/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.event.shared.testing;

import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.HandlerRegistration;
import com.google.web.bindery.event.shared.SimpleEventBus;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountingEventBus
extends EventBus {
    private final Map<Event.Type<?>, Integer> counts = new HashMap();
    private final EventBus wrapped;

    public CountingEventBus() {
        this(new SimpleEventBus());
    }

    public CountingEventBus(EventBus wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public <H> HandlerRegistration addHandler(Event.Type<H> type, H handler) {
        this.increment(type);
        HandlerRegistration superReg = this.wrapped.addHandler(type, handler);
        return this.makeReg(type, superReg);
    }

    @Override
    public <H> HandlerRegistration addHandlerToSource(Event.Type<H> type, Object source, H handler) {
        this.increment(type);
        HandlerRegistration superReg = this.wrapped.addHandlerToSource(type, source, handler);
        return this.makeReg(type, superReg);
    }

    @Override
    public void fireEvent(Event<?> event) {
        this.wrapped.fireEvent(event);
    }

    @Override
    public void fireEventFromSource(Event<?> event, Object source) {
        this.wrapped.fireEventFromSource(event, source);
    }

    public int getCount(Event.Type<?> type) {
        Integer count = this.counts.get(type);
        return count == null ? 0 : count;
    }

    private void decrement(Event.Type<?> type) {
        this.counts.put(type, this.getCount(type) - 1);
    }

    private <H> void increment(Event.Type<H> type) {
        this.counts.put(type, this.getCount(type) + 1);
    }

    private <H> HandlerRegistration makeReg(final Event.Type<H> type, final HandlerRegistration superReg) {
        return new HandlerRegistration(){

            public void removeHandler() {
                CountingEventBus.this.decrement(type);
                superReg.removeHandler();
            }
        };
    }
}

