%%
%% This is file `limap.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% limap.dtx  (with options: `class')
%% 
%% IMPORTANT NOTICE:
%% 
%% For the copyright see the source file.
%% 
%% Any modified versions of this file must be renamed
%% with new filenames distinct from limap.cls.
%% 
%% For distribution of the original source see the terms
%% for copying and modification in the file limap.dtx.
%% 
%% This generated file may be distributed as long as the
%% original source files, as listed above, are part of the
%% same distribution. (The sources need not necessarily be
%% in the same archive or directory.)
%%^^A%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%^^A $Id: limap.dtx 1.2 2000/03/01 20:11:42 gene Exp gene $
%%^^A%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Purpose:
%%      A package for typesetting Information Maps.
%%
%% Documentation:
%%      The documentation  can be generated  from  the  original  file
%%      limap.dtx with the doc style/package. LaTeX the file limap.tex
%%      to get the full documentation in \textsc{dvi} format.
%%
%% Author: Gerd Neugebauer
%%         Mainzer Str. 8
%%         56321 Rhens (Germany)
%% Mail:   gerd.neugebauer@sdm.de
%%    gerd.neugebauer@gmx.de
%%
%% Copyright (C) 1999-2000 Gerd Neugebauer
%%
%% limap.dtx may be  distributed under the terms of  the LaTeX Project
%% Public  License,  as  described  in  lppl.txt  in  the  base  LaTeX
%% distribution.   Either version 1.0  or, at  your option,  any later
%% version.
%%
%% This class is still under development and  may be replaced with a
%% new version which provides an enhanced functionality.
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
%%
\def\LIMAP@RCS$#1: #2 #3${#2}
\def\filename{limap.dtx}
\xdef\fileversion{\LIMAP@RCS$Revision: 1.2 $}
\xdef\filedate{\LIMAP@RCS$Date: 2000/03/01 20:11:42 $}
\let\docversion=\fileversion
\let\docdate=\filedate
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{limap}[\filedate\space  gene]
\providecommand\LIMAP@Language{english}
\DeclareOption{austrian}{\renewcommand\LIMAP@Language{austrian}}
\DeclareOption{german}{\renewcommand\LIMAP@Language{german}}
\DeclareOption{french}{\renewcommand\LIMAP@Language{french}}
\DeclareOption{english}{\renewcommand\LIMAP@Language{english}}
\DeclareOption{USenglish}{\renewcommand\LIMAP@Language{USenglish}}
\newif\ifLIMAP@strict \LIMAP@stricttrue
\DeclareOption{nonstrict}{\LIMAP@strictfalse}
\providecommand\LIMAP@ClassType{report}
\DeclareOption{book}{\renewcommand\LIMAP@ClassType{book}}
\DeclareOption{report}{\renewcommand\LIMAP@ClassType{report}}
\DeclareOption{article}{\renewcommand\LIMAP@ClassType{article}}
\DeclareOption{letter}{\renewcommand\LIMAP@ClassType{letter}}
\providecommand\LIMAP@Variant{base}
\DeclareOption{koma}{\renewcommand\LIMAP@Variant{koma}}
\DeclareOption{base}{\renewcommand\LIMAP@Variant{base}}
\newcommand\LIMAP@Class@base@article{article}
\newcommand\LIMAP@Class@base@report{report}
\newcommand\LIMAP@Class@base@book{book}
\newcommand\LIMAP@Class@base@letter{letter}
\newcommand\LIMAP@Class@koma@article{scrartcl}
\newcommand\LIMAP@Class@koma@report{scrreprt}
\newcommand\LIMAP@Class@koma@book{scrbook}
\newcommand\LIMAP@Class@koma@letter{scrlettr}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{%
    \csname LIMAP@Class@\LIMAP@Variant @\LIMAP@ClassType\endcsname}%
  }
\ProcessOptions
\LoadClass{\csname LIMAP@Class@\LIMAP@Variant @\LIMAP@ClassType\endcsname}
\RequirePackage{longtable}
\RequirePackage{booktabs}
\RequirePackage{fancyhdr}
\addtolength{\headheight}{2ex}%
\pagestyle{fancy}%
\cfoot{}
\rhead{\small\thepage}
\lhead{\textit{\footnotesize\@title}}
\def\@title{}
\raggedbottom
\newcommand\MapRuleWidth{.25pt}
\newcommand\MapContinued{}
\newcommand\MapContinuing{}
\newcommand\MapContinuingFormat[1]{\textit{\footnotesize #1}}
\newcommand\MapContinuedFormat[1]{, {\MapTitleContinuedSize #1}}
\let\MapFont\textsf
\let\MapTitleSize\Large
\let\MapTitleContinuedSize\small
\newcommand\MapParskip{2ex}
\newcommand\MapTitlefraction{.2}
\newcommand\MapTextfraction{.75}
\let\MapNewpage\newpage
\newcommand\MapTOC[1]{%
  \refstepcounter{\@nameuse{Map@TOC@name\the\Map@level}}%
  \addcontentsline{toc}{\@nameuse{Map@TOC@name\the\Map@level}}{#1}%
}
\newcommand\MapTOCname{}
\newcommand\MapTOCpage{}
\let\MapTOCemph=\emph
\providecommand\LIMAP@SelectLanguage@austrian{%
  \renewcommand\MapContinued{ Fortsetzung}%
  \renewcommand\MapContinuing{Fortsetzung\dots}
  \renewcommand\MapTOCname{Titel}
  \renewcommand\MapTOCpage{Seite}
}
\providecommand\LIMAP@SelectLanguage@german{%
  \renewcommand\MapContinued{ Fortsetzung}%
  \renewcommand\MapContinuing{Fortsetzung\dots}
  \renewcommand\MapTOCname{Titel}
  \renewcommand\MapTOCpage{Seite}
}
\providecommand\LIMAP@SelectLanguage@english{%
  \renewcommand\MapContinued{ Continued}%
  \renewcommand\MapContinuing{Continuing\dots}
  \renewcommand\MapTOCname{Title}
  \renewcommand\MapTOCpage{Page}
}
\providecommand\LIMAP@SelectLanguage@USenglish{%
  \renewcommand\MapContinued{ Continued}%
  \renewcommand\MapContinuing{Continuing\dots}
  \renewcommand\MapTOCname{Title}
  \renewcommand\MapTOCpage{Page}
}
\newlength{\Map@length}
\newcount\Map@level
\Map@level=0
\newcount\Map@blockcount
\newif\ifMap@open@
\Map@open@false
\@namedef{Map@TOC@name0}{chapter}
\@namedef{Map@TOC@name1}{section}
\@namedef{Map@TOC@name2}{subsection}
\@namedef{Map@TOC@name3}{subsubsection}
\@namedef{Map@TOC@name4}{paragraph}
\@namedef{Map@TOC@name5}{subparagraph}
\@namedef{Map@TOC@name6}{subsubparagraph}
\@namedef{Map@TOC@name7}{subsubparagraph}
\@namedef{Map@TOC@name8}{subsubparagraph}
\@namedef{Map@TOC@name9}{subsubparagraph}
\@namedef{Map@TOC@name10}{subsubparagraph}
\@namedef{Map@TOC@name11}{subsubparagraph}
\@namedef{Map@TOC@name12}{subsubparagraph}
\newcommand\Map@start{%
  \setlength{\Map@length}{\textwidth}%
  \addtolength{\Map@length}{-\MapTitlefraction\textwidth}%
  \addtolength{\Map@length}{-\MapTextfraction\textwidth}%
  \MapTOC{\Map@TITLE}%
  \longtable
    {@{}p{\MapTitlefraction\textwidth}@{\hspace{\Map@length}}
        p{\MapTextfraction\textwidth}@{}}%
      \multicolumn{2}{@{}p{\textwidth}@{}}{%
        \MapFont{\MapTitleSize\rule{0pt}{3ex}%
          \Map@TITLE}}
    \endfirsthead
      \multicolumn{2}{@{}p{\textwidth}@{}}{%
        \MapFont{\MapTitleSize\rule{0pt}{3ex}%
          \Map@TITLE\MapContinuedFormat{\MapContinued}}}%
    \endhead
      \par\vspace*{-\parskip}\vspace*{-2ex}\\
      &\rule{\MapTextfraction\textwidth}{\MapRuleWidth}\newline
      \mbox{}\hfill\raisebox{3pt}{\MapContinuingFormat{\MapContinuing}}
    \endfoot
      &\rule{\MapTextfraction\textwidth}{\MapRuleWidth}%
       \vspace{\MapParskip}
    \endlastfoot
    \xdef\@currentlabel{\Map@TITLE}%
    \global\Map@open@true
}
\newcommand\Map@end{%
  \ifMap@open@
    \global\Map@open@false
    \endlongtable
    \MapNewpage
  \fi
  \iftrue
   \ifnum\Map@blockcount>9
    \PackageWarning{limap}%
    {*** The current map contains too much blocks: \the\Map@blockcount}%
   \else\ifnum\Map@blockcount>7
    \PackageWarning{limap}%
    {--- The current map contains \the\Map@blockcount blocks.}%
   \fi\fi
  \fi
}
\newcommand\Map@UP{}
\newcount\Map@no
\@namedef{Map@parts@}{}
\newenvironment{Map}[1]{%
  \def\LT@err{\PackageError{limap}}%
  \def\LT@warn{\PackageWarning{limap}}%
  \let\Block\Map@Block
  \let\endBlock\Map@endBlock
  \Map@blockcount=0
  \global\advance\Map@no1
  \ifx\Map@UP\empty\else
    \immediate\write\@auxout
      {\string\expandafter\string\xdef\string\csname\space
        Map@parts@\Map@UP\string\endcsname{\string\csname\space
          Map@parts@\Map@UP\string\endcsname\the\Map@no:}}%
  \fi
  \edef\Map@UP{\the\Map@no}%
  \ifnum\Map@level>0
    \xdef\Map@@up{\Map@UP}% Just to save the value across blocks.
    \endgroup
    \Map@end
    \begingroup
    \edef\Map@UP{\Map@@up}%
    \def\@currenvir{Map}%
  \fi
  \edef\Map@this{\the\Map@no}%
  \immediate\write\@auxout
    {\string\global\string\@namedef{Map@title@\the\Map@no}{#1}}%
  \immediate\write\@auxout
    {\string\global\string\@namedef{Map@page@\the\Map@no}{\the\c@page}}%
  \immediate\write\@auxout
    {\string\global\string\@namedef{Map@parts@\the\Map@no}{}}%
  \global\advance\Map@level1
  \def\Map@TITLE{#1}%
  \Map@start
  }{%
  \Map@end
  \global\advance\Map@level-1
}
\newenvironment{Map@Block}[1]{\par\vspace*{-\parskip}\vspace*{-2ex}%
  \\\null\par
  \vspace*{\MapParskip}%
  \raggedright\hspace{0pt}\MapFont{#1}%
  \gdef\@currentlabel{#1}%
  &\parskip=\MapParskip
  \rule{\MapTextfraction\textwidth}{\MapRuleWidth}\par
}{%
}
\newcommand\Wide@Block{\\\multicolumn2{@{}l@{}}}{}
\newcommand\MapTableOfContents{%
  \medskip\par
  \xdef\Map@@{\csname Map@parts@\the\Map@no\endcsname}%
  \gdef\Map@@@{}%
  \centering
  \begin{tabular}{p{.6\textwidth}r}\toprule
    \MapTOCemph{\MapTOCname}&\MapTOCemph{\MapTOCpage}\\
    \midrule
    \expandafter\Map@toc@loop \Map@@:%
    \\\bottomrule
  \end{tabular}
}
\def\Map@toc@loop#1:{%
  \def\Map@@{#1}%
  \ifx\Map@@\empty
    \global\let\Map@@=\relax
  \else
    \gdef\Map@@{\Map@@@\@nameuse{Map@title@#1}&\@nameuse{Map@page@#1}%
      \global\let\Map@@@=\\%
      \Map@toc@loop}%
  \fi
  \Map@@
}
\newcommand\MakeTitle{\thispagestyle{empty}
  \rule{0pt}{.25\textheight}\par
  \mbox{}\hfill
  \begin{minipage}{\MapTextfraction\textwidth}
    \raggedright
    \rule{\textwidth}{1pt}\par
    \vspace*{5ex}%
    \sf{\huge \@title\par}%
    \vspace*{5ex}%
    \rule{\textwidth}{1pt}\par
    \vspace*{5ex}%
    \MapFont{\large \@author} \par
    \vspace*{10ex}%
    \MapFont{\footnotesize \@date}
    \vspace*{10ex}%
  \end{minipage}%
  \par
}
\let\maketitle\MakeTitle
\InputIfFileExists{limap.cfg}{}{}
\csname LIMAP@SelectLanguage@\LIMAP@Language\endcsname
\ifLIMAP@strict
  \def\subsection{\PackageWarning{limap}{The sectioning command
      `subsection' is not available.}}
  \def\subsubsection{\PackageWarning{limap}{The sectioning command
      `subsubsection' is not available.}}
  \def\paragraph{\PackageWarning{limap}{The sectioning command
      `paragraph' is not available.}}
  \def\subparagraph{\PackageWarning{limap}{The sectioning command
      `subparagraph' is not available.}}
  \def\subsubparagraph{\PackageWarning{limap}{The sectioning command
      `subsubparagraph' is not available.}}
\fi
\endinput
%%
%% End of file `limap.cls'.
