/*
 * Copyright 2023 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _nbio_7_11_0_SH_MASK_HEADER
#define _nbio_7_11_0_SH_MASK_HEADER


// addressBlock: nbio_iohub_nb_nbcfg_nb_cfgdec
//NB_VENDOR_ID
#define NB_VENDOR_ID__VENDOR_ID__SHIFT                                                                        0x0
#define NB_VENDOR_ID__VENDOR_ID_MASK                                                                          0xFFFFL
//NB_DEVICE_ID
#define NB_DEVICE_ID__DEVICE_ID__SHIFT                                                                        0x0
#define NB_DEVICE_ID__DEVICE_ID_MASK                                                                          0xFFFFL
//NB_COMMAND
#define NB_COMMAND__IO_ACCESS_EN__SHIFT                                                                       0x0
#define NB_COMMAND__MEM_ACCESS_EN__SHIFT                                                                      0x1
#define NB_COMMAND__BUS_MASTER_EN__SHIFT                                                                      0x2
#define NB_COMMAND__IO_ACCESS_EN_MASK                                                                         0x0001L
#define NB_COMMAND__MEM_ACCESS_EN_MASK                                                                        0x0002L
#define NB_COMMAND__BUS_MASTER_EN_MASK                                                                        0x0004L
//NB_STATUS
#define NB_STATUS__CAP_LIST__SHIFT                                                                            0x4
#define NB_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                               0xc
#define NB_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                               0xd
#define NB_STATUS__CAP_LIST_MASK                                                                              0x0010L
#define NB_STATUS__RECEIVED_TARGET_ABORT_MASK                                                                 0x1000L
#define NB_STATUS__RECEIVED_MASTER_ABORT_MASK                                                                 0x2000L
//NB_SUB_CLASS
#define NB_SUB_CLASS__SUB_CLASS_INF__SHIFT                                                                    0x0
#define NB_SUB_CLASS__SUB_CLASS_INF_MASK                                                                      0xFFL
//NB_BASE_CODE
#define NB_BASE_CODE__BASE_CLASS_CODE__SHIFT                                                                  0x0
#define NB_BASE_CODE__BASE_CLASS_CODE_MASK                                                                    0xFFL
//NB_CACHE_LINE
#define NB_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                                 0x0
#define NB_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                                   0xFFL
//NB_LATENCY
#define NB_LATENCY__LATENCY_TIMER__SHIFT                                                                      0x0
#define NB_LATENCY__LATENCY_TIMER_MASK                                                                        0xFFL
//NB_HEADER
#define NB_HEADER__HEADER_TYPE__SHIFT                                                                         0x0
#define NB_HEADER__DEVICE_TYPE__SHIFT                                                                         0x7
#define NB_HEADER__HEADER_TYPE_MASK                                                                           0x7FL
#define NB_HEADER__DEVICE_TYPE_MASK                                                                           0x80L
//NB_ADAPTER_ID
#define NB_ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                                             0x0
#define NB_ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                                    0x10
#define NB_ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                                               0x0000FFFFL
#define NB_ADAPTER_ID__SUBSYSTEM_ID_MASK                                                                      0xFFFF0000L
//NB_CAPABILITIES_PTR
#define NB_CAPABILITIES_PTR__CAP_PTR__SHIFT                                                                   0x0
#define NB_CAPABILITIES_PTR__CAP_PTR_MASK                                                                     0x000000FFL
//NB_HEADER_W
#define NB_HEADER_W__DEVICE_TYPE__SHIFT                                                                       0x7
#define NB_HEADER_W__DEVICE_TYPE_MASK                                                                         0x00000080L
//NB_PCI_CTRL
#define NB_PCI_CTRL__PMEDis__SHIFT                                                                            0x4
#define NB_PCI_CTRL__SErrDis__SHIFT                                                                           0x5
#define NB_PCI_CTRL__MMIOEnable__SHIFT                                                                        0x17
#define NB_PCI_CTRL__HPDis__SHIFT                                                                             0x1a
#define NB_PCI_CTRL__PMEDis_MASK                                                                              0x00000010L
#define NB_PCI_CTRL__SErrDis_MASK                                                                             0x00000020L
#define NB_PCI_CTRL__MMIOEnable_MASK                                                                          0x00800000L
#define NB_PCI_CTRL__HPDis_MASK                                                                               0x04000000L
//NB_ADAPTER_ID_W
#define NB_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT                                                           0x0
#define NB_ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT                                                                  0x10
#define NB_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK                                                             0x0000FFFFL
#define NB_ADAPTER_ID_W__SUBSYSTEM_ID_MASK                                                                    0xFFFF0000L
//NBCFG_SCRATCH_0
#define NBCFG_SCRATCH_0__NBCFG_SCRATCH_0__SHIFT                                                               0x0
#define NBCFG_SCRATCH_0__NBCFG_SCRATCH_0_MASK                                                                 0xFFFFFFFFL
//NBCFG_SCRATCH_1
#define NBCFG_SCRATCH_1__NBCFG_SCRATCH_1__SHIFT                                                               0x0
#define NBCFG_SCRATCH_1__NBCFG_SCRATCH_1_MASK                                                                 0xFFFFFFFFL
//NBCFG_SCRATCH_2
#define NBCFG_SCRATCH_2__NBCFG_SCRATCH_2__SHIFT                                                               0x0
#define NBCFG_SCRATCH_2__NBCFG_SCRATCH_2_MASK                                                                 0xFFFFFFFFL
//NBCFG_SCRATCH_3
#define NBCFG_SCRATCH_3__NBCFG_SCRATCH_3__SHIFT                                                               0x0
#define NBCFG_SCRATCH_3__NBCFG_SCRATCH_3_MASK                                                                 0xFFFFFFFFL
//NBCFG_SCRATCH_4
#define NBCFG_SCRATCH_4__NBCFG_SCRATCH_4__SHIFT                                                               0x0
#define NBCFG_SCRATCH_4__NBCFG_SCRATCH_4_MASK                                                                 0xFFFFFFFFL
//NB_PCI_ARB
#define NB_PCI_ARB__VGA_HOLE__SHIFT                                                                           0x3
#define NB_PCI_ARB__PMEMode__SHIFT                                                                            0x8
#define NB_PCI_ARB__PMETurnOff__SHIFT                                                                         0x9
#define NB_PCI_ARB__PMETOAckStatus__SHIFT                                                                     0xa
#define NB_PCI_ARB__PMETarget__SHIFT                                                                          0x10
#define NB_PCI_ARB__VGA_HOLE_MASK                                                                             0x00000008L
#define NB_PCI_ARB__PMEMode_MASK                                                                              0x00000100L
#define NB_PCI_ARB__PMETurnOff_MASK                                                                           0x00000200L
#define NB_PCI_ARB__PMETOAckStatus_MASK                                                                       0x00000400L
#define NB_PCI_ARB__PMETarget_MASK                                                                            0x00FF0000L
//NB_DRAM_SLOT1_BASE
#define NB_DRAM_SLOT1_BASE__DRAM_BASE__SHIFT                                                                  0x17
#define NB_DRAM_SLOT1_BASE__DRAM_BASE_MASK                                                                    0xFF800000L
//NB_INDEX_DATA_MUTEX0
#define NB_INDEX_DATA_MUTEX0__NB_INDEX_DATA_MUTEX0__SHIFT                                                     0x0
#define NB_INDEX_DATA_MUTEX0__NB_INDEX_DATA_MUTEX0_UNLOCK__SHIFT                                              0x1f
#define NB_INDEX_DATA_MUTEX0__NB_INDEX_DATA_MUTEX0_MASK                                                       0x7FFFFFFFL
#define NB_INDEX_DATA_MUTEX0__NB_INDEX_DATA_MUTEX0_UNLOCK_MASK                                                0x80000000L
//NB_INDEX_DATA_MUTEX1
#define NB_INDEX_DATA_MUTEX1__NB_INDEX_DATA_MUTEX1__SHIFT                                                     0x0
#define NB_INDEX_DATA_MUTEX1__NB_INDEX_DATA_MUTEX1_UNLOCK__SHIFT                                              0x1f
#define NB_INDEX_DATA_MUTEX1__NB_INDEX_DATA_MUTEX1_MASK                                                       0x7FFFFFFFL
#define NB_INDEX_DATA_MUTEX1__NB_INDEX_DATA_MUTEX1_UNLOCK_MASK                                                0x80000000L
//NB_VENDOR_ID_W
#define NB_VENDOR_ID_W__VENDOR_ID__SHIFT                                                                      0x0
#define NB_VENDOR_ID_W__VENDOR_ID_MASK                                                                        0xFFFFL
//NB_DEVICE_ID_W
#define NB_DEVICE_ID_W__DEVICE_ID__SHIFT                                                                      0x0
#define NB_DEVICE_ID_W__DEVICE_ID_MASK                                                                        0xFFFFL


// addressBlock: nbio_nbif0_bif_cfg_dev0_rc_bifcfgdecp
//BIF_CFG_DEV0_RC_VENDOR_ID
#define BIF_CFG_DEV0_RC_VENDOR_ID__VENDOR_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV0_RC_VENDOR_ID__VENDOR_ID_MASK                                                             0xFFFFL
//BIF_CFG_DEV0_RC_DEVICE_ID
#define BIF_CFG_DEV0_RC_DEVICE_ID__DEVICE_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV0_RC_DEVICE_ID__DEVICE_ID_MASK                                                             0xFFFFL
//BIF_CFG_DEV0_RC_COMMAND
#define BIF_CFG_DEV0_RC_COMMAND__IOEN_DN__SHIFT                                                               0x0
#define BIF_CFG_DEV0_RC_COMMAND__MEMEN_DN__SHIFT                                                              0x1
#define BIF_CFG_DEV0_RC_COMMAND__BUS_MASTER_EN__SHIFT                                                         0x2
#define BIF_CFG_DEV0_RC_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                      0x3
#define BIF_CFG_DEV0_RC_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                               0x4
#define BIF_CFG_DEV0_RC_COMMAND__PAL_SNOOP_EN__SHIFT                                                          0x5
#define BIF_CFG_DEV0_RC_COMMAND__AD_STEPPING__SHIFT                                                           0x7
#define BIF_CFG_DEV0_RC_COMMAND__SERR_EN__SHIFT                                                               0x8
#define BIF_CFG_DEV0_RC_COMMAND__FAST_B2B_EN__SHIFT                                                           0x9
#define BIF_CFG_DEV0_RC_COMMAND__INT_DIS__SHIFT                                                               0xa
#define BIF_CFG_DEV0_RC_COMMAND__IOEN_DN_MASK                                                                 0x0001L
#define BIF_CFG_DEV0_RC_COMMAND__MEMEN_DN_MASK                                                                0x0002L
#define BIF_CFG_DEV0_RC_COMMAND__BUS_MASTER_EN_MASK                                                           0x0004L
#define BIF_CFG_DEV0_RC_COMMAND__SPECIAL_CYCLE_EN_MASK                                                        0x0008L
#define BIF_CFG_DEV0_RC_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                                 0x0010L
#define BIF_CFG_DEV0_RC_COMMAND__PAL_SNOOP_EN_MASK                                                            0x0020L
#define BIF_CFG_DEV0_RC_COMMAND__AD_STEPPING_MASK                                                             0x0080L
#define BIF_CFG_DEV0_RC_COMMAND__SERR_EN_MASK                                                                 0x0100L
#define BIF_CFG_DEV0_RC_COMMAND__FAST_B2B_EN_MASK                                                             0x0200L
#define BIF_CFG_DEV0_RC_COMMAND__INT_DIS_MASK                                                                 0x0400L
//BIF_CFG_DEV0_RC_STATUS
#define BIF_CFG_DEV0_RC_STATUS__IMMEDIATE_READINESS__SHIFT                                                    0x0
#define BIF_CFG_DEV0_RC_STATUS__INT_STATUS__SHIFT                                                             0x3
#define BIF_CFG_DEV0_RC_STATUS__CAP_LIST__SHIFT                                                               0x4
#define BIF_CFG_DEV0_RC_STATUS__PCI_66_CAP__SHIFT                                                             0x5
#define BIF_CFG_DEV0_RC_STATUS__FAST_BACK_CAPABLE__SHIFT                                                      0x7
#define BIF_CFG_DEV0_RC_STATUS__DEVSEL_TIMING__SHIFT                                                          0x9
#define BIF_CFG_DEV0_RC_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                    0xb
#define BIF_CFG_DEV0_RC_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                  0xc
#define BIF_CFG_DEV0_RC_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                  0xd
#define BIF_CFG_DEV0_RC_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                                  0xe
#define BIF_CFG_DEV0_RC_STATUS__IMMEDIATE_READINESS_MASK                                                      0x0001L
#define BIF_CFG_DEV0_RC_STATUS__INT_STATUS_MASK                                                               0x0008L
#define BIF_CFG_DEV0_RC_STATUS__CAP_LIST_MASK                                                                 0x0010L
#define BIF_CFG_DEV0_RC_STATUS__PCI_66_CAP_MASK                                                               0x0020L
#define BIF_CFG_DEV0_RC_STATUS__FAST_BACK_CAPABLE_MASK                                                        0x0080L
#define BIF_CFG_DEV0_RC_STATUS__DEVSEL_TIMING_MASK                                                            0x0600L
#define BIF_CFG_DEV0_RC_STATUS__SIGNAL_TARGET_ABORT_MASK                                                      0x0800L
#define BIF_CFG_DEV0_RC_STATUS__RECEIVED_TARGET_ABORT_MASK                                                    0x1000L
#define BIF_CFG_DEV0_RC_STATUS__RECEIVED_MASTER_ABORT_MASK                                                    0x2000L
#define BIF_CFG_DEV0_RC_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                    0x4000L
//BIF_CFG_DEV0_RC_REVISION_ID
#define BIF_CFG_DEV0_RC_REVISION_ID__MINOR_REV_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_RC_REVISION_ID__MAJOR_REV_ID__SHIFT                                                      0x4
#define BIF_CFG_DEV0_RC_REVISION_ID__MINOR_REV_ID_MASK                                                        0x0FL
#define BIF_CFG_DEV0_RC_REVISION_ID__MAJOR_REV_ID_MASK                                                        0xF0L
//BIF_CFG_DEV0_RC_PROG_INTERFACE
#define BIF_CFG_DEV0_RC_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC_PROG_INTERFACE__PROG_INTERFACE_MASK                                                   0xFFL
//BIF_CFG_DEV0_RC_SUB_CLASS
#define BIF_CFG_DEV0_RC_SUB_CLASS__SUB_CLASS__SHIFT                                                           0x0
#define BIF_CFG_DEV0_RC_SUB_CLASS__SUB_CLASS_MASK                                                             0xFFL
//BIF_CFG_DEV0_RC_BASE_CLASS
#define BIF_CFG_DEV0_RC_BASE_CLASS__BASE_CLASS__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC_BASE_CLASS__BASE_CLASS_MASK                                                           0xFFL
//BIF_CFG_DEV0_RC_CACHE_LINE
#define BIF_CFG_DEV0_RC_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                    0x0
#define BIF_CFG_DEV0_RC_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                      0xFFL
//BIF_CFG_DEV0_RC_LATENCY
#define BIF_CFG_DEV0_RC_LATENCY__LATENCY_TIMER__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC_LATENCY__LATENCY_TIMER_MASK                                                           0xFFL
//BIF_CFG_DEV0_RC_HEADER
#define BIF_CFG_DEV0_RC_HEADER__HEADER_TYPE__SHIFT                                                            0x0
#define BIF_CFG_DEV0_RC_HEADER__DEVICE_TYPE__SHIFT                                                            0x7
#define BIF_CFG_DEV0_RC_HEADER__HEADER_TYPE_MASK                                                              0x7FL
#define BIF_CFG_DEV0_RC_HEADER__DEVICE_TYPE_MASK                                                              0x80L
//BIF_CFG_DEV0_RC_BIST
#define BIF_CFG_DEV0_RC_BIST__BIST_COMP__SHIFT                                                                0x0
#define BIF_CFG_DEV0_RC_BIST__BIST_STRT__SHIFT                                                                0x6
#define BIF_CFG_DEV0_RC_BIST__BIST_CAP__SHIFT                                                                 0x7
#define BIF_CFG_DEV0_RC_BIST__BIST_COMP_MASK                                                                  0x0FL
#define BIF_CFG_DEV0_RC_BIST__BIST_STRT_MASK                                                                  0x40L
#define BIF_CFG_DEV0_RC_BIST__BIST_CAP_MASK                                                                   0x80L
//BIF_CFG_DEV0_RC_BASE_ADDR_1
#define BIF_CFG_DEV0_RC_BASE_ADDR_1__BASE_ADDR__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC_BASE_ADDR_1__BASE_ADDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV0_RC_BASE_ADDR_2
#define BIF_CFG_DEV0_RC_BASE_ADDR_2__BASE_ADDR__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC_BASE_ADDR_2__BASE_ADDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV0_RC_SUB_BUS_NUMBER_LATENCY
#define BIF_CFG_DEV0_RC_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS__SHIFT                                          0x8
#define BIF_CFG_DEV0_RC_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM__SHIFT                                            0x10
#define BIF_CFG_DEV0_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER__SHIFT                                0x18
#define BIF_CFG_DEV0_RC_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS_MASK                                              0x000000FFL
#define BIF_CFG_DEV0_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS_MASK                                            0x0000FF00L
#define BIF_CFG_DEV0_RC_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM_MASK                                              0x00FF0000L
#define BIF_CFG_DEV0_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER_MASK                                  0xFF000000L
//BIF_CFG_DEV0_RC_IO_BASE_LIMIT
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT__IO_BASE_TYPE__SHIFT                                                    0x0
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT__IO_BASE__SHIFT                                                         0x4
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT__IO_LIMIT_TYPE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT__IO_LIMIT__SHIFT                                                        0xc
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT__IO_BASE_TYPE_MASK                                                      0x000FL
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT__IO_BASE_MASK                                                           0x00F0L
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT__IO_LIMIT_TYPE_MASK                                                     0x0F00L
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT__IO_LIMIT_MASK                                                          0xF000L
//BIF_CFG_DEV0_RC_SECONDARY_STATUS
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__PCI_66_CAP__SHIFT                                                   0x5
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__FAST_BACK_CAPABLE__SHIFT                                            0x7
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__DEVSEL_TIMING__SHIFT                                                0x9
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                          0xb
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                        0xc
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                        0xd
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR__SHIFT                                        0xe
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__PCI_66_CAP_MASK                                                     0x0020L
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__FAST_BACK_CAPABLE_MASK                                              0x0080L
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__DEVSEL_TIMING_MASK                                                  0x0600L
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__SIGNAL_TARGET_ABORT_MASK                                            0x0800L
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__RECEIVED_TARGET_ABORT_MASK                                          0x1000L
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__RECEIVED_MASTER_ABORT_MASK                                          0x2000L
#define BIF_CFG_DEV0_RC_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR_MASK                                          0x4000L
//BIF_CFG_DEV0_RC_MEM_BASE_LIMIT
#define BIF_CFG_DEV0_RC_MEM_BASE_LIMIT__MEM_BASE_TYPE__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC_MEM_BASE_LIMIT__MEM_BASE_31_20__SHIFT                                                 0x4
#define BIF_CFG_DEV0_RC_MEM_BASE_LIMIT__MEM_LIMIT_TYPE__SHIFT                                                 0x10
#define BIF_CFG_DEV0_RC_MEM_BASE_LIMIT__MEM_LIMIT_31_20__SHIFT                                                0x14
#define BIF_CFG_DEV0_RC_MEM_BASE_LIMIT__MEM_BASE_TYPE_MASK                                                    0x0000000FL
#define BIF_CFG_DEV0_RC_MEM_BASE_LIMIT__MEM_BASE_31_20_MASK                                                   0x0000FFF0L
#define BIF_CFG_DEV0_RC_MEM_BASE_LIMIT__MEM_LIMIT_TYPE_MASK                                                   0x000F0000L
#define BIF_CFG_DEV0_RC_MEM_BASE_LIMIT__MEM_LIMIT_31_20_MASK                                                  0xFFF00000L
//BIF_CFG_DEV0_RC_PREF_BASE_LIMIT
#define BIF_CFG_DEV0_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20__SHIFT                                           0x4
#define BIF_CFG_DEV0_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE__SHIFT                                           0x10
#define BIF_CFG_DEV0_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20__SHIFT                                          0x14
#define BIF_CFG_DEV0_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE_MASK                                              0x0000000FL
#define BIF_CFG_DEV0_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20_MASK                                             0x0000FFF0L
#define BIF_CFG_DEV0_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE_MASK                                             0x000F0000L
#define BIF_CFG_DEV0_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20_MASK                                            0xFFF00000L
//BIF_CFG_DEV0_RC_PREF_BASE_UPPER
#define BIF_CFG_DEV0_RC_PREF_BASE_UPPER__PREF_BASE_UPPER__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC_PREF_BASE_UPPER__PREF_BASE_UPPER_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PREF_LIMIT_UPPER
#define BIF_CFG_DEV0_RC_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER__SHIFT                                             0x0
#define BIF_CFG_DEV0_RC_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_RC_IO_BASE_LIMIT_HI
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT_HI__IO_BASE_31_16__SHIFT                                                0x0
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT_HI__IO_LIMIT_31_16__SHIFT                                               0x10
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT_HI__IO_BASE_31_16_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_RC_IO_BASE_LIMIT_HI__IO_LIMIT_31_16_MASK                                                 0xFFFF0000L
//BIF_CFG_DEV0_RC_CAP_PTR
#define BIF_CFG_DEV0_RC_CAP_PTR__CAP_PTR__SHIFT                                                               0x0
#define BIF_CFG_DEV0_RC_CAP_PTR__CAP_PTR_MASK                                                                 0xFFL
//BIF_CFG_DEV0_RC_ROM_BASE_ADDR
#define BIF_CFG_DEV0_RC_ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_RC_ROM_BASE_ADDR__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_RC_INTERRUPT_LINE
#define BIF_CFG_DEV0_RC_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                                   0xFFL
//BIF_CFG_DEV0_RC_INTERRUPT_PIN
#define BIF_CFG_DEV0_RC_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                                   0x0
#define BIF_CFG_DEV0_RC_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                     0xFFL
//BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__SERR_EN__SHIFT                                                       0x1
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__ISA_EN__SHIFT                                                        0x2
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__VGA_EN__SHIFT                                                        0x3
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__VGA_DEC__SHIFT                                                       0x4
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE__SHIFT                                             0x5
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET__SHIFT                                           0x6
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__FAST_B2B_EN__SHIFT                                                   0x7
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__PRIMARY_DISCARD_TIMER__SHIFT                                         0x8
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__SECONDARY_DISCARD_TIMER__SHIFT                                       0x9
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_STATUS__SHIFT                                          0xa
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_SERR_ENABLE__SHIFT                                     0xb
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN_MASK                                              0x0001L
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__SERR_EN_MASK                                                         0x0002L
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__ISA_EN_MASK                                                          0x0004L
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__VGA_EN_MASK                                                          0x0008L
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__VGA_DEC_MASK                                                         0x0010L
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE_MASK                                               0x0020L
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET_MASK                                             0x0040L
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__FAST_B2B_EN_MASK                                                     0x0080L
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__PRIMARY_DISCARD_TIMER_MASK                                           0x0100L
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__SECONDARY_DISCARD_TIMER_MASK                                         0x0200L
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_STATUS_MASK                                            0x0400L
#define BIF_CFG_DEV0_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_SERR_ENABLE_MASK                                       0x0800L
//BIF_CFG_DEV0_RC_EXT_BRIDGE_CNTL
#define BIF_CFG_DEV0_RC_EXT_BRIDGE_CNTL__IO_PORT_80_EN__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC_EXT_BRIDGE_CNTL__IO_PORT_80_EN_MASK                                                   0x01L
//BIF_CFG_DEV0_RC_PMI_CAP_LIST
#define BIF_CFG_DEV0_RC_PMI_CAP_LIST__CAP_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV0_RC_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                         0x8
#define BIF_CFG_DEV0_RC_PMI_CAP_LIST__CAP_ID_MASK                                                             0x00FFL
#define BIF_CFG_DEV0_RC_PMI_CAP_LIST__NEXT_PTR_MASK                                                           0xFF00L
//BIF_CFG_DEV0_RC_PMI_CAP
#define BIF_CFG_DEV0_RC_PMI_CAP__VERSION__SHIFT                                                               0x0
#define BIF_CFG_DEV0_RC_PMI_CAP__PME_CLOCK__SHIFT                                                             0x3
#define BIF_CFG_DEV0_RC_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0__SHIFT                                   0x4
#define BIF_CFG_DEV0_RC_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                     0x5
#define BIF_CFG_DEV0_RC_PMI_CAP__AUX_CURRENT__SHIFT                                                           0x6
#define BIF_CFG_DEV0_RC_PMI_CAP__D1_SUPPORT__SHIFT                                                            0x9
#define BIF_CFG_DEV0_RC_PMI_CAP__D2_SUPPORT__SHIFT                                                            0xa
#define BIF_CFG_DEV0_RC_PMI_CAP__PME_SUPPORT__SHIFT                                                           0xb
#define BIF_CFG_DEV0_RC_PMI_CAP__VERSION_MASK                                                                 0x0007L
#define BIF_CFG_DEV0_RC_PMI_CAP__PME_CLOCK_MASK                                                               0x0008L
#define BIF_CFG_DEV0_RC_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0_MASK                                     0x0010L
#define BIF_CFG_DEV0_RC_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                       0x0020L
#define BIF_CFG_DEV0_RC_PMI_CAP__AUX_CURRENT_MASK                                                             0x01C0L
#define BIF_CFG_DEV0_RC_PMI_CAP__D1_SUPPORT_MASK                                                              0x0200L
#define BIF_CFG_DEV0_RC_PMI_CAP__D2_SUPPORT_MASK                                                              0x0400L
#define BIF_CFG_DEV0_RC_PMI_CAP__PME_SUPPORT_MASK                                                             0xF800L
//BIF_CFG_DEV0_RC_PMI_STATUS_CNTL
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                                   0x0
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                                 0x3
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__PME_EN__SHIFT                                                        0x8
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                                   0x9
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                    0xd
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                    0xf
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                                 0x16
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                    0x17
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                      0x18
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__POWER_STATE_MASK                                                     0x00000003L
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                                   0x00000008L
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__PME_EN_MASK                                                          0x00000100L
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                     0x00001E00L
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                      0x00006000L
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__PME_STATUS_MASK                                                      0x00008000L
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                                   0x00400000L
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                      0x00800000L
#define BIF_CFG_DEV0_RC_PMI_STATUS_CNTL__PMI_DATA_MASK                                                        0xFF000000L
//BIF_CFG_DEV0_RC_PCIE_CAP_LIST
#define BIF_CFG_DEV0_RC_PCIE_CAP_LIST__CAP_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                        0x8
#define BIF_CFG_DEV0_RC_PCIE_CAP_LIST__CAP_ID_MASK                                                            0x00FFL
#define BIF_CFG_DEV0_RC_PCIE_CAP_LIST__NEXT_PTR_MASK                                                          0xFF00L
//BIF_CFG_DEV0_RC_PCIE_CAP
#define BIF_CFG_DEV0_RC_PCIE_CAP__VERSION__SHIFT                                                              0x0
#define BIF_CFG_DEV0_RC_PCIE_CAP__DEVICE_TYPE__SHIFT                                                          0x4
#define BIF_CFG_DEV0_RC_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                     0x8
#define BIF_CFG_DEV0_RC_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                      0x9
#define BIF_CFG_DEV0_RC_PCIE_CAP__VERSION_MASK                                                                0x000FL
#define BIF_CFG_DEV0_RC_PCIE_CAP__DEVICE_TYPE_MASK                                                            0x00F0L
#define BIF_CFG_DEV0_RC_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                       0x0100L
#define BIF_CFG_DEV0_RC_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                        0x3E00L
//BIF_CFG_DEV0_RC_DEVICE_CAP
#define BIF_CFG_DEV0_RC_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                                0x0
#define BIF_CFG_DEV0_RC_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                       0x3
#define BIF_CFG_DEV0_RC_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                       0x5
#define BIF_CFG_DEV0_RC_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                             0x6
#define BIF_CFG_DEV0_RC_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                              0x9
#define BIF_CFG_DEV0_RC_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                           0xf
#define BIF_CFG_DEV0_RC_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                        0x1c
#define BIF_CFG_DEV0_RC_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                                  0x00000007L
#define BIF_CFG_DEV0_RC_DEVICE_CAP__PHANTOM_FUNC_MASK                                                         0x00000018L
#define BIF_CFG_DEV0_RC_DEVICE_CAP__EXTENDED_TAG_MASK                                                         0x00000020L
#define BIF_CFG_DEV0_RC_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                               0x000001C0L
#define BIF_CFG_DEV0_RC_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                                0x00000E00L
#define BIF_CFG_DEV0_RC_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                             0x00008000L
#define BIF_CFG_DEV0_RC_DEVICE_CAP__FLR_CAPABLE_MASK                                                          0x10000000L
//BIF_CFG_DEV0_RC_DEVICE_CNTL
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                       0x0
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                                  0x1
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                      0x2
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                     0x3
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                    0x4
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                                  0x5
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                                   0x8
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                                   0x9
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                                   0xa
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                       0xb
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                             0xc
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN__SHIFT                                               0xf
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__CORR_ERR_EN_MASK                                                         0x0001L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                    0x0002L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                        0x0004L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__USR_REPORT_EN_MASK                                                       0x0008L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                      0x0010L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                    0x00E0L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                     0x0100L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                     0x0200L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                     0x0400L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                         0x0800L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                               0x7000L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN_MASK                                                 0x8000L
//BIF_CFG_DEV0_RC_DEVICE_STATUS
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__CORR_ERR__SHIFT                                                        0x0
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                                   0x1
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__FATAL_ERR__SHIFT                                                       0x2
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__USR_DETECTED__SHIFT                                                    0x3
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__AUX_PWR__SHIFT                                                         0x4
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                               0x5
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED__SHIFT                                   0x6
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__CORR_ERR_MASK                                                          0x0001L
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                     0x0002L
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__FATAL_ERR_MASK                                                         0x0004L
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__USR_DETECTED_MASK                                                      0x0008L
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__AUX_PWR_MASK                                                           0x0010L
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                                 0x0020L
#define BIF_CFG_DEV0_RC_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED_MASK                                     0x0040L
//BIF_CFG_DEV0_RC_LINK_CAP
#define BIF_CFG_DEV0_RC_LINK_CAP__LINK_SPEED__SHIFT                                                           0x0
#define BIF_CFG_DEV0_RC_LINK_CAP__LINK_WIDTH__SHIFT                                                           0x4
#define BIF_CFG_DEV0_RC_LINK_CAP__PM_SUPPORT__SHIFT                                                           0xa
#define BIF_CFG_DEV0_RC_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                     0xc
#define BIF_CFG_DEV0_RC_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                      0xf
#define BIF_CFG_DEV0_RC_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                               0x12
#define BIF_CFG_DEV0_RC_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                          0x13
#define BIF_CFG_DEV0_RC_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                          0x14
#define BIF_CFG_DEV0_RC_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                             0x15
#define BIF_CFG_DEV0_RC_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                          0x16
#define BIF_CFG_DEV0_RC_LINK_CAP__PORT_NUMBER__SHIFT                                                          0x18
#define BIF_CFG_DEV0_RC_LINK_CAP__LINK_SPEED_MASK                                                             0x0000000FL
#define BIF_CFG_DEV0_RC_LINK_CAP__LINK_WIDTH_MASK                                                             0x000003F0L
#define BIF_CFG_DEV0_RC_LINK_CAP__PM_SUPPORT_MASK                                                             0x00000C00L
#define BIF_CFG_DEV0_RC_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                       0x00007000L
#define BIF_CFG_DEV0_RC_LINK_CAP__L1_EXIT_LATENCY_MASK                                                        0x00038000L
#define BIF_CFG_DEV0_RC_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                                 0x00040000L
#define BIF_CFG_DEV0_RC_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                            0x00080000L
#define BIF_CFG_DEV0_RC_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                            0x00100000L
#define BIF_CFG_DEV0_RC_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                               0x00200000L
#define BIF_CFG_DEV0_RC_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                            0x00400000L
#define BIF_CFG_DEV0_RC_LINK_CAP__PORT_NUMBER_MASK                                                            0xFF000000L
//BIF_CFG_DEV0_RC_LINK_CNTL
#define BIF_CFG_DEV0_RC_LINK_CNTL__PM_CONTROL__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B__SHIFT                                        0x2
#define BIF_CFG_DEV0_RC_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                                   0x3
#define BIF_CFG_DEV0_RC_LINK_CNTL__LINK_DIS__SHIFT                                                            0x4
#define BIF_CFG_DEV0_RC_LINK_CNTL__RETRAIN_LINK__SHIFT                                                        0x5
#define BIF_CFG_DEV0_RC_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                    0x6
#define BIF_CFG_DEV0_RC_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                       0x7
#define BIF_CFG_DEV0_RC_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                           0x8
#define BIF_CFG_DEV0_RC_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                         0x9
#define BIF_CFG_DEV0_RC_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                           0xa
#define BIF_CFG_DEV0_RC_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                           0xb
#define BIF_CFG_DEV0_RC_LINK_CNTL__DRS_SIGNALING_CONTROL__SHIFT                                               0xe
#define BIF_CFG_DEV0_RC_LINK_CNTL__PM_CONTROL_MASK                                                            0x0003L
#define BIF_CFG_DEV0_RC_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B_MASK                                          0x0004L
#define BIF_CFG_DEV0_RC_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                     0x0008L
#define BIF_CFG_DEV0_RC_LINK_CNTL__LINK_DIS_MASK                                                              0x0010L
#define BIF_CFG_DEV0_RC_LINK_CNTL__RETRAIN_LINK_MASK                                                          0x0020L
#define BIF_CFG_DEV0_RC_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                      0x0040L
#define BIF_CFG_DEV0_RC_LINK_CNTL__EXTENDED_SYNC_MASK                                                         0x0080L
#define BIF_CFG_DEV0_RC_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                             0x0100L
#define BIF_CFG_DEV0_RC_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                           0x0200L
#define BIF_CFG_DEV0_RC_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                             0x0400L
#define BIF_CFG_DEV0_RC_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                             0x0800L
#define BIF_CFG_DEV0_RC_LINK_CNTL__DRS_SIGNALING_CONTROL_MASK                                                 0xC000L
//BIF_CFG_DEV0_RC_LINK_STATUS
#define BIF_CFG_DEV0_RC_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                                0x0
#define BIF_CFG_DEV0_RC_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                             0x4
#define BIF_CFG_DEV0_RC_LINK_STATUS__LINK_TRAINING__SHIFT                                                     0xb
#define BIF_CFG_DEV0_RC_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                    0xc
#define BIF_CFG_DEV0_RC_LINK_STATUS__DL_ACTIVE__SHIFT                                                         0xd
#define BIF_CFG_DEV0_RC_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                         0xe
#define BIF_CFG_DEV0_RC_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                         0xf
#define BIF_CFG_DEV0_RC_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                                  0x000FL
#define BIF_CFG_DEV0_RC_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                               0x03F0L
#define BIF_CFG_DEV0_RC_LINK_STATUS__LINK_TRAINING_MASK                                                       0x0800L
#define BIF_CFG_DEV0_RC_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                      0x1000L
#define BIF_CFG_DEV0_RC_LINK_STATUS__DL_ACTIVE_MASK                                                           0x2000L
#define BIF_CFG_DEV0_RC_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                           0x4000L
#define BIF_CFG_DEV0_RC_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                           0x8000L
//BIF_CFG_DEV0_RC_SLOT_CAP
#define BIF_CFG_DEV0_RC_SLOT_CAP__ATTN_BUTTON_PRESENT__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC_SLOT_CAP__PWR_CONTROLLER_PRESENT__SHIFT                                               0x1
#define BIF_CFG_DEV0_RC_SLOT_CAP__MRL_SENSOR_PRESENT__SHIFT                                                   0x2
#define BIF_CFG_DEV0_RC_SLOT_CAP__ATTN_INDICATOR_PRESENT__SHIFT                                               0x3
#define BIF_CFG_DEV0_RC_SLOT_CAP__PWR_INDICATOR_PRESENT__SHIFT                                                0x4
#define BIF_CFG_DEV0_RC_SLOT_CAP__HOTPLUG_SURPRISE__SHIFT                                                     0x5
#define BIF_CFG_DEV0_RC_SLOT_CAP__HOTPLUG_CAPABLE__SHIFT                                                      0x6
#define BIF_CFG_DEV0_RC_SLOT_CAP__SLOT_PWR_LIMIT_VALUE__SHIFT                                                 0x7
#define BIF_CFG_DEV0_RC_SLOT_CAP__SLOT_PWR_LIMIT_SCALE__SHIFT                                                 0xf
#define BIF_CFG_DEV0_RC_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT__SHIFT                                        0x11
#define BIF_CFG_DEV0_RC_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED__SHIFT                                       0x12
#define BIF_CFG_DEV0_RC_SLOT_CAP__PHYSICAL_SLOT_NUM__SHIFT                                                    0x13
#define BIF_CFG_DEV0_RC_SLOT_CAP__ATTN_BUTTON_PRESENT_MASK                                                    0x00000001L
#define BIF_CFG_DEV0_RC_SLOT_CAP__PWR_CONTROLLER_PRESENT_MASK                                                 0x00000002L
#define BIF_CFG_DEV0_RC_SLOT_CAP__MRL_SENSOR_PRESENT_MASK                                                     0x00000004L
#define BIF_CFG_DEV0_RC_SLOT_CAP__ATTN_INDICATOR_PRESENT_MASK                                                 0x00000008L
#define BIF_CFG_DEV0_RC_SLOT_CAP__PWR_INDICATOR_PRESENT_MASK                                                  0x00000010L
#define BIF_CFG_DEV0_RC_SLOT_CAP__HOTPLUG_SURPRISE_MASK                                                       0x00000020L
#define BIF_CFG_DEV0_RC_SLOT_CAP__HOTPLUG_CAPABLE_MASK                                                        0x00000040L
#define BIF_CFG_DEV0_RC_SLOT_CAP__SLOT_PWR_LIMIT_VALUE_MASK                                                   0x00007F80L
#define BIF_CFG_DEV0_RC_SLOT_CAP__SLOT_PWR_LIMIT_SCALE_MASK                                                   0x00018000L
#define BIF_CFG_DEV0_RC_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT_MASK                                          0x00020000L
#define BIF_CFG_DEV0_RC_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED_MASK                                         0x00040000L
#define BIF_CFG_DEV0_RC_SLOT_CAP__PHYSICAL_SLOT_NUM_MASK                                                      0xFFF80000L
//BIF_CFG_DEV0_RC_SLOT_CNTL
#define BIF_CFG_DEV0_RC_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC_SLOT_CNTL__PWR_FAULT_DETECTED_EN__SHIFT                                               0x1
#define BIF_CFG_DEV0_RC_SLOT_CNTL__MRL_SENSOR_CHANGED_EN__SHIFT                                               0x2
#define BIF_CFG_DEV0_RC_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN__SHIFT                                          0x3
#define BIF_CFG_DEV0_RC_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN__SHIFT                                           0x4
#define BIF_CFG_DEV0_RC_SLOT_CNTL__HOTPLUG_INTR_EN__SHIFT                                                     0x5
#define BIF_CFG_DEV0_RC_SLOT_CNTL__ATTN_INDICATOR_CNTL__SHIFT                                                 0x6
#define BIF_CFG_DEV0_RC_SLOT_CNTL__PWR_INDICATOR_CNTL__SHIFT                                                  0x8
#define BIF_CFG_DEV0_RC_SLOT_CNTL__PWR_CONTROLLER_CNTL__SHIFT                                                 0xa
#define BIF_CFG_DEV0_RC_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL__SHIFT                                          0xb
#define BIF_CFG_DEV0_RC_SLOT_CNTL__DL_STATE_CHANGED_EN__SHIFT                                                 0xc
#define BIF_CFG_DEV0_RC_SLOT_CNTL__AUTO_SLOT_PWR_LIMIT_DISABLE__SHIFT                                         0xd
#define BIF_CFG_DEV0_RC_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN_MASK                                                0x0001L
#define BIF_CFG_DEV0_RC_SLOT_CNTL__PWR_FAULT_DETECTED_EN_MASK                                                 0x0002L
#define BIF_CFG_DEV0_RC_SLOT_CNTL__MRL_SENSOR_CHANGED_EN_MASK                                                 0x0004L
#define BIF_CFG_DEV0_RC_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN_MASK                                            0x0008L
#define BIF_CFG_DEV0_RC_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN_MASK                                             0x0010L
#define BIF_CFG_DEV0_RC_SLOT_CNTL__HOTPLUG_INTR_EN_MASK                                                       0x0020L
#define BIF_CFG_DEV0_RC_SLOT_CNTL__ATTN_INDICATOR_CNTL_MASK                                                   0x00C0L
#define BIF_CFG_DEV0_RC_SLOT_CNTL__PWR_INDICATOR_CNTL_MASK                                                    0x0300L
#define BIF_CFG_DEV0_RC_SLOT_CNTL__PWR_CONTROLLER_CNTL_MASK                                                   0x0400L
#define BIF_CFG_DEV0_RC_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL_MASK                                            0x0800L
#define BIF_CFG_DEV0_RC_SLOT_CNTL__DL_STATE_CHANGED_EN_MASK                                                   0x1000L
#define BIF_CFG_DEV0_RC_SLOT_CNTL__AUTO_SLOT_PWR_LIMIT_DISABLE_MASK                                           0x2000L
//BIF_CFG_DEV0_RC_SLOT_STATUS
#define BIF_CFG_DEV0_RC_SLOT_STATUS__ATTN_BUTTON_PRESSED__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC_SLOT_STATUS__PWR_FAULT_DETECTED__SHIFT                                                0x1
#define BIF_CFG_DEV0_RC_SLOT_STATUS__MRL_SENSOR_CHANGED__SHIFT                                                0x2
#define BIF_CFG_DEV0_RC_SLOT_STATUS__PRESENCE_DETECT_CHANGED__SHIFT                                           0x3
#define BIF_CFG_DEV0_RC_SLOT_STATUS__COMMAND_COMPLETED__SHIFT                                                 0x4
#define BIF_CFG_DEV0_RC_SLOT_STATUS__MRL_SENSOR_STATE__SHIFT                                                  0x5
#define BIF_CFG_DEV0_RC_SLOT_STATUS__PRESENCE_DETECT_STATE__SHIFT                                             0x6
#define BIF_CFG_DEV0_RC_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS__SHIFT                                      0x7
#define BIF_CFG_DEV0_RC_SLOT_STATUS__DL_STATE_CHANGED__SHIFT                                                  0x8
#define BIF_CFG_DEV0_RC_SLOT_STATUS__ATTN_BUTTON_PRESSED_MASK                                                 0x0001L
#define BIF_CFG_DEV0_RC_SLOT_STATUS__PWR_FAULT_DETECTED_MASK                                                  0x0002L
#define BIF_CFG_DEV0_RC_SLOT_STATUS__MRL_SENSOR_CHANGED_MASK                                                  0x0004L
#define BIF_CFG_DEV0_RC_SLOT_STATUS__PRESENCE_DETECT_CHANGED_MASK                                             0x0008L
#define BIF_CFG_DEV0_RC_SLOT_STATUS__COMMAND_COMPLETED_MASK                                                   0x0010L
#define BIF_CFG_DEV0_RC_SLOT_STATUS__MRL_SENSOR_STATE_MASK                                                    0x0020L
#define BIF_CFG_DEV0_RC_SLOT_STATUS__PRESENCE_DETECT_STATE_MASK                                               0x0040L
#define BIF_CFG_DEV0_RC_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS_MASK                                        0x0080L
#define BIF_CFG_DEV0_RC_SLOT_STATUS__DL_STATE_CHANGED_MASK                                                    0x0100L
//BIF_CFG_DEV0_RC_ROOT_CNTL
#define BIF_CFG_DEV0_RC_ROOT_CNTL__SERR_ON_CORR_ERR_EN__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN__SHIFT                                             0x1
#define BIF_CFG_DEV0_RC_ROOT_CNTL__SERR_ON_FATAL_ERR_EN__SHIFT                                                0x2
#define BIF_CFG_DEV0_RC_ROOT_CNTL__PM_INTERRUPT_EN__SHIFT                                                     0x3
#define BIF_CFG_DEV0_RC_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN__SHIFT                                          0x4
#define BIF_CFG_DEV0_RC_ROOT_CNTL__SERR_ON_CORR_ERR_EN_MASK                                                   0x0001L
#define BIF_CFG_DEV0_RC_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN_MASK                                               0x0002L
#define BIF_CFG_DEV0_RC_ROOT_CNTL__SERR_ON_FATAL_ERR_EN_MASK                                                  0x0004L
#define BIF_CFG_DEV0_RC_ROOT_CNTL__PM_INTERRUPT_EN_MASK                                                       0x0008L
#define BIF_CFG_DEV0_RC_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN_MASK                                            0x0010L
//BIF_CFG_DEV0_RC_ROOT_CAP
#define BIF_CFG_DEV0_RC_ROOT_CAP__CRS_SOFTWARE_VISIBILITY__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC_ROOT_CAP__CRS_SOFTWARE_VISIBILITY_MASK                                                0x0001L
//BIF_CFG_DEV0_RC_ROOT_STATUS
#define BIF_CFG_DEV0_RC_ROOT_STATUS__PME_REQUESTOR_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC_ROOT_STATUS__PME_STATUS__SHIFT                                                        0x10
#define BIF_CFG_DEV0_RC_ROOT_STATUS__PME_PENDING__SHIFT                                                       0x11
#define BIF_CFG_DEV0_RC_ROOT_STATUS__PME_REQUESTOR_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV0_RC_ROOT_STATUS__PME_STATUS_MASK                                                          0x00010000L
#define BIF_CFG_DEV0_RC_ROOT_STATUS__PME_PENDING_MASK                                                         0x00020000L
//BIF_CFG_DEV0_RC_DEVICE_CAP2
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                       0x0
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                         0x4
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                          0x5
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                        0x6
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                        0x7
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                        0x8
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                            0x9
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                         0xa
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                     0xb
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                                0xc
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__LN_SYSTEM_CLS__SHIFT                                                     0xe
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED__SHIFT                                   0x10
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED__SHIFT                                   0x11
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                    0x12
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                      0x14
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                      0x15
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                          0x16
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED__SHIFT                                    0x18
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ__SHIFT                                     0x1a
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__FRS_SUPPORTED__SHIFT                                                     0x1f
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                         0x0000000FL
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                           0x00000010L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                            0x00000020L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                          0x00000040L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                          0x00000080L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                          0x00000100L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                              0x00000200L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                           0x00000400L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                       0x00000800L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                                  0x00003000L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__LN_SYSTEM_CLS_MASK                                                       0x0000C000L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED_MASK                                     0x00010000L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED_MASK                                     0x00020000L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                      0x000C0000L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                        0x00100000L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                        0x00200000L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                            0x00C00000L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED_MASK                                      0x03000000L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ_MASK                                       0x04000000L
#define BIF_CFG_DEV0_RC_DEVICE_CAP2__FRS_SUPPORTED_MASK                                                       0x80000000L
//BIF_CFG_DEV0_RC_DEVICE_CNTL2
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                                0x0
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                                  0x4
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                                0x5
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                              0x6
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                         0x7
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                               0x8
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                            0x9
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__LTR_EN__SHIFT                                                           0xa
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST__SHIFT                                     0xb
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE__SHIFT                                     0xc
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__OBFF_EN__SHIFT                                                          0xd
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                      0xf
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                                  0x000FL
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                    0x0010L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                                  0x0020L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                                0x0040L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                           0x0080L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                                 0x0100L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                              0x0200L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__LTR_EN_MASK                                                             0x0400L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST_MASK                                       0x0800L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE_MASK                                       0x1000L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__OBFF_EN_MASK                                                            0x6000L
#define BIF_CFG_DEV0_RC_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                        0x8000L
//BIF_CFG_DEV0_RC_DEVICE_STATUS2
#define BIF_CFG_DEV0_RC_DEVICE_STATUS2__RESERVED__SHIFT                                                       0x0
#define BIF_CFG_DEV0_RC_DEVICE_STATUS2__RESERVED_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_RC_LINK_CAP2
#define BIF_CFG_DEV0_RC_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                                0x1
#define BIF_CFG_DEV0_RC_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                                 0x8
#define BIF_CFG_DEV0_RC_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT__SHIFT                                            0x9
#define BIF_CFG_DEV0_RC_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT__SHIFT                                            0x10
#define BIF_CFG_DEV0_RC_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT__SHIFT                                           0x17
#define BIF_CFG_DEV0_RC_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT__SHIFT                                           0x18
#define BIF_CFG_DEV0_RC_LINK_CAP2__DRS_SUPPORTED__SHIFT                                                       0x1f
#define BIF_CFG_DEV0_RC_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                                  0x000000FEL
#define BIF_CFG_DEV0_RC_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                                   0x00000100L
#define BIF_CFG_DEV0_RC_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT_MASK                                              0x0000FE00L
#define BIF_CFG_DEV0_RC_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT_MASK                                              0x007F0000L
#define BIF_CFG_DEV0_RC_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT_MASK                                             0x00800000L
#define BIF_CFG_DEV0_RC_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT_MASK                                             0x01000000L
#define BIF_CFG_DEV0_RC_LINK_CAP2__DRS_SUPPORTED_MASK                                                         0x80000000L
//BIF_CFG_DEV0_RC_LINK_CNTL2
#define BIF_CFG_DEV0_RC_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                                   0x4
#define BIF_CFG_DEV0_RC_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                        0x5
#define BIF_CFG_DEV0_RC_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                              0x6
#define BIF_CFG_DEV0_RC_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                        0x7
#define BIF_CFG_DEV0_RC_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                               0xa
#define BIF_CFG_DEV0_RC_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                     0xb
#define BIF_CFG_DEV0_RC_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                              0xc
#define BIF_CFG_DEV0_RC_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                    0x000FL
#define BIF_CFG_DEV0_RC_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                     0x0010L
#define BIF_CFG_DEV0_RC_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                          0x0020L
#define BIF_CFG_DEV0_RC_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                                0x0040L
#define BIF_CFG_DEV0_RC_LINK_CNTL2__XMIT_MARGIN_MASK                                                          0x0380L
#define BIF_CFG_DEV0_RC_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                                 0x0400L
#define BIF_CFG_DEV0_RC_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                       0x0800L
#define BIF_CFG_DEV0_RC_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                                0xF000L
//BIF_CFG_DEV0_RC_LINK_STATUS2
#define BIF_CFG_DEV0_RC_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                             0x0
#define BIF_CFG_DEV0_RC_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT__SHIFT                                        0x1
#define BIF_CFG_DEV0_RC_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT__SHIFT                                  0x2
#define BIF_CFG_DEV0_RC_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT__SHIFT                                  0x3
#define BIF_CFG_DEV0_RC_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT__SHIFT                                  0x4
#define BIF_CFG_DEV0_RC_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT__SHIFT                                    0x5
#define BIF_CFG_DEV0_RC_LINK_STATUS2__RTM1_PRESENCE_DET__SHIFT                                                0x6
#define BIF_CFG_DEV0_RC_LINK_STATUS2__RTM2_PRESENCE_DET__SHIFT                                                0x7
#define BIF_CFG_DEV0_RC_LINK_STATUS2__CROSSLINK_RESOLUTION__SHIFT                                             0x8
#define BIF_CFG_DEV0_RC_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE__SHIFT                                    0xc
#define BIF_CFG_DEV0_RC_LINK_STATUS2__DRS_MESSAGE_RECEIVED__SHIFT                                             0xf
#define BIF_CFG_DEV0_RC_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                               0x0001L
#define BIF_CFG_DEV0_RC_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT_MASK                                          0x0002L
#define BIF_CFG_DEV0_RC_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT_MASK                                    0x0004L
#define BIF_CFG_DEV0_RC_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT_MASK                                    0x0008L
#define BIF_CFG_DEV0_RC_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT_MASK                                    0x0010L
#define BIF_CFG_DEV0_RC_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT_MASK                                      0x0020L
#define BIF_CFG_DEV0_RC_LINK_STATUS2__RTM1_PRESENCE_DET_MASK                                                  0x0040L
#define BIF_CFG_DEV0_RC_LINK_STATUS2__RTM2_PRESENCE_DET_MASK                                                  0x0080L
#define BIF_CFG_DEV0_RC_LINK_STATUS2__CROSSLINK_RESOLUTION_MASK                                               0x0300L
#define BIF_CFG_DEV0_RC_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE_MASK                                      0x7000L
#define BIF_CFG_DEV0_RC_LINK_STATUS2__DRS_MESSAGE_RECEIVED_MASK                                               0x8000L
//BIF_CFG_DEV0_RC_SLOT_CAP2
#define BIF_CFG_DEV0_RC_SLOT_CAP2__RESERVED__SHIFT                                                            0x0
#define BIF_CFG_DEV0_RC_SLOT_CAP2__RESERVED_MASK                                                              0xFFFFFFFFL
//BIF_CFG_DEV0_RC_SLOT_CNTL2
#define BIF_CFG_DEV0_RC_SLOT_CNTL2__RESERVED__SHIFT                                                           0x0
#define BIF_CFG_DEV0_RC_SLOT_CNTL2__RESERVED_MASK                                                             0xFFFFL
//BIF_CFG_DEV0_RC_SLOT_STATUS2
#define BIF_CFG_DEV0_RC_SLOT_STATUS2__RESERVED__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC_SLOT_STATUS2__RESERVED_MASK                                                           0xFFFFL
//BIF_CFG_DEV0_RC_MSI_CAP_LIST
#define BIF_CFG_DEV0_RC_MSI_CAP_LIST__CAP_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV0_RC_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                         0x8
#define BIF_CFG_DEV0_RC_MSI_CAP_LIST__CAP_ID_MASK                                                             0x00FFL
#define BIF_CFG_DEV0_RC_MSI_CAP_LIST__NEXT_PTR_MASK                                                           0xFF00L
//BIF_CFG_DEV0_RC_MSI_MSG_CNTL
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_EN__SHIFT                                                           0x0
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                    0x1
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                     0x4
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                        0x7
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                        0x8
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP__SHIFT                                             0x9
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN__SHIFT                                              0xa
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_EN_MASK                                                             0x0001L
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                      0x000EL
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                       0x0070L
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_64BIT_MASK                                                          0x0080L
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                          0x0100L
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP_MASK                                               0x0200L
#define BIF_CFG_DEV0_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN_MASK                                                0x0400L
//BIF_CFG_DEV0_RC_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV0_RC_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                               0x2
#define BIF_CFG_DEV0_RC_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                                 0xFFFFFFFCL
//BIF_CFG_DEV0_RC_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV0_RC_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_RC_MSI_MSG_DATA
#define BIF_CFG_DEV0_RC_MSI_MSG_DATA__MSI_DATA__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC_MSI_MSG_DATA__MSI_DATA_MASK                                                           0xFFFFL
//BIF_CFG_DEV0_RC_MSI_EXT_MSG_DATA
#define BIF_CFG_DEV0_RC_MSI_EXT_MSG_DATA__MSI_EXT_DATA__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC_MSI_EXT_MSG_DATA__MSI_EXT_DATA_MASK                                                   0xFFFFL
//BIF_CFG_DEV0_RC_MSI_MSG_DATA_64
#define BIF_CFG_DEV0_RC_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                                   0x0
#define BIF_CFG_DEV0_RC_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                     0xFFFFL
//BIF_CFG_DEV0_RC_MSI_EXT_MSG_DATA_64
#define BIF_CFG_DEV0_RC_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64_MASK                                             0xFFFFL
//BIF_CFG_DEV0_RC_SSID_CAP_LIST
#define BIF_CFG_DEV0_RC_SSID_CAP_LIST__CAP_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC_SSID_CAP_LIST__NEXT_PTR__SHIFT                                                        0x8
#define BIF_CFG_DEV0_RC_SSID_CAP_LIST__CAP_ID_MASK                                                            0x00FFL
#define BIF_CFG_DEV0_RC_SSID_CAP_LIST__NEXT_PTR_MASK                                                          0xFF00L
//BIF_CFG_DEV0_RC_SSID_CAP
#define BIF_CFG_DEV0_RC_SSID_CAP__SUBSYSTEM_VENDOR_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC_SSID_CAP__SUBSYSTEM_ID__SHIFT                                                         0x10
#define BIF_CFG_DEV0_RC_SSID_CAP__SUBSYSTEM_VENDOR_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV0_RC_SSID_CAP__SUBSYSTEM_ID_MASK                                                           0xFFFF0000L
//BIF_CFG_DEV0_RC_MSI_MAP_CAP_LIST
#define BIF_CFG_DEV0_RC_MSI_MAP_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_RC_MSI_MAP_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV0_RC_MSI_MAP_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV0_RC_MSI_MAP_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV0_RC_MSI_MAP_CAP
#define BIF_CFG_DEV0_RC_MSI_MAP_CAP__EN__SHIFT                                                                0x0
#define BIF_CFG_DEV0_RC_MSI_MAP_CAP__FIXD__SHIFT                                                              0x1
#define BIF_CFG_DEV0_RC_MSI_MAP_CAP__CAP_TYPE__SHIFT                                                          0xb
#define BIF_CFG_DEV0_RC_MSI_MAP_CAP__EN_MASK                                                                  0x0001L
#define BIF_CFG_DEV0_RC_MSI_MAP_CAP__FIXD_MASK                                                                0x0002L
#define BIF_CFG_DEV0_RC_MSI_MAP_CAP__CAP_TYPE_MASK                                                            0xF800L
//BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                      0x0
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                     0x10
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                    0x14
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                        0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                       0x000F0000L
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                      0xFFF00000L
//BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                             0x10
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                          0x14
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                            0xFFF00000L
//BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                                   0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                                   0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_VC_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT                                                   0x0
#define BIF_CFG_DEV0_RC_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT                                                  0x10
#define BIF_CFG_DEV0_RC_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                 0x14
#define BIF_CFG_DEV0_RC_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK                                                     0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK                                                    0x000F0000L
#define BIF_CFG_DEV0_RC_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK                                                   0xFFF00000L
//BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG1
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT                               0x4
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT                                                 0x8
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT                               0xa
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK                                              0x00000007L
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK                                 0x00000070L
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK                                                   0x00000300L
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK                                 0x00000C00L
//BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG2
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT                                     0x18
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK                                                0x000000FFL
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK                                       0xFF000000L
//BIF_CFG_DEV0_RC_PCIE_PORT_VC_CNTL
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT                                               0x1
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK                                             0x0001L
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK                                                 0x000EL
//BIF_CFG_DEV0_RC_PCIE_PORT_VC_STATUS
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT                                       0x0
#define BIF_CFG_DEV0_RC_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK                                         0x0001L
//BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CAP
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                      0xf
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                          0x10
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                   0x18
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK                                              0x000000FFL
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                        0x00008000L
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                            0x007F0000L
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                     0xFF000000L
//BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                          0x0
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                        0x1
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                    0x10
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                        0x11
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT                                                  0x18
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT                                              0x1f
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                            0x00000001L
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                          0x000000FEL
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                      0x00010000L
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                          0x000E0000L
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK                                                    0x07000000L
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK                                                0x80000000L
//BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_STATUS
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                                0x0
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                               0x1
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                  0x0001L
#define BIF_CFG_DEV0_RC_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                 0x0002L
//BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CAP
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                      0xf
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                          0x10
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                   0x18
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK                                              0x000000FFL
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                        0x00008000L
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                            0x003F0000L
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                     0xFF000000L
//BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                          0x0
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                        0x1
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                    0x10
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                        0x11
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT                                                  0x18
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT                                              0x1f
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                            0x00000001L
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                          0x000000FEL
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                      0x00010000L
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                          0x000E0000L
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK                                                    0x07000000L
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK                                                0x80000000L
//BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_STATUS
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                                0x0
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                               0x1
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                  0x0001L
#define BIF_CFG_DEV0_RC_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                 0x0002L
//BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT                                       0x0
#define BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT                                      0x10
#define BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT                                     0x14
#define BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK                                         0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK                                        0x000F0000L
#define BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK                                       0xFFF00000L
//BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_DW1
#define BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT                                      0x0
#define BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_DW2
#define BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT                                      0x0
#define BIF_CFG_DEV0_RC_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                         0x10
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                        0x14
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                           0x000F0000L
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                          0xFFF00000L
//BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                         0x4
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                      0x5
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                         0xc
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                          0xd
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                     0xe
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                                   0xf
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                       0x10
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                        0x11
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                         0x12
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                        0x13
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                                  0x14
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                                   0x15
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                                  0x16
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                                  0x17
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                         0x18
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                          0x19
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS__SHIFT                     0x1a
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                           0x00000010L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                        0x00000020L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                           0x00001000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                            0x00002000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                       0x00004000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                     0x00008000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                         0x00010000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                          0x00020000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                           0x00040000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                          0x00080000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                    0x00100000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                     0x00200000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                    0x00400000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                    0x00800000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                           0x01000000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                            0x02000000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS_MASK                       0x04000000L
//BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                             0x4
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                          0x5
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                             0xc
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                              0xd
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                         0xe
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                           0x10
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                            0x11
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                             0x12
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                            0x13
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                      0x14
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                       0x15
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                      0x16
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                      0x17
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                             0x18
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                              0x19
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__POISONED_TLP_EGRESS_BLOCKED_MASK__SHIFT                         0x1a
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                               0x00000010L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                            0x00000020L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                               0x00001000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                                0x00002000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                           0x00004000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                         0x00008000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                             0x00010000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                              0x00020000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                               0x00040000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                              0x00080000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                        0x00100000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                         0x00200000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                        0x00400000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                        0x00800000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                               0x01000000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                                0x02000000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_MASK__POISONED_TLP_EGRESS_BLOCKED_MASK_MASK                           0x04000000L
//BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                     0x4
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                                  0x5
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                     0xc
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                      0xd
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                                 0xe
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                               0xf
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                                   0x10
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                    0x11
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                     0x12
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                    0x13
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                              0x14
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                               0x15
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                              0x16
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                              0x17
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                     0x18
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                      0x19
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__POISONED_TLP_EGRESS_BLOCKED_SEVERITY__SHIFT                 0x1a
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                       0x00000010L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                    0x00000020L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                       0x00001000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                        0x00002000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                                   0x00004000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                                 0x00008000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                     0x00010000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                      0x00020000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                       0x00040000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                      0x00080000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                                0x00100000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                                 0x00200000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                                0x00400000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                                0x00800000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                       0x01000000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                        0x02000000L
#define BIF_CFG_DEV0_RC_PCIE_UNCORR_ERR_SEVERITY__POISONED_TLP_EGRESS_BLOCKED_SEVERITY_MASK                   0x04000000L
//BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                           0x6
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                          0x7
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                               0x8
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                              0xc
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                             0xd
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                      0xe
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                             0x00000001L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                             0x00000040L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                            0x00000080L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                                 0x00000100L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                                0x00001000L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                               0x00002000L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                        0x00004000L
//BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                               0x6
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                              0x7
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                                   0x8
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                                  0xc
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                                 0xd
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                          0xe
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                                 0x00000001L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                                 0x00000040L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                                0x00000080L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                     0x00000100L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                    0x00001000L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                                   0x00002000L
#define BIF_CFG_DEV0_RC_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                            0x00004000L
//BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                            0x5
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                             0x6
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                          0x7
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                           0x8
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                      0x9
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                       0xa
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                             0x0000001FL
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                              0x00000020L
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                               0x00000040L
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                            0x00000080L
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                             0x00000100L
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                        0x00000200L
#define BIF_CFG_DEV0_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                         0x00000400L
//BIF_CFG_DEV0_RC_PCIE_HDR_LOG0
#define BIF_CFG_DEV0_RC_PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC_PCIE_HDR_LOG0__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_HDR_LOG1
#define BIF_CFG_DEV0_RC_PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC_PCIE_HDR_LOG1__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_HDR_LOG2
#define BIF_CFG_DEV0_RC_PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC_PCIE_HDR_LOG2__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_HDR_LOG3
#define BIF_CFG_DEV0_RC_PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC_PCIE_HDR_LOG3__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_CMD
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN__SHIFT                                             0x0
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN__SHIFT                                         0x1
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN__SHIFT                                            0x2
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN_MASK                                               0x00000001L
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN_MASK                                           0x00000002L
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN_MASK                                              0x00000004L
//BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD__SHIFT                                       0x1
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD__SHIFT                                  0x2
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD__SHIFT                             0x3
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL__SHIFT                                0x4
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD__SHIFT                                  0x5
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD__SHIFT                                     0x6
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM__SHIFT                                      0x1b
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD_MASK                                              0x00000001L
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD_MASK                                         0x00000002L
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD_MASK                                    0x00000004L
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD_MASK                               0x00000008L
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL_MASK                                  0x00000010L
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD_MASK                                    0x00000020L
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD_MASK                                       0x00000040L
#define BIF_CFG_DEV0_RC_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM_MASK                                        0xF8000000L
//BIF_CFG_DEV0_RC_PCIE_ERR_SRC_ID
#define BIF_CFG_DEV0_RC_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID__SHIFT                                     0x10
#define BIF_CFG_DEV0_RC_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID_MASK                                                 0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG0
#define BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG1
#define BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG2
#define BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG3
#define BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_RC_PCIE_SECONDARY_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT                                           0x10
#define BIF_CFG_DEV0_RC_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT                                          0x14
#define BIF_CFG_DEV0_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK                                             0x000F0000L
#define BIF_CFG_DEV0_RC_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK                                            0xFFF00000L
//BIF_CFG_DEV0_RC_PCIE_LINK_CNTL3
#define BIF_CFG_DEV0_RC_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT                                          0x0
#define BIF_CFG_DEV0_RC_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT                                  0x1
#define BIF_CFG_DEV0_RC_PCIE_LINK_CNTL3__ENABLE_LOWER_SKP_OS_GEN__SHIFT                                       0x9
#define BIF_CFG_DEV0_RC_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK                                            0x00000001L
#define BIF_CFG_DEV0_RC_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK                                    0x00000002L
#define BIF_CFG_DEV0_RC_PCIE_LINK_CNTL3__ENABLE_LOWER_SKP_OS_GEN_MASK                                         0x0000FE00L
//BIF_CFG_DEV0_RC_PCIE_LANE_ERROR_STATUS
#define BIF_CFG_DEV0_RC_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT                                 0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK                                   0x0000FFFFL
//BIF_CFG_DEV0_RC_PCIE_LANE_0_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_1_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_2_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_3_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_4_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_5_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_6_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_7_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_8_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_9_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_10_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_11_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_12_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_13_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_14_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV0_RC_PCIE_LANE_15_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV0_RC_PCIE_ACS_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                                 0x10
#define BIF_CFG_DEV0_RC_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                0x14
#define BIF_CFG_DEV0_RC_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                                   0x000F0000L
#define BIF_CFG_DEV0_RC_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                                  0xFFF00000L
//BIF_CFG_DEV0_RC_PCIE_ACS_CAP
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                                0x0
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                             0x1
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                             0x2
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                          0x3
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                              0x4
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                               0x5
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                            0x6
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                       0x8
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                                  0x0001L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                               0x0002L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                               0x0004L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                            0x0008L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                                0x0010L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                                 0x0020L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                              0x0040L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                         0xFF00L
//BIF_CFG_DEV0_RC_PCIE_ACS_CNTL
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                         0x1
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                         0x2
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                      0x3
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                          0x4
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                           0x5
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                        0x6
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                              0x0001L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                           0x0002L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                           0x0004L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                        0x0008L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                            0x0010L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                             0x0020L
#define BIF_CFG_DEV0_RC_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                          0x0040L
//BIF_CFG_DEV0_RC_PCIE_DLF_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC_PCIE_DLF_ENH_CAP_LIST__CAP_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC_PCIE_DLF_ENH_CAP_LIST__CAP_VER__SHIFT                                                 0x10
#define BIF_CFG_DEV0_RC_PCIE_DLF_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                0x14
#define BIF_CFG_DEV0_RC_PCIE_DLF_ENH_CAP_LIST__CAP_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_DLF_ENH_CAP_LIST__CAP_VER_MASK                                                   0x000F0000L
#define BIF_CFG_DEV0_RC_PCIE_DLF_ENH_CAP_LIST__NEXT_PTR_MASK                                                  0xFFF00000L
//BIF_CFG_DEV0_RC_DATA_LINK_FEATURE_CAP
#define BIF_CFG_DEV0_RC_DATA_LINK_FEATURE_CAP__LOCAL_DLF_SUPPORTED__SHIFT                                     0x0
#define BIF_CFG_DEV0_RC_DATA_LINK_FEATURE_CAP__DLF_EXCHANGE_ENABLE__SHIFT                                     0x1f
#define BIF_CFG_DEV0_RC_DATA_LINK_FEATURE_CAP__LOCAL_DLF_SUPPORTED_MASK                                       0x007FFFFFL
#define BIF_CFG_DEV0_RC_DATA_LINK_FEATURE_CAP__DLF_EXCHANGE_ENABLE_MASK                                       0x80000000L
//BIF_CFG_DEV0_RC_DATA_LINK_FEATURE_STATUS
#define BIF_CFG_DEV0_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED__SHIFT                                 0x0
#define BIF_CFG_DEV0_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_VALID__SHIFT                           0x1f
#define BIF_CFG_DEV0_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_MASK                                   0x007FFFFFL
#define BIF_CFG_DEV0_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_VALID_MASK                             0x80000000L
//BIF_CFG_DEV0_RC_PCIE_PHY_16GT_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_ID__SHIFT                                             0x0
#define BIF_CFG_DEV0_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_VER__SHIFT                                            0x10
#define BIF_CFG_DEV0_RC_PCIE_PHY_16GT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                           0x14
#define BIF_CFG_DEV0_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_ID_MASK                                               0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_VER_MASK                                              0x000F0000L
#define BIF_CFG_DEV0_RC_PCIE_PHY_16GT_ENH_CAP_LIST__NEXT_PTR_MASK                                             0xFFF00000L
//BIF_CFG_DEV0_RC_LINK_CAP_16GT
#define BIF_CFG_DEV0_RC_LINK_CAP_16GT__RESERVED__SHIFT                                                        0x0
#define BIF_CFG_DEV0_RC_LINK_CAP_16GT__RESERVED_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV0_RC_LINK_CNTL_16GT
#define BIF_CFG_DEV0_RC_LINK_CNTL_16GT__RESERVED__SHIFT                                                       0x0
#define BIF_CFG_DEV0_RC_LINK_CNTL_16GT__RESERVED_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_RC_LINK_STATUS_16GT
#define BIF_CFG_DEV0_RC_LINK_STATUS_16GT__EQUALIZATION_COMPLETE_16GT__SHIFT                                   0x0
#define BIF_CFG_DEV0_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE1_SUCCESS_16GT__SHIFT                             0x1
#define BIF_CFG_DEV0_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE2_SUCCESS_16GT__SHIFT                             0x2
#define BIF_CFG_DEV0_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE3_SUCCESS_16GT__SHIFT                             0x3
#define BIF_CFG_DEV0_RC_LINK_STATUS_16GT__LINK_EQUALIZATION_REQUEST_16GT__SHIFT                               0x4
#define BIF_CFG_DEV0_RC_LINK_STATUS_16GT__EQUALIZATION_COMPLETE_16GT_MASK                                     0x00000001L
#define BIF_CFG_DEV0_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE1_SUCCESS_16GT_MASK                               0x00000002L
#define BIF_CFG_DEV0_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE2_SUCCESS_16GT_MASK                               0x00000004L
#define BIF_CFG_DEV0_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE3_SUCCESS_16GT_MASK                               0x00000008L
#define BIF_CFG_DEV0_RC_LINK_STATUS_16GT__LINK_EQUALIZATION_REQUEST_16GT_MASK                                 0x00000010L
//BIF_CFG_DEV0_RC_LOCAL_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV0_RC_LOCAL_PARITY_MISMATCH_STATUS_16GT__LOCAL_PARITY_MISMATCH_STATUS_BITS__SHIFT           0x0
#define BIF_CFG_DEV0_RC_LOCAL_PARITY_MISMATCH_STATUS_16GT__LOCAL_PARITY_MISMATCH_STATUS_BITS_MASK             0x0000FFFFL
//BIF_CFG_DEV0_RC_RTM1_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV0_RC_RTM1_PARITY_MISMATCH_STATUS_16GT__RTM1_PARITY_MISMATCH_STATUS_BITS__SHIFT             0x0
#define BIF_CFG_DEV0_RC_RTM1_PARITY_MISMATCH_STATUS_16GT__RTM1_PARITY_MISMATCH_STATUS_BITS_MASK               0x0000FFFFL
//BIF_CFG_DEV0_RC_RTM2_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV0_RC_RTM2_PARITY_MISMATCH_STATUS_16GT__RTM2_PARITY_MISMATCH_STATUS_BITS__SHIFT             0x0
#define BIF_CFG_DEV0_RC_RTM2_PARITY_MISMATCH_STATUS_16GT__RTM2_PARITY_MISMATCH_STATUS_BITS_MASK               0x0000FFFFL
//BIF_CFG_DEV0_RC_LANE_0_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV0_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV0_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV0_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV0_RC_LANE_1_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV0_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV0_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV0_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV0_RC_LANE_2_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV0_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV0_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV0_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV0_RC_LANE_3_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV0_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV0_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV0_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV0_RC_LANE_4_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV0_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV0_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV0_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV0_RC_LANE_5_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV0_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV0_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV0_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV0_RC_LANE_6_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV0_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV0_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV0_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV0_RC_LANE_7_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV0_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV0_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV0_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV0_RC_LANE_8_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV0_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV0_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV0_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV0_RC_LANE_9_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV0_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV0_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV0_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV0_RC_LANE_10_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_RC_LANE_11_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_RC_LANE_12_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_RC_LANE_13_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_RC_LANE_14_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_RC_LANE_15_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_RC_PCIE_MARGINING_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_VER__SHIFT                                           0x10
#define BIF_CFG_DEV0_RC_PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR__SHIFT                                          0x14
#define BIF_CFG_DEV0_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_VER_MASK                                             0x000F0000L
#define BIF_CFG_DEV0_RC_PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR_MASK                                            0xFFF00000L
//BIF_CFG_DEV0_RC_MARGINING_PORT_CAP
#define BIF_CFG_DEV0_RC_MARGINING_PORT_CAP__MARGINING_USES_SOFTWARE__SHIFT                                    0x0
#define BIF_CFG_DEV0_RC_MARGINING_PORT_CAP__MARGINING_USES_SOFTWARE_MASK                                      0x0001L
//BIF_CFG_DEV0_RC_MARGINING_PORT_STATUS
#define BIF_CFG_DEV0_RC_MARGINING_PORT_STATUS__MARGINING_READY__SHIFT                                         0x0
#define BIF_CFG_DEV0_RC_MARGINING_PORT_STATUS__MARGINING_SOFTWARE_READY__SHIFT                                0x1
#define BIF_CFG_DEV0_RC_MARGINING_PORT_STATUS__MARGINING_READY_MASK                                           0x0001L
#define BIF_CFG_DEV0_RC_MARGINING_PORT_STATUS__MARGINING_SOFTWARE_READY_MASK                                  0x0002L
//BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV0_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV0_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV0_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV0_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV0_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV0_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV0_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV0_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV0_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV0_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_RC_PCIE_RTR_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC_PCIE_RTR_ENH_CAP_LIST__CAP_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC_PCIE_RTR_ENH_CAP_LIST__CAP_VER__SHIFT                                                 0x10
#define BIF_CFG_DEV0_RC_PCIE_RTR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                0x14
#define BIF_CFG_DEV0_RC_PCIE_RTR_ENH_CAP_LIST__CAP_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV0_RC_PCIE_RTR_ENH_CAP_LIST__CAP_VER_MASK                                                   0x000F0000L
#define BIF_CFG_DEV0_RC_PCIE_RTR_ENH_CAP_LIST__NEXT_PTR_MASK                                                  0xFFF00000L
//BIF_CFG_DEV0_RC_RTR_DATA1
#define BIF_CFG_DEV0_RC_RTR_DATA1__RESET_TIME__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC_RTR_DATA1__DLUP_TIME__SHIFT                                                           0xc
#define BIF_CFG_DEV0_RC_RTR_DATA1__VALID__SHIFT                                                               0x1f
#define BIF_CFG_DEV0_RC_RTR_DATA1__RESET_TIME_MASK                                                            0x00000FFFL
#define BIF_CFG_DEV0_RC_RTR_DATA1__DLUP_TIME_MASK                                                             0x00FFF000L
#define BIF_CFG_DEV0_RC_RTR_DATA1__VALID_MASK                                                                 0x80000000L
//BIF_CFG_DEV0_RC_RTR_DATA2
#define BIF_CFG_DEV0_RC_RTR_DATA2__FLR_TIME__SHIFT                                                            0x0
#define BIF_CFG_DEV0_RC_RTR_DATA2__D3HOTD0_TIME__SHIFT                                                        0xc
#define BIF_CFG_DEV0_RC_RTR_DATA2__FLR_TIME_MASK                                                              0x00000FFFL
#define BIF_CFG_DEV0_RC_RTR_DATA2__D3HOTD0_TIME_MASK                                                          0x00FFF000L


// addressBlock: nbio_nbif0_bif_cfg_dev1_rc_bifcfgdecp
//BIF_CFG_DEV1_RC_VENDOR_ID
#define BIF_CFG_DEV1_RC_VENDOR_ID__VENDOR_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV1_RC_VENDOR_ID__VENDOR_ID_MASK                                                             0xFFFFL
//BIF_CFG_DEV1_RC_DEVICE_ID
#define BIF_CFG_DEV1_RC_DEVICE_ID__DEVICE_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV1_RC_DEVICE_ID__DEVICE_ID_MASK                                                             0xFFFFL
//BIF_CFG_DEV1_RC_COMMAND
#define BIF_CFG_DEV1_RC_COMMAND__IOEN_DN__SHIFT                                                               0x0
#define BIF_CFG_DEV1_RC_COMMAND__MEMEN_DN__SHIFT                                                              0x1
#define BIF_CFG_DEV1_RC_COMMAND__BUS_MASTER_EN__SHIFT                                                         0x2
#define BIF_CFG_DEV1_RC_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                      0x3
#define BIF_CFG_DEV1_RC_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                               0x4
#define BIF_CFG_DEV1_RC_COMMAND__PAL_SNOOP_EN__SHIFT                                                          0x5
#define BIF_CFG_DEV1_RC_COMMAND__AD_STEPPING__SHIFT                                                           0x7
#define BIF_CFG_DEV1_RC_COMMAND__SERR_EN__SHIFT                                                               0x8
#define BIF_CFG_DEV1_RC_COMMAND__FAST_B2B_EN__SHIFT                                                           0x9
#define BIF_CFG_DEV1_RC_COMMAND__INT_DIS__SHIFT                                                               0xa
#define BIF_CFG_DEV1_RC_COMMAND__IOEN_DN_MASK                                                                 0x0001L
#define BIF_CFG_DEV1_RC_COMMAND__MEMEN_DN_MASK                                                                0x0002L
#define BIF_CFG_DEV1_RC_COMMAND__BUS_MASTER_EN_MASK                                                           0x0004L
#define BIF_CFG_DEV1_RC_COMMAND__SPECIAL_CYCLE_EN_MASK                                                        0x0008L
#define BIF_CFG_DEV1_RC_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                                 0x0010L
#define BIF_CFG_DEV1_RC_COMMAND__PAL_SNOOP_EN_MASK                                                            0x0020L
#define BIF_CFG_DEV1_RC_COMMAND__AD_STEPPING_MASK                                                             0x0080L
#define BIF_CFG_DEV1_RC_COMMAND__SERR_EN_MASK                                                                 0x0100L
#define BIF_CFG_DEV1_RC_COMMAND__FAST_B2B_EN_MASK                                                             0x0200L
#define BIF_CFG_DEV1_RC_COMMAND__INT_DIS_MASK                                                                 0x0400L
//BIF_CFG_DEV1_RC_STATUS
#define BIF_CFG_DEV1_RC_STATUS__IMMEDIATE_READINESS__SHIFT                                                    0x0
#define BIF_CFG_DEV1_RC_STATUS__INT_STATUS__SHIFT                                                             0x3
#define BIF_CFG_DEV1_RC_STATUS__CAP_LIST__SHIFT                                                               0x4
#define BIF_CFG_DEV1_RC_STATUS__PCI_66_CAP__SHIFT                                                             0x5
#define BIF_CFG_DEV1_RC_STATUS__FAST_BACK_CAPABLE__SHIFT                                                      0x7
#define BIF_CFG_DEV1_RC_STATUS__DEVSEL_TIMING__SHIFT                                                          0x9
#define BIF_CFG_DEV1_RC_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                    0xb
#define BIF_CFG_DEV1_RC_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                  0xc
#define BIF_CFG_DEV1_RC_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                  0xd
#define BIF_CFG_DEV1_RC_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                                  0xe
#define BIF_CFG_DEV1_RC_STATUS__IMMEDIATE_READINESS_MASK                                                      0x0001L
#define BIF_CFG_DEV1_RC_STATUS__INT_STATUS_MASK                                                               0x0008L
#define BIF_CFG_DEV1_RC_STATUS__CAP_LIST_MASK                                                                 0x0010L
#define BIF_CFG_DEV1_RC_STATUS__PCI_66_CAP_MASK                                                               0x0020L
#define BIF_CFG_DEV1_RC_STATUS__FAST_BACK_CAPABLE_MASK                                                        0x0080L
#define BIF_CFG_DEV1_RC_STATUS__DEVSEL_TIMING_MASK                                                            0x0600L
#define BIF_CFG_DEV1_RC_STATUS__SIGNAL_TARGET_ABORT_MASK                                                      0x0800L
#define BIF_CFG_DEV1_RC_STATUS__RECEIVED_TARGET_ABORT_MASK                                                    0x1000L
#define BIF_CFG_DEV1_RC_STATUS__RECEIVED_MASTER_ABORT_MASK                                                    0x2000L
#define BIF_CFG_DEV1_RC_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                    0x4000L
//BIF_CFG_DEV1_RC_REVISION_ID
#define BIF_CFG_DEV1_RC_REVISION_ID__MINOR_REV_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV1_RC_REVISION_ID__MAJOR_REV_ID__SHIFT                                                      0x4
#define BIF_CFG_DEV1_RC_REVISION_ID__MINOR_REV_ID_MASK                                                        0x0FL
#define BIF_CFG_DEV1_RC_REVISION_ID__MAJOR_REV_ID_MASK                                                        0xF0L
//BIF_CFG_DEV1_RC_PROG_INTERFACE
#define BIF_CFG_DEV1_RC_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC_PROG_INTERFACE__PROG_INTERFACE_MASK                                                   0xFFL
//BIF_CFG_DEV1_RC_SUB_CLASS
#define BIF_CFG_DEV1_RC_SUB_CLASS__SUB_CLASS__SHIFT                                                           0x0
#define BIF_CFG_DEV1_RC_SUB_CLASS__SUB_CLASS_MASK                                                             0xFFL
//BIF_CFG_DEV1_RC_BASE_CLASS
#define BIF_CFG_DEV1_RC_BASE_CLASS__BASE_CLASS__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC_BASE_CLASS__BASE_CLASS_MASK                                                           0xFFL
//BIF_CFG_DEV1_RC_CACHE_LINE
#define BIF_CFG_DEV1_RC_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                    0x0
#define BIF_CFG_DEV1_RC_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                      0xFFL
//BIF_CFG_DEV1_RC_LATENCY
#define BIF_CFG_DEV1_RC_LATENCY__LATENCY_TIMER__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC_LATENCY__LATENCY_TIMER_MASK                                                           0xFFL
//BIF_CFG_DEV1_RC_HEADER
#define BIF_CFG_DEV1_RC_HEADER__HEADER_TYPE__SHIFT                                                            0x0
#define BIF_CFG_DEV1_RC_HEADER__DEVICE_TYPE__SHIFT                                                            0x7
#define BIF_CFG_DEV1_RC_HEADER__HEADER_TYPE_MASK                                                              0x7FL
#define BIF_CFG_DEV1_RC_HEADER__DEVICE_TYPE_MASK                                                              0x80L
//BIF_CFG_DEV1_RC_BIST
#define BIF_CFG_DEV1_RC_BIST__BIST_COMP__SHIFT                                                                0x0
#define BIF_CFG_DEV1_RC_BIST__BIST_STRT__SHIFT                                                                0x6
#define BIF_CFG_DEV1_RC_BIST__BIST_CAP__SHIFT                                                                 0x7
#define BIF_CFG_DEV1_RC_BIST__BIST_COMP_MASK                                                                  0x0FL
#define BIF_CFG_DEV1_RC_BIST__BIST_STRT_MASK                                                                  0x40L
#define BIF_CFG_DEV1_RC_BIST__BIST_CAP_MASK                                                                   0x80L
//BIF_CFG_DEV1_RC_BASE_ADDR_1
#define BIF_CFG_DEV1_RC_BASE_ADDR_1__BASE_ADDR__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC_BASE_ADDR_1__BASE_ADDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV1_RC_BASE_ADDR_2
#define BIF_CFG_DEV1_RC_BASE_ADDR_2__BASE_ADDR__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC_BASE_ADDR_2__BASE_ADDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV1_RC_SUB_BUS_NUMBER_LATENCY
#define BIF_CFG_DEV1_RC_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS__SHIFT                                          0x8
#define BIF_CFG_DEV1_RC_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM__SHIFT                                            0x10
#define BIF_CFG_DEV1_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER__SHIFT                                0x18
#define BIF_CFG_DEV1_RC_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS_MASK                                              0x000000FFL
#define BIF_CFG_DEV1_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS_MASK                                            0x0000FF00L
#define BIF_CFG_DEV1_RC_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM_MASK                                              0x00FF0000L
#define BIF_CFG_DEV1_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER_MASK                                  0xFF000000L
//BIF_CFG_DEV1_RC_IO_BASE_LIMIT
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT__IO_BASE_TYPE__SHIFT                                                    0x0
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT__IO_BASE__SHIFT                                                         0x4
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT__IO_LIMIT_TYPE__SHIFT                                                   0x8
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT__IO_LIMIT__SHIFT                                                        0xc
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT__IO_BASE_TYPE_MASK                                                      0x000FL
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT__IO_BASE_MASK                                                           0x00F0L
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT__IO_LIMIT_TYPE_MASK                                                     0x0F00L
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT__IO_LIMIT_MASK                                                          0xF000L
//BIF_CFG_DEV1_RC_SECONDARY_STATUS
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__PCI_66_CAP__SHIFT                                                   0x5
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__FAST_BACK_CAPABLE__SHIFT                                            0x7
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__DEVSEL_TIMING__SHIFT                                                0x9
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                          0xb
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                        0xc
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                        0xd
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR__SHIFT                                        0xe
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__PCI_66_CAP_MASK                                                     0x0020L
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__FAST_BACK_CAPABLE_MASK                                              0x0080L
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__DEVSEL_TIMING_MASK                                                  0x0600L
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__SIGNAL_TARGET_ABORT_MASK                                            0x0800L
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__RECEIVED_TARGET_ABORT_MASK                                          0x1000L
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__RECEIVED_MASTER_ABORT_MASK                                          0x2000L
#define BIF_CFG_DEV1_RC_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR_MASK                                          0x4000L
//BIF_CFG_DEV1_RC_MEM_BASE_LIMIT
#define BIF_CFG_DEV1_RC_MEM_BASE_LIMIT__MEM_BASE_TYPE__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC_MEM_BASE_LIMIT__MEM_BASE_31_20__SHIFT                                                 0x4
#define BIF_CFG_DEV1_RC_MEM_BASE_LIMIT__MEM_LIMIT_TYPE__SHIFT                                                 0x10
#define BIF_CFG_DEV1_RC_MEM_BASE_LIMIT__MEM_LIMIT_31_20__SHIFT                                                0x14
#define BIF_CFG_DEV1_RC_MEM_BASE_LIMIT__MEM_BASE_TYPE_MASK                                                    0x0000000FL
#define BIF_CFG_DEV1_RC_MEM_BASE_LIMIT__MEM_BASE_31_20_MASK                                                   0x0000FFF0L
#define BIF_CFG_DEV1_RC_MEM_BASE_LIMIT__MEM_LIMIT_TYPE_MASK                                                   0x000F0000L
#define BIF_CFG_DEV1_RC_MEM_BASE_LIMIT__MEM_LIMIT_31_20_MASK                                                  0xFFF00000L
//BIF_CFG_DEV1_RC_PREF_BASE_LIMIT
#define BIF_CFG_DEV1_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20__SHIFT                                           0x4
#define BIF_CFG_DEV1_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE__SHIFT                                           0x10
#define BIF_CFG_DEV1_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20__SHIFT                                          0x14
#define BIF_CFG_DEV1_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE_MASK                                              0x0000000FL
#define BIF_CFG_DEV1_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20_MASK                                             0x0000FFF0L
#define BIF_CFG_DEV1_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE_MASK                                             0x000F0000L
#define BIF_CFG_DEV1_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20_MASK                                            0xFFF00000L
//BIF_CFG_DEV1_RC_PREF_BASE_UPPER
#define BIF_CFG_DEV1_RC_PREF_BASE_UPPER__PREF_BASE_UPPER__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC_PREF_BASE_UPPER__PREF_BASE_UPPER_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PREF_LIMIT_UPPER
#define BIF_CFG_DEV1_RC_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER__SHIFT                                             0x0
#define BIF_CFG_DEV1_RC_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV1_RC_IO_BASE_LIMIT_HI
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT_HI__IO_BASE_31_16__SHIFT                                                0x0
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT_HI__IO_LIMIT_31_16__SHIFT                                               0x10
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT_HI__IO_BASE_31_16_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV1_RC_IO_BASE_LIMIT_HI__IO_LIMIT_31_16_MASK                                                 0xFFFF0000L
//BIF_CFG_DEV1_RC_CAP_PTR
#define BIF_CFG_DEV1_RC_CAP_PTR__CAP_PTR__SHIFT                                                               0x0
#define BIF_CFG_DEV1_RC_CAP_PTR__CAP_PTR_MASK                                                                 0xFFL
//BIF_CFG_DEV1_RC_ROM_BASE_ADDR
#define BIF_CFG_DEV1_RC_ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV1_RC_ROM_BASE_ADDR__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV1_RC_INTERRUPT_LINE
#define BIF_CFG_DEV1_RC_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                                   0xFFL
//BIF_CFG_DEV1_RC_INTERRUPT_PIN
#define BIF_CFG_DEV1_RC_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                                   0x0
#define BIF_CFG_DEV1_RC_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                     0xFFL
//BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__SERR_EN__SHIFT                                                       0x1
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__ISA_EN__SHIFT                                                        0x2
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__VGA_EN__SHIFT                                                        0x3
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__VGA_DEC__SHIFT                                                       0x4
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE__SHIFT                                             0x5
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET__SHIFT                                           0x6
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__FAST_B2B_EN__SHIFT                                                   0x7
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__PRIMARY_DISCARD_TIMER__SHIFT                                         0x8
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__SECONDARY_DISCARD_TIMER__SHIFT                                       0x9
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_STATUS__SHIFT                                          0xa
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_SERR_ENABLE__SHIFT                                     0xb
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN_MASK                                              0x0001L
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__SERR_EN_MASK                                                         0x0002L
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__ISA_EN_MASK                                                          0x0004L
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__VGA_EN_MASK                                                          0x0008L
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__VGA_DEC_MASK                                                         0x0010L
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE_MASK                                               0x0020L
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET_MASK                                             0x0040L
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__FAST_B2B_EN_MASK                                                     0x0080L
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__PRIMARY_DISCARD_TIMER_MASK                                           0x0100L
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__SECONDARY_DISCARD_TIMER_MASK                                         0x0200L
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_STATUS_MASK                                            0x0400L
#define BIF_CFG_DEV1_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_SERR_ENABLE_MASK                                       0x0800L
//BIF_CFG_DEV1_RC_EXT_BRIDGE_CNTL
#define BIF_CFG_DEV1_RC_EXT_BRIDGE_CNTL__IO_PORT_80_EN__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC_EXT_BRIDGE_CNTL__IO_PORT_80_EN_MASK                                                   0x01L
//BIF_CFG_DEV1_RC_PMI_CAP_LIST
#define BIF_CFG_DEV1_RC_PMI_CAP_LIST__CAP_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV1_RC_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                         0x8
#define BIF_CFG_DEV1_RC_PMI_CAP_LIST__CAP_ID_MASK                                                             0x00FFL
#define BIF_CFG_DEV1_RC_PMI_CAP_LIST__NEXT_PTR_MASK                                                           0xFF00L
//BIF_CFG_DEV1_RC_PMI_CAP
#define BIF_CFG_DEV1_RC_PMI_CAP__VERSION__SHIFT                                                               0x0
#define BIF_CFG_DEV1_RC_PMI_CAP__PME_CLOCK__SHIFT                                                             0x3
#define BIF_CFG_DEV1_RC_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0__SHIFT                                   0x4
#define BIF_CFG_DEV1_RC_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                     0x5
#define BIF_CFG_DEV1_RC_PMI_CAP__AUX_CURRENT__SHIFT                                                           0x6
#define BIF_CFG_DEV1_RC_PMI_CAP__D1_SUPPORT__SHIFT                                                            0x9
#define BIF_CFG_DEV1_RC_PMI_CAP__D2_SUPPORT__SHIFT                                                            0xa
#define BIF_CFG_DEV1_RC_PMI_CAP__PME_SUPPORT__SHIFT                                                           0xb
#define BIF_CFG_DEV1_RC_PMI_CAP__VERSION_MASK                                                                 0x0007L
#define BIF_CFG_DEV1_RC_PMI_CAP__PME_CLOCK_MASK                                                               0x0008L
#define BIF_CFG_DEV1_RC_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0_MASK                                     0x0010L
#define BIF_CFG_DEV1_RC_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                       0x0020L
#define BIF_CFG_DEV1_RC_PMI_CAP__AUX_CURRENT_MASK                                                             0x01C0L
#define BIF_CFG_DEV1_RC_PMI_CAP__D1_SUPPORT_MASK                                                              0x0200L
#define BIF_CFG_DEV1_RC_PMI_CAP__D2_SUPPORT_MASK                                                              0x0400L
#define BIF_CFG_DEV1_RC_PMI_CAP__PME_SUPPORT_MASK                                                             0xF800L
//BIF_CFG_DEV1_RC_PMI_STATUS_CNTL
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                                   0x0
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                                 0x3
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__PME_EN__SHIFT                                                        0x8
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                                   0x9
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                    0xd
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                    0xf
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                                 0x16
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                    0x17
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                      0x18
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__POWER_STATE_MASK                                                     0x00000003L
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                                   0x00000008L
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__PME_EN_MASK                                                          0x00000100L
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                     0x00001E00L
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                      0x00006000L
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__PME_STATUS_MASK                                                      0x00008000L
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                                   0x00400000L
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                      0x00800000L
#define BIF_CFG_DEV1_RC_PMI_STATUS_CNTL__PMI_DATA_MASK                                                        0xFF000000L
//BIF_CFG_DEV1_RC_PCIE_CAP_LIST
#define BIF_CFG_DEV1_RC_PCIE_CAP_LIST__CAP_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                        0x8
#define BIF_CFG_DEV1_RC_PCIE_CAP_LIST__CAP_ID_MASK                                                            0x00FFL
#define BIF_CFG_DEV1_RC_PCIE_CAP_LIST__NEXT_PTR_MASK                                                          0xFF00L
//BIF_CFG_DEV1_RC_PCIE_CAP
#define BIF_CFG_DEV1_RC_PCIE_CAP__VERSION__SHIFT                                                              0x0
#define BIF_CFG_DEV1_RC_PCIE_CAP__DEVICE_TYPE__SHIFT                                                          0x4
#define BIF_CFG_DEV1_RC_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                     0x8
#define BIF_CFG_DEV1_RC_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                      0x9
#define BIF_CFG_DEV1_RC_PCIE_CAP__VERSION_MASK                                                                0x000FL
#define BIF_CFG_DEV1_RC_PCIE_CAP__DEVICE_TYPE_MASK                                                            0x00F0L
#define BIF_CFG_DEV1_RC_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                       0x0100L
#define BIF_CFG_DEV1_RC_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                        0x3E00L
//BIF_CFG_DEV1_RC_DEVICE_CAP
#define BIF_CFG_DEV1_RC_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                                0x0
#define BIF_CFG_DEV1_RC_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                       0x3
#define BIF_CFG_DEV1_RC_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                       0x5
#define BIF_CFG_DEV1_RC_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                             0x6
#define BIF_CFG_DEV1_RC_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                              0x9
#define BIF_CFG_DEV1_RC_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                           0xf
#define BIF_CFG_DEV1_RC_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                        0x1c
#define BIF_CFG_DEV1_RC_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                                  0x00000007L
#define BIF_CFG_DEV1_RC_DEVICE_CAP__PHANTOM_FUNC_MASK                                                         0x00000018L
#define BIF_CFG_DEV1_RC_DEVICE_CAP__EXTENDED_TAG_MASK                                                         0x00000020L
#define BIF_CFG_DEV1_RC_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                               0x000001C0L
#define BIF_CFG_DEV1_RC_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                                0x00000E00L
#define BIF_CFG_DEV1_RC_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                             0x00008000L
#define BIF_CFG_DEV1_RC_DEVICE_CAP__FLR_CAPABLE_MASK                                                          0x10000000L
//BIF_CFG_DEV1_RC_DEVICE_CNTL
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                       0x0
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                                  0x1
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                      0x2
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                     0x3
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                    0x4
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                                  0x5
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                                   0x8
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                                   0x9
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                                   0xa
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                       0xb
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                             0xc
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN__SHIFT                                               0xf
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__CORR_ERR_EN_MASK                                                         0x0001L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                    0x0002L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                        0x0004L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__USR_REPORT_EN_MASK                                                       0x0008L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                      0x0010L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                    0x00E0L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                     0x0100L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                     0x0200L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                     0x0400L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                         0x0800L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                               0x7000L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN_MASK                                                 0x8000L
//BIF_CFG_DEV1_RC_DEVICE_STATUS
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__CORR_ERR__SHIFT                                                        0x0
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                                   0x1
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__FATAL_ERR__SHIFT                                                       0x2
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__USR_DETECTED__SHIFT                                                    0x3
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__AUX_PWR__SHIFT                                                         0x4
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                               0x5
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED__SHIFT                                   0x6
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__CORR_ERR_MASK                                                          0x0001L
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                     0x0002L
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__FATAL_ERR_MASK                                                         0x0004L
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__USR_DETECTED_MASK                                                      0x0008L
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__AUX_PWR_MASK                                                           0x0010L
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                                 0x0020L
#define BIF_CFG_DEV1_RC_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED_MASK                                     0x0040L
//BIF_CFG_DEV1_RC_LINK_CAP
#define BIF_CFG_DEV1_RC_LINK_CAP__LINK_SPEED__SHIFT                                                           0x0
#define BIF_CFG_DEV1_RC_LINK_CAP__LINK_WIDTH__SHIFT                                                           0x4
#define BIF_CFG_DEV1_RC_LINK_CAP__PM_SUPPORT__SHIFT                                                           0xa
#define BIF_CFG_DEV1_RC_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                     0xc
#define BIF_CFG_DEV1_RC_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                      0xf
#define BIF_CFG_DEV1_RC_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                               0x12
#define BIF_CFG_DEV1_RC_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                          0x13
#define BIF_CFG_DEV1_RC_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                          0x14
#define BIF_CFG_DEV1_RC_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                             0x15
#define BIF_CFG_DEV1_RC_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                          0x16
#define BIF_CFG_DEV1_RC_LINK_CAP__PORT_NUMBER__SHIFT                                                          0x18
#define BIF_CFG_DEV1_RC_LINK_CAP__LINK_SPEED_MASK                                                             0x0000000FL
#define BIF_CFG_DEV1_RC_LINK_CAP__LINK_WIDTH_MASK                                                             0x000003F0L
#define BIF_CFG_DEV1_RC_LINK_CAP__PM_SUPPORT_MASK                                                             0x00000C00L
#define BIF_CFG_DEV1_RC_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                       0x00007000L
#define BIF_CFG_DEV1_RC_LINK_CAP__L1_EXIT_LATENCY_MASK                                                        0x00038000L
#define BIF_CFG_DEV1_RC_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                                 0x00040000L
#define BIF_CFG_DEV1_RC_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                            0x00080000L
#define BIF_CFG_DEV1_RC_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                            0x00100000L
#define BIF_CFG_DEV1_RC_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                               0x00200000L
#define BIF_CFG_DEV1_RC_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                            0x00400000L
#define BIF_CFG_DEV1_RC_LINK_CAP__PORT_NUMBER_MASK                                                            0xFF000000L
//BIF_CFG_DEV1_RC_LINK_CNTL
#define BIF_CFG_DEV1_RC_LINK_CNTL__PM_CONTROL__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B__SHIFT                                        0x2
#define BIF_CFG_DEV1_RC_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                                   0x3
#define BIF_CFG_DEV1_RC_LINK_CNTL__LINK_DIS__SHIFT                                                            0x4
#define BIF_CFG_DEV1_RC_LINK_CNTL__RETRAIN_LINK__SHIFT                                                        0x5
#define BIF_CFG_DEV1_RC_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                    0x6
#define BIF_CFG_DEV1_RC_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                       0x7
#define BIF_CFG_DEV1_RC_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                           0x8
#define BIF_CFG_DEV1_RC_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                         0x9
#define BIF_CFG_DEV1_RC_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                           0xa
#define BIF_CFG_DEV1_RC_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                           0xb
#define BIF_CFG_DEV1_RC_LINK_CNTL__DRS_SIGNALING_CONTROL__SHIFT                                               0xe
#define BIF_CFG_DEV1_RC_LINK_CNTL__PM_CONTROL_MASK                                                            0x0003L
#define BIF_CFG_DEV1_RC_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B_MASK                                          0x0004L
#define BIF_CFG_DEV1_RC_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                     0x0008L
#define BIF_CFG_DEV1_RC_LINK_CNTL__LINK_DIS_MASK                                                              0x0010L
#define BIF_CFG_DEV1_RC_LINK_CNTL__RETRAIN_LINK_MASK                                                          0x0020L
#define BIF_CFG_DEV1_RC_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                      0x0040L
#define BIF_CFG_DEV1_RC_LINK_CNTL__EXTENDED_SYNC_MASK                                                         0x0080L
#define BIF_CFG_DEV1_RC_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                             0x0100L
#define BIF_CFG_DEV1_RC_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                           0x0200L
#define BIF_CFG_DEV1_RC_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                             0x0400L
#define BIF_CFG_DEV1_RC_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                             0x0800L
#define BIF_CFG_DEV1_RC_LINK_CNTL__DRS_SIGNALING_CONTROL_MASK                                                 0xC000L
//BIF_CFG_DEV1_RC_LINK_STATUS
#define BIF_CFG_DEV1_RC_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                                0x0
#define BIF_CFG_DEV1_RC_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                             0x4
#define BIF_CFG_DEV1_RC_LINK_STATUS__LINK_TRAINING__SHIFT                                                     0xb
#define BIF_CFG_DEV1_RC_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                    0xc
#define BIF_CFG_DEV1_RC_LINK_STATUS__DL_ACTIVE__SHIFT                                                         0xd
#define BIF_CFG_DEV1_RC_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                         0xe
#define BIF_CFG_DEV1_RC_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                         0xf
#define BIF_CFG_DEV1_RC_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                                  0x000FL
#define BIF_CFG_DEV1_RC_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                               0x03F0L
#define BIF_CFG_DEV1_RC_LINK_STATUS__LINK_TRAINING_MASK                                                       0x0800L
#define BIF_CFG_DEV1_RC_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                      0x1000L
#define BIF_CFG_DEV1_RC_LINK_STATUS__DL_ACTIVE_MASK                                                           0x2000L
#define BIF_CFG_DEV1_RC_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                           0x4000L
#define BIF_CFG_DEV1_RC_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                           0x8000L
//BIF_CFG_DEV1_RC_SLOT_CAP
#define BIF_CFG_DEV1_RC_SLOT_CAP__ATTN_BUTTON_PRESENT__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC_SLOT_CAP__PWR_CONTROLLER_PRESENT__SHIFT                                               0x1
#define BIF_CFG_DEV1_RC_SLOT_CAP__MRL_SENSOR_PRESENT__SHIFT                                                   0x2
#define BIF_CFG_DEV1_RC_SLOT_CAP__ATTN_INDICATOR_PRESENT__SHIFT                                               0x3
#define BIF_CFG_DEV1_RC_SLOT_CAP__PWR_INDICATOR_PRESENT__SHIFT                                                0x4
#define BIF_CFG_DEV1_RC_SLOT_CAP__HOTPLUG_SURPRISE__SHIFT                                                     0x5
#define BIF_CFG_DEV1_RC_SLOT_CAP__HOTPLUG_CAPABLE__SHIFT                                                      0x6
#define BIF_CFG_DEV1_RC_SLOT_CAP__SLOT_PWR_LIMIT_VALUE__SHIFT                                                 0x7
#define BIF_CFG_DEV1_RC_SLOT_CAP__SLOT_PWR_LIMIT_SCALE__SHIFT                                                 0xf
#define BIF_CFG_DEV1_RC_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT__SHIFT                                        0x11
#define BIF_CFG_DEV1_RC_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED__SHIFT                                       0x12
#define BIF_CFG_DEV1_RC_SLOT_CAP__PHYSICAL_SLOT_NUM__SHIFT                                                    0x13
#define BIF_CFG_DEV1_RC_SLOT_CAP__ATTN_BUTTON_PRESENT_MASK                                                    0x00000001L
#define BIF_CFG_DEV1_RC_SLOT_CAP__PWR_CONTROLLER_PRESENT_MASK                                                 0x00000002L
#define BIF_CFG_DEV1_RC_SLOT_CAP__MRL_SENSOR_PRESENT_MASK                                                     0x00000004L
#define BIF_CFG_DEV1_RC_SLOT_CAP__ATTN_INDICATOR_PRESENT_MASK                                                 0x00000008L
#define BIF_CFG_DEV1_RC_SLOT_CAP__PWR_INDICATOR_PRESENT_MASK                                                  0x00000010L
#define BIF_CFG_DEV1_RC_SLOT_CAP__HOTPLUG_SURPRISE_MASK                                                       0x00000020L
#define BIF_CFG_DEV1_RC_SLOT_CAP__HOTPLUG_CAPABLE_MASK                                                        0x00000040L
#define BIF_CFG_DEV1_RC_SLOT_CAP__SLOT_PWR_LIMIT_VALUE_MASK                                                   0x00007F80L
#define BIF_CFG_DEV1_RC_SLOT_CAP__SLOT_PWR_LIMIT_SCALE_MASK                                                   0x00018000L
#define BIF_CFG_DEV1_RC_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT_MASK                                          0x00020000L
#define BIF_CFG_DEV1_RC_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED_MASK                                         0x00040000L
#define BIF_CFG_DEV1_RC_SLOT_CAP__PHYSICAL_SLOT_NUM_MASK                                                      0xFFF80000L
//BIF_CFG_DEV1_RC_SLOT_CNTL
#define BIF_CFG_DEV1_RC_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC_SLOT_CNTL__PWR_FAULT_DETECTED_EN__SHIFT                                               0x1
#define BIF_CFG_DEV1_RC_SLOT_CNTL__MRL_SENSOR_CHANGED_EN__SHIFT                                               0x2
#define BIF_CFG_DEV1_RC_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN__SHIFT                                          0x3
#define BIF_CFG_DEV1_RC_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN__SHIFT                                           0x4
#define BIF_CFG_DEV1_RC_SLOT_CNTL__HOTPLUG_INTR_EN__SHIFT                                                     0x5
#define BIF_CFG_DEV1_RC_SLOT_CNTL__ATTN_INDICATOR_CNTL__SHIFT                                                 0x6
#define BIF_CFG_DEV1_RC_SLOT_CNTL__PWR_INDICATOR_CNTL__SHIFT                                                  0x8
#define BIF_CFG_DEV1_RC_SLOT_CNTL__PWR_CONTROLLER_CNTL__SHIFT                                                 0xa
#define BIF_CFG_DEV1_RC_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL__SHIFT                                          0xb
#define BIF_CFG_DEV1_RC_SLOT_CNTL__DL_STATE_CHANGED_EN__SHIFT                                                 0xc
#define BIF_CFG_DEV1_RC_SLOT_CNTL__AUTO_SLOT_PWR_LIMIT_DISABLE__SHIFT                                         0xd
#define BIF_CFG_DEV1_RC_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN_MASK                                                0x0001L
#define BIF_CFG_DEV1_RC_SLOT_CNTL__PWR_FAULT_DETECTED_EN_MASK                                                 0x0002L
#define BIF_CFG_DEV1_RC_SLOT_CNTL__MRL_SENSOR_CHANGED_EN_MASK                                                 0x0004L
#define BIF_CFG_DEV1_RC_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN_MASK                                            0x0008L
#define BIF_CFG_DEV1_RC_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN_MASK                                             0x0010L
#define BIF_CFG_DEV1_RC_SLOT_CNTL__HOTPLUG_INTR_EN_MASK                                                       0x0020L
#define BIF_CFG_DEV1_RC_SLOT_CNTL__ATTN_INDICATOR_CNTL_MASK                                                   0x00C0L
#define BIF_CFG_DEV1_RC_SLOT_CNTL__PWR_INDICATOR_CNTL_MASK                                                    0x0300L
#define BIF_CFG_DEV1_RC_SLOT_CNTL__PWR_CONTROLLER_CNTL_MASK                                                   0x0400L
#define BIF_CFG_DEV1_RC_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL_MASK                                            0x0800L
#define BIF_CFG_DEV1_RC_SLOT_CNTL__DL_STATE_CHANGED_EN_MASK                                                   0x1000L
#define BIF_CFG_DEV1_RC_SLOT_CNTL__AUTO_SLOT_PWR_LIMIT_DISABLE_MASK                                           0x2000L
//BIF_CFG_DEV1_RC_SLOT_STATUS
#define BIF_CFG_DEV1_RC_SLOT_STATUS__ATTN_BUTTON_PRESSED__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC_SLOT_STATUS__PWR_FAULT_DETECTED__SHIFT                                                0x1
#define BIF_CFG_DEV1_RC_SLOT_STATUS__MRL_SENSOR_CHANGED__SHIFT                                                0x2
#define BIF_CFG_DEV1_RC_SLOT_STATUS__PRESENCE_DETECT_CHANGED__SHIFT                                           0x3
#define BIF_CFG_DEV1_RC_SLOT_STATUS__COMMAND_COMPLETED__SHIFT                                                 0x4
#define BIF_CFG_DEV1_RC_SLOT_STATUS__MRL_SENSOR_STATE__SHIFT                                                  0x5
#define BIF_CFG_DEV1_RC_SLOT_STATUS__PRESENCE_DETECT_STATE__SHIFT                                             0x6
#define BIF_CFG_DEV1_RC_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS__SHIFT                                      0x7
#define BIF_CFG_DEV1_RC_SLOT_STATUS__DL_STATE_CHANGED__SHIFT                                                  0x8
#define BIF_CFG_DEV1_RC_SLOT_STATUS__ATTN_BUTTON_PRESSED_MASK                                                 0x0001L
#define BIF_CFG_DEV1_RC_SLOT_STATUS__PWR_FAULT_DETECTED_MASK                                                  0x0002L
#define BIF_CFG_DEV1_RC_SLOT_STATUS__MRL_SENSOR_CHANGED_MASK                                                  0x0004L
#define BIF_CFG_DEV1_RC_SLOT_STATUS__PRESENCE_DETECT_CHANGED_MASK                                             0x0008L
#define BIF_CFG_DEV1_RC_SLOT_STATUS__COMMAND_COMPLETED_MASK                                                   0x0010L
#define BIF_CFG_DEV1_RC_SLOT_STATUS__MRL_SENSOR_STATE_MASK                                                    0x0020L
#define BIF_CFG_DEV1_RC_SLOT_STATUS__PRESENCE_DETECT_STATE_MASK                                               0x0040L
#define BIF_CFG_DEV1_RC_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS_MASK                                        0x0080L
#define BIF_CFG_DEV1_RC_SLOT_STATUS__DL_STATE_CHANGED_MASK                                                    0x0100L
//BIF_CFG_DEV1_RC_ROOT_CNTL
#define BIF_CFG_DEV1_RC_ROOT_CNTL__SERR_ON_CORR_ERR_EN__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN__SHIFT                                             0x1
#define BIF_CFG_DEV1_RC_ROOT_CNTL__SERR_ON_FATAL_ERR_EN__SHIFT                                                0x2
#define BIF_CFG_DEV1_RC_ROOT_CNTL__PM_INTERRUPT_EN__SHIFT                                                     0x3
#define BIF_CFG_DEV1_RC_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN__SHIFT                                          0x4
#define BIF_CFG_DEV1_RC_ROOT_CNTL__SERR_ON_CORR_ERR_EN_MASK                                                   0x0001L
#define BIF_CFG_DEV1_RC_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN_MASK                                               0x0002L
#define BIF_CFG_DEV1_RC_ROOT_CNTL__SERR_ON_FATAL_ERR_EN_MASK                                                  0x0004L
#define BIF_CFG_DEV1_RC_ROOT_CNTL__PM_INTERRUPT_EN_MASK                                                       0x0008L
#define BIF_CFG_DEV1_RC_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN_MASK                                            0x0010L
//BIF_CFG_DEV1_RC_ROOT_CAP
#define BIF_CFG_DEV1_RC_ROOT_CAP__CRS_SOFTWARE_VISIBILITY__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC_ROOT_CAP__CRS_SOFTWARE_VISIBILITY_MASK                                                0x0001L
//BIF_CFG_DEV1_RC_ROOT_STATUS
#define BIF_CFG_DEV1_RC_ROOT_STATUS__PME_REQUESTOR_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC_ROOT_STATUS__PME_STATUS__SHIFT                                                        0x10
#define BIF_CFG_DEV1_RC_ROOT_STATUS__PME_PENDING__SHIFT                                                       0x11
#define BIF_CFG_DEV1_RC_ROOT_STATUS__PME_REQUESTOR_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV1_RC_ROOT_STATUS__PME_STATUS_MASK                                                          0x00010000L
#define BIF_CFG_DEV1_RC_ROOT_STATUS__PME_PENDING_MASK                                                         0x00020000L
//BIF_CFG_DEV1_RC_DEVICE_CAP2
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                       0x0
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                         0x4
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                          0x5
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                        0x6
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                        0x7
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                        0x8
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                            0x9
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                         0xa
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                     0xb
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                                0xc
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__LN_SYSTEM_CLS__SHIFT                                                     0xe
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED__SHIFT                                   0x10
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED__SHIFT                                   0x11
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                    0x12
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                      0x14
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                      0x15
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                          0x16
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED__SHIFT                                    0x18
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ__SHIFT                                     0x1a
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__FRS_SUPPORTED__SHIFT                                                     0x1f
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                         0x0000000FL
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                           0x00000010L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                            0x00000020L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                          0x00000040L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                          0x00000080L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                          0x00000100L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                              0x00000200L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                           0x00000400L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                       0x00000800L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                                  0x00003000L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__LN_SYSTEM_CLS_MASK                                                       0x0000C000L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED_MASK                                     0x00010000L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED_MASK                                     0x00020000L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                      0x000C0000L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                        0x00100000L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                        0x00200000L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                            0x00C00000L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED_MASK                                      0x03000000L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ_MASK                                       0x04000000L
#define BIF_CFG_DEV1_RC_DEVICE_CAP2__FRS_SUPPORTED_MASK                                                       0x80000000L
//BIF_CFG_DEV1_RC_DEVICE_CNTL2
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                                0x0
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                                  0x4
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                                0x5
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                              0x6
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                         0x7
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                               0x8
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                            0x9
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__LTR_EN__SHIFT                                                           0xa
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST__SHIFT                                     0xb
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE__SHIFT                                     0xc
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__OBFF_EN__SHIFT                                                          0xd
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                      0xf
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                                  0x000FL
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                    0x0010L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                                  0x0020L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                                0x0040L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                           0x0080L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                                 0x0100L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                              0x0200L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__LTR_EN_MASK                                                             0x0400L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST_MASK                                       0x0800L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE_MASK                                       0x1000L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__OBFF_EN_MASK                                                            0x6000L
#define BIF_CFG_DEV1_RC_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                        0x8000L
//BIF_CFG_DEV1_RC_DEVICE_STATUS2
#define BIF_CFG_DEV1_RC_DEVICE_STATUS2__RESERVED__SHIFT                                                       0x0
#define BIF_CFG_DEV1_RC_DEVICE_STATUS2__RESERVED_MASK                                                         0xFFFFL
//BIF_CFG_DEV1_RC_LINK_CAP2
#define BIF_CFG_DEV1_RC_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                                0x1
#define BIF_CFG_DEV1_RC_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                                 0x8
#define BIF_CFG_DEV1_RC_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT__SHIFT                                            0x9
#define BIF_CFG_DEV1_RC_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT__SHIFT                                            0x10
#define BIF_CFG_DEV1_RC_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT__SHIFT                                           0x17
#define BIF_CFG_DEV1_RC_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT__SHIFT                                           0x18
#define BIF_CFG_DEV1_RC_LINK_CAP2__DRS_SUPPORTED__SHIFT                                                       0x1f
#define BIF_CFG_DEV1_RC_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                                  0x000000FEL
#define BIF_CFG_DEV1_RC_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                                   0x00000100L
#define BIF_CFG_DEV1_RC_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT_MASK                                              0x0000FE00L
#define BIF_CFG_DEV1_RC_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT_MASK                                              0x007F0000L
#define BIF_CFG_DEV1_RC_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT_MASK                                             0x00800000L
#define BIF_CFG_DEV1_RC_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT_MASK                                             0x01000000L
#define BIF_CFG_DEV1_RC_LINK_CAP2__DRS_SUPPORTED_MASK                                                         0x80000000L
//BIF_CFG_DEV1_RC_LINK_CNTL2
#define BIF_CFG_DEV1_RC_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                                   0x4
#define BIF_CFG_DEV1_RC_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                        0x5
#define BIF_CFG_DEV1_RC_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                              0x6
#define BIF_CFG_DEV1_RC_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                        0x7
#define BIF_CFG_DEV1_RC_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                               0xa
#define BIF_CFG_DEV1_RC_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                     0xb
#define BIF_CFG_DEV1_RC_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                              0xc
#define BIF_CFG_DEV1_RC_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                    0x000FL
#define BIF_CFG_DEV1_RC_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                     0x0010L
#define BIF_CFG_DEV1_RC_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                          0x0020L
#define BIF_CFG_DEV1_RC_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                                0x0040L
#define BIF_CFG_DEV1_RC_LINK_CNTL2__XMIT_MARGIN_MASK                                                          0x0380L
#define BIF_CFG_DEV1_RC_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                                 0x0400L
#define BIF_CFG_DEV1_RC_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                       0x0800L
#define BIF_CFG_DEV1_RC_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                                0xF000L
//BIF_CFG_DEV1_RC_LINK_STATUS2
#define BIF_CFG_DEV1_RC_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                             0x0
#define BIF_CFG_DEV1_RC_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT__SHIFT                                        0x1
#define BIF_CFG_DEV1_RC_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT__SHIFT                                  0x2
#define BIF_CFG_DEV1_RC_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT__SHIFT                                  0x3
#define BIF_CFG_DEV1_RC_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT__SHIFT                                  0x4
#define BIF_CFG_DEV1_RC_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT__SHIFT                                    0x5
#define BIF_CFG_DEV1_RC_LINK_STATUS2__RTM1_PRESENCE_DET__SHIFT                                                0x6
#define BIF_CFG_DEV1_RC_LINK_STATUS2__RTM2_PRESENCE_DET__SHIFT                                                0x7
#define BIF_CFG_DEV1_RC_LINK_STATUS2__CROSSLINK_RESOLUTION__SHIFT                                             0x8
#define BIF_CFG_DEV1_RC_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE__SHIFT                                    0xc
#define BIF_CFG_DEV1_RC_LINK_STATUS2__DRS_MESSAGE_RECEIVED__SHIFT                                             0xf
#define BIF_CFG_DEV1_RC_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                               0x0001L
#define BIF_CFG_DEV1_RC_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT_MASK                                          0x0002L
#define BIF_CFG_DEV1_RC_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT_MASK                                    0x0004L
#define BIF_CFG_DEV1_RC_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT_MASK                                    0x0008L
#define BIF_CFG_DEV1_RC_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT_MASK                                    0x0010L
#define BIF_CFG_DEV1_RC_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT_MASK                                      0x0020L
#define BIF_CFG_DEV1_RC_LINK_STATUS2__RTM1_PRESENCE_DET_MASK                                                  0x0040L
#define BIF_CFG_DEV1_RC_LINK_STATUS2__RTM2_PRESENCE_DET_MASK                                                  0x0080L
#define BIF_CFG_DEV1_RC_LINK_STATUS2__CROSSLINK_RESOLUTION_MASK                                               0x0300L
#define BIF_CFG_DEV1_RC_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE_MASK                                      0x7000L
#define BIF_CFG_DEV1_RC_LINK_STATUS2__DRS_MESSAGE_RECEIVED_MASK                                               0x8000L
//BIF_CFG_DEV1_RC_SLOT_CAP2
#define BIF_CFG_DEV1_RC_SLOT_CAP2__RESERVED__SHIFT                                                            0x0
#define BIF_CFG_DEV1_RC_SLOT_CAP2__RESERVED_MASK                                                              0xFFFFFFFFL
//BIF_CFG_DEV1_RC_SLOT_CNTL2
#define BIF_CFG_DEV1_RC_SLOT_CNTL2__RESERVED__SHIFT                                                           0x0
#define BIF_CFG_DEV1_RC_SLOT_CNTL2__RESERVED_MASK                                                             0xFFFFL
//BIF_CFG_DEV1_RC_SLOT_STATUS2
#define BIF_CFG_DEV1_RC_SLOT_STATUS2__RESERVED__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC_SLOT_STATUS2__RESERVED_MASK                                                           0xFFFFL
//BIF_CFG_DEV1_RC_MSI_CAP_LIST
#define BIF_CFG_DEV1_RC_MSI_CAP_LIST__CAP_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV1_RC_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                         0x8
#define BIF_CFG_DEV1_RC_MSI_CAP_LIST__CAP_ID_MASK                                                             0x00FFL
#define BIF_CFG_DEV1_RC_MSI_CAP_LIST__NEXT_PTR_MASK                                                           0xFF00L
//BIF_CFG_DEV1_RC_MSI_MSG_CNTL
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_EN__SHIFT                                                           0x0
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                    0x1
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                     0x4
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                        0x7
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                        0x8
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP__SHIFT                                             0x9
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN__SHIFT                                              0xa
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_EN_MASK                                                             0x0001L
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                      0x000EL
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                       0x0070L
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_64BIT_MASK                                                          0x0080L
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                          0x0100L
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP_MASK                                               0x0200L
#define BIF_CFG_DEV1_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN_MASK                                                0x0400L
//BIF_CFG_DEV1_RC_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV1_RC_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                               0x2
#define BIF_CFG_DEV1_RC_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                                 0xFFFFFFFCL
//BIF_CFG_DEV1_RC_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV1_RC_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV1_RC_MSI_MSG_DATA
#define BIF_CFG_DEV1_RC_MSI_MSG_DATA__MSI_DATA__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC_MSI_MSG_DATA__MSI_DATA_MASK                                                           0xFFFFL
//BIF_CFG_DEV1_RC_MSI_EXT_MSG_DATA
#define BIF_CFG_DEV1_RC_MSI_EXT_MSG_DATA__MSI_EXT_DATA__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC_MSI_EXT_MSG_DATA__MSI_EXT_DATA_MASK                                                   0xFFFFL
//BIF_CFG_DEV1_RC_MSI_MSG_DATA_64
#define BIF_CFG_DEV1_RC_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                                   0x0
#define BIF_CFG_DEV1_RC_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                     0xFFFFL
//BIF_CFG_DEV1_RC_MSI_EXT_MSG_DATA_64
#define BIF_CFG_DEV1_RC_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64_MASK                                             0xFFFFL
//BIF_CFG_DEV1_RC_SSID_CAP_LIST
#define BIF_CFG_DEV1_RC_SSID_CAP_LIST__CAP_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC_SSID_CAP_LIST__NEXT_PTR__SHIFT                                                        0x8
#define BIF_CFG_DEV1_RC_SSID_CAP_LIST__CAP_ID_MASK                                                            0x00FFL
#define BIF_CFG_DEV1_RC_SSID_CAP_LIST__NEXT_PTR_MASK                                                          0xFF00L
//BIF_CFG_DEV1_RC_SSID_CAP
#define BIF_CFG_DEV1_RC_SSID_CAP__SUBSYSTEM_VENDOR_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC_SSID_CAP__SUBSYSTEM_ID__SHIFT                                                         0x10
#define BIF_CFG_DEV1_RC_SSID_CAP__SUBSYSTEM_VENDOR_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV1_RC_SSID_CAP__SUBSYSTEM_ID_MASK                                                           0xFFFF0000L
//BIF_CFG_DEV1_RC_MSI_MAP_CAP_LIST
#define BIF_CFG_DEV1_RC_MSI_MAP_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV1_RC_MSI_MAP_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV1_RC_MSI_MAP_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV1_RC_MSI_MAP_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV1_RC_MSI_MAP_CAP
#define BIF_CFG_DEV1_RC_MSI_MAP_CAP__EN__SHIFT                                                                0x0
#define BIF_CFG_DEV1_RC_MSI_MAP_CAP__FIXD__SHIFT                                                              0x1
#define BIF_CFG_DEV1_RC_MSI_MAP_CAP__CAP_TYPE__SHIFT                                                          0xb
#define BIF_CFG_DEV1_RC_MSI_MAP_CAP__EN_MASK                                                                  0x0001L
#define BIF_CFG_DEV1_RC_MSI_MAP_CAP__FIXD_MASK                                                                0x0002L
#define BIF_CFG_DEV1_RC_MSI_MAP_CAP__CAP_TYPE_MASK                                                            0xF800L
//BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                      0x0
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                     0x10
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                    0x14
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                        0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                       0x000F0000L
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                      0xFFF00000L
//BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                             0x10
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                          0x14
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                               0x000F0000L
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                            0xFFF00000L
//BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                                   0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                                   0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_VC_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT                                                   0x0
#define BIF_CFG_DEV1_RC_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT                                                  0x10
#define BIF_CFG_DEV1_RC_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                 0x14
#define BIF_CFG_DEV1_RC_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK                                                     0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK                                                    0x000F0000L
#define BIF_CFG_DEV1_RC_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK                                                   0xFFF00000L
//BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG1
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT                               0x4
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT                                                 0x8
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT                               0xa
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK                                              0x00000007L
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK                                 0x00000070L
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK                                                   0x00000300L
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK                                 0x00000C00L
//BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG2
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT                                     0x18
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK                                                0x000000FFL
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK                                       0xFF000000L
//BIF_CFG_DEV1_RC_PCIE_PORT_VC_CNTL
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT                                               0x1
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK                                             0x0001L
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK                                                 0x000EL
//BIF_CFG_DEV1_RC_PCIE_PORT_VC_STATUS
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT                                       0x0
#define BIF_CFG_DEV1_RC_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK                                         0x0001L
//BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CAP
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                      0xf
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                          0x10
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                   0x18
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK                                              0x000000FFL
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                        0x00008000L
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                            0x007F0000L
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                     0xFF000000L
//BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                          0x0
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                        0x1
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                    0x10
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                        0x11
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT                                                  0x18
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT                                              0x1f
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                            0x00000001L
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                          0x000000FEL
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                      0x00010000L
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                          0x000E0000L
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK                                                    0x07000000L
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK                                                0x80000000L
//BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_STATUS
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                                0x0
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                               0x1
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                  0x0001L
#define BIF_CFG_DEV1_RC_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                 0x0002L
//BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CAP
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                      0xf
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                          0x10
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                   0x18
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK                                              0x000000FFL
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                        0x00008000L
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                            0x003F0000L
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                     0xFF000000L
//BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                          0x0
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                        0x1
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                    0x10
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                        0x11
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT                                                  0x18
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT                                              0x1f
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                            0x00000001L
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                          0x000000FEL
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                      0x00010000L
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                          0x000E0000L
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK                                                    0x07000000L
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK                                                0x80000000L
//BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_STATUS
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                                0x0
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                               0x1
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                  0x0001L
#define BIF_CFG_DEV1_RC_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                 0x0002L
//BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT                                       0x0
#define BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT                                      0x10
#define BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT                                     0x14
#define BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK                                         0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK                                        0x000F0000L
#define BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK                                       0xFFF00000L
//BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_DW1
#define BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT                                      0x0
#define BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_DW2
#define BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT                                      0x0
#define BIF_CFG_DEV1_RC_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                          0x0
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                         0x10
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                        0x14
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                           0x000F0000L
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                          0xFFF00000L
//BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                         0x4
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                      0x5
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                         0xc
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                          0xd
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                     0xe
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                                   0xf
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                       0x10
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                        0x11
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                         0x12
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                        0x13
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                                  0x14
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                                   0x15
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                                  0x16
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                                  0x17
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                         0x18
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                          0x19
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS__SHIFT                     0x1a
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                           0x00000010L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                        0x00000020L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                           0x00001000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                            0x00002000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                       0x00004000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                     0x00008000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                         0x00010000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                          0x00020000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                           0x00040000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                          0x00080000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                    0x00100000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                     0x00200000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                    0x00400000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                    0x00800000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                           0x01000000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                            0x02000000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS_MASK                       0x04000000L
//BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                             0x4
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                          0x5
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                             0xc
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                              0xd
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                         0xe
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                           0x10
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                            0x11
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                             0x12
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                            0x13
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                      0x14
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                       0x15
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                      0x16
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                      0x17
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                             0x18
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                              0x19
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__POISONED_TLP_EGRESS_BLOCKED_MASK__SHIFT                         0x1a
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                               0x00000010L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                            0x00000020L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                               0x00001000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                                0x00002000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                           0x00004000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                         0x00008000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                             0x00010000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                              0x00020000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                               0x00040000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                              0x00080000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                        0x00100000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                         0x00200000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                        0x00400000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                        0x00800000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                               0x01000000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                                0x02000000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_MASK__POISONED_TLP_EGRESS_BLOCKED_MASK_MASK                           0x04000000L
//BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                     0x4
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                                  0x5
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                     0xc
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                      0xd
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                                 0xe
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                               0xf
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                                   0x10
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                    0x11
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                     0x12
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                    0x13
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                              0x14
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                               0x15
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                              0x16
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                              0x17
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                     0x18
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                      0x19
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__POISONED_TLP_EGRESS_BLOCKED_SEVERITY__SHIFT                 0x1a
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                       0x00000010L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                    0x00000020L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                       0x00001000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                        0x00002000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                                   0x00004000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                                 0x00008000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                     0x00010000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                      0x00020000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                       0x00040000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                      0x00080000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                                0x00100000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                                 0x00200000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                                0x00400000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                                0x00800000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                       0x01000000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                        0x02000000L
#define BIF_CFG_DEV1_RC_PCIE_UNCORR_ERR_SEVERITY__POISONED_TLP_EGRESS_BLOCKED_SEVERITY_MASK                   0x04000000L
//BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                           0x6
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                          0x7
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                               0x8
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                              0xc
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                             0xd
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                      0xe
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                             0x00000001L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                             0x00000040L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                            0x00000080L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                                 0x00000100L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                                0x00001000L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                               0x00002000L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                        0x00004000L
//BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                               0x6
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                              0x7
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                                   0x8
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                                  0xc
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                                 0xd
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                          0xe
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                                 0x00000001L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                                 0x00000040L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                                0x00000080L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                     0x00000100L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                    0x00001000L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                                   0x00002000L
#define BIF_CFG_DEV1_RC_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                            0x00004000L
//BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                            0x5
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                             0x6
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                          0x7
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                           0x8
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                      0x9
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                       0xa
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                             0x0000001FL
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                              0x00000020L
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                               0x00000040L
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                            0x00000080L
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                             0x00000100L
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                        0x00000200L
#define BIF_CFG_DEV1_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                         0x00000400L
//BIF_CFG_DEV1_RC_PCIE_HDR_LOG0
#define BIF_CFG_DEV1_RC_PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC_PCIE_HDR_LOG0__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_HDR_LOG1
#define BIF_CFG_DEV1_RC_PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC_PCIE_HDR_LOG1__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_HDR_LOG2
#define BIF_CFG_DEV1_RC_PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC_PCIE_HDR_LOG2__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_HDR_LOG3
#define BIF_CFG_DEV1_RC_PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC_PCIE_HDR_LOG3__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_CMD
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN__SHIFT                                             0x0
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN__SHIFT                                         0x1
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN__SHIFT                                            0x2
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN_MASK                                               0x00000001L
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN_MASK                                           0x00000002L
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN_MASK                                              0x00000004L
//BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD__SHIFT                                       0x1
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD__SHIFT                                  0x2
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD__SHIFT                             0x3
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL__SHIFT                                0x4
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD__SHIFT                                  0x5
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD__SHIFT                                     0x6
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM__SHIFT                                      0x1b
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD_MASK                                              0x00000001L
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD_MASK                                         0x00000002L
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD_MASK                                    0x00000004L
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD_MASK                               0x00000008L
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL_MASK                                  0x00000010L
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD_MASK                                    0x00000020L
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD_MASK                                       0x00000040L
#define BIF_CFG_DEV1_RC_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM_MASK                                        0xF8000000L
//BIF_CFG_DEV1_RC_PCIE_ERR_SRC_ID
#define BIF_CFG_DEV1_RC_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID__SHIFT                                     0x10
#define BIF_CFG_DEV1_RC_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID_MASK                                                 0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID_MASK                                       0xFFFF0000L
//BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG0
#define BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG1
#define BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG2
#define BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG3
#define BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV1_RC_PCIE_SECONDARY_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT                                           0x10
#define BIF_CFG_DEV1_RC_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT                                          0x14
#define BIF_CFG_DEV1_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK                                             0x000F0000L
#define BIF_CFG_DEV1_RC_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK                                            0xFFF00000L
//BIF_CFG_DEV1_RC_PCIE_LINK_CNTL3
#define BIF_CFG_DEV1_RC_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT                                          0x0
#define BIF_CFG_DEV1_RC_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT                                  0x1
#define BIF_CFG_DEV1_RC_PCIE_LINK_CNTL3__ENABLE_LOWER_SKP_OS_GEN__SHIFT                                       0x9
#define BIF_CFG_DEV1_RC_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK                                            0x00000001L
#define BIF_CFG_DEV1_RC_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK                                    0x00000002L
#define BIF_CFG_DEV1_RC_PCIE_LINK_CNTL3__ENABLE_LOWER_SKP_OS_GEN_MASK                                         0x0000FE00L
//BIF_CFG_DEV1_RC_PCIE_LANE_ERROR_STATUS
#define BIF_CFG_DEV1_RC_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT                                 0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK                                   0x0000FFFFL
//BIF_CFG_DEV1_RC_PCIE_LANE_0_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_1_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_2_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_3_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_4_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_5_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_6_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_7_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_8_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_9_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_10_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_11_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_12_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_13_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_14_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV1_RC_PCIE_LANE_15_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV1_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV1_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV1_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV1_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV1_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV1_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV1_RC_PCIE_ACS_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                                 0x10
#define BIF_CFG_DEV1_RC_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                0x14
#define BIF_CFG_DEV1_RC_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                                   0x000F0000L
#define BIF_CFG_DEV1_RC_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                                  0xFFF00000L
//BIF_CFG_DEV1_RC_PCIE_ACS_CAP
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                                0x0
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                             0x1
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                             0x2
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                          0x3
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                              0x4
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                               0x5
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                            0x6
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                       0x8
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                                  0x0001L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                               0x0002L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                               0x0004L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                            0x0008L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                                0x0010L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                                 0x0020L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                              0x0040L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                         0xFF00L
//BIF_CFG_DEV1_RC_PCIE_ACS_CNTL
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                         0x1
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                         0x2
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                      0x3
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                          0x4
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                           0x5
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                        0x6
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                              0x0001L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                           0x0002L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                           0x0004L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                        0x0008L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                            0x0010L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                             0x0020L
#define BIF_CFG_DEV1_RC_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                          0x0040L
//BIF_CFG_DEV1_RC_PCIE_DLF_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC_PCIE_DLF_ENH_CAP_LIST__CAP_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC_PCIE_DLF_ENH_CAP_LIST__CAP_VER__SHIFT                                                 0x10
#define BIF_CFG_DEV1_RC_PCIE_DLF_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                0x14
#define BIF_CFG_DEV1_RC_PCIE_DLF_ENH_CAP_LIST__CAP_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_DLF_ENH_CAP_LIST__CAP_VER_MASK                                                   0x000F0000L
#define BIF_CFG_DEV1_RC_PCIE_DLF_ENH_CAP_LIST__NEXT_PTR_MASK                                                  0xFFF00000L
//BIF_CFG_DEV1_RC_DATA_LINK_FEATURE_CAP
#define BIF_CFG_DEV1_RC_DATA_LINK_FEATURE_CAP__LOCAL_DLF_SUPPORTED__SHIFT                                     0x0
#define BIF_CFG_DEV1_RC_DATA_LINK_FEATURE_CAP__DLF_EXCHANGE_ENABLE__SHIFT                                     0x1f
#define BIF_CFG_DEV1_RC_DATA_LINK_FEATURE_CAP__LOCAL_DLF_SUPPORTED_MASK                                       0x007FFFFFL
#define BIF_CFG_DEV1_RC_DATA_LINK_FEATURE_CAP__DLF_EXCHANGE_ENABLE_MASK                                       0x80000000L
//BIF_CFG_DEV1_RC_DATA_LINK_FEATURE_STATUS
#define BIF_CFG_DEV1_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED__SHIFT                                 0x0
#define BIF_CFG_DEV1_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_VALID__SHIFT                           0x1f
#define BIF_CFG_DEV1_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_MASK                                   0x007FFFFFL
#define BIF_CFG_DEV1_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_VALID_MASK                             0x80000000L
//BIF_CFG_DEV1_RC_PCIE_PHY_16GT_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_ID__SHIFT                                             0x0
#define BIF_CFG_DEV1_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_VER__SHIFT                                            0x10
#define BIF_CFG_DEV1_RC_PCIE_PHY_16GT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                           0x14
#define BIF_CFG_DEV1_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_ID_MASK                                               0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_VER_MASK                                              0x000F0000L
#define BIF_CFG_DEV1_RC_PCIE_PHY_16GT_ENH_CAP_LIST__NEXT_PTR_MASK                                             0xFFF00000L
//BIF_CFG_DEV1_RC_LINK_CAP_16GT
#define BIF_CFG_DEV1_RC_LINK_CAP_16GT__RESERVED__SHIFT                                                        0x0
#define BIF_CFG_DEV1_RC_LINK_CAP_16GT__RESERVED_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV1_RC_LINK_CNTL_16GT
#define BIF_CFG_DEV1_RC_LINK_CNTL_16GT__RESERVED__SHIFT                                                       0x0
#define BIF_CFG_DEV1_RC_LINK_CNTL_16GT__RESERVED_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV1_RC_LINK_STATUS_16GT
#define BIF_CFG_DEV1_RC_LINK_STATUS_16GT__EQUALIZATION_COMPLETE_16GT__SHIFT                                   0x0
#define BIF_CFG_DEV1_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE1_SUCCESS_16GT__SHIFT                             0x1
#define BIF_CFG_DEV1_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE2_SUCCESS_16GT__SHIFT                             0x2
#define BIF_CFG_DEV1_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE3_SUCCESS_16GT__SHIFT                             0x3
#define BIF_CFG_DEV1_RC_LINK_STATUS_16GT__LINK_EQUALIZATION_REQUEST_16GT__SHIFT                               0x4
#define BIF_CFG_DEV1_RC_LINK_STATUS_16GT__EQUALIZATION_COMPLETE_16GT_MASK                                     0x00000001L
#define BIF_CFG_DEV1_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE1_SUCCESS_16GT_MASK                               0x00000002L
#define BIF_CFG_DEV1_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE2_SUCCESS_16GT_MASK                               0x00000004L
#define BIF_CFG_DEV1_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE3_SUCCESS_16GT_MASK                               0x00000008L
#define BIF_CFG_DEV1_RC_LINK_STATUS_16GT__LINK_EQUALIZATION_REQUEST_16GT_MASK                                 0x00000010L
//BIF_CFG_DEV1_RC_LOCAL_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV1_RC_LOCAL_PARITY_MISMATCH_STATUS_16GT__LOCAL_PARITY_MISMATCH_STATUS_BITS__SHIFT           0x0
#define BIF_CFG_DEV1_RC_LOCAL_PARITY_MISMATCH_STATUS_16GT__LOCAL_PARITY_MISMATCH_STATUS_BITS_MASK             0x0000FFFFL
//BIF_CFG_DEV1_RC_RTM1_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV1_RC_RTM1_PARITY_MISMATCH_STATUS_16GT__RTM1_PARITY_MISMATCH_STATUS_BITS__SHIFT             0x0
#define BIF_CFG_DEV1_RC_RTM1_PARITY_MISMATCH_STATUS_16GT__RTM1_PARITY_MISMATCH_STATUS_BITS_MASK               0x0000FFFFL
//BIF_CFG_DEV1_RC_RTM2_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV1_RC_RTM2_PARITY_MISMATCH_STATUS_16GT__RTM2_PARITY_MISMATCH_STATUS_BITS__SHIFT             0x0
#define BIF_CFG_DEV1_RC_RTM2_PARITY_MISMATCH_STATUS_16GT__RTM2_PARITY_MISMATCH_STATUS_BITS_MASK               0x0000FFFFL
//BIF_CFG_DEV1_RC_LANE_0_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV1_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV1_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV1_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV1_RC_LANE_1_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV1_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV1_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV1_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV1_RC_LANE_2_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV1_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV1_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV1_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV1_RC_LANE_3_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV1_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV1_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV1_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV1_RC_LANE_4_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV1_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV1_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV1_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV1_RC_LANE_5_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV1_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV1_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV1_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV1_RC_LANE_6_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV1_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV1_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV1_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV1_RC_LANE_7_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV1_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV1_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV1_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV1_RC_LANE_8_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV1_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV1_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV1_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV1_RC_LANE_9_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV1_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV1_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV1_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV1_RC_LANE_10_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV1_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV1_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV1_RC_LANE_11_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV1_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV1_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV1_RC_LANE_12_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV1_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV1_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV1_RC_LANE_13_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV1_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV1_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV1_RC_LANE_14_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV1_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV1_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV1_RC_LANE_15_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV1_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV1_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV1_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV1_RC_PCIE_MARGINING_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_ID__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_VER__SHIFT                                           0x10
#define BIF_CFG_DEV1_RC_PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR__SHIFT                                          0x14
#define BIF_CFG_DEV1_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_VER_MASK                                             0x000F0000L
#define BIF_CFG_DEV1_RC_PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR_MASK                                            0xFFF00000L
//BIF_CFG_DEV1_RC_MARGINING_PORT_CAP
#define BIF_CFG_DEV1_RC_MARGINING_PORT_CAP__MARGINING_USES_SOFTWARE__SHIFT                                    0x0
#define BIF_CFG_DEV1_RC_MARGINING_PORT_CAP__MARGINING_USES_SOFTWARE_MASK                                      0x0001L
//BIF_CFG_DEV1_RC_MARGINING_PORT_STATUS
#define BIF_CFG_DEV1_RC_MARGINING_PORT_STATUS__MARGINING_READY__SHIFT                                         0x0
#define BIF_CFG_DEV1_RC_MARGINING_PORT_STATUS__MARGINING_SOFTWARE_READY__SHIFT                                0x1
#define BIF_CFG_DEV1_RC_MARGINING_PORT_STATUS__MARGINING_READY_MASK                                           0x0001L
#define BIF_CFG_DEV1_RC_MARGINING_PORT_STATUS__MARGINING_SOFTWARE_READY_MASK                                  0x0002L
//BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV1_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV1_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV1_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV1_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV1_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV1_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV1_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV1_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV1_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV1_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV1_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV1_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV1_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV1_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV1_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_CNTL
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_STATUS
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV1_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV1_RC_PCIE_RTR_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC_PCIE_RTR_ENH_CAP_LIST__CAP_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC_PCIE_RTR_ENH_CAP_LIST__CAP_VER__SHIFT                                                 0x10
#define BIF_CFG_DEV1_RC_PCIE_RTR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                0x14
#define BIF_CFG_DEV1_RC_PCIE_RTR_ENH_CAP_LIST__CAP_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV1_RC_PCIE_RTR_ENH_CAP_LIST__CAP_VER_MASK                                                   0x000F0000L
#define BIF_CFG_DEV1_RC_PCIE_RTR_ENH_CAP_LIST__NEXT_PTR_MASK                                                  0xFFF00000L
//BIF_CFG_DEV1_RC_RTR_DATA1
#define BIF_CFG_DEV1_RC_RTR_DATA1__RESET_TIME__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC_RTR_DATA1__DLUP_TIME__SHIFT                                                           0xc
#define BIF_CFG_DEV1_RC_RTR_DATA1__VALID__SHIFT                                                               0x1f
#define BIF_CFG_DEV1_RC_RTR_DATA1__RESET_TIME_MASK                                                            0x00000FFFL
#define BIF_CFG_DEV1_RC_RTR_DATA1__DLUP_TIME_MASK                                                             0x00FFF000L
#define BIF_CFG_DEV1_RC_RTR_DATA1__VALID_MASK                                                                 0x80000000L
//BIF_CFG_DEV1_RC_RTR_DATA2
#define BIF_CFG_DEV1_RC_RTR_DATA2__FLR_TIME__SHIFT                                                            0x0
#define BIF_CFG_DEV1_RC_RTR_DATA2__D3HOTD0_TIME__SHIFT                                                        0xc
#define BIF_CFG_DEV1_RC_RTR_DATA2__FLR_TIME_MASK                                                              0x00000FFFL
#define BIF_CFG_DEV1_RC_RTR_DATA2__D3HOTD0_TIME_MASK                                                          0x00FFF000L


// addressBlock: nbio_nbif0_bif_cfg_dev2_rc_bifcfgdecp
//BIF_CFG_DEV2_RC_VENDOR_ID
#define BIF_CFG_DEV2_RC_VENDOR_ID__VENDOR_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV2_RC_VENDOR_ID__VENDOR_ID_MASK                                                             0xFFFFL
//BIF_CFG_DEV2_RC_DEVICE_ID
#define BIF_CFG_DEV2_RC_DEVICE_ID__DEVICE_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV2_RC_DEVICE_ID__DEVICE_ID_MASK                                                             0xFFFFL
//BIF_CFG_DEV2_RC_COMMAND
#define BIF_CFG_DEV2_RC_COMMAND__IOEN_DN__SHIFT                                                               0x0
#define BIF_CFG_DEV2_RC_COMMAND__MEMEN_DN__SHIFT                                                              0x1
#define BIF_CFG_DEV2_RC_COMMAND__BUS_MASTER_EN__SHIFT                                                         0x2
#define BIF_CFG_DEV2_RC_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                      0x3
#define BIF_CFG_DEV2_RC_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                               0x4
#define BIF_CFG_DEV2_RC_COMMAND__PAL_SNOOP_EN__SHIFT                                                          0x5
#define BIF_CFG_DEV2_RC_COMMAND__AD_STEPPING__SHIFT                                                           0x7
#define BIF_CFG_DEV2_RC_COMMAND__SERR_EN__SHIFT                                                               0x8
#define BIF_CFG_DEV2_RC_COMMAND__FAST_B2B_EN__SHIFT                                                           0x9
#define BIF_CFG_DEV2_RC_COMMAND__INT_DIS__SHIFT                                                               0xa
#define BIF_CFG_DEV2_RC_COMMAND__IOEN_DN_MASK                                                                 0x0001L
#define BIF_CFG_DEV2_RC_COMMAND__MEMEN_DN_MASK                                                                0x0002L
#define BIF_CFG_DEV2_RC_COMMAND__BUS_MASTER_EN_MASK                                                           0x0004L
#define BIF_CFG_DEV2_RC_COMMAND__SPECIAL_CYCLE_EN_MASK                                                        0x0008L
#define BIF_CFG_DEV2_RC_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                                 0x0010L
#define BIF_CFG_DEV2_RC_COMMAND__PAL_SNOOP_EN_MASK                                                            0x0020L
#define BIF_CFG_DEV2_RC_COMMAND__AD_STEPPING_MASK                                                             0x0080L
#define BIF_CFG_DEV2_RC_COMMAND__SERR_EN_MASK                                                                 0x0100L
#define BIF_CFG_DEV2_RC_COMMAND__FAST_B2B_EN_MASK                                                             0x0200L
#define BIF_CFG_DEV2_RC_COMMAND__INT_DIS_MASK                                                                 0x0400L
//BIF_CFG_DEV2_RC_STATUS
#define BIF_CFG_DEV2_RC_STATUS__IMMEDIATE_READINESS__SHIFT                                                    0x0
#define BIF_CFG_DEV2_RC_STATUS__INT_STATUS__SHIFT                                                             0x3
#define BIF_CFG_DEV2_RC_STATUS__CAP_LIST__SHIFT                                                               0x4
#define BIF_CFG_DEV2_RC_STATUS__PCI_66_CAP__SHIFT                                                             0x5
#define BIF_CFG_DEV2_RC_STATUS__FAST_BACK_CAPABLE__SHIFT                                                      0x7
#define BIF_CFG_DEV2_RC_STATUS__DEVSEL_TIMING__SHIFT                                                          0x9
#define BIF_CFG_DEV2_RC_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                    0xb
#define BIF_CFG_DEV2_RC_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                  0xc
#define BIF_CFG_DEV2_RC_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                  0xd
#define BIF_CFG_DEV2_RC_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                                  0xe
#define BIF_CFG_DEV2_RC_STATUS__IMMEDIATE_READINESS_MASK                                                      0x0001L
#define BIF_CFG_DEV2_RC_STATUS__INT_STATUS_MASK                                                               0x0008L
#define BIF_CFG_DEV2_RC_STATUS__CAP_LIST_MASK                                                                 0x0010L
#define BIF_CFG_DEV2_RC_STATUS__PCI_66_CAP_MASK                                                               0x0020L
#define BIF_CFG_DEV2_RC_STATUS__FAST_BACK_CAPABLE_MASK                                                        0x0080L
#define BIF_CFG_DEV2_RC_STATUS__DEVSEL_TIMING_MASK                                                            0x0600L
#define BIF_CFG_DEV2_RC_STATUS__SIGNAL_TARGET_ABORT_MASK                                                      0x0800L
#define BIF_CFG_DEV2_RC_STATUS__RECEIVED_TARGET_ABORT_MASK                                                    0x1000L
#define BIF_CFG_DEV2_RC_STATUS__RECEIVED_MASTER_ABORT_MASK                                                    0x2000L
#define BIF_CFG_DEV2_RC_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                    0x4000L
//BIF_CFG_DEV2_RC_REVISION_ID
#define BIF_CFG_DEV2_RC_REVISION_ID__MINOR_REV_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV2_RC_REVISION_ID__MAJOR_REV_ID__SHIFT                                                      0x4
#define BIF_CFG_DEV2_RC_REVISION_ID__MINOR_REV_ID_MASK                                                        0x0FL
#define BIF_CFG_DEV2_RC_REVISION_ID__MAJOR_REV_ID_MASK                                                        0xF0L
//BIF_CFG_DEV2_RC_PROG_INTERFACE
#define BIF_CFG_DEV2_RC_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                                 0x0
#define BIF_CFG_DEV2_RC_PROG_INTERFACE__PROG_INTERFACE_MASK                                                   0xFFL
//BIF_CFG_DEV2_RC_SUB_CLASS
#define BIF_CFG_DEV2_RC_SUB_CLASS__SUB_CLASS__SHIFT                                                           0x0
#define BIF_CFG_DEV2_RC_SUB_CLASS__SUB_CLASS_MASK                                                             0xFFL
//BIF_CFG_DEV2_RC_BASE_CLASS
#define BIF_CFG_DEV2_RC_BASE_CLASS__BASE_CLASS__SHIFT                                                         0x0
#define BIF_CFG_DEV2_RC_BASE_CLASS__BASE_CLASS_MASK                                                           0xFFL
//BIF_CFG_DEV2_RC_CACHE_LINE
#define BIF_CFG_DEV2_RC_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                    0x0
#define BIF_CFG_DEV2_RC_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                      0xFFL
//BIF_CFG_DEV2_RC_LATENCY
#define BIF_CFG_DEV2_RC_LATENCY__LATENCY_TIMER__SHIFT                                                         0x0
#define BIF_CFG_DEV2_RC_LATENCY__LATENCY_TIMER_MASK                                                           0xFFL
//BIF_CFG_DEV2_RC_HEADER
#define BIF_CFG_DEV2_RC_HEADER__HEADER_TYPE__SHIFT                                                            0x0
#define BIF_CFG_DEV2_RC_HEADER__DEVICE_TYPE__SHIFT                                                            0x7
#define BIF_CFG_DEV2_RC_HEADER__HEADER_TYPE_MASK                                                              0x7FL
#define BIF_CFG_DEV2_RC_HEADER__DEVICE_TYPE_MASK                                                              0x80L
//BIF_CFG_DEV2_RC_BIST
#define BIF_CFG_DEV2_RC_BIST__BIST_COMP__SHIFT                                                                0x0
#define BIF_CFG_DEV2_RC_BIST__BIST_STRT__SHIFT                                                                0x6
#define BIF_CFG_DEV2_RC_BIST__BIST_CAP__SHIFT                                                                 0x7
#define BIF_CFG_DEV2_RC_BIST__BIST_COMP_MASK                                                                  0x0FL
#define BIF_CFG_DEV2_RC_BIST__BIST_STRT_MASK                                                                  0x40L
#define BIF_CFG_DEV2_RC_BIST__BIST_CAP_MASK                                                                   0x80L
//BIF_CFG_DEV2_RC_BASE_ADDR_1
#define BIF_CFG_DEV2_RC_BASE_ADDR_1__BASE_ADDR__SHIFT                                                         0x0
#define BIF_CFG_DEV2_RC_BASE_ADDR_1__BASE_ADDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV2_RC_BASE_ADDR_2
#define BIF_CFG_DEV2_RC_BASE_ADDR_2__BASE_ADDR__SHIFT                                                         0x0
#define BIF_CFG_DEV2_RC_BASE_ADDR_2__BASE_ADDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV2_RC_SUB_BUS_NUMBER_LATENCY
#define BIF_CFG_DEV2_RC_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS__SHIFT                                            0x0
#define BIF_CFG_DEV2_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS__SHIFT                                          0x8
#define BIF_CFG_DEV2_RC_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM__SHIFT                                            0x10
#define BIF_CFG_DEV2_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER__SHIFT                                0x18
#define BIF_CFG_DEV2_RC_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS_MASK                                              0x000000FFL
#define BIF_CFG_DEV2_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS_MASK                                            0x0000FF00L
#define BIF_CFG_DEV2_RC_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM_MASK                                              0x00FF0000L
#define BIF_CFG_DEV2_RC_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER_MASK                                  0xFF000000L
//BIF_CFG_DEV2_RC_IO_BASE_LIMIT
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT__IO_BASE_TYPE__SHIFT                                                    0x0
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT__IO_BASE__SHIFT                                                         0x4
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT__IO_LIMIT_TYPE__SHIFT                                                   0x8
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT__IO_LIMIT__SHIFT                                                        0xc
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT__IO_BASE_TYPE_MASK                                                      0x000FL
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT__IO_BASE_MASK                                                           0x00F0L
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT__IO_LIMIT_TYPE_MASK                                                     0x0F00L
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT__IO_LIMIT_MASK                                                          0xF000L
//BIF_CFG_DEV2_RC_SECONDARY_STATUS
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__PCI_66_CAP__SHIFT                                                   0x5
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__FAST_BACK_CAPABLE__SHIFT                                            0x7
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__DEVSEL_TIMING__SHIFT                                                0x9
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                          0xb
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                        0xc
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                        0xd
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR__SHIFT                                        0xe
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__PCI_66_CAP_MASK                                                     0x0020L
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__FAST_BACK_CAPABLE_MASK                                              0x0080L
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__DEVSEL_TIMING_MASK                                                  0x0600L
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__SIGNAL_TARGET_ABORT_MASK                                            0x0800L
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__RECEIVED_TARGET_ABORT_MASK                                          0x1000L
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__RECEIVED_MASTER_ABORT_MASK                                          0x2000L
#define BIF_CFG_DEV2_RC_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR_MASK                                          0x4000L
//BIF_CFG_DEV2_RC_MEM_BASE_LIMIT
#define BIF_CFG_DEV2_RC_MEM_BASE_LIMIT__MEM_BASE_TYPE__SHIFT                                                  0x0
#define BIF_CFG_DEV2_RC_MEM_BASE_LIMIT__MEM_BASE_31_20__SHIFT                                                 0x4
#define BIF_CFG_DEV2_RC_MEM_BASE_LIMIT__MEM_LIMIT_TYPE__SHIFT                                                 0x10
#define BIF_CFG_DEV2_RC_MEM_BASE_LIMIT__MEM_LIMIT_31_20__SHIFT                                                0x14
#define BIF_CFG_DEV2_RC_MEM_BASE_LIMIT__MEM_BASE_TYPE_MASK                                                    0x0000000FL
#define BIF_CFG_DEV2_RC_MEM_BASE_LIMIT__MEM_BASE_31_20_MASK                                                   0x0000FFF0L
#define BIF_CFG_DEV2_RC_MEM_BASE_LIMIT__MEM_LIMIT_TYPE_MASK                                                   0x000F0000L
#define BIF_CFG_DEV2_RC_MEM_BASE_LIMIT__MEM_LIMIT_31_20_MASK                                                  0xFFF00000L
//BIF_CFG_DEV2_RC_PREF_BASE_LIMIT
#define BIF_CFG_DEV2_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE__SHIFT                                            0x0
#define BIF_CFG_DEV2_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20__SHIFT                                           0x4
#define BIF_CFG_DEV2_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE__SHIFT                                           0x10
#define BIF_CFG_DEV2_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20__SHIFT                                          0x14
#define BIF_CFG_DEV2_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE_MASK                                              0x0000000FL
#define BIF_CFG_DEV2_RC_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20_MASK                                             0x0000FFF0L
#define BIF_CFG_DEV2_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE_MASK                                             0x000F0000L
#define BIF_CFG_DEV2_RC_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20_MASK                                            0xFFF00000L
//BIF_CFG_DEV2_RC_PREF_BASE_UPPER
#define BIF_CFG_DEV2_RC_PREF_BASE_UPPER__PREF_BASE_UPPER__SHIFT                                               0x0
#define BIF_CFG_DEV2_RC_PREF_BASE_UPPER__PREF_BASE_UPPER_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PREF_LIMIT_UPPER
#define BIF_CFG_DEV2_RC_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER__SHIFT                                             0x0
#define BIF_CFG_DEV2_RC_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV2_RC_IO_BASE_LIMIT_HI
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT_HI__IO_BASE_31_16__SHIFT                                                0x0
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT_HI__IO_LIMIT_31_16__SHIFT                                               0x10
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT_HI__IO_BASE_31_16_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV2_RC_IO_BASE_LIMIT_HI__IO_LIMIT_31_16_MASK                                                 0xFFFF0000L
//BIF_CFG_DEV2_RC_CAP_PTR
#define BIF_CFG_DEV2_RC_CAP_PTR__CAP_PTR__SHIFT                                                               0x0
#define BIF_CFG_DEV2_RC_CAP_PTR__CAP_PTR_MASK                                                                 0xFFL
//BIF_CFG_DEV2_RC_ROM_BASE_ADDR
#define BIF_CFG_DEV2_RC_ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV2_RC_ROM_BASE_ADDR__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV2_RC_INTERRUPT_LINE
#define BIF_CFG_DEV2_RC_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                                 0x0
#define BIF_CFG_DEV2_RC_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                                   0xFFL
//BIF_CFG_DEV2_RC_INTERRUPT_PIN
#define BIF_CFG_DEV2_RC_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                                   0x0
#define BIF_CFG_DEV2_RC_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                     0xFFL
//BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN__SHIFT                                            0x0
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__SERR_EN__SHIFT                                                       0x1
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__ISA_EN__SHIFT                                                        0x2
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__VGA_EN__SHIFT                                                        0x3
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__VGA_DEC__SHIFT                                                       0x4
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE__SHIFT                                             0x5
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET__SHIFT                                           0x6
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__FAST_B2B_EN__SHIFT                                                   0x7
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__PRIMARY_DISCARD_TIMER__SHIFT                                         0x8
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__SECONDARY_DISCARD_TIMER__SHIFT                                       0x9
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_STATUS__SHIFT                                          0xa
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_SERR_ENABLE__SHIFT                                     0xb
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN_MASK                                              0x0001L
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__SERR_EN_MASK                                                         0x0002L
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__ISA_EN_MASK                                                          0x0004L
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__VGA_EN_MASK                                                          0x0008L
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__VGA_DEC_MASK                                                         0x0010L
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE_MASK                                               0x0020L
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET_MASK                                             0x0040L
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__FAST_B2B_EN_MASK                                                     0x0080L
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__PRIMARY_DISCARD_TIMER_MASK                                           0x0100L
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__SECONDARY_DISCARD_TIMER_MASK                                         0x0200L
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_STATUS_MASK                                            0x0400L
#define BIF_CFG_DEV2_RC_IRQ_BRIDGE_CNTL__DISCARD_TIMER_SERR_ENABLE_MASK                                       0x0800L
//BIF_CFG_DEV2_RC_EXT_BRIDGE_CNTL
#define BIF_CFG_DEV2_RC_EXT_BRIDGE_CNTL__IO_PORT_80_EN__SHIFT                                                 0x0
#define BIF_CFG_DEV2_RC_EXT_BRIDGE_CNTL__IO_PORT_80_EN_MASK                                                   0x01L
//BIF_CFG_DEV2_RC_PMI_CAP_LIST
#define BIF_CFG_DEV2_RC_PMI_CAP_LIST__CAP_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV2_RC_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                         0x8
#define BIF_CFG_DEV2_RC_PMI_CAP_LIST__CAP_ID_MASK                                                             0x00FFL
#define BIF_CFG_DEV2_RC_PMI_CAP_LIST__NEXT_PTR_MASK                                                           0xFF00L
//BIF_CFG_DEV2_RC_PMI_CAP
#define BIF_CFG_DEV2_RC_PMI_CAP__VERSION__SHIFT                                                               0x0
#define BIF_CFG_DEV2_RC_PMI_CAP__PME_CLOCK__SHIFT                                                             0x3
#define BIF_CFG_DEV2_RC_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0__SHIFT                                   0x4
#define BIF_CFG_DEV2_RC_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                     0x5
#define BIF_CFG_DEV2_RC_PMI_CAP__AUX_CURRENT__SHIFT                                                           0x6
#define BIF_CFG_DEV2_RC_PMI_CAP__D1_SUPPORT__SHIFT                                                            0x9
#define BIF_CFG_DEV2_RC_PMI_CAP__D2_SUPPORT__SHIFT                                                            0xa
#define BIF_CFG_DEV2_RC_PMI_CAP__PME_SUPPORT__SHIFT                                                           0xb
#define BIF_CFG_DEV2_RC_PMI_CAP__VERSION_MASK                                                                 0x0007L
#define BIF_CFG_DEV2_RC_PMI_CAP__PME_CLOCK_MASK                                                               0x0008L
#define BIF_CFG_DEV2_RC_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0_MASK                                     0x0010L
#define BIF_CFG_DEV2_RC_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                       0x0020L
#define BIF_CFG_DEV2_RC_PMI_CAP__AUX_CURRENT_MASK                                                             0x01C0L
#define BIF_CFG_DEV2_RC_PMI_CAP__D1_SUPPORT_MASK                                                              0x0200L
#define BIF_CFG_DEV2_RC_PMI_CAP__D2_SUPPORT_MASK                                                              0x0400L
#define BIF_CFG_DEV2_RC_PMI_CAP__PME_SUPPORT_MASK                                                             0xF800L
//BIF_CFG_DEV2_RC_PMI_STATUS_CNTL
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                                   0x0
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                                 0x3
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__PME_EN__SHIFT                                                        0x8
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                                   0x9
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                    0xd
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                    0xf
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                                 0x16
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                    0x17
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                      0x18
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__POWER_STATE_MASK                                                     0x00000003L
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                                   0x00000008L
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__PME_EN_MASK                                                          0x00000100L
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                     0x00001E00L
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                      0x00006000L
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__PME_STATUS_MASK                                                      0x00008000L
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                                   0x00400000L
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                      0x00800000L
#define BIF_CFG_DEV2_RC_PMI_STATUS_CNTL__PMI_DATA_MASK                                                        0xFF000000L
//BIF_CFG_DEV2_RC_PCIE_CAP_LIST
#define BIF_CFG_DEV2_RC_PCIE_CAP_LIST__CAP_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV2_RC_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                        0x8
#define BIF_CFG_DEV2_RC_PCIE_CAP_LIST__CAP_ID_MASK                                                            0x00FFL
#define BIF_CFG_DEV2_RC_PCIE_CAP_LIST__NEXT_PTR_MASK                                                          0xFF00L
//BIF_CFG_DEV2_RC_PCIE_CAP
#define BIF_CFG_DEV2_RC_PCIE_CAP__VERSION__SHIFT                                                              0x0
#define BIF_CFG_DEV2_RC_PCIE_CAP__DEVICE_TYPE__SHIFT                                                          0x4
#define BIF_CFG_DEV2_RC_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                     0x8
#define BIF_CFG_DEV2_RC_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                      0x9
#define BIF_CFG_DEV2_RC_PCIE_CAP__VERSION_MASK                                                                0x000FL
#define BIF_CFG_DEV2_RC_PCIE_CAP__DEVICE_TYPE_MASK                                                            0x00F0L
#define BIF_CFG_DEV2_RC_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                       0x0100L
#define BIF_CFG_DEV2_RC_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                        0x3E00L
//BIF_CFG_DEV2_RC_DEVICE_CAP
#define BIF_CFG_DEV2_RC_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                                0x0
#define BIF_CFG_DEV2_RC_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                       0x3
#define BIF_CFG_DEV2_RC_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                       0x5
#define BIF_CFG_DEV2_RC_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                             0x6
#define BIF_CFG_DEV2_RC_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                              0x9
#define BIF_CFG_DEV2_RC_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                           0xf
#define BIF_CFG_DEV2_RC_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                        0x1c
#define BIF_CFG_DEV2_RC_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                                  0x00000007L
#define BIF_CFG_DEV2_RC_DEVICE_CAP__PHANTOM_FUNC_MASK                                                         0x00000018L
#define BIF_CFG_DEV2_RC_DEVICE_CAP__EXTENDED_TAG_MASK                                                         0x00000020L
#define BIF_CFG_DEV2_RC_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                               0x000001C0L
#define BIF_CFG_DEV2_RC_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                                0x00000E00L
#define BIF_CFG_DEV2_RC_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                             0x00008000L
#define BIF_CFG_DEV2_RC_DEVICE_CAP__FLR_CAPABLE_MASK                                                          0x10000000L
//BIF_CFG_DEV2_RC_DEVICE_CNTL
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                       0x0
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                                  0x1
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                      0x2
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                     0x3
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                    0x4
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                                  0x5
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                                   0x8
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                                   0x9
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                                   0xa
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                       0xb
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                             0xc
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN__SHIFT                                               0xf
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__CORR_ERR_EN_MASK                                                         0x0001L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                    0x0002L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                        0x0004L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__USR_REPORT_EN_MASK                                                       0x0008L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                      0x0010L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                    0x00E0L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                     0x0100L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                     0x0200L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                     0x0400L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                         0x0800L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                               0x7000L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN_MASK                                                 0x8000L
//BIF_CFG_DEV2_RC_DEVICE_STATUS
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__CORR_ERR__SHIFT                                                        0x0
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                                   0x1
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__FATAL_ERR__SHIFT                                                       0x2
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__USR_DETECTED__SHIFT                                                    0x3
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__AUX_PWR__SHIFT                                                         0x4
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                               0x5
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED__SHIFT                                   0x6
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__CORR_ERR_MASK                                                          0x0001L
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                     0x0002L
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__FATAL_ERR_MASK                                                         0x0004L
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__USR_DETECTED_MASK                                                      0x0008L
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__AUX_PWR_MASK                                                           0x0010L
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                                 0x0020L
#define BIF_CFG_DEV2_RC_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED_MASK                                     0x0040L
//BIF_CFG_DEV2_RC_LINK_CAP
#define BIF_CFG_DEV2_RC_LINK_CAP__LINK_SPEED__SHIFT                                                           0x0
#define BIF_CFG_DEV2_RC_LINK_CAP__LINK_WIDTH__SHIFT                                                           0x4
#define BIF_CFG_DEV2_RC_LINK_CAP__PM_SUPPORT__SHIFT                                                           0xa
#define BIF_CFG_DEV2_RC_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                     0xc
#define BIF_CFG_DEV2_RC_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                      0xf
#define BIF_CFG_DEV2_RC_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                               0x12
#define BIF_CFG_DEV2_RC_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                          0x13
#define BIF_CFG_DEV2_RC_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                          0x14
#define BIF_CFG_DEV2_RC_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                             0x15
#define BIF_CFG_DEV2_RC_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                          0x16
#define BIF_CFG_DEV2_RC_LINK_CAP__PORT_NUMBER__SHIFT                                                          0x18
#define BIF_CFG_DEV2_RC_LINK_CAP__LINK_SPEED_MASK                                                             0x0000000FL
#define BIF_CFG_DEV2_RC_LINK_CAP__LINK_WIDTH_MASK                                                             0x000003F0L
#define BIF_CFG_DEV2_RC_LINK_CAP__PM_SUPPORT_MASK                                                             0x00000C00L
#define BIF_CFG_DEV2_RC_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                       0x00007000L
#define BIF_CFG_DEV2_RC_LINK_CAP__L1_EXIT_LATENCY_MASK                                                        0x00038000L
#define BIF_CFG_DEV2_RC_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                                 0x00040000L
#define BIF_CFG_DEV2_RC_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                            0x00080000L
#define BIF_CFG_DEV2_RC_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                            0x00100000L
#define BIF_CFG_DEV2_RC_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                               0x00200000L
#define BIF_CFG_DEV2_RC_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                            0x00400000L
#define BIF_CFG_DEV2_RC_LINK_CAP__PORT_NUMBER_MASK                                                            0xFF000000L
//BIF_CFG_DEV2_RC_LINK_CNTL
#define BIF_CFG_DEV2_RC_LINK_CNTL__PM_CONTROL__SHIFT                                                          0x0
#define BIF_CFG_DEV2_RC_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B__SHIFT                                        0x2
#define BIF_CFG_DEV2_RC_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                                   0x3
#define BIF_CFG_DEV2_RC_LINK_CNTL__LINK_DIS__SHIFT                                                            0x4
#define BIF_CFG_DEV2_RC_LINK_CNTL__RETRAIN_LINK__SHIFT                                                        0x5
#define BIF_CFG_DEV2_RC_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                    0x6
#define BIF_CFG_DEV2_RC_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                       0x7
#define BIF_CFG_DEV2_RC_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                           0x8
#define BIF_CFG_DEV2_RC_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                         0x9
#define BIF_CFG_DEV2_RC_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                           0xa
#define BIF_CFG_DEV2_RC_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                           0xb
#define BIF_CFG_DEV2_RC_LINK_CNTL__DRS_SIGNALING_CONTROL__SHIFT                                               0xe
#define BIF_CFG_DEV2_RC_LINK_CNTL__PM_CONTROL_MASK                                                            0x0003L
#define BIF_CFG_DEV2_RC_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B_MASK                                          0x0004L
#define BIF_CFG_DEV2_RC_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                     0x0008L
#define BIF_CFG_DEV2_RC_LINK_CNTL__LINK_DIS_MASK                                                              0x0010L
#define BIF_CFG_DEV2_RC_LINK_CNTL__RETRAIN_LINK_MASK                                                          0x0020L
#define BIF_CFG_DEV2_RC_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                      0x0040L
#define BIF_CFG_DEV2_RC_LINK_CNTL__EXTENDED_SYNC_MASK                                                         0x0080L
#define BIF_CFG_DEV2_RC_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                             0x0100L
#define BIF_CFG_DEV2_RC_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                           0x0200L
#define BIF_CFG_DEV2_RC_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                             0x0400L
#define BIF_CFG_DEV2_RC_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                             0x0800L
#define BIF_CFG_DEV2_RC_LINK_CNTL__DRS_SIGNALING_CONTROL_MASK                                                 0xC000L
//BIF_CFG_DEV2_RC_LINK_STATUS
#define BIF_CFG_DEV2_RC_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                                0x0
#define BIF_CFG_DEV2_RC_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                             0x4
#define BIF_CFG_DEV2_RC_LINK_STATUS__LINK_TRAINING__SHIFT                                                     0xb
#define BIF_CFG_DEV2_RC_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                    0xc
#define BIF_CFG_DEV2_RC_LINK_STATUS__DL_ACTIVE__SHIFT                                                         0xd
#define BIF_CFG_DEV2_RC_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                         0xe
#define BIF_CFG_DEV2_RC_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                         0xf
#define BIF_CFG_DEV2_RC_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                                  0x000FL
#define BIF_CFG_DEV2_RC_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                               0x03F0L
#define BIF_CFG_DEV2_RC_LINK_STATUS__LINK_TRAINING_MASK                                                       0x0800L
#define BIF_CFG_DEV2_RC_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                      0x1000L
#define BIF_CFG_DEV2_RC_LINK_STATUS__DL_ACTIVE_MASK                                                           0x2000L
#define BIF_CFG_DEV2_RC_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                           0x4000L
#define BIF_CFG_DEV2_RC_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                           0x8000L
//BIF_CFG_DEV2_RC_SLOT_CAP
#define BIF_CFG_DEV2_RC_SLOT_CAP__ATTN_BUTTON_PRESENT__SHIFT                                                  0x0
#define BIF_CFG_DEV2_RC_SLOT_CAP__PWR_CONTROLLER_PRESENT__SHIFT                                               0x1
#define BIF_CFG_DEV2_RC_SLOT_CAP__MRL_SENSOR_PRESENT__SHIFT                                                   0x2
#define BIF_CFG_DEV2_RC_SLOT_CAP__ATTN_INDICATOR_PRESENT__SHIFT                                               0x3
#define BIF_CFG_DEV2_RC_SLOT_CAP__PWR_INDICATOR_PRESENT__SHIFT                                                0x4
#define BIF_CFG_DEV2_RC_SLOT_CAP__HOTPLUG_SURPRISE__SHIFT                                                     0x5
#define BIF_CFG_DEV2_RC_SLOT_CAP__HOTPLUG_CAPABLE__SHIFT                                                      0x6
#define BIF_CFG_DEV2_RC_SLOT_CAP__SLOT_PWR_LIMIT_VALUE__SHIFT                                                 0x7
#define BIF_CFG_DEV2_RC_SLOT_CAP__SLOT_PWR_LIMIT_SCALE__SHIFT                                                 0xf
#define BIF_CFG_DEV2_RC_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT__SHIFT                                        0x11
#define BIF_CFG_DEV2_RC_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED__SHIFT                                       0x12
#define BIF_CFG_DEV2_RC_SLOT_CAP__PHYSICAL_SLOT_NUM__SHIFT                                                    0x13
#define BIF_CFG_DEV2_RC_SLOT_CAP__ATTN_BUTTON_PRESENT_MASK                                                    0x00000001L
#define BIF_CFG_DEV2_RC_SLOT_CAP__PWR_CONTROLLER_PRESENT_MASK                                                 0x00000002L
#define BIF_CFG_DEV2_RC_SLOT_CAP__MRL_SENSOR_PRESENT_MASK                                                     0x00000004L
#define BIF_CFG_DEV2_RC_SLOT_CAP__ATTN_INDICATOR_PRESENT_MASK                                                 0x00000008L
#define BIF_CFG_DEV2_RC_SLOT_CAP__PWR_INDICATOR_PRESENT_MASK                                                  0x00000010L
#define BIF_CFG_DEV2_RC_SLOT_CAP__HOTPLUG_SURPRISE_MASK                                                       0x00000020L
#define BIF_CFG_DEV2_RC_SLOT_CAP__HOTPLUG_CAPABLE_MASK                                                        0x00000040L
#define BIF_CFG_DEV2_RC_SLOT_CAP__SLOT_PWR_LIMIT_VALUE_MASK                                                   0x00007F80L
#define BIF_CFG_DEV2_RC_SLOT_CAP__SLOT_PWR_LIMIT_SCALE_MASK                                                   0x00018000L
#define BIF_CFG_DEV2_RC_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT_MASK                                          0x00020000L
#define BIF_CFG_DEV2_RC_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED_MASK                                         0x00040000L
#define BIF_CFG_DEV2_RC_SLOT_CAP__PHYSICAL_SLOT_NUM_MASK                                                      0xFFF80000L
//BIF_CFG_DEV2_RC_SLOT_CNTL
#define BIF_CFG_DEV2_RC_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN__SHIFT                                              0x0
#define BIF_CFG_DEV2_RC_SLOT_CNTL__PWR_FAULT_DETECTED_EN__SHIFT                                               0x1
#define BIF_CFG_DEV2_RC_SLOT_CNTL__MRL_SENSOR_CHANGED_EN__SHIFT                                               0x2
#define BIF_CFG_DEV2_RC_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN__SHIFT                                          0x3
#define BIF_CFG_DEV2_RC_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN__SHIFT                                           0x4
#define BIF_CFG_DEV2_RC_SLOT_CNTL__HOTPLUG_INTR_EN__SHIFT                                                     0x5
#define BIF_CFG_DEV2_RC_SLOT_CNTL__ATTN_INDICATOR_CNTL__SHIFT                                                 0x6
#define BIF_CFG_DEV2_RC_SLOT_CNTL__PWR_INDICATOR_CNTL__SHIFT                                                  0x8
#define BIF_CFG_DEV2_RC_SLOT_CNTL__PWR_CONTROLLER_CNTL__SHIFT                                                 0xa
#define BIF_CFG_DEV2_RC_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL__SHIFT                                          0xb
#define BIF_CFG_DEV2_RC_SLOT_CNTL__DL_STATE_CHANGED_EN__SHIFT                                                 0xc
#define BIF_CFG_DEV2_RC_SLOT_CNTL__AUTO_SLOT_PWR_LIMIT_DISABLE__SHIFT                                         0xd
#define BIF_CFG_DEV2_RC_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN_MASK                                                0x0001L
#define BIF_CFG_DEV2_RC_SLOT_CNTL__PWR_FAULT_DETECTED_EN_MASK                                                 0x0002L
#define BIF_CFG_DEV2_RC_SLOT_CNTL__MRL_SENSOR_CHANGED_EN_MASK                                                 0x0004L
#define BIF_CFG_DEV2_RC_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN_MASK                                            0x0008L
#define BIF_CFG_DEV2_RC_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN_MASK                                             0x0010L
#define BIF_CFG_DEV2_RC_SLOT_CNTL__HOTPLUG_INTR_EN_MASK                                                       0x0020L
#define BIF_CFG_DEV2_RC_SLOT_CNTL__ATTN_INDICATOR_CNTL_MASK                                                   0x00C0L
#define BIF_CFG_DEV2_RC_SLOT_CNTL__PWR_INDICATOR_CNTL_MASK                                                    0x0300L
#define BIF_CFG_DEV2_RC_SLOT_CNTL__PWR_CONTROLLER_CNTL_MASK                                                   0x0400L
#define BIF_CFG_DEV2_RC_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL_MASK                                            0x0800L
#define BIF_CFG_DEV2_RC_SLOT_CNTL__DL_STATE_CHANGED_EN_MASK                                                   0x1000L
#define BIF_CFG_DEV2_RC_SLOT_CNTL__AUTO_SLOT_PWR_LIMIT_DISABLE_MASK                                           0x2000L
//BIF_CFG_DEV2_RC_SLOT_STATUS
#define BIF_CFG_DEV2_RC_SLOT_STATUS__ATTN_BUTTON_PRESSED__SHIFT                                               0x0
#define BIF_CFG_DEV2_RC_SLOT_STATUS__PWR_FAULT_DETECTED__SHIFT                                                0x1
#define BIF_CFG_DEV2_RC_SLOT_STATUS__MRL_SENSOR_CHANGED__SHIFT                                                0x2
#define BIF_CFG_DEV2_RC_SLOT_STATUS__PRESENCE_DETECT_CHANGED__SHIFT                                           0x3
#define BIF_CFG_DEV2_RC_SLOT_STATUS__COMMAND_COMPLETED__SHIFT                                                 0x4
#define BIF_CFG_DEV2_RC_SLOT_STATUS__MRL_SENSOR_STATE__SHIFT                                                  0x5
#define BIF_CFG_DEV2_RC_SLOT_STATUS__PRESENCE_DETECT_STATE__SHIFT                                             0x6
#define BIF_CFG_DEV2_RC_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS__SHIFT                                      0x7
#define BIF_CFG_DEV2_RC_SLOT_STATUS__DL_STATE_CHANGED__SHIFT                                                  0x8
#define BIF_CFG_DEV2_RC_SLOT_STATUS__ATTN_BUTTON_PRESSED_MASK                                                 0x0001L
#define BIF_CFG_DEV2_RC_SLOT_STATUS__PWR_FAULT_DETECTED_MASK                                                  0x0002L
#define BIF_CFG_DEV2_RC_SLOT_STATUS__MRL_SENSOR_CHANGED_MASK                                                  0x0004L
#define BIF_CFG_DEV2_RC_SLOT_STATUS__PRESENCE_DETECT_CHANGED_MASK                                             0x0008L
#define BIF_CFG_DEV2_RC_SLOT_STATUS__COMMAND_COMPLETED_MASK                                                   0x0010L
#define BIF_CFG_DEV2_RC_SLOT_STATUS__MRL_SENSOR_STATE_MASK                                                    0x0020L
#define BIF_CFG_DEV2_RC_SLOT_STATUS__PRESENCE_DETECT_STATE_MASK                                               0x0040L
#define BIF_CFG_DEV2_RC_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS_MASK                                        0x0080L
#define BIF_CFG_DEV2_RC_SLOT_STATUS__DL_STATE_CHANGED_MASK                                                    0x0100L
//BIF_CFG_DEV2_RC_ROOT_CNTL
#define BIF_CFG_DEV2_RC_ROOT_CNTL__SERR_ON_CORR_ERR_EN__SHIFT                                                 0x0
#define BIF_CFG_DEV2_RC_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN__SHIFT                                             0x1
#define BIF_CFG_DEV2_RC_ROOT_CNTL__SERR_ON_FATAL_ERR_EN__SHIFT                                                0x2
#define BIF_CFG_DEV2_RC_ROOT_CNTL__PM_INTERRUPT_EN__SHIFT                                                     0x3
#define BIF_CFG_DEV2_RC_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN__SHIFT                                          0x4
#define BIF_CFG_DEV2_RC_ROOT_CNTL__SERR_ON_CORR_ERR_EN_MASK                                                   0x0001L
#define BIF_CFG_DEV2_RC_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN_MASK                                               0x0002L
#define BIF_CFG_DEV2_RC_ROOT_CNTL__SERR_ON_FATAL_ERR_EN_MASK                                                  0x0004L
#define BIF_CFG_DEV2_RC_ROOT_CNTL__PM_INTERRUPT_EN_MASK                                                       0x0008L
#define BIF_CFG_DEV2_RC_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN_MASK                                            0x0010L
//BIF_CFG_DEV2_RC_ROOT_CAP
#define BIF_CFG_DEV2_RC_ROOT_CAP__CRS_SOFTWARE_VISIBILITY__SHIFT                                              0x0
#define BIF_CFG_DEV2_RC_ROOT_CAP__CRS_SOFTWARE_VISIBILITY_MASK                                                0x0001L
//BIF_CFG_DEV2_RC_ROOT_STATUS
#define BIF_CFG_DEV2_RC_ROOT_STATUS__PME_REQUESTOR_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV2_RC_ROOT_STATUS__PME_STATUS__SHIFT                                                        0x10
#define BIF_CFG_DEV2_RC_ROOT_STATUS__PME_PENDING__SHIFT                                                       0x11
#define BIF_CFG_DEV2_RC_ROOT_STATUS__PME_REQUESTOR_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV2_RC_ROOT_STATUS__PME_STATUS_MASK                                                          0x00010000L
#define BIF_CFG_DEV2_RC_ROOT_STATUS__PME_PENDING_MASK                                                         0x00020000L
//BIF_CFG_DEV2_RC_DEVICE_CAP2
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                       0x0
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                         0x4
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                          0x5
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                        0x6
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                        0x7
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                        0x8
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                            0x9
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                         0xa
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                     0xb
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                                0xc
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__LN_SYSTEM_CLS__SHIFT                                                     0xe
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED__SHIFT                                   0x10
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED__SHIFT                                   0x11
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                    0x12
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                      0x14
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                      0x15
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                          0x16
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED__SHIFT                                    0x18
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ__SHIFT                                     0x1a
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__FRS_SUPPORTED__SHIFT                                                     0x1f
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                         0x0000000FL
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                           0x00000010L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                            0x00000020L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                          0x00000040L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                          0x00000080L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                          0x00000100L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                              0x00000200L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                           0x00000400L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                       0x00000800L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                                  0x00003000L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__LN_SYSTEM_CLS_MASK                                                       0x0000C000L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED_MASK                                     0x00010000L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED_MASK                                     0x00020000L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                      0x000C0000L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                        0x00100000L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                        0x00200000L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                            0x00C00000L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED_MASK                                      0x03000000L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ_MASK                                       0x04000000L
#define BIF_CFG_DEV2_RC_DEVICE_CAP2__FRS_SUPPORTED_MASK                                                       0x80000000L
//BIF_CFG_DEV2_RC_DEVICE_CNTL2
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                                0x0
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                                  0x4
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                                0x5
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                              0x6
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                         0x7
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                               0x8
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                            0x9
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__LTR_EN__SHIFT                                                           0xa
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST__SHIFT                                     0xb
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE__SHIFT                                     0xc
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__OBFF_EN__SHIFT                                                          0xd
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                      0xf
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                                  0x000FL
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                    0x0010L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                                  0x0020L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                                0x0040L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                           0x0080L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                                 0x0100L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                              0x0200L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__LTR_EN_MASK                                                             0x0400L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST_MASK                                       0x0800L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE_MASK                                       0x1000L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__OBFF_EN_MASK                                                            0x6000L
#define BIF_CFG_DEV2_RC_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                        0x8000L
//BIF_CFG_DEV2_RC_DEVICE_STATUS2
#define BIF_CFG_DEV2_RC_DEVICE_STATUS2__RESERVED__SHIFT                                                       0x0
#define BIF_CFG_DEV2_RC_DEVICE_STATUS2__RESERVED_MASK                                                         0xFFFFL
//BIF_CFG_DEV2_RC_LINK_CAP2
#define BIF_CFG_DEV2_RC_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                                0x1
#define BIF_CFG_DEV2_RC_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                                 0x8
#define BIF_CFG_DEV2_RC_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT__SHIFT                                            0x9
#define BIF_CFG_DEV2_RC_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT__SHIFT                                            0x10
#define BIF_CFG_DEV2_RC_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT__SHIFT                                           0x17
#define BIF_CFG_DEV2_RC_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT__SHIFT                                           0x18
#define BIF_CFG_DEV2_RC_LINK_CAP2__DRS_SUPPORTED__SHIFT                                                       0x1f
#define BIF_CFG_DEV2_RC_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                                  0x000000FEL
#define BIF_CFG_DEV2_RC_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                                   0x00000100L
#define BIF_CFG_DEV2_RC_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT_MASK                                              0x0000FE00L
#define BIF_CFG_DEV2_RC_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT_MASK                                              0x007F0000L
#define BIF_CFG_DEV2_RC_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT_MASK                                             0x00800000L
#define BIF_CFG_DEV2_RC_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT_MASK                                             0x01000000L
#define BIF_CFG_DEV2_RC_LINK_CAP2__DRS_SUPPORTED_MASK                                                         0x80000000L
//BIF_CFG_DEV2_RC_LINK_CNTL2
#define BIF_CFG_DEV2_RC_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                                  0x0
#define BIF_CFG_DEV2_RC_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                                   0x4
#define BIF_CFG_DEV2_RC_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                        0x5
#define BIF_CFG_DEV2_RC_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                              0x6
#define BIF_CFG_DEV2_RC_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                        0x7
#define BIF_CFG_DEV2_RC_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                               0xa
#define BIF_CFG_DEV2_RC_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                     0xb
#define BIF_CFG_DEV2_RC_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                              0xc
#define BIF_CFG_DEV2_RC_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                    0x000FL
#define BIF_CFG_DEV2_RC_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                     0x0010L
#define BIF_CFG_DEV2_RC_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                          0x0020L
#define BIF_CFG_DEV2_RC_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                                0x0040L
#define BIF_CFG_DEV2_RC_LINK_CNTL2__XMIT_MARGIN_MASK                                                          0x0380L
#define BIF_CFG_DEV2_RC_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                                 0x0400L
#define BIF_CFG_DEV2_RC_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                       0x0800L
#define BIF_CFG_DEV2_RC_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                                0xF000L
//BIF_CFG_DEV2_RC_LINK_STATUS2
#define BIF_CFG_DEV2_RC_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                             0x0
#define BIF_CFG_DEV2_RC_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT__SHIFT                                        0x1
#define BIF_CFG_DEV2_RC_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT__SHIFT                                  0x2
#define BIF_CFG_DEV2_RC_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT__SHIFT                                  0x3
#define BIF_CFG_DEV2_RC_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT__SHIFT                                  0x4
#define BIF_CFG_DEV2_RC_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT__SHIFT                                    0x5
#define BIF_CFG_DEV2_RC_LINK_STATUS2__RTM1_PRESENCE_DET__SHIFT                                                0x6
#define BIF_CFG_DEV2_RC_LINK_STATUS2__RTM2_PRESENCE_DET__SHIFT                                                0x7
#define BIF_CFG_DEV2_RC_LINK_STATUS2__CROSSLINK_RESOLUTION__SHIFT                                             0x8
#define BIF_CFG_DEV2_RC_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE__SHIFT                                    0xc
#define BIF_CFG_DEV2_RC_LINK_STATUS2__DRS_MESSAGE_RECEIVED__SHIFT                                             0xf
#define BIF_CFG_DEV2_RC_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                               0x0001L
#define BIF_CFG_DEV2_RC_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT_MASK                                          0x0002L
#define BIF_CFG_DEV2_RC_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT_MASK                                    0x0004L
#define BIF_CFG_DEV2_RC_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT_MASK                                    0x0008L
#define BIF_CFG_DEV2_RC_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT_MASK                                    0x0010L
#define BIF_CFG_DEV2_RC_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT_MASK                                      0x0020L
#define BIF_CFG_DEV2_RC_LINK_STATUS2__RTM1_PRESENCE_DET_MASK                                                  0x0040L
#define BIF_CFG_DEV2_RC_LINK_STATUS2__RTM2_PRESENCE_DET_MASK                                                  0x0080L
#define BIF_CFG_DEV2_RC_LINK_STATUS2__CROSSLINK_RESOLUTION_MASK                                               0x0300L
#define BIF_CFG_DEV2_RC_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE_MASK                                      0x7000L
#define BIF_CFG_DEV2_RC_LINK_STATUS2__DRS_MESSAGE_RECEIVED_MASK                                               0x8000L
//BIF_CFG_DEV2_RC_SLOT_CAP2
#define BIF_CFG_DEV2_RC_SLOT_CAP2__RESERVED__SHIFT                                                            0x0
#define BIF_CFG_DEV2_RC_SLOT_CAP2__RESERVED_MASK                                                              0xFFFFFFFFL
//BIF_CFG_DEV2_RC_SLOT_CNTL2
#define BIF_CFG_DEV2_RC_SLOT_CNTL2__RESERVED__SHIFT                                                           0x0
#define BIF_CFG_DEV2_RC_SLOT_CNTL2__RESERVED_MASK                                                             0xFFFFL
//BIF_CFG_DEV2_RC_SLOT_STATUS2
#define BIF_CFG_DEV2_RC_SLOT_STATUS2__RESERVED__SHIFT                                                         0x0
#define BIF_CFG_DEV2_RC_SLOT_STATUS2__RESERVED_MASK                                                           0xFFFFL
//BIF_CFG_DEV2_RC_MSI_CAP_LIST
#define BIF_CFG_DEV2_RC_MSI_CAP_LIST__CAP_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV2_RC_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                         0x8
#define BIF_CFG_DEV2_RC_MSI_CAP_LIST__CAP_ID_MASK                                                             0x00FFL
#define BIF_CFG_DEV2_RC_MSI_CAP_LIST__NEXT_PTR_MASK                                                           0xFF00L
//BIF_CFG_DEV2_RC_MSI_MSG_CNTL
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_EN__SHIFT                                                           0x0
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                    0x1
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                     0x4
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                        0x7
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                        0x8
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP__SHIFT                                             0x9
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN__SHIFT                                              0xa
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_EN_MASK                                                             0x0001L
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                      0x000EL
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                       0x0070L
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_64BIT_MASK                                                          0x0080L
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                          0x0100L
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP_MASK                                               0x0200L
#define BIF_CFG_DEV2_RC_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN_MASK                                                0x0400L
//BIF_CFG_DEV2_RC_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV2_RC_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                               0x2
#define BIF_CFG_DEV2_RC_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                                 0xFFFFFFFCL
//BIF_CFG_DEV2_RC_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV2_RC_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                               0x0
#define BIF_CFG_DEV2_RC_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV2_RC_MSI_MSG_DATA
#define BIF_CFG_DEV2_RC_MSI_MSG_DATA__MSI_DATA__SHIFT                                                         0x0
#define BIF_CFG_DEV2_RC_MSI_MSG_DATA__MSI_DATA_MASK                                                           0xFFFFL
//BIF_CFG_DEV2_RC_MSI_EXT_MSG_DATA
#define BIF_CFG_DEV2_RC_MSI_EXT_MSG_DATA__MSI_EXT_DATA__SHIFT                                                 0x0
#define BIF_CFG_DEV2_RC_MSI_EXT_MSG_DATA__MSI_EXT_DATA_MASK                                                   0xFFFFL
//BIF_CFG_DEV2_RC_MSI_MSG_DATA_64
#define BIF_CFG_DEV2_RC_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                                   0x0
#define BIF_CFG_DEV2_RC_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                     0xFFFFL
//BIF_CFG_DEV2_RC_MSI_EXT_MSG_DATA_64
#define BIF_CFG_DEV2_RC_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64__SHIFT                                           0x0
#define BIF_CFG_DEV2_RC_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64_MASK                                             0xFFFFL
//BIF_CFG_DEV2_RC_SSID_CAP_LIST
#define BIF_CFG_DEV2_RC_SSID_CAP_LIST__CAP_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV2_RC_SSID_CAP_LIST__NEXT_PTR__SHIFT                                                        0x8
#define BIF_CFG_DEV2_RC_SSID_CAP_LIST__CAP_ID_MASK                                                            0x00FFL
#define BIF_CFG_DEV2_RC_SSID_CAP_LIST__NEXT_PTR_MASK                                                          0xFF00L
//BIF_CFG_DEV2_RC_SSID_CAP
#define BIF_CFG_DEV2_RC_SSID_CAP__SUBSYSTEM_VENDOR_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV2_RC_SSID_CAP__SUBSYSTEM_ID__SHIFT                                                         0x10
#define BIF_CFG_DEV2_RC_SSID_CAP__SUBSYSTEM_VENDOR_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV2_RC_SSID_CAP__SUBSYSTEM_ID_MASK                                                           0xFFFF0000L
//BIF_CFG_DEV2_RC_MSI_MAP_CAP_LIST
#define BIF_CFG_DEV2_RC_MSI_MAP_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV2_RC_MSI_MAP_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV2_RC_MSI_MAP_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV2_RC_MSI_MAP_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV2_RC_MSI_MAP_CAP
#define BIF_CFG_DEV2_RC_MSI_MAP_CAP__EN__SHIFT                                                                0x0
#define BIF_CFG_DEV2_RC_MSI_MAP_CAP__FIXD__SHIFT                                                              0x1
#define BIF_CFG_DEV2_RC_MSI_MAP_CAP__CAP_TYPE__SHIFT                                                          0xb
#define BIF_CFG_DEV2_RC_MSI_MAP_CAP__EN_MASK                                                                  0x0001L
#define BIF_CFG_DEV2_RC_MSI_MAP_CAP__FIXD_MASK                                                                0x0002L
#define BIF_CFG_DEV2_RC_MSI_MAP_CAP__CAP_TYPE_MASK                                                            0xF800L
//BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                      0x0
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                     0x10
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                    0x14
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                        0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                       0x000F0000L
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                      0xFFF00000L
//BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                              0x0
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                             0x10
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                          0x14
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                               0x000F0000L
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                            0xFFF00000L
//BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                                 0x0
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                                   0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                                 0x0
#define BIF_CFG_DEV2_RC_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                                   0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_VC_ENH_CAP_LIST
#define BIF_CFG_DEV2_RC_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT                                                   0x0
#define BIF_CFG_DEV2_RC_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT                                                  0x10
#define BIF_CFG_DEV2_RC_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                 0x14
#define BIF_CFG_DEV2_RC_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK                                                     0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK                                                    0x000F0000L
#define BIF_CFG_DEV2_RC_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK                                                   0xFFF00000L
//BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG1
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT                                            0x0
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT                               0x4
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT                                                 0x8
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT                               0xa
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK                                              0x00000007L
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK                                 0x00000070L
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK                                                   0x00000300L
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK                                 0x00000C00L
//BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG2
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT                                              0x0
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT                                     0x18
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK                                                0x000000FFL
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK                                       0xFF000000L
//BIF_CFG_DEV2_RC_PCIE_PORT_VC_CNTL
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT                                           0x0
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT                                               0x1
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK                                             0x0001L
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK                                                 0x000EL
//BIF_CFG_DEV2_RC_PCIE_PORT_VC_STATUS
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT                                       0x0
#define BIF_CFG_DEV2_RC_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK                                         0x0001L
//BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CAP
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                            0x0
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                      0xf
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                          0x10
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                   0x18
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK                                              0x000000FFL
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                        0x00008000L
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                            0x007F0000L
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                     0xFF000000L
//BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                          0x0
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                        0x1
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                    0x10
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                        0x11
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT                                                  0x18
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT                                              0x1f
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                            0x00000001L
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                          0x000000FEL
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                      0x00010000L
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                          0x000E0000L
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK                                                    0x07000000L
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK                                                0x80000000L
//BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_STATUS
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                                0x0
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                               0x1
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                  0x0001L
#define BIF_CFG_DEV2_RC_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                 0x0002L
//BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CAP
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                            0x0
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                      0xf
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                          0x10
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                   0x18
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK                                              0x000000FFL
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                        0x00008000L
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                            0x003F0000L
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                     0xFF000000L
//BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                          0x0
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                        0x1
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                    0x10
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                        0x11
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT                                                  0x18
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT                                              0x1f
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                            0x00000001L
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                          0x000000FEL
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                      0x00010000L
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                          0x000E0000L
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK                                                    0x07000000L
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK                                                0x80000000L
//BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_STATUS
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                                0x0
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                               0x1
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                  0x0001L
#define BIF_CFG_DEV2_RC_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                 0x0002L
//BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST
#define BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT                                       0x0
#define BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT                                      0x10
#define BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT                                     0x14
#define BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK                                         0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK                                        0x000F0000L
#define BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK                                       0xFFF00000L
//BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_DW1
#define BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT                                      0x0
#define BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_DW2
#define BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT                                      0x0
#define BIF_CFG_DEV2_RC_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                          0x0
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                         0x10
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                        0x14
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                           0x000F0000L
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                          0xFFF00000L
//BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                         0x4
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                      0x5
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                         0xc
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                          0xd
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                     0xe
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                                   0xf
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                       0x10
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                        0x11
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                         0x12
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                        0x13
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                                  0x14
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                                   0x15
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                                  0x16
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                                  0x17
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                         0x18
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                          0x19
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS__SHIFT                     0x1a
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                           0x00000010L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                        0x00000020L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                           0x00001000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                            0x00002000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                       0x00004000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                     0x00008000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                         0x00010000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                          0x00020000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                           0x00040000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                          0x00080000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                    0x00100000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                     0x00200000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                    0x00400000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                    0x00800000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                           0x01000000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                            0x02000000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS_MASK                       0x04000000L
//BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                             0x4
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                          0x5
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                             0xc
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                              0xd
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                         0xe
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                       0xf
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                           0x10
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                            0x11
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                             0x12
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                            0x13
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                      0x14
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                       0x15
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                      0x16
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                      0x17
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                             0x18
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                              0x19
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__POISONED_TLP_EGRESS_BLOCKED_MASK__SHIFT                         0x1a
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                               0x00000010L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                            0x00000020L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                               0x00001000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                                0x00002000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                           0x00004000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                         0x00008000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                             0x00010000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                              0x00020000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                               0x00040000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                              0x00080000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                        0x00100000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                         0x00200000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                        0x00400000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                        0x00800000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                               0x01000000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                                0x02000000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_MASK__POISONED_TLP_EGRESS_BLOCKED_MASK_MASK                           0x04000000L
//BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                     0x4
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                                  0x5
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                     0xc
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                      0xd
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                                 0xe
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                               0xf
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                                   0x10
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                    0x11
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                     0x12
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                    0x13
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                              0x14
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                               0x15
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                              0x16
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                              0x17
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                     0x18
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                      0x19
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__POISONED_TLP_EGRESS_BLOCKED_SEVERITY__SHIFT                 0x1a
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                       0x00000010L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                    0x00000020L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                       0x00001000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                        0x00002000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                                   0x00004000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                                 0x00008000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                     0x00010000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                      0x00020000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                       0x00040000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                      0x00080000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                                0x00100000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                                 0x00200000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                                0x00400000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                                0x00800000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                       0x01000000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                        0x02000000L
#define BIF_CFG_DEV2_RC_PCIE_UNCORR_ERR_SEVERITY__POISONED_TLP_EGRESS_BLOCKED_SEVERITY_MASK                   0x04000000L
//BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                           0x0
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                           0x6
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                          0x7
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                               0x8
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                              0xc
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                             0xd
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                      0xe
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                             0x00000001L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                             0x00000040L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                            0x00000080L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                                 0x00000100L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                                0x00001000L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                               0x00002000L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                        0x00004000L
//BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                               0x0
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                               0x6
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                              0x7
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                                   0x8
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                                  0xc
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                                 0xd
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                          0xe
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                                 0x00000001L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                                 0x00000040L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                                0x00000080L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                     0x00000100L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                    0x00001000L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                                   0x00002000L
#define BIF_CFG_DEV2_RC_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                            0x00004000L
//BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                           0x0
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                            0x5
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                             0x6
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                          0x7
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                           0x8
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                      0x9
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                       0xa
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                             0x0000001FL
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                              0x00000020L
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                               0x00000040L
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                            0x00000080L
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                             0x00000100L
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                        0x00000200L
#define BIF_CFG_DEV2_RC_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                         0x00000400L
//BIF_CFG_DEV2_RC_PCIE_HDR_LOG0
#define BIF_CFG_DEV2_RC_PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV2_RC_PCIE_HDR_LOG0__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_HDR_LOG1
#define BIF_CFG_DEV2_RC_PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV2_RC_PCIE_HDR_LOG1__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_HDR_LOG2
#define BIF_CFG_DEV2_RC_PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV2_RC_PCIE_HDR_LOG2__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_HDR_LOG3
#define BIF_CFG_DEV2_RC_PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                         0x0
#define BIF_CFG_DEV2_RC_PCIE_HDR_LOG3__TLP_HDR_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_CMD
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN__SHIFT                                             0x0
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN__SHIFT                                         0x1
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN__SHIFT                                            0x2
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN_MASK                                               0x00000001L
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN_MASK                                           0x00000002L
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN_MASK                                              0x00000004L
//BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD__SHIFT                                            0x0
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD__SHIFT                                       0x1
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD__SHIFT                                  0x2
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD__SHIFT                             0x3
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL__SHIFT                                0x4
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD__SHIFT                                  0x5
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD__SHIFT                                     0x6
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM__SHIFT                                      0x1b
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD_MASK                                              0x00000001L
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD_MASK                                         0x00000002L
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD_MASK                                    0x00000004L
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD_MASK                               0x00000008L
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL_MASK                                  0x00000010L
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD_MASK                                    0x00000020L
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD_MASK                                       0x00000040L
#define BIF_CFG_DEV2_RC_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM_MASK                                        0xF8000000L
//BIF_CFG_DEV2_RC_PCIE_ERR_SRC_ID
#define BIF_CFG_DEV2_RC_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID__SHIFT                                               0x0
#define BIF_CFG_DEV2_RC_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID__SHIFT                                     0x10
#define BIF_CFG_DEV2_RC_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID_MASK                                                 0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID_MASK                                       0xFFFF0000L
//BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG0
#define BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG1
#define BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG2
#define BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG3
#define BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                               0x0
#define BIF_CFG_DEV2_RC_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV2_RC_PCIE_SECONDARY_ENH_CAP_LIST
#define BIF_CFG_DEV2_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT                                            0x0
#define BIF_CFG_DEV2_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT                                           0x10
#define BIF_CFG_DEV2_RC_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT                                          0x14
#define BIF_CFG_DEV2_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK                                             0x000F0000L
#define BIF_CFG_DEV2_RC_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK                                            0xFFF00000L
//BIF_CFG_DEV2_RC_PCIE_LINK_CNTL3
#define BIF_CFG_DEV2_RC_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT                                          0x0
#define BIF_CFG_DEV2_RC_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT                                  0x1
#define BIF_CFG_DEV2_RC_PCIE_LINK_CNTL3__ENABLE_LOWER_SKP_OS_GEN__SHIFT                                       0x9
#define BIF_CFG_DEV2_RC_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK                                            0x00000001L
#define BIF_CFG_DEV2_RC_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK                                    0x00000002L
#define BIF_CFG_DEV2_RC_PCIE_LINK_CNTL3__ENABLE_LOWER_SKP_OS_GEN_MASK                                         0x0000FE00L
//BIF_CFG_DEV2_RC_PCIE_LANE_ERROR_STATUS
#define BIF_CFG_DEV2_RC_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT                                 0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK                                   0x0000FFFFL
//BIF_CFG_DEV2_RC_PCIE_LANE_0_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_1_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_2_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_3_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_4_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_5_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_6_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_7_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_8_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_9_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                  0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_10_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_11_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_12_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_13_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_14_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV2_RC_PCIE_LANE_15_EQUALIZATION_CNTL
#define BIF_CFG_DEV2_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV2_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV2_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV2_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV2_RC_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV2_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV2_RC_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                 0x7000L
//BIF_CFG_DEV2_RC_PCIE_ACS_ENH_CAP_LIST
#define BIF_CFG_DEV2_RC_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV2_RC_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                                 0x10
#define BIF_CFG_DEV2_RC_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                0x14
#define BIF_CFG_DEV2_RC_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                                   0x000F0000L
#define BIF_CFG_DEV2_RC_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                                  0xFFF00000L
//BIF_CFG_DEV2_RC_PCIE_ACS_CAP
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                                0x0
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                             0x1
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                             0x2
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                          0x3
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                              0x4
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                               0x5
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                            0x6
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                       0x8
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                                  0x0001L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                               0x0002L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                               0x0004L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                            0x0008L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                                0x0010L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                                 0x0020L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                              0x0040L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                         0xFF00L
//BIF_CFG_DEV2_RC_PCIE_ACS_CNTL
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                            0x0
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                         0x1
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                         0x2
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                      0x3
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                          0x4
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                           0x5
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                        0x6
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                              0x0001L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                           0x0002L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                           0x0004L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                        0x0008L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                            0x0010L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                             0x0020L
#define BIF_CFG_DEV2_RC_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                          0x0040L
//BIF_CFG_DEV2_RC_PCIE_DLF_ENH_CAP_LIST
#define BIF_CFG_DEV2_RC_PCIE_DLF_ENH_CAP_LIST__CAP_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV2_RC_PCIE_DLF_ENH_CAP_LIST__CAP_VER__SHIFT                                                 0x10
#define BIF_CFG_DEV2_RC_PCIE_DLF_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                0x14
#define BIF_CFG_DEV2_RC_PCIE_DLF_ENH_CAP_LIST__CAP_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_DLF_ENH_CAP_LIST__CAP_VER_MASK                                                   0x000F0000L
#define BIF_CFG_DEV2_RC_PCIE_DLF_ENH_CAP_LIST__NEXT_PTR_MASK                                                  0xFFF00000L
//BIF_CFG_DEV2_RC_DATA_LINK_FEATURE_CAP
#define BIF_CFG_DEV2_RC_DATA_LINK_FEATURE_CAP__LOCAL_DLF_SUPPORTED__SHIFT                                     0x0
#define BIF_CFG_DEV2_RC_DATA_LINK_FEATURE_CAP__DLF_EXCHANGE_ENABLE__SHIFT                                     0x1f
#define BIF_CFG_DEV2_RC_DATA_LINK_FEATURE_CAP__LOCAL_DLF_SUPPORTED_MASK                                       0x007FFFFFL
#define BIF_CFG_DEV2_RC_DATA_LINK_FEATURE_CAP__DLF_EXCHANGE_ENABLE_MASK                                       0x80000000L
//BIF_CFG_DEV2_RC_DATA_LINK_FEATURE_STATUS
#define BIF_CFG_DEV2_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED__SHIFT                                 0x0
#define BIF_CFG_DEV2_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_VALID__SHIFT                           0x1f
#define BIF_CFG_DEV2_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_MASK                                   0x007FFFFFL
#define BIF_CFG_DEV2_RC_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_VALID_MASK                             0x80000000L
//BIF_CFG_DEV2_RC_PCIE_PHY_16GT_ENH_CAP_LIST
#define BIF_CFG_DEV2_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_ID__SHIFT                                             0x0
#define BIF_CFG_DEV2_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_VER__SHIFT                                            0x10
#define BIF_CFG_DEV2_RC_PCIE_PHY_16GT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                           0x14
#define BIF_CFG_DEV2_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_ID_MASK                                               0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_VER_MASK                                              0x000F0000L
#define BIF_CFG_DEV2_RC_PCIE_PHY_16GT_ENH_CAP_LIST__NEXT_PTR_MASK                                             0xFFF00000L
//BIF_CFG_DEV2_RC_LINK_CAP_16GT
#define BIF_CFG_DEV2_RC_LINK_CAP_16GT__RESERVED__SHIFT                                                        0x0
#define BIF_CFG_DEV2_RC_LINK_CAP_16GT__RESERVED_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV2_RC_LINK_CNTL_16GT
#define BIF_CFG_DEV2_RC_LINK_CNTL_16GT__RESERVED__SHIFT                                                       0x0
#define BIF_CFG_DEV2_RC_LINK_CNTL_16GT__RESERVED_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV2_RC_LINK_STATUS_16GT
#define BIF_CFG_DEV2_RC_LINK_STATUS_16GT__EQUALIZATION_COMPLETE_16GT__SHIFT                                   0x0
#define BIF_CFG_DEV2_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE1_SUCCESS_16GT__SHIFT                             0x1
#define BIF_CFG_DEV2_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE2_SUCCESS_16GT__SHIFT                             0x2
#define BIF_CFG_DEV2_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE3_SUCCESS_16GT__SHIFT                             0x3
#define BIF_CFG_DEV2_RC_LINK_STATUS_16GT__LINK_EQUALIZATION_REQUEST_16GT__SHIFT                               0x4
#define BIF_CFG_DEV2_RC_LINK_STATUS_16GT__EQUALIZATION_COMPLETE_16GT_MASK                                     0x00000001L
#define BIF_CFG_DEV2_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE1_SUCCESS_16GT_MASK                               0x00000002L
#define BIF_CFG_DEV2_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE2_SUCCESS_16GT_MASK                               0x00000004L
#define BIF_CFG_DEV2_RC_LINK_STATUS_16GT__EQUALIZATION_PHASE3_SUCCESS_16GT_MASK                               0x00000008L
#define BIF_CFG_DEV2_RC_LINK_STATUS_16GT__LINK_EQUALIZATION_REQUEST_16GT_MASK                                 0x00000010L
//BIF_CFG_DEV2_RC_LOCAL_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV2_RC_LOCAL_PARITY_MISMATCH_STATUS_16GT__LOCAL_PARITY_MISMATCH_STATUS_BITS__SHIFT           0x0
#define BIF_CFG_DEV2_RC_LOCAL_PARITY_MISMATCH_STATUS_16GT__LOCAL_PARITY_MISMATCH_STATUS_BITS_MASK             0x0000FFFFL
//BIF_CFG_DEV2_RC_RTM1_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV2_RC_RTM1_PARITY_MISMATCH_STATUS_16GT__RTM1_PARITY_MISMATCH_STATUS_BITS__SHIFT             0x0
#define BIF_CFG_DEV2_RC_RTM1_PARITY_MISMATCH_STATUS_16GT__RTM1_PARITY_MISMATCH_STATUS_BITS_MASK               0x0000FFFFL
//BIF_CFG_DEV2_RC_RTM2_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV2_RC_RTM2_PARITY_MISMATCH_STATUS_16GT__RTM2_PARITY_MISMATCH_STATUS_BITS__SHIFT             0x0
#define BIF_CFG_DEV2_RC_RTM2_PARITY_MISMATCH_STATUS_16GT__RTM2_PARITY_MISMATCH_STATUS_BITS_MASK               0x0000FFFFL
//BIF_CFG_DEV2_RC_LANE_0_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV2_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV2_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV2_RC_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV2_RC_LANE_1_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV2_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV2_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV2_RC_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV2_RC_LANE_2_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV2_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV2_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV2_RC_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV2_RC_LANE_3_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV2_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV2_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV2_RC_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV2_RC_LANE_4_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV2_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV2_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV2_RC_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV2_RC_LANE_5_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV2_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV2_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV2_RC_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV2_RC_LANE_6_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV2_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV2_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV2_RC_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV2_RC_LANE_7_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV2_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV2_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV2_RC_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV2_RC_LANE_8_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV2_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV2_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV2_RC_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV2_RC_LANE_9_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_DSP_16GT_TX_PRESET__SHIFT                       0x0
#define BIF_CFG_DEV2_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_USP_16GT_TX_PRESET__SHIFT                       0x4
#define BIF_CFG_DEV2_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_DSP_16GT_TX_PRESET_MASK                         0x0FL
#define BIF_CFG_DEV2_RC_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_USP_16GT_TX_PRESET_MASK                         0xF0L
//BIF_CFG_DEV2_RC_LANE_10_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV2_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV2_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV2_RC_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV2_RC_LANE_11_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV2_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV2_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV2_RC_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV2_RC_LANE_12_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV2_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV2_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV2_RC_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV2_RC_LANE_13_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV2_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV2_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV2_RC_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV2_RC_LANE_14_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV2_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV2_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV2_RC_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV2_RC_LANE_15_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV2_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV2_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV2_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV2_RC_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV2_RC_PCIE_MARGINING_ENH_CAP_LIST
#define BIF_CFG_DEV2_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_ID__SHIFT                                            0x0
#define BIF_CFG_DEV2_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_VER__SHIFT                                           0x10
#define BIF_CFG_DEV2_RC_PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR__SHIFT                                          0x14
#define BIF_CFG_DEV2_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_MARGINING_ENH_CAP_LIST__CAP_VER_MASK                                             0x000F0000L
#define BIF_CFG_DEV2_RC_PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR_MASK                                            0xFFF00000L
//BIF_CFG_DEV2_RC_MARGINING_PORT_CAP
#define BIF_CFG_DEV2_RC_MARGINING_PORT_CAP__MARGINING_USES_SOFTWARE__SHIFT                                    0x0
#define BIF_CFG_DEV2_RC_MARGINING_PORT_CAP__MARGINING_USES_SOFTWARE_MASK                                      0x0001L
//BIF_CFG_DEV2_RC_MARGINING_PORT_STATUS
#define BIF_CFG_DEV2_RC_MARGINING_PORT_STATUS__MARGINING_READY__SHIFT                                         0x0
#define BIF_CFG_DEV2_RC_MARGINING_PORT_STATUS__MARGINING_SOFTWARE_READY__SHIFT                                0x1
#define BIF_CFG_DEV2_RC_MARGINING_PORT_STATUS__MARGINING_READY_MASK                                           0x0001L
#define BIF_CFG_DEV2_RC_MARGINING_PORT_STATUS__MARGINING_SOFTWARE_READY_MASK                                  0x0002L
//BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV2_RC_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV2_RC_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV2_RC_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV2_RC_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV2_RC_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV2_RC_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV2_RC_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV2_RC_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV2_RC_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_RECEIVER_NUMBER__SHIFT                             0x0
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_TYPE__SHIFT                                 0x3
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_USAGE_MODEL__SHIFT                                 0x6
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_PAYLOAD__SHIFT                              0x8
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_RECEIVER_NUMBER_MASK                               0x0007L
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_TYPE_MASK                                   0x0038L
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_USAGE_MODEL_MASK                                   0x0040L
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_PAYLOAD_MASK                                0xFF00L
//BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_RECEIVER_NUMBER_STATUS__SHIFT                    0x0
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_TYPE_STATUS__SHIFT                        0x3
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_USAGE_MODEL_STATUS__SHIFT                        0x6
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_PAYLOAD_STATUS__SHIFT                     0x8
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_RECEIVER_NUMBER_STATUS_MASK                      0x0007L
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_TYPE_STATUS_MASK                          0x0038L
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_USAGE_MODEL_STATUS_MASK                          0x0040L
#define BIF_CFG_DEV2_RC_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_PAYLOAD_STATUS_MASK                       0xFF00L
//BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV2_RC_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV2_RC_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV2_RC_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV2_RC_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV2_RC_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_CNTL
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_STATUS
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV2_RC_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV2_RC_PCIE_RTR_ENH_CAP_LIST
#define BIF_CFG_DEV2_RC_PCIE_RTR_ENH_CAP_LIST__CAP_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV2_RC_PCIE_RTR_ENH_CAP_LIST__CAP_VER__SHIFT                                                 0x10
#define BIF_CFG_DEV2_RC_PCIE_RTR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                0x14
#define BIF_CFG_DEV2_RC_PCIE_RTR_ENH_CAP_LIST__CAP_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV2_RC_PCIE_RTR_ENH_CAP_LIST__CAP_VER_MASK                                                   0x000F0000L
#define BIF_CFG_DEV2_RC_PCIE_RTR_ENH_CAP_LIST__NEXT_PTR_MASK                                                  0xFFF00000L
//BIF_CFG_DEV2_RC_RTR_DATA1
#define BIF_CFG_DEV2_RC_RTR_DATA1__RESET_TIME__SHIFT                                                          0x0
#define BIF_CFG_DEV2_RC_RTR_DATA1__DLUP_TIME__SHIFT                                                           0xc
#define BIF_CFG_DEV2_RC_RTR_DATA1__VALID__SHIFT                                                               0x1f
#define BIF_CFG_DEV2_RC_RTR_DATA1__RESET_TIME_MASK                                                            0x00000FFFL
#define BIF_CFG_DEV2_RC_RTR_DATA1__DLUP_TIME_MASK                                                             0x00FFF000L
#define BIF_CFG_DEV2_RC_RTR_DATA1__VALID_MASK                                                                 0x80000000L
//BIF_CFG_DEV2_RC_RTR_DATA2
#define BIF_CFG_DEV2_RC_RTR_DATA2__FLR_TIME__SHIFT                                                            0x0
#define BIF_CFG_DEV2_RC_RTR_DATA2__D3HOTD0_TIME__SHIFT                                                        0xc
#define BIF_CFG_DEV2_RC_RTR_DATA2__FLR_TIME_MASK                                                              0x00000FFFL
#define BIF_CFG_DEV2_RC_RTR_DATA2__D3HOTD0_TIME_MASK                                                          0x00FFF000L


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf0_bifcfgdecp
//BIF_CFG_DEV0_EPF0_VENDOR_ID
#define BIF_CFG_DEV0_EPF0_VENDOR_ID__VENDOR_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF0_VENDOR_ID__VENDOR_ID_MASK                                                           0xFFFFL
//BIF_CFG_DEV0_EPF0_DEVICE_ID
#define BIF_CFG_DEV0_EPF0_DEVICE_ID__DEVICE_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF0_DEVICE_ID__DEVICE_ID_MASK                                                           0xFFFFL
//BIF_CFG_DEV0_EPF0_COMMAND
#define BIF_CFG_DEV0_EPF0_COMMAND__IO_ACCESS_EN__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF0_COMMAND__MEM_ACCESS_EN__SHIFT                                                       0x1
#define BIF_CFG_DEV0_EPF0_COMMAND__BUS_MASTER_EN__SHIFT                                                       0x2
#define BIF_CFG_DEV0_EPF0_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                    0x3
#define BIF_CFG_DEV0_EPF0_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                             0x4
#define BIF_CFG_DEV0_EPF0_COMMAND__PAL_SNOOP_EN__SHIFT                                                        0x5
#define BIF_CFG_DEV0_EPF0_COMMAND__AD_STEPPING__SHIFT                                                         0x7
#define BIF_CFG_DEV0_EPF0_COMMAND__SERR_EN__SHIFT                                                             0x8
#define BIF_CFG_DEV0_EPF0_COMMAND__FAST_B2B_EN__SHIFT                                                         0x9
#define BIF_CFG_DEV0_EPF0_COMMAND__INT_DIS__SHIFT                                                             0xa
#define BIF_CFG_DEV0_EPF0_COMMAND__IO_ACCESS_EN_MASK                                                          0x0001L
#define BIF_CFG_DEV0_EPF0_COMMAND__MEM_ACCESS_EN_MASK                                                         0x0002L
#define BIF_CFG_DEV0_EPF0_COMMAND__BUS_MASTER_EN_MASK                                                         0x0004L
#define BIF_CFG_DEV0_EPF0_COMMAND__SPECIAL_CYCLE_EN_MASK                                                      0x0008L
#define BIF_CFG_DEV0_EPF0_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                               0x0010L
#define BIF_CFG_DEV0_EPF0_COMMAND__PAL_SNOOP_EN_MASK                                                          0x0020L
#define BIF_CFG_DEV0_EPF0_COMMAND__AD_STEPPING_MASK                                                           0x0080L
#define BIF_CFG_DEV0_EPF0_COMMAND__SERR_EN_MASK                                                               0x0100L
#define BIF_CFG_DEV0_EPF0_COMMAND__FAST_B2B_EN_MASK                                                           0x0200L
#define BIF_CFG_DEV0_EPF0_COMMAND__INT_DIS_MASK                                                               0x0400L
//BIF_CFG_DEV0_EPF0_STATUS
#define BIF_CFG_DEV0_EPF0_STATUS__IMMEDIATE_READINESS__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF0_STATUS__INT_STATUS__SHIFT                                                           0x3
#define BIF_CFG_DEV0_EPF0_STATUS__CAP_LIST__SHIFT                                                             0x4
#define BIF_CFG_DEV0_EPF0_STATUS__PCI_66_CAP__SHIFT                                                           0x5
#define BIF_CFG_DEV0_EPF0_STATUS__FAST_BACK_CAPABLE__SHIFT                                                    0x7
#define BIF_CFG_DEV0_EPF0_STATUS__DEVSEL_TIMING__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF0_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                  0xb
#define BIF_CFG_DEV0_EPF0_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF0_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                0xd
#define BIF_CFG_DEV0_EPF0_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                                0xe
#define BIF_CFG_DEV0_EPF0_STATUS__IMMEDIATE_READINESS_MASK                                                    0x0001L
#define BIF_CFG_DEV0_EPF0_STATUS__INT_STATUS_MASK                                                             0x0008L
#define BIF_CFG_DEV0_EPF0_STATUS__CAP_LIST_MASK                                                               0x0010L
#define BIF_CFG_DEV0_EPF0_STATUS__PCI_66_CAP_MASK                                                             0x0020L
#define BIF_CFG_DEV0_EPF0_STATUS__FAST_BACK_CAPABLE_MASK                                                      0x0080L
#define BIF_CFG_DEV0_EPF0_STATUS__DEVSEL_TIMING_MASK                                                          0x0600L
#define BIF_CFG_DEV0_EPF0_STATUS__SIGNAL_TARGET_ABORT_MASK                                                    0x0800L
#define BIF_CFG_DEV0_EPF0_STATUS__RECEIVED_TARGET_ABORT_MASK                                                  0x1000L
#define BIF_CFG_DEV0_EPF0_STATUS__RECEIVED_MASTER_ABORT_MASK                                                  0x2000L
#define BIF_CFG_DEV0_EPF0_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                  0x4000L
//BIF_CFG_DEV0_EPF0_REVISION_ID
#define BIF_CFG_DEV0_EPF0_REVISION_ID__MINOR_REV_ID__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF0_REVISION_ID__MAJOR_REV_ID__SHIFT                                                    0x4
#define BIF_CFG_DEV0_EPF0_REVISION_ID__MINOR_REV_ID_MASK                                                      0x0FL
#define BIF_CFG_DEV0_EPF0_REVISION_ID__MAJOR_REV_ID_MASK                                                      0xF0L
//BIF_CFG_DEV0_EPF0_PROG_INTERFACE
#define BIF_CFG_DEV0_EPF0_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF0_PROG_INTERFACE__PROG_INTERFACE_MASK                                                 0xFFL
//BIF_CFG_DEV0_EPF0_SUB_CLASS
#define BIF_CFG_DEV0_EPF0_SUB_CLASS__SUB_CLASS__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF0_SUB_CLASS__SUB_CLASS_MASK                                                           0xFFL
//BIF_CFG_DEV0_EPF0_BASE_CLASS
#define BIF_CFG_DEV0_EPF0_BASE_CLASS__BASE_CLASS__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_BASE_CLASS__BASE_CLASS_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF0_CACHE_LINE
#define BIF_CFG_DEV0_EPF0_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF0_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                    0xFFL
//BIF_CFG_DEV0_EPF0_LATENCY
#define BIF_CFG_DEV0_EPF0_LATENCY__LATENCY_TIMER__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_LATENCY__LATENCY_TIMER_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF0_HEADER
#define BIF_CFG_DEV0_EPF0_HEADER__HEADER_TYPE__SHIFT                                                          0x0
#define BIF_CFG_DEV0_EPF0_HEADER__DEVICE_TYPE__SHIFT                                                          0x7
#define BIF_CFG_DEV0_EPF0_HEADER__HEADER_TYPE_MASK                                                            0x7FL
#define BIF_CFG_DEV0_EPF0_HEADER__DEVICE_TYPE_MASK                                                            0x80L
//BIF_CFG_DEV0_EPF0_BIST
#define BIF_CFG_DEV0_EPF0_BIST__BIST_COMP__SHIFT                                                              0x0
#define BIF_CFG_DEV0_EPF0_BIST__BIST_STRT__SHIFT                                                              0x6
#define BIF_CFG_DEV0_EPF0_BIST__BIST_CAP__SHIFT                                                               0x7
#define BIF_CFG_DEV0_EPF0_BIST__BIST_COMP_MASK                                                                0x0FL
#define BIF_CFG_DEV0_EPF0_BIST__BIST_STRT_MASK                                                                0x40L
#define BIF_CFG_DEV0_EPF0_BIST__BIST_CAP_MASK                                                                 0x80L
//BIF_CFG_DEV0_EPF0_BASE_ADDR_1
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_1__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_1__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_BASE_ADDR_2
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_2__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_2__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_BASE_ADDR_3
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_3__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_3__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_BASE_ADDR_4
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_4__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_4__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_BASE_ADDR_5
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_5__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_5__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_BASE_ADDR_6
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_6__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_BASE_ADDR_6__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_ADAPTER_ID
#define BIF_CFG_DEV0_EPF0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF0_ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                     0x10
#define BIF_CFG_DEV0_EPF0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_ADAPTER_ID__SUBSYSTEM_ID_MASK                                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF0_ROM_BASE_ADDR
#define BIF_CFG_DEV0_EPF0_ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF0_ROM_BASE_ADDR__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_CAP_PTR
#define BIF_CFG_DEV0_EPF0_CAP_PTR__CAP_PTR__SHIFT                                                             0x0
#define BIF_CFG_DEV0_EPF0_CAP_PTR__CAP_PTR_MASK                                                               0xFFL
//BIF_CFG_DEV0_EPF0_INTERRUPT_LINE
#define BIF_CFG_DEV0_EPF0_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF0_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                                 0xFFL
//BIF_CFG_DEV0_EPF0_INTERRUPT_PIN
#define BIF_CFG_DEV0_EPF0_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF0_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                   0xFFL
//BIF_CFG_DEV0_EPF0_MIN_GRANT
#define BIF_CFG_DEV0_EPF0_MIN_GRANT__MIN_GNT__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF0_MIN_GRANT__MIN_GNT_MASK                                                             0xFFL
//BIF_CFG_DEV0_EPF0_MAX_LATENCY
#define BIF_CFG_DEV0_EPF0_MAX_LATENCY__MAX_LAT__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF0_MAX_LATENCY__MAX_LAT_MASK                                                           0xFFL
//BIF_CFG_DEV0_EPF0_VENDOR_CAP_LIST
#define BIF_CFG_DEV0_EPF0_VENDOR_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF0_VENDOR_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF0_VENDOR_CAP_LIST__LENGTH__SHIFT                                                      0x10
#define BIF_CFG_DEV0_EPF0_VENDOR_CAP_LIST__CAP_ID_MASK                                                        0x000000FFL
#define BIF_CFG_DEV0_EPF0_VENDOR_CAP_LIST__NEXT_PTR_MASK                                                      0x0000FF00L
#define BIF_CFG_DEV0_EPF0_VENDOR_CAP_LIST__LENGTH_MASK                                                        0x00FF0000L
//BIF_CFG_DEV0_EPF0_ADAPTER_ID_W
#define BIF_CFG_DEV0_EPF0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF0_ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT                                                   0x10
#define BIF_CFG_DEV0_EPF0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_ADAPTER_ID_W__SUBSYSTEM_ID_MASK                                                     0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PMI_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PMI_CAP_LIST__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF0_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV0_EPF0_PMI_CAP_LIST__CAP_ID_MASK                                                           0x00FFL
#define BIF_CFG_DEV0_EPF0_PMI_CAP_LIST__NEXT_PTR_MASK                                                         0xFF00L
//BIF_CFG_DEV0_EPF0_PMI_CAP
#define BIF_CFG_DEV0_EPF0_PMI_CAP__VERSION__SHIFT                                                             0x0
#define BIF_CFG_DEV0_EPF0_PMI_CAP__PME_CLOCK__SHIFT                                                           0x3
#define BIF_CFG_DEV0_EPF0_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0__SHIFT                                 0x4
#define BIF_CFG_DEV0_EPF0_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                   0x5
#define BIF_CFG_DEV0_EPF0_PMI_CAP__AUX_CURRENT__SHIFT                                                         0x6
#define BIF_CFG_DEV0_EPF0_PMI_CAP__D1_SUPPORT__SHIFT                                                          0x9
#define BIF_CFG_DEV0_EPF0_PMI_CAP__D2_SUPPORT__SHIFT                                                          0xa
#define BIF_CFG_DEV0_EPF0_PMI_CAP__PME_SUPPORT__SHIFT                                                         0xb
#define BIF_CFG_DEV0_EPF0_PMI_CAP__VERSION_MASK                                                               0x0007L
#define BIF_CFG_DEV0_EPF0_PMI_CAP__PME_CLOCK_MASK                                                             0x0008L
#define BIF_CFG_DEV0_EPF0_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0_MASK                                   0x0010L
#define BIF_CFG_DEV0_EPF0_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                     0x0020L
#define BIF_CFG_DEV0_EPF0_PMI_CAP__AUX_CURRENT_MASK                                                           0x01C0L
#define BIF_CFG_DEV0_EPF0_PMI_CAP__D1_SUPPORT_MASK                                                            0x0200L
#define BIF_CFG_DEV0_EPF0_PMI_CAP__D2_SUPPORT_MASK                                                            0x0400L
#define BIF_CFG_DEV0_EPF0_PMI_CAP__PME_SUPPORT_MASK                                                           0xF800L
//BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                               0x3
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__PME_EN__SHIFT                                                      0x8
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                                 0x9
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                  0xd
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                               0x16
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                  0x17
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                    0x18
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__POWER_STATE_MASK                                                   0x00000003L
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                                 0x00000008L
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__PME_EN_MASK                                                        0x00000100L
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                   0x00001E00L
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                    0x00006000L
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__PME_STATUS_MASK                                                    0x00008000L
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                                 0x00400000L
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                    0x00800000L
#define BIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL__PMI_DATA_MASK                                                      0xFF000000L
//BIF_CFG_DEV0_EPF0_PCIE_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_CAP_LIST__CAP_ID__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                      0x8
#define BIF_CFG_DEV0_EPF0_PCIE_CAP_LIST__CAP_ID_MASK                                                          0x00FFL
#define BIF_CFG_DEV0_EPF0_PCIE_CAP_LIST__NEXT_PTR_MASK                                                        0xFF00L
//BIF_CFG_DEV0_EPF0_PCIE_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_CAP__VERSION__SHIFT                                                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_CAP__DEVICE_TYPE__SHIFT                                                        0x4
#define BIF_CFG_DEV0_EPF0_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF0_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                    0x9
#define BIF_CFG_DEV0_EPF0_PCIE_CAP__VERSION_MASK                                                              0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_CAP__DEVICE_TYPE_MASK                                                          0x00F0L
#define BIF_CFG_DEV0_EPF0_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                     0x0100L
#define BIF_CFG_DEV0_EPF0_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                      0x3E00L
//BIF_CFG_DEV0_EPF0_DEVICE_CAP
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                     0x3
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                     0x5
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                           0x6
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                            0x9
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                         0xf
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT                                        0x12
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT                                        0x1a
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                      0x1c
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                                0x00000007L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__PHANTOM_FUNC_MASK                                                       0x00000018L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__EXTENDED_TAG_MASK                                                       0x00000020L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                             0x000001C0L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                              0x00000E00L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                           0x00008000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK                                          0x03FC0000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK                                          0x0C000000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP__FLR_CAPABLE_MASK                                                        0x10000000L
//BIF_CFG_DEV0_EPF0_DEVICE_CNTL
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                                0x1
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                    0x2
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                   0x3
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                  0x4
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                                 0x8
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                                 0x9
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                                 0xa
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                     0xb
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                           0xc
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__INITIATE_FLR__SHIFT                                                    0xf
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__CORR_ERR_EN_MASK                                                       0x0001L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                  0x0002L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                      0x0004L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__USR_REPORT_EN_MASK                                                     0x0008L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                    0x0010L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                  0x00E0L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                   0x0100L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                   0x0200L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                   0x0400L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                       0x0800L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                             0x7000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL__INITIATE_FLR_MASK                                                      0x8000L
//BIF_CFG_DEV0_EPF0_DEVICE_STATUS
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__CORR_ERR__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                                 0x1
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__FATAL_ERR__SHIFT                                                     0x2
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__USR_DETECTED__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__AUX_PWR__SHIFT                                                       0x4
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                             0x5
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED__SHIFT                                 0x6
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__CORR_ERR_MASK                                                        0x0001L
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                   0x0002L
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__FATAL_ERR_MASK                                                       0x0004L
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__USR_DETECTED_MASK                                                    0x0008L
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__AUX_PWR_MASK                                                         0x0010L
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                               0x0020L
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED_MASK                                   0x0040L
//BIF_CFG_DEV0_EPF0_LINK_CAP
#define BIF_CFG_DEV0_EPF0_LINK_CAP__LINK_SPEED__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF0_LINK_CAP__LINK_WIDTH__SHIFT                                                         0x4
#define BIF_CFG_DEV0_EPF0_LINK_CAP__PM_SUPPORT__SHIFT                                                         0xa
#define BIF_CFG_DEV0_EPF0_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                   0xc
#define BIF_CFG_DEV0_EPF0_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                    0xf
#define BIF_CFG_DEV0_EPF0_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                             0x12
#define BIF_CFG_DEV0_EPF0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                        0x13
#define BIF_CFG_DEV0_EPF0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                        0x14
#define BIF_CFG_DEV0_EPF0_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                           0x15
#define BIF_CFG_DEV0_EPF0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                        0x16
#define BIF_CFG_DEV0_EPF0_LINK_CAP__PORT_NUMBER__SHIFT                                                        0x18
#define BIF_CFG_DEV0_EPF0_LINK_CAP__LINK_SPEED_MASK                                                           0x0000000FL
#define BIF_CFG_DEV0_EPF0_LINK_CAP__LINK_WIDTH_MASK                                                           0x000003F0L
#define BIF_CFG_DEV0_EPF0_LINK_CAP__PM_SUPPORT_MASK                                                           0x00000C00L
#define BIF_CFG_DEV0_EPF0_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                     0x00007000L
#define BIF_CFG_DEV0_EPF0_LINK_CAP__L1_EXIT_LATENCY_MASK                                                      0x00038000L
#define BIF_CFG_DEV0_EPF0_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                               0x00040000L
#define BIF_CFG_DEV0_EPF0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                          0x00080000L
#define BIF_CFG_DEV0_EPF0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                          0x00100000L
#define BIF_CFG_DEV0_EPF0_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                             0x00200000L
#define BIF_CFG_DEV0_EPF0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                          0x00400000L
#define BIF_CFG_DEV0_EPF0_LINK_CAP__PORT_NUMBER_MASK                                                          0xFF000000L
//BIF_CFG_DEV0_EPF0_LINK_CNTL
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__PM_CONTROL__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B__SHIFT                                      0x2
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                                 0x3
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__LINK_DIS__SHIFT                                                          0x4
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__RETRAIN_LINK__SHIFT                                                      0x5
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                  0x6
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                     0x7
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                         0x8
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                       0x9
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                         0xa
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                         0xb
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__DRS_SIGNALING_CONTROL__SHIFT                                             0xe
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__PM_CONTROL_MASK                                                          0x0003L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B_MASK                                        0x0004L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                   0x0008L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__LINK_DIS_MASK                                                            0x0010L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__RETRAIN_LINK_MASK                                                        0x0020L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                    0x0040L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__EXTENDED_SYNC_MASK                                                       0x0080L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                           0x0100L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                         0x0200L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                           0x0400L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                           0x0800L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL__DRS_SIGNALING_CONTROL_MASK                                               0xC000L
//BIF_CFG_DEV0_EPF0_LINK_STATUS
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                           0x4
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__LINK_TRAINING__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                  0xc
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__DL_ACTIVE__SHIFT                                                       0xd
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                       0xe
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                       0xf
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                                0x000FL
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                             0x03F0L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__LINK_TRAINING_MASK                                                     0x0800L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                    0x1000L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__DL_ACTIVE_MASK                                                         0x2000L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                         0x4000L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                         0x8000L
//BIF_CFG_DEV0_EPF0_DEVICE_CAP2
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                       0x4
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                        0x5
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                      0x6
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                      0x7
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                      0x8
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                       0xa
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__LN_SYSTEM_CLS__SHIFT                                                   0xe
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED__SHIFT                                 0x10
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED__SHIFT                                 0x11
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                  0x12
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                    0x14
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                    0x15
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                        0x16
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED__SHIFT                                  0x18
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ__SHIFT                                   0x1a
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__FRS_SUPPORTED__SHIFT                                                   0x1f
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                       0x0000000FL
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                         0x00000010L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                          0x00000020L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                        0x00000040L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                        0x00000080L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                        0x00000100L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                            0x00000200L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                         0x00000400L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                     0x00000800L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                                0x00003000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__LN_SYSTEM_CLS_MASK                                                     0x0000C000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED_MASK                                   0x00010000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED_MASK                                   0x00020000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                    0x000C0000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                      0x00100000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                      0x00200000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                          0x00C00000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED_MASK                                    0x03000000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ_MASK                                     0x04000000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CAP2__FRS_SUPPORTED_MASK                                                     0x80000000L
//BIF_CFG_DEV0_EPF0_DEVICE_CNTL2
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                                0x4
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                            0x6
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                       0x7
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                             0x8
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__LTR_EN__SHIFT                                                         0xa
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST__SHIFT                                   0xb
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE__SHIFT                                   0xc
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__OBFF_EN__SHIFT                                                        0xd
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                                0x000FL
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                  0x0010L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                                0x0020L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                              0x0040L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                         0x0080L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                               0x0100L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                            0x0200L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__LTR_EN_MASK                                                           0x0400L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST_MASK                                     0x0800L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE_MASK                                     0x1000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__OBFF_EN_MASK                                                          0x6000L
#define BIF_CFG_DEV0_EPF0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF0_DEVICE_STATUS2
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS2__RESERVED__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF0_DEVICE_STATUS2__RESERVED_MASK                                                       0xFFFFL
//BIF_CFG_DEV0_EPF0_LINK_CAP2
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                              0x1
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT__SHIFT                                          0x10
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT__SHIFT                                         0x17
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT__SHIFT                                         0x18
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__DRS_SUPPORTED__SHIFT                                                     0x1f
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                                0x000000FEL
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                                 0x00000100L
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT_MASK                                            0x0000FE00L
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT_MASK                                            0x007F0000L
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT_MASK                                           0x00800000L
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT_MASK                                           0x01000000L
#define BIF_CFG_DEV0_EPF0_LINK_CAP2__DRS_SUPPORTED_MASK                                                       0x80000000L
//BIF_CFG_DEV0_EPF0_LINK_CNTL2
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                                 0x4
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                      0x5
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                            0x6
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                      0x7
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                             0xa
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                            0xc
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                  0x000FL
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                   0x0010L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                        0x0020L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                              0x0040L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__XMIT_MARGIN_MASK                                                        0x0380L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                               0x0400L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                     0x0800L
#define BIF_CFG_DEV0_EPF0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                              0xF000L
//BIF_CFG_DEV0_EPF0_LINK_STATUS2
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT__SHIFT                                0x2
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT__SHIFT                                0x3
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT__SHIFT                                0x4
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT__SHIFT                                  0x5
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__RTM1_PRESENCE_DET__SHIFT                                              0x6
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__RTM2_PRESENCE_DET__SHIFT                                              0x7
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__CROSSLINK_RESOLUTION__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE__SHIFT                                  0xc
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__DRS_MESSAGE_RECEIVED__SHIFT                                           0xf
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                             0x0001L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT_MASK                                        0x0002L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT_MASK                                  0x0004L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT_MASK                                  0x0008L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT_MASK                                  0x0010L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT_MASK                                    0x0020L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__RTM1_PRESENCE_DET_MASK                                                0x0040L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__RTM2_PRESENCE_DET_MASK                                                0x0080L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__CROSSLINK_RESOLUTION_MASK                                             0x0300L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE_MASK                                    0x7000L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS2__DRS_MESSAGE_RECEIVED_MASK                                             0x8000L
//BIF_CFG_DEV0_EPF0_MSI_CAP_LIST
#define BIF_CFG_DEV0_EPF0_MSI_CAP_LIST__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF0_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV0_EPF0_MSI_CAP_LIST__CAP_ID_MASK                                                           0x00FFL
#define BIF_CFG_DEV0_EPF0_MSI_CAP_LIST__NEXT_PTR_MASK                                                         0xFF00L
//BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_EN__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                  0x1
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                   0x4
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                      0x7
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                      0x8
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP__SHIFT                                           0x9
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN__SHIFT                                            0xa
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_EN_MASK                                                           0x0001L
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                    0x000EL
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                     0x0070L
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_64BIT_MASK                                                        0x0080L
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                        0x0100L
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP_MASK                                             0x0200L
#define BIF_CFG_DEV0_EPF0_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN_MASK                                              0x0400L
//BIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                             0x2
#define BIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                               0xFFFFFFFCL
//BIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_MSI_MSG_DATA
#define BIF_CFG_DEV0_EPF0_MSI_MSG_DATA__MSI_DATA__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_MSI_MSG_DATA__MSI_DATA_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA
#define BIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA__MSI_EXT_DATA__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA__MSI_EXT_DATA_MASK                                                 0xFFFFL
//BIF_CFG_DEV0_EPF0_MSI_MASK
#define BIF_CFG_DEV0_EPF0_MSI_MASK__MSI_MASK__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF0_MSI_MASK__MSI_MASK_MASK                                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_MSI_MSG_DATA_64
#define BIF_CFG_DEV0_EPF0_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF0_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                   0xFFFFL
//BIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA_64
#define BIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64_MASK                                           0xFFFFL
//BIF_CFG_DEV0_EPF0_MSI_MASK_64
#define BIF_CFG_DEV0_EPF0_MSI_MASK_64__MSI_MASK_64__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF0_MSI_MASK_64__MSI_MASK_64_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_MSI_PENDING
#define BIF_CFG_DEV0_EPF0_MSI_PENDING__MSI_PENDING__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF0_MSI_PENDING__MSI_PENDING_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_MSI_PENDING_64
#define BIF_CFG_DEV0_EPF0_MSI_PENDING_64__MSI_PENDING_64__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF0_MSI_PENDING_64__MSI_PENDING_64_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_MSIX_CAP_LIST
#define BIF_CFG_DEV0_EPF0_MSIX_CAP_LIST__CAP_ID__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF0_MSIX_CAP_LIST__NEXT_PTR__SHIFT                                                      0x8
#define BIF_CFG_DEV0_EPF0_MSIX_CAP_LIST__CAP_ID_MASK                                                          0x00FFL
#define BIF_CFG_DEV0_EPF0_MSIX_CAP_LIST__NEXT_PTR_MASK                                                        0xFF00L
//BIF_CFG_DEV0_EPF0_MSIX_MSG_CNTL
#define BIF_CFG_DEV0_EPF0_MSIX_MSG_CNTL__MSIX_TABLE_SIZE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF0_MSIX_MSG_CNTL__MSIX_FUNC_MASK__SHIFT                                                0xe
#define BIF_CFG_DEV0_EPF0_MSIX_MSG_CNTL__MSIX_EN__SHIFT                                                       0xf
#define BIF_CFG_DEV0_EPF0_MSIX_MSG_CNTL__MSIX_TABLE_SIZE_MASK                                                 0x07FFL
#define BIF_CFG_DEV0_EPF0_MSIX_MSG_CNTL__MSIX_FUNC_MASK_MASK                                                  0x4000L
#define BIF_CFG_DEV0_EPF0_MSIX_MSG_CNTL__MSIX_EN_MASK                                                         0x8000L
//BIF_CFG_DEV0_EPF0_MSIX_TABLE
#define BIF_CFG_DEV0_EPF0_MSIX_TABLE__MSIX_TABLE_BIR__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF0_MSIX_TABLE__MSIX_TABLE_OFFSET__SHIFT                                                0x3
#define BIF_CFG_DEV0_EPF0_MSIX_TABLE__MSIX_TABLE_BIR_MASK                                                     0x00000007L
#define BIF_CFG_DEV0_EPF0_MSIX_TABLE__MSIX_TABLE_OFFSET_MASK                                                  0xFFFFFFF8L
//BIF_CFG_DEV0_EPF0_MSIX_PBA
#define BIF_CFG_DEV0_EPF0_MSIX_PBA__MSIX_PBA_BIR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_MSIX_PBA__MSIX_PBA_OFFSET__SHIFT                                                    0x3
#define BIF_CFG_DEV0_EPF0_MSIX_PBA__MSIX_PBA_BIR_MASK                                                         0x00000007L
#define BIF_CFG_DEV0_EPF0_MSIX_PBA__MSIX_PBA_OFFSET_MASK                                                      0xFFFFFFF8L
//BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                   0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                  0x14
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                      0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                     0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                    0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                           0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                        0x14
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                             0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                          0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_VC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT                                                0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                               0x14
#define BIF_CFG_DEV0_EPF0_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK                                                   0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK                                                  0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK                                                 0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT                             0x4
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT                             0xa
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK                                            0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK                               0x00000070L
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK                                                 0x00000300L
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK                               0x00000C00L
//BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG2
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT                                   0x18
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK                                              0x000000FFL
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK                                     0xFF000000L
//BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT                                             0x1
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK                                           0x0001L
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK                                               0x000EL
//BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_STATUS
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK                                       0x0001L
//BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                        0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                 0x18
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK                                            0x000000FFL
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                      0x00008000L
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                          0x007F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                   0xFF000000L
//BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                  0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                      0x11
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT                                                0x18
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT                                            0x1f
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                          0x00000001L
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                        0x000000FEL
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                    0x00010000L
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                        0x000E0000L
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK                                                  0x07000000L
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK                                              0x80000000L
//BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_STATUS
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                              0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                             0x1
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                0x0001L
#define BIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                               0x0002L
//BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                        0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                 0x18
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK                                            0x000000FFL
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                      0x00008000L
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                          0x003F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                   0xFF000000L
//BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                  0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                      0x11
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT                                                0x18
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT                                            0x1f
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                          0x00000001L
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                        0x000000FEL
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                    0x00010000L
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                        0x000E0000L
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK                                                  0x07000000L
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK                                              0x80000000L
//BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_STATUS
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                              0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                             0x1
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                0x0001L
#define BIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                               0x0002L
//BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT                                    0x10
#define BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT                                   0x14
#define BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK                                       0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK                                      0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK                                     0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW1
#define BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW2
#define BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                       0x10
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                         0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                        0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                       0x4
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                    0x5
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                       0xc
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                        0xd
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                   0xe
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                                 0xf
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                      0x11
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                       0x12
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                      0x13
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                                0x14
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                                 0x15
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                                0x16
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                                0x17
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                       0x18
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                        0x19
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS__SHIFT                   0x1a
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                         0x00000010L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                      0x00000020L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                         0x00001000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                          0x00002000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                     0x00004000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                   0x00008000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                       0x00010000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                        0x00020000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                         0x00040000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                        0x00080000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                  0x00100000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                   0x00200000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                  0x00400000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                  0x00800000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                         0x01000000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                          0x02000000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS_MASK                     0x04000000L
//BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                           0x4
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                        0x5
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                           0xc
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                            0xd
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                       0xe
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                     0xf
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                         0x10
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                          0x11
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                           0x12
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                          0x13
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                    0x14
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                     0x15
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                    0x16
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                    0x17
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                           0x18
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                            0x19
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__POISONED_TLP_EGRESS_BLOCKED_MASK__SHIFT                       0x1a
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                             0x00000010L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                          0x00000020L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                             0x00001000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                              0x00002000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                         0x00004000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                       0x00008000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                           0x00010000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                            0x00020000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                             0x00040000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                            0x00080000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                      0x00100000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                       0x00200000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                      0x00400000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                      0x00800000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                             0x01000000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                              0x02000000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK__POISONED_TLP_EGRESS_BLOCKED_MASK_MASK                         0x04000000L
//BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                   0x4
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                                0x5
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                   0xc
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                    0xd
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                               0xe
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                             0xf
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                                 0x10
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                  0x11
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                   0x12
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                  0x13
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                            0x14
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                             0x15
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                            0x16
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                            0x17
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                   0x18
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                    0x19
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__POISONED_TLP_EGRESS_BLOCKED_SEVERITY__SHIFT               0x1a
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                     0x00000010L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                  0x00000020L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                     0x00001000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                      0x00002000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                                 0x00004000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                               0x00008000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                   0x00010000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                    0x00020000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                     0x00040000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                    0x00080000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                              0x00100000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                               0x00200000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                              0x00400000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                              0x00800000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                     0x01000000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                      0x02000000L
#define BIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY__POISONED_TLP_EGRESS_BLOCKED_SEVERITY_MASK                 0x04000000L
//BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                         0x6
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                        0x7
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                             0x8
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                            0xc
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                           0xd
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                    0xe
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                           0x00000001L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                           0x00000040L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                          0x00000080L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                               0x00000100L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                              0x00001000L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                             0x00002000L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                      0x00004000L
//BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                             0x6
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                            0x7
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                                 0x8
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                                0xc
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                               0xd
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                        0xe
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                               0x00000001L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                               0x00000040L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                              0x00000080L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                   0x00000100L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                  0x00001000L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                                 0x00002000L
#define BIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                          0x00004000L
//BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                          0x5
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                           0x6
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                        0x7
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                         0x8
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                    0x9
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                     0xa
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                           0x0000001FL
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                            0x00000020L
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                             0x00000040L
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                          0x00000080L
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                           0x00000100L
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                      0x00000200L
#define BIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                       0x00000400L
//BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG0
#define BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG0__TLP_HDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG1
#define BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG1__TLP_HDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG2
#define BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG2__TLP_HDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG3
#define BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_HDR_LOG3__TLP_HDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG0
#define BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG1
#define BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG2
#define BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG3
#define BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_BAR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_BAR_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_BAR_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF0_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF0_PCIE_BAR_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_BAR_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_BAR1_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_BAR2_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_BAR3_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_BAR4_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_BAR5_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_BAR6_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER__SHIFT                                        0x10
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR__SHIFT                                       0x14
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID_MASK                                           0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER_MASK                                          0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR_MASK                                         0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA_SELECT
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT_MASK                                       0xFFL
//BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__BASE_POWER__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__DATA_SCALE__SHIFT                                             0x8
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE__SHIFT                                           0xa
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__PM_STATE__SHIFT                                               0xd
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__TYPE__SHIFT                                                   0xf
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__POWER_RAIL__SHIFT                                             0x12
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__BASE_POWER_MASK                                               0x000000FFL
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__DATA_SCALE_MASK                                               0x00000300L
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE_MASK                                             0x00001C00L
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__PM_STATE_MASK                                                 0x00006000L
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__TYPE_MASK                                                     0x00038000L
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA__POWER_RAIL_MASK                                               0x001C0000L
//BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED_MASK                                          0x01L
//BIF_CFG_DEV0_EPF0_PCIE_DPA_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_DPA_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CAP__SUBSTATE_MAX__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CAP__TRANS_LAT_UNIT__SHIFT                                                 0x8
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CAP__PWR_ALLOC_SCALE__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CAP__TRANS_LAT_VAL_0__SHIFT                                                0x10
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CAP__TRANS_LAT_VAL_1__SHIFT                                                0x18
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CAP__SUBSTATE_MAX_MASK                                                     0x0000001FL
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CAP__TRANS_LAT_UNIT_MASK                                                   0x00000300L
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CAP__PWR_ALLOC_SCALE_MASK                                                  0x00003000L
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CAP__TRANS_LAT_VAL_0_MASK                                                  0x00FF0000L
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CAP__TRANS_LAT_VAL_1_MASK                                                  0xFF000000L
//BIF_CFG_DEV0_EPF0_PCIE_DPA_LATENCY_INDICATOR
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS_MASK                           0x000000FFL
//BIF_CFG_DEV0_EPF0_PCIE_DPA_STATUS
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_STATUS__SUBSTATE_STATUS__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED__SHIFT                                       0x8
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_STATUS__SUBSTATE_STATUS_MASK                                               0x001FL
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED_MASK                                         0x0100L
//BIF_CFG_DEV0_EPF0_PCIE_DPA_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CNTL__SUBSTATE_CNTL__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_CNTL__SUBSTATE_CNTL_MASK                                                   0x001FL
//BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF0_PCIE_SECONDARY_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT                                         0x10
#define BIF_CFG_DEV0_EPF0_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT                                        0x14
#define BIF_CFG_DEV0_EPF0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK                                           0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK                                          0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_LINK_CNTL3
#define BIF_CFG_DEV0_EPF0_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT                                0x1
#define BIF_CFG_DEV0_EPF0_PCIE_LINK_CNTL3__ENABLE_LOWER_SKP_OS_GEN__SHIFT                                     0x9
#define BIF_CFG_DEV0_EPF0_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK                                          0x00000001L
#define BIF_CFG_DEV0_EPF0_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK                                  0x00000002L
#define BIF_CFG_DEV0_EPF0_PCIE_LINK_CNTL3__ENABLE_LOWER_SKP_OS_GEN_MASK                                       0x0000FE00L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_ERROR_STATUS
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT                               0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK                                 0x0000FFFFL
//BIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF0_PCIE_ACS_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                           0x1
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                           0x2
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                        0x3
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                             0x5
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                          0x6
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                     0x8
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                                0x0001L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                             0x0002L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                             0x0004L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                          0x0008L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                              0x0010L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                               0x0020L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                            0x0040L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                       0xFF00L
//BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                       0x1
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                       0x2
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                    0x3
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                        0x4
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                         0x5
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                      0x6
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                            0x0001L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                         0x0002L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                         0x0004L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                      0x0008L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                          0x0010L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                           0x0020L
#define BIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                        0x0040L
//BIF_CFG_DEV0_EPF0_PCIE_ATS_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_ATS_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CAP__INVALIDATE_Q_DEPTH__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST__SHIFT                                           0x5
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED__SHIFT                                    0x6
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CAP__RELAXED_ORDERING_SUPPORTED__SHIFT                                     0x7
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CAP__INVALIDATE_Q_DEPTH_MASK                                               0x001FL
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST_MASK                                             0x0020L
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED_MASK                                      0x0040L
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CAP__RELAXED_ORDERING_SUPPORTED_MASK                                       0x0080L
//BIF_CFG_DEV0_EPF0_PCIE_ATS_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CNTL__STU__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CNTL__ATC_ENABLE__SHIFT                                                    0xf
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CNTL__STU_MASK                                                             0x001FL
#define BIF_CFG_DEV0_EPF0_PCIE_ATS_CNTL__ATC_ENABLE_MASK                                                      0x8000L
//BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER__SHIFT                                          0x10
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR__SHIFT                                         0x14
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID_MASK                                             0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER_MASK                                            0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR_MASK                                           0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_CNTL__PRI_ENABLE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_CNTL__PRI_RESET__SHIFT                                                0x1
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_CNTL__PRI_ENABLE_MASK                                                 0x0001L
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_CNTL__PRI_RESET_MASK                                                  0x0002L
//BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_STATUS
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX__SHIFT                          0x1
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_STATUS__STOPPED__SHIFT                                                0x8
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED__SHIFT                            0xf
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE_MASK                                         0x0001L
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX_MASK                            0x0002L
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_STATUS__STOPPED_MASK                                                  0x0100L
#define BIF_CFG_DEV0_EPF0_PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED_MASK                              0x8000L
//BIF_CFG_DEV0_EPF0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY
#define BIF_CFG_DEV0_EPF0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY_MASK                    0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_OUTSTAND_PAGE_REQ_ALLOC
#define BIF_CFG_DEV0_EPF0_PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC_MASK                          0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_PASID_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_PASID_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED__SHIFT                               0x1
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED__SHIFT                                    0x2
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CAP__MAX_PASID_WIDTH__SHIFT                                              0x8
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED_MASK                                 0x0002L
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED_MASK                                      0x0004L
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CAP__MAX_PASID_WIDTH_MASK                                                0x1F00L
//BIF_CFG_DEV0_EPF0_PCIE_PASID_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CNTL__PASID_ENABLE__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE__SHIFT                                 0x1
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE__SHIFT                            0x2
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CNTL__PASID_ENABLE_MASK                                                  0x0001L
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE_MASK                                   0x0002L
#define BIF_CFG_DEV0_EPF0_PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE_MASK                              0x0004L
//BIF_CFG_DEV0_EPF0_PCIE_MC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ENH_CAP_LIST__CAP_ID__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ENH_CAP_LIST__CAP_VER__SHIFT                                                0x10
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                               0x14
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ENH_CAP_LIST__CAP_ID_MASK                                                   0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ENH_CAP_LIST__CAP_VER_MASK                                                  0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ENH_CAP_LIST__NEXT_PTR_MASK                                                 0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_MC_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_MC_CAP__MC_MAX_GROUP__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_CAP__MC_WIN_SIZE_REQ__SHIFT                                                 0x8
#define BIF_CFG_DEV0_EPF0_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP__SHIFT                                              0xf
#define BIF_CFG_DEV0_EPF0_PCIE_MC_CAP__MC_MAX_GROUP_MASK                                                      0x003FL
#define BIF_CFG_DEV0_EPF0_PCIE_MC_CAP__MC_WIN_SIZE_REQ_MASK                                                   0x3F00L
#define BIF_CFG_DEV0_EPF0_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP_MASK                                                0x8000L
//BIF_CFG_DEV0_EPF0_PCIE_MC_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_MC_CNTL__MC_NUM_GROUP__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_CNTL__MC_ENABLE__SHIFT                                                      0xf
#define BIF_CFG_DEV0_EPF0_PCIE_MC_CNTL__MC_NUM_GROUP_MASK                                                     0x003FL
#define BIF_CFG_DEV0_EPF0_PCIE_MC_CNTL__MC_ENABLE_MASK                                                        0x8000L
//BIF_CFG_DEV0_EPF0_PCIE_MC_ADDR0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ADDR0__MC_INDEX_POS__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ADDR0__MC_BASE_ADDR_0__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ADDR0__MC_INDEX_POS_MASK                                                    0x0000003FL
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ADDR0__MC_BASE_ADDR_0_MASK                                                  0xFFFFF000L
//BIF_CFG_DEV0_EPF0_PCIE_MC_ADDR1
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ADDR1__MC_BASE_ADDR_1__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_ADDR1__MC_BASE_ADDR_1_MASK                                                  0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_MC_RCV0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_RCV0__MC_RECEIVE_0__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_RCV0__MC_RECEIVE_0_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_MC_RCV1
#define BIF_CFG_DEV0_EPF0_PCIE_MC_RCV1__MC_RECEIVE_1__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_RCV1__MC_RECEIVE_1_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_ALL0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_ALL1
#define BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_UNTRANSLATED_0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0_MASK                          0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_UNTRANSLATED_1
#define BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1_MASK                          0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_LTR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_LTR_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE__SHIFT                                        0xa
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE__SHIFT                                       0x10
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE__SHIFT                                       0x1a
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE_MASK                                          0x000003FFL
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE_MASK                                          0x00001C00L
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE_MASK                                         0x03FF0000L
#define BIF_CFG_DEV0_EPF0_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE_MASK                                         0x1C000000L
//BIF_CFG_DEV0_EPF0_PCIE_ARI_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_ARI_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP__SHIFT                                        0x1
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM__SHIFT                                              0x8
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP_MASK                                         0x0001L
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP_MASK                                          0x0002L
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM_MASK                                                0xFF00L
//BIF_CFG_DEV0_EPF0_PCIE_ARI_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN__SHIFT                                        0x1
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN_MASK                                         0x0001L
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN_MASK                                          0x0002L
#define BIF_CFG_DEV0_EPF0_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP_MASK                                              0x0070L
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CAP__SRIOV_ARI_CAP_HIERARCHY_PRESERVED__SHIFT                            0x1
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CAP__SRIOV_VF_TEN_BIT_TAG_REQUESTER_SUPPORTED__SHIFT                     0x2
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CAP__SRIOV_ARI_CAP_HIERARCHY_PRESERVED_MASK                              0x00000002L
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CAP__SRIOV_VF_TEN_BIT_TAG_REQUESTER_SUPPORTED_MASK                       0x00000004L
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL__SRIOV_VF_ENABLE__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL__SRIOV_VF_MSE__SHIFT                                             0x3
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL__SRIOV_ARI_CAP_HIERARCHY__SHIFT                                  0x4
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL__SRIOV_VF_TEN_BIT_TAG_REQUESTER_ENABLE__SHIFT                    0x5
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL__SRIOV_VF_ENABLE_MASK                                            0x0001L
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL__SRIOV_VF_MSE_MASK                                               0x0008L
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL__SRIOV_ARI_CAP_HIERARCHY_MASK                                    0x0010L
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL__SRIOV_VF_TEN_BIT_TAG_REQUESTER_ENABLE_MASK                      0x0020L
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_STATUS
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_INITIAL_VFS
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_INITIAL_VFS__SRIOV_INITIAL_VFS__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_INITIAL_VFS__SRIOV_INITIAL_VFS_MASK                                      0xFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_TOTAL_VFS
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_TOTAL_VFS__SRIOV_TOTAL_VFS__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_TOTAL_VFS__SRIOV_TOTAL_VFS_MASK                                          0xFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_NUM_VFS
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_NUM_VFS__SRIOV_NUM_VFS__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_NUM_VFS__SRIOV_NUM_VFS_MASK                                              0xFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_FUNC_DEP_LINK
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_FUNC_DEP_LINK__SRIOV_FUNC_DEP_LINK__SHIFT                                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_FUNC_DEP_LINK__SRIOV_FUNC_DEP_LINK_MASK                                  0xFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_FIRST_VF_OFFSET
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_FIRST_VF_OFFSET__SRIOV_FIRST_VF_OFFSET__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_FIRST_VF_OFFSET__SRIOV_FIRST_VF_OFFSET_MASK                              0xFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_STRIDE
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_STRIDE__SRIOV_VF_STRIDE__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_STRIDE__SRIOV_VF_STRIDE_MASK                                          0xFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_DEVICE_ID
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_DEVICE_ID__SRIOV_VF_DEVICE_ID__SHIFT                                  0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_DEVICE_ID__SRIOV_VF_DEVICE_ID_MASK                                    0xFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE__SRIOV_SUPPORTED_PAGE_SIZE__SHIFT                    0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE__SRIOV_SUPPORTED_PAGE_SIZE_MASK                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_SYSTEM_PAGE_SIZE
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_SYSTEM_PAGE_SIZE__SRIOV_SYSTEM_PAGE_SIZE__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_SYSTEM_PAGE_SIZE__SRIOV_SYSTEM_PAGE_SIZE_MASK                            0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_0__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_0__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_1
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_1__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_1__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_2
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_2__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_2__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_3
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_3__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_3__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_4
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_4__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_4__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_5
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_5__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_5__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_PCIE_DLF_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_DLF_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_DLF_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF0_PCIE_DLF_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF0_PCIE_DLF_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_DLF_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_DLF_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_CAP
#define BIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_CAP__LOCAL_DLF_SUPPORTED__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_CAP__DLF_EXCHANGE_ENABLE__SHIFT                                   0x1f
#define BIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_CAP__LOCAL_DLF_SUPPORTED_MASK                                     0x007FFFFFL
#define BIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_CAP__DLF_EXCHANGE_ENABLE_MASK                                     0x80000000L
//BIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_STATUS
#define BIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED__SHIFT                               0x0
#define BIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_VALID__SHIFT                         0x1f
#define BIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_MASK                                 0x007FFFFFL
#define BIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_VALID_MASK                           0x80000000L
//BIF_CFG_DEV0_EPF0_PCIE_PHY_16GT_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_ID__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF0_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_VER__SHIFT                                          0x10
#define BIF_CFG_DEV0_EPF0_PCIE_PHY_16GT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                         0x14
#define BIF_CFG_DEV0_EPF0_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_ID_MASK                                             0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_VER_MASK                                            0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_PHY_16GT_ENH_CAP_LIST__NEXT_PTR_MASK                                           0xFFF00000L
//BIF_CFG_DEV0_EPF0_LINK_CAP_16GT
#define BIF_CFG_DEV0_EPF0_LINK_CAP_16GT__RESERVED__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF0_LINK_CAP_16GT__RESERVED_MASK                                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_LINK_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LINK_CNTL_16GT__RESERVED__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF0_LINK_CNTL_16GT__RESERVED_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF0_LINK_STATUS_16GT
#define BIF_CFG_DEV0_EPF0_LINK_STATUS_16GT__EQUALIZATION_COMPLETE_16GT__SHIFT                                 0x0
#define BIF_CFG_DEV0_EPF0_LINK_STATUS_16GT__EQUALIZATION_PHASE1_SUCCESS_16GT__SHIFT                           0x1
#define BIF_CFG_DEV0_EPF0_LINK_STATUS_16GT__EQUALIZATION_PHASE2_SUCCESS_16GT__SHIFT                           0x2
#define BIF_CFG_DEV0_EPF0_LINK_STATUS_16GT__EQUALIZATION_PHASE3_SUCCESS_16GT__SHIFT                           0x3
#define BIF_CFG_DEV0_EPF0_LINK_STATUS_16GT__LINK_EQUALIZATION_REQUEST_16GT__SHIFT                             0x4
#define BIF_CFG_DEV0_EPF0_LINK_STATUS_16GT__EQUALIZATION_COMPLETE_16GT_MASK                                   0x00000001L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS_16GT__EQUALIZATION_PHASE1_SUCCESS_16GT_MASK                             0x00000002L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS_16GT__EQUALIZATION_PHASE2_SUCCESS_16GT_MASK                             0x00000004L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS_16GT__EQUALIZATION_PHASE3_SUCCESS_16GT_MASK                             0x00000008L
#define BIF_CFG_DEV0_EPF0_LINK_STATUS_16GT__LINK_EQUALIZATION_REQUEST_16GT_MASK                               0x00000010L
//BIF_CFG_DEV0_EPF0_LOCAL_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV0_EPF0_LOCAL_PARITY_MISMATCH_STATUS_16GT__LOCAL_PARITY_MISMATCH_STATUS_BITS__SHIFT         0x0
#define BIF_CFG_DEV0_EPF0_LOCAL_PARITY_MISMATCH_STATUS_16GT__LOCAL_PARITY_MISMATCH_STATUS_BITS_MASK           0x0000FFFFL
//BIF_CFG_DEV0_EPF0_RTM1_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV0_EPF0_RTM1_PARITY_MISMATCH_STATUS_16GT__RTM1_PARITY_MISMATCH_STATUS_BITS__SHIFT           0x0
#define BIF_CFG_DEV0_EPF0_RTM1_PARITY_MISMATCH_STATUS_16GT__RTM1_PARITY_MISMATCH_STATUS_BITS_MASK             0x0000FFFFL
//BIF_CFG_DEV0_EPF0_RTM2_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV0_EPF0_RTM2_PARITY_MISMATCH_STATUS_16GT__RTM2_PARITY_MISMATCH_STATUS_BITS__SHIFT           0x0
#define BIF_CFG_DEV0_EPF0_RTM2_PARITY_MISMATCH_STATUS_16GT__RTM2_PARITY_MISMATCH_STATUS_BITS_MASK             0x0000FFFFL
//BIF_CFG_DEV0_EPF0_LANE_0_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF0_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF0_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF0_LANE_1_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF0_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF0_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF0_LANE_2_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF0_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF0_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF0_LANE_3_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF0_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF0_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF0_LANE_4_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF0_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF0_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF0_LANE_5_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF0_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF0_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF0_LANE_6_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF0_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF0_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF0_LANE_7_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF0_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF0_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF0_LANE_8_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF0_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF0_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF0_LANE_9_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF0_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF0_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF0_LANE_10_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF0_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF0_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF0_LANE_11_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF0_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF0_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF0_LANE_12_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF0_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF0_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF0_LANE_13_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF0_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF0_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF0_LANE_14_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF0_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF0_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF0_LANE_15_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF0_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF0_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF0_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF0_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF0_PCIE_MARGINING_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_MARGINING_ENH_CAP_LIST__CAP_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF0_PCIE_MARGINING_ENH_CAP_LIST__CAP_VER__SHIFT                                         0x10
#define BIF_CFG_DEV0_EPF0_PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR__SHIFT                                        0x14
#define BIF_CFG_DEV0_EPF0_PCIE_MARGINING_ENH_CAP_LIST__CAP_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_MARGINING_ENH_CAP_LIST__CAP_VER_MASK                                           0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR_MASK                                          0xFFF00000L
//BIF_CFG_DEV0_EPF0_MARGINING_PORT_CAP
#define BIF_CFG_DEV0_EPF0_MARGINING_PORT_CAP__MARGINING_USES_SOFTWARE__SHIFT                                  0x0
#define BIF_CFG_DEV0_EPF0_MARGINING_PORT_CAP__MARGINING_USES_SOFTWARE_MASK                                    0x0001L
//BIF_CFG_DEV0_EPF0_MARGINING_PORT_STATUS
#define BIF_CFG_DEV0_EPF0_MARGINING_PORT_STATUS__MARGINING_READY__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF0_MARGINING_PORT_STATUS__MARGINING_SOFTWARE_READY__SHIFT                              0x1
#define BIF_CFG_DEV0_EPF0_MARGINING_PORT_STATUS__MARGINING_READY_MASK                                         0x0001L
#define BIF_CFG_DEV0_EPF0_MARGINING_PORT_STATUS__MARGINING_SOFTWARE_READY_MASK                                0x0002L
//BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL__LANE_0_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL__LANE_0_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL__LANE_0_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL__LANE_0_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS__LANE_0_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS__LANE_0_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS__LANE_0_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS__LANE_0_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL__LANE_1_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL__LANE_1_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL__LANE_1_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL__LANE_1_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS__LANE_1_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS__LANE_1_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS__LANE_1_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS__LANE_1_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL__LANE_2_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL__LANE_2_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL__LANE_2_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL__LANE_2_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS__LANE_2_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS__LANE_2_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS__LANE_2_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS__LANE_2_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL__LANE_3_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL__LANE_3_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL__LANE_3_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL__LANE_3_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS__LANE_3_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS__LANE_3_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS__LANE_3_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS__LANE_3_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL__LANE_4_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL__LANE_4_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL__LANE_4_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL__LANE_4_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS__LANE_4_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS__LANE_4_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS__LANE_4_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS__LANE_4_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL__LANE_5_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL__LANE_5_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL__LANE_5_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL__LANE_5_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS__LANE_5_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS__LANE_5_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS__LANE_5_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS__LANE_5_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL__LANE_6_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL__LANE_6_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL__LANE_6_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL__LANE_6_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS__LANE_6_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS__LANE_6_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS__LANE_6_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS__LANE_6_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL__LANE_7_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL__LANE_7_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL__LANE_7_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL__LANE_7_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS__LANE_7_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS__LANE_7_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS__LANE_7_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS__LANE_7_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL__LANE_8_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL__LANE_8_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL__LANE_8_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL__LANE_8_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS__LANE_8_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS__LANE_8_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS__LANE_8_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS__LANE_8_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL__LANE_9_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL__LANE_9_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL__LANE_9_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL__LANE_9_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS__LANE_9_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS__LANE_9_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS__LANE_9_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS__LANE_9_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL__LANE_10_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL__LANE_10_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL__LANE_10_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL__LANE_10_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS__LANE_10_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS__LANE_10_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS__LANE_10_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS__LANE_10_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL__LANE_11_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL__LANE_11_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL__LANE_11_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL__LANE_11_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS__LANE_11_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS__LANE_11_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS__LANE_11_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS__LANE_11_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL__LANE_12_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL__LANE_12_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL__LANE_12_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL__LANE_12_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS__LANE_12_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS__LANE_12_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS__LANE_12_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS__LANE_12_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL__LANE_13_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL__LANE_13_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL__LANE_13_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL__LANE_13_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS__LANE_13_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS__LANE_13_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS__LANE_13_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS__LANE_13_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL__LANE_14_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL__LANE_14_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL__LANE_14_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL__LANE_14_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS__LANE_14_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS__LANE_14_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS__LANE_14_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS__LANE_14_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL__LANE_15_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL__LANE_15_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL__LANE_15_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL__LANE_15_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS__LANE_15_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS__LANE_15_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS__LANE_15_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS__LANE_15_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__CAP_ID__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__CAP_VER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                    0x14
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__CAP_ID_MASK                                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__CAP_VER_MASK                                       0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__NEXT_PTR_MASK                                      0xFFF00000L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CAP
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF0_PCIE_RTR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF0_PCIE_RTR_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF0_PCIE_RTR_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF0_PCIE_RTR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF0_PCIE_RTR_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF0_PCIE_RTR_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF0_PCIE_RTR_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF0_RTR_DATA1
#define BIF_CFG_DEV0_EPF0_RTR_DATA1__RESET_TIME__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF0_RTR_DATA1__DLUP_TIME__SHIFT                                                         0xc
#define BIF_CFG_DEV0_EPF0_RTR_DATA1__VALID__SHIFT                                                             0x1f
#define BIF_CFG_DEV0_EPF0_RTR_DATA1__RESET_TIME_MASK                                                          0x00000FFFL
#define BIF_CFG_DEV0_EPF0_RTR_DATA1__DLUP_TIME_MASK                                                           0x00FFF000L
#define BIF_CFG_DEV0_EPF0_RTR_DATA1__VALID_MASK                                                               0x80000000L
//BIF_CFG_DEV0_EPF0_RTR_DATA2
#define BIF_CFG_DEV0_EPF0_RTR_DATA2__FLR_TIME__SHIFT                                                          0x0
#define BIF_CFG_DEV0_EPF0_RTR_DATA2__D3HOTD0_TIME__SHIFT                                                      0xc
#define BIF_CFG_DEV0_EPF0_RTR_DATA2__FLR_TIME_MASK                                                            0x00000FFFL
#define BIF_CFG_DEV0_EPF0_RTR_DATA2__D3HOTD0_TIME_MASK                                                        0x00FFF000L
//PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_ID__SHIFT                                               0x0
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_VER__SHIFT                                              0x10
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__NEXT_PTR__SHIFT                                             0x14
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_ID_MASK                                                 0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_VER_MASK                                                0x000F0000L
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__NEXT_PTR_MASK                                               0xFFF00000L


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf1_bifcfgdecp
//BIF_CFG_DEV0_EPF1_VENDOR_ID
#define BIF_CFG_DEV0_EPF1_VENDOR_ID__VENDOR_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF1_VENDOR_ID__VENDOR_ID_MASK                                                           0xFFFFL
//BIF_CFG_DEV0_EPF1_DEVICE_ID
#define BIF_CFG_DEV0_EPF1_DEVICE_ID__DEVICE_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF1_DEVICE_ID__DEVICE_ID_MASK                                                           0xFFFFL
//BIF_CFG_DEV0_EPF1_COMMAND
#define BIF_CFG_DEV0_EPF1_COMMAND__IO_ACCESS_EN__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF1_COMMAND__MEM_ACCESS_EN__SHIFT                                                       0x1
#define BIF_CFG_DEV0_EPF1_COMMAND__BUS_MASTER_EN__SHIFT                                                       0x2
#define BIF_CFG_DEV0_EPF1_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                    0x3
#define BIF_CFG_DEV0_EPF1_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                             0x4
#define BIF_CFG_DEV0_EPF1_COMMAND__PAL_SNOOP_EN__SHIFT                                                        0x5
#define BIF_CFG_DEV0_EPF1_COMMAND__AD_STEPPING__SHIFT                                                         0x7
#define BIF_CFG_DEV0_EPF1_COMMAND__SERR_EN__SHIFT                                                             0x8
#define BIF_CFG_DEV0_EPF1_COMMAND__FAST_B2B_EN__SHIFT                                                         0x9
#define BIF_CFG_DEV0_EPF1_COMMAND__INT_DIS__SHIFT                                                             0xa
#define BIF_CFG_DEV0_EPF1_COMMAND__IO_ACCESS_EN_MASK                                                          0x0001L
#define BIF_CFG_DEV0_EPF1_COMMAND__MEM_ACCESS_EN_MASK                                                         0x0002L
#define BIF_CFG_DEV0_EPF1_COMMAND__BUS_MASTER_EN_MASK                                                         0x0004L
#define BIF_CFG_DEV0_EPF1_COMMAND__SPECIAL_CYCLE_EN_MASK                                                      0x0008L
#define BIF_CFG_DEV0_EPF1_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                               0x0010L
#define BIF_CFG_DEV0_EPF1_COMMAND__PAL_SNOOP_EN_MASK                                                          0x0020L
#define BIF_CFG_DEV0_EPF1_COMMAND__AD_STEPPING_MASK                                                           0x0080L
#define BIF_CFG_DEV0_EPF1_COMMAND__SERR_EN_MASK                                                               0x0100L
#define BIF_CFG_DEV0_EPF1_COMMAND__FAST_B2B_EN_MASK                                                           0x0200L
#define BIF_CFG_DEV0_EPF1_COMMAND__INT_DIS_MASK                                                               0x0400L
//BIF_CFG_DEV0_EPF1_STATUS
#define BIF_CFG_DEV0_EPF1_STATUS__IMMEDIATE_READINESS__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF1_STATUS__INT_STATUS__SHIFT                                                           0x3
#define BIF_CFG_DEV0_EPF1_STATUS__CAP_LIST__SHIFT                                                             0x4
#define BIF_CFG_DEV0_EPF1_STATUS__PCI_66_CAP__SHIFT                                                           0x5
#define BIF_CFG_DEV0_EPF1_STATUS__FAST_BACK_CAPABLE__SHIFT                                                    0x7
#define BIF_CFG_DEV0_EPF1_STATUS__DEVSEL_TIMING__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF1_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                  0xb
#define BIF_CFG_DEV0_EPF1_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF1_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                0xd
#define BIF_CFG_DEV0_EPF1_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                                0xe
#define BIF_CFG_DEV0_EPF1_STATUS__IMMEDIATE_READINESS_MASK                                                    0x0001L
#define BIF_CFG_DEV0_EPF1_STATUS__INT_STATUS_MASK                                                             0x0008L
#define BIF_CFG_DEV0_EPF1_STATUS__CAP_LIST_MASK                                                               0x0010L
#define BIF_CFG_DEV0_EPF1_STATUS__PCI_66_CAP_MASK                                                             0x0020L
#define BIF_CFG_DEV0_EPF1_STATUS__FAST_BACK_CAPABLE_MASK                                                      0x0080L
#define BIF_CFG_DEV0_EPF1_STATUS__DEVSEL_TIMING_MASK                                                          0x0600L
#define BIF_CFG_DEV0_EPF1_STATUS__SIGNAL_TARGET_ABORT_MASK                                                    0x0800L
#define BIF_CFG_DEV0_EPF1_STATUS__RECEIVED_TARGET_ABORT_MASK                                                  0x1000L
#define BIF_CFG_DEV0_EPF1_STATUS__RECEIVED_MASTER_ABORT_MASK                                                  0x2000L
#define BIF_CFG_DEV0_EPF1_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                  0x4000L
//BIF_CFG_DEV0_EPF1_REVISION_ID
#define BIF_CFG_DEV0_EPF1_REVISION_ID__MINOR_REV_ID__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF1_REVISION_ID__MAJOR_REV_ID__SHIFT                                                    0x4
#define BIF_CFG_DEV0_EPF1_REVISION_ID__MINOR_REV_ID_MASK                                                      0x0FL
#define BIF_CFG_DEV0_EPF1_REVISION_ID__MAJOR_REV_ID_MASK                                                      0xF0L
//BIF_CFG_DEV0_EPF1_PROG_INTERFACE
#define BIF_CFG_DEV0_EPF1_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_PROG_INTERFACE__PROG_INTERFACE_MASK                                                 0xFFL
//BIF_CFG_DEV0_EPF1_SUB_CLASS
#define BIF_CFG_DEV0_EPF1_SUB_CLASS__SUB_CLASS__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF1_SUB_CLASS__SUB_CLASS_MASK                                                           0xFFL
//BIF_CFG_DEV0_EPF1_BASE_CLASS
#define BIF_CFG_DEV0_EPF1_BASE_CLASS__BASE_CLASS__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_BASE_CLASS__BASE_CLASS_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF1_CACHE_LINE
#define BIF_CFG_DEV0_EPF1_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF1_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                    0xFFL
//BIF_CFG_DEV0_EPF1_LATENCY
#define BIF_CFG_DEV0_EPF1_LATENCY__LATENCY_TIMER__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_LATENCY__LATENCY_TIMER_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF1_HEADER
#define BIF_CFG_DEV0_EPF1_HEADER__HEADER_TYPE__SHIFT                                                          0x0
#define BIF_CFG_DEV0_EPF1_HEADER__DEVICE_TYPE__SHIFT                                                          0x7
#define BIF_CFG_DEV0_EPF1_HEADER__HEADER_TYPE_MASK                                                            0x7FL
#define BIF_CFG_DEV0_EPF1_HEADER__DEVICE_TYPE_MASK                                                            0x80L
//BIF_CFG_DEV0_EPF1_BIST
#define BIF_CFG_DEV0_EPF1_BIST__BIST_COMP__SHIFT                                                              0x0
#define BIF_CFG_DEV0_EPF1_BIST__BIST_STRT__SHIFT                                                              0x6
#define BIF_CFG_DEV0_EPF1_BIST__BIST_CAP__SHIFT                                                               0x7
#define BIF_CFG_DEV0_EPF1_BIST__BIST_COMP_MASK                                                                0x0FL
#define BIF_CFG_DEV0_EPF1_BIST__BIST_STRT_MASK                                                                0x40L
#define BIF_CFG_DEV0_EPF1_BIST__BIST_CAP_MASK                                                                 0x80L
//BIF_CFG_DEV0_EPF1_BASE_ADDR_1
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_1__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_1__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_BASE_ADDR_2
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_2__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_2__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_BASE_ADDR_3
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_3__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_3__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_BASE_ADDR_4
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_4__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_4__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_BASE_ADDR_5
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_5__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_5__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_BASE_ADDR_6
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_6__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_BASE_ADDR_6__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_ADAPTER_ID
#define BIF_CFG_DEV0_EPF1_ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                     0x10
#define BIF_CFG_DEV0_EPF1_ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_ADAPTER_ID__SUBSYSTEM_ID_MASK                                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF1_ROM_BASE_ADDR
#define BIF_CFG_DEV0_EPF1_ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_ROM_BASE_ADDR__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_CAP_PTR
#define BIF_CFG_DEV0_EPF1_CAP_PTR__CAP_PTR__SHIFT                                                             0x0
#define BIF_CFG_DEV0_EPF1_CAP_PTR__CAP_PTR_MASK                                                               0xFFL
//BIF_CFG_DEV0_EPF1_INTERRUPT_LINE
#define BIF_CFG_DEV0_EPF1_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                                 0xFFL
//BIF_CFG_DEV0_EPF1_INTERRUPT_PIN
#define BIF_CFG_DEV0_EPF1_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF1_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                   0xFFL
//BIF_CFG_DEV0_EPF1_MIN_GRANT
#define BIF_CFG_DEV0_EPF1_MIN_GRANT__MIN_GNT__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF1_MIN_GRANT__MIN_GNT_MASK                                                             0xFFL
//BIF_CFG_DEV0_EPF1_MAX_LATENCY
#define BIF_CFG_DEV0_EPF1_MAX_LATENCY__MAX_LAT__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF1_MAX_LATENCY__MAX_LAT_MASK                                                           0xFFL
//BIF_CFG_DEV0_EPF1_VENDOR_CAP_LIST
#define BIF_CFG_DEV0_EPF1_VENDOR_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF1_VENDOR_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF1_VENDOR_CAP_LIST__LENGTH__SHIFT                                                      0x10
#define BIF_CFG_DEV0_EPF1_VENDOR_CAP_LIST__CAP_ID_MASK                                                        0x000000FFL
#define BIF_CFG_DEV0_EPF1_VENDOR_CAP_LIST__NEXT_PTR_MASK                                                      0x0000FF00L
#define BIF_CFG_DEV0_EPF1_VENDOR_CAP_LIST__LENGTH_MASK                                                        0x00FF0000L
//BIF_CFG_DEV0_EPF1_ADAPTER_ID_W
#define BIF_CFG_DEV0_EPF1_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF1_ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT                                                   0x10
#define BIF_CFG_DEV0_EPF1_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_ADAPTER_ID_W__SUBSYSTEM_ID_MASK                                                     0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PMI_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PMI_CAP_LIST__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF1_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV0_EPF1_PMI_CAP_LIST__CAP_ID_MASK                                                           0x00FFL
#define BIF_CFG_DEV0_EPF1_PMI_CAP_LIST__NEXT_PTR_MASK                                                         0xFF00L
//BIF_CFG_DEV0_EPF1_PMI_CAP
#define BIF_CFG_DEV0_EPF1_PMI_CAP__VERSION__SHIFT                                                             0x0
#define BIF_CFG_DEV0_EPF1_PMI_CAP__PME_CLOCK__SHIFT                                                           0x3
#define BIF_CFG_DEV0_EPF1_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0__SHIFT                                 0x4
#define BIF_CFG_DEV0_EPF1_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                   0x5
#define BIF_CFG_DEV0_EPF1_PMI_CAP__AUX_CURRENT__SHIFT                                                         0x6
#define BIF_CFG_DEV0_EPF1_PMI_CAP__D1_SUPPORT__SHIFT                                                          0x9
#define BIF_CFG_DEV0_EPF1_PMI_CAP__D2_SUPPORT__SHIFT                                                          0xa
#define BIF_CFG_DEV0_EPF1_PMI_CAP__PME_SUPPORT__SHIFT                                                         0xb
#define BIF_CFG_DEV0_EPF1_PMI_CAP__VERSION_MASK                                                               0x0007L
#define BIF_CFG_DEV0_EPF1_PMI_CAP__PME_CLOCK_MASK                                                             0x0008L
#define BIF_CFG_DEV0_EPF1_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0_MASK                                   0x0010L
#define BIF_CFG_DEV0_EPF1_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                     0x0020L
#define BIF_CFG_DEV0_EPF1_PMI_CAP__AUX_CURRENT_MASK                                                           0x01C0L
#define BIF_CFG_DEV0_EPF1_PMI_CAP__D1_SUPPORT_MASK                                                            0x0200L
#define BIF_CFG_DEV0_EPF1_PMI_CAP__D2_SUPPORT_MASK                                                            0x0400L
#define BIF_CFG_DEV0_EPF1_PMI_CAP__PME_SUPPORT_MASK                                                           0xF800L
//BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                               0x3
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__PME_EN__SHIFT                                                      0x8
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                                 0x9
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                  0xd
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                               0x16
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                  0x17
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                    0x18
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__POWER_STATE_MASK                                                   0x00000003L
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                                 0x00000008L
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__PME_EN_MASK                                                        0x00000100L
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                   0x00001E00L
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                    0x00006000L
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__PME_STATUS_MASK                                                    0x00008000L
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                                 0x00400000L
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                    0x00800000L
#define BIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL__PMI_DATA_MASK                                                      0xFF000000L
//BIF_CFG_DEV0_EPF1_PCIE_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_CAP_LIST__CAP_ID__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF1_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                      0x8
#define BIF_CFG_DEV0_EPF1_PCIE_CAP_LIST__CAP_ID_MASK                                                          0x00FFL
#define BIF_CFG_DEV0_EPF1_PCIE_CAP_LIST__NEXT_PTR_MASK                                                        0xFF00L
//BIF_CFG_DEV0_EPF1_PCIE_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_CAP__VERSION__SHIFT                                                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_CAP__DEVICE_TYPE__SHIFT                                                        0x4
#define BIF_CFG_DEV0_EPF1_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF1_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                    0x9
#define BIF_CFG_DEV0_EPF1_PCIE_CAP__VERSION_MASK                                                              0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_CAP__DEVICE_TYPE_MASK                                                          0x00F0L
#define BIF_CFG_DEV0_EPF1_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                     0x0100L
#define BIF_CFG_DEV0_EPF1_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                      0x3E00L
//BIF_CFG_DEV0_EPF1_DEVICE_CAP
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                     0x3
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                     0x5
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                           0x6
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                            0x9
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                         0xf
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT                                        0x12
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT                                        0x1a
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                      0x1c
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                                0x00000007L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__PHANTOM_FUNC_MASK                                                       0x00000018L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__EXTENDED_TAG_MASK                                                       0x00000020L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                             0x000001C0L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                              0x00000E00L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                           0x00008000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK                                          0x03FC0000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK                                          0x0C000000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP__FLR_CAPABLE_MASK                                                        0x10000000L
//BIF_CFG_DEV0_EPF1_DEVICE_CNTL
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                                0x1
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                    0x2
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                   0x3
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                  0x4
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                                 0x8
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                                 0x9
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                                 0xa
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                     0xb
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                           0xc
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__INITIATE_FLR__SHIFT                                                    0xf
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__CORR_ERR_EN_MASK                                                       0x0001L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                  0x0002L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                      0x0004L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__USR_REPORT_EN_MASK                                                     0x0008L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                    0x0010L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                  0x00E0L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                   0x0100L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                   0x0200L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                   0x0400L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                       0x0800L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                             0x7000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL__INITIATE_FLR_MASK                                                      0x8000L
//BIF_CFG_DEV0_EPF1_DEVICE_STATUS
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__CORR_ERR__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                                 0x1
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__FATAL_ERR__SHIFT                                                     0x2
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__USR_DETECTED__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__AUX_PWR__SHIFT                                                       0x4
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                             0x5
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED__SHIFT                                 0x6
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__CORR_ERR_MASK                                                        0x0001L
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                   0x0002L
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__FATAL_ERR_MASK                                                       0x0004L
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__USR_DETECTED_MASK                                                    0x0008L
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__AUX_PWR_MASK                                                         0x0010L
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                               0x0020L
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED_MASK                                   0x0040L
//BIF_CFG_DEV0_EPF1_LINK_CAP
#define BIF_CFG_DEV0_EPF1_LINK_CAP__LINK_SPEED__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF1_LINK_CAP__LINK_WIDTH__SHIFT                                                         0x4
#define BIF_CFG_DEV0_EPF1_LINK_CAP__PM_SUPPORT__SHIFT                                                         0xa
#define BIF_CFG_DEV0_EPF1_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                   0xc
#define BIF_CFG_DEV0_EPF1_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                    0xf
#define BIF_CFG_DEV0_EPF1_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                             0x12
#define BIF_CFG_DEV0_EPF1_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                        0x13
#define BIF_CFG_DEV0_EPF1_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                        0x14
#define BIF_CFG_DEV0_EPF1_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                           0x15
#define BIF_CFG_DEV0_EPF1_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                        0x16
#define BIF_CFG_DEV0_EPF1_LINK_CAP__PORT_NUMBER__SHIFT                                                        0x18
#define BIF_CFG_DEV0_EPF1_LINK_CAP__LINK_SPEED_MASK                                                           0x0000000FL
#define BIF_CFG_DEV0_EPF1_LINK_CAP__LINK_WIDTH_MASK                                                           0x000003F0L
#define BIF_CFG_DEV0_EPF1_LINK_CAP__PM_SUPPORT_MASK                                                           0x00000C00L
#define BIF_CFG_DEV0_EPF1_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                     0x00007000L
#define BIF_CFG_DEV0_EPF1_LINK_CAP__L1_EXIT_LATENCY_MASK                                                      0x00038000L
#define BIF_CFG_DEV0_EPF1_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                               0x00040000L
#define BIF_CFG_DEV0_EPF1_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                          0x00080000L
#define BIF_CFG_DEV0_EPF1_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                          0x00100000L
#define BIF_CFG_DEV0_EPF1_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                             0x00200000L
#define BIF_CFG_DEV0_EPF1_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                          0x00400000L
#define BIF_CFG_DEV0_EPF1_LINK_CAP__PORT_NUMBER_MASK                                                          0xFF000000L
//BIF_CFG_DEV0_EPF1_LINK_CNTL
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__PM_CONTROL__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B__SHIFT                                      0x2
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                                 0x3
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__LINK_DIS__SHIFT                                                          0x4
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__RETRAIN_LINK__SHIFT                                                      0x5
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                  0x6
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                     0x7
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                         0x8
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                       0x9
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                         0xa
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                         0xb
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__DRS_SIGNALING_CONTROL__SHIFT                                             0xe
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__PM_CONTROL_MASK                                                          0x0003L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B_MASK                                        0x0004L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                   0x0008L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__LINK_DIS_MASK                                                            0x0010L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__RETRAIN_LINK_MASK                                                        0x0020L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                    0x0040L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__EXTENDED_SYNC_MASK                                                       0x0080L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                           0x0100L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                         0x0200L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                           0x0400L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                           0x0800L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL__DRS_SIGNALING_CONTROL_MASK                                               0xC000L
//BIF_CFG_DEV0_EPF1_LINK_STATUS
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                           0x4
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__LINK_TRAINING__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                  0xc
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__DL_ACTIVE__SHIFT                                                       0xd
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                       0xe
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                       0xf
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                                0x000FL
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                             0x03F0L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__LINK_TRAINING_MASK                                                     0x0800L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                    0x1000L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__DL_ACTIVE_MASK                                                         0x2000L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                         0x4000L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                         0x8000L
//BIF_CFG_DEV0_EPF1_DEVICE_CAP2
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                       0x4
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                        0x5
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                      0x6
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                      0x7
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                      0x8
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                       0xa
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__LN_SYSTEM_CLS__SHIFT                                                   0xe
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED__SHIFT                                 0x10
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED__SHIFT                                 0x11
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                  0x12
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                    0x14
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                    0x15
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                        0x16
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED__SHIFT                                  0x18
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ__SHIFT                                   0x1a
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__FRS_SUPPORTED__SHIFT                                                   0x1f
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                       0x0000000FL
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                         0x00000010L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                          0x00000020L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                        0x00000040L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                        0x00000080L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                        0x00000100L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                            0x00000200L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                         0x00000400L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                     0x00000800L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                                0x00003000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__LN_SYSTEM_CLS_MASK                                                     0x0000C000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED_MASK                                   0x00010000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED_MASK                                   0x00020000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                    0x000C0000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                      0x00100000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                      0x00200000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                          0x00C00000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED_MASK                                    0x03000000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ_MASK                                     0x04000000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CAP2__FRS_SUPPORTED_MASK                                                     0x80000000L
//BIF_CFG_DEV0_EPF1_DEVICE_CNTL2
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                                0x4
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                            0x6
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                       0x7
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                             0x8
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__LTR_EN__SHIFT                                                         0xa
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST__SHIFT                                   0xb
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE__SHIFT                                   0xc
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__OBFF_EN__SHIFT                                                        0xd
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                                0x000FL
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                  0x0010L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                                0x0020L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                              0x0040L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                         0x0080L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                               0x0100L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                            0x0200L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__LTR_EN_MASK                                                           0x0400L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST_MASK                                     0x0800L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE_MASK                                     0x1000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__OBFF_EN_MASK                                                          0x6000L
#define BIF_CFG_DEV0_EPF1_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF1_DEVICE_STATUS2
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS2__RESERVED__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_DEVICE_STATUS2__RESERVED_MASK                                                       0xFFFFL
//BIF_CFG_DEV0_EPF1_LINK_CAP2
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                              0x1
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT__SHIFT                                          0x10
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT__SHIFT                                         0x17
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT__SHIFT                                         0x18
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__DRS_SUPPORTED__SHIFT                                                     0x1f
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                                0x000000FEL
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                                 0x00000100L
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT_MASK                                            0x0000FE00L
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT_MASK                                            0x007F0000L
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT_MASK                                           0x00800000L
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT_MASK                                           0x01000000L
#define BIF_CFG_DEV0_EPF1_LINK_CAP2__DRS_SUPPORTED_MASK                                                       0x80000000L
//BIF_CFG_DEV0_EPF1_LINK_CNTL2
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                                 0x4
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                      0x5
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                            0x6
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                      0x7
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                             0xa
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                            0xc
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                  0x000FL
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                   0x0010L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                        0x0020L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                              0x0040L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__XMIT_MARGIN_MASK                                                        0x0380L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                               0x0400L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                     0x0800L
#define BIF_CFG_DEV0_EPF1_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                              0xF000L
//BIF_CFG_DEV0_EPF1_LINK_STATUS2
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT__SHIFT                                0x2
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT__SHIFT                                0x3
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT__SHIFT                                0x4
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT__SHIFT                                  0x5
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__RTM1_PRESENCE_DET__SHIFT                                              0x6
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__RTM2_PRESENCE_DET__SHIFT                                              0x7
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__CROSSLINK_RESOLUTION__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE__SHIFT                                  0xc
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__DRS_MESSAGE_RECEIVED__SHIFT                                           0xf
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                             0x0001L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT_MASK                                        0x0002L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT_MASK                                  0x0004L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT_MASK                                  0x0008L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT_MASK                                  0x0010L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT_MASK                                    0x0020L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__RTM1_PRESENCE_DET_MASK                                                0x0040L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__RTM2_PRESENCE_DET_MASK                                                0x0080L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__CROSSLINK_RESOLUTION_MASK                                             0x0300L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE_MASK                                    0x7000L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS2__DRS_MESSAGE_RECEIVED_MASK                                             0x8000L
//BIF_CFG_DEV0_EPF1_MSI_CAP_LIST
#define BIF_CFG_DEV0_EPF1_MSI_CAP_LIST__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF1_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV0_EPF1_MSI_CAP_LIST__CAP_ID_MASK                                                           0x00FFL
#define BIF_CFG_DEV0_EPF1_MSI_CAP_LIST__NEXT_PTR_MASK                                                         0xFF00L
//BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_EN__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                  0x1
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                   0x4
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                      0x7
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                      0x8
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP__SHIFT                                           0x9
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN__SHIFT                                            0xa
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_EN_MASK                                                           0x0001L
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                    0x000EL
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                     0x0070L
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_64BIT_MASK                                                        0x0080L
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                        0x0100L
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP_MASK                                             0x0200L
#define BIF_CFG_DEV0_EPF1_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN_MASK                                              0x0400L
//BIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                             0x2
#define BIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                               0xFFFFFFFCL
//BIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_MSI_MSG_DATA
#define BIF_CFG_DEV0_EPF1_MSI_MSG_DATA__MSI_DATA__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_MSI_MSG_DATA__MSI_DATA_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA
#define BIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA__MSI_EXT_DATA__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA__MSI_EXT_DATA_MASK                                                 0xFFFFL
//BIF_CFG_DEV0_EPF1_MSI_MASK
#define BIF_CFG_DEV0_EPF1_MSI_MASK__MSI_MASK__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF1_MSI_MASK__MSI_MASK_MASK                                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_MSI_MSG_DATA_64
#define BIF_CFG_DEV0_EPF1_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF1_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                   0xFFFFL
//BIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA_64
#define BIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64_MASK                                           0xFFFFL
//BIF_CFG_DEV0_EPF1_MSI_MASK_64
#define BIF_CFG_DEV0_EPF1_MSI_MASK_64__MSI_MASK_64__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_MSI_MASK_64__MSI_MASK_64_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_MSI_PENDING
#define BIF_CFG_DEV0_EPF1_MSI_PENDING__MSI_PENDING__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_MSI_PENDING__MSI_PENDING_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_MSI_PENDING_64
#define BIF_CFG_DEV0_EPF1_MSI_PENDING_64__MSI_PENDING_64__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_MSI_PENDING_64__MSI_PENDING_64_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_MSIX_CAP_LIST
#define BIF_CFG_DEV0_EPF1_MSIX_CAP_LIST__CAP_ID__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF1_MSIX_CAP_LIST__NEXT_PTR__SHIFT                                                      0x8
#define BIF_CFG_DEV0_EPF1_MSIX_CAP_LIST__CAP_ID_MASK                                                          0x00FFL
#define BIF_CFG_DEV0_EPF1_MSIX_CAP_LIST__NEXT_PTR_MASK                                                        0xFF00L
//BIF_CFG_DEV0_EPF1_MSIX_MSG_CNTL
#define BIF_CFG_DEV0_EPF1_MSIX_MSG_CNTL__MSIX_TABLE_SIZE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_MSIX_MSG_CNTL__MSIX_FUNC_MASK__SHIFT                                                0xe
#define BIF_CFG_DEV0_EPF1_MSIX_MSG_CNTL__MSIX_EN__SHIFT                                                       0xf
#define BIF_CFG_DEV0_EPF1_MSIX_MSG_CNTL__MSIX_TABLE_SIZE_MASK                                                 0x07FFL
#define BIF_CFG_DEV0_EPF1_MSIX_MSG_CNTL__MSIX_FUNC_MASK_MASK                                                  0x4000L
#define BIF_CFG_DEV0_EPF1_MSIX_MSG_CNTL__MSIX_EN_MASK                                                         0x8000L
//BIF_CFG_DEV0_EPF1_MSIX_TABLE
#define BIF_CFG_DEV0_EPF1_MSIX_TABLE__MSIX_TABLE_BIR__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF1_MSIX_TABLE__MSIX_TABLE_OFFSET__SHIFT                                                0x3
#define BIF_CFG_DEV0_EPF1_MSIX_TABLE__MSIX_TABLE_BIR_MASK                                                     0x00000007L
#define BIF_CFG_DEV0_EPF1_MSIX_TABLE__MSIX_TABLE_OFFSET_MASK                                                  0xFFFFFFF8L
//BIF_CFG_DEV0_EPF1_MSIX_PBA
#define BIF_CFG_DEV0_EPF1_MSIX_PBA__MSIX_PBA_BIR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_MSIX_PBA__MSIX_PBA_OFFSET__SHIFT                                                    0x3
#define BIF_CFG_DEV0_EPF1_MSIX_PBA__MSIX_PBA_BIR_MASK                                                         0x00000007L
#define BIF_CFG_DEV0_EPF1_MSIX_PBA__MSIX_PBA_OFFSET_MASK                                                      0xFFFFFFF8L
//BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                   0x10
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                  0x14
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                      0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                     0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                    0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                           0x10
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                        0x14
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                             0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                          0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT                                    0x10
#define BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT                                   0x14
#define BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK                                       0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK                                      0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK                                     0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW1
#define BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW2
#define BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                       0x10
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                         0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                        0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                       0x4
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                    0x5
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                       0xc
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                        0xd
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                   0xe
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                                 0xf
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                      0x11
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                       0x12
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                      0x13
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                                0x14
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                                 0x15
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                                0x16
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                                0x17
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                       0x18
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                        0x19
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS__SHIFT                   0x1a
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                         0x00000010L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                      0x00000020L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                         0x00001000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                          0x00002000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                     0x00004000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                   0x00008000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                       0x00010000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                        0x00020000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                         0x00040000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                        0x00080000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                  0x00100000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                   0x00200000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                  0x00400000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                  0x00800000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                         0x01000000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                          0x02000000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS_MASK                     0x04000000L
//BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                           0x4
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                        0x5
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                           0xc
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                            0xd
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                       0xe
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                     0xf
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                         0x10
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                          0x11
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                           0x12
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                          0x13
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                    0x14
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                     0x15
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                    0x16
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                    0x17
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                           0x18
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                            0x19
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__POISONED_TLP_EGRESS_BLOCKED_MASK__SHIFT                       0x1a
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                             0x00000010L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                          0x00000020L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                             0x00001000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                              0x00002000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                         0x00004000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                       0x00008000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                           0x00010000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                            0x00020000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                             0x00040000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                            0x00080000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                      0x00100000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                       0x00200000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                      0x00400000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                      0x00800000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                             0x01000000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                              0x02000000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK__POISONED_TLP_EGRESS_BLOCKED_MASK_MASK                         0x04000000L
//BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                   0x4
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                                0x5
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                   0xc
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                    0xd
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                               0xe
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                             0xf
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                                 0x10
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                  0x11
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                   0x12
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                  0x13
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                            0x14
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                             0x15
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                            0x16
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                            0x17
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                   0x18
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                    0x19
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__POISONED_TLP_EGRESS_BLOCKED_SEVERITY__SHIFT               0x1a
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                     0x00000010L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                  0x00000020L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                     0x00001000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                      0x00002000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                                 0x00004000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                               0x00008000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                   0x00010000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                    0x00020000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                     0x00040000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                    0x00080000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                              0x00100000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                               0x00200000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                              0x00400000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                              0x00800000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                     0x01000000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                      0x02000000L
#define BIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY__POISONED_TLP_EGRESS_BLOCKED_SEVERITY_MASK                 0x04000000L
//BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                         0x6
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                        0x7
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                             0x8
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                            0xc
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                           0xd
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                    0xe
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                           0x00000001L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                           0x00000040L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                          0x00000080L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                               0x00000100L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                              0x00001000L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                             0x00002000L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                      0x00004000L
//BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                             0x6
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                            0x7
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                                 0x8
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                                0xc
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                               0xd
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                        0xe
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                               0x00000001L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                               0x00000040L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                              0x00000080L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                   0x00000100L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                  0x00001000L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                                 0x00002000L
#define BIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                          0x00004000L
//BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                          0x5
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                           0x6
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                        0x7
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                         0x8
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                    0x9
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                     0xa
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                           0x0000001FL
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                            0x00000020L
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                             0x00000040L
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                          0x00000080L
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                           0x00000100L
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                      0x00000200L
#define BIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                       0x00000400L
//BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG0
#define BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG0__TLP_HDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG1
#define BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG1__TLP_HDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG2
#define BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG2__TLP_HDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG3
#define BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_HDR_LOG3__TLP_HDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG0
#define BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG1
#define BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG2
#define BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG3
#define BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_BAR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_BAR_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_BAR_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF1_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF1_PCIE_BAR_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_BAR_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_BAR1_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_BAR2_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_BAR3_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_BAR4_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_BAR5_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_BAR6_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED_MASK                                              0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL__BAR_INDEX__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL__BAR_TOTAL_NUM__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL__BAR_SIZE__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL__BAR_SIZE_SUPPORTED_UPPER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL__BAR_INDEX_MASK                                                      0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL__BAR_TOTAL_NUM_MASK                                                  0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL__BAR_SIZE_MASK                                                       0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL__BAR_SIZE_SUPPORTED_UPPER_MASK                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER__SHIFT                                        0x10
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR__SHIFT                                       0x14
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID_MASK                                           0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER_MASK                                          0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR_MASK                                         0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA_SELECT
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT_MASK                                       0xFFL
//BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__BASE_POWER__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__DATA_SCALE__SHIFT                                             0x8
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE__SHIFT                                           0xa
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__PM_STATE__SHIFT                                               0xd
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__TYPE__SHIFT                                                   0xf
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__POWER_RAIL__SHIFT                                             0x12
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__BASE_POWER_MASK                                               0x000000FFL
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__DATA_SCALE_MASK                                               0x00000300L
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE_MASK                                             0x00001C00L
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__PM_STATE_MASK                                                 0x00006000L
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__TYPE_MASK                                                     0x00038000L
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA__POWER_RAIL_MASK                                               0x001C0000L
//BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED_MASK                                          0x01L
//BIF_CFG_DEV0_EPF1_PCIE_DPA_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_DPA_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CAP__SUBSTATE_MAX__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CAP__TRANS_LAT_UNIT__SHIFT                                                 0x8
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CAP__PWR_ALLOC_SCALE__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CAP__TRANS_LAT_VAL_0__SHIFT                                                0x10
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CAP__TRANS_LAT_VAL_1__SHIFT                                                0x18
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CAP__SUBSTATE_MAX_MASK                                                     0x0000001FL
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CAP__TRANS_LAT_UNIT_MASK                                                   0x00000300L
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CAP__PWR_ALLOC_SCALE_MASK                                                  0x00003000L
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CAP__TRANS_LAT_VAL_0_MASK                                                  0x00FF0000L
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CAP__TRANS_LAT_VAL_1_MASK                                                  0xFF000000L
//BIF_CFG_DEV0_EPF1_PCIE_DPA_LATENCY_INDICATOR
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS_MASK                           0x000000FFL
//BIF_CFG_DEV0_EPF1_PCIE_DPA_STATUS
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_STATUS__SUBSTATE_STATUS__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED__SHIFT                                       0x8
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_STATUS__SUBSTATE_STATUS_MASK                                               0x001FL
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED_MASK                                         0x0100L
//BIF_CFG_DEV0_EPF1_PCIE_DPA_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CNTL__SUBSTATE_CNTL__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_CNTL__SUBSTATE_CNTL_MASK                                                   0x001FL
//BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_1
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_2
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_3
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_4
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_5
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_6
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_7
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC_MASK                              0xFFL
//BIF_CFG_DEV0_EPF1_PCIE_SECONDARY_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT                                         0x10
#define BIF_CFG_DEV0_EPF1_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT                                        0x14
#define BIF_CFG_DEV0_EPF1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK                                           0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK                                          0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_LINK_CNTL3
#define BIF_CFG_DEV0_EPF1_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT                                0x1
#define BIF_CFG_DEV0_EPF1_PCIE_LINK_CNTL3__ENABLE_LOWER_SKP_OS_GEN__SHIFT                                     0x9
#define BIF_CFG_DEV0_EPF1_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK                                          0x00000001L
#define BIF_CFG_DEV0_EPF1_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK                                  0x00000002L
#define BIF_CFG_DEV0_EPF1_PCIE_LINK_CNTL3__ENABLE_LOWER_SKP_OS_GEN_MASK                                       0x0000FE00L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_ERROR_STATUS
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT                               0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK                                 0x0000FFFFL
//BIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT              0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                   0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK              0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                     0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK                0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT           0x4
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET__SHIFT                  0x8
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT__SHIFT             0xc
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_TX_PRESET_MASK                  0x000FL
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_8GT_RX_PRESET_HINT_MASK             0x0070L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_TX_PRESET_MASK                    0x0F00L
#define BIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_8GT_RX_PRESET_HINT_MASK               0x7000L
//BIF_CFG_DEV0_EPF1_PCIE_ACS_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                           0x1
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                           0x2
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                        0x3
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                             0x5
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                          0x6
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                     0x8
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                                0x0001L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                             0x0002L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                             0x0004L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                          0x0008L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                              0x0010L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                               0x0020L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                            0x0040L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                       0xFF00L
//BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                       0x1
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                       0x2
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                    0x3
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                        0x4
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                         0x5
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                      0x6
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                            0x0001L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                         0x0002L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                         0x0004L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                      0x0008L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                          0x0010L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                           0x0020L
#define BIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                        0x0040L
//BIF_CFG_DEV0_EPF1_PCIE_ATS_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_ATS_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CAP__INVALIDATE_Q_DEPTH__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST__SHIFT                                           0x5
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED__SHIFT                                    0x6
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CAP__RELAXED_ORDERING_SUPPORTED__SHIFT                                     0x7
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CAP__INVALIDATE_Q_DEPTH_MASK                                               0x001FL
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST_MASK                                             0x0020L
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED_MASK                                      0x0040L
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CAP__RELAXED_ORDERING_SUPPORTED_MASK                                       0x0080L
//BIF_CFG_DEV0_EPF1_PCIE_ATS_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CNTL__STU__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CNTL__ATC_ENABLE__SHIFT                                                    0xf
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CNTL__STU_MASK                                                             0x001FL
#define BIF_CFG_DEV0_EPF1_PCIE_ATS_CNTL__ATC_ENABLE_MASK                                                      0x8000L
//BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER__SHIFT                                          0x10
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR__SHIFT                                         0x14
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID_MASK                                             0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER_MASK                                            0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR_MASK                                           0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_CNTL__PRI_ENABLE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_CNTL__PRI_RESET__SHIFT                                                0x1
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_CNTL__PRI_ENABLE_MASK                                                 0x0001L
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_CNTL__PRI_RESET_MASK                                                  0x0002L
//BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_STATUS
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX__SHIFT                          0x1
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_STATUS__STOPPED__SHIFT                                                0x8
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED__SHIFT                            0xf
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE_MASK                                         0x0001L
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX_MASK                            0x0002L
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_STATUS__STOPPED_MASK                                                  0x0100L
#define BIF_CFG_DEV0_EPF1_PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED_MASK                              0x8000L
//BIF_CFG_DEV0_EPF1_PCIE_OUTSTAND_PAGE_REQ_CAPACITY
#define BIF_CFG_DEV0_EPF1_PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY_MASK                    0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_OUTSTAND_PAGE_REQ_ALLOC
#define BIF_CFG_DEV0_EPF1_PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC_MASK                          0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_PASID_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_PASID_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED__SHIFT                               0x1
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED__SHIFT                                    0x2
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CAP__MAX_PASID_WIDTH__SHIFT                                              0x8
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED_MASK                                 0x0002L
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED_MASK                                      0x0004L
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CAP__MAX_PASID_WIDTH_MASK                                                0x1F00L
//BIF_CFG_DEV0_EPF1_PCIE_PASID_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CNTL__PASID_ENABLE__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE__SHIFT                                 0x1
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE__SHIFT                            0x2
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CNTL__PASID_ENABLE_MASK                                                  0x0001L
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE_MASK                                   0x0002L
#define BIF_CFG_DEV0_EPF1_PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE_MASK                              0x0004L
//BIF_CFG_DEV0_EPF1_PCIE_MC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ENH_CAP_LIST__CAP_ID__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ENH_CAP_LIST__CAP_VER__SHIFT                                                0x10
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                               0x14
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ENH_CAP_LIST__CAP_ID_MASK                                                   0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ENH_CAP_LIST__CAP_VER_MASK                                                  0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ENH_CAP_LIST__NEXT_PTR_MASK                                                 0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_MC_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_MC_CAP__MC_MAX_GROUP__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_CAP__MC_WIN_SIZE_REQ__SHIFT                                                 0x8
#define BIF_CFG_DEV0_EPF1_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP__SHIFT                                              0xf
#define BIF_CFG_DEV0_EPF1_PCIE_MC_CAP__MC_MAX_GROUP_MASK                                                      0x003FL
#define BIF_CFG_DEV0_EPF1_PCIE_MC_CAP__MC_WIN_SIZE_REQ_MASK                                                   0x3F00L
#define BIF_CFG_DEV0_EPF1_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP_MASK                                                0x8000L
//BIF_CFG_DEV0_EPF1_PCIE_MC_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_MC_CNTL__MC_NUM_GROUP__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_CNTL__MC_ENABLE__SHIFT                                                      0xf
#define BIF_CFG_DEV0_EPF1_PCIE_MC_CNTL__MC_NUM_GROUP_MASK                                                     0x003FL
#define BIF_CFG_DEV0_EPF1_PCIE_MC_CNTL__MC_ENABLE_MASK                                                        0x8000L
//BIF_CFG_DEV0_EPF1_PCIE_MC_ADDR0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ADDR0__MC_INDEX_POS__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ADDR0__MC_BASE_ADDR_0__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ADDR0__MC_INDEX_POS_MASK                                                    0x0000003FL
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ADDR0__MC_BASE_ADDR_0_MASK                                                  0xFFFFF000L
//BIF_CFG_DEV0_EPF1_PCIE_MC_ADDR1
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ADDR1__MC_BASE_ADDR_1__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_ADDR1__MC_BASE_ADDR_1_MASK                                                  0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_MC_RCV0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_RCV0__MC_RECEIVE_0__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_RCV0__MC_RECEIVE_0_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_MC_RCV1
#define BIF_CFG_DEV0_EPF1_PCIE_MC_RCV1__MC_RECEIVE_1__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_RCV1__MC_RECEIVE_1_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_ALL0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_ALL1
#define BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_UNTRANSLATED_0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0_MASK                          0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_UNTRANSLATED_1
#define BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1_MASK                          0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_LTR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_LTR_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE__SHIFT                                        0xa
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE__SHIFT                                       0x10
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE__SHIFT                                       0x1a
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE_MASK                                          0x000003FFL
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE_MASK                                          0x00001C00L
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE_MASK                                         0x03FF0000L
#define BIF_CFG_DEV0_EPF1_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE_MASK                                         0x1C000000L
//BIF_CFG_DEV0_EPF1_PCIE_ARI_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_ARI_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP__SHIFT                                        0x1
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM__SHIFT                                              0x8
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP_MASK                                         0x0001L
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP_MASK                                          0x0002L
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM_MASK                                                0xFF00L
//BIF_CFG_DEV0_EPF1_PCIE_ARI_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN__SHIFT                                        0x1
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN_MASK                                         0x0001L
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN_MASK                                          0x0002L
#define BIF_CFG_DEV0_EPF1_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP_MASK                                              0x0070L
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CAP__SRIOV_ARI_CAP_HIERARCHY_PRESERVED__SHIFT                            0x1
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CAP__SRIOV_VF_TEN_BIT_TAG_REQUESTER_SUPPORTED__SHIFT                     0x2
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CAP__SRIOV_ARI_CAP_HIERARCHY_PRESERVED_MASK                              0x00000002L
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CAP__SRIOV_VF_TEN_BIT_TAG_REQUESTER_SUPPORTED_MASK                       0x00000004L
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL__SRIOV_VF_ENABLE__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL__SRIOV_VF_MSE__SHIFT                                             0x3
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL__SRIOV_ARI_CAP_HIERARCHY__SHIFT                                  0x4
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL__SRIOV_VF_TEN_BIT_TAG_REQUESTER_ENABLE__SHIFT                    0x5
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL__SRIOV_VF_ENABLE_MASK                                            0x0001L
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL__SRIOV_VF_MSE_MASK                                               0x0008L
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL__SRIOV_ARI_CAP_HIERARCHY_MASK                                    0x0010L
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL__SRIOV_VF_TEN_BIT_TAG_REQUESTER_ENABLE_MASK                      0x0020L
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_STATUS
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_INITIAL_VFS
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_INITIAL_VFS__SRIOV_INITIAL_VFS__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_INITIAL_VFS__SRIOV_INITIAL_VFS_MASK                                      0xFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_TOTAL_VFS
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_TOTAL_VFS__SRIOV_TOTAL_VFS__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_TOTAL_VFS__SRIOV_TOTAL_VFS_MASK                                          0xFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_NUM_VFS
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_NUM_VFS__SRIOV_NUM_VFS__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_NUM_VFS__SRIOV_NUM_VFS_MASK                                              0xFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_FUNC_DEP_LINK
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_FUNC_DEP_LINK__SRIOV_FUNC_DEP_LINK__SHIFT                                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_FUNC_DEP_LINK__SRIOV_FUNC_DEP_LINK_MASK                                  0xFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_FIRST_VF_OFFSET
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_FIRST_VF_OFFSET__SRIOV_FIRST_VF_OFFSET__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_FIRST_VF_OFFSET__SRIOV_FIRST_VF_OFFSET_MASK                              0xFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_STRIDE
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_STRIDE__SRIOV_VF_STRIDE__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_STRIDE__SRIOV_VF_STRIDE_MASK                                          0xFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_DEVICE_ID
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_DEVICE_ID__SRIOV_VF_DEVICE_ID__SHIFT                                  0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_DEVICE_ID__SRIOV_VF_DEVICE_ID_MASK                                    0xFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_SUPPORTED_PAGE_SIZE
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_SUPPORTED_PAGE_SIZE__SRIOV_SUPPORTED_PAGE_SIZE__SHIFT                    0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_SUPPORTED_PAGE_SIZE__SRIOV_SUPPORTED_PAGE_SIZE_MASK                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_SYSTEM_PAGE_SIZE
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_SYSTEM_PAGE_SIZE__SRIOV_SYSTEM_PAGE_SIZE__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_SYSTEM_PAGE_SIZE__SRIOV_SYSTEM_PAGE_SIZE_MASK                            0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_0__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_0__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_1
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_1__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_1__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_2
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_2__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_2__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_3
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_3__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_3__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_4
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_4__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_4__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_5
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_5__VF_BASE_ADDR__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_5__VF_BASE_ADDR_MASK                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_PCIE_DLF_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_DLF_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_DLF_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF1_PCIE_DLF_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF1_PCIE_DLF_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_DLF_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_DLF_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF1_DATA_LINK_FEATURE_CAP
#define BIF_CFG_DEV0_EPF1_DATA_LINK_FEATURE_CAP__LOCAL_DLF_SUPPORTED__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF1_DATA_LINK_FEATURE_CAP__DLF_EXCHANGE_ENABLE__SHIFT                                   0x1f
#define BIF_CFG_DEV0_EPF1_DATA_LINK_FEATURE_CAP__LOCAL_DLF_SUPPORTED_MASK                                     0x007FFFFFL
#define BIF_CFG_DEV0_EPF1_DATA_LINK_FEATURE_CAP__DLF_EXCHANGE_ENABLE_MASK                                     0x80000000L
//BIF_CFG_DEV0_EPF1_DATA_LINK_FEATURE_STATUS
#define BIF_CFG_DEV0_EPF1_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED__SHIFT                               0x0
#define BIF_CFG_DEV0_EPF1_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_VALID__SHIFT                         0x1f
#define BIF_CFG_DEV0_EPF1_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_MASK                                 0x007FFFFFL
#define BIF_CFG_DEV0_EPF1_DATA_LINK_FEATURE_STATUS__REMOTE_DLF_SUPPORTED_VALID_MASK                           0x80000000L
//BIF_CFG_DEV0_EPF1_PCIE_PHY_16GT_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_ID__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_VER__SHIFT                                          0x10
#define BIF_CFG_DEV0_EPF1_PCIE_PHY_16GT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                         0x14
#define BIF_CFG_DEV0_EPF1_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_ID_MASK                                             0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_PHY_16GT_ENH_CAP_LIST__CAP_VER_MASK                                            0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_PHY_16GT_ENH_CAP_LIST__NEXT_PTR_MASK                                           0xFFF00000L
//BIF_CFG_DEV0_EPF1_LINK_CAP_16GT
#define BIF_CFG_DEV0_EPF1_LINK_CAP_16GT__RESERVED__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF1_LINK_CAP_16GT__RESERVED_MASK                                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_LINK_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LINK_CNTL_16GT__RESERVED__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_LINK_CNTL_16GT__RESERVED_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_LINK_STATUS_16GT
#define BIF_CFG_DEV0_EPF1_LINK_STATUS_16GT__EQUALIZATION_COMPLETE_16GT__SHIFT                                 0x0
#define BIF_CFG_DEV0_EPF1_LINK_STATUS_16GT__EQUALIZATION_PHASE1_SUCCESS_16GT__SHIFT                           0x1
#define BIF_CFG_DEV0_EPF1_LINK_STATUS_16GT__EQUALIZATION_PHASE2_SUCCESS_16GT__SHIFT                           0x2
#define BIF_CFG_DEV0_EPF1_LINK_STATUS_16GT__EQUALIZATION_PHASE3_SUCCESS_16GT__SHIFT                           0x3
#define BIF_CFG_DEV0_EPF1_LINK_STATUS_16GT__LINK_EQUALIZATION_REQUEST_16GT__SHIFT                             0x4
#define BIF_CFG_DEV0_EPF1_LINK_STATUS_16GT__EQUALIZATION_COMPLETE_16GT_MASK                                   0x00000001L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS_16GT__EQUALIZATION_PHASE1_SUCCESS_16GT_MASK                             0x00000002L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS_16GT__EQUALIZATION_PHASE2_SUCCESS_16GT_MASK                             0x00000004L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS_16GT__EQUALIZATION_PHASE3_SUCCESS_16GT_MASK                             0x00000008L
#define BIF_CFG_DEV0_EPF1_LINK_STATUS_16GT__LINK_EQUALIZATION_REQUEST_16GT_MASK                               0x00000010L
//BIF_CFG_DEV0_EPF1_LOCAL_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV0_EPF1_LOCAL_PARITY_MISMATCH_STATUS_16GT__LOCAL_PARITY_MISMATCH_STATUS_BITS__SHIFT         0x0
#define BIF_CFG_DEV0_EPF1_LOCAL_PARITY_MISMATCH_STATUS_16GT__LOCAL_PARITY_MISMATCH_STATUS_BITS_MASK           0x0000FFFFL
//BIF_CFG_DEV0_EPF1_RTM1_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV0_EPF1_RTM1_PARITY_MISMATCH_STATUS_16GT__RTM1_PARITY_MISMATCH_STATUS_BITS__SHIFT           0x0
#define BIF_CFG_DEV0_EPF1_RTM1_PARITY_MISMATCH_STATUS_16GT__RTM1_PARITY_MISMATCH_STATUS_BITS_MASK             0x0000FFFFL
//BIF_CFG_DEV0_EPF1_RTM2_PARITY_MISMATCH_STATUS_16GT
#define BIF_CFG_DEV0_EPF1_RTM2_PARITY_MISMATCH_STATUS_16GT__RTM2_PARITY_MISMATCH_STATUS_BITS__SHIFT           0x0
#define BIF_CFG_DEV0_EPF1_RTM2_PARITY_MISMATCH_STATUS_16GT__RTM2_PARITY_MISMATCH_STATUS_BITS_MASK             0x0000FFFFL
//BIF_CFG_DEV0_EPF1_LANE_0_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF1_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF1_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_0_EQUALIZATION_CNTL_16GT__LANE_0_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF1_LANE_1_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF1_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF1_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_1_EQUALIZATION_CNTL_16GT__LANE_1_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF1_LANE_2_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF1_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF1_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_2_EQUALIZATION_CNTL_16GT__LANE_2_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF1_LANE_3_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF1_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF1_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_3_EQUALIZATION_CNTL_16GT__LANE_3_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF1_LANE_4_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF1_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF1_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_4_EQUALIZATION_CNTL_16GT__LANE_4_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF1_LANE_5_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF1_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF1_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_5_EQUALIZATION_CNTL_16GT__LANE_5_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF1_LANE_6_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF1_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF1_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_6_EQUALIZATION_CNTL_16GT__LANE_6_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF1_LANE_7_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF1_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF1_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_7_EQUALIZATION_CNTL_16GT__LANE_7_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF1_LANE_8_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF1_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF1_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_8_EQUALIZATION_CNTL_16GT__LANE_8_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF1_LANE_9_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_DSP_16GT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF1_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_USP_16GT_TX_PRESET__SHIFT                     0x4
#define BIF_CFG_DEV0_EPF1_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_DSP_16GT_TX_PRESET_MASK                       0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_9_EQUALIZATION_CNTL_16GT__LANE_9_USP_16GT_TX_PRESET_MASK                       0xF0L
//BIF_CFG_DEV0_EPF1_LANE_10_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF1_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_10_EQUALIZATION_CNTL_16GT__LANE_10_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF1_LANE_11_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF1_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_11_EQUALIZATION_CNTL_16GT__LANE_11_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF1_LANE_12_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF1_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_12_EQUALIZATION_CNTL_16GT__LANE_12_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF1_LANE_13_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF1_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_13_EQUALIZATION_CNTL_16GT__LANE_13_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF1_LANE_14_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF1_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_14_EQUALIZATION_CNTL_16GT__LANE_14_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF1_LANE_15_EQUALIZATION_CNTL_16GT
#define BIF_CFG_DEV0_EPF1_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_DSP_16GT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_USP_16GT_TX_PRESET__SHIFT                   0x4
#define BIF_CFG_DEV0_EPF1_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_DSP_16GT_TX_PRESET_MASK                     0x0FL
#define BIF_CFG_DEV0_EPF1_LANE_15_EQUALIZATION_CNTL_16GT__LANE_15_USP_16GT_TX_PRESET_MASK                     0xF0L
//BIF_CFG_DEV0_EPF1_PCIE_MARGINING_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_MARGINING_ENH_CAP_LIST__CAP_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF1_PCIE_MARGINING_ENH_CAP_LIST__CAP_VER__SHIFT                                         0x10
#define BIF_CFG_DEV0_EPF1_PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR__SHIFT                                        0x14
#define BIF_CFG_DEV0_EPF1_PCIE_MARGINING_ENH_CAP_LIST__CAP_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_MARGINING_ENH_CAP_LIST__CAP_VER_MASK                                           0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_MARGINING_ENH_CAP_LIST__NEXT_PTR_MASK                                          0xFFF00000L
//BIF_CFG_DEV0_EPF1_MARGINING_PORT_CAP
#define BIF_CFG_DEV0_EPF1_MARGINING_PORT_CAP__MARGINING_USES_SOFTWARE__SHIFT                                  0x0
#define BIF_CFG_DEV0_EPF1_MARGINING_PORT_CAP__MARGINING_USES_SOFTWARE_MASK                                    0x0001L
//BIF_CFG_DEV0_EPF1_MARGINING_PORT_STATUS
#define BIF_CFG_DEV0_EPF1_MARGINING_PORT_STATUS__MARGINING_READY__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_MARGINING_PORT_STATUS__MARGINING_SOFTWARE_READY__SHIFT                              0x1
#define BIF_CFG_DEV0_EPF1_MARGINING_PORT_STATUS__MARGINING_READY_MASK                                         0x0001L
#define BIF_CFG_DEV0_EPF1_MARGINING_PORT_STATUS__MARGINING_SOFTWARE_READY_MASK                                0x0002L
//BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_CNTL__LANE_0_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_CNTL__LANE_0_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_CNTL__LANE_0_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_CNTL__LANE_0_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_CNTL__LANE_0_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_STATUS__LANE_0_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_STATUS__LANE_0_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_STATUS__LANE_0_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_STATUS__LANE_0_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_0_MARGINING_LANE_STATUS__LANE_0_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_CNTL__LANE_1_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_CNTL__LANE_1_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_CNTL__LANE_1_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_CNTL__LANE_1_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_CNTL__LANE_1_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_STATUS__LANE_1_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_STATUS__LANE_1_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_STATUS__LANE_1_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_STATUS__LANE_1_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_1_MARGINING_LANE_STATUS__LANE_1_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_CNTL__LANE_2_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_CNTL__LANE_2_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_CNTL__LANE_2_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_CNTL__LANE_2_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_CNTL__LANE_2_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_STATUS__LANE_2_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_STATUS__LANE_2_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_STATUS__LANE_2_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_STATUS__LANE_2_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_2_MARGINING_LANE_STATUS__LANE_2_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_CNTL__LANE_3_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_CNTL__LANE_3_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_CNTL__LANE_3_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_CNTL__LANE_3_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_CNTL__LANE_3_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_STATUS__LANE_3_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_STATUS__LANE_3_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_STATUS__LANE_3_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_STATUS__LANE_3_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_3_MARGINING_LANE_STATUS__LANE_3_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_CNTL__LANE_4_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_CNTL__LANE_4_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_CNTL__LANE_4_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_CNTL__LANE_4_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_CNTL__LANE_4_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_STATUS__LANE_4_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_STATUS__LANE_4_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_STATUS__LANE_4_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_STATUS__LANE_4_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_4_MARGINING_LANE_STATUS__LANE_4_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_CNTL__LANE_5_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_CNTL__LANE_5_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_CNTL__LANE_5_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_CNTL__LANE_5_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_CNTL__LANE_5_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_STATUS__LANE_5_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_STATUS__LANE_5_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_STATUS__LANE_5_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_STATUS__LANE_5_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_5_MARGINING_LANE_STATUS__LANE_5_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_CNTL__LANE_6_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_CNTL__LANE_6_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_CNTL__LANE_6_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_CNTL__LANE_6_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_CNTL__LANE_6_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_STATUS__LANE_6_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_STATUS__LANE_6_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_STATUS__LANE_6_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_STATUS__LANE_6_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_6_MARGINING_LANE_STATUS__LANE_6_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_CNTL__LANE_7_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_CNTL__LANE_7_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_CNTL__LANE_7_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_CNTL__LANE_7_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_CNTL__LANE_7_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_STATUS__LANE_7_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_STATUS__LANE_7_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_STATUS__LANE_7_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_STATUS__LANE_7_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_7_MARGINING_LANE_STATUS__LANE_7_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_CNTL__LANE_8_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_CNTL__LANE_8_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_CNTL__LANE_8_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_CNTL__LANE_8_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_CNTL__LANE_8_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_STATUS__LANE_8_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_STATUS__LANE_8_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_STATUS__LANE_8_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_STATUS__LANE_8_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_8_MARGINING_LANE_STATUS__LANE_8_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_CNTL__LANE_9_RECEIVER_NUMBER__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_TYPE__SHIFT                               0x3
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_CNTL__LANE_9_USAGE_MODEL__SHIFT                               0x6
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_PAYLOAD__SHIFT                            0x8
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_CNTL__LANE_9_RECEIVER_NUMBER_MASK                             0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_TYPE_MASK                                 0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_CNTL__LANE_9_USAGE_MODEL_MASK                                 0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_CNTL__LANE_9_MARGIN_PAYLOAD_MASK                              0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_STATUS__LANE_9_RECEIVER_NUMBER_STATUS__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_TYPE_STATUS__SHIFT                      0x3
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_STATUS__LANE_9_USAGE_MODEL_STATUS__SHIFT                      0x6
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_PAYLOAD_STATUS__SHIFT                   0x8
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_STATUS__LANE_9_RECEIVER_NUMBER_STATUS_MASK                    0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_TYPE_STATUS_MASK                        0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_STATUS__LANE_9_USAGE_MODEL_STATUS_MASK                        0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_9_MARGINING_LANE_STATUS__LANE_9_MARGIN_PAYLOAD_STATUS_MASK                     0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_CNTL__LANE_10_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_CNTL__LANE_10_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_CNTL__LANE_10_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_CNTL__LANE_10_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_CNTL__LANE_10_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_STATUS__LANE_10_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_STATUS__LANE_10_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_STATUS__LANE_10_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_STATUS__LANE_10_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_10_MARGINING_LANE_STATUS__LANE_10_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_CNTL__LANE_11_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_CNTL__LANE_11_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_CNTL__LANE_11_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_CNTL__LANE_11_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_CNTL__LANE_11_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_STATUS__LANE_11_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_STATUS__LANE_11_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_STATUS__LANE_11_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_STATUS__LANE_11_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_11_MARGINING_LANE_STATUS__LANE_11_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_CNTL__LANE_12_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_CNTL__LANE_12_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_CNTL__LANE_12_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_CNTL__LANE_12_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_CNTL__LANE_12_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_STATUS__LANE_12_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_STATUS__LANE_12_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_STATUS__LANE_12_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_STATUS__LANE_12_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_12_MARGINING_LANE_STATUS__LANE_12_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_CNTL__LANE_13_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_CNTL__LANE_13_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_CNTL__LANE_13_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_CNTL__LANE_13_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_CNTL__LANE_13_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_STATUS__LANE_13_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_STATUS__LANE_13_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_STATUS__LANE_13_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_STATUS__LANE_13_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_13_MARGINING_LANE_STATUS__LANE_13_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_CNTL__LANE_14_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_CNTL__LANE_14_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_CNTL__LANE_14_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_CNTL__LANE_14_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_CNTL__LANE_14_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_STATUS__LANE_14_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_STATUS__LANE_14_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_STATUS__LANE_14_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_STATUS__LANE_14_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_14_MARGINING_LANE_STATUS__LANE_14_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_CNTL
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_CNTL__LANE_15_RECEIVER_NUMBER__SHIFT                         0x0
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_TYPE__SHIFT                             0x3
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_CNTL__LANE_15_USAGE_MODEL__SHIFT                             0x6
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_PAYLOAD__SHIFT                          0x8
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_CNTL__LANE_15_RECEIVER_NUMBER_MASK                           0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_TYPE_MASK                               0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_CNTL__LANE_15_USAGE_MODEL_MASK                               0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_CNTL__LANE_15_MARGIN_PAYLOAD_MASK                            0xFF00L
//BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_STATUS
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_STATUS__LANE_15_RECEIVER_NUMBER_STATUS__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_TYPE_STATUS__SHIFT                    0x3
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_STATUS__LANE_15_USAGE_MODEL_STATUS__SHIFT                    0x6
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_PAYLOAD_STATUS__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_STATUS__LANE_15_RECEIVER_NUMBER_STATUS_MASK                  0x0007L
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_TYPE_STATUS_MASK                      0x0038L
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_STATUS__LANE_15_USAGE_MODEL_STATUS_MASK                      0x0040L
#define BIF_CFG_DEV0_EPF1_LANE_15_MARGINING_LANE_STATUS__LANE_15_MARGIN_PAYLOAD_STATUS_MASK                   0xFF00L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__CAP_ID__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__CAP_VER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                    0x14
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__CAP_ID_MASK                                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__CAP_VER_MASK                                       0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST__NEXT_PTR_MASK                                      0xFFF00000L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CAP
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CAP__VF_BAR_SIZE_SUPPORTED__SHIFT                               0x4
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CAP__VF_BAR_SIZE_SUPPORTED_MASK                                 0xFFFFFFF0L
//BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_INDEX__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_TOTAL_NUM__SHIFT                                   0x5
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_SIZE__SHIFT                                        0x8
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER__SHIFT                        0x10
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_INDEX_MASK                                         0x00000007L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_TOTAL_NUM_MASK                                     0x000000E0L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_SIZE_MASK                                          0x00003F00L
#define BIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL__VF_BAR_SIZE_SUPPORTED_UPPER_MASK                          0xFFFF0000L
//BIF_CFG_DEV0_EPF1_PCIE_RTR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_PCIE_RTR_ENH_CAP_LIST__CAP_ID__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_PCIE_RTR_ENH_CAP_LIST__CAP_VER__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF1_PCIE_RTR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                              0x14
#define BIF_CFG_DEV0_EPF1_PCIE_RTR_ENH_CAP_LIST__CAP_ID_MASK                                                  0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_PCIE_RTR_ENH_CAP_LIST__CAP_VER_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF1_PCIE_RTR_ENH_CAP_LIST__NEXT_PTR_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_EPF1_RTR_DATA1
#define BIF_CFG_DEV0_EPF1_RTR_DATA1__RESET_TIME__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF1_RTR_DATA1__DLUP_TIME__SHIFT                                                         0xc
#define BIF_CFG_DEV0_EPF1_RTR_DATA1__VALID__SHIFT                                                             0x1f
#define BIF_CFG_DEV0_EPF1_RTR_DATA1__RESET_TIME_MASK                                                          0x00000FFFL
#define BIF_CFG_DEV0_EPF1_RTR_DATA1__DLUP_TIME_MASK                                                           0x00FFF000L
#define BIF_CFG_DEV0_EPF1_RTR_DATA1__VALID_MASK                                                               0x80000000L
//BIF_CFG_DEV0_EPF1_RTR_DATA2
#define BIF_CFG_DEV0_EPF1_RTR_DATA2__FLR_TIME__SHIFT                                                          0x0
#define BIF_CFG_DEV0_EPF1_RTR_DATA2__D3HOTD0_TIME__SHIFT                                                      0xc
#define BIF_CFG_DEV0_EPF1_RTR_DATA2__FLR_TIME_MASK                                                            0x00000FFFL
#define BIF_CFG_DEV0_EPF1_RTR_DATA2__D3HOTD0_TIME_MASK                                                        0x00FFF000L


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf2_bifcfgdecp
//BIF_CFG_DEV0_EPF2_VENDOR_ID
#define BIF_CFG_DEV0_EPF2_VENDOR_ID__VENDOR_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF2_VENDOR_ID__VENDOR_ID_MASK                                                           0xFFFFL
//BIF_CFG_DEV0_EPF2_DEVICE_ID
#define BIF_CFG_DEV0_EPF2_DEVICE_ID__DEVICE_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF2_DEVICE_ID__DEVICE_ID_MASK                                                           0xFFFFL
//BIF_CFG_DEV0_EPF2_COMMAND
#define BIF_CFG_DEV0_EPF2_COMMAND__IO_ACCESS_EN__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF2_COMMAND__MEM_ACCESS_EN__SHIFT                                                       0x1
#define BIF_CFG_DEV0_EPF2_COMMAND__BUS_MASTER_EN__SHIFT                                                       0x2
#define BIF_CFG_DEV0_EPF2_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                    0x3
#define BIF_CFG_DEV0_EPF2_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                             0x4
#define BIF_CFG_DEV0_EPF2_COMMAND__PAL_SNOOP_EN__SHIFT                                                        0x5
#define BIF_CFG_DEV0_EPF2_COMMAND__AD_STEPPING__SHIFT                                                         0x7
#define BIF_CFG_DEV0_EPF2_COMMAND__SERR_EN__SHIFT                                                             0x8
#define BIF_CFG_DEV0_EPF2_COMMAND__FAST_B2B_EN__SHIFT                                                         0x9
#define BIF_CFG_DEV0_EPF2_COMMAND__INT_DIS__SHIFT                                                             0xa
#define BIF_CFG_DEV0_EPF2_COMMAND__IO_ACCESS_EN_MASK                                                          0x0001L
#define BIF_CFG_DEV0_EPF2_COMMAND__MEM_ACCESS_EN_MASK                                                         0x0002L
#define BIF_CFG_DEV0_EPF2_COMMAND__BUS_MASTER_EN_MASK                                                         0x0004L
#define BIF_CFG_DEV0_EPF2_COMMAND__SPECIAL_CYCLE_EN_MASK                                                      0x0008L
#define BIF_CFG_DEV0_EPF2_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                               0x0010L
#define BIF_CFG_DEV0_EPF2_COMMAND__PAL_SNOOP_EN_MASK                                                          0x0020L
#define BIF_CFG_DEV0_EPF2_COMMAND__AD_STEPPING_MASK                                                           0x0080L
#define BIF_CFG_DEV0_EPF2_COMMAND__SERR_EN_MASK                                                               0x0100L
#define BIF_CFG_DEV0_EPF2_COMMAND__FAST_B2B_EN_MASK                                                           0x0200L
#define BIF_CFG_DEV0_EPF2_COMMAND__INT_DIS_MASK                                                               0x0400L
//BIF_CFG_DEV0_EPF2_STATUS
#define BIF_CFG_DEV0_EPF2_STATUS__IMMEDIATE_READINESS__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF2_STATUS__INT_STATUS__SHIFT                                                           0x3
#define BIF_CFG_DEV0_EPF2_STATUS__CAP_LIST__SHIFT                                                             0x4
#define BIF_CFG_DEV0_EPF2_STATUS__PCI_66_CAP__SHIFT                                                           0x5
#define BIF_CFG_DEV0_EPF2_STATUS__FAST_BACK_CAPABLE__SHIFT                                                    0x7
#define BIF_CFG_DEV0_EPF2_STATUS__DEVSEL_TIMING__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF2_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                  0xb
#define BIF_CFG_DEV0_EPF2_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF2_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                0xd
#define BIF_CFG_DEV0_EPF2_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                                0xe
#define BIF_CFG_DEV0_EPF2_STATUS__IMMEDIATE_READINESS_MASK                                                    0x0001L
#define BIF_CFG_DEV0_EPF2_STATUS__INT_STATUS_MASK                                                             0x0008L
#define BIF_CFG_DEV0_EPF2_STATUS__CAP_LIST_MASK                                                               0x0010L
#define BIF_CFG_DEV0_EPF2_STATUS__PCI_66_CAP_MASK                                                             0x0020L
#define BIF_CFG_DEV0_EPF2_STATUS__FAST_BACK_CAPABLE_MASK                                                      0x0080L
#define BIF_CFG_DEV0_EPF2_STATUS__DEVSEL_TIMING_MASK                                                          0x0600L
#define BIF_CFG_DEV0_EPF2_STATUS__SIGNAL_TARGET_ABORT_MASK                                                    0x0800L
#define BIF_CFG_DEV0_EPF2_STATUS__RECEIVED_TARGET_ABORT_MASK                                                  0x1000L
#define BIF_CFG_DEV0_EPF2_STATUS__RECEIVED_MASTER_ABORT_MASK                                                  0x2000L
#define BIF_CFG_DEV0_EPF2_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                  0x4000L
//BIF_CFG_DEV0_EPF2_REVISION_ID
#define BIF_CFG_DEV0_EPF2_REVISION_ID__MINOR_REV_ID__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF2_REVISION_ID__MAJOR_REV_ID__SHIFT                                                    0x4
#define BIF_CFG_DEV0_EPF2_REVISION_ID__MINOR_REV_ID_MASK                                                      0x0FL
#define BIF_CFG_DEV0_EPF2_REVISION_ID__MAJOR_REV_ID_MASK                                                      0xF0L
//BIF_CFG_DEV0_EPF2_PROG_INTERFACE
#define BIF_CFG_DEV0_EPF2_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_PROG_INTERFACE__PROG_INTERFACE_MASK                                                 0xFFL
//BIF_CFG_DEV0_EPF2_SUB_CLASS
#define BIF_CFG_DEV0_EPF2_SUB_CLASS__SUB_CLASS__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF2_SUB_CLASS__SUB_CLASS_MASK                                                           0xFFL
//BIF_CFG_DEV0_EPF2_BASE_CLASS
#define BIF_CFG_DEV0_EPF2_BASE_CLASS__BASE_CLASS__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_BASE_CLASS__BASE_CLASS_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF2_CACHE_LINE
#define BIF_CFG_DEV0_EPF2_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF2_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                    0xFFL
//BIF_CFG_DEV0_EPF2_LATENCY
#define BIF_CFG_DEV0_EPF2_LATENCY__LATENCY_TIMER__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_LATENCY__LATENCY_TIMER_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF2_HEADER
#define BIF_CFG_DEV0_EPF2_HEADER__HEADER_TYPE__SHIFT                                                          0x0
#define BIF_CFG_DEV0_EPF2_HEADER__DEVICE_TYPE__SHIFT                                                          0x7
#define BIF_CFG_DEV0_EPF2_HEADER__HEADER_TYPE_MASK                                                            0x7FL
#define BIF_CFG_DEV0_EPF2_HEADER__DEVICE_TYPE_MASK                                                            0x80L
//BIF_CFG_DEV0_EPF2_BIST
#define BIF_CFG_DEV0_EPF2_BIST__BIST_COMP__SHIFT                                                              0x0
#define BIF_CFG_DEV0_EPF2_BIST__BIST_STRT__SHIFT                                                              0x6
#define BIF_CFG_DEV0_EPF2_BIST__BIST_CAP__SHIFT                                                               0x7
#define BIF_CFG_DEV0_EPF2_BIST__BIST_COMP_MASK                                                                0x0FL
#define BIF_CFG_DEV0_EPF2_BIST__BIST_STRT_MASK                                                                0x40L
#define BIF_CFG_DEV0_EPF2_BIST__BIST_CAP_MASK                                                                 0x80L
//BIF_CFG_DEV0_EPF2_BASE_ADDR_1
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_1__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_1__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_BASE_ADDR_2
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_2__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_2__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_BASE_ADDR_3
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_3__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_3__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_BASE_ADDR_4
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_4__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_4__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_BASE_ADDR_5
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_5__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_5__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_BASE_ADDR_6
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_6__BASE_ADDR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_BASE_ADDR_6__BASE_ADDR_MASK                                                         0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_ADAPTER_ID
#define BIF_CFG_DEV0_EPF2_ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF2_ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                     0x10
#define BIF_CFG_DEV0_EPF2_ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_ADAPTER_ID__SUBSYSTEM_ID_MASK                                                       0xFFFF0000L
//BIF_CFG_DEV0_EPF2_ROM_BASE_ADDR
#define BIF_CFG_DEV0_EPF2_ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_ROM_BASE_ADDR__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_CAP_PTR
#define BIF_CFG_DEV0_EPF2_CAP_PTR__CAP_PTR__SHIFT                                                             0x0
#define BIF_CFG_DEV0_EPF2_CAP_PTR__CAP_PTR_MASK                                                               0xFFL
//BIF_CFG_DEV0_EPF2_INTERRUPT_LINE
#define BIF_CFG_DEV0_EPF2_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                                 0xFFL
//BIF_CFG_DEV0_EPF2_INTERRUPT_PIN
#define BIF_CFG_DEV0_EPF2_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF2_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                   0xFFL
//BIF_CFG_DEV0_EPF2_MIN_GRANT
#define BIF_CFG_DEV0_EPF2_MIN_GRANT__MIN_GNT__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF2_MIN_GRANT__MIN_GNT_MASK                                                             0xFFL
//BIF_CFG_DEV0_EPF2_MAX_LATENCY
#define BIF_CFG_DEV0_EPF2_MAX_LATENCY__MAX_LAT__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF2_MAX_LATENCY__MAX_LAT_MASK                                                           0xFFL
//BIF_CFG_DEV0_EPF2_VENDOR_CAP_LIST
#define BIF_CFG_DEV0_EPF2_VENDOR_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF2_VENDOR_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF2_VENDOR_CAP_LIST__LENGTH__SHIFT                                                      0x10
#define BIF_CFG_DEV0_EPF2_VENDOR_CAP_LIST__CAP_ID_MASK                                                        0x000000FFL
#define BIF_CFG_DEV0_EPF2_VENDOR_CAP_LIST__NEXT_PTR_MASK                                                      0x0000FF00L
#define BIF_CFG_DEV0_EPF2_VENDOR_CAP_LIST__LENGTH_MASK                                                        0x00FF0000L
//BIF_CFG_DEV0_EPF2_ADAPTER_ID_W
#define BIF_CFG_DEV0_EPF2_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF2_ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT                                                   0x10
#define BIF_CFG_DEV0_EPF2_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_ADAPTER_ID_W__SUBSYSTEM_ID_MASK                                                     0xFFFF0000L
//BIF_CFG_DEV0_EPF2_PMI_CAP_LIST
#define BIF_CFG_DEV0_EPF2_PMI_CAP_LIST__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF2_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV0_EPF2_PMI_CAP_LIST__CAP_ID_MASK                                                           0x00FFL
#define BIF_CFG_DEV0_EPF2_PMI_CAP_LIST__NEXT_PTR_MASK                                                         0xFF00L
//BIF_CFG_DEV0_EPF2_PMI_CAP
#define BIF_CFG_DEV0_EPF2_PMI_CAP__VERSION__SHIFT                                                             0x0
#define BIF_CFG_DEV0_EPF2_PMI_CAP__PME_CLOCK__SHIFT                                                           0x3
#define BIF_CFG_DEV0_EPF2_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0__SHIFT                                 0x4
#define BIF_CFG_DEV0_EPF2_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                   0x5
#define BIF_CFG_DEV0_EPF2_PMI_CAP__AUX_CURRENT__SHIFT                                                         0x6
#define BIF_CFG_DEV0_EPF2_PMI_CAP__D1_SUPPORT__SHIFT                                                          0x9
#define BIF_CFG_DEV0_EPF2_PMI_CAP__D2_SUPPORT__SHIFT                                                          0xa
#define BIF_CFG_DEV0_EPF2_PMI_CAP__PME_SUPPORT__SHIFT                                                         0xb
#define BIF_CFG_DEV0_EPF2_PMI_CAP__VERSION_MASK                                                               0x0007L
#define BIF_CFG_DEV0_EPF2_PMI_CAP__PME_CLOCK_MASK                                                             0x0008L
#define BIF_CFG_DEV0_EPF2_PMI_CAP__IMMEDIATE_READINESS_ON_RETURN_TO_D0_MASK                                   0x0010L
#define BIF_CFG_DEV0_EPF2_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                     0x0020L
#define BIF_CFG_DEV0_EPF2_PMI_CAP__AUX_CURRENT_MASK                                                           0x01C0L
#define BIF_CFG_DEV0_EPF2_PMI_CAP__D1_SUPPORT_MASK                                                            0x0200L
#define BIF_CFG_DEV0_EPF2_PMI_CAP__D2_SUPPORT_MASK                                                            0x0400L
#define BIF_CFG_DEV0_EPF2_PMI_CAP__PME_SUPPORT_MASK                                                           0xF800L
//BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                               0x3
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__PME_EN__SHIFT                                                      0x8
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                                 0x9
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                  0xd
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                               0x16
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                  0x17
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                    0x18
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__POWER_STATE_MASK                                                   0x00000003L
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                                 0x00000008L
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__PME_EN_MASK                                                        0x00000100L
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                   0x00001E00L
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                    0x00006000L
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__PME_STATUS_MASK                                                    0x00008000L
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                                 0x00400000L
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                    0x00800000L
#define BIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL__PMI_DATA_MASK                                                      0xFF000000L
//BIF_CFG_DEV0_EPF2_SBRN
#define BIF_CFG_DEV0_EPF2_SBRN__SBRN__SHIFT                                                                   0x0
#define BIF_CFG_DEV0_EPF2_SBRN__SBRN_MASK                                                                     0xFFL
//BIF_CFG_DEV0_EPF2_FLADJ
#define BIF_CFG_DEV0_EPF2_FLADJ__FLADJ__SHIFT                                                                 0x0
#define BIF_CFG_DEV0_EPF2_FLADJ__NFC__SHIFT                                                                   0x6
#define BIF_CFG_DEV0_EPF2_FLADJ__FLADJ_MASK                                                                   0x3FL
#define BIF_CFG_DEV0_EPF2_FLADJ__NFC_MASK                                                                     0x40L
//BIF_CFG_DEV0_EPF2_DBESL_DBESLD
#define BIF_CFG_DEV0_EPF2_DBESL_DBESLD__DBESL__SHIFT                                                          0x0
#define BIF_CFG_DEV0_EPF2_DBESL_DBESLD__DBESLD__SHIFT                                                         0x4
#define BIF_CFG_DEV0_EPF2_DBESL_DBESLD__DBESL_MASK                                                            0x0FL
#define BIF_CFG_DEV0_EPF2_DBESL_DBESLD__DBESLD_MASK                                                           0xF0L
//BIF_CFG_DEV0_EPF2_PCIE_CAP_LIST
#define BIF_CFG_DEV0_EPF2_PCIE_CAP_LIST__CAP_ID__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF2_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                      0x8
#define BIF_CFG_DEV0_EPF2_PCIE_CAP_LIST__CAP_ID_MASK                                                          0x00FFL
#define BIF_CFG_DEV0_EPF2_PCIE_CAP_LIST__NEXT_PTR_MASK                                                        0xFF00L
//BIF_CFG_DEV0_EPF2_PCIE_CAP
#define BIF_CFG_DEV0_EPF2_PCIE_CAP__VERSION__SHIFT                                                            0x0
#define BIF_CFG_DEV0_EPF2_PCIE_CAP__DEVICE_TYPE__SHIFT                                                        0x4
#define BIF_CFG_DEV0_EPF2_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF2_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                    0x9
#define BIF_CFG_DEV0_EPF2_PCIE_CAP__VERSION_MASK                                                              0x000FL
#define BIF_CFG_DEV0_EPF2_PCIE_CAP__DEVICE_TYPE_MASK                                                          0x00F0L
#define BIF_CFG_DEV0_EPF2_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                     0x0100L
#define BIF_CFG_DEV0_EPF2_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                      0x3E00L
//BIF_CFG_DEV0_EPF2_DEVICE_CAP
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                     0x3
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                     0x5
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                           0x6
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                            0x9
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                         0xf
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT                                        0x12
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT                                        0x1a
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                      0x1c
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                                0x00000007L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__PHANTOM_FUNC_MASK                                                       0x00000018L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__EXTENDED_TAG_MASK                                                       0x00000020L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                             0x000001C0L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                              0x00000E00L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                           0x00008000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK                                          0x03FC0000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK                                          0x0C000000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP__FLR_CAPABLE_MASK                                                        0x10000000L
//BIF_CFG_DEV0_EPF2_DEVICE_CNTL
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                                0x1
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                    0x2
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                   0x3
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                  0x4
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                                0x5
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                                 0x8
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                                 0x9
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                                 0xa
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                     0xb
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                           0xc
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__INITIATE_FLR__SHIFT                                                    0xf
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__CORR_ERR_EN_MASK                                                       0x0001L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                  0x0002L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                      0x0004L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__USR_REPORT_EN_MASK                                                     0x0008L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                    0x0010L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                  0x00E0L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                   0x0100L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                   0x0200L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                   0x0400L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                       0x0800L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                             0x7000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL__INITIATE_FLR_MASK                                                      0x8000L
//BIF_CFG_DEV0_EPF2_DEVICE_STATUS
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__CORR_ERR__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                                 0x1
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__FATAL_ERR__SHIFT                                                     0x2
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__USR_DETECTED__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__AUX_PWR__SHIFT                                                       0x4
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                             0x5
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED__SHIFT                                 0x6
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__CORR_ERR_MASK                                                        0x0001L
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                   0x0002L
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__FATAL_ERR_MASK                                                       0x0004L
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__USR_DETECTED_MASK                                                    0x0008L
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__AUX_PWR_MASK                                                         0x0010L
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                               0x0020L
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS__EMER_POWER_REDUCTION_DETECTED_MASK                                   0x0040L
//BIF_CFG_DEV0_EPF2_LINK_CAP
#define BIF_CFG_DEV0_EPF2_LINK_CAP__LINK_SPEED__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF2_LINK_CAP__LINK_WIDTH__SHIFT                                                         0x4
#define BIF_CFG_DEV0_EPF2_LINK_CAP__PM_SUPPORT__SHIFT                                                         0xa
#define BIF_CFG_DEV0_EPF2_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                   0xc
#define BIF_CFG_DEV0_EPF2_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                    0xf
#define BIF_CFG_DEV0_EPF2_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                             0x12
#define BIF_CFG_DEV0_EPF2_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                        0x13
#define BIF_CFG_DEV0_EPF2_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                        0x14
#define BIF_CFG_DEV0_EPF2_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                           0x15
#define BIF_CFG_DEV0_EPF2_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                        0x16
#define BIF_CFG_DEV0_EPF2_LINK_CAP__PORT_NUMBER__SHIFT                                                        0x18
#define BIF_CFG_DEV0_EPF2_LINK_CAP__LINK_SPEED_MASK                                                           0x0000000FL
#define BIF_CFG_DEV0_EPF2_LINK_CAP__LINK_WIDTH_MASK                                                           0x000003F0L
#define BIF_CFG_DEV0_EPF2_LINK_CAP__PM_SUPPORT_MASK                                                           0x00000C00L
#define BIF_CFG_DEV0_EPF2_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                     0x00007000L
#define BIF_CFG_DEV0_EPF2_LINK_CAP__L1_EXIT_LATENCY_MASK                                                      0x00038000L
#define BIF_CFG_DEV0_EPF2_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                               0x00040000L
#define BIF_CFG_DEV0_EPF2_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                          0x00080000L
#define BIF_CFG_DEV0_EPF2_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                          0x00100000L
#define BIF_CFG_DEV0_EPF2_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                             0x00200000L
#define BIF_CFG_DEV0_EPF2_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                          0x00400000L
#define BIF_CFG_DEV0_EPF2_LINK_CAP__PORT_NUMBER_MASK                                                          0xFF000000L
//BIF_CFG_DEV0_EPF2_LINK_CNTL
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__PM_CONTROL__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B__SHIFT                                      0x2
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                                 0x3
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__LINK_DIS__SHIFT                                                          0x4
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__RETRAIN_LINK__SHIFT                                                      0x5
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                  0x6
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                     0x7
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                         0x8
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                       0x9
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                         0xa
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                         0xb
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__DRS_SIGNALING_CONTROL__SHIFT                                             0xe
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__PM_CONTROL_MASK                                                          0x0003L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__PTM_PROP_DELAY_ADAPT_INTER_B_MASK                                        0x0004L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                   0x0008L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__LINK_DIS_MASK                                                            0x0010L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__RETRAIN_LINK_MASK                                                        0x0020L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                    0x0040L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__EXTENDED_SYNC_MASK                                                       0x0080L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                           0x0100L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                         0x0200L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                           0x0400L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                           0x0800L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL__DRS_SIGNALING_CONTROL_MASK                                               0xC000L
//BIF_CFG_DEV0_EPF2_LINK_STATUS
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                           0x4
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__LINK_TRAINING__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                  0xc
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__DL_ACTIVE__SHIFT                                                       0xd
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                       0xe
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                       0xf
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                                0x000FL
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                             0x03F0L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__LINK_TRAINING_MASK                                                     0x0800L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                    0x1000L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__DL_ACTIVE_MASK                                                         0x2000L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                         0x4000L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                         0x8000L
//BIF_CFG_DEV0_EPF2_DEVICE_CAP2
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                       0x4
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                        0x5
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                      0x6
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                      0x7
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                      0x8
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                       0xa
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__LN_SYSTEM_CLS__SHIFT                                                   0xe
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED__SHIFT                                 0x10
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED__SHIFT                                 0x11
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                  0x12
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                    0x14
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                    0x15
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                        0x16
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED__SHIFT                                  0x18
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ__SHIFT                                   0x1a
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__FRS_SUPPORTED__SHIFT                                                   0x1f
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                       0x0000000FL
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                         0x00000010L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                          0x00000020L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                        0x00000040L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                        0x00000080L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                        0x00000100L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                            0x00000200L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                         0x00000400L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                     0x00000800L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                                0x00003000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__LN_SYSTEM_CLS_MASK                                                     0x0000C000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__TEN_BIT_TAG_COMPLETER_SUPPORTED_MASK                                   0x00010000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__TEN_BIT_TAG_REQUESTER_SUPPORTED_MASK                                   0x00020000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                    0x000C0000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                      0x00100000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                      0x00200000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                          0x00C00000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__EMER_POWER_REDUCTION_SUPPORTED_MASK                                    0x03000000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__EMER_POWER_REDUCTION_INIT_REQ_MASK                                     0x04000000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CAP2__FRS_SUPPORTED_MASK                                                     0x80000000L
//BIF_CFG_DEV0_EPF2_DEVICE_CNTL2
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                                0x4
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                            0x6
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                       0x7
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                             0x8
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__LTR_EN__SHIFT                                                         0xa
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST__SHIFT                                   0xb
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE__SHIFT                                   0xc
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__OBFF_EN__SHIFT                                                        0xd
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                                0x000FL
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                  0x0010L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                                0x0020L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                              0x0040L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                         0x0080L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                               0x0100L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                            0x0200L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__LTR_EN_MASK                                                           0x0400L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__EMER_POWER_REDUCTION_REQUEST_MASK                                     0x0800L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__TEN_BIT_TAG_REQUESTER_ENABLE_MASK                                     0x1000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__OBFF_EN_MASK                                                          0x6000L
#define BIF_CFG_DEV0_EPF2_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF2_DEVICE_STATUS2
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS2__RESERVED__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_DEVICE_STATUS2__RESERVED_MASK                                                       0xFFFFL
//BIF_CFG_DEV0_EPF2_LINK_CAP2
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                              0x1
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT__SHIFT                                          0x10
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT__SHIFT                                         0x17
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT__SHIFT                                         0x18
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__DRS_SUPPORTED__SHIFT                                                     0x1f
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                                0x000000FEL
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                                 0x00000100L
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__LOWER_SKP_OS_GEN_SUPPORT_MASK                                            0x0000FE00L
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__LOWER_SKP_OS_RCV_SUPPORT_MASK                                            0x007F0000L
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__RTM1_PRESENCE_DET_SUPPORT_MASK                                           0x00800000L
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__RTM2_PRESENCE_DET_SUPPORT_MASK                                           0x01000000L
#define BIF_CFG_DEV0_EPF2_LINK_CAP2__DRS_SUPPORTED_MASK                                                       0x80000000L
//BIF_CFG_DEV0_EPF2_LINK_CNTL2
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                                 0x4
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                      0x5
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                            0x6
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                      0x7
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                             0xa
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                            0xc
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                  0x000FL
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                   0x0010L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                        0x0020L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                              0x0040L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__XMIT_MARGIN_MASK                                                        0x0380L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                               0x0400L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                     0x0800L
#define BIF_CFG_DEV0_EPF2_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                              0xF000L
//BIF_CFG_DEV0_EPF2_LINK_STATUS2
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT__SHIFT                                0x2
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT__SHIFT                                0x3
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT__SHIFT                                0x4
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT__SHIFT                                  0x5
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__RTM1_PRESENCE_DET__SHIFT                                              0x6
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__RTM2_PRESENCE_DET__SHIFT                                              0x7
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__CROSSLINK_RESOLUTION__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE__SHIFT                                  0xc
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__DRS_MESSAGE_RECEIVED__SHIFT                                           0xf
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                             0x0001L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__EQUALIZATION_COMPLETE_8GT_MASK                                        0x0002L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_8GT_MASK                                  0x0004L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_8GT_MASK                                  0x0008L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_8GT_MASK                                  0x0010L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_8GT_MASK                                    0x0020L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__RTM1_PRESENCE_DET_MASK                                                0x0040L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__RTM2_PRESENCE_DET_MASK                                                0x0080L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__CROSSLINK_RESOLUTION_MASK                                             0x0300L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__DOWNSTREAM_COMPONENT_PRESENCE_MASK                                    0x7000L
#define BIF_CFG_DEV0_EPF2_LINK_STATUS2__DRS_MESSAGE_RECEIVED_MASK                                             0x8000L
//BIF_CFG_DEV0_EPF2_MSI_CAP_LIST
#define BIF_CFG_DEV0_EPF2_MSI_CAP_LIST__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF2_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV0_EPF2_MSI_CAP_LIST__CAP_ID_MASK                                                           0x00FFL
#define BIF_CFG_DEV0_EPF2_MSI_CAP_LIST__NEXT_PTR_MASK                                                         0xFF00L
//BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_EN__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                  0x1
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                   0x4
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                      0x7
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                      0x8
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP__SHIFT                                           0x9
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN__SHIFT                                            0xa
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_EN_MASK                                                           0x0001L
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                    0x000EL
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                     0x0070L
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_64BIT_MASK                                                        0x0080L
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                        0x0100L
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_CAP_MASK                                             0x0200L
#define BIF_CFG_DEV0_EPF2_MSI_MSG_CNTL__MSI_EXT_MSG_DATA_EN_MASK                                              0x0400L
//BIF_CFG_DEV0_EPF2_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV0_EPF2_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                             0x2
#define BIF_CFG_DEV0_EPF2_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                               0xFFFFFFFCL
//BIF_CFG_DEV0_EPF2_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV0_EPF2_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF2_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_MSI_MSG_DATA
#define BIF_CFG_DEV0_EPF2_MSI_MSG_DATA__MSI_DATA__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_MSI_MSG_DATA__MSI_DATA_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF2_MSI_EXT_MSG_DATA
#define BIF_CFG_DEV0_EPF2_MSI_EXT_MSG_DATA__MSI_EXT_DATA__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_MSI_EXT_MSG_DATA__MSI_EXT_DATA_MASK                                                 0xFFFFL
//BIF_CFG_DEV0_EPF2_MSI_MASK
#define BIF_CFG_DEV0_EPF2_MSI_MASK__MSI_MASK__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF2_MSI_MASK__MSI_MASK_MASK                                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_MSI_MSG_DATA_64
#define BIF_CFG_DEV0_EPF2_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF2_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                   0xFFFFL
//BIF_CFG_DEV0_EPF2_MSI_EXT_MSG_DATA_64
#define BIF_CFG_DEV0_EPF2_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF2_MSI_EXT_MSG_DATA_64__MSI_EXT_DATA_64_MASK                                           0xFFFFL
//BIF_CFG_DEV0_EPF2_MSI_MASK_64
#define BIF_CFG_DEV0_EPF2_MSI_MASK_64__MSI_MASK_64__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_MSI_MASK_64__MSI_MASK_64_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_MSI_PENDING
#define BIF_CFG_DEV0_EPF2_MSI_PENDING__MSI_PENDING__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_MSI_PENDING__MSI_PENDING_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_MSI_PENDING_64
#define BIF_CFG_DEV0_EPF2_MSI_PENDING_64__MSI_PENDING_64__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_MSI_PENDING_64__MSI_PENDING_64_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_MSIX_CAP_LIST
#define BIF_CFG_DEV0_EPF2_MSIX_CAP_LIST__CAP_ID__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF2_MSIX_CAP_LIST__NEXT_PTR__SHIFT                                                      0x8
#define BIF_CFG_DEV0_EPF2_MSIX_CAP_LIST__CAP_ID_MASK                                                          0x00FFL
#define BIF_CFG_DEV0_EPF2_MSIX_CAP_LIST__NEXT_PTR_MASK                                                        0xFF00L
//BIF_CFG_DEV0_EPF2_MSIX_MSG_CNTL
#define BIF_CFG_DEV0_EPF2_MSIX_MSG_CNTL__MSIX_TABLE_SIZE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_MSIX_MSG_CNTL__MSIX_FUNC_MASK__SHIFT                                                0xe
#define BIF_CFG_DEV0_EPF2_MSIX_MSG_CNTL__MSIX_EN__SHIFT                                                       0xf
#define BIF_CFG_DEV0_EPF2_MSIX_MSG_CNTL__MSIX_TABLE_SIZE_MASK                                                 0x07FFL
#define BIF_CFG_DEV0_EPF2_MSIX_MSG_CNTL__MSIX_FUNC_MASK_MASK                                                  0x4000L
#define BIF_CFG_DEV0_EPF2_MSIX_MSG_CNTL__MSIX_EN_MASK                                                         0x8000L
//BIF_CFG_DEV0_EPF2_MSIX_TABLE
#define BIF_CFG_DEV0_EPF2_MSIX_TABLE__MSIX_TABLE_BIR__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF2_MSIX_TABLE__MSIX_TABLE_OFFSET__SHIFT                                                0x3
#define BIF_CFG_DEV0_EPF2_MSIX_TABLE__MSIX_TABLE_BIR_MASK                                                     0x00000007L
#define BIF_CFG_DEV0_EPF2_MSIX_TABLE__MSIX_TABLE_OFFSET_MASK                                                  0xFFFFFFF8L
//BIF_CFG_DEV0_EPF2_MSIX_PBA
#define BIF_CFG_DEV0_EPF2_MSIX_PBA__MSIX_PBA_BIR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_MSIX_PBA__MSIX_PBA_OFFSET__SHIFT                                                    0x3
#define BIF_CFG_DEV0_EPF2_MSIX_PBA__MSIX_PBA_BIR_MASK                                                         0x00000007L
#define BIF_CFG_DEV0_EPF2_MSIX_PBA__MSIX_PBA_OFFSET_MASK                                                      0xFFFFFFF8L
//BIF_CFG_DEV0_EPF2_SATA_CAP_0
#define BIF_CFG_DEV0_EPF2_SATA_CAP_0__CAP_ID__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF2_SATA_CAP_0__NEXT_PTR__SHIFT                                                         0x8
#define BIF_CFG_DEV0_EPF2_SATA_CAP_0__SATA_CAP_MINOR_REV__SHIFT                                               0x10
#define BIF_CFG_DEV0_EPF2_SATA_CAP_0__SATA_CAP_MAJOR_REV__SHIFT                                               0x14
#define BIF_CFG_DEV0_EPF2_SATA_CAP_0__SATA_CAP_RESERVED1__SHIFT                                               0x18
#define BIF_CFG_DEV0_EPF2_SATA_CAP_0__CAP_ID_MASK                                                             0x000000FFL
#define BIF_CFG_DEV0_EPF2_SATA_CAP_0__NEXT_PTR_MASK                                                           0x0000FF00L
#define BIF_CFG_DEV0_EPF2_SATA_CAP_0__SATA_CAP_MINOR_REV_MASK                                                 0x000F0000L
#define BIF_CFG_DEV0_EPF2_SATA_CAP_0__SATA_CAP_MAJOR_REV_MASK                                                 0x00F00000L
#define BIF_CFG_DEV0_EPF2_SATA_CAP_0__SATA_CAP_RESERVED1_MASK                                                 0xFF000000L
//BIF_CFG_DEV0_EPF2_SATA_CAP_1
#define BIF_CFG_DEV0_EPF2_SATA_CAP_1__SATA_CAP_BAR_LOC__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF2_SATA_CAP_1__SATA_CAP_BAR_OFFSET__SHIFT                                              0x4
#define BIF_CFG_DEV0_EPF2_SATA_CAP_1__SATA_CAP_RESERVED2__SHIFT                                               0x18
#define BIF_CFG_DEV0_EPF2_SATA_CAP_1__SATA_CAP_BAR_LOC_MASK                                                   0x0000000FL
#define BIF_CFG_DEV0_EPF2_SATA_CAP_1__SATA_CAP_BAR_OFFSET_MASK                                                0x00FFFFF0L
#define BIF_CFG_DEV0_EPF2_SATA_CAP_1__SATA_CAP_RESERVED2_MASK                                                 0xFF000000L
//BIF_CFG_DEV0_EPF2_SATA_IDP_INDEX
#define BIF_CFG_DEV0_EPF2_SATA_IDP_INDEX__IDP_RESERVED1__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF2_SATA_IDP_INDEX__IDP_INDEX__SHIFT                                                    0x2
#define BIF_CFG_DEV0_EPF2_SATA_IDP_INDEX__IDP_RESERVED2__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF2_SATA_IDP_INDEX__IDP_RESERVED1_MASK                                                  0x00000003L
#define BIF_CFG_DEV0_EPF2_SATA_IDP_INDEX__IDP_INDEX_MASK                                                      0x00000FFCL
#define BIF_CFG_DEV0_EPF2_SATA_IDP_INDEX__IDP_RESERVED2_MASK                                                  0xFFFFF000L
//BIF_CFG_DEV0_EPF2_SATA_IDP_DATA
#define BIF_CFG_DEV0_EPF2_SATA_IDP_DATA__IDP_DATA__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF2_SATA_IDP_DATA__IDP_DATA_MASK                                                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                   0x10
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                  0x14
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                      0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                     0x000F0000L
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                    0xFFF00000L
//BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                           0x10
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                        0x14
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                             0x000F0000L
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                          0xFFF00000L
//BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                                 0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                       0x10
#define BIF_CFG_DEV0_EPF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                         0x000F0000L
#define BIF_CFG_DEV0_EPF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                        0xFFF00000L
//BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                       0x4
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                    0x5
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                       0xc
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                        0xd
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                   0xe
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                                 0xf
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                      0x11
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                       0x12
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                      0x13
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                                0x14
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                                 0x15
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                                0x16
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                                0x17
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                       0x18
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                        0x19
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS__SHIFT                   0x1a
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                         0x00000010L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                      0x00000020L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                         0x00001000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                          0x00002000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                     0x00004000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                   0x00008000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                       0x00010000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                        0x00020000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                         0x00040000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                        0x00080000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                  0x00100000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                   0x00200000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                  0x00400000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                  0x00800000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                         0x01000000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                          0x02000000L
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS__POISONED_TLP_EGRESS_BLOCKED_STATUS_MASK                     0x04000000L
//BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                           0x4
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                        0x5
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                           0xc
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                            0xd
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                       0xe
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                     0xf
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                         0x10
#define BIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                          0x11
#define BIF_CFG_DEV0_EPF2_PCIE