#ifndef HAVE_ADNS_NSEC3_RR_H
#define HAVE_ADNS_NSEC3_RR_H

#include "adns_rr.h"

namespace ADNS {

/* From RFC 5155

3.2. NSEC3 RDATA Wire Format


   The RDATA of the NSEC3 RR is as shown below:

                        1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |   Hash Alg.   |     Flags     |          Iterations           |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |  Salt Length  |                     Salt                      /
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |  Hash Length  |             Next Hashed Owner Name            /
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   /                         Type Bit Maps                         /
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   Hash Algorithm is a single octet.

   Flags field is a single octet, the Opt-Out flag is the least
   significant bit, as shown below:

    0 1 2 3 4 5 6 7
   +-+-+-+-+-+-+-+-+
   |             |O|
   +-+-+-+-+-+-+-+-+
 
 */

	public ref class NSEC3_RR : ResourceRecord
	{
	public:
		NSEC3_RR();
		HASH_ALGORITHM GetHashAlgorithm();
		Void SetHashAlgorithm(HASH_ALGORITHM h);
		array<Byte>^ GetNextHashedOwner();
		Void SetNextHashedOwner(array<Byte>^ hash);
		bool GetOptOutFlag();
		Void SetOptOutFlag(bool val);
		UInt16 GetIterations();
		Void SetIterations(UInt16 val);
		array<Byte>^ GetSalt();
		Void SetSalt(array<Byte>^ newsalt);
		array<Byte>^ GetBitmap();
		Void SetBitmap(List<RR_TYPE>^ typelist);
		Void SetBitmap(array<Byte>^ bm);
		String^ Print();
		bool BitmapCoversType(RR_TYPE t);
		Void ToCanonical();
		NSEC3_RR^ Clone();
		static ResourceRecord^ ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start);
		static String^ PrintRR(ResourceRecord^ rec);
		static ResourceRecord^ CloneRR(ResourceRecord^ rec);

	private:
		HASH_ALGORITHM algo;
		Byte Flags;
		UInt16 Iterations;
		array<Byte>^ Salt;
		array<Byte>^ NextHashedOwner;
		array<Byte>^ Bitmap;
		Void UpdateRdata();
		List<RR_TYPE>^ GetTypesFromBitmap();

	};


}

#endif
