
package WSNotification::Attributes::space;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.w3.org/XML/1998/namespace' }

__PACKAGE__->__set_name('space');
__PACKAGE__->__set_ref();

# atomic simpleType: <attribute><simpleType
use base qw(
    SOAP::WSDL::XSD::Typelib::Attribute
);
# derivation by restriction
use base qw(
    SOAP::WSDL::XSD::Typelib::Builtin::NCName);


}



1;


=pod

=head1 NAME

WSNotification::Attributes::space

=head1 DESCRIPTION

Perl data type class for the XML Schema defined attribute
space from the namespace http://www.w3.org/XML/1998/namespace.

denotes an attribute whose value is a keyword indicating what whitespace processing discipline is intended for the content of the element; its value is inherited. This name is reserved by virtue of its definition in the XML specification. 




This XML element type class has a atomic simpleType as it's base:



=head1 METHODS

=head2 new

 my $element = WSNotification::Attributes::space->new($data);

Constructor. The following data structure may be passed to new():

 { value => $value }

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

