/*---------------------------------------------------------------------------*\

    FILE....: MESS.H
    TYPE....: C Function Header File
    AUTHOR..: John Kostogiannis
    DATE....: 21/11/97

    Interface functions for messages.  Messages are information sent by
    various modules to a message window using standard printf formatting.  They
    are used to give information about low level operations during
    development. Not to be confused with PC-DSP messages!


         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __MESSWIN32__
#define __MESSWIN32__

#define ON	1
#define OFF	0
#define MAXSTR 150

void mess_init();
void mess_mprintf_on();
void mess_mprintf_on(const char *fn);
void mess_mprintf_on(const char *fn, const char *s);
void mess_mprintf_off();

void mess_set_messages(void (*func)(const char *stuff, ...));

void mprintf(const char *fmt, ...) __attribute__ ((format(__printf__,1,2)));


#endif	/* #ifndef __MESS__	*/

