# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

# Pour générer la version windows, il faut 
#   se positionner dans le répertoire trunk
#   lancer la commande : "c:\Program Files\Python26\python.exe" setup-portable.py py2exe
#   ça crée un répertoire dist sous trunk
#     copier les répertoires help, icons, iconstr, luma et locale dans le répertoire dist
#     ajouter la partie extern_bin dans portable
#     creer la structure de repertoire suivante sous portable : PyQt4\Plugins\imageformats
#     copier les fichiers dll depuis Python26\Lib\site-packages\PyQt4\plugins\imageformats dans dist\PyQt4\Plugins\imageformats
#     creer un fichier qt.conf dans dist avec le contenu suivant :
#        [Paths]
#        Prefix = ./PyQt4
# dist contient maintenant tout ce qu'il faut pour faire le package avec inno-setup
# la ligne de commande étant : portable\PortableVideoporama.exe

import os
from distutils.core import setup
import py2exe

setup(name = "videoporama",
      version = "BETA 0.8.1",
      description = "PortableVideoporama - Application to make video of image slideshow",
      author = "Ponchaut Olivier - Levray Dominique",
      author_email = "videoporama@numericable.be",
      url = "http://www.videoporama.tuxfamily.org",
      scripts = ["videoporama"],
      windows=[{"script":"PortableVideoporama.py",
		"icon_resources": [(1, "icone_videoporama.ico")]}],
      options={"py2exe":{
        "includes":[                                                  # addition python modules
          "sip","PyQt4.QtCore","PyQt4.QtGui",
          "pyexiv2","Image","StringIO"
        ],"optimize": 2,                                              # 0 = don’t optimize (generate .pyc), 1 = normal optimization, 2 = extra optimization
        "bundle_files": 3,                                            # This tells py2exe to bundle everything
        "dist_dir": 'portable',                                       # Where to build the final files
        "xref" : False,                                               # Create and show a module cross reference
        "skip_archive" : False,                                       # True put files in the file system, False : in the python bytecode
        "ascii" : False,                                              # False : include encodings
        "custom_boot_script" : ''                                     # script to run at pyton startup (before the software)
      }},
      long_description= """
Videoporama is an application to make diaporama from images export in video file. It is written in Python using QT4 and the PyQt4 GUI toolkit. It use MJPEGtools, ffmpeg, sox and PIL to build images and convert them to movie
"""
)
