/*
 * make vf which simulates vert-BKfont symbol by hor-BKfont
 * mkvsyvf rml 10 rmlvsy /.../rmlvsy.tfm vch pssp [VFDIR]
 * --> rmlvsy.vf
 */
#include	<stdio.h>
#include	"defs.h"
#include	"vfcodes.h"
#include	"vchar.h"
#include	"bifont.h"

char *horfont;
char *vsyfont;
int vfds;
char *vfdir;
FILE *tfm, *vf;

/* set by readvchar */
extern struct vchar vchar[];
extern int depthratio;
extern int rdisp, ddisp, vdisp;

/* set by readtfm */
extern char header[];
extern char width[];
extern byte char_info[];
extern int nt, lh, bc, ec, nw, ds;

main(ac, av)
int ac;
char *av[];
{
    char name[64];

    horfont = av[1];
    vfds = atoi(av[2])<<20;
    vsyfont = av[3];
    if ((tfm = fopen(av[4], "r")) == NULL) {
	fprintf(stderr, "cannot read %s\n", av[4]);
	exit(1);
    }
    if (!readtfm(tfm)) {
	fprintf(stderr, "%s is not tfm\n", av[4]);
	exit(1);
    }

    readvchar(av[5]);
    readpssp(av[6]);

    vfdir = (ac > 7) ? av[7] : "";
    sprintf(name, "%s%s.vf", vfdir, vsyfont);
    if ((vf = fopen(name, "w")) == NULL) {
	fprintf(stderr, "cannot write %s\n", name);
	exit(1);
    }
    vsyvf();
    fclose(vf);

    exit(0);
}

#define	SPLEN	256
char rotate_beg[SPLEN];
int rotate_beg_len;
char rotate_end[SPLEN];
int rotate_end_len;
char mirror_beg[SPLEN];
int mirror_beg_len;
char mirror_end[SPLEN];
int mirror_end_len;

getline(sp, lenp, f)
char *sp;
int *lenp;
FILE *f;
{
    int l;

    fgets(sp, SPLEN, f);
    l = strlen(sp);
    sp[l-1] = '\0';
    *lenp = l-1;
}

readpssp(fn)
char *fn;
{
    FILE *f;

    if ((f = fopen(fn, "r")) == NULL) {
	fprintf(stderr, "cannot open %s\n", fn);
	exit(1);
    }
    getline(rotate_beg, &rotate_beg_len, f);
    getline(rotate_end, &rotate_end_len, f);
    getline(mirror_beg, &mirror_beg_len, f);
    getline(mirror_end, &mirror_end_len, f);
}

vsyvf()
{
    struct vchar *vc;
    char jsubname[64];
    long len;
    int i;

    putuint(vf, VF_PRE, 1);
    putuint(vf, VF_ID, 1);
    putuint(vf, 0, 1);	/* no comment */
    putbytes(vf, header, 2*4);	/* check sum & design size */

    fontdef(1, horfont);

    for (vc = vchar; vc->cc != 0; vc++)
	vfchar(vc);

    len = ftell(vf);
    for (i = 0; i < 4 - len%4; i++)
	putuint(vf, VF_POST, 1);
}

fontdef(f, fn)
int f;
char *fn;
{
    putuint(vf, FNT_DEF1, 1);
    putuint(vf, f, 1);
    putuint(vf, 0, 4);
    putuint(vf, VFRATIO, 4);
    putuint(vf, vfds, 4);
    putuint(vf, 0, 1);
    putuint(vf, strlen(fn), 1);
    putbytes(vf, fn, strlen(fn));
}

vfchar(vc)
struct vchar *vc;
{
    int pl;
    int rd, dd;
    int rn, dn;
    byte rb[sizeof(int)], db[sizeof(int)];
    char *sp_beg, *sp_end;
    int sp_beg_len, sp_end_len;

    if (vc->op == vop_rot) {
	rd = depthratio;
	dd = -rdisp;
	sp_beg = rotate_beg;
	sp_beg_len = rotate_beg_len;
	sp_end = rotate_end;
	sp_end_len = rotate_end_len;
    } else if (vc->op == vop_mirror) {
	rd = UNIT-depthratio;
	dd = -rdisp;
	sp_beg = mirror_beg;
	sp_beg_len = mirror_beg_len;
	sp_end = mirror_end;
	sp_end_len = mirror_end_len;
    } else
	return;
    pl = 3;	/* SET2 cc */
    rn = inttob(rb, rd, TRUE);
    pl += 1+rn;
    dn = inttob(db, dd, TRUE);
    pl += 1+dn;
    pl += 6+sp_beg_len+6+sp_end_len;

    putuint(vf, VF_LONG_CHAR, 1);
    putuint(vf, pl, 4);
    putuint(vf, vc->c, 4);
    putbytes(vf, width+char_info[(vc->c-bc)*4]*4, 4);
    putuint(vf, RIGHT1+rn-1, 1);
    putbytes(vf, rb, rn);
    putuint(vf, DOWN1+dn-1, 1);
    putbytes(vf, db, dn);
    putuint(vf, XXX1, 1);
    putuint(vf, sp_beg_len+4, 1);
    putbytes(vf, "ps::", 4);
    putbytes(vf, sp_beg, sp_beg_len);
    putuint(vf, SET2, 1);
    putuint(vf, vc->cc, 2);
    putuint(vf, XXX1, 1);
    putuint(vf, sp_end_len+4, 1);
    putbytes(vf, "ps::", 4);
    putbytes(vf, sp_end, sp_end_len);
}
