/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef __CIM_REMOTESERVICEACCESSPOINT_H
#define __CIM_REMOTESERVICEACCESSPOINT_H
#include "CIM_ServiceAccessPoint.h"
namespace CimClassNamespace
{

	// Class CIM_RemoteServiceAccessPoint:
	// RemoteServiceAccessPoint describes access and/or addressing information for a remote connection, that is known to a 'local' network element. This information is scoped/contained by the 'local' network element, since this is the context in which it is 'remote'.
	//
	// Why the remote access point is relevant and information on its use are described by subclassing RemoteService AccessPoint, or by associating to it.
	class CIM_RemoteServiceAccessPoint  : public CIM_ServiceAccessPoint
	{
	public:
		// type definitions
		typedef CimClassContainer<CIM_RemoteServiceAccessPoint> CIM_RemoteServiceAccessPointContainer;

		// static const declarations
		static const string CLASS_NAME;
		static const string CLASS_URI;
		static const string CLASS_NS;
		static const string CLASS_NS_PREFIX;

		// class fields
		// Access and/or addressing information for a remote connection. This can be a host name, network address or similar information.
		string AccessInfo;

		// This field determines whether the AccessInfo field is valid.
		bool AccessInfoSpecified;

		// An enumerated integer describing the format and interpretation of the AccessInfo property.
		// Legal values:
		// Other: 1
		// Host Name: 2
		// IPv4 Address: 3
		// IPv6 Address: 4
		// IPX Address: 5
		// DECnet Address: 6
		// SNA Address: 7
		// Autonomous System Number: 8
		// MPLS Label: 9
		// IPv4 Subnet Address: 10
		// IPv6 Subnet Address: 11
		// IPv4 Address Range: 12
		// IPv6 Address Range: 13
		// Dial String: 100
		// Ethernet Address: 101
		// Token Ring Address: 102
		// ATM Address: 103
		// Frame Relay Address: 104
		// URL: 200
		// FQDN: 201
		// User FQDN: 202
		// DER ASN1 DN: 203
		// DER ASN1 GN: 204
		// Key ID: 205
		// DMTF Reserved: ..
		// Vendor Reserved: 32768..65535
		unsigned short InfoFormat;

		// This field determines whether the InfoFormat field is valid.
		bool InfoFormatSpecified;

		// Describes the format when the property InfoFormat is set to 1 ("Other").
		string OtherInfoFormatDescription;

		// This field determines whether the OtherInfoFormatDescription field is valid.
		bool OtherInfoFormatDescriptionSpecified;

		// Invoke RequestStateChange Classes:
		// Requests that the element's state be changed to the value specified in the RequestedState parameter. When the requested state change takes place, the element's EnabledState and RequestedState will be the same. Invoking the RequestStateChange method multiple times could result in earlier requests being overwritten/lost.
		// If 0 is returned, then the task completed successfully and the use of ConcreteJob was not required. If 4096 (0x1000) is returned, then the task will take some time to complete, ConcreteJob will be created, and its reference returned in the output parameter Job. Any other return code indicates an error condition.
		class RequestStateChange_INPUT : public Serializable
		{
		public:
			// class fields
			// The state requested for the element. This information will be placed into the instance's RequestedState property if the RequestStateChange method's return code is 0, 3, or 4096 (0x1000) - 'Completed with No Error', 'Timeout', or 'Job Started' respectively. Refer to the description of the EnabledState and RequestedState properties for the detailed meanings of the RequestedState values.
			// Legal values:
			// Enabled: 2
			// Disabled: 3
			// Shut Down: 4
			// Offline: 6
			// Test: 7
			// Defer: 8
			// Quiesce: 9
			// Reboot: 10
			// Reset: 11
			// DMTF Reserved: ..
			// Vendor Reserved: 32768..65535
			unsigned short RequestedState;

			// This field determines whether the RequestedState field is valid.
			bool RequestedStateSpecified;

			// A timeout period that specifies the maximum amount of time that the client expects the transition to the new state to take. The interval format MUST be used to specify the TimeoutPeriod. A value of 0 or a null parameter indicates that the client has no time requirements for the transition.
			// If this property does not contain 0 or null and the implementation doesn't support this parameter. A return code of 'Use Of Timeout Parameter Not Supported' MUST be returned.
			DateTime TimeoutPeriod;

			// This field determines whether the TimeoutPeriod field is valid.
			bool TimeoutPeriodSpecified;

			// Class Constructor
			RequestStateChange_INPUT();

			// Class Destructor
			~RequestStateChange_INPUT(){}

			// This function appends a serialization of this instance to the given node.
			void SerializeMembers(XMLElement& node) const;
		};

		class RequestStateChange_OUTPUT : public DeSerializable
		{
		public:
			// class fields
			// Reference to the job (may be null if task completed).
			EndpointReference Job;

			// This field determines whether the Job field is valid.
			bool JobSpecified;

			// Function Return Value:
			// Legal values:
			// Completed with No Error: 0
			// Not Supported: 1
			// Unknown/Unspecified Error: 2
			// Can NOT complete within Timeout Period: 3
			// Failed: 4
			// Invalid Parameter: 5
			// In Use: 6
			// DMTF Reserved: ..
			// Method Parameters Checked - Job Started: 4096
			// Invalid State Transition: 4097
			// Use of Timeout Parameter Not Supported: 4098
			// Busy: 4099
			// Method Reserved: 4100..32767
			// Vendor Specific: 32768..65535
			unsigned int ReturnValue;

			// Class Constructor
			RequestStateChange_OUTPUT();

			// Class Destructor
			~RequestStateChange_OUTPUT(){}

			// This function sets a field value according to the given node.
			void SetValue(const XMLElement& elem);

		};

		// Class Constructor
		CIM_RemoteServiceAccessPoint(
			const string& objName = CIM_RemoteServiceAccessPoint::CLASS_NAME,
			const string& uri = CIM_RemoteServiceAccessPoint::CLASS_URI,
			const string& ns = CIM_RemoteServiceAccessPoint::CLASS_NS,
			const string& nsPrefix = CIM_RemoteServiceAccessPoint::CLASS_NS_PREFIX);

		// Class Destructor
		virtual ~CIM_RemoteServiceAccessPoint(){}

		// This function appends a serialization of this instance to the given node.
		virtual void SerializeMembers(XMLElement& node) const;

		// This function returns the selector set of this instance.
		virtual NameValuePairs GetSelectorsList() const;

		// This function sets a field value according to the given node.
		virtual void SetValue(const XMLElement& node);

		// This function performs the Invoke RequestStateChange operation using the given input.
		// The output of the function is returned in the given output class.
		virtual void InvokeRequestStateChange(RequestStateChange_INPUT &input, RequestStateChange_OUTPUT &output,  const WsmanClient *cl = defaultProvider) const;

	};
}
#endif
