/*
 * Copyright (C) 2013,2014 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DISPLAYCONFIGURATIONPOLICY_H
#define DISPLAYCONFIGURATIONPOLICY_H

#include "mir/graphics/display_configuration_policy.h"

#include <memory>

class DisplayConfigurationPolicy : public mir::graphics::DisplayConfigurationPolicy
{
public:
    DisplayConfigurationPolicy(std::shared_ptr<mir::graphics::DisplayConfigurationPolicy> const& base_policy,
                               bool with_alpha);
    void apply_to(mir::graphics::DisplayConfiguration& conf);

private:
    std::shared_ptr<mir::graphics::DisplayConfigurationPolicy> const base_policy;
    bool const with_alpha;
};

#endif // DISPLAYCONFIGURATIONPOLICY_H
