-- test/test-tongue.transliteration.lua
--
-- Lua I18N library 'Tongue' -- Tests for the transliteration module
--
-- Copyright 2016 Daniel Silverstone <dsilvers@digital-scurf.org>
--
-- For Licence terms, see COPYING
--

-- Step one, start coverage

pcall(require, 'luacov')

local tongue = require 'tongue'

local testnames = {}

local real_assert = assert
local total_asserts = 0
local function assert(...)
   local retval = real_assert(...)
   total_asserts = total_asserts + 1
   return retval
end

local function add_test(suite, name, value)
   rawset(suite, name, value)
   testnames[#testnames+1] = name
end

local suite = setmetatable({}, {__newindex = add_test})

function suite.get_passthru()
   local pt = tongue.transliteration.get("UTF-8")
   assert(pt, "Unable to get a passthrough transliterator")
   assert(pt:touser("다니앨") == "다니앨", "Passthrough mangles Korean")
   assert(pt:fromuser("다니앨") == "다니앨", "Passthrough mangles Korean")
end

function suite.get_simple_trans()
   local st = tongue.transliteration.get("ISO-8859-1")
   assert(st, "Unable to get a simple transliterator for testing")
   assert(st:touser("café") == "caf\233", "Unable to transliterate from UTF-8 to Latin 1")
end

function suite.real_transliterate()
   local st = tongue.transliteration.get("ASCII")
   assert(st, "Unable to get a simple transliterator for testing")
   assert(st:touser("œdipus") == "oedipus", "Unable to transliterate from UTF-8 to ASCII")
end

local count_ok = 0
for _, testname in ipairs(testnames) do
--   print("Run: " .. testname)
   local ok, err = xpcall(suite[testname], debug.traceback)
   if not ok then
      print(err)
      print()
   else
      count_ok = count_ok + 1
   end
end

print(tostring(count_ok) .. "/" .. tostring(#testnames) .. " [" .. tostring(total_asserts) .. "] OK")

os.exit(count_ok == #testnames and 0 or 1)
