'\"
'\" tdbc_resultset.n --
'\"
'\" Copyright (c) 2008 by Kevin B. Kenny.
'\"
'\" See the file "license.terms" for information on usage and redistribution of
'\" this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH "tdbc::resultset" n 8.6 Tcl "Tcl Database Connectivity"
'\" .so man.macros
'\" IGNORE
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
'\"	Draw four-sided box normally, but don't draw top of
'\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
'\" END IGNORE
.BS
.SH "NAME"
tdbc::resultset \- TDBC result set object
.SH "SYNOPSIS"
.nf
package require \fBtdbc 1.0\fR
package require \fBtdbc::\fR\fIdriver version\fR

\fBtdbc::\fR\fIdriver\fR\fB::connection create \fR\fIdb\fR \fI?\-option value\fR...?

\fBset\fR \fIstmt\fR \fB[\fR\fIdb\fR \fBprepare\fR \fIsql-code\fR\fB]\fR
\fBset\fR \fIresultset\fR \fB[\fR\fI$stmt\fR \fBexecute\fR ?\fIargs...\fR?\fB]\fR

\fI$resultset\fR \fBcolumns\fR
\fI$resultset\fR \fBrowcount\fR
\fI$resultset\fR \fBnextrow\fR ?\fB-as\fR \fBlists\fR|\fBdicts\fR? ?\fB--\fR? \fIvarname\fR
\fI$resultset\fR \fBnextlist\fR \fIvarname\fR
\fI$resultset\fR \fBnextdict\fR \fIvarname\fR
\fI$resultset\fR \fBnextresults\fR
.fi
.ad l
.in 14
.ti 7
\fI$resultset\fR \fBallrows\fR ?\fB-as lists|dicts\fR? ?\fB-columnsvariable\fR \fIname\fR? ?\fB--\fR?
.br
.ti 7
\fI$resultset\fR \fBforeach\fR ?\fB-as lists|dicts\fR? ?\fB-columnsvariable\fR \fIname\fR? ?\fB--\fR? \fIvarname\fR \fIscript\fR
.br
.ti 7
\fI$resultset\fR \fBclose\fR
.ad b
.BE
.SH "DESCRIPTION"
.PP
Every database driver for TDBC (Tcl DataBase Connectivity) implements
a \fIresult set\fR object that represents a the results returned from
executing SQL statement in a database. Instances of this object are created 
by executing the \fBexecute\fR object command on a statement object.
.PP
The \fBcolumns\fR object command returns a list of the names of the columns 
in the result set. The columns will appear in the same order as they appeared
in the SQL statement that performed the database query. If the SQL statement
does not return a set of columns (for instance, if it is an INSERT,
UPDATE, or DELETE statement), the \fBcolumns\fR command will return an empty
list.
.PP
The \fBrowcount\fR object command returns the number of rows in the database
that were affected by the execution of an INSERT, UPDATE or DELETE statement.
For a SELECT statement, the row count is unspecified.
.PP
The \fBnextlist\fR object command sets the variable given by \fIvarname\fR 
in the caller's scope to the next row of the results, expressed as a list 
of column values. NULL values are replaced by empty strings. The
columns of the result row appear in the same order in which they
appeared on the SELECT statement. The
return of \fBnextlist\fR is \fB1\fR if the operation succeeded, and
\fB0\fR  if the end of the result set was reached.
.PP
The \fBnextdict\fR object command sets the variable given by \fIvarname\fR 
in the caller's scope to the next row of the results, expressed as a
dictionary. The dictionary's keys are column names, and the values are
the values of those columns in the row. If a column's value in the row
is NULL, its key is omitted from the dictionary.
The keys appear in the dictionary in the same order in which the
columns appeared on the SELECT statement. The
return of \fBnextdict\fR is \fB1\fR if the operation succeeded, and
\fB0\fR  if the end of the result set was reached.
.PP
The \fBnextrow\fR object command is precisely equivalent to the
\fBnextdict\fR or \fBnextlist\fR object command, depending on whether
\fB-as dicts\fR (the default) or \fB-as lists\fR is specified. 
.PP
Some databases support the idea of a single statement that returns multiple
sets of results. The \fBnextresults\fR object command is executed, typically
after the \fBnextlist\fR of \fBnextdict\fR object command has returned
\fB0\fR, to advance to the next result set. It returns \fB1\fR if there
is another result set to process, and \fB0\fR if the result set just
processed was the last. After calling \fBnextresults\fR and getting
the return value of \fB1\fR, the caller may once again call \fBcolumns\fR
to get the column descriptions of the next result set, and then return to
calling \fBnextdict\fR or \fBnextlist\fR to process the rows of the
next result set.  It is an error to call \fBcolumns\fR, \fBnextdict\fR,
\fBnextlist\fR or \fBnextrow\fR after \fBnextresults\fR has returned \fB0\fR.
.PP
The \fBallrows\fR object command sets the variable designated by the
\fB-columnsvariable\fR option (if present) to the result of the \fBcolumns\fR
object command. It then executes the \fBnextrow\fR object command
repeatedly until the end of the result set is reached. If \fBnextresults\fR
returns a nonzero value, it executes the above two steps (\fBcolumns\fR
followed by iterated \fBnextrow\fR calls) as long as further results are
available. The rows returned by \fBnextrow\fR
are assembled into a Tcl list and become the return value of the
\fBallrows\fR command; the last value returned from \fBcolumns\fR is what
the application will see in \fB-columnsvariable\fR.
.PP
The \fBforeach\fR object command sets the variable designated by the
\fB-columnsvariable\fR option (if present) to the result of the \fBcolumns\fR
object command. It then executes the \fBnextrow\fR object command
repeatedly until the end of the result set is reached, storing the
successive rows in the variable designated by \fIvarName\fR. For each
row, it executes the given \fIscript\fR. If the script terminates with
an error, the error is reported by the \fBforeach\fR command, and
iteration stops. If the script performs a \fBbreak\fR operation, the
iteration terminates prematurely. If the script performs a
\fBcontinue\fR operation, the iteration recommences with the next row.
If the script performs a \fBreturn\fR, results are the same as if a
script outside the control of \fBforeach\fR had returned. Any other
unusual return code terminates the iteration and is reported from the
\fBforeach\fR. 
.PP
Once \fBnextrow\fR returns \fB0\fR, the \fBforeach\fR object command 
tries to advance to the next result set using \fBnextresults\fR.  If
\fBnextresults\fR returns \fB1\fR, the above steps (\fBcolumns\fR and
\fBnextrow\fR, with script invocation) are repeated as long as more
result sets remain. The \fIscript\fR will always see the correct description
of the columns of the current result set in the variable designated
byt \fB-columnsvariable\fR. At the end of the call, the variable
designated by \fB-columnsvariable\fR will have the description of the
columns of the last result set.
.PP
The \fBclose\fR object command deletes the result set and frees any
associated system resources.
.SH "SEE ALSO"
encoding(n), tdbc(n), tdbc::connection(n), tdbc::statement(n), tdbc::tokenize(n)
.SH "KEYWORDS"
TDBC, SQL, database, connectivity, connection, resultset, statement,
bound variable, stored procedure, call
.SH "COPYRIGHT"
Copyright (c) 2008 by Kevin B. Kenny.
'\" Local Variables:
'\" mode: nroff
'\" End:
'\"
