C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=INTSEG,SSI=0
C
                        SUBROUTINE INTSEG
C                       *****************
C    ------------------
     *(XAB,YAB,ZAB,XAC,YAC,ZAC,XCD,YCD,ZCD,VALINT)
C    ------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   Calcul de facteur de forme par integrale de contour     *
C              Application a des triangles                             *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !   XI   !  TR  !  D ! Coordonnees X des 6 points des 2 triangles  !
C   !        !      !    ! (dans l'ordre xa,xb,xc,   xd,xe,xf)         !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/XREFER/!      ! M  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
C**********************************************************************
C
C.. Variables externes
      DOUBLE PRECISION XAB,YAB,ZAB,XCD,YCD,ZCD,XAC,YAC,ZAC,RES
C
C.. Variables locales
      DOUBLE PRECISION VALINT,T12,T22,T1,T2,T1T2,T0
      DOUBLE PRECISION A,B,C,D,E,TERM1,TERM2,EPS
C
      double precision W(8),X(8),resg
      double precision ag,bg,cg,dg,delg
      integer i
C**********************************************************************
      DOUBLE PRECISION ANALY2,DEL,AL1,AL2,C2,D2
      DOUBLE PRECISION PBINT1,RAC,RAC2
C
      ANALY2 (A,B,C,D,E,DEL,AL1,AL2,C2,D2) = 
     *  (AL1-AL2)*(A*(4.*D*E*C-D2*D)+B*(2.*C*D2-8.*E*C2))/(2.*C2*DEL)
     *  -(-C2*(4.*B+2.*A)-2.*C*(A*E+B*D)+A*D2)/(4.*C2)*LOG(C+D+E)
     *  -(A+4*B)*0.5 + A*D*0.5/C
     *  +(-2.*C*(B*D+A*E)+A*D2)*0.25/C2*LOG(E)
C
      PBINT1 (A,B,C,RAC,RAC2) = (B+0.5*A)*LOG(C)
     *  +(2.*B*(1.-RAC)+A*(1-RAC2))*LOG(ABS(1.-RAC))
     *  +(A*RAC2+2.*B*RAC) * LOG(ABS(-RAC))
     *  -2.*B - A*(0.5+RAC) 
C
      DATA X / 0.408282678752175 , 0.237233795041835 ,
     *         0.101666761293187 , 0.019855071751232 ,
     *         0.591717321247825 , 0.762766204958165 ,
     *         0.898333238706814 , 0.980144928248768    /
C
      DATA W / 0.362683783378362 , 0.313706645877887,
     *         0.222381034453374 , 0.101228536290376,
     *         0.362683783378362 , 0.313706645877887,
     *         0.222381034453374 , 0.101228536290376  /


C**********************************************************************
C
          EPS = 1.E-10
C
C         1.1- Coefficients
C         -----------------
C
          T12 = XAB*XAB + YAB*YAB + ZAB*ZAB
          T22 = XCD*XCD + YCD*YCD + ZCD*ZCD
          T1  = -2 * (XAC*XAB + YAC*YAB + ZAC*ZAB)
          T2  =  2 * (XAC*XCD + YAC*YCD + ZAC*ZCD)
          T1T2= -2 * (XAB*XCD + YAB*YCD + ZAB*ZCD)
          T0  = XAC*XAC + YAC*YAC + ZAC*ZAC
C
C
c          CALL ROMBER(RES,T12,T22,T1,T2,T1T2,T0)      
C
c 
          RESG = 0.
c      x(1)=-0.18343 46424 95650D0*0.5D0+0.5D0
c      x(2)=-0.52553 24099 16329D0*0.5D0+0.5D0
c      x(3)=-0.79666 64774 13627D0*0.5D0+0.5D0
c      x(4)=-0.96028 98564 97536D0*0.5D0+0.5D0
c      x(5)=0.18343 46424 95650D0*0.5D0+0.5D0
c      x(6)=0.52553 24099 16329D0*0.5D0+0.5D0
c      x(7)=0.79666 64774 13627D0*0.5D0+0.5D0
c      x(8)=0.96028 98564 97536D0*0.5D0+0.5D0
c      w(1)=0.36268 37833 78362D0
c      w(2)=0.31370 66458 77887D0
c      w(3)=0.22238 10344 53374D0
c      w(4)=0.10122 85362 90376D0
c      w(5)=0.36268 37833 78362D0
c      w(6)=0.31370 66458 77887D0
c      w(7)=0.22238 10344 53374D0
c      w(8)=0.10122 85362 90376D0
         DO 120 I=1,8
           AG = T12
           BG = T1T2*x(i)+t1
           CG = T22*X(i)*X(i) + T2*X(i) + T0
           DG = -BG*BG + 4.*T12*CG
           DELG = SQRT(ABS(DG))
           RESG = RESG + W(i)*(DELG/AG) *
     *           (ATAN((2.*AG+BG)/DELG)-ATAN(BG/DELG))
 120     CONTINUE
         RES = RESG*0.5D0
C
          A = 0.5*T1T2/T12
          B = 0.5*T1/T12 + 1.
          C = T22
          D = T1T2+T2
          E = T12+T1+T0
          C2 = C*C
          D2 = D*D
          DEL = SQRT(ABS(4.*C*E-D2))
          IF (DEL .LE. EPS) THEN
            RAC = -0.5*D/C
            RAC2 = RAC*RAC
            TERM1 = PBINT1(A,B,C,RAC,RAC2)
          ELSE
            AL1 = ATAN(D/DEL)
            AL2 = ATAN((2.*C+D)/DEL)
            TERM1 = ANALY2(A,B,C,D,E,DEL,AL1,AL2,C2,D2)
          ENDIF
C
          A = -0.5*T1T2/T12
          B = -0.5*T1/T12
          C = T22
          D = T2
          E = T0
          C2 = C*C
          D2 = D*D
          DEL = SQRT(ABS(4.*C*E-D2))
          IF (DEL .LE. EPS)  THEN
            RAC = -0.5*D/C
            RAC2 = RAC*RAC
            TERM2 = PBINT1(A,B,C,RAC,RAC2)
          ELSE
            AL1 = ATAN(D/DEL)
            AL2 = ATAN((2.*C+D)/DEL)
            B =  - 0.5*T1/T12
            TERM2 = ANALY2(A,B,C,D,E,DEL,AL1,AL2,C2,D2)
          ENDIF
C
          VALINT = RES + TERM1 + TERM2 -2.
C
C
C--------
C FORMATS
C--------
C----
C FIN
C----
C
      END
