// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#include "Bubble.h"

#include "tools.h"

using std::cout;
using std::endl;
using std::string;

namespace SyFi
{

	Bubble::Bubble(): StandardFE()
	{
		description = "Bubble";
	}

	Bubble::Bubble(Polygon& p, unsigned int order): StandardFE(p, order)
	{
		compute_basis_functions();
	}

	void Bubble:: compute_basis_functions()
	{

		// remove previously computed basis functions and dofs
		Ns.clear();
		dofs.clear();

		if ( p == NULL )
		{
			throw(std::logic_error("You need to set a polygon before the basisfunctions can be computed"));
		}

		if ( p->str().find("ReferenceLine") != string::npos )
		{
			Ns.insert(Ns.end(), x*(1-x));
			description = "Bubble_1D";
		}
		else if ( p->str().find("Triangle") != string::npos )
		{

			GiNaC::ex b = barycenter_triangle(p->vertex(0), p->vertex(1), p->vertex(2));
			GiNaC::ex N = GiNaC::numeric(1);
			for (unsigned int d=0; d< b.nops(); d++)
			{
				N = N*b.op(d).rhs();
			}
			Ns.insert(Ns.end(), N);

			description = "Bubble_2D";

		}
		else if ( p->str().find("Tetrahedron") != string::npos )
		{
			GiNaC::ex b = barycenter_tetrahedron(p->vertex(0), p->vertex(1),
				p->vertex(2), p->vertex(3));
			GiNaC::ex N = GiNaC::numeric(1);
			for (unsigned int d=0; d< b.nops(); d++)
			{
				N = N*b.op(d).rhs();
			}
			Ns.insert(Ns.end(), N);

			description = "Bubble_3D";
		}

		// create and insert dof
		GiNaC::lst midpoint = GiNaC::lst();
		for (unsigned int d=0; d< p->vertex(1).nops(); d++)
		{
			midpoint.append(GiNaC::numeric(0));
		}
		for (unsigned int i=1; i<= p->no_vertices(); i++)
		{
			for (unsigned int d=0; d< p->vertex(i-1).nops(); d++)
			{
				midpoint.let_op(d)  += p->vertex(i-1).op(d);
			}
		}

		for (unsigned int d=0; d< p->vertex(1).nops(); d++)
		{
			midpoint.let_op(d)  = midpoint.op(d)/p->no_vertices();
		}

		dofs.insert(dofs.end(), midpoint);
	}

}								 // namespace SyFi
