/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_FONTSETTINGSINFO_H
#define _SC_FONTSETTINGSINFO_H

// sc
#include "sublib/settings/SettingsInfoBase.h"
class FontSettings;
class SettingsWidget;

// qt
#include <QtCore/QString>
#include <QtGui/QFont>


class FontSettingsInfo : public SettingsInfoBase
{
public:
  FontSettingsInfo( const QString& title, const QString& id, FontSettings* fs, int sortIndex );
  ~FontSettingsInfo();

  const QString& getTitle();
  const QString& getSettingsId();

  void initWidgetData( SettingsWidget* sw );
  void storeWidgetData( SettingsWidget* sw );
  
  bool isModified();

  void ok();
  void apply();
  void cancel();

  int getSortIndex();

private:
  QString       _title;
  QString       _id;

  int           _sortIndex;

  FontSettings* _fs;

  QFont         _modGeneral;
  QFont         _modEditor;
};



#endif //  _SC_FONTSETTINGSINFO_H
