/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COMMITCMD_H
#define _SC_COMMITCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class CommitParam;

/**
 * Command for committing changes from a working copy.
 */
class CommitCmd : public ScCmd
{
public:
  /**
   * Construct a CommitCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  CommitCmd( CommitParam* param, CmdResultCallback* cb );
  ~CommitCmd();

  void run();

private:
  // in
  CommitParam*       _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_COMMITCMD_H
