3.3 サンプルを引き延ばす

# サンプルを引き延ばす

すでに私たちは、音楽を作るために様々なシンセやサンプルを演奏することができます。そろそろ、音楽をもっとユニークで面白くするために、シンセとサンプルを編集する方法を学ぶ時間です。まずは、サンプルを引き延ばしたり圧縮する方法をみてみましょう。

## サンプルで表現する

サンプルとは、あらかじめ録音されたサウンドで、サウンドを再生するためにスピーカーのコーン（振動板）をどう動かすかを表す数値が格納されています。スピーカーのコーンは行ったり来たり（振動）するため、数値は、その時々でコーンがどれくらいの距離を行ったり来たりすべきかをその時々で表す必要があります。録音された音を忠実に再生するために、サンプルは概して1秒間に何千もの数値を格納しておく必要があるのです！Sonic Piはこの数値のリストを使って、適切なスピードでサウンドを再生するための正しい方法をあなたのコンピューターのスピーカーに伝え、振動させるのです。けれども、サウンドを変えるためにスピーカーに与えられる数値のスピードを変えるのも楽しいですよ。

## レートを変える

アンビエント・サウンドのひとつ、`:ambi_choir`で演奏してみましょう。デフォルト（既定値）で演奏するには、`sample`に`rate:` のオプションを渡します。

sample :ambi_choir, rate: 1

これはデフォルト（既定値）のレート（速度）1で演奏するので、まだ何も変わったところはありません。ですが、数値を何か他の値に変えてもよいのです。`0.5`はどうでしょう。

```
sample :ambi_choir, rate: 0.5
```

ワオ！何が起きたのでしょう？そう、2つのことが起こりました。一つ目は、サンプルは再生に2倍の時間をかけていました。二つ目は、サウンドは1オクターブ低くなっていました。もう少し詳しく、これらのことを探ってみましょう。

## 引き延ばしてみる

引き延ばしたり圧縮したりして楽しいサンプルは、定番のアーメン・ブレイクです。
通常のレートでは、*ドラムン・ベース（音楽ジャンルのひとつ）*のトラックを思わせます。

```
sample :loop_amen
```

:loop_amenですが、レート（速度）を変えると、音楽のジャンルが切り替わったように聞こえます。
半分のスピードにすると、*オールドスクールのヒップホップ*に。

```
sample :loop_amen, rate: 0.5
```

スピードを上げると、*ジャングル*のジャンルになりますね。

```
sample :loop_amen, rate: 1.5
```

では、パーティーの最後の仕掛けに、マイナスのレートを使うと何が起きるでしょうか。

```
sample :loop_amen, rate: -1
```

ワオ！逆再生！いろいろな異なったサンプルで、異なったレートで演奏してみましょう。ものすごく速い数値や、おかしなくらいゆっくりになる数値を使って、どんなおもしろいサウンドを作れるか、試してみましょう。

## サンプル・レートの解説

サンプルは、バネのように考えると便利です。再生速度（プレイバック）は、バネを縮めたり伸ばしたりするようなものです。もしサンプルをレート 2 で再生した場合、通常の長さの半分に、*バネを縮める*ことになります。ですので、サンプルは半分の時間で演奏するので、より短くなります。もしサンプルを半分のレートで再生した場合、2倍の長さに*バネを伸ばす*ことになります。そのため、サンプルは再生に2倍の時間をかけるため、より長くなるのです。もっと縮める（レートを上げる）と、短く再生され、さらに伸ばす（レートを下げる）と、さらに長く再生されます。
バネを縮めることは、その密度（1cm あたりのコイルの数）を増やすことです。これは*高いピッチ（音程）*のサンプルに近づくことになります。バネを伸ばすことは、密度を減らすことで、*低いピッチ（音程）*のサウンドに近づいていきます。

## サンプル・レートの背後にある計算

（このセクションはさらに細かい部分に興味がある人向けです。飛ばしても構いませんよ・・・。）

上記で見てきたように、サンプルは、スピーカーが一定の時間でどのように振動すべきかを表現した長大な
数値のリストによって表されています。この数値のリストで、これと同じようなグラフを描いてみます。

![sample graph](:/images/tutorial/sample.png)

あなたはこれと同じような図を、以前に見たことがあるかも知れません。これはサンプルの*波形*と呼ばれるものです。これは数値のグラフです。このような波形はだいたい、1秒間に44100ポイントのデータを有しています（これはナイキスト・シャノンのサンプリング定理によるものです）。サンプルが2秒間続くなら、スピーカーに1秒間に44100ポイントのレート（長さ）を与えることで88200の数値で表現されます。もちろん、1秒間に88200ポイントで、2倍のレートとすることもできます。ですので、これは1秒間で再生されます。1秒間に22050ポイントで、半分のレートで再生することも可能です。この場合、4秒で再生されます。

サンプルのデュレーションは、再生するレートに影響を与えます。

* 2倍の再生レートは、再生時間を半分にする
* 半分の再生レートは、再生時間を2倍にする
* 4分の1の再生レートは、再生時間を4倍にする
* 10分の1の再生レートは、10倍長く再生させる

これを以下の数式で表します。

```
new_sample_duration = (1 / rate) * sample_duration 
```

再生レートを変えることは、サンプルのピッチ（音程）にも影響します。周波数や波形のピッチがどれくらい速く上下に動くかで決定されます。我々の脳は、どういうわけか、スピーカーの速い動きを高い音階に、遅い動きを低い音階に捉えます。だからあなたは時々、大きなベース・スピーカーが超低音を吐き出すのを見ることができるのです。実際に高い音を出しているときのスピーカーよりも、ゆっくりと振動しているのです。

もし波形を取り出して圧縮したら、1秒間でさらに頻繁に上下します。これがサウンドをより高い音にするのです。
上下の運動を2倍にすると、周波数が2倍になるということになります。
そのため、*サンプルを2倍のレートで再生すると、聞こえる周波数が2倍になる*ということです。
また、*レートを半分にすると、周波数が半分になる*ということでもあります。他のレートはそれに応じて周波数に影響します。
