// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_ALIGN_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_ALIGN_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Align

template <typename TSource, typename TSpec > class Align;       	// "seqan-1.3.1/seqan/align/align_base.h"(138)

//____________________________________________________________________________
// AlignColIterator

template <typename TSpec> struct AlignColIterator;       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(160)

//____________________________________________________________________________
// AlignCols

template <typename TAlign> struct AlignCols;       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(60)

//____________________________________________________________________________
// AlignTrace

template <typename TSize , typename TSpec > struct AlignTrace;       	// "seqan-1.3.1/seqan/align/align_trace.h"(48)

//____________________________________________________________________________
// ArrayGaps

struct ArrayGaps;       	// "seqan-1.3.1/seqan/align/gaps_array.h"(44)
struct ArrayGaps;       	// "seqan-1.3.1/seqan/align/gaps_base.h"(80)

//____________________________________________________________________________
// Col

template <typename T> struct Col;       	// "seqan-1.3.1/seqan/align/align_base.h"(71)

//____________________________________________________________________________
// Cols

template <typename T> struct Cols;       	// "seqan-1.3.1/seqan/align/align_base.h"(52)

//____________________________________________________________________________
// GappedValueType

template <typename T> struct GappedValueType;       	// "seqan-1.3.1/seqan/align/gaps_base.h"(52)

//____________________________________________________________________________
// Gaps

template <typename TSource, typename TSpec > class Gaps;       	// "seqan-1.3.1/seqan/align/gaps_base.h"(111)

//____________________________________________________________________________
// GapsIterator

template <typename TSpec> struct GapsIterator;       	// "seqan-1.3.1/seqan/align/gaps_base.h"(84)

//____________________________________________________________________________
// GetSource

template <typename T> struct GetSource;       	// "seqan-1.3.1/seqan/align/gaps_base.h"(182)

//____________________________________________________________________________
// LocalAlignmentFinder

template <typename TScoreValue > class LocalAlignmentFinder;       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(119)

//____________________________________________________________________________
// Matrix

template <typename TValue, unsigned DIMENSION > class Matrix;       	// "seqan-1.3.1/seqan/align/matrix_base.h"(49)

//____________________________________________________________________________
// NDimensional

struct NDimensional;       	// "seqan-1.3.1/seqan/align/matrix_base.h"(45)

//____________________________________________________________________________
// Navi

template <typename TContainer, typename TSpec> struct Navi;       	// "seqan-1.3.1/seqan/align/align_trace.h"(244)

//____________________________________________________________________________
// Navigator

template <typename T> struct Navigator;       	// "seqan-1.3.1/seqan/align/align_trace.h"(229)

//____________________________________________________________________________
// Row

template <typename T> struct Row;       	// "seqan-1.3.1/seqan/align/align_base.h"(105)

//____________________________________________________________________________
// Rows

template <typename T> struct Rows;       	// "seqan-1.3.1/seqan/align/align_base.h"(86)

//____________________________________________________________________________
// ScoreAndID

template <typename TValue, typename TID> class ScoreAndID;       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(48)

//____________________________________________________________________________
// SizeArr_

template <typename T> struct SizeArr_;       	// "seqan-1.3.1/seqan/align/matrix_base.h"(52)

//____________________________________________________________________________
// StringSetType

template <typename T> struct StringSetType;       	// "seqan-1.3.1/seqan/align/align_base.h"(287)

//____________________________________________________________________________
// SumListOfGaps_

template <typename TGaps> struct SumListOfGaps_;       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(532)

//____________________________________________________________________________
// SumlistGaps

struct SumlistGaps;       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(44)

//____________________________________________________________________________
// _HirschbergSet

class _HirschbergSet;       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(45)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _alignBandedSmithWaterman

template <typename TScoreValue, typename TStringSet, typename TScore, typename TDiagonal> inline TScoreValue _alignBandedSmithWaterman(LocalAlignmentFinder<TScoreValue>& finder, TStringSet const& str, TScore const& sc, TScoreValue const cutoff, TDiagonal const diagL, TDiagonal const diagU);       	// "seqan-1.3.1/seqan/align/align_local_dynprog_banded.h"(341)

//____________________________________________________________________________
// _alignBandedSmithWatermanDeclump

template <typename TScoreValue, typename TStringSet, typename TScore, typename TDiagonal> inline void _alignBandedSmithWatermanDeclump(LocalAlignmentFinder<TScoreValue>& finder, TStringSet const& str, TScore const& sc, TScoreValue const cutoff, TDiagonal const diagL, TDiagonal const diagU);       	// "seqan-1.3.1/seqan/align/align_local_dynprog_banded.h"(182)

//____________________________________________________________________________
// _alignBandedSmithWatermanTrace

template <typename TScoreValue, typename TStringSet, typename TScore, typename TDiagonal> inline Pair<Pair<TDiagonal> > _alignBandedSmithWatermanTrace(LocalAlignmentFinder<TScoreValue> & finder, TStringSet const& str, TScore& sc, TDiagonal diagL, TDiagonal diagU);       	// "seqan-1.3.1/seqan/align/align_local_dynprog_banded.h"(83)

//____________________________________________________________________________
// _alignTracePrint

template <typename TSize, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _alignTracePrint(AlignTraceback<TSize> & tb, TStringSet const &, TId const, TPos const, TId const, TPos const, TPos const segLen, TTraceValue const tv);       	// "seqan-1.3.1/seqan/align/align_algorithms.h"(53)

//____________________________________________________________________________
// _begin1

inline int& _begin1(_HirschbergSet & me);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(89)
inline int const& _begin1(_HirschbergSet const & me);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(97)

//____________________________________________________________________________
// _begin2

inline int& _begin2(_HirschbergSet & me);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(133)
inline int const& _begin2(_HirschbergSet const & me);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(140)

//____________________________________________________________________________
// _beginPositionAlignCols

template <typename TAlignCols> inline typename Position<TAlignCols>::Type _beginPositionAlignCols(TAlignCols const & me);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(295)

//____________________________________________________________________________
// _coordinatesToPositions

template <typename TSize, typename TSpec, typename TCoordinates> inline void _coordinatesToPositions(AlignTrace<TSize, TSpec> & me, TCoordinates const & coordinates_, TSize & position_, unsigned char & bit_position);       	// "seqan-1.3.1/seqan/align/align_trace.h"(168)

//____________________________________________________________________________
// _dataArr

template <typename TSource> inline String<typename Size<Gaps<TSource, ArrayGaps> >::Type> & _dataArr(Gaps<TSource, ArrayGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(165)
template <typename TSource> inline String<typename Size<Gaps<TSource, ArrayGaps> >::Type> const & _dataArr(Gaps<TSource, ArrayGaps> const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(172)

//____________________________________________________________________________
// _dataFactors

template <typename TValue, unsigned DIMENSION> inline typename SizeArr_<Matrix<TValue, DIMENSION> >::Type & _dataFactors(Matrix<TValue, DIMENSION> & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(288)
template <typename TValue, unsigned DIMENSION> inline typename SizeArr_<Matrix<TValue, DIMENSION> >::Type & _dataFactors(Matrix<TValue, DIMENSION> const & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(295)

//____________________________________________________________________________
// _dataLengths

template <typename TValue, unsigned DIMENSION> inline typename SizeArr_<Matrix<TValue, DIMENSION> >::Type & _dataLengths(Matrix<TValue, DIMENSION> & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(274)
template <typename TValue, unsigned DIMENSION> inline typename SizeArr_<Matrix<TValue, DIMENSION> >::Type const & _dataLengths(Matrix<TValue, DIMENSION> const & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(281)

//____________________________________________________________________________
// _dataSource

template <typename TSource> inline Holder<TSource> & _dataSource(Gaps<TSource, ArrayGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(182)
template <typename TSource> inline Holder<TSource> const & _dataSource(Gaps<TSource, ArrayGaps> const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(189)
template <typename TSource> inline Holder<TSource> & _dataSource(Gaps<TSource, SumlistGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(154)
template <typename TSource> inline Holder<TSource> const & _dataSource(Gaps<TSource, SumlistGaps> const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(161)

//____________________________________________________________________________
// _end1

inline int& _end1(_HirschbergSet & me);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(111)
inline int const& _end1(_HirschbergSet const & me);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(118)

//____________________________________________________________________________
// _end2

inline int& _end2(_HirschbergSet & me);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(154)
inline int const& _end2(_HirschbergSet const & me);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(161)

//____________________________________________________________________________
// _endPositionAlignCols

template <typename TAlignCols> inline typename Position<TAlignCols>::Type _endPositionAlignCols(TAlignCols const & me);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(363)

//____________________________________________________________________________
// _finishAlign

template <typename TSource, typename TSpec, typename TPos> inline void _finishAlign(Align<TSource, TSpec>& align, TPos const begin1, TPos const end1, TPos const begin2, TPos const end2);       	// "seqan-1.3.1/seqan/align/align_local_dynprog_banded.h"(443)

//____________________________________________________________________________
// _getBitsPerEntry

template <typename TSize, typename TSpec> inline unsigned int _getBitsPerEntry(AlignTrace<TSize, TSpec> & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(114)

//____________________________________________________________________________
// _getNextBestEndPosition

template <typename TScoreValue> typename LocalAlignmentFinder<TScoreValue>::TMatrixPosition _getNextBestEndPosition(LocalAlignmentFinder<TScoreValue> & sw , TScoreValue cutoff);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(655)

//____________________________________________________________________________
// _getTrailingGaps

template <typename TSource> inline typename Position<Gaps<TSource, ArrayGaps> >::Type _getTrailingGaps(Gaps<TSource, ArrayGaps> const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(216)

//____________________________________________________________________________
// _goNextArrayGapsIterator

template <typename T> inline void _goNextArrayGapsIterator(T const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(892)

//____________________________________________________________________________
// _goNextSumlistGapsIterator

template <typename T> inline void _goNextSumlistGapsIterator(T & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(710)

//____________________________________________________________________________
// _goPreviousArrayGapsIterator

template <typename T> inline void _goPreviousArrayGapsIterator(T const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(925)

//____________________________________________________________________________
// _goPreviousSumlistGapsIterator

template <typename T> inline void _goPreviousSumlistGapsIterator(T & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(737)

//____________________________________________________________________________
// _gotoh

template <typename TScoreValue, unsigned DIMENSION, typename TString> TScoreValue _gotoh(Matrix<TScoreValue, DIMENSION> & diag_matrix_, Matrix<TScoreValue, DIMENSION> & vert_matrix_, Matrix<TScoreValue, DIMENSION> & hori_matrix_, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "seqan-1.3.1/seqan/align/align_dynprog.h"(241)

//____________________________________________________________________________
// _gotohTrace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, unsigned DIMENSION> void _gotohTrace(Align<TTargetSource, TTargetSpec> & target_, Matrix<TScoreValue, DIMENSION> & diag_matrix_, Matrix<TScoreValue, DIMENSION> & vert_matrix_, Matrix<TScoreValue, DIMENSION> & hori_matrix_, Score<TScoreValue, Simple> const & score_);       	// "seqan-1.3.1/seqan/align/align_dynprog.h"(385)

//____________________________________________________________________________
// _initLocalAlignmentFinder

template <typename TStringSet, typename TScoreValue, typename TTag> void _initLocalAlignmentFinder(TStringSet & str, LocalAlignmentFinder<TScoreValue> & finder, TTag);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(186)
template <typename TStringSet, typename TScoreValue, typename TDiagonal> void _initLocalAlignmentFinder(TStringSet const& str, LocalAlignmentFinder<TScoreValue> & finder, BandedWatermanEggert, TDiagonal const lowerDiag, TDiagonal const upperDiag);       	// "seqan-1.3.1/seqan/align/align_local_dynprog_banded.h"(50)

//____________________________________________________________________________
// _initMembers

template <typename TSize, typename TSpec> inline void _initMembers(AlignTrace<TSize, TSpec> & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(123)

//____________________________________________________________________________
// _initToResize

template <typename TSource, typename TSize> inline void _initToResize(Gaps<TSource, ArrayGaps> & me, TSize _size);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(329)
template <typename TSource, typename TSize2> inline void _initToResize(Gaps<TSource, SumlistGaps> & me, TSize2 _size);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(261)

//____________________________________________________________________________
// _iteratorGapsArray

template <typename TGaps, typename TPosition> inline typename Iterator<TGaps, Standard>::Type _iteratorGapsArray(TGaps & gaps, TPosition view_position);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(478)

//____________________________________________________________________________
// _localAlignment

template <typename TScoreValue, typename TSource, typename TSpec, typename TStringSet, typename TScore, typename TDiagonal> inline TScoreValue _localAlignment(LocalAlignmentFinder<TScoreValue> & finder, TStringSet& str, Align<TSource, TSpec> & align, TScore const& sc, TScoreValue cutoff, TDiagonal diag1, TDiagonal diag2, BandedWatermanEggert);       	// "seqan-1.3.1/seqan/align/align_local_dynprog_banded.h"(464)

//____________________________________________________________________________
// _localAlignmentNext

template <typename TScoreValue, typename TSource, typename TSpec, typename TStringSet, typename TScore, typename TDiagonal> inline TScoreValue _localAlignmentNext(LocalAlignmentFinder<TScoreValue> & finder, TStringSet& str, Align<TSource, TSpec> & align, TScore const& sc, TScoreValue cutoff, TDiagonal diag1, TDiagonal diag2, BandedWatermanEggert);       	// "seqan-1.3.1/seqan/align/align_local_dynprog_banded.h"(491)

//____________________________________________________________________________
// _needlemanWunsch

template <typename TScoreValue, unsigned DIMENSION, typename TString> TScoreValue _needlemanWunsch(Matrix<TScoreValue, DIMENSION> & matrix_, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "seqan-1.3.1/seqan/align/align_dynprog.h"(47)

//____________________________________________________________________________
// _needlemanWunschTrace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, unsigned DIMENSION> void _needlemanWunschTrace(Align<TTargetSource, TTargetSpec> & target_, Iter< Matrix<TScoreValue, DIMENSION>, PositionIterator > source_, Score<TScoreValue, Simple> const & score_);       	// "seqan-1.3.1/seqan/align/align_dynprog.h"(147)

//____________________________________________________________________________
// _positionsToCoordinates

template <typename TSize, typename TSpec, typename TCoordinates> inline void _positionsToCoordinates(AlignTrace<TSize, TSpec> & me, TCoordinates & coordinates_, TSize position_, unsigned char bit_position );       	// "seqan-1.3.1/seqan/align/align_trace.h"(195)

//____________________________________________________________________________
// _pumpTraceToAlign

template <typename TSource, typename TSpec, typename TTrace> void _pumpTraceToAlign(Align<TSource, TSpec> & align_, TTrace trace);       	// "seqan-1.3.1/seqan/align/align_algorithms.h"(66)

//____________________________________________________________________________
// _score

inline int& _score(_HirschbergSet & me);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(179)
inline int const& _score(_HirschbergSet const & me);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(186)

//____________________________________________________________________________
// _setBegin1

inline void _setBegin1(_HirschbergSet & me, int const & new_begin);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(104)

//____________________________________________________________________________
// _setBegin2

inline void _setBegin2(_HirschbergSet & me, int const & new_begin);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(147)

//____________________________________________________________________________
// _setClippedBeginPosition

template <typename TSource, typename TSourcePosition> inline void _setClippedBeginPosition(Gaps<TSource, ArrayGaps> & me, TSourcePosition _pos);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(286)
template <typename TSource, typename TSourcePosition> inline void _setClippedBeginPosition(Gaps<TSource, SumlistGaps> & me, TSourcePosition _pos);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(231)

//____________________________________________________________________________
// _setClippedEndPosition

template <typename TSource, typename TSourcePosition> inline void _setClippedEndPosition(Gaps<TSource, ArrayGaps> & me, TSourcePosition _pos);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(318)
template <typename TSource, typename TSourcePosition> inline void _setClippedEndPosition(Gaps<TSource, SumlistGaps> & me, TSourcePosition _pos);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(250)

//____________________________________________________________________________
// _setEnd1

inline void _setEnd1(_HirschbergSet & me, int const & new_end);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(125)

//____________________________________________________________________________
// _setEnd2

inline void _setEnd2(_HirschbergSet & me, int const & new_end);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(168)

//____________________________________________________________________________
// _setEndPosition

template <typename TSource, typename TPosition> inline void _setEndPosition(Gaps<TSource, ArrayGaps> & me, TPosition _pos);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(253)

//____________________________________________________________________________
// _setScore

inline void _setScore(_HirschbergSet & me,int new_score);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(193)

//____________________________________________________________________________
// _setTrailingGaps

template <typename TSource, typename TSize> inline void _setTrailingGaps(Gaps<TSource, ArrayGaps> & me, TSize const & size);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(224)

//____________________________________________________________________________
// _smithWaterman

template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue _smithWaterman(Align<TSource, TSpec> & align_, LocalAlignmentFinder<TScoreValue> & sw_finder, Score<TScoreValue, Simple> const & score_, TScoreValue cutoff);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(722)

//____________________________________________________________________________
// _smithWatermanDeclump

template <typename TScoreValue, typename TSource, typename TSpec> void _smithWatermanDeclump(LocalAlignmentFinder<TScoreValue> & sw , Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(346)

//____________________________________________________________________________
// _smithWatermanGetMatrix

template <typename TScoreValue, typename TString> TScoreValue _smithWatermanGetMatrix(LocalAlignmentFinder<TScoreValue> & sw, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, TScoreValue cutoff);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(234)

//____________________________________________________________________________
// _smithWatermanGetNext

template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue _smithWatermanGetNext(Align<TSource, TSpec> & align_, LocalAlignmentFinder<TScoreValue> & sw_finder , Score<TScoreValue, Simple> const & score_, TScoreValue cutoff);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(783)

//____________________________________________________________________________
// _smithWatermanTrace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, unsigned DIMENSION> typename Iterator<Matrix<TScoreValue, DIMENSION>, Standard >::Type _smithWatermanTrace(Align<TTargetSource, TTargetSpec> & target_, typename LocalAlignmentFinder<TScoreValue>::TBoolMatrix & fb_matrix, Iter< Matrix<TScoreValue, DIMENSION>, PositionIterator > source_, Score<TScoreValue, Simple> const & scoring_);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(548)

//____________________________________________________________________________
// _unclippedLength

template <typename TSource> inline typename Position<Gaps<TSource, ArrayGaps> >::Type _unclippedLength(Gaps<TSource, ArrayGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(243)

//____________________________________________________________________________
// _writeDebugMatrix

template <typename TSource> void _writeDebugMatrix(TSource s1,TSource s2);       	// "seqan-1.3.1/seqan/align/align_hirschberg.h"(49)
template <typename TSource> void _writeDebugMatrix(TSource s1,TSource s2);       	// "seqan-1.3.1/seqan/align/align_myers.h"(51)

//____________________________________________________________________________
// assignHost

template <typename TValue, unsigned DIMENSION, typename THost> inline void assignHost(Matrix<TValue, DIMENSION> & me, THost const & value_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(340)

//____________________________________________________________________________
// assignSource

template <typename TSource, typename TSpec, typename TSource2> inline void assignSource(Gaps<TSource, TSpec> & me, TSource2 const & source_);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1040)

//____________________________________________________________________________
// assignValue

template <typename TGaps, typename TSpec, typename TValue> inline void assignValue(Iter<TGaps, GapsIterator<TSpec> > & me, TValue const & val);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(222)
template <typename TGaps, typename TSpec, typename TValue> inline void assignValue(Iter<TGaps, GapsIterator<TSpec> > const & me, TValue const & val);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(234)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue & val);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(348)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue const & val);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(357)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue & val);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(366)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue const & val);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(375)

//____________________________________________________________________________
// atBegin

template <typename TGaps> inline bool atBegin(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(963)
template <typename TGaps> inline bool atBegin(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(766)

//____________________________________________________________________________
// atEnd

template <typename TGaps> inline bool atEnd(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(973)
template <typename TGaps> inline bool atEnd(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(776)

//____________________________________________________________________________
// begin

template <typename TValue, unsigned DIMENSION, typename TTag> inline typename Iterator<Matrix <TValue, DIMENSION>, Tag<TTag> const>::Type begin(Matrix<TValue, DIMENSION> & me, Tag<TTag> const);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(554)
template <typename TValue, unsigned DIMENSION, typename TTag> inline typename Iterator<Matrix <TValue, DIMENSION> const, Tag<TTag> const>::Type begin(Matrix<TValue, DIMENSION> const & me, Tag<TTag> const);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(561)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec>, Tag<TTag> const>::Type begin(Gaps<TSource, TSpec> & me, Tag<TTag> const tag_);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(304)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec> const, Tag<TTag> const>::Type begin(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(312)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign>, Tag<TTag> const>::Type begin(AlignCols<TAlign> & me, Tag<TTag> const tag_);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(343)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign> const, Tag<TTag> const>::Type begin(AlignCols<TAlign> const & me, Tag<TTag> const tag_);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(351)

//____________________________________________________________________________
// beginPosition

template <typename TSource> inline typename Position< Gaps<TSource, ArrayGaps> >::Type beginPosition(Gaps<TSource, ArrayGaps> & gaps);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(562)
template <typename TSource> inline typename Position< Gaps<TSource, ArrayGaps> const>::Type beginPosition(Gaps<TSource, ArrayGaps> const & gaps);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(569)
template <typename TAlign> inline typename Position<AlignCols<TAlign> >::Type beginPosition(AlignCols<TAlign> const & me);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(323)
template <typename TAlign> inline typename Position<AlignCols<TAlign> >::Type beginPosition(AlignCols<TAlign> & me);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(330)
template <typename TSource> inline typename Position< Gaps<TSource, SumlistGaps> >::Type beginPosition(Gaps<TSource, SumlistGaps> & gaps);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(171)
template <typename TSource> inline typename Position< Gaps<TSource, SumlistGaps> const>::Type beginPosition(Gaps<TSource, SumlistGaps> const & gaps);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(182)

//____________________________________________________________________________
// clear

template <typename TSource> inline void clear(Gaps<TSource, ArrayGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(353)
template <typename TScoreValue> void clear(LocalAlignmentFinder<TScoreValue> & sw_finder);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(210)
template <typename TSource> inline void clear(Gaps<TSource, SumlistGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(288)

//____________________________________________________________________________
// clearBit

template <typename TSize, typename TSpec, typename TSpec2> inline void clearBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(302)

//____________________________________________________________________________
// clearClipping

template <typename TSource> inline void clearClipping(Gaps<TSource, ArrayGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(365)
template <typename TSource, typename TSpec> inline void clearClipping(Align<TSource, TSpec> & align_);       	// "seqan-1.3.1/seqan/align/align_base.h"(533)
template <typename TSource> inline void clearClipping(Gaps<TSource, SumlistGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(300)

//____________________________________________________________________________
// clearGaps

template <typename TSource> inline void clearGaps(Gaps<TSource, ArrayGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(343)
template <typename TSource, typename TSpec, typename TPosition1, typename TPosition2> inline void clearGaps(Gaps<TSource, TSpec> & me, TPosition1 view_pos_begin, TPosition2 view_pos_end);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(641)
template <typename TSource, typename TSpec> inline void clearGaps(Gaps<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(674)
template <typename TSource, typename TSpec> inline void clearGaps(Align<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/align_base.h"(615)
template <typename TSource> inline void clearGaps(Gaps<TSource, SumlistGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(278)

//____________________________________________________________________________
// clippedBeginPosition

template <typename TSource> inline typename Position<TSource>::Type clippedBeginPosition(Gaps<TSource, ArrayGaps> const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(276)
template <typename TSource> inline typename Position<TSource>::Type clippedBeginPosition(Gaps<TSource, SumlistGaps> const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(221)

//____________________________________________________________________________
// clippedEndPosition

template <typename TSource> inline typename Position<TSource>::Type clippedEndPosition(Gaps<TSource, ArrayGaps> const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(309)
template <typename TSource> inline typename Position<TSource>::Type clippedEndPosition(Gaps<TSource, SumlistGaps> const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(241)

//____________________________________________________________________________
// col

template <typename TSource, typename TSpec, typename TPosition> inline typename Col< Align<TSource, TSpec> >::Type col(Align<TSource, TSpec> & me, TPosition _pos);       	// "seqan-1.3.1/seqan/align/align_base.h"(418)
template <typename TSource, typename TSpec, typename TPosition> inline typename Col< Align<TSource, TSpec> const>::Type col(Align<TSource, TSpec> const & me, TPosition _pos);       	// "seqan-1.3.1/seqan/align/align_base.h"(426)

//____________________________________________________________________________
// cols

template <typename TSource, typename TSpec> inline typename Cols< Align<TSource, TSpec> >::Type cols(Align<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/align_base.h"(385)
template <typename TSource, typename TSpec> inline typename Cols< Align<TSource, TSpec> const>::Type cols(Align<TSource, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/align_base.h"(392)

//____________________________________________________________________________
// container

template <typename TGaps, typename TSpec> inline TGaps & container(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(273)
template <typename TGaps, typename TSpec> inline TGaps & container(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(281)
template <typename TAlign, typename TSpec> inline typename Cols<TAlign>::Type container(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(136)
template <typename TAlign, typename TSpec> inline typename Cols<TAlign>::Type container(Iter<TAlign, AlignColIterator<TSpec> > const & me);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(143)
template <typename TContainer, typename TSpec> inline TContainer & container(Navi<TContainer, TSpec> & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(261)
template <typename TContainer, typename TSpec> inline TContainer const & container(Navi<TContainer, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(267)

//____________________________________________________________________________
// coordinate

template <typename TValue, unsigned DIMENSION, typename TPosition> inline typename Size< Matrix <TValue, DIMENSION> >::Type coordinate(Matrix<TValue, DIMENSION> & me, TPosition position_, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(535)
template <typename TValue, unsigned DIMENSION> inline typename Size< Matrix<TValue, DIMENSION> >::Type coordinate(Iter<Matrix<TValue, DIMENSION>, PositionIterator > & me, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(744)
template <typename TValue, unsigned DIMENSION> inline typename Size< Matrix<TValue, DIMENSION> >::Type coordinate(Iter<Matrix<TValue, DIMENSION> const, PositionIterator > & me, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(752)

//____________________________________________________________________________
// copyGaps

template <typename TSource, typename TSpec, typename TPosition1, typename TSourceGaps, typename TPosition2, typename TPosition3> inline void copyGaps(Gaps<TSource, TSpec> & target_gaps, TPosition1 target_view_pos_begin, TSourceGaps const & source_gaps, TPosition2 source_view_pos_begin, TPosition3 source_view_pos_end);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(691)

//____________________________________________________________________________
// countCharacters

template <typename TGaps> inline typename Size<TGaps>::Type countCharacters(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(867)
template <typename TSource, typename TSpec, typename TPosition> inline typename Size<Gaps<TSource, TSpec> >::Type countCharacters(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(606)
template <typename TSource, typename TSpec, typename TPoistion> inline typename Size<Gaps<TSource, TSpec> >::Type countCharacters(Gaps<TSource, TSpec> & me, TPoistion view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(615)

//____________________________________________________________________________
// countGaps

template <typename TGaps> inline typename Size<TGaps>::Type countGaps(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(828)
template <typename TSource, typename TSpec, typename TPosition> inline typename Size<Gaps<TSource, TSpec> >::Type countGaps(Gaps<TSource, TSpec> & me, TPosition view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(572)
template <typename TSource, typename TSpec, typename TPosition> inline typename Size<Gaps<TSource, TSpec> >::Type countGaps(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(580)
template <typename TGaps> inline typename Size<TGaps>::Type countGaps(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(693)

//____________________________________________________________________________
// createSource

template <typename TSource, typename TSpec> inline void createSource(Gaps<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(893)

//____________________________________________________________________________
// dependent

template <typename TValue, unsigned DIMENSION> inline bool dependent(Matrix<TValue, DIMENSION> & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(305)

//____________________________________________________________________________
// dependentSource

template <typename TSource, typename TSpec> inline bool dependentSource(Gaps<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(810)
template <typename TSource, typename TSpec> inline bool dependentSource(Gaps<TSource, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(817)

//____________________________________________________________________________
// detach

template <typename TSource, typename TSpec> inline void detach(Gaps<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(909)
template <typename TSource, typename TSpec> inline void detach(Align<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/align_base.h"(438)

//____________________________________________________________________________
// dimension

template <typename TValue, unsigned DIMENSION> inline unsigned int dimension(Matrix<TValue, DIMENSION> & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(381)
template <typename TSize, typename TSpec> inline unsigned int dimension(AlignTrace<TSize, TSpec> & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(74)

//____________________________________________________________________________
// empty

template <typename TValue, unsigned DIMENSION> inline bool empty(Matrix<TValue, DIMENSION> const & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(421)

//____________________________________________________________________________
// emptySource

template <typename TSource, typename TSpec> inline bool emptySource(Gaps<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(776)
template <typename TSource, typename TSpec> inline bool emptySource(Gaps<TSource, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(784)

//____________________________________________________________________________
// end

template <typename TValue, unsigned DIMENSION, typename TTag> inline typename Iterator<Matrix <TValue, DIMENSION>, Tag<TTag> const >::Type end(Matrix<TValue, DIMENSION> & me, Tag<TTag> const);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(571)
template <typename TValue, unsigned DIMENSION, typename TTag> inline typename Iterator<Matrix <TValue, DIMENSION> const, Tag<TTag> const >::Type end(Matrix<TValue, DIMENSION> const & me, Tag<TTag> const);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(578)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec>, Tag<TTag> const>::Type end(Gaps<TSource, TSpec> & me, Tag<TTag> const tag_);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(325)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec> const, Tag<TTag> const>::Type end(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(333)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign>, Tag<TTag> const>::Type end(AlignCols<TAlign> & me, Tag<TTag> const tag_);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(405)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign> const, Tag<TTag> const>::Type end(AlignCols<TAlign> const & me, Tag<TTag> const tag_);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(413)

//____________________________________________________________________________
// endPosition

template <typename TSource> inline typename Position<Gaps<TSource, ArrayGaps> >::Type endPosition(Gaps<TSource, ArrayGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(199)
template <typename TSource> inline typename Position<Gaps<TSource, ArrayGaps> >::Type endPosition(Gaps<TSource, ArrayGaps> const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(206)
template <typename TAlign> inline typename Position<AlignCols<TAlign> >::Type endPosition(AlignCols<TAlign> & me);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(385)
template <typename TAlign> inline typename Position<AlignCols<TAlign> const>::Type endPosition(AlignCols<TAlign> const & me);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(392)
template <typename TSource> inline typename Position<Gaps<TSource, SumlistGaps> >::Type endPosition(Gaps<TSource, SumlistGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(204)
template <typename TSource> inline typename Position<Gaps<TSource, SumlistGaps> >::Type endPosition(Gaps<TSource, SumlistGaps> const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(211)

//____________________________________________________________________________
// gapValueImpl

template <typename THost, typename TSpec> inline ModifiedAlphabet<THost, ModExpand<'-', TSpec> > gapValueImpl(ModifiedAlphabet<THost, ModExpand<'-', TSpec> > *);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(69)

//____________________________________________________________________________
// getBit

template <typename TSize, typename TSpec, typename TSpec2> inline bool getBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(284)

//____________________________________________________________________________
// getScore

template <typename TScoreValue> TScoreValue getScore(LocalAlignmentFinder<TScoreValue> & sw);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(218)

//____________________________________________________________________________
// getValue

template <typename TGaps> inline typename GetValue< Iter<TGaps, GapsIterator<ArrayGaps> > >::Type getValue(Iter<TGaps, GapsIterator<ArrayGaps> > & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(797)
template <typename TGaps> inline typename GetValue< Iter<TGaps, GapsIterator<ArrayGaps> > const>::Type getValue(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(806)
template <typename TSource, typename TSpec, typename TPosition> inline typename GetValue<Gaps<TSource, TSpec> >::Type getValue(Gaps<TSource, TSpec> & me, TPosition view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(717)
template <typename TSource, typename TSpec, typename TPosition> inline typename GetValue<Gaps<TSource, TSpec> >::Type getValue(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(727)
template <typename TAlign, typename TSpec, typename TPosition> inline typename GetValue<TAlign>::Type getValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(328)
template <typename TAlign, typename TSpec, typename TPosition> inline typename GetValue<TAlign>::Type getValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(336)
template <typename TGaps> inline typename GetValue< Iter<TGaps, GapsIterator<SumlistGaps> > >::Type getValue(Iter<TGaps, GapsIterator<SumlistGaps> > & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(618)
template <typename TGaps> inline typename GetValue< Iter<TGaps, GapsIterator<SumlistGaps> > const>::Type getValue(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(627)

//____________________________________________________________________________
// globalAlignment

template <typename TAlign, typename TScoreValue, typename TScoreSpec> TScoreValue globalAlignment(TAlign & align_, Score<TScoreValue, TScoreSpec> const & score_);       	// "seqan-1.3.1/seqan/align/align_algorithms.h"(205)
template <typename TSource, typename TSpec, typename TScoreValue, typename TScoreSpec, typename TAlignConfig, typename TAlgorithm> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, TScoreSpec> const & score_, TAlignConfig tag_align_config, TAlgorithm tag_algorithm);       	// "seqan-1.3.1/seqan/align/align_algorithms.h"(227)
template <typename TSource, typename TSpec, typename TScoreValue, typename TScoreSpec, typename TAlgorithm> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, TScoreSpec> const & score_, TAlgorithm tag_algorithm);       	// "seqan-1.3.1/seqan/align/align_algorithms.h"(247)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_, Hirschberg);       	// "seqan-1.3.1/seqan/align/align_hirschberg.h"(174)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const &, MyersBitVector);       	// "seqan-1.3.1/seqan/align/align_myers.h"(171)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const &, MyersHirschberg);       	// "seqan-1.3.1/seqan/align/align_myers.h"(374)

//____________________________________________________________________________
// goFurther

template <typename TGaps, typename TSpec, typename TSize> inline void goFurther(Iter<TGaps, GapsIterator<TSpec> > & me, TSize steps);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(310)

//____________________________________________________________________________
// goNext

template <typename TGaps> inline void goNext(Iter<TGaps, GapsIterator<ArrayGaps> > & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(910)
template <typename TGaps> inline void goNext(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(916)
template <typename TValue, unsigned DIMENSION> inline void goNext(Iter<Matrix<TValue, DIMENSION>, PositionIterator> & me, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(642)
template <typename TValue, unsigned DIMENSION> inline void goNext(Iter<Matrix<TValue, DIMENSION> const, PositionIterator> & me, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(650)
template <typename TValue, unsigned DIMENSION> inline void goNext(Iter<Matrix<TValue, DIMENSION>, PositionIterator> & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(657)
template <typename TValue, unsigned DIMENSION> inline void goNext(Iter<Matrix<TValue, DIMENSION> const, PositionIterator> & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(664)
template <typename TAlign, typename TSpec> inline void goNext(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(153)
template <typename TGaps> inline void goNext(Iter<TGaps, GapsIterator<SumlistGaps> > & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(722)
template <typename TGaps> inline void goNext(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(728)
template <typename TSize, typename TSpec, typename TSpec2> inline void goNext(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/align_trace.h"(312)

//____________________________________________________________________________
// goPrevious

template <typename TGaps> inline void goPrevious(Iter<TGaps, GapsIterator<ArrayGaps> > & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(949)
template <typename TGaps> inline void goPrevious(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(955)
template <typename TValue, unsigned DIMENSION> inline void goPrevious(Iter< Matrix<TValue, DIMENSION>, PositionIterator > & me, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(676)
template <typename TValue, unsigned DIMENSION> inline void goPrevious(Iter< Matrix<TValue, DIMENSION> const, PositionIterator > & me, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(684)
template <typename TValue, unsigned DIMENSION> inline void goPrevious(Iter< Matrix<TValue, DIMENSION>, PositionIterator > & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(691)
template <typename TValue, unsigned DIMENSION> inline void goPrevious(Iter< Matrix<TValue, DIMENSION> const, PositionIterator > & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(698)
template <typename TAlign, typename TSpec> inline void goPrevious(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(196)
template <typename TGaps> inline void goPrevious(Iter<TGaps, GapsIterator<SumlistGaps> > & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(752)
template <typename TGaps> inline void goPrevious(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(758)
template <typename TSize, typename TSpec, typename TSpec2> inline void goPrevious(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/align_trace.h"(352)

//____________________________________________________________________________
// goTo

template <typename TValue, unsigned DIMENSION, typename TPosition0, typename TPosition1> inline void goTo(Iter<Matrix<TValue, DIMENSION>, PositionIterator> & me, TPosition0 pos0, TPosition1 pos1);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(709)
template <typename TValue, unsigned DIMENSION, typename TPosition0, typename TPosition1> inline void goTo(Iter<Matrix<TValue, DIMENSION> const, PositionIterator> & me, TPosition0 pos0, TPosition1 pos1);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(717)
template <typename TValue, unsigned DIMENSION, typename TPosition0, typename TPosition1, typename TPosition2> inline void goTo(Iter<Matrix<TValue, DIMENSION>, PositionIterator> & me, TPosition0 pos0, TPosition1 pos1, TPosition2 pos2);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(725)
template <typename TValue, unsigned DIMENSION, typename TPosition0, typename TPosition1, typename TPosition2> inline void goTo(Iter<Matrix<TValue, DIMENSION> const, PositionIterator> & me, TPosition0 pos0, TPosition1 pos1, TPosition2 pos2);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(733)

//____________________________________________________________________________
// host

template <typename TValue, unsigned DIMENSION> inline typename Host<Matrix<TValue, DIMENSION> >::Type & host(Matrix<TValue, DIMENSION> & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(324)
template <typename TValue, unsigned DIMENSION> inline typename Host<Matrix<TValue, DIMENSION> >::Type const & host(Matrix<TValue, DIMENSION> const & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(331)
template <typename TAlign, typename TSpec> inline TAlign & host(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(109)
template <typename TAlign, typename TSpec> inline TAlign & host(Iter<TAlign, AlignColIterator<TSpec> > const & me);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(116)
template <typename TAlign> inline typename Host<AlignCols<TAlign> >::Type & host(AlignCols<TAlign> & me);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(230)
template <typename TAlign> inline typename Host<AlignCols<TAlign> const>::Type & host(AlignCols<TAlign> const & me);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(238)

//____________________________________________________________________________
// id

template <typename TSource, typename TSpec> inline void const * id(Gaps<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(283)
template <typename TSource, typename TSpec> inline void const * id(Gaps<TSource, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(290)

//____________________________________________________________________________
// insertGap

template <typename TGaps, typename TSpec> inline void insertGap(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(179)
template <typename TSource, typename TSpec, typename TPosition> inline void insertGap(Gaps<TSource, TSpec> & me, TPosition _view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(436)

//____________________________________________________________________________
// insertGaps

template <typename TGaps, typename TCount> inline void insertGaps(Iter<TGaps, GapsIterator<ArrayGaps> > const & me, TCount size);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(984)
template <typename TSource, typename TSpec, typename TPosition, typename TSize> inline void insertGaps(Gaps<TSource, TSpec> & me, TPosition _view_pos, TSize _size);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(460)
template <typename TGaps, typename TCount> inline void insertGaps(Iter<TGaps, GapsIterator<SumlistGaps> > const & me, TCount size);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(787)

//____________________________________________________________________________
// integrateAlign

template <typename TSource1, typename TSpec1, typename TSource2, typename TSpec2, typename TPos> void integrateAlign(Align<TSource1, TSpec1> & align, Align<TSource2, TSpec2> const & infixAlign, String<TPos> viewPos);       	// "seqan-1.3.1/seqan/align/align_algorithms.h"(119)
template <typename TSource, typename TSpec1, typename TSpec2> void integrateAlign(Align<TSource, TSpec1> & align, Align<typename Infix<TSource>::Type, TSpec2> const & infixAlign);       	// "seqan-1.3.1/seqan/align/align_algorithms.h"(179)

//____________________________________________________________________________
// isGap

template <typename TGaps> inline bool isGap(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(818)
template <typename TSource, typename TSpec, typename TPosition> inline bool isGap(Gaps<TSource, TSpec> & me, TPosition view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(535)
template <typename TSource, typename TSpec, typename TPosition> inline bool isGap(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(543)
template <typename TGaps> inline bool isGap(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(683)

//____________________________________________________________________________
// iter

template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, ArrayGaps>, Tag<TTag> const>::Type iter(Gaps<TSource, ArrayGaps> & gaps, TPosition view_pos, Tag<TTag> const);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(543)
template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, ArrayGaps> const, Tag<TTag> const>::Type iter(Gaps<TSource, ArrayGaps> const & gaps, TPosition view_pos, Tag<TTag> const);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(552)
template <typename TAlign, typename TPosition, typename TTag> inline typename Iterator<AlignCols<TAlign>, Tag<TTag> const>::Type iter(AlignCols<TAlign> & me, TPosition pos_, Tag<TTag> const);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(253)
template <typename TAlign, typename TPosition, typename TTag> inline typename Iterator<AlignCols<TAlign> const, Tag<TTag> const>::Type iter(AlignCols<TAlign> const & me, TPosition pos_, Tag<TTag> const);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(262)
template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, SumlistGaps>, Tag<TTag> const>::Type iter(Gaps<TSource, SumlistGaps> & gaps, TPosition view_pos, Tag<TTag> const);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(382)
template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, SumlistGaps> const, Tag<TTag> const>::Type iter(Gaps<TSource, SumlistGaps> const & gaps, TPosition view_pos, Tag<TTag> const);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(393)

//____________________________________________________________________________
// length

template <typename TValue, unsigned DIMENSION> inline typename Size<Matrix<TValue, DIMENSION> >::Type length(Matrix<TValue, DIMENSION> const & me, unsigned int dim_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(408)
template <typename TValue, unsigned DIMENSION> inline typename Size<Matrix <TValue, DIMENSION> >::Type length(Matrix<TValue, DIMENSION> const & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(415)
template <typename TSource, typename TSpec> inline typename Size<Gaps<TSource, TSpec> >::Type length(Gaps<TSource, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(345)
template <typename TAlign> inline typename Size<AlignCols<TAlign> >::Type length(AlignCols<TAlign> const & me);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(423)
template <typename TSize, typename TSpec> inline TSize length(AlignTrace<TSize, TSpec> const & me, TSize _dim);       	// "seqan-1.3.1/seqan/align/align_trace.h"(94)

//____________________________________________________________________________
// localAlignment

template <typename TSource, typename TSpec, typename TScoreValue> inline TScoreValue localAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_, SmithWaterman);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(834)
template <typename TSource, typename TSpec, typename TScoreValue> inline TScoreValue localAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(844)
template <typename TSource, typename TSpec, typename TScoreValue1, typename TScoreValue2, typename TScoreValue3> inline TScoreValue1 localAlignment(Align<TSource, TSpec> & align_, LocalAlignmentFinder<TScoreValue1> & sw_finder, Score<TScoreValue2, Simple> const & score_, TScoreValue3 cutoff, WatermanEggert);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(857)
template <typename TSource, typename TSpec, typename TScoreValue1, typename TScoreValue2, typename TScoreValue3> inline TScoreValue1 localAlignment(Align<TSource, TSpec> & align_, LocalAlignmentFinder<TScoreValue1> & sw_finder, Score<TScoreValue2, Simple> const & score_, TScoreValue3 cutoff);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(873)
template <typename TSource, typename TSpec, typename TScoreValue, typename TDiagonal> inline TScoreValue localAlignment(Align<TSource, TSpec> & align, Score<TScoreValue, Simple> const & score, TDiagonal lowerDiag, TDiagonal upperDiag, BandedSmithWaterman);       	// "seqan-1.3.1/seqan/align/align_local_dynprog_banded.h"(519)
template <typename TSource, typename TSpec, typename TScoreValue, typename TDiagonal> inline TScoreValue localAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_, TDiagonal lowerDiag, TDiagonal upperDiag);       	// "seqan-1.3.1/seqan/align/align_local_dynprog_banded.h"(544)
template <typename TSource, typename TSpec, typename TScoreValue1, typename TScoreValue2, typename TScoreValue3, typename TDiagonal, typename TTag> inline TScoreValue1 localAlignment(Align<TSource, TSpec> & align, LocalAlignmentFinder<TScoreValue1> & finder, Score<TScoreValue2, Simple> const & score, TScoreValue3 cutoff, TDiagonal lowerDiag, TDiagonal upperDiag, TTag tag);       	// "seqan-1.3.1/seqan/align/align_local_dynprog_banded.h"(558)

//____________________________________________________________________________
// move

template <typename TSource, typename TSpec> inline void move(Align<TSource, TSpec> & target, Align<TSource, TSpec> & source);       	// "seqan-1.3.1/seqan/align/align_base.h"(182)

//____________________________________________________________________________
// moveHost

template <typename TValue, unsigned DIMENSION, typename THost> inline void moveHost(Matrix<TValue, DIMENSION> & me, THost const & value_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(349)

//____________________________________________________________________________
// moveNextBit

template <typename TSize, typename TSpec, typename TSpec2> inline void moveNextBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(389)

//____________________________________________________________________________
// movePreviousBit

template <typename TSize, typename TSpec, typename TSpec2> inline void movePreviousBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(406)

//____________________________________________________________________________
// moveSource

template <typename TSource, typename TSpec, typename TSource2, typename TPosition1, typename TPosition2> inline void moveSource(Gaps<TSource, TSpec> & me, TSource2 const & source_, TPosition1 clipped_begin_pos, TPosition2 clipped_end_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1085)
template <typename TSource, typename TSpec, typename TSource2> inline void moveSource(Gaps<TSource, TSpec> & me, TSource2 const & source_);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1099)

//____________________________________________________________________________
// moveValue

template <typename TGaps, typename TSpec, typename TValue> inline void moveValue(Iter<TGaps, GapsIterator<TSpec> > & me, TValue const & val);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(247)
template <typename TGaps, typename TSpec, typename TValue> inline void moveValue(Iter<TGaps, GapsIterator<TSpec> > const & me, TValue const & val);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(258)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue & val);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(387)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue const & val);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(396)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue & val);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(405)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue const & val);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(414)

//____________________________________________________________________________
// nextPosition

template <typename TValue, unsigned DIMENSION, typename TPosition> inline typename Position<Matrix <TValue, DIMENSION> >::Type nextPosition(Matrix<TValue, DIMENSION> & me, TPosition position_, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(497)
template <typename TValue, unsigned DIMENSION, typename TPosition> inline typename Position<Matrix <TValue, DIMENSION> >::Type nextPosition(Matrix<TValue, DIMENSION> const & me, TPosition position_, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(506)

//____________________________________________________________________________
// operator!=

template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<ArrayGaps> > & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > & _right);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(1150)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<ArrayGaps> > const & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > & _right);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(1158)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<ArrayGaps> > & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > const & _right);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(1166)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<ArrayGaps> > const & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > const & _right);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(1174)
template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator!= (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1194)
template <typename TLeftSource, typename TLeftSpec, typename TRight > inline bool operator!=(Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1203)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator!= (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1212)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(275)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(283)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(291)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(299)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SumlistGaps> > & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > & _right);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(904)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SumlistGaps> > const & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > & _right);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(912)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SumlistGaps> > & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > const & _right);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(920)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SumlistGaps> > const & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > const & _right);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(928)

//____________________________________________________________________________
// operator*

template <typename TValue> Matrix<TValue, 2> operator* (Matrix<TValue, 2> const & matrix1, Matrix<TValue, 2> const & matrix2);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(815)
template <typename TValue> Matrix<TValue, 2> operator* (TValue const & scalar, Matrix<TValue, 2> const & matrix);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(845)
template <typename TValue> Matrix<TValue, 2> operator* (Matrix<TValue, 2> const & matrix, TValue const & scalar);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(860)

//____________________________________________________________________________
// operator+

template <typename TValue,unsigned DIMENSION> Matrix<TValue,DIMENSION> operator+ (Matrix<TValue,DIMENSION> const & matrix1,Matrix<TValue,DIMENSION> const & matrix2);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(771)

//____________________________________________________________________________
// operator++

template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const & operator++(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(132)
template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const operator++(Iter<TGaps, GapsIterator<TSpec> > const & me, int);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(141)
template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > & operator++(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(174)
template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > operator++(Iter<TAlign, AlignColIterator<TSpec> > & me, int);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(184)
template <typename TSize, typename TSpec, typename TSpec2> inline Navi< AlignTrace<TSize, TSpec>, TSpec2> const & operator++ (Navi< AlignTrace<TSize, TSpec>, TSpec2> & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(340)

//____________________________________________________________________________
// operator-

template <typename TValue,unsigned DIMENSION> Matrix<TValue,DIMENSION> operator- (Matrix<TValue,DIMENSION> const & matrix1,Matrix<TValue,DIMENSION> const & matrix2);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(793)

//____________________________________________________________________________
// operator--

template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const & operator--(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(153)
template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const operator--(Iter<TGaps, GapsIterator<TSpec> > const & me, int);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(162)
template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > & operator--(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(217)
template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > operator--(Iter<TAlign, AlignColIterator<TSpec> > & me, int);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(227)
template <typename TSize, typename TSpec, typename TSpec2> inline Navi< AlignTrace<TSize, TSpec>, TSpec2> const & operator-- (Navi< AlignTrace<TSize, TSpec>, TSpec2> & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(380)

//____________________________________________________________________________
// operator<

template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator< (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1223)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator< (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1232)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator< (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1240)
template <typename TValue, typename TID> bool operator<(ScoreAndID<TValue,TID> & a, ScoreAndID<TValue,TID> & b);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(89)
template <typename TValue, typename TID> bool operator<(const ScoreAndID<TValue,TID> & a, const ScoreAndID<TValue,TID> & b);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(96)

//____________________________________________________________________________
// operator<<

template <typename TValue > ::std::ostream& operator<<(::std::ostream &out, const Matrix<TValue,2> &matrix);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(1065)
template <typename TStream, typename TSource, typename TSpec> inline TStream & operator<< (TStream & target, Gaps<TSource, TSpec> const & source);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1138)
template <typename TStream, typename TSource, typename TSpec> inline TStream & operator<< (TStream & target, Align<TSource, TSpec> const & source);       	// "seqan-1.3.1/seqan/align/align_base.h"(552)

//____________________________________________________________________________
// operator<=

template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator<= (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1252)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator<= (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1261)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator<= (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1269)

//____________________________________________________________________________
// operator==

template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<ArrayGaps> > & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > & _right);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(1116)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<ArrayGaps> > const & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > & _right);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(1124)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<ArrayGaps> > & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > const & _right);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(1132)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<ArrayGaps> > const & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > const & _right);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(1140)
template <typename TValue, unsigned DIMENSION1, unsigned DIMENSION2> bool operator== (Matrix<TValue, DIMENSION1> const & matrix1, Matrix<TValue, DIMENSION2> const & matrix2);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(876)
template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator== (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1164)
template <typename TLeftSource, typename TLeftSpec, typename TRight > inline bool operator== (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1173)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator== (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1182)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(240)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(248)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(256)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(264)
template <typename TAlign> inline bool operator==(AlignCols<TAlign> const & left, AlignCols<TAlign> const & right);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(434)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SumlistGaps> > & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > & _right);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(870)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SumlistGaps> > const & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > & _right);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(878)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SumlistGaps> > & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > const & _right);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(886)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SumlistGaps> > const & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > const & _right);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(894)
inline bool operator== (_HirschbergSet const & lhs, _HirschbergSet const & rhs);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(217)

//____________________________________________________________________________
// operator>

template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator> (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1280)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator> (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1289)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator> (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1297)
template <typename TValue, typename TID> bool operator>(ScoreAndID<TValue,TID> & a, ScoreAndID<TValue,TID> & b);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(73)
template <typename TValue, typename TID> bool operator>(const ScoreAndID<TValue,TID> & a, const ScoreAndID<TValue,TID> & b);       	// "seqan-1.3.1/seqan/align/align_local_dynprog.h"(80)

//____________________________________________________________________________
// operator>=

template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator>= (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1308)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator>= (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1317)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator>= (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1325)

//____________________________________________________________________________
// previousPosition

template <typename TValue, unsigned DIMENSION, typename TPosition> inline typename Position<Matrix <TValue, DIMENSION> >::Type previousPosition(Matrix<TValue, DIMENSION> & me, TPosition position_, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(515)
template <typename TValue, unsigned DIMENSION, typename TPosition> inline typename Position<Matrix <TValue, DIMENSION> >::Type previousPosition(Matrix<TValue, DIMENSION> const & me, TPosition position_, unsigned int dimension_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(524)

//____________________________________________________________________________
// print

inline void print(_HirschbergSet const & me);       	// "seqan-1.3.1/seqan/align/hirschberg_set.h"(207)

//____________________________________________________________________________
// removeGap

template <typename TGaps, typename TSpec> inline void removeGap(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(190)
template <typename TSource, typename TSpec, typename TPosition> inline void removeGap(Gaps<TSource, TSpec> & me, TPosition _view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(483)

//____________________________________________________________________________
// removeGaps

template <typename TGaps, typename TCount> inline void removeGaps(Iter<TGaps, GapsIterator<ArrayGaps> > const & me, TCount _size);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(1046)
template <typename TSource, typename TSpec, typename TPosition, typename TSize> inline void removeGaps(Gaps<TSource, TSpec> & me, TPosition _view_pos, TSize _size);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(512)
template <typename TGaps, typename TCount> inline void removeGaps(Iter<TGaps, GapsIterator<SumlistGaps> > const & me, TCount _size);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(825)

//____________________________________________________________________________
// resize

template <typename TValue, unsigned DIMENSION> inline void resize(Matrix<TValue, DIMENSION> & me);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(444)
template <typename TValue, unsigned DIMENSION, typename TFillValue> inline void resize(Matrix<TValue, DIMENSION> & me, TFillValue myValue);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(470)

//____________________________________________________________________________
// row

template <typename TSource, typename TSpec, typename TPosition> inline typename Row< Align<TSource, TSpec> >::Type & row(Align<TSource, TSpec> & me, TPosition _pos);       	// "seqan-1.3.1/seqan/align/align_base.h"(355)
template <typename TSource, typename TSpec, typename TPosition> inline typename Row< Align<TSource, TSpec> const>::Type & row(Align<TSource, TSpec> const & me, TPosition _pos);       	// "seqan-1.3.1/seqan/align/align_base.h"(363)

//____________________________________________________________________________
// rows

template <typename TSource, typename TSpec> inline typename Rows< Align<TSource, TSpec> >::Type & rows(Align<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/align_base.h"(321)
template <typename TSource, typename TSpec> inline typename Rows< Align<TSource, TSpec> const >::Type & rows(Align<TSource, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/align_base.h"(328)

//____________________________________________________________________________
// setBeginPosition

template <typename TSource, typename TPosition> inline void setBeginPosition(Gaps<TSource, ArrayGaps> & me, TPosition view_position);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(582)
template <typename TSource, typename TPosition> inline void setBeginPosition(Gaps<TSource, SumlistGaps> & me, TPosition view_position);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(408)

//____________________________________________________________________________
// setBit

template <typename TSize, typename TSpec, typename TSpec2> inline void setBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "seqan-1.3.1/seqan/align/align_trace.h"(293)

//____________________________________________________________________________
// setClippedBeginPosition

template <typename TSource, typename TPosition> inline void setClippedBeginPosition(Gaps<TSource, ArrayGaps> & me, TPosition source_position);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(599)
template <typename TSource, typename TPosition> inline typename Size< Gaps<TSource, SumlistGaps> >::Type setClippedBeginPosition(Gaps<TSource, SumlistGaps> & me, TPosition source_position);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(426)

//____________________________________________________________________________
// setClippedEndPosition

template <typename TSource, typename TPosition> inline void setClippedEndPosition(Gaps<TSource, ArrayGaps> & me, TPosition source_position);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(666)
template <typename TSource, typename TPosition> inline void setClippedEndPosition(Gaps<TSource, SumlistGaps> & me, TPosition source_position);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(484)

//____________________________________________________________________________
// setContainer

template <typename TContainer, typename TSpec> inline void setContainer(Navi<TContainer, TSpec> & me, TContainer & container_);       	// "seqan-1.3.1/seqan/align/align_trace.h"(274)

//____________________________________________________________________________
// setDimension

template <typename TValue, unsigned DIMENSION> inline void setDimension(Matrix<TValue, DIMENSION> & me, unsigned int dim_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(391)
template <typename TSize, typename TSpec> inline unsigned int setDimension(AlignTrace<TSize, TSpec> & me, unsigned int _dim);       	// "seqan-1.3.1/seqan/align/align_trace.h"(84)

//____________________________________________________________________________
// setHost

template <typename TValue, unsigned DIMENSION, typename THost> inline void setHost(Matrix<TValue, DIMENSION> & me, THost & host_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(314)
template <typename TAlign, typename TSpec> inline void setHost(Iter<TAlign, AlignColIterator<TSpec> > & me, TAlign & _host);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(126)

//____________________________________________________________________________
// setLength

template <typename TValue, unsigned DIMENSION, typename TSize> inline void setLength(Matrix<TValue, DIMENSION> & me, unsigned int dim_, TSize length_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(432)
template <typename TSize, typename TSpec> inline void setLength(AlignTrace<TSize, TSpec> & me, unsigned int _dim, TSize _length);       	// "seqan-1.3.1/seqan/align/align_trace.h"(105)

//____________________________________________________________________________
// setSource

template <typename TSource, typename TSpec, typename TPosition1, typename TPosition2> inline void setSource(Gaps<TSource, TSpec> & me, TSource & source_, TPosition1 clipped_begin_pos, TPosition2 clipped_end_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(850)
template <typename TSource, typename TSpec> inline void setSource(Gaps<TSource, TSpec> & me, TSource & source_);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(864)

//____________________________________________________________________________
// setStrings

template <typename TSource, typename TSpec, typename TSpec2> inline void setStrings(Align<TSource, TSpec> & me, StringSet<TSource, TSpec2> & stringset);       	// "seqan-1.3.1/seqan/align/align_base.h"(590)

//____________________________________________________________________________
// source

template <typename TGaps, typename TSpec> inline typename Source<Iter<TGaps, GapsIterator<TSpec> > >::Type source(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(291)
template <typename TGaps, typename TSpec> inline typename Source<Iter<TGaps, GapsIterator<TSpec> > const>::Type source(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(298)
template <typename TSource, typename TSpec> inline TSource & source(Gaps<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(932)
template <typename TSource, typename TSpec> inline TSource & source(Gaps<TSource, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(939)
template <typename TGaps> inline typename Source<Iter<TGaps, GapsIterator<SumlistGaps> > >::Type source(Iter<TGaps, GapsIterator<SumlistGaps> > & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(666)
template <typename TGaps> inline typename Source<Iter<TGaps, GapsIterator<SumlistGaps> > const>::Type source(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(673)

//____________________________________________________________________________
// sourceBegin

template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<TSource, Tag<TTag> const>::Type sourceBegin(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(370)
template <typename TSource, typename TSpec> inline typename Iterator<TSource, typename DefaultGetIteratorSpec<TSource>::Type>::Type sourceBegin(Gaps<TSource, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(377)

//____________________________________________________________________________
// sourceEnd

template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<TSource, Tag<TTag> const>::Type sourceEnd(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(405)
template <typename TSource, typename TSpec> inline typename Iterator<TSource, typename DefaultGetIteratorSpec<TSource>::Type>::Type sourceEnd(Gaps<TSource, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(412)

//____________________________________________________________________________
// sourceLength

template <typename TSource> inline typename Size<TSource>::Type sourceLength(Gaps<TSource, ArrayGaps> & me);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(715)
template <typename TSource, typename TSpec> inline typename Size<TSource>::Type sourceLength(Gaps<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(996)
template <typename TSource, typename TSpec> inline typename Size<TSource>::Type sourceLength(Gaps<TSource, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1003)

//____________________________________________________________________________
// sourcePosition

template <typename TGaps> inline typename Position<TGaps>::Type sourcePosition(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(649)

//____________________________________________________________________________
// sourceSegment

template <typename TSource, typename TSpec> inline typename Infix<TSource>::Type sourceSegment(Gaps<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(964)
template <typename TSource, typename TSpec> inline typename Infix<TSource>::Type sourceSegment(Gaps<TSource, TSpec> const & me);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(972)

//____________________________________________________________________________
// stringSet

template <typename TSource, typename TSpec> inline typename StringSetType<Align<TSource, TSpec> >::Type stringSet(Align<TSource, TSpec> & me);       	// "seqan-1.3.1/seqan/align/align_base.h"(635)

//____________________________________________________________________________
// toSourcePosition

template <typename TSource> inline typename Position<TSource>::Type toSourcePosition(Gaps<TSource, ArrayGaps> const & gaps, typename Position< Gaps<TSource, ArrayGaps> >::Type pos);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(442)
template <typename TSource> inline typename Position<TSource>::Type toSourcePosition(Gaps<TSource, SumlistGaps> const & gaps, typename Position< Gaps<TSource, SumlistGaps> >::Type pos);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(340)

//____________________________________________________________________________
// toViewPosition

template <typename TSource> inline typename Position< Gaps<TSource, ArrayGaps> >::Type toViewPosition(Gaps<TSource, ArrayGaps> const & gaps, typename Position<TSource>::Type pos);       	// "seqan-1.3.1/seqan/align/gaps_array.h"(392)
template <typename TSource> inline typename Position< Gaps<TSource, SumlistGaps> >::Type toViewPosition(Gaps<TSource, SumlistGaps> const & gaps_, typename Position<TSource>::Type pos);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(313)

//____________________________________________________________________________
// transpose

template <typename TValue> Matrix<TValue,2> transpose(Matrix<TValue,2> const & matrix);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(1036)

//____________________________________________________________________________
// value

template <typename TGaps, typename TSpec> inline typename Reference< Iter<TGaps, GapsIterator<TSpec> > >::Type value(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(201)
template <typename TGaps, typename TSpec> inline typename Reference< Iter<TGaps, GapsIterator<TSpec> > const>::Type value(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_iterator_base.h"(209)
template <typename TValue, unsigned DIMENSION, typename TPosition> inline typename Reference<Matrix<TValue, DIMENSION> >::Type value(Matrix<TValue, DIMENSION> & me, TPosition position_);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(588)
template <typename TValue, unsigned DIMENSION, typename TOrdinate1, typename TOrdinate2> inline typename Reference<Matrix<TValue, DIMENSION> >::Type value(Matrix<TValue, DIMENSION> & me, TOrdinate1 i1, TOrdinate2 i2);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(600)
template <typename TValue, unsigned DIMENSION, typename TOrdinate1, typename TOrdinate2, typename TOrdinate3> inline typename Reference<Matrix<TValue, DIMENSION> >::Type value(Matrix<TValue, DIMENSION> & me, TOrdinate1 i1, TOrdinate2 i2, TOrdinate3 i3);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(614)
template <typename TValue, unsigned DIMENSION, typename TOrdinate1, typename TOrdinate2, typename TOrdinate3, typename TOrdinate4> inline typename Reference<Matrix<TValue, DIMENSION> >::Type value(Matrix<TValue, DIMENSION> & me, TOrdinate1 i1, TOrdinate2 i2, TOrdinate3 i3, TOrdinate4 i4);       	// "seqan-1.3.1/seqan/align/matrix_base.h"(629)
template <typename TSource, typename TSpec, typename TPosition> inline typename Reference<Gaps<TSource, TSpec> >::Type value(Gaps<TSource, TSpec> & me, TPosition view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(742)
template <typename TSource, typename TSpec, typename TPosition> inline typename Reference<Gaps<TSource, TSpec> const>::Type value(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(751)
template <typename TAlign, typename TSpec, typename TPosition> inline typename Reference<TAlign>::Type value(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(310)
template <typename TAlign, typename TSpec, typename TPosition> inline typename Reference<TAlign>::Type value(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_);       	// "seqan-1.3.1/seqan/align/align_iterator_base.h"(318)
template <typename TAlign, typename TPosition> inline typename Value< AlignCols<TAlign> >::Type value(AlignCols<TAlign> & me, TPosition _pos);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(275)
template <typename TAlign, typename TPosition> inline typename Value< AlignCols<TAlign> const>::Type value(AlignCols<TAlign> const & me, TPosition _pos);       	// "seqan-1.3.1/seqan/align/align_cols_base.h"(283)

//____________________________________________________________________________
// viewPosition

template <typename TGaps> inline typename Position<TGaps>::Type viewPosition(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "seqan-1.3.1/seqan/align/gaps_sumlist.h"(639)

//____________________________________________________________________________
// write

template <typename TFile, typename TSource, typename TIDString, typename TSpec> inline void write(TFile & target, Gaps<TSource, TSpec> const & source, TIDString const &, Raw);       	// "seqan-1.3.1/seqan/align/gaps_base.h"(1114)
template <typename TFile, typename TSource, typename TSpec, typename TIDString> inline void write(TFile & target, Align<TSource, TSpec> const & source, TIDString const &, Raw);       	// "seqan-1.3.1/seqan/align/align_base.h"(463)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

