/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Dimension.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __LIST_DIMENSION_H__
#define __LIST_DIMENSION_H__

//#include <>
#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef    _LIST_DIMENSION_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL DIMENSION_LIST *p_dimension_list;
	GLOBAL DIMENSION_LIST_INFO dimension_list_info;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef  _LIST_DIMENSION_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int init_dimension(DIMENSION *dimension);
/*  */
DIMENSION_LIST *r_dimension_list_add_first(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Data をリストの最初に追加 */
DIMENSION_LIST *dimension_list_add_first(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Data をリストの最初に追加して、 Undo Baffer に書込む */
DIMENSION_LIST *dimension_list_add_first_with_undo(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);

/* DIMENSION Data をリストの最後に追加 */
DIMENSION_LIST *dimension_list_add_last(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Data をリストの最後に追加、 Undo Baffer に書込む */
DIMENSION_LIST *dimension_list_add_last_with_undo(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);

/* DIMENSION Data の削除機能 (メモリの削除ではない) */
int dimension_list_delete(DIMENSION_LIST *del_List, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Data の削除機能 (メモリの削除ではなく、Undo Buffer へ移す) */
int dimension_list_delete_Undo(DIMENSION_LIST *del_List, DIMENSION_LIST_INFO *p_dimension_list_info);

/* DIMENSION Data を変更する */
DIMENSION_LIST *dimension_list_edit(DIMENSION_LIST *point, DIMENSION *change_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION Data を変更する、 Undo Baffer に書込む */
DIMENSION_LIST *dimension_list_edit_with_undo(DIMENSION_LIST *point, DIMENSION *change_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);

/* リストの総数を調べる */
long dimension_list_num(DIMENSION_LIST_INFO *p_dimension_list_info);
/* n 番目のデータの検索 */
DIMENSION_LIST *dimension_search_num(long search_number, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION のデータの検索 */
DIMENSION_LIST *dimension_search_dimension(DIMENSION *p_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);
/* DIMENSION のデータの検索 */
long dimension_search_dimension_to_num(DIMENSION *p_dimension, DIMENSION_LIST_INFO *p_dimension_list_info);

/* DIMENSION Data をリストから削除 */
int dimension_list_free(DIMENSION_LIST *del_List, DIMENSION_LIST_INFO *p_dimension_list_info);
/* 全リストを削除 */
void dimension_list_all_free(DIMENSION_LIST_INFO *p_dimension_list_info);

/* DIMENSION リストを表示 */
void dimension_list_print(DIMENSION_LIST_INFO *p_dimension_list_info);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_DIMENSION_H__ */



/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Dimension.h
 * ====================================================================
 */
