#!/usr/bin/python
# -*-coding: UTF-8 -*-
# bbou@ac-toulouse.fr
# GPL license
# 30/08/2009 

import os
import sys
import locale
import gettext
APP_NAME = "sadms"

#Get the local directory since we are not installing anything
local_path = os.path.realpath(os.path.dirname(sys.argv[0]))
print local_path

# Init the list of languages to support
langs = []

#Check the default locale
lc, encoding = locale.getdefaultlocale()
if (lc):
	#if we have a default, it's the first in the list
	langs = [lc]
	print lc

# Now lets get all of the supported languages on the system
language = os.environ.get('LANGUAGE', None)
print language
if (language):
	"""langage comes back something like en_CA:en_US:en_GB:en
	on linuxy systems, on Win32 it's nothing, so we need to
	split it up into a list"""
	langs += language.split(":")
"""Now add on to the back of the list the translations that we
know that we have, our defaults"""
langs += ["en_US","fr_FR"]

"""Now langs is a list of all of the languages that we are going
to try to use.  First we check the default, then what the system
told us, and finally the 'known' list"""
gettext.bindtextdomain(APP_NAME, local_path)
gettext.textdomain(APP_NAME)

# Get the language to use
lang = gettext.translation(APP_NAME, local_path, languages=langs, fallback = True)

"""Install the language, map _() (which we marked our
strings to translate with) to self.lang.gettext() which will
translate them."""
_ = lang.gettext

print 'LOCALIZE TO ', lang.info()
print _('_Open')

