/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTWMsgHandlers.h
    \author Romain BONDUE
    \date 21/02/06 */
#ifndef __RTWMSGHANDLERS_H__
#define __RTWMSGHANDLERS_H__

#include "CWirelessMsgHandler.h"



namespace nsWireless
{
    class CRT2400Driver;
    class CRTAdvancedDriver;
    class CRT2570Driver;

} // namespace nsWireless



namespace nsRoot
{
    class CRT2400MsgHandler : public CWirelessMsgHandler
    {
      protected :
        nsWireless::CRT2400Driver* GetDriver () throw();
        const nsWireless::CRT2400Driver* GetDriver () const throw();
        void SetDriver (const std::string&)
                                throw (std::bad_alloc, nsErrors::CException);

    }; // CRT2400MsgHandler


        // Not always the best way to share code (but the most compact).
    class CRTAdvancedMsgHandler : public CWirelessMsgHandler
    {
      public:
        CMsg operator () (const CMsg&) throw (nsErrors::CException,
                                              std::bad_alloc);

      protected :
        nsWireless::CRTAdvancedDriver* GetDriver () throw();
        const nsWireless::CRTAdvancedDriver* GetDriver () const throw();

    }; // CRTAdvancedMsgHandler


    class CRT2500MsgHandler : public CRTAdvancedMsgHandler
    {
      protected :
        void SetDriver (const std::string&)
                                throw (std::bad_alloc, nsErrors::CException);

    }; // CRT500MsgHandler


    class CRT61MsgHandler : public CRTAdvancedMsgHandler
    {
      protected :
        void SetDriver (const std::string&)
                                throw (std::bad_alloc, nsErrors::CException);

    }; // CRT61MsgHandler


    class CRT73MsgHandler : public CRTAdvancedMsgHandler
    {
      protected :
        void SetDriver (const std::string&)
                                throw (std::bad_alloc, nsErrors::CException);

    }; // CRT73MsgHandler


    class CRT2570MsgHandler : public CWirelessMsgHandler
    {
      public:
        CMsg operator () (const CMsg&) throw (nsErrors::CException,
                                              std::bad_alloc);

      protected :
        nsWireless::CRT2570Driver* GetDriver () throw();
        const nsWireless::CRT2570Driver* GetDriver () const throw();
        void SetDriver (const std::string&)
                                throw (std::bad_alloc, nsErrors::CException);

    }; // CRT2570MsgHandler

} // namespace nsRoot

#include "private/RTWMsgHandlers.hxx"

#endif // __RTWMSGHANDLERS_H__
