---
layout: default
title: rpm.org - Signature header format
---
# Signature header

The 2.1 release of RPM had a few improvements in the area of
digital package signatures.  The usage of PGP has been cleaned
up and extended, the signature section in the RPM file format
has been made easily extensible with new signature types, and
packages can have multiple signatures.

## PGP

Legacy usage of PGP in rpm-2.0 was cumbersome, and only supported
1024 bit keys.  Both of these problems have been corrected in rpm-2.1.

Whereas previously you needed many rpmrc entries to clue in
RPM about keyring locations and such, RPM now behaves as PGP
users would expect.  The PGPPATH environment variable can be
used to specify keyring locations.  You can also use a
"%_pgpbin" line in your macros file to specify a different value
for RPM to use for PGPPATH.  If neither of these are used PGP
uses its default ($HOME/.pgp).

If you just want to verify packages, you need to supply values
for the macros
```
	%_pgpbin	the path to the pgp executable
	%_signature	the type of signature to use
```

In order to be able to sign packages, you may also have to
supply values for
```
	%_pgp_name	the pgp signature to use for signing
	%_pgp_path	the path to the key ring
```

## Signing Packages

Signature creation is the same as previous releases: just add
a --sign to your build command line.  You can sign a package
after the package is built with:

```
	rpm --resign <package>
```

Using --resign removes any previous signature in the package.
To *add* a signature to a package, leaving all existing
signatures use:

```
	rpm --addsign <package>
```

RPM always creates MD5 and SIZE signatures when it build
packages, which means that packages built without --sign can
be "verified" to some extent.  The MD5 signature should catch
problems like corrupt packages, faulty downloads, etc.

## Verifying Package Signatures

Package signature verification is the same as previous releases:

```
	rpm -K <package>
```

RPM will verify every signature in the package, which may include
more than one PGP signature.  The output indicates what types of
signatures are being checked.  If any checks fail you'll see a
"NOT OK" message, and you should be worried.

If you have a package with PGP signatures, but don't have PGP
installed, but still want to verify it as much as possible, you
can do:

```
	rpm -K --nopgp <package>
```

That will cause RPM to skip any PGP signatures, but still check
any others (currently only MD5 and SIZE).
