#include "rheolef.h"
using namespace rheolef;
using namespace std;

size_t N;
Float f (const point& x) { return 1+(0.5/N)*(x[0]*(1-x[0])+x[1]*(1-x[1])+x[2]*(1-x[2])); }
Float g (const point& x) { return -0.5/N; }

int main(int argc, char**argv) {
  geo omega (argv[1]);
  N = omega.dimension();
  space Vh (omega, argv[2]);
  form m (Vh, Vh, "mass");
  form a (Vh, Vh, "grad_grad");
  a = a+m;
  field fh = interpolate(Vh, f);
  space Wh (omega, omega["boundary"], argv[2]);
  field gh = interpolate(Wh, g);
  form mb (Wh, Vh, "mass");
  field uh(Vh);
  if (omega.dimension() < 3) {
    ssk<Float> fact = ldlt(a.uu);
    uh.u = fact.solve(m.uu*fh.u + m.ub*fh.b + mb.uu*gh.u + mb.ub*gh.b - a.ub*uh.b);
  } else {
    size_t max_iter = 10000;
    Float tol = 1e-15;
    uh.u = 0;
    int status = pcg (a.uu, uh.u, m.uu*fh.u + m.ub*fh.b + mb.uu*gh.u + mb.ub*gh.b - a.ub*uh.b,
                  ic0(a.uu), max_iter, tol, &cerr);
  }
  cout << uh;
  return 0;
}
