#!/usr/bin/perl

$state = 0;
while ($l = <STDIN>) {
	chomp($l);
	if (!$state && $l =~ /^[0-9a-f]* <.*>:/) {
		$state++;
	} elsif ($state) {
		if ($l =~ /^\s*([0-9a-f]*):\t(.*)\t(.*)$/) {
			$c = $1;
			$a = $2;
			$b = $3;
			$a =~ s/[^0-9a-f]//g;
			$a =~ s/([0-9a-f]{2})/0x\1,/g;
			printf("/* %04s */\t%-30s\t/* \%s */\n", $c, $a, $b);
		} elsif ($l =~ /^([0-9a-f]+) <(\S+)>:\s*$/) {
			push (@id, [$2, $1]);
		}
	}
}

print "};\n";
foreach my $i (@id) {
	my ($id, $ofs) = @$i;
	print "poke_32($ARGV[0], 0x$ofs+1, fd_$id);\n";
}
print "{\n";
