/* refdbd.h header file for refdbd.c */
/* markus@mhoenicka.de 2-10-00 */
/* $Id: refdbd.h.in,v 1.7.2.15 2006/02/22 20:58:39 mhoenicka Exp $ */

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#ifndef XmlParse_INCLUDED
#include <expat.h>
#endif

#ifndef backend_included
#include "backend.h"
#endif

/* instances were not available before libdbi 1.0 */
#if !defined (LIBDBI_LIB_CURRENT) || LIBDBI_LIB_CURRENT < 2
typedef void * dbi_inst;
#endif

struct ADDRESULT {
  unsigned long long success; /* number of successfully added references */
  unsigned long long failure; /* number of failures */
  unsigned long long updated; /* number of successfully updated references */
  unsigned long long skipped; /* number of skipped references */
  char *msg; /* ptr to optional error message */
  size_t msg_len; /* length of optional error message */
};

struct CLIENT_REQUEST {
  int fd; /* file descriptor of incoming connection */
  int n_cgi; /* if 1, handle as CGI request */
  int* ptr_optind; /* ptr to index of first parsed argument to handle */
  int inargc; /* number of parsed arguments */
  int protocol; /* protocol version */
  int db_timeout; /* db-engine specific timeout (sqlite/sqlite3) */
  int share_default; /* whether (1) or not (0) to share notes by default */
  char** inargv; /* ptr to array of parsed arguments */
  char username[USERNAME_LENGTH]; /* username for database authentication */
  char passwd[PREFS_BUF_LEN]; /* password for database authentication */
  char server_ip[PREFS_BUF_LEN]; /* hostname or IP address of database server */
  char my_hostname[256]; /* hostname of box running refdbd */
  char dbs_port_address[PREFS_BUF_LEN]; /* port where database server listens */
  char dbserver[PREFS_BUF_LEN]; /* name of the libdbi driver */
  char current_db[DBNAME_LENGTH+1]; /* name of reference database */
  char db_path[PREFS_BUF_LEN]; /* path of dir containing databases */
  char db_encoding[PREFS_BUF_LEN]; /* input or output encoding */
  char listname[PREFS_BUF_LEN+USERNAME_LENGTH+2]; /* name of personal list */
  char limit[PREFS_BUF_LEN]; /* limit:offset for retrieval functions */
  char namespace[PREFS_BUF_LEN]; /* namespace for XML documents */
  char client_ip[16]; /* IP address of client */
  char pdfroot[_POSIX_PATH_MAX+1];
  char cgi_url[_POSIX_PATH_MAX+1];
  char check_string[MAX_FMT_LEN]; /* fields to check */
  char* argument; /* additional unparsed command arguments */
  dbi_inst inst; /* the libdbi instance (used for libdbi >= 1.0) */
};

struct BIBCONNS {
  dbi_conn conn;
  dbi_conn conn_refdb;
  dbi_conn conn_source;
};

#define MSG_BUF_SIZE 256
#define FIFO_NAME "/tmp/refdbd_fifo" /* base name of a fifo */
#define MAIN_META "t_meta" /* name of the main database meta table */
#define DB_DIR "/usr/local/var/lib/refdb/db" /* directory which holds database and version file */
#define MAIN_DB_VERSION 3 /* version tag of main database shipped with this version */
#define MIN_MAIN_DB_VERSION 3 /* minimum version tag of readable main database */
#define DB_VERSION 4 /* version tag of reference databases created with this version */
#define MIN_DB_VERSION 4 /* minimum version tag of reference databases readable */

#define CITEKEY_BASE_LENGTH 240 /* maximum length of authorname+year */

/* defines for the temporary tables used in duplicate checks */
#define TEMP_TABLE_SPECIFIER "TEMPORARY "
#define TEMP_TABLE_NAME_PREFIX "temp_"

/* here we define some strings that will be used in the DSSSL style specification files */
#define STYLESHEET_HTML_NAME "docbook-refdb-html.dsl"
#define STYLESHEET_HTML_BASENAME "docbook-refdb-html"
#define STYLESHEET_HTML_ID "html"
#define STYLESHEET_HTML_PUBID "-//Markus Hoenicka//DOCUMENT RefDB DocBook html stylesheet//EN"

#define STYLESHEET_PRINT_NAME "docbook-refdb-print.dsl"
#define STYLESHEET_PRINT_BASENAME "docbook-refdb-print"
#define STYLESHEET_PRINT_ID "print"
#define STYLESHEET_PRINT_PUBID "-//Markus Hoenicka//DOCUMENT RefDB DocBook print stylesheet//EN"

/* these defines are for the bibliography style output */
#define PROCESSING_INST "<?xml version=\"1.0\"?>\n"
#define PROCESSING_INST_UTF8 "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
#define DOCTYPE_CITESTYLE "<!DOCTYPE CITESTYLE PUBLIC \"-//Markus Hoenicka//DTD CiteStyle V1.8//EN\" \"http://refdb.sourceforge.net/dtd/citestylex-1.8/citestylex.dtd\" [\n<!ENTITY lt \"&#38;#60;\">\n<!ENTITY gt \"&#62;\">\n<!ENTITY amp \"&#38;#38;\">\n<!ENTITY mdash \"&#x2014;\">\n<!ENTITY lsquo \"&#x2018;\">\n<!ENTITY rsquo \"&#x2019;\">\n]>\n"
#define DOCTYPE_STYLESET "<!DOCTYPE STYLESET PUBLIC \"-//Markus Hoenicka//DTD CiteStyle V1.8//EN\" \"http://refdb.sourceforge.net/dtd/citestylex-1.8/citestylex.dtd\" [\n<!ENTITY lt \"&#38;#60;\">\n<!ENTITY gt \"&#62;\">\n<!ENTITY amp \"&#38;#38;\">\n<!ENTITY mdash \"&#x2014;\">\n<!ENTITY lsquo \"&#x2018;\">\n<!ENTITY rsquo \"&#x2019;\">\n]>\n"

/* this one is for the risx.dtd */
#define RISX_PUBID "<!DOCTYPE ris PUBLIC \"-//Markus Hoenicka//DTD Ris V1.3.0//EN\" \"http://refdb.sourceforge.net/dtd/risx-1.3.0/risx.dtd\" [\n<!ENTITY lt \"&#38;#60;\">\n<!ENTITY gt \"&#62;\">\n<!ENTITY amp \"&#38;#38;\">\n<!ENTITY mdash \"&#x2014;\">\n<!ENTITY lsquo \"&#x2018;\">\n<!ENTITY rsquo \"&#x2019;\">\n]>\n"

/* the extended notes dtd */
#define XNOTE_PUBID "<!DOCTYPE xnoteset PUBLIC \"-//Markus Hoenicka//DTD Xnote V1.4//EN\" \"http://refdb.sourceforge.net/dtd/xnote-1.4/xnote.dtd\" [\n<!ENTITY lt \"&#38;#60;\">\n<!ENTITY gt \"&#62;\">\n<!ENTITY amp \"&#38;#38;\">\n<!ENTITY mdash \"&#x2014;\">\n<!ENTITY lsquo \"&#x2018;\">\n<!ENTITY rsquo \"&#x2019;\">\n]>\n"

/* the citationlistx dtd */
#define CITATIONLISTX_PUBID "<!DOCTYPE CITATIONLIST PUBLIC \"-//Markus Hoenicka//DTD CitationList V1.0//EN\" \"http://refdb.sourceforge.net/dtd/citationlistx-1.0/citationlistx.dtd\">\n"

/* these defines select the addref modes */
#define ADDREF_ADD 0
#define ADDREF_UPDATE 1
#define ADDREF_UPDATE_PERSONAL 2
#define ADDREF_CHECK 3

/* the following defines are for daemonize & friends */
#define ROOT_DIR "/"
#define STDIN_FILENO 0
#define STDOUT_FILENO 1
#define STDERR_FILENO 2

/* supported reference types */
#define REFTYPES "ABST ADVS ART BILL BOOK CASE CHAP COMP CONF CTLG DATA ELEC GEN HEAR ICOMM INPR JFULL JOUR MAP MGZN MPCT MUSIC NEWS PAMP PAT PCOMM RPRT SER SLIDE SOUND STAT THES UNBILL UNPB VIDEO"

struct ADDRESULT* new_addresult(size_t msg_len);
void free_addresult(struct ADDRESULT* ptr_addresult);
struct bibinfo* new_bibinfo(char* format_string, char* sort_string);

dbi_conn connect_to_db(struct CLIENT_REQUEST* ptr_clrequest, const char* special_db, int nocheck);
int viewstat(struct CLIENT_REQUEST* ptr_clrequest);
int listdb(struct CLIENT_REQUEST* ptr_clrequest, int select, struct ADDRESULT* ptr_addresult);
int listuser(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
int liststyle(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
int getstyle(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
int whichdb(struct CLIENT_REQUEST* ptr_clrequest);
int createdb(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult, int optind);
int real_createdb(struct CLIENT_REQUEST* ptr_clrequest, const char* db_encoding, struct ADDRESULT* ptr_addresult);
int deletedb(struct CLIENT_REQUEST* ptr_clrequest, int optind, struct ADDRESULT* ptr_addresult);
int child_confserv(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
void confserv(char *command, char *server_ip);
int addref(struct CLIENT_REQUEST* ptr_clrequest, struct bibinfo* ptr_biblio_info, char* set_owner, struct ADDRESULT* ptr_addresult, int replace_ref, int n_keep_id, int informat, int outformat, Lilid* ptr_sentinel);
int deleteref(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
int delete_ref_by_id(unsigned long long idval, dbi_conn conn, struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
int pickref(struct CLIENT_REQUEST* ptr_clrequest, int n_remove, struct ADDRESULT* ptr_addresult);
int pick_one_reference(dbi_conn conn, unsigned long long n_ref_id, unsigned long long n_user_id, const char *listname, const char *username, struct ADDRESULT* ptr_addresult);
int dump_one_reference(dbi_conn conn, unsigned long long n_ref_id, unsigned long long n_user_id, const char *listname, const char *username, struct ADDRESULT* ptr_addresult);
int adduser(struct CLIENT_REQUEST* ptr_clrequest, char *user_host, char* newuser_passwd, int n_remove, int n_readonly, struct ADDRESULT* ptr_addresult);
int addword(struct CLIENT_REQUEST* ptr_clrequest, int n_remove, struct ADDRESULT* ptr_addresult);
int listword(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
int getfoo(struct CLIENT_REQUEST* ptr_clrequest, int type, int all, char* input_encoding, struct ADDRESULT* ptr_addresult, char* format_string);
int getbib(struct CLIENT_REQUEST* ptr_clrequest, struct bibinfo* ptr_biblio_info, int n_ref_format, struct ADDRESULT* ptr_addresult);
char* getid(char* idstring, char** db, int* type);
char* get_bibtex_id(char* idstring, char** db);
int addstyle(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
int deletestyle(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
int remove_style(dbi_conn conn, unsigned int id);
int read_xml(int fd, XML_Parser p, struct ADDRESULT* ptr_addresult);
void log_print(int priority, const char* string);
int is_refdb_admin(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
int run_keyword_scan(struct CLIENT_REQUEST* ptr_clrequest, Lilid* ptr_sentinel, int mode);
int addnote(struct CLIENT_REQUEST* ptr_clrequest, char* set_owner, struct ADDRESULT* ptr_addresult, int replace_note, Lilid* ptr_sentinel);
int deletenote(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
int getnote(struct CLIENT_REQUEST* ptr_clrequest, struct bibinfo *ptr_biblio_info, int ref_format, int n_privatelist, struct ADDRESULT* ptr_addresult, int send_data);
int addlink(struct CLIENT_REQUEST* ptr_clrequest, char* set_owner, struct ADDRESULT* ptr_addresult, int n_remove);
unsigned long long create_personal_list(dbi_conn conn, char *listname, unsigned long long n_user_id, const char *username);
int remove_personal_list(dbi_conn conn, char *quoted_listname, struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
int updatejo(struct CLIENT_REQUEST* ptr_clrequest, struct ADDRESULT* ptr_addresult);
struct CLIENT_REQUEST* new_client_request(void);
struct CLIENT_REQUEST* dup_client_request(struct CLIENT_REQUEST* ptr_clrequest);
int initialize_client_request(struct CLIENT_REQUEST* ptr_clrequest);
int free_client_request(struct CLIENT_REQUEST* ptr_clrequest);
int update_meta(dbi_conn conn, struct CLIENT_REQUEST* ptr_clrequest);
int check_is_subseq(const char* author_concat, const char* table_name, int n_currpos, short int n_pubyear, dbi_conn conn);
int daemonize(char* progname);
int indent_notbelow_dbib(const char* name);
int is_entry_dbib(const char* name);



