// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Fitness.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.fitness {
  public class Fitness : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("fitness.Fitness:1.0.0", null);

    public Fitness(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Fitness(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Fitness StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Fitness(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int FLAG_VALUE_INVALID = 0x1;

    public const int FLAG_VALUE_OLD = 0x2;

    public const int FLAG_ENTRY_CRITICAL = 0x4;

    public class DataEntry : ICloneable {
      public object Clone() {
        DataEntry copy = new DataEntry();
        copy.id = this.id;
        copy.value = this.value;
        copy.maxValue = this.maxValue;
        copy.worstValue = this.worstValue;
        copy.thresholdValue = this.thresholdValue;
        copy.rawValue = this.rawValue;
        copy.flags = this.flags;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["id"] = this.id;
        json["value"] = this.value;
        json["maxValue"] = this.maxValue;
        json["worstValue"] = this.worstValue;
        json["thresholdValue"] = this.thresholdValue;
        json["rawValue"] = this.rawValue;
        json["flags"] = this.flags;
        return json;
      }

      public static DataEntry Decode(LightJson.JsonObject json, Agent agent) {
        DataEntry inst = new DataEntry();
        inst.id = (string)json["id"];
        inst.value = (int)json["value"];
        inst.maxValue = (int)json["maxValue"];
        inst.worstValue = (int)json["worstValue"];
        inst.thresholdValue = (int)json["thresholdValue"];
        inst.rawValue = (long)json["rawValue"];
        inst.flags = (int)json["flags"];
        return inst;
      }

      public string id = "";
      public int value = 0;
      public int maxValue = 0;
      public int worstValue = 0;
      public int thresholdValue = 0;
      public long rawValue = 0;
      public int flags = 0;
    }

    public class ErrorLogEntry : ICloneable {
      public object Clone() {
        ErrorLogEntry copy = new ErrorLogEntry();
        copy.id = this.id;
        copy.value = this.value;
        copy.thresholdValue = this.thresholdValue;
        copy.rawValue = this.rawValue;
        copy.powerOnHours = this.powerOnHours;
        copy.timeStampUTC = this.timeStampUTC;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["id"] = this.id;
        json["value"] = this.value;
        json["thresholdValue"] = this.thresholdValue;
        json["rawValue"] = this.rawValue;
        json["powerOnHours"] = this.powerOnHours;
        json["timeStampUTC"] = (this.timeStampUTC.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        return json;
      }

      public static ErrorLogEntry Decode(LightJson.JsonObject json, Agent agent) {
        ErrorLogEntry inst = new ErrorLogEntry();
        inst.id = (string)json["id"];
        inst.value = (int)json["value"];
        inst.thresholdValue = (int)json["thresholdValue"];
        inst.rawValue = (long)json["rawValue"];
        inst.powerOnHours = (int)json["powerOnHours"];
        inst.timeStampUTC = new System.DateTime(json["timeStampUTC"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        return inst;
      }

      public string id = "";
      public int value = 0;
      public int thresholdValue = 0;
      public long rawValue = 0;
      public int powerOnHours = 0;
      public System.DateTime timeStampUTC = new System.DateTime(0);
    }

    public class GetDataEntriesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.fitness.Fitness.DataEntry> _ret_;
    }

    public GetDataEntriesResult getDataEntries() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDataEntries", _parameters);
      var _ret = new GetDataEntriesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.fitness.Fitness.DataEntry>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.fitness.Fitness.DataEntry.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getDataEntries(AsyncRpcResponse<GetDataEntriesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDataEntries(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDataEntries(AsyncRpcResponse<GetDataEntriesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDataEntries", _parameters,
        _result => {
          try {
            var _ret = new GetDataEntriesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.fitness.Fitness.DataEntry>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.fitness.Fitness.DataEntry.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetErrorLogIndexRangeResult {
      public int firstIndex;
      public int entryCount;
    }

    public GetErrorLogIndexRangeResult getErrorLogIndexRange() {
      JsonObject _parameters = null;
      var _result = RpcCall("getErrorLogIndexRange", _parameters);
      var _ret = new GetErrorLogIndexRangeResult();
      _ret.firstIndex = (int)_result["firstIndex"];
      _ret.entryCount = (int)_result["entryCount"];
      return _ret;
    }

    public AsyncRequest getErrorLogIndexRange(AsyncRpcResponse<GetErrorLogIndexRangeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getErrorLogIndexRange(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getErrorLogIndexRange(AsyncRpcResponse<GetErrorLogIndexRangeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getErrorLogIndexRange", _parameters,
        _result => {
          try {
            var _ret = new GetErrorLogIndexRangeResult();
            _ret.firstIndex = (int)_result["firstIndex"];
            _ret.entryCount = (int)_result["entryCount"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetErrorLogEntriesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.fitness.Fitness.ErrorLogEntry> _ret_;
    }

    public GetErrorLogEntriesResult getErrorLogEntries(int startIndex, int count) {
      var _parameters = new LightJson.JsonObject();
      _parameters["startIndex"] = startIndex;
      _parameters["count"] = count;

      var _result = RpcCall("getErrorLogEntries", _parameters);
      var _ret = new GetErrorLogEntriesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.fitness.Fitness.ErrorLogEntry>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.fitness.Fitness.ErrorLogEntry.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getErrorLogEntries(int startIndex, int count, AsyncRpcResponse<GetErrorLogEntriesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getErrorLogEntries(startIndex, count, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getErrorLogEntries(int startIndex, int count, AsyncRpcResponse<GetErrorLogEntriesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["startIndex"] = startIndex;
        _parameters["count"] = count;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getErrorLogEntries", _parameters,
        _result => {
          try {
            var _ret = new GetErrorLogEntriesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.fitness.Fitness.ErrorLogEntry>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.fitness.Fitness.ErrorLogEntry.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
