// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Circuit.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class Circuit_1_0_5 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Circuit:1.0.5", null);

    public Circuit_1_0_5(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Circuit_1_0_5(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Circuit_1_0_5 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Circuit_1_0_5(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_PARAM = 1;

    public const int ERR_METER_CHANNEL_BUSY = 2;

    public enum Type {
      ONE_PHASE_LN,
      ONE_PHASE_LL,
      ONE_PHASE_LLN,
      THREE_PHASE,
    }

    public class Config : ICloneable {
      public object Clone() {
        Config copy = new Config();
        copy.position = this.position;
        copy.type = this.type;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["position"] = this.position;
        json["type"] = (int)this.type;
        return json;
      }

      public static Config Decode(LightJson.JsonObject json, Agent agent) {
        Config inst = new Config();
        inst.position = (int)json["position"];
        inst.type = (Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Type)(int)json["type"];
        return inst;
      }

      public int position = 0;
      public Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Type type = Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Type.ONE_PHASE_LN;
    }

    public class GetConfigResult {
      public Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Config _ret_;
    }

    public GetConfigResult getConfig() {
      JsonObject _parameters = null;
      var _result = RpcCall("getConfig", _parameters);
      var _ret = new GetConfigResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Config.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getConfig(AsyncRpcResponse<GetConfigResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getConfig(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getConfig(AsyncRpcResponse<GetConfigResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getConfig", _parameters,
        _result => {
          try {
            var _ret = new GetConfigResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Config.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class Sensors : ICloneable {
      public object Clone() {
        Sensors copy = new Sensors();
        copy.current = this.current;
        copy.activePower = this.activePower;
        copy.reactivePower = this.reactivePower;
        copy.apparentPower = this.apparentPower;
        copy.powerFactor = this.powerFactor;
        copy.phaseAngle = this.phaseAngle;
        copy.displacementPowerFactor = this.displacementPowerFactor;
        copy.activeEnergy = this.activeEnergy;
        copy.unbalancedCurrent = this.unbalancedCurrent;
        copy.crestFactor = this.crestFactor;
        copy.activePowerDemand = this.activePowerDemand;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["current"] = this.current != null ? this.current.Encode() : JsonValue.Null;
        json["activePower"] = this.activePower != null ? this.activePower.Encode() : JsonValue.Null;
        json["reactivePower"] = this.reactivePower != null ? this.reactivePower.Encode() : JsonValue.Null;
        json["apparentPower"] = this.apparentPower != null ? this.apparentPower.Encode() : JsonValue.Null;
        json["powerFactor"] = this.powerFactor != null ? this.powerFactor.Encode() : JsonValue.Null;
        json["phaseAngle"] = this.phaseAngle != null ? this.phaseAngle.Encode() : JsonValue.Null;
        json["displacementPowerFactor"] = this.displacementPowerFactor != null ? this.displacementPowerFactor.Encode() : JsonValue.Null;
        json["activeEnergy"] = this.activeEnergy != null ? this.activeEnergy.Encode() : JsonValue.Null;
        json["unbalancedCurrent"] = this.unbalancedCurrent != null ? this.unbalancedCurrent.Encode() : JsonValue.Null;
        json["crestFactor"] = this.crestFactor != null ? this.crestFactor.Encode() : JsonValue.Null;
        json["activePowerDemand"] = this.activePowerDemand != null ? this.activePowerDemand.Encode() : JsonValue.Null;
        return json;
      }

      public static Sensors Decode(LightJson.JsonObject json, Agent agent) {
        Sensors inst = new Sensors();
        inst.current = Com.Raritan.Idl.sensors.NumericSensor_4_0_4.StaticCast(ObjectProxy.Decode(json["current"], agent));
        inst.activePower = Com.Raritan.Idl.sensors.NumericSensor_4_0_4.StaticCast(ObjectProxy.Decode(json["activePower"], agent));
        inst.reactivePower = Com.Raritan.Idl.sensors.NumericSensor_4_0_4.StaticCast(ObjectProxy.Decode(json["reactivePower"], agent));
        inst.apparentPower = Com.Raritan.Idl.sensors.NumericSensor_4_0_4.StaticCast(ObjectProxy.Decode(json["apparentPower"], agent));
        inst.powerFactor = Com.Raritan.Idl.sensors.NumericSensor_4_0_4.StaticCast(ObjectProxy.Decode(json["powerFactor"], agent));
        inst.phaseAngle = Com.Raritan.Idl.sensors.NumericSensor_4_0_4.StaticCast(ObjectProxy.Decode(json["phaseAngle"], agent));
        inst.displacementPowerFactor = Com.Raritan.Idl.sensors.NumericSensor_4_0_4.StaticCast(ObjectProxy.Decode(json["displacementPowerFactor"], agent));
        inst.activeEnergy = Com.Raritan.Idl.sensors.NumericSensor_4_0_4.StaticCast(ObjectProxy.Decode(json["activeEnergy"], agent));
        inst.unbalancedCurrent = Com.Raritan.Idl.sensors.NumericSensor_4_0_4.StaticCast(ObjectProxy.Decode(json["unbalancedCurrent"], agent));
        inst.crestFactor = Com.Raritan.Idl.sensors.NumericSensor_4_0_4.StaticCast(ObjectProxy.Decode(json["crestFactor"], agent));
        inst.activePowerDemand = Com.Raritan.Idl.sensors.NumericSensor_4_0_4.StaticCast(ObjectProxy.Decode(json["activePowerDemand"], agent));
        return inst;
      }

      public Com.Raritan.Idl.sensors.NumericSensor_4_0_4 current = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_4 activePower = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_4 reactivePower = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_4 apparentPower = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_4 powerFactor = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_4 phaseAngle = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_4 displacementPowerFactor = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_4 activeEnergy = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_4 unbalancedCurrent = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_4 crestFactor = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_4 activePowerDemand = null;
    }

    public class GetSensorsResult {
      public Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Sensors _ret_;
    }

    public GetSensorsResult getSensors() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSensors", _parameters);
      var _ret = new GetSensorsResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Sensors.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSensors(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSensors", _parameters,
        _result => {
          try {
            var _ret = new GetSensorsResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Sensors.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetPolesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Pole_7_0_0> _ret_;
    }

    public GetPolesResult getPoles() {
      JsonObject _parameters = null;
      var _result = RpcCall("getPoles", _parameters);
      var _ret = new GetPolesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Pole_7_0_0>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.pdumodel.Pole_7_0_0.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getPoles(AsyncRpcResponse<GetPolesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getPoles(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getPoles(AsyncRpcResponse<GetPolesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getPoles", _parameters,
        _result => {
          try {
            var _ret = new GetPolesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Pole_7_0_0>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.pdumodel.Pole_7_0_0.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class PoleSettings : ICloneable {
      public object Clone() {
        PoleSettings copy = new PoleSettings();
        copy.line = this.line;
        copy.meterChannel = this.meterChannel;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["line"] = (int)this.line;
        json["meterChannel"] = this.meterChannel;
        return json;
      }

      public static PoleSettings Decode(LightJson.JsonObject json, Agent agent) {
        PoleSettings inst = new PoleSettings();
        inst.line = (Com.Raritan.Idl.pdumodel.PowerLine_2_0_0)(int)json["line"];
        inst.meterChannel = (int)json["meterChannel"];
        return inst;
      }

      public Com.Raritan.Idl.pdumodel.PowerLine_2_0_0 line = Com.Raritan.Idl.pdumodel.PowerLine_2_0_0.L1;
      public int meterChannel = 0;
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.name = this.name;
        copy.rating = this.rating;
        copy.ctRating = this.ctRating;
        copy.poleSettings = this.poleSettings;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        json["rating"] = this.rating;
        json["ctRating"] = this.ctRating;
        json["poleSettings"] = new JsonArray(this.poleSettings.Select(
          _value => (JsonValue)(_value.Encode())));
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.name = (string)json["name"];
        inst.rating = (int)json["rating"];
        inst.ctRating = (int)json["ctRating"];
        inst.poleSettings = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Circuit_1_0_5.PoleSettings>(json["poleSettings"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.pdumodel.Circuit_1_0_5.PoleSettings.Decode(_value, agent)));
        return inst;
      }

      public string name = "";
      public int rating = 0;
      public int ctRating = 0;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Circuit_1_0_5.PoleSettings> poleSettings = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Circuit_1_0_5.PoleSettings>();
    }

    public class SettingsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Circuit_1_0_5.SettingsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Settings oldSettings = new Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Settings();
      public Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Settings newSettings = new Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Settings();
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.pdumodel.Circuit_1_0_5.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
