# Copyright (C) 2016-2020 Damon Lynch <damonlynch@gmail.com>

# This file is part of Rapid Photo Downloader.
#
# Rapid Photo Downloader is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Rapid Photo Downloader is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rapid Photo Downloader.  If not,
# see <http://www.gnu.org/licenses/>.

# Directly modelled on Donald Stufft's readme_renderer code:
# https://github.com/pypa/readme_renderer/blob/master/readme_renderer/__about__.py

__all__ = [
    '__title__', '__summary__', '__uri__', '__version__', '__author__',
    '__email__', '__license__', '__copyright__',
]

__title__ = 'rapid-photo-downloader'
__summary__ = 'Downloads, renames and backs up photos and videos from cameras, phones, ' \
'memory cards and other devices'
__uri__ = 'http://www.damonlynch.net/rapid'

__version__ = '0.9.22'

__author__ = 'Damon Lynch'
__email__ = 'damonlynch@gmail.com'

__license__ = 'GPL 3+'
__copyright__ = 'Copyright 2007-2020 {}'.format(__author__)
