/*
RailControl - Model Railway Control Software

Copyright (c) 2017-2023 Dominik (Teddy) Mahrer - www.railcontrol.org

RailControl is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3, or (at your option) any
later version.

RailControl is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with RailControl; see the file LICENCE. If not see
<http://www.gnu.org/licenses/>.
*/

#include "Languages.h"
#include "Utils/Utils.h"









const char* Languages::languages[MaxTexts][MaxLanguages] =
{
/* Text180Deg */ { "180 degrees", "180 Grad", "180 grados" },
/* Text90DegAntiClockwise */ { "90 degrees anti-clockwise", "90 Grad gegen den Uhrzeigersinn", "90 grados en el sentido contrario de las agujas del reloj" },
/* Text90DegClockwise */ { "90 degrees clockwise", "90 Grad im Uhrzeigersinn", "90 grados en el sentido de las agujas del reloj" },
/* TextAccessories */ { "Accessories", "Zubehörartikel", "Accesorios" },
/* TextAccessory*/ { "accessory", "Zubehörartikel", "accesorio" },
/* TextAccessoryAddressDccTooHigh */ { "Addresses higher then 2044 are not supported by DCC", "Adressen grösser als 2044 werden nicht unterstützt von DCC", "Direcciones más grandes que 2044 no están compatibles con DCC" },
/* TextAccessoryAddressMmTooHigh */ { "Addresses higher then 320 are not supported by MM1/MM2", "Adressen grösser als 320 werden nicht unterstützt von MM1/MM2", "Direcciones más grandes que 320 no están compatibles con MM1/MM2" },
/* TextAccessoryControlProtocolAddressDoesNotExist */ { "Acessory for control {0} with protocol {1} and address {2} does not exist", "Zubehörartikel für Zentrale {0} mit Protokoll {1} und Adresse {2} existiert nicht", "Accesorio para control {0} con protocolo {1} y dirección {2} no existe" },
/* TextAccessoryDeleted */ { "Accessory {0} deleted", "Zubehörartikel {0} gelöscht", "Accessorio {0} eliminado" },
/* TextAccessoryDoesNotExist */ { "Acessory does not exist", "Zubehörartikel existiert nicht", "Accesorio no existe" },
/* TextAccessoryIsLocked */ { "Accessory {0} is locked", "Zubehörartikel {0} ist gesperrt", "Accesorio {0} está bloqueado" },
/* TextAccessoryIsUsedByRoute */ { "Accessory {0} is used by route {1}", "Zubehörartikel {0} wird von Fahrstrasse {1} benutzt", "Acesorio {0} está utilizado por itinerario {1}" },
/* TextAccessorySaved */ { "Accessory {0} saved", "Zubehörartikel {0} gespeichert", "Accesorio {0} guardado" },
/* TextAccessorySenderThreadStarted */ { "Accessory sender thread started", "Zubehörartikel Sender Thread gestartet", "Thread enviador accesorio creado" },
/* TextAccessoryStateIsGreen */ { "Accessory state of {0} is now green", "Der Status des Zubehörartikels ist nun grün", "El estado del accessorio está verde" },
/* TextAccessoryStateIsRed */ { "Accessory state of {0} is now red", "Der Status des Zubehörartikels ist nun rot", "El estado del accessorio está rojo" },
/* TextAccessoryUpdated */ { "Accessory {0} updated", "Zubehörartikel {0} aktualisiert", "Accessorio {0} actualizado" },
/* TextActualAndStoredProtocolsDiffer */ { "Actual ({0}) and stored ({1}) protocols differ", "Aktuelles ({0}) und gespeichertes ({1}) Protokoll unterscheiden sich", "protocolo reciente y guardado son diferentes" },
/* TextAddAccessory */ { "Add accessory", "Zubehörartikel hinzufügen", "Añadir accesorio" },
/* TextAddFeedback */ { "Add feedback", "Rückmelder hinzufügen", "Añadir retroseñal" },
/* TextAddRoute */ { "Add route", "Fahrstrasse hinzufügen", "Añadir itinerario" },
/* TextAddSignal */ { "Add signal", "Signal hinzufügen", "Añadir señal" },
/* TextAddSwitch */ { "Add switch", "Weiche hinzufügen", "Añadir desvío" },
/* TextAddText */ { "Add text", "Text hinzufügen", "Añadir texto" },
/* TextAddTrack */ { "Add track", "Gleis hinzufügen", "Añadir vía" },
/* TextAddingFeedback */ { "Adding feedback {0}", "Rückmelder {0} hinzugefügt", "Retroseñal añadido" },
/* TextAddingRouteToTimetable */ { "Adding route {0} to timetable", "Füge Fahrstrasse {0} zum Fahrplan hinzu", "Añadando itinerario {0} al horario" },
/* TextAddress */ { "Address", "Adresse", "Dirección" },
/* TextAddressMustBeHigherThen0 */ { "Address must be higher then 0", "Adresse muss grösser sein als 0", "Dirección tiene que ser mas que 0" },
/* TextAddresses */ { "Addresses", "Adressen", "Direcciónes" },
/* TextAllTrains */ { "all trains", "alle Züge", "todos los trenes" },
/* TextAllowLocoTurn */ { "Allow turn locomotive orientation", "Fahrtrichtung der Lokomotive drehen erlauben", "Permitir girar la dirección de viaje" },
/* TextAllowedPropulsions */ { "Allowed propulsions", "Erlaubte Antriebe", "Tipos de propulsiones permitios" },
/* TextAllowedPushPull */ { "Allowed push-pull trains", "Erlaubte Pendelzüge", "Trenes push-pull permitidos" },
/* TextAllowedTrainTypes */ { "Allowed train types", "Erlaubte Zugtypen", "Tipos de trenes permitidos" },
/* TextAlways */ { "always", "immer", "siempre" },
/* TextAreYouSureToDelete */ { "Are you sure you really want to delete {0}?", "Bist du sicher, dass du {0} löschen möchtest?", "Estás seguro, que quieres eliminar {0}?" },
/* TextAtLock */ { "At lock", "Beim Sperren", "Durante bloquear" },
/* TextAtUnlock */ { "At unlock", "Beim Freigeben", "Durante liberar" },
/* TextAutomaticallyAddUnknownFeedbacks */ { "Automatically add unknown feedbacks", "Füge unbekannte Rückmelder automatisch hinzu", "Añadir retroseñales desconocidos automaticamente" },
/* TextAutomode */ { "Automode", "Automode", "Autómodo" },
/* TextBaseAddress */ { "Baseaddress", "Basisadresse", "Dirección basica" },
/* TextBasic */ { "Basic data", "Basisdaten", "Datos básicos" },
/* TextBlockTrack */ { "Block track", "Blockiere Gleis", "Bloquear vía" },
/* TextBoosterIsTurnedOff */ { "Booster is turned off", "Booster ist ausgeschaltet", "Booster está apagado" },
/* TextBoosterIsTurnedOn */ { "Booster is turned on", "Booster ist eingeschaltet", "Booster está encendido" },
/* TextBridge */ { "Bridge", "Brücke", "Puente" },
/* TextBrowserInfo */ { "Please type one of the following links in your browser to connect to RailControl:{0}{1}{2}", "Bitte einer der folgenden Links im Browser eingeben um sich mit RailControl zu verbinden:{0}{1}{2}", "Por favor conectate a RailControl con el navegador internet con una de las enlaces siguientes:{0}{1}{2}" },
/* TextBufferStop */ { "End / Buffer Stop", "Ende / Prellbock", "Final / Tope" },
/* TextCV */ { "CV", "CV", "CV" },
/* TextCanNotStartAlreadyRunning */ { "Can not start because it is already running", "Unmöglich zu starten weil schon gestartet", "Imposible poner en marcha porque ya está en marcha" },
/* TextCanNotStartInErrorState */ { "Can not start because it is in error state", "Unmöglich zu startein weil sie im Fehlerstatus ist", "Imposible poner en marcha perque está en estado error" },
/* TextCanNotStartNotOnTrack */ { "Can not start because it is not on a track", "Unmöglich zu starten weil sie nicht auf einem Gleis ist", "Imposible poner en marcha porque no está sobre una vía" },
/* TextChDwarf */ { "Swiss dwarf", "Schweizer Zwergsignal", "Suiza enana" },
/* TextChLDistant */ { "Swiss L distant", "Schweizer L Vorsignal", "Suiza L avanzada" },
/* TextChLMain */ { "Swiss L main", "Schweizer L Hauptsignal", "Suiza L principal" },
/* TextChange */ { "change", "wechseln", "cambiar" },
/* TextCheckSumError */ { "Checksum error", "Checksummen Fehler", "Error de checksum" },
/* TextClosingSQLite */ { "Closing SQLite database", "Schliesse SQLite Datenbank", "Cerrando base de datos SQLite" },
/* TextCluster */ { "Cluster", "Gruppe", "Grupo" },
/* TextClusterDeleted */ { "Cluster {0} deleted", "Gruppe {0} gelöscht", "Grupo {0} eliminado" },
/* TextClusterDoesNotExist */ { "Cluster does not exist", "Gruppe existiert nicht", "Grupo no existe" },
/* TextClusterUpdated */ { "Cluster {0} updated", "Gruppe {0} aktualisiert", "Grupo {0} actualizado" },
/* TextClusters */ { "Clusters", "Gruppen", "Grupos" },
/* TextCommandUnknown */ { "Command {0} unknown", "Kommando {0} nicht bekannt", "Comando {0} desconocido" },
/* TextCompileDate */ { "Compile date: {0}", "Kompilierdatum: 01}", "Fetcha compilada: {0}" },
/* TextConfigFileNotFound */ { "Config file {0} not found. Using default config file {1}.", "", "" },
/* TextConfigFileReceivedWithSize */ { "Configuration file with {0} bytes received", "Konfigurationsdatei mit {0} Bytes empfangen", "Archivo de configuración recibido con {0} bytes" },
/* TextConfigMenu */ { "Configuration menu", "Konfigurationsmenu", "Navegación de configuración" },
/* TextConfigureControlFirst */ { "Please configure a control first", "Bitte zuerst eine Zentrale konfigurieren", "Por favor configura un control antes" },
/* TextConnectedTo */ {"Connected to {0}", "Verbunden mit {0}", "Conectado con {0}" },
/* TextConnectionFailed */ { "Connection to {0}:{1} failed", "Verbindung zu {0}:{1} nicht möglich", "Imposible conectar a {0}:{1}" },
/* TextConnectionRefused */ { "Connection to {0}:{1} refused", "Verbindung zu {0}:{1} zurückgewiesen", "Falló intento de conectar a {0}:{1}" },
/* TextConnectionReset */ { "Connection reset", "Verbindung zurückgesetzt", "Conexión reajustado" },
/* TextControl */ { "Control", "Zentrale", "Control" },
/* TextControlDeleted */ { "Control {0} deleted", "Zentrale {0} gelöscht", "Control {0} eliminado" },
/* TextControlDoesNotAnswer */ { "Control does not answer", "Zentrale antwortet nicht", "Control no respuesta" },
/* TextControlDoesNotExist */ { "Control does not exist", "Zentrale existiert nicht", "Control no existe" },
/* TextControlReturnedBadParameter */ { "Control returned bad parameter", "Zentrale sendete falscher Parameter", "Control respondió malo parametro" },
/* TextControlReturnedError */ { "Control returned error: {0}", "Zentrale meldete Fehler: {0}", "Control contesta error: {0}" },
/* TextControlReturnedOnHalt */ { "Control returned on HALT", "Zentrale sendete auf HALT", "Control respondió en HALT" },
/* TextControlReturnedPowerOff */ { "Control returned Power Off", "Zentrale sendete Strom aus", "Control respondió codico booster apagado" },
/* TextControlReturnedQueueFull */ { "Control returned queue full", "Zentrale sendete Warteschlange voll", "Control respondió cola lleno" },
/* TextControlReturnedQueueNearlyFull */ { "Control returned queue nearly full", "Zentrale sendete Warteschlange fast voll", "Control respondió cola casi lleno" },
/* TextControlReturnedUnknownErrorCode */ { "Control returned unknown error code: {0}", "Zentrale sendete unbekannten Fehlercode: {0}", "Control respondió codico error disconocido: {0}" },
/* TextControlSaved */ { "Control {0} saved", "Zentrale {0} gespeichert", "Control {0} guardado" },
/* TextControls */ { "Controls", "Zentralen", "Controls" },
/* TextCopyingFromTo */ { "Copying from {0} to {1}", "Kopiere von {0} nach {1}", "Copiando de {0} a {1}" },
/* TextCreatingTable */ { "Creating table {0}", "Erstelle Tabelle {0}", "Creando table {0}" },
/* TextCreepAt */ { "Creep at", "Schleichgeschwindigkeit bei", "Velocidad a rastras a" },
/* TextCreepingSpeed */ { "Creeping speed", "Kriech Geschwindigkeit", "Velocidad a rastras" },
/* TextCrossingLeft */ { "Crossing left", "Kreuzung links", "Intersección izquierda" },
/* TextCrossingRight */ { "Crossing right", "Kreuzung rechts", "Intersección derecha" },
/* TextCrossingSymetric */ { "Crossing symetric", "Kreuzung symetrisch", "Intersección simétrico" },
/* TextCs2MasterFound */ { "CS2 Master found on CAN bus", "CS2 Master gefunden auf dem CAN bus", "Encontrado CS2 master en el CAN bus" },
/* TextCs2MasterLocoAddressProtocol */ { "CS2 Master has locomotive with address {0} and protocol {1}", "CS2 Master hat eine Lokomotive mit der Adresse {0} und Protokoll {1}", "CS2 master tiene una locomotora con la dirección {0} y el protocolo {1}" },
/* TextCs2MasterLocoFunctionIconType */ { "CS2 Master has locomotive with function {0} with icon {1} of type {2}", "CS2 Master hat eine Lokomotive mit Funktion {0} mit Bild {1} vom Typ {2}", "CS2 master tiene una locomotora con la función {0} con el imagen {1} de tipo {2}" },
/* TextCs2MasterLocoFunctionIconTypeTimer */ { "CS2 Master has locomotive with function {0} with icon {1} of type timer of {2} seconds", "CS2 Master hat eine Lokomotive mit Funktion {0} mit Bild {1} vom Typ timer mit {2} Sekunden", "CS2 master tiene una locomotora con la función {0} con el imagen {1} de tipo timer con {2} secundos" },
/* TextCs2MasterLocoName */ { "CS2 Master has locomotive with name {0}", "CS2 Master hat eine Lokomotive mit dem Namen {0}", "CS2 master tiene una locomotora con el nombre {0}" },
/* TextCs2MasterLocoOldName */ { "CS2 Master has locomotive with former name {0}", "CS2 Master hat eine Lokomotive mit dem bisherigen Namen {0}", "CS2 master tiene una locomotora con el nombre antiguo {0}" },
/* TextCs2MasterLocoRemove */ { "CS2 Master has removed locomotive with name {0}", "CS2 Master hat eine Lokomotive mit dem Namen {0} gelöscht", "CS2 master ha eliminado la locomotora con el nombre {0}" },
/* TextCs2MinorVersionIsUnknown */ { "Minor version of received file unknown", "Minor Version des erhaltenen files ist nicht bekannt", "La versión menor del archivo recibido no está conocido" },
/* TextDcc */ { "DCC", "DCC", "DCC" },
/* TextDeCombined */ { "German Ks", "Deutsches Ks", "Alemania Ks" },
/* TextDebounceThreadStarted */ { "Debounce thread started", "Entprellthread gestartet", "Antirebote thread encendido" },
/* TextDebounceThreadTerminated */ { "Debounce thread terminated", "Entprellthread beedet", "Antirebote thread apagado" },
/* TextDebouncer */ { "Debouncer", "Entpreller", "Antirebote" },
/* TextDebug */ { "debug", "Entkäfern", "depurar" },
/* TextDefaultSwitchingDuration */ { "Default switching duration (ms)", "Standard Schaltzeit (ms)", "Duración de conmutación por defecto (ms)" },
/* TextDelete */ { "Delete", "Löschen", "Eliminar" },
/* TextDeleteAccessory */ { "Delete accessory", "Zubehörartikel löschen", "Eliminar accesorio" },
/* TextDeleteCluster */ { "Delete cluster", "Gruppe löschen", "Eliminar grupo" },
/* TextDeleteControl */ { "Delete control", "Zentrale löschen", "Eliminar control" },
/* TextDeleteFeedback */ { "Delete feedback", "Rückmelder löschen", "Eliminar retroseñal" },
/* TextDeleteLayer */ { "Delete layer", "Schicht löschen", "Eliminar capa" },
/* TextDeleteLoco */ { "Delete locomotive", "Lokomotive löschen", "Eliminar locomotora" },
/* TextDeleteMultipleUnit */ { "Delete multiple unit", "Mehrfachtraktion löschen", "Eliminar unidad múltiple" },
/* TextDeleteRoute */ { "Delete route", "Fahrstrasse löschen", "Eliminar itinerario" },
/* TextDeleteSignal */ { "Delete signal", "Signal löschen", "Eliminar señal" },
/* TextDeleteSwitch */ { "Delete switch", "Weiche löschen", "Eliminar desvío" },
/* TextDeleteText */ { "Delete text", "Text löschen", "Eliminar texto" },
/* TextDeleteTrack */ { "Delete track", "Gleis löschen", "Eliminar vía" },
/* TextDestinationTrack */ { "Destination track", "Zielgleis", "Vía de destino" },
/* TextDeviceOnCanBus */ { "CAN-device {0} with hash {1}, device ID {2} and software version {3}.{4} found.", "CAN-Gerät {0} mit Hash {1}, Geräte-Kennung {2} und Softwareversion {3}.{4} gefunden.", "Encontrado dispositivo {0} con hash {1}, identificador {2} y version {3}.{4}." },
/* TextDifferentOrientations */ { "Locomotive and route {0} have different running directions", "Lokomotive und Fahrstrasse {0} haben verschiedene Fahrtrichtungen", "Tren e itinerario {0} tienen sentidos de la marcha differentes" },
/* TextDifferentPropulsions */ { "Locomotive and route {0} have different propulsion types", "Lokomotive und Fahrstrasse {0} haben verschiedene Antriebsformen", "Tren e itinerario {0} tienen ajustes de propulsión differentes" },
/* TextDifferentPushpullTypes */ { "Locomotive and route {0} have different push-pull types", "Lokomotive und Fahrstrasse {0} haben verschiedene Wendezugeinstellungen", "Tren e itinerario {0} tienen ajustes de push-pull differentes" },
/* TextDifferentTrainTypes */ { "Locomotive and route {0} have different train types", "Lokomotive und Fahrstrasse {0} haben verschiedene Zugtypen", "Tren e itinerario {0} tienen ajustes de tipos de trenes differentes" },
/* TextDirect */ { "Direct", "Direkt", "Directo" },
/* TextDoNotCare */ { "Do not care", "Egal", "No importa" },
/* TextDroppingTable */ { "Dropping table {0}", "Lösche Tabelle {0}", "Eliminando tabla {0}" },
/* TextDuration */ { "Switching duration (ms)", "Schaltzeit (ms)", "Duración de conmutación (ms)" },
/* TextEdit */ { "Edit", "Bearbeiten", "Editar" },
/* TextEditAccessories */ { "Edit accessories", "Zubehörartikel bearbeiten", "Editar accesorios" },
/* TextEditAccessory */ { "Edit accessory", "Zubehörartikel bearbeiten", "Editar accesorio" },
/* TextEditClusters */ { "Edit clusterss", "Gruppen bearbeiten", "Editar grupos" },
/* TextEditControls */ { "Edit controls", "Zentralen bearbeiten", "Editar controlos" },
/* TextEditFeedback */ { "Edit feedback", "Rückmelder bearbeiten", "Editar retroseñal" },
/* TextEditFeedbacks */ { "Edit feedbacks", "Rückmelder bearbeiten", "Editar retroseñales" },
/* TextEditLayers */ { "Edit layers", "Schichten bearbeiten", "Editar capas" },
/* TextEditLocos */ { "Edit locomotives", "Lokomotiven bearbeiten", "Editar locomotoras" },
/* TextEditLocos */ { "Edit multiple units", "Mehrfachtraktion bearbeiten", "Editar unidades múltiples" },
/* TextEditRoute */ { "Edit route", "Fahrstrasse bearbeiten", "Editar itinerario" },
/* TextEditRoutes */ { "Edit routes", "Fahrstrassen bearbeiten", "Editar itinerarios" },
/* TextEditSettings */ { "Edit settings", "Einstellungen bearbeiten", "Editar opciones" },
/* TextEditSignal */ { "Edit signal", "Signal bearbeiten", "Editar señal" },
/* TextEditSignals */ { "Edit signals", "Signale bearbeiten", "Editar señales" },
/* TextEditSwitch */ { "Edit switch", "Weiche bearbeiten", "Editar desvío" },
/* TextEditSwitches */ { "Edit switches", "Weichen bearbeiten", "Editar desvíos" },
/* TextEditText */ { "Edit text", "Text bearbeiten", "Editar texto" },
/* TextEditTexts */ { "Edit texts", "Texte bearbeiten", "Editar textos" },
/* TextEditTrack */ { "Edit track", "Gleis bearbeiten", "Editar vía" },
/* TextEditTracks */ { "Edit tracks", "Gleise bearbeiten", "Editar vías" },
/* TextEnglish */ { "English", "Englisch", "Ingles" },
/* TextError */ { "error", "Fehler", "error" },
/* TextErrorReadingData */ { "Error reading data: {0}", "Fehler beim Daten lesen {0}", "Error leer data: {0}" },
/* TextExecuteAccessory */ { "Execute accessories", "Schalte Zubehörartikel", "Cambia los accesorios" },
/* TextExecutingRoute */ { "Executing route {0}", "Führe Fahrstrasse {0} aus", "Ejecutando itinerario {0}" },
/* TextExitRailControl */ { "Exit RailControl", "RailControl beenden", "Apagar RailControl" },
/* TextFeedback */ { "feedback", "Rückmelder", "retroseñal" },
/* TextFeedbackChange */ { "State of pin {0} on S88 module {1} is {2}", "Status von Pin {0} an S88 Modul {1} ist {2}", "Estado de contacto {0} del S88 módulo {1} está {2}" },
/* TextFeedbackDeleted */ { "Feedback {0} deleted", "Rückmelder {0} gelöscht", "Retroseñal {0} eliminado" },
/* TextFeedbackDoesNotExist */ { "Feedback does not exist", "Rückmelder existiert nicht", "Retroseñal no existe" },
/* TextFeedbackIsUsedByTrack */ { "Feedback {0} is used by track {1}", "Rückmelder {0} wird gebraucht von Gleis {1}", "Retroseñal {0} está usado por vía {1}" },
/* TextFeedbackSaved */ { "Feedback {0} saved", "Rückmelder {0} gespeichert", "Retroseñal {0} guardado" },
/* TextFeedbackStateIsOff */ { "Feedback state of {0} is now off", "Der Status des Rückmelders {0} ist nun aus", "El estado de la retroseñal {0} está apagada" },
/* TextFeedbackStateIsOn */ { "Feedback state of {0} is now on", "Der Status des Rückmelders {0} ist nun ein", "El estado de la retroseñal {0} está encendida" },
/* TextFeedbackUpdated */ { "Feedback {0} updated", "Rückmelder {0} aktualisiert", "Retroseñal {0} actualizado" },
/* TextFeedbacks */ { "Feedbacks", "Rückmelder", "Retroseñales" },
/* TextFileNotFound */ { "File not found: {0}", "Datei nicht gefunden: {0}", "Archivo no encontrado {0}" },
/* TextFoundAccessoryInEcosDatabase */ { "Found accessory in ECoS database: Address: {0} Name: {1}/{2}/{3}", "Zubehörartikel in ECoS Datenbank gefunden: Adresse: {0} Name: {1}/{2}/{3}", "Encontrado un accessorio en la base de datos de ECoS: Dirección: {0} Nombre: {1}/{2}/{3}" },
/* TextFoundFeedbackModuleInEcosDatabase */ { "Found feedback module in ECoS database: ID: {0}", "Rückmeldemodule in ECoS Datenbank gefunden: ID: {0}", "Encontrado un modulo retroseñal en la base de datos de ECoS: ID: {0}" },
/* TextFoundLocoInEcosDatabase */ { "Found locomotive in ECoS database: Address: {0} Name: {1}", "Locomotive in ECoS Datenbank gefunden: Adresse: {0} Name: {1}", "Encontrado una locomotora en la base de datos de ECoS: Dirección: {0} Nombre: {1}" },
/* TextFullScreen */ { "Full screen", "Vollbild", "Pantalla completa" },
/* TextFunctions */ { "Functions", "Funktionen", "Functiones" },
/* TextGerman */ { "German", "Deutsch", "Alemán" },
/* TextGitDate */ { "Last GIT commit date: {0}", "Letztes GIT Commit Datum: {0}", "Último GIT commit fetcha: {0}" },
/* TextGitDirty */ { "GIT working directory has {0} changed files since last commit.", "Im GIT Arbeitsverzeichnis wurden seit dem letzten commit {0} Dateien geändert.", "En el directorio de trabajo de GIT han cambiado {0} archivos deste el último commit." },
/* TextGitHash */ { "Last GIT commit hash: {0}", "Letzter GIT Commit Hash: {0}", "Último GIT commit hash: {0};" },
/* TextGreen */ { "green", "grün", "verde" },
/* TextHasAlreadyReservedRoute */ { "Has already reserved a route. Setting error state.", "Hat schon eine Fahrstrasse reserviert. Setze Fehlerstatus.", "Ya ha reservado un itinerario. Poniando estado error." },
/* TextHasNotReachedDestination */ { "Has not yet reached its destination. Going to manual mode when it reached its destination.", "Hat ihr Ziel noch nicht erreicht. Setze sie in Modus manuell wenn sie ihr Ziel erreicht hat", "No ha llegado su destino. Poniando en modo manual cuando ha llegado su destino." },
/* TextHeadingToVia */ { "Heading to {0} via {1}", "Fahre via {1} nach {0}", "Circulando por {1} a {0}" },
/* TextHeadingToViaVia */ { "Heading to {0} via {1} and {2}", "Fahre via {1} und {2} nach {0}", "Circulando por {1} y {2} a {0}" },
/* TextHeartBeatThreadStarted */ { "Heartbeat thread started", "Heartbeat-Thread gestartet", "Thread heartbeat creado" },
/* TextHeightIs0 */ { "Height is zero", "Höhe ist null", "Altura está zero" },
/* TextHint */ { "Hint:", "Hinweis:", "Nota:" },
/* TextHintCcSchnitte */ { "Under Linux the virtual serial port is usually /dev/ttyUSB0.", "Unter Linux ist der erstellte virtuelle COM-Port üblicherweise /dev/ttyUSB0.", "Sobre Linux el puerto virtual normalmente es /dev/ttyUSB0." },
/* TextHintCs2Tcp */ { "If you have an outdated CS2 software you must use CS2/CS3 UDP.", "Wenn die CS2 software veraltet ist muss stattdessen CS2/CS3 UDP verwendet werden.", "Si la software de la CS2 no está reciente, se tiene que usar CS2/CS3 UDP." },
/* TextHintCs2Udp */ { "Try CS2/CS3 TCP (new protocol) first. Use the CS2/CS3 UDP only, if you have an outdated CS2 software version.<br>To connect to a Märklin Central Station 2 or 3, the firewall has to allow UDP-connections to the remote port 15731 and from the remote port 15730.<br>The CAN settings have to be &quot;broadcast&quot; and the IP of the RailControl server.", "Vorzugsweise wird das CS2/CS3 TCP Protokoll benutzt. CS2/CS3 UDP sollte nur verwendet werden, wenn die CS2 Software nicht mehr aktuell ist.<br>Um die Märklin Central Station 2 oder 3 mit RailControl zu verbinden, muss die Firewall UDP-Verbindungen zum Remote Port 15731, sowie UDP-Verbindungen zum lokalen Port 15730 zulassen.<br>Die CAN Einstellungen müssen auf &quot;broadcast&quot; und die IP auf die Adresse vom RailControl server gestellt werden.", "Está mejor utilzar CS2/CS3 TCP. Solamente use CS2/CS3 UDP si el software de CS2 no está reciente.<br>Para conectar a una Märklin Central Station 2 o 3, el cortafuegos tiene que permitir UDP-conexiones al puerto remoto 15731 y del puerto remote 15730.<br>Los ajustes CAN tienen que ser &quot;broadcast&quot; y la IP tiene que ser la direcctión del servidor RailControl." },
/* TextHintDccPpExSerial */  { "Under Linux the virtual serial port is usually /dev/ttyACM0.", "Unter Linux ist der erstellte virtuelle COM-Port üblicherweise /dev/ttyACM0.", "Sobre Linux el puerto virtual normalmente es /dev/ttyACM0." },
/* TextHintDccPpExTcp */ { "Standard IP is 192.168.1.200.", "Standard IP ist 192.168.1.200.", "IP por defecto es 192.168.1.200." },
/* TextHintEcos */ { "Locomotives and accessories must be accessed with an internal address. The easiest is to import the locomotives and accessories to get the correct address.", "Lokomotiven und Zubehörartikel werden mit einer internen Adresse angesprochen. Am Einfachsten ist es, die Lokomotiven und Zubehörartikel zu importieren, um die korrekte Adresse zu erhalten.", "Se puede acceder las locomotoras y los accesorios con una dirección interna. Lo más facil es importar las locomotoras y los accesorios, para obtener la dirección correcto." },
/* TextHintHsi88 */ { "HSI-88-USB is not supported, only RS-232 version.<br>One has to count the S88 modules as 8-bit modules. 16-bit modules count as two modules.", "HSI-88-USB wird nicht unterstützt, nur die RS-232-Variante.<br>Die S88 Module müssen als 8-Bit Module gezählt werden. 16-Bit Module zählen entsprechend als zwei Module.", "HSI-88-USB no es soportado, solamente la versión RS-232.<br>Se tiene que contar los modulo S88 como 8-bit modulos. Cada Modulo S88 con 16 bits vale como dos modulos." },
/* TextHintIntellibox */ { "Under Linux the virtual serial port is usually /dev/ttyUSB0.<br>The Intellibox does not forward very short feedbacks. It is not recommended to use the feedbacks of the Intellibox for automatic train control.", "Unter Linux ist der erstellte virtuelle COM-Port üblicherweise /dev/ttyUSB0.<br>Die Intellibox verschluckt sehr kurzzeitige Rückmelder. Ein Automatikbetrieb mit den Rückmeldern von Intellibox ist deshalb nicht zu empfehlen.", "Sobre Linux el puerto virtual normalmente es /dev/ttyUSB0.<br>El Intellibox no puede procesar las retroseñales muy cortas. No es recomendada de utilisar las retroseñales de Intellibox para modo automatico." },
/* TextHintIntellibox2 */ { "Under Linux the virtual serial port is usually /dev/ttyUSB0.<br>Please set the Intellibox II to a communication speed of 115200 (default).", "Unter Linux ist der erstellte virtuelle COM-Port üblicherweise /dev/ttyUSB0.<br>Die Kommunikationsgeschwindigkeit ist in der Intellibox II auf 115200 zu setzen (standard).", "Sobre Linux el puerto virtual normalmente es /dev/ttyUSB0.<br>Se tiene que usar una velocidad de comunicación de 115200 en Intellibox II (defecto)." },
/* TextHintLocoNetAdapter63120 */ { "Under Linux the virtual serial port is usually /dev/ttyUSB0.<br>Please set the adapter to a communication speed of 115200 (default).", "Unter Linux ist der erstellte virtuelle COM-Port üblicherweise /dev/ttyUSB0.<br>Die Kommunikationsgeschwindigkeit ist im Adapter auf 115200 zu setzen (standard).", "Sobre Linux el puerto virtual normalmente es /dev/ttyUSB0.<br>Se tiene que usar una velocidad de comunicación de 115200 en el adaptador (defecto)." },
/* TextHintLocoNetAdapter63820 */ { "Under Linux the virtual serial port is usually /dev/ttyUSB0.<br>Please set the adapter to a communication speed of 115200 (default).", "Unter Linux ist der erstellte virtuelle COM-Port üblicherweise /dev/ttyUSB0.<br>Die Kommunikationsgeschwindigkeit ist im Adapter auf 115200 zu setzen (standard).", "Sobre Linux el puerto virtual normalmente es /dev/ttyUSB0.<br>Se tiene que usar una velocidad de comunicación de 115200 en el adaptador (defecto)." },
/* TextHintM6051 */ { "Locomotives that are selected by a Central Control/Control 80/80f can not be controlled by RailControl.<br>The Interface 6050/6051 does not forward very short feedbacks. It is not recommended to use the feedbacks of the Interface 6050/6051 for automatic train control.", "Lokomotiven die von einer Central Control/Control 80/80f ausgewählt sind können von RailControl nicht gesteuert werden.<br>Das Interface 6050/6051 verschluckt sehr kurzzeitige Rückmelder. Ein Automatikbetrieb mit den Rückmeldern des Interface 6050/6051 ist deshalb nicht zu empfehlen.", "RailControl no puede controlar Locomotoras que estan selectionado por un Central Control/Control 80/80f.<br>El Interface 6050/6051 no puede procesar las retroseñales muy cortas. No es recomendada de utilisar las retroseñales del Interface 6050/6051 para modo automatico." },
/* TextHintMasterControl */ { "Under Linux the virtual serial port is usually /dev/ttyUSB0.<br>The MasterControl does not forward very short feedbacks. It is not recommended to use the feedbacks of the MasterControl for automatic train control.", "Unter Linux ist der erstellte virtuelle COM-Port üblicherweise /dev/ttyUSB0.<br>Die MasterControl verschluckt sehr kurzzeitige Rückmelder. Ein Automatikbetrieb mit den Rückmeldern von MasterControl ist deshalb nicht zu empfehlen.", "Sobre Linux el puerto virtual normalmente es /dev/ttyUSB0.<br>El MasterControl no puede procesar las retroseñales muy cortas. No es recomendada de utilisar las retroseñales de MasterControl para modo automatico." },
/* TextHintMasterControl2 */ { "", "", "" },
/* TextHintOpenDcc */ { "Under Linux the virtual serial port is usually /dev/ttyUSB0.<br>The OpenDCC does not forward very short feedbacks. It is not recommended to use the feedbacks of the OpenDCC for automatic train control.", "Unter Linux ist der erstellte virtuelle COM-Port üblicherweise /dev/ttyUSB0.<br>OpenDCC verschluckt sehr kurzzeitige Rückmelder. Ein Automatikbetrieb mit den Rückmeldern von OpenDCC ist deshalb nicht zu empfehlen.", "Sobre Linux el puerto virtual normalmente es /dev/ttyUSB0.<br>El OpenDCC no puede procesar las retroseñales muy cortas. No es recomendada de utilisar las retroseñales de OpenDCC para modo automatico." },
/* TextHintPositionMove */ { "Elements can be moved by drag and drop while shift-, control or alt key is pressed (key depends on the used browser).", "Elemente können mit Drag und Drop verschoben werden, während die Shift-, Ctrl- oder Alt-Taste gedrückt wird (Die Taste ist abhängig vom verwendeten Browser).", "Se puede mover elementos con Drag and Drop, cuando la tecla de mayúsculas, control o alt esté pulsada (La tecla depende del navegador usado)." },
/* TextHintPositionRotate */ { "Elements can be moved by clicking on it while shift-, control or alt key is pressed (key depends on the used browser).", "Elemente können mit einem Klick gedreht werden, während die Shift-, Ctrl- oder Alt-Taste gedrückt wird (Die Taste ist abhängig vom verwendeten Browser).", "Se puede rotar elementos con un click, cuando la tecla de mayúsculas, control o alt esté pulsada (La tecla depende del navegador usado)." },
/* TextHintRedBox */ { "Under Linux the virtual serial port is usually /dev/ttyUSB0.<br>The RedBox does not forward very short feedbacks. It is not recommended to use the feedbacks of the RedBox for automatic train control.", "Unter Linux ist der erstellte virtuelle COM-Port üblicherweise /dev/ttyUSB0.<br>Die RedBox verschluckt sehr kurzzeitige Rückmelder. Ein Automatikbetrieb mit den Rückmeldern von RedBox ist deshalb nicht zu empfehlen.", "Sobre Linux el puerto virtual normalmente es /dev/ttyUSB0.<br>El RedBox no puede procesar las retroseñales muy cortas. No es recomendada de utilisar las retroseñales de RedBox para modo automatico." },
/* TextHintSystemControl7 */ { "Under Linux the virtual serial port is usually /dev/ttyUSB0.<br>Please set the System Control 7 to a communication speed of 115200 (default).", "Unter Linux ist der erstellte virtuelle COM-Port üblicherweise /dev/ttyUSB0.<br>Die Kommunikationsgeschwindigkeit ist in der System Control 7 auf 115200 zu setzen (standard).", "Sobre Linux el puerto virtual normalmente es /dev/ttyUSB0.<br>Se tiene que usar una velocidad de comunicación de 115200 en System Control 7 (defecto)." },
/* TextHintTwinCenter */ { "Under Linux the virtual serial port is usually /dev/ttyUSB0.<br>The TwinCenter does not forward very short feedbacks. It is not recommended to use the feedbacks of the TwinCenter for automatic train control.", "Unter Linux ist der erstellte virtuelle COM-Port üblicherweise /dev/ttyUSB0.<br>Das TwinCenter verschluckt sehr kurzzeitige Rückmelder. Ein Automatikbetrieb mit den Rückmeldern vom TwinCenter ist deshalb nicht zu empfehlen.", "Sobre Linux el puerto virtual normalmente es /dev/ttyUSB0.<br>El TwinCenter no puede procesar las retroseñales muy cortas. No es recomendada de utilisar las retroseñales de TwinCenter para modo automatico." },
/* TextHintVirtual */ { "The virtual control does not have a physical representation. It is for testing only.", "Die virtuelle Zentrale hat keine physische Repräsentation. Sie ist ausschliesslich für Tests.", "El control virtual no tiene representation physica. Es solamente para tests." },
/* TextHintZ21 */ { "To connect to a control with Z21 protocol, the firewall has to allow UDP-connections from and to the remote port 21105.", "Um eine Zentrale mit Z21-Protokoll mit RailControl zu verbinden, muss die Firewall UDP-Verbindungen von und zum remote Port 21105 zulassen.", "Para conectar a un control con protocolo Z21, el cortafuego tiene que permitir UDP-conexiones del y al puerto remoto 21105." },
/* TextHitOverrun */ { "Hit overrun feedback {0}", "Erreichte Überfahr-Rückmelder {0}", "Ha pasado a {0}" },
/* TextHsi88Configured */ { "{0} ({1}/{2}/{3}) S88 modules configured.", "{0} ({1}/{2}/{3}) S88 Module konfiguriert", "{0} ({1}/{2}/{3}) S88 módulos configurado" },
/* TextHsi88ErrorConfiguring */ { "Unable to configure HSI-88. HSI-88 returned {0} configured modules", "HSI-88 kann nicht konfiguriert werden. HSI-88 meldet {0} module", "Imposible configurar HSI-88. HSI-88 denuncia {0} módulos" },
/* TextHttpRequest */ { "HTTP request: {0} {1}", "HTTP Anfrage: {0} {1}", "HTTP solicitud: {0} {1}" },
/* TextIPAddress */ { "IP address", "IP Adresse", "Dirección IP" },
/* TextImport */ { "Import", "Importieren", "Importar" },
/* TextIndependentOfControl */ { "Independent of control", "Unabhängig der Zentrale", "Independiente del control" },
/* TextIndex */ { "Index", "Index", "Index" },
/* TextInfo */ { "info", "Informationen", "informaciones" },
/* TextInvalidControlID */ { "Invalid controlID {0}", "Ungültige Control ID {0}", "Control ID {0} no valido" },
/* TextInvalidDataReceived */ { "Invalid data received", "Ungültige Daten empfangen", "Datos recibidos no validos" },
/* TextInverted */ { "Inverted", "Invertiert", "Invertido" },
/* TextIsInAutomodeWithoutRouteTrack */ { "Is in automode without a route or track set. Setting error state.", "Ist im Automodus ohne Fahrstrasse oder Gleis. Setze Fehlerstatus.", "Está en modo auto sin itinerario o vía. Poniando estado error." },
/* TextIsInErrorState */ { "Is in error state", "Ist im Fehlerstatus", "Está en estado error" },
/* TextIsInInvalidAutomodeState */ { "Is running in invalid automode state {0} while {1} is reached. Setting error state.", "Ist in unerlaubten Automode Status {0} während {1} erreicht wurde. Setze Fehlerstatus.", "Está en estado ilegal {0} mientras llegando {1}. Poniando estado error." },
/* TextIsInManualState */ { "Is in manual state while automode is running. Setting error state.", "Ist im Status manuell während der Auto-Modus eingeschaltet ist. Setze Fehlerstatus.", "Está en estado manual durante modo auto. Poniando estado error." },
/* TextIsInTerminatedState */ { "Is in terminated state while automode is running. Setting error state.", "Ist im Status beendet während der Auto-Modus eingeschaltet ist. Setze Fehlerstatus.", "Está en estado terminado durante modo auto. Poniando estado error." },
/* TextIsLocked */ { "{0} is locked", "{0} ist gesperrt", "{0} está bloqueado" },
/* TextIsNotFree */ { "{0} is not free", "{0} ist nicht frei", "{0} no está libre" },
/* TextIsNotOnTrack */ { "Is not on a track. Switching to manual mode.", "Ist nicht auf einem Gleis. Wechsle in den Modus manuell.", "No está sobre una vía. Poniando en modo manual." },
/* TextIsNowInAutoMode */ { "Is now in automode", "Ist jetzt im Auto-Modus", "Está en modo auto" },
/* TextIsNowInManualMode */ { "Is now in manual mode", "Ist nun im Modus manuell", "Está en modo manual" },
/* TextIsOnOcupiedTrack */ { "Thinks it is on track {0} but there is {1}. Setting error state.", "Meint sie sei auf Gleis {0} aber dort ist {1}. Setze Fehlerstatus.", "Cree que está sobre vía {0} pero allá está {1}. Poniando estado error." },
/* TextIsRunningWaitingUntilDestination */ { "Is actually running, waiting until reached its destination", "Fährt noch, warte bis sie das Ziel erreicht hat.", "Todavía está en marcha, esperando hasta ha llegado el destino" },
/* TextIsUpToDate */ { "{0} is up to date", "{0} ist aktuell", "{0} es actual" },
/* TextLanguage */ { "Language", "Sprache", "Idioma" },
/* TextLayer1 */ { "Layer 1", "Schicht 1", "Capa 1" },
/* TextLayer1IsUndeletable */ { "Layer 1 is undeletable", "Schicht 1 ist unlöschbar", "Capa 1 no se puede eliminar" },
/* TextLayerDeleted */ { "Layer {0} deleted", "Schicht {0} gelöscht", "Capa {0} eliminado" },
/* TextLayerDoesNotExist */ { "Layer does not exist", "Schicht existiert nicht", "Capa no existe" },
/* TextLayerIsUsedByAccessory */ { "Layer {0} is used by accessory {1}", "Schicht {0} wird benutzt von Zubehörartikel {1}", "Capa {0} está usado por accesorio {1}" },
/* TextLayerIsUsedByFeedback */ { "Layer {0} is used by feedback {1}", "Schicht {0} wird benutzt von Rückmelder {1}", "Capa {0} está usado por retroseñal {1}" },
/* TextLayerIsUsedByRoute */ { "Layer {0} is used by route {1}", "Schicht {0} wird benutzt von Fahrstrasse {1}", "Capa {0} está usado por itinerario {1}" },
/* TextLayerIsUsedBySignal */ { "Layer {0} is used by signal {1}", "Schicht {0} wird benutzt von Signal {1}", "Capa {0} está usado por señal {1}" },
/* TextLayerIsUsedBySwitch */ { "Layer {0} is used by switch {1}", "Schicht {0} wird benutzt von Weiche {1}", "Capa {0} está usado por desvío {1}" },
/* TextLayerIsUsedByText */ { "Layer {0} is used by text {1}", "Schicht {0} wird benutzt von Text {1}", "Capa {0} está usado por texto {1}" },
/* TextLayerIsUsedByTrack */ { "Layer {0} is used by track {1}", "Schicht {0} wird benutzt von Gleis {1}", "Capa {0} está usado por vía {1}" },
/* TextLayerSaved */ { "Layer {0} saved", "Schicht {0} gespeichert", "Capa {0} guardado" },
/* TextLayerUpdated */ { "Layer {0} updated", "Schicht {0} aktualisiert", "Capa {0} actualizado" },
/* TextLayers */ { "Layers", "Schichten", "Capas" },
/* TextLeft */ { "left", "links", "izquierda" },
/* TextLength */ { "Length", "Länge", "Longitud" },
/* TextLink */ { "Link", "Link", "Enlace" },
/* TextLoadedAccessory */ { "Loaded accessory {0}: {1}", "Zubehörartikel {0} geladen: {1}", "Cargado accesorio {0}: {1}" },
/* TextLoadedCluster */ { "Loaded cluster {0}: {1}", "Gruppe {0} geladen: {1}", "Cargado grupo {0}: {1}" },
/* TextLoadedControl */ { "Loaded control {0}: {1}", "Zentrale {0} geladen: {1}", "Cargado control {0}: {1}" },
/* TextLoadedFeedback */ { "Loaded feedback {0}: {1}", "Rückmelder {0} geladen: {1}", "Cargado retroseñal {0}: {1}" },
/* TextLoadedLayer */ { "Loaded layer {0}: {1}", "Schicht {0} geladen: {1}", "Cargado capa {0}: {1}" },
/* TextLoadedLoco */ { "Loaded locomotive {0}: {1}", "Lokomotive {0} geladen: {1}", "Cargado locomotora {0}: {1}" },
/* TextLoadedMultipleUnit */ { "Loaded multiple unit {0}: {1}", "Mehrfachtraktion {0} geladen: {1}", "Cargado unidad múltiple {0}: {1}" },
/* TextLoadedRoute */ { "Loaded route {0}: {1}", "Fahrstrasse {0} geladen: {1}", "Cargado itinerario {0}: {1}" },
/* TextLoadedSignal */ { "Loaded signal {0}: {1}", "Signal {0} geladen: {1}", "Cargado señal {0}: {1}" },
/* TextLoadedSwitch */ { "Loaded switch {0}: {1}", "Weiche {0} geladen: {1}", "Cargado desvío {0}: {1}" },
/* TextLoadedText */ { "Loaded text {0}: {1}", "Text {0} geladen: {1}", "Cargado texto {0}: {1}" },
/* TextLoadedTrack */ { "Loaded track {0}: {1}", "Gleis {0} geladen: {1}", "Cargado vía {0}: {1}" },
/* TextLoco */ { "Locomotive", "Lokomotive", "Locomotora" },
/* TextLocoAddressDccTooHigh */ { "Addresses higher than 10239 are not supported by DCC", "Adressen grösser als 10239 werden nicht unterstützt von DCC", "Direcciones más grandes que 10239 no están compatibles con DCC" },
/* TextLocoAddressMm1TooHigh */ { "Addresses higher than 80 are not supported by MM1", "Adressen grösser als 80 werden nicht unterstützt von MM1", "Direcciones más grandes que 80 no están compatibles con MM1" },
/* TextLocoAddressMm2TooHigh */ { "Addresses higher than 255 are not supported by MM2", "Adressen grösser als 255 werden nicht unterstützt von MM2", "Direcciones más grandes que 255 no están compatibles con MM2" },
/* TextLocoDeleted */ { "Locomotive {0} deleted", "Lokomotive {0} gelöscht", "Locomotora {0} eliminado" },
/* TextLocoDirectionOfTravelIsLeft */ { "Direction of travel of {0} is now left", "Die Fahrtrichtung von {0} ist links", "La dirección de viaje  de {0} está izquierda" },
/* TextLocoDirectionOfTravelIsRight */ { "Direction of travel  of {0} is now right", "Die Fahrtrichtung von {0} ist rechts", "La dirección de viaje de {0} está derecha" },
/* TextLocoDoesNotExist */ { "Locomotive does not exist", "Lokomotive existiert nicht", "Locomotora no existe" },
/* TextLocoFunctionIconAirPump */ { "Air pump", "Luftpumpe", "Bomba de aire" },
/* TextLocoFunctionIconBacklightForward */ { "Backlight", "Rücklicht", "Luz trasera" },
/* TextLocoFunctionIconBacklightReverse */ { "Backlight reverse", "Rücklicht vorn", "Luz trasera adelante" },
/* TextLocoFunctionIconBell */ { "Bell", "Glocke", "Campana" },
/* TextLocoFunctionIconBlinkingLight */ { "Blinking light", "Blinklicht", "Luz parpadeando" },
/* TextLocoFunctionIconBreak1 */ { "Break", "Bremsen", "Frenar" },
/* TextLocoFunctionIconBreak1 */ { "Breaking noise 1", "Bremsgeräusch 1", "Ruido de frenos 1" },
/* TextLocoFunctionIconBreak2 */ { "Breaking noise 2", "Bremsgeräusch 2", "Ruido de frenos 2" },
/* TextLocoFunctionIconBufferPush */ { "Buffer push", "Pufferstoss", "Aumento del buffer" },
/* TextLocoFunctionIconCabLight1 */ { "Cab light 1", "Führerstandsbeleuchtung 1", "Luz de cabina 1" },
/* TextLocoFunctionIconCabLight12 */ { "Cab light", "Führerstandsbeleuchtung", "Luz de cabina" },
/* TextLocoFunctionIconCabLight2 */ { "Cab light 2", "Führerstandsbeleuchtung 2", "Luz de cabina 2" },
/* TextLocoFunctionIconCloseDoor */ { "Close door", "Tür schliessen", "Cerrar la puerta" },
/* TextLocoFunctionIconCompressedAir */ { "Compressed air", "Pressluft", "Aire comprimido" },
/* TextLocoFunctionIconCoupler */ { "Coupler", "Kuppeln", "Acoplar" },
/* TextLocoFunctionIconCrane */ { "Crane", "Kran", "Grúa" },
/* TextLocoFunctionIconCraneHook */ { "Crane hook", "Kranhaken", "Gancho de la grúa" },
/* TextLocoFunctionIconCurve */ { "Curve noise", "Kurvengeräusch", "" },
/* TextLocoFunctionIconDefault */ { "Default", "Standard", "Estándar" },
/* TextLocoFunctionIconDown */ { "Down", "Runter", "Abajo" },
/* TextLocoFunctionIconDrainValve */ { "Drain valve", "Abschlammen", "Válvula de drenaje" },
/* TextLocoFunctionIconDriversDeskLight */ { "Drivers desk light", "Fahrpultbeleuchtung", "Luz de la mesa de control" },
/* TextLocoFunctionIconEngine1 */ { "Engine noise 1", "Motorgeräusch 1", "Ruido de motor 1" },
/* TextLocoFunctionIconEngine2 */ { "Engine noise 2", "Motorgeräusch 2", "Ruido de motor 2" },
/* TextLocoFunctionIconEngineLight */ { "Engine light", "Motorlicht", "Luz de motor" },
/* TextLocoFunctionIconFan */ { "Fan", "Lüfter", "Ventilador" },
/* TextLocoFunctionIconFan1 */ { "Fan noise 1", "Lüftergeräusch 1", "Ruido de ventilador 1" },
/* TextLocoFunctionIconFan2 */ { "Fan noise 2", "Lüftergeräusch 2", "Ruido de ventilador 2" },
/* TextLocoFunctionIconFan3 */ { "Fan noise 3", "Lüftergeräusch 3", "Ruido de ventilador 3" },
/* TextLocoFunctionIconFillDiesel */ { "Fill diesel", "Diesel auffüllen", "Llenar diesel" },
/* TextLocoFunctionIconFillGas */ { "Fill gas", "Gas auffüllen", "Llenar gas" },
/* TextLocoFunctionIconFillWater */ { "Fill water", "Wasser auffüllen", "Llenar agua" },
/* TextLocoFunctionIconFireBox */ { "Firebox", "Feuerbüchse", "Fogón" },
/* TextLocoFunctionIconGearBox */ { "Gear box", "Getriebe", "Engranaje" },
/* TextLocoFunctionIconGearDown */ { "Gear down", "Runterschalten", "Reducir la marcha" },
/* TextLocoFunctionIconGearUp */ { "Gear up", "Hochschalten", "Subir la marcha" },
/* TextLocoFunctionIconGenerator */ { "Generator", "Generator", "Generador" },
/* TextLocoFunctionIconHeadlightHighBeamForward */ { "Headlight high beam", "Scheinwerfer", "Faros" },
/* TextLocoFunctionIconHeadlightHighBeamReverse */ { "Headlight high beam reverse", "Scheinwerfer hinten", "Faros traseros" },
/* TextLocoFunctionIconHeadlightLowBeamForward */ { "Headlight lwo beam", "Abblendlicht", "Luz de cruce" },
/* TextLocoFunctionIconHeadlightLowBeamReverse */ { "Headlight lwo beam reverse", "Abblendlicht hinten", "Luz de cruce trasera" },
/* TextLocoFunctionIconHorn1 */ { "Horn 1", "Horn 1", "Trompa 1" },
/* TextLocoFunctionIconHorn2 */ { "Horn 2", "Horn 2", "Trompa 2" },
/* TextLocoFunctionIconInertia */ { "Inertia", "Trägheit", "Inercia" },
/* TextLocoFunctionIconInteriorLight1 */ { "Interior light 1", "Innenbeleuchtung 1", "Luz interior 1" },
/* TextLocoFunctionIconInteriorLight2 */ { "Interior light 2", "Innenbeleuchtung 2", "Luz interior 2" },
/* TextLocoFunctionIconLeft */ { "Left", "Links", "Izquierda" },
/* TextLocoFunctionIconLeftRight */ { "Left and right", "Links und Rechts", "Izquierda y derecha" },
/* TextLocoFunctionIconLight */ { "Light", "Licht", "Luz" },
/* TextLocoFunctionIconLocomotiveNumberIndicator */ { "Locomotive number indicator", "Lokomotivnummerindikator", "Indicador del número de la locomotora" },
/* TextLocoFunctionIconMagnet */ { "Magnet", "Magnet", "Imán" },
/* TextLocoFunctionIconMainSwitch */ { "Main switch", "Hauptschalter", "Interruptor principal" },
/* TextLocoFunctionIconMusic1 */ { "Music 1", "Musik 1", "Musica 1" },
/* TextLocoFunctionIconMusic2 */ { "Music 2", "Musik 2", "Musica 2" },
/* TextLocoFunctionIconNoBreak */ { "No break noise", "Kein Bremsgeräusch", "Ningún ruido de frenos" },
/* TextLocoFunctionIconNoSound */ { "No sound", "Kein Sound", "Ningun sonido" },
/* TextLocoFunctionIconOpenDoor */ { "Open door", "Tür öffnen", "Abrir la puerta" },
/* TextLocoFunctionIconPanto */ { "Raise pantograph", "Pantograf heben", "Elevar el pantógrafo" },
/* TextLocoFunctionIconPanto1 */ { "Raise pantograph 1", "Pantograf 1 heben", "Elevar el pantógrafo 1" },
/* TextLocoFunctionIconPanto12 */ { "Raise pantograph", "Pantograf heben", "Elevar el pantógrafo" },
/* TextLocoFunctionIconPanto2 */ { "Raise pantograph 2", "Pantograf 2 heben", "Elevar el pantógrafo 2" },
/* TextLocoFunctionIconRadio */ { "Radio", "Funk", "Radio" },
/* TextLocoFunctionIconRailJoint */ { "Rail joint", "Schienenstoss", "Junta de rieles" },
/* TextLocoFunctionIconReliefValve */ { "Relief valve", "Überdruckventil", "Válvula de sobrepresión" },
/* TextLocoFunctionIconRight */ { "Right", "Rechts", "Derecha" },
/* TextLocoFunctionIconRunning1 */ { "Driving noise 1", "Fahrgeräusch 1", "Ruido de conducción 1" },
/* TextLocoFunctionIconRunning2 */ { "Driving noise 2", "Fahrgeräusch 2", "Ruido de conducción 2" },
/* TextLocoFunctionIconSand */ { "Sand", "Sanden", "Espolvorear arena" },
/* TextLocoFunctionIconShakingRust */ { "Shaking rust", "Schüttelrost", "Agitar parrilla" },
/* TextLocoFunctionIconShovelCoal */ { "Shovel coal", "Kohle schaufeln", "Palear carbón" },
/* TextLocoFunctionIconShuntingLight */ { "Shunting light", "Rangierbeleuchtung", "Luz de maniobras" },
/* TextLocoFunctionIconShuntingMode */ { "Shunting mode", "Rangiergang", "Modo de maniobras" },
/* TextLocoFunctionIconSmokeGenerator */ { "Smoke generator", "Rauchgenerator", "Generador de humo" },
/* TextLocoFunctionIconSoundGeneral */ { "Sound", "Sound", "Sonido" },
/* TextLocoFunctionIconSoundLouder */ { "Sound louder", "Sound lauter", "Sonido más fuerte" },
/* TextLocoFunctionIconSoundLower */ { "Sound lower", "Sound lower", "Sonido más bajo" },
/* TextLocoFunctionIconSpeak */ { "Speak", "Sprechen", "Hablar" },
/* TextLocoFunctionIconStairsLight */ { "Stairs light", "Treppenlicht", "Luz de escalera" },
/* TextLocoFunctionIconStationAnnouncement1 */ { "Station announcement 1", "Stationsansage 1", "Anuncio de la estación 1" },
/* TextLocoFunctionIconStationAnnouncement2 */ { "Station announcement 2", "Stationsansage 2", "Anuncio de la estación 2" },
/* TextLocoFunctionIconStationAnnouncement3 */ { "Station announcement 3", "Stationsansage 3", "Anuncio de la estación 3" },
/* TextLocoFunctionIconSteamBlow */ { "Steam blow", "Dampfstoss", "Empuje de vapor" },
/* TextLocoFunctionIconSteamBlowOut */ { "Steam blow out", "Zylinder ausblasen", "Soplar el cilindro" },
/* TextLocoFunctionIconTableLight1 */ { "Table light 1", "Tischlicht 1", "Luz de mesa 1" },
/* TextLocoFunctionIconTableLight2 */ { "Table light 2", "Tischlicht 2", "Luz de mesa 2" },
/* TextLocoFunctionIconTableLight3 */ { "Table light 3", "Tischlicht 3", "Luz de mesa 3" },
/* TextLocoFunctionIconTelex1 */ { "Telex 1", "Telex 1", "Telex 1" },
/* TextLocoFunctionIconTelex12 */ { "Telex", "Telex", "Telex" },
/* TextLocoFunctionIconTelex2 */ { "Telex 2", "Telex 2", "Telex 2" },
/* TextLocoFunctionIconTrainDestinationIndicator */ { "Train destination indicator", "Zugzielanzeige", "Indicador de destino del tren" },
/* TextLocoFunctionIconTurn */ { "Turn", "Drehen", "Girar" },
/* TextLocoFunctionIconTurnLeft */ { "Turn left", "Links drehen", "Girar a la izquierda" },
/* TextLocoFunctionIconTurnRight */ { "Turn right", "Rechts drehen", "Girar a la derecha" },
/* TextLocoFunctionIconUp */ { "Up", "Hoch", "Arriba" },
/* TextLocoFunctionIconUpDown1 */ { "Up and down 1", "Hoch und runter 1", "Arriba y abajo 1" },
/* TextLocoFunctionIconUpDown2 */ { "Up and down 2", "Hoch und runter 2", "Arriba y abajo 2" },
/* TextLocoFunctionIconWaterPump */ { "Water pump", "Wasserpumpe", "Bomba de agua" },
/* TextLocoFunctionIconWhistle1 */ { "Conductor's whistle", "Schaffnerpfeiffe", "Silbato del conductor" },
/* TextLocoFunctionIconWhistle2 */ { "Whistle", "Pfeiffe", "Silbato" },
/* TextLocoFunctionIsOff */ { "F{1} of {0} is now off", "F{1} von {0} ist aus", "F{1} de {0} está apagado" },
/* TextLocoFunctionIsOn */ { "F{1} of {0} is now on", "F{1} von {0} ist an", "F{1} de {0} está encendido" },
/* TextLocoFunctionTypeFlashing */ { "Flashing", "Blinkend", "Parpadeante" },
/* TextLocoFunctionTypeMoment */ { "Moment function", "Momentfunktion", "Función momentánea" },
/* TextLocoFunctionTypeNone */ { "Deactivated", "Deaktiviert", "Desactivado" },
/* TextLocoFunctionTypePermanent */ { "Permanent function", "Dauerfunktion", "Función continua" },
/* TextLocoFunctionTypeTimer */ { "Time controlled", "Zeitgesteuert", "Controlado por tiempo" },
/* TextLocoHasReachedDestination */ { "{0} has reached destination track {1} via {2}", "{0} hat das Zielgleis {1} über {2} erreicht.", "{0} ha llegado a su vía destino {1} vía {2}" },
/* TextLocoIsInAutoMode */ { "{0} is in auto mode", "{0} ist im Automatik-Betrieb", "{0} está en el modo automático" },
/* TextLocoIsInManualMode */ { "{0} is in manual mode", "{0} ist im manuellen Betrieb", "{0} está en el modo manual" },
/* TextLocoIsInUse */ { "Locomotive {0} is in use", "Lokomotive {0} ist in Gebrauch", "Locomotora {0} está en uso" },
/* TextLocoIsOnTrack */ { "{0} is on track {1}", "{0} ist auf Gleis {1}", "{0} está sobre vía {1}" } ,
/* TextLocoIsReleased */ { "{0} is released", " {0} ist freigegeben", "{0} está desbloqueada" },
/* TextLocoSaved */ { "Locomotive {0} saved", "Lokomotive {0} gespeichert", "Locomotora {0} guardado" },
/* TextLocoSpeedIs */ { "Speed of {0} is now {1}", "Die Geschwindigkeit von {0} ist {1}", "La velocidad de {0} está {1}" },
/* TextLocoUpdated */ { "Locomotive {0} updated", "Lokomotive {0} aktualisiert", "Locomotora {0} actualizado" },
/* TextLocos */ { "Locomotives", "Lokomotiven", "Locomotoras" },
/* TextLogLevel */ { "Log level", "Log Level", "Nivel de registro" },
/* TextLongestUnused */ { "Longest unused", "Am längsten ungenutzt", "El más largo sin usar" },
/* TextLookingForDestination */ {"Looking for new destination starting from {0}", "Suche von {0} aus neues Ziel", "Buscando nuevo destino deste {0}" },
/* TextMaerklinLeft */ { "Märklin DSS left", "Märklin DKW links", "Märklin DCD izquierda" },
/* TextMaerklinMotorola */ { "Märklin Motorola", "Märklin Motorola", "Märklin Motorola" },
/* TextMaerklinRight */ { "Märklin DSS right", "Märklin DKW rechts", "Märklin DCD derecha" },
/* TextManager */ { "Manager", "Manager", "Manager" },
/* TextMaxSpeed */ { "Maximum speed", "Maximale Geschwindigkeit", "Velocidad máxima" },
/* TextMaxTrainLength */ { "Maximal train length", "Maximale Zuglänge", "Longitud de tren maxima" },
/* TextMembers */ { "Members", "Teilnehmer", "Miembros" },
/* TextMethodNotImplemented */ { "Method {0} not implemented", "Methode {0} nicht implementiert", "Methodo {0} no implementado" },
/* TextMinTrackLength */ { "Minimal track length", "Kürzestes Gleis", "Vía más corta" },
/* TextMinTrainLength */ { "Minimal train length", "Minimale Zuglänge", "Longitud de tren minima" },
/* TextMultipleUnit */ { "Multiple unit", "Mehrfachtraktion", "Unidad múltiple" },
/* TextMultipleUnitDeleted */ { "Multiple unit {0} deleted", "Mehrfachtraktion {0} gelöscht", "Unidad múltiple {0} eliminado" },
/* TextMultipleUnitDoesNotExist */ { "Multiple unit does not exist", "Mehrfachtraktion existiert nicht", "Unidad múltiple no existe" },
/* TextMultipleUnitIsInUse */ { "Multiple unit {0} is in use", "Mehrfrachtraktion {0} ist in Gebrauch", "Unidad múltiple {0} está en uso" },
/* TextMultipleUnitSaved */ { "Multiple unit {0} saved", "Mehrfachtraktion {0} gespeichert", "Unidad múltiple {0} guardado" },
/* TextMultipleUnits */ { "Multiple units", "Mehrfachtraktionen", "Unidades múltiples" },
/* TextMyUidHash */ { "My UID: {0}; My CAN hash: {1}", "Meine UID: {0}; Mein CAN hash: {1}", "Mi UID: {0}; Mi CAN hash: {1}" },
/* TextName */ { "Name", "Name", "Nombre" },
/* TextNameInControl */ { "Name in control's database", "Name in der Datenbank der Zentrale", "Nombre en el control" },
/* TextNetworkUnreachable */ { "Network of {0}:{1} unreachable", "Netzwerk von {0}:{1} nicht erreichbar", "Red de {0}:{1} inaccesible" },
/* TextNew */ { "New", "Neu", "Nuevo" },
/* TextNoAnswerFromDecoder */ { "No answer from decoder", "Keine Antwort vom Decoder", "Ninguna respuesta del decoder" },
/* TextNoControlSupportsProgramming */ { "No control supports decoder programming", "Keine Zentrale unterstützt die Decoder-Programmierung", "Ningun control está soportando la programación de decoders" },
/* TextNoPushPull */ { "no push-pull trains", "keine Wendezüge", "ningunos push-pull trenes" },
/* TextNoRotation */ { "No rotation", "Keine Drehung", "Ninguna rotación" },
/* TextNoS88Modules */ { "No S88 modules configured", "Keine S88 Module konfiguriert", "No hay módulos S88 configurado" },
/* TextNoValidRouteFound */ { "No valid route found", "Keine Fahrstrasse gefunden", "Ningun itinerario encontrado" },
/* TextNoValidTimetableEntryFound */ { "No valid timetable entry found", "Kein Fahrplaneintrag gefunden", "Ninguna entrada encontrado en el horario" },
/* TextNone */ { "none", "keine", "ningun" },
/* TextNotImplemented */ { "Not implemented at {0}:{1}", "Nicht implementiert bei {0}:{1}", "No implementado a {0}:{1}" },
/* TextNrOfFunctions */ { "Number of functions", "Anzahl der Funktionen", "Número de funciones" },
/* TextNrOfS88Modules */ { "# of S88 Modules (8 port)", "Anzahl S88 Module (8 Pin)", "Número de módulos S88 (8 contactos)" },
/* TextNrOfS88ModulesConfigured */ { "{0} S88 Modules (8 port)", "{0} S88 Module (8 Pin)", "{0} módulos S88 (8 contactos)" },
/* TextNrOfS88ModulesOnBus */ { "{0} S88 Modules (8 port) on bus {1}", "{0} S88 Module (8 Pin) an Bus {1}", "{0} módulos S88 (8 contactos) en bus {1}" },
/* TextNrOfTracksToReserve */ { "# of Tracks to reserve", "Anzahl der zu reservierenden Gleise", "Reservar numero de vías" },
/* TextObjectIsUsedByRoute */ { "Object {0} is used by route {1}", "Objekt {0} wird von Fahrstrasse {1} benutzt", "Objeto {0} está utilizado por itinerario {1}" },
/* TextOff */ { "off", "aus", "apagado" },
/* TextOn */ { "on", "ein", "encendido" },
/* TextOpeningSQLite */ { "Opening SQLite database with filename {0}", "Öffne SQLite Datenbank mit Dateiname {0}", "Abriendo base de datos SQLite con nombre {0}" },
/* TextOrientation */ { "Orientation", "Ausrichtung", "Orientación" },
/* TextOverrunAt */ { "Overrun at", "Überfahrt bei", "Pasar a" },
/* TextParameterFoundInConfigFile */ { "Parameter found in config file: {0} = {1}", "Parameter gefunden in Konfigurationsdate: {0} = {1}", "Parametro encontrado en fila de configuración: {0} = {1}" },
/* TextPause */ { "Pause", "Pause", "Pausa" },
/* TextPin */ { "Pin", "Anschluss", "Contacto" },
/* TextPleaseSelectLoco */ { "Please select a locomotive", "Bitte eine Lokomotive wählen", "Por favor selecciona una locomotora" },
/* TextPosX */ { "Position X", "Position X", "Posición X" },
/* TextPosY */ { "Position Y", "Position Y", "Posición Y" },
/* TextPosZ */ { "Layer", "Schicht", "Capa" },
/* TextPosition */ { "Position", "Position", "Posición" },
/* TextPositionAlreadyInUse */ { "Position {0}/{1}/{2} is already used by {3} \"{4}\".", "Position {0}/{1}/{2} wird bereits verwendet von {3} \"{4}\".", "Positión {0}/{1}/{2} es usado por {3} \"{4}\"." },
/* TextProgramDccDirectRead */ { "Reading DCC CV {0} on programming track in direct mode", "Lese DCC CV {0} auf dem Programmiergleis im Direct Mode", "Leyendo DCC CV {0} en la vía de programación en modo directo" },
/* TextProgramDccDirectWrite */ { "Programming DCC CV {0} to value {1} on programming track in direct mode", "Programmiere DCC CV {0} auf Wert {1} auf dem Programmiergleis im Direct Mode", "Programando DCC CV {0} al valor {1} en modo directo" },
/* TextProgramDccPageRead */ { "Reading DCC CV {0} on programming track in page mode", "Lese DCC CV {0} auf dem Programmiergleis im Page Mode", "Leyendo DCC CV {0} en la vía de programación en modo pagina" },
/* TextProgramDccPageWrite */ { "Programming DCC CV {0} to value {1} on programming track in page mode", "Programmiere DCC CV {0} auf Wert {1} auf dem Programmiergleis im Page Mode", "Programando DCC CV {0} al valor {1} en la vía de programación en modo pagina" },
/* TextProgramDccPomAccessoryRead */ { "Reading DCC CV {1} of accessory with address {0} on main", "Lese DCC CV {1} des Zubehörartikels mit Adresse {0} auf dem Hauptgleis", "Leyendo DCC CV {1} del acessorio con dirección {0} en vía principal" },
/* TextProgramDccPomAccessoryWrite */ { "Programming DCC CV {1} of accessory with address {0} on main to value {2}", "Programmiere DCC CV {1} auf Wert {2} des Zubehörartikels mit Adresse {0} auf dem Hauptgleis", "Escribiendo DCC CV {1} al valor {2} del acessorio con dirección {0} en vía principal" },
/* TextProgramDccPomLocoRead */ { "Reading DCC CV {1} of locomotive with address {0} on main", "Lese DCC CV {1} der Lokomotive mit Adresse {0} auf dem Hauptgleis", "Leyendo DCC CV {1} de la locomotora con dirección {0} en vía principal" },
/* TextProgramDccPomLocoWrite */ { "Programming DCC CV {1} to value {2} of locomotive with address {0} on main", "Programmiere DCC CV {1} auf Wert {2} der Lokomotive mit Adresse {0} auf dem Hauptgleis", "Escribiendo DCC CV {1} al valor {2} de la locomotora con dirección {0} en vía principal" },
/* TextProgramDccRegisterRead */ { "Reading DCC CV {0} on programming track in register mode", "Lese DCC CV {0} auf dem Programmiergleis im Register Mode", "Leyendo DCC CV {0} en la vía de programación en modo registro" },
/* TextProgramDccRegisterWrite */ { "Programming DCC CV {0} to value {1} on programming track in register mode", "Programmiere DCC CV {0} auf Wert {1} auf dem Programmiergleis im Register Mode", "Programando DCC CV {0} al valor {1} en la vía de programación en modo registro" },
/* TextProgramMfxRead */ { "Reading mfx CV {1} of locomotive with address {0}", "Lese mfx CV {1} der Lokomotive mit Adresse {0}", "Leyendo mfx CV {0} de la locomotora con dirección {0}" },
/* TextProgramMfxWrite */ { "Writing mfx CV {1} to value {2} of locomotive with address {0}", "Schreibe mfx CV {1} auf Wert {2} der Lokomotive mit Adresse {0}", "Escribiendo mfx CV {0} al valor {2} de la locomotora con dirección {0} en la vía de programación" },
/* TextProgramMm */ { "Programming Märklin Motorola variable {0} to value {1} on programming track", "Programmiere Märklin Motorola Variable {0} auf Wert {1} auf dem Programmiergleis", "Programando Märklin Motorol variable {0} al valor {1} en la vía de programación" },
/* TextProgramMmPom */ { "Programming Märklin Motorola variable {1} to value {2} of locomotive with address {0} on main", "Programmiere Märklin Motorola Variable {1} auf Wert {2} der Lokomotive mit Adresse {0} auf dem Hauptgleis", "Programando Märklin Motorol variable {1} al valor {2} de la locomotora con dirección {0} en vía principal" },
/* TextProgramMode */ { "Mode", "Modus", "Modo" },
/* TextProgramModeDccDirect */ { "DCC direct (program track, all decoders)", "DCC direkt (Programmiergleis, alle Decoder)", "DCC directo (vía de programación, todos los decoders)" },
/* TextProgramModeDccPage */ { "DCC page (program track, all decoders)", "DCC Seite (Programmiergleis, alle Decoder)", "DCC pagina (vía de programación, todos los decoders)" },
/* TextProgramModeDccPomAccessory */ { "DCC POM accessory (main track)", "DCC POM Zubehörartikel (Hauptgleis)", "DCC POM accesorio (vía principal)" },
/* TextProgramModeDccPomLoco */ { "DCC POM locomotive (main track)", "DCC POM Lokomotive (Hauptgleis)", "DCC POM locomotora (vía principal)" },
/* TextProgramModeDccRegister */ { "DCC register (program track, all decoders)", "DCC Register (Programmiergleis, alle Decoder)", "DCC registro (vía de programación, todos los decoders)" },
/* TextProgramModeMfx */ { "Märklin mfx (program and main track)", "Märklin mfx (Programmier- und Hauptgleis)", "Märklin mfx (vía de programación y principal)" },
/* TextProgramModeMm */ { "Märklin Motorola (program track, all decoders)", "Märklin Motorola (Programmiergleis, alle Decoder)", "Märklin Motorola (vía de programación, todos los decoders)" },
/* TextProgramModeMmPom */ { "Märklin Motorola POM (main track)", "Märklin Motorola POM (Hauptgleis)", "Märklin Motorola POM (vía principal)" },
/* TextProgramReadValue */ { "CV {0} has value {1}", "CV {0} hat den Wert {1}", "CV {0} tiene valor {1}" },
/* TextProgrammer */ { "Programmer", "Programmierer", "Programador" },
/* TextProgrammingMode */ { "Programming mode", "Programmiermodus", "Modo programador" },
/* TextPropulsion */ { "Propulsion", "Antrieb", "Propulsión" },
/* TextPropulsionAccu */ { "Accu", "Akku", "Acumulador" },
/* TextPropulsionAll */ { "All propulsions", "Alle Antriebe", "Todas las propulsiones" },
/* TextPropulsionDiesel */ { "Diesel", "Diesel", "Diesel" },
/* TextPropulsionElectric */ { "Electric", "Elektrisch", "Electrico" },
/* TextPropulsionGas */ { "Gas", "Gas", "Gas" },
/* TextPropulsionHydrogen */ { "Hydrogen", "Wasserstoff", "Hidrógeno" },
/* TextPropulsionOther */ { "Other propulsion", "Anderer Antrieb", "Otra propulsión" },
/* TextPropulsionSteam */ { "Steam", "Dampf", "Vapor" },
/* TextPropulsionUnknown */ { "Unknown propulsion", "Unbekannter Antrieb", "Propulsión desconocida" },
/* TextProtocol */ { "Protocol", "Protokoll", "Protocolo" },
/* TextProtocolNotSupported */ { "Protocol {0} is not supported by control. Please use one of: {1}", "Protokoll {0} wird nicht unterstützt von der Zentrale. Verwende eines aus {1}", "Protocolo {0} no está compatible con ese control. Utilisa uno de {1}" },
/* TextPushPullOnly */ { "push-pull trains only", "nur Wendezüge", "solamente push-pull trenes" },
/* TextPushPullTrain */ { "Push-Pull train", "Wendezug", "Tren push-pull" },
/* TextQuery */ { "Query: {0}", "Abfrage: {0}", "Consulta: {0}" },
/* TextQueryAffected */ { "Query: {0} Rows affected {1}", "Abfrage: {0} Geänderte Datensätze: {1}", "Consulta: {0} Líneas afectados: {1}" },
/* TextRailControlStarted */ { "RailControl started", "RailControl wurde gestartet", "RailControl encendido" },
/* TextRailControlUpdateAvailable */ { "A new version of RailControl is available", "Eine neue Version von RailControl ist verfügbar", "Una nueva versión de RailControl es disponible" },
/* TextRandom */ { "Random", "Zufall", "Aleatorio" },
/* TextReachedItsDestination */ { "Reached its destination", "Erreichte ihr Ziel", "Llegó a su destino" },
/* TextRead */ { "read", "lesen", "leer" },
/* TextReadingConfigFile */ { "Reading config file {0}", "Lese Konfigurationsdatei {0}", "Leyendo fila de configuración {0}" },
/* TextReceivedAccessoryCommand */ { "Received command for accessory {0}/{1}: {2}", "Zubehörartikelkommando empfangen {0}/{1}: {2}", "Recibido comando para accesorio {0}/{1}: {2}" },
/* TextReceivedDirectionCommand */ { "Received direction command for locomotive {0}/{1}: {2}", "Richtungskommando empfangen für Lokomotive {0}/{1}: {2}", "Recibido comando de direccion para locomotora {0}/{1}: {2}" },
/* TextReceivedFunctionCommand */ { "Received function command for locomotive {0}/{1} and function {2}: {3}", "Funktionskommando empfangen für Lokomotive {0}/{1} und Funktion {2}: {3}", "Recibido comando de funcciona para locomotora {0}/{1} y funcciona {2}: {3}" },
/* TextReceivedSignalKill */ { "Received a signal kill {0} times. Exiting without saving.", "Signal Kill {0} mal erhalten. Beende RailControl ohne zu speichern.", "Señal Kill recibido {0} veces. Apagando RailControl sin guardar." },
/* TextReceivedSpeedCommand */ { "Received speed command for locomotive {0}/{1}: {2}", "Geschwindigkeitskommando empfangen für Lokomotive {0}/{1}: {2}", "Recibido comando de velocidad para locomotora {0}/{1}: {2}" },
/* TextReceiverThreadStarted */ { "Receiver thread started", "Empfangs-Thread gestartet", "Thread recibiendo creado" },
/* TextRed */ { "red", "rot", "rojo" },
/* TextReducedSpeed */ { "Reduced speed", "Reduzierte Geschwindigkeit", "Velocidad reducido" },
/* TextReducedSpeedAt */ { "Reduce speed at", "Reduziere Geschwindigkeit bei", "Reducir velocidad a" },
/* TextRegister */ { "Register", "Register", "Registro" },
/* TextRelationTargetNotFound */ { "Relation target not found", "Ziel der Relation nicht gefunden", "Relación no encontrado" },
/* TextRelease */ { "Release", "Freigeben", "Liberar" },
/* TextReleaseAccessory */ { "Release accessory", "Zubehörartikel freigeben", "Liberar accesorio" },
/* TextReleaseLoco */ { "Release locomotive", "Lokomotive freigeben", "Liberar locomotora" },
/* TextReleaseRoute */ { "Release route", "Fahrstrasse freigeben", "Liberar itinerario" },
/* TextReleaseSignal */ { "Release signal", "Signal freigeben", "Liberar señal" },
/* TextReleaseSwitch */ { "Release switch", "Weiche freigeben", "Liberar desvío" },
/* TextReleaseTrack */ { "Release track", "Gleis freigeben", "Liberar vía" },
/* TextReleaseTrackAndLoco */ { "Release track and locomotive", "Gleis und Lokomotive freigeben", "Liberar vía y locomotora" },
/* TextReleaseWhenFree */ { "Release when free", "Freigeben wenn nicht besetzt", "Liberar si no está ocupado" },
/* TextReleasingLoco */ { "Releasing locomotive", "Lokomotive wird freigeben", "Liberando locomotora" },
/* TextReleasingMultipleUnit */ { "Releasing multiple unit", "Mehrfachtraktion wird freigeben", "Liberando unidad múltiple" },
/* TextRemoveBackupFile */ { "Removing backup file {0}", "Lösche Sicherungskopie {0}", "Eliminando copia de respaldo {0}" },
/* TextRenamingFromTo */ { "Renaming from {0} to {1}", "Benenne von {0} nach {1} um", "Renombrando de {0} a {1}" },
/* TextRestarting */ { "Restarting", "Neustart", "Reiniciando" },
/* TextRight */ { "right", "rechts", "derecha" },
/* TextRotation */ { "Rotation", "Drehung", "Rotación", },
/* TextRoute*/ { "route", "Fahrstrasse", "itinerario" },
/* TextRouteDeleted */ { "Route {0} deleted", "Fahrstrasse {0} gelöscht", "Itinerario {0} eliminado" },
/* TextRouteDoesNotExist */ { "Route does not exist", "Fahrstrasse existiert nicht", "Itinerario no existe" },
/* TextRouteIsInUse */ { "Route {0} is in use", "Fahrstrasse {0} ist in Gebrauch", "Itinerario {0} está en uso" },
/* TextRouteIsLocked */ { "Route {0} is locked", "Fahrstrasse {0} ist gesperrt", "Itinerario {0} está bloqueado" },
/* TextRouteIsReleased */ { "Route {0} is released", "Fahrstrasse {0} ist freigegeben", "Itinerario {0} está desbloqueado" },
/* TextRouteIsUsedByRoute */ { "Route {0} is used by route {1}", "Fahrstrasse {0} wird von Fahrstrasse {1} benutzt", "Itinerario {0} está utilizado por itinerario {1}" },
/* TextRouteSaved */ { "Route {0} saved", "Fahrstrasse {0} gespeichert", "Itinerario {0} guardado" },
/* TextRouteUpdated */ { "Route {0} updated", "Fahrstrasse {0} aktualisiert", "Itinerario {0} actualizado" },
/* TextRoutes */ { "Routes", "Fahrstrassen", "Itinerarios" },
/* TextSQLiteErrorQuery */ { "SQLite error: {0} Query: {1}", "SQLite Fehler: {0} Query: {1}", "Error de SQLite: {0} Query: {1}" },
/* TextSaving */ { "Saving {0}", "Speichere {0}", "Guardando {0}" },
/* TextSelectLocoForTrack */ {"Select locomotive for track {0}", "Wähle Lokomotive für Gleis {0}", "Selectione locomotora para vía {0}" },
/* TextSelectRouteBy */ { "Select route by", "Wähle die Fahrstrasse nach", "Selecctionar itinerario por" },
/* TextSenderSocketCreated */ { "Sender socket created", "Sender socket erstellt", "Socket para enviar datos creado" },
/* TextSenderThreadStarted */ { "Sender thread started", "Sender Thread gestartet", "Thread enviador creado" },
/* TextSeparator */ { "<hr>", "<hr>", "<hr>" },
/* TextSerialNumberIs */ { "Serialnumber is {0}", "Seriennummer ist {0}", "Número de serie es {0}" },
/* TextSerialPort */ { "Serial port", "Serieller Anschluss", "Puerto serie" },
/* TextSetAllLocosToAutomode */ { "Set all locomotives to automode", "Versetze alle Lokomotiven in den Automatikmodus", "Poner todas las locomotora en modo automatico" },
/* TextSetAllLocosToManualMode */ { "Set all locomotives to manual mode", "Versetze alle Lokomotiven in den manuellen Modus", "Poner todas las locomotora en modo manual" },
/* TextSetLoco */ { "Set locomotive", "Setze Lokomotive", "Poner locomotora sobre vía" },
/* TextSettingAccessory */ { "Setting accessory {0} to {1}", "Setze Zubehörartikel {0} auf {1}", "Ajusto accesorio {0} a {1}" },
/* TextSettingAccessoryOnOff */ { "Setting accessory {0}/{1} to {2}", "Setze Zubehörartikel {0}/{1} auf {2}", "Ajusto accesorio {0}/{1} a {2}" },
/* TextSettingAccessoryWithProtocol */ { "Setting accessory {0}/{1}/{2} to {3}", "Setze Zubehörartikel {0}/{1}/{2} auf {3}", "Ajusto accesorio {0}/{1}/{2} a {3}" },
/* TextSettingDirectionOfTravel */ { "Changing direction of travel of locomotive {0}", "Wechsle die Fahrtrichtung der Lokomotive {0}", "Cambio la direccion de viaje de la locomotora {0}" },
/* TextSettingDirectionOfTravelWithProtocol */ { "Setting locomotive {0}/{1} to direction of travel {2}", "Setze Lokomotive {0}/{1} in Rahrtrichtung {2}", "Ajusto la direccion de viaje de la locomotora {0}/{1} a {2}" },
/* TextSettingFunction */ { "Setting function {0} of locomotive {1} to {2}", "Setze Funktion {0} der Lokomotive {1} auf {2}", "Ajusto la function {0} de la locomotora {1} a {2}" },
/* TextSettingFunctionWithProtocol */ { "Setting function {0} of locomotive {1}/{2} to {3}", "Setze Funktion {0} der Lokomotive {1}/{2} auf {3}", "Ajusto la function {0} de la locomotora {1}/{2} a {3}" },
/* TextSettingFunctions17_28 */ { "Setting functions 17-28 of locomotive {0} to {1} and {2}", "Setze Funktionen 17-28 der Lokomotive {0} auf {1} und {2}", "Ajusto las functionas 17-28 de la locomotora {0} a {1} y {2}" },
/* TextSettingFunctions1_8 */ { "Setting functions 1-8 of locomotive {0} to {1}", "Setze Funktionen 1-8 der Lokomotive {0} auf {1}", "Ajusto las functionas 1-8 de la locomotora {0} a {1}" },
/* TextSettingFunctions9_16 */ { "Setting functions 9-16 of locomotive {0} to {1}", "Setze Funktionen 9-16 der Lokomotive {0} auf {1}", "Ajusto las functionas 9-16 de la locomotora {0} a {1}" },
/* TextSettingOrientation */ { "Setting locomotive {0} orientation {1}", "Setze Richtung {1} der Lokomotive {0}", "Ajusto orientación a {1} de la locomotora {0}" },
/* TextSettingSpeed */ { "Setting locomotive {0} to speed {1}", "Setze Lokomotive {0} auf Geschwindigkeit {1}", "Ajusto la velocidad de la locomotora {0} a {1}" },
/* TextSettingSpeedOrientationLight */ { "Setting locomotive {0} to speed {1} and direction {2} and light {3}", "Setze Geschwindigkeit {1}, Richtung {2} und Licht {3} der Lokomotive {0}", "Ajusto velocidad a {1}, orientación {2} y luz {3} de la locomotora {0}" },
/* TextSettingSpeedWithProtocol */ { "Setting locomotive {0}/{1} to speed {2}", "Setze Lokomotive {0}/{1} auf Geschwindigkeit {2}", "Ajusto la velocidad de la locomotora {0}/{1} a {2}" },
/* TextSettings */ { "Settings", "Einstellungen", "Opciones" },
/* TextSettingsSaved */ { "Settings saved", "Einstellungen gespeichert", "Opciones guardado" },
/* TextSeveral */ { "several", "mehrere", "varios" },
/* TextShortCircuit */ { "Short circuit", "Kurzschluss", "Cortocircuit" },
/* TextShowName */ { "Show name", "Name sichtbar", "Nombre visible" },
/* TextSignal*/ { "signal ", "Signal", "señal" },
/* TextSignalDeleted */ { "Signal {0} deleted", "Signal {0} gelöscht", "Señal {0} eliminado" },
/* TextSignalDoesNotExist */ { "Signal does not exist", "Signal existiert nicht", "Señal no existe" },
/* TextSignalHasAssociatedFeedback */ { "Signal {0} has associated feedback {1}", "Signal {0} hat verknüpften Rückmelder {1}", "Señal {0} tiene enlaze a retroseñal {1}" },
/* TextSignalIsLocked */ { "Signal {0} is locked", "Signal {0} ist gesperrt", "Señal {0} está bloqueado" },
/* TextSignalIsUsedByLoco */ { "Signal {0} is used by locomotive {1}", "Signal {0} wird von Lokomotive {1} benutzt", "Señal {0} está utilizado por locomotora {1}" },
/* TextSignalIsUsedByRoute */ { "Signal {0} is used by route {1}", "Signal {0} wird von Fahrstrasse {1} benutzt", "Señal {0} está utilizado por itinerario {1}" },
/* TextSignalIsUsedByTrack */ { "Signal {0} is used by track {1}", "Signal {0} wird von Gleis {1} benutzt", "Señal {0} está utilizado por vía {1}" },
/* TextSignalSaved */ { "Signal {0} saved", "Signale {0} gespeichert", "Señal {0} guardado" },
/* TextSignalStateCaution */ { "Caution", "Vorsicht", "Cuidado" },
/* TextSignalStateClear */ { "Clear", "Fahrt", "Vía libre" },
/* TextSignalStateClear40 */ { "Clear 40 km/h", "Fahrt 40 km/h", "Vía libre 40 km/h" },
/* TextSignalStateClear60 */ { "Clear 60 km/h", "Fahrt 60 km/h", "Vía libre 60 km/h" },
/* TextSignalStateClear90 */ { "Clear 90 km/h", "Fahrt 90 km/h", "Vía libre 90 km/h" },
/* TextSignalStateDark */ { "Dark", "Dunkel", "Oscuro" },
/* TextSignalStateIsAspect10 */ { "Signal {0} shows aspect 10", "Signal {0} zeigt Fahrtbegriff 10", "Señal {0} muestra aspecto 10" },
/* TextSignalStateIsAspect2 */ { "Signal {0} shows aspect 2", "Signal {0} zeigt Fahrtbegriff 2", "Señal {0} muestra aspecto 2" },
/* TextSignalStateIsAspect3 */ { "Signal {0} shows aspect 3", "Signal {0} zeigt Fahrtbegriff 3", "Señal {0} muestra aspecto 3" },
/* TextSignalStateIsAspect4 */ { "Signal {0} shows aspect 4", "Signal {0} zeigt Fahrtbegriff 4", "Señal {0} muestra aspecto 4" },
/* TextSignalStateIsAspect5 */ { "Signal {0} shows aspect 5", "Signal {0} zeigt Fahrtbegriff 5", "Señal {0} muestra aspecto 5" },
/* TextSignalStateIsAspect6 */ { "Signal {0} shows aspect 6", "Signal {0} zeigt Fahrtbegriff 6", "Señal {0} muestra aspecto 6" },
/* TextSignalStateIsAspect7 */ { "Signal {0} shows aspect 7", "Signal {0} zeigt Fahrtbegriff 7", "Señal {0} muestra aspecto 7" },
/* TextSignalStateIsAspect8 */ { "Signal {0} shows aspect 8", "Signal {0} zeigt Fahrtbegriff 8", "Señal {0} muestra aspecto 8" },
/* TextSignalStateIsAspect9 */ { "Signal {0} shows aspect 9", "Signal {0} zeigt Fahrtbegriff 9", "Señal {0} muestra aspecto 9" },
/* TextSignalStateIsClear */ { "Signal {0} shows clear", "Signal {0} zeigt Fahrt", "Señal {0} muestra vía libre" },
/* TextSignalStateIsDark */ { "Signal {0} is dark", "Signal {0} ist dunkel", "Señal {0} está oscura" },
/* TextSignalStateIsStop */ { "Signal {0} shows stop", "Signal {0} zeigt Halt", "Señal {0} muestra parada" },
/* TextSignalStateIsStopExpected */ { "Signal {0} shows stop expected", "Signal {0} zeigt Halt erwarten", "Señal {0} muestra parada esperado" },
/* TextSignalStateShortClear */ { "Short Clear", "Kurze Fahrt", "Vía libre corta" },
/* TextSignalStateShunting */ { "Shunting", "Rangieren", "Maniobra" },
/* TextSignalStateStop */ { "Stop", "Halt", "Parada" },
/* TextSignalStateStopExpected */ { "Stop expected", "Halt erwarten", "Parada esperada" },
/* TextSignalStateZs7 */ { "Caution Zs 7", "Vorsichtssignal Zs 7", "Cuidado Zs 7" },
/* TextSignalUpdated */ { "Signal {0} updated", "Signal {0} aktualisiert", "Señal {0} actualizado" },
/* TextSignals */ { "Signals", "Signale", "Señales" },
/* TextSimpleLeft */ { "simple left", "einfach links", "simple izquierda" },
/* TextSimpleRight */ { "simple right", "einfach rechts", "simple derecha" },
/* TextSlotHasAddress */ { "Slot {0} has address {1}", "Slot {0} hat Adresse {1}", "Slot {0} tiene dirección {1}" },
/* TextSpanish */ { "Spanish", "Spanisch", "Español" },
/* TextSpeed */ { "Speed", "Geschwindigkeit", "Velocidad" },
/* TextStartArgument */ { "Start argument: {0}", "Startargument: {0}", "Argumento de inicio: {0}" },
/* TextStartLocoAutomode */ { "Start locomotive in automode", "Starte Lokomotive im Automodus", "Poner locomotora en marcha en autómodo" },
/* TextStartLocoTimetablemode */ { "Start locomotive in timetable mode", "Starte Lokomotive im Fahrplanmodus", "Poner locomotora en marcha en modo horario" },
/* TextStartTrack */ { "Start track", "Startgleis", "Vía de inicio" },
/* TextStarting */ { "Starting {0}", "Starte {0}", "Encendiendo {0}" },
/* TextStopAllLocos */ { "Stop all locomotives", "Stoppe alle Lokomotiven", "Detener todas las locomotoras" },
/* TextStopAt */ { "Stop at", "Anhalten bei", "Parar a" },
/* TextStopLoco */ { "Stop locomotive", "Stoppe Lokomotive", "Parar locomotora" },
/* TextStopOnFeedbackInFreeTrack */ { "Turn off current on feedback in free track", "Schalte Strom aus bei Rückmelder in freiem Gleis", "Apagar la corriente en una retroseñal en una vía libre" },
/* TextStoppingRailControl */ { "Stopping RailControl", "Beende RailControl", "Apagando RailControl" },
/* TextStoppingRequestedBySignal */ { "Stopping RailControl requested by signal {0}", "Beenden von RailControl angefordert mit Signal {0}", "Apagar RailControl pedido con señal {0}" },
/* TextStoppingRequestedByWebClient */ { "Stopping RailControl requested by webclient", "Beenden von RailControl angefordert von Webclient", "Apagar RailControl pedido del webclient" },
/* TextStraight */ { "straight", "gerade", "recto" },
/* TextSwitch*/ { "switch", "Weiche", "desvío" },
/* TextSwitchDeleted */ { "Switch {0} deleted", "Weiche {0} gelöscht", "Desvío {0} eliminado" },
/* TextSwitchDoesNotExist */ { "Switch does not exist", "Weiche existiert nicht", "Desvío no existe" },
/* TextSwitchIsLocked */ { "Switch {0} is locked", "Weiche {0} ist gesperrt", "Desvío {0} está bloqueado" },
/* TextSwitchIsUsedByRoute */ { "Switch {0} is used by route {1}", "Weiche {0} wird von Fahrstrasse {1} benutzt", "Desvío {0} está utilizado por itinerario {1}" },
/* TextSwitchSaved */ { "Switch {0} saved", "Weiche {0} gespeichert", "Desvío {0} guardado" },
/* TextSwitchStateIsStraight */ { "Switch {0} is straight", "Weiche {0} ist geradeaus", "Desvío {0} está directo" },
/* TextSwitchStateIsThird */ { "Switch {0} is third way", "Weiche {0} ist drittes Gleis", "Desvío {0} está tercer vía" },
/* TextSwitchStateIsTurnout */ { "Switch {0} is turnout", "Weiche {0} ist ablenkend", "Desvío {0} está desviado" },
/* TextSwitchStateLeft */ { "Left", "Links", "Izquierda" },
/* TextSwitchStateRight */ { "Right", "Rechts", "Derecha" },
/* TextSwitchStateStraight */ { "Straight", "Geradeaus", "Directo" },
/* TextSwitchUpdated */ { "Switch {0} updated", "Weiche {0} aktualisiert", "Desvío {0} actualizado" },
/* TextSwitches */ { "Switches", "Weichen", "Desvíos" },
/* TextSystemDefault */ { "System setting", "Systemeinstellung", "Configuración del sistema" },
/* TextTcpConnectionClosed */ { "TCP connection to {0} closed", "TCP Verbindung zu {0} geschlossen", "Connectión TCP a {0} cerrado" },
/* TextTcpConnectionEstablished */ { "TCP connection to {0} established", "TCP Verbindung zu {0} hergestellt", "Connectión TCP a {0} establecido" },
/* TextTerminatingAccessorySenderThread */ { "Terminating accessory sender thread", "Beende Zubehörartikel Sender Thread", "Apagando thread enviador accesorio" },
/* TextTerminatingHeartBeatThread */ { "Terminating heartbeat thread", "Beende Heartbeat-Thread", "Apagando thread heartbeat" },
/* TextTerminatingReceiverThread */ { "Terminating receiver thread", "Beende Empfangs-Thread", "Apagando thread recibiendo" },
/* TextTerminatingSenderSocket */ { "Terminating sender socket", "Beende Sende Socket", "Apagando socket enviando" },
/* TextTerminatingSenderThread */ { "Terminating sender thread", "Beende Sende-Thread", "Apagando thread enviando" },
/* TextText */ { "text", "Text", "texto" },
/* TextTextDeleted */ { "Text {0} deleted", "Text {0} gelöscht", "Texto {0} eliminado" },
/* TextTextDoesNotExist */ { "Text does not exist", "Text existiert nicht", "texto no existe" },
/* TextTextSaved */ { "Text {0} saved", "Text {0} gespeichert", "Texto {0} guardado" },
/* TextTextUpdated */ { "Text {0} updated", "Text {0} aktualisiert", "Texto {0} actualizado" },
/* TextTexts */ { "Texts", "Texte", "Textos" },
/* TextThreeWay */ { "three way", "Dreiweg", "tres vías" },
/* TextTimestampAlreadySet */ { "Timestamp already set", "Zeit schon gesetzt", "Hora ya ajustado" },
/* TextTimestampNotSet */ { "Timestamp not set", "Zeit nicht gesetzt", "Hora no ajustado" },
/* TextTimestampSet */ { "Timestamp set", "Zeit gesetzt", "Hora ajustado" },
/* TextTooManyS88Modules */ { "Too many S88 modules configured: {0}. Max is {1}", "Zu viele S88 Module konfiguriert: {0}. Maximum ist {1}", "Demasiado módulos S88 configurado: {0}. El maximo es {1}" },
/* TextTrack */ { "track", "Gleis", "vía" },
/* TextTrackDeleted */ { "Track {0} deleted", "Gleis {0} gelöscht", "Vía {0} eliminado" },
/* TextTrackDoesNotExist */ { "Track does not exist", "Gleis existiert nicht", "Vía no existe" },
/* TextTrackHasAssociatedFeedback */ { "Track {0} has associated feedback {1}", "Gleis {0} hat verknüpften Rückmelder {1}", "Vía {0} tiene enlaze a retroseñal {1}" },
/* TextTrackIsUsedByLoco */ { "Track {0} is used by locomotive {1}", "Gleis {0} wird von Lokomotive {1} benutzt", "Vía {0} está utilizado por locomotora {1}" },
/* TextTrackIsUsedByRoute */ { "Track {0} is used by route {1}", "Gleis {0} wird von Fahrstrasse {1} benutzt", "Vía {0} está utilizado por itinerario {1}" },
/* TextTrackSaved */ { "Track {0} saved", "Gleis {0} gespeichert", "Vía {0} guardado" },
/* TextTrackStatusIsBlocked */ { "{0} is blocked", "{0} ist blockiert", "{0} está bloqueado" },
/* TextTrackStatusIsBlockedAndOccupied */ { "{0} is blocked and occupied", "{0} ist blockiert und besetzt", "{0} está bloqueado y ocupado" },
/* TextTrackStatusIsBlockedAndReserved */ { "{0} is blocked and reserved by {1}", "{0} ist blockiert und reserviert von {1}", "{0} está bloqueado y reservado por {1}" },
/* TextTrackStatusIsFree */ { "{0} is free", "{0} ist frei", "{0} está libre" },
/* TextTrackStatusIsOccupied */ { "{0} is occupied", "{0} ist besetzt", "{0} está ocupada" },
/* TextTrackStatusIsReserved */ { "{0} is reserved by {1}", "{0} ist reserviert von {1}", "{0} está reservada por {1}" },
/* TextTrackUpdated */ { "Track {0} updated", "Gleis {0} aktualisiert", "Vía {0} actualizado" },
/* TextTracks */ { "Tracks", "Gleise", "Vías" },
/* TextTrainIsToLong */ { "Train is to long for route {0}", "Zug ist zu lang für die Fahrstrasse {0}", "El tren es demasiado largo para el itinerario {0}" },
/* TextTrainIsToShort */ { "Train is to short for route {0}", "Zug ist zu kurz für die Fahrstrasse {0}", "El tren es demasiado corto para el itinerario {0}" },
/* TextTrainLenght */ { "Train length", "Zuglänge", "Longitud de tren" },
/* TextTrainType */ { "Train type", "Zugtyp", "Tipo de tren" },
/* TextTrainTypeAll */ { "All train types", "Alle Zugtypen", "Todos tipos de trens" },
/* TextTrainTypeCargo */ { "All cargo trains", "Alle Güterzüge", "Todos tipos de carga" },
/* TextTrainTypeCargoBlock */ { "Cargo block train/unit train", "Blockzug/Ganzzug", "Tren bloque/tren completo (carga)" },
/* TextTrainTypeCargoExpress */ { "Express cargo train", "Express Güterzug", "Tren carga expreso" },
/* TextTrainTypeCargoLocal */ { "Local cargo train", "Lokaler Güterzug", "Tren carga local" },
/* TextTrainTypeCargoLongDistance */ { "Long distance cargo train", "Langdistanzgüterzug", "Tren carga de larga distancia" },
/* TextTrainTypeCargoTractor */ { "Tractor cargo train", "Güterzug mit Traktor", "Tren carga con tractor" },
/* TextTrainTypeCargoWithPassenger */ { "Cargo train with passenger", "Güterzug mit Personenbeförderung", "Tren carga con pasageros" },
/* TextTrainTypeCleaning */ { "Cleaning train", "Reinigungszug", "Tren de limpieza" },
/* TextTrainTypeConstruction */ { "Construction train", "Bauzug", "Tren de construcción" },
/* TextTrainTypeEmpty */ { "Empty train", "Leerzug", "Tren vacío" },
/* TextTrainTypeExtra */ { "Extra train", "Extrazug", "Tren extra" },
/* TextTrainTypeFastLocal */ { "Fast local train", "RegioExpress", "Tren local rápido" },
/* TextTrainTypeHistoric */ { "Historic train", "Historischer Zug", "Tren histórico" },
/* TextTrainTypeInternationalHighSpeed */ { "International high speed train", "Internat. Hochgeschwindigkeitszug", "Tren de alta velocidad internac." },
/* TextTrainTypeInternationalLongDistance */ { "International long distance train", "EuroCity", "Tren de larga distancia internac." },
/* TextTrainTypeInternationalNight */ { "International night train", "Internationaler Nachtzug", "Tren nocturo internacional" },
/* TextTrainTypeLocal */ { "Local train", "Regionalzug", "Tren local" },
/* TextTrainTypeLoco */ { "Locomotive train", "Lokzug", "Tren locomotora" },
/* TextTrainTypeLongDistanceFastLocal */ { "Long distance fast local train", "InterRegio", "Tren local rápido de larga dist." },
/* TextTrainTypeNationalHighSpeed */ { "National high speed train", "Nat. Hochgeschwindigkeitszug", "Tren de alta velocidad nacional" },
/* TextTrainTypeNationalLongDistance */ { "National long distance train", "InterCity", "Tren de larga distancia nacional" },
/* TextTrainTypeNationalNight */ { "National night train", "Nationaler Nachtzug", "Tren nocturo nacional" },
/* TextTrainTypeOther */ { "Other train type", "Anderer Zugtyp", "Otro tipo de tren" },
/* TextTrainTypePassenger */ { "All passenger trains", "Alle Personenzüge", "Todos tipos de personas" },
/* TextTrainTypePassengerWithCargo */ { "Passenger train with Cargo", "Personenzug mit Güterbeförderung", "Tren pasageros con carga" },
/* TextTrainTypeRescue */ { "Rescue train", "Lösch- oder Rettungszug", "Tren de rescate" },
/* TextTrainTypeSuburban */ { "Suburban train", "S-Bahn", "Tren suburbano" },
/* TextTrainTypeUnderground */ { "Underground", "U-Bahn", "Metro" },
/* TextTrainTypeUnknown */ { "Unknown train type", "Unbekannter Zugtyp", "Tipo de tren desconocido" },
/* TextTravelSpeed */ { "Travel speed", "Reisegeschwindigkeit", "Velocidad de viaje" },
/* TextTunnelOneSide */ { "Tunnel (one side)", "Tunnel (eine Seite)", "Túnel (un lado)" },
/* TextTunnelTwoSides */ { "Tunnel (two sides)", "Tunnel (zwei Seiten)", "Túnel (dos lados)" },
/* TextTurn */ { "turn", "gebogen", "curvo" },
/* TextTurnDirectionOfTravelToLeft */ { "Turn direction of travel to left", "Drehe Fahrtrichtung nach links", "Gire la dirección de viaje hacia la izquierda" },
/* TextTurnDirectionOfTravelToRight */ { "Turn direction of travel to right", "Drehe Fahrtrichtung nach rechts", "Gire la dirección de viaje hacia la dereja" },
/* TextTurningBoosterOff */ { "Turning booster off", "Deaktiviere Booster", "Apagando booster" },
/* TextTurningBoosterOn */ { "Turning booster on", "Aktiviere Booster", "Encendiendo booster" },
/* TextTurningBoosterOnOrOff */ { "Turning booster on or off", "Schalte Fahrstrom ein oder aus", "Encender o apagar la energiá" },
/* TextTurnout */ { "turnout", "abzweigend", "desviando" },
/* TextType */ { "Type", "Typ", "Typo" },
/* TextUdpConnectionClosed */ { "UDP connection to {0} closed", "UDP Verbindung zu {0} geschlossen", "Connectión UDP a {0} cerrado" },
/* TextUdpConnectionEstablished */ { "UDP connection to {0} established", "UDP Verbindung zu {0} hergestellt", "Connectión UDP a {0} establecido" },
/* TextUnableToAddAccessory */ { "Unable to add accessory", "Nicht möglich den Zubehörartikel hinzuzufügen ", "Imposible añadir el accesorio" },
/* TextUnableToAddCluster */ { "Unable to add cluster", "Nicht möglich die Gruppe hinzuzufügen ", "Imposible añadir el grupo" },
/* TextUnableToAddControl */ { "Unable to add control", "Nicht möglich die Zentrale hinzuzufügen ", "Imposible añadir el control" },
/* TextUnableToAddFeedback */ { "Unable to add feedback", "Nicht möglich den Rückmelder hinzuzufügen ", "Imposible añadir la retroseñal" },
/* TextUnableToAddLayer */ { "Unable to add layer", "Nicht möglich die Schicht hinzuzufügen ", "Imposible añadir la capa" },
/* TextUnableToAddLayer1 */ { "Unable to add initial layer 1", "Nicht möglich die Schicht 1 hinzuzufügen", "Imposible añadir capa 1" },
/* TextUnableToAddLoco */ { "Unable to add locomotive", "Nicht möglich die Lokomotive hinzuzufügen", "Impsible ańadir la locomotora" },
/* TextUnableToAddLocoToTrack */ { "Unable to add locomotive {0} to track {1}", "Nicht möglich die Lokomotive {0} auf Gleis {1} zu setzen", "Impsible poner la locomotora sobre vía {1}" },
/* TextUnableToAddMultipleUnit */ { "Unable to add multiple unit", "Nicht möglich die Mehrfachtraktion hinzuzufügen", "Impsible ańadir la unidad múltiple" },
/* TextUnableToAddRoute */ { "Unable to add route", "Nicht möglich die Fahrstrasse hinzuzufügen ", "Imposible añadir el itinerario" },
/* TextUnableToAddSignal */ { "Unable to add signal", "Nicht möglich das Signal hinzuzufügen ", "Imposible añadir la señal" },
/* TextUnableToAddSwitch */ { "Unable to add switch", "Nicht möglich die Weiche hinzuzufügen ", "Imposible añadir el desvío" },
/* TextUnableToAddText */ { "Unable to add text", "Nicht möglich den Text hinzuzufügen ", "Imposible añadir el texto" },
/* TextUnableToAddTrack */ { "Unable to add track", "Nicht möglich das Gleis hinzuzufügen ", "Imposible añadir la vía" },
/* TextUnableToBindSocketToPort */ { "Unable to bind connection to port {0}", "Binden der Verbindung an Port {0} fehlgeschlagen", "Imposible vincular la conexión al puerto {0}" },
/* TextUnableToBindUdpSocket */ { "Unable to bind UDP socket to address", "Nicht möglich den UDP socket an eine Adresse zu binden", "Imposible enlazar el UDP socket a la dirección" },
/* TextUnableToCalculatePosition */ { "Unable to calculate position", "Unmöglich die Position zu berechnen", "Imposible calcular la posición" },
/* TextUnableToCreateStorageHandler */ { "Unable to create storage handler", "Unmöglich den Speicher Handler zu erstellen", "Imposible crear manipulador de almacenamiento" },
/* TextUnableToCreateTcpSocket */ { "Unable to create TCP socket for {0}:{1}", "TCP Socket für {0}:{1} erstellen fehlgeschlagen", "Imposible crear socket TCP para {0}:{1}" },
/* TextUnableToCreateUdpSocket */ { "Unable to create UDP socket for {0}:{1}", "UDP Socket für {0}:{1} erstellen fehlgeschlagen", "Imposible crear socket UDP para {0}:{1}" },
/* TextUnableToCreateUdpSocketForReceivingData */ { "Unable to create UDP socket to receive data from control", "Nicht möglich ein UDP socket zu erstellen um Daten von der Zentrale zu empfangen", "Imposible crear UDP socket para recibir datos del control" },
/* TextUnableToCreateUdpSocketForSendingData */ { "Unable to create UDP socket to send data to control", "Nicht möglich ein UDP socket zu erstellen um Daten an die Zentrale zu senden", "Imposible crear UDP socket para enviar datos al control" },
/* TextUnableToFindSymbol */ { "Unable to find symbol {0}", "Symbol {0} nicht gefunden", "Imposible encontrar simbolo {0}" },
/* TextUnableToLock */ { "Unable to lock {0}", "Sperren von {0} nicht möglich", "Imposible bloquear {0}" },
/* TextUnableToOpenFile */ { "Unable to open file {0}", "Öffnen der Datei {0} nicht möglich", "Imposible abrir fila {0}" },
/* TextUnableToOpenSQLite */ { "Unable to load SQLite database: {0}", "Öffnen von SQLite Datenbank nicht möglich: {0}", "Imposible abrir base de datos SQLite: {0}" },
/* TextUnableToOpenSerial */ { "Unable to open serial {0}", "Serieller Anschluss {0} kann nicht geöffnet werden", "Imposible abrir conexión serial {0}" },
/* TextUnableToReceiveData */ { "Unable to receive data", "Daten empfangen nicht möglich", "Imposible recibir datos" },
/* TextUnableToReserve */ { "Unable to reserve {0}", "Reservieren von {0} nicht möglich", "Imposible reservar {0}" },
/* TextUnableToResolveAddress */ { "Unable to resolve address {0}", "Adresse {0} auflösen fehlgeschalgen", "Imposible resolver la dirección {0}" },
/* TextUnableToSendDataToControl */ { "Unable to send data to control", "Nicht möglich Daten an die Zentrale zu senden", "Imposible enviar datos al control" },
/* TextUnblockTrack */ { "Unblock track", "Deblockere Gleis", "Desbloquear vía" },
/* TextUnknownHardware */ { "Unknown control", "Unbekannte Zentrale", "Tipo de control desconocido" },
/* TextUnknownObjectType */ { "Unknown object type", "Unbekannter Objekttyp", "Tipo de objeto desconocido" },
/* TextUnloadingControl */ { "Unloading control {0}: {1}", "Entlade Zentrale {0}: {1}", "Descargando control {0}: {1}" },
/* TextUsingRouteFromTimetable */ { "Using route {0} from timetable", "Verwende Fahrstrasse {0} aus dem Fahrplan", "Usando itinerario {0} del horario" },
/* TextValue */ { "Value", "Wert", "Valor" },
/* TextVersion */ { "Version: {0}", "Version: {0}", "Versión: {0}" },
/* TextVisible */ { "Visible", "Sichtbar", "Visible" },
/* TextWaitAfterRelease */ { "Wait after release (s)", "Wartezeit nach Freigabe (s)", "Tiempo de espera despues liberar (s)" },
/* TextWaitingTimeBetweenMembers */ { "Waiting time between members (ms)", "Wartezeit zwischen Teilnehmern (ms)", "Tiempo de esprera entre los miembros (ms)" },
/* TextWaitingUntilHasStopped */ { "Waiting until it has stopped", "Warte bis sie angehalten hat", "Esperando hasta ha parado" },
/* TextWarning */ { "warning", "Warnungen", "advertencias" },
/* TextWebServerStarted */ { "Webserver started", "Webserver wurde gestartet", "Servidor web encendido" },
/* TextWebServerStopped */ { "Webserver stopped", "Webserver wurde beendet", "Servidor web apagado" },
/* TextWhenWrongPosition */ { "when in wrong position", "wenn in falscher Lage", "si en la posición falsa" },
/* TextWidth */ { "Width", "Breite", "Anchura" },
/* TextWidthIs0 */ { "Width is zero", "Breite ist null", "Anchura está zero" },
/* TextWrite */ { "write", "schreiben", "escribir" },
/* TextZ21Black2012 */ { "black Z21, hardware 2012", "schwarzen Z21, Hardware 2012", "Z21 negro, hardware 2012" },
/* TextZ21Black2013 */ { "black Z21, hardware 2013", "schwarzen Z21, Hardware 2013", "Z21 negro, hardware 2013" },
/* TextZ21DoesNotUnderstand */ { "Z21 does not understand our command", "Z21 versteht unser Kommando nicht", "Z21 no ha endendido nuestro comando" },
/* TextZ21NotRestricted */ { "Z21 does not have any restrictions", "Z21 hat keine Restriktionen", "Z21 no tiene restricctiones" },
/* TextZ21RestrictionsUnknown */ { "Z21 restrictions unknown", "Z21 Restriktionen unbekannt", "Z21 restricctiones desconocidos" },
/* TextZ21ServerStarted */ { "Z21 server started", "Z21 Server wurde gestartet", "Servidor Z21 encendido" },
/* TextZ21ServerStopped */ { "Z21 server stopped", "Z21 Server wurde beendet", "Servidor Z21 apagado" },
/* TextZ21SmartRail2012 */ { "SmartRail", "SmartRail", "SmartRail" },
/* TextZ21Start2016 */ { "z21 start", "z21 start", "z21 start" },
/* TextZ21StartLocked */ { "Z21 start is locked. Impssible to use this Z21!", "Z21 start ist gesperrt. Unmöglich diese Z21 zu benutzen!", "Z21 start está limitado. Imposible usar este Z21!" },
/* TextZ21StartUnlocked */ { "Z21 start is unlocked", "Z21 start ist offen", "Z21 start está abierto" },
/* TextZ21Type */ { "Connected to a {0} with firmware version {1}", "Verbunden mit einer {0} mit Firmware version {1}", "Conectado a {0} con firmware versión {1}" },
/* TextZ21Unknown */ { "unknown Z21", "unbekannten Z21", "Z21 desconocido" },
/* TextZ21White2013 */ { "white z21", "weissen z21", "z21 blanco" },
// /* Text */ { "", "", "" },
};

Languages::Language Languages::defaultLanguage = Languages::EN;
