% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikipedia.R
\name{wt_wikipedia}
\alias{wt_wikipedia}
\alias{wt_wikipedia_parse}
\alias{wt_wikipedia_search}
\title{Wikipedia}
\usage{
wt_wikipedia(name, wiki = "en", utf8 = TRUE, ...)

wt_wikipedia_parse(
  page,
  types = c("langlinks", "iwlinks", "externallinks", "common_names", "classification"),
  tidy = FALSE
)

wt_wikipedia_search(
  query,
  wiki = "en",
  limit = 10,
  offset = 0,
  utf8 = TRUE,
  ...
)
}
\arguments{
\item{name}{(character) Wiki name - as a page title, must be length 1}

\item{wiki}{(character) wiki language. default: en. See \link{wikipedias} for
language codes.}

\item{utf8}{(logical) If \code{TRUE}, encodes most (but not all) non-ASCII
characters as UTF-8 instead of replacing them with hexadecimal escape
sequences. Default: \code{TRUE}}

\item{...}{curl options, passed on to \code{\link[httr:GET]{httr::GET()}}}

\item{page}{(\code{\link[httr:response]{httr::response()}}) Result of \code{\link[=wt_wiki_page]{wt_wiki_page()}}}

\item{types}{(character) List of properties to parse}

\item{tidy}{(logical). tidy output to data.frame's if possible.
Default: \code{FALSE}}

\item{query}{(character) query terms}

\item{limit}{(integer) number of results to return. Default: 10}

\item{offset}{(integer) record to start at. Default: 0}
}
\value{
\code{wt_wikipedia} returns a list, with slots:
\itemize{
\item langlinks - language page links
\item externallinks - external links
\item common_names - a data.frame with \code{name} and \code{language} columns
\item classification - a data.frame with \code{rank} and \code{name} columns
\item synonyms - a character vector with taxonomic names
}

\code{wt_wikipedia_parse} returns a list with same slots determined by
the \code{types} parmeter

\code{wt_wikipedia_search} returns a list with slots for \code{continue} and
\code{query}, where \code{query} holds the results, with \code{query$search} slot with
the search results
}
\description{
Wikipedia
}
\examples{
\dontrun{
# high level
wt_wikipedia(name = "Malus domestica")
wt_wikipedia(name = "Malus domestica", wiki = "fr")
wt_wikipedia(name = "Malus domestica", wiki = "da")

# low level
pg <- wt_wiki_page("https://en.wikipedia.org/wiki/Malus_domestica")
wt_wikipedia_parse(pg)
wt_wikipedia_parse(pg, tidy = TRUE)

# search wikipedia
# FIXME: utf=FALSE for now until curl::curl_escape fix 
# https://github.com/jeroen/curl/issues/228
wt_wikipedia_search(query = "Pinus", utf8=FALSE)
wt_wikipedia_search(query = "Pinus", wiki = "fr", utf8=FALSE)
wt_wikipedia_search(query = "Pinus", wiki = "br", utf8=FALSE)

## curl options
# wt_wikipedia_search(query = "Pinus", verbose = TRUE, utf8=FALSE)

## use search results to dig into pages
res <- wt_wikipedia_search(query = "Pinus", utf8=FALSE)
lapply(res$query$search$title[1:3], wt_wikipedia)
}
}
\references{
\url{https://www.mediawiki.org/wiki/API:Search} for help on search
}
\concept{Wikipedia functions}
