% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate-rows.R
\name{separate_rows}
\alias{separate_rows}
\title{Separate a collapsed column into multiple rows.}
\usage{
separate_rows(data, ..., sep = "[^[:alnum:].]+", convert = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{...}{A selection of columns. If empty, all variables are
selected. You can supply bare variable names, select all
variables between x and z with \code{x:z}, exclude y with \code{-y}. For
more options, see the \code{\link[dplyr:select]{dplyr::select()}} documentation. See also
the section on selection rules below.}

\item{sep}{Separator delimiting collapsed values.}

\item{convert}{If \code{TRUE} will automatically run
\code{\link[=type.convert]{type.convert()}} on the key column. This is useful if the column
names are actually numeric, integer, or logical.}
}
\description{
If a variable contains observations with multiple delimited values, this
separates the values and places each one in its own row.
}
\section{Rules for selection}{


Arguments for selecting columns are passed to
\code{\link[tidyselect:vars_select]{tidyselect::vars_select()}} and are treated specially. Unlike other
verbs, selecting functions make a strict distinction between data
expressions and context expressions.
\itemize{
\item A data expression is either a bare name like \code{x} or an expression
like \code{x:y} or \code{c(x, y)}. In a data expression, you can only refer
to columns from the data frame.
\item Everything else is a context expression in which you can only
refer to objects that you have defined with \code{<-}.
}

For instance, \code{col1:col3} is a data expression that refers to data
columns, while \code{seq(start, end)} is a context expression that
refers to objects from the contexts.

If you really need to refer to contextual objects from a data
expression, you can unquote them with the tidy eval operator
\code{!!}. This operator evaluates its argument in the context and
inlines the result in the surrounding function call. For instance,
\code{c(x, !! x)} selects the \code{x} column within the data frame and the
column referred to by the object \code{x} defined in the context (which
can contain either a column name as string or a column position).
}

\examples{

df <- data.frame(
  x = 1:3,
  y = c("a", "d,e,f", "g,h"),
  z = c("1", "2,3,4", "5,6"),
  stringsAsFactors = FALSE
)
separate_rows(df, y, z, convert = TRUE)
}
