% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_actions.R
\name{add_actions}
\alias{add_actions}
\alias{get_actions}
\alias{add_icons}
\alias{add_methods}
\alias{addActions}
\alias{addIcons}
\alias{addMethods}
\title{Add GUI elements like actions (menu items), icons, or methods in a predefined
list}
\usage{
add_actions(
  obj = get_actions(),
  text = NULL,
  code = NULL,
  state = NULL,
  options = NULL,
  replace = TRUE
)

get_actions()

add_icons(obj = ".svIcons", icons, replace = TRUE)

add_methods(methods)

addActions(
  obj = get_actions(),
  text = NULL,
  code = NULL,
  state = NULL,
  options = NULL,
  replace = TRUE
)

addIcons(obj = ".svIcons", icons, replace = TRUE)

addMethods(methods)
}
\arguments{
\item{obj}{The name of the object in \code{SciViews:TempEnv} to manipulate.}

\item{text}{The text of actions to add (label on first line, tip on other
lines).}

\item{code}{The R code of actions to add.}

\item{state}{The default (initial) state of an action, as a succession of
letters: \code{c} = checked, \code{u} = unchecked (default); \code{d} = disabled,
\code{e} = enabled (default); \code{h} = hidden, \code{v} = visible (default). Default
values are optional. Ex: \code{udv} means: unchecked - disabled - visible and
it equals to simply \code{d}, given the defaults for the other properties.}

\item{options}{A character vector with other options to pass to the graphical
toolkit for this action.}

\item{replace}{Do we replace existing items in 'x'?}

\item{icons}{The description of the icons to add.}

\item{methods}{The list of methods to add (character string).}
}
\value{
The modified object is returned invisibly.
}
\description{
Manage lists of GUI actions, icons and methods.
}
\examples{
# This is useful to add actions, icons, descriptions, shortcuts or methods
# TODO: examples and use for functions add_actions(), add_icons() and
# add_methods()
}
\seealso{
\code{\link[=add_items]{add_items()}}, \code{\link[=obj_menu]{obj_menu()}}, \code{\link[=temp_env]{temp_env()}}
}
\concept{list of GUI elements}
\keyword{utilities}
