% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_site.R
\name{render_site}
\alias{render_site}
\alias{clean_site}
\alias{site_generator}
\alias{site_config}
\alias{default_site_generator}
\title{Render multiple documents as a website}
\usage{
render_site(
  input = ".",
  output_format = "all",
  envir = parent.frame(),
  quiet = FALSE,
  encoding = "UTF-8"
)

clean_site(input = ".", preview = FALSE, quiet = FALSE, encoding = "UTF-8")

site_generator(input = ".", output_format = NULL)

site_config(input = ".", encoding = "UTF-8")

default_site_generator(input, ...)
}
\arguments{
\item{input}{Website directory (or the name of a file within the directory).}

\item{output_format}{R Markdown format to convert to (defaults to "all").}

\item{envir}{The environment in which the code chunks are to be evaluated
during knitting (can use \code{\link{new.env}} to guarantee an empty new
environment).}

\item{quiet}{\code{TRUE} to suppress messages and other output.}

\item{encoding}{Ignored. The encoding is always assumed to be UTF-8.}

\item{preview}{Whether to list the files to be removed rather than actually
removing them.}

\item{...}{Currently unused.}
}
\value{
\code{render_site} returns the name of the site output file (relative
  to the input directory). \code{clean_site} returns the names of the
  generated files removed during cleaning. \code{site_config} returns the
  contents of _site.yml as an R list. \code{default_site_generator} returns
  the default site generator for R Markdown websites.
}
\description{
Render all of the R Markdown documents within a directory as a website.
}
\details{
The \code{render_site} function enables you to render a collection of
markdown documents within a directory as a website. There are two
requirements for a directory to be rendered as a website:
\enumerate{
  \item{It must contain either an "index.Rmd" or "index.md" file.}
  \item{It must contain a site configuration file ("_site.yml").}
}

The most minimal valid website is an empty "index.Rmd" and an empty
"_site.yml". With this configuration a single empty webpage would be
generated via a call to \code{render_site}. If you add additional markdown
documents to the directory they will also be rendered. By default a site is
rendered in the following fashion:

\enumerate{
  \item{R Markdown (.Rmd) and plain markdown (.md) files in the root
  directory are rendered. Note however that markdown files beginning with "_"
  are not rendered (this is a convention to designate files that are included
  by top level documents).}
  \item{All output and supporting files are copied to a "_site" subdirectory
  of the website directory (this is configurable, see discussion below).}
  \item{The following files are \bold{not} copied to the "_site"
  sub-directory:
    \itemize{
      \item{Files beginning with "." (hidden files).}
      \item{Files beginning with "_"}
      \item{Files known to contain R source code (e.g. ".R", ".s", ".Rmd"), R
      data (e.g. ".RData", ".rds"), or configuration data (e.g. ".Rproj",
      "rsconnect")).}
    }
    Note that you can override which files are included or excluded via
    settings in "_site.yml" (described below).}
  \item{Normally R Markdown renders documents as self-contained HTML.
  However, \code{render_site} ensures that dependencies (e.g. CSS,
  JavaScript, images, etc.) remain in external files. CSS/JavaScript
  libraries are copied to a "site_libs" sub-directory and plots/images are
  copied to "_files" sub-directories.}
}

You can remove the files generated by \code{render_site} using the
\code{clean_site} function.
}
\section{Configuration}{

A "_site.yml" file can be used to configure the behavior of site generation.
Here is an example configuration file:

\preformatted{
name: my-website
output_dir: _site
include: ["demo.R"]
exclude: ["docs.txt", "*.csv"]
navbar:
  title: "My Website"
  left:
    - text: "Home"
      href: index.html
    - text: "About"
      href: about.html
output:
  html_document:
    toc: true
    highlight: textmate
}

The \code{name} field provides a suggested URL path for your website when it
is published (by default this is just the name of the directory containing
the site). The \code{output_dir} indicates which directory to copy site
content into ("_site" is the default if none is specified). Note that this
can be "." to keep all content within the root website directory alongside
the source code.

The \code{include} and \code{exclude} fields enable you to override the
default behavior vis-a-vis what files are copied into the "_site" directory
(wildcards can be used as in the above example).

The \code{navbar} field can be used to define a navigation bar for websites
based on the \code{\link{html_document}} format.

Finally, the \code{output} field enables you to specify output options that
are common to all documents within the website (you can also still provide
local options within each document that override any common options).

\code{new_session: true} causes each file to be rendered in a new R session.
This prevents the masking problem that arises when different files use
functions from different packages (namespaces) that share a common name, such
as \code{here::here} and \code{lubridate::here} or \code{dplyr::filter} and
\code{MASS::filter}. The default behaviour of \code{render_site} is to use a
common R session.

\code{autospin: true} causes \code{.R} files to be spinned and rendered
(as well as \code{.Rmd} files). If \code{autospin} is set to false (the default),
\code{.R} files will not be spinned nor rendered. \code{autospin} can also
enumerate a list of .R files to be spinned and rendered.
}

\section{Custom Site Generation}{

The behavior of the default site generation function
(\code{rmarkdown::default_site}) is described above. It is also possible to
define a custom site generator that has alternate behavior. A site generator
is an R function that is bound to by including it in the "site:" field of the
"index.Rmd" or "index.md" file. For example:

\preformatted{
title: "My Book"
output: bookdown::gitbook
site: bookdown::bookdown_site
}

A site generation function should return a list with the following elements:
\itemize{
  \item{\code{name}} {The name for the website (e.g. the parent directory
  name).}
  \item{\code{output_dir} {The directory where the website output is written
  to. This path should be relative to the site directory (e.g. "." or
  "_site")}}
  \item{\code{render}} {An R function that can be called to generate the
  site. The function should accept the \code{input_file},
  \code{output_format}, \code{envir}, and \code{quiet} arguments.}
  \item{\code{clean}} {An R function that returns relative paths to the files
  generated by \code{render_site} (these files are the ones which will be
  removed by the \code{clean_site} function.}
}

Note that the \code{input_file} argument will be \code{NULL} when the entire
site is being generated. It will be set to a specific file name if a
front-end tool is attempting to preview it (e.g. RStudio IDE via the Knit
button).

When \code{quiet = FALSE} the \code{render} function should also print a line
of output using the \code{\link{message}} function indicating which output
file should be previewed, for example:

\preformatted{if (!quiet)
  message("\nOutput created: ", output)
}

Emitting this line enables front-ends like RStudio to determine which file
they should open to preview the website.

See the source code of the \code{rmarkdown::default_site} function for a
example of a site generation function.
}

