% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec.R, R/indexing.R
\name{re_exec}
\alias{re_exec}
\alias{$.rematch_records}
\alias{$.rematch_allrecords}
\title{Extract Data From First Regular Expression Match Into a Data Frame}
\usage{
re_exec(text, pattern, perl = TRUE, ...)

\method{$}{rematch_records}(x, name)

\method{$}{rematch_allrecords}(x, name)
}
\arguments{
\item{text}{Character vector.}

\item{pattern}{A regular expression. See \code{\link[base]{regex}} for more
about regular expressions.}

\item{perl}{logical should perl compatible regular expressions be used?
Defaults to TRUE, setting to FALSE will disable capture groups.}

\item{...}{Additional arguments to pass to
\code{\link[base]{gregexpr}} (or \code{\link[base]{regexpr}} if
\code{text} is of length zero).}

\item{x}{Object returned by \code{re_exec} or \code{re_exec_all}.}

\item{name}{\code{match}, \code{start} or \code{end}.}
}
\value{
A tidy data frame (see Section \dQuote{Tidy Data}).  Match record
  entries are one length vectors that are set to NA if there is no match.
}
\description{
Match a regular expression to a string, and return matches, match positions,
and capture groups.  This function is like its
\code{\link[=re_match]{match}} counterpart, except it returns match/capture
group start and end positions in addition to the matched values.
}
\section{Tidy Data}{


The return value is a tidy data frame where each row
corresponds to an element of the input character vector \code{text}.  The
values from \code{text} appear for reference in the \code{.text} character
column.  All other columns are list columns containing the match data.  The
\code{.match} column contains the match information for full regular
expression matches while other columns correspond to capture groups if there
are any, and PCRE matches are enabled with \code{perl = TRUE} (this is on by
default).  If capture groups are named the corresponding columns will bear
those names.

Each match data column list contains match records, one for each element in
\code{text}.  A match record is a named list, with entries \code{match},
\code{start} and \code{end} that are respectively the matching (sub) string,
the start, and the end positions (using one based indexing).
}

\section{Extracting Match Data}{


To make it easier to extract matching substrings or positions, a special
\code{$} operator is defined on match columns, both for the \code{.match}
column and the columns corresponding to the capture groups.  See examples
below.
}

\examples{
name_rex <- paste0(
  "(?<first>[[:upper:]][[:lower:]]+) ",
  "(?<last>[[:upper:]][[:lower:]]+)"
)
notables <- c(
  "  Ben Franklin and Jefferson Davis",
  "\tMillard Fillmore"
)
# Match first occurrence
pos <- re_exec(notables, name_rex)
pos

# Custom $ to extract matches and positions
pos$first$match
pos$first$start
pos$first$end
}
\seealso{
\code{\link[base]{regexpr}}, which this function wraps

Other tidy regular expression matching: 
\code{\link{re_exec_all}()},
\code{\link{re_match_all}()},
\code{\link{re_match}()}
}
\concept{tidy regular expression matching}
