% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle.R
\name{step_shuffle}
\alias{step_shuffle}
\title{Shuffle Variables}
\usage{
step_shuffle(recipe, ..., role = NA, trained = FALSE, columns = NULL)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of 
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables will
permuted. See \code{\link{selections}} for  more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing 
have been estimated.}

\item{columns}{A character string that contains the names of columns that
should be shuffled. These values are not determined until
\code{\link{prep.recipe}} is called.}
}
\value{
An updated version of \code{recipe} with the
  new step added to the sequence of existing steps (if any).
}
\description{
\code{step_shuffle} creates a \emph{specification} of a recipe step that will
  randomly change the order of rows for selected variables.
}
\examples{
integers <- data.frame(A = 1:12, B = 13:24, C = 25:36)

library(dplyr)
rec <- recipe(~ A + B + C, data = integers) \%>\%
  step_shuffle(A, B)

rand_set <- prep(rec, training = integers)

set.seed(5377)
bake(rand_set, integers)
}
\concept{
preprocessing randomization permutation
}
\keyword{datagen}
