% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_set.R
\name{pr_set_docs}
\alias{pr_set_docs}
\title{Set the API visual documentation}
\usage{
pr_set_docs(pr, docs = get_option_or_env("plumber.docs", TRUE), ...)
}
\arguments{
\item{pr}{A Plumber API. Note: The supplied Plumber API object will also be updated in place as well as returned by the function.}

\item{docs}{a character value or a logical value.
If using \code{\link[=options_plumber]{options_plumber()}}, the value must be set before initializing your Plumber router.}

\item{...}{Arguments for the visual documentation. See each visual documentation package for further details.}
}
\value{
The Plumber router with the new docs settings.
}
\description{
\code{docs} should be either a logical or a character value matching a registered visual documentation.
Multiple handles will be added to \code{\link{Plumber}} object. OpenAPI json
file will be served on paths \verb{/openapi.json}. Documentation
will be served on paths \verb{/__docs__/index.html} and \verb{/__docs__/}.
}
\examples{
\dontrun{
## View API using Swagger UI
# Official Website: https://swagger.io/tools/swagger-ui/
# install.packages("swagger")
if (require(swagger)) {
  pr() \%>\%
    pr_set_docs("swagger") \%>\%
    pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
    pr_run()
}

## View API using Redoc
# Official Website: https://github.com/Redocly/redoc
if (require(redoc)) {
  pr() \%>\%
    pr_set_docs("redoc") \%>\%
    pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
    pr_run()
}

## View API using RapiDoc
# Official Website: https://github.com/mrin9/RapiDoc
if (require(rapidoc)) {
  pr() \%>\%
    pr_set_docs("rapidoc") \%>\%
    pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
    pr_run()
}

## Disable the OpenAPI Spec UI
pr() \%>\%
  pr_set_docs(FALSE) \%>\%
  pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
  pr_run()
}
}
