% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeManipulation.R
\name{getRoot}
\alias{getRoot}
\alias{midpoint}
\alias{midpoint.phylo}
\alias{midpoint.multiPhylo}
\alias{pruneTree}
\alias{keep_as_tip}
\title{Tree manipulation}
\usage{
getRoot(tree)

midpoint(tree, node.labels = "support", ...)

\method{midpoint}{phylo}(tree, node.labels = "support", ...)

\method{midpoint}{multiPhylo}(tree, node.labels = "support", ...)

pruneTree(tree, ..., FUN = ">=")

keep_as_tip(tree, labels)
}
\arguments{
\item{tree}{an object of class \code{phylo}.}

\item{node.labels}{are node labels 'support' values (edges), 'label' or
should labels get 'deleted'?}

\item{\dots}{further arguments, passed to other methods.}

\item{FUN}{a function evaluated on the nodelabels, result must be logical.}

\item{labels}{tip and node labels to keep as tip labels in the tree}
}
\value{
\code{pruneTree} and \code{midpoint} a tree. \code{getRoot} returns
the root node.
}
\description{
\code{midpoint} performs midpoint rooting of a tree.  \code{pruneTree}
produces a consensus tree.
\code{pruneTree} prunes back a tree and produces a consensus tree, for trees
already containing nodelabels.  It assumes that nodelabels are numerical or
character that allows conversion to numerical, it uses
as.numeric(as.character(tree$node.labels)) to convert them.
\code{midpoint} by default assumes that node labels contain support values.
This works if support values are computed from splits, but should be
recomputed for clades.
\code{keep_as_tip} takes a list of tips and/or node labels and returns a tree
pruned to those. If node label, then it prunes all descendants of that node
until that internal node becomes a tip.
}
\examples{

tree <- rtree(10, rooted = FALSE)
tree$node.label <- c("", round(runif(tree$Nnode-1), digits=3))

tree2 <- midpoint(tree)
tree3 <- pruneTree(tree, .5)

old.par <- par(no.readonly = TRUE)
par(mfrow = c(3,1))
plot(tree, show.node.label=TRUE)
plot(tree2, show.node.label=TRUE)
plot(tree3, show.node.label=TRUE)
par(old.par)

}
\seealso{
\code{\link[ape]{consensus}}, \code{\link[ape]{root}},
\code{\link[ape]{multi2di}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
