% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url.r
\name{parse_url}
\alias{parse_url}
\alias{build_url}
\title{Parse and build urls according to RFC1808.}
\usage{
parse_url(url)

build_url(url)
}
\arguments{
\item{url}{For \code{parse_url} a character vector (of length 1) to parse
into components; for \code{build_url} a list of components to turn back
into a string.}
}
\value{
a list containing: \itemize{
 \item scheme
 \item hostname
 \item port
 \item path
 \item params
 \item fragment
 \item query, a list
 \item username
 \item password
}
}
\description{
See \url{http://tools.ietf.org/html/rfc1808.html} for details of parsing
algorithm.
}
\examples{
parse_url("http://google.com/")
parse_url("http://google.com:80/")
parse_url("http://google.com:80/?a=1&b=2")

url <- parse_url("http://google.com/")
url$scheme <- "https"
url$query <- list(q = "hello")
build_url(url)
}
