% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{renderGvis}
\alias{renderGvis}
\title{renderGvis}
\usage{
renderGvis(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{expr}{An expression that returns a gvis object.}

\item{env}{The environment in which to evaluate \code{expr}}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})?
This is useful if you want to save an expression in a variable.}
}
\value{
Returns a function that can be assigned to a Shiny \code{output} 
element.
}
\description{
This function lets you use googleVis charts as Shiny output. 
Use it to wrap a googleVis-generating function that you assign to an 
\code{output} element in \code{server.R}; then create an \code{htmlOutput} 
with the same name in \code{ui.R}.
}
\details{
Use a googleVis Chart as Shiny Output
}
\section{Details}{

More information about shiny is available online: 
 \url{https://shiny.posit.co/}. 
 You find further examples with googleVis on shiny on mages' blog:
 \url{https://magesblog.com/tags/shiny/}
}

\examples{
  
\dontrun{
# To run this example:
shiny::runApp(system.file("shiny/", package="googleVis"))
# server.R
library(googleVis)

shinyServer(function(input, output) {
  datasetInput <- reactive({
    switch(input$dataset,
           "rock" = rock,
           "pressure" = pressure,
           "cars" = cars)
  })
  
  output$view <- renderGvis({
    gvisScatterChart(datasetInput(),
                     options=list(title=paste('Data:',input$dataset)))
  })
})

# ui.R
shinyUI(pageWithSidebar(
  headerPanel("googleVis on Shiny"),
  sidebarPanel(
    selectInput("dataset", "Choose a dataset:",
                choices = c("rock", "pressure", "cars"))
  ),
  mainPanel(
    htmlOutput("view")
  )
))
}


}
\author{
Joe Cheng, \email{joe@rstudio.com}
}
\keyword{shiny}
