% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust-glmrob-tidiers.R
\name{glance.glmRob}
\alias{glance.glmRob}
\title{Glance at a(n) glmRob object}
\usage{
\method{glance}{glmRob}(x, ...)
}
\arguments{
\item{x}{A \code{glmRob} object returned from \code{\link[robust:glmRob]{robust::glmRob()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modeling
function. This includes the name of the modeling function or any
arguments passed to the modeling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.

Glance returns the same number of columns regardless of whether the
model matrix is rank-deficient or not. If so, entries in columns
that no longer have a well-defined value are filled in with an \code{NA}
of the appropriate type.
}
\examples{

if (requireNamespace("robust", quietly = TRUE)) {
  library(robust)

  gm <- glmRob(am ~ wt, data = mtcars, family = "binomial")

  tidy(gm)
  glance(gm)
}
}
\seealso{
\code{\link[robust:glmRob]{robust::glmRob()}}

Other robust tidiers: 
\code{\link{augment.lmRob}()},
\code{\link{glance.lmRob}()},
\code{\link{tidy.glmRob}()},
\code{\link{tidy.lmRob}()}
}
\concept{robust tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with exactly one row and columns:
  \item{deviance}{Deviance of the model.}
  \item{df.residual}{Residual degrees of freedom.}
  \item{nobs}{Number of observations used.}
  \item{null.deviance}{Deviance of the null model.}
  \item{sigma}{Estimated standard error of the residuals.}

}
