% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_draws.R
\name{diagnostic_draws}
\alias{diagnostic_draws}
\title{Diagnostic values for each iteration}
\usage{
diagnostic_draws(posterior, ...)
}
\arguments{
\item{posterior}{A \code{stanreg}, \code{stanfit}, \code{brmsfit}, or \code{blavaan} object.}

\item{...}{Currently not used.}
}
\description{
Returns the accumulated log-posterior, the average Metropolis acceptance rate, divergent transitions, treedepth rather than terminated its evolution normally.
}
\examples{
\donttest{
set.seed(333)

if (require("brms", quietly = TRUE)) {
  model <- suppressWarnings(brm(mpg ~ wt * cyl * vs,
    data = mtcars,
    iter = 100, control = list(adapt_delta = 0.80),
    refresh = 0
  ))
  diagnostic_draws(model)
}
}

}
