% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.R.prior.R
\name{simul.R.prior}
\alias{simul.R.prior}
\title{Simulate prior distribution of factor correlation matrix}
\usage{
simul.R.prior(Kmax, nu0 = Kmax + 1, S0 = 1, HW.prior = TRUE,
  nrep = 10^5, verbose = TRUE)
}
\arguments{
\item{Kmax}{Maximum number of latent factors.}

\item{nu0}{Degrees of freedom of the Inverse-Wishart prior on the covariance
matrix of the latent factors in the expanded model.}

\item{S0}{Scale parameters of the Inverse-Wishart prior on the covariance matrix
of latent factors in the expanded model:
\itemize{
  \item if \code{HW.prior = TRUE}, scale parameter of the Gamma
  hyperprior distribution on the individual scales of the
  Inverse-Wishart prior.
  \item if \code{HW.prior = FALSE}, diagonal elements of the scale
  matrix of the Inverse-Wishart prior on the covariance matrix of
  the latent factors in the expanded model.
}
Either a scalar or a numeric vector of length equal to \code{Kmax}.}

\item{HW.prior}{If \code{TRUE}, implement Huang-Wand (2013) prior on the covariance
matrix of the factors in the expanded model, otherwise use an
Inverse-Wishart prior if \code{FALSE}, see CFSHP section 2.3.5.}

\item{nrep}{Number of Monte Carlo replications.}

\item{verbose}{If \code{TRUE}, display information on the progress of the function.}
}
\value{
A list of length equal to the number of pairs of parameters
\code{nu0} and \code{S0}, where each element of the list is an array of
dimension (\code{Kmax}, \code{Kmax}, \code{nrep}) that contains the
correlation matrices of the latent factors drawn from the prior.
}
\description{
This function produces a sample of correlation matrices drawn from their
prior distribution induced in the identified version of the factor model,
given the prior distribution specified on the corresponding covariance
matrices of the factors in the expanded model.
}
\details{
Covariance matrices are sampled from the prior distribution in the
expanded model, and transformed to produce the corresponding correlation
matrices. See section 2.3.5 of CFSHP (p.36-37), as well as the details of
the function \code{\link{befa}}.

To compare several prior specifications, different values of the parameters
\code{nu0} and \code{S0} can be specified. The function then simulates for
each pair of these parameters. \code{nu0} and \code{S0} should therefore be
scalars or vectors of same length.
}
\examples{
# partial reproduction of figure 1 in CFSHP (p.38)
# note: use larger number of replications nrep to increase smoothness
Kmax <- 10
Rsim <- simul.R.prior(Kmax, nu0 = Kmax + c(1, 2, 5), S0 = .5, nrep = 1000)
summary(Rsim)
plot(Rsim)

}
\references{
G. Conti, S. Frühwirth-Schnatter, J.J. Heckman, R. Piatek (2014):
``Bayesian Exploratory Factor Analysis'', \emph{Journal of Econometrics},
183(1), pages 31-57, \url{http://dx.doi.org/10.1016/j.jeconom.2014.06.008}.
}
\author{
Rémi Piatek \email{remi.piatek@econ.ku.dk}
}
