% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{TCGAanalyze_Normalization}
\alias{TCGAanalyze_Normalization}
\title{normalization mRNA transcripts and miRNA using EDASeq package.}
\usage{
TCGAanalyze_Normalization(tabDF, geneInfo, method = "geneLength")
}
\arguments{
\item{tabDF}{Rnaseq numeric matrix, each row represents a gene,
each column represents a sample}

\item{geneInfo}{Information matrix of 20531 genes about geneLength and gcContent.
Two objects are provided: TCGAbiolinks::geneInfoHT,TCGAbiolinks::geneInfo}

\item{method}{is method of normalization such as 'gcContent' or 'geneLength'}
}
\value{
Rnaseq matrix normalized with counts slot holds the count data as a matrix
of non-negative integer count values, one row for each observational unit (gene or the like),
and one column for each sample.
}
\description{
TCGAanalyze_Normalization allows user to normalize mRNA transcripts and miRNA,
   using EDASeq package.

   Normalization for RNA-Seq Numerical and graphical
    summaries of RNA-Seq read data. Within-lane normalization procedures
   to adjust for GC-content effect (or other gene-level effects) on read counts:
   loess robust local regression, global-scaling, and full-quantile normalization
   (Risso et al., 2011). Between-lane normalization procedures to adjust for
   distributional differences between lanes (e.g., sequencing depth):
   global-scaling and full-quantile normalization (Bullard et al., 2010).

   For istance returns all mRNA or miRNA with mean across all
   samples, higher than the threshold defined quantile mean across all samples.

   TCGAanalyze_Normalization performs normalization using following functions
   from EDASeq
   \enumerate{
   \item  EDASeq::newSeqExpressionSet
   \item  EDASeq::withinLaneNormalization
   \item  EDASeq::betweenLaneNormalization
   \item  EDASeq::counts
   }
}
\examples{
dataNorm <- TCGAbiolinks::TCGAanalyze_Normalization(dataBRCA, geneInfo)
}
