/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "QtLoginDialog.h"

#include "QtAddAccount.h"
#include "QtAddQuteComAccount.h"
#include "QtAddSIPAccount.h"
#include "QtLogAccount.h"

#include <presentation/qt/QtQuteCom.h>
#include <presentation/qt/QtToolBar.h>

#include <control/profile/CUserProfileHandler.h>

#include <model/account/SipAccount.h>
#include <model/config/ConfigManager.h>
#include <model/config/Config.h>

#include <qtutil/SafeConnect.h>

#include <util/Logger.h>


#include <util/String.h>

#include <QtGui/QtGui>

QtLoginDialog::QtLoginDialog(QtQuteCom * qtQuteCom, CUserProfileHandler & cUserProfileHandler)
	:QDialog(qtQuteCom->getWidget()),
	_qtQuteCom(qtQuteCom) {

	_centralWidget = new QStackedWidget(this);
	_loginPage.push_back(new QtAddAccount(this, _centralWidget, cUserProfileHandler));
	_loginPage.push_back(new QtAddQuteComAccount(this, _centralWidget, cUserProfileHandler));
	_loginPage.push_back(new QtAddSIPAccount(this, _centralWidget, cUserProfileHandler));
	_loginPage.push_back(new QtLogAccount(this, _centralWidget, cUserProfileHandler));
    SAFE_CONNECT(this, SIGNAL(rejected()), SLOT(loginRejected()));

    _centralWidget->addWidget(_loginPage[AddAccount]);
    _centralWidget->addWidget(_loginPage[AddQuteComAccount]);
    _centralWidget->addWidget(_loginPage[AddSIPAccount]);
	_centralWidget->addWidget(_loginPage[LogAccount]);
	
	setWindowTitle(tr("@product@ - Login"));

    QVBoxLayout * layout = new QVBoxLayout(this);
    layout->addWidget(_centralWidget);
	
	changePage(LogAccount);
}

QtLoginDialog::~QtLoginDialog() {
}

void QtLoginDialog::changePage(int newPage, std::string sipAccountName) {
	if ( (newPage >= 0) && (newPage < _centralWidget->count())) 
	{
		int page = newPage ;
		
	#ifndef CUSTOM_ACCOUNT
		if( page == 0)
		{
			page = 2;
		}
	#endif
		
		_centralWidget->setCurrentIndex(page);
		_loginPage[page]->initPage();
		if (!sipAccountName.empty()) {
			_loginPage[page]->load(sipAccountName);
		}
	}
}

ILogin* QtLoginDialog::currentPage() const {
	return _loginPage[_centralWidget->currentIndex()];
}

void QtLoginDialog::loginRejected() {
    _qtQuteCom->getQtToolBar().enableMenuBar();
}

void QtLoginDialog::setInvalidAccount(const SipAccount & sipAccount) {
	if (sipAccount.getType() ==  SipAccount::SipAccountTypeQuteCom) {
		//qutecom account
		changePage(AddQuteComAccount);
		_loginPage[AddQuteComAccount]->load(sipAccount);
	} else {
		//"generic" sip account
		changePage(AddSIPAccount);
		_loginPage[AddSIPAccount]->load(sipAccount);
	}
}

void QtLoginDialog::setValidAccount(SipAccount sipAccount) {
	changePage(LogAccount);
	_loginPage[LogAccount]->load(sipAccount);
	_loginPage[LogAccount]->setInfoMessage();
}

void QtLoginDialog::setInfoMessage() {
	_loginPage[_centralWidget->currentIndex()]->setInfoMessage();
}

void QtLoginDialog::setErrorMessage(const QString & message) {
	_loginPage[_centralWidget->currentIndex()]->setErrorMessage(message);
}
