"""
Set of objects to manage 3D spatialization with HRTF algorithm.

"""
from __future__ import division
from __future__ import print_function
from __future__ import absolute_import

"""
Copyright 2009-2018 Olivier Belanger

This file is part of pyo, a python module to help digital signal
processing script creation.

pyo is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

pyo is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with pyo.  If not, see <http://www.gnu.org/licenses/>.
"""
import os
from ._core import *
from ._maps import *

class ImpulseResponseTables:
    def getTables(self):
        IR_LEFT = []
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000244140625, 0.000244140625, -0.00018310546875, 0.00042724609375, -0.0003662109375, 0.00054931640625, -0.000823974609375, 0.0006103515625, -0.0006103515625, 0.00030517578125, -0.000518798828125, 0.0006103515625, -0.001220703125, 0.065277099609375, 0.202117919921875, -0.077972412109375, -0.246307373046875, 0.005523681640625, -0.03961181640625, 0.044189453125, 0.26947021484375, 0.240631103515625, 0.10150146484375, 0.147186279296875, 0.31597900390625, 0.090789794921875, -0.14910888671875, -0.1080322265625, -0.19500732421875, -0.226104736328125, -0.013153076171875, -0.06683349609375, -0.204620361328125, -0.117950439453125, -0.038726806640625, -0.0218505859375, -0.013336181640625, 0.03057861328125, 0.04803466796875, 0.026947021484375, 0.052215576171875, 0.09326171875, 0.02874755859375, 0.00140380859375, 0.016326904296875, 0.009185791015625, -0.009124755859375, -0.03448486328125, -0.0311279296875, -0.03564453125, -0.0404052734375, -0.02069091796875, -0.0216064453125, -0.0303955078125, -0.00604248046875, 0.006988525390625, 0.002716064453125, 0.0089111328125, 0.01556396484375, 0.02020263671875, 0.013702392578125, -0.00201416015625, -0.001556396484375, -0.013916015625, -0.015777587890625, 0.004150390625, 0.007232666015625, 0.005401611328125, 0.008544921875, 0.0054931640625, -0.00030517578125, -0.01123046875, -0.017181396484375, -0.023773193359375, -0.037628173828125, -0.0306396484375, -0.0145263671875, -0.005340576171875, 0.005340576171875, 0.01068115234375, 0.014404296875, 0.015655517578125, 0.0089111328125, 0.0081787109375, 0.001007080078125, -0.009765625, -0.016693115234375, -0.019378662109375, -0.014404296875, -0.006195068359375, -0.00091552734375, 0.002288818359375, 0.001495361328125, 0.000946044921875, 0.0015869140625, -0.002288818359375, -0.00360107421875, -0.00274658203125, -0.001800537109375, -0.004425048828125, -0.007720947265625, -0.00634765625, -0.00360107421875, -0.003143310546875, -0.0029296875, -0.005828857421875, -0.008544921875, -0.00750732421875, -0.005615234375, -0.005462646484375, -0.003631591796875, 6.103515625e-05, 0.001373291015625, 0.00177001953125, 0.00286865234375, 0.003143310546875, 0.001739501953125, -0.00091552734375, -0.00250244140625, -0.003326416015625, -0.004638671875, -0.005706787109375, -0.00689697265625, -0.00653076171875, -0.00811767578125, -0.007598876953125, -0.004547119140625, -0.0013427734375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -0.000152587890625, 0.00018310546875, -6.103515625e-05, 0.000274658203125, 3.0517578125e-05, 0.0001220703125, -6.103515625e-05, -0.000213623046875, 0.000335693359375, -0.00067138671875, 0.000823974609375, -0.001007080078125, 0.000823974609375, 0.023590087890625, 0.158294677734375, 0.046112060546875, -0.22174072265625, -0.094390869140625, -0.058319091796875, -0.03436279296875, 0.20867919921875, 0.2489013671875, 0.155975341796875, 0.1309814453125, 0.246002197265625, 0.19134521484375, -0.031768798828125, -0.071929931640625, -0.132720947265625, -0.23760986328125, -0.09375, -0.01104736328125, -0.1302490234375, -0.15191650390625, -0.096405029296875, -0.039825439453125, -0.015777587890625, 0.0093994140625, 0.03436279296875, 0.023162841796875, 0.03009033203125, 0.081024169921875, 0.063232421875, 0.018280029296875, 0.020355224609375, 0.0181884765625, -0.003753662109375, -0.0235595703125, -0.03045654296875, -0.039794921875, -0.04461669921875, -0.031005859375, -0.022430419921875, -0.026580810546875, -0.017181396484375, -0.004913330078125, 0.004852294921875, 0.013336181640625, 0.0140380859375, 0.0089111328125, 0.0079345703125, -0.002593994140625, 0.005645751953125, 0.020538330078125, 0.012481689453125, 0.011474609375, 0.010772705078125, -0.0001220703125, -0.007965087890625, -0.01007080078125, -0.010986328125, -0.023162841796875, -0.0341796875, -0.0291748046875, -0.0245361328125, -0.014739990234375, 0.0001220703125, 0.00457763671875, 0.00811767578125, 0.015228271484375, 0.0152587890625, 0.012664794921875, 0.00225830078125, -0.0062255859375, -0.013763427734375, -0.0206298828125, -0.015777587890625, -0.00762939453125, -0.00347900390625, -0.00128173828125, 0.001190185546875, 0.00439453125, 0.0035400390625, -0.001434326171875, -0.002044677734375, -0.002960205078125, -0.00201416015625, -0.002410888671875, -0.007568359375, -0.010955810546875, -0.008758544921875, -0.00653076171875, -0.00628662109375, -0.0052490234375, -0.004119873046875, -0.0035400390625, -0.001556396484375, -0.0008544921875, -0.0015869140625, -0.00201416015625, -0.002197265625, -0.0008544921875, 0.001434326171875, 0.00164794921875, -0.000762939453125, -0.00164794921875, -0.002685546875, -0.003570556640625, -0.002777099609375, -0.00128173828125, -0.002655029296875, -0.002166748046875, -0.002532958984375, -0.006988525390625, -0.007659912109375, -0.006011962890625, -0.00445556640625])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, -6.103515625e-05, -0.000152587890625, 0.0001220703125, -9.1552734375e-05, 0.000274658203125, -0.0001220703125, 0.000274658203125, -0.000396728515625, 0.000152587890625, -0.0001220703125, -0.000152587890625, 0.00018310546875, -0.0001220703125, -0.000213623046875, 0.037628173828125, 0.1519775390625, -0.0057373046875, -0.19866943359375, -0.063232421875, -0.06134033203125, 0.00897216796875, 0.200836181640625, 0.20184326171875, 0.140380859375, 0.1395263671875, 0.234039306640625, 0.145355224609375, -0.0330810546875, -0.05841064453125, -0.1357421875, -0.208709716796875, -0.0819091796875, -0.0294189453125, -0.129791259765625, -0.14459228515625, -0.07464599609375, -0.018310546875, -0.011962890625, 0.007080078125, 0.033660888671875, 0.031890869140625, 0.044525146484375, 0.0693359375, 0.03863525390625, 0.0179443359375, 0.0274658203125, 0.011810302734375, -0.015655517578125, -0.02886962890625, -0.033477783203125, -0.03900146484375, -0.03955078125, -0.029266357421875, -0.02264404296875, -0.02081298828125, -0.01202392578125, -0.0009765625, 0.00921630859375, 0.01287841796875, 0.00909423828125, 0.009429931640625, 0.0098876953125, 0.002227783203125, 0.015350341796875, 0.020355224609375, 0.011932373046875, 0.01165771484375, 0.003448486328125, -0.007415771484375, -0.0125732421875, -0.013397216796875, -0.01507568359375, -0.026824951171875, -0.03179931640625, -0.0250244140625, -0.019683837890625, -0.007720947265625, 0.0025634765625, 0.00531005859375, 0.009246826171875, 0.01043701171875, 0.009674072265625, 0.006988525390625, -0.001312255859375, -0.00714111328125, -0.014678955078125, -0.018035888671875, -0.011383056640625, -0.0047607421875, -0.001953125, 0.0001220703125, 0.002685546875, 0.004425048828125, 0.000335693359375, -0.00274658203125, -0.0035400390625, -0.005615234375, -0.0040283203125, -0.0057373046875, -0.010040283203125, -0.01055908203125, -0.007110595703125, -0.005706787109375, -0.0052490234375, -0.0040283203125, -0.0042724609375, -0.002960205078125, 0.0001220703125, -0.000213623046875, -0.001556396484375, -0.0013427734375, -0.000518798828125, 0.000518798828125, 0.00146484375, 3.0517578125e-05, -0.0023193359375, -0.003631591796875, -0.00531005859375, -0.005340576171875, -0.002960205078125, -0.00164794921875, -0.002166748046875, -0.001373291015625, -0.003082275390625, -0.005645751953125, -0.0048828125, -0.00433349609375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, -3.0517578125e-05, -0.000152587890625, 0.0001220703125, -6.103515625e-05, 0.00030517578125, -0.000152587890625, 0.000244140625, -0.000274658203125, 9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, 0.000244140625, 3.0517578125e-05, -0.0001220703125, 0.03497314453125, 0.13311767578125, -0.004638671875, -0.169830322265625, -0.059295654296875, -0.04632568359375, 0.0169677734375, 0.157501220703125, 0.172515869140625, 0.138336181640625, 0.13165283203125, 0.206939697265625, 0.133270263671875, -0.011993408203125, -0.047760009765625, -0.120941162109375, -0.185394287109375, -0.0821533203125, -0.0333251953125, -0.12451171875, -0.134063720703125, -0.0614013671875, -0.010498046875, -0.01214599609375, 0.00372314453125, 0.034271240234375, 0.041717529296875, 0.050506591796875, 0.057891845703125, 0.032379150390625, 0.020355224609375, 0.021636962890625, 0.00054931640625, -0.024627685546875, -0.034332275390625, -0.031829833984375, -0.032928466796875, -0.03875732421875, -0.0294189453125, -0.016326904296875, -0.013641357421875, -0.007904052734375, 0.0020751953125, 0.0113525390625, 0.01385498046875, 0.011444091796875, 0.013824462890625, 0.0113525390625, 0.005706787109375, 0.015655517578125, 0.013275146484375, 0.0086669921875, 0.00811767578125, -0.00067138671875, -0.01068115234375, -0.016357421875, -0.01531982421875, -0.020172119140625, -0.031768798828125, -0.031005859375, -0.020263671875, -0.01202392578125, 9.1552734375e-05, 0.007171630859375, 0.008636474609375, 0.009918212890625, 0.00738525390625, 0.0057373046875, 0.002105712890625, -0.004486083984375, -0.010223388671875, -0.0177001953125, -0.0167236328125, -0.0081787109375, -0.002166748046875, -0.0006103515625, 6.103515625e-05, 0.00244140625, 0.00262451171875, -0.001007080078125, -0.002777099609375, -0.004547119140625, -0.006256103515625, -0.00506591796875, -0.006622314453125, -0.009613037109375, -0.00885009765625, -0.00579833984375, -0.005615234375, -0.005279541015625, -0.004119873046875, -0.003875732421875, -0.001495361328125, 0.000457763671875, -0.000579833984375, -0.00152587890625, -0.000396728515625, 0.000762939453125, 0.001220703125, 0.000274658203125, -0.0018310546875, -0.003143310546875, -0.00494384765625, -0.0067138671875, -0.005828857421875, -0.003173828125, -0.002410888671875, -0.001129150390625, 0.00048828125, -0.001129150390625, -0.0028076171875, -0.00372314453125])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, 0.0001220703125, -3.0517578125e-05, 0.000274658203125, -0.0001220703125, 0.000274658203125, -0.000335693359375, 0.0003662109375, -0.0003662109375, 0.00042724609375, -0.000244140625, 0.000579833984375, -6.103515625e-05, 0.04461669921875, 0.119049072265625, -0.03448486328125, -0.145721435546875, -0.042083740234375, -0.03314208984375, 0.0302734375, 0.133087158203125, 0.15704345703125, 0.128021240234375, 0.130126953125, 0.186981201171875, 0.106170654296875, -0.006256103515625, -0.045989990234375, -0.12579345703125, -0.165374755859375, -0.05767822265625, -0.04156494140625, -0.1297607421875, -0.115264892578125, -0.03997802734375, -0.00604248046875, -0.01129150390625, 0.00897216796875, 0.03582763671875, 0.04547119140625, 0.0521240234375, 0.0518798828125, 0.02642822265625, 0.014373779296875, 0.011199951171875, -0.008758544921875, -0.029998779296875, -0.03271484375, -0.027252197265625, -0.033905029296875, -0.0382080078125, -0.021453857421875, -0.009796142578125, -0.009918212890625, -0.00421142578125, 0.00640869140625, 0.014984130859375, 0.01751708984375, 0.017333984375, 0.014068603515625, 0.004425048828125, 0.004486083984375, 0.011993408203125, 0.00689697265625, 0.0050048828125, 0.00274658203125, -0.004150390625, -0.012664794921875, -0.01751708984375, -0.0194091796875, -0.02734375, -0.033111572265625, -0.02496337890625, -0.01275634765625, -0.003021240234375, 0.007720947265625, 0.011474609375, 0.01171875, 0.010009765625, 0.005584716796875, 0.00091552734375, -0.005096435546875, -0.0098876953125, -0.01458740234375, -0.01910400390625, -0.014862060546875, -0.0052490234375, 0.000732421875, 0.000244140625, -0.0008544921875, 0.001251220703125, 0.00164794921875, -0.001068115234375, -0.00341796875, -0.005218505859375, -0.005401611328125, -0.00457763671875, -0.006500244140625, -0.008148193359375, -0.006622314453125, -0.00567626953125, -0.00701904296875, -0.005615234375, -0.003936767578125, -0.0028076171875, -0.000823974609375, -0.000335693359375, -0.00067138671875, -0.0003662109375, 0.000244140625, 0.000732421875, 0.000396728515625, -0.001312255859375, -0.003021240234375, -0.004547119140625, -0.00592041015625, -0.006927490234375, -0.005035400390625, -0.002410888671875, -0.000640869140625, 0.001861572265625, 0.001495361328125, -0.00115966796875, -0.003387451171875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, 0.0, 0.000244140625, -0.0001220703125, 0.000274658203125, -0.000213623046875, 0.00030517578125, -0.000244140625, 0.00042724609375, -0.00018310546875, 0.0006103515625, -0.00018310546875, 0.039276123046875, 0.103546142578125, -0.0272216796875, -0.12518310546875, -0.032623291015625, -0.02264404296875, 0.013153076171875, 0.108123779296875, 0.145233154296875, 0.11846923828125, 0.118499755859375, 0.1630859375, 0.10150146484375, 0.007843017578125, -0.040313720703125, -0.11761474609375, -0.142120361328125, -0.047119140625, -0.046295166015625, -0.12017822265625, -0.0966796875, -0.02728271484375, -0.003204345703125, -0.0120849609375, 0.00946044921875, 0.03717041015625, 0.044525146484375, 0.041595458984375, 0.04107666015625, 0.02703857421875, 0.012786865234375, 0.00274658203125, -0.01416015625, -0.025421142578125, -0.024932861328125, -0.02606201171875, -0.034759521484375, -0.032440185546875, -0.014129638671875, -0.00732421875, -0.010406494140625, -0.004150390625, 0.01226806640625, 0.02252197265625, 0.01922607421875, 0.01531982421875, 0.008941650390625, 0.001007080078125, 0.001617431640625, 0.003265380859375, 0.001251220703125, 0.000579833984375, -0.00341796875, -0.00811767578125, -0.014434814453125, -0.016571044921875, -0.019317626953125, -0.02593994140625, -0.02691650390625, -0.018218994140625, -0.006591796875, 0.00311279296875, 0.011016845703125, 0.013427734375, 0.012176513671875, 0.00653076171875, 0.0008544921875, -0.003692626953125, -0.00946044921875, -0.014862060546875, -0.018463134765625, -0.018035888671875, -0.0106201171875, -0.0015869140625, 0.001312255859375, -0.002044677734375, -0.002044677734375, 0.001129150390625, 0.00115966796875, -0.00128173828125, -0.003326416015625, -0.004730224609375, -0.0052490234375, -0.004547119140625, -0.00531005859375, -0.006134033203125, -0.005584716796875, -0.00653076171875, -0.007781982421875, -0.00531005859375, -0.003021240234375, -0.002197265625, -0.00164794921875, -0.00079345703125, 9.1552734375e-05, -0.000732421875, -0.0010986328125, -0.000274658203125, -0.000579833984375, -0.002593994140625, -0.004058837890625, -0.005523681640625, -0.007080078125, -0.00592041015625, -0.001739501953125, 0.000396728515625, 0.001312255859375, 0.002410888671875, 0.00048828125, -0.00225830078125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.00018310546875, 3.0517578125e-05, 0.000274658203125, -0.000244140625, 0.00042724609375, -0.000274658203125, 0.000518798828125, -0.000457763671875, 0.000885009765625, 0.000732421875, 0.047088623046875, 0.0860595703125, -0.048492431640625, -0.09844970703125, -0.016143798828125, -0.025970458984375, 0.016998291015625, 0.1064453125, 0.131500244140625, 0.10528564453125, 0.115966796875, 0.142059326171875, 0.079742431640625, 0.00787353515625, -0.043731689453125, -0.11517333984375, -0.11328125, -0.038116455078125, -0.061065673828125, -0.1026611328125, -0.064056396484375, -0.015899658203125, -0.008148193359375, -0.008819580078125, 0.01715087890625, 0.03668212890625, 0.035003662109375, 0.0281982421875, 0.033203125, 0.026702880859375, 0.013641357421875, -0.001434326171875, -0.01678466796875, -0.019683837890625, -0.019256591796875, -0.026702880859375, -0.03326416015625, -0.027069091796875, -0.014129638671875, -0.008209228515625, -0.00628662109375, 0.00335693359375, 0.017822265625, 0.022491455078125, 0.01605224609375, 0.008392333984375, 0.00115966796875, -0.002716064453125, -0.001953125, -0.001861572265625, -0.002471923828125, -0.004180908203125, -0.006683349609375, -0.009246826171875, -0.01287841796875, -0.01312255859375, -0.016998291015625, -0.021453857421875, -0.02001953125, -0.012115478515625, -0.00238037109375, 0.005828857421875, 0.010345458984375, 0.010833740234375, 0.007537841796875, 0.001068115234375, -0.003082275390625, -0.00653076171875, -0.0115966796875, -0.01617431640625, -0.01708984375, -0.012969970703125, -0.0048828125, -0.000274658203125, -0.00189208984375, -0.003753662109375, -0.0015869140625, 6.103515625e-05, -0.00048828125, -0.001373291015625, -0.003509521484375, -0.00579833984375, -0.005096435546875, -0.004241943359375, -0.004486083984375, -0.0047607421875, -0.00506591796875, -0.00640869140625, -0.006103515625, -0.0032958984375, -0.00250244140625, -0.002166748046875, -0.002227783203125, -0.00201416015625, -0.001617431640625, -0.002044677734375, -0.00128173828125, -0.000457763671875, -0.00189208984375, -0.003875732421875, -0.004974365234375, -0.00604248046875, -0.005767822265625, -0.002655029296875, 0.000518798828125, 0.0009765625, 0.00213623046875, 0.002166748046875, -0.0003662109375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, 0.0, 0.0, 6.103515625e-05, 6.103515625e-05, 0.0001220703125, 0.000213623046875, 0.0001220703125, 0.000213623046875, -0.000152587890625, 0.0003662109375, -0.00030517578125, 0.000518798828125, -0.000274658203125, 0.00067138671875, 0.003143310546875, 0.053192138671875, 0.06219482421875, -0.059722900390625, -0.0665283203125, -0.013153076171875, -0.0296630859375, 0.028350830078125, 0.102783203125, 0.1160888671875, 0.094757080078125, 0.1087646484375, 0.11871337890625, 0.0675048828125, 0.011199951171875, -0.053009033203125, -0.111602783203125, -0.086669921875, -0.0345458984375, -0.05975341796875, -0.075927734375, -0.043487548828125, -0.012725830078125, -0.006378173828125, -0.000213623046875, 0.01666259765625, 0.02581787109375, 0.0216064453125, 0.023223876953125, 0.035186767578125, 0.02642822265625, 0.011138916015625, -0.004150390625, -0.01507568359375, -0.015838623046875, -0.016998291015625, -0.02685546875, -0.0355224609375, -0.025909423828125, -0.0072021484375, -0.0009765625, -0.000579833984375, 0.0068359375, 0.014495849609375, 0.012908935546875, 0.00933837890625, 0.003875732421875, -0.004425048828125, -0.00640869140625, -0.00457763671875, -0.00238037109375, -0.0032958984375, -0.005218505859375, -0.00604248046875, -0.00885009765625, -0.009765625, -0.009796142578125, -0.014556884765625, -0.01788330078125, -0.01531982421875, -0.0079345703125, -0.000518798828125, 0.00469970703125, 0.006805419921875, 0.00592041015625, 0.00103759765625, -0.0030517578125, -0.0032958984375, -0.006011962890625, -0.010833740234375, -0.01324462890625, -0.011810302734375, -0.0076904296875, -0.003173828125, -0.00262451171875, -0.005401611328125, -0.005096435546875, -0.0020751953125, -0.00091552734375, -0.0009765625, -0.003082275390625, -0.005645751953125, -0.00531005859375, -0.00390625, -0.003387451171875, -0.003692626953125, -0.0037841796875, -0.00390625, -0.003936767578125, -0.00299072265625, -0.002655029296875, -0.00311279296875, -0.0035400390625, -0.004119873046875, -0.00372314453125, -0.0028076171875, -0.002197265625, -0.001434326171875, -0.001068115234375, -0.002532958984375, -0.003753662109375, -0.004638671875, -0.0050048828125, -0.00396728515625, -0.00128173828125, 0.001007080078125, 0.001861572265625, 0.00311279296875, 0.001617431640625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, -9.1552734375e-05, 0.00030517578125, -0.000274658203125, 0.00030517578125, -0.000274658203125, 3.0517578125e-05, 0.004638671875, 0.04754638671875, 0.04376220703125, -0.04644775390625, -0.04541015625, -0.020477294921875, -0.0250244140625, 0.03070068359375, 0.08575439453125, 0.09820556640625, 0.08551025390625, 0.09765625, 0.102569580078125, 0.064788818359375, 0.008758544921875, -0.05718994140625, -0.093414306640625, -0.061431884765625, -0.02825927734375, -0.04815673828125, -0.052764892578125, -0.02874755859375, -0.00689697265625, -0.004150390625, -0.003997802734375, 0.006011962890625, 0.0162353515625, 0.018707275390625, 0.02301025390625, 0.030548095703125, 0.02008056640625, 0.005584716796875, -0.003814697265625, -0.0089111328125, -0.013031005859375, -0.021087646484375, -0.0294189453125, -0.026611328125, -0.01239013671875, -0.001068115234375, -0.00213623046875, -0.003936767578125, 0.0001220703125, 0.005950927734375, 0.00628662109375, 0.002716064453125, -0.001953125, -0.00543212890625, -0.006195068359375, -0.006103515625, -0.00225830078125, -0.00079345703125, -0.00311279296875, -0.004913330078125, -0.006134033203125, -0.007537841796875, -0.01055908203125, -0.01422119140625, -0.01495361328125, -0.012298583984375, -0.0069580078125, -0.001953125, 0.000946044921875, 0.001251220703125, 6.103515625e-05, -0.002288818359375, -0.002655029296875, -0.00164794921875, -0.00396728515625, -0.006805419921875, -0.0079345703125, -0.007110595703125, -0.0064697265625, -0.0064697265625, -0.007049560546875, -0.00738525390625, -0.005218505859375, -0.0035400390625, -0.0035400390625, -0.0042724609375, -0.005340576171875, -0.00482177734375, -0.003692626953125, -0.002960205078125, -0.003021240234375, -0.0023193359375, -0.001708984375, -0.001983642578125, -0.002227783203125, -0.002960205078125, -0.003570556640625, -0.004547119140625, -0.005279541015625, -0.0057373046875, -0.005126953125, -0.003875732421875, -0.002655029296875, -0.000946044921875, -0.00140380859375, -0.0025634765625, -0.0030517578125, -0.003753662109375, -0.004486083984375, -0.004241943359375, -0.001434326171875, 0.000823974609375, 0.0023193359375, 0.002685546875])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 0.0001220703125, 9.1552734375e-05, 6.103515625e-05, 0.0001220703125, 9.1552734375e-05, 0.000152587890625, 0.0001220703125, 0.000244140625, 6.103515625e-05, 0.000213623046875, 0.0001220703125, 0.0, 3.0517578125e-05, -6.103515625e-05, -0.00018310546875, 0.011383056640625, 0.04571533203125, 0.0181884765625, -0.037994384765625, -0.02886962890625, -0.025604248046875, -0.01043701171875, 0.036895751953125, 0.074066162109375, 0.085357666015625, 0.084075927734375, 0.091888427734375, 0.078582763671875, 0.047454833984375, -0.00225830078125, -0.0576171875, -0.069671630859375, -0.036773681640625, -0.0238037109375, -0.034942626953125, -0.0281982421875, -0.013458251953125, -0.007598876953125, -0.00970458984375, -0.0028076171875, 0.004669189453125, 0.009429931640625, 0.013031005859375, 0.019287109375, 0.020599365234375, 0.01226806640625, 0.004791259765625, -0.00262451171875, -0.00860595703125, -0.014556884765625, -0.019287109375, -0.020111083984375, -0.013275146484375, -0.005126953125, -0.00469970703125, -0.00738525390625, -0.006744384765625, -0.002532958984375, 0.000335693359375, 0.00054931640625, -6.103515625e-05, -0.003692626953125, -0.006378173828125, -0.007232666015625, -0.00360107421875, 0.001708984375, 0.001617431640625, -0.001007080078125, -0.003448486328125, -0.005859375, -0.009246826171875, -0.012542724609375, -0.013641357421875, -0.011962890625, -0.009735107421875, -0.0069580078125, -0.00341796875, -0.001068115234375, 0.000152587890625, -0.001190185546875, -0.00244140625, -0.001129150390625, -0.000640869140625, -0.00201416015625, -0.00408935546875, -0.005126953125, -0.006378173828125, -0.00738525390625, -0.007568359375, -0.007720947265625, -0.0069580078125, -0.006072998046875, -0.005615234375, -0.00543212890625, -0.005035400390625, -0.004608154296875, -0.00360107421875, -0.002105712890625, -0.00164794921875, -0.001617431640625, -0.00152587890625, -0.0013427734375, -0.0013427734375, -0.001678466796875, -0.00250244140625, -0.00396728515625, -0.00518798828125, -0.005828857421875, -0.00543212890625, -0.004241943359375, -0.003204345703125, -0.00189208984375, -0.00067138671875, -0.00091552734375, -0.0015869140625, -0.0025634765625, -0.003936767578125, -0.00469970703125, -0.003509521484375, -0.000946044921875, 0.000579833984375, 0.00213623046875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0001220703125, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 9.1552734375e-05, 9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 0.00018310546875, 9.1552734375e-05, 0.0001220703125, 6.103515625e-05, 0.000213623046875, -0.000152587890625, 3.0517578125e-05, -3.0517578125e-05, 0.000335693359375, 3.0517578125e-05, 0.01483154296875, 0.0347900390625, 0.005279541015625, -0.02276611328125, -0.021820068359375, -0.0244140625, -0.001556396484375, 0.033203125, 0.0623779296875, 0.0787353515625, 0.07562255859375, 0.066619873046875, 0.058013916015625, 0.0435791015625, 0.0010986328125, -0.0460205078125, -0.044189453125, -0.016082763671875, -0.008087158203125, -0.00823974609375, -0.01361083984375, -0.016815185546875, -0.012542724609375, -0.00927734375, -0.00848388671875, -0.00714111328125, -0.00030517578125, 0.004486083984375, 0.010223388671875, 0.01544189453125, 0.01226806640625, 0.001556396484375, -0.00634765625, -0.006317138671875, -0.004791259765625, -0.0081787109375, -0.010345458984375, -0.008148193359375, -0.0072021484375, -0.0087890625, -0.01043701171875, -0.010833740234375, -0.008575439453125, -0.003936767578125, -0.0018310546875, -0.003570556640625, -0.00750732421875, -0.00787353515625, -0.004852294921875, 0.000152587890625, 0.004608154296875, 0.00360107421875, 0.0001220703125, -0.003875732421875, -0.007537841796875, -0.0103759765625, -0.01239013671875, -0.0123291015625, -0.01129150390625, -0.009735107421875, -0.00732421875, -0.002838134765625, 0.000213623046875, -0.00048828125, -0.0020751953125, -0.00311279296875, -0.00189208984375, -0.00115966796875, -0.0018310546875, -0.002716064453125, -0.0042724609375, -0.005767822265625, -0.0068359375, -0.00726318359375, -0.007720947265625, -0.007568359375, -0.00701904296875, -0.006927490234375, -0.006195068359375, -0.005340576171875, -0.004425048828125, -0.00262451171875, -0.00140380859375, -0.002105712890625, -0.0030517578125, -0.001708984375, -0.00048828125, -0.000274658203125, -0.000946044921875, -0.002471923828125, -0.0042724609375, -0.005462646484375, -0.004791259765625, -0.004119873046875, -0.004119873046875, -0.003448486328125, -0.00152587890625, -0.000396728515625, -0.000823974609375, -0.001861572265625, -0.00390625, -0.00518798828125, -0.00518798828125, -0.0035400390625, -0.001861572265625, -0.00067138671875])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 9.1552734375e-05, 9.1552734375e-05, 9.1552734375e-05, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, -6.103515625e-05, 0.000213623046875, -6.103515625e-05, 3.0517578125e-05, 0.0020751953125, 0.0198974609375, 0.02252197265625, -0.004974365234375, -0.014434814453125, -0.0191650390625, -0.01666259765625, 0.009796142578125, 0.040618896484375, 0.05621337890625, 0.057098388671875, 0.05859375, 0.053863525390625, 0.052734375, 0.04022216796875, -0.00128173828125, -0.029876708984375, -0.0118408203125, 0.007598876953125, 0.002685546875, -0.006744384765625, -0.017822265625, -0.01910400390625, -0.01666259765625, -0.01544189453125, -0.01678466796875, -0.013275146484375, -0.006683349609375, -0.000152587890625, 0.0101318359375, 0.012451171875, 0.004730224609375, -0.003509521484375, -0.000274658203125, 0.006988525390625, 0.00537109375, -0.00335693359375, -0.008331298828125, -0.0093994140625, -0.011138916015625, -0.0126953125, -0.0137939453125, -0.01312255859375, -0.010345458984375, -0.007049560546875, -0.005767822265625, -0.006988525390625, -0.007965087890625, -0.006378173828125, -0.002777099609375, 0.00286865234375, 0.00701904296875, 0.0048828125, -0.000885009765625, -0.00579833984375, -0.00872802734375, -0.0103759765625, -0.011627197265625, -0.01171875, -0.010711669921875, -0.00860595703125, -0.004425048828125, -0.00091552734375, -0.001068115234375, -0.002685546875, -0.004119873046875, -0.004364013671875, -0.00323486328125, -0.002838134765625, -0.00213623046875, -0.00128173828125, -0.002410888671875, -0.0048828125, -0.0062255859375, -0.006622314453125, -0.0072021484375, -0.007843017578125, -0.008056640625, -0.007568359375, -0.006622314453125, -0.00567626953125, -0.00457763671875, -0.003204345703125, -0.002838134765625, -0.0032958984375, -0.002471923828125, -0.000396728515625, 0.000732421875, 0.000396728515625, -0.000823974609375, -0.00262451171875, -0.00384521484375, -0.004302978515625, -0.00457763671875, -0.00445556640625, -0.00384521484375, -0.002685546875, -0.001129150390625, -0.001068115234375, -0.00201416015625, -0.003692626953125, -0.00537109375, -0.00592041015625, -0.005584716796875, -0.00384521484375, -0.0025634765625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 0.0, 3.0517578125e-05, 9.1552734375e-05, 9.1552734375e-05, -6.103515625e-05, -0.0001220703125, -3.0517578125e-05, 0.0040283203125, 0.01739501953125, 0.01263427734375, -0.006103515625, -0.009490966796875, -0.011077880859375, -0.0003662109375, 0.018280029296875, 0.024932861328125, 0.026397705078125, 0.03778076171875, 0.055389404296875, 0.058258056640625, 0.05706787109375, 0.045440673828125, 0.01690673828125, 0.003631591796875, 0.01153564453125, 0.00469970703125, -0.0098876953125, -0.013702392578125, -0.018463134765625, -0.024139404296875, -0.02545166015625, -0.022552490234375, -0.022705078125, -0.0181884765625, -0.00994873046875, -0.000152587890625, 0.007049560546875, 0.00396728515625, 0.003326416015625, 0.010467529296875, 0.01739501953125, 0.016693115234375, 0.00653076171875, -0.00555419921875, -0.01129150390625, -0.01324462890625, -0.016754150390625, -0.017303466796875, -0.01470947265625, -0.0150146484375, -0.01446533203125, -0.01092529296875, -0.007476806640625, -0.007293701171875, -0.007171630859375, -0.0045166015625, 0.0, 0.005767822265625, 0.006988525390625, 0.00360107421875, -0.001007080078125, -0.00518798828125, -0.008636474609375, -0.009918212890625, -0.00970458984375, -0.01025390625, -0.009124755859375, -0.00732421875, -0.004852294921875, -0.002716064453125, -0.003387451171875, -0.005401611328125, -0.00677490234375, -0.00689697265625, -0.0057373046875, -0.00250244140625, 0.000946044921875, 0.001983642578125, -0.00048828125, -0.003692626953125, -0.005615234375, -0.007110595703125, -0.008056640625, -0.008758544921875, -0.008880615234375, -0.0084228515625, -0.0076904296875, -0.006378173828125, -0.005157470703125, -0.00439453125, -0.0035400390625, -0.002349853515625, -0.00030517578125, 0.00091552734375, 0.00103759765625, 0.0006103515625, -0.000396728515625, -0.001678466796875, -0.003814697265625, -0.0050048828125, -0.004547119140625, -0.00384521484375, -0.00341796875, -0.002960205078125, -0.002532958984375, -0.0028076171875, -0.003509521484375, -0.004913330078125, -0.006072998046875, -0.006500244140625, -0.006011962890625, -0.004638671875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 0.0, 9.1552734375e-05, 6.103515625e-05, 0.0001220703125, 9.1552734375e-05, 3.0517578125e-05, 6.103515625e-05, 0.0, -6.103515625e-05, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 0.0, 0.00018310546875, 0.000152587890625, 0.0001220703125, -0.000152587890625, 0.0, 6.103515625e-05, 0.00634765625, 0.015045166015625, 0.00531005859375, -0.005950927734375, 0.00152587890625, 0.00677490234375, -0.003021240234375, -0.005157470703125, 0.01068115234375, 0.027069091796875, 0.046630859375, 0.065887451171875, 0.0665283203125, 0.06365966796875, 0.05950927734375, 0.031463623046875, 0.00286865234375, -0.003662109375, -0.010498046875, -0.01885986328125, -0.017913818359375, -0.02044677734375, -0.031982421875, -0.0323486328125, -0.023193359375, -0.019622802734375, -0.015228271484375, -0.007049560546875, -0.0001220703125, 0.002532958984375, 0.008392333984375, 0.020294189453125, 0.025146484375, 0.01983642578125, 0.01190185546875, -0.00030517578125, -0.012115478515625, -0.015380859375, -0.017608642578125, -0.02142333984375, -0.01959228515625, -0.01568603515625, -0.015655517578125, -0.01458740234375, -0.010284423828125, -0.006927490234375, -0.005615234375, -0.00421142578125, -0.00115966796875, 0.00238037109375, 0.004913330078125, 0.004974365234375, 0.00335693359375, 0.000213623046875, -0.00506591796875, -0.008544921875, -0.009033203125, -0.008636474609375, -0.008697509765625, -0.00830078125, -0.0078125, -0.006866455078125, -0.005157470703125, -0.0054931640625, -0.008087158203125, -0.00958251953125, -0.007293701171875, -0.002288818359375, 0.00225830078125, 0.004669189453125, 0.002777099609375, -0.001708984375, -0.005126953125, -0.0068359375, -0.007965087890625, -0.00909423828125, -0.00933837890625, -0.00885009765625, -0.007904052734375, -0.00732421875, -0.006378173828125, -0.004974365234375, -0.003692626953125, -0.002105712890625, -0.000396728515625, 0.001220703125, 0.0013427734375, 0.001251220703125, 0.000701904296875, -0.001312255859375, -0.003387451171875, -0.00445556640625, -0.00433349609375, -0.003936767578125, -0.00360107421875, -0.003814697265625, -0.003692626953125, -0.00311279296875, -0.003326416015625, -0.0042724609375, -0.0057373046875, -0.00634765625, -0.00604248046875, -0.00531005859375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, 9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0001220703125, 9.1552734375e-05, 3.0517578125e-05, 9.1552734375e-05, 0.000213623046875, 9.1552734375e-05, -3.0517578125e-05, -0.000335693359375, -0.0001220703125, 0.00091552734375, 0.007598876953125, 0.011383056640625, 0.009429931640625, 0.012451171875, -0.00146484375, -0.021087646484375, -0.0181884765625, 0.001983642578125, 0.02972412109375, 0.045440673828125, 0.054412841796875, 0.07330322265625, 0.087493896484375, 0.0791015625, 0.045745849609375, 0.00225830078125, -0.01678466796875, -0.01324462890625, -0.016387939453125, -0.026519775390625, -0.0277099609375, -0.02642822265625, -0.0330810546875, -0.027679443359375, -0.013946533203125, -0.011566162109375, -0.011138916015625, -0.00579833984375, 0.00067138671875, 0.012420654296875, 0.024993896484375, 0.02740478515625, 0.02191162109375, 0.013671875, 0.00299072265625, -0.00982666015625, -0.019287109375, -0.020721435546875, -0.020721435546875, -0.022705078125, -0.0205078125, -0.01531982421875, -0.01239013671875, -0.011566162109375, -0.0081787109375, -0.00421142578125, -0.00360107421875, -0.00262451171875, -0.000396728515625, 0.002960205078125, 0.0057373046875, 0.0059814453125, 0.002166748046875, -0.002716064453125, -0.00518798828125, -0.0069580078125, -0.007232666015625, -0.00872802734375, -0.009979248046875, -0.009490966796875, -0.009307861328125, -0.00836181640625, -0.007781982421875, -0.00823974609375, -0.00927734375, -0.007049560546875, -0.00213623046875, 0.002288818359375, 0.0047607421875, 0.0030517578125, -0.001129150390625, -0.004669189453125, -0.005889892578125, -0.007415771484375, -0.008758544921875, -0.00860595703125, -0.00830078125, -0.007568359375, -0.00787353515625, -0.007110595703125, -0.005126953125, -0.003631591796875, -0.002288818359375, -0.000518798828125, 0.001068115234375, 0.001617431640625, 0.0015869140625, 0.00048828125, -0.001861572265625, -0.003692626953125, -0.0040283203125, -0.004150390625, -0.00433349609375, -0.00390625, -0.0037841796875, -0.003509521484375, -0.00311279296875, -0.00341796875, -0.004150390625, -0.004852294921875, -0.005340576171875, -0.005767822265625, -0.00579833984375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 0.0, -9.1552734375e-05, -9.1552734375e-05, -6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, 0.0001220703125, 6.103515625e-05, -0.0001220703125, 3.0517578125e-05, -0.000152587890625, -0.0001220703125, -0.00030517578125, 0.00018310546875, 0.000946044921875, 0.01495361328125, 0.03173828125, 0.00567626953125, -0.027374267578125, -0.02685546875, -0.00946044921875, 0.013580322265625, 0.0291748046875, 0.041168212890625, 0.055938720703125, 0.07867431640625, 0.095977783203125, 0.075592041015625, 0.032623291015625, 0.006622314453125, -0.00927734375, -0.0213623046875, -0.023651123046875, -0.030242919921875, -0.03826904296875, -0.031890869140625, -0.017822265625, -0.0179443359375, -0.017486572265625, -0.003753662109375, 0.00115966796875, -0.00543212890625, -0.005035400390625, 0.009552001953125, 0.02398681640625, 0.02691650390625, 0.022216796875, 0.01373291015625, 0.00030517578125, -0.010589599609375, -0.01708984375, -0.023284912109375, -0.02386474609375, -0.021392822265625, -0.02008056640625, -0.01763916015625, -0.01226806640625, -0.008087158203125, -0.00732421875, -0.005950927734375, -0.004302978515625, -0.0030517578125, -0.00079345703125, 0.003326416015625, 0.0050048828125, 0.0035400390625, 0.001739501953125, -0.000701904296875, -0.002044677734375, -0.003387451171875, -0.005950927734375, -0.0093994140625, -0.01226806640625, -0.012176513671875, -0.01043701171875, -0.009796142578125, -0.0096435546875, -0.0084228515625, -0.007110595703125, -0.00506591796875, -0.002349853515625, -9.1552734375e-05, 0.000457763671875, -0.00091552734375, -0.001678466796875, -0.002044677734375, -0.003662109375, -0.00634765625, -0.00726318359375, -0.006561279296875, -0.006591796875, -0.00750732421875, -0.008331298828125, -0.007598876953125, -0.005828857421875, -0.0035400390625, -0.00213623046875, -0.001251220703125, 0.000335693359375, 0.00128173828125, 0.0009765625, -0.0009765625, -0.0030517578125, -0.00439453125, -0.004974365234375, -0.004638671875, -0.004302978515625, -0.00384521484375, -0.003204345703125, -0.002777099609375, -0.002716064453125, -0.002960205078125, -0.003143310546875, -0.00372314453125, -0.004669189453125, -0.006103515625, -0.006805419921875])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0001220703125, 9.1552734375e-05, 9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 9.1552734375e-05, 9.1552734375e-05, 0.000213623046875, 9.1552734375e-05, 9.1552734375e-05, -9.1552734375e-05, 0.0, -9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, 0.007293701171875, 0.0283203125, 0.0167236328125, -0.02001953125, -0.028717041015625, -0.01397705078125, 0.00982666015625, 0.025421142578125, 0.031524658203125, 0.039764404296875, 0.069183349609375, 0.094512939453125, 0.070404052734375, 0.035736083984375, 0.023590087890625, 0.01092529296875, -0.0030517578125, -0.0167236328125, -0.035552978515625, -0.0396728515625, -0.032562255859375, -0.0286865234375, -0.02008056640625, -0.006591796875, -0.002410888671875, -0.00146484375, 0.008880615234375, 0.008148193359375, -0.00445556640625, -0.000823974609375, 0.01593017578125, 0.026336669921875, 0.020965576171875, 0.00823974609375, -0.003692626953125, -0.012847900390625, -0.016387939453125, -0.01922607421875, -0.022216796875, -0.0224609375, -0.01873779296875, -0.015106201171875, -0.012115478515625, -0.007720947265625, -0.005615234375, -0.006103515625, -0.004852294921875, -0.000244140625, 0.00238037109375, 0.001953125, 0.000885009765625, 0.001129150390625, 0.001983642578125, 0.001556396484375, -0.00042724609375, -0.004180908203125, -0.007049560546875, -0.009918212890625, -0.01129150390625, -0.011962890625, -0.01141357421875, -0.009368896484375, -0.008087158203125, -0.0069580078125, -0.005828857421875, -0.003875732421875, -0.003692626953125, -0.00445556640625, -0.004364013671875, -0.002716064453125, -0.00079345703125, -0.000732421875, -0.002288818359375, -0.003936767578125, -0.003997802734375, -0.003936767578125, -0.005218505859375, -0.007354736328125, -0.008514404296875, -0.00732421875, -0.005126953125, -0.003662109375, -0.002593994140625, -0.0013427734375, 0.00030517578125, 0.001251220703125, 0.00018310546875, -0.0020751953125, -0.004241943359375, -0.005279541015625, -0.0052490234375, -0.004852294921875, -0.004180908203125, -0.00311279296875, -0.00189208984375, -0.001434326171875, -0.00146484375, -0.001800537109375, -0.002044677734375, -0.0028076171875, -0.004302978515625, -0.005889892578125, -0.0072021484375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0001220703125, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 0.0001220703125, 6.103515625e-05, 0.0001220703125, 9.1552734375e-05, 6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 0.0001220703125, 0.0, 3.0517578125e-05, 0.0, 0.0001220703125, 6.103515625e-05, 0.00018310546875, 0.0001220703125, 0.0, 9.1552734375e-05, -3.0517578125e-05, 0.000244140625, 0.006866455078125, 0.034454345703125, 0.018707275390625, -0.03607177734375, -0.036224365234375, -0.007080078125, 0.018524169921875, 0.032562255859375, 0.0341796875, 0.036529541015625, 0.064239501953125, 0.0955810546875, 0.0687255859375, 0.019805908203125, -0.001129150390625, 0.0006103515625, 0.006988525390625, -0.000244140625, -0.0211181640625, -0.034912109375, -0.03802490234375, -0.02972412109375, -0.01617431640625, -0.012359619140625, -0.006195068359375, 0.010162353515625, 0.018280029296875, 0.015777587890625, 0.013824462890625, 0.003570556640625, -0.0050048828125, 0.002410888671875, 0.01470947265625, 0.014068603515625, 0.00054931640625, -0.009033203125, -0.01226806640625, -0.014862060546875, -0.017852783203125, -0.01910400390625, -0.018402099609375, -0.0169677734375, -0.01373291015625, -0.009368896484375, -0.008148193359375, -0.005828857421875, -0.001678466796875, -0.00103759765625, 0.00042724609375, 0.002288818359375, 0.000518798828125, -0.002410888671875, -0.00164794921875, 0.001251220703125, 0.00067138671875, -0.003082275390625, -0.006805419921875, -0.00848388671875, -0.009429931640625, -0.009521484375, -0.010162353515625, -0.009796142578125, -0.007965087890625, -0.00726318359375, -0.005889892578125, -0.005340576171875, -0.005340576171875, -0.006378173828125, -0.007171630859375, -0.006134033203125, -0.003997802734375, -0.002044677734375, -0.0009765625, -0.000885009765625, -0.00091552734375, -0.000823974609375, -0.0020751953125, -0.0042724609375, -0.0064697265625, -0.008026123046875, -0.0076904296875, -0.005401611328125, -0.003204345703125, -0.0028076171875, -0.002166748046875, -0.000335693359375, 0.00048828125, -0.000579833984375, -0.00299072265625, -0.005340576171875, -0.006561279296875, -0.006195068359375, -0.005462646484375, -0.003692626953125, -0.001495361328125, -0.00042724609375, -0.00030517578125, -0.000823974609375, -0.0008544921875, -0.001129150390625, -0.0023193359375, -0.004058837890625, -0.006103515625, -0.007232666015625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0001220703125, 9.1552734375e-05, 6.103515625e-05, 0.0001220703125, 6.103515625e-05, 9.1552734375e-05, 9.1552734375e-05, 9.1552734375e-05, 0.0001220703125, 9.1552734375e-05, 9.1552734375e-05, 9.1552734375e-05, 9.1552734375e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 0.0, 0.000244140625, -0.000244140625, 0.00030517578125, -0.00018310546875, 0.00048828125, 0.003143310546875, 0.034454345703125, 0.037200927734375, -0.034881591796875, -0.05548095703125, -0.020904541015625, 0.01617431640625, 0.04345703125, 0.0458984375, 0.04205322265625, 0.0595703125, 0.10260009765625, 0.085418701171875, 0.014312744140625, -0.019805908203125, -0.0146484375, -0.0125732421875, -0.01409912109375, -0.01507568359375, -0.025054931640625, -0.030120849609375, -0.024139404296875, -0.0152587890625, -0.01092529296875, -0.00323486328125, 0.006622314453125, 0.014068603515625, 0.02532958984375, 0.028839111328125, 0.017486572265625, 0.003326416015625, -0.004150390625, -0.0042724609375, -0.00244140625, -0.000457763671875, -0.000885009765625, -0.006561279296875, -0.0140380859375, -0.017486572265625, -0.01654052734375, -0.016143798828125, -0.014556884765625, -0.013519287109375, -0.01177978515625, -0.0069580078125, -0.003875732421875, -0.003448486328125, -0.001953125, 0.001739501953125, 0.00323486328125, 0.000274658203125, -0.003021240234375, -0.0037841796875, -0.002685546875, -0.001861572265625, -0.0035400390625, -0.0069580078125, -0.008392333984375, -0.0079345703125, -0.006866455078125, -0.00799560546875, -0.01019287109375, -0.008270263671875, -0.006561279296875, -0.007293701171875, -0.006927490234375, -0.00506591796875, -0.00408935546875, -0.00604248046875, -0.007904052734375, -0.007476806640625, -0.00518798828125, -0.002899169921875, -0.001556396484375, -0.000732421875, 0.00048828125, 0.000518798828125, -0.00115966796875, -0.0030517578125, -0.00567626953125, -0.007476806640625, -0.00738525390625, -0.005828857421875, -0.0035400390625, -0.002044677734375, -0.001495361328125, -0.001739501953125, -0.001678466796875, -0.001708984375, -0.00323486328125, -0.005462646484375, -0.006927490234375, -0.006622314453125, -0.0052490234375, -0.003173828125, -0.0010986328125, 0.000244140625, 0.00030517578125, -9.1552734375e-05, -0.000213623046875, -0.0010986328125, -0.00225830078125, -0.00360107421875, -0.005767822265625, -0.00701904296875])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 9.1552734375e-05, 0.0001220703125, 9.1552734375e-05, 9.1552734375e-05, 3.0517578125e-05, 9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, 0.000152587890625, 9.1552734375e-05, 0.00018310546875, 0.0001220703125, 0.0, -0.000152587890625, 0.000152587890625, -0.00018310546875, 0.00030517578125, -0.000396728515625, 0.000274658203125, -0.00048828125, 0.000732421875, 0.00152587890625, 0.035736083984375, 0.05413818359375, -0.035003662109375, -0.07379150390625, -0.0296630859375, 0.012481689453125, 0.04742431640625, 0.05487060546875, 0.05303955078125, 0.067474365234375, 0.120880126953125, 0.107757568359375, 0.011199951171875, -0.036895751953125, -0.03167724609375, -0.02978515625, -0.031951904296875, -0.037200927734375, -0.04656982421875, -0.0345458984375, -0.016998291015625, -0.006011962890625, 0.001800537109375, 0.004119873046875, 0.012237548828125, 0.0225830078125, 0.02691650390625, 0.030517578125, 0.027374267578125, 0.018463134765625, 0.00628662109375, -0.0069580078125, -0.01275634765625, -0.016326904296875, -0.013458251953125, -0.006561279296875, -0.0069580078125, -0.014495849609375, -0.018035888671875, -0.016326904296875, -0.014190673828125, -0.01165771484375, -0.005706787109375, -0.000946044921875, -0.003021240234375, -0.003631591796875, -0.00140380859375, 0.001678466796875, 0.004180908203125, 0.0010986328125, -0.00494384765625, -0.00701904296875, -0.005126953125, -0.003204345703125, -0.00506591796875, -0.009674072265625, -0.010345458984375, -0.008056640625, -0.006103515625, -0.00665283203125, -0.0103759765625, -0.010833740234375, -0.00830078125, -0.00592041015625, -0.0045166015625, -0.003814697265625, -0.002471923828125, -0.002410888671875, -0.005218505859375, -0.00836181640625, -0.00982666015625, -0.00762939453125, -0.00372314453125, -0.001678466796875, -0.000579833984375, 0.000396728515625, 9.1552734375e-05, -0.000579833984375, -0.002044677734375, -0.005035400390625, -0.0067138671875, -0.00689697265625, -0.005523681640625, -0.002960205078125, -0.0006103515625, -0.0009765625, -0.003814697265625, -0.00469970703125, -0.003692626953125, -0.003570556640625, -0.00469970703125, -0.00616455078125, -0.006256103515625, -0.004669189453125, -0.0028076171875, -0.00146484375, -0.000274658203125, 0.00042724609375, 0.00054931640625, 0.000274658203125, -0.00115966796875, -0.002288818359375, -0.003509521484375, -0.005462646484375, -0.006744384765625])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 9.1552734375e-05, 9.1552734375e-05, 0.0001220703125, 9.1552734375e-05, 6.103515625e-05, 0.000213623046875, 9.1552734375e-05, 0.00018310546875, -0.0001220703125, 0.000213623046875, -0.000244140625, 0.000335693359375, -0.000244140625, 6.103515625e-05, -0.00030517578125, 0.000396728515625, -3.0517578125e-05, 0.025604248046875, 0.0736083984375, -0.012603759765625, -0.0948486328125, -0.045013427734375, 0.00482177734375, 0.04742431640625, 0.06103515625, 0.059356689453125, 0.067413330078125, 0.1258544921875, 0.14501953125, 0.032989501953125, -0.04876708984375, -0.043731689453125, -0.036041259765625, -0.042938232421875, -0.05059814453125, -0.063262939453125, -0.0570068359375, -0.037200927734375, -0.01190185546875, 0.006011962890625, 0.00921630859375, 0.022796630859375, 0.033477783203125, 0.03564453125, 0.03875732421875, 0.035552978515625, 0.0172119140625, 0.008392333984375, 0.0106201171875, -6.103515625e-05, -0.021087646484375, -0.02935791015625, -0.021392822265625, -0.014984130859375, -0.0111083984375, -0.0113525390625, -0.017364501953125, -0.01763916015625, -0.00787353515625, 6.103515625e-05, 0.0015869140625, 0.000579833984375, -0.000579833984375, -0.000213623046875, 0.001495361328125, 0.00421142578125, 0.001007080078125, -0.0081787109375, -0.00946044921875, -0.004791259765625, -0.003173828125, -0.005218505859375, -0.00830078125, -0.0111083984375, -0.010498046875, -0.00799560546875, -0.0084228515625, -0.013824462890625, -0.0152587890625, -0.0089111328125, -0.004150390625, -0.00189208984375, -0.00018310546875, 0.000732421875, 0.000885009765625, -0.00164794921875, -0.0062255859375, -0.010162353515625, -0.0120849609375, -0.00970458984375, -0.00518798828125, -0.001373291015625, 0.000762939453125, -9.1552734375e-05, -0.001129150390625, -0.00079345703125, -0.001312255859375, -0.00390625, -0.006500244140625, -0.006744384765625, -0.003936767578125, -0.00030517578125, 0.000244140625, -0.002655029296875, -0.005462646484375, -0.005828857421875, -0.004852294921875, -0.0040283203125, -0.00390625, -0.005462646484375, -0.005645751953125, -0.003997802734375, -0.0020751953125, -0.001373291015625, -0.001251220703125, -0.000274658203125, 0.000762939453125, 0.00079345703125, -0.000579833984375, -0.002410888671875, -0.00439453125, -0.00531005859375, -0.0062255859375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0001220703125, 6.103515625e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0001220703125, 3.0517578125e-05, 0.00018310546875, 0.0001220703125, 0.000244140625, -3.0517578125e-05, 0.0001220703125, -3.0517578125e-05, 6.103515625e-05, 0.000244140625, -0.000244140625, 0.000213623046875, -0.00054931640625, 0.000701904296875, 0.01300048828125, 0.083251953125, 0.024444580078125, -0.112762451171875, -0.069549560546875, -0.001556396484375, 0.046112060546875, 0.069122314453125, 0.0648193359375, 0.068695068359375, 0.122406005859375, 0.178985595703125, 0.069091796875, -0.055419921875, -0.057647705078125, -0.04119873046875, -0.05218505859375, -0.057525634765625, -0.07196044921875, -0.075714111328125, -0.0537109375, -0.03173828125, -0.007293701171875, 0.006134033203125, 0.022430419921875, 0.04083251953125, 0.047637939453125, 0.050445556640625, 0.044891357421875, 0.024810791015625, 0.014373779296875, 0.01318359375, 0.00885009765625, -0.006072998046875, -0.026824951171875, -0.03411865234375, -0.0296630859375, -0.024017333984375, -0.019683837890625, -0.0140380859375, -0.00799560546875, -0.002685546875, -0.000518798828125, 0.00433349609375, 0.00665283203125, 0.00384521484375, 0.00189208984375, 0.00054931640625, 0.001190185546875, -0.000518798828125, -0.007537841796875, -0.011138916015625, -0.008758544921875, -0.00347900390625, -0.0009765625, -0.005157470703125, -0.010894775390625, -0.012176513671875, -0.011383056640625, -0.0130615234375, -0.01776123046875, -0.01953125, -0.0128173828125, -0.004669189453125, 0.001129150390625, 0.004608154296875, 0.00518798828125, 0.00421142578125, 0.001220703125, -0.003204345703125, -0.007904052734375, -0.012939453125, -0.01483154296875, -0.011077880859375, -0.00555419921875, -0.001007080078125, 0.000213623046875, -0.001007080078125, -0.000579833984375, 3.0517578125e-05, -0.001220703125, -0.0040283203125, -0.006317138671875, -0.004974365234375, -0.00152587890625, 0.0003662109375, -0.001007080078125, -0.004241943359375, -0.00579833984375, -0.0054931640625, -0.005645751953125, -0.005462646484375, -0.0048828125, -0.0045166015625, -0.004241943359375, -0.0040283203125, -0.00286865234375, -0.00140380859375, -0.000732421875, 0.00030517578125, 0.00115966796875, 0.0001220703125, -0.00140380859375, -0.003326416015625, -0.0048828125, -0.0052490234375, -0.0062255859375])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0001220703125, 0.0001220703125, 0.000335693359375, 6.103515625e-05, 9.1552734375e-05, 0.00018310546875, -0.000213623046875, 0.00054931640625, -0.000701904296875, 0.001129150390625, -0.001373291015625, 0.001861572265625, 0.007659912109375, 0.093414306640625, 0.0517578125, -0.138885498046875, -0.0928955078125, -0.000244140625, 0.048675537109375, 0.0841064453125, 0.075103759765625, 0.07562255859375, 0.1259765625, 0.20849609375, 0.093994140625, -0.06829833984375, -0.0732421875, -0.04632568359375, -0.062164306640625, -0.0694580078125, -0.080718994140625, -0.0904541015625, -0.06884765625, -0.042816162109375, -0.0115966796875, -0.000396728515625, 0.01220703125, 0.0382080078125, 0.054351806640625, 0.05633544921875, 0.055328369140625, 0.03790283203125, 0.019500732421875, 0.019378662109375, 0.013824462890625, -0.004302978515625, -0.02313232421875, -0.025726318359375, -0.031005859375, -0.04150390625, -0.03564453125, -0.01922607421875, -0.006500244140625, 0.003997802734375, 0.009368896484375, 0.01177978515625, 0.012115478515625, 0.007965087890625, 0.003814697265625, -0.000885009765625, -0.00238037109375, -0.000823974609375, -0.009307861328125, -0.016387939453125, -0.0098876953125, -0.0015869140625, 0.000701904296875, -0.003021240234375, -0.008880615234375, -0.01361083984375, -0.016815185546875, -0.017822265625, -0.018768310546875, -0.021697998046875, -0.016571044921875, -0.00506591796875, 0.00335693359375, 0.00848388671875, 0.009063720703125, 0.00701904296875, 0.00390625, -0.00164794921875, -0.0069580078125, -0.0123291015625, -0.015960693359375, -0.013763427734375, -0.009796142578125, -0.00665283203125, -0.0032958984375, -0.000518798828125, 0.001312255859375, 0.00128173828125, -9.1552734375e-05, -0.001373291015625, -0.002899169921875, -0.003143310546875, -0.002166748046875, -0.002349853515625, -0.00299072265625, -0.0025634765625, -0.00250244140625, -0.00408935546875, -0.006744384765625, -0.007537841796875, -0.006072998046875, -0.0042724609375, -0.00408935546875, -0.0054931640625, -0.005645751953125, -0.00299072265625, 0.00018310546875, 0.001861572265625, 0.00250244140625, 0.000946044921875, -0.001220703125, -0.002838134765625, -0.004608154296875, -0.005828857421875, -0.006622314453125, -0.006866455078125])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0001220703125, 0.000213623046875, 0.000213623046875, 0.0003662109375, -0.0001220703125, 0.0006103515625, -0.0006103515625, 0.0010986328125, -0.00115966796875, 0.001739501953125, -0.001678466796875, 0.002777099609375, 0.000457763671875, 0.08258056640625, 0.10540771484375, -0.1375732421875, -0.142608642578125, -0.0010986328125, 0.041015625, 0.09375, 0.086822509765625, 0.084075927734375, 0.12060546875, 0.2235107421875, 0.142303466796875, -0.064208984375, -0.093841552734375, -0.0501708984375, -0.065277099609375, -0.0810546875, -0.084320068359375, -0.104339599609375, -0.08197021484375, -0.05499267578125, -0.021484375, 0.00042724609375, 0.00830078125, 0.030487060546875, 0.04718017578125, 0.06011962890625, 0.064361572265625, 0.04791259765625, 0.025665283203125, 0.02252197265625, 0.01556396484375, 0.000152587890625, -0.02276611328125, -0.03253173828125, -0.026885986328125, -0.028167724609375, -0.033477783203125, -0.032501220703125, -0.018798828125, 0.00042724609375, 0.01422119140625, 0.019805908203125, 0.01947021484375, 0.011810302734375, 0.003204345703125, 0.000885009765625, -0.00048828125, -0.000762939453125, -0.007598876953125, -0.01776123046875, -0.0150146484375, -0.00518798828125, 0.001617431640625, -0.00054931640625, -0.00927734375, -0.015716552734375, -0.01678466796875, -0.01617431640625, -0.0179443359375, -0.022979736328125, -0.018951416015625, -0.005584716796875, 0.004638671875, 0.009368896484375, 0.010162353515625, 0.008636474609375, 0.00518798828125, -0.00054931640625, -0.006805419921875, -0.011322021484375, -0.014862060546875, -0.01519775390625, -0.011871337890625, -0.009033203125, -0.005767822265625, -0.00262451171875, 0.000244140625, 0.002471923828125, 0.0018310546875, 0.000762939453125, -0.000457763671875, -0.000701904296875, 0.0, -0.001922607421875, -0.0052490234375, -0.004913330078125, -0.0023193359375, -0.00164794921875, -0.004150390625, -0.0069580078125, -0.006927490234375, -0.00518798828125, -0.00433349609375, -0.00579833984375, -0.00732421875, -0.005584716796875, -0.001800537109375, 0.001953125, 0.0048828125, 0.0042724609375, 0.000762939453125, -0.00238037109375, -0.004302978515625, -0.005462646484375, -0.006317138671875, -0.007049560546875, -0.007537841796875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, -9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, -9.1552734375e-05, 3.0517578125e-05, 0.000213623046875, 0.0, 0.00042724609375, -0.0003662109375, 0.000701904296875, -0.000762939453125, 0.00128173828125, -0.0013427734375, 0.0018310546875, -0.001617431640625, 0.0029296875, -0.001129150390625, 0.08135986328125, 0.140960693359375, -0.14532470703125, -0.190704345703125, 0.00433349609375, 0.045257568359375, 0.10198974609375, 0.101470947265625, 0.095001220703125, 0.1329345703125, 0.242919921875, 0.17047119140625, -0.069061279296875, -0.117950439453125, -0.060028076171875, -0.066314697265625, -0.095733642578125, -0.094970703125, -0.11248779296875, -0.0970458984375, -0.06304931640625, -0.02423095703125, -0.000274658203125, 0.002288818359375, 0.028656005859375, 0.054229736328125, 0.064666748046875, 0.06524658203125, 0.05450439453125, 0.029052734375, 0.02398681640625, 0.019744873046875, -0.004638671875, -0.032623291015625, -0.03814697265625, -0.027130126953125, -0.02825927734375, -0.028717041015625, -0.021453857421875, -0.014404296875, -0.006683349609375, 0.00665283203125, 0.01910400390625, 0.022674560546875, 0.01837158203125, 0.008392333984375, 0.002410888671875, -6.103515625e-05, 0.00274658203125, -0.001434326171875, -0.018524169921875, -0.02008056640625, -0.009002685546875, -0.00189208984375, -0.00469970703125, -0.01177978515625, -0.015625, -0.0157470703125, -0.015960693359375, -0.016448974609375, -0.01873779296875, -0.018280029296875, -0.006378173828125, 0.0054931640625, 0.01226806640625, 0.0142822265625, 0.009674072265625, 0.003509521484375, -0.0028076171875, -0.007904052734375, -0.01214599609375, -0.01654052734375, -0.017547607421875, -0.01446533203125, -0.00958251953125, -0.005767822265625, -0.002349853515625, 0.000274658203125, 0.001983642578125, 0.00250244140625, 0.002532958984375, 0.0018310546875, 0.00091552734375, 0.001708984375, 0.00042724609375, -0.003570556640625, -0.006072998046875, -0.005584716796875, -0.004058837890625, -0.003875732421875, -0.004669189453125, -0.005523681640625, -0.005859375, -0.005401611328125, -0.005889892578125, -0.007568359375, -0.00732421875, -0.003631591796875, 0.000701904296875, 0.004486083984375, 0.006134033203125, 0.0035400390625, -0.00054931640625, -0.003692626953125, -0.00543212890625, -0.00640869140625, -0.00689697265625, -0.007080078125, -0.007415771484375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 0.000335693359375, -9.1552734375e-05, 0.000518798828125, -0.00048828125, 0.000762939453125, -0.000823974609375, 0.00103759765625, -0.00091552734375, 0.000885009765625, -0.000640869140625, 0.00152587890625, -0.000762939453125, 0.059661865234375, 0.177734375, -0.09832763671875, -0.25482177734375, -0.019927978515625, 0.052734375, 0.103515625, 0.11602783203125, 0.101715087890625, 0.136016845703125, 0.246337890625, 0.21484375, -0.041046142578125, -0.137054443359375, -0.078155517578125, -0.068572998046875, -0.104522705078125, -0.1029052734375, -0.121368408203125, -0.109893798828125, -0.072113037109375, -0.03912353515625, -0.004974365234375, 0.004852294921875, 0.03125, 0.0540771484375, 0.069976806640625, 0.0718994140625, 0.0584716796875, 0.0299072265625, 0.022247314453125, 0.0186767578125, -0.0037841796875, -0.026702880859375, -0.042633056640625, -0.036834716796875, -0.0328369140625, -0.02911376953125, -0.020904541015625, -0.010040283203125, 0.00030517578125, 0.003204345703125, 0.0084228515625, 0.018218994140625, 0.022369384765625, 0.013641357421875, 0.00811767578125, 0.004638671875, 0.002197265625, 0.003173828125, -0.012481689453125, -0.02374267578125, -0.01727294921875, -0.00732421875, -0.00390625, -0.008148193359375, -0.01446533203125, -0.01763916015625, -0.01654052734375, -0.01507568359375, -0.016143798828125, -0.018798828125, -0.00970458984375, 0.004119873046875, 0.01251220703125, 0.016815185546875, 0.01300048828125, 0.004547119140625, -0.0028076171875, -0.00762939453125, -0.011749267578125, -0.017486572265625, -0.02105712890625, -0.018951416015625, -0.0126953125, -0.00592041015625, -0.00177001953125, -0.000946044921875, 0.0010986328125, 0.003326416015625, 0.004364013671875, 0.0040283203125, 0.00189208984375, 0.001861572265625, 0.00213623046875, -0.001129150390625, -0.005340576171875, -0.0068359375, -0.006683349609375, -0.0062255859375, -0.005035400390625, -0.004486083984375, -0.005126953125, -0.005615234375, -0.006317138671875, -0.008148193359375, -0.007965087890625, -0.0042724609375, -0.00054931640625, 0.00299072265625, 0.005462646484375, 0.004486083984375, 0.001220703125, -0.001800537109375, -0.0045166015625, -0.00689697265625, -0.007293701171875, -0.006439208984375, -0.006195068359375, -0.0068359375])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, -0.000152587890625, 0.000274658203125, -0.0001220703125, 0.000518798828125, -0.000518798828125, 0.000701904296875, -0.00079345703125, 0.0008544921875, -0.0008544921875, 0.0006103515625, -0.000396728515625, 0.001129150390625, -0.000457763671875, 0.060089111328125, 0.196807861328125, -0.08892822265625, -0.29083251953125, -0.03955078125, 0.057403564453125, 0.1195068359375, 0.13580322265625, 0.1103515625, 0.153045654296875, 0.255584716796875, 0.224395751953125, -0.022369384765625, -0.141021728515625, -0.10455322265625, -0.08331298828125, -0.111785888671875, -0.106292724609375, -0.1302490234375, -0.13446044921875, -0.08453369140625, -0.039031982421875, -0.00018310546875, 0.00628662109375, 0.0343017578125, 0.0635986328125, 0.08001708984375, 0.07867431640625, 0.0625, 0.027801513671875, 0.01483154296875, 0.0169677734375, -0.00555419921875, -0.02862548828125, -0.045806884765625, -0.042083740234375, -0.037567138671875, -0.033203125, -0.021820068359375, -0.0106201171875, -0.000518798828125, 0.006988525390625, 0.01409912109375, 0.016693115234375, 0.018463134765625, 0.011749267578125, 0.006011962890625, 0.0091552734375, 0.008392333984375, 0.005828857421875, -0.012359619140625, -0.028106689453125, -0.018890380859375, -0.004364013671875, -9.1552734375e-05, -0.00506591796875, -0.012664794921875, -0.01641845703125, -0.016143798828125, -0.0172119140625, -0.01776123046875, -0.018951416015625, -0.011688232421875, 0.00274658203125, 0.01171875, 0.017120361328125, 0.01715087890625, 0.00933837890625, -0.001617431640625, -0.009307861328125, -0.012847900390625, -0.016876220703125, -0.02130126953125, -0.02105712890625, -0.015350341796875, -0.008575439453125, -0.0030517578125, -0.0013427734375, 0.000457763671875, 0.002838134765625, 0.004791259765625, 0.006072998046875, 0.005584716796875, 0.005523681640625, 0.00311279296875, -0.0015869140625, -0.0050048828125, -0.006744384765625, -0.007843017578125, -0.008056640625, -0.006805419921875, -0.004180908203125, -0.003814697265625, -0.00579833984375, -0.007110595703125, -0.008056640625, -0.0076904296875, -0.004638671875, -0.000732421875, 0.002838134765625, 0.005401611328125, 0.005035400390625, 0.0020751953125, -0.0013427734375, -0.004302978515625, -0.006378173828125, -0.006927490234375, -0.006591796875, -0.00592041015625, -0.006072998046875, -0.006256103515625])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, 0.0, -3.0517578125e-05, -0.0001220703125, 0.00030517578125, -0.0001220703125, 0.00048828125, -0.000335693359375, 0.00054931640625, -0.00048828125, 0.00042724609375, -0.000244140625, -0.000244140625, 0.000396728515625, -0.000244140625, 0.000946044921875, 0.043670654296875, 0.204345703125, -0.026611328125, -0.313812255859375, -0.08837890625, 0.046722412109375, 0.113250732421875, 0.1646728515625, 0.127105712890625, 0.1572265625, 0.244842529296875, 0.23687744140625, 0.0263671875, -0.118072509765625, -0.124603271484375, -0.11029052734375, -0.120452880859375, -0.11248779296875, -0.130218505859375, -0.149871826171875, -0.103240966796875, -0.051666259765625, 0.00030517578125, 0.0162353515625, 0.033538818359375, 0.062347412109375, 0.084381103515625, 0.08233642578125, 0.0665283203125, 0.040985107421875, 0.0201416015625, 0.014984130859375, -0.010101318359375, -0.03076171875, -0.04608154296875, -0.04736328125, -0.0423583984375, -0.038421630859375, -0.02947998046875, -0.01763916015625, -0.000885009765625, 0.008758544921875, 0.017303466796875, 0.02264404296875, 0.022308349609375, 0.0123291015625, 0.000335693359375, 0.00335693359375, 0.0040283203125, 0.002960205078125, -0.006683349609375, -0.021209716796875, -0.018402099609375, -0.0052490234375, 0.00274658203125, 0.000335693359375, -0.005279541015625, -0.012786865234375, -0.01629638671875, -0.018768310546875, -0.019805908203125, -0.019683837890625, -0.016815185546875, -0.00335693359375, 0.008392333984375, 0.015838623046875, 0.019195556640625, 0.014434814453125, 0.003509521484375, -0.006866455078125, -0.0115966796875, -0.017364501953125, -0.021942138671875, -0.02154541015625, -0.016387939453125, -0.010162353515625, -0.00506591796875, -0.002838134765625, -0.001739501953125, 0.00189208984375, 0.004150390625, 0.006439208984375, 0.00775146484375, 0.0069580078125, 0.00439453125, -6.103515625e-05, -0.00390625, -0.006378173828125, -0.008056640625, -0.008697509765625, -0.007354736328125, -0.004608154296875, -0.00408935546875, -0.006011962890625, -0.007568359375, -0.007659912109375, -0.00714111328125, -0.00537109375, -0.00225830078125, 0.0015869140625, 0.00592041015625, 0.006103515625, 0.003143310546875, -0.000457763671875, -0.003875732421875, -0.005859375, -0.00701904296875, -0.00701904296875, -0.00628662109375, -0.005767822265625, -0.005645751953125, -0.00579833984375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, -0.000244140625, 0.000244140625, -9.1552734375e-05, 0.00042724609375, -0.000213623046875, 0.000274658203125, -0.000213623046875, 6.103515625e-05, 0.000213623046875, -0.00079345703125, 0.0009765625, -0.001312255859375, 0.001953125, 0.0302734375, 0.200775146484375, 0.031158447265625, -0.31219482421875, -0.13690185546875, 0.029052734375, 0.091461181640625, 0.18060302734375, 0.15960693359375, 0.172149658203125, 0.2376708984375, 0.22930908203125, 0.068145751953125, -0.08026123046875, -0.1239013671875, -0.131317138671875, -0.15179443359375, -0.12835693359375, -0.11944580078125, -0.155731201171875, -0.127044677734375, -0.06292724609375, 0.00299072265625, 0.022003173828125, 0.0301513671875, 0.060150146484375, 0.08660888671875, 0.08612060546875, 0.073638916015625, 0.051666259765625, 0.024932861328125, 0.018035888671875, -0.00640869140625, -0.032073974609375, -0.05230712890625, -0.054412841796875, -0.047882080078125, -0.048370361328125, -0.0372314453125, -0.019134521484375, -0.003021240234375, 0.006988525390625, 0.0179443359375, 0.0250244140625, 0.0267333984375, 0.021881103515625, 0.003936767578125, -0.0059814453125, -0.006256103515625, -0.001922607421875, -0.001861572265625, -0.01580810546875, -0.0177001953125, -0.005462646484375, 0.004425048828125, 0.00341796875, -0.00152587890625, -0.00799560546875, -0.0130615234375, -0.016510009765625, -0.019744873046875, -0.020050048828125, -0.019561767578125, -0.010406494140625, 0.003448486328125, 0.014129638671875, 0.020355224609375, 0.0172119140625, 0.007171630859375, -0.002960205078125, -0.008087158203125, -0.01470947265625, -0.022491455078125, -0.024169921875, -0.019256591796875, -0.011505126953125, -0.00634765625, -0.003662109375, -0.0025634765625, 0.000823974609375, 0.00439453125, 0.00714111328125, 0.008270263671875, 0.007415771484375, 0.005157470703125, 0.001129150390625, -0.00323486328125, -0.0067138671875, -0.008087158203125, -0.00738525390625, -0.00634765625, -0.00531005859375, -0.00537109375, -0.006927490234375, -0.0076904296875, -0.00714111328125, -0.006927490234375, -0.00543212890625, -0.002532958984375, 0.000518798828125, 0.004730224609375, 0.006561279296875, 0.00457763671875, 0.00128173828125, -0.003204345703125, -0.0057373046875, -0.006500244140625, -0.007904052734375, -0.007476806640625, -0.006317138671875, -0.005584716796875, -0.00457763671875, -0.00457763671875])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000213623046875, 0.00018310546875, -0.0001220703125, 0.000152587890625, 0.0, -0.0001220703125, 9.1552734375e-05, -0.0008544921875, 0.00103759765625, -0.001800537109375, 0.001800537109375, -0.00250244140625, 0.00250244140625, 0.01995849609375, 0.192657470703125, 0.063873291015625, -0.309722900390625, -0.074981689453125, -0.041900634765625, -0.077484130859375, 0.261627197265625, 0.285064697265625, 0.1397705078125, 0.16253662109375, 0.42041015625, 0.166412353515625, -0.228424072265625, -0.082794189453125, -0.153411865234375, -0.3194580078125, -0.051300048828125, 0.032257080078125, -0.18218994140625, -0.114593505859375, 0.026153564453125, 0.030181884765625, -0.012176513671875, 0.010406494140625, 0.042083740234375, -0.007171630859375, 0.004058837890625, 0.055511474609375, -0.011505126953125, -0.05389404296875, -0.002899169921875, 0.004974365234375, -0.03363037109375, -0.04180908203125, -0.0208740234375, -0.019805908203125, -0.0198974609375, 0.0048828125, 0.007659912109375, -0.008270263671875, 0.0062255859375, 0.0224609375, 0.021331787109375, 0.01104736328125, 0.003753662109375, 0.0018310546875, -0.001373291015625, -0.014495849609375, -0.014495849609375, -0.014984130859375, -0.021087646484375, -0.014495849609375, -0.006011962890625, -0.00811767578125, -0.00836181640625, 0.000335693359375, 0.000946044921875, -0.0003662109375, 0.003692626953125, 0.00390625, -0.000213623046875, -0.001434326171875, -0.003326416015625, -0.004791259765625, -0.005401611328125, -0.003997802734375, -0.002655029296875, -0.0015869140625, -0.004913330078125, -0.004669189453125, -0.002288818359375, -0.001922607421875, -0.001251220703125, -0.00054931640625, -0.00177001953125, -0.00469970703125, -0.00360107421875, -0.00433349609375, -0.005401611328125, -0.000762939453125, -0.00213623046875, -0.015472412109375, -0.018951416015625, -0.015899658203125, -0.008331298828125, 0.008148193359375, 0.015228271484375, 0.011383056640625, 0.00823974609375, -0.000213623046875, -0.009918212890625, -0.01446533203125, -0.019866943359375, -0.02587890625, -0.0206298828125, -0.001129150390625, 0.009002685546875, 0.007843017578125, 0.007781982421875, 0.00518798828125, 0.001953125, 0.000244140625, -0.001190185546875, 0.000152587890625, 0.003631591796875, 0.00433349609375, 0.0009765625, -0.00250244140625, -0.00634765625, -0.007781982421875, -0.0084228515625, -0.01007080078125, -0.011688232421875, -0.014404296875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -0.00018310546875, 3.0517578125e-05, 6.103515625e-05, -9.1552734375e-05, 0.000274658203125, -0.000335693359375, 0.000457763671875, -0.001007080078125, 0.0009765625, -0.001434326171875, 0.00115966796875, -0.001678466796875, 0.001800537109375, 0.004852294921875, 0.121002197265625, 0.1365966796875, -0.199737548828125, -0.156463623046875, -0.043243408203125, -0.149383544921875, 0.119049072265625, 0.283538818359375, 0.191192626953125, 0.163482666015625, 0.334381103515625, 0.256622314453125, -0.098907470703125, -0.091766357421875, -0.0821533203125, -0.26397705078125, -0.137115478515625, 0.049224853515625, -0.084442138671875, -0.12127685546875, -0.02886962890625, -0.014495849609375, -0.0174560546875, -0.022979736328125, 0.006988525390625, 0.016754150390625, -0.013946533203125, 0.034515380859375, 0.041656494140625, -0.00982666015625, -0.003875732421875, 0.005828857421875, -0.011993408203125, -0.03826904296875, -0.031707763671875, -0.02142333984375, -0.04290771484375, -0.0242919921875, 0.008575439453125, -0.009063720703125, 0.003204345703125, 0.0267333984375, 0.01580810546875, 0.01055908203125, 0.008270263671875, -0.0010986328125, 0.00189208984375, -0.002899169921875, -0.004608154296875, -0.0072021484375, -0.015411376953125, -0.012451171875, -0.0089111328125, -0.00970458984375, -0.011016845703125, -0.007598876953125, -0.005401611328125, -0.003875732421875, -0.000946044921875, 0.00250244140625, -0.00189208984375, -0.00213623046875, 0.002777099609375, -0.00054931640625, -0.002960205078125, 0.001556396484375, 0.00091552734375, -0.0001220703125, -0.001220703125, -0.001922607421875, -0.000701904296875, -0.002899169921875, -0.005645751953125, -0.007293701171875, -0.00927734375, -0.012054443359375, -0.009368896484375, -0.0010986328125, -0.00018310546875, -0.01434326171875, -0.019561767578125, -0.015472412109375, -0.009124755859375, 0.008941650390625, 0.020751953125, 0.016754150390625, 0.01129150390625, 0.00469970703125, -0.003875732421875, -0.012451171875, -0.020233154296875, -0.02911376953125, -0.0308837890625, -0.013763427734375, 0.000244140625, 0.001708984375, 0.0020751953125, 0.004119873046875, 0.006866455078125, 0.008758544921875, 0.00860595703125, 0.006591796875, 0.006134033203125, 0.00634765625, 0.0015869140625, -0.003204345703125, -0.006134033203125, -0.010009765625, -0.01177978515625, -0.01190185546875, -0.0125732421875, -0.015594482421875, -0.01629638671875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, -0.000152587890625, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, 0.00018310546875, -0.00018310546875, 0.000274658203125, -0.000762939453125, 0.000762939453125, -0.001220703125, 0.0010986328125, -0.0013427734375, 0.001556396484375, 0.006866455078125, 0.1142578125, 0.10772705078125, -0.17755126953125, -0.123748779296875, -0.050689697265625, -0.12603759765625, 0.1141357421875, 0.23931884765625, 0.178070068359375, 0.1685791015625, 0.290863037109375, 0.21185302734375, -0.069061279296875, -0.068603515625, -0.073883056640625, -0.219512939453125, -0.1124267578125, 0.0238037109375, -0.08258056640625, -0.09918212890625, -0.03924560546875, -0.026580810546875, -0.0260009765625, -0.033477783203125, 0.00469970703125, 0.01763916015625, -0.006744384765625, 0.037017822265625, 0.04376220703125, 0.007904052734375, 0.01068115234375, 0.008544921875, -0.012115478515625, -0.0340576171875, -0.02740478515625, -0.026580810546875, -0.049407958984375, -0.032501220703125, -0.00469970703125, -0.0123291015625, 0.002838134765625, 0.01971435546875, 0.01019287109375, 0.009429931640625, 0.01025390625, 0.005401611328125, 0.0106201171875, 0.006561279296875, 0.0018310546875, -0.0030517578125, -0.01190185546875, -0.012908935546875, -0.01153564453125, -0.012481689453125, -0.012969970703125, -0.010772705078125, -0.008880615234375, -0.00811767578125, -0.00604248046875, -0.00042724609375, -0.00054931640625, 0.00164794921875, 0.004119873046875, 0.00115966796875, 0.000701904296875, 0.002716064453125, 0.001708984375, 0.00128173828125, 0.001434326171875, 6.103515625e-05, -0.001434326171875, -0.003692626953125, -0.006927490234375, -0.009765625, -0.0126953125, -0.014923095703125, -0.010101318359375, -0.0013427734375, -0.004791259765625, -0.017608642578125, -0.0169677734375, -0.011871337890625, -0.0015869140625, 0.015411376953125, 0.0208740234375, 0.015869140625, 0.008148193359375, 0.000579833984375, -0.007080078125, -0.014312744140625, -0.021026611328125, -0.02911376953125, -0.02569580078125, -0.009552001953125, 3.0517578125e-05, 0.0030517578125, 0.003631591796875, 0.004058837890625, 0.00469970703125, 0.005096435546875, 0.00628662109375, 0.006500244140625, 0.0067138671875, 0.00506591796875, 0.00067138671875, -0.00250244140625, -0.00531005859375, -0.008453369140625, -0.01129150390625, -0.01385498046875, -0.015472412109375, -0.01708984375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 0.0, -6.103515625e-05, -0.00018310546875, 3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0001220703125, -0.000152587890625, 0.00018310546875, -0.000579833984375, 0.00054931640625, -0.0009765625, 0.000885009765625, -0.001068115234375, 0.00115966796875, 0.007965087890625, 0.10345458984375, 0.086456298828125, -0.149444580078125, -0.102783203125, -0.05548095703125, -0.101104736328125, 0.099212646484375, 0.2020263671875, 0.17181396484375, 0.158233642578125, 0.2454833984375, 0.18328857421875, -0.039520263671875, -0.0469970703125, -0.062042236328125, -0.17523193359375, -0.097900390625, 0.0008544921875, -0.074249267578125, -0.090057373046875, -0.043060302734375, -0.028900146484375, -0.04107666015625, -0.0484619140625, -0.001953125, 0.01715087890625, 0.005096435546875, 0.04559326171875, 0.04833984375, 0.0225830078125, 0.0264892578125, 0.019683837890625, -0.0125732421875, -0.0391845703125, -0.031524658203125, -0.03399658203125, -0.054168701171875, -0.040252685546875, -0.015106201171875, -0.0137939453125, -0.00030517578125, 0.011077880859375, 0.007598876953125, 0.011627197265625, 0.016998291015625, 0.01641845703125, 0.017547607421875, 0.0106201171875, 0.006103515625, -0.000640869140625, -0.010589599609375, -0.01123046875, -0.01165771484375, -0.015838623046875, -0.017181396484375, -0.015411376953125, -0.016357421875, -0.01470947265625, -0.00750732421875, 0.0003662109375, 0.002532958984375, 0.00457763671875, 0.00579833984375, 0.00347900390625, 0.0030517578125, 0.0045166015625, 0.00274658203125, 0.001434326171875, 0.000396728515625, -0.0003662109375, -0.001739501953125, -0.005523681640625, -0.009124755859375, -0.01104736328125, -0.01300048828125, -0.014251708984375, -0.008575439453125, -0.003387451171875, -0.010498046875, -0.018402099609375, -0.014251708984375, -0.007843017578125, 0.005096435546875, 0.017578125, 0.01837158203125, 0.0128173828125, 0.004638671875, -0.00262451171875, -0.00897216796875, -0.01513671875, -0.022552490234375, -0.027557373046875, -0.01873779296875, -0.00469970703125, 0.001953125, 0.00396728515625, 0.002532958984375, 0.002227783203125, 0.002471923828125, 0.002410888671875, 0.003936767578125, 0.00634765625, 0.00677490234375, 0.0035400390625, 0.0003662109375, -0.002105712890625, -0.0054931640625, -0.008544921875, -0.01202392578125, -0.0155029296875, -0.016754150390625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, -9.1552734375e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 0.0001220703125, -0.0001220703125, 0.000213623046875, -0.000457763671875, 0.000457763671875, -0.000701904296875, 0.000732421875, -0.000732421875, 0.000885009765625, 0.007568359375, 0.0894775390625, 0.07666015625, -0.120086669921875, -0.09417724609375, -0.05322265625, -0.08245849609375, 0.077423095703125, 0.179107666015625, 0.162384033203125, 0.13604736328125, 0.20867919921875, 0.168212890625, -0.01202392578125, -0.029022216796875, -0.04351806640625, -0.141326904296875, -0.0953369140625, -0.008544921875, -0.06549072265625, -0.084564208984375, -0.04412841796875, -0.039764404296875, -0.059295654296875, -0.05401611328125, 0.0001220703125, 0.020721435546875, 0.018096923828125, 0.052581787109375, 0.055084228515625, 0.035186767578125, 0.032470703125, 0.020233154296875, -0.012908935546875, -0.0394287109375, -0.040008544921875, -0.041839599609375, -0.054229736328125, -0.04193115234375, -0.019378662109375, -0.019195556640625, -0.00732421875, 0.00927734375, 0.01336669921875, 0.017822265625, 0.02105712890625, 0.0211181640625, 0.02142333984375, 0.013580322265625, 0.00738525390625, -0.00018310546875, -0.00848388671875, -0.01007080078125, -0.013153076171875, -0.01910400390625, -0.022979736328125, -0.02197265625, -0.018585205078125, -0.0146484375, -0.007965087890625, 0.000823974609375, 0.004241943359375, 0.00616455078125, 0.0079345703125, 0.00677490234375, 0.00457763671875, 0.004364013671875, 0.002777099609375, 0.000701904296875, -0.001495361328125, -0.0029296875, -0.003143310546875, -0.005096435546875, -0.008209228515625, -0.010406494140625, -0.01251220703125, -0.0125732421875, -0.00726318359375, -0.006134033203125, -0.014739990234375, -0.018096923828125, -0.01177978515625, -0.002532958984375, 0.01007080078125, 0.015625, 0.013885498046875, 0.009002685546875, 0.001953125, -0.0047607421875, -0.0108642578125, -0.015899658203125, -0.021453857421875, -0.0213623046875, -0.010498046875, -0.00067138671875, 0.002716064453125, 0.002716064453125, 3.0517578125e-05, 0.00030517578125, 0.000152587890625, 0.000396728515625, 0.00396728515625, 0.0067138671875, 0.005035400390625, 0.001129150390625, -0.00103759765625, -0.003021240234375, -0.005645751953125, -0.00823974609375, -0.012298583984375, -0.01544189453125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, -9.1552734375e-05, 0.0, 0.0, 3.0517578125e-05, 0.0001220703125, -6.103515625e-05, 0.0001220703125, -0.00030517578125, 0.0003662109375, -0.000579833984375, 0.00067138671875, -0.000518798828125, 0.0006103515625, 0.00634765625, 0.075042724609375, 0.071685791015625, -0.094512939453125, -0.088287353515625, -0.047210693359375, -0.0703125, 0.061431884765625, 0.160400390625, 0.1417236328125, 0.11700439453125, 0.179840087890625, 0.154144287109375, 0.012847900390625, -0.0091552734375, -0.027130126953125, -0.1182861328125, -0.09002685546875, -0.013671875, -0.056365966796875, -0.08087158203125, -0.05902099609375, -0.055572509765625, -0.05810546875, -0.042724609375, 0.002044677734375, 0.02459716796875, 0.02874755859375, 0.058258056640625, 0.057647705078125, 0.034332275390625, 0.02886962890625, 0.015655517578125, -0.01129150390625, -0.034027099609375, -0.04107666015625, -0.04754638671875, -0.05548095703125, -0.04193115234375, -0.02349853515625, -0.02020263671875, -0.006500244140625, 0.01141357421875, 0.017608642578125, 0.021484375, 0.021881103515625, 0.01947021484375, 0.020416259765625, 0.01470947265625, 0.007476806640625, -0.000335693359375, -0.007659912109375, -0.01214599609375, -0.016754150390625, -0.0213623046875, -0.023651123046875, -0.021881103515625, -0.0189208984375, -0.014068603515625, -0.007598876953125, 0.000762939453125, 0.003997802734375, 0.00543212890625, 0.00848388671875, 0.0076904296875, 0.00604248046875, 0.003936767578125, 0.000946044921875, -0.000640869140625, -0.002410888671875, -0.001983642578125, -0.00238037109375, -0.00543212890625, -0.0084228515625, -0.009979248046875, -0.011260986328125, -0.011474609375, -0.00732421875, -0.0096435546875, -0.016387939453125, -0.014892578125, -0.008148193359375, 0.0013427734375, 0.010040283203125, 0.011871337890625, 0.00982666015625, 0.005279541015625, -0.00067138671875, -0.0068359375, -0.01116943359375, -0.0146484375, -0.017608642578125, -0.013153076171875, -0.0042724609375, 0.000152587890625, 0.001190185546875, 6.103515625e-05, -0.0023193359375, -0.00225830078125, -0.000885009765625, 0.00067138671875, 0.002899169921875, 0.00421142578125, 0.001708984375, -0.0003662109375, -0.000946044921875, -0.003082275390625, -0.005523681640625, -0.00799560546875, -0.011474609375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -0.0001220703125, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, 3.0517578125e-05, -0.0001220703125, 3.0517578125e-05, -0.0003662109375, 0.000213623046875, -0.000518798828125, 0.000579833984375, -0.000579833984375, 0.0003662109375, 0.004638671875, 0.06268310546875, 0.069976806640625, -0.07489013671875, -0.08489990234375, -0.0421142578125, -0.060211181640625, 0.05157470703125, 0.138671875, 0.12115478515625, 0.103973388671875, 0.15313720703125, 0.14337158203125, 0.03570556640625, 0.008087158203125, -0.016265869140625, -0.10162353515625, -0.08282470703125, -0.0169677734375, -0.053619384765625, -0.08245849609375, -0.0712890625, -0.05975341796875, -0.046142578125, -0.030029296875, 0.00640869140625, 0.032073974609375, 0.0357666015625, 0.048553466796875, 0.046661376953125, 0.033355712890625, 0.027679443359375, 0.012786865234375, -0.010711669921875, -0.03070068359375, -0.038909912109375, -0.047637939453125, -0.05657958984375, -0.041900634765625, -0.02020263671875, -0.012908935546875, -0.00128173828125, 0.010040283203125, 0.014495849609375, 0.018798828125, 0.0184326171875, 0.0155029296875, 0.01776123046875, 0.013946533203125, 0.004852294921875, -0.002471923828125, -0.00927734375, -0.012420654296875, -0.015869140625, -0.019561767578125, -0.0216064453125, -0.020965576171875, -0.0172119140625, -0.01470947265625, -0.008697509765625, -0.001007080078125, 0.001617431640625, 0.00433349609375, 0.007110595703125, 0.00762939453125, 0.00469970703125, 0.003173828125, 0.001678466796875, -0.000244140625, -0.000701904296875, -0.001983642578125, -0.00347900390625, -0.006500244140625, -0.008941650390625, -0.010528564453125, -0.01171875, -0.010589599609375, -0.00921630859375, -0.0120849609375, -0.014129638671875, -0.011199951171875, -0.00579833984375, 0.002593994140625, 0.008636474609375, 0.008270263671875, 0.005767822265625, 0.00146484375, -0.003662109375, -0.007965087890625, -0.0101318359375, -0.01177978515625, -0.0125732421875, -0.00775146484375, -0.00299072265625, -0.001495361328125, -0.001007080078125, -0.002655029296875, -0.0045166015625, -0.00390625, -0.0023193359375, -0.0010986328125, 0.001556396484375, 0.0023193359375, 0.000274658203125, -0.000274658203125, -0.0013427734375, -0.00360107421875, -0.0052490234375, -0.007843017578125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, -0.00018310546875, 0.0001220703125, -0.000335693359375, 0.000335693359375, -0.000274658203125, 0.00048828125, -0.0003662109375, 0.00042724609375, 0.002960205078125, 0.05242919921875, 0.067596435546875, -0.059173583984375, -0.0799560546875, -0.036651611328125, -0.048095703125, 0.042236328125, 0.11444091796875, 0.105377197265625, 0.092529296875, 0.129150390625, 0.13568115234375, 0.055511474609375, 0.019317626953125, -0.00799560546875, -0.0841064453125, -0.081573486328125, -0.0223388671875, -0.047088623046875, -0.0814208984375, -0.0753173828125, -0.051788330078125, -0.03192138671875, -0.019073486328125, 0.014678955078125, 0.031524658203125, 0.02362060546875, 0.0355224609375, 0.0450439453125, 0.033905029296875, 0.02410888671875, 0.011383056640625, -0.00921630859375, -0.028656005859375, -0.036834716796875, -0.04443359375, -0.048858642578125, -0.032958984375, -0.013153076171875, -0.009552001953125, -0.003753662109375, 0.005828857421875, 0.00946044921875, 0.01251220703125, 0.014739990234375, 0.01416015625, 0.013763427734375, 0.008575439453125, 0.002410888671875, -0.001678466796875, -0.006683349609375, -0.01055908203125, -0.01397705078125, -0.01690673828125, -0.019256591796875, -0.01885986328125, -0.017486572265625, -0.01458740234375, -0.0081787109375, -0.001739501953125, 0.00091552734375, 0.003173828125, 0.005340576171875, 0.005523681640625, 0.00506591796875, 0.00372314453125, 0.001861572265625, 0.001708984375, 0.00054931640625, -0.002716064453125, -0.005096435546875, -0.00726318359375, -0.008819580078125, -0.009857177734375, -0.0111083984375, -0.0101318359375, -0.009765625, -0.01177978515625, -0.010284423828125, -0.00738525390625, -0.002685546875, 0.003570556640625, 0.006072998046875, 0.004791259765625, 0.00238037109375, -0.00091552734375, -0.00555419921875, -0.0078125, -0.007293701171875, -0.008087158203125, -0.008270263671875, -0.005584716796875, -0.003814697265625, -0.00238037109375, -0.00189208984375, -0.003936767578125, -0.00604248046875, -0.00543212890625, -0.003082275390625, -0.0006103515625, 0.001861572265625, 0.002044677734375, 0.000732421875, 0.000152587890625, -0.0013427734375, -0.002685546875, -0.00469970703125])
        IR_LEFT[len(IR_LEFT)-1].append([6.103515625e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, 0.00018310546875, -6.103515625e-05, 0.000213623046875, -0.000213623046875, 0.000396728515625, -0.000213623046875, 0.00042724609375, -0.00018310546875, 0.0003662109375, 0.001983642578125, 0.04412841796875, 0.0634765625, -0.046142578125, -0.0743408203125, -0.031402587890625, -0.0357666015625, 0.031524658203125, 0.0921630859375, 0.09417724609375, 0.082427978515625, 0.108856201171875, 0.126922607421875, 0.071502685546875, 0.0325927734375, -0.0089111328125, -0.080413818359375, -0.076446533203125, -0.0186767578125, -0.03643798828125, -0.077545166015625, -0.0728759765625, -0.03863525390625, -0.014495849609375, -0.011688232421875, 0.00555419921875, 0.02099609375, 0.01898193359375, 0.029876708984375, 0.041839599609375, 0.033966064453125, 0.0205078125, 0.006744384765625, -0.01239013671875, -0.02691650390625, -0.02734375, -0.03173828125, -0.03607177734375, -0.02642822265625, -0.013946533203125, -0.012298583984375, -0.007843017578125, -0.0001220703125, 0.00469970703125, 0.009552001953125, 0.010009765625, 0.008514404296875, 0.009063720703125, 0.005706787109375, 0.0020751953125, -6.103515625e-05, -0.00494384765625, -0.0087890625, -0.011810302734375, -0.014862060546875, -0.01690673828125, -0.016998291015625, -0.01611328125, -0.01287841796875, -0.00701904296875, -0.001983642578125, -0.00030517578125, 0.0006103515625, 0.00238037109375, 0.004058837890625, 0.004791259765625, 0.004180908203125, 0.001739501953125, 0.0006103515625, -6.103515625e-05, -0.00201416015625, -0.004302978515625, -0.007110595703125, -0.00823974609375, -0.00970458984375, -0.010772705078125, -0.010223388671875, -0.010101318359375, -0.00927734375, -0.00665283203125, -0.003814697265625, 0.00042724609375, 0.0029296875, 0.00201416015625, 0.001251220703125, 0.000244140625, -0.003387451171875, -0.006988525390625, -0.006591796875, -0.00494384765625, -0.00579833984375, -0.006927490234375, -0.00616455078125, -0.003997802734375, -0.001861572265625, -0.00299072265625, -0.00592041015625, -0.007171630859375, -0.00482177734375, -0.002105712890625, -0.000152587890625, 0.00213623046875, 0.001983642578125, 0.000885009765625, -6.103515625e-05, -0.001220703125, -0.002716064453125])
        IR_LEFT[len(IR_LEFT)-1].append([6.103515625e-05, 3.0517578125e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 9.1552734375e-05, 3.0517578125e-05, 0.0001220703125, -0.000213623046875, 0.000274658203125, -0.00030517578125, 0.000457763671875, -0.000244140625, 0.000274658203125, 0.001983642578125, 0.03765869140625, 0.05548095703125, -0.035675048828125, -0.065643310546875, -0.02685546875, -0.024810791015625, 0.021087646484375, 0.07366943359375, 0.084808349609375, 0.072113037109375, 0.0946044921875, 0.125518798828125, 0.0789794921875, 0.022430419921875, -0.0164794921875, -0.064910888671875, -0.05767822265625, -0.0108642578125, -0.030792236328125, -0.0712890625, -0.05767822265625, -0.02288818359375, -0.015533447265625, -0.017913818359375, -0.00091552734375, 0.015869140625, 0.018218994140625, 0.027252197265625, 0.03656005859375, 0.0281982421875, 0.01165771484375, -0.004150390625, -0.00872802734375, -0.007965087890625, -0.01312255859375, -0.025360107421875, -0.031280517578125, -0.0255126953125, -0.0174560546875, -0.0147705078125, -0.011505126953125, -0.004791259765625, 0.001678466796875, 0.004730224609375, 0.004241943359375, 0.003204345703125, 0.004730224609375, 0.004150390625, 0.0028076171875, 0.00115966796875, -0.003509521484375, -0.007049560546875, -0.00933837890625, -0.01165771484375, -0.014373779296875, -0.01470947265625, -0.013702392578125, -0.010955810546875, -0.00701904296875, -0.004241943359375, -0.003173828125, -0.00146484375, 0.000946044921875, 0.002105712890625, 0.00311279296875, 0.002532958984375, 0.00054931640625, 0.001129150390625, 0.00103759765625, -0.000762939453125, -0.003173828125, -0.006317138671875, -0.0087890625, -0.01104736328125, -0.010772705078125, -0.0096435546875, -0.008056640625, -0.00579833984375, -0.003814697265625, -0.001434326171875, 0.000244140625, 9.1552734375e-05, -0.000885009765625, -0.00128173828125, -0.002838134765625, -0.005706787109375, -0.006195068359375, -0.00433349609375, -0.0040283203125, -0.00628662109375, -0.00732421875, -0.00579833984375, -0.0035400390625, -0.0029296875, -0.00494384765625, -0.00604248046875, -0.00537109375, -0.00396728515625, -0.0020751953125, 0.000579833984375, 0.00189208984375, 0.00103759765625, 0.00042724609375, -0.000457763671875, -0.001861572265625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 0.0001220703125, 9.1552734375e-05, 0.0001220703125, 3.0517578125e-05, 6.103515625e-05, -6.103515625e-05, 0.000213623046875, -9.1552734375e-05, 0.000244140625, -6.103515625e-05, 0.00018310546875, 0.00299072265625, 0.03302001953125, 0.043731689453125, -0.026947021484375, -0.053314208984375, -0.0233154296875, -0.017608642578125, 0.01318359375, 0.057830810546875, 0.077178955078125, 0.076171875, 0.085418701171875, 0.0992431640625, 0.069091796875, 0.020050048828125, -0.01116943359375, -0.038177490234375, -0.037872314453125, -0.009124755859375, -0.020111083984375, -0.05487060546875, -0.0517578125, -0.02484130859375, -0.016937255859375, -0.0194091796875, -0.003631591796875, 0.014190673828125, 0.014556884765625, 0.020904541015625, 0.0264892578125, 0.013397216796875, 0.005340576171875, 0.0078125, 0.00848388671875, 0.00140380859375, -0.010955810546875, -0.024078369140625, -0.029296875, -0.025421142578125, -0.019073486328125, -0.015899658203125, -0.014312744140625, -0.008331298828125, -0.002685546875, -0.00225830078125, -0.00140380859375, 0.000244140625, 0.003265380859375, 0.003997802734375, 0.003997802734375, 0.002716064453125, -0.001708984375, -0.003814697265625, -0.006927490234375, -0.009521484375, -0.01177978515625, -0.012054443359375, -0.011260986328125, -0.011260986328125, -0.008941650390625, -0.00689697265625, -0.004913330078125, -0.002532958984375, -0.0010986328125, 0.000885009765625, 0.001129150390625, 0.0018310546875, 0.002593994140625, 0.00274658203125, 0.0018310546875, -0.000732421875, -0.003021240234375, -0.006866455078125, -0.009674072265625, -0.010833740234375, -0.00958251953125, -0.0068359375, -0.005035400390625, -0.003173828125, -0.00311279296875, -0.002349853515625, -0.001434326171875, -0.001922607421875, -0.002227783203125, -0.003448486328125, -0.004638671875, -0.005859375, -0.004547119140625, -0.002899169921875, -0.004669189453125, -0.00750732421875, -0.008544921875, -0.00537109375, -0.00250244140625, -0.0030517578125, -0.004364013671875, -0.004974365234375, -0.004425048828125, -0.0030517578125, -0.001190185546875, 0.000518798828125, 0.000579833984375, 0.00030517578125, -0.0001220703125, -0.0010986328125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, 6.103515625e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0001220703125, 0.0001220703125, -0.000152587890625, 0.00018310546875, 0.000213623046875, -6.103515625e-05, 0.00567626953125, 0.028564453125, 0.029083251953125, -0.019073486328125, -0.037994384765625, -0.02197265625, -0.015655517578125, 0.01043701171875, 0.055389404296875, 0.076995849609375, 0.061492919921875, 0.05755615234375, 0.078277587890625, 0.071014404296875, 0.029815673828125, -0.002716064453125, -0.0159912109375, -0.012969970703125, 0.000762939453125, -0.02142333984375, -0.05340576171875, -0.045806884765625, -0.025543212890625, -0.019622802734375, -0.0186767578125, -0.005584716796875, 0.005523681640625, 0.006134033203125, 0.008331298828125, 0.015350341796875, 0.0208740234375, 0.019500732421875, 0.01531982421875, 0.010528564453125, 0.002655029296875, -0.0115966796875, -0.025054931640625, -0.027496337890625, -0.02325439453125, -0.018768310546875, -0.01837158203125, -0.018096923828125, -0.013580322265625, -0.008819580078125, -0.00616455078125, -0.00372314453125, -3.0517578125e-05, 0.004180908203125, 0.00531005859375, 0.005279541015625, 0.003997802734375, 0.00018310546875, -0.003082275390625, -0.005096435546875, -0.00701904296875, -0.009552001953125, -0.010833740234375, -0.01251220703125, -0.01263427734375, -0.010406494140625, -0.007843017578125, -0.00567626953125, -0.00433349609375, -0.001495361328125, 0.00067138671875, 0.001922607421875, 0.0029296875, 0.002838134765625, 0.00311279296875, 0.001861572265625, -0.00128173828125, -0.005279541015625, -0.007781982421875, -0.008544921875, -0.008697509765625, -0.00653076171875, -0.00457763671875, -0.003936767578125, -0.003997802734375, -0.0040283203125, -0.003021240234375, -0.002410888671875, -0.002716064453125, -0.00360107421875, -0.004608154296875, -0.005523681640625, -0.0052490234375, -0.003570556640625, -0.0042724609375, -0.007232666015625, -0.00860595703125, -0.007232666015625, -0.003662109375, -0.00146484375, -0.002349853515625, -0.003753662109375, -0.00439453125, -0.003936767578125, -0.002899169921875, -0.001068115234375, 0.00018310546875, -0.000244140625, -0.000579833984375, -0.001129150390625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 0.0001220703125, 9.1552734375e-05, 0.0001220703125, 0.0001220703125, 0.000152587890625, 0.000152587890625, 0.0001220703125, 0.00018310546875, 9.1552734375e-05, 0.000152587890625, 0.0001220703125, 0.000244140625, 0.0, 0.00030517578125, 6.103515625e-05, 0.0, 0.0003662109375, 0.0003662109375, 0.00030517578125, 0.00848388671875, 0.02392578125, 0.014984130859375, -0.01153564453125, -0.023895263671875, -0.023834228515625, -0.0062255859375, 0.023590087890625, 0.0400390625, 0.047088623046875, 0.050048828125, 0.0543212890625, 0.071746826171875, 0.07513427734375, 0.037811279296875, 0.007415771484375, 0.01556396484375, 0.0111083984375, -0.016693115234375, -0.036285400390625, -0.04193115234375, -0.038818359375, -0.02972412109375, -0.0220947265625, -0.0196533203125, -0.01434326171875, -0.009002685546875, -0.000579833984375, 0.014862060546875, 0.02764892578125, 0.028900146484375, 0.021209716796875, 0.013916015625, 0.00872802734375, 0.000274658203125, -0.01513671875, -0.024139404296875, -0.022125244140625, -0.020904541015625, -0.023162841796875, -0.024200439453125, -0.0208740234375, -0.015899658203125, -0.011138916015625, -0.00726318359375, -0.002716064453125, 0.00311279296875, 0.005035400390625, 0.005645751953125, 0.00592041015625, 0.00421142578125, 0.001220703125, -0.001556396484375, -0.003814697265625, -0.00714111328125, -0.0093994140625, -0.011932373046875, -0.01385498046875, -0.012451171875, -0.009796142578125, -0.007568359375, -0.0059814453125, -0.00347900390625, -0.001007080078125, 0.000823974609375, 0.002532958984375, 0.003326416015625, 0.003753662109375, 0.002655029296875, 0.00018310546875, -0.00341796875, -0.006134033203125, -0.00677490234375, -0.006683349609375, -0.005584716796875, -0.0048828125, -0.005157470703125, -0.00439453125, -0.003753662109375, -0.003387451171875, -0.003448486328125, -0.003814697265625, -0.00372314453125, -0.00408935546875, -0.00543212890625, -0.006805419921875, -0.00628662109375, -0.004638671875, -0.00506591796875, -0.006683349609375, -0.00714111328125, -0.005157470703125, -0.00177001953125, -0.00067138671875, -0.0020751953125, -0.004180908203125, -0.00469970703125, -0.00360107421875, -0.001922607421875, -0.000457763671875, -0.0008544921875, -0.001556396484375, -0.00164794921875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 9.1552734375e-05, 3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 0.0, 0.0, 0.0, 9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 9.1552734375e-05, 0.000244140625, -3.0517578125e-05, 0.00018310546875, 0.0001220703125, 0.000244140625, 0.001007080078125, 0.011505126953125, 0.01727294921875, 0.002716064453125, -0.004058837890625, -0.01031494140625, -0.0084228515625, -0.00341796875, -0.0028076171875, 0.02008056640625, 0.043853759765625, 0.058502197265625, 0.06109619140625, 0.06610107421875, 0.076416015625, 0.05828857421875, 0.028045654296875, 0.014617919921875, -0.00164794921875, -0.0289306640625, -0.038116455078125, -0.03338623046875, -0.035003662109375, -0.036956787109375, -0.029571533203125, -0.026153564453125, -0.0247802734375, -0.0068359375, 0.01776123046875, 0.029632568359375, 0.028961181640625, 0.02557373046875, 0.01885986328125, 0.00982666015625, 0.003082275390625, -0.005340576171875, -0.01513671875, -0.02056884765625, -0.022369384765625, -0.025421142578125, -0.02813720703125, -0.025726318359375, -0.020721435546875, -0.01519775390625, -0.01025390625, -0.005279541015625, -9.1552734375e-05, 0.003936767578125, 0.00506591796875, 0.00518798828125, 0.0057373046875, 0.00433349609375, 0.00213623046875, -0.001739501953125, -0.006134033203125, -0.009674072265625, -0.011505126953125, -0.011810302734375, -0.01171875, -0.010986328125, -0.009552001953125, -0.007080078125, -0.004791259765625, -0.00335693359375, -0.001312255859375, 0.000640869140625, 0.0029296875, 0.004669189453125, 0.003509521484375, 0.000457763671875, -0.0023193359375, -0.00384521484375, -0.00567626953125, -0.0064697265625, -0.0054931640625, -0.004608154296875, -0.004669189453125, -0.00506591796875, -0.0040283203125, -0.00347900390625, -0.004150390625, -0.004791259765625, -0.005218505859375, -0.005218505859375, -0.006317138671875, -0.00799560546875, -0.008453369140625, -0.006072998046875, -0.003204345703125, -0.003997802734375, -0.00543212890625, -0.00482177734375, -0.002532958984375, -0.0013427734375, -0.002288818359375, -0.00384521484375, -0.00433349609375, -0.00341796875, -0.00262451171875, -0.002044677734375, -0.0020751953125, -0.0025634765625, -0.00213623046875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, 9.1552734375e-05, -3.0517578125e-05, -6.103515625e-05, 0.00018310546875, 6.103515625e-05, 0.00030517578125, 0.0001220703125, -0.00018310546875, 0.0001220703125, 0.000396728515625, 0.0028076171875, 0.011627197265625, 0.009552001953125, 0.0010986328125, 0.01593017578125, 0.000244140625, -0.032012939453125, -0.0228271484375, -0.0020751953125, 0.030364990234375, 0.056640625, 0.06488037109375, 0.0677490234375, 0.07940673828125, 0.0880126953125, 0.051025390625, 0.006500244140625, -0.0020751953125, -0.0050048828125, -0.027008056640625, -0.039276123046875, -0.034027099609375, -0.0360107421875, -0.04290771484375, -0.040863037109375, -0.026824951171875, -0.008056640625, 0.0135498046875, 0.030792236328125, 0.03131103515625, 0.025238037109375, 0.019622802734375, 0.01226806640625, 0.003997802734375, -0.0023193359375, -0.008636474609375, -0.016937255859375, -0.02337646484375, -0.02716064453125, -0.027099609375, -0.02667236328125, -0.02423095703125, -0.018218994140625, -0.011871337890625, -0.006317138671875, -0.002349853515625, 0.00103759765625, 0.002838134765625, 0.004486083984375, 0.00665283203125, 0.00653076171875, 0.003631591796875, -0.00103759765625, -0.005401611328125, -0.008941650390625, -0.010955810546875, -0.01080322265625, -0.010040283203125, -0.009490966796875, -0.0096435546875, -0.009002685546875, -0.00689697265625, -0.004302978515625, -0.00189208984375, -0.000274658203125, 0.00152587890625, 0.003631591796875, 0.004730224609375, 0.0028076171875, -0.00091552734375, -0.0035400390625, -0.004974365234375, -0.005615234375, -0.005584716796875, -0.005218505859375, -0.00469970703125, -0.004180908203125, -0.003631591796875, -0.00408935546875, -0.0048828125, -0.00567626953125, -0.00653076171875, -0.007293701171875, -0.0076904296875, -0.008544921875, -0.008880615234375, -0.006378173828125, -0.002899169921875, -0.001556396484375, -0.001922607421875, -0.0028076171875, -0.00311279296875, -0.0030517578125, -0.003387451171875, -0.004058837890625, -0.0037841796875, -0.003021240234375, -0.003021240234375, -0.003326416015625, -0.003387451171875, -0.002960205078125, -0.002197265625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, -3.0517578125e-05, 6.103515625e-05, 0.0001220703125, 9.1552734375e-05, 0.000213623046875, 0.000244140625, 6.103515625e-05, -0.00030517578125, 0.000457763671875, 9.1552734375e-05, 0.0040283203125, 0.012420654296875, 0.02069091796875, 0.0137939453125, -0.013031005859375, -0.02978515625, -0.02886962890625, -0.004425048828125, 0.022125244140625, 0.043914794921875, 0.06695556640625, 0.081512451171875, 0.094146728515625, 0.075775146484375, 0.04193115234375, 0.019378662109375, -0.0013427734375, -0.00958251953125, -0.0101318359375, -0.024658203125, -0.040924072265625, -0.039215087890625, -0.03955078125, -0.046905517578125, -0.03533935546875, -0.003387451171875, 0.01806640625, 0.02459716796875, 0.0322265625, 0.030487060546875, 0.017669677734375, 0.00885009765625, 0.004364013671875, -0.00128173828125, -0.00909423828125, -0.01708984375, -0.022369384765625, -0.025726318359375, -0.027374267578125, -0.025482177734375, -0.022216796875, -0.018951416015625, -0.01220703125, -0.006927490234375, -0.004119873046875, -0.0009765625, 0.001800537109375, 0.004364013671875, 0.004913330078125, 0.005523681640625, 0.003753662109375, -0.00018310546875, -0.004669189453125, -0.0091552734375, -0.010467529296875, -0.010101318359375, -0.00872802734375, -0.0086669921875, -0.0093994140625, -0.00927734375, -0.00750732421875, -0.00408935546875, -0.002227783203125, -0.000457763671875, 0.001617431640625, 0.003082275390625, 0.00390625, 0.00341796875, 0.001251220703125, -0.001861572265625, -0.003875732421875, -0.00567626953125, -0.007171630859375, -0.006622314453125, -0.00421142578125, -0.00311279296875, -0.003875732421875, -0.004730224609375, -0.00604248046875, -0.007080078125, -0.0078125, -0.00799560546875, -0.008758544921875, -0.0093994140625, -0.008056640625, -0.0054931640625, -0.0023193359375, 0.000457763671875, 0.001251220703125, -0.000396728515625, -0.002960205078125, -0.004638671875, -0.00531005859375, -0.00445556640625, -0.003753662109375, -0.003692626953125, -0.00347900390625, -0.00384521484375, -0.003570556640625, -0.002593994140625, -0.002044677734375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0001220703125, 0.0001220703125, 0.0001220703125, 9.1552734375e-05, 6.103515625e-05, 9.1552734375e-05, 0.0, 0.0, 9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 0.00018310546875, 0.0, 0.00018310546875, 0.000213623046875, 0.000335693359375, 0.000274658203125, 0.00018310546875, -0.00048828125, 0.000213623046875, 0.00115966796875, 0.021087646484375, 0.03375244140625, -0.00872802734375, -0.033935546875, -0.023040771484375, -0.009033203125, 0.00762939453125, 0.024932861328125, 0.03973388671875, 0.060760498046875, 0.0986328125, 0.088653564453125, 0.05242919921875, 0.0323486328125, 0.01055908203125, 0.00177001953125, -0.004669189453125, -0.015777587890625, -0.01971435546875, -0.023590087890625, -0.03912353515625, -0.04345703125, -0.03851318359375, -0.031494140625, -0.007476806640625, 0.0206298828125, 0.031585693359375, 0.029296875, 0.026947021484375, 0.01898193359375, 0.007415771484375, 0.000579833984375, -0.005157470703125, -0.011566162109375, -0.017242431640625, -0.02337646484375, -0.025360107421875, -0.024322509765625, -0.0240478515625, -0.019775390625, -0.014892578125, -0.012115478515625, -0.007904052734375, -0.003265380859375, -0.00079345703125, 0.001068115234375, 0.002716064453125, 0.0028076171875, 0.004150390625, 0.003509521484375, -0.00140380859375, -0.006134033203125, -0.008148193359375, -0.008880615234375, -0.01043701171875, -0.010498046875, -0.00933837890625, -0.008087158203125, -0.00665283203125, -0.005645751953125, -0.004180908203125, -0.001373291015625, 0.001373291015625, 0.002227783203125, 0.00238037109375, 0.00238037109375, 0.002593994140625, 0.00262451171875, 0.0001220703125, -0.003326416015625, -0.00634765625, -0.00836181640625, -0.007965087890625, -0.00506591796875, -0.002655029296875, -0.0037841796875, -0.005767822265625, -0.007232666015625, -0.007904052734375, -0.008087158203125, -0.008544921875, -0.008544921875, -0.00848388671875, -0.007110595703125, -0.0048828125, -0.00152587890625, 0.002166748046875, 0.00299072265625, 0.000732421875, -0.002960205078125, -0.0054931640625, -0.006011962890625, -0.005157470703125, -0.0045166015625, -0.00457763671875, -0.00396728515625, -0.003265380859375, -0.00225830078125, -0.001739501953125, -0.00238037109375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 0.0, 6.103515625e-05, 0.0, 0.0, 0.0, 0.0, -6.103515625e-05, 6.103515625e-05, 0.0, 0.0001220703125, 0.0, 0.000244140625, 3.0517578125e-05, 0.000396728515625, 0.000152587890625, -0.0001220703125, -0.0006103515625, 0.0120849609375, 0.03533935546875, 0.0050048828125, -0.0330810546875, -0.02935791015625, -0.015289306640625, 0.009796142578125, 0.02886962890625, 0.0330810546875, 0.04638671875, 0.080810546875, 0.08160400390625, 0.05572509765625, 0.035491943359375, 0.019256591796875, 0.010345458984375, -0.006744384765625, -0.01104736328125, -0.01458740234375, -0.023590087890625, -0.0234375, -0.0185546875, -0.0244140625, -0.040008544921875, -0.02703857421875, -0.000579833984375, 0.018218994140625, 0.0338134765625, 0.034423828125, 0.0211181640625, 0.01348876953125, 0.01055908203125, -0.00286865234375, -0.0137939453125, -0.01611328125, -0.019287109375, -0.023681640625, -0.02593994140625, -0.02276611328125, -0.0201416015625, -0.0186767578125, -0.013519287109375, -0.007354736328125, -0.00384521484375, -0.00274658203125, -0.00164794921875, 0.0003662109375, 0.002532958984375, 0.0029296875, 0.001007080078125, -0.001617431640625, -0.00286865234375, -0.005340576171875, -0.009185791015625, -0.011993408203125, -0.0120849609375, -0.010711669921875, -0.009490966796875, -0.00726318359375, -0.004974365234375, -0.002227783203125, -0.000335693359375, 0.00067138671875, 0.001953125, 0.002227783203125, 0.001861572265625, 0.00140380859375, 0.0015869140625, 0.001678466796875, 0.000213623046875, -0.003173828125, -0.007720947265625, -0.00958251953125, -0.008514404296875, -0.006500244140625, -0.00482177734375, -0.004364013671875, -0.006378173828125, -0.00909423828125, -0.009246826171875, -0.007904052734375, -0.00689697265625, -0.006988525390625, -0.007232666015625, -0.0059814453125, -0.003265380859375, -0.000274658203125, 0.001678466796875, 0.001922607421875, -0.000274658203125, -0.00396728515625, -0.0059814453125, -0.00616455078125, -0.006072998046875, -0.006134033203125, -0.005035400390625, -0.00372314453125, -0.002410888671875, -0.001129150390625, -0.001434326171875, -0.00274658203125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, 0.0001220703125, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 9.1552734375e-05, -3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.00018310546875, 0.0, 0.0001220703125, 0.00030517578125, 0.000152587890625, 0.000152587890625, 0.00701904296875, 0.039031982421875, 0.014495849609375, -0.043548583984375, -0.0343017578125, -0.013763427734375, 0.00836181640625, 0.029510498046875, 0.036346435546875, 0.04827880859375, 0.080322265625, 0.09124755859375, 0.048004150390625, 0.0106201171875, 0.011260986328125, 0.012939453125, 0.00018310546875, -0.004364013671875, -0.02264404296875, -0.0306396484375, -0.020660400390625, -0.01800537109375, -0.009033203125, -0.004486083984375, -0.014251708984375, -0.023712158203125, -0.003082275390625, 0.025909423828125, 0.03424072265625, 0.02899169921875, 0.021209716796875, 0.013519287109375, 0.003692626953125, -0.006317138671875, -0.01873779296875, -0.023712158203125, -0.022064208984375, -0.0230712890625, -0.02447509765625, -0.02459716796875, -0.01837158203125, -0.0123291015625, -0.00970458984375, -0.00543212890625, -0.0008544921875, 0.001220703125, 0.0010986328125, 0.0018310546875, 0.000244140625, -0.000946044921875, -0.0009765625, -0.002777099609375, -0.005706787109375, -0.009918212890625, -0.011932373046875, -0.01263427734375, -0.012847900390625, -0.01171875, -0.00921630859375, -0.004486083984375, -0.0013427734375, 0.0008544921875, 0.003082275390625, 0.003570556640625, 0.0032958984375, 0.001922607421875, 0.000701904296875, -0.000396728515625, 0.0008544921875, 0.001800537109375, -0.000640869140625, -0.004180908203125, -0.008758544921875, -0.0106201171875, -0.009979248046875, -0.00750732421875, -0.005462646484375, -0.006561279296875, -0.00872802734375, -0.00970458984375, -0.00750732421875, -0.005462646484375, -0.004730224609375, -0.0047607421875, -0.0050048828125, -0.00341796875, -0.001800537109375, -0.00067138671875, -0.00054931640625, -0.000946044921875, -0.00213623046875, -0.00494384765625, -0.005828857421875, -0.00640869140625, -0.00653076171875, -0.00555419921875, -0.00433349609375, -0.002777099609375, -0.0018310546875, -0.00042724609375, -0.000732421875, -0.00238037109375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 0.0, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, -0.0001220703125, -6.103515625e-05, -3.0517578125e-05, 0.00018310546875, -0.000335693359375, 0.000518798828125, -0.000244140625, 0.0008544921875, 0.003326416015625, 0.03997802734375, 0.033538818359375, -0.048553466796875, -0.05426025390625, -0.01959228515625, 0.00994873046875, 0.037322998046875, 0.042022705078125, 0.04681396484375, 0.07928466796875, 0.112335205078125, 0.063018798828125, 0.00390625, -0.00537109375, -0.013214111328125, -0.012847900390625, -0.002471923828125, -0.01666259765625, -0.03143310546875, -0.03369140625, -0.030364990234375, -0.005645751953125, 0.005889892578125, 0.00274658203125, 0.006866455078125, 0.00360107421875, 0.002655029296875, 0.018218994140625, 0.03076171875, 0.026702880859375, 0.01861572265625, 0.013092041015625, -0.000640869140625, -0.016571044921875, -0.0220947265625, -0.024688720703125, -0.0279541015625, -0.026763916015625, -0.02294921875, -0.01910400390625, -0.01531982421875, -0.0111083984375, -0.0050048828125, -0.0010986328125, 0.001678466796875, 0.005950927734375, 0.004241943359375, -0.000701904296875, -0.0008544921875, -0.0009765625, -0.005157470703125, -0.00897216796875, -0.009765625, -0.010833740234375, -0.013763427734375, -0.01531982421875, -0.013824462890625, -0.01007080078125, -0.005706787109375, -0.00213623046875, 0.000946044921875, 0.004150390625, 0.0057373046875, 0.0047607421875, 0.003021240234375, 0.000732421875, 9.1552734375e-05, 0.0001220703125, -0.000335693359375, -9.1552734375e-05, -0.0015869140625, -0.00555419921875, -0.010162353515625, -0.011962890625, -0.01141357421875, -0.009521484375, -0.007354736328125, -0.008026123046875, -0.009521484375, -0.00860595703125, -0.00506591796875, -0.00213623046875, -0.00177001953125, -0.002288818359375, -0.002716064453125, -0.0018310546875, -0.00189208984375, -0.00372314453125, -0.00433349609375, -0.0040283203125, -0.00445556640625, -0.00604248046875, -0.007049560546875, -0.006134033203125, -0.00469970703125, -0.00372314453125, -0.0032958984375, -0.002166748046875, -0.000823974609375, -0.00018310546875, -0.000640869140625, -0.0015869140625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 9.1552734375e-05, 3.0517578125e-05, 0.0001220703125, -3.0517578125e-05, 0.0001220703125, -0.000244140625, 0.000396728515625, -0.00048828125, 0.00054931640625, -0.00054931640625, 0.001129150390625, 0.0008544921875, 0.036346435546875, 0.05596923828125, -0.043853759765625, -0.0777587890625, -0.028045654296875, 0.0042724609375, 0.040985107421875, 0.052093505859375, 0.052978515625, 0.082855224609375, 0.1275634765625, 0.081695556640625, 0.003997802734375, -0.011688232421875, -0.01800537109375, -0.025543212890625, -0.028900146484375, -0.031646728515625, -0.032257080078125, -0.034271240234375, -0.034393310546875, -0.018035888671875, -0.002105712890625, 0.009368896484375, 0.020721435546875, 0.021392822265625, 0.02496337890625, 0.02484130859375, 0.014434814453125, 0.01080322265625, 0.022216796875, 0.02435302734375, 0.003875732421875, -0.01007080078125, -0.015716552734375, -0.0267333984375, -0.03314208984375, -0.02960205078125, -0.023590087890625, -0.01922607421875, -0.014892578125, -0.012115478515625, -0.007171630859375, 0.000732421875, 0.00518798828125, 0.003692626953125, 0.001708984375, 0.005096435546875, 0.005218505859375, -0.00225830078125, -0.009490966796875, -0.0103759765625, -0.00927734375, -0.012115478515625, -0.014984130859375, -0.014862060546875, -0.0130615234375, -0.0106201171875, -0.0079345703125, -0.0042724609375, 0.000213623046875, 0.0047607421875, 0.006072998046875, 0.00390625, 0.0030517578125, 0.003509521484375, 0.002532958984375, 0.0006103515625, -0.00030517578125, -0.000762939453125, -0.00213623046875, -0.004364013671875, -0.00714111328125, -0.010711669921875, -0.01348876953125, -0.012359619140625, -0.009552001953125, -0.0093994140625, -0.009613037109375, -0.0079345703125, -0.004486083984375, -0.00140380859375, 0.000213623046875, 0.00042724609375, 0.0003662109375, 0.000579833984375, -0.001312255859375, -0.0048828125, -0.0076904296875, -0.007843017578125, -0.006805419921875, -0.00634765625, -0.006988525390625, -0.00738525390625, -0.004974365234375, -0.00201416015625, -0.000732421875, -0.000732421875, -0.000823974609375, 3.0517578125e-05, 0.0006103515625, 0.00030517578125, -0.00054931640625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 3.0517578125e-05, 6.103515625e-05, -6.103515625e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.000152587890625, 3.0517578125e-05, 0.000213623046875, -0.0001220703125, 0.00030517578125, -0.000335693359375, 0.000396728515625, -0.00030517578125, 0.0003662109375, -0.000396728515625, 0.000518798828125, -6.103515625e-05, 0.02813720703125, 0.07659912109375, -0.026092529296875, -0.10528564453125, -0.0408935546875, 0.00286865234375, 0.04034423828125, 0.05682373046875, 0.0589599609375, 0.08819580078125, 0.1468505859375, 0.111907958984375, 0.00299072265625, -0.0277099609375, -0.021240234375, -0.0257568359375, -0.03564453125, -0.042724609375, -0.0562744140625, -0.05426025390625, -0.036834716796875, -0.021514892578125, -0.003204345703125, 0.003692626953125, 0.0115966796875, 0.027252197265625, 0.041748046875, 0.043701171875, 0.0313720703125, 0.014495849609375, 0.00732421875, 0.0118408203125, 0.0125732421875, 0.001800537109375, -0.0169677734375, -0.026397705078125, -0.02655029296875, -0.028594970703125, -0.02874755859375, -0.02471923828125, -0.01666259765625, -0.0091552734375, -0.002044677734375, 0.002166748046875, -0.00042724609375, 0.00079345703125, 0.007110595703125, 0.00836181640625, 0.002349853515625, -0.0032958984375, -0.006011962890625, -0.008544921875, -0.012237548828125, -0.0155029296875, -0.01629638671875, -0.014739990234375, -0.011566162109375, -0.0091552734375, -0.007568359375, -0.005035400390625, -0.001312255859375, 0.00146484375, 0.00225830078125, 0.002899169921875, 0.004058837890625, 0.00396728515625, 0.003082275390625, 0.002471923828125, 0.001495361328125, -0.000274658203125, -0.0029296875, -0.0054931640625, -0.0078125, -0.009918212890625, -0.011199951171875, -0.011383056640625, -0.0101318359375, -0.01080322265625, -0.0123291015625, -0.0101318359375, -0.004852294921875, 0.000152587890625, 0.001739501953125, 0.001129150390625, 0.001220703125, 0.0025634765625, 0.001922607421875, -0.0029296875, -0.0086669921875, -0.01153564453125, -0.011138916015625, -0.0091552734375, -0.007781982421875, -0.008331298828125, -0.006988525390625, -0.002777099609375, 0.000213623046875, 0.001861572265625, 0.00201416015625, 0.001617431640625, 0.001556396484375, 0.00079345703125, 0.0003662109375, -0.000732421875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 9.1552734375e-05, 0.0, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, -3.0517578125e-05, 0.00018310546875, 0.0, 0.000213623046875, -6.103515625e-05, 0.000244140625, -0.000152587890625, 0.000213623046875, -3.0517578125e-05, -9.1552734375e-05, 0.000396728515625, -0.000213623046875, 0.0003662109375, 0.018218994140625, 0.09100341796875, 0.00469970703125, -0.13336181640625, -0.064849853515625, 0.0045166015625, 0.04217529296875, 0.06427001953125, 0.0614013671875, 0.08935546875, 0.16522216796875, 0.150177001953125, 0.012359619140625, -0.043548583984375, -0.033355712890625, -0.03228759765625, -0.0382080078125, -0.046051025390625, -0.06500244140625, -0.069061279296875, -0.055877685546875, -0.03948974609375, -0.00311279296875, 0.006805419921875, 0.00897216796875, 0.023773193359375, 0.035491943359375, 0.049163818359375, 0.050048828125, 0.03021240234375, 0.015289306640625, 0.01800537109375, 0.00579833984375, -0.015716552734375, -0.0189208984375, -0.014801025390625, -0.019561767578125, -0.026824951171875, -0.0283203125, -0.026275634765625, -0.017059326171875, -0.006439208984375, -0.002166748046875, -0.000274658203125, 0.00152587890625, 0.00537109375, 0.00823974609375, 0.004638671875, -0.000396728515625, -0.00091552734375, -0.00445556640625, -0.009674072265625, -0.01226806640625, -0.0157470703125, -0.017913818359375, -0.016510009765625, -0.01214599609375, -0.008453369140625, -0.004547119140625, -0.001800537109375, -0.002227783203125, -0.002227783203125, -0.000213623046875, 0.001129150390625, 0.001861572265625, 0.003631591796875, 0.00390625, 0.002899169921875, 0.00164794921875, -0.000244140625, -0.002349853515625, -0.005889892578125, -0.009185791015625, -0.010009765625, -0.009552001953125, -0.00909423828125, -0.007904052734375, -0.008331298828125, -0.012237548828125, -0.01361083984375, -0.008941650390625, -0.001953125, 0.003021240234375, 0.00347900390625, 0.001800537109375, 0.002655029296875, 0.003570556640625, 0.000152587890625, -0.00689697265625, -0.011993408203125, -0.013092041015625, -0.01239013671875, -0.010833740234375, -0.010284423828125, -0.008331298828125, -0.0040283203125, -0.00067138671875, 0.001617431640625, 0.003509521484375, 0.0052490234375, 0.005584716796875, 0.003509521484375, 0.000701904296875, -0.001068115234375, -0.002593994140625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 0.0, 9.1552734375e-05, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, -9.1552734375e-05, 0.0001220703125, 6.103515625e-05, 0.000152587890625, 3.0517578125e-05, 9.1552734375e-05, 0.0001220703125, -0.0001220703125, 0.00048828125, -0.000701904296875, 0.001068115234375, -0.000946044921875, 0.001678466796875, 0.00933837890625, 0.097412109375, 0.044189453125, -0.153900146484375, -0.1015625, 0.005157470703125, 0.04547119140625, 0.074005126953125, 0.068572998046875, 0.091644287109375, 0.176788330078125, 0.1851806640625, 0.030487060546875, -0.0556640625, -0.046661376953125, -0.037994384765625, -0.043426513671875, -0.054901123046875, -0.07000732421875, -0.07940673828125, -0.067779541015625, -0.04931640625, -0.013641357421875, -0.0003662109375, 0.0101318359375, 0.02569580078125, 0.0347900390625, 0.04949951171875, 0.046051025390625, 0.0355224609375, 0.030426025390625, 0.029266357421875, 0.008758544921875, -0.01806640625, -0.027435302734375, -0.026885986328125, -0.0213623046875, -0.019012451171875, -0.020965576171875, -0.019073486328125, -0.009246826171875, -0.00775146484375, -0.008941650390625, 0.0006103515625, 0.007354736328125, 0.0087890625, 0.006378173828125, 0.003814697265625, 0.002197265625, -0.0018310546875, -0.00677490234375, -0.011505126953125, -0.013641357421875, -0.01507568359375, -0.016448974609375, -0.017547607421875, -0.014862060546875, -0.0084228515625, -0.00347900390625, -0.002197265625, -0.002166748046875, 0.00018310546875, 0.00152587890625, -6.103515625e-05, 0.00048828125, 0.002105712890625, 0.002227783203125, 0.0020751953125, 6.103515625e-05, -0.002532958984375, -0.0037841796875, -0.005126953125, -0.00732421875, -0.00927734375, -0.00921630859375, -0.007720947265625, -0.005584716796875, -0.004547119140625, -0.008758544921875, -0.0137939453125, -0.012847900390625, -0.00634765625, 0.0006103515625, 0.0037841796875, 0.003173828125, 0.002899169921875, 0.00445556640625, 0.002227783203125, -0.00433349609375, -0.01104736328125, -0.013763427734375, -0.013702392578125, -0.011993408203125, -0.010894775390625, -0.01092529296875, -0.006378173828125, -0.001190185546875, 0.00030517578125, 0.002655029296875, 0.00628662109375, 0.008819580078125, 0.007293701171875, 0.003204345703125, 0.0006103515625, -0.001708984375, -0.00421142578125])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 0.0, 0.0, -3.0517578125e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 0.0, -9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 0.0001220703125, -0.000213623046875, 0.0003662109375, -0.000518798828125, 0.0008544921875, -0.0010986328125, 0.00146484375, -0.001617431640625, 0.0029296875, 0.00286865234375, 0.095458984375, 0.087860107421875, -0.161102294921875, -0.149444580078125, 0.000335693359375, 0.050079345703125, 0.0841064453125, 0.07745361328125, 0.096923828125, 0.190521240234375, 0.217926025390625, 0.048614501953125, -0.067169189453125, -0.060943603515625, -0.045257568359375, -0.04437255859375, -0.0604248046875, -0.079376220703125, -0.09423828125, -0.077239990234375, -0.056671142578125, -0.01959228515625, 0.000885009765625, 0.000732421875, 0.019073486328125, 0.040069580078125, 0.053955078125, 0.053619384765625, 0.03985595703125, 0.019866943359375, 0.025360107421875, 0.02117919921875, -0.009521484375, -0.030609130859375, -0.035003662109375, -0.032379150390625, -0.028778076171875, -0.01519775390625, -0.00494384765625, -0.004913330078125, -0.004241943359375, -0.000152587890625, 0.004974365234375, 0.006195068359375, 0.006317138671875, 0.008697509765625, 0.008392333984375, 0.002899169921875, -0.002685546875, -0.00897216796875, -0.015899658203125, -0.015838623046875, -0.015289306640625, -0.017242431640625, -0.016632080078125, -0.01324462890625, -0.010711669921875, -0.008636474609375, -0.00433349609375, -0.000518798828125, 0.002471923828125, 0.004364013671875, 0.003326416015625, 0.001556396484375, 0.001556396484375, 0.001434326171875, -0.00054931640625, -0.00390625, -0.00653076171875, -0.005859375, -0.0045166015625, -0.006195068359375, -0.008270263671875, -0.007965087890625, -0.006439208984375, -0.00457763671875, -0.0020751953125, -0.004730224609375, -0.012451171875, -0.014129638671875, -0.00927734375, -0.002777099609375, 0.0015869140625, 0.00250244140625, 0.00244140625, 0.004547119140625, 0.005035400390625, -0.00115966796875, -0.010528564453125, -0.014739990234375, -0.01446533203125, -0.012115478515625, -0.0101318359375, -0.011383056640625, -0.00921630859375, -0.00299072265625, 0.000732421875, 0.0020751953125, 0.004638671875, 0.00823974609375, 0.008697509765625, 0.0054931640625, 0.00262451171875, 0.000640869140625, -0.00238037109375, -0.005889892578125])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, -6.103515625e-05, 0.0, 0.000152587890625, -3.0517578125e-05, 0.000244140625, -0.000335693359375, 0.00054931640625, -0.000762939453125, 0.001068115234375, -0.001373291015625, 0.0018310546875, -0.001922607421875, 0.00341796875, -0.0001220703125, 0.088134765625, 0.12872314453125, -0.154296875, -0.20135498046875, -0.01263427734375, 0.054779052734375, 0.096588134765625, 0.08892822265625, 0.103424072265625, 0.20440673828125, 0.247100830078125, 0.0716552734375, -0.073883056640625, -0.078521728515625, -0.059173583984375, -0.04742431640625, -0.062774658203125, -0.083465576171875, -0.106353759765625, -0.09222412109375, -0.06622314453125, -0.02392578125, 0.004119873046875, -0.000640869140625, 0.012786865234375, 0.036773681640625, 0.06134033203125, 0.062774658203125, 0.043701171875, 0.01788330078125, 0.02447509765625, 0.019744873046875, -0.014404296875, -0.0294189453125, -0.03662109375, -0.036773681640625, -0.028656005859375, -0.02301025390625, -0.0196533203125, -0.003204345703125, 0.013214111328125, 0.01263427734375, 0.010894775390625, 0.01416015625, 0.011749267578125, 0.007354736328125, 0.00885009765625, 0.00640869140625, -0.00335693359375, -0.011810302734375, -0.018463134765625, -0.019195556640625, -0.0169677734375, -0.01678466796875, -0.01800537109375, -0.01715087890625, -0.012420654296875, -0.007293701171875, -0.004974365234375, -0.00323486328125, 0.00244140625, 0.0074462890625, 0.007110595703125, 0.004486083984375, 0.0030517578125, 0.0001220703125, -0.00311279296875, -0.00506591796875, -0.006866455078125, -0.00750732421875, -0.006317138671875, -0.006500244140625, -0.00750732421875, -0.00726318359375, -0.0059814453125, -0.003753662109375, -0.00048828125, -0.00103759765625, -0.0096435546875, -0.014923095703125, -0.012115478515625, -0.0047607421875, 0.001251220703125, 0.001556396484375, 0.000213623046875, 0.0028076171875, 0.0067138671875, 0.0029296875, -0.00787353515625, -0.015167236328125, -0.01519775390625, -0.013031005859375, -0.009674072265625, -0.009765625, -0.010345458984375, -0.005279541015625, -0.00030517578125, 0.002838134765625, 0.0052490234375, 0.007293701171875, 0.00799560546875, 0.00518798828125, 0.003448486328125, 0.002960205078125, -6.103515625e-05, -0.003936767578125, -0.007476806640625])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, -3.0517578125e-05, 6.103515625e-05, -9.1552734375e-05, 0.0, 0.0, -6.103515625e-05, -9.1552734375e-05, 0.00018310546875, -9.1552734375e-05, 0.000335693359375, -0.00048828125, 0.00054931640625, -0.00079345703125, 0.001007080078125, -0.001373291015625, 0.001495361328125, -0.001617431640625, 0.002777099609375, -0.00042724609375, 0.079833984375, 0.159942626953125, -0.1357421875, -0.249847412109375, -0.033782958984375, 0.0557861328125, 0.10858154296875, 0.108184814453125, 0.11297607421875, 0.21832275390625, 0.26751708984375, 0.093170166015625, -0.072021484375, -0.0909423828125, -0.075958251953125, -0.059906005859375, -0.067138671875, -0.083953857421875, -0.115386962890625, -0.1063232421875, -0.075927734375, -0.031280517578125, 0.007537841796875, -0.0025634765625, 0.0125732421875, 0.041748046875, 0.06195068359375, 0.063385009765625, 0.04766845703125, 0.024627685546875, 0.023529052734375, 0.0184326171875, -0.01519775390625, -0.037078857421875, -0.039398193359375, -0.0341796875, -0.0350341796875, -0.033203125, -0.0220947265625, -0.00689697265625, 0.00445556640625, 0.015228271484375, 0.02801513671875, 0.0296630859375, 0.02093505859375, 0.015350341796875, 0.011566162109375, 0.00335693359375, -0.0048828125, -0.010528564453125, -0.01837158203125, -0.020263671875, -0.019775390625, -0.022979736328125, -0.023834228515625, -0.018829345703125, -0.012481689453125, -0.008575439453125, -0.003875732421875, -0.000701904296875, 0.002655029296875, 0.006561279296875, 0.008056640625, 0.005340576171875, 0.0023193359375, -0.0001220703125, -0.001953125, -0.00360107421875, -0.006561279296875, -0.0079345703125, -0.006622314453125, -0.006317138671875, -0.0076904296875, -0.00811767578125, -0.00653076171875, -0.00408935546875, -0.000823974609375, 0.00115966796875, -0.006500244140625, -0.01446533203125, -0.013458251953125, -0.00750732421875, -0.0003662109375, 0.002105712890625, 0.00018310546875, 0.000274658203125, 0.0045166015625, 0.0052490234375, -0.003631591796875, -0.012969970703125, -0.01458740234375, -0.014404296875, -0.011688232421875, -0.00885009765625, -0.009429931640625, -0.00689697265625, -0.002410888671875, 0.00213623046875, 0.00567626953125, 0.0072021484375, 0.008209228515625, 0.005767822265625, 0.00299072265625, 0.003204345703125, 0.0015869140625, -0.001953125, -0.005889892578125, -0.010223388671875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, -6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -0.000152587890625, -0.000213623046875, 6.103515625e-05, -0.00018310546875, 0.000274658203125, -0.000579833984375, 0.00048828125, -0.000885009765625, 0.0008544921875, -0.00128173828125, 0.00103759765625, -0.001190185546875, 0.0018310546875, 0.0001220703125, 0.0740966796875, 0.17938232421875, -0.1107177734375, -0.287322998046875, -0.062408447265625, 0.054107666015625, 0.112640380859375, 0.132354736328125, 0.13323974609375, 0.232757568359375, 0.278289794921875, 0.108795166015625, -0.062835693359375, -0.098114013671875, -0.0882568359375, -0.076690673828125, -0.08245849609375, -0.085357666015625, -0.115936279296875, -0.120697021484375, -0.08734130859375, -0.04248046875, 0.009185791015625, 0.00762939453125, 0.00775146484375, 0.0404052734375, 0.066192626953125, 0.0692138671875, 0.05517578125, 0.0220947265625, 0.0216064453125, 0.022308349609375, -0.014739990234375, -0.03594970703125, -0.043670654296875, -0.049102783203125, -0.043426513671875, -0.029693603515625, -0.0205078125, -0.0137939453125, -0.001312255859375, 0.013427734375, 0.02386474609375, 0.034942626953125, 0.03656005859375, 0.02569580078125, 0.016082763671875, 0.00860595703125, -0.001068115234375, -0.008392333984375, -0.0181884765625, -0.0240478515625, -0.0240478515625, -0.025970458984375, -0.02667236328125, -0.024444580078125, -0.01800537109375, -0.008697509765625, -0.00128173828125, 0.00140380859375, 0.003936767578125, 0.00634765625, 0.00579833984375, 0.002838134765625, 0.0023193359375, 0.001861572265625, -0.00042724609375, -0.002838134765625, -0.00494384765625, -0.006927490234375, -0.00732421875, -0.00653076171875, -0.007293701171875, -0.007659912109375, -0.00689697265625, -0.00518798828125, -0.002960205078125, 0.001190185546875, -0.0025634765625, -0.013916015625, -0.016143798828125, -0.010223388671875, -0.001220703125, 0.0035400390625, -3.0517578125e-05, -0.001800537109375, 0.002288818359375, 0.005645751953125, -0.000213623046875, -0.010528564453125, -0.013702392578125, -0.014373779296875, -0.013580322265625, -0.00927734375, -0.009613037109375, -0.009063720703125, -0.00390625, 0.001129150390625, 0.005401611328125, 0.006500244140625, 0.00750732421875, 0.006622314453125, 0.003692626953125, 0.00390625, 0.00311279296875, -0.000335693359375, -0.004302978515625, -0.009857177734375, -0.01470947265625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -6.103515625e-05, 0.0, 0.0, -9.1552734375e-05, -0.000152587890625, 0.0001220703125, -0.0001220703125, 0.000335693359375, -0.00048828125, 0.00048828125, -0.000823974609375, 0.000762939453125, -0.00103759765625, 0.000732421875, -0.0009765625, 0.0015869140625, 0.000396728515625, 0.07470703125, 0.1861572265625, -0.090789794921875, -0.302337646484375, -0.09521484375, 0.04754638671875, 0.113922119140625, 0.149871826171875, 0.162841796875, 0.25421142578125, 0.28118896484375, 0.117431640625, -0.049468994140625, -0.1019287109375, -0.09619140625, -0.0909423828125, -0.10028076171875, -0.093902587890625, -0.11761474609375, -0.12969970703125, -0.1019287109375, -0.046356201171875, 0.01068115234375, 0.008270263671875, 0.0069580078125, 0.04095458984375, 0.073272705078125, 0.073150634765625, 0.058990478515625, 0.02734375, 0.0235595703125, 0.025848388671875, -0.011993408203125, -0.0426025390625, -0.05462646484375, -0.053466796875, -0.0462646484375, -0.036956787109375, -0.023529052734375, -0.00762939453125, 0.001251220703125, 0.010833740234375, 0.022247314453125, 0.0299072265625, 0.030426025390625, 0.028717041015625, 0.027587890625, 0.01959228515625, 0.005828857421875, -0.005279541015625, -0.018798828125, -0.02520751953125, -0.022369384765625, -0.026336669921875, -0.030914306640625, -0.027374267578125, -0.019012451171875, -0.0108642578125, -0.00396728515625, 0.0003662109375, 0.003448486328125, 0.005859375, 0.006805419921875, 0.004913330078125, 0.002655029296875, 0.00146484375, 0.000732421875, -0.001220703125, -0.00335693359375, -0.005157470703125, -0.006134033203125, -0.006622314453125, -0.00701904296875, -0.006744384765625, -0.0068359375, -0.006195068359375, -0.00482177734375, 0.0006103515625, 0.00146484375, -0.0113525390625, -0.019012451171875, -0.01318359375, -0.0030517578125, 0.0047607421875, 0.00225830078125, -0.002288818359375, 0.0008544921875, 0.00592041015625, 0.002410888671875, -0.00830078125, -0.0133056640625, -0.0137939453125, -0.014404296875, -0.010528564453125, -0.00982666015625, -0.01019287109375, -0.00469970703125, 0.000518798828125, 0.00494384765625, 0.005859375, 0.005889892578125, 0.00689697265625, 0.00604248046875, 0.005706787109375, 0.004852294921875, 0.002044677734375, -0.002227783203125, -0.008636474609375, -0.014251708984375, -0.016204833984375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, -0.000213623046875, 0.000152587890625, -0.0001220703125, 0.00030517578125, -0.000396728515625, 0.00042724609375, -0.000823974609375, 0.000732421875, -0.00115966796875, 0.0009765625, -0.00146484375, 0.0020751953125, -0.000152587890625, 0.080841064453125, 0.185455322265625, -0.0853271484375, -0.295654296875, -0.12152099609375, 0.030303955078125, 0.116363525390625, 0.16290283203125, 0.189697265625, 0.27838134765625, 0.28448486328125, 0.125244140625, -0.034210205078125, -0.104949951171875, -0.1029052734375, -0.10333251953125, -0.118988037109375, -0.103240966796875, -0.126373291015625, -0.135040283203125, -0.103729248046875, -0.061767578125, 0.001068115234375, 0.012664794921875, 0.015533447265625, 0.046478271484375, 0.071258544921875, 0.074432373046875, 0.065155029296875, 0.040008544921875, 0.03436279296875, 0.020538330078125, -0.021820068359375, -0.045135498046875, -0.0550537109375, -0.0579833984375, -0.055999755859375, -0.043731689453125, -0.0216064453125, -0.005157470703125, 0.002410888671875, 0.013153076171875, 0.02142333984375, 0.02740478515625, 0.029052734375, 0.024078369140625, 0.022979736328125, 0.021514892578125, 0.0126953125, 0.001007080078125, -0.013946533203125, -0.02264404296875, -0.02337646484375, -0.0257568359375, -0.027801513671875, -0.02508544921875, -0.020599365234375, -0.014404296875, -0.00836181640625, -0.004364013671875, 0.001220703125, 0.00567626953125, 0.007720947265625, 0.0054931640625, 0.004180908203125, 0.002777099609375, 0.0001220703125, -0.001922607421875, -0.00299072265625, -0.003143310546875, -0.003631591796875, -0.00506591796875, -0.006103515625, -0.0059814453125, -0.006439208984375, -0.0079345703125, -0.007415771484375, -0.002105712890625, 0.0032958984375, -0.0064697265625, -0.01922607421875, -0.01641845703125, -0.006805419921875, 0.00445556640625, 0.006103515625, -0.000518798828125, 0.000579833984375, 0.00604248046875, 0.00335693359375, -0.006378173828125, -0.01263427734375, -0.0142822265625, -0.0164794921875, -0.013031005859375, -0.0098876953125, -0.010986328125, -0.005645751953125, 0.00067138671875, 0.004180908203125, 0.0052490234375, 0.004852294921875, 0.0057373046875, 0.00653076171875, 0.00775146484375, 0.007415771484375, 0.004058837890625, -0.000274658203125, -0.006103515625, -0.012542724609375, -0.01617431640625, -0.017730712890625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, -9.1552734375e-05, -9.1552734375e-05, 9.1552734375e-05, -6.103515625e-05, 0.0003662109375, -0.00042724609375, 0.00054931640625, -0.0008544921875, 0.000946044921875, -0.001434326171875, 0.001434326171875, -0.001983642578125, 0.002838134765625, -0.00048828125, 0.0921630859375, 0.181793212890625, -0.099395751953125, -0.276275634765625, -0.12774658203125, 0.007904052734375, 0.119384765625, 0.176361083984375, 0.20989990234375, 0.292938232421875, 0.281829833984375, 0.1383056640625, -0.013092041015625, -0.1072998046875, -0.1094970703125, -0.11639404296875, -0.138214111328125, -0.114898681640625, -0.127685546875, -0.146026611328125, -0.1180419921875, -0.0621337890625, -0.00274658203125, 0.00677490234375, 0.015899658203125, 0.055206298828125, 0.07672119140625, 0.0833740234375, 0.080780029296875, 0.04412841796875, 0.028564453125, 0.016571044921875, -0.017120361328125, -0.045257568359375, -0.0625, -0.0657958984375, -0.058563232421875, -0.044708251953125, -0.02362060546875, -0.007110595703125, -0.001739501953125, 0.012237548828125, 0.026397705078125, 0.031982421875, 0.02783203125, 0.020355224609375, 0.0169677734375, 0.0135498046875, 0.009613037109375, 0.0062255859375, -0.005889892578125, -0.016571044921875, -0.01947021484375, -0.022308349609375, -0.025787353515625, -0.025848388671875, -0.022552490234375, -0.01617431640625, -0.00946044921875, -0.00390625, 0.0013427734375, 0.003082275390625, 0.004913330078125, 0.004791259765625, 0.004058837890625, 0.002288818359375, -0.000335693359375, -0.002838134765625, -0.003173828125, -0.001800537109375, -0.0008544921875, -0.002197265625, -0.004150390625, -0.003936767578125, -0.00408935546875, -0.006591796875, -0.009002685546875, -0.0072021484375, 0.00048828125, -0.001678466796875, -0.01593017578125, -0.01849365234375, -0.0108642578125, -9.1552734375e-05, 0.007965087890625, 0.0042724609375, 0.0009765625, 0.00616455078125, 0.005584716796875, -0.003387451171875, -0.011260986328125, -0.01373291015625, -0.018035888671875, -0.0177001953125, -0.01104736328125, -0.011474609375, -0.00787353515625, -9.1552734375e-05, 0.00372314453125, 0.00555419921875, 0.00506591796875, 0.004364013671875, 0.0048828125, 0.00726318359375, 0.008941650390625, 0.007049560546875, 0.003326416015625, -0.00189208984375, -0.008941650390625, -0.01519775390625, -0.01812744140625, -0.01947021484375])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([0.000152587890625, -0.000244140625, 0.00054931640625, -0.00067138671875, 0.000823974609375, -0.001373291015625, 0.001434326171875, -0.001556396484375, 0.001068115234375, -0.0013427734375, 0.001373291015625, 0.000396728515625, 0.112548828125, 0.21844482421875, -0.228302001953125, -0.219879150390625, 0.06036376953125, -0.134307861328125, 0.14105224609375, 0.33563232421875, 0.1519775390625, 0.10809326171875, 0.417327880859375, 0.28948974609375, -0.27386474609375, -0.109588623046875, 0.00445556640625, -0.3314208984375, -0.195831298828125, 0.064300537109375, -0.175201416015625, -0.22247314453125, 0.002716064453125, 0.0543212890625, -0.0018310546875, 0.02252197265625, 0.133514404296875, 0.10638427734375, 0.047119140625, 0.073577880859375, 0.023468017578125, -0.069793701171875, -0.048492431640625, -0.044830322265625, -0.1051025390625, -0.1153564453125, -0.071929931640625, -0.034515380859375, -0.04705810546875, -0.02349853515625, 0.035919189453125, 0.028411865234375, 0.028594970703125, 0.054351806640625, 0.046661376953125, 0.031097412109375, 0.02752685546875, 0.02276611328125, 0.007354736328125, -0.016815185546875, -0.02239990234375, -0.01934814453125, -0.03643798828125, -0.0355224609375, -0.022308349609375, -0.02960205078125, -0.027435302734375, -0.00927734375, -0.00323486328125, -0.001068115234375, 0.005645751953125, 0.015838623046875, 0.014373779296875, 0.011016845703125, 0.01214599609375, 0.00732421875, 9.1552734375e-05, -0.00555419921875, -0.009185791015625, -0.0126953125, -0.016387939453125, -0.014862060546875, -0.00897216796875, -0.011474609375, -0.011566162109375, -0.00518798828125, -0.0045166015625, -0.00579833984375, -0.000885009765625, 0.00299072265625, 0.00384521484375, 0.003692626953125, 0.004364013671875, 0.0020751953125, -0.001556396484375, -0.00408935546875, -0.004241943359375, -0.002960205078125, -0.0040283203125, -0.00299072265625, -0.00079345703125, -0.001739501953125, -0.0037841796875, -0.001678466796875, -0.001190185546875, -0.0040283203125, -0.00201416015625, 0.000274658203125, -0.004486083984375, -0.006866455078125, -0.006744384765625, -0.006683349609375, -0.004241943359375, -0.00067138671875, -0.00042724609375, -0.0030517578125, -0.00225830078125, -0.00030517578125, 6.103515625e-05, -0.001800537109375, -0.005584716796875, -0.00787353515625, -0.007598876953125, -0.008514404296875, -0.009246826171875, -0.0078125, -0.009613037109375, -0.013031005859375])
        IR_LEFT[len(IR_LEFT)-1].append([-0.00018310546875, 0.000213623046875, -0.000244140625, 0.000457763671875, -0.0003662109375, 0.00042724609375, -0.000701904296875, 0.0003662109375, -0.000152587890625, -0.00048828125, 0.00054931640625, -0.000762939453125, 0.001007080078125, 0.059722900390625, 0.208251953125, -0.09320068359375, -0.259765625, 0.01190185546875, -0.121734619140625, 0.025726318359375, 0.3016357421875, 0.204986572265625, 0.1123046875, 0.304901123046875, 0.35552978515625, -0.102996826171875, -0.143096923828125, 0.0086669921875, -0.245635986328125, -0.240447998046875, 0.027557373046875, -0.089447021484375, -0.208953857421875, -0.058197021484375, 0.025787353515625, 0.00921630859375, 0.000152587890625, 0.085784912109375, 0.102508544921875, 0.039581298828125, 0.058746337890625, 0.051239013671875, -0.0303955078125, -0.04229736328125, -0.026336669921875, -0.067230224609375, -0.093963623046875, -0.074554443359375, -0.058837890625, -0.052734375, -0.0252685546875, 0.0128173828125, 0.015411376953125, 0.01885986328125, 0.03900146484375, 0.043365478515625, 0.03692626953125, 0.025482177734375, 0.01666259765625, 0.013458251953125, -0.002960205078125, -0.017913818359375, -0.01361083984375, -0.022705078125, -0.032379150390625, -0.02532958984375, -0.0223388671875, -0.025054931640625, -0.014251708984375, -0.005767822265625, -0.005828857421875, 0.000732421875, 0.010223388671875, 0.0086669921875, 0.006744384765625, 0.010467529296875, 0.007904052734375, 0.00311279296875, -0.0006103515625, -0.005645751953125, -0.009429931640625, -0.012420654296875, -0.013641357421875, -0.009735107421875, -0.01055908203125, -0.0113525390625, -0.00848388671875, -0.00604248046875, -0.005096435546875, -0.00177001953125, 0.001495361328125, 0.002960205078125, 0.0042724609375, 0.0045166015625, 0.00189208984375, -0.001556396484375, -0.003448486328125, -0.003814697265625, -0.00201416015625, -0.002227783203125, -0.002777099609375, -0.001129150390625, -0.000701904296875, -0.00335693359375, -0.002685546875, -0.00091552734375, -0.002532958984375, -0.004058837890625, -0.00433349609375, -0.007720947265625, -0.0084228515625, -0.005035400390625, -0.002593994140625, -0.000823974609375, -0.000213623046875, -0.00115966796875, -0.00189208984375, 0.000335693359375, 0.00103759765625, -0.001495361328125, -0.005859375, -0.009613037109375, -0.009918212890625, -0.008544921875, -0.010406494140625, -0.01031494140625, -0.010772705078125, -0.013275146484375])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -0.0001220703125, 0.00018310546875, -0.000152587890625, 0.000396728515625, -0.000457763671875, 0.00048828125, -0.0008544921875, 0.00079345703125, -0.0008544921875, 0.0003662109375, -0.000518798828125, 0.00079345703125, 0.00054931640625, 0.078643798828125, 0.17327880859375, -0.134521484375, -0.190460205078125, 0.009002685546875, -0.11834716796875, 0.0657958984375, 0.264129638671875, 0.1737060546875, 0.116943359375, 0.302490234375, 0.283721923828125, -0.097930908203125, -0.092010498046875, -0.0272216796875, -0.233673095703125, -0.17803955078125, 0.012542724609375, -0.108184814453125, -0.1707763671875, -0.04266357421875, 0.01519775390625, 0.00274658203125, 0.0115966796875, 0.078033447265625, 0.073455810546875, 0.02935791015625, 0.04779052734375, 0.03839111328125, -0.0208740234375, -0.029144287109375, -0.021759033203125, -0.0521240234375, -0.06793212890625, -0.0587158203125, -0.0560302734375, -0.05126953125, -0.02288818359375, 0.0059814453125, 0.002349853515625, 0.00872802734375, 0.029205322265625, 0.034912109375, 0.027496337890625, 0.018951416015625, 0.0159912109375, 0.015045166015625, 0.001068115234375, -0.010162353515625, -0.008636474609375, -0.019317626953125, -0.02557373046875, -0.01983642578125, -0.020904541015625, -0.02288818359375, -0.012969970703125, -0.009552001953125, -0.008880615234375, -0.001068115234375, 0.006103515625, 0.003997802734375, 0.0045166015625, 0.00927734375, 0.0072021484375, 0.003692626953125, 0.00091552734375, -0.003753662109375, -0.007904052734375, -0.010284423828125, -0.011138916015625, -0.010528564453125, -0.011444091796875, -0.0113525390625, -0.009246826171875, -0.007232666015625, -0.0050048828125, -0.000274658203125, 0.00225830078125, 0.00341796875, 0.003997802734375, 0.004791259765625, 0.001953125, -0.001708984375, -0.003570556640625, -0.00433349609375, -0.002777099609375, -0.00341796875, -0.0032958984375, -0.001495361328125, -0.00091552734375, -0.00225830078125, -0.0018310546875, -0.001220703125, -0.003753662109375, -0.005828857421875, -0.006683349609375, -0.008697509765625, -0.00653076171875, -0.0025634765625, -0.00091552734375, -0.00091552734375, -0.00128173828125, -0.001190185546875, -0.000274658203125, 0.001678466796875, -9.1552734375e-05, -0.00457763671875, -0.008148193359375, -0.01043701171875, -0.010772705078125, -0.01068115234375, -0.010589599609375, -0.009490966796875, -0.01007080078125])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -9.1552734375e-05, -3.0517578125e-05, 6.103515625e-05, -0.0001220703125, 0.000274658203125, -0.0003662109375, 0.0003662109375, -0.0008544921875, 0.00079345703125, -0.001129150390625, 0.000823974609375, -0.000946044921875, 0.001312255859375, 0.001861572265625, 0.089385986328125, 0.1353759765625, -0.147064208984375, -0.13671875, -0.00128173828125, -0.103179931640625, 0.085693359375, 0.2281494140625, 0.1474609375, 0.120452880859375, 0.2891845703125, 0.234375, -0.08013916015625, -0.073760986328125, -0.0450439453125, -0.201446533203125, -0.13958740234375, -0.001800537109375, -0.11187744140625, -0.141998291015625, -0.03753662109375, 0.004608154296875, -0.00201416015625, 0.016021728515625, 0.072509765625, 0.049072265625, 0.010894775390625, 0.04376220703125, 0.038238525390625, -0.01470947265625, -0.018341064453125, -0.01092529296875, -0.036865234375, -0.04937744140625, -0.043182373046875, -0.0474853515625, -0.052642822265625, -0.03045654296875, -0.002838134765625, -0.0067138671875, -0.00396728515625, 0.014923095703125, 0.024566650390625, 0.023162841796875, 0.02056884765625, 0.02069091796875, 0.016815185546875, 0.002044677734375, -0.0032958984375, -0.003326416015625, -0.016754150390625, -0.021820068359375, -0.015899658203125, -0.017913818359375, -0.021331787109375, -0.015655517578125, -0.01202392578125, -0.009735107421875, -0.003265380859375, 0.002838134765625, 0.001434326171875, 0.002471923828125, 0.00714111328125, 0.0076904296875, 0.00408935546875, 0.000213623046875, -0.00341796875, -0.005767822265625, -0.0084228515625, -0.010040283203125, -0.009918212890625, -0.013092041015625, -0.012054443359375, -0.0078125, -0.005615234375, -0.0037841796875, -0.000579833984375, 0.00286865234375, 0.00372314453125, 0.00396728515625, 0.00311279296875, -0.000244140625, -0.002349853515625, -0.004852294921875, -0.004669189453125, -0.003662109375, -0.002899169921875, -0.002105712890625, -0.000274658203125, 0.000732421875, -0.002197265625, -0.00238037109375, -0.00286865234375, -0.005767822265625, -0.008087158203125, -0.00823974609375, -0.00750732421875, -0.004425048828125, -0.00054931640625, -0.0003662109375, -0.00177001953125, -0.0015869140625, -9.1552734375e-05, 0.001678466796875, 0.001220703125, -0.002777099609375, -0.00750732421875, -0.00994873046875, -0.011199951171875, -0.011383056640625, -0.010528564453125, -0.009063720703125, -0.007904052734375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, -0.000152587890625, 0.0, 0.0, -9.1552734375e-05, 0.00018310546875, -0.000244140625, 0.000274658203125, -0.000701904296875, 0.000732421875, -0.0010986328125, 0.0009765625, -0.0009765625, 0.001220703125, 0.00433349609375, 0.0927734375, 0.1015625, -0.14263916015625, -0.09686279296875, -0.01141357421875, -0.08575439453125, 0.093292236328125, 0.1932373046875, 0.12713623046875, 0.1239013671875, 0.2735595703125, 0.200164794921875, -0.0721435546875, -0.06072998046875, -0.042877197265625, -0.173919677734375, -0.111175537109375, -0.013092041015625, -0.111053466796875, -0.12103271484375, -0.037200927734375, -0.001739501953125, -0.00372314453125, 0.01739501953125, 0.05413818359375, 0.026153564453125, 0.009613037109375, 0.048309326171875, 0.035064697265625, -0.011138916015625, -0.003326416015625, 0.003570556640625, -0.023162841796875, -0.03973388671875, -0.0369873046875, -0.04083251953125, -0.049774169921875, -0.03759765625, -0.019989013671875, -0.020233154296875, -0.00994873046875, 0.00946044921875, 0.020294189453125, 0.02484130859375, 0.02337646484375, 0.02093505859375, 0.0164794921875, 0.004730224609375, 0.000946044921875, -0.00274658203125, -0.014007568359375, -0.01654052734375, -0.01239013671875, -0.0169677734375, -0.02093505859375, -0.01605224609375, -0.01312255859375, -0.010223388671875, -0.00555419921875, -0.0006103515625, -0.0001220703125, 0.00335693359375, 0.006622314453125, 0.00518798828125, 0.002960205078125, -0.0001220703125, -0.0025634765625, -0.004364013671875, -0.00811767578125, -0.010009765625, -0.009979248046875, -0.0103759765625, -0.00946044921875, -0.006103515625, -0.004058837890625, -0.003326416015625, -0.000274658203125, 0.00146484375, 0.002532958984375, 0.001953125, 6.103515625e-05, -0.00189208984375, -0.003387451171875, -0.00408935546875, -0.00335693359375, -0.00164794921875, -0.001434326171875, -0.00042724609375, 0.001251220703125, -0.000396728515625, -0.00286865234375, -0.003265380859375, -0.004608154296875, -0.00848388671875, -0.00946044921875, -0.007598876953125, -0.005645751953125, -0.001495361328125, 0.00018310546875, -0.0010986328125, -0.001800537109375, -6.103515625e-05, 0.001678466796875, 0.00164794921875, -0.000701904296875, -0.005615234375, -0.009185791015625, -0.0106201171875, -0.010894775390625, -0.010589599609375, -0.0091552734375, -0.007080078125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, -0.0001220703125, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, -0.0001220703125, 0.000152587890625, -0.00042724609375, 0.000640869140625, -0.000946044921875, 0.00103759765625, -0.0008544921875, 0.000823974609375, 0.006866455078125, 0.090087890625, 0.075042724609375, -0.128143310546875, -0.069183349609375, -0.0203857421875, -0.068603515625, 0.091094970703125, 0.160919189453125, 0.114227294921875, 0.127288818359375, 0.255889892578125, 0.16717529296875, -0.063995361328125, -0.040618896484375, -0.038299560546875, -0.148345947265625, -0.089508056640625, -0.02496337890625, -0.106903076171875, -0.106292724609375, -0.035888671875, -0.0035400390625, -0.00885009765625, 0.003265380859375, 0.033233642578125, 0.022796630859375, 0.0216064453125, 0.048065185546875, 0.029510498046875, 0.0003662109375, 0.014556884765625, 0.011260986328125, -0.02154541015625, -0.03515625, -0.032745361328125, -0.037261962890625, -0.0506591796875, -0.048980712890625, -0.03399658203125, -0.0233154296875, -0.006134033203125, 0.0108642578125, 0.019195556640625, 0.020355224609375, 0.02099609375, 0.02032470703125, 0.015899658203125, 0.00616455078125, 0.00213623046875, -0.001190185546875, -0.0107421875, -0.01153564453125, -0.010589599609375, -0.017913818359375, -0.02056884765625, -0.01531982421875, -0.012603759765625, -0.01190185546875, -0.0069580078125, -0.00152587890625, -0.00054931640625, 0.002471923828125, 0.005035400390625, 0.003326416015625, 0.000579833984375, -0.00042724609375, -0.002166748046875, -0.00457763671875, -0.0074462890625, -0.008209228515625, -0.007476806640625, -0.00775146484375, -0.006561279296875, -0.005523681640625, -0.00482177734375, -0.003265380859375, -0.001190185546875, -0.000274658203125, -0.00042724609375, -0.000762939453125, -0.00103759765625, -0.002197265625, -0.002685546875, -0.00244140625, -0.000762939453125, 0.00030517578125, -3.0517578125e-05, 6.103515625e-05, 0.000274658203125, -0.001373291015625, -0.00396728515625, -0.00482177734375, -0.006927490234375, -0.009674072265625, -0.0093994140625, -0.00628662109375, -0.00299072265625, -0.000335693359375, -0.0003662109375, -0.0015869140625, -0.00048828125, 0.001678466796875, 0.00238037109375, 0.00054931640625, -0.003448486328125, -0.007843017578125, -0.009796142578125, -0.00927734375, -0.010009765625, -0.01055908203125, -0.008026123046875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, -0.0001220703125, 3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, 0.0, -9.1552734375e-05, 9.1552734375e-05, -0.00030517578125, 0.0003662109375, -0.00067138671875, 0.0008544921875, -0.00079345703125, 0.000518798828125, 0.00848388671875, 0.08355712890625, 0.0567626953125, -0.108917236328125, -0.05255126953125, -0.027008056640625, -0.05291748046875, 0.08111572265625, 0.134857177734375, 0.10858154296875, 0.128387451171875, 0.23016357421875, 0.137420654296875, -0.045318603515625, -0.022308349609375, -0.034210205078125, -0.12286376953125, -0.077606201171875, -0.03533935546875, -0.098236083984375, -0.090606689453125, -0.036773681640625, -0.016357421875, -0.019622802734375, -0.005615234375, 0.027069091796875, 0.028961181640625, 0.029937744140625, 0.045501708984375, 0.032196044921875, 0.01513671875, 0.018585205078125, 0.0059814453125, -0.020660400390625, -0.030242919921875, -0.032867431640625, -0.042877197265625, -0.0533447265625, -0.048919677734375, -0.0328369140625, -0.017120361328125, -0.001617431640625, 0.00726318359375, 0.012115478515625, 0.0155029296875, 0.016937255859375, 0.018402099609375, 0.01690673828125, 0.006561279296875, 0.00164794921875, 9.1552734375e-05, -0.006561279296875, -0.01007080078125, -0.0113525390625, -0.016693115234375, -0.018524169921875, -0.014495849609375, -0.012481689453125, -0.011474609375, -0.00787353515625, -0.00341796875, -0.001617431640625, 0.000457763671875, 0.00189208984375, 0.002166748046875, 0.00030517578125, -0.001739501953125, -0.002349853515625, -0.00299072265625, -0.005218505859375, -0.0068359375, -0.007080078125, -0.0072021484375, -0.0062255859375, -0.0045166015625, -0.004058837890625, -0.004608154296875, -0.00341796875, -0.001861572265625, -0.001800537109375, -0.001953125, -0.001708984375, -0.002044677734375, -0.001953125, -0.00067138671875, 0.001434326171875, 0.001556396484375, -9.1552734375e-05, -0.00146484375, -0.00115966796875, -0.001953125, -0.004241943359375, -0.0068359375, -0.00933837890625, -0.0103759765625, -0.008148193359375, -0.003753662109375, -0.001556396484375, -0.0013427734375, -0.001495361328125, -0.00018310546875, 0.001708984375, 0.0023193359375, 0.0008544921875, -0.00225830078125, -0.0062255859375, -0.008636474609375, -0.008148193359375, -0.008544921875, -0.01104736328125, -0.0113525390625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, -0.000152587890625, -3.0517578125e-05, -0.0001220703125, -6.103515625e-05, 0.0, -9.1552734375e-05, -3.0517578125e-05, -0.000244140625, 0.000244140625, -0.00054931640625, 0.000640869140625, -0.000701904296875, 0.0001220703125, 0.00921630859375, 0.07489013671875, 0.0465087890625, -0.08953857421875, -0.045318603515625, -0.028717041015625, -0.041717529296875, 0.067535400390625, 0.117767333984375, 0.10601806640625, 0.123321533203125, 0.198272705078125, 0.12005615234375, -0.021453857421875, -0.01129150390625, -0.02667236328125, -0.101470947265625, -0.073028564453125, -0.0367431640625, -0.085205078125, -0.0906982421875, -0.048553466796875, -0.018707275390625, -0.0211181640625, -0.0103759765625, 0.02716064453125, 0.0364990234375, 0.0357666015625, 0.04766845703125, 0.034423828125, 0.01397705078125, 0.014556884765625, 0.00390625, -0.01922607421875, -0.032257080078125, -0.0384521484375, -0.041656494140625, -0.046051025390625, -0.038909912109375, -0.022491455078125, -0.015533447265625, -0.009033203125, 0.000518798828125, 0.007965087890625, 0.01171875, 0.014495849609375, 0.01629638671875, 0.01483154296875, 0.00616455078125, 0.0023193359375, 0.001068115234375, -0.004852294921875, -0.007598876953125, -0.01043701171875, -0.01446533203125, -0.01507568359375, -0.01397705078125, -0.013214111328125, -0.012298583984375, -0.008453369140625, -0.00469970703125, -0.0032958984375, -0.00152587890625, 0.000762939453125, 0.0020751953125, 0.000335693359375, -0.00079345703125, -0.002044677734375, -0.00299072265625, -0.005035400390625, -0.007171630859375, -0.00726318359375, -0.00616455078125, -0.004119873046875, -0.003448486328125, -0.004241943359375, -0.004852294921875, -0.00433349609375, -0.00311279296875, -0.00225830078125, -0.00213623046875, -0.00238037109375, -0.001861572265625, -0.000213623046875, 0.00115966796875, 0.00225830078125, 0.000946044921875, -0.00091552734375, -0.00146484375, -0.000823974609375, -0.0018310546875, -0.00592041015625, -0.009063720703125, -0.01007080078125, -0.009124755859375, -0.005615234375, -0.002410888671875, -0.001983642578125, -0.001556396484375, 0.0, 0.00140380859375, 0.00225830078125, 0.001251220703125, -0.001983642578125, -0.00506591796875, -0.006622314453125, -0.006988525390625, -0.00738525390625, -0.0096435546875, -0.01239013671875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -0.0001220703125, 0.0, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, 0.0, -9.1552734375e-05, 0.000213623046875, -0.000335693359375, 0.0006103515625, -0.000579833984375, 3.0517578125e-05, 0.00897216796875, 0.066375732421875, 0.04278564453125, -0.07427978515625, -0.0423583984375, -0.026824951171875, -0.0352783203125, 0.05670166015625, 0.107025146484375, 0.102752685546875, 0.11077880859375, 0.1680908203125, 0.114501953125, -0.00103759765625, -0.00213623046875, -0.01715087890625, -0.0849609375, -0.066070556640625, -0.0421142578125, -0.088226318359375, -0.086761474609375, -0.042510986328125, -0.019287109375, -0.02581787109375, -0.009185791015625, 0.03546142578125, 0.045074462890625, 0.0352783203125, 0.038482666015625, 0.028472900390625, 0.01483154296875, 0.012481689453125, -0.001495361328125, -0.02337646484375, -0.03424072265625, -0.031494140625, -0.029754638671875, -0.034820556640625, -0.030303955078125, -0.022186279296875, -0.021484375, -0.015106201171875, -0.00152587890625, 0.0047607421875, 0.006866455078125, 0.0111083984375, 0.014068603515625, 0.012420654296875, 0.005035400390625, 0.004119873046875, 0.0023193359375, -0.002716064453125, -0.004669189453125, -0.00799560546875, -0.01312255859375, -0.014892578125, -0.013885498046875, -0.01416015625, -0.01226806640625, -0.008514404296875, -0.006011962890625, -0.004638671875, -0.002044677734375, 0.000579833984375, 0.001007080078125, 0.000579833984375, -0.0008544921875, -0.003173828125, -0.00482177734375, -0.006011962890625, -0.005889892578125, -0.004913330078125, -0.003997802734375, -0.00384521484375, -0.003662109375, -0.00457763671875, -0.005157470703125, -0.00469970703125, -0.004119873046875, -0.002960205078125, -0.002227783203125, -0.001617431640625, -0.001312255859375, 0.000213623046875, 0.00140380859375, 0.00128173828125, 0.00042724609375, -0.000274658203125, -0.000457763671875, -0.0009765625, -0.00335693359375, -0.0076904296875, -0.010101318359375, -0.0096435546875, -0.00732421875, -0.003570556640625, -0.00225830078125, -0.0023193359375, -0.0010986328125, 0.0008544921875, 0.001739501953125, 0.0006103515625, -0.00146484375, -0.004119873046875, -0.00543212890625, -0.00579833984375, -0.006439208984375, -0.008575439453125, -0.0111083984375])
        IR_LEFT[len(IR_LEFT)-1].append([6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, -9.1552734375e-05, -0.0001220703125, 3.0517578125e-05, -6.103515625e-05, 0.0, 0.0, -3.0517578125e-05, 3.0517578125e-05, -0.00018310546875, 0.000213623046875, -0.000335693359375, 0.00048828125, -0.000640869140625, -3.0517578125e-05, 0.007965087890625, 0.05889892578125, 0.042083740234375, -0.063812255859375, -0.04150390625, -0.022979736328125, -0.03131103515625, 0.049652099609375, 0.09942626953125, 0.0950927734375, 0.09429931640625, 0.144317626953125, 0.1138916015625, 0.0162353515625, 0.0086669921875, -0.00628662109375, -0.078399658203125, -0.07562255859375, -0.045074462890625, -0.07379150390625, -0.07550048828125, -0.041534423828125, -0.023406982421875, -0.023834228515625, 0.00390625, 0.042266845703125, 0.035858154296875, 0.0230712890625, 0.031341552734375, 0.02789306640625, 0.01409912109375, 0.0045166015625, -0.009735107421875, -0.019256591796875, -0.019073486328125, -0.0191650390625, -0.024139404296875, -0.0318603515625, -0.031005859375, -0.02447509765625, -0.023223876953125, -0.01788330078125, -0.0062255859375, 0.00067138671875, 0.004364013671875, 0.00750732421875, 0.011474609375, 0.011077880859375, 0.0054931640625, 0.005279541015625, 0.004608154296875, 0.000274658203125, -0.004058837890625, -0.00732421875, -0.01251220703125, -0.015289306640625, -0.0133056640625, -0.012847900390625, -0.0125732421875, -0.0103759765625, -0.006591796875, -0.0050048828125, -0.003570556640625, 6.103515625e-05, 0.000732421875, -0.00152587890625, -0.00274658203125, -0.003326416015625, -0.003875732421875, -0.0047607421875, -0.003692626953125, -0.00299072265625, -0.003875732421875, -0.004150390625, -0.004669189453125, -0.0054931640625, -0.0057373046875, -0.004425048828125, -0.003570556640625, -0.0032958984375, -0.002410888671875, -0.001434326171875, -0.000701904296875, -0.000396728515625, 0.000457763671875, 0.00128173828125, 0.001190185546875, 0.000885009765625, -0.0001220703125, -0.0018310546875, -0.005767822265625, -0.009246826171875, -0.009307861328125, -0.00732421875, -0.005157470703125, -0.00396728515625, -0.003143310546875, -0.002471923828125, -0.00030517578125, 0.0008544921875, -0.000152587890625, -0.001129150390625, -0.00274658203125, -0.004119873046875, -0.005279541015625, -0.006134033203125, -0.007293701171875, -0.00927734375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -9.1552734375e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, 0.0001220703125, -0.000213623046875, 0.00018310546875, -0.00018310546875, 0.000518798828125, -0.00079345703125, 0.00018310546875, 0.006683349609375, 0.052825927734375, 0.042572021484375, -0.057586669921875, -0.04010009765625, -0.018402099609375, -0.027374267578125, 0.046630859375, 0.0906982421875, 0.083160400390625, 0.07904052734375, 0.128326416015625, 0.115509033203125, 0.03570556640625, 0.01824951171875, -0.016815185546875, -0.08172607421875, -0.065765380859375, -0.033966064453125, -0.060791015625, -0.06817626953125, -0.043121337890625, -0.020599365234375, -0.010833740234375, 0.00860595703125, 0.02850341796875, 0.02252197265625, 0.01727294921875, 0.02801513671875, 0.0242919921875, 0.0072021484375, 0.00225830078125, -0.000823974609375, -0.004058837890625, -0.008148193359375, -0.01873779296875, -0.029083251953125, -0.03228759765625, -0.02862548828125, -0.02606201171875, -0.02532958984375, -0.01934814453125, -0.009735107421875, -0.00213623046875, 0.002899169921875, 0.0062255859375, 0.00885009765625, 0.01007080078125, 0.00738525390625, 0.007415771484375, 0.006805419921875, 0.00067138671875, -0.004425048828125, -0.006866455078125, -0.010894775390625, -0.014007568359375, -0.014068603515625, -0.014007568359375, -0.013092041015625, -0.01092529296875, -0.007415771484375, -0.00537109375, -0.003387451171875, -0.001617431640625, -0.0013427734375, -0.001708984375, -0.00201416015625, -0.00140380859375, -0.002044677734375, -0.003082275390625, -0.00299072265625, -0.00274658203125, -0.003997802734375, -0.005828857421875, -0.005584716796875, -0.005218505859375, -0.004974365234375, -0.00445556640625, -0.003631591796875, -0.00286865234375, -0.002410888671875, -0.001220703125, -0.00067138671875, -0.0003662109375, 0.000701904296875, 0.002197265625, 0.00244140625, 0.00091552734375, -0.001251220703125, -0.004180908203125, -0.007232666015625, -0.00799560546875, -0.0069580078125, -0.0059814453125, -0.005645751953125, -0.004791259765625, -0.002960205078125, -0.001190185546875, -0.00030517578125, -0.000579833984375, -0.000885009765625, -0.00152587890625, -0.003021240234375, -0.004791259765625, -0.005950927734375, -0.006439208984375, -0.0076904296875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, 0.0, -3.0517578125e-05, 0.0, -6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 0.0, 0.0001220703125, -0.00018310546875, 0.000244140625, -6.103515625e-05, 0.000274658203125, -0.0006103515625, 0.00048828125, 0.00537109375, 0.048309326171875, 0.041534423828125, -0.053375244140625, -0.0380859375, -0.012664794921875, -0.02203369140625, 0.04376220703125, 0.079315185546875, 0.06982421875, 0.07000732421875, 0.11956787109375, 0.12042236328125, 0.040679931640625, 0.006744384765625, -0.017730712890625, -0.0662841796875, -0.052398681640625, -0.023406982421875, -0.051239013671875, -0.062347412109375, -0.035400390625, -0.015350341796875, -0.013336181640625, -0.001495361328125, 0.017547607421875, 0.0169677734375, 0.009796142578125, 0.020263671875, 0.02288818359375, 0.01422119140625, 0.013153076171875, 0.009124755859375, -0.0003662109375, -0.013092041015625, -0.0235595703125, -0.02874755859375, -0.030120849609375, -0.029541015625, -0.02587890625, -0.02557373046875, -0.021575927734375, -0.0101318359375, -0.00311279296875, 0.000244140625, 0.003997802734375, 0.008941650390625, 0.0115966796875, 0.009124755859375, 0.00885009765625, 0.006500244140625, 0.00030517578125, -0.003814697265625, -0.006195068359375, -0.01068115234375, -0.01544189453125, -0.015716552734375, -0.0145263671875, -0.012908935546875, -0.01043701171875, -0.007537841796875, -0.006072998046875, -0.004974365234375, -0.002105712890625, -3.0517578125e-05, -0.000701904296875, -0.0010986328125, -0.000732421875, -0.000457763671875, -0.001800537109375, -0.003570556640625, -0.00433349609375, -0.004913330078125, -0.004913330078125, -0.005340576171875, -0.0062255859375, -0.00634765625, -0.0045166015625, -0.002593994140625, -0.0020751953125, -0.0020751953125, -0.001373291015625, -0.000244140625, 0.001068115234375, 0.001953125, 0.002288818359375, 0.001007080078125, -0.00091552734375, -0.002410888671875, -0.00482177734375, -0.006683349609375, -0.007080078125, -0.0062255859375, -0.005523681640625, -0.005645751953125, -0.00396728515625, -0.001983642578125, -0.001434326171875, -0.001251220703125, -0.00079345703125, -0.00067138671875, -0.0025634765625, -0.004669189453125, -0.0057373046875, -0.005828857421875, -0.006561279296875])
        IR_LEFT[len(IR_LEFT)-1].append([6.103515625e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 0.0001220703125, -0.0001220703125, 0.000274658203125, -0.00018310546875, 0.0003662109375, -0.00042724609375, 0.00048828125, 0.005035400390625, 0.043975830078125, 0.03814697265625, -0.04949951171875, -0.034576416015625, -0.00677490234375, -0.015899658203125, 0.039947509765625, 0.066558837890625, 0.061187744140625, 0.071746826171875, 0.10797119140625, 0.098876953125, 0.042724609375, 0.017181396484375, -0.01177978515625, -0.051849365234375, -0.040130615234375, -0.013275146484375, -0.03692626953125, -0.053314208984375, -0.04205322265625, -0.02679443359375, -0.01458740234375, -0.00323486328125, 0.006500244140625, 0.003265380859375, 0.00482177734375, 0.02777099609375, 0.036102294921875, 0.023284912109375, 0.013427734375, 0.00238037109375, -0.00567626953125, -0.012359619140625, -0.024017333984375, -0.0294189453125, -0.029388427734375, -0.029449462890625, -0.026214599609375, -0.024505615234375, -0.020263671875, -0.012725830078125, -0.005706787109375, 0.00067138671875, 0.0064697265625, 0.010223388671875, 0.011199951171875, 0.009613037109375, 0.008453369140625, 0.006317138671875, -0.000457763671875, -0.005401611328125, -0.007415771484375, -0.012542724609375, -0.016082763671875, -0.01605224609375, -0.01397705078125, -0.011871337890625, -0.010650634765625, -0.007904052734375, -0.005828857421875, -0.0037841796875, -0.001220703125, 3.0517578125e-05, -0.000579833984375, 3.0517578125e-05, 0.0003662109375, -0.00067138671875, -0.002410888671875, -0.003448486328125, -0.003997802734375, -0.005218505859375, -0.00640869140625, -0.007354736328125, -0.007049560546875, -0.005889892578125, -0.003631591796875, -0.00164794921875, -0.001434326171875, -0.00146484375, -0.0003662109375, 0.000946044921875, 0.00128173828125, 0.00103759765625, 0.00048828125, -0.000640869140625, -0.0013427734375, -0.003143310546875, -0.005615234375, -0.006500244140625, -0.00567626953125, -0.00482177734375, -0.00494384765625, -0.00457763671875, -0.003387451171875, -0.00250244140625, -0.001922607421875, -0.001190185546875, -0.001220703125, -0.002777099609375, -0.0045166015625, -0.00537109375, -0.005706787109375, -0.006072998046875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, 9.1552734375e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 0.000152587890625, 6.103515625e-05, -9.1552734375e-05, 0.000213623046875, 9.1552734375e-05, 0.000213623046875, -0.000335693359375, 0.000762939453125, 0.00567626953125, 0.03961181640625, 0.032196044921875, -0.044342041015625, -0.03057861328125, -0.000885009765625, -0.0078125, 0.0341796875, 0.06146240234375, 0.059967041015625, 0.050384521484375, 0.081207275390625, 0.1011962890625, 0.058990478515625, 0.0245361328125, -0.008087158203125, -0.0384521484375, -0.01751708984375, 0.002288818359375, -0.04010009765625, -0.06805419921875, -0.049468994140625, -0.022064208984375, -0.014404296875, -0.01812744140625, -0.00848388671875, 0.006072998046875, 0.022430419921875, 0.04010009765625, 0.03619384765625, 0.015655517578125, 0.003814697265625, 0.000732421875, -0.00341796875, -0.01361083984375, -0.025482177734375, -0.029571533203125, -0.02960205078125, -0.0283203125, -0.02398681640625, -0.02374267578125, -0.021087646484375, -0.0125732421875, -0.0030517578125, 0.003814697265625, 0.006866455078125, 0.0091552734375, 0.01055908203125, 0.009368896484375, 0.007720947265625, 0.003662109375, -0.003204345703125, -0.00750732421875, -0.008697509765625, -0.013092041015625, -0.016021728515625, -0.014617919921875, -0.0126953125, -0.010833740234375, -0.009765625, -0.007049560546875, -0.004913330078125, -0.00299072265625, -0.000946044921875, -6.103515625e-05, 0.000152587890625, 0.00030517578125, 0.00054931640625, -0.00030517578125, -0.0018310546875, -0.0040283203125, -0.005828857421875, -0.00714111328125, -0.0078125, -0.0067138671875, -0.006011962890625, -0.004608154296875, -0.00244140625, -0.001129150390625, -0.000762939453125, -0.00042724609375, 0.000274658203125, 0.00018310546875, 0.000152587890625, 6.103515625e-05, -0.000244140625, -0.00079345703125, -0.002197265625, -0.0042724609375, -0.0054931640625, -0.00439453125, -0.00360107421875, -0.004119873046875, -0.004302978515625, -0.004180908203125, -0.003753662109375, -0.002838134765625, -0.002044677734375, -0.00238037109375, -0.0032958984375, -0.004058837890625, -0.0050048828125, -0.00579833984375, -0.00640869140625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, 0.0, 6.103515625e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 0.0001220703125, 6.103515625e-05, 3.0517578125e-05, 0.0001220703125, 0.0, 3.0517578125e-05, 0.000213623046875, 0.000152587890625, -0.0001220703125, 9.1552734375e-05, 0.0008544921875, 0.00762939453125, 0.034271240234375, 0.023529052734375, -0.0369873046875, -0.026275634765625, 0.00634765625, 0.003753662109375, 0.0364990234375, 0.043243408203125, 0.02783203125, 0.045989990234375, 0.087127685546875, 0.105194091796875, 0.06585693359375, 0.02740478515625, 0.005218505859375, -0.01080322265625, -0.00665283203125, -0.016387939453125, -0.054779052734375, -0.067352294921875, -0.044891357421875, -0.027801513671875, -0.028839111328125, -0.022979736328125, 0.003753662109375, 0.02392578125, 0.028533935546875, 0.03399658203125, 0.0252685546875, 0.00823974609375, 0.003143310546875, 0.0010986328125, -0.004852294921875, -0.016510009765625, -0.02764892578125, -0.030029296875, -0.027435302734375, -0.025238037109375, -0.0235595703125, -0.022308349609375, -0.018218994140625, -0.008575439453125, -0.0003662109375, 0.003265380859375, 0.006134033203125, 0.008331298828125, 0.00970458984375, 0.007110595703125, 0.00421142578125, 0.000244140625, -0.005859375, -0.008819580078125, -0.010498046875, -0.0123291015625, -0.01312255859375, -0.012542724609375, -0.0113525390625, -0.010589599609375, -0.008941650390625, -0.0062255859375, -0.0037841796875, -0.00250244140625, -0.000885009765625, 0.00048828125, 0.0003662109375, 0.00054931640625, -3.0517578125e-05, -0.00128173828125, -0.003204345703125, -0.005889892578125, -0.00762939453125, -0.00775146484375, -0.006011962890625, -0.005126953125, -0.005279541015625, -0.004608154296875, -0.002532958984375, -0.00079345703125, -0.00042724609375, -0.000579833984375, -0.000579833984375, -0.000396728515625, -0.00018310546875, -0.00018310546875, -0.000335693359375, -0.001373291015625, -0.003173828125, -0.00439453125, -0.0037841796875, -0.00244140625, -0.003021240234375, -0.00469970703125, -0.005035400390625, -0.00433349609375, -0.00341796875, -0.003631591796875, -0.0037841796875, -0.003662109375, -0.004180908203125, -0.0050048828125, -0.006134033203125, -0.006744384765625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0, 9.1552734375e-05, 0.000152587890625, 0.0001220703125, -6.103515625e-05, 0.000152587890625, 0.000152587890625, 0.0, 0.0003662109375, 0.0015869140625, 0.01055908203125, 0.026092529296875, 0.01458740234375, -0.02655029296875, -0.017608642578125, 0.024261474609375, 0.00872802734375, -0.0015869140625, 0.02423095703125, 0.0391845703125, 0.056549072265625, 0.088409423828125, 0.101806640625, 0.0723876953125, 0.0455322265625, 0.02197265625, -0.014617919921875, -0.024658203125, -0.02691650390625, -0.0550537109375, -0.069061279296875, -0.053131103515625, -0.034515380859375, -0.02142333984375, -0.0040283203125, 0.016357421875, 0.02374267578125, 0.0218505859375, 0.0242919921875, 0.0191650390625, 0.00634765625, 0.001678466796875, -0.0001220703125, -0.009490966796875, -0.021392822265625, -0.0267333984375, -0.026123046875, -0.02459716796875, -0.023834228515625, -0.021087646484375, -0.01849365234375, -0.013458251953125, -0.005889892578125, -0.000762939453125, 0.0029296875, 0.00543212890625, 0.007110595703125, 0.007080078125, 0.003692626953125, -9.1552734375e-05, -0.0035400390625, -0.007568359375, -0.00909423828125, -0.008453369140625, -0.009857177734375, -0.011505126953125, -0.011199951171875, -0.010498046875, -0.009124755859375, -0.007720947265625, -0.005035400390625, -0.002532958984375, -0.0010986328125, -0.00042724609375, -0.000946044921875, -0.00042724609375, 3.0517578125e-05, -0.0010986328125, -0.0032958984375, -0.00506591796875, -0.005767822265625, -0.006378173828125, -0.00592041015625, -0.005279541015625, -0.005157470703125, -0.005401611328125, -0.00469970703125, -0.00250244140625, -0.000640869140625, 0.0, -0.000396728515625, -0.000518798828125, -0.000152587890625, 0.00030517578125, 0.000152587890625, -0.00067138671875, -0.002227783203125, -0.00335693359375, -0.00311279296875, -0.002197265625, -0.002716064453125, -0.005126953125, -0.00567626953125, -0.004486083984375, -0.0035400390625, -0.004119873046875, -0.004730224609375, -0.00439453125, -0.004547119140625, -0.004852294921875, -0.005767822265625, -0.00616455078125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 0.0, 6.103515625e-05, 0.0, 6.103515625e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 0.0, 0.0, 0.0, -6.103515625e-05, 0.000213623046875, 0.0001220703125, -9.1552734375e-05, -6.103515625e-05, 0.0001220703125, 0.00030517578125, 3.0517578125e-05, 0.00042724609375, 0.003326416015625, 0.01153564453125, 0.01690673828125, 0.009429931640625, -0.002044677734375, -0.000152587890625, -0.003692626953125, -0.016510009765625, 0.004852294921875, 0.038482666015625, 0.04962158203125, 0.05914306640625, 0.087615966796875, 0.11212158203125, 0.088043212890625, 0.0391845703125, 0.00323486328125, -0.02105712890625, -0.03082275390625, -0.03839111328125, -0.0645751953125, -0.076019287109375, -0.047027587890625, -0.014617919921875, -0.0030517578125, 0.0047607421875, 0.01385498046875, 0.014617919921875, 0.015838623046875, 0.02099609375, 0.014862060546875, 0.002288818359375, -0.00213623046875, -0.005096435546875, -0.01348876953125, -0.02081298828125, -0.022979736328125, -0.024383544921875, -0.022735595703125, -0.020263671875, -0.01690673828125, -0.01416015625, -0.01055908203125, -0.004638671875, -0.001007080078125, 0.002349853515625, 0.004486083984375, 0.0045166015625, 0.002105712890625, -0.00091552734375, -0.003143310546875, -0.005218505859375, -0.006683349609375, -0.0074462890625, -0.008026123046875, -0.00860595703125, -0.009552001953125, -0.00933837890625, -0.00872802734375, -0.007476806640625, -0.005584716796875, -0.003875732421875, -0.002105712890625, -0.0018310546875, -0.001953125, -0.001678466796875, -0.00146484375, -0.001312255859375, -0.002685546875, -0.003753662109375, -0.004302978515625, -0.005279541015625, -0.0057373046875, -0.00604248046875, -0.00604248046875, -0.005859375, -0.0050048828125, -0.00372314453125, -0.00177001953125, 0.0, 0.000457763671875, 0.000396728515625, 0.0003662109375, 0.000518798828125, 0.000213623046875, -0.000579833984375, -0.001495361328125, -0.002349853515625, -0.00250244140625, -0.00274658203125, -0.00408935546875, -0.006011962890625, -0.00592041015625, -0.0040283203125, -0.003326416015625, -0.004058837890625, -0.005035400390625, -0.005218505859375, -0.004791259765625, -0.004547119140625, -0.0047607421875, -0.005340576171875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 9.1552734375e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 0.0001220703125, 0.00018310546875, -6.103515625e-05, 9.1552734375e-05, -6.103515625e-05, 0.000335693359375, 9.1552734375e-05, 0.000396728515625, 0.000335693359375, 0.005462646484375, 0.011810302734375, 0.015380859375, 0.028900146484375, -0.004730224609375, -0.042877197265625, -0.008209228515625, 0.013702392578125, 0.019195556640625, 0.043975830078125, 0.055908203125, 0.070556640625, 0.10650634765625, 0.10992431640625, 0.055908203125, 0.01458740234375, 0.00347900390625, -0.02349853515625, -0.051361083984375, -0.060028076171875, -0.066253662109375, -0.053192138671875, -0.018768310546875, 0.002227783203125, 0.00177001953125, 0.000396728515625, 0.00433349609375, 0.012420654296875, 0.017791748046875, 0.01373291015625, 0.00640869140625, -0.003509521484375, -0.0057373046875, -0.006256103515625, -0.01416015625, -0.0208740234375, -0.02264404296875, -0.0208740234375, -0.018402099609375, -0.015655517578125, -0.013397216796875, -0.011505126953125, -0.0081787109375, -0.00408935546875, -0.000396728515625, 0.00128173828125, 0.000823974609375, -0.000244140625, -0.001251220703125, -0.00274658203125, -0.00555419921875, -0.005828857421875, -0.00604248046875, -0.007171630859375, -0.0064697265625, -0.006561279296875, -0.006866455078125, -0.006805419921875, -0.00653076171875, -0.0064697265625, -0.005828857421875, -0.003692626953125, -0.00299072265625, -0.0028076171875, -0.0028076171875, -0.002166748046875, -0.001739501953125, -0.002838134765625, -0.003173828125, -0.00396728515625, -0.00469970703125, -0.005889892578125, -0.007110595703125, -0.006591796875, -0.005645751953125, -0.0042724609375, -0.00323486328125, -0.002166748046875, -0.000823974609375, 0.0003662109375, 0.00177001953125, 0.00140380859375, 0.000274658203125, -0.000946044921875, -0.0009765625, -0.00103759765625, -0.0018310546875, -0.00244140625, -0.004150390625, -0.005889892578125, -0.007080078125, -0.005859375, -0.00347900390625, -0.002899169921875, -0.0037841796875, -0.005157470703125, -0.0054931640625, -0.0045166015625, -0.003753662109375, -0.00390625, -0.004730224609375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 6.103515625e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, 0.0, 9.1552734375e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.000244140625, -3.0517578125e-05, 9.1552734375e-05, 6.103515625e-05, 0.000244140625, -3.0517578125e-05, 9.1552734375e-05, 0.0003662109375, -0.000274658203125, 0.0015869140625, 0.012054443359375, 0.030609130859375, 0.014190673828125, -0.017974853515625, -0.02325439453125, -0.016448974609375, 0.013397216796875, 0.03173828125, 0.02838134765625, 0.05242919921875, 0.085662841796875, 0.0870361328125, 0.075958251953125, 0.066009521484375, 0.037017822265625, 0.010467529296875, -0.0062255859375, -0.043487548828125, -0.07879638671875, -0.060089111328125, -0.0281982421875, -0.01824951171875, -0.005035400390625, 0.002532958984375, -0.0030517578125, -0.005218505859375, 0.00653076171875, 0.014678955078125, 0.0096435546875, 0.003021240234375, -0.0006103515625, -0.004547119140625, -0.007781982421875, -0.009796142578125, -0.016815185546875, -0.0211181640625, -0.018768310546875, -0.015655517578125, -0.012939453125, -0.012786865234375, -0.0106201171875, -0.008148193359375, -0.006591796875, -0.00299072265625, -0.001007080078125, -0.00164794921875, -0.002716064453125, -0.002899169921875, -0.003631591796875, -0.005584716796875, -0.006744384765625, -0.006317138671875, -0.0052490234375, -0.00457763671875, -0.0037841796875, -0.003662109375, -0.005401611328125, -0.005950927734375, -0.005859375, -0.006103515625, -0.005706787109375, -0.0045166015625, -0.002593994140625, -0.002349853515625, -0.00274658203125, -0.003173828125, -0.00384521484375, -0.003448486328125, -0.004150390625, -0.00555419921875, -0.00634765625, -0.006622314453125, -0.0057373046875, -0.004608154296875, -0.003143310546875, -0.001983642578125, -0.0010986328125, -0.000457763671875, 0.00030517578125, 0.00152587890625, 0.00140380859375, 0.000274658203125, -0.001251220703125, -0.001953125, -0.001678466796875, -0.00177001953125, -0.002777099609375, -0.0048828125, -0.00689697265625, -0.0076904296875, -0.00592041015625, -0.0032958984375, -0.002227783203125, -0.0029296875, -0.00445556640625, -0.004974365234375, -0.00390625, -0.00250244140625, -0.00262451171875, -0.00421142578125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, -9.1552734375e-05, 3.0517578125e-05, 9.1552734375e-05, -6.103515625e-05, 0.000152587890625, -3.0517578125e-05, 0.00054931640625, -0.000152587890625, 0.0001220703125, -0.0003662109375, 0.000213623046875, 0.001739501953125, 0.022003173828125, 0.034515380859375, -0.01483154296875, -0.03472900390625, 0.0001220703125, 0.008819580078125, 0.003753662109375, 0.02392578125, 0.047607421875, 0.05877685546875, 0.08349609375, 0.07440185546875, 0.038421630859375, 0.041748046875, 0.05096435546875, 0.02294921875, -0.00885009765625, -0.029205322265625, -0.06646728515625, -0.0697021484375, -0.0201416015625, 0.007568359375, -0.00390625, -0.007781982421875, -0.001007080078125, -0.002532958984375, -0.001220703125, 0.00531005859375, 0.0069580078125, 0.000701904296875, -0.003204345703125, -0.003997802734375, -0.009796142578125, -0.013580322265625, -0.01318359375, -0.016387939453125, -0.0184326171875, -0.013824462890625, -0.009735107421875, -0.009429931640625, -0.010009765625, -0.00750732421875, -0.00592041015625, -0.00433349609375, -0.002349853515625, -0.003448486328125, -0.0048828125, -0.0057373046875, -0.005584716796875, -0.0069580078125, -0.007598876953125, -0.006866455078125, -0.004547119140625, -0.002166748046875, -0.00299072265625, -0.003326416015625, -0.003662109375, -0.004180908203125, -0.00506591796875, -0.006011962890625, -0.005706787109375, -0.004241943359375, -0.002593994140625, -0.0030517578125, -0.00390625, -0.004302978515625, -0.005157470703125, -0.005859375, -0.0059814453125, -0.005859375, -0.005950927734375, -0.005584716796875, -0.004425048828125, -0.00323486328125, -0.001708984375, -0.00048828125, 0.000152587890625, 0.000518798828125, 0.000457763671875, 9.1552734375e-05, -9.1552734375e-05, -0.0006103515625, -0.00152587890625, -0.002349853515625, -0.0029296875, -0.00323486328125, -0.003265380859375, -0.00469970703125, -0.007110595703125, -0.007965087890625, -0.006134033203125, -0.00341796875, -0.00177001953125, -0.002197265625, -0.00347900390625, -0.003936767578125, -0.003021240234375, -0.002105712890625, -0.0020751953125, -0.00360107421875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, -3.0517578125e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, 6.103515625e-05, -0.000152587890625, 9.1552734375e-05, -6.103515625e-05, 0.0001220703125, -0.000152587890625, 0.000152587890625, 0.000244140625, 0.00018310546875, -0.0001220703125, -0.000579833984375, -3.0517578125e-05, 0.013092041015625, 0.03497314453125, 0.00274658203125, -0.036163330078125, -0.01849365234375, 0.006561279296875, 0.0198974609375, 0.02099609375, 0.021820068359375, 0.052276611328125, 0.09222412109375, 0.07012939453125, 0.031982421875, 0.029541015625, 0.02410888671875, 0.02557373046875, 0.023590087890625, 0.0003662109375, -0.030487060546875, -0.049957275390625, -0.04864501953125, -0.0277099609375, 0.00885009765625, 0.020538330078125, -0.000823974609375, -0.008636474609375, 0.002410888671875, 0.0006103515625, -0.00518798828125, -0.000946044921875, 0.0006103515625, -0.00421142578125, -0.011474609375, -0.014312744140625, -0.015167236328125, -0.014556884765625, -0.01397705078125, -0.015655517578125, -0.013031005859375, -0.007568359375, -0.005645751953125, -0.00701904296875, -0.0054931640625, -0.003326416015625, -0.003814697265625, -0.004302978515625, -0.004547119140625, -0.005096435546875, -0.0078125, -0.009368896484375, -0.009185791015625, -0.007904052734375, -0.00592041015625, -0.00537109375, -0.004486083984375, -0.0032958984375, -0.002471923828125, -0.002288818359375, -0.002899169921875, -0.003997802734375, -0.00390625, -0.002899169921875, -0.003448486328125, -0.004302978515625, -0.004302978515625, -0.00439453125, -0.005950927734375, -0.0078125, -0.00836181640625, -0.007293701171875, -0.005645751953125, -0.0048828125, -0.0042724609375, -0.003204345703125, -0.001678466796875, -0.000213623046875, 0.000732421875, 0.00079345703125, 0.000518798828125, 0.000518798828125, -0.000640869140625, -0.001922607421875, -0.002410888671875, -0.00274658203125, -0.003173828125, -0.003509521484375, -0.00396728515625, -0.00457763671875, -0.00531005859375, -0.006744384765625, -0.006988525390625, -0.005767822265625, -0.004119873046875, -0.002166748046875, -0.00146484375, -0.001983642578125, -0.002532958984375, -0.002471923828125, -0.002349853515625, -0.002685546875, -0.00360107421875])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 0.0001220703125, 9.1552734375e-05, 0.000152587890625, 9.1552734375e-05, 0.0001220703125, 0.0001220703125, 9.1552734375e-05, 0.0001220703125, 0.0001220703125, 0.0001220703125, 0.000152587890625, 0.000213623046875, 0.0001220703125, 0.00018310546875, 0.0001220703125, 0.000152587890625, 0.0001220703125, 0.000152587890625, 0.000274658203125, 0.0, 0.000274658203125, 0.0003662109375, 0.000457763671875, 3.0517578125e-05, -0.00030517578125, 0.005889892578125, 0.03619384765625, 0.018890380859375, -0.042022705078125, -0.028961181640625, 0.0076904296875, 0.015289306640625, 0.018218994140625, 0.028656005859375, 0.0496826171875, 0.077880859375, 0.083282470703125, 0.04803466796875, 0.01153564453125, 0.00830078125, 0.019561767578125, 0.00433349609375, -0.00408935546875, -0.000732421875, -0.016448974609375, -0.039154052734375, -0.0345458984375, -0.01116943359375, 0.0008544921875, 0.0208740234375, 0.02630615234375, 0.005828857421875, -0.00408935546875, 0.000823974609375, -0.004150390625, -0.0096435546875, -0.003814697265625, -0.00701904296875, -0.016693115234375, -0.022613525390625, -0.017822265625, -0.014312744140625, -0.016143798828125, -0.01422119140625, -0.010406494140625, -0.00604248046875, -0.002593994140625, -9.1552734375e-05, -0.001251220703125, -0.002349853515625, -0.002655029296875, -0.002716064453125, -0.00390625, -0.0064697265625, -0.00860595703125, -0.0111083984375, -0.010284423828125, -0.008209228515625, -0.00799560546875, -0.00799560546875, -0.00665283203125, -0.00384521484375, -0.002288818359375, -0.0018310546875, -0.00140380859375, 3.0517578125e-05, -9.1552734375e-05, -0.001739501953125, -0.002899169921875, -0.00396728515625, -0.004608154296875, -0.006256103515625, -0.008087158203125, -0.009246826171875, -0.008880615234375, -0.007354736328125, -0.00543212890625, -0.00335693359375, -0.002105712890625, -0.00103759765625, -0.000274658203125, 0.00048828125, 0.001190185546875, 0.00115966796875, 0.0010986328125, 0.000579833984375, -0.001068115234375, -0.002960205078125, -0.003997802734375, -0.003662109375, -0.00323486328125, -0.00384521484375, -0.004241943359375, -0.004913330078125, -0.00567626953125, -0.005706787109375, -0.005279541015625, -0.00494384765625, -0.004241943359375, -0.002166748046875, -0.00048828125, -0.000396728515625, -0.001007080078125, -0.00189208984375, -0.002716064453125, -0.003387451171875, -0.003875732421875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, -3.0517578125e-05, -0.0001220703125, -3.0517578125e-05, -9.1552734375e-05, -6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, -0.0001220703125, 0.0, -0.000213623046875, 3.0517578125e-05, -6.103515625e-05, -0.0001220703125, -0.0001220703125, 0.000274658203125, -0.000335693359375, 0.00042724609375, 0.0013427734375, 0.02996826171875, 0.038330078125, -0.03369140625, -0.0538330078125, -0.002471923828125, 0.024444580078125, 0.022247314453125, 0.021453857421875, 0.0394287109375, 0.08306884765625, 0.104095458984375, 0.052459716796875, 0.006103515625, 0.0052490234375, 0.006317138671875, -0.005523681640625, -0.011474609375, -0.0184326171875, -0.0233154296875, -0.012725830078125, -0.014373779296875, -0.0235595703125, -0.0096435546875, 0.011688232421875, 0.01898193359375, 0.031707763671875, 0.0330810546875, 0.007293701171875, -0.007781982421875, -0.006683349609375, -0.0074462890625, -0.01220703125, -0.017059326171875, -0.022705078125, -0.024993896484375, -0.0238037109375, -0.019866943359375, -0.0164794921875, -0.01641845703125, -0.0106201171875, -0.002105712890625, 0.00299072265625, 0.00311279296875, 0.00067138671875, 9.1552734375e-05, 0.00054931640625, -0.00030517578125, -0.00396728515625, -0.0079345703125, -0.009124755859375, -0.009918212890625, -0.012054443359375, -0.013275146484375, -0.0120849609375, -0.010101318359375, -0.00799560546875, -0.0068359375, -0.004425048828125, -0.000579833984375, 0.00128173828125, 0.001739501953125, 0.0013427734375, -0.0001220703125, -0.00250244140625, -0.004547119140625, -0.006195068359375, -0.0081787109375, -0.009307861328125, -0.009918212890625, -0.00933837890625, -0.00714111328125, -0.005126953125, -0.0028076171875, -0.001068115234375, -3.0517578125e-05, -0.00048828125, -0.00067138671875, 0.000518798828125, 0.000701904296875, 0.00091552734375, -0.000335693359375, -0.0029296875, -0.0045166015625, -0.00469970703125, -0.00408935546875, -0.004119873046875, -0.00494384765625, -0.0052490234375, -0.0047607421875, -0.005035400390625, -0.00579833984375, -0.00543212890625, -0.005157470703125, -0.004058837890625, -0.002044677734375, -0.000732421875, -0.00042724609375, -0.00079345703125, -0.002105712890625, -0.004119873046875, -0.005157470703125, -0.00469970703125])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 0.0001220703125, 9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, 9.1552734375e-05, 0.000152587890625, 0.0001220703125, 0.000152587890625, 3.0517578125e-05, 0.0001220703125, 0.0001220703125, 0.000274658203125, -9.1552734375e-05, 0.00054931640625, -0.000213623046875, 0.00048828125, -6.103515625e-05, 0.020751953125, 0.053985595703125, -0.012786865234375, -0.071563720703125, -0.022857666015625, 0.02154541015625, 0.031341552734375, 0.027099609375, 0.03509521484375, 0.075439453125, 0.11358642578125, 0.0792236328125, 0.015899658203125, -0.009246826171875, -0.005859375, -0.002044677734375, -0.019073486328125, -0.03314208984375, -0.03125, -0.02734375, -0.02142333984375, -0.003082275390625, 0.000701904296875, -0.00775146484375, 0.009918212890625, 0.03228759765625, 0.0396728515625, 0.03717041015625, 0.025390625, 0.001953125, -0.011077880859375, -0.009613037109375, -0.01702880859375, -0.027008056640625, -0.02947998046875, -0.02606201171875, -0.025726318359375, -0.027313232421875, -0.0218505859375, -0.013641357421875, -0.00726318359375, -0.0006103515625, 0.005401611328125, 0.0057373046875, 0.004669189453125, 0.005767822265625, 0.004669189453125, 0.0008544921875, -0.003143310546875, -0.004241943359375, -0.008331298828125, -0.012908935546875, -0.01458740234375, -0.01470947265625, -0.013519287109375, -0.013336181640625, -0.011077880859375, -0.007537841796875, -0.0032958984375, -0.000274658203125, 0.001983642578125, 0.003631591796875, 0.00323486328125, 0.001800537109375, -0.002227783203125, -0.00531005859375, -0.00616455078125, -0.00726318359375, -0.008544921875, -0.009033203125, -0.007598876953125, -0.005859375, -0.00384521484375, -0.0023193359375, -0.001251220703125, -0.000274658203125, -0.00018310546875, -0.000244140625, 0.000244140625, 0.000946044921875, 0.00018310546875, -0.001983642578125, -0.0037841796875, -0.003997802734375, -0.003936767578125, -0.004241943359375, -0.00408935546875, -0.003387451171875, -0.00341796875, -0.00445556640625, -0.005157470703125, -0.00537109375, -0.004669189453125, -0.004180908203125, -0.00372314453125, -0.001953125, -0.000579833984375, 0.000274658203125, -0.00030517578125, -0.002471923828125, -0.0047607421875, -0.005523681640625, -0.004241943359375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 0.0001220703125, -3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, 0.0001220703125, 3.0517578125e-05, 0.0, 0.0003662109375, -0.00018310546875, 0.00018310546875, 0.009765625, 0.05914306640625, 0.020111083984375, -0.08099365234375, -0.05096435546875, 0.015960693359375, 0.034820556640625, 0.03094482421875, 0.03564453125, 0.0723876953125, 0.12469482421875, 0.1029052734375, 0.019256591796875, -0.012542724609375, -0.007720947265625, -0.008270263671875, -0.025482177734375, -0.0377197265625, -0.04180908203125, -0.043731689453125, -0.028900146484375, -0.014007568359375, -0.0042724609375, 0.00701904296875, 0.010284423828125, 0.011810302734375, 0.035247802734375, 0.04888916015625, 0.0374755859375, 0.0263671875, 0.017303466796875, 0.001190185546875, -0.01861572265625, -0.027435302734375, -0.03131103515625, -0.0316162109375, -0.031463623046875, -0.032379150390625, -0.02923583984375, -0.0225830078125, -0.0126953125, -0.0064697265625, -0.0015869140625, 0.004852294921875, 0.0098876953125, 0.01080322265625, 0.00848388671875, 0.006072998046875, 0.0042724609375, 0.001007080078125, -0.00567626953125, -0.011749267578125, -0.013885498046875, -0.01397705078125, -0.016082763671875, -0.017669677734375, -0.01580810546875, -0.01190185546875, -0.008056640625, -0.004608154296875, -0.001129150390625, 0.00250244140625, 0.004852294921875, 0.0025634765625, -0.000335693359375, -0.00152587890625, -0.00347900390625, -0.006317138671875, -0.007476806640625, -0.006500244140625, -0.006072998046875, -0.00579833984375, -0.005645751953125, -0.005157470703125, -0.00396728515625, -0.0020751953125, -0.000823974609375, -0.0006103515625, -6.103515625e-05, -0.000213623046875, -0.00067138671875, -0.002105712890625, -0.003814697265625, -0.004608154296875, -0.00469970703125, -0.00408935546875, -0.0032958984375, -0.002105712890625, -0.001434326171875, -0.0023193359375, -0.004791259765625, -0.00677490234375, -0.006072998046875, -0.00433349609375, -0.00372314453125, -0.00396728515625, -0.003509521484375, -0.001251220703125, 0.00018310546875, -0.0009765625, -0.0035400390625, -0.00531005859375, -0.005218505859375, -0.00396728515625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 6.103515625e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0001220703125, 0.0001220703125, 0.000152587890625, 3.0517578125e-05, 0.0001220703125, -6.103515625e-05, 0.000396728515625, -0.00042724609375, 0.0008544921875, -0.00067138671875, 0.00128173828125, 0.00244140625, 0.0523681640625, 0.055572509765625, -0.07293701171875, -0.08477783203125, 0.00213623046875, 0.03887939453125, 0.03912353515625, 0.0330810546875, 0.066314697265625, 0.13385009765625, 0.134735107421875, 0.037628173828125, -0.02191162109375, -0.0225830078125, -0.00933837890625, -0.01702880859375, -0.04449462890625, -0.05584716796875, -0.0550537109375, -0.0401611328125, -0.02569580078125, -0.00665283203125, 0.0023193359375, 0.004058837890625, 0.02001953125, 0.03369140625, 0.03680419921875, 0.037445068359375, 0.03778076171875, 0.0289306640625, 0.023468017578125, 0.009735107421875, -0.017333984375, -0.03411865234375, -0.035125732421875, -0.03472900390625, -0.03680419921875, -0.033935546875, -0.028106689453125, -0.02130126953125, -0.015289306640625, -0.006500244140625, 0.001007080078125, 0.006134033203125, 0.0115966796875, 0.0130615234375, 0.012664794921875, 0.010223388671875, 0.005126953125, -0.00189208984375, -0.00732421875, -0.00933837890625, -0.012725830078125, -0.016326904296875, -0.018402099609375, -0.01776123046875, -0.015625, -0.012664794921875, -0.00909423828125, -0.00543212890625, 9.1552734375e-05, 0.00213623046875, 0.0015869140625, 0.001373291015625, 0.000396728515625, -0.00115966796875, -0.00311279296875, -0.004180908203125, -0.004486083984375, -0.00390625, -0.004150390625, -0.0054931640625, -0.00616455078125, -0.006011962890625, -0.004638671875, -0.002960205078125, -0.00115966796875, -9.1552734375e-05, -0.00030517578125, -0.001312255859375, -0.00286865234375, -0.003875732421875, -0.00482177734375, -0.005523681640625, -0.004638671875, -0.0025634765625, -0.000396728515625, 0.00067138671875, 0.0003662109375, -0.00189208984375, -0.00543212890625, -0.0076904296875, -0.0068359375, -0.00457763671875, -0.00360107421875, -0.004058837890625, -0.004119873046875, -0.002166748046875, -0.0010986328125, -0.001953125, -0.003173828125, -0.00396728515625, -0.003814697265625, -0.0035400390625])
        IR_LEFT[len(IR_LEFT)-1].append([6.103515625e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, -6.103515625e-05, 9.1552734375e-05, 0.0, 0.000152587890625, -9.1552734375e-05, 0.00030517578125, -0.000335693359375, 0.000579833984375, -0.000579833984375, 0.00079345703125, -0.0006103515625, 0.00115966796875, -0.000335693359375, 0.037841796875, 0.084930419921875, -0.045623779296875, -0.11981201171875, -0.020843505859375, 0.038909912109375, 0.048004150390625, 0.03875732421875, 0.06011962890625, 0.133270263671875, 0.16302490234375, 0.065673828125, -0.0208740234375, -0.031524658203125, -0.0211181640625, -0.021728515625, -0.04296875, -0.054351806640625, -0.067169189453125, -0.060638427734375, -0.03759765625, -0.01239013671875, 0.000274658203125, 0.004119873046875, 0.013885498046875, 0.027557373046875, 0.0478515625, 0.03912353515625, 0.02490234375, 0.026611328125, 0.032623291015625, 0.0235595703125, 0.004364013671875, -0.011383056640625, -0.03070068359375, -0.03759765625, -0.038055419921875, -0.03656005859375, -0.03424072265625, -0.02825927734375, -0.020355224609375, -0.01312255859375, -0.00384521484375, 0.0029296875, 0.006866455078125, 0.011260986328125, 0.016693115234375, 0.014923095703125, 0.0067138671875, 0.001617431640625, -0.0010986328125, -0.00518798828125, -0.01031494140625, -0.01422119140625, -0.01641845703125, -0.01849365234375, -0.017333984375, -0.014556884765625, -0.012420654296875, -0.008697509765625, -0.005126953125, -0.002349853515625, -0.00042724609375, 0.0006103515625, 0.0008544921875, -0.00048828125, -0.001129150390625, -0.00091552734375, -0.000885009765625, -0.002471923828125, -0.003875732421875, -0.004669189453125, -0.005340576171875, -0.005828857421875, -0.006072998046875, -0.00469970703125, -0.003143310546875, -0.0013427734375, -0.00079345703125, -0.00189208984375, -0.003204345703125, -0.0047607421875, -0.005859375, -0.005584716796875, -0.004241943359375, -0.00274658203125, -0.00079345703125, 0.001556396484375, 0.00262451171875, 0.0015869140625, -0.002197265625, -0.00701904296875, -0.00885009765625, -0.00726318359375, -0.00506591796875, -0.00396728515625, -0.004425048828125, -0.004730224609375, -0.003662109375, -0.002655029296875, -0.001983642578125, -0.00213623046875, -0.0023193359375, -0.002655029296875, -0.003326416015625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 0.0, 0.0, -6.103515625e-05, -6.103515625e-05, 3.0517578125e-05, 0.0, 0.0, -6.103515625e-05, 0.0001220703125, -3.0517578125e-05, 0.00018310546875, -0.00018310546875, 0.000335693359375, -0.000213623046875, 0.000152587890625, -9.1552734375e-05, 3.0517578125e-05, 0.00042724609375, 6.103515625e-05, 0.00030517578125, 0.021026611328125, 0.100067138671875, 0.000640869140625, -0.146728515625, -0.05682373046875, 0.03533935546875, 0.05419921875, 0.048614501953125, 0.0589599609375, 0.13330078125, 0.183563232421875, 0.093719482421875, -0.016265869140625, -0.03668212890625, -0.026885986328125, -0.022918701171875, -0.049591064453125, -0.0645751953125, -0.067230224609375, -0.068145751953125, -0.053375244140625, -0.029815673828125, -0.004302978515625, 0.00689697265625, 0.011505126953125, 0.026458740234375, 0.047576904296875, 0.0418701171875, 0.032989501953125, 0.022918701171875, 0.017486572265625, 0.024261474609375, 0.0135498046875, -0.00360107421875, -0.013031005859375, -0.017303466796875, -0.031585693359375, -0.0418701171875, -0.03961181640625, -0.0296630859375, -0.022674560546875, -0.01739501953125, -0.0078125, -0.002838134765625, 0.003753662109375, 0.01171875, 0.013153076171875, 0.01043701171875, 0.008697509765625, 0.007904052734375, 0.002410888671875, -0.004974365234375, -0.0076904296875, -0.0098876953125, -0.013916015625, -0.0166015625, -0.01678466796875, -0.015167236328125, -0.01171875, -0.011077880859375, -0.010223388671875, -0.006256103515625, -0.002410888671875, -0.001434326171875, -0.00177001953125, -0.000701904296875, 0.0010986328125, 0.00128173828125, -0.0003662109375, -0.002227783203125, -0.00335693359375, -0.00341796875, -0.004150390625, -0.00494384765625, -0.005645751953125, -0.00531005859375, -0.003936767578125, -0.002960205078125, -0.002349853515625, -0.0028076171875, -0.004486083984375, -0.0057373046875, -0.005462646484375, -0.004913330078125, -0.004547119140625, -0.0030517578125, -0.001068115234375, 0.001190185546875, 0.002960205078125, 0.003265380859375, 0.00103759765625, -0.003814697265625, -0.008392333984375, -0.009735107421875, -0.00750732421875, -0.00555419921875, -0.004974365234375, -0.00482177734375, -0.005126953125, -0.004913330078125, -0.0029296875, -0.0010986328125, -0.001129150390625, -0.001556396484375, -0.00177001953125, -0.002593994140625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, -0.0001220703125, 0.0001220703125, 6.103515625e-05, 9.1552734375e-05, -3.0517578125e-05, 3.0517578125e-05, 0.000152587890625, -0.00018310546875, 0.00048828125, -0.000762939453125, 0.001220703125, -0.001007080078125, 0.002227783203125, 0.0074462890625, 0.098388671875, 0.055938720703125, -0.154052734375, -0.1051025390625, 0.026763916015625, 0.056243896484375, 0.05877685546875, 0.063720703125, 0.13470458984375, 0.202423095703125, 0.122344970703125, -0.0087890625, -0.043670654296875, -0.035003662109375, -0.022247314453125, -0.04931640625, -0.072662353515625, -0.074188232421875, -0.07989501953125, -0.061920166015625, -0.039398193359375, -0.01275634765625, 0.0013427734375, 0.0084228515625, 0.02557373046875, 0.05010986328125, 0.052276611328125, 0.034210205078125, 0.022247314453125, 0.020294189453125, 0.02020263671875, -0.000213623046875, -0.006072998046875, -0.005706787109375, -0.01080322265625, -0.018035888671875, -0.028717041015625, -0.0335693359375, -0.032379150390625, -0.0242919921875, -0.01678466796875, -0.010528564453125, -0.002532958984375, 0.004486083984375, 0.005706787109375, 0.0069580078125, 0.00994873046875, 0.0093994140625, 0.006103515625, 0.001617431640625, -0.0025634765625, -0.005462646484375, -0.00885009765625, -0.01177978515625, -0.013458251953125, -0.01373291015625, -0.012237548828125, -0.01202392578125, -0.013092041015625, -0.010284423828125, -0.006591796875, -0.004852294921875, -0.005126953125, -0.003326416015625, 3.0517578125e-05, 0.00140380859375, 0.0008544921875, -0.0018310546875, -0.002532958984375, -0.0020751953125, -0.002410888671875, -0.0037841796875, -0.004364013671875, -0.004119873046875, -0.00390625, -0.003631591796875, -0.003997802734375, -0.00439453125, -0.004547119140625, -0.004730224609375, -0.00469970703125, -0.0048828125, -0.0047607421875, -0.00396728515625, -0.002655029296875, -0.000732421875, 0.000701904296875, 0.002105712890625, 0.0029296875, 0.0025634765625, -0.000335693359375, -0.005401611328125, -0.009429931640625, -0.00982666015625, -0.007781982421875, -0.0062255859375, -0.0054931640625, -0.004791259765625, -0.005035400390625, -0.003875732421875, -0.001678466796875, -0.000518798828125, -0.00018310546875, -0.000762939453125, -0.001068115234375, -0.00213623046875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, -9.1552734375e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, -9.1552734375e-05, 0.0, 0.0001220703125, 0.0, 0.0001220703125, -0.000274658203125, 0.000518798828125, -0.000640869140625, 0.00091552734375, -0.00115966796875, 0.00146484375, -0.001556396484375, 0.003143310546875, 0.00042724609375, 0.08270263671875, 0.108062744140625, -0.13580322265625, -0.1605224609375, 0.010406494140625, 0.05670166015625, 0.0645751953125, 0.071258544921875, 0.140594482421875, 0.220947265625, 0.14959716796875, 0.0020751953125, -0.0474853515625, -0.044708251953125, -0.02801513671875, -0.047271728515625, -0.081634521484375, -0.075347900390625, -0.084503173828125, -0.07879638671875, -0.05322265625, -0.01873779296875, 0.00299072265625, 0.00543212890625, 0.016845703125, 0.04742431640625, 0.0635986328125, 0.040557861328125, 0.0286865234375, 0.019073486328125, 0.015167236328125, 0.0064697265625, -0.010986328125, -0.021209716796875, -0.02008056640625, -0.016571044921875, -0.01995849609375, -0.022369384765625, -0.019622802734375, -0.0179443359375, -0.021240234375, -0.007781982421875, 0.00567626953125, 0.003021240234375, 0.001434326171875, 0.005767822265625, 0.00927734375, 0.006683349609375, 0.001861572265625, -0.000762939453125, -0.004364013671875, -0.00689697265625, -0.007293701171875, -0.009490966796875, -0.01220703125, -0.01116943359375, -0.011383056640625, -0.0118408203125, -0.011322021484375, -0.008758544921875, -0.005859375, -0.00616455078125, -0.005096435546875, -0.002960205078125, -0.00048828125, -0.000244140625, -0.002105712890625, -0.004150390625, -0.003326416015625, -0.001708984375, -0.002166748046875, -0.003753662109375, -0.003875732421875, -0.003143310546875, -0.002899169921875, -0.00384521484375, -0.005157470703125, -0.0054931640625, -0.00543212890625, -0.00421142578125, -0.00396728515625, -0.0040283203125, -0.00372314453125, -0.002960205078125, -0.002288818359375, -0.00146484375, 3.0517578125e-05, 0.00164794921875, 0.002410888671875, 0.00189208984375, -6.103515625e-05, -0.002838134765625, -0.006500244140625, -0.00958251953125, -0.009918212890625, -0.008453369140625, -0.007232666015625, -0.005645751953125, -0.0042724609375, -0.00341796875, -0.00177001953125, -0.000640869140625, -6.103515625e-05, 0.000244140625, -0.00030517578125, -0.001434326171875, -0.003570556640625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, -3.0517578125e-05, -9.1552734375e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, -0.000152587890625, 0.000152587890625, -9.1552734375e-05, 0.000244140625, -0.000457763671875, 0.000518798828125, -0.00067138671875, 0.00079345703125, -0.001068115234375, 0.0010986328125, -0.001251220703125, 0.0023193359375, -0.000732421875, 0.060302734375, 0.145843505859375, -0.091156005859375, -0.214385986328125, -0.019683837890625, 0.058441162109375, 0.065673828125, 0.078338623046875, 0.148040771484375, 0.243072509765625, 0.17681884765625, 0.01446533203125, -0.04833984375, -0.05242919921875, -0.03607177734375, -0.047210693359375, -0.0928955078125, -0.0816650390625, -0.08154296875, -0.087677001953125, -0.067474365234375, -0.0340576171875, 0.001678466796875, 0.008941650390625, 0.01373291015625, 0.042510986328125, 0.064239501953125, 0.0479736328125, 0.03521728515625, 0.01898193359375, 0.022308349609375, 0.01123046875, -0.0177001953125, -0.02496337890625, -0.03143310546875, -0.029266357421875, -0.02642822265625, -0.020294189453125, -0.01507568359375, -0.009796142578125, -0.003143310546875, 0.00048828125, 0.00152587890625, 0.005126953125, 0.00909423828125, 0.0086669921875, 0.0072021484375, 0.002685546875, -0.001708984375, -0.003082275390625, -0.007720947265625, -0.010986328125, -0.009429931640625, -0.008026123046875, -0.009552001953125, -0.012237548828125, -0.013153076171875, -0.01092529296875, -0.008453369140625, -0.00750732421875, -0.00537109375, -0.003173828125, -0.001708984375, -0.00177001953125, -0.001129150390625, -0.002593994140625, -0.0047607421875, -0.005645751953125, -0.004486083984375, -0.003448486328125, -0.003570556640625, -0.003265380859375, -0.003265380859375, -0.00311279296875, -0.003662109375, -0.00445556640625, -0.006195068359375, -0.006744384765625, -0.004302978515625, -0.002716064453125, -0.00311279296875, -0.00360107421875, -0.00250244140625, -0.001129150390625, -0.00164794921875, -0.001678466796875, -0.000701904296875, 0.00067138671875, 0.001312255859375, 0.001251220703125, -0.000244140625, -0.002716064453125, -0.0048828125, -0.007659912109375, -0.009857177734375, -0.01019287109375, -0.008636474609375, -0.006500244140625, -0.00494384765625, -0.0035400390625, -0.001068115234375, 0.00048828125, 0.00054931640625, -0.0001220703125, -0.000396728515625, -0.0010986328125, -0.003143310546875, -0.006011962890625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -0.000152587890625, 0.0001220703125, -9.1552734375e-05, 0.000274658203125, -0.000396728515625, 0.0003662109375, -0.00042724609375, 0.0003662109375, -0.00042724609375, 0.000244140625, -3.0517578125e-05, 0.000335693359375, 0.001068115234375, 0.04022216796875, 0.1627197265625, -0.0299072265625, -0.252593994140625, -0.0655517578125, 0.060791015625, 0.064727783203125, 0.083282470703125, 0.154571533203125, 0.268157958984375, 0.206512451171875, 0.026702880859375, -0.04766845703125, -0.057952880859375, -0.044403076171875, -0.04669189453125, -0.1031494140625, -0.09759521484375, -0.079559326171875, -0.090362548828125, -0.075927734375, -0.04718017578125, -0.006256103515625, 0.009063720703125, 0.01385498046875, 0.0400390625, 0.068939208984375, 0.0506591796875, 0.0296630859375, 0.031829833984375, 0.03118896484375, 0.00970458984375, -0.019683837890625, -0.030059814453125, -0.03369140625, -0.032745361328125, -0.03509521484375, -0.03680419921875, -0.02484130859375, 0.000396728515625, 0.0076904296875, 0.007110595703125, 0.01177978515625, 0.01361083984375, 0.01300048828125, 0.011871337890625, 0.008636474609375, 0.002166748046875, -0.0018310546875, -0.00518798828125, -0.01092529296875, -0.014068603515625, -0.01171875, -0.010955810546875, -0.012969970703125, -0.01324462890625, -0.01220703125, -0.011077880859375, -0.00921630859375, -0.007080078125, -0.002166748046875, 0.00128173828125, 0.00189208984375, -0.000396728515625, -0.0015869140625, -0.002044677734375, -0.00457763671875, -0.007080078125, -0.006744384765625, -0.00518798828125, -0.00421142578125, -0.004547119140625, -0.00482177734375, -0.0042724609375, -0.004974365234375, -0.0057373046875, -0.006927490234375, -0.005706787109375, -0.002960205078125, -0.00146484375, -0.001953125, -0.002349853515625, -0.001373291015625, -9.1552734375e-05, -0.000396728515625, -0.0013427734375, -0.001007080078125, -0.00030517578125, 0.00018310546875, 6.103515625e-05, -0.00115966796875, -0.002532958984375, -0.003936767578125, -0.00640869140625, -0.009185791015625, -0.01031494140625, -0.009613037109375, -0.00750732421875, -0.005096435546875, -0.003509521484375, -0.00115966796875, 0.000946044921875, 0.00140380859375, 0.000579833984375, -0.000579833984375, -0.001739501953125, -0.003387451171875, -0.005615234375, -0.00738525390625])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -0.0001220703125, -6.103515625e-05, 0.0, -3.0517578125e-05, -0.000244140625, 6.103515625e-05, -6.103515625e-05, 0.000213623046875, -0.000274658203125, 0.0001220703125, -9.1552734375e-05, -6.103515625e-05, 0.0, -0.000518798828125, 0.000885009765625, -0.000946044921875, 0.002166748046875, 0.02679443359375, 0.1619873046875, 0.03228759765625, -0.26361083984375, -0.12506103515625, 0.05859375, 0.064971923828125, 0.085693359375, 0.159393310546875, 0.2896728515625, 0.241973876953125, 0.04150390625, -0.044952392578125, -0.06390380859375, -0.053131103515625, -0.045440673828125, -0.10858154296875, -0.116668701171875, -0.08673095703125, -0.093505859375, -0.08074951171875, -0.05426025390625, -0.01336669921875, 0.00726318359375, 0.0098876953125, 0.04052734375, 0.06878662109375, 0.053985595703125, 0.0426025390625, 0.03369140625, 0.0238037109375, 0.014801025390625, -0.01531982421875, -0.031524658203125, -0.037353515625, -0.03851318359375, -0.04180908203125, -0.04046630859375, -0.028106689453125, -0.010009765625, 0.001129150390625, 0.010894775390625, 0.023223876953125, 0.02777099609375, 0.023223876953125, 0.012542724609375, 0.0078125, 0.00701904296875, 0.000640869140625, -0.00567626953125, -0.010162353515625, -0.015625, -0.01629638671875, -0.015625, -0.015472412109375, -0.016387939453125, -0.01611328125, -0.01153564453125, -0.00750732421875, -0.00665283203125, -0.001373291015625, 0.004302978515625, 0.00439453125, 0.001434326171875, 0.000274658203125, -0.000732421875, -0.003265380859375, -0.006134033203125, -0.0069580078125, -0.00640869140625, -0.0067138671875, -0.006866455078125, -0.0076904296875, -0.0074462890625, -0.007171630859375, -0.006683349609375, -0.006256103515625, -0.005035400390625, -0.001953125, 0.000152587890625, -0.00042724609375, -0.0008544921875, -0.00018310546875, 0.00048828125, 0.00042724609375, -0.000152587890625, -0.0009765625, -0.001220703125, -0.000823974609375, -0.001556396484375, -0.002960205078125, -0.003265380859375, -0.002655029296875, -0.00439453125, -0.007965087890625, -0.010406494140625, -0.010345458984375, -0.007904052734375, -0.005035400390625, -0.00390625, -0.0020751953125, 0.000640869140625, 0.0020751953125, 0.001434326171875, -0.000213623046875, -0.00201416015625, -0.004425048828125, -0.00628662109375, -0.007049560546875, -0.00787353515625])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, -0.00018310546875, 9.1552734375e-05, -3.0517578125e-05, 0.0001220703125, -6.103515625e-05, -3.0517578125e-05, 9.1552734375e-05, -0.000244140625, 0.00030517578125, -0.00091552734375, 0.001220703125, -0.001190185546875, 0.00213623046875, 0.019287109375, 0.15203857421875, 0.081298828125, -0.2452392578125, -0.185089111328125, 0.041656494140625, 0.069976806640625, 0.08538818359375, 0.164642333984375, 0.303466796875, 0.2774658203125, 0.0633544921875, -0.03814697265625, -0.0673828125, -0.06524658203125, -0.0457763671875, -0.109405517578125, -0.133087158203125, -0.09765625, -0.099884033203125, -0.09039306640625, -0.058502197265625, -0.017791748046875, 0.008148193359375, 0.00909423828125, 0.029296875, 0.0718994140625, 0.070953369140625, 0.04376220703125, 0.03155517578125, 0.026153564453125, 0.015655517578125, -0.01513671875, -0.02960205078125, -0.039306640625, -0.049163818359375, -0.0435791015625, -0.035675048828125, -0.03118896484375, -0.01873779296875, -0.00531005859375, 0.0079345703125, 0.023651123046875, 0.03076171875, 0.030059814453125, 0.0235595703125, 0.015472412109375, 0.008575439453125, 0.0032958984375, -0.001739501953125, -0.00933837890625, -0.017608642578125, -0.01904296875, -0.016815185546875, -0.01904296875, -0.021575927734375, -0.019439697265625, -0.013519287109375, -0.00689697265625, -0.004241943359375, -0.0006103515625, 0.00213623046875, 0.005706787109375, 0.005889892578125, 0.00286865234375, 0.0009765625, -0.0013427734375, -0.003509521484375, -0.0059814453125, -0.00689697265625, -0.008758544921875, -0.010589599609375, -0.01153564453125, -0.0103759765625, -0.008392333984375, -0.0074462890625, -0.006256103515625, -0.00433349609375, -0.001190185546875, 0.00152587890625, 0.001190185546875, 0.00067138671875, 0.0010986328125, 0.001556396484375, 0.0010986328125, 0.0006103515625, 0.00018310546875, -0.001190185546875, -0.002471923828125, -0.00311279296875, -0.00390625, -0.004425048828125, -0.00335693359375, -0.002838134765625, -0.00531005859375, -0.008392333984375, -0.009521484375, -0.00836181640625, -0.005859375, -0.0040283203125, -0.002349853515625, -0.000701904296875, 0.00115966796875, 0.002166748046875, 0.0010986328125, -0.00146484375, -0.00457763671875, -0.0067138671875, -0.007598876953125, -0.007965087890625, -0.008087158203125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000152587890625, 0.0, 3.0517578125e-05, -0.00018310546875, 0.0, -3.0517578125e-05, 9.1552734375e-05, -3.0517578125e-05, -0.000152587890625, 6.103515625e-05, -0.00042724609375, 0.000335693359375, -0.00091552734375, 0.0009765625, -0.001129150390625, 0.00201416015625, 0.014434814453125, 0.14202880859375, 0.110595703125, -0.21087646484375, -0.225738525390625, 0.00518798828125, 0.07489013671875, 0.08624267578125, 0.16949462890625, 0.313232421875, 0.304931640625, 0.091064453125, -0.025970458984375, -0.0653076171875, -0.07763671875, -0.0511474609375, -0.109832763671875, -0.145294189453125, -0.10943603515625, -0.107177734375, -0.102203369140625, -0.06890869140625, -0.0186767578125, 0.00958251953125, 0.001495361328125, 0.0316162109375, 0.080230712890625, 0.071533203125, 0.04595947265625, 0.034698486328125, 0.02825927734375, 0.017425537109375, -0.012176513671875, -0.03680419921875, -0.046966552734375, -0.044189453125, -0.04144287109375, -0.04339599609375, -0.03765869140625, -0.01605224609375, -0.000640869140625, 0.00531005859375, 0.012420654296875, 0.023529052734375, 0.033050537109375, 0.028961181640625, 0.0234375, 0.018310546875, 0.008056640625, -0.000762939453125, -0.007110595703125, -0.015960693359375, -0.0216064453125, -0.021575927734375, -0.021575927734375, -0.022918701171875, -0.02166748046875, -0.0162353515625, -0.009246826171875, -0.005889892578125, 0.0, 0.005462646484375, 0.006927490234375, 0.005615234375, 0.00469970703125, 0.004608154296875, 0.0018310546875, -0.002532958984375, -0.00640869140625, -0.0081787109375, -0.01080322265625, -0.012939453125, -0.013885498046875, -0.01263427734375, -0.0103759765625, -0.00830078125, -0.006256103515625, -0.004241943359375, -0.001220703125, 0.002166748046875, 0.002593994140625, 0.001434326171875, 0.00152587890625, 0.002288818359375, 0.001953125, 0.001129150390625, 0.000640869140625, -0.0010986328125, -0.002838134765625, -0.00408935546875, -0.005096435546875, -0.00604248046875, -0.00482177734375, -0.00274658203125, -0.003448486328125, -0.005950927734375, -0.0078125, -0.00750732421875, -0.006439208984375, -0.005126953125, -0.003265380859375, -0.002105712890625, -0.000518798828125, 0.0013427734375, 0.00146484375, -0.0009765625, -0.0042724609375, -0.0064697265625, -0.007965087890625, -0.00860595703125, -0.009185791015625, -0.007049560546875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 6.103515625e-05, -0.000152587890625, 0.0, 0.0, 0.0001220703125, 0.0, -0.0001220703125, 3.0517578125e-05, -0.00042724609375, 0.000396728515625, -0.0009765625, 0.001007080078125, -0.001434326171875, 0.0023193359375, 0.01068115234375, 0.1348876953125, 0.125640869140625, -0.1783447265625, -0.23773193359375, -0.03814697265625, 0.066162109375, 0.092376708984375, 0.17327880859375, 0.32073974609375, 0.32476806640625, 0.118804931640625, -0.008758544921875, -0.057373046875, -0.083587646484375, -0.05987548828125, -0.114349365234375, -0.15338134765625, -0.120147705078125, -0.115203857421875, -0.1134033203125, -0.079620361328125, -0.029815673828125, 0.0045166015625, 0.0162353515625, 0.03192138671875, 0.071929931640625, 0.07733154296875, 0.0550537109375, 0.03851318359375, 0.0296630859375, 0.019378662109375, -0.01776123046875, -0.03857421875, -0.041015625, -0.045654296875, -0.052947998046875, -0.046539306640625, -0.033447265625, -0.015106201171875, -0.002777099609375, 0.001983642578125, 0.013580322265625, 0.021514892578125, 0.0264892578125, 0.027191162109375, 0.0252685546875, 0.022064208984375, 0.016265869140625, 0.0074462890625, -0.004547119140625, -0.01629638671875, -0.02264404296875, -0.023223876953125, -0.0233154296875, -0.0244140625, -0.022491455078125, -0.019073486328125, -0.013519287109375, -0.00677490234375, 0.000885009765625, 0.00634765625, 0.008575439453125, 0.0093994140625, 0.008026123046875, 0.00579833984375, 0.00238037109375, -0.002471923828125, -0.00701904296875, -0.01055908203125, -0.011962890625, -0.013031005859375, -0.01470947265625, -0.014129638671875, -0.011993408203125, -0.0084228515625, -0.0062255859375, -0.004150390625, -0.001434326171875, 0.001922607421875, 0.00390625, 0.002532958984375, 0.001312255859375, 0.001800537109375, 0.00274658203125, 0.001861572265625, 0.0009765625, -0.00018310546875, -0.002685546875, -0.004150390625, -0.00518798828125, -0.006378173828125, -0.00628662109375, -0.003875732421875, -0.001861572265625, -0.003326416015625, -0.00537109375, -0.006195068359375, -0.00592041015625, -0.005950927734375, -0.004791259765625, -0.002685546875, -0.001495361328125, 6.103515625e-05, 0.00067138671875, -0.0006103515625, -0.003570556640625, -0.0059814453125, -0.0069580078125, -0.008697509765625, -0.010040283203125, -0.009246826171875, -0.00408935546875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -9.1552734375e-05, 0.0, 0.0, 9.1552734375e-05, 3.0517578125e-05, -6.103515625e-05, 0.0001220703125, -0.00048828125, 0.000518798828125, -0.001220703125, 0.00128173828125, -0.0018310546875, 0.002838134765625, 0.007232666015625, 0.130035400390625, 0.13519287109375, -0.157379150390625, -0.231109619140625, -0.067718505859375, 0.039398193359375, 0.095916748046875, 0.1807861328125, 0.323394775390625, 0.33868408203125, 0.1478271484375, 0.01171875, -0.049652099609375, -0.080902099609375, -0.06378173828125, -0.1224365234375, -0.16259765625, -0.127838134765625, -0.124664306640625, -0.120208740234375, -0.0997314453125, -0.045562744140625, 0.012542724609375, 0.018280029296875, 0.03082275390625, 0.069976806640625, 0.079620361328125, 0.064605712890625, 0.048614501953125, 0.031463623046875, 0.012115478515625, -0.016937255859375, -0.027679443359375, -0.04156494140625, -0.05816650390625, -0.0560302734375, -0.04608154296875, -0.034393310546875, -0.017974853515625, -0.0054931640625, 0.001190185546875, 0.01190185546875, 0.0244140625, 0.03094482421875, 0.024200439453125, 0.018829345703125, 0.0211181640625, 0.017547607421875, 0.01104736328125, 0.001861572265625, -0.011627197265625, -0.022064208984375, -0.0245361328125, -0.022613525390625, -0.025360107421875, -0.02630615234375, -0.02117919921875, -0.01275634765625, -0.00848388671875, -0.000762939453125, 0.008575439453125, 0.012664794921875, 0.011810302734375, 0.008270263671875, 0.0068359375, 0.00286865234375, -0.003173828125, -0.008941650390625, -0.011444091796875, -0.012054443359375, -0.01318359375, -0.0146484375, -0.0142822265625, -0.012054443359375, -0.00909423828125, -0.006561279296875, -0.004669189453125, -0.00152587890625, 0.00244140625, 0.003875732421875, 0.002960205078125, 0.001556396484375, 0.0015869140625, 0.0020751953125, 0.00189208984375, 0.001678466796875, 0.000640869140625, -0.00152587890625, -0.003692626953125, -0.0052490234375, -0.00634765625, -0.006011962890625, -0.004638671875, -0.00244140625, -0.00152587890625, -0.002349853515625, -0.003997802734375, -0.004730224609375, -0.00555419921875, -0.005767822265625, -0.00439453125, -0.00286865234375, -0.001220703125, -0.000152587890625, -0.000457763671875, -0.003082275390625, -0.00567626953125, -0.006317138671875, -0.00750732421875, -0.009613037109375, -0.0108642578125, -0.007110595703125, -0.002349853515625])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([0.00018310546875, -0.000274658203125, 0.000640869140625, -0.000946044921875, 0.001068115234375, -0.001678466796875, 0.00201416015625, -0.0025634765625, 0.002471923828125, -0.002685546875, 0.00299072265625, 0.000213623046875, 0.139984130859375, 0.205413818359375, -0.267303466796875, -0.124755859375, 0.074737548828125, -0.161041259765625, 0.202239990234375, 0.313140869140625, 0.0753173828125, 0.212249755859375, 0.4896240234375, 0.02276611328125, -0.3641357421875, 0.052490234375, -0.04669189453125, -0.41839599609375, -0.131927490234375, 0.04107666015625, -0.2283935546875, -0.158599853515625, 0.066162109375, 0.053253173828125, -0.012603759765625, 0.046356201171875, 0.140167236328125, 0.082733154296875, 0.0577392578125, 0.111572265625, 0.0384521484375, -0.045257568359375, 0.0029296875, -0.000640869140625, -0.085601806640625, -0.1146240234375, -0.078094482421875, -0.093902587890625, -0.1104736328125, -0.0567626953125, -0.040252685546875, -0.03155517578125, 0.03057861328125, 0.053955078125, 0.0465087890625, 0.056549072265625, 0.059478759765625, 0.0477294921875, 0.0311279296875, 0.0152587890625, 0.008148193359375, -0.004791259765625, -0.027984619140625, -0.02960205078125, -0.03131103515625, -0.044464111328125, -0.042938232421875, -0.031463623046875, -0.02947998046875, -0.02392578125, -0.008758544921875, 0.00115966796875, 0.00262451171875, 0.013580322265625, 0.023529052734375, 0.02166748046875, 0.01800537109375, 0.014923095703125, 0.011322021484375, 0.000701904296875, -0.010162353515625, -0.011810302734375, -0.01312255859375, -0.02117919921875, -0.01837158203125, -0.012603759765625, -0.01605224609375, -0.015411376953125, -0.008056640625, -0.00244140625, -0.00048828125, 0.003204345703125, 0.0081787109375, 0.004974365234375, 0.0040283203125, 0.008026123046875, 0.0074462890625, 0.00274658203125, -0.00079345703125, -0.003204345703125, -0.009674072265625, -0.013092041015625, -0.013458251953125, -0.012664794921875, -0.01129150390625, -0.008819580078125, -0.00439453125, -0.00115966796875, 0.000213623046875, 0.00238037109375, 0.002685546875, 0.000946044921875, 0.0003662109375, 0.00048828125, -0.000396728515625, -0.001068115234375, -0.002105712890625, -0.00433349609375, -0.005279541015625, -0.005126953125, -0.00445556640625, -0.003326416015625, -0.00189208984375, -0.0020751953125, -0.001251220703125, 0.00018310546875, 0.000274658203125, 0.0018310546875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0001220703125, -0.00018310546875, 0.000457763671875, -0.000701904296875, 0.0008544921875, -0.00140380859375, 0.0018310546875, -0.002349853515625, 0.00250244140625, -0.002777099609375, 0.003326416015625, 0.002288818359375, 0.139007568359375, 0.162261962890625, -0.241607666015625, -0.07830810546875, 0.0445556640625, -0.139495849609375, 0.19512939453125, 0.264617919921875, 0.0762939453125, 0.208038330078125, 0.428680419921875, 0.0169677734375, -0.29150390625, 0.048309326171875, -0.060394287109375, -0.359710693359375, -0.111785888671875, 0.014068603515625, -0.205902099609375, -0.135589599609375, 0.042999267578125, 0.038177490234375, -0.011199951171875, 0.04254150390625, 0.121551513671875, 0.072052001953125, 0.063262939453125, 0.10614013671875, 0.027191162109375, -0.0355224609375, 0.0047607421875, -0.010223388671875, -0.077972412109375, -0.09320068359375, -0.062713623046875, -0.086029052734375, -0.0943603515625, -0.041259765625, -0.03204345703125, -0.03594970703125, 0.01348876953125, 0.04156494140625, 0.0374755859375, 0.040618896484375, 0.04473876953125, 0.0440673828125, 0.032073974609375, 0.017059326171875, 0.009918212890625, -0.0054931640625, -0.0238037109375, -0.023193359375, -0.0291748046875, -0.043060302734375, -0.039215087890625, -0.028778076171875, -0.02703857421875, -0.02001953125, -0.00628662109375, 0.0018310546875, 0.0020751953125, 0.01153564453125, 0.0198974609375, 0.017486572265625, 0.01336669921875, 0.012725830078125, 0.010406494140625, 0.000396728515625, -0.0096435546875, -0.010223388671875, -0.010498046875, -0.01849365234375, -0.016815185546875, -0.012237548828125, -0.01361083984375, -0.01275634765625, -0.007965087890625, -0.004425048828125, -0.003265380859375, 0.0013427734375, 0.006378173828125, 0.003936767578125, 0.00396728515625, 0.00762939453125, 0.0069580078125, 0.00274658203125, -0.0001220703125, -0.003173828125, -0.0086669921875, -0.0107421875, -0.010345458984375, -0.009979248046875, -0.0093994140625, -0.0079345703125, -0.00518798828125, -0.002227783203125, -0.0008544921875, 0.000732421875, 0.000701904296875, -0.00091552734375, -0.001708984375, -0.00115966796875, -0.000732421875, -0.001129150390625, -0.001373291015625, -0.002410888671875, -0.003021240234375, -0.003265380859375, -0.003021240234375, -0.00238037109375, -0.002105712890625, -0.002471923828125, -0.001922607421875, -0.000732421875, 0.000335693359375])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000152587890625, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 0.000274658203125, -0.000457763671875, 0.0006103515625, -0.001068115234375, 0.00140380859375, -0.0020751953125, 0.002227783203125, -0.002655029296875, 0.003326416015625, 0.00592041015625, 0.141143798828125, 0.11480712890625, -0.216705322265625, -0.04058837890625, 0.012359619140625, -0.10125732421875, 0.18682861328125, 0.2178955078125, 0.08209228515625, 0.20672607421875, 0.374298095703125, -0.000579833984375, -0.230010986328125, 0.0428466796875, -0.076995849609375, -0.304290771484375, -0.09228515625, -0.012664794921875, -0.186004638671875, -0.113433837890625, 0.028717041015625, 0.028076171875, -0.00933837890625, 0.04400634765625, 0.106353759765625, 0.06402587890625, 0.0643310546875, 0.09832763671875, 0.021514892578125, -0.034423828125, -0.00030517578125, -0.01507568359375, -0.069000244140625, -0.0775146484375, -0.05499267578125, -0.0748291015625, -0.07696533203125, -0.030975341796875, -0.024810791015625, -0.032928466796875, 0.002716064453125, 0.02752685546875, 0.029022216796875, 0.033721923828125, 0.039093017578125, 0.037322998046875, 0.024169921875, 0.011505126953125, 0.00738525390625, -0.00689697265625, -0.021270751953125, -0.020843505859375, -0.0263671875, -0.03759765625, -0.03369140625, -0.024139404296875, -0.022430419921875, -0.01593017578125, -0.004241943359375, 0.0035400390625, 0.0040283203125, 0.010345458984375, 0.015533447265625, 0.0133056640625, 0.01043701171875, 0.00933837890625, 0.00689697265625, -0.0008544921875, -0.00927734375, -0.01007080078125, -0.011383056640625, -0.017059326171875, -0.0146484375, -0.011932373046875, -0.012786865234375, -0.010711669921875, -0.0059814453125, -0.003875732421875, -0.003875732421875, 0.000762939453125, 0.0059814453125, 0.004364013671875, 0.0042724609375, 0.0064697265625, 0.005645751953125, 0.0015869140625, -0.001068115234375, -0.00439453125, -0.00823974609375, -0.0087890625, -0.008575439453125, -0.00836181640625, -0.0084228515625, -0.006988525390625, -0.004791259765625, -0.003143310546875, -0.001983642578125, -0.00079345703125, -0.000885009765625, -0.00225830078125, -0.00213623046875, -0.001251220703125, -0.000946044921875, -0.00048828125, -0.000274658203125, -0.0009765625, -0.00244140625, -0.00225830078125, -0.00201416015625, -0.002227783203125, -0.002288818359375, -0.00341796875, -0.0023193359375, -0.00115966796875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -0.000152587890625, 6.103515625e-05, -6.103515625e-05, 0.0, 0.0001220703125, -0.00030517578125, 0.0003662109375, -0.000762939453125, 0.000946044921875, -0.001556396484375, 0.001708984375, -0.002044677734375, 0.002410888671875, 0.00927734375, 0.133270263671875, 0.083953857421875, -0.1856689453125, -0.026702880859375, 0.001373291015625, -0.071533203125, 0.160888671875, 0.1878662109375, 0.0843505859375, 0.19256591796875, 0.33074951171875, 0.00201416015625, -0.18499755859375, 0.035369873046875, -0.0718994140625, -0.257354736328125, -0.08563232421875, -0.029083251953125, -0.16619873046875, -0.102935791015625, 0.01422119140625, 0.022796630859375, -0.00933837890625, 0.03839111328125, 0.096527099609375, 0.06280517578125, 0.06085205078125, 0.080535888671875, 0.019927978515625, -0.0245361328125, -0.00335693359375, -0.0140380859375, -0.05865478515625, -0.067291259765625, -0.04693603515625, -0.061065673828125, -0.066070556640625, -0.03106689453125, -0.02410888671875, -0.027618408203125, -0.00128173828125, 0.015472412109375, 0.024078369140625, 0.03094482421875, 0.028472900390625, 0.022735595703125, 0.0159912109375, 0.008941650390625, 0.004302978515625, -0.006683349609375, -0.01690673828125, -0.016082763671875, -0.021453857421875, -0.030670166015625, -0.027618408203125, -0.0211181640625, -0.018310546875, -0.013519287109375, -0.003875732421875, 0.00372314453125, 0.0047607421875, 0.00927734375, 0.01165771484375, 0.010345458984375, 0.007415771484375, 0.00506591796875, 0.002838134765625, -0.002716064453125, -0.009185791015625, -0.00994873046875, -0.01104736328125, -0.015625, -0.01318359375, -0.010498046875, -0.011474609375, -0.009857177734375, -0.00518798828125, -0.00238037109375, -0.001739501953125, 0.0008544921875, 0.003936767578125, 0.00335693359375, 0.00421142578125, 0.0057373046875, 0.00360107421875, -0.000244140625, -0.002227783203125, -0.004425048828125, -0.007537841796875, -0.008544921875, -0.008209228515625, -0.007843017578125, -0.00738525390625, -0.00653076171875, -0.0048828125, -0.003326416015625, -0.002593994140625, -0.001922607421875, -0.001861572265625, -0.00201416015625, -0.002166748046875, -0.0013427734375, -0.000885009765625, -0.000457763671875, -6.103515625e-05, -0.001220703125, -0.00189208984375, -0.001861572265625, -0.001556396484375, -0.001861572265625, -0.00262451171875, -0.004058837890625, -0.0037841796875])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, -6.103515625e-05, -0.000152587890625, 0.0, -6.103515625e-05, 3.0517578125e-05, 9.1552734375e-05, -0.000274658203125, 0.000274658203125, -0.00054931640625, 0.0006103515625, -0.001190185546875, 0.001312255859375, -0.001434326171875, 0.001495361328125, 0.011444091796875, 0.12060546875, 0.065460205078125, -0.15716552734375, -0.02008056640625, 0.001739501953125, -0.0556640625, 0.133636474609375, 0.167266845703125, 0.080780029296875, 0.17425537109375, 0.29681396484375, 0.013031005859375, -0.14996337890625, 0.0323486328125, -0.0584716796875, -0.219635009765625, -0.0845947265625, -0.038299560546875, -0.148529052734375, -0.10113525390625, 0.00555419921875, 0.018402099609375, -0.01300048828125, 0.03704833984375, 0.0919189453125, 0.055999755859375, 0.048492431640625, 0.070709228515625, 0.02288818359375, -0.01513671875, -0.000152587890625, -0.0096435546875, -0.050811767578125, -0.05841064453125, -0.037628173828125, -0.055419921875, -0.063629150390625, -0.032989501953125, -0.0228271484375, -0.021759033203125, 0.001678466796875, 0.01226806640625, 0.013641357421875, 0.0169677734375, 0.018096923828125, 0.01654052734375, 0.009521484375, 0.005767822265625, 0.00494384765625, -0.002838134765625, -0.011566162109375, -0.012176513671875, -0.0172119140625, -0.02606201171875, -0.023223876953125, -0.016448974609375, -0.015411376953125, -0.012054443359375, -0.00262451171875, 0.003509521484375, 0.00311279296875, 0.007537841796875, 0.009613037109375, 0.0072021484375, 0.00408935546875, 0.00213623046875, -0.000274658203125, -0.0059814453125, -0.0098876953125, -0.008056640625, -0.008697509765625, -0.013458251953125, -0.012359619140625, -0.0093994140625, -0.00921630859375, -0.007904052734375, -0.0042724609375, -0.00146484375, -0.00079345703125, 0.001190185546875, 0.003509521484375, 0.0023193359375, 0.003204345703125, 0.004638671875, 0.002716064453125, -0.00140380859375, -0.004119873046875, -0.005340576171875, -0.00714111328125, -0.0081787109375, -0.008270263671875, -0.007476806640625, -0.006561279296875, -0.00494384765625, -0.00299072265625, -0.002655029296875, -0.003173828125, -0.0023193359375, -0.00140380859375, -0.001556396484375, -0.00201416015625, -0.00152587890625, -0.0009765625, -0.000579833984375, -0.000823974609375, -0.00164794921875, -0.0013427734375, -0.00067138671875, -0.00079345703125, -0.001739501953125, -0.003204345703125, -0.0047607421875])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 3.0517578125e-05, -9.1552734375e-05, -0.00018310546875, 0.0, -0.0001220703125, 3.0517578125e-05, -3.0517578125e-05, -0.0001220703125, 0.000244140625, -0.00042724609375, 0.00042724609375, -0.000885009765625, 0.0009765625, -0.001129150390625, 0.001007080078125, 0.011993408203125, 0.105987548828125, 0.0550537109375, -0.1314697265625, -0.015655517578125, 0.004852294921875, -0.048980712890625, 0.109954833984375, 0.15032958984375, 0.073455810546875, 0.154815673828125, 0.270477294921875, 0.02789306640625, -0.1202392578125, 0.032379150390625, -0.04278564453125, -0.190826416015625, -0.08551025390625, -0.040679931640625, -0.138397216796875, -0.099761962890625, 0.001190185546875, 0.013641357421875, -0.01190185546875, 0.033782958984375, 0.079315185546875, 0.048004150390625, 0.045257568359375, 0.065093994140625, 0.02349853515625, -0.00689697265625, 0.0086669921875, -0.003936767578125, -0.04498291015625, -0.052581787109375, -0.03826904296875, -0.0546875, -0.06060791015625, -0.02978515625, -0.018890380859375, -0.01605224609375, -0.000885009765625, 0.00177001953125, 0.00408935546875, 0.00885009765625, 0.0125732421875, 0.01153564453125, 0.0079345703125, 0.004913330078125, 0.006561279296875, 0.001800537109375, -0.00921630859375, -0.012176513671875, -0.01556396484375, -0.019500732421875, -0.0174560546875, -0.013519287109375, -0.012725830078125, -0.0107421875, -0.00323486328125, 0.0018310546875, 0.00164794921875, 0.0045166015625, 0.00714111328125, 0.005584716796875, 0.000946044921875, -0.001495361328125, -0.0028076171875, -0.006195068359375, -0.009307861328125, -0.00738525390625, -0.007415771484375, -0.011688232421875, -0.010406494140625, -0.007568359375, -0.007476806640625, -0.005859375, -0.00286865234375, -0.001434326171875, -0.001190185546875, 0.001068115234375, 0.0032958984375, 0.001617431640625, 0.001556396484375, 0.002716064453125, 0.00128173828125, -0.003082275390625, -0.00579833984375, -0.006317138671875, -0.00726318359375, -0.00732421875, -0.0072021484375, -0.006378173828125, -0.00494384765625, -0.0032958984375, -0.002105712890625, -0.00238037109375, -0.00250244140625, -0.0020751953125, -0.001800537109375, -0.00177001953125, -0.001800537109375, -0.001617431640625, -0.001922607421875, -0.0018310546875, -0.001556396484375, -0.000732421875, -0.000335693359375, -0.00030517578125, -0.000885009765625, -0.002288818359375, -0.003875732421875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -9.1552734375e-05, -3.0517578125e-05, -6.103515625e-05, -0.000152587890625, 6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, 0.000213623046875, -0.000396728515625, 0.000457763671875, -0.00067138671875, 0.00079345703125, -0.000762939453125, 0.000762939453125, 0.01104736328125, 0.09075927734375, 0.05078125, -0.10736083984375, -0.013092041015625, 0.007476806640625, -0.046539306640625, 0.08978271484375, 0.13427734375, 0.06475830078125, 0.13671875, 0.24774169921875, 0.046478271484375, -0.09295654296875, 0.032379150390625, -0.0279541015625, -0.168426513671875, -0.083648681640625, -0.04364013671875, -0.131439208984375, -0.092803955078125, -0.0001220703125, 0.007659912109375, -0.0169677734375, 0.02813720703125, 0.07275390625, 0.04473876953125, 0.041595458984375, 0.06005859375, 0.027374267578125, 0.005340576171875, 0.0159912109375, -0.00421142578125, -0.045440673828125, -0.052886962890625, -0.03851318359375, -0.049591064453125, -0.05157470703125, -0.025238037109375, -0.020599365234375, -0.023773193359375, -0.006317138671875, 0.001434326171875, 0.000335693359375, 0.00384521484375, 0.00933837890625, 0.010833740234375, 0.0072021484375, 0.005615234375, 0.006378173828125, 0.000701904296875, -0.007568359375, -0.009613037109375, -0.011627197265625, -0.015411376953125, -0.01300048828125, -0.0108642578125, -0.0123291015625, -0.010894775390625, -0.004425048828125, 0.000244140625, 0.000335693359375, 0.002838134765625, 0.004241943359375, 0.00244140625, -0.001007080078125, -0.00238037109375, -0.00286865234375, -0.0057373046875, -0.009063720703125, -0.00775146484375, -0.007232666015625, -0.009063720703125, -0.007232666015625, -0.0054931640625, -0.0052490234375, -0.004608154296875, -0.00244140625, -0.001922607421875, -0.002288818359375, -3.0517578125e-05, 0.00213623046875, 0.0010986328125, 0.000244140625, 0.00079345703125, -0.001373291015625, -0.0045166015625, -0.00543212890625, -0.0059814453125, -0.006195068359375, -0.005859375, -0.00543212890625, -0.0052490234375, -0.00396728515625, -0.00213623046875, -0.00164794921875, -0.002044677734375, -0.00262451171875, -0.002227783203125, -0.001678466796875, -0.001708984375, -0.00213623046875, -0.002532958984375, -0.0025634765625, -0.00164794921875, -0.000396728515625, -0.0001220703125, -0.000396728515625, -0.000579833984375, -0.001739501953125, -0.003204345703125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, -3.0517578125e-05, -0.00018310546875, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0001220703125, -0.00030517578125, 0.000335693359375, -0.00054931640625, 0.00054931640625, -0.000579833984375, 0.000579833984375, 0.00897216796875, 0.075592041015625, 0.049774169921875, -0.084320068359375, -0.0125732421875, 0.008087158203125, -0.044403076171875, 0.071563720703125, 0.116912841796875, 0.05816650390625, 0.11944580078125, 0.2266845703125, 0.067596435546875, -0.068389892578125, 0.03070068359375, -0.0172119140625, -0.145355224609375, -0.08197021484375, -0.05023193359375, -0.11572265625, -0.082489013671875, -0.014007568359375, -0.002044677734375, -0.012115478515625, 0.02685546875, 0.06268310546875, 0.041717529296875, 0.040771484375, 0.06005859375, 0.037689208984375, 0.009979248046875, 0.00701904296875, -0.01080322265625, -0.041656494140625, -0.04791259765625, -0.034027099609375, -0.041015625, -0.048095703125, -0.033843994140625, -0.027313232421875, -0.020751953125, -0.00714111328125, -0.00079345703125, 0.000762939453125, 0.002593994140625, 0.007415771484375, 0.00970458984375, 0.00701904296875, 0.00335693359375, 0.004913330078125, 0.00115966796875, -0.005523681640625, -0.00604248046875, -0.009033203125, -0.01336669921875, -0.012603759765625, -0.01007080078125, -0.0120849609375, -0.011566162109375, -0.00445556640625, -0.0003662109375, -0.0009765625, 0.000244140625, 0.0013427734375, -6.103515625e-05, -0.001708984375, -0.0018310546875, -0.0028076171875, -0.006072998046875, -0.00872802734375, -0.0067138671875, -0.005615234375, -0.00762939453125, -0.005340576171875, -0.003021240234375, -0.00439453125, -0.005035400390625, -0.00372314453125, -0.00299072265625, -0.002960205078125, -0.001373291015625, 0.00054931640625, -0.00079345703125, -0.001129150390625, -0.00079345703125, -0.00238037109375, -0.004425048828125, -0.0045166015625, -0.004058837890625, -0.0048828125, -0.004669189453125, -0.0045166015625, -0.00445556640625, -0.003753662109375, -0.002655029296875, -0.001953125, -0.00238037109375, -0.00244140625, -0.00213623046875, -0.00177001953125, -0.0023193359375, -0.00286865234375, -0.002227783203125, -0.001861572265625, -0.001007080078125, -0.000274658203125, -0.000244140625, -0.00079345703125, -0.001953125, -0.0029296875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -9.1552734375e-05, -0.0001220703125, 3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, -6.103515625e-05, 0.0001220703125, -0.000213623046875, 0.00030517578125, -0.00054931640625, 0.000640869140625, -0.00048828125, 0.00048828125, 0.00677490234375, 0.060882568359375, 0.050537109375, -0.061614990234375, -0.014312744140625, 0.006927490234375, -0.040069580078125, 0.053863525390625, 0.098785400390625, 0.05572509765625, 0.104034423828125, 0.204833984375, 0.088836669921875, -0.04400634765625, 0.023956298828125, -0.007171630859375, -0.11932373046875, -0.08306884765625, -0.05023193359375, -0.101531982421875, -0.086273193359375, -0.0230712890625, 0.00164794921875, -0.007110595703125, 0.0194091796875, 0.054840087890625, 0.046051025390625, 0.04547119140625, 0.059112548828125, 0.0338134765625, -0.000518798828125, -0.001922607421875, -0.0072021484375, -0.030303955078125, -0.039947509765625, -0.034759521484375, -0.044525146484375, -0.050933837890625, -0.0338134765625, -0.023712158203125, -0.02008056640625, -0.00848388671875, -0.000457763671875, 0.002471923828125, 0.002410888671875, 0.005035400390625, 0.0076904296875, 0.006134033203125, 0.003631591796875, 0.003936767578125, 0.001922607421875, -0.003326416015625, -0.00506591796875, -0.00811767578125, -0.01324462890625, -0.013397216796875, -0.01043701171875, -0.010589599609375, -0.009674072265625, -0.004852294921875, -0.001953125, -0.002838134765625, -0.001922607421875, -0.000213623046875, -0.000885009765625, -0.00238037109375, -0.001617431640625, -0.001495361328125, -0.004364013671875, -0.007080078125, -0.0059814453125, -0.005523681640625, -0.006439208984375, -0.004669189453125, -0.00341796875, -0.004425048828125, -0.00531005859375, -0.00421142578125, -0.003662109375, -0.003631591796875, -0.002593994140625, -0.001617431640625, -0.00201416015625, -0.001861572265625, -0.001129150390625, -0.00189208984375, -0.002716064453125, -0.002685546875, -0.00274658203125, -0.00360107421875, -0.003997802734375, -0.004608154296875, -0.00494384765625, -0.00396728515625, -0.003021240234375, -0.002655029296875, -0.002288818359375, -0.00238037109375, -0.002105712890625, -0.001739501953125, -0.002227783203125, -0.002197265625, -0.001495361328125, -0.0009765625, -0.00067138671875, -0.000518798828125, -0.000946044921875, -0.002288818359375, -0.00286865234375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -9.1552734375e-05, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, 3.0517578125e-05, -6.103515625e-05, 0.0, 3.0517578125e-05, -9.1552734375e-05, 3.0517578125e-05, -0.000152587890625, 6.103515625e-05, -0.00030517578125, 0.000579833984375, -0.000518798828125, 0.000701904296875, 0.00421142578125, 0.047149658203125, 0.051116943359375, -0.039154052734375, -0.017669677734375, 0.004425048828125, -0.032867431640625, 0.03436279296875, 0.082244873046875, 0.058013916015625, 0.0885009765625, 0.181304931640625, 0.108734130859375, -0.021392822265625, 0.0147705078125, 0.00689697265625, -0.089935302734375, -0.08941650390625, -0.05987548828125, -0.0867919921875, -0.079620361328125, -0.02618408203125, 0.003814697265625, -0.00531005859375, 0.015411376953125, 0.056671142578125, 0.052215576171875, 0.035980224609375, 0.041534423828125, 0.024169921875, -0.0006103515625, 0.002716064453125, -0.00042724609375, -0.025665283203125, -0.044891357421875, -0.04083251953125, -0.041229248046875, -0.044403076171875, -0.032379150390625, -0.02197265625, -0.01776123046875, -0.008758544921875, 6.103515625e-05, 0.002227783203125, 0.001312255859375, 0.00341796875, 0.0064697265625, 0.006622314453125, 0.00384521484375, 0.00347900390625, 0.001556396484375, -0.00360107421875, -0.005767822265625, -0.008544921875, -0.012847900390625, -0.013885498046875, -0.010284423828125, -0.00830078125, -0.00885009765625, -0.006622314453125, -0.003448486328125, -0.003631591796875, -0.00311279296875, -0.001129150390625, 3.0517578125e-05, -0.001373291015625, -0.00128173828125, -0.000640869140625, -0.003265380859375, -0.00634765625, -0.006744384765625, -0.005706787109375, -0.0067138671875, -0.00518798828125, -0.003631591796875, -0.004608154296875, -0.004608154296875, -0.004547119140625, -0.004364013671875, -0.004638671875, -0.003753662109375, -0.002410888671875, -0.0025634765625, -0.001861572265625, -0.0008544921875, -0.0001220703125, -0.0008544921875, -0.001800537109375, -0.002685546875, -0.003387451171875, -0.003936767578125, -0.0052490234375, -0.005401611328125, -0.004730224609375, -0.00347900390625, -0.00299072265625, -0.00244140625, -0.001983642578125, -0.00146484375, -0.000946044921875, -0.001373291015625, -0.00164794921875, -0.0013427734375, -0.00067138671875, -0.000732421875, -0.00164794921875, -0.00262451171875, -0.003082275390625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -9.1552734375e-05, -9.1552734375e-05, -6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, -0.000213623046875, 0.000152587890625, -0.000152587890625, -6.103515625e-05, -3.0517578125e-05, 0.00030517578125, -0.000244140625, 0.0006103515625, 0.0023193359375, 0.034576416015625, 0.050811767578125, -0.017486572265625, -0.0218505859375, 0.00152587890625, -0.025299072265625, 0.016387939453125, 0.068634033203125, 0.061279296875, 0.073944091796875, 0.156402587890625, 0.124969482421875, 0.001434326171875, 0.01361083984375, 0.01995849609375, -0.07965087890625, -0.100433349609375, -0.053741455078125, -0.0650634765625, -0.0731201171875, -0.029632568359375, 0.004852294921875, 0.003753662109375, 0.019775390625, 0.0479736328125, 0.03460693359375, 0.01885986328125, 0.0343017578125, 0.029693603515625, 0.006988525390625, -0.00018310546875, -0.00799560546875, -0.029754638671875, -0.04315185546875, -0.036590576171875, -0.0360107421875, -0.039703369140625, -0.028472900390625, -0.018402099609375, -0.017364501953125, -0.00836181640625, -0.000762939453125, -0.00030517578125, 0.0013427734375, 0.004241943359375, 0.00579833984375, 0.005523681640625, 0.003570556640625, 0.001983642578125, -0.0001220703125, -0.003875732421875, -0.006866455078125, -0.00958251953125, -0.012237548828125, -0.012725830078125, -0.01007080078125, -0.00860595703125, -0.00872802734375, -0.00653076171875, -0.00341796875, -0.003387451171875, -0.002655029296875, -0.000396728515625, 0.0, -0.00146484375, -0.00177001953125, -0.0015869140625, -0.003021240234375, -0.00653076171875, -0.007110595703125, -0.006103515625, -0.0062255859375, -0.005401611328125, -0.004608154296875, -0.004180908203125, -0.004913330078125, -0.004547119140625, -0.00439453125, -0.004913330078125, -0.004180908203125, -0.002471923828125, -0.001861572265625, -0.00177001953125, -9.1552734375e-05, 0.000518798828125, -0.000457763671875, -0.00164794921875, -0.002471923828125, -0.003570556640625, -0.005126953125, -0.005828857421875, -0.00567626953125, -0.00482177734375, -0.003875732421875, -0.002593994140625, -0.001617431640625, -0.0008544921875, -0.000579833984375, -0.001129150390625, -0.001556396484375, -0.001922607421875, -0.001068115234375, -0.000946044921875, -0.001708984375, -0.00250244140625, -0.00311279296875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, -6.103515625e-05, -6.103515625e-05, -9.1552734375e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, -9.1552734375e-05, -6.103515625e-05, 0.0001220703125, -0.000213623046875, 6.103515625e-05, 0.0001220703125, 0.000244140625, -9.1552734375e-05, 0.000732421875, 0.00067138671875, 0.023590087890625, 0.0489501953125, 0.002197265625, -0.024505615234375, -0.00323486328125, -0.01629638671875, 0.001617431640625, 0.05633544921875, 0.0633544921875, 0.0615234375, 0.133087158203125, 0.139556884765625, 0.03173828125, 0.001007080078125, 0.01129150390625, -0.0594482421875, -0.09033203125, -0.04638671875, -0.0491943359375, -0.0640869140625, -0.026458740234375, 0.012603759765625, 0.00665283203125, 0.002227783203125, 0.022308349609375, 0.026123046875, 0.023651123046875, 0.0347900390625, 0.027557373046875, 0.000701904296875, -0.011993408203125, -0.012664794921875, -0.022308349609375, -0.03631591796875, -0.0350341796875, -0.028961181640625, -0.0313720703125, -0.02685546875, -0.01678466796875, -0.01446533203125, -0.01043701171875, -0.003173828125, 0.00079345703125, 0.001983642578125, 0.003021240234375, 0.00482177734375, 0.00408935546875, 0.001373291015625, 0.0006103515625, -0.000823974609375, -0.005218505859375, -0.00897216796875, -0.009429931640625, -0.010894775390625, -0.01226806640625, -0.00982666015625, -0.007354736328125, -0.006622314453125, -0.005340576171875, -0.00244140625, -0.00244140625, -0.0032958984375, -0.00164794921875, -0.00103759765625, -0.002166748046875, -0.002532958984375, -0.0025634765625, -0.003570556640625, -0.0054931640625, -0.006195068359375, -0.0062255859375, -0.006561279296875, -0.006195068359375, -0.00439453125, -0.003662109375, -0.004425048828125, -0.004180908203125, -0.0040283203125, -0.004364013671875, -0.00360107421875, -0.002197265625, -0.0018310546875, -0.00177001953125, 6.103515625e-05, 0.0006103515625, -0.000732421875, -0.0023193359375, -0.003326416015625, -0.00396728515625, -0.00531005859375, -0.005706787109375, -0.005157470703125, -0.003875732421875, -0.002532958984375, -0.00177001953125, -0.0009765625, -0.001251220703125, -0.00177001953125, -0.001739501953125, -0.001434326171875, -0.001190185546875, -0.00103759765625, -0.000946044921875, -0.001739501953125, -0.002532958984375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0, 0.0, 0.0, -6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 0.0001220703125, -6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 0.000213623046875, 0.000152587890625, 0.000244140625, 0.0003662109375, 0.000213623046875, -0.000152587890625, 0.015380859375, 0.045074462890625, 0.018310546875, -0.02532958984375, -0.008148193359375, -0.008087158203125, -0.0079345703125, 0.043731689453125, 0.062957763671875, 0.059600830078125, 0.1202392578125, 0.13775634765625, 0.037017822265625, -0.005096435546875, 0.01959228515625, -0.03399658203125, -0.0799560546875, -0.043609619140625, -0.02752685546875, -0.04278564453125, -0.028167724609375, -0.003265380859375, -0.009674072265625, -0.009613037109375, 0.01953125, 0.030548095703125, 0.020751953125, 0.01971435546875, 0.0142822265625, -0.005035400390625, -0.01202392578125, -0.008880615234375, -0.017425537109375, -0.030670166015625, -0.0286865234375, -0.023101806640625, -0.02593994140625, -0.022552490234375, -0.016632080078125, -0.013916015625, -0.00927734375, -0.00299072265625, -3.0517578125e-05, 0.000335693359375, 0.001739501953125, 0.001556396484375, 0.001708984375, 0.000579833984375, -0.001251220703125, -0.003143310546875, -0.00701904296875, -0.00872802734375, -0.00860595703125, -0.0089111328125, -0.009521484375, -0.007843017578125, -0.0054931640625, -0.00537109375, -0.00433349609375, -0.003021240234375, -0.003570556640625, -0.004486083984375, -0.00323486328125, -0.001953125, -0.00250244140625, -0.0030517578125, -0.003143310546875, -0.003082275390625, -0.004974365234375, -0.006561279296875, -0.006439208984375, -0.006195068359375, -0.005340576171875, -0.003692626953125, -0.003082275390625, -0.003875732421875, -0.003753662109375, -0.003082275390625, -0.003448486328125, -0.003936767578125, -0.002655029296875, -0.001434326171875, -0.001678466796875, -0.0009765625, -0.000732421875, -0.001861572265625, -0.003326416015625, -0.003326416015625, -0.003326416015625, -0.00421142578125, -0.004302978515625, -0.003692626953125, -0.00262451171875, -0.002227783203125, -0.002471923828125, -0.002960205078125, -0.00250244140625, -0.001556396484375, -0.000946044921875, -0.000762939453125, -0.000885009765625, -0.00042724609375, -0.000640869140625, -0.001556396484375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, 6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0001220703125, -3.0517578125e-05, 0.000335693359375, 0.000396728515625, 3.0517578125e-05, -9.1552734375e-05, -0.0001220703125, 0.009674072265625, 0.03936767578125, 0.02899169921875, -0.022216796875, -0.0130615234375, -0.001953125, -0.01177978515625, 0.03277587890625, 0.07177734375, 0.0635986328125, 0.080413818359375, 0.11724853515625, 0.066314697265625, 0.00836181640625, 0.017791748046875, -0.016265869140625, -0.059051513671875, -0.02667236328125, -0.00927734375, -0.045166015625, -0.0523681640625, -0.020904541015625, -0.0023193359375, -0.001068115234375, 0.008758544921875, 0.01544189453125, 0.006256103515625, 0.0047607421875, 0.00933837890625, 0.00115966796875, -0.00927734375, -0.00946044921875, -0.01092529296875, -0.022216796875, -0.023895263671875, -0.0177001953125, -0.020263671875, -0.02197265625, -0.014404296875, -0.009368896484375, -0.009796142578125, -0.00592041015625, -0.002655029296875, -0.00201416015625, -0.0018310546875, -0.00177001953125, -0.000457763671875, -0.001678466796875, -0.003692626953125, -0.004638671875, -0.006103515625, -0.00634765625, -0.005828857421875, -0.0054931640625, -0.007293701171875, -0.007232666015625, -0.005096435546875, -0.00482177734375, -0.00531005859375, -0.00506591796875, -0.0042724609375, -0.00482177734375, -0.004119873046875, -0.00274658203125, -0.003173828125, -0.003570556640625, -0.00335693359375, -0.003936767578125, -0.005340576171875, -0.006072998046875, -0.005218505859375, -0.00445556640625, -0.004364013671875, -0.003326416015625, -0.002655029296875, -0.002685546875, -0.00323486328125, -0.003509521484375, -0.003631591796875, -0.00396728515625, -0.0028076171875, -0.002685546875, -0.002777099609375, -0.0028076171875, -0.0020751953125, -0.00177001953125, -0.00286865234375, -0.0023193359375, -0.001861572265625, -0.002410888671875, -0.003448486328125, -0.003570556640625, -0.003448486328125, -0.0040283203125, -0.003692626953125, -0.00286865234375, -0.001495361328125, -0.0010986328125, -0.00054931640625, -6.103515625e-05, 0.0, 0.000335693359375, -0.000457763671875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, 0.0, 9.1552734375e-05, -3.0517578125e-05, 0.0, 9.1552734375e-05, 0.0, 0.0, 0.000152587890625, 0.000396728515625, 0.0, 9.1552734375e-05, 0.000244140625, -0.00018310546875, 0.005706787109375, 0.03387451171875, 0.03350830078125, -0.017303466796875, -0.015533447265625, 0.002471923828125, -0.002532958984375, 0.03289794921875, 0.054595947265625, 0.044219970703125, 0.066162109375, 0.116973876953125, 0.087860107421875, 0.01605224609375, 0.0172119140625, 0.013336181640625, -0.02618408203125, -0.0306396484375, -0.0274658203125, -0.055419921875, -0.05126953125, -0.009185791015625, 0.000274658203125, -0.01849365234375, -0.015716552734375, 0.000701904296875, 0.000701904296875, 0.001953125, 0.00982666015625, 0.0032958984375, -0.005950927734375, -0.004974365234375, -0.005401611328125, -0.014190673828125, -0.018524169921875, -0.015899658203125, -0.015380859375, -0.01568603515625, -0.012420654296875, -0.010589599609375, -0.01165771484375, -0.009429931640625, -0.006591796875, -0.00567626953125, -0.0059814453125, -0.004730224609375, -0.002685546875, -0.002777099609375, -0.00433349609375, -0.003448486328125, -0.00238037109375, -0.0028076171875, -0.00347900390625, -0.0048828125, -0.006622314453125, -0.00677490234375, -0.00579833984375, -0.00592041015625, -0.006072998046875, -0.0050048828125, -0.0045166015625, -0.005706787109375, -0.005340576171875, -0.004150390625, -0.00360107421875, -0.00408935546875, -0.004364013671875, -0.004150390625, -0.00421142578125, -0.003936767578125, -0.003326416015625, -0.003265380859375, -0.003692626953125, -0.003082275390625, -0.00201416015625, -0.00274658203125, -0.003875732421875, -0.004241943359375, -0.004486083984375, -0.00482177734375, -0.004638671875, -0.003631591796875, -0.00341796875, -0.003082275390625, -0.001678466796875, -0.001251220703125, -0.001739501953125, -0.0015869140625, -0.00140380859375, -0.002655029296875, -0.003936767578125, -0.0045166015625, -0.0045166015625, -0.003631591796875, -0.00250244140625, -0.0018310546875, -0.001739501953125, -0.00091552734375, 0.000457763671875, 0.0009765625, 0.000946044921875, 0.000152587890625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 0.0, 3.0517578125e-05, 0.00018310546875, 6.103515625e-05, 9.1552734375e-05, 0.0001220703125, 0.000518798828125, -0.000213623046875, -3.0517578125e-05, 0.004486083984375, 0.02789306640625, 0.031494140625, -0.009979248046875, -0.007537841796875, 0.017974853515625, -0.00543212890625, -0.0003662109375, 0.046661376953125, 0.060028076171875, 0.062469482421875, 0.10125732421875, 0.097503662109375, 0.042266845703125, 0.034912109375, 0.02447509765625, -0.032440185546875, -0.0513916015625, -0.02984619140625, -0.030792236328125, -0.03717041015625, -0.02777099609375, -0.026275634765625, -0.034210205078125, -0.02410888671875, -0.00421142578125, -0.000640869140625, 0.000152587890625, 0.009521484375, 0.009490966796875, 0.00067138671875, -0.001617431640625, -0.001007080078125, -0.008544921875, -0.01434326171875, -0.010955810546875, -0.009674072265625, -0.014190673828125, -0.014739990234375, -0.01220703125, -0.01422119140625, -0.01373291015625, -0.01129150390625, -0.009246826171875, -0.008209228515625, -0.006378173828125, -0.0032958984375, -0.002471923828125, -0.0020751953125, -0.00042724609375, 0.0006103515625, -0.00146484375, -0.0032958984375, -0.0045166015625, -0.006683349609375, -0.00701904296875, -0.005859375, -0.005096435546875, -0.005828857421875, -0.00616455078125, -0.006103515625, -0.006622314453125, -0.0059814453125, -0.005218505859375, -0.0045166015625, -0.0040283203125, -0.003509521484375, -0.002960205078125, -0.00213623046875, -0.002349853515625, -0.002716064453125, -0.0023193359375, -0.00274658203125, -0.00323486328125, -0.002960205078125, -0.003387451171875, -0.005340576171875, -0.006011962890625, -0.00567626953125, -0.005340576171875, -0.004852294921875, -0.00347900390625, -0.002593994140625, -0.002532958984375, -0.00152587890625, -0.00128173828125, -0.0020751953125, -0.001953125, -0.001708984375, -0.002777099609375, -0.004180908203125, -0.004119873046875, -0.00299072265625, -0.002044677734375, -0.001800537109375, -0.001953125, -0.00152587890625, 0.0003662109375, 0.001861572265625, 0.0013427734375, 6.103515625e-05])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, 0.0, -3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, 3.0517578125e-05, -6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.000396728515625, 9.1552734375e-05, 0.00030517578125, 0.000213623046875, -9.1552734375e-05, 0.003936767578125, 0.022491455078125, 0.02935791015625, 0.014678955078125, 0.001922607421875, -0.0137939453125, -0.0137939453125, 0.015045166015625, 0.05108642578125, 0.060546875, 0.057403564453125, 0.094696044921875, 0.121856689453125, 0.068817138671875, 0.012481689453125, -0.005706787109375, -0.026763916015625, -0.027008056640625, -0.0133056640625, -0.03143310546875, -0.058929443359375, -0.055511474609375, -0.036285400390625, -0.032989501953125, -0.027069091796875, -0.0111083984375, -0.000457763671875, 0.006011962890625, 0.013214111328125, 0.01361083984375, 0.00567626953125, 0.001190185546875, 0.000640869140625, -0.00164794921875, -0.00823974609375, -0.01007080078125, -0.010162353515625, -0.0142822265625, -0.01629638671875, -0.015228271484375, -0.01727294921875, -0.017852783203125, -0.014007568359375, -0.010589599609375, -0.008819580078125, -0.00689697265625, -0.00286865234375, -0.0006103515625, 0.000457763671875, 0.00128173828125, 0.000701904296875, -0.000885009765625, -0.003509521484375, -0.00457763671875, -0.005340576171875, -0.00592041015625, -0.005645751953125, -0.00616455078125, -0.00677490234375, -0.00787353515625, -0.0074462890625, -0.00714111328125, -0.00653076171875, -0.0048828125, -0.003936767578125, -0.00286865234375, -0.00225830078125, -0.00146484375, -0.001434326171875, -0.001861572265625, -0.001708984375, -0.002166748046875, -0.003082275390625, -0.00439453125, -0.0045166015625, -0.005035400390625, -0.00640869140625, -0.006195068359375, -0.0054931640625, -0.00494384765625, -0.004364013671875, -0.00286865234375, -0.002349853515625, -0.0030517578125, -0.00238037109375, -0.001953125, -0.001678466796875, -0.001556396484375, -0.001922607421875, -0.00244140625, -0.00250244140625, -0.001922607421875, -0.00177001953125, -0.001739501953125, -0.00177001953125, -0.001434326171875, -0.000518798828125, 0.000946044921875, 0.0009765625, -0.00067138671875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, 0.0, 0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, -6.103515625e-05, 0.0001220703125, 0.0001220703125, 0.0, -0.000152587890625, 0.000274658203125, 0.00030517578125, 0.0001220703125, 0.00018310546875, 0.000762939453125, -0.00067138671875, 0.00030517578125, 0.006988525390625, 0.029937744140625, 0.03924560546875, -0.00299072265625, -0.020599365234375, 0.0006103515625, 0.01043701171875, 0.019073486328125, 0.041717529296875, 0.066314697265625, 0.08197021484375, 0.10345458984375, 0.10089111328125, 0.03790283203125, -0.011962890625, 0.006683349609375, 0.016143798828125, -0.01495361328125, -0.040283203125, -0.056884765625, -0.06695556640625, -0.057373046875, -0.03857421875, -0.034210205078125, -0.0291748046875, -0.00830078125, 0.006500244140625, 0.010284423828125, 0.0142822265625, 0.015411376953125, 0.00830078125, 0.004547119140625, 0.00494384765625, 0.000762939453125, -0.00811767578125, -0.011444091796875, -0.010589599609375, -0.01446533203125, -0.0185546875, -0.019134521484375, -0.0186767578125, -0.01776123046875, -0.014678955078125, -0.0111083984375, -0.009124755859375, -0.00616455078125, -0.00177001953125, 0.001373291015625, 0.0010986328125, 0.00054931640625, 0.001922607421875, -6.103515625e-05, -0.002349853515625, -0.003814697265625, -0.00457763671875, -0.00579833984375, -0.006805419921875, -0.006744384765625, -0.008575439453125, -0.0089111328125, -0.007171630859375, -0.005767822265625, -0.005279541015625, -0.004486083984375, -0.002685546875, -0.001708984375, -0.001251220703125, -0.001434326171875, -0.001251220703125, -0.00146484375, -0.002593994140625, -0.0028076171875, -0.003814697265625, -0.0052490234375, -0.005645751953125, -0.005523681640625, -0.005706787109375, -0.005615234375, -0.005157470703125, -0.005096435546875, -0.004638671875, -0.003204345703125, -0.002410888671875, -0.002960205078125, -0.0025634765625, -0.00146484375, -0.001007080078125, -0.000701904296875, -0.00042724609375, -0.000457763671875, -0.000579833984375, -0.001068115234375, -0.00140380859375, -0.00152587890625, -0.001556396484375, -0.001312255859375, -0.001068115234375, -0.0006103515625, -0.0013427734375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, -9.1552734375e-05, 0.000152587890625, 0.000152587890625, -0.0001220703125, 6.103515625e-05, 0.000244140625, 0.000457763671875, -0.000213623046875, 0.0006103515625, -3.0517578125e-05, -0.000152587890625, 0.000518798828125, 0.011505126953125, 0.030059814453125, 0.0098876953125, -0.004547119140625, 0.00738525390625, 0.01123046875, 0.0120849609375, 0.01007080078125, 0.0238037109375, 0.061279296875, 0.097869873046875, 0.08349609375, 0.05084228515625, 0.044281005859375, 0.028717041015625, 0.022003173828125, 0.034759521484375, 0.0120849609375, -0.041534423828125, -0.063873291015625, -0.058013916015625, -0.05816650390625, -0.05596923828125, -0.04364013671875, -0.030731201171875, -0.018402099609375, -0.003662109375, 0.007415771484375, 0.011871337890625, 0.013885498046875, 0.0150146484375, 0.011566162109375, 0.007598876953125, 0.00311279296875, -0.00213623046875, -0.00799560546875, -0.011199951171875, -0.012054443359375, -0.016693115234375, -0.0201416015625, -0.0185546875, -0.017181396484375, -0.0169677734375, -0.01507568359375, -0.011993408203125, -0.00830078125, -0.00537109375, -0.00177001953125, 0.00030517578125, 0.00213623046875, 0.002838134765625, 0.001953125, 0.00030517578125, -0.00262451171875, -0.003387451171875, -0.0048828125, -0.006805419921875, -0.008026123046875, -0.0081787109375, -0.007293701171875, -0.007537841796875, -0.00616455078125, -0.005340576171875, -0.004669189453125, -0.00323486328125, -0.002410888671875, -0.00164794921875, -0.002166748046875, -0.002166748046875, -0.0023193359375, -0.00213623046875, -0.00274658203125, -0.003662109375, -0.003814697265625, -0.005523681640625, -0.005645751953125, -0.005157470703125, -0.0057373046875, -0.006439208984375, -0.0064697265625, -0.0050048828125, -0.003997802734375, -0.0028076171875, -0.002410888671875, -0.0028076171875, -0.00140380859375, -0.000213623046875, 0.000701904296875, 0.001007080078125, 0.0009765625, 0.000396728515625, -0.00048828125, -0.001220703125, -0.00201416015625, -0.002532958984375, -0.002655029296875, -0.002655029296875, -0.002593994140625, -0.0023193359375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 0.0, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 9.1552734375e-05, 0.0001220703125, -9.1552734375e-05, 0.0, 0.00054931640625, 0.000274658203125, 0.000213623046875, -6.103515625e-05, -0.0003662109375, 3.0517578125e-05, 0.00653076171875, 0.026336669921875, 0.013427734375, -0.01727294921875, -0.005615234375, 0.024993896484375, 0.029296875, 0.01373291015625, 0.01336669921875, 0.03204345703125, 0.066680908203125, 0.076995849609375, 0.063323974609375, 0.038360595703125, 0.003387451171875, 0.024444580078125, 0.057647705078125, 0.045379638671875, 0.01776123046875, -0.01611328125, -0.049774169921875, -0.059783935546875, -0.049896240234375, -0.050994873046875, -0.05279541015625, -0.0380859375, -0.02020263671875, -0.011871337890625, -0.0042724609375, 0.00579833984375, 0.01092529296875, 0.0137939453125, 0.01397705078125, 0.0106201171875, 0.006500244140625, -0.0003662109375, -0.004547119140625, -0.007568359375, -0.011505126953125, -0.014007568359375, -0.0159912109375, -0.017364501953125, -0.01727294921875, -0.015838623046875, -0.015869140625, -0.015289306640625, -0.0126953125, -0.009124755859375, -0.00494384765625, -0.001007080078125, 0.00250244140625, 0.00274658203125, 0.001739501953125, 0.001556396484375, 9.1552734375e-05, -0.00164794921875, -0.00494384765625, -0.006072998046875, -0.006195068359375, -0.006317138671875, -0.006317138671875, -0.006805419921875, -0.006500244140625, -0.0057373046875, -0.004547119140625, -0.0037841796875, -0.00347900390625, -0.003570556640625, -0.00347900390625, -0.003173828125, -0.002716064453125, -0.001953125, -0.0023193359375, -0.00323486328125, -0.003204345703125, -0.00384521484375, -0.00518798828125, -0.006378173828125, -0.00677490234375, -0.006866455078125, -0.006378173828125, -0.004852294921875, -0.00396728515625, -0.003692626953125, -0.002716064453125, -0.00146484375, -0.000518798828125, 0.00042724609375, 0.0015869140625, 0.0020751953125, 0.001739501953125, 0.000762939453125, -0.000579833984375, -0.0018310546875, -0.002777099609375, -0.003265380859375, -0.00372314453125, -0.00384521484375, -0.00347900390625, -0.003082275390625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 0.0, 0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, -3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0, 6.103515625e-05, 0.0, 6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.00042724609375, 0.0001220703125, 0.000701904296875, -0.000762939453125, -0.000640869140625, 0.002960205078125, 0.0245361328125, 0.024383544921875, -0.019683837890625, -0.018890380859375, 0.012969970703125, 0.020843505859375, 0.027587890625, 0.0281982421875, 0.029266357421875, 0.05908203125, 0.06707763671875, 0.045257568359375, 0.032196044921875, 0.032196044921875, 0.005615234375, -0.01806640625, 0.032806396484375, 0.06207275390625, 0.0318603515625, 0.001190185546875, -0.0223388671875, -0.042022705078125, -0.046661376953125, -0.04119873046875, -0.043304443359375, -0.0408935546875, -0.030059814453125, -0.017059326171875, -0.012542724609375, -0.007232666015625, 0.00567626953125, 0.008880615234375, 0.009124755859375, 0.010223388671875, 0.008544921875, 0.00311279296875, -0.00360107421875, -0.006500244140625, -0.006683349609375, -0.009307861328125, -0.0126953125, -0.0142822265625, -0.0152587890625, -0.014129638671875, -0.015228271484375, -0.017333984375, -0.016571044921875, -0.0125732421875, -0.006805419921875, -0.00323486328125, -0.0010986328125, 0.000762939453125, 0.001983642578125, 0.001556396484375, 0.000823974609375, -0.001007080078125, -0.003173828125, -0.0030517578125, -0.00347900390625, -0.004608154296875, -0.00604248046875, -0.006317138671875, -0.00543212890625, -0.0059814453125, -0.0059814453125, -0.005218505859375, -0.005218505859375, -0.005401611328125, -0.0048828125, -0.00372314453125, -0.00323486328125, -0.0025634765625, -0.001953125, -0.002166748046875, -0.00323486328125, -0.004425048828125, -0.00494384765625, -0.00677490234375, -0.007171630859375, -0.006195068359375, -0.005889892578125, -0.005157470703125, -0.004180908203125, -0.002716064453125, -0.0025634765625, -0.001434326171875, 0.000518798828125, 0.001129150390625, 0.00189208984375, 0.002105712890625, 0.00146484375, -0.000396728515625, -0.00146484375, -0.002471923828125, -0.00372314453125, -0.00421142578125, -0.004302978515625, -0.004364013671875, -0.00445556640625, -0.003387451171875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, 0.0, 0.0, 9.1552734375e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, 0.0, 0.000152587890625, -6.103515625e-05, 0.0001220703125, -0.000213623046875, 0.000335693359375, -3.0517578125e-05, 0.0006103515625, -3.0517578125e-05, -0.000152587890625, -0.00018310546875, 0.0189208984375, 0.03594970703125, -0.01092529296875, -0.032501220703125, 0.0028076171875, 0.022247314453125, 0.021270751953125, 0.01824951171875, 0.03826904296875, 0.07080078125, 0.07452392578125, 0.04571533203125, 0.020904541015625, 0.016876220703125, 0.018280029296875, 0.000335693359375, -0.025421142578125, -0.013092041015625, 0.027252197265625, 0.045135498046875, 0.02886962890625, 0.003509521484375, -0.01580810546875, -0.029296875, -0.03143310546875, -0.030487060546875, -0.032379150390625, -0.032989501953125, -0.029510498046875, -0.02154541015625, -0.012664794921875, -0.005767822265625, -0.00067138671875, 0.002655029296875, 0.00506591796875, 0.006439208984375, 0.00372314453125, -0.000213623046875, -0.003997802734375, -0.00384521484375, -0.003265380859375, -0.007904052734375, -0.010284423828125, -0.010833740234375, -0.01312255859375, -0.015960693359375, -0.0166015625, -0.015716552734375, -0.013885498046875, -0.010711669921875, -0.007843017578125, -0.005096435546875, -0.0018310546875, 0.000823974609375, 0.000762939453125, -0.000396728515625, 0.000457763671875, 0.001251220703125, 3.0517578125e-05, -0.00201416015625, -0.003204345703125, -0.00421142578125, -0.00531005859375, -0.005462646484375, -0.00579833984375, -0.007232666015625, -0.00823974609375, -0.006866455078125, -0.00543212890625, -0.005462646484375, -0.004791259765625, -0.003692626953125, -0.00286865234375, -0.00201416015625, -0.00213623046875, -0.003997802734375, -0.00592041015625, -0.0054931640625, -0.004730224609375, -0.005401611328125, -0.006072998046875, -0.0059814453125, -0.00469970703125, -0.00299072265625, -0.001678466796875, -0.001251220703125, -0.00140380859375, -0.000244140625, 0.00152587890625, 0.00201416015625, 0.001129150390625, -0.000457763671875, -0.001617431640625, -0.002471923828125, -0.0028076171875, -0.00390625, -0.00482177734375, -0.0047607421875, -0.004486083984375, -0.003753662109375, -0.003021240234375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 9.1552734375e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, 0.0, 9.1552734375e-05, -3.0517578125e-05, 3.0517578125e-05, 0.000152587890625, -6.103515625e-05, 0.000213623046875, -3.0517578125e-05, 0.0001220703125, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0003662109375, 0.0003662109375, 0.0, -0.0003662109375, 0.01239013671875, 0.04180908203125, 0.00482177734375, -0.041351318359375, -0.0084228515625, 0.019866943359375, 0.02069091796875, 0.020111083984375, 0.03045654296875, 0.065032958984375, 0.09234619140625, 0.0623779296875, 0.016326904296875, 0.010498046875, 0.015228271484375, 0.000152587890625, -0.0189208984375, -0.027008056640625, -0.028656005859375, -0.01287841796875, 0.02117919921875, 0.042572021484375, 0.035980224609375, 0.013763427734375, -0.004913330078125, -0.01409912109375, -0.0169677734375, -0.022125244140625, -0.029754638671875, -0.035430908203125, -0.03131103515625, -0.0186767578125, -0.015350341796875, -0.013427734375, -0.0054931640625, -0.0015869140625, -0.000885009765625, 0.00128173828125, 0.002777099609375, 0.0018310546875, -0.000396728515625, -0.0008544921875, -0.001129150390625, -0.004058837890625, -0.00830078125, -0.011566162109375, -0.013519287109375, -0.013946533203125, -0.01373291015625, -0.014678955078125, -0.014678955078125, -0.012725830078125, -0.0084228515625, -0.004730224609375, -0.00250244140625, -0.00018310546875, 0.00164794921875, 0.0020751953125, 0.002288818359375, 0.002044677734375, 0.000885009765625, -0.0008544921875, -0.0029296875, -0.003997802734375, -0.00506591796875, -0.0072021484375, -0.008331298828125, -0.00848388671875, -0.008209228515625, -0.00653076171875, -0.005096435546875, -0.0047607421875, -0.004608154296875, -0.003143310546875, -0.002838134765625, -0.004150390625, -0.00482177734375, -0.005035400390625, -0.004486083984375, -0.00396728515625, -0.00384521484375, -0.004669189453125, -0.004852294921875, -0.00323486328125, -0.001678466796875, -0.000823974609375, -0.000701904296875, -0.000518798828125, -0.000396728515625, 0.000244140625, 0.000274658203125, -0.000579833984375, -0.00177001953125, -0.0028076171875, -0.002838134765625, -0.003021240234375, -0.00384521484375, -0.004730224609375, -0.0045166015625, -0.003387451171875, -0.002471923828125, -0.00201416015625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, 6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 9.1552734375e-05, 0.0, 0.00048828125, 9.1552734375e-05, 6.103515625e-05, 0.005706787109375, 0.043853759765625, 0.025360107421875, -0.04736328125, -0.024078369140625, 0.021331787109375, 0.020416259765625, 0.01593017578125, 0.02899169921875, 0.0699462890625, 0.10089111328125, 0.068328857421875, 0.020355224609375, 0.010711669921875, 0.0084228515625, 0.001068115234375, -0.018707275390625, -0.03399658203125, -0.032745361328125, -0.032470703125, -0.02447509765625, -0.00396728515625, 0.02679443359375, 0.048187255859375, 0.043304443359375, 0.026031494140625, 0.009979248046875, -0.00439453125, -0.0140380859375, -0.024932861328125, -0.03338623046875, -0.03173828125, -0.031097412109375, -0.026275634765625, -0.0213623046875, -0.016998291015625, -0.011077880859375, -0.007537841796875, -0.003692626953125, 0.002593994140625, 0.00628662109375, 0.0045166015625, 0.00299072265625, 0.001495361328125, 0.00030517578125, -0.003204345703125, -0.0074462890625, -0.009796142578125, -0.0120849609375, -0.013519287109375, -0.0155029296875, -0.01715087890625, -0.01556396484375, -0.0126953125, -0.007843017578125, -0.00274658203125, -0.00079345703125, 0.00042724609375, 0.002166748046875, 0.00286865234375, 0.00347900390625, 0.00274658203125, 0.000396728515625, -0.00128173828125, -0.003143310546875, -0.00567626953125, -0.0078125, -0.008392333984375, -0.0087890625, -0.008819580078125, -0.007598876953125, -0.0057373046875, -0.004913330078125, -0.00531005859375, -0.005462646484375, -0.005096435546875, -0.00469970703125, -0.004180908203125, -0.004302978515625, -0.003997802734375, -0.003387451171875, -0.002838134765625, -0.002471923828125, -0.002593994140625, -0.00177001953125, -0.001434326171875, -0.0009765625, -0.00048828125, -0.000701904296875, -0.00115966796875, -0.0020751953125, -0.002655029296875, -0.003143310546875, -0.002960205078125, -0.00323486328125, -0.00360107421875, -0.003662109375, -0.003875732421875, -0.003387451171875, -0.002899169921875, -0.002288818359375, -0.00189208984375, -0.00164794921875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 0.0, 0.00018310546875, -6.103515625e-05, 0.000335693359375, -0.00030517578125, 0.000701904296875, -0.000335693359375, 0.0009765625, 0.0015869140625, 0.038543701171875, 0.04833984375, -0.0419921875, -0.0477294921875, 0.01861572265625, 0.0263671875, 0.01409912109375, 0.022613525390625, 0.0703125, 0.118682861328125, 0.086944580078125, 0.019256591796875, 0.0003662109375, 0.0057373046875, 0.00469970703125, -0.024627685546875, -0.04351806640625, -0.0345458984375, -0.0367431640625, -0.03271484375, -0.02227783203125, -0.00762939453125, 0.01263427734375, 0.03338623046875, 0.053466796875, 0.054931640625, 0.035919189453125, 0.01153564453125, -0.009002685546875, -0.020782470703125, -0.021759033203125, -0.0308837890625, -0.04034423828125, -0.03643798828125, -0.02911376953125, -0.025848388671875, -0.021270751953125, -0.014190673828125, -0.006927490234375, 0.00115966796875, 0.00732421875, 0.00762939453125, 0.004974365234375, 0.006622314453125, 0.004730224609375, 0.00091552734375, -0.003204345703125, -0.006378173828125, -0.0093994140625, -0.0142822265625, -0.016876220703125, -0.0181884765625, -0.016998291015625, -0.012786865234375, -0.007781982421875, -0.005096435546875, -0.003997802734375, -0.000762939453125, 0.002685546875, 0.0037841796875, 0.00347900390625, 0.002716064453125, 0.001617431640625, -0.0008544921875, -0.0025634765625, -0.004058837890625, -0.0069580078125, -0.00897216796875, -0.009063720703125, -0.008575439453125, -0.007720947265625, -0.007293701171875, -0.0067138671875, -0.00714111328125, -0.0067138671875, -0.00506591796875, -0.00390625, -0.003875732421875, -0.00408935546875, -0.00286865234375, -0.001922607421875, -0.00115966796875, -0.000701904296875, -0.00067138671875, -0.00091552734375, -0.0008544921875, -0.00067138671875, -0.001220703125, -0.002105712890625, -0.00311279296875, -0.003875732421875, -0.004486083984375, -0.004913330078125, -0.00433349609375, -0.003997802734375, -0.00408935546875, -0.003082275390625, -0.00189208984375, -0.00164794921875, -0.001678466796875, -0.001220703125, -0.00079345703125, -0.00091552734375])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 0.0, 0.0, -3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0001220703125, -9.1552734375e-05, 0.000335693359375, -0.0001220703125, 0.000396728515625, -0.000213623046875, 0.000579833984375, -0.00018310546875, 0.001007080078125, 0.0, 0.02935791015625, 0.06732177734375, -0.0242919921875, -0.073394775390625, 0.008331298828125, 0.034454345703125, 0.014678955078125, 0.01751708984375, 0.068939208984375, 0.1326904296875, 0.10736083984375, 0.02789306640625, -0.00238037109375, -0.001495361328125, -0.00250244140625, -0.0244140625, -0.04998779296875, -0.050872802734375, -0.04168701171875, -0.031280517578125, -0.027099609375, -0.016326904296875, 0.00244140625, 0.009765625, 0.0203857421875, 0.04681396484375, 0.062103271484375, 0.050201416015625, 0.02740478515625, 0.001678466796875, -0.010406494140625, -0.017547607421875, -0.029510498046875, -0.040313720703125, -0.04345703125, -0.03729248046875, -0.03204345703125, -0.02899169921875, -0.0211181640625, -0.00616455078125, -0.00048828125, 0.001739501953125, 0.0087890625, 0.012054443359375, 0.0101318359375, 0.00567626953125, 0.003448486328125, 0.001220703125, -0.00421142578125, -0.007843017578125, -0.013885498046875, -0.01751708984375, -0.015716552734375, -0.013671875, -0.01275634765625, -0.012176513671875, -0.008331298828125, -0.00360107421875, -0.000274658203125, 0.00067138671875, 0.002716064453125, 0.003814697265625, 0.002166748046875, 0.00079345703125, -0.000213623046875, -0.000640869140625, -0.0023193359375, -0.005859375, -0.008270263671875, -0.00946044921875, -0.0089111328125, -0.00848388671875, -0.009307861328125, -0.00909423828125, -0.00726318359375, -0.005584716796875, -0.005096435546875, -0.00421142578125, -0.002960205078125, -0.00189208984375, -0.00140380859375, -0.0008544921875, 3.0517578125e-05, 0.000640869140625, 0.000640869140625, 3.0517578125e-05, -0.000732421875, -0.00152587890625, -0.002777099609375, -0.003936767578125, -0.005126953125, -0.0057373046875, -0.005401611328125, -0.005615234375, -0.005523681640625, -0.004364013671875, -0.0028076171875, -0.00146484375, -0.0006103515625, -0.000335693359375, -0.00030517578125, -9.1552734375e-05, -9.1552734375e-05, -0.00042724609375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, 9.1552734375e-05, 0.0, 9.1552734375e-05, -6.103515625e-05, 0.000213623046875, -0.000152587890625, 0.000213623046875, -0.0001220703125, 0.000244140625, 0.000213623046875, 0.0003662109375, 0.000274658203125, 0.018890380859375, 0.078826904296875, 0.004638671875, -0.09539794921875, -0.013885498046875, 0.043853759765625, 0.01910400390625, 0.01251220703125, 0.06591796875, 0.14837646484375, 0.129150390625, 0.0335693359375, -0.001922607421875, -0.00390625, -0.00616455078125, -0.02545166015625, -0.06365966796875, -0.064208984375, -0.046783447265625, -0.042083740234375, -0.032501220703125, -0.014984130859375, 0.00146484375, 0.007568359375, 0.012725830078125, 0.027008056640625, 0.0380859375, 0.04345703125, 0.04840087890625, 0.033538818359375, 0.0177001953125, 0.00408935546875, -0.01947021484375, -0.0303955078125, -0.03509521484375, -0.0418701171875, -0.044342041015625, -0.04022216796875, -0.03118896484375, -0.020355224609375, -0.01263427734375, -0.002960205078125, 0.003265380859375, 0.01019287109375, 0.01263427734375, 0.00848388671875, 0.00726318359375, 0.006103515625, 0.002227783203125, -0.004180908203125, -0.007965087890625, -0.009979248046875, -0.0111083984375, -0.013580322265625, -0.015045166015625, -0.015045166015625, -0.01348876953125, -0.0078125, -0.004058837890625, -0.002685546875, -0.00018310546875, 0.001373291015625, 0.001312255859375, 0.00054931640625, 0.001739501953125, 0.002044677734375, 0.000244140625, -0.00250244140625, -0.005157470703125, -0.008026123046875, -0.009857177734375, -0.0098876953125, -0.0106201171875, -0.010101318359375, -0.00885009765625, -0.007171630859375, -0.005859375, -0.004974365234375, -0.00341796875, -0.00177001953125, -0.0003662109375, -0.000213623046875, -0.000274658203125, 0.000732421875, 0.001312255859375, 0.00103759765625, 0.00030517578125, -0.001312255859375, -0.00372314453125, -0.00543212890625, -0.006500244140625, -0.0067138671875, -0.006591796875, -0.006591796875, -0.0059814453125, -0.004730224609375, -0.002960205078125, -0.001678466796875, -0.0010986328125, -0.0006103515625, 0.000396728515625, 0.00091552734375, 0.000335693359375, -0.0003662109375, -0.000396728515625])
        IR_LEFT[len(IR_LEFT)-1].append([6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 6.103515625e-05, -6.103515625e-05, 0.000213623046875, 0.0001220703125, -0.000152587890625, 0.000274658203125, -0.000335693359375, 0.000823974609375, -0.00030517578125, 0.001373291015625, 0.009918212890625, 0.081329345703125, 0.04022216796875, -0.106658935546875, -0.046966552734375, 0.04925537109375, 0.027679443359375, 0.009246826171875, 0.0631103515625, 0.16278076171875, 0.152587890625, 0.041961669921875, -0.001922607421875, -0.007110595703125, -0.011383056640625, -0.0223388671875, -0.0687255859375, -0.081695556640625, -0.06072998046875, -0.047393798828125, -0.035888671875, -0.027435302734375, -0.000213623046875, 0.016998291015625, 0.0107421875, 0.02593994140625, 0.038970947265625, 0.026885986328125, 0.025421142578125, 0.030548095703125, 0.03216552734375, 0.026885986328125, 0.006744384765625, -0.011932373046875, -0.028076171875, -0.033294677734375, -0.03662109375, -0.04486083984375, -0.045074462890625, -0.03094482421875, -0.0185546875, -0.01312255859375, -0.00347900390625, 0.005096435546875, 0.00799560546875, 0.007598876953125, 0.00927734375, 0.009124755859375, 0.00347900390625, 0.000213623046875, -0.000244140625, -0.003814697265625, -0.0067138671875, -0.009552001953125, -0.0123291015625, -0.0140380859375, -0.014495849609375, -0.011993408203125, -0.00787353515625, -0.00604248046875, -0.004180908203125, -0.00189208984375, -0.00146484375, -0.000762939453125, 0.00189208984375, 0.004058837890625, 0.002777099609375, -0.00030517578125, -0.002655029296875, -0.005889892578125, -0.009246826171875, -0.00970458984375, -0.009979248046875, -0.0103759765625, -0.0098876953125, -0.008148193359375, -0.006988525390625, -0.00537109375, -0.003662109375, -0.002471923828125, -0.001495361328125, 0.00030517578125, 0.00140380859375, 0.0009765625, 0.001220703125, 0.00146484375, 0.00091552734375, -0.001007080078125, -0.00341796875, -0.005950927734375, -0.007781982421875, -0.008331298828125, -0.00750732421875, -0.006317138671875, -0.00555419921875, -0.00457763671875, -0.003326416015625, -0.00201416015625, -0.000946044921875, -0.00054931640625, -0.000396728515625, 0.00018310546875, 0.00091552734375, 0.000823974609375, 0.000213623046875, -0.00048828125])
        IR_LEFT[len(IR_LEFT)-1].append([0.000152587890625, 3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 0.0, -6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 0.0, 9.1552734375e-05, -0.0001220703125, 0.00042724609375, -0.000335693359375, 0.00054931640625, -0.000640869140625, 0.001129150390625, -0.00091552734375, 0.002288818359375, 0.00396728515625, 0.07611083984375, 0.0760498046875, -0.103912353515625, -0.08673095703125, 0.0469970703125, 0.039031982421875, 0.00714111328125, 0.060882568359375, 0.178314208984375, 0.1767578125, 0.04913330078125, 0.0003662109375, -0.00567626953125, -0.021942138671875, -0.0244140625, -0.068572998046875, -0.09423828125, -0.0714111328125, -0.056732177734375, -0.045989990234375, -0.03253173828125, -0.00335693359375, 0.0150146484375, 0.011260986328125, 0.029571533203125, 0.044677734375, 0.031768798828125, 0.02203369140625, 0.0150146484375, 0.01263427734375, 0.023284912109375, 0.01690673828125, 0.004302978515625, -0.005096435546875, -0.01824951171875, -0.0301513671875, -0.0394287109375, -0.042388916015625, -0.034271240234375, -0.02691650390625, -0.018646240234375, -0.01055908203125, -0.004425048828125, 0.0035400390625, 0.005218505859375, 0.005859375, 0.006439208984375, 0.00592041015625, 0.005096435546875, 0.003265380859375, -0.002471923828125, -0.00445556640625, -0.00457763671875, -0.00677490234375, -0.009857177734375, -0.013458251953125, -0.011383056640625, -0.008880615234375, -0.009857177734375, -0.00860595703125, -0.005859375, -0.00360107421875, -0.002288818359375, -0.000152587890625, 0.0030517578125, 0.003631591796875, 0.00146484375, -0.00128173828125, -0.004058837890625, -0.007781982421875, -0.008636474609375, -0.009033203125, -0.009765625, -0.009521484375, -0.00823974609375, -0.0064697265625, -0.006072998046875, -0.005035400390625, -0.003326416015625, -0.0018310546875, -0.000274658203125, 0.000518798828125, 0.001617431640625, 0.002197265625, 0.00189208984375, 0.000946044921875, -0.00140380859375, -0.004058837890625, -0.006591796875, -0.007965087890625, -0.00836181640625, -0.007476806640625, -0.00634765625, -0.00537109375, -0.0045166015625, -0.003509521484375, -0.001983642578125, -0.0008544921875, -0.000701904296875, -0.0009765625, -0.00067138671875, 0.000213623046875, 0.000823974609375, 0.00054931640625, -0.000274658203125, -0.000640869140625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, -6.103515625e-05, -9.1552734375e-05, -6.103515625e-05, 0.0, -3.0517578125e-05, -0.0001220703125, -9.1552734375e-05, 0.0001220703125, -0.000152587890625, 9.1552734375e-05, -0.00030517578125, 0.000396728515625, -0.00048828125, 0.00054931640625, -0.00079345703125, 0.001068115234375, -0.00115966796875, 0.00238037109375, 0.001007080078125, 0.0665283203125, 0.107086181640625, -0.088134765625, -0.12786865234375, 0.0360107421875, 0.052032470703125, 0.005645751953125, 0.05841064453125, 0.196441650390625, 0.20166015625, 0.054168701171875, 0.002593994140625, 0.0001220703125, -0.03082275390625, -0.0313720703125, -0.071533203125, -0.10723876953125, -0.07891845703125, -0.060882568359375, -0.05450439453125, -0.041839599609375, -0.012237548828125, 0.0201416015625, 0.0126953125, 0.02093505859375, 0.051116943359375, 0.042022705078125, 0.02313232421875, 0.018280029296875, 0.009002685546875, 0.00634765625, 0.00128173828125, 0.0008544921875, 0.00079345703125, -0.005401611328125, -0.013519287109375, -0.027618408203125, -0.036285400390625, -0.028350830078125, -0.021148681640625, -0.02349853515625, -0.01837158203125, -0.00897216796875, -0.001129150390625, -0.0006103515625, -0.000213623046875, 0.005950927734375, 0.008026123046875, 0.0037841796875, 0.001556396484375, -0.0010986328125, -0.002899169921875, -0.002471923828125, -0.004364013671875, -0.007049560546875, -0.008148193359375, -0.00823974609375, -0.00872802734375, -0.010833740234375, -0.01092529296875, -0.0068359375, -0.005035400390625, -0.004608154296875, -0.002685546875, 0.00079345703125, 0.0020751953125, -0.00054931640625, -0.001617431640625, -0.002044677734375, -0.00579833984375, -0.007843017578125, -0.00799560546875, -0.008392333984375, -0.008544921875, -0.007080078125, -0.006500244140625, -0.006866455078125, -0.00567626953125, -0.00335693359375, -0.001800537109375, -0.001556396484375, -6.103515625e-05, 0.00103759765625, 0.001861572265625, 0.001739501953125, 0.00018310546875, -0.002166748046875, -0.005157470703125, -0.00750732421875, -0.008331298828125, -0.0078125, -0.006591796875, -0.0052490234375, -0.004638671875, -0.004669189453125, -0.004058837890625, -0.002593994140625, -0.0010986328125, -0.001007080078125, -0.0013427734375, -0.0013427734375, -0.00103759765625, 0.000152587890625, 0.00030517578125, -0.000701904296875, -0.001251220703125, -0.00115966796875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -9.1552734375e-05, -6.103515625e-05, -0.0001220703125, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, -0.0001220703125, 0.0001220703125, -0.0001220703125, 0.00018310546875, -0.000335693359375, 0.0003662109375, -0.000518798828125, 0.000457763671875, -0.00079345703125, 0.0009765625, -0.0009765625, 0.001708984375, 0.00030517578125, 0.055145263671875, 0.13067626953125, -0.06060791015625, -0.16583251953125, 0.01470947265625, 0.066497802734375, 0.0062255859375, 0.052825927734375, 0.2159423828125, 0.230621337890625, 0.056304931640625, 0.00323486328125, 0.011322021484375, -0.037628173828125, -0.040771484375, -0.0732421875, -0.122772216796875, -0.09173583984375, -0.061248779296875, -0.05950927734375, -0.048980712890625, -0.0186767578125, 0.019744873046875, 0.01263427734375, 0.01885986328125, 0.0538330078125, 0.04473876953125, 0.025909423828125, 0.022552490234375, 0.01239013671875, 0.00701904296875, -0.00390625, -0.01300048828125, -0.011688232421875, -0.01422119140625, -0.011749267578125, -0.01220703125, -0.021728515625, -0.01983642578125, -0.015411376953125, -0.016143798828125, -0.014984130859375, -0.013519287109375, -0.005767822265625, -0.003387451171875, -0.00177001953125, 0.005157470703125, 0.004302978515625, -0.001373291015625, 0.00030517578125, 0.000244140625, -0.003326416015625, -0.004302978515625, -0.004302978515625, -0.00341796875, -0.00653076171875, -0.008056640625, -0.005859375, -0.007598876953125, -0.00885009765625, -0.0062255859375, -0.0047607421875, -0.00494384765625, -0.004486083984375, -0.00140380859375, -0.001068115234375, -0.00286865234375, -0.003173828125, -0.00335693359375, -0.006134033203125, -0.006683349609375, -0.005615234375, -0.006622314453125, -0.006683349609375, -0.006378173828125, -0.00634765625, -0.00726318359375, -0.00537109375, -0.002197265625, -0.00152587890625, -0.000823974609375, 0.00018310546875, 0.000244140625, 0.000244140625, -6.103515625e-05, -0.00103759765625, -0.003936767578125, -0.006195068359375, -0.00726318359375, -0.00811767578125, -0.0076904296875, -0.00592041015625, -0.004058837890625, -0.003387451171875, -0.00335693359375, -0.0035400390625, -0.00311279296875, -0.001678466796875, -0.001007080078125, -0.00189208984375, -0.002105712890625, -0.001739501953125, -0.000885009765625, -0.0001220703125, -0.00067138671875, -0.001953125, -0.002349853515625, -0.001678466796875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, -6.103515625e-05, -9.1552734375e-05, 0.000152587890625, -6.103515625e-05, 0.000213623046875, -0.000335693359375, 0.000396728515625, -0.00042724609375, 0.000396728515625, -0.00054931640625, 0.000579833984375, -0.000213623046875, 0.000823974609375, 0.000701904296875, 0.045257568359375, 0.145233154296875, -0.02691650390625, -0.19439697265625, -0.016387939453125, 0.0791015625, 0.01123046875, 0.045928955078125, 0.23370361328125, 0.264404296875, 0.05828857421875, -0.002197265625, 0.026947021484375, -0.039520263671875, -0.05316162109375, -0.07476806640625, -0.13555908203125, -0.109039306640625, -0.06396484375, -0.06268310546875, -0.056304931640625, -0.023468017578125, 0.022979736328125, 0.01708984375, 0.011474609375, 0.053131103515625, 0.05364990234375, 0.026397705078125, 0.02032470703125, 0.01556396484375, 0.008392333984375, -0.00140380859375, -0.011474609375, -0.021575927734375, -0.02630615234375, -0.019317626953125, -0.019134521484375, -0.024169921875, -0.011260986328125, 0.00152587890625, -0.006011962890625, -0.010528564453125, -0.008026123046875, -0.00286865234375, 0.001129150390625, 0.000732421875, -0.001312255859375, -0.001495361328125, -0.00299072265625, -0.00177001953125, -0.0018310546875, -0.006988525390625, -0.005889892578125, -0.0040283203125, -0.004974365234375, -0.008026123046875, -0.00787353515625, -0.003662109375, -0.00360107421875, -0.005645751953125, -0.002716064453125, -0.000701904296875, -0.00396728515625, -0.005767822265625, -0.003265380859375, -0.00146484375, -0.004150390625, -0.006622314453125, -0.005523681640625, -0.00677490234375, -0.00738525390625, -0.00494384765625, -0.004791259765625, -0.005706787109375, -0.00555419921875, -0.00543212890625, -0.0064697265625, -0.005157470703125, -0.00091552734375, 0.0010986328125, 0.00103759765625, 0.000579833984375, 0.0, -0.00091552734375, -0.002593994140625, -0.003936767578125, -0.00482177734375, -0.00567626953125, -0.00750732421875, -0.00823974609375, -0.006988525390625, -0.0054931640625, -0.003814697265625, -0.002777099609375, -0.002105712890625, -0.00201416015625, -0.001617431640625, -0.001312255859375, -0.001556396484375, -0.001953125, -0.002105712890625, -0.002288818359375, -0.001953125, -0.000762939453125, -0.000701904296875, -0.00201416015625, -0.0029296875, -0.0028076171875, -0.0018310546875])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -9.1552734375e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -0.000152587890625, 9.1552734375e-05, -0.0001220703125, 0.000152587890625, -0.00030517578125, 0.000244140625, -0.00030517578125, 0.000152587890625, -0.0003662109375, 9.1552734375e-05, 0.00018310546875, 0.000244140625, 0.0008544921875, 0.0382080078125, 0.1522216796875, 0.0059814453125, -0.209625244140625, -0.053955078125, 0.084930419921875, 0.020965576171875, 0.0394287109375, 0.248748779296875, 0.298858642578125, 0.0648193359375, -0.012542724609375, 0.039337158203125, -0.0340576171875, -0.06597900390625, -0.078033447265625, -0.146453857421875, -0.127593994140625, -0.068756103515625, -0.065216064453125, -0.06524658203125, -0.02978515625, 0.025543212890625, 0.024383544921875, 0.012451171875, 0.05096435546875, 0.055206298828125, 0.028472900390625, 0.0224609375, 0.0157470703125, 0.005889892578125, -0.005950927734375, -0.01361083984375, -0.0123291015625, -0.024383544921875, -0.0306396484375, -0.030426025390625, -0.035247802734375, -0.01983642578125, 0.0015869140625, 0.004852294921875, 0.00067138671875, 0.0, 0.012054443359375, 0.013519287109375, -0.00079345703125, -0.003814697265625, -0.000244140625, -0.003814697265625, -0.00787353515625, -0.008148193359375, -0.009368896484375, -0.008819580078125, -0.008514404296875, -0.0086669921875, -0.0098876953125, -0.00872802734375, -0.002777099609375, -0.002471923828125, -0.0028076171875, 0.002197265625, 0.00274658203125, -0.001495361328125, -0.004547119140625, -0.002197265625, -0.001983642578125, -0.00634765625, -0.0078125, -0.006988525390625, -0.00830078125, -0.008636474609375, -0.005889892578125, -0.00640869140625, -0.006988525390625, -0.004974365234375, -0.004913330078125, -0.005859375, -0.003875732421875, 0.000946044921875, 0.002655029296875, 0.001800537109375, 0.002197265625, 6.103515625e-05, -0.00311279296875, -0.005096435546875, -0.00518798828125, -0.005218505859375, -0.00677490234375, -0.007568359375, -0.008148193359375, -0.007415771484375, -0.005401611328125, -0.003662109375, -0.003082275390625, -0.002960205078125, -0.001739501953125, -0.000762939453125, 0.0, -0.0003662109375, -0.0018310546875, -0.00274658203125, -0.002838134765625, -0.0023193359375, -0.001739501953125, -0.001495361328125, -0.00262451171875, -0.00384521484375, -0.003936767578125, -0.003143310546875, -0.001708984375])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, 0.0, 0.0, -9.1552734375e-05, -0.00018310546875, 9.1552734375e-05, -0.000152587890625, 0.00018310546875, -0.000274658203125, 0.00018310546875, -0.000274658203125, 3.0517578125e-05, -0.000244140625, -0.000213623046875, 0.000335693359375, 3.0517578125e-05, 0.000823974609375, 0.03375244140625, 0.154754638671875, 0.033355712890625, -0.2117919921875, -0.089813232421875, 0.07940673828125, 0.03350830078125, 0.036285400390625, 0.259521484375, 0.332733154296875, 0.075347900390625, -0.02105712890625, 0.045623779296875, -0.026641845703125, -0.074432373046875, -0.082916259765625, -0.153961181640625, -0.147308349609375, -0.0767822265625, -0.0654296875, -0.072967529296875, -0.039794921875, 0.025299072265625, 0.032012939453125, 0.01519775390625, 0.05267333984375, 0.0596923828125, 0.030059814453125, 0.0211181640625, 0.018280029296875, -0.0009765625, -0.01239013671875, -0.006439208984375, -0.012969970703125, -0.028076171875, -0.031402587890625, -0.030242919921875, -0.040252685546875, -0.0316162109375, -0.00897216796875, -0.00555419921875, 0.00335693359375, 0.020599365234375, 0.025299072265625, 0.017425537109375, 0.01043701171875, 0.00775146484375, 0.0032958984375, -0.006561279296875, -0.011932373046875, -0.011871337890625, -0.01580810546875, -0.015594482421875, -0.013275146484375, -0.01214599609375, -0.011932373046875, -0.010772705078125, -0.005279541015625, -0.00128173828125, -3.0517578125e-05, 0.00384521484375, 0.005157470703125, 0.00128173828125, -0.001312255859375, -0.000396728515625, -0.000396728515625, -0.004791259765625, -0.0081787109375, -0.00787353515625, -0.00909423828125, -0.0098876953125, -0.0079345703125, -0.008453369140625, -0.009765625, -0.00732421875, -0.003997802734375, -0.002838134765625, -0.002044677734375, 0.00042724609375, 0.002471923828125, 0.002960205078125, 0.00238037109375, -0.0006103515625, -0.0037841796875, -0.00469970703125, -0.004669189453125, -0.005828857421875, -0.007598876953125, -0.00811767578125, -0.008209228515625, -0.007232666015625, -0.005859375, -0.0042724609375, -0.003387451171875, -0.003204345703125, -0.00250244140625, -0.00128173828125, 6.103515625e-05, 0.00042724609375, -0.0006103515625, -0.001708984375, -0.00201416015625, -0.002471923828125, -0.00262451171875, -0.002716064453125, -0.003021240234375, -0.00384521484375, -0.004852294921875, -0.004913330078125, -0.00341796875, -0.000396728515625])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 3.0517578125e-05, -6.103515625e-05, -0.000152587890625, 9.1552734375e-05, -0.0001220703125, 0.000152587890625, -0.000274658203125, 0.000244140625, -0.000244140625, -3.0517578125e-05, -0.000213623046875, -0.000152587890625, 0.000152587890625, 3.0517578125e-05, 0.00067138671875, 0.0313720703125, 0.15545654296875, 0.05206298828125, -0.205169677734375, -0.1162109375, 0.06451416015625, 0.04193115234375, 0.0390625, 0.2669677734375, 0.36260986328125, 0.0908203125, -0.0272216796875, 0.0496826171875, -0.021453857421875, -0.0809326171875, -0.08740234375, -0.15948486328125, -0.164459228515625, -0.08843994140625, -0.066436767578125, -0.078887939453125, -0.048492431640625, 0.022369384765625, 0.03533935546875, 0.016937255859375, 0.056304931640625, 0.066253662109375, 0.037261962890625, 0.021636962890625, 0.006378173828125, 0.00152587890625, -0.00628662109375, -0.01263427734375, -0.016326904296875, -0.031829833984375, -0.036346435546875, -0.03070068359375, -0.0367431640625, -0.0357666015625, -0.020843505859375, -0.00701904296875, 0.00665283203125, 0.0118408203125, 0.022430419921875, 0.032928466796875, 0.02630615234375, 0.0169677734375, 0.009765625, 0.0008544921875, -0.009307861328125, -0.01739501953125, -0.021636962890625, -0.02154541015625, -0.018951416015625, -0.016876220703125, -0.016448974609375, -0.014556884765625, -0.006439208984375, -0.00067138671875, -0.000518798828125, 0.003570556640625, 0.00714111328125, 0.0042724609375, -0.000244140625, 0.000701904296875, 0.003997802734375, -0.000518798828125, -0.00616455078125, -0.00738525390625, -0.00982666015625, -0.0115966796875, -0.009979248046875, -0.009552001953125, -0.011566162109375, -0.008880615234375, -0.0042724609375, -0.003082275390625, -0.001617431640625, 0.0015869140625, 0.00335693359375, 0.00128173828125, -0.000244140625, -0.0010986328125, -0.00250244140625, -0.00286865234375, -0.004058837890625, -0.0054931640625, -0.007049560546875, -0.007965087890625, -0.0081787109375, -0.00787353515625, -0.0062255859375, -0.005035400390625, -0.004058837890625, -0.003570556640625, -0.0028076171875, -0.00146484375, -0.000579833984375, 6.103515625e-05, -0.000579833984375, -0.00079345703125, -0.000762939453125, -0.001556396484375, -0.00262451171875, -0.00323486328125, -0.00347900390625, -0.0042724609375, -0.00494384765625, -0.00543212890625, -0.00469970703125, -0.00177001953125, 0.001251220703125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -6.103515625e-05, -0.00018310546875, 6.103515625e-05, -0.0001220703125, 0.0001220703125, -0.000274658203125, 0.000213623046875, -0.0003662109375, 0.0, -0.00042724609375, -6.103515625e-05, 0.0, 0.0001220703125, 0.000396728515625, 0.030731201171875, 0.1563720703125, 0.061859130859375, -0.194732666015625, -0.131195068359375, 0.046234130859375, 0.042236328125, 0.044219970703125, 0.274139404296875, 0.38580322265625, 0.11346435546875, -0.028411865234375, 0.0482177734375, -0.01470947265625, -0.08624267578125, -0.094940185546875, -0.16180419921875, -0.177978515625, -0.103179931640625, -0.06842041015625, -0.081939697265625, -0.05859375, 0.018524169921875, 0.039764404296875, 0.01666259765625, 0.054443359375, 0.078094482421875, 0.040740966796875, 0.015960693359375, 0.01824951171875, 0.0048828125, -0.016845703125, -0.0162353515625, -0.01641845703125, -0.03466796875, -0.042266845703125, -0.035675048828125, -0.043243408203125, -0.038330078125, -0.010589599609375, -0.00128173828125, -0.00262451171875, 0.007659912109375, 0.0228271484375, 0.031402587890625, 0.029144287109375, 0.02532958984375, 0.020660400390625, 0.00738525390625, -0.004730224609375, -0.01275634765625, -0.020751953125, -0.024658203125, -0.02362060546875, -0.022857666015625, -0.02215576171875, -0.017974853515625, -0.01031494140625, -0.00396728515625, -0.001739501953125, 0.003692626953125, 0.007232666015625, 0.00506591796875, 0.00286865234375, 0.003570556640625, 0.005401611328125, 0.002716064453125, -0.0020751953125, -0.005584716796875, -0.00994873046875, -0.012451171875, -0.0108642578125, -0.0091552734375, -0.0103759765625, -0.00946044921875, -0.00653076171875, -0.004974365234375, -0.00238037109375, 0.0006103515625, 0.001861572265625, 0.001007080078125, 0.000152587890625, -0.00079345703125, -0.002899169921875, -0.003204345703125, -0.002716064453125, -0.00396728515625, -0.005859375, -0.007110595703125, -0.007904052734375, -0.00830078125, -0.006927490234375, -0.00537109375, -0.004486083984375, -0.003997802734375, -0.0030517578125, -0.001739501953125, -0.000640869140625, 0.0003662109375, -0.00030517578125, -0.001068115234375, -0.001007080078125, -0.001129150390625, -0.001708984375, -0.00286865234375, -0.003662109375, -0.003997802734375, -0.004791259765625, -0.0052490234375, -0.005035400390625, -0.002960205078125, 0.0, 0.00164794921875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -0.00018310546875, 6.103515625e-05, -0.0001220703125, 0.000213623046875, -0.00030517578125, 0.0003662109375, -0.000457763671875, 0.00018310546875, -0.00048828125, 0.0001220703125, -0.00018310546875, 0.000244140625, 0.0, 0.03131103515625, 0.159515380859375, 0.061553955078125, -0.184783935546875, -0.132781982421875, 0.03057861328125, 0.037017822265625, 0.046905517578125, 0.280242919921875, 0.398895263671875, 0.1385498046875, -0.017486572265625, 0.041717529296875, -0.0126953125, -0.082763671875, -0.103790283203125, -0.166717529296875, -0.184112548828125, -0.11871337890625, -0.074371337890625, -0.082000732421875, -0.06536865234375, 0.007659912109375, 0.03936767578125, 0.025787353515625, 0.053802490234375, 0.06451416015625, 0.045166015625, 0.038177490234375, 0.021087646484375, 0.00238037109375, -0.016082763671875, -0.0194091796875, -0.020843505859375, -0.03607177734375, -0.0443115234375, -0.049224853515625, -0.049468994140625, -0.0301513671875, -0.010009765625, -0.0059814453125, 0.00262451171875, 0.0137939453125, 0.022857666015625, 0.026397705078125, 0.025146484375, 0.0238037109375, 0.0206298828125, 0.013275146484375, 0.003753662109375, -0.006988525390625, -0.016937255859375, -0.020965576171875, -0.022430419921875, -0.02313232421875, -0.025238037109375, -0.023712158203125, -0.015899658203125, -0.009063720703125, -0.005462646484375, -6.103515625e-05, 0.005767822265625, 0.006927490234375, 0.0057373046875, 0.006378173828125, 0.007171630859375, 0.003875732421875, -0.00048828125, -0.003448486328125, -0.0084228515625, -0.01129150390625, -0.009002685546875, -0.007598876953125, -0.008941650390625, -0.00958251953125, -0.00738525390625, -0.00628662109375, -0.005767822265625, -0.00225830078125, 0.000335693359375, 0.000701904296875, -9.1552734375e-05, -0.001129150390625, -0.00213623046875, -0.0028076171875, -0.0023193359375, -0.003265380859375, -0.004638671875, -0.00628662109375, -0.0079345703125, -0.00836181640625, -0.007476806640625, -0.005584716796875, -0.0045166015625, -0.003814697265625, -0.003173828125, -0.001983642578125, -0.000244140625, 0.00054931640625, 6.103515625e-05, -0.00103759765625, -0.001495361328125, -0.001739501953125, -0.0018310546875, -0.00213623046875, -0.003204345703125, -0.00396728515625, -0.004364013671875, -0.004638671875, -0.004852294921875, -0.003448486328125, -0.0008544921875, 0.000762939453125, 0.001678466796875])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([0.000152587890625, -0.00018310546875, 0.000579833984375, -0.000732421875, 0.001190185546875, -0.001708984375, 0.00225830078125, -0.003082275390625, 0.003662109375, -0.004150390625, 0.004913330078125, 0.000885009765625, 0.162384033203125, 0.18511962890625, -0.20635986328125, -0.007720947265625, 0.005950927734375, -0.15655517578125, 0.22235107421875, 0.182708740234375, 0.0711669921875, 0.359649658203125, 0.337799072265625, -0.199493408203125, -0.155914306640625, 0.138519287109375, -0.249237060546875, -0.4132080078125, -0.06182861328125, -0.0416259765625, -0.223846435546875, -0.038970947265625, 0.0919189453125, 0.00244140625, 0.033050537109375, 0.128509521484375, 0.100250244140625, 0.041473388671875, 0.075286865234375, 0.047088623046875, -0.027587890625, -0.005859375, 0.037109375, -0.017913818359375, -0.051788330078125, -0.033477783203125, -0.037689208984375, -0.065155029296875, -0.082733154296875, -0.07391357421875, -0.06243896484375, -0.040618896484375, -0.0076904296875, 0.00347900390625, 0.00592041015625, 0.020782470703125, 0.03997802734375, 0.0419921875, 0.02838134765625, 0.021209716796875, 0.016876220703125, 0.004608154296875, -0.0074462890625, -0.00689697265625, -0.014495849609375, -0.024993896484375, -0.021331787109375, -0.0224609375, -0.028106689453125, -0.0224609375, -0.01654052734375, -0.018463134765625, -0.013641357421875, -0.002227783203125, 0.002288818359375, 0.004791259765625, 0.0107421875, 0.016754150390625, 0.012786865234375, 0.003387451171875, -0.001007080078125, -0.00018310546875, -0.003173828125, -0.00933837890625, -0.008331298828125, -0.009490966796875, -0.012054443359375, -0.0089111328125, -0.005035400390625, -0.005340576171875, -0.00445556640625, -0.00018310546875, -0.0018310546875, -0.00750732421875, -0.004150390625, 0.001800537109375, 0.00177001953125, 0.00048828125, 0.0010986328125, -0.001129150390625, -0.004425048828125, -0.003631591796875, -0.004669189453125, -0.005950927734375, -0.005462646484375, -0.006591796875, -0.007293701171875, -0.00390625, 0.000762939453125, 0.00225830078125, 0.0003662109375, -0.0013427734375, -0.001007080078125, -0.002899169921875, -0.00616455078125, -0.005645751953125, -0.00482177734375, -0.005859375, -0.00494384765625, -0.00250244140625, -0.0015869140625, -0.000823974609375, -0.000640869140625, -0.001617431640625, -0.001800537109375, -0.00115966796875, -0.001739501953125, -0.00177001953125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0001220703125, 0.0, 0.000274658203125, -0.000518798828125, 0.000946044921875, -0.00146484375, 0.001800537109375, -0.00250244140625, 0.0030517578125, -0.003631591796875, 0.00439453125, 0.0037841796875, 0.153472900390625, 0.152191162109375, -0.176483154296875, 0.006195068359375, -0.005035400390625, -0.132049560546875, 0.192291259765625, 0.161865234375, 0.078826904296875, 0.321502685546875, 0.3016357421875, -0.153900146484375, -0.127105712890625, 0.101959228515625, -0.219879150390625, -0.356597900390625, -0.069305419921875, -0.046844482421875, -0.192596435546875, -0.040863037109375, 0.0714111328125, 0.0069580078125, 0.027191162109375, 0.1033935546875, 0.087310791015625, 0.038238525390625, 0.06414794921875, 0.050811767578125, -0.013763427734375, -0.005096435546875, 0.0374755859375, -0.00335693359375, -0.046905517578125, -0.036285400390625, -0.0362548828125, -0.0697021484375, -0.0809326171875, -0.05963134765625, -0.049346923828125, -0.037750244140625, -0.00726318359375, 0.01055908203125, 0.011505126953125, 0.01251220703125, 0.02398681640625, 0.03240966796875, 0.02264404296875, 0.012908935546875, 0.01043701171875, 0.003173828125, -0.006195068359375, -0.00738525390625, -0.0142822265625, -0.023162841796875, -0.02020263671875, -0.01947021484375, -0.02557373046875, -0.02105712890625, -0.01318359375, -0.013153076171875, -0.0098876953125, -0.000152587890625, 0.005096435546875, 0.006378173828125, 0.0093994140625, 0.01165771484375, 0.008453369140625, 0.001220703125, -0.003814697265625, -0.003173828125, -0.005615234375, -0.00897216796875, -0.006103515625, -0.006500244140625, -0.009307861328125, -0.006927490234375, -0.003448486328125, -0.00537109375, -0.00482177734375, -0.001190185546875, -0.002899169921875, -0.006683349609375, -0.0035400390625, 0.00128173828125, 0.000152587890625, -0.00103759765625, -0.00042724609375, -0.002685546875, -0.004669189453125, -0.003662109375, -0.003662109375, -0.004425048828125, -0.004638671875, -0.005645751953125, -0.00567626953125, -0.002716064453125, 0.00030517578125, 0.00213623046875, 0.001129150390625, -0.0006103515625, -0.00128173828125, -0.003448486328125, -0.006103515625, -0.00579833984375, -0.0052490234375, -0.0062255859375, -0.005340576171875, -0.003265380859375, -0.0025634765625, -0.002288818359375, -0.00152587890625, -0.001556396484375, -0.001678466796875, -0.001312255859375, -0.0008544921875])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000152587890625, 0.000152587890625, 0.0, -6.103515625e-05, 0.00030517578125, -0.000396728515625, 0.000701904296875, -0.001007080078125, 0.001373291015625, -0.001983642578125, 0.00250244140625, -0.003082275390625, 0.003814697265625, 0.007354736328125, 0.147491455078125, 0.118743896484375, -0.151885986328125, 0.01678466796875, -0.01751708984375, -0.104461669921875, 0.1710205078125, 0.14410400390625, 0.08624267578125, 0.29412841796875, 0.264373779296875, -0.127471923828125, -0.104400634765625, 0.074249267578125, -0.19647216796875, -0.3106689453125, -0.06768798828125, -0.049163818359375, -0.16949462890625, -0.036834716796875, 0.05853271484375, 0.006622314453125, 0.01885986328125, 0.088836669921875, 0.076263427734375, 0.031982421875, 0.06280517578125, 0.05316162109375, -0.00799560546875, -0.00262451171875, 0.032379150390625, -0.001800537109375, -0.03704833984375, -0.03369140625, -0.041961669921875, -0.069793701171875, -0.06951904296875, -0.048980712890625, -0.044708251953125, -0.03240966796875, -0.00494384765625, 0.012481689453125, 0.0157470703125, 0.011810302734375, 0.012359619140625, 0.01702880859375, 0.01434326171875, 0.00921630859375, 0.00555419921875, -0.002685546875, -0.006866455078125, -0.005828857421875, -0.014892578125, -0.023162841796875, -0.0184326171875, -0.01800537109375, -0.02215576171875, -0.016021728515625, -0.007720947265625, -0.0072021484375, -0.004852294921875, 0.0023193359375, 0.0052490234375, 0.005950927734375, 0.00604248046875, 0.00701904296875, 0.004150390625, -0.001251220703125, -0.00482177734375, -0.0054931640625, -0.007232666015625, -0.009063720703125, -0.00439453125, -0.004180908203125, -0.007476806640625, -0.00665283203125, -0.003631591796875, -0.003692626953125, -0.0045166015625, -0.002227783203125, -0.00347900390625, -0.006134033203125, -0.003082275390625, 0.0008544921875, 0.00018310546875, -0.0018310546875, -0.00152587890625, -0.002899169921875, -0.0047607421875, -0.003875732421875, -0.00396728515625, -0.004608154296875, -0.004241943359375, -0.00433349609375, -0.004791259765625, -0.00286865234375, 0.00067138671875, 0.002593994140625, 0.001190185546875, -0.001129150390625, -0.002044677734375, -0.00347900390625, -0.00531005859375, -0.00506591796875, -0.005828857421875, -0.006988525390625, -0.005828857421875, -0.003997802734375, -0.003082275390625, -0.00250244140625, -0.001708984375, -0.0020751953125, -0.001678466796875, -0.00079345703125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -9.1552734375e-05, 9.1552734375e-05, 0.0, 3.0517578125e-05, 0.0001220703125, -0.000152587890625, 0.00048828125, -0.0008544921875, 0.00115966796875, -0.0015869140625, 0.001861572265625, -0.002349853515625, 0.003143310546875, 0.009033203125, 0.1353759765625, 0.099334716796875, -0.129913330078125, 0.018768310546875, -0.01849365234375, -0.087982177734375, 0.1513671875, 0.130767822265625, 0.084747314453125, 0.266082763671875, 0.239410400390625, -0.10321044921875, -0.0914306640625, 0.062957763671875, -0.16961669921875, -0.2734375, -0.06494140625, -0.04852294921875, -0.15118408203125, -0.03814697265625, 0.046722412109375, -0.00067138671875, 0.01177978515625, 0.07794189453125, 0.064422607421875, 0.033599853515625, 0.064971923828125, 0.052459716796875, -0.004638671875, 0.0, 0.02703857421875, -0.003753662109375, -0.027679443359375, -0.027984619140625, -0.042938232421875, -0.06182861328125, -0.06072998046875, -0.048919677734375, -0.040618896484375, -0.025726318359375, -0.003021240234375, 0.009674072265625, 0.011627197265625, 0.00811767578125, 0.007537841796875, 0.008453369140625, 0.005950927734375, 0.003631591796875, 0.00042724609375, -0.003875732421875, -0.007110595703125, -0.00689697265625, -0.012481689453125, -0.02093505859375, -0.0177001953125, -0.01495361328125, -0.0157470703125, -0.009246826171875, -0.003814697265625, -0.004119873046875, -0.003021240234375, 0.001617431640625, 0.00372314453125, 0.002899169921875, 0.00323486328125, 0.004425048828125, 0.002044677734375, -0.003387451171875, -0.0062255859375, -0.005401611328125, -0.00750732421875, -0.00823974609375, -0.0047607421875, -0.004241943359375, -0.006439208984375, -0.00494384765625, -0.002685546875, -0.004364013671875, -0.00421142578125, -0.002777099609375, -0.003662109375, -0.005889892578125, -0.002593994140625, 0.001129150390625, 0.00018310546875, -0.00091552734375, -0.00189208984375, -0.00384521484375, -0.005462646484375, -0.00469970703125, -0.004852294921875, -0.00482177734375, -0.003326416015625, -0.003662109375, -0.003692626953125, -0.0020751953125, 0.000396728515625, 0.001495361328125, -3.0517578125e-05, -0.00164794921875, -0.00244140625, -0.00286865234375, -0.0042724609375, -0.00506591796875, -0.006103515625, -0.007354736328125, -0.005706787109375, -0.004058837890625, -0.003509521484375, -0.002838134765625, -0.001983642578125, -0.001800537109375, -0.0018310546875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, -0.0001220703125, -9.1552734375e-05, 0.000152587890625, -3.0517578125e-05, 0.0, 0.0001220703125, -0.0001220703125, 0.000396728515625, -0.000701904296875, 0.001007080078125, -0.0013427734375, 0.00152587890625, -0.001800537109375, 0.00262451171875, 0.009002685546875, 0.121002197265625, 0.08782958984375, -0.11053466796875, 0.018402099609375, -0.016876220703125, -0.074676513671875, 0.132568359375, 0.116790771484375, 0.081146240234375, 0.237457275390625, 0.221466064453125, -0.079833984375, -0.079742431640625, 0.05810546875, -0.14154052734375, -0.240325927734375, -0.063201904296875, -0.0462646484375, -0.138397216796875, -0.041015625, 0.0322265625, -0.00762939453125, 0.00860595703125, 0.0657958984375, 0.060760498046875, 0.038238525390625, 0.061126708984375, 0.050537109375, -0.0001220703125, 0.001068115234375, 0.023193359375, -0.00189208984375, -0.021484375, -0.02191162109375, -0.037628173828125, -0.056671142578125, -0.057708740234375, -0.04595947265625, -0.03436279296875, -0.02252197265625, -0.0074462890625, -0.00018310546875, 0.0042724609375, 0.008819580078125, 0.007049560546875, 0.001068115234375, -0.0020751953125, -0.0009765625, 6.103515625e-05, -0.00274658203125, -0.0069580078125, -0.0072021484375, -0.009918212890625, -0.01458740234375, -0.013397216796875, -0.01287841796875, -0.011474609375, -0.006256103515625, -0.0035400390625, -0.003936767578125, -0.00360107421875, 0.000335693359375, 0.00244140625, 0.002105712890625, 0.00201416015625, 0.002197265625, -0.0003662109375, -0.00433349609375, -0.00628662109375, -0.005035400390625, -0.006072998046875, -0.00799560546875, -0.0054931640625, -0.00421142578125, -0.00555419921875, -0.0048828125, -0.003082275390625, -0.004241943359375, -0.004486083984375, -0.00213623046875, -0.00225830078125, -0.004669189453125, -0.002532958984375, 0.001129150390625, 0.000274658203125, -0.001922607421875, -0.002105712890625, -0.004150390625, -0.005950927734375, -0.005218505859375, -0.004730224609375, -0.004058837890625, -0.003173828125, -0.002960205078125, -0.003173828125, -0.00225830078125, -0.000762939453125, -0.0001220703125, -0.000701904296875, -0.001861572265625, -0.00152587890625, -0.0023193359375, -0.004150390625, -0.004608154296875, -0.00518798828125, -0.005767822265625, -0.005645751953125, -0.004119873046875, -0.003662109375, -0.003082275390625, -0.00225830078125, -0.002288818359375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 3.0517578125e-05, 0.0, -0.0001220703125, 6.103515625e-05, 0.0, 6.103515625e-05, 0.000152587890625, -9.1552734375e-05, 0.0003662109375, -0.000579833984375, 0.000946044921875, -0.001129150390625, 0.001251220703125, -0.00128173828125, 0.002288818359375, 0.007598876953125, 0.104827880859375, 0.08221435546875, -0.091400146484375, 0.0135498046875, -0.01043701171875, -0.06341552734375, 0.109832763671875, 0.10638427734375, 0.074554443359375, 0.20806884765625, 0.2091064453125, -0.054840087890625, -0.069061279296875, 0.0552978515625, -0.111175537109375, -0.21051025390625, -0.06414794921875, -0.04547119140625, -0.1259765625, -0.04718017578125, 0.016204833984375, -0.008697509765625, 0.00592041015625, 0.05804443359375, 0.058074951171875, 0.037506103515625, 0.05841064453125, 0.04876708984375, 0.0037841796875, 0.00311279296875, 0.024078369140625, 0.00262451171875, -0.019561767578125, -0.022857666015625, -0.03192138671875, -0.048431396484375, -0.05194091796875, -0.04083251953125, -0.03619384765625, -0.028961181640625, -0.01556396484375, -0.005462646484375, 0.0013427734375, 0.0045166015625, 0.00335693359375, -0.001434326171875, -0.00390625, -0.001312255859375, 0.003326416015625, -0.000518798828125, -0.006072998046875, -0.003753662109375, -0.005523681640625, -0.010833740234375, -0.010955810546875, -0.012359619140625, -0.013336181640625, -0.007476806640625, -0.002899169921875, -0.004302978515625, -0.00390625, 0.0008544921875, 0.00201416015625, 3.0517578125e-05, 3.0517578125e-05, 0.001129150390625, -0.000762939453125, -0.00408935546875, -0.005096435546875, -0.00439453125, -0.006011962890625, -0.007354736328125, -0.00531005859375, -0.004913330078125, -0.006256103515625, -0.004913330078125, -0.003509521484375, -0.00408935546875, -0.003387451171875, -0.000732421875, -0.00091552734375, -0.00347900390625, -0.002410888671875, -0.000274658203125, -0.001220703125, -0.002349853515625, -0.002105712890625, -0.003692626953125, -0.005279541015625, -0.005035400390625, -0.0045166015625, -0.003875732421875, -0.003204345703125, -0.003509521484375, -0.004150390625, -0.002838134765625, -0.0009765625, -0.000457763671875, -0.001434326171875, -0.001953125, -0.00128173828125, -0.001861572265625, -0.0032958984375, -0.00341796875, -0.0035400390625, -0.00469970703125, -0.005035400390625, -0.004669189453125, -0.004425048828125, -0.0037841796875, -0.002471923828125])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, -6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 0.0, 6.103515625e-05, -3.0517578125e-05, 9.1552734375e-05, -0.0001220703125, 0.00030517578125, -0.00048828125, 0.000762939453125, -0.001068115234375, 0.00103759765625, -0.00079345703125, 0.001800537109375, 0.00531005859375, 0.087738037109375, 0.0802001953125, -0.0731201171875, 0.0064697265625, -0.0006103515625, -0.05609130859375, 0.08673095703125, 0.097442626953125, 0.06622314453125, 0.1793212890625, 0.199005126953125, -0.02667236328125, -0.0601806640625, 0.053619384765625, -0.080413818359375, -0.184661865234375, -0.068939208984375, -0.042694091796875, -0.113555908203125, -0.05902099609375, 0.006195068359375, -0.004364013671875, 0.001556396484375, 0.047119140625, 0.056121826171875, 0.039215087890625, 0.05352783203125, 0.047607421875, 0.01080322265625, 0.0093994140625, 0.02276611328125, -0.000457763671875, -0.020965576171875, -0.019989013671875, -0.0230712890625, -0.0386962890625, -0.04949951171875, -0.047943115234375, -0.041961669921875, -0.0325927734375, -0.0205078125, -0.011627197265625, -0.00494384765625, -0.00030517578125, 0.002044677734375, 0.0029296875, 0.00152587890625, 0.002471923828125, 0.00567626953125, 0.002685546875, -0.001678466796875, -0.001617431640625, -0.005401611328125, -0.012237548828125, -0.01287841796875, -0.012908935546875, -0.01458740234375, -0.0098876953125, -0.003631591796875, -0.0028076171875, -0.0032958984375, -0.001251220703125, -0.000244140625, -0.00091552734375, 0.000244140625, 0.00213623046875, 0.000274658203125, -0.003509521484375, -0.005584716796875, -0.004730224609375, -0.00555419921875, -0.007080078125, -0.005615234375, -0.00543212890625, -0.006805419921875, -0.006072998046875, -0.00396728515625, -0.0032958984375, -0.0023193359375, -9.1552734375e-05, -0.000457763671875, -0.002899169921875, -0.002716064453125, -0.001434326171875, -0.0020751953125, -0.002777099609375, -0.002349853515625, -0.003326416015625, -0.0045166015625, -0.004638671875, -0.0048828125, -0.0045166015625, -0.003875732421875, -0.00421142578125, -0.0045166015625, -0.002960205078125, -0.001495361328125, -0.001220703125, -0.001678466796875, -0.001739501953125, -0.00115966796875, -0.001220703125, -0.001953125, -0.002288818359375, -0.002960205078125, -0.004241943359375, -0.005126953125, -0.005035400390625, -0.004730224609375, -0.003814697265625])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 0.0, -3.0517578125e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, 0.0, 9.1552734375e-05, 0.0, 0.0001220703125, -0.0001220703125, 0.0003662109375, -0.00048828125, 0.000640869140625, -0.0008544921875, 0.0008544921875, -0.00042724609375, 0.0010986328125, 0.003692626953125, 0.069671630859375, 0.079833984375, -0.05419921875, -0.002227783203125, 0.0101318359375, -0.04913330078125, 0.06304931640625, 0.08843994140625, 0.059234619140625, 0.14990234375, 0.189666748046875, 0.0050048828125, -0.05084228515625, 0.049163818359375, -0.051055908203125, -0.15972900390625, -0.07525634765625, -0.037994384765625, -0.103363037109375, -0.06719970703125, 0.001190185546875, -0.0059814453125, -0.0037841796875, 0.040374755859375, 0.055267333984375, 0.040191650390625, 0.049896240234375, 0.050811767578125, 0.01837158203125, 0.0067138671875, 0.015625, 0.00091552734375, -0.0146484375, -0.01416015625, -0.021881103515625, -0.0411376953125, -0.0523681640625, -0.05023193359375, -0.0439453125, -0.038970947265625, -0.02777099609375, -0.015625, -0.007568359375, -0.000396728515625, 0.00701904296875, 0.01165771484375, 0.0086669921875, 0.00677490234375, 0.008209228515625, 0.00579833984375, -0.00067138671875, -0.004364013671875, -0.0084228515625, -0.014892578125, -0.014892578125, -0.014373779296875, -0.01446533203125, -0.010528564453125, -0.00518798828125, -0.003173828125, -0.004486083984375, -0.001983642578125, 0.000701904296875, 0.0010986328125, 0.000946044921875, 0.002166748046875, 0.00128173828125, -0.00341796875, -0.005645751953125, -0.004852294921875, -0.005126953125, -0.006561279296875, -0.006103515625, -0.006011962890625, -0.007415771484375, -0.0062255859375, -0.003570556640625, -0.003143310546875, -0.00225830078125, 0.000335693359375, 0.00042724609375, -0.00274658203125, -0.003173828125, -0.001678466796875, -0.00238037109375, -0.003021240234375, -0.00274658203125, -0.003204345703125, -0.004241943359375, -0.004241943359375, -0.004058837890625, -0.004669189453125, -0.004791259765625, -0.005035400390625, -0.004425048828125, -0.002960205078125, -0.00238037109375, -0.001434326171875, -0.001251220703125, -0.001251220703125, -0.000518798828125, -0.00030517578125, -0.001312255859375, -0.002227783203125, -0.00250244140625, -0.003631591796875, -0.0045166015625, -0.0048828125, -0.004852294921875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, 6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, -6.103515625e-05, 9.1552734375e-05, -9.1552734375e-05, 0.000244140625, -0.000457763671875, 0.0006103515625, -0.000701904296875, 0.000732421875, -0.000335693359375, 0.0009765625, 0.001953125, 0.051971435546875, 0.07952880859375, -0.03533935546875, -0.01123046875, 0.02056884765625, -0.041412353515625, 0.038665771484375, 0.07989501953125, 0.053680419921875, 0.120574951171875, 0.18023681640625, 0.03863525390625, -0.042266845703125, 0.04022216796875, -0.021942138671875, -0.134521484375, -0.0811767578125, -0.031585693359375, -0.091827392578125, -0.07733154296875, -0.00787353515625, -0.0032958984375, -0.00543212890625, 0.0330810546875, 0.05645751953125, 0.043426513671875, 0.046356201171875, 0.04742431640625, 0.020233154296875, 0.006103515625, 0.014495849609375, 0.0076904296875, -0.012786865234375, -0.02349853515625, -0.029541015625, -0.039337158203125, -0.050323486328125, -0.054443359375, -0.05029296875, -0.042694091796875, -0.028594970703125, -0.01416015625, -0.004486083984375, 0.0048828125, 0.01409912109375, 0.017669677734375, 0.015106201171875, 0.00982666015625, 0.008056640625, 0.004974365234375, -0.00323486328125, -0.00897216796875, -0.01263427734375, -0.01605224609375, -0.0167236328125, -0.0155029296875, -0.014404296875, -0.0115966796875, -0.007049560546875, -0.003936767578125, -0.002685546875, -0.000152587890625, 0.002227783203125, 0.001708984375, 0.001068115234375, 0.0020751953125, 0.001190185546875, -0.00244140625, -0.00537109375, -0.0048828125, -0.005157470703125, -0.007415771484375, -0.007232666015625, -0.00640869140625, -0.006927490234375, -0.005950927734375, -0.003753662109375, -0.00274658203125, -0.00225830078125, -0.000396728515625, -0.000244140625, -0.002410888671875, -0.003021240234375, -0.002349853515625, -0.002288818359375, -0.003265380859375, -0.002655029296875, -0.002655029296875, -0.003570556640625, -0.00384521484375, -0.004608154296875, -0.0050048828125, -0.00518798828125, -0.00469970703125, -0.004791259765625, -0.003936767578125, -0.002471923828125, -0.001251220703125, -0.0006103515625, -0.00079345703125, -0.000213623046875, -0.000152587890625, -0.001129150390625, -0.0020751953125, -0.00250244140625, -0.00335693359375, -0.00433349609375, -0.004547119140625])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 0.0, 0.0, 0.0, -3.0517578125e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 0.0001220703125, -9.1552734375e-05, 0.000213623046875, -3.0517578125e-05, 0.000213623046875, -0.000274658203125, 0.00048828125, -0.000335693359375, 0.00042724609375, 9.1552734375e-05, 0.000701904296875, 0.000823974609375, 0.03631591796875, 0.076080322265625, -0.015960693359375, -0.0184326171875, 0.0284423828125, -0.032318115234375, 0.01568603515625, 0.07080078125, 0.049560546875, 0.0946044921875, 0.16845703125, 0.07000732421875, -0.032684326171875, 0.030426025390625, 0.004974365234375, -0.1060791015625, -0.081573486328125, -0.03228759765625, -0.086456298828125, -0.080810546875, -0.011749267578125, -0.001678466796875, -0.00506591796875, 0.030426025390625, 0.056060791015625, 0.039794921875, 0.0386962890625, 0.0474853515625, 0.027496337890625, 0.009307861328125, 0.008453369140625, -0.0006103515625, -0.019989013671875, -0.029327392578125, -0.031005859375, -0.03912353515625, -0.05279541015625, -0.05712890625, -0.04931640625, -0.03839111328125, -0.02313232421875, -0.0084228515625, 0.000640869140625, 0.010498046875, 0.01898193359375, 0.021240234375, 0.0164794921875, 0.010040283203125, 0.006256103515625, 0.0001220703125, -0.007843017578125, -0.0126953125, -0.0140380859375, -0.017242431640625, -0.01800537109375, -0.01629638671875, -0.0150146484375, -0.011138916015625, -0.00592041015625, -0.001953125, -0.001312255859375, 0.000762939453125, 0.0023193359375, 0.0020751953125, 0.00189208984375, 0.00164794921875, 0.000946044921875, -0.001708984375, -0.00445556640625, -0.005859375, -0.006744384765625, -0.0078125, -0.007080078125, -0.0057373046875, -0.006103515625, -0.005645751953125, -0.00372314453125, -0.003082275390625, -0.0030517578125, -0.001678466796875, -0.000885009765625, -0.00213623046875, -0.002838134765625, -0.001495361328125, -0.00152587890625, -0.00250244140625, -0.00244140625, -0.002105712890625, -0.003173828125, -0.004486083984375, -0.004638671875, -0.004852294921875, -0.0048828125, -0.005401611328125, -0.0048828125, -0.003753662109375, -0.00244140625, -0.00079345703125, -0.00018310546875, -6.103515625e-05, -0.000274658203125, -0.00030517578125, -0.001556396484375, -0.00250244140625, -0.00262451171875, -0.0032958984375, -0.0035400390625])
        IR_LEFT[len(IR_LEFT)-1].append([6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, 6.103515625e-05, -6.103515625e-05, 9.1552734375e-05, -9.1552734375e-05, 9.1552734375e-05, -0.00018310546875, 0.000213623046875, -6.103515625e-05, 3.0517578125e-05, 0.0003662109375, 0.00030517578125, 0.000274658203125, 0.022796630859375, 0.0689697265625, 0.003143310546875, -0.022705078125, 0.032073974609375, -0.02178955078125, -0.00439453125, 0.060211181640625, 0.047149658203125, 0.072723388671875, 0.152679443359375, 0.095367431640625, -0.018798828125, 0.02252197265625, 0.031402587890625, -0.078094482421875, -0.089874267578125, -0.036102294921875, -0.071868896484375, -0.07952880859375, -0.0181884765625, 0.003173828125, -0.001739501953125, 0.0218505859375, 0.047637939453125, 0.0406494140625, 0.041290283203125, 0.049713134765625, 0.025787353515625, -0.006561279296875, -0.00616455078125, -0.003204345703125, -0.023101806640625, -0.036041259765625, -0.035369873046875, -0.037689208984375, -0.048828125, -0.052093505859375, -0.0418701171875, -0.02923583984375, -0.015380859375, -0.0035400390625, 0.005340576171875, 0.013702392578125, 0.019134521484375, 0.020172119140625, 0.014373779296875, 0.006561279296875, 0.0009765625, -0.00445556640625, -0.011199951171875, -0.015045166015625, -0.014892578125, -0.01788330078125, -0.018890380859375, -0.01568603515625, -0.0125732421875, -0.0089111328125, -0.003997802734375, -0.00091552734375, -0.0015869140625, -3.0517578125e-05, 0.0030517578125, 0.002899169921875, 0.00103759765625, 0.001068115234375, 0.000885009765625, -0.002288818359375, -0.005584716796875, -0.006439208984375, -0.00653076171875, -0.0074462890625, -0.00701904296875, -0.00555419921875, -0.005889892578125, -0.005950927734375, -0.0045166015625, -0.00396728515625, -0.00396728515625, -0.002349853515625, -0.000762939453125, -0.001556396484375, -0.00225830078125, -0.000823974609375, -0.000823974609375, -0.0023193359375, -0.002105712890625, -0.001983642578125, -0.00384521484375, -0.004913330078125, -0.004669189453125, -0.005126953125, -0.005584716796875, -0.005126953125, -0.0045166015625, -0.0035400390625, -0.002197265625, -0.00067138671875, -0.000152587890625, -0.0008544921875, -0.001129150390625, -0.00146484375, -0.00201416015625, -0.00262451171875, -0.002227783203125, -0.00213623046875])
        IR_LEFT[len(IR_LEFT)-1].append([6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 0.0, 0.0, -3.0517578125e-05, 0.0, 0.0, 0.0, 3.0517578125e-05, 0.0, 6.103515625e-05, -6.103515625e-05, 6.103515625e-05, -3.0517578125e-05, 0.000152587890625, 0.0001220703125, -0.000152587890625, 0.000640869140625, -6.103515625e-05, 0.000335693359375, 0.01214599609375, 0.05828857421875, 0.02093505859375, -0.02203369140625, 0.03057861328125, -0.0103759765625, -0.01953125, 0.047576904296875, 0.0458984375, 0.05657958984375, 0.132598876953125, 0.11419677734375, 0.006805419921875, 0.0181884765625, 0.0394287109375, -0.052947998046875, -0.08544921875, -0.03900146484375, -0.058502197265625, -0.0738525390625, -0.022003173828125, 0.003143310546875, -0.005035400390625, 0.01715087890625, 0.049560546875, 0.047698974609375, 0.03546142578125, 0.02740478515625, 0.009002685546875, -0.012298583984375, -0.011322021484375, -0.01177978515625, -0.030426025390625, -0.03692626953125, -0.03094482421875, -0.029998779296875, -0.039031982421875, -0.041290283203125, -0.031951904296875, -0.019287109375, -0.0086669921875, -0.001678466796875, 0.005767822265625, 0.01263427734375, 0.015960693359375, 0.014495849609375, 0.009185791015625, 0.002655029296875, -0.00421142578125, -0.00811767578125, -0.012115478515625, -0.015594482421875, -0.015960693359375, -0.016815185546875, -0.015777587890625, -0.0125732421875, -0.00921630859375, -0.006927490234375, -0.003814697265625, -0.001373291015625, -0.00146484375, 0.000396728515625, 0.002044677734375, 0.002044677734375, 0.000762939453125, -9.1552734375e-05, -0.00054931640625, -0.003082275390625, -0.004913330078125, -0.005889892578125, -0.006134033203125, -0.007476806640625, -0.007598876953125, -0.005859375, -0.0059814453125, -0.006103515625, -0.00506591796875, -0.003875732421875, -0.00341796875, -0.0020751953125, -0.001068115234375, -0.0013427734375, -0.001373291015625, -0.00042724609375, -0.000579833984375, -0.001922607421875, -0.00201416015625, -0.002777099609375, -0.003814697265625, -0.0045166015625, -0.005035400390625, -0.00531005859375, -0.0052490234375, -0.004425048828125, -0.004119873046875, -0.00341796875, -0.002655029296875, -0.00201416015625, -0.001556396484375, -0.0015869140625, -0.00140380859375, -0.001220703125, -0.00140380859375, -0.001678466796875, -0.00164794921875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, 0.000152587890625, 3.0517578125e-05, 6.103515625e-05, -0.00030517578125, 0.0008544921875, -0.000152587890625, 0.000152587890625, 0.005279541015625, 0.044769287109375, 0.03509521484375, -0.015380859375, 0.023773193359375, -3.0517578125e-05, -0.027862548828125, 0.033935546875, 0.044525146484375, 0.046539306640625, 0.11444091796875, 0.128509521484375, 0.02752685546875, 0.008819580078125, 0.048126220703125, -0.021209716796875, -0.07904052734375, -0.044281005859375, -0.042938232421875, -0.067291259765625, -0.031463623046875, 0.00225830078125, 0.006500244140625, 0.021209716796875, 0.03924560546875, 0.03057861328125, 0.011138916015625, 0.011322021484375, 0.003021240234375, -0.020172119140625, -0.0228271484375, -0.016082763671875, -0.02545166015625, -0.029998779296875, -0.020599365234375, -0.017364501953125, -0.026336669921875, -0.030731201171875, -0.0218505859375, -0.012786865234375, -0.008056640625, -0.003326416015625, 0.0028076171875, 0.007659912109375, 0.00933837890625, 0.008209228515625, 0.00347900390625, -0.00238037109375, -0.0068359375, -0.009246826171875, -0.012786865234375, -0.014862060546875, -0.0130615234375, -0.01226806640625, -0.01214599609375, -0.009552001953125, -0.007080078125, -0.00640869140625, -0.004241943359375, -0.001800537109375, -0.001129150390625, -0.0009765625, 9.1552734375e-05, 0.001068115234375, -0.0003662109375, -0.001251220703125, -0.00140380859375, -0.00262451171875, -0.004150390625, -0.0059814453125, -0.006683349609375, -0.0076904296875, -0.0078125, -0.0059814453125, -0.005523681640625, -0.00531005859375, -0.004241943359375, -0.003387451171875, -0.003143310546875, -0.002288818359375, -0.001007080078125, -0.001251220703125, -0.001220703125, -0.000518798828125, -0.00079345703125, -0.001739501953125, -0.0023193359375, -0.002197265625, -0.003326416015625, -0.004547119140625, -0.004913330078125, -0.005340576171875, -0.00482177734375, -0.0045166015625, -0.004669189453125, -0.0045166015625, -0.003936767578125, -0.00262451171875, -0.001617431640625, -0.000823974609375, -0.0006103515625, -0.00048828125, -0.0009765625, -0.001739501953125])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, 0.000152587890625, 9.1552734375e-05, 0.00018310546875, 0.00018310546875, 0.0001220703125, 0.0001220703125, 9.1552734375e-05, 0.000152587890625, 0.00018310546875, 0.00018310546875, 0.000152587890625, 0.000244140625, 9.1552734375e-05, 0.000244140625, 9.1552734375e-05, 0.000457763671875, 0.000213623046875, 0.00018310546875, 0.000396728515625, 0.0009765625, -0.000213623046875, 0.00042724609375, 0.0020751953125, 0.03070068359375, 0.04376220703125, -0.00274658203125, 0.013671875, 0.007965087890625, -0.02685546875, 0.019683837890625, 0.0455322265625, 0.0496826171875, 0.0885009765625, 0.11865234375, 0.05828857421875, 0.01861572265625, 0.048431396484375, 0.002838134765625, -0.06341552734375, -0.048980712890625, -0.037017822265625, -0.0548095703125, -0.0247802734375, 0.01007080078125, 0.005157470703125, -0.0006103515625, 0.010284423828125, 0.01556396484375, 0.0010986328125, -0.007110595703125, -0.01190185546875, -0.021026611328125, -0.01837158203125, -0.012908935546875, -0.0157470703125, -0.013671875, -0.006072998046875, -0.006195068359375, -0.015533447265625, -0.021514892578125, -0.01715087890625, -0.01123046875, -0.010650634765625, -0.00860595703125, -0.002288818359375, 0.001495361328125, 0.00238037109375, 0.001373291015625, -0.000701904296875, -0.004150390625, -0.008026123046875, -0.0089111328125, -0.00885009765625, -0.0093994140625, -0.00897216796875, -0.008575439453125, -0.00836181640625, -0.0069580078125, -0.005615234375, -0.006011962890625, -0.00482177734375, -0.002349853515625, -0.002105712890625, -0.0025634765625, -0.00128173828125, -0.000244140625, -0.000579833984375, -0.00115966796875, -0.001617431640625, -0.002197265625, -0.003875732421875, -0.0057373046875, -0.0067138671875, -0.0068359375, -0.00616455078125, -0.004852294921875, -0.003875732421875, -0.003936767578125, -0.00360107421875, -0.003143310546875, -0.00250244140625, -0.001983642578125, -0.00146484375, -0.000946044921875, -0.001068115234375, -0.00048828125, -0.000335693359375, -0.000823974609375, -0.00128173828125, -0.001739501953125, -0.002685546875, -0.00421142578125, -0.004791259765625, -0.0052490234375, -0.0054931640625, -0.00518798828125, -0.0048828125, -0.00445556640625, -0.003387451171875, -0.001861572265625, -0.00067138671875, -3.0517578125e-05, 9.1552734375e-05, -0.00054931640625, -0.001129150390625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, -3.0517578125e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 0.0, 0.000213623046875, -0.000152587890625, 0.00042724609375, -3.0517578125e-05, 0.000152587890625, 0.000396728515625, 0.00042724609375, -0.0001220703125, 6.103515625e-05, 0.000823974609375, 0.01776123046875, 0.044921875, 0.0125732421875, 0.004150390625, 0.01123046875, -0.017242431640625, 0.016571044921875, 0.04168701171875, 0.03369140625, 0.06707763671875, 0.118255615234375, 0.08856201171875, 0.030517578125, 0.041107177734375, 0.0211181640625, -0.046417236328125, -0.05108642578125, -0.01947021484375, -0.027496337890625, -0.0299072265625, -0.01727294921875, -0.018829345703125, -0.01824951171875, -0.005889892578125, -0.002471923828125, -0.018890380859375, -0.02227783203125, -0.010498046875, -0.008697509765625, -0.011260986328125, -0.004669189453125, 0.001007080078125, 0.002349853515625, 0.004364013671875, 0.00018310546875, -0.010345458984375, -0.01715087890625, -0.016998291015625, -0.01544189453125, -0.017181396484375, -0.0146484375, -0.00909423828125, -0.006622314453125, -0.00421142578125, -0.003204345703125, -0.003387451171875, -0.00537109375, -0.006103515625, -0.004302978515625, -0.003936767578125, -0.0057373046875, -0.00653076171875, -0.0054931640625, -0.005950927734375, -0.006317138671875, -0.006378173828125, -0.0068359375, -0.00604248046875, -0.005279541015625, -0.004364013671875, -0.004058837890625, -0.0029296875, -0.001312255859375, -0.00164794921875, -0.002044677734375, -0.00244140625, -0.00250244140625, -0.00390625, -0.00592041015625, -0.00579833984375, -0.005157470703125, -0.004547119140625, -0.004119873046875, -0.003936767578125, -0.003814697265625, -0.00384521484375, -0.003082275390625, -0.003448486328125, -0.00323486328125, -0.002227783203125, -0.001312255859375, -0.000518798828125, -0.000640869140625, -0.00042724609375, -0.0009765625, -0.0010986328125, -0.00201416015625, -0.0037841796875, -0.004974365234375, -0.00604248046875, -0.00604248046875, -0.006011962890625, -0.005462646484375, -0.0050048828125, -0.0040283203125, -0.00262451171875, -0.002105712890625, -0.0010986328125, -0.000457763671875, -0.000579833984375, -0.001312255859375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, -3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0517578125e-05, 0.0, 9.1552734375e-05, -0.00018310546875, 0.00048828125, 0.0001220703125, -0.00018310546875, 0.000579833984375, 0.0003662109375, -0.000152587890625, -0.0001220703125, 0.000396728515625, 0.008575439453125, 0.04058837890625, 0.028045654296875, -0.00030517578125, 0.0185546875, 0.0037841796875, -0.0052490234375, 0.02459716796875, 0.04168701171875, 0.058624267578125, 0.106658935546875, 0.110382080078125, 0.0460205078125, 0.0311279296875, 0.03558349609375, -0.00982666015625, -0.032989501953125, -0.018280029296875, -0.035430908203125, -0.05950927734375, -0.044281005859375, -0.029052734375, -0.032562255859375, -0.030364990234375, -0.022491455078125, -0.02325439453125, -0.017425537109375, -0.000885009765625, 0.0047607421875, 0.0032958984375, 0.00762939453125, 0.01416015625, 0.014862060546875, 0.009368896484375, 0.000213623046875, -0.00946044921875, -0.016326904296875, -0.0211181640625, -0.02227783203125, -0.022979736328125, -0.021453857421875, -0.016357421875, -0.0115966796875, -0.007720947265625, -0.005401611328125, -0.00311279296875, -0.00164794921875, -0.000732421875, -0.000152587890625, -0.000640869140625, -0.002593994140625, -0.0040283203125, -0.003814697265625, -0.0048828125, -0.006805419921875, -0.007598876953125, -0.0084228515625, -0.008544921875, -0.00714111328125, -0.0054931640625, -0.004791259765625, -0.004180908203125, -0.0028076171875, -0.002166748046875, -0.002532958984375, -0.002685546875, -0.002685546875, -0.002777099609375, -0.003265380859375, -0.00390625, -0.003662109375, -0.00396728515625, -0.004119873046875, -0.003692626953125, -0.003875732421875, -0.0042724609375, -0.0045166015625, -0.004119873046875, -0.003021240234375, -0.001708984375, -0.00079345703125, -0.000732421875, -0.000762939453125, -0.000823974609375, -0.001068115234375, -0.002197265625, -0.003173828125, -0.00408935546875, -0.0052490234375, -0.00592041015625, -0.006195068359375, -0.005584716796875, -0.00506591796875, -0.004119873046875, -0.00347900390625, -0.003448486328125, -0.002532958984375, -0.0015869140625, -0.000823974609375, -0.001251220703125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 0.0, 3.0517578125e-05, 0.0, 0.0, 0.0, 0.0, 6.103515625e-05, 0.0, 0.0, -3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.00030517578125, 3.0517578125e-05, -6.103515625e-05, 0.00091552734375, 0.000274658203125, -0.00042724609375, -0.00030517578125, 0.0, 0.0048828125, 0.03399658203125, 0.044708251953125, 0.01361083984375, 0.00592041015625, 0.00079345703125, -0.000396728515625, 0.025146484375, 0.03900146484375, 0.0511474609375, 0.09429931640625, 0.11712646484375, 0.068695068359375, 0.0462646484375, 0.059722900390625, 0.012298583984375, -0.04608154296875, -0.049285888671875, -0.051727294921875, -0.070648193359375, -0.06463623046875, -0.04998779296875, -0.04736328125, -0.041107177734375, -0.025909423828125, -0.01416015625, -0.005035400390625, 0.011260986328125, 0.0203857421875, 0.01708984375, 0.0174560546875, 0.0223388671875, 0.0196533203125, 0.007965087890625, -0.00360107421875, -0.01177978515625, -0.01995849609375, -0.02667236328125, -0.0294189453125, -0.02880859375, -0.025970458984375, -0.01995849609375, -0.01397705078125, -0.0087890625, -0.0025634765625, 0.001068115234375, 0.003082275390625, 0.0030517578125, 0.002410888671875, 0.001617431640625, -0.000885009765625, -0.002197265625, -0.003692626953125, -0.005706787109375, -0.009002685546875, -0.009765625, -0.009002685546875, -0.009368896484375, -0.008087158203125, -0.007080078125, -0.005950927734375, -0.00506591796875, -0.003509521484375, -0.002655029296875, -0.002838134765625, -0.001617431640625, -0.000396728515625, -0.00042724609375, -0.0020751953125, -0.003173828125, -0.003204345703125, -0.00372314453125, -0.004180908203125, -0.004486083984375, -0.004791259765625, -0.005157470703125, -0.00457763671875, -0.003448486328125, -0.0028076171875, -0.00189208984375, -0.00115966796875, -0.0008544921875, -0.001495361328125, -0.001922607421875, -0.002105712890625, -0.002777099609375, -0.003326416015625, -0.004364013671875, -0.0052490234375, -0.0057373046875, -0.00531005859375, -0.0047607421875, -0.004913330078125, -0.0045166015625, -0.0040283203125, -0.003814697265625, -0.003265380859375, -0.00213623046875, -0.001007080078125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, -9.1552734375e-05, -3.0517578125e-05, 0.0, 9.1552734375e-05, 9.1552734375e-05, -9.1552734375e-05, 0.00042724609375, 0.000244140625, 0.000213623046875, 0.000701904296875, 6.103515625e-05, -0.00091552734375, -0.000274658203125, 0.00164794921875, 0.008941650390625, 0.042755126953125, 0.044921875, -0.002655029296875, 0.0064697265625, 0.02435302734375, 0.00689697265625, 0.01568603515625, 0.033782958984375, 0.04412841796875, 0.082122802734375, 0.137451171875, 0.11712646484375, 0.05584716796875, 0.03472900390625, -0.00347900390625, -0.0618896484375, -0.06671142578125, -0.06170654296875, -0.0875244140625, -0.08563232421875, -0.059234619140625, -0.045257568359375, -0.037628173828125, -0.01995849609375, -0.000701904296875, 0.010986328125, 0.022705078125, 0.03118896484375, 0.027618408203125, 0.022186279296875, 0.022705078125, 0.01690673828125, 0.00347900390625, -0.01031494140625, -0.0181884765625, -0.02398681640625, -0.031982421875, -0.033935546875, -0.031280517578125, -0.0277099609375, -0.020965576171875, -0.01190185546875, -0.003692626953125, 0.0013427734375, 0.0045166015625, 0.005828857421875, 0.005157470703125, 0.003387451171875, 0.00250244140625, 0.0006103515625, -0.003387451171875, -0.00579833984375, -0.007598876953125, -0.009307861328125, -0.009918212890625, -0.00970458984375, -0.009796142578125, -0.0096435546875, -0.008148193359375, -0.006439208984375, -0.005279541015625, -0.00347900390625, -0.001312255859375, -0.00054931640625, 0.0001220703125, 0.0010986328125, 0.000213623046875, -0.001495361328125, -0.002655029296875, -0.0035400390625, -0.00396728515625, -0.0045166015625, -0.0050048828125, -0.00518798828125, -0.004791259765625, -0.00396728515625, -0.00347900390625, -0.003143310546875, -0.00274658203125, -0.001556396484375, -0.001129150390625, -0.00189208984375, -0.00225830078125, -0.002685546875, -0.0030517578125, -0.003448486328125, -0.003814697265625, -0.004669189453125, -0.0050048828125, -0.004425048828125, -0.004791259765625, -0.005096435546875, -0.004974365234375, -0.00469970703125, -0.00396728515625, -0.00238037109375, -0.000762939453125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -6.103515625e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 0.0, 0.0, 3.0517578125e-05, 0.0, -3.0517578125e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, 0.0, -0.0001220703125, -6.103515625e-05, -6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, -9.1552734375e-05, 0.000152587890625, 0.000518798828125, 0.000244140625, 3.0517578125e-05, 0.000457763671875, -0.000518798828125, -0.000518798828125, 0.00433349609375, 0.0198974609375, 0.0169677734375, 0.0108642578125, 0.032867431640625, 0.0245361328125, 0.01556396484375, 0.028472900390625, 0.019500732421875, 0.011566162109375, 0.01776123046875, 0.043182373046875, 0.109039306640625, 0.16253662109375, 0.112060546875, 0.0228271484375, -0.003021240234375, -0.013824462890625, -0.058319091796875, -0.08380126953125, -0.084686279296875, -0.093658447265625, -0.082855224609375, -0.0550537109375, -0.037750244140625, -0.026336669921875, -0.0076904296875, 0.0123291015625, 0.02215576171875, 0.030731201171875, 0.036346435546875, 0.031280517578125, 0.02069091796875, 0.01629638671875, 0.01104736328125, -0.00543212890625, -0.01824951171875, -0.02362060546875, -0.0272216796875, -0.032928466796875, -0.035858154296875, -0.03143310546875, -0.025054931640625, -0.01513671875, -0.006805419921875, -0.00091552734375, 0.003875732421875, 0.006011962890625, 0.006744384765625, 0.005096435546875, 0.00360107421875, 0.00091552734375, -0.00152587890625, -0.003936767578125, -0.0067138671875, -0.007659912109375, -0.00982666015625, -0.010528564453125, -0.010406494140625, -0.010498046875, -0.0107421875, -0.00909423828125, -0.005340576171875, -0.00299072265625, -0.0013427734375, -0.00042724609375, 0.000457763671875, 0.001251220703125, 0.001129150390625, -0.00048828125, -0.002197265625, -0.002716064453125, -0.003143310546875, -0.00396728515625, -0.005126953125, -0.005889892578125, -0.0050048828125, -0.004486083984375, -0.004974365234375, -0.004608154296875, -0.0035400390625, -0.00225830078125, -0.00164794921875, -0.001556396484375, -0.002227783203125, -0.00299072265625, -0.002838134765625, -0.003173828125, -0.00347900390625, -0.00384521484375, -0.004058837890625, -0.00421142578125, -0.004730224609375, -0.00518798828125, -0.0059814453125, -0.005218505859375, -0.00341796875, -0.001739501953125, -0.00079345703125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 0.0, 0.0, -3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, -9.1552734375e-05, -6.103515625e-05, -6.103515625e-05, 3.0517578125e-05, -9.1552734375e-05, 3.0517578125e-05, 0.00018310546875, 0.000335693359375, 0.000244140625, 0.0003662109375, -0.00030517578125, -6.103515625e-05, 0.00146484375, 0.01690673828125, 0.023345947265625, -0.002197265625, -0.00421142578125, 0.023681640625, 0.03948974609375, 0.031341552734375, 0.025146484375, 0.04473876953125, 0.0433349609375, -0.014251708984375, 0.000762939453125, 0.08624267578125, 0.12353515625, 0.119171142578125, 0.067962646484375, 0.001678466796875, -0.01885986328125, -0.01910400390625, -0.060821533203125, -0.0989990234375, -0.0916748046875, -0.077880859375, -0.06927490234375, -0.04962158203125, -0.022735595703125, -0.010711669921875, -0.000213623046875, 0.018218994140625, 0.030029296875, 0.034698486328125, 0.033660888671875, 0.02630615234375, 0.01507568359375, 0.00885009765625, -0.000274658203125, -0.01385498046875, -0.02362060546875, -0.025299072265625, -0.026031494140625, -0.0330810546875, -0.033172607421875, -0.025634765625, -0.0169677734375, -0.01104736328125, -0.00494384765625, 0.001129150390625, 0.00445556640625, 0.006011962890625, 0.00457763671875, 0.00262451171875, 0.001434326171875, 0.0006103515625, -0.001373291015625, -0.004730224609375, -0.007415771484375, -0.0091552734375, -0.009490966796875, -0.010711669921875, -0.0120849609375, -0.011383056640625, -0.00897216796875, -0.005584716796875, -0.003387451171875, -0.00177001953125, -0.000732421875, 0.000213623046875, 0.00054931640625, 0.00018310546875, -0.00067138671875, -0.001617431640625, -0.00115966796875, -0.001708984375, -0.003875732421875, -0.005218505859375, -0.005706787109375, -0.006103515625, -0.006072998046875, -0.005340576171875, -0.00469970703125, -0.00439453125, -0.003326416015625, -0.002655029296875, -0.0023193359375, -0.001861572265625, -0.002166748046875, -0.0030517578125, -0.003814697265625, -0.00384521484375, -0.0032958984375, -0.00335693359375, -0.0040283203125, -0.004730224609375, -0.005035400390625, -0.0050048828125, -0.004608154296875, -0.0030517578125, -0.00140380859375, -0.0008544921875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, 0.0, 0.0, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, 0.0001220703125, 0.000274658203125, 0.000152587890625, 0.000396728515625, 0.000335693359375, 0.000152587890625, -6.103515625e-05, 0.013519287109375, 0.029449462890625, 0.0045166015625, -0.011566162109375, 0.00909423828125, 0.017913818359375, 0.016571044921875, 0.0335693359375, 0.056793212890625, 0.06732177734375, 0.06024169921875, 0.000732421875, -0.0313720703125, 0.040283203125, 0.089385986328125, 0.0738525390625, 0.061920166015625, 0.04443359375, -0.001129150390625, -0.02496337890625, -0.027587890625, -0.063751220703125, -0.09088134765625, -0.078125, -0.062225341796875, -0.0533447265625, -0.032196044921875, -0.013427734375, -0.007232666015625, 0.00543212890625, 0.024139404296875, 0.03125, 0.028167724609375, 0.0252685546875, 0.019622802734375, 0.008148193359375, -0.0023193359375, -0.01043701171875, -0.01837158203125, -0.02117919921875, -0.022796630859375, -0.025238037109375, -0.0272216796875, -0.024505615234375, -0.0185546875, -0.0137939453125, -0.0084228515625, -0.003265380859375, 0.00103759765625, 0.00201416015625, 0.00146484375, 0.002471923828125, 0.00286865234375, 0.00225830078125, -3.0517578125e-05, -0.00335693359375, -0.0062255859375, -0.00732421875, -0.008148193359375, -0.010772705078125, -0.01190185546875, -0.00946044921875, -0.006744384765625, -0.006072998046875, -0.004486083984375, -0.002105712890625, -0.00091552734375, -0.001068115234375, -0.00128173828125, -0.000732421875, -0.00042724609375, -0.0006103515625, -0.000885009765625, -0.001373291015625, -0.00262451171875, -0.004669189453125, -0.006317138671875, -0.006561279296875, -0.005859375, -0.00494384765625, -0.0045166015625, -0.00494384765625, -0.0047607421875, -0.003326416015625, -0.00213623046875, -0.001953125, -0.0023193359375, -0.002685546875, -0.00347900390625, -0.003753662109375, -0.003448486328125, -0.00360107421875, -0.003753662109375, -0.00335693359375, -0.003173828125, -0.00341796875, -0.002960205078125, -0.002471923828125, -0.001556396484375, -0.00091552734375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 6.103515625e-05, 6.103515625e-05, 0.0, 6.103515625e-05, 0.0, 0.0, 0.0, -3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, 6.103515625e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, -6.103515625e-05, 0.000396728515625, 0.0, 0.000274658203125, 0.00042724609375, 0.000396728515625, 3.0517578125e-05, 0.009063720703125, 0.032928466796875, 0.01458740234375, -0.01507568359375, 0.002960205078125, 0.017181396484375, 0.00982666015625, 0.009857177734375, 0.031097412109375, 0.08050537109375, 0.09869384765625, 0.045806884765625, 0.00592041015625, -0.00360107421875, -0.0018310546875, 0.023590087890625, 0.03759765625, 0.034271240234375, 0.036773681640625, 0.032745361328125, 0.0028076171875, -0.0263671875, -0.033050537109375, -0.04815673828125, -0.070587158203125, -0.06317138671875, -0.0416259765625, -0.036041259765625, -0.0284423828125, -0.014801025390625, 0.000152587890625, 0.01129150390625, 0.01788330078125, 0.022216796875, 0.0211181640625, 0.01715087890625, 0.00872802734375, -0.00140380859375, -0.009674072265625, -0.012847900390625, -0.014312744140625, -0.017333984375, -0.019195556640625, -0.019256591796875, -0.01904296875, -0.01861572265625, -0.015655517578125, -0.010498046875, -0.00799560546875, -0.00628662109375, -0.003173828125, 9.1552734375e-05, 0.0015869140625, 0.002532958984375, 0.002532958984375, -0.000244140625, -0.002593994140625, -0.004058837890625, -0.00543212890625, -0.007904052734375, -0.00848388671875, -0.0076904296875, -0.00750732421875, -0.006683349609375, -0.00531005859375, -0.00390625, -0.00341796875, -0.003265380859375, -0.002655029296875, -0.002410888671875, -0.00128173828125, -0.00030517578125, -0.001251220703125, -0.002044677734375, -0.001800537109375, -0.0023193359375, -0.00433349609375, -0.00531005859375, -0.005279541015625, -0.005035400390625, -0.004852294921875, -0.005340576171875, -0.00567626953125, -0.005096435546875, -0.00360107421875, -0.002532958984375, -0.002655029296875, -0.002838134765625, -0.0025634765625, -0.0028076171875, -0.003814697265625, -0.0042724609375, -0.003753662109375, -0.00274658203125, -0.00164794921875, -0.00140380859375, -0.00146484375, -0.001861572265625, -0.001861572265625, -0.00177001953125, -0.001678466796875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0, 9.1552734375e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 9.1552734375e-05, -0.0001220703125, 0.0001220703125, 0.0003662109375, -6.103515625e-05, 0.000274658203125, 0.000396728515625, 0.00030517578125, 0.005157470703125, 0.03375244140625, 0.027130126953125, -0.0166015625, -0.00537109375, 0.0194091796875, 0.010223388671875, 0.002410888671875, 0.02215576171875, 0.068389892578125, 0.090179443359375, 0.063018798828125, 0.0406494140625, 0.021820068359375, 0.00347900390625, -0.00848388671875, -0.027587890625, -0.013397216796875, 0.01397705078125, 0.01953125, 0.02734375, 0.028167724609375, 0.00750732421875, -0.017242431640625, -0.02508544921875, -0.031494140625, -0.043060302734375, -0.045684814453125, -0.0379638671875, -0.03216552734375, -0.0247802734375, -0.00946044921875, -0.00091552734375, 0.003814697265625, 0.01019287109375, 0.014617919921875, 0.0113525390625, 0.003875732421875, 0.00042724609375, -0.00286865234375, -0.007659912109375, -0.009674072265625, -0.0096435546875, -0.01153564453125, -0.014495849609375, -0.014373779296875, -0.014007568359375, -0.014312744140625, -0.015411376953125, -0.013885498046875, -0.00970458984375, -0.006927490234375, -0.0025634765625, -0.000579833984375, -0.000152587890625, 9.1552734375e-05, -0.0003662109375, -0.001678466796875, -0.00384521484375, -0.003692626953125, -0.003265380859375, -0.00445556640625, -0.00567626953125, -0.005828857421875, -0.005096435546875, -0.004638671875, -0.00396728515625, -0.005035400390625, -0.005218505859375, -0.003936767578125, -0.002410888671875, -0.0018310546875, -0.002685546875, -0.00244140625, -0.003265380859375, -0.003662109375, -0.00286865234375, -0.002471923828125, -0.00299072265625, -0.003692626953125, -0.0042724609375, -0.005706787109375, -0.00628662109375, -0.0054931640625, -0.004547119140625, -0.004119873046875, -0.003631591796875, -0.0030517578125, -0.003021240234375, -0.00299072265625, -0.003662109375, -0.0040283203125, -0.003448486328125, -0.00250244140625, -0.0018310546875, -0.00103759765625, -0.00030517578125, -0.0001220703125, -0.00054931640625, -0.00146484375, -0.002227783203125, -0.002960205078125])
        IR_LEFT[len(IR_LEFT)-1].append([6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 0.000152587890625, -0.0001220703125, 0.000274658203125, 6.103515625e-05, 0.000335693359375, 0.000152587890625, 0.000823974609375, 0.002227783203125, 0.031494140625, 0.041015625, -0.01324462890625, -0.01690673828125, 0.0194091796875, 0.013641357421875, -0.00091552734375, 0.015838623046875, 0.069793701171875, 0.099456787109375, 0.059783935546875, 0.027069091796875, 0.028656005859375, 0.026702880859375, 0.00360107421875, -0.02874755859375, -0.03961181640625, -0.036041259765625, -0.02056884765625, 0.00592041015625, 0.017730712890625, 0.0252685546875, 0.0341796875, 0.016998291015625, -0.007537841796875, -0.005706787109375, -0.010894775390625, -0.03570556640625, -0.0455322265625, -0.033660888671875, -0.02349853515625, -0.0238037109375, -0.016448974609375, -0.006561279296875, -0.001861572265625, 0.001068115234375, 0.002044677734375, 0.00030517578125, 0.00128173828125, 0.00372314453125, 0.000762939453125, -0.00360107421875, -0.0045166015625, -0.0048828125, -0.008453369140625, -0.0107421875, -0.0115966796875, -0.014190673828125, -0.01617431640625, -0.01556396484375, -0.01190185546875, -0.00860595703125, -0.007110595703125, -0.004913330078125, -0.00335693359375, -0.002655029296875, -0.0028076171875, -0.002044677734375, -0.000396728515625, 0.000732421875, 0.000213623046875, -0.00213623046875, -0.004150390625, -0.0035400390625, -0.00286865234375, -0.0042724609375, -0.0052490234375, -0.0052490234375, -0.005157470703125, -0.00482177734375, -0.003997802734375, -0.00360107421875, -0.0045166015625, -0.00537109375, -0.004791259765625, -0.003387451171875, -0.002471923828125, -0.00189208984375, -0.001312255859375, -0.00225830078125, -0.0042724609375, -0.0059814453125, -0.005950927734375, -0.005035400390625, -0.00457763671875, -0.00396728515625, -0.003875732421875, -0.0037841796875, -0.003692626953125, -0.003997802734375, -0.004119873046875, -0.003326416015625, -0.00201416015625, -0.00128173828125, -0.00103759765625, -0.00079345703125, 0.000152587890625, 0.00067138671875, -9.1552734375e-05, -0.001495361328125, -0.00299072265625, -0.0037841796875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, 0.0, 0.0, 3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 0.0, 9.1552734375e-05, 6.103515625e-05, 0.000213623046875, -6.103515625e-05, 0.000274658203125, -0.00018310546875, 0.00048828125, -0.000152587890625, 0.001190185546875, 0.000701904296875, 0.0264892578125, 0.053436279296875, -0.003509521484375, -0.029693603515625, 0.0150146484375, 0.019561767578125, -0.003936767578125, 0.00958251953125, 0.0758056640625, 0.112030029296875, 0.063995361328125, 0.027069091796875, 0.0252685546875, 0.01080322265625, 0.001007080078125, -0.014373779296875, -0.03887939453125, -0.040863037109375, -0.03369140625, -0.032501220703125, -0.017822265625, 0.009246826171875, 0.02825927734375, 0.03265380859375, 0.03448486328125, 0.032196044921875, 0.013092041015625, -0.004669189453125, -0.015777587890625, -0.031768798828125, -0.0361328125, -0.02996826171875, -0.0283203125, -0.02789306640625, -0.020843505859375, -0.014556884765625, -0.0123291015625, -0.010009765625, -0.002044677734375, 0.004730224609375, 0.00640869140625, 0.0069580078125, 0.00457763671875, 0.00146484375, -0.00079345703125, -0.00396728515625, -0.009490966796875, -0.011932373046875, -0.0120849609375, -0.01263427734375, -0.013763427734375, -0.014251708984375, -0.01226806640625, -0.0101318359375, -0.008544921875, -0.008514404296875, -0.00750732421875, -0.002593994140625, 0.001556396484375, 0.002166748046875, 0.001800537109375, 0.001220703125, 9.1552734375e-05, -0.0013427734375, -0.002166748046875, -0.00225830078125, -0.0029296875, -0.004364013671875, -0.005340576171875, -0.005584716796875, -0.0057373046875, -0.005706787109375, -0.00653076171875, -0.007415771484375, -0.006622314453125, -0.004608154296875, -0.002899169921875, -0.002532958984375, -0.00146484375, -0.001190185546875, -0.002655029296875, -0.00408935546875, -0.0050048828125, -0.00494384765625, -0.00457763671875, -0.004180908203125, -0.00384521484375, -0.00384521484375, -0.00469970703125, -0.005096435546875, -0.004302978515625, -0.003326416015625, -0.002105712890625, -0.00140380859375, -0.00128173828125, -0.0006103515625, 0.000213623046875, 0.00030517578125, -0.000152587890625, -0.00091552734375, -0.002105712890625, -0.00335693359375, -0.00408935546875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -0.000152587890625, 0.000244140625, -0.00018310546875, 0.00018310546875, -0.000152587890625, 0.00030517578125, -6.103515625e-05, 0.000823974609375, 0.000518798828125, 0.02056884765625, 0.062652587890625, 0.011444091796875, -0.041473388671875, 0.006256103515625, 0.02520751953125, -0.00396728515625, 0.002410888671875, 0.079620361328125, 0.1300048828125, 0.071502685546875, 0.02386474609375, 0.02850341796875, 0.010009765625, -0.00909423828125, -0.02935791015625, -0.050811767578125, -0.038543701171875, -0.029144287109375, -0.033538818359375, -0.027679443359375, -0.018310546875, 0.002899169921875, 0.022003173828125, 0.030059814453125, 0.04327392578125, 0.04815673828125, 0.02923583984375, 0.003631591796875, -0.008148193359375, -0.011505126953125, -0.025970458984375, -0.03704833984375, -0.033538818359375, -0.032135009765625, -0.033660888671875, -0.030517578125, -0.02496337890625, -0.0152587890625, -0.0030517578125, 0.00445556640625, 0.007720947265625, 0.010040283203125, 0.011566162109375, 0.00775146484375, 0.0001220703125, -0.003936767578125, -0.006011962890625, -0.008758544921875, -0.010040283203125, -0.011383056640625, -0.012969970703125, -0.014190673828125, -0.014007568359375, -0.013397216796875, -0.0142822265625, -0.01153564453125, -0.00482177734375, -0.000885009765625, 0.0003662109375, 0.001007080078125, 0.002166748046875, 0.0020751953125, 0.000335693359375, 0.0003662109375, 0.000823974609375, -0.0006103515625, -0.00286865234375, -0.003753662109375, -0.005401611328125, -0.006072998046875, -0.006256103515625, -0.0081787109375, -0.0093994140625, -0.008575439453125, -0.00555419921875, -0.00457763671875, -0.00384521484375, -0.002166748046875, -0.001708984375, -0.0025634765625, -0.004058837890625, -0.003997802734375, -0.00390625, -0.00341796875, -0.0030517578125, -0.003631591796875, -0.004364013671875, -0.0050048828125, -0.00469970703125, -0.0047607421875, -0.00408935546875, -0.002593994140625, -0.00164794921875, -0.001373291015625, -0.00128173828125, -0.00018310546875, 0.0, -0.000701904296875, -0.00140380859375, -0.00225830078125, -0.002960205078125, -0.003631591796875, -0.003936767578125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 6.103515625e-05, -6.103515625e-05, 9.1552734375e-05, -9.1552734375e-05, 0.0001220703125, 3.0517578125e-05, 6.103515625e-05, 0.0, 0.00018310546875, 0.00018310546875, 0.0003662109375, 0.00079345703125, 0.014984130859375, 0.068603515625, 0.030487060546875, -0.050201416015625, -0.007568359375, 0.0299072265625, -0.00164794921875, -0.0042724609375, 0.083526611328125, 0.14923095703125, 0.080108642578125, 0.022216796875, 0.0330810546875, 0.00946044921875, -0.01556396484375, -0.0325927734375, -0.0650634765625, -0.0609130859375, -0.035980224609375, -0.02886962890625, -0.028106689453125, -0.0172119140625, 0.00396728515625, 0.006011962890625, 0.00860595703125, 0.03497314453125, 0.047271728515625, 0.03546142578125, 0.028778076171875, 0.01959228515625, 0.00408935546875, -0.006805419921875, -0.01513671875, -0.026519775390625, -0.038909912109375, -0.04052734375, -0.0406494140625, -0.042572021484375, -0.03173828125, -0.01434326171875, -0.0052490234375, 0.0001220703125, 0.0086669921875, 0.014434814453125, 0.010467529296875, 0.007110595703125, 0.005218505859375, 0.000396728515625, -0.00396728515625, -0.006561279296875, -0.0087890625, -0.01220703125, -0.012603759765625, -0.012542724609375, -0.01544189453125, -0.01702880859375, -0.011932373046875, -0.006317138671875, -0.005035400390625, -0.004241943359375, -0.0018310546875, 0.001068115234375, 0.00079345703125, 0.0003662109375, 0.002471923828125, 0.003509521484375, 0.002349853515625, -0.00054931640625, -0.003173828125, -0.00439453125, -0.0048828125, -0.005035400390625, -0.0072021484375, -0.00946044921875, -0.009368896484375, -0.007781982421875, -0.005706787109375, -0.004547119140625, -0.003753662109375, -0.002899169921875, -0.003021240234375, -0.003936767578125, -0.004913330078125, -0.003875732421875, -0.0023193359375, -0.001617431640625, -0.001983642578125, -0.003631591796875, -0.004852294921875, -0.00506591796875, -0.004180908203125, -0.003387451171875, -0.002685546875, -0.00225830078125, -0.001983642578125, -0.00128173828125, -0.000946044921875, -0.000885009765625, -0.00140380859375, -0.002197265625, -0.0028076171875, -0.003326416015625, -0.003265380859375, -0.003173828125, -0.00341796875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0001220703125, 3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, -9.1552734375e-05, 6.103515625e-05, -0.000152587890625, 0.000518798828125, -0.000213623046875, 0.0013427734375, 0.010284423828125, 0.07061767578125, 0.05133056640625, -0.05401611328125, -0.02490234375, 0.032196044921875, 0.001495361328125, -0.01019287109375, 0.088134765625, 0.169677734375, 0.0894775390625, 0.018646240234375, 0.03802490234375, 0.013275146484375, -0.023529052734375, -0.0369873046875, -0.07257080078125, -0.07806396484375, -0.04583740234375, -0.0372314453125, -0.038238525390625, -0.019378662109375, 0.01080322265625, 0.01593017578125, 0.0103759765625, 0.0242919921875, 0.032745361328125, 0.027801513671875, 0.024322509765625, 0.0220947265625, 0.02081298828125, 0.0146484375, 0.000152587890625, -0.010406494140625, -0.019073486328125, -0.034423828125, -0.047393798828125, -0.0484619140625, -0.04022216796875, -0.0281982421875, -0.0186767578125, -0.00860595703125, -9.1552734375e-05, 0.00482177734375, 0.009429931640625, 0.010894775390625, 0.009918212890625, 0.007537841796875, 0.00201416015625, -0.002655029296875, -0.005767822265625, -0.0093994140625, -0.011871337890625, -0.013153076171875, -0.012969970703125, -0.01214599609375, -0.0111083984375, -0.008636474609375, -0.00665283203125, -0.006988525390625, -0.00543212890625, -0.003875732421875, -0.002899169921875, -0.000762939453125, 0.002593994140625, 0.004547119140625, 0.002899169921875, 0.00054931640625, -0.001434326171875, -0.003631591796875, -0.0045166015625, -0.00360107421875, -0.004852294921875, -0.00762939453125, -0.0087890625, -0.00762939453125, -0.006134033203125, -0.006134033203125, -0.00537109375, -0.004241943359375, -0.00457763671875, -0.005126953125, -0.00518798828125, -0.0045166015625, -0.00299072265625, -0.00128173828125, -0.001190185546875, -0.0029296875, -0.00445556640625, -0.004486083984375, -0.003631591796875, -0.0030517578125, -0.001983642578125, -0.001434326171875, -0.0020751953125, -0.00262451171875, -0.002227783203125, -0.001708984375, -0.002471923828125, -0.00341796875, -0.003936767578125, -0.003997802734375, -0.0035400390625, -0.003082275390625, -0.002838134765625, -0.00299072265625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, 0.0, 0.0, 0.0, 0.0, -6.103515625e-05, 0.00018310546875, -0.000152587890625, 0.000244140625, -0.000396728515625, 0.000640869140625, -0.000518798828125, 0.00177001953125, 0.006866455078125, 0.070648193359375, 0.071807861328125, -0.05303955078125, -0.044158935546875, 0.032196044921875, 0.006256103515625, -0.01666259765625, 0.092742919921875, 0.1922607421875, 0.099945068359375, 0.01483154296875, 0.04217529296875, 0.01690673828125, -0.029632568359375, -0.040374755859375, -0.079559326171875, -0.094146728515625, -0.05511474609375, -0.04107666015625, -0.04547119140625, -0.030548095703125, 0.00537109375, 0.022613525390625, 0.0174560546875, 0.032989501953125, 0.040435791015625, 0.0191650390625, 0.00848388671875, 0.015594482421875, 0.015167236328125, 0.0111083984375, 0.012451171875, 0.010498046875, -0.006072998046875, -0.02294921875, -0.031280517578125, -0.042144775390625, -0.043792724609375, -0.03167724609375, -0.023773193359375, -0.019744873046875, -0.014862060546875, -0.004058837890625, 0.003814697265625, 0.0059814453125, 0.01025390625, 0.009368896484375, 0.004852294921875, 0.00152587890625, -0.001220703125, -0.007293701171875, -0.011077880859375, -0.009185791015625, -0.007293701171875, -0.0096435546875, -0.010223388671875, -0.006500244140625, -0.005828857421875, -0.007659912109375, -0.008087158203125, -0.006866455078125, -0.005462646484375, -0.00384521484375, -0.0003662109375, 0.00274658203125, 0.002593994140625, 0.00091552734375, -0.0009765625, -0.0035400390625, -0.00372314453125, -0.0023193359375, -0.00323486328125, -0.006103515625, -0.00677490234375, -0.005126953125, -0.004974365234375, -0.0057373046875, -0.00579833984375, -0.005340576171875, -0.005828857421875, -0.00640869140625, -0.005889892578125, -0.005157470703125, -0.003448486328125, -0.001617431640625, -0.001678466796875, -0.00360107421875, -0.004425048828125, -0.003875732421875, -0.0028076171875, -0.001190185546875, -0.000152587890625, -0.000732421875, -0.0023193359375, -0.00311279296875, -0.00274658203125, -0.002532958984375, -0.00335693359375, -0.00433349609375, -0.004302978515625, -0.00439453125, -0.00421142578125, -0.00323486328125, -0.00262451171875, -0.002593994140625, -0.00299072265625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -6.103515625e-05, -9.1552734375e-05, -9.1552734375e-05, -9.1552734375e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -9.1552734375e-05, 0.0, -3.0517578125e-05, 0.0, -9.1552734375e-05, 0.00018310546875, -0.000335693359375, 0.00042724609375, -0.0006103515625, 0.0008544921875, -0.000946044921875, 0.001953125, 0.0045166015625, 0.069366455078125, 0.09112548828125, -0.048919677734375, -0.06439208984375, 0.029571533203125, 0.012359619140625, -0.0228271484375, 0.0977783203125, 0.216583251953125, 0.108612060546875, 0.010772705078125, 0.049041748046875, 0.0196533203125, -0.039520263671875, -0.043212890625, -0.08245849609375, -0.1104736328125, -0.06640625, -0.04278564453125, -0.05230712890625, -0.038665771484375, 0.00384521484375, 0.021514892578125, 0.0145263671875, 0.03857421875, 0.05035400390625, 0.0269775390625, 0.011016845703125, 0.00775146484375, 0.002777099609375, 0.00201416015625, 0.004058837890625, 0.006591796875, 0.005035400390625, -0.006561279296875, -0.02301025390625, -0.032257080078125, -0.028533935546875, -0.02294921875, -0.023895263671875, -0.02569580078125, -0.02020263671875, -0.011474609375, -0.005340576171875, -0.0006103515625, 0.002960205078125, 0.004730224609375, 0.003448486328125, 0.001251220703125, -0.0015869140625, -0.00567626953125, -0.0047607421875, -0.00238037109375, -0.005035400390625, -0.008331298828125, -0.007232666015625, -0.00421142578125, -0.00408935546875, -0.00665283203125, -0.007965087890625, -0.00726318359375, -0.0064697265625, -0.00592041015625, -0.0040283203125, -0.001190185546875, -9.1552734375e-05, -0.000701904296875, -0.001861572265625, -0.00311279296875, -0.003570556640625, -0.002410888671875, -0.0028076171875, -0.004669189453125, -0.004974365234375, -0.00347900390625, -0.003204345703125, -0.00445556640625, -0.004730224609375, -0.004364013671875, -0.00555419921875, -0.0069580078125, -0.00653076171875, -0.005889892578125, -0.004486083984375, -0.003204345703125, -0.0035400390625, -0.004730224609375, -0.005218505859375, -0.004486083984375, -0.002288818359375, 0.00042724609375, 0.00128173828125, -3.0517578125e-05, -0.0025634765625, -0.00396728515625, -0.003631591796875, -0.00311279296875, -0.0035400390625, -0.004425048828125, -0.00482177734375, -0.0050048828125, -0.0048828125, -0.00372314453125, -0.00274658203125, -0.00262451171875, -0.003143310546875, -0.0035400390625])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, -9.1552734375e-05, 0.0, -6.103515625e-05, -9.1552734375e-05, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, 0.0, -6.103515625e-05, 0.0001220703125, -0.000213623046875, 0.000274658203125, -0.000457763671875, 0.00042724609375, -0.000701904296875, 0.001007080078125, -0.0010986328125, 0.001861572265625, 0.002777099609375, 0.06744384765625, 0.109039306640625, -0.04144287109375, -0.084320068359375, 0.02349853515625, 0.01983642578125, -0.028167724609375, 0.101593017578125, 0.243743896484375, 0.11737060546875, 0.004058837890625, 0.057037353515625, 0.0264892578125, -0.0517578125, -0.04986572265625, -0.0821533203125, -0.124969482421875, -0.0784912109375, -0.044158935546875, -0.057861328125, -0.04595947265625, 0.00128173828125, 0.0238037109375, 0.01483154296875, 0.037445068359375, 0.054840087890625, 0.031982421875, 0.01239013671875, 0.014129638671875, 0.0064697265625, -0.00830078125, -0.007843017578125, -0.001373291015625, -0.00347900390625, -0.01104736328125, -0.0133056640625, -0.01947021484375, -0.021453857421875, -0.013092041015625, -0.012237548828125, -0.015655517578125, -0.01708984375, -0.012908935546875, -0.0089111328125, -0.008392333984375, -0.004730224609375, -0.002044677734375, -0.00360107421875, -0.007537841796875, -0.005767822265625, -0.00152587890625, 0.000274658203125, -0.000396728515625, -0.00177001953125, -0.004302978515625, -0.00579833984375, -0.0025634765625, -0.00189208984375, -0.003997802734375, -0.00555419921875, -0.005279541015625, -0.006378173828125, -0.00787353515625, -0.005096435546875, -0.0020751953125, -0.0035400390625, -0.0050048828125, -0.003570556640625, -0.004119873046875, -0.004974365234375, -0.002838134765625, -0.001983642578125, -0.003692626953125, -0.00421142578125, -0.002655029296875, -0.002716064453125, -0.003692626953125, -0.002349853515625, -0.002166748046875, -0.00396728515625, -0.004913330078125, -0.005584716796875, -0.0059814453125, -0.00537109375, -0.004669189453125, -0.005157470703125, -0.006622314453125, -0.006500244140625, -0.0045166015625, -0.002044677734375, 0.0003662109375, 0.00164794921875, 0.000152587890625, -0.00286865234375, -0.00457763671875, -0.0040283203125, -0.002838134765625, -0.002716064453125, -0.003753662109375, -0.004852294921875, -0.00518798828125, -0.004791259765625, -0.0037841796875, -0.002960205078125, -0.003082275390625, -0.003387451171875, -0.00347900390625, -0.002960205078125])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, -9.1552734375e-05, -6.103515625e-05, 9.1552734375e-05, -3.0517578125e-05, 0.0001220703125, -0.00018310546875, 0.000335693359375, -0.000518798828125, 0.00054931640625, -0.000762939453125, 0.0009765625, -0.000946044921875, 0.001800537109375, 0.001617431640625, 0.065093994140625, 0.124969482421875, -0.031524658203125, -0.102630615234375, 0.01483154296875, 0.02691650390625, -0.031829833984375, 0.1041259765625, 0.271697998046875, 0.127410888671875, -0.00421142578125, 0.06494140625, 0.03521728515625, -0.062774658203125, -0.06097412109375, -0.08074951171875, -0.13629150390625, -0.093994140625, -0.04412841796875, -0.061431884765625, -0.05426025390625, 0.000335693359375, 0.026458740234375, 0.01312255859375, 0.038726806640625, 0.061065673828125, 0.0341796875, 0.010986328125, 0.0140380859375, 0.009918212890625, -0.004974365234375, -0.00897216796875, -0.010162353515625, -0.013946533203125, -0.018280029296875, -0.02069091796875, -0.022064208984375, -0.017852783203125, -0.00634765625, 0.0003662109375, -0.002532958984375, -0.0050048828125, -0.004730224609375, -0.006439208984375, -0.0091552734375, -0.007415771484375, -0.007965087890625, -0.01458740234375, -0.016204833984375, -0.008056640625, -0.003631591796875, -0.004638671875, -0.000732421875, 0.001129150390625, -0.00201416015625, -0.003997802734375, -0.0008544921875, 0.00177001953125, -0.00115966796875, -0.00360107421875, -0.0035400390625, -0.004669189453125, -0.006103515625, -0.004547119140625, -0.003021240234375, -0.004486083984375, -0.00567626953125, -0.006561279296875, -0.008758544921875, -0.008636474609375, -0.00323486328125, -0.000457763671875, -0.003662109375, -0.00482177734375, -0.003265380859375, -0.0023193359375, -0.002288818359375, -0.00140380859375, -0.00030517578125, -0.001251220703125, -0.0025634765625, -0.003814697265625, -0.005523681640625, -0.005889892578125, -0.00494384765625, -0.0052490234375, -0.00689697265625, -0.00732421875, -0.00579833984375, -0.0030517578125, -0.00030517578125, 0.000701904296875, -0.00140380859375, -0.004608154296875, -0.005340576171875, -0.00360107421875, -0.00177001953125, -0.00164794921875, -0.00286865234375, -0.004241943359375, -0.0050048828125, -0.00439453125, -0.0035400390625, -0.0030517578125, -0.00323486328125, -0.00396728515625, -0.0040283203125, -0.0030517578125, -0.00146484375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, -0.0001220703125, 6.103515625e-05, 0.0, 0.00018310546875, -0.000213623046875, 0.00042724609375, -0.00054931640625, 0.00054931640625, -0.000823974609375, 0.001007080078125, -0.000946044921875, 0.001861572265625, 0.000946044921875, 0.0633544921875, 0.13848876953125, -0.02117919921875, -0.117919921875, 0.003814697265625, 0.03314208984375, -0.0338134765625, 0.105743408203125, 0.300628662109375, 0.13836669921875, -0.013519287109375, 0.07281494140625, 0.044403076171875, -0.072174072265625, -0.074005126953125, -0.0826416015625, -0.14324951171875, -0.109466552734375, -0.04754638671875, -0.06304931640625, -0.062347412109375, 0.000640869140625, 0.030242919921875, 0.012359619140625, 0.038330078125, 0.065093994140625, 0.04046630859375, 0.011871337890625, 0.0113525390625, 0.009521484375, -0.0076904296875, -0.009124755859375, -0.006195068359375, -0.017974853515625, -0.0269775390625, -0.026031494140625, -0.03350830078125, -0.0289306640625, -0.00421142578125, 0.009521484375, 0.006866455078125, 0.002838134765625, 0.00677490234375, 0.0059814453125, -0.002166748046875, -0.00665283203125, -0.010833740234375, -0.014984130859375, -0.015777587890625, -0.01605224609375, -0.014434814453125, -0.00872802734375, -0.002532958984375, -0.0020751953125, -0.00653076171875, -0.004913330078125, 0.003173828125, 0.004730224609375, 0.000640869140625, -0.001190185546875, -0.00091552734375, -0.002532958984375, -0.00457763671875, -0.003631591796875, -0.000640869140625, -0.002166748046875, -0.00628662109375, -0.008544921875, -0.011260986328125, -0.01129150390625, -0.00640869140625, -0.00274658203125, -0.004364013671875, -0.005767822265625, -0.0032958984375, -0.001922607421875, -0.00244140625, -0.00030517578125, 0.00164794921875, 0.001129150390625, -0.0013427734375, -0.003631591796875, -0.00518798828125, -0.00445556640625, -0.002960205078125, -0.003662109375, -0.00579833984375, -0.0076904296875, -0.00677490234375, -0.004364013671875, -0.001953125, -0.001617431640625, -0.003936767578125, -0.00677490234375, -0.007110595703125, -0.003997802734375, -0.00091552734375, -0.00030517578125, -0.00140380859375, -0.0032958984375, -0.004364013671875, -0.003875732421875, -0.0028076171875, -0.002655029296875, -0.003631591796875, -0.004486083984375, -0.004730224609375, -0.003662109375, -0.00164794921875, 0.00042724609375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -9.1552734375e-05, 6.103515625e-05, -9.1552734375e-05, 0.000213623046875, -0.000244140625, 0.000396728515625, -0.000640869140625, 0.000518798828125, -0.00079345703125, 0.0008544921875, -0.000946044921875, 0.0018310546875, 0.000579833984375, 0.06201171875, 0.1497802734375, -0.010528564453125, -0.1297607421875, -0.008026123046875, 0.03704833984375, -0.033660888671875, 0.10528564453125, 0.3275146484375, 0.15325927734375, -0.023223876953125, 0.07940673828125, 0.05450439453125, -0.080413818359375, -0.0865478515625, -0.086334228515625, -0.150482177734375, -0.123260498046875, -0.051727294921875, -0.06365966796875, -0.071502685546875, -0.00164794921875, 0.037841796875, 0.012451171875, 0.03729248046875, 0.06964111328125, 0.04345703125, 0.01434326171875, 0.012451171875, 0.00830078125, -0.010955810546875, -0.01251220703125, -0.007537841796875, -0.016143798828125, -0.028594970703125, -0.0367431640625, -0.03826904296875, -0.028350830078125, -0.012847900390625, 0.000152587890625, 0.008392333984375, 0.012420654296875, 0.014495849609375, 0.01251220703125, 0.006561279296875, 0.00225830078125, 0.0008544921875, -0.006683349609375, -0.019439697265625, -0.02178955078125, -0.01690673828125, -0.013031005859375, -0.010223388671875, -0.010040283203125, -0.0101318359375, -0.00738525390625, -0.00079345703125, 0.002899169921875, 0.0029296875, 0.00152587890625, 0.0023193359375, 0.00115966796875, -0.0028076171875, -0.0006103515625, 0.00238037109375, -0.00079345703125, -0.0062255859375, -0.00787353515625, -0.010650634765625, -0.012847900390625, -0.00872802734375, -0.00543212890625, -0.0079345703125, -0.00811767578125, -0.003875732421875, -0.00213623046875, -0.0015869140625, 0.001251220703125, 0.0025634765625, 0.00079345703125, -0.00140380859375, -0.003143310546875, -0.003936767578125, -0.0029296875, -0.00067138671875, -0.000579833984375, -0.003875732421875, -0.006744384765625, -0.00732421875, -0.00616455078125, -0.004638671875, -0.00408935546875, -0.005035400390625, -0.00823974609375, -0.00921630859375, -0.0059814453125, -0.00140380859375, 0.000396728515625, -0.000396728515625, -0.0018310546875, -0.003173828125, -0.00286865234375, -0.0020751953125, -0.002227783203125, -0.0032958984375, -0.00439453125, -0.0050048828125, -0.004425048828125, -0.00238037109375, -9.1552734375e-05, 0.000640869140625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, -9.1552734375e-05, -9.1552734375e-05, 0.0001220703125, -0.0001220703125, 0.00018310546875, -0.000213623046875, 0.000457763671875, -0.000701904296875, 0.000518798828125, -0.000823974609375, 0.000885009765625, -0.00103759765625, 0.00164794921875, 0.00048828125, 0.062286376953125, 0.15863037109375, -0.00225830078125, -0.1376953125, -0.018890380859375, 0.037994384765625, -0.031829833984375, 0.105438232421875, 0.350067138671875, 0.17071533203125, -0.03009033203125, 0.083587646484375, 0.06414794921875, -0.087066650390625, -0.100067138671875, -0.090087890625, -0.15625, -0.138702392578125, -0.057708740234375, -0.06207275390625, -0.07769775390625, -0.006317138671875, 0.04290771484375, 0.015838623046875, 0.03668212890625, 0.073883056640625, 0.048553466796875, 0.0137939453125, 0.011474609375, 0.009490966796875, -0.010955810546875, -0.01556396484375, -0.008270263671875, -0.02215576171875, -0.039520263671875, -0.03216552734375, -0.03375244140625, -0.03448486328125, -0.019073486328125, -0.004180908203125, 0.004425048828125, 0.0078125, 0.01495361328125, 0.01507568359375, 0.012664794921875, 0.0186767578125, 0.016326904296875, -0.001556396484375, -0.014801025390625, -0.01593017578125, -0.01690673828125, -0.01953125, -0.017364501953125, -0.013824462890625, -0.015960693359375, -0.01580810546875, -0.00592041015625, 0.00091552734375, 0.00146484375, 0.001190185546875, 0.001708984375, 0.002227783203125, 0.002197265625, 0.003936767578125, 0.005462646484375, 0.00177001953125, -0.003662109375, -0.007293701171875, -0.01129150390625, -0.01348876953125, -0.00933837890625, -0.00537109375, -0.008697509765625, -0.011077880859375, -0.007110595703125, -0.003143310546875, -0.00189208984375, 0.001373291015625, 0.00274658203125, -0.000213623046875, -0.002105712890625, -0.0020751953125, -0.001495361328125, -0.00079345703125, 0.000701904296875, 0.0009765625, -0.00140380859375, -0.004364013671875, -0.00689697265625, -0.0081787109375, -0.00738525390625, -0.005859375, -0.006561279296875, -0.00970458984375, -0.0106201171875, -0.006988525390625, -0.0020751953125, -0.000213623046875, -0.00054931640625, -0.00128173828125, -0.001953125, -0.00177001953125, -0.00091552734375, -0.001068115234375, -0.0028076171875, -0.004180908203125, -0.004425048828125, -0.00421142578125, -0.003204345703125, -0.0010986328125, -9.1552734375e-05, -0.00115966796875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, -9.1552734375e-05, -0.000152587890625, 0.0001220703125, -9.1552734375e-05, 0.000152587890625, -0.000213623046875, 0.00048828125, -0.000701904296875, 0.000579833984375, -0.00079345703125, 0.000885009765625, -0.001129150390625, 0.00164794921875, 0.00030517578125, 0.06390380859375, 0.164764404296875, 0.003997802734375, -0.140472412109375, -0.028228759765625, 0.036163330078125, -0.02886962890625, 0.10626220703125, 0.3646240234375, 0.18994140625, -0.02935791015625, 0.084869384765625, 0.0716552734375, -0.090240478515625, -0.113037109375, -0.097320556640625, -0.157928466796875, -0.152313232421875, -0.069610595703125, -0.061065673828125, -0.079864501953125, -0.010467529296875, 0.04583740234375, 0.020233154296875, 0.03546142578125, 0.075714111328125, 0.056365966796875, 0.015228271484375, 0.00799560546875, 0.009735107421875, -0.0093994140625, -0.01605224609375, -0.017059326171875, -0.026153564453125, -0.034393310546875, -0.03741455078125, -0.040191650390625, -0.033721923828125, -0.018218994140625, -0.007537841796875, 0.000732421875, 0.003021240234375, 0.00567626953125, 0.01312255859375, 0.024322509765625, 0.028289794921875, 0.01800537109375, 0.00762939453125, -0.0010986328125, -0.00738525390625, -0.015380859375, -0.02020263671875, -0.01702880859375, -0.0181884765625, -0.0235595703125, -0.022857666015625, -0.011932373046875, -0.00311279296875, -0.000762939453125, -0.001312255859375, 0.000244140625, 0.002288818359375, 0.002716064453125, 0.005828857421875, 0.009307861328125, 0.005828857421875, -0.001068115234375, -0.005340576171875, -0.01068115234375, -0.01312255859375, -0.008880615234375, -0.00494384765625, -0.008544921875, -0.011016845703125, -0.00799560546875, -0.0057373046875, -0.004852294921875, -0.0009765625, 0.001983642578125, -0.00018310546875, -0.001953125, -0.0010986328125, -0.0001220703125, 0.0009765625, 0.002593994140625, 0.0029296875, 0.00018310546875, -0.00390625, -0.006622314453125, -0.008087158203125, -0.008026123046875, -0.007354736328125, -0.0084228515625, -0.0111083984375, -0.011749267578125, -0.007781982421875, -0.002777099609375, -0.000457763671875, -0.000701904296875, -0.00152587890625, -0.001678466796875, -0.001312255859375, -0.0001220703125, 6.103515625e-05, -0.00140380859375, -0.003326416015625, -0.004638671875, -0.004241943359375, -0.003082275390625, -0.001617431640625, -0.000823974609375, -0.0018310546875, -0.003082275390625])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -0.0001220703125, 9.1552734375e-05, -0.0001220703125, 0.00018310546875, -0.000274658203125, 0.00048828125, -0.000762939453125, 0.00054931640625, -0.000946044921875, 0.00103759765625, -0.00140380859375, 0.001861572265625, -0.000244140625, 0.067138671875, 0.16876220703125, 0.005828857421875, -0.137359619140625, -0.035369873046875, 0.030303955078125, -0.024139404296875, 0.1090087890625, 0.370025634765625, 0.2078857421875, -0.0184326171875, 0.08416748046875, 0.075592041015625, -0.08990478515625, -0.1240234375, -0.10772705078125, -0.1593017578125, -0.160888671875, -0.085479736328125, -0.06317138671875, -0.08026123046875, -0.01385498046875, 0.04791259765625, 0.025848388671875, 0.0391845703125, 0.072357177734375, 0.05792236328125, 0.022705078125, 0.008880615234375, 0.00811767578125, -0.012237548828125, -0.026519775390625, -0.015838623046875, -0.018524169921875, -0.03839111328125, -0.04144287109375, -0.043731689453125, -0.03973388671875, -0.020172119140625, -0.005096435546875, -0.0025634765625, -0.005279541015625, 0.006805419921875, 0.021881103515625, 0.020416259765625, 0.021636962890625, 0.02545166015625, 0.01812744140625, 0.004547119140625, -0.00469970703125, -0.00909423828125, -0.01318359375, -0.015899658203125, -0.01898193359375, -0.024871826171875, -0.0267333984375, -0.01708984375, -0.009368896484375, -0.00787353515625, -0.004547119140625, 0.000274658203125, 0.001220703125, 0.001922607421875, 0.007171630859375, 0.011474609375, 0.006805419921875, -0.001434326171875, -0.00433349609375, -0.007598876953125, -0.0101318359375, -0.007537841796875, -0.004150390625, -0.00634765625, -0.0103759765625, -0.009185791015625, -0.00811767578125, -0.008087158203125, -0.0037841796875, 0.001617431640625, 0.00146484375, -0.001617431640625, -0.0020751953125, -0.000946044921875, 0.00189208984375, 0.004730224609375, 0.005096435546875, 0.001129150390625, -0.0037841796875, -0.00634765625, -0.007720947265625, -0.00811767578125, -0.0084228515625, -0.0093994140625, -0.01190185546875, -0.012420654296875, -0.008819580078125, -0.003662109375, -0.001007080078125, -0.001068115234375, -0.001556396484375, -0.002044677734375, -0.00128173828125, 9.1552734375e-05, 0.000823974609375, -0.00042724609375, -0.002655029296875, -0.00408935546875, -0.00439453125, -0.0032958984375, -0.00152587890625, -0.000732421875, -0.0023193359375, -0.003753662109375, -0.003387451171875])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([0.000244140625, -0.00030517578125, 0.000640869140625, -0.00054931640625, 0.000823974609375, -0.000823974609375, 0.00054931640625, -0.000244140625, -0.000335693359375, 0.000823974609375, -0.001220703125, 0.001190185546875, 0.057891845703125, 0.246826171875, -0.016082763671875, -0.131317138671875, 0.023712158203125, -0.178680419921875, 0.082672119140625, 0.22088623046875, 0.098358154296875, 0.34051513671875, 0.3251953125, -0.10467529296875, -0.13916015625, 0.109893798828125, -0.1456298828125, -0.40179443359375, -0.170684814453125, -0.02899169921875, -0.1749267578125, -0.1046142578125, 0.06488037109375, 0.0081787109375, 0.02655029296875, 0.110992431640625, 0.07757568359375, 0.03338623046875, 0.074859619140625, 0.073944091796875, 0.01300048828125, -0.004486083984375, 0.020111083984375, -0.000579833984375, -0.038848876953125, -0.02117919921875, -0.0174560546875, -0.060211181640625, -0.08721923828125, -0.049530029296875, -0.012939453125, -0.007843017578125, -0.009185791015625, -0.01190185546875, -0.01531982421875, -0.0025634765625, 0.00927734375, 0.004913330078125, -0.00390625, 0.00054931640625, 0.007904052734375, 0.0040283203125, -0.00604248046875, -0.00506591796875, -0.002105712890625, -0.013885498046875, -0.01824951171875, -0.017730712890625, -0.019866943359375, -0.011260986328125, 0.000762939453125, -0.00323486328125, -0.0068359375, -0.0006103515625, 0.00018310546875, -0.0035400390625, 0.001068115234375, 0.00445556640625, -0.00225830078125, -0.0081787109375, -0.008148193359375, -0.006378173828125, -0.005157470703125, -0.00555419921875, -0.004547119140625, -0.004486083984375, -0.00689697265625, -0.005706787109375, -0.001861572265625, -3.0517578125e-05, -0.00042724609375, 0.0001220703125, -0.001495361328125, -0.004119873046875, -0.003082275390625, 0.00091552734375, -0.00042724609375, -0.00262451171875, -0.00262451171875, -0.0059814453125, -0.009063720703125, -0.0079345703125, -0.0069580078125, -0.005859375, -0.00360107421875, -0.00421142578125, -0.004669189453125, -0.000518798828125, 0.00384521484375, 0.00543212890625, 0.004150390625, -0.000274658203125, -0.003265380859375, -0.003753662109375, -0.00421142578125, -0.00433349609375, -0.003509521484375, -0.00567626953125, -0.007415771484375, -0.004608154296875, -0.00244140625, -0.001220703125, -0.00054931640625, -0.002838134765625, -0.004852294921875, -0.003448486328125, -0.00201416015625, -0.001617431640625])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000152587890625, 0.000213623046875, -0.00030517578125, 0.000518798828125, -0.00042724609375, 0.00067138671875, -0.000762939453125, 0.00054931640625, -0.00048828125, -0.000152587890625, 0.00048828125, -0.000640869140625, 0.000701904296875, 0.05767822265625, 0.218170166015625, -0.01580810546875, -0.104217529296875, 0.018157958984375, -0.16094970703125, 0.073944091796875, 0.188751220703125, 0.09765625, 0.315093994140625, 0.290130615234375, -0.07373046875, -0.104278564453125, 0.087158203125, -0.14178466796875, -0.347320556640625, -0.154449462890625, -0.04791259765625, -0.158233642578125, -0.087158203125, 0.047882080078125, 0.0010986328125, 0.0277099609375, 0.09320068359375, 0.062896728515625, 0.039794921875, 0.072540283203125, 0.059295654296875, 0.008758544921875, 0.0020751953125, 0.02362060546875, 0.00372314453125, -0.027191162109375, -0.018890380859375, -0.019439697265625, -0.048797607421875, -0.073638916015625, -0.048736572265625, -0.019775390625, -0.0211181640625, -0.01409912109375, -0.00152587890625, -0.006103515625, -0.00128173828125, 0.008514404296875, 0.010284423828125, 0.002197265625, -0.004547119140625, -0.007843017578125, -0.00689697265625, -0.007781982421875, -0.00872802734375, -0.0081787109375, -0.01556396484375, -0.0147705078125, -0.013519287109375, -0.015838623046875, -0.008056640625, 0.00067138671875, -0.00274658203125, -0.006072998046875, -0.00048828125, 0.00146484375, -0.00189208984375, -0.00018310546875, 0.00225830078125, -0.000579833984375, -0.005828857421875, -0.007049560546875, -0.008026123046875, -0.007415771484375, -0.00592041015625, -0.005218505859375, -0.004852294921875, -0.006439208984375, -0.004638671875, -0.0010986328125, 0.00030517578125, 0.000213623046875, 0.0009765625, -0.0010986328125, -0.005096435546875, -0.003509521484375, 0.00042724609375, -0.001312255859375, -0.003448486328125, -0.003570556640625, -0.005706787109375, -0.008026123046875, -0.00640869140625, -0.00628662109375, -0.007354736328125, -0.00567626953125, -0.004730224609375, -0.00396728515625, -0.0009765625, 0.00299072265625, 0.00555419921875, 0.00482177734375, 0.000732421875, -0.00250244140625, -0.003173828125, -0.003692626953125, -0.004119873046875, -0.0037841796875, -0.005645751953125, -0.00653076171875, -0.00439453125, -0.00311279296875, -0.00201416015625, -0.00079345703125, -0.002716064453125, -0.004974365234375, -0.0037841796875, -0.002288818359375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -3.0517578125e-05, 0.00018310546875, -0.000274658203125, 0.000518798828125, -0.00042724609375, 0.00067138671875, -0.00079345703125, 0.000885009765625, -0.000946044921875, 0.00054931640625, -0.000335693359375, 0.000640869140625, -6.103515625e-05, 0.0650634765625, 0.192169189453125, -0.028533935546875, -0.075347900390625, 0.00103759765625, -0.135650634765625, 0.0784912109375, 0.1533203125, 0.1170654296875, 0.293792724609375, 0.240264892578125, -0.053924560546875, -0.07037353515625, 0.053497314453125, -0.1424560546875, -0.290771484375, -0.14410400390625, -0.060516357421875, -0.134246826171875, -0.068634033203125, 0.029693603515625, 0.0028076171875, 0.032562255859375, 0.072357177734375, 0.0546875, 0.048492431640625, 0.061248779296875, 0.041015625, 0.012847900390625, 0.010345458984375, 0.02398681640625, 0.00518798828125, -0.021209716796875, -0.017852783203125, -0.02276611328125, -0.04541015625, -0.057952880859375, -0.042266845703125, -0.0281982421875, -0.023529052734375, -0.0084228515625, 0.00390625, -0.00299072265625, -0.003143310546875, 0.004302978515625, 0.008209228515625, 0.00335693359375, -0.00787353515625, -0.016357421875, -0.013427734375, -0.010955810546875, -0.010498046875, -0.01153564453125, -0.015655517578125, -0.01116943359375, -0.009185791015625, -0.01300048828125, -0.0081787109375, 0.000213623046875, -0.001800537109375, -0.004058837890625, -0.000579833984375, 0.0003662109375, -0.0010986328125, 0.000732421875, 0.00274658203125, 3.0517578125e-05, -0.00433349609375, -0.007232666015625, -0.00921630859375, -0.008026123046875, -0.007049560546875, -0.00543212890625, -0.004852294921875, -0.006072998046875, -0.004241943359375, -0.000518798828125, 0.00054931640625, 0.00018310546875, 0.00054931640625, -0.00091552734375, -0.004486083984375, -0.004486083984375, -0.00115966796875, -0.00177001953125, -0.002838134765625, -0.003570556640625, -0.006256103515625, -0.007537841796875, -0.005523681640625, -0.00592041015625, -0.007568359375, -0.00616455078125, -0.004974365234375, -0.0035400390625, -0.000152587890625, 0.003082275390625, 0.0047607421875, 0.0040283203125, 0.001007080078125, -0.001708984375, -0.00323486328125, -0.004425048828125, -0.0042724609375, -0.00323486328125, -0.00494384765625, -0.00592041015625, -0.00433349609375, -0.0030517578125, -0.001922607421875, -0.0009765625, -0.003173828125, -0.005157470703125, -0.0037841796875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -6.103515625e-05, -6.103515625e-05, 0.0001220703125, -0.000213623046875, 0.00042724609375, -0.000396728515625, 0.0006103515625, -0.000701904296875, 0.00079345703125, -0.00103759765625, 0.0008544921875, -0.00067138671875, 0.001190185546875, -0.000335693359375, 0.06549072265625, 0.1690673828125, -0.027679443359375, -0.0625, -0.005340576171875, -0.11114501953125, 0.064697265625, 0.13824462890625, 0.1263427734375, 0.259307861328125, 0.21185302734375, -0.028350830078125, -0.060211181640625, 0.03057861328125, -0.117340087890625, -0.252288818359375, -0.14361572265625, -0.05609130859375, -0.11163330078125, -0.068450927734375, 0.018310546875, 0.009002685546875, 0.0240478515625, 0.05352783203125, 0.057830810546875, 0.047607421875, 0.04248046875, 0.0400390625, 0.02374267578125, 0.01123046875, 0.021759033203125, 0.009185791015625, -0.016448974609375, -0.017608642578125, -0.0255126953125, -0.045013427734375, -0.043609619140625, -0.0316162109375, -0.033599853515625, -0.02203369140625, 0.00048828125, -0.0001220703125, -0.011627197265625, -0.007049560546875, 0.000762939453125, 0.002532958984375, -0.000885009765625, -0.00750732421875, -0.014556884765625, -0.01446533203125, -0.0130615234375, -0.011627197265625, -0.011749267578125, -0.013092041015625, -0.009307861328125, -0.009124755859375, -0.012176513671875, -0.007110595703125, 0.000244140625, -0.001861572265625, -0.0030517578125, 0.0003662109375, -0.000518798828125, -0.001434326171875, 0.001739501953125, 0.002838134765625, -0.0003662109375, -0.0042724609375, -0.006988525390625, -0.00860595703125, -0.007293701171875, -0.00628662109375, -0.005157470703125, -0.004974365234375, -0.00592041015625, -0.004302978515625, -0.001434326171875, -0.00018310546875, -0.000579833984375, -3.0517578125e-05, -0.001373291015625, -0.004547119140625, -0.00421142578125, -0.001739501953125, -0.00146484375, -0.00225830078125, -0.003570556640625, -0.006195068359375, -0.007415771484375, -0.0059814453125, -0.005767822265625, -0.005523681640625, -0.00457763671875, -0.00457763671875, -0.0035400390625, -0.000396728515625, 0.002655029296875, 0.003631591796875, 0.00274658203125, 0.000244140625, -0.0018310546875, -0.00274658203125, -0.004150390625, -0.00372314453125, -0.00299072265625, -0.004730224609375, -0.005401611328125, -0.003875732421875, -0.0029296875, -0.00262451171875, -0.001678466796875, -0.002899169921875, -0.00421142578125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, -6.103515625e-05, -6.103515625e-05, 9.1552734375e-05, -0.0001220703125, 0.000396728515625, -0.000335693359375, 0.00054931640625, -0.0006103515625, 0.00067138671875, -0.000823974609375, 0.000762939453125, -0.0006103515625, 0.001190185546875, -0.00018310546875, 0.060577392578125, 0.15087890625, -0.021942138671875, -0.056610107421875, -0.002593994140625, -0.09637451171875, 0.04986572265625, 0.13238525390625, 0.121307373046875, 0.2265625, 0.198638916015625, -0.00921630859375, -0.0595703125, 0.02532958984375, -0.08905029296875, -0.228607177734375, -0.137237548828125, -0.04412841796875, -0.101470947265625, -0.07159423828125, 0.015960693359375, 0.007843017578125, 0.00836181640625, 0.047607421875, 0.059844970703125, 0.03472900390625, 0.037994384765625, 0.047210693359375, 0.02392578125, 0.01043701171875, 0.02655029296875, 0.0120849609375, -0.017425537109375, -0.018585205078125, -0.024810791015625, -0.03436279296875, -0.0313720703125, -0.03033447265625, -0.031890869140625, -0.017852783203125, -0.00384521484375, -0.01104736328125, -0.02044677734375, -0.01287841796875, -0.003387451171875, -0.00152587890625, -0.00384521484375, -0.00335693359375, -0.0059814453125, -0.011871337890625, -0.01513671875, -0.0111083984375, -0.00921630859375, -0.01287841796875, -0.011199951171875, -0.010101318359375, -0.009613037109375, -0.004425048828125, -0.0009765625, -0.0025634765625, -0.00201416015625, 6.103515625e-05, -0.0015869140625, -0.002838134765625, 0.00018310546875, 0.002532958984375, 0.000335693359375, -0.003082275390625, -0.005340576171875, -0.006378173828125, -0.005584716796875, -0.005889892578125, -0.00543212890625, -0.005096435546875, -0.00604248046875, -0.005645751953125, -0.0032958984375, -0.001434326171875, -0.000885009765625, -0.00048828125, -0.001556396484375, -0.00408935546875, -0.004302978515625, -0.00152587890625, -0.001373291015625, -0.00250244140625, -0.003204345703125, -0.005218505859375, -0.006988525390625, -0.005950927734375, -0.004608154296875, -0.003814697265625, -0.003326416015625, -0.004058837890625, -0.00408935546875, -0.001617431640625, 0.001617431640625, 0.00286865234375, 0.0015869140625, -0.00079345703125, -0.0020751953125, -0.0023193359375, -0.003326416015625, -0.003631591796875, -0.003021240234375, -0.00408935546875, -0.00482177734375, -0.00372314453125, -0.0032958984375, -0.00286865234375, -0.001617431640625, -0.00238037109375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, 9.1552734375e-05, -9.1552734375e-05, 0.000335693359375, -0.000274658203125, 0.00042724609375, -0.000518798828125, 0.000579833984375, -0.00067138671875, 0.000640869140625, -0.0003662109375, 0.001068115234375, 6.103515625e-05, 0.0521240234375, 0.136627197265625, -0.014373779296875, -0.05230712890625, 0.0032958984375, -0.088104248046875, 0.038726806640625, 0.125823974609375, 0.10845947265625, 0.201019287109375, 0.1904296875, 0.00360107421875, -0.056854248046875, 0.029693603515625, -0.06744384765625, -0.20684814453125, -0.124359130859375, -0.039031982421875, -0.095550537109375, -0.07025146484375, 0.012359619140625, -0.001678466796875, -0.00030517578125, 0.048583984375, 0.052001953125, 0.0281982421875, 0.038604736328125, 0.04608154296875, 0.027191162109375, 0.01654052734375, 0.02545166015625, 0.006378173828125, -0.013916015625, -0.01190185546875, -0.017852783203125, -0.022918701171875, -0.026885986328125, -0.036712646484375, -0.032958984375, -0.015899658203125, -0.01434326171875, -0.0245361328125, -0.028656005859375, -0.01629638671875, -0.004638671875, -0.002532958984375, -0.00091552734375, 0.001953125, 0.0003662109375, -0.006683349609375, -0.0140380859375, -0.012939453125, -0.0089111328125, -0.011810302734375, -0.0126953125, -0.009307861328125, -0.007232666015625, -0.003997802734375, -0.002197265625, -0.0040283203125, -0.003753662109375, -0.002899169921875, -0.003509521484375, -0.003875732421875, -0.000518798828125, 0.003570556640625, 0.0029296875, -0.001129150390625, -0.0035400390625, -0.004638671875, -0.00518798828125, -0.00518798828125, -0.005035400390625, -0.00616455078125, -0.007904052734375, -0.007354736328125, -0.00439453125, -0.00225830078125, -0.001434326171875, -0.00054931640625, -0.001953125, -0.004241943359375, -0.004058837890625, -0.001708984375, -0.00128173828125, -0.002227783203125, -0.0025634765625, -0.0042724609375, -0.00555419921875, -0.004638671875, -0.00433349609375, -0.003814697265625, -0.003265380859375, -0.00347900390625, -0.00408935546875, -0.001953125, 0.00067138671875, 0.001312255859375, 0.000518798828125, -0.001861572265625, -0.002593994140625, -0.002777099609375, -0.002777099609375, -0.0028076171875, -0.00274658203125, -0.0032958984375, -0.004364013671875, -0.003631591796875, -0.00360107421875, -0.002899169921875, -0.001739501953125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.00018310546875, -6.103515625e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, 0.0, 9.1552734375e-05, -0.0001220703125, 0.000274658203125, -0.000274658203125, 0.000335693359375, -0.000396728515625, 0.000335693359375, -0.0003662109375, 0.00030517578125, -0.00018310546875, 0.000885009765625, -0.0003662109375, 0.04241943359375, 0.123321533203125, -0.004730224609375, -0.047576904296875, 0.006988525390625, -0.080322265625, 0.028106689453125, 0.11553955078125, 0.095855712890625, 0.17926025390625, 0.182037353515625, 0.01513671875, -0.0494384765625, 0.033111572265625, -0.0484619140625, -0.180419921875, -0.115081787109375, -0.037841796875, -0.087554931640625, -0.06903076171875, 0.003997802734375, -0.00933837890625, 0.00164794921875, 0.0439453125, 0.0394287109375, 0.0267333984375, 0.039093017578125, 0.049468994140625, 0.031005859375, 0.0133056640625, 0.020782470703125, 0.012725830078125, -0.00262451171875, -0.00787353515625, -0.009490966796875, -0.01806640625, -0.0389404296875, -0.04486083984375, -0.02886962890625, -0.0213623046875, -0.02960205078125, -0.033233642578125, -0.029144287109375, -0.015380859375, -0.00360107421875, 0.000701904296875, 0.00286865234375, 0.005889892578125, 0.005126953125, -0.00274658203125, -0.012420654296875, -0.012359619140625, -0.0081787109375, -0.0103759765625, -0.011077880859375, -0.0091552734375, -0.0079345703125, -0.006195068359375, -0.0048828125, -0.006195068359375, -0.007965087890625, -0.00567626953125, -0.00372314453125, -0.00238037109375, 0.001495361328125, 0.00469970703125, 0.00384521484375, 0.000274658203125, -0.00146484375, -0.0032958984375, -0.00439453125, -0.00567626953125, -0.006103515625, -0.007171630859375, -0.008941650390625, -0.007781982421875, -0.00579833984375, -0.003265380859375, -0.0018310546875, -0.001220703125, -0.001739501953125, -0.00421142578125, -0.004302978515625, -0.001617431640625, -0.00091552734375, -0.001434326171875, -0.00201416015625, -0.003448486328125, -0.004180908203125, -0.003692626953125, -0.00421142578125, -0.004180908203125, -0.00299072265625, -0.003448486328125, -0.003814697265625, -0.002655029296875, -0.00140380859375, -0.000823974609375, -0.00079345703125, -0.00189208984375, -0.00335693359375, -0.00286865234375, -0.002166748046875, -0.00164794921875, -0.00164794921875, -0.003265380859375, -0.00439453125, -0.00421142578125, -0.0037841796875, -0.003173828125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000152587890625, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, -0.000152587890625, 0.00018310546875, -0.000213623046875, 0.00030517578125, -0.000335693359375, 0.000335693359375, -0.00018310546875, -6.103515625e-05, 0.000274658203125, 0.000335693359375, -0.0001220703125, 0.032196044921875, 0.10980224609375, 0.00775146484375, -0.043792724609375, 0.00927734375, -0.070556640625, 0.0162353515625, 0.103790283203125, 0.085235595703125, 0.157958984375, 0.172576904296875, 0.02874755859375, -0.0401611328125, 0.034423828125, -0.028961181640625, -0.15386962890625, -0.10919189453125, -0.037841796875, -0.07879638671875, -0.068328857421875, -0.003448486328125, -0.0084228515625, -0.000640869140625, 0.02838134765625, 0.03594970703125, 0.03179931640625, 0.036895751953125, 0.046173095703125, 0.031219482421875, 0.01800537109375, 0.026123046875, 0.022369384765625, 0.002899169921875, -0.008941650390625, -0.01226806640625, -0.025634765625, -0.046966552734375, -0.04803466796875, -0.03350830078125, -0.03045654296875, -0.034759521484375, -0.034515380859375, -0.02606201171875, -0.01123046875, -0.001373291015625, 0.003662109375, 0.00616455078125, 0.0084228515625, 0.00775146484375, 0.001617431640625, -0.0089111328125, -0.010528564453125, -0.006744384765625, -0.009063720703125, -0.011871337890625, -0.011993408203125, -0.010986328125, -0.00970458984375, -0.008026123046875, -0.008880615234375, -0.00970458984375, -0.006072998046875, -0.00201416015625, -0.000396728515625, 0.002471923828125, 0.0057373046875, 0.004669189453125, 0.001708984375, -0.00048828125, -0.00225830078125, -0.004364013671875, -0.00738525390625, -0.007537841796875, -0.007049560546875, -0.00872802734375, -0.0089111328125, -0.006317138671875, -0.00396728515625, -0.002410888671875, -0.001312255859375, -0.0020751953125, -0.004241943359375, -0.00396728515625, -0.00128173828125, -0.0010986328125, -0.001434326171875, -0.001068115234375, -0.001739501953125, -0.003021240234375, -0.003082275390625, -0.00311279296875, -0.003814697265625, -0.004058837890625, -0.00445556640625, -0.00469970703125, -0.00372314453125, -0.0029296875, -0.00177001953125, -0.001190185546875, -0.001953125, -0.00286865234375, -0.002532958984375, -0.001190185546875, -0.001190185546875, -0.001678466796875, -0.00341796875, -0.004547119140625, -0.003936767578125, -0.0035400390625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, 0.0, 6.103515625e-05, -9.1552734375e-05, 0.000152587890625, -0.00018310546875, 0.00018310546875, -0.00018310546875, 0.000213623046875, -3.0517578125e-05, -0.000274658203125, 0.000457763671875, 9.1552734375e-05, -3.0517578125e-05, 0.022491455078125, 0.095855712890625, 0.02142333984375, -0.03997802734375, 0.009765625, -0.058349609375, 0.002410888671875, 0.09185791015625, 0.0762939453125, 0.1368408203125, 0.163238525390625, 0.043548583984375, -0.02880859375, 0.033416748046875, -0.010498046875, -0.1279296875, -0.104888916015625, -0.038970947265625, -0.06640625, -0.0638427734375, -0.012359619140625, -0.011993408203125, -0.00665283203125, 0.023040771484375, 0.036956787109375, 0.02490234375, 0.031707763671875, 0.052947998046875, 0.04144287109375, 0.0255126953125, 0.0303955078125, 0.02117919921875, -0.006591796875, -0.01507568359375, -0.015533447265625, -0.035064697265625, -0.054412841796875, -0.050140380859375, -0.037261962890625, -0.0322265625, -0.03314208984375, -0.032196044921875, -0.021636962890625, -0.007110595703125, 0.0015869140625, 0.00604248046875, 0.00811767578125, 0.011810302734375, 0.01123046875, 0.003509521484375, -0.00518798828125, -0.007415771484375, -0.007843017578125, -0.01202392578125, -0.014434814453125, -0.01409912109375, -0.014617919921875, -0.013519287109375, -0.009674072265625, -0.009185791015625, -0.009368896484375, -0.00543212890625, -0.000701904296875, 0.001861572265625, 0.0035400390625, 0.006011962890625, 0.00555419921875, 0.001861572265625, -0.000823974609375, -0.002777099609375, -0.00518798828125, -0.0079345703125, -0.0074462890625, -0.0069580078125, -0.00848388671875, -0.008514404296875, -0.006622314453125, -0.004547119140625, -0.003173828125, -0.002166748046875, -0.00262451171875, -0.003875732421875, -0.003265380859375, -0.001495361328125, -0.00103759765625, -0.000640869140625, 0.000274658203125, -0.000213623046875, -0.002044677734375, -0.0028076171875, -0.003570556640625, -0.0047607421875, -0.005279541015625, -0.00537109375, -0.0052490234375, -0.004669189453125, -0.003326416015625, -0.001983642578125, -0.001220703125, -0.001708984375, -0.002197265625, -0.001678466796875, -0.001708984375, -0.001922607421875, -0.001708984375, -0.00274658203125, -0.0040283203125, -0.00360107421875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, -6.103515625e-05, 0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, -6.103515625e-05, 0.000152587890625, -0.0001220703125, 0.0001220703125, 6.103515625e-05, 9.1552734375e-05, 0.0001220703125, -0.000335693359375, 0.000701904296875, -0.00018310546875, 0.000335693359375, 0.014312744140625, 0.0802001953125, 0.034881591796875, -0.03448486328125, 0.008819580078125, -0.044952392578125, -0.010894775390625, 0.0787353515625, 0.068145751953125, 0.11627197265625, 0.153289794921875, 0.059783935546875, -0.016571044921875, 0.030517578125, 0.005859375, -0.10186767578125, -0.098785400390625, -0.036102294921875, -0.05352783203125, -0.0670166015625, -0.021240234375, -0.009307861328125, -0.010223388671875, 0.012237548828125, 0.0286865234375, 0.028900146484375, 0.042694091796875, 0.062255859375, 0.0491943359375, 0.02203369140625, 0.01715087890625, 0.0115966796875, -0.01220703125, -0.021881103515625, -0.02459716796875, -0.042266845703125, -0.05426025390625, -0.046875, -0.035675048828125, -0.02996826171875, -0.03076171875, -0.028564453125, -0.015960693359375, -0.00225830078125, 0.00390625, 0.00762939453125, 0.0113525390625, 0.014434814453125, 0.01214599609375, 0.004638671875, -0.003631591796875, -0.008880615234375, -0.01019287109375, -0.013824462890625, -0.01739501953125, -0.017120361328125, -0.016510009765625, -0.013671875, -0.009796142578125, -0.00909423828125, -0.0076904296875, -0.0032958984375, 0.00140380859375, 0.00335693359375, 0.00372314453125, 0.00494384765625, 0.00433349609375, 0.0010986328125, -0.001708984375, -0.0029296875, -0.004913330078125, -0.006988525390625, -0.007171630859375, -0.006683349609375, -0.0072021484375, -0.0084228515625, -0.00726318359375, -0.00555419921875, -0.004241943359375, -0.00286865234375, -0.00262451171875, -0.00286865234375, -0.00244140625, -0.00042724609375, 0.000152587890625, 0.000152587890625, 0.000885009765625, 0.0, -0.00189208984375, -0.003509521484375, -0.00421142578125, -0.004913330078125, -0.005096435546875, -0.005157470703125, -0.005706787109375, -0.005126953125, -0.0035400390625, -0.001495361328125, -0.00067138671875, -0.001129150390625, -0.001800537109375, -0.002166748046875, -0.002197265625, -0.001739501953125, -0.001129150390625, -0.002044677734375, -0.003204345703125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.000244140625, -0.000213623046875, 0.000274658203125, -0.00042724609375, 0.00048828125, -0.00018310546875, 0.000701904296875, 0.007781982421875, 0.063262939453125, 0.046630859375, -0.02642822265625, 0.00506591796875, -0.03021240234375, -0.021759033203125, 0.063232421875, 0.0606689453125, 0.098480224609375, 0.142120361328125, 0.073944091796875, -0.001922607421875, 0.026519775390625, 0.019439697265625, -0.07073974609375, -0.089141845703125, -0.042083740234375, -0.04571533203125, -0.06048583984375, -0.026153564453125, -0.018402099609375, -0.021148681640625, 0.012786865234375, 0.038330078125, 0.040252685546875, 0.0516357421875, 0.0570068359375, 0.033233642578125, 0.0115966796875, 0.00946044921875, -0.000823974609375, -0.022979736328125, -0.026947021484375, -0.028839111328125, -0.04180908203125, -0.0460205078125, -0.040618896484375, -0.0338134765625, -0.027313232421875, -0.02630615234375, -0.0224609375, -0.01104736328125, 0.000640869140625, 0.0067138671875, 0.008544921875, 0.012298583984375, 0.014678955078125, 0.009735107421875, 0.0018310546875, -0.00421142578125, -0.00958251953125, -0.014007568359375, -0.017120361328125, -0.0181884765625, -0.01702880859375, -0.015899658203125, -0.013458251953125, -0.009674072265625, -0.007537841796875, -0.004180908203125, -0.0009765625, 0.001007080078125, 0.002288818359375, 0.00201416015625, 0.0025634765625, 0.00250244140625, 0.00091552734375, -0.001312255859375, -0.00311279296875, -0.004302978515625, -0.0059814453125, -0.006500244140625, -0.007080078125, -0.0079345703125, -0.00823974609375, -0.007720947265625, -0.006256103515625, -0.004974365234375, -0.003326416015625, -0.001922607421875, -0.001434326171875, -0.001220703125, -0.00030517578125, -6.103515625e-05, -9.1552734375e-05, 0.000244140625, -0.000640869140625, -0.002655029296875, -0.003509521484375, -0.00372314453125, -0.004608154296875, -0.0050048828125, -0.005767822265625, -0.00634765625, -0.00537109375, -0.0030517578125, -0.0013427734375, -0.000885009765625, -0.001251220703125, -0.002227783203125, -0.00213623046875, -0.001861572265625, -0.001617431640625, -0.00115966796875, -0.001800537109375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, 0.0, 6.103515625e-05, 0.0, -6.103515625e-05, 6.103515625e-05, 6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 0.00030517578125, -0.00018310546875, 0.000457763671875, -0.00048828125, 0.00042724609375, 0.000213623046875, 0.000946044921875, 0.00311279296875, 0.046844482421875, 0.054046630859375, -0.01513671875, 0.000885009765625, -0.01641845703125, -0.028411865234375, 0.045013427734375, 0.05474853515625, 0.082672119140625, 0.128875732421875, 0.086700439453125, 0.014892578125, 0.027862548828125, 0.033294677734375, -0.047698974609375, -0.08245849609375, -0.0401611328125, -0.033935546875, -0.062286376953125, -0.04400634765625, -0.019683837890625, -0.00567626953125, 0.025421142578125, 0.043792724609375, 0.03692626953125, 0.033660888671875, 0.038818359375, 0.025970458984375, 0.00299072265625, -0.0079345703125, -0.013427734375, -0.023468017578125, -0.025238037109375, -0.026519775390625, -0.033721923828125, -0.0377197265625, -0.036224365234375, -0.027252197265625, -0.021209716796875, -0.023529052734375, -0.01800537109375, -0.005157470703125, 0.002716064453125, 0.0054931640625, 0.008880615234375, 0.009796142578125, 0.009124755859375, 0.00738525390625, 0.00103759765625, -0.007232666015625, -0.013153076171875, -0.014923095703125, -0.015960693359375, -0.016265869140625, -0.015655517578125, -0.01470947265625, -0.01190185546875, -0.007293701171875, -0.0042724609375, -0.00311279296875, -0.002410888671875, -0.000732421875, 0.00042724609375, 3.0517578125e-05, 0.0008544921875, 0.002197265625, 0.000946044921875, -0.00091552734375, -0.002288818359375, -0.00408935546875, -0.005859375, -0.006866455078125, -0.00689697265625, -0.007904052734375, -0.008026123046875, -0.00726318359375, -0.006378173828125, -0.00494384765625, -0.0029296875, -0.000732421875, -0.0008544921875, -0.00140380859375, -0.0006103515625, -6.103515625e-05, -0.000732421875, -0.000823974609375, -0.00048828125, -0.0018310546875, -0.002838134765625, -0.003662109375, -0.00494384765625, -0.005645751953125, -0.005462646484375, -0.005462646484375, -0.005126953125, -0.003173828125, -0.001617431640625, -0.000885009765625, -0.00128173828125, -0.00189208984375, -0.001556396484375, -0.00146484375, -0.001800537109375, -0.0018310546875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.000274658203125, -0.000244140625, 0.000457763671875, -0.000579833984375, 0.0003662109375, 0.00054931640625, 0.00054931640625, 0.00079345703125, 0.031646728515625, 0.055694580078125, -0.000335693359375, -0.003875732421875, -0.0057373046875, -0.029083251953125, 0.025848388671875, 0.04736328125, 0.0697021484375, 0.1163330078125, 0.099456787109375, 0.038787841796875, 0.025482177734375, 0.031982421875, -0.01953125, -0.06207275390625, -0.049346923828125, -0.042144775390625, -0.055511474609375, -0.03326416015625, -0.003082275390625, 0.010009765625, 0.017913818359375, 0.01641845703125, 0.020172119140625, 0.025054931640625, 0.022674560546875, 0.009033203125, -0.00811767578125, -0.0155029296875, -0.01580810546875, -0.016265869140625, -0.017242431640625, -0.02325439453125, -0.02813720703125, -0.02667236328125, -0.024566650390625, -0.022491455078125, -0.020294189453125, -0.018951416015625, -0.012908935546875, -0.00421142578125, 0.001617431640625, 0.002655029296875, 0.002349853515625, 0.0054931640625, 0.00701904296875, 0.003143310546875, -0.00323486328125, -0.008575439453125, -0.012451171875, -0.013153076171875, -0.012603759765625, -0.0137939453125, -0.014007568359375, -0.011932373046875, -0.008575439453125, -0.006195068359375, -0.0050048828125, -0.0045166015625, -0.004425048828125, -0.002105712890625, -0.001190185546875, -0.001251220703125, 0.000213623046875, 0.0013427734375, 0.000885009765625, -0.0006103515625, -0.00262451171875, -0.004791259765625, -0.00555419921875, -0.006103515625, -0.006683349609375, -0.00732421875, -0.007354736328125, -0.0067138671875, -0.0059814453125, -0.004608154296875, -0.002685546875, -0.001373291015625, -0.000885009765625, -0.001007080078125, -0.00115966796875, -0.001068115234375, -0.0008544921875, 0.0001220703125, -0.0003662109375, -0.00201416015625, -0.00335693359375, -0.0042724609375, -0.00494384765625, -0.004791259765625, -0.00482177734375, -0.005615234375, -0.004974365234375, -0.00311279296875, -0.00164794921875, -0.001220703125, -0.001129150390625, -0.00115966796875, -0.001708984375, -0.00225830078125, -0.0028076171875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, 0.0, -9.1552734375e-05, 0.0, 0.0, 0.000152587890625, 0.0001220703125, -9.1552734375e-05, 0.00030517578125, -0.000518798828125, 0.0006103515625, 0.000579833984375, 0.0, -0.000213623046875, 0.0198974609375, 0.0518798828125, 0.014495849609375, -0.005859375, 0.001312255859375, -0.024566650390625, 0.0062255859375, 0.038482666015625, 0.0634765625, 0.11328125, 0.106109619140625, 0.046600341796875, 0.030303955078125, 0.041839599609375, -0.003692626953125, -0.06060791015625, -0.05340576171875, -0.02081298828125, -0.0216064453125, -0.019500732421875, -0.0108642578125, -0.013763427734375, -0.0064697265625, 0.003173828125, 0.005767822265625, 0.004364013671875, 0.005584716796875, 0.001312255859375, -0.008575439453125, -0.0135498046875, -0.00885009765625, -0.006866455078125, -0.015380859375, -0.01654052734375, -0.01312255859375, -0.015869140625, -0.0196533203125, -0.01904296875, -0.0172119140625, -0.0177001953125, -0.01190185546875, -0.006072998046875, -0.005462646484375, -0.0040283203125, -0.0010986328125, 0.001739501953125, 0.001617431640625, 0.00042724609375, -0.003173828125, -0.00701904296875, -0.008880615234375, -0.009521484375, -0.00958251953125, -0.011322021484375, -0.010894775390625, -0.0087890625, -0.0084228515625, -0.00750732421875, -0.006988525390625, -0.006103515625, -0.005096435546875, -0.003448486328125, -0.00238037109375, -0.00225830078125, -0.000701904296875, 0.000335693359375, 0.00079345703125, -0.000885009765625, -0.002960205078125, -0.0040283203125, -0.00482177734375, -0.00543212890625, -0.00653076171875, -0.00665283203125, -0.00640869140625, -0.006072998046875, -0.00537109375, -0.0048828125, -0.00323486328125, -0.0015869140625, -0.000885009765625, -0.001373291015625, -0.001190185546875, -0.00067138671875, -0.000518798828125, -0.0006103515625, -0.001251220703125, -0.002105712890625, -0.0032958984375, -0.003753662109375, -0.00439453125, -0.004669189453125, -0.0047607421875, -0.005035400390625, -0.0042724609375, -0.00311279296875, -0.0020751953125, -0.0013427734375, -0.001129150390625, -0.002105712890625, -0.00299072265625, -0.00323486328125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, 0.000152587890625, -3.0517578125e-05, 0.000152587890625, 9.1552734375e-05, -0.00018310546875, 0.00054931640625, 0.00018310546875, -0.00018310546875, 3.0517578125e-05, 0.01141357421875, 0.043487548828125, 0.027862548828125, -0.004241943359375, 0.00445556640625, -0.016998291015625, -0.009307861328125, 0.03631591796875, 0.0628662109375, 0.097076416015625, 0.105804443359375, 0.069549560546875, 0.033203125, 0.0234375, 0.006866455078125, -0.022674560546875, -0.016082763671875, 0.00341796875, -0.02142333984375, -0.05145263671875, -0.0386962890625, -0.02099609375, -0.026092529296875, -0.024749755859375, -0.01165771484375, -0.002960205078125, 0.00030517578125, 0.001556396484375, 0.000762939453125, -0.005889892578125, -0.005218505859375, -0.001953125, -0.0030517578125, -0.003509521484375, -0.006805419921875, -0.01068115234375, -0.01336669921875, -0.016632080078125, -0.01947021484375, -0.01922607421875, -0.01611328125, -0.013092041015625, -0.011138916015625, -0.00921630859375, -0.005828857421875, -0.00152587890625, 0.00103759765625, 0.00152587890625, -0.00079345703125, -0.0030517578125, -0.00482177734375, -0.0068359375, -0.00738525390625, -0.008087158203125, -0.008575439453125, -0.009124755859375, -0.009918212890625, -0.00982666015625, -0.008453369140625, -0.006439208984375, -0.006072998046875, -0.004852294921875, -0.003570556640625, -0.002960205078125, -0.001373291015625, 0.000152587890625, 0.000732421875, -0.000701904296875, -0.0025634765625, -0.003662109375, -0.004425048828125, -0.00531005859375, -0.005859375, -0.00543212890625, -0.005340576171875, -0.005706787109375, -0.005523681640625, -0.004913330078125, -0.003448486328125, -0.00201416015625, -0.0008544921875, -0.000579833984375, -0.00115966796875, -0.00140380859375, -0.001434326171875, -0.0009765625, -0.001068115234375, -0.0018310546875, -0.0028076171875, -0.0037841796875, -0.0042724609375, -0.004241943359375, -0.004364013671875, -0.00439453125, -0.003936767578125, -0.00323486328125, -0.002838134765625, -0.002777099609375, -0.002593994140625, -0.002899169921875, -0.002960205078125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, -9.1552734375e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0001220703125, -3.0517578125e-05, 0.000396728515625, 9.1552734375e-05, 0.0, 0.0003662109375, 0.0001220703125, -3.0517578125e-05, 0.00054931640625, 0.0064697265625, 0.033416748046875, 0.0350341796875, 0.0029296875, 0.00787353515625, -0.002044677734375, -0.012786865234375, 0.017547607421875, 0.05291748046875, 0.100982666015625, 0.107757568359375, 0.05657958984375, 0.02813720703125, 0.0484619140625, 0.060760498046875, 0.03057861328125, -0.01361083984375, -0.038360595703125, -0.0479736328125, -0.057525634765625, -0.056884765625, -0.0518798828125, -0.0484619140625, -0.033935546875, -0.01519775390625, -0.00244140625, 0.005767822265625, 0.009552001953125, 0.0068359375, -0.00018310546875, 0.003082275390625, 0.011932373046875, 0.007415771484375, -0.001251220703125, -0.0029296875, -0.00433349609375, -0.0107421875, -0.0205078125, -0.02581787109375, -0.02398681640625, -0.020904541015625, -0.019622802734375, -0.017547607421875, -0.0123291015625, -0.005523681640625, 0.00054931640625, 0.003143310546875, 0.003753662109375, 0.002777099609375, 0.000885009765625, -0.0020751953125, -0.004669189453125, -0.004913330078125, -0.00640869140625, -0.009429931640625, -0.01129150390625, -0.01153564453125, -0.010345458984375, -0.00860595703125, -0.008056640625, -0.007415771484375, -0.005279541015625, -0.003692626953125, -0.00262451171875, -0.0013427734375, 0.000274658203125, 0.00067138671875, -0.000823974609375, -0.002593994140625, -0.003662109375, -0.003936767578125, -0.00390625, -0.004180908203125, -0.004791259765625, -0.005035400390625, -0.005035400390625, -0.005126953125, -0.0048828125, -0.0037841796875, -0.00177001953125, -0.000732421875, -0.000762939453125, -0.001556396484375, -0.001495361328125, -0.000885009765625, -0.000946044921875, -0.000762939453125, -0.001434326171875, -0.0025634765625, -0.00335693359375, -0.003936767578125, -0.00390625, -0.00390625, -0.003814697265625, -0.004302978515625, -0.0047607421875, -0.00433349609375, -0.003326416015625, -0.002532958984375, -0.0025634765625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 0.0, 0.0, -6.103515625e-05, 3.0517578125e-05, 0.0, -0.0001220703125, 9.1552734375e-05, 0.0, 3.0517578125e-05, 0.0001220703125, -9.1552734375e-05, 0.0006103515625, -6.103515625e-05, 3.0517578125e-05, 9.1552734375e-05, -0.000152587890625, 0.000946044921875, 0.001129150390625, 0.002532958984375, 0.022308349609375, 0.039154052734375, 0.021820068359375, 0.0242919921875, -0.000701904296875, -0.03466796875, 0.01190185546875, 0.0550537109375, 0.076873779296875, 0.088043212890625, 0.08148193359375, 0.089996337890625, 0.0999755859375, 0.0679931640625, 0.003387451171875, -0.04302978515625, -0.05364990234375, -0.062835693359375, -0.087493896484375, -0.08367919921875, -0.062042236328125, -0.0521240234375, -0.0335693359375, -0.009246826171875, 0.005828857421875, 0.012481689453125, 0.0145263671875, 0.013824462890625, 0.012237548828125, 0.0157470703125, 0.016998291015625, 0.006988525390625, 0.001129150390625, 0.001495361328125, -0.004364013671875, -0.01641845703125, -0.02728271484375, -0.031158447265625, -0.030059814453125, -0.02777099609375, -0.024505615234375, -0.0174560546875, -0.00897216796875, -0.001861572265625, 0.00286865234375, 0.005157470703125, 0.0067138671875, 0.006011962890625, 0.00323486328125, -0.00018310546875, -0.003326416015625, -0.0054931640625, -0.00872802734375, -0.011810302734375, -0.0120849609375, -0.011199951171875, -0.01141357421875, -0.0111083984375, -0.008941650390625, -0.006500244140625, -0.00457763671875, -0.003387451171875, -0.00244140625, -0.001312255859375, -0.000579833984375, -0.00030517578125, -0.001861572265625, -0.00274658203125, -0.002044677734375, -0.002197265625, -0.003204345703125, -0.004486083984375, -0.00457763671875, -0.004119873046875, -0.004638671875, -0.00537109375, -0.005462646484375, -0.003875732421875, -0.002227783203125, -0.001190185546875, -0.00067138671875, -0.00103759765625, -0.00115966796875, -0.001312255859375, -0.001251220703125, -0.000701904296875, -0.00128173828125, -0.002471923828125, -0.00372314453125, -0.0040283203125, -0.004180908203125, -0.00433349609375, -0.004791259765625, -0.00543212890625, -0.00518798828125, -0.004486083984375, -0.00372314453125, -0.00286865234375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, -3.0517578125e-05, 9.1552734375e-05, -3.0517578125e-05, 0.000823974609375, -0.000152587890625, -0.000579833984375, 0.000244140625, 0.00091552734375, 0.001312255859375, -0.0006103515625, 6.103515625e-05, 0.019744873046875, 0.056488037109375, 0.039886474609375, 0.014892578125, -0.001373291015625, -0.03619384765625, -0.02081298828125, 0.022857666015625, 0.0982666015625, 0.1572265625, 0.142547607421875, 0.09619140625, 0.06011962890625, 0.0355224609375, -0.00067138671875, -0.053192138671875, -0.096038818359375, -0.0977783203125, -0.089447021484375, -0.08294677734375, -0.066253662109375, -0.045867919921875, -0.020965576171875, -0.001678466796875, 0.011993408203125, 0.02032470703125, 0.023101806640625, 0.02362060546875, 0.021453857421875, 0.018402099609375, 0.0145263671875, 0.007781982421875, 0.00115966796875, -0.001739501953125, -0.009124755859375, -0.022613525390625, -0.03533935546875, -0.03887939453125, -0.034393310546875, -0.027557373046875, -0.021270751953125, -0.0126953125, -0.004302978515625, 0.00079345703125, 0.005401611328125, 0.00762939453125, 0.009124755859375, 0.0078125, 0.00421142578125, -0.000885009765625, -0.0059814453125, -0.008544921875, -0.01055908203125, -0.01153564453125, -0.012115478515625, -0.013031005859375, -0.0128173828125, -0.010345458984375, -0.0069580078125, -0.005401611328125, -0.004150390625, -0.00323486328125, -0.002655029296875, -0.00238037109375, -0.002227783203125, -0.001312255859375, -0.000762939453125, -0.0001220703125, -0.000946044921875, -0.002685546875, -0.0037841796875, -0.0040283203125, -0.00372314453125, -0.00396728515625, -0.00482177734375, -0.0057373046875, -0.005584716796875, -0.00396728515625, -0.002105712890625, -0.0006103515625, -0.000213623046875, -0.000946044921875, -0.001739501953125, -0.001800537109375, -0.001190185546875, -0.000701904296875, -0.001739501953125, -0.0032958984375, -0.004058837890625, -0.004638671875, -0.00506591796875, -0.005126953125, -0.00494384765625, -0.00531005859375, -0.00555419921875, -0.004913330078125, -0.00396728515625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0, 6.103515625e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, 6.103515625e-05, 0.0001220703125, 3.0517578125e-05, 6.103515625e-05, 0.0001220703125, 0.000457763671875, 0.000701904296875, -0.000732421875, 3.0517578125e-05, 0.0015869140625, 0.000457763671875, -0.000244140625, 0.001800537109375, 0.016021728515625, 0.029083251953125, 0.042755126953125, 0.0472412109375, 0.036529541015625, -0.03143310546875, -0.099151611328125, -0.021697998046875, 0.119384765625, 0.196319580078125, 0.15435791015625, 0.078277587890625, 0.059295654296875, 0.058441162109375, 0.024505615234375, -0.040863037109375, -0.094329833984375, -0.11077880859375, -0.091766357421875, -0.081695556640625, -0.079833984375, -0.056121826171875, -0.03076171875, -0.01116943359375, 0.0054931640625, 0.02349853515625, 0.03009033203125, 0.026458740234375, 0.026611328125, 0.0233154296875, 0.018585205078125, 0.0098876953125, 0.001617431640625, -0.001678466796875, -0.004058837890625, -0.017578125, -0.0355224609375, -0.040863037109375, -0.036712646484375, -0.02984619140625, -0.022796630859375, -0.0157470703125, -0.00714111328125, -0.000518798828125, 0.00390625, 0.00738525390625, 0.009521484375, 0.01019287109375, 0.006561279296875, 0.00115966796875, -0.004638671875, -0.00811767578125, -0.009521484375, -0.01104736328125, -0.01220703125, -0.012908935546875, -0.012481689453125, -0.010345458984375, -0.007843017578125, -0.005950927734375, -0.004791259765625, -0.003753662109375, -0.003997802734375, -0.004486083984375, -0.002960205078125, -0.001220703125, 0.00048828125, 0.00103759765625, 0.000213623046875, -0.001678466796875, -0.003326416015625, -0.003387451171875, -0.003692626953125, -0.003448486328125, -0.0035400390625, -0.004638671875, -0.0054931640625, -0.00518798828125, -0.0028076171875, -0.001007080078125, -0.000244140625, -0.000396728515625, -0.001251220703125, -0.001739501953125, -0.00177001953125, -0.001678466796875, -0.001953125, -0.002349853515625, -0.003326416015625, -0.004486083984375, -0.00543212890625, -0.005401611328125, -0.004730224609375, -0.004730224609375, -0.005218505859375, -0.00567626953125, -0.00469970703125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, 0.0, 6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -9.1552734375e-05, 0.0001220703125, -3.0517578125e-05, 0.00018310546875, 0.000213623046875, 9.1552734375e-05, 0.000457763671875, -9.1552734375e-05, 0.0006103515625, 0.00042724609375, 0.00103759765625, 0.01361083984375, 0.023773193359375, 0.003936767578125, 0.014801025390625, 0.061614990234375, 0.058074951171875, -0.018463134765625, -0.103485107421875, -0.018280029296875, 0.139434814453125, 0.15863037109375, 0.11285400390625, 0.085174560546875, 0.068878173828125, 0.052032470703125, 0.027099609375, -0.030609130859375, -0.072509765625, -0.086639404296875, -0.095855712890625, -0.086334228515625, -0.073577880859375, -0.058868408203125, -0.04248046875, -0.022186279296875, 0.00146484375, 0.02001953125, 0.02685546875, 0.026580810546875, 0.02813720703125, 0.02679443359375, 0.020294189453125, 0.010498046875, 0.00213623046875, -0.0020751953125, -0.00506591796875, -0.01544189453125, -0.031036376953125, -0.03656005859375, -0.03363037109375, -0.030181884765625, -0.024688720703125, -0.016571044921875, -0.009521484375, -0.003021240234375, 0.0020751953125, 0.005218505859375, 0.0081787109375, 0.008758544921875, 0.006195068359375, 0.00146484375, -0.00244140625, -0.006317138671875, -0.009735107421875, -0.010711669921875, -0.011474609375, -0.01177978515625, -0.01068115234375, -0.009429931640625, -0.00872802734375, -0.006866455078125, -0.005279541015625, -0.005523681640625, -0.005889892578125, -0.004547119140625, -0.002532958984375, -0.00140380859375, -0.000640869140625, 0.000579833984375, 0.000640869140625, -0.0010986328125, -0.002777099609375, -0.00372314453125, -0.003631591796875, -0.002960205078125, -0.00244140625, -0.003509521484375, -0.004852294921875, -0.004608154296875, -0.003570556640625, -0.002288818359375, -0.001556396484375, -0.00103759765625, -0.000640869140625, -0.001983642578125, -0.002899169921875, -0.00286865234375, -0.00238037109375, -0.001983642578125, -0.00299072265625, -0.004486083984375, -0.00579833984375, -0.00555419921875, -0.00469970703125, -0.0048828125, -0.005157470703125, -0.00506591796875, -0.004058837890625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, 0.0, 0.0, -3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, 3.0517578125e-05, 0.0001220703125, -9.1552734375e-05, 0.0, 9.1552734375e-05, 0.000244140625, 0.000244140625, -0.000244140625, 0.000732421875, 0.00079345703125, -0.000152587890625, 0.000274658203125, 0.01239013671875, 0.027740478515625, 0.0107421875, -0.004364013671875, 0.01873779296875, 0.035186767578125, 0.03143310546875, -0.0003662109375, -0.02337646484375, 0.04351806640625, 0.0999755859375, 0.087554931640625, 0.0770263671875, 0.07855224609375, 0.06854248046875, 0.0361328125, 0.006561279296875, -0.0162353515625, -0.042236328125, -0.060546875, -0.073455810546875, -0.08209228515625, -0.07000732421875, -0.0517578125, -0.045684814453125, -0.02880859375, -0.005401611328125, 0.010101318359375, 0.01812744140625, 0.023040771484375, 0.02801513671875, 0.024383544921875, 0.017486572265625, 0.012237548828125, 0.004547119140625, -0.005279541015625, -0.009185791015625, -0.01513671875, -0.0230712890625, -0.02740478515625, -0.028900146484375, -0.026458740234375, -0.02313232421875, -0.01678466796875, -0.010528564453125, -0.00555419921875, -0.00042724609375, 0.00286865234375, 0.004730224609375, 0.00482177734375, 0.00384521484375, 0.001312255859375, -0.00201416015625, -0.00531005859375, -0.00762939453125, -0.0093994140625, -0.0107421875, -0.009552001953125, -0.0087890625, -0.00823974609375, -0.0076904296875, -0.007354736328125, -0.007110595703125, -0.007232666015625, -0.005340576171875, -0.002899169921875, -0.002105712890625, -0.002227783203125, -0.001953125, -0.000946044921875, -0.000244140625, -0.0009765625, -0.002655029296875, -0.003570556640625, -0.003021240234375, -0.002044677734375, -0.001617431640625, -0.002532958984375, -0.003173828125, -0.00311279296875, -0.003387451171875, -0.003448486328125, -0.0030517578125, -0.001922607421875, -0.00177001953125, -0.002410888671875, -0.0028076171875, -0.00274658203125, -0.002349853515625, -0.002655029296875, -0.0035400390625, -0.00494384765625, -0.005340576171875, -0.004974365234375, -0.005218505859375, -0.0048828125, -0.004364013671875, -0.003326416015625, -0.00286865234375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 6.103515625e-05, 0.0, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, 0.0, 0.0, -6.103515625e-05, 9.1552734375e-05, 0.0, -3.0517578125e-05, 6.103515625e-05, -6.103515625e-05, 3.0517578125e-05, -6.103515625e-05, 0.0003662109375, 0.0, -3.0517578125e-05, 0.0003662109375, 0.00091552734375, 0.000152587890625, 0.008544921875, 0.031890869140625, 0.019256591796875, -0.008026123046875, 0.00750732421875, 0.022186279296875, 0.00732421875, -0.004302978515625, 0.03057861328125, 0.083038330078125, 0.07598876953125, 0.04608154296875, 0.046295166015625, 0.051239013671875, 0.048248291015625, 0.0357666015625, 0.0166015625, -0.000823974609375, -0.013092041015625, -0.01812744140625, -0.032379150390625, -0.050628662109375, -0.05328369140625, -0.055572509765625, -0.053375244140625, -0.037322998046875, -0.025421142578125, -0.016632080078125, -0.00421142578125, 0.007904052734375, 0.017822265625, 0.020294189453125, 0.017974853515625, 0.013397216796875, 0.010406494140625, 0.00390625, -0.0067138671875, -0.0130615234375, -0.01416015625, -0.01483154296875, -0.018951416015625, -0.02099609375, -0.021026611328125, -0.01812744140625, -0.0142822265625, -0.01190185546875, -0.0072021484375, -0.003570556640625, -0.00128173828125, -0.00030517578125, 0.00018310546875, 0.000885009765625, -0.001434326171875, -0.003173828125, -0.003814697265625, -0.005218505859375, -0.0072021484375, -0.008453369140625, -0.00811767578125, -0.007781982421875, -0.00640869140625, -0.006591796875, -0.00848388671875, -0.008270263671875, -0.00579833984375, -0.003204345703125, -0.0029296875, -0.00274658203125, -0.0030517578125, -0.003387451171875, -0.0025634765625, -0.002655029296875, -0.002288818359375, -0.0029296875, -0.0025634765625, -0.0015869140625, -0.001800537109375, -0.00128173828125, -0.001312255859375, -0.001556396484375, -0.002349853515625, -0.0030517578125, -0.003662109375, -0.004730224609375, -0.00433349609375, -0.003265380859375, -0.002197265625, -0.00213623046875, -0.002471923828125, -0.002685546875, -0.003997802734375, -0.00482177734375, -0.0052490234375, -0.005340576171875, -0.005157470703125, -0.004913330078125, -0.003814697265625, -0.003173828125, -0.002685546875, -0.00238037109375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, -3.0517578125e-05, 0.00018310546875, 0.000152587890625, 0.0001220703125, 0.0003662109375, 0.000457763671875, 0.00628662109375, 0.03375244140625, 0.0289306640625, -0.008880615234375, -0.000579833984375, 0.01763916015625, 0.00390625, -0.010223388671875, 0.0260009765625, 0.08856201171875, 0.090301513671875, 0.058868408203125, 0.048004150390625, 0.03375244140625, 0.017425537109375, 0.008514404296875, -0.00531005859375, -0.010040283203125, -0.002044677734375, -0.002716064453125, -0.012542724609375, -0.015838623046875, -0.0147705078125, -0.02520751953125, -0.036346435546875, -0.03570556640625, -0.0291748046875, -0.0263671875, -0.021942138671875, -0.01300048828125, -0.00347900390625, 0.005584716796875, 0.009674072265625, 0.010406494140625, 0.0068359375, 0.003021240234375, -0.00048828125, -0.00750732421875, -0.011138916015625, -0.010772705078125, -0.009796142578125, -0.011444091796875, -0.0126953125, -0.012542724609375, -0.0123291015625, -0.01068115234375, -0.010223388671875, -0.00872802734375, -0.008056640625, -0.006591796875, -0.004730224609375, -0.004302978515625, -0.004669189453125, -0.00421142578125, -0.002593994140625, -0.0035400390625, -0.0035400390625, -0.0045166015625, -0.006439208984375, -0.006439208984375, -0.006072998046875, -0.006439208984375, -0.00762939453125, -0.006622314453125, -0.004547119140625, -0.003570556640625, -0.002960205078125, -0.003265380859375, -0.00372314453125, -0.004058837890625, -0.004486083984375, -0.00439453125, -0.00482177734375, -0.004180908203125, -0.00262451171875, -0.00140380859375, -0.00079345703125, -0.0010986328125, -0.00042724609375, -0.000244140625, -0.00054931640625, -0.001708984375, -0.003326416015625, -0.00445556640625, -0.005615234375, -0.00494384765625, -0.003662109375, -0.00238037109375, -0.001861572265625, -0.002410888671875, -0.0035400390625, -0.0050048828125, -0.00543212890625, -0.00579833984375, -0.005706787109375, -0.004638671875, -0.00347900390625, -0.002716064453125, -0.00262451171875, -0.001922607421875, -0.001739501953125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0001220703125, 9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, 9.1552734375e-05, 0.00018310546875, 0.0, 0.00018310546875, 0.0001220703125, 0.000518798828125, 0.0, 0.000762939453125, 0.00384521484375, 0.033294677734375, 0.041046142578125, -0.00714111328125, -0.01025390625, 0.015350341796875, 0.00341796875, -0.0137939453125, 0.028564453125, 0.100494384765625, 0.087310791015625, 0.042999267578125, 0.050811767578125, 0.049407958984375, 0.022430419921875, -0.003265380859375, -0.031951904296875, -0.038238525390625, -0.020843505859375, -0.011810302734375, -0.00506591796875, -0.0030517578125, 0.000518798828125, 0.0069580078125, -0.00152587890625, -0.0087890625, -0.01068115234375, -0.019439697265625, -0.026458740234375, -0.02362060546875, -0.016937255859375, -0.013092041015625, -0.00946044921875, -0.002471923828125, 0.0003662109375, -0.003692626953125, -0.006011962890625, -0.007659912109375, -0.0074462890625, -0.005218505859375, -0.00634765625, -0.006072998046875, -0.004730224609375, -0.004180908203125, -0.0047607421875, -0.00616455078125, -0.006561279296875, -0.007568359375, -0.009857177734375, -0.0123291015625, -0.011383056640625, -0.01055908203125, -0.0101318359375, -0.006683349609375, -0.005035400390625, -0.00408935546875, -0.003448486328125, -0.002960205078125, -0.003143310546875, -0.0040283203125, -0.004791259765625, -0.00665283203125, -0.007049560546875, -0.004730224609375, -0.002105712890625, -0.00152587890625, -0.002197265625, -0.003326416015625, -0.00408935546875, -0.004638671875, -0.005645751953125, -0.005889892578125, -0.0059814453125, -0.005645751953125, -0.00408935546875, -0.00262451171875, -0.001617431640625, -0.000823974609375, -3.0517578125e-05, 0.00079345703125, 0.000335693359375, -0.00079345703125, -0.002288818359375, -0.004547119140625, -0.00482177734375, -0.003997802734375, -0.00384521484375, -0.004119873046875, -0.00341796875, -0.00238037109375, -0.002960205078125, -0.00445556640625, -0.0057373046875, -0.00592041015625, -0.005767822265625, -0.004791259765625, -0.003631591796875, -0.0030517578125, -0.002227783203125, -0.001739501953125, -0.001129150390625, -0.001312255859375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, 0.0, 3.0517578125e-05, 0.0, 0.00018310546875, -0.0001220703125, 3.0517578125e-05, -3.0517578125e-05, 0.0006103515625, -0.00018310546875, 0.000640869140625, 0.002349853515625, 0.03167724609375, 0.05096435546875, -0.001617431640625, -0.01953125, 0.011138916015625, 0.00372314453125, -0.016265869140625, 0.031646728515625, 0.11181640625, 0.09466552734375, 0.039581298828125, 0.044403076171875, 0.03826904296875, 0.01324462890625, 0.00579833984375, -0.021942138671875, -0.050628662109375, -0.044342041015625, -0.029632568359375, -0.022491455078125, -0.014984130859375, 0.00567626953125, 0.01971435546875, 0.013092041015625, 0.0166015625, 0.020965576171875, 0.006103515625, -0.009185791015625, -0.016021728515625, -0.02081298828125, -0.02349853515625, -0.021575927734375, -0.017547607421875, -0.01593017578125, -0.01544189453125, -0.014678955078125, -0.01531982421875, -0.012969970703125, -0.006256103515625, -0.00213623046875, -0.002105712890625, -0.000946044921875, 0.0018310546875, 0.002838134765625, 0.001007080078125, -0.001007080078125, -0.002655029296875, -0.0067138671875, -0.0106201171875, -0.014678955078125, -0.018280029296875, -0.0155029296875, -0.01019287109375, -0.007659912109375, -0.007293701171875, -0.006500244140625, -0.004486083984375, -0.00250244140625, -0.00201416015625, -0.004241943359375, -0.006011962890625, -0.005157470703125, -0.002685546875, -0.001251220703125, -3.0517578125e-05, -6.103515625e-05, -0.001922607421875, -0.003662109375, -0.00537109375, -0.00634765625, -0.006927490234375, -0.006866455078125, -0.00640869140625, -0.005279541015625, -0.003692626953125, -0.003173828125, -0.00250244140625, -0.001068115234375, 0.000946044921875, 0.00140380859375, -0.00067138671875, -0.002960205078125, -0.0040283203125, -0.003631591796875, -0.003143310546875, -0.00311279296875, -0.003662109375, -0.004608154296875, -0.00408935546875, -0.00372314453125, -0.004791259765625, -0.005615234375, -0.005615234375, -0.005401611328125, -0.004852294921875, -0.00396728515625, -0.00360107421875, -0.002899169921875, -0.001708984375, -0.001373291015625, -0.001434326171875, -0.0009765625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0001220703125, 3.0517578125e-05, 0.00018310546875, -3.0517578125e-05, 0.00018310546875, -0.000274658203125, 0.0006103515625, 0.0, 0.000823974609375, 0.001190185546875, 0.02947998046875, 0.060638427734375, 0.005828857421875, -0.028961181640625, 0.005828857421875, 0.005889892578125, -0.019561767578125, 0.03411865234375, 0.126007080078125, 0.101715087890625, 0.03741455078125, 0.046966552734375, 0.040802001953125, -0.00030517578125, -0.013275146484375, -0.02825927734375, -0.046966552734375, -0.038482666015625, -0.031463623046875, -0.039093017578125, -0.0321044921875, -0.006195068359375, 0.009796142578125, 0.0146484375, 0.028564453125, 0.036163330078125, 0.0267333984375, 0.016510009765625, 0.00787353515625, -0.004364013671875, -0.016998291015625, -0.024688720703125, -0.0263671875, -0.026275634765625, -0.02789306640625, -0.028350830078125, -0.02655029296875, -0.0223388671875, -0.013275146484375, -0.006195068359375, -0.002685546875, 0.001861572265625, 0.0064697265625, 0.007415771484375, 0.006439208984375, 0.0067138671875, 0.003631591796875, -0.001556396484375, -0.006927490234375, -0.013916015625, -0.01776123046875, -0.016937255859375, -0.01422119140625, -0.01123046875, -0.01025390625, -0.01007080078125, -0.00750732421875, -0.00408935546875, -0.00347900390625, -0.004974365234375, -0.00408935546875, -0.00128173828125, -0.001190185546875, -0.0006103515625, 0.001190185546875, 0.00146484375, 3.0517578125e-05, -0.0025634765625, -0.00469970703125, -0.0064697265625, -0.00701904296875, -0.006439208984375, -0.006256103515625, -0.006103515625, -0.00482177734375, -0.00347900390625, -0.003387451171875, -0.001983642578125, 0.00018310546875, 0.00067138671875, -0.001129150390625, -0.003204345703125, -0.00384521484375, -0.00286865234375, -0.00164794921875, -0.001708984375, -0.003204345703125, -0.0040283203125, -0.0040283203125, -0.004364013671875, -0.00555419921875, -0.006011962890625, -0.00494384765625, -0.004302978515625, -0.00433349609375, -0.003936767578125, -0.0032958984375, -0.0028076171875, -0.002197265625, -0.00140380859375, -0.001373291015625, -0.000946044921875, 0.0003662109375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -9.1552734375e-05, 3.0517578125e-05, -9.1552734375e-05, 3.0517578125e-05, -0.000152587890625, 0.000152587890625, -0.000213623046875, 0.0001220703125, -0.000274658203125, 0.000396728515625, -3.0517578125e-05, 0.000701904296875, 0.000946044921875, 0.02685546875, 0.06878662109375, 0.01544189453125, -0.03765869140625, -0.0020751953125, 0.007720947265625, -0.02099609375, 0.035186767578125, 0.1407470703125, 0.110321044921875, 0.035064697265625, 0.05029296875, 0.04656982421875, -0.007171630859375, -0.025604248046875, -0.036590576171875, -0.064208984375, -0.0516357421875, -0.0235595703125, -0.029541015625, -0.036163330078125, -0.015869140625, 0.002227783203125, 0.002685546875, 0.015289306640625, 0.038543701171875, 0.040008544921875, 0.026641845703125, 0.023162841796875, 0.018829345703125, 0.002960205078125, -0.01141357421875, -0.019256591796875, -0.028564453125, -0.037078857421875, -0.0380859375, -0.03656005859375, -0.033447265625, -0.02471923828125, -0.0145263671875, -0.00860595703125, -0.0018310546875, 0.006072998046875, 0.00982666015625, 0.00970458984375, 0.010040283203125, 0.01043701171875, 0.00537109375, -0.005584716796875, -0.012054443359375, -0.013397216796875, -0.01422119140625, -0.01214599609375, -0.01263427734375, -0.0155029296875, -0.014129638671875, -0.009033203125, -0.00732421875, -0.0084228515625, -0.0067138671875, -0.001922607421875, -9.1552734375e-05, -0.000518798828125, 0.000701904296875, 0.001495361328125, 0.002105712890625, 0.000457763671875, -0.001861572265625, -0.00390625, -0.0062255859375, -0.006103515625, -0.00543212890625, -0.0057373046875, -0.006103515625, -0.005767822265625, -0.005157470703125, -0.003936767578125, -0.001495361328125, -0.000396728515625, -0.000885009765625, -0.0025634765625, -0.004364013671875, -0.00421142578125, -0.0030517578125, -0.00152587890625, -0.00115966796875, -0.002166748046875, -0.00360107421875, -0.004638671875, -0.004425048828125, -0.00518798828125, -0.005767822265625, -0.005218505859375, -0.0042724609375, -0.004058837890625, -0.004150390625, -0.0030517578125, -0.00250244140625, -0.002288818359375, -0.0018310546875, -0.00164794921875, -0.001068115234375, 9.1552734375e-05, 0.00115966796875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -6.103515625e-05, 6.103515625e-05, -9.1552734375e-05, 9.1552734375e-05, -9.1552734375e-05, 0.0001220703125, -0.0001220703125, 0.0001220703125, -0.000335693359375, 0.0003662109375, 0.0, 0.000732421875, 0.000518798828125, 0.024658203125, 0.076385498046875, 0.0262451171875, -0.044769287109375, -0.011627197265625, 0.009521484375, -0.02203369140625, 0.036224365234375, 0.156524658203125, 0.118927001953125, 0.031494140625, 0.0545654296875, 0.05609130859375, -0.0108642578125, -0.0380859375, -0.044677734375, -0.072296142578125, -0.063629150390625, -0.035003662109375, -0.0352783203125, -0.034637451171875, -0.00732421875, 0.00994873046875, -0.001556396484375, 0.005279541015625, 0.027496337890625, 0.03045654296875, 0.02716064453125, 0.03204345703125, 0.02813720703125, 0.014434814453125, 0.0067138671875, -0.001495361328125, -0.01519775390625, -0.0308837890625, -0.041259765625, -0.044769287109375, -0.041168212890625, -0.03118896484375, -0.02423095703125, -0.01800537109375, -0.008270263671875, 0.00128173828125, 0.006927490234375, 0.008331298828125, 0.011474609375, 0.013580322265625, 0.00701904296875, -0.00238037109375, -0.006561279296875, -0.009765625, -0.010040283203125, -0.008453369140625, -0.01104736328125, -0.015350341796875, -0.016326904296875, -0.01275634765625, -0.0111083984375, -0.010498046875, -0.006500244140625, -0.002532958984375, -0.00128173828125, -0.00054931640625, 0.000457763671875, 0.00238037109375, 0.00152587890625, -0.000244140625, -0.001220703125, -0.00408935546875, -0.005950927734375, -0.0054931640625, -0.003753662109375, -0.004486083984375, -0.00579833984375, -0.00579833984375, -0.0057373046875, -0.004669189453125, -0.002227783203125, 0.000152587890625, -0.00146484375, -0.004180908203125, -0.00482177734375, -0.00439453125, -0.003692626953125, -0.003021240234375, -0.001678466796875, -0.002105712890625, -0.00372314453125, -0.00457763671875, -0.00482177734375, -0.00457763671875, -0.00469970703125, -0.004180908203125, -0.004241943359375, -0.00482177734375, -0.00445556640625, -0.0032958984375, -0.002166748046875, -0.002166748046875, -0.001800537109375, -0.0013427734375, -0.0010986328125, -0.000640869140625, -3.0517578125e-05, 3.0517578125e-05])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, -9.1552734375e-05, 3.0517578125e-05, -3.0517578125e-05, 0.000152587890625, -0.000213623046875, 0.00018310546875, -0.000274658203125, 9.1552734375e-05, 9.1552734375e-05, 0.000640869140625, 0.000640869140625, 0.022003173828125, 0.083404541015625, 0.0382080078125, -0.051513671875, -0.022003173828125, 0.01055908203125, -0.02166748046875, 0.03594970703125, 0.17315673828125, 0.13055419921875, 0.0255126953125, 0.0567626953125, 0.0667724609375, -0.01031494140625, -0.048614501953125, -0.053680419921875, -0.082275390625, -0.074920654296875, -0.03814697265625, -0.038482666015625, -0.04766845703125, -0.016326904296875, 0.019744873046875, 0.0135498046875, 0.01007080078125, 0.02337646484375, 0.023590087890625, 0.017181396484375, 0.021514892578125, 0.0274658203125, 0.0205078125, 0.0123291015625, 0.008056640625, 0.000732421875, -0.015655517578125, -0.0303955078125, -0.040069580078125, -0.043792724609375, -0.0377197265625, -0.028289794921875, -0.02166748046875, -0.01611328125, -0.006622314453125, 0.00146484375, 0.005523681640625, 0.008941650390625, 0.007965087890625, 0.00469970703125, 0.001556396484375, -0.00347900390625, -0.005584716796875, -0.00518798828125, -0.005401611328125, -0.00848388671875, -0.012725830078125, -0.015289306640625, -0.01519775390625, -0.0130615234375, -0.008758544921875, -0.005462646484375, -0.00408935546875, -0.002471923828125, -0.001983642578125, -0.000335693359375, 0.00103759765625, 0.00048828125, -0.000396728515625, -0.00213623046875, -0.003997802734375, -0.00579833984375, -0.0050048828125, -0.0030517578125, -0.003265380859375, -0.005218505859375, -0.00555419921875, -0.00469970703125, -0.004486083984375, -0.0023193359375, -0.000701904296875, -0.0018310546875, -0.004180908203125, -0.004852294921875, -0.004364013671875, -0.004180908203125, -0.003265380859375, -0.002899169921875, -0.0035400390625, -0.00433349609375, -0.005126953125, -0.005126953125, -0.00421142578125, -0.003326416015625, -0.0030517578125, -0.003662109375, -0.004852294921875, -0.005096435546875, -0.003204345703125, -0.001617431640625, -0.001617431640625, -0.00189208984375, -0.001617431640625, -0.0009765625, -0.0003662109375, -0.000701904296875, -0.001922607421875, -0.003204345703125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 0.0, 6.103515625e-05, -6.103515625e-05, -6.103515625e-05, 0.0, -6.103515625e-05, 9.1552734375e-05, -0.000152587890625, 0.000152587890625, -0.00018310546875, 3.0517578125e-05, -9.1552734375e-05, -3.0517578125e-05, 6.103515625e-05, 0.000396728515625, 0.00091552734375, 0.0198974609375, 0.08984375, 0.050689697265625, -0.057708740234375, -0.03363037109375, 0.011322021484375, -0.020233154296875, 0.037017822265625, 0.189178466796875, 0.142425537109375, 0.020355224609375, 0.0576171875, 0.076019287109375, -0.009613037109375, -0.055938720703125, -0.060791015625, -0.092498779296875, -0.0877685546875, -0.042724609375, -0.0390625, -0.05279541015625, -0.023101806640625, 0.013885498046875, 0.0146484375, 0.01959228515625, 0.034759521484375, 0.027862548828125, 0.01385498046875, 0.015228271484375, 0.018218994140625, 0.009063720703125, 0.0078125, 0.012908935546875, 0.006256103515625, -0.008392333984375, -0.01812744140625, -0.027069091796875, -0.034393310546875, -0.03363037109375, -0.027923583984375, -0.023284912109375, -0.018646240234375, -0.0108642578125, -0.00390625, 0.000701904296875, 0.00164794921875, 0.002410888671875, 0.002166748046875, -0.002899169921875, -0.0037841796875, -0.00201416015625, -0.002685546875, -0.003570556640625, -0.005126953125, -0.010009765625, -0.015228271484375, -0.013214111328125, -0.007720947265625, -0.006195068359375, -0.006683349609375, -0.003936767578125, -0.002349853515625, -0.002349853515625, -0.00225830078125, -0.001373291015625, -0.000579833984375, -0.001800537109375, -0.002685546875, -0.00469970703125, -0.0067138671875, -0.005340576171875, -0.002227783203125, -0.002593994140625, -0.004547119140625, -0.00469970703125, -0.0045166015625, -0.003570556640625, -0.00115966796875, 6.103515625e-05, -0.002532958984375, -0.004425048828125, -0.00408935546875, -0.004119873046875, -0.004302978515625, -0.00372314453125, -0.003265380859375, -0.00384521484375, -0.00537109375, -0.006195068359375, -0.005645751953125, -0.0042724609375, -0.002288818359375, -0.001617431640625, -0.00341796875, -0.00537109375, -0.004486083984375, -0.002044677734375, -0.0006103515625, -0.00079345703125, -0.001708984375, -0.0018310546875, -0.00128173828125, -0.00079345703125, -0.001220703125, -0.00274658203125, -0.0042724609375, -0.005401611328125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, -9.1552734375e-05, 3.0517578125e-05, -6.103515625e-05, 0.000152587890625, -9.1552734375e-05, 0.0001220703125, -0.0001220703125, 3.0517578125e-05, -9.1552734375e-05, 0.0, 0.000152587890625, 3.0517578125e-05, 0.0010986328125, 0.018157958984375, 0.096282958984375, 0.063323974609375, -0.06329345703125, -0.0457763671875, 0.01129150390625, -0.01849365234375, 0.03887939453125, 0.206878662109375, 0.154296875, 0.013336181640625, 0.05926513671875, 0.0860595703125, -0.010467529296875, -0.0635986328125, -0.065948486328125, -0.100982666015625, -0.10125732421875, -0.04876708984375, -0.038482666015625, -0.05810546875, -0.028228759765625, 0.013397216796875, 0.015411376953125, 0.019561767578125, 0.03546142578125, 0.034637451171875, 0.022369384765625, 0.018524169921875, 0.01678466796875, 0.00213623046875, -0.00439453125, 0.001983642578125, 0.00238037109375, -0.00616455078125, -0.015167236328125, -0.0216064453125, -0.0238037109375, -0.02178955078125, -0.0172119140625, -0.015960693359375, -0.01776123046875, -0.01220703125, -0.003662109375, -0.006256103515625, -0.00592041015625, 0.0003662109375, -0.001922607421875, -0.0072021484375, -0.008514404296875, -0.005615234375, -0.0035400390625, -0.00244140625, -0.00439453125, -0.011199951171875, -0.01312255859375, -0.006103515625, -0.002685546875, -0.004425048828125, -0.003875732421875, -0.00189208984375, -0.0020751953125, -0.004608154296875, -0.00360107421875, -0.000946044921875, -0.00189208984375, -0.00396728515625, -0.00396728515625, -0.005706787109375, -0.00787353515625, -0.006103515625, -0.00335693359375, -0.003021240234375, -0.003875732421875, -0.003936767578125, -0.00372314453125, -0.003204345703125, -0.00048828125, 0.000518798828125, -0.001800537109375, -0.003662109375, -0.003662109375, -0.0040283203125, -0.00482177734375, -0.004058837890625, -0.003082275390625, -0.003814697265625, -0.005706787109375, -0.0072021484375, -0.007171630859375, -0.004364013671875, -0.001251220703125, -0.001678466796875, -0.004547119140625, -0.005401611328125, -0.003082275390625, -0.00042724609375, 6.103515625e-05, -0.000579833984375, -0.001373291015625, -0.001800537109375, -0.0015869140625, -0.001861572265625, -0.002777099609375, -0.003448486328125, -0.00445556640625, -0.005950927734375, -0.006591796875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, -3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, -9.1552734375e-05, 3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, -9.1552734375e-05, 0.00018310546875, -0.00018310546875, -3.0517578125e-05, 6.103515625e-05, -0.000152587890625, 0.000396728515625, -0.000244140625, 0.001251220703125, 0.01641845703125, 0.10272216796875, 0.076507568359375, -0.068756103515625, -0.058319091796875, 0.01068115234375, -0.01678466796875, 0.0406494140625, 0.225799560546875, 0.16796875, 0.00592041015625, 0.059539794921875, 0.095794677734375, -0.010345458984375, -0.071685791015625, -0.071441650390625, -0.1087646484375, -0.1138916015625, -0.056915283203125, -0.0367431640625, -0.060760498046875, -0.033660888671875, 0.013214111328125, 0.014251708984375, 0.02398681640625, 0.040802001953125, 0.03204345703125, 0.01934814453125, 0.024505615234375, 0.026092529296875, 0.003936767578125, -0.009765625, -0.0048828125, -0.007110595703125, -0.02008056640625, -0.01995849609375, -0.0203857421875, -0.022705078125, -0.014678955078125, -0.00457763671875, -0.00250244140625, -0.00738525390625, -0.005126953125, -0.006622314453125, -0.0081787109375, -0.002532958984375, -0.002532958984375, -0.008453369140625, -0.01239013671875, -0.010772705078125, -0.00958251953125, -0.0091552734375, -0.007598876953125, -0.00836181640625, -0.009674072265625, -0.007843017578125, -0.00341796875, -0.001190185546875, -6.103515625e-05, 0.00091552734375, 0.000518798828125, -0.00152587890625, -0.003631591796875, -0.00286865234375, -0.001922607421875, -0.00299072265625, -0.00421142578125, -0.005126953125, -0.006622314453125, -0.0087890625, -0.008026123046875, -0.004241943359375, -0.00384521484375, -0.004791259765625, -0.00421142578125, -0.00299072265625, -0.00201416015625, -0.000396728515625, 0.000762939453125, -0.000701904296875, -0.002532958984375, -0.0030517578125, -0.00360107421875, -0.004547119140625, -0.003631591796875, -0.002593994140625, -0.003570556640625, -0.0057373046875, -0.007720947265625, -0.007568359375, -0.00494384765625, -0.00238037109375, -0.001953125, -0.004119873046875, -0.004730224609375, -0.001556396484375, 0.00140380859375, 0.00103759765625, -0.0006103515625, -0.001434326171875, -0.002227783203125, -0.0025634765625, -0.0028076171875, -0.003387451171875, -0.00390625, -0.004669189453125, -0.00616455078125, -0.006927490234375, -0.0057373046875])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, 0.0, -0.0001220703125, 0.0, -6.103515625e-05, 0.0001220703125, -0.0001220703125, 9.1552734375e-05, -0.00018310546875, -0.00018310546875, 3.0517578125e-05, -0.0003662109375, 0.00054931640625, -0.00054931640625, 0.001556396484375, 0.014617919921875, 0.109130859375, 0.08966064453125, -0.07421875, -0.070953369140625, 0.00933837890625, -0.015350341796875, 0.042327880859375, 0.245147705078125, 0.182769775390625, -0.001495361328125, 0.05987548828125, 0.104583740234375, -0.0120849609375, -0.079132080078125, -0.075042724609375, -0.11712646484375, -0.1273193359375, -0.065704345703125, -0.0379638671875, -0.061431884765625, -0.037017822265625, 0.014801025390625, 0.012359619140625, 0.023162841796875, 0.04827880859375, 0.036407470703125, 0.01788330078125, 0.0196533203125, 0.02587890625, 0.01007080078125, -0.00494384765625, -0.005615234375, -0.0113525390625, -0.029266357421875, -0.034271240234375, -0.031341552734375, -0.026458740234375, -0.013397216796875, -0.001434326171875, 0.00750732421875, 0.006256103515625, 0.000152587890625, 0.001434326171875, 0.002166748046875, -0.001251220703125, -0.002899169921875, -0.0089111328125, -0.017333984375, -0.017486572265625, -0.012664794921875, -0.0135498046875, -0.015777587890625, -0.011871337890625, -0.007965087890625, -0.009124755859375, -0.0048828125, 0.001678466796875, 0.0032958984375, 0.00244140625, 0.001129150390625, 0.00091552734375, -0.00091552734375, -0.001495361328125, -0.000823974609375, -0.002197265625, -0.005401611328125, -0.0062255859375, -0.007354736328125, -0.010467529296875, -0.009033203125, -0.0054931640625, -0.005279541015625, -0.006378173828125, -0.00506591796875, -0.00299072265625, -0.002471923828125, -0.000823974609375, 0.0008544921875, -0.00030517578125, -0.002044677734375, -0.00286865234375, -0.00323486328125, -0.003570556640625, -0.0023193359375, -0.00177001953125, -0.003692626953125, -0.00634765625, -0.008026123046875, -0.0074462890625, -0.00579833984375, -0.00433349609375, -0.003997802734375, -0.004302978515625, -0.0030517578125, -0.000152587890625, 0.002166748046875, 0.002410888671875, 0.000518798828125, -0.002105712890625, -0.004241943359375, -0.00506591796875, -0.004364013671875, -0.00372314453125, -0.004364013671875, -0.0054931640625, -0.006317138671875, -0.0067138671875, -0.005615234375, -0.00390625])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -0.0001220703125, -3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, -0.0001220703125, -0.000244140625, 0.000152587890625, -0.000457763671875, 0.000701904296875, -0.000946044921875, 0.001922607421875, 0.012908935546875, 0.1146240234375, 0.104095458984375, -0.078948974609375, -0.083831787109375, 0.00811767578125, -0.014434814453125, 0.043212890625, 0.263885498046875, 0.199981689453125, -0.008270263671875, 0.059295654296875, 0.113739013671875, -0.01385498046875, -0.08734130859375, -0.078094482421875, -0.1217041015625, -0.14105224609375, -0.0760498046875, -0.039642333984375, -0.063323974609375, -0.04083251953125, 0.018402099609375, 0.01580810546875, 0.019500732421875, 0.05169677734375, 0.042755126953125, 0.01788330078125, 0.019866943359375, 0.02642822265625, 0.00634765625, -0.005950927734375, -0.000762939453125, -0.007568359375, -0.0330810546875, -0.04339599609375, -0.0408935546875, -0.03631591796875, -0.0198974609375, -0.0020751953125, 0.00689697265625, 0.00634765625, 0.01275634765625, 0.015655517578125, 0.0093994140625, 0.007568359375, 0.004364013671875, -0.0076904296875, -0.0189208984375, -0.018890380859375, -0.0191650390625, -0.022003173828125, -0.0150146484375, -0.009033203125, -0.014068603515625, -0.01593017578125, -0.00555419921875, 0.003326416015625, 0.003326416015625, 0.00146484375, 0.002288818359375, 0.0029296875, 0.000518798828125, 0.000701904296875, 0.00225830078125, -0.00042724609375, -0.004150390625, -0.0054931640625, -0.007904052734375, -0.01104736328125, -0.010284423828125, -0.0068359375, -0.0067138671875, -0.00701904296875, -0.005401611328125, -0.004150390625, -0.003570556640625, -0.001708984375, 0.00091552734375, -0.00030517578125, -0.002166748046875, -0.002166748046875, -0.0020751953125, -0.002105712890625, -0.00140380859375, -0.000701904296875, -0.002685546875, -0.00555419921875, -0.0079345703125, -0.0087890625, -0.006134033203125, -0.00390625, -0.004119873046875, -0.005035400390625, -0.0040283203125, -0.0003662109375, 0.00396728515625, 0.005218505859375, 0.001922607421875, -0.00238037109375, -0.005523681640625, -0.006500244140625, -0.00592041015625, -0.0050048828125, -0.005035400390625, -0.0059814453125, -0.006561279296875, -0.006256103515625, -0.00482177734375, -0.003082275390625, -0.002471923828125])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 3.0517578125e-05, -3.0517578125e-05, -0.000152587890625, -3.0517578125e-05, -9.1552734375e-05, 0.0001220703125, -6.103515625e-05, 9.1552734375e-05, -9.1552734375e-05, -0.0003662109375, 0.00030517578125, -0.000640869140625, 0.0008544921875, -0.00128173828125, 0.00213623046875, 0.011932373046875, 0.11962890625, 0.1177978515625, -0.08245849609375, -0.097015380859375, 0.007080078125, -0.014251708984375, 0.044097900390625, 0.2823486328125, 0.217559814453125, -0.012603759765625, 0.058441162109375, 0.12200927734375, -0.01739501953125, -0.09564208984375, -0.080902099609375, -0.1258544921875, -0.15264892578125, -0.087982177734375, -0.04180908203125, -0.063934326171875, -0.046600341796875, 0.01885986328125, 0.02252197265625, 0.021514892578125, 0.052581787109375, 0.04718017578125, 0.01910400390625, 0.018035888671875, 0.028656005859375, 0.008514404296875, -0.009521484375, -0.005767822265625, -0.006561279296875, -0.030181884765625, -0.04632568359375, -0.04791259765625, -0.04150390625, -0.023468017578125, -0.012725830078125, -0.00323486328125, 0.0098876953125, 0.017059326171875, 0.019378662109375, 0.019256591796875, 0.018096923828125, 0.012176513671875, -0.00146484375, -0.014892578125, -0.020355224609375, -0.020416259765625, -0.0198974609375, -0.016143798828125, -0.015167236328125, -0.016326904296875, -0.01611328125, -0.009765625, -0.00262451171875, 9.1552734375e-05, 0.00262451171875, 0.002410888671875, 0.001007080078125, 0.00140380859375, 0.00347900390625, 0.004791259765625, 0.002197265625, -0.002532958984375, -0.0040283203125, -0.006134033203125, -0.010650634765625, -0.01153564453125, -0.00775146484375, -0.006256103515625, -0.0076904296875, -0.007171630859375, -0.005584716796875, -0.0047607421875, -0.003265380859375, -0.00054931640625, -0.000244140625, -0.001495361328125, -0.00146484375, -0.00140380859375, -0.001495361328125, -0.000732421875, -0.000152587890625, -0.001861572265625, -0.00537109375, -0.007476806640625, -0.00738525390625, -0.00537109375, -0.00384521484375, -0.004669189453125, -0.005828857421875, -0.004669189453125, -0.000640869140625, 0.003692626953125, 0.005462646484375, 0.003082275390625, -0.00140380859375, -0.00518798828125, -0.007476806640625, -0.0078125, -0.00653076171875, -0.005706787109375, -0.0062255859375, -0.007171630859375, -0.0067138671875, -0.004913330078125, -0.00250244140625, -0.00115966796875, -0.001800537109375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, -0.000152587890625, -3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, 0.0, 6.103515625e-05, -3.0517578125e-05, -0.000396728515625, 0.000396728515625, -0.000762939453125, 0.0009765625, -0.001373291015625, 0.00213623046875, 0.0113525390625, 0.123321533203125, 0.13018798828125, -0.08203125, -0.109405517578125, 0.0045166015625, -0.01361083984375, 0.04290771484375, 0.29766845703125, 0.236175537109375, -0.012237548828125, 0.056793212890625, 0.1295166015625, -0.020172119140625, -0.105316162109375, -0.083038330078125, -0.128448486328125, -0.162017822265625, -0.101837158203125, -0.046905517578125, -0.061065673828125, -0.050079345703125, 0.014129638671875, 0.025787353515625, 0.02764892578125, 0.055419921875, 0.050506591796875, 0.0225830078125, 0.014923095703125, 0.0289306640625, 0.012054443359375, -0.0108642578125, -0.009002685546875, -0.008941650390625, -0.031707763671875, -0.04937744140625, -0.04998779296875, -0.04351806640625, -0.02880859375, -0.017547607421875, -0.0052490234375, 0.004669189453125, 0.013153076171875, 0.02056884765625, 0.02215576171875, 0.022674560546875, 0.019683837890625, 0.00567626953125, -0.00933837890625, -0.014862060546875, -0.012908935546875, -0.015289306640625, -0.018341064453125, -0.016815185546875, -0.018310546875, -0.019775390625, -0.014434814453125, -0.006378173828125, -0.0023193359375, -0.001251220703125, -0.000335693359375, 0.000732421875, 0.0009765625, 0.003326416015625, 0.006927490234375, 0.005035400390625, -0.00067138671875, -0.001678466796875, -0.00390625, -0.009735107421875, -0.01153564453125, -0.007476806640625, -0.006317138671875, -0.008209228515625, -0.00738525390625, -0.006988525390625, -0.007598876953125, -0.0048828125, -0.000579833984375, -0.000457763671875, -0.001983642578125, -0.00115966796875, -0.0006103515625, -0.00115966796875, -0.00018310546875, 0.00054931640625, -0.00225830078125, -0.005859375, -0.00604248046875, -0.00482177734375, -0.00390625, -0.003387451171875, -0.004119873046875, -0.00592041015625, -0.0057373046875, -0.001373291015625, 0.003143310546875, 0.0045166015625, 0.0028076171875, -0.000518798828125, -0.004608154296875, -0.007720947265625, -0.008209228515625, -0.0074462890625, -0.006683349609375, -0.0068359375, -0.007415771484375, -0.006866455078125, -0.00469970703125, -0.00201416015625, -0.000885009765625, -0.001068115234375, -0.001708984375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -0.00018310546875, -3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, -0.000457763671875, 0.00030517578125, -0.000762939453125, 0.000946044921875, -0.00146484375, 0.001953125, 0.011077880859375, 0.126312255859375, 0.13983154296875, -0.0780029296875, -0.119354248046875, -0.000885009765625, -0.01361083984375, 0.040863037109375, 0.308807373046875, 0.255035400390625, -0.00494384765625, 0.0543212890625, 0.13433837890625, -0.019500732421875, -0.116851806640625, -0.0869140625, -0.130157470703125, -0.169189453125, -0.115020751953125, -0.057098388671875, -0.05889892578125, -0.048370361328125, 0.0106201171875, 0.02386474609375, 0.031524658203125, 0.062286376953125, 0.053253173828125, 0.02520751953125, 0.017425537109375, 0.02618408203125, 0.01275634765625, -0.010589599609375, -0.012725830078125, -0.009307861328125, -0.033477783203125, -0.054290771484375, -0.05401611328125, -0.050933837890625, -0.032440185546875, -0.011077880859375, -0.003387451171875, -0.000701904296875, 0.007080078125, 0.01776123046875, 0.021148681640625, 0.020904541015625, 0.02008056640625, 0.01025390625, -0.00213623046875, -0.003204345703125, -0.00433349609375, -0.012847900390625, -0.01434326171875, -0.01385498046875, -0.018524169921875, -0.0247802734375, -0.01947021484375, -0.009185791015625, -0.007293701171875, -0.005340576171875, -0.001190185546875, -6.103515625e-05, -0.002166748046875, 0.001739501953125, 0.00714111328125, 0.006378173828125, 0.002105712890625, -0.0001220703125, -0.00225830078125, -0.0078125, -0.00909423828125, -0.006011962890625, -0.00701904296875, -0.00933837890625, -0.00933837890625, -0.008758544921875, -0.00823974609375, -0.004974365234375, -0.000823974609375, -0.000732421875, -0.002410888671875, -0.002410888671875, -0.00152587890625, -0.001312255859375, 0.0001220703125, 0.000457763671875, -0.001739501953125, -0.00390625, -0.00482177734375, -0.004547119140625, -0.003082275390625, -0.0023193359375, -0.0037841796875, -0.0054931640625, -0.0054931640625, -0.002349853515625, 0.00164794921875, 0.003448486328125, 0.002227783203125, -0.00091552734375, -0.004852294921875, -0.007537841796875, -0.00799560546875, -0.007537841796875, -0.007293701171875, -0.007843017578125, -0.008331298828125, -0.007232666015625, -0.00439453125, -0.001312255859375, -0.000335693359375, -0.001220703125, -0.001800537109375, -0.00128173828125])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000152587890625, 6.103515625e-05, -0.00018310546875, 0.00030517578125, 3.0517578125e-05, 9.1552734375e-05, 0.0003662109375, -0.000823974609375, 0.00128173828125, -0.002197265625, 0.00323486328125, -0.004241943359375, 0.005096435546875, 0.016571044921875, 0.20355224609375, 0.1304931640625, -0.0821533203125, -0.050262451171875, -0.17919921875, 0.024169921875, 0.1522216796875, 0.153656005859375, 0.359283447265625, 0.234588623046875, -0.068145751953125, -0.037200927734375, 0.0606689453125, -0.153656005859375, -0.304931640625, -0.21624755859375, -0.089202880859375, -0.107269287109375, -0.09527587890625, 0.006805419921875, 0.00048828125, 0.041595458984375, 0.089630126953125, 0.06298828125, 0.06842041015625, 0.074462890625, 0.032928466796875, 0.0010986328125, 0.001617431640625, 0.00616455078125, 0.01873779296875, 0.00579833984375, 0.001983642578125, -0.017974853515625, -0.057830810546875, -0.07806396484375, -0.06036376953125, -0.030426025390625, -0.02947998046875, -0.01556396484375, 0.0244140625, 0.02984619140625, 0.024658203125, 0.030792236328125, 0.016937255859375, -0.00640869140625, -0.01617431640625, -0.02166748046875, -0.031524658203125, -0.036407470703125, -0.030487060546875, -0.014068603515625, -0.01300048828125, -0.017547607421875, -0.01800537109375, -0.01385498046875, -0.002655029296875, 0.005126953125, 0.002685546875, -0.001007080078125, 0.0023193359375, 0.003448486328125, 0.0025634765625, 0.004058837890625, 0.00726318359375, 0.003631591796875, -0.0050048828125, -0.00927734375, -0.0108642578125, -0.013031005859375, -0.01214599609375, -0.00958251953125, -0.0072021484375, -0.0084228515625, -0.0079345703125, -0.0048828125, -0.000213623046875, 0.00469970703125, 0.005645751953125, 0.00103759765625, -0.004364013671875, -0.00439453125, -0.001983642578125, -0.00048828125, -0.000213623046875, -0.001922607421875, -0.006195068359375, -0.008209228515625, -0.00592041015625, -0.004180908203125, -0.003570556640625, -0.00311279296875, -0.0052490234375, -0.006439208984375, -0.003662109375, 0.0006103515625, 0.002655029296875, 0.000885009765625, -0.003570556640625, -0.005828857421875, -0.0047607421875, -0.0032958984375, -0.001373291015625, -0.001373291015625, -0.00384521484375, -0.00421142578125, -0.0029296875, -0.000274658203125, 0.003326416015625, 0.003082275390625, -0.001220703125, -0.00384521484375, -0.004119873046875, -0.005584716796875])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -0.0001220703125, 9.1552734375e-05, -0.000213623046875, 0.00042724609375, -0.000152587890625, 0.00030517578125, -9.1552734375e-05, -0.000213623046875, 0.000518798828125, -0.00128173828125, 0.002044677734375, -0.00250244140625, 0.00299072265625, 0.02484130859375, 0.191253662109375, 0.097442626953125, -0.066162109375, -0.044036865234375, -0.156768798828125, 0.022125244140625, 0.139923095703125, 0.157623291015625, 0.315338134765625, 0.209747314453125, -0.051605224609375, -0.01959228515625, 0.057281494140625, -0.146697998046875, -0.287567138671875, -0.18988037109375, -0.0736083984375, -0.117095947265625, -0.09100341796875, 0.014556884765625, -0.002593994140625, 0.03369140625, 0.084228515625, 0.060821533203125, 0.060821533203125, 0.06146240234375, 0.026153564453125, 0.00921630859375, 0.00531005859375, 0.0081787109375, 0.019256591796875, 0.00347900390625, 0.002532958984375, -0.015960693359375, -0.053131103515625, -0.0706787109375, -0.05609130859375, -0.033447265625, -0.021820068359375, -0.000213623046875, 0.02215576171875, 0.022125244140625, 0.019287109375, 0.022003173828125, 0.01129150390625, -0.006683349609375, -0.017364501953125, -0.023040771484375, -0.024688720703125, -0.02813720703125, -0.029754638671875, -0.0206298828125, -0.01568603515625, -0.01690673828125, -0.018890380859375, -0.01483154296875, -0.00311279296875, 0.0057373046875, 0.0020751953125, -0.000732421875, 0.003387451171875, 0.003265380859375, 0.00152587890625, 0.003204345703125, 0.0062255859375, 0.001678466796875, -0.006072998046875, -0.009490966796875, -0.010223388671875, -0.010498046875, -0.009765625, -0.007568359375, -0.006256103515625, -0.00762939453125, -0.00665283203125, -0.003875732421875, -0.000701904296875, 0.00299072265625, 0.004730224609375, 0.000732421875, -0.0045166015625, -0.005340576171875, -0.00274658203125, 0.00048828125, 0.000762939453125, -0.001556396484375, -0.006103515625, -0.008636474609375, -0.0062255859375, -0.00396728515625, -0.003631591796875, -0.00384521484375, -0.00506591796875, -0.00518798828125, -0.002410888671875, 0.00128173828125, 0.00238037109375, -0.000274658203125, -0.004150390625, -0.00567626953125, -0.0047607421875, -0.00396728515625, -0.0025634765625, -0.001922607421875, -0.003448486328125, -0.002960205078125, -0.001495361328125, 0.00054931640625, 0.00323486328125, 0.002899169921875, -0.00067138671875, -0.003875732421875, -0.004730224609375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -9.1552734375e-05, -0.0001220703125, 0.0001220703125, -0.00018310546875, 0.00042724609375, -0.000244140625, 0.00048828125, -0.00042724609375, 0.0003662109375, -0.000274658203125, -6.103515625e-05, 0.000732421875, -0.00079345703125, 0.0008544921875, 0.038299560546875, 0.17919921875, 0.061767578125, -0.0487060546875, -0.04901123046875, -0.14263916015625, 0.0435791015625, 0.128326416015625, 0.156646728515625, 0.29583740234375, 0.167388916015625, -0.04736328125, 0.012603759765625, 0.038848876953125, -0.162841796875, -0.257781982421875, -0.1502685546875, -0.078033447265625, -0.123138427734375, -0.063629150390625, 0.012481689453125, -0.010711669921875, 0.04156494140625, 0.077178955078125, 0.05291748046875, 0.054473876953125, 0.049072265625, 0.023590087890625, 0.0137939453125, 0.0069580078125, 0.013702392578125, 0.014434814453125, 0.00042724609375, 0.00555419921875, -0.018890380859375, -0.052703857421875, -0.06268310546875, -0.04962158203125, -0.03350830078125, -0.011016845703125, 0.018951416015625, 0.0189208984375, 0.00628662109375, 0.01336669921875, 0.014434814453125, 0.004058837890625, -0.009918212890625, -0.020172119140625, -0.021881103515625, -0.021697998046875, -0.022613525390625, -0.02337646484375, -0.0218505859375, -0.019561767578125, -0.015106201171875, -0.01812744140625, -0.015167236328125, -0.00250244140625, 0.004608154296875, 0.000885009765625, -0.001190185546875, 0.002777099609375, 0.00189208984375, 0.0, 0.003082275390625, 0.00408935546875, -0.001068115234375, -0.00628662109375, -0.0087890625, -0.00909423828125, -0.00811767578125, -0.006103515625, -0.00433349609375, -0.00537109375, -0.007354736328125, -0.005584716796875, -0.003265380859375, -0.001495361328125, 0.00128173828125, 0.0020751953125, -0.001312255859375, -0.0042724609375, -0.0047607421875, -0.00213623046875, -9.1552734375e-05, 9.1552734375e-05, -0.001708984375, -0.006072998046875, -0.0079345703125, -0.006378173828125, -0.00390625, -0.003204345703125, -0.003570556640625, -0.004486083984375, -0.0042724609375, -0.0015869140625, 0.001556396484375, 0.00213623046875, -0.001068115234375, -0.0050048828125, -0.0062255859375, -0.005706787109375, -0.004608154296875, -0.0025634765625, -0.0015869140625, -0.00262451171875, -0.0025634765625, -0.000823974609375, 0.001190185546875, 0.003265380859375, 0.00244140625, -0.001251220703125, -0.00384521484375])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, 0.0, -9.1552734375e-05, -0.0001220703125, 6.103515625e-05, -0.000152587890625, 0.0003662109375, -0.000274658203125, 0.00048828125, -0.000579833984375, 0.000518798828125, -0.00067138671875, 0.00048828125, -9.1552734375e-05, 0.000213623046875, 3.0517578125e-05, 0.04620361328125, 0.161376953125, 0.043548583984375, -0.03448486328125, -0.060760498046875, -0.120880126953125, 0.0589599609375, 0.10748291015625, 0.161590576171875, 0.272674560546875, 0.128204345703125, -0.027130126953125, 0.03228759765625, 0.012939453125, -0.16241455078125, -0.2154541015625, -0.13037109375, -0.090179443359375, -0.1083984375, -0.04632568359375, -0.000885009765625, -0.0089111328125, 0.045684814453125, 0.064208984375, 0.046478271484375, 0.04864501953125, 0.039764404296875, 0.025421142578125, 0.019439697265625, 0.011444091796875, 0.011138916015625, 0.00762939453125, 0.006561279296875, 0.0040283203125, -0.02362060546875, -0.046478271484375, -0.0516357421875, -0.043304443359375, -0.029083251953125, 0.000213623046875, 0.020355224609375, 0.00775146484375, -0.00390625, 0.0059814453125, 0.008453369140625, -0.001739501953125, -0.015167236328125, -0.01959228515625, -0.0185546875, -0.019073486328125, -0.017547607421875, -0.0174560546875, -0.01812744140625, -0.018280029296875, -0.016754150390625, -0.016845703125, -0.01348876953125, -0.00482177734375, 0.00091552734375, -0.0008544921875, -0.000701904296875, -0.000396728515625, -0.002105712890625, -0.000396728515625, 0.002716064453125, 0.002716064453125, -0.0013427734375, -0.00567626953125, -0.006866455078125, -0.006195068359375, -0.0050048828125, -0.003509521484375, -0.00286865234375, -0.0042724609375, -0.0064697265625, -0.005859375, -0.004058837890625, -0.002105712890625, -0.001129150390625, -0.0010986328125, -0.002655029296875, -0.0040283203125, -0.003692626953125, -0.002532958984375, -0.001312255859375, -0.0008544921875, -0.001953125, -0.0052490234375, -0.00701904296875, -0.0052490234375, -0.00372314453125, -0.00262451171875, -0.002593994140625, -0.00390625, -0.003875732421875, -0.00189208984375, 0.00091552734375, 0.001190185546875, -0.001190185546875, -0.005279541015625, -0.0069580078125, -0.00567626953125, -0.0047607421875, -0.00262451171875, -0.00177001953125, -0.002655029296875, -0.002044677734375, -0.000396728515625, 0.00177001953125, 0.00311279296875, 0.002166748046875, -0.0013427734375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, 6.103515625e-05, -0.0001220703125, 0.0003662109375, -0.000244140625, 0.00042724609375, -0.00048828125, 0.00054931640625, -0.000732421875, 0.00079345703125, -0.000518798828125, 0.0008544921875, -0.00018310546875, 0.04888916015625, 0.143798828125, 0.037506103515625, -0.029632568359375, -0.068939208984375, -0.09246826171875, 0.05755615234375, 0.0926513671875, 0.167449951171875, 0.239898681640625, 0.10577392578125, -0.00311279296875, 0.0360107421875, -0.008087158203125, -0.142425537109375, -0.17926025390625, -0.12823486328125, -0.08978271484375, -0.088653564453125, -0.04388427734375, -0.010772705078125, -0.003082275390625, 0.040863037109375, 0.052032470703125, 0.04443359375, 0.040252685546875, 0.036865234375, 0.0330810546875, 0.022430419921875, 0.007049560546875, 0.006805419921875, 0.01068115234375, 0.007232666015625, 0.001678466796875, -0.019744873046875, -0.035369873046875, -0.04010009765625, -0.04046630859375, -0.02667236328125, 0.001129150390625, 0.0113525390625, -0.00323486328125, -0.01055908203125, -0.000213623046875, 0.007080078125, -0.007598876953125, -0.02130126953125, -0.014892578125, -0.01348876953125, -0.015533447265625, -0.014404296875, -0.0101318359375, -0.011810302734375, -0.01727294921875, -0.01727294921875, -0.0166015625, -0.013763427734375, -0.008087158203125, -0.00311279296875, -0.00372314453125, -0.0025634765625, -0.0028076171875, -0.005035400390625, -0.001251220703125, 0.003509521484375, 0.004119873046875, -0.000396728515625, -0.0045166015625, -0.004180908203125, -0.00347900390625, -0.002716064453125, -0.00177001953125, -0.002288818359375, -0.004119873046875, -0.005645751953125, -0.00579833984375, -0.00531005859375, -0.004180908203125, -0.003143310546875, -0.002471923828125, -0.003265380859375, -0.004913330078125, -0.004486083984375, -0.002655029296875, -0.001220703125, -0.000823974609375, -0.002532958984375, -0.004608154296875, -0.004913330078125, -0.003448486328125, -0.00299072265625, -0.002532958984375, -0.002227783203125, -0.00347900390625, -0.00396728515625, -0.00238037109375, 3.0517578125e-05, 0.00054931640625, -0.001800537109375, -0.00506591796875, -0.0064697265625, -0.006317138671875, -0.005126953125, -0.00286865234375, -0.001922607421875, -0.00238037109375, -0.001251220703125, 0.000457763671875, 0.001495361328125, 0.00286865234375, 0.001800537109375])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, 3.0517578125e-05, -9.1552734375e-05, 0.000274658203125, -0.000274658203125, 0.0003662109375, -0.000457763671875, 0.000518798828125, -0.0006103515625, 0.000701904296875, -0.000579833984375, 0.00103759765625, -0.000244140625, 0.04730224609375, 0.128936767578125, 0.036224365234375, -0.031219482421875, -0.066131591796875, -0.070281982421875, 0.04656982421875, 0.08721923828125, 0.16357421875, 0.20819091796875, 0.09814453125, 0.0147705078125, 0.030181884765625, -0.01446533203125, -0.115386962890625, -0.158660888671875, -0.12646484375, -0.079833984375, -0.07550048828125, -0.047698974609375, -0.01409912109375, -0.00146484375, 0.031982421875, 0.047149658203125, 0.0400390625, 0.03607177734375, 0.040130615234375, 0.03466796875, 0.018951416015625, 0.001861572265625, 0.007049560546875, 0.014312744140625, 0.009979248046875, 0.00604248046875, -0.00994873046875, -0.024810791015625, -0.0408935546875, -0.0460205078125, -0.023345947265625, -0.0010986328125, -0.006378173828125, -0.0147705078125, -0.008270263671875, 0.0010986328125, 0.000274658203125, -0.014434814453125, -0.01904296875, -0.00933837890625, -0.0079345703125, -0.01177978515625, -0.010711669921875, -0.00555419921875, -0.005828857421875, -0.01422119140625, -0.020355224609375, -0.01885986328125, -0.014434814453125, -0.0101318359375, -0.008392333984375, -0.00726318359375, -0.00457763671875, -0.00494384765625, -0.005096435546875, -0.00054931640625, 0.00469970703125, 0.00469970703125, 0.0008544921875, -0.001678466796875, -0.001922607421875, -0.0015869140625, -0.00152587890625, -0.00164794921875, -0.00213623046875, -0.0040283203125, -0.0057373046875, -0.00677490234375, -0.00677490234375, -0.005401611328125, -0.003997802734375, -0.00384521484375, -0.005035400390625, -0.00579833984375, -0.00457763671875, -0.00225830078125, -0.000823974609375, -0.00115966796875, -0.002044677734375, -0.003387451171875, -0.00323486328125, -0.002532958984375, -0.00250244140625, -0.00213623046875, -0.002410888671875, -0.003448486328125, -0.003814697265625, -0.002593994140625, -0.001129150390625, -0.000823974609375, -0.002655029296875, -0.004974365234375, -0.005828857421875, -0.006439208984375, -0.005523681640625, -0.002716064453125, -0.00103759765625, -0.001373291015625, -0.001220703125, -0.00018310546875, 0.001007080078125, 0.002105712890625])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -6.103515625e-05, 6.103515625e-05, -3.0517578125e-05, 0.000244140625, -0.000213623046875, 0.00042724609375, -0.000396728515625, 0.000518798828125, -0.000518798828125, 0.000579833984375, -0.00030517578125, 0.000701904296875, 3.0517578125e-05, 0.0428466796875, 0.116912841796875, 0.0357666015625, -0.032196044921875, -0.05694580078125, -0.05865478515625, 0.0364990234375, 0.084625244140625, 0.15155029296875, 0.184967041015625, 0.096771240234375, 0.0233154296875, 0.02655029296875, -0.010040283203125, -0.09375, -0.144012451171875, -0.119232177734375, -0.0689697265625, -0.06915283203125, -0.050811767578125, -0.016387939453125, -0.003509521484375, 0.02777099609375, 0.045684814453125, 0.03533935546875, 0.03228759765625, 0.041595458984375, 0.03228759765625, 0.010772705078125, 0.001800537109375, 0.01507568359375, 0.01983642578125, 0.01934814453125, 0.013824462890625, -0.009765625, -0.029083251953125, -0.045745849609375, -0.044891357421875, -0.024566650390625, -0.013275146484375, -0.019805908203125, -0.016357421875, -0.003173828125, 0.000732421875, -0.007904052734375, -0.0166015625, -0.010650634765625, -0.002197265625, -0.004974365234375, -0.00994873046875, -0.006256103515625, -0.00018310546875, -0.003875732421875, -0.015045166015625, -0.021636962890625, -0.020355224609375, -0.015167236328125, -0.0128173828125, -0.0120849609375, -0.01007080078125, -0.00628662109375, -0.00482177734375, -0.003265380859375, 0.000640869140625, 0.00439453125, 0.005584716796875, 0.002838134765625, 0.001190185546875, 0.0006103515625, -0.000640869140625, -0.00244140625, -0.002716064453125, -0.001983642578125, -0.00372314453125, -0.00628662109375, -0.007415771484375, -0.007354736328125, -0.006378173828125, -0.00531005859375, -0.0050048828125, -0.0057373046875, -0.005340576171875, -0.003875732421875, -0.00213623046875, -0.000946044921875, -0.000244140625, -0.00048828125, -0.0023193359375, -0.00286865234375, -0.001983642578125, -0.00128173828125, -0.0013427734375, -0.00225830078125, -0.0037841796875, -0.004638671875, -0.003570556640625, -0.001678466796875, -0.0013427734375, -0.0029296875, -0.0047607421875, -0.0054931640625, -0.00518798828125, -0.00390625, -0.00177001953125, -0.0010986328125, -0.001953125, -0.00146484375, -0.000396728515625, 0.000335693359375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -9.1552734375e-05, -9.1552734375e-05, -9.1552734375e-05, -6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -9.1552734375e-05, 3.0517578125e-05, -6.103515625e-05, 9.1552734375e-05, -0.000274658203125, 0.00030517578125, -0.0003662109375, 0.0003662109375, -0.000518798828125, 0.00048828125, -0.0003662109375, 0.000396728515625, 0.000274658203125, 0.036529541015625, 0.106201171875, 0.035888671875, -0.030242919921875, -0.0477294921875, -0.053558349609375, 0.029266357421875, 0.07965087890625, 0.137603759765625, 0.168426513671875, 0.09478759765625, 0.028961181640625, 0.0264892578125, -0.003143310546875, -0.07647705078125, -0.12994384765625, -0.110137939453125, -0.0616455078125, -0.0654296875, -0.053375244140625, -0.017913818359375, -0.00201416015625, 0.028472900390625, 0.038299560546875, 0.026947021484375, 0.031890869140625, 0.038055419921875, 0.02545166015625, 0.01153564453125, 0.011566162109375, 0.025482177734375, 0.030975341796875, 0.019775390625, 0.00274658203125, -0.0135498046875, -0.03070068359375, -0.0521240234375, -0.049102783203125, -0.0262451171875, -0.022369384765625, -0.02618408203125, -0.0125732421875, -0.000213623046875, -0.00250244140625, -0.012359619140625, -0.0106201171875, -0.001708984375, 0.000152587890625, -0.004669189453125, -0.0067138671875, -0.002960205078125, -0.00128173828125, -0.00482177734375, -0.014984130859375, -0.02154541015625, -0.02069091796875, -0.01727294921875, -0.01568603515625, -0.0142822265625, -0.010955810546875, -0.007537841796875, -0.004486083984375, -0.00128173828125, 0.001373291015625, 0.004180908203125, 0.00616455078125, 0.005279541015625, 0.003082275390625, 0.000518798828125, -0.00250244140625, -0.004058837890625, -0.00299072265625, -0.002105712890625, -0.003692626953125, -0.007110595703125, -0.008819580078125, -0.008514404296875, -0.00750732421875, -0.00592041015625, -0.005218505859375, -0.005523681640625, -0.0052490234375, -0.0037841796875, -0.00201416015625, -0.000732421875, 0.00018310546875, -0.000274658203125, -0.001434326171875, -0.002105712890625, -0.001617431640625, -0.001434326171875, -0.001983642578125, -0.003082275390625, -0.005279541015625, -0.0054931640625, -0.00396728515625, -0.002197265625, -0.00189208984375, -0.00299072265625, -0.00421142578125, -0.004730224609375, -0.00408935546875, -0.003631591796875, -0.002593994140625, -0.001922607421875, -0.002166748046875, -0.001800537109375, -0.00164794921875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, -6.103515625e-05, 0.0, -9.1552734375e-05, -3.0517578125e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, 0.000152587890625, -3.0517578125e-05, 0.000152587890625, -9.1552734375e-05, 0.000335693359375, -0.0001220703125, 0.000274658203125, -0.00030517578125, 0.00042724609375, -0.000152587890625, 0.000579833984375, 0.000213623046875, 0.030059814453125, 0.096282958984375, 0.036773681640625, -0.025726318359375, -0.039886474609375, -0.0506591796875, 0.023345947265625, 0.07305908203125, 0.124481201171875, 0.1549072265625, 0.094268798828125, 0.033416748046875, 0.0279541015625, 0.005157470703125, -0.06170654296875, -0.1160888671875, -0.1009521484375, -0.056121826171875, -0.0623779296875, -0.05169677734375, -0.013916015625, -0.0008544921875, 0.022216796875, 0.02734375, 0.02032470703125, 0.032012939453125, 0.035736083984375, 0.02642822265625, 0.02398681640625, 0.027130126953125, 0.028167724609375, 0.021575927734375, 0.0101318359375, -0.000579833984375, -0.0179443359375, -0.041717529296875, -0.056640625, -0.04364013671875, -0.027618408203125, -0.029144287109375, -0.024505615234375, -0.007843017578125, 0.000335693359375, -0.003448486328125, -0.00958251953125, -0.004974365234375, 0.0028076171875, 0.00103759765625, -0.0047607421875, -0.005645751953125, -0.002899169921875, -0.001068115234375, -0.00518798828125, -0.01483154296875, -0.020263671875, -0.02093505859375, -0.01953125, -0.0174560546875, -0.013824462890625, -0.010711669921875, -0.007171630859375, -0.002960205078125, 0.000213623046875, 0.0028076171875, 0.00482177734375, 0.0068359375, 0.00579833984375, 0.002166748046875, -0.000946044921875, -0.0030517578125, -0.003570556640625, -0.003143310546875, -0.00262451171875, -0.00408935546875, -0.0079345703125, -0.009979248046875, -0.00872802734375, -0.006561279296875, -0.005859375, -0.004852294921875, -0.00439453125, -0.004364013671875, -0.00341796875, -0.001617431640625, -9.1552734375e-05, 0.00048828125, 0.000885009765625, -0.000457763671875, -0.001922607421875, -0.002349853515625, -0.002227783203125, -0.00238037109375, -0.003875732421875, -0.005126953125, -0.00537109375, -0.004241943359375, -0.0020751953125, -0.00091552734375, -0.00177001953125, -0.003662109375, -0.004486083984375, -0.003997802734375, -0.003265380859375, -0.002288818359375, -0.001922607421875, -0.00225830078125, -0.002197265625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, -0.0001220703125, 6.103515625e-05, -9.1552734375e-05, 0.000335693359375, -0.000152587890625, 0.000152587890625, -0.000213623046875, 0.000213623046875, 3.0517578125e-05, 0.000335693359375, -6.103515625e-05, 0.02398681640625, 0.086090087890625, 0.038116455078125, -0.01934814453125, -0.03399658203125, -0.04937744140625, 0.018096923828125, 0.065399169921875, 0.111480712890625, 0.145050048828125, 0.09381103515625, 0.035308837890625, 0.031341552734375, 0.013275146484375, -0.050689697265625, -0.10211181640625, -0.090789794921875, -0.0511474609375, -0.05499267578125, -0.04730224609375, -0.01519775390625, -0.005126953125, 0.010223388671875, 0.017822265625, 0.024322509765625, 0.0340576171875, 0.03863525390625, 0.042022705078125, 0.030975341796875, 0.016143798828125, 0.017974853515625, 0.01824951171875, 0.001617431640625, -0.011566162109375, -0.026092529296875, -0.04644775390625, -0.04998779296875, -0.03704833984375, -0.03192138671875, -0.0303955078125, -0.0179443359375, -0.003021240234375, -0.00030517578125, -0.00372314453125, -0.00616455078125, -0.00128173828125, 0.001983642578125, -0.0018310546875, -0.003814697265625, -0.004241943359375, -0.00238037109375, -0.00146484375, -0.006591796875, -0.01513671875, -0.019439697265625, -0.0216064453125, -0.021392822265625, -0.0162353515625, -0.011871337890625, -0.009979248046875, -0.005859375, -0.00140380859375, 0.000885009765625, 0.002655029296875, 0.004547119140625, 0.005645751953125, 0.004058837890625, 0.0009765625, -0.00128173828125, -0.002960205078125, -0.003875732421875, -0.00408935546875, -0.003692626953125, -0.00555419921875, -0.00872802734375, -0.009124755859375, -0.008056640625, -0.006622314453125, -0.00494384765625, -0.003387451171875, -0.003448486328125, -0.00390625, -0.00286865234375, -0.001373291015625, -0.0001220703125, 0.000762939453125, 0.000640869140625, -0.00091552734375, -0.002471923828125, -0.00262451171875, -0.003021240234375, -0.00341796875, -0.00396728515625, -0.00494384765625, -0.005035400390625, -0.003875732421875, -0.001495361328125, -0.0006103515625, -0.001434326171875, -0.00335693359375, -0.004638671875, -0.00390625, -0.0029296875, -0.0018310546875, -0.001953125, -0.002777099609375])
        IR_LEFT[len(IR_LEFT)-1].append([6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -9.1552734375e-05, -9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, -9.1552734375e-05, 9.1552734375e-05, -6.103515625e-05, 0.000335693359375, -0.0001220703125, 9.1552734375e-05, -9.1552734375e-05, 0.000152587890625, 0.000152587890625, 3.0517578125e-05, 9.1552734375e-05, 0.018585205078125, 0.075531005859375, 0.040283203125, -0.012237548828125, -0.02978515625, -0.048187255859375, 0.013031005859375, 0.056732177734375, 0.10089111328125, 0.137969970703125, 0.092620849609375, 0.036895751953125, 0.035308837890625, 0.01934814453125, -0.040802001953125, -0.085235595703125, -0.076416015625, -0.045562744140625, -0.051849365234375, -0.0479736328125, -0.022308349609375, -0.010101318359375, 0.00616455078125, 0.01934814453125, 0.033782958984375, 0.043914794921875, 0.04400634765625, 0.031982421875, 0.017059326171875, 0.011566162109375, 0.0120849609375, 0.00555419921875, -0.010040283203125, -0.0155029296875, -0.028411865234375, -0.041961669921875, -0.039825439453125, -0.035308837890625, -0.03265380859375, -0.023284912109375, -0.01092529296875, -0.003265380859375, -0.00103759765625, -0.002899169921875, -0.00628662109375, -0.003662109375, 9.1552734375e-05, -0.00048828125, -0.00225830078125, -0.003204345703125, -0.002471923828125, -0.004058837890625, -0.008056640625, -0.01470947265625, -0.020050048828125, -0.0208740234375, -0.018218994140625, -0.013702392578125, -0.010650634765625, -0.0081787109375, -0.004180908203125, -0.00177001953125, 0.000152587890625, 0.00225830078125, 0.003143310546875, 0.003631591796875, 0.003326416015625, 0.00042724609375, -0.0023193359375, -0.00341796875, -0.004852294921875, -0.0050048828125, -0.005096435546875, -0.00616455078125, -0.007568359375, -0.00836181640625, -0.007232666015625, -0.005401611328125, -0.003509521484375, -0.002593994140625, -0.002777099609375, -0.0028076171875, -0.003021240234375, -0.00201416015625, -0.00054931640625, 0.000335693359375, 0.00018310546875, -0.001434326171875, -0.00262451171875, -0.003326416015625, -0.003753662109375, -0.00372314453125, -0.003875732421875, -0.00439453125, -0.004638671875, -0.003387451171875, -0.001251220703125, -0.00030517578125, -0.001251220703125, -0.003143310546875, -0.003936767578125, -0.00341796875, -0.002716064453125, -0.00225830078125, -0.002349853515625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, 0.0, -6.103515625e-05, 0.0, -3.0517578125e-05, 0.0, -9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, 0.000274658203125, -0.00018310546875, 3.0517578125e-05, 3.0517578125e-05, 9.1552734375e-05, 9.1552734375e-05, -0.00018310546875, 0.00030517578125, 0.013641357421875, 0.064971923828125, 0.042694091796875, -0.004669189453125, -0.0257568359375, -0.047332763671875, 0.00653076171875, 0.048431396484375, 0.09222412109375, 0.13262939453125, 0.0911865234375, 0.036956787109375, 0.03924560546875, 0.026336669921875, -0.025482177734375, -0.0640869140625, -0.067535400390625, -0.04986572265625, -0.056182861328125, -0.048065185546875, -0.018768310546875, -0.00909423828125, 0.009674072265625, 0.03668212890625, 0.038299560546875, 0.027557373046875, 0.03009033203125, 0.02374267578125, 0.00750732421875, 0.000274658203125, 0.00201416015625, -0.002197265625, -0.01129150390625, -0.013763427734375, -0.026580810546875, -0.033905029296875, -0.03057861328125, -0.031097412109375, -0.028594970703125, -0.0179443359375, -0.00885009765625, -0.003997802734375, -0.003509521484375, -0.007354736328125, -0.0084228515625, -0.0037841796875, 0.000762939453125, 0.001617431640625, -0.001800537109375, -0.004913330078125, -0.004119873046875, -0.005615234375, -0.010040283203125, -0.01416015625, -0.015960693359375, -0.017608642578125, -0.0159912109375, -0.011383056640625, -0.009033203125, -0.0076904296875, -0.00457763671875, -0.00225830078125, -0.001312255859375, 0.000762939453125, 0.00201416015625, 0.002532958984375, 0.001556396484375, -0.00091552734375, -0.003204345703125, -0.0048828125, -0.005462646484375, -0.005279541015625, -0.00531005859375, -0.00604248046875, -0.00640869140625, -0.006500244140625, -0.006011962890625, -0.0045166015625, -0.002716064453125, -0.001678466796875, -0.00238037109375, -0.003173828125, -0.0037841796875, -0.002655029296875, -0.000732421875, -3.0517578125e-05, -0.000457763671875, -0.002349853515625, -0.003173828125, -0.003631591796875, -0.004119873046875, -0.00408935546875, -0.003692626953125, -0.003662109375, -0.00390625, -0.002960205078125, -0.001373291015625, -0.000457763671875, -0.00079345703125, -0.00225830078125, -0.00341796875, -0.003570556640625, -0.003448486328125, -0.00286865234375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, 9.1552734375e-05, 0.0001220703125, 0.000152587890625, 0.0, 0.0, 0.000152587890625, 9.1552734375e-05, 3.0517578125e-05, -0.0001220703125, 0.000701904296875, 0.0096435546875, 0.05487060546875, 0.0445556640625, 0.002777099609375, -0.021331787109375, -0.047607421875, -0.000213623046875, 0.041717529296875, 0.085968017578125, 0.128387451171875, 0.0877685546875, 0.038482666015625, 0.047698974609375, 0.04034423828125, -0.01171875, -0.05706787109375, -0.071563720703125, -0.05401611328125, -0.045654296875, -0.038482666015625, -0.01129150390625, 0.007232666015625, 0.017730712890625, 0.02020263671875, 0.016632080078125, 0.0201416015625, 0.01776123046875, 0.005950927734375, -0.003936767578125, -0.005096435546875, 0.0013427734375, 0.00018310546875, -0.008575439453125, -0.013702392578125, -0.01947021484375, -0.019927978515625, -0.023284912109375, -0.0296630859375, -0.024627685546875, -0.015411376953125, -0.010528564453125, -0.00787353515625, -0.0081787109375, -0.010467529296875, -0.008636474609375, -0.001434326171875, 0.00244140625, -0.000762939453125, -0.0042724609375, -0.00439453125, -0.006011962890625, -0.00732421875, -0.00653076171875, -0.01031494140625, -0.013702392578125, -0.0146484375, -0.012542724609375, -0.01055908203125, -0.009429931640625, -0.00726318359375, -0.0057373046875, -0.003509521484375, -0.001800537109375, -0.0001220703125, 0.000335693359375, 0.000396728515625, 0.00030517578125, -0.00250244140625, -0.0042724609375, -0.004608154296875, -0.0050048828125, -0.00537109375, -0.00537109375, -0.004119873046875, -0.004730224609375, -0.00543212890625, -0.0048828125, -0.003631591796875, -0.001983642578125, -0.002044677734375, -0.00238037109375, -0.0035400390625, -0.003692626953125, -0.002532958984375, -0.001434326171875, -0.0006103515625, -0.001434326171875, -0.002471923828125, -0.003692626953125, -0.004180908203125, -0.0040283203125, -0.003448486328125, -0.002777099609375, -0.003204345703125, -0.003326416015625, -0.0029296875, -0.00115966796875, 0.000274658203125, -0.000152587890625, -0.001708984375, -0.0032958984375, -0.004058837890625, -0.00408935546875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, -6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, -9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, -0.000213623046875, 0.000457763671875, -0.000274658203125, -6.103515625e-05, 0.0001220703125, 0.000885009765625, 0.006195068359375, 0.045867919921875, 0.045562744140625, 0.010009765625, -0.01641845703125, -0.04925537109375, -0.00732421875, 0.03656005859375, 0.082489013671875, 0.123931884765625, 0.087921142578125, 0.049835205078125, 0.057281494140625, 0.04119873046875, -0.017822265625, -0.054046630859375, -0.0572509765625, -0.0445556640625, -0.032623291015625, -0.011871337890625, 0.001495361328125, -0.012420654296875, -0.00396728515625, 0.008056640625, 0.00164794921875, 0.00146484375, 0.0010986328125, -0.004608154296875, -0.006500244140625, 0.00421142578125, 0.0068359375, -0.0009765625, -0.004486083984375, -0.00439453125, -0.008575439453125, -0.013092041015625, -0.020263671875, -0.0281982421875, -0.02520751953125, -0.017578125, -0.01275634765625, -0.011962890625, -0.012359619140625, -0.0101318359375, -0.006072998046875, -0.002349853515625, -0.001708984375, -0.002716064453125, -0.003753662109375, -0.005157470703125, -0.00439453125, -0.003326416015625, -0.00482177734375, -0.00811767578125, -0.010345458984375, -0.01190185546875, -0.0123291015625, -0.010894775390625, -0.0096435546875, -0.008819580078125, -0.00616455078125, -0.00360107421875, -0.00311279296875, -0.0023193359375, -0.0015869140625, -0.001251220703125, -0.001739501953125, -0.002655029296875, -0.003662109375, -0.004486083984375, -0.00518798828125, -0.00482177734375, -0.003692626953125, -0.00323486328125, -0.003753662109375, -0.004425048828125, -0.0042724609375, -0.00341796875, -0.00238037109375, -0.002197265625, -0.002655029296875, -0.00347900390625, -0.00360107421875, -0.002899169921875, -0.002227783203125, -0.001678466796875, -0.001983642578125, -0.003204345703125, -0.00390625, -0.0035400390625, -0.003265380859375, -0.00299072265625, -0.002777099609375, -0.0029296875, -0.003143310546875, -0.002227783203125, -0.000244140625, 0.00042724609375, -0.000274658203125, -0.002105712890625, -0.00360107421875, -0.00445556640625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, -3.0517578125e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 0.0, 3.0517578125e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, -3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 0.0001220703125, 0.00018310546875, 6.103515625e-05, -6.103515625e-05, 0.000701904296875, -0.0006103515625, 0.000213623046875, 0.0003662109375, 0.001068115234375, 0.004058837890625, 0.038421630859375, 0.045318603515625, 0.0172119140625, -0.011627197265625, -0.05303955078125, -0.014984130859375, 0.0357666015625, 0.08544921875, 0.128875732421875, 0.094970703125, 0.047760009765625, 0.040679931640625, 0.035125732421875, -0.001129150390625, -0.034820556640625, -0.04205322265625, -0.015625, -0.00933837890625, -0.026214599609375, -0.024993896484375, -0.022705078125, -0.019683837890625, -0.018341064453125, -0.01409912109375, -0.010009765625, -0.00811767578125, -0.000213623046875, 0.00653076171875, 0.009613037109375, 0.008087158203125, 0.00927734375, 0.003570556640625, -0.000457763671875, -0.001251220703125, -0.00872802734375, -0.02349853515625, -0.03173828125, -0.025390625, -0.018646240234375, -0.015838623046875, -0.0146484375, -0.0115966796875, -0.01068115234375, -0.009521484375, -0.004547119140625, -0.002532958984375, -0.0025634765625, -0.001678466796875, -0.0008544921875, -0.001617431640625, -0.001922607421875, -0.00177001953125, -0.00555419921875, -0.00933837890625, -0.011688232421875, -0.012359619140625, -0.01190185546875, -0.01104736328125, -0.008148193359375, -0.0062255859375, -0.005035400390625, -0.00457763671875, -0.00408935546875, -0.003326416015625, -0.00189208984375, -0.00115966796875, -0.00250244140625, -0.003509521484375, -0.003997802734375, -0.003997802734375, -0.003753662109375, -0.002899169921875, -0.0020751953125, -0.002899169921875, -0.003936767578125, -0.004150390625, -0.003173828125, -0.002655029296875, -0.002410888671875, -0.0023193359375, -0.00299072265625, -0.00360107421875, -0.00384521484375, -0.003173828125, -0.002349853515625, -0.001861572265625, -0.00244140625, -0.003173828125, -0.003143310546875, -0.0030517578125, -0.0028076171875, -0.00250244140625, -0.00201416015625, -0.00189208984375, -0.00115966796875, -0.000396728515625, -0.000152587890625, -0.00067138671875, -0.00201416015625, -0.00347900390625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 0.0001220703125, 0.0, -9.1552734375e-05, 9.1552734375e-05, -9.1552734375e-05, 6.103515625e-05, 0.000152587890625, 0.0001220703125, 3.0517578125e-05, 0.00018310546875, 0.000457763671875, -0.00091552734375, 0.000579833984375, 0.000640869140625, 0.00115966796875, 0.002227783203125, 0.032867431640625, 0.045318603515625, 0.023834228515625, -0.00994873046875, -0.059478759765625, -0.0184326171875, 0.049560546875, 0.104644775390625, 0.12060546875, 0.0657958984375, 0.03497314453125, 0.052337646484375, 0.052886962890625, 0.014404296875, -0.000640869140625, -0.011688232421875, -0.030670166015625, -0.03271484375, -0.034942626953125, -0.043304443359375, -0.0477294921875, -0.04010009765625, -0.03240966796875, -0.02252197265625, -0.0084228515625, 0.000885009765625, 0.00640869140625, 0.014068603515625, 0.02203369140625, 0.0172119140625, 0.0106201171875, 0.007049560546875, 0.00482177734375, -0.0010986328125, -0.013824462890625, -0.02880859375, -0.032196044921875, -0.025543212890625, -0.019256591796875, -0.016815185546875, -0.016754150390625, -0.015533447265625, -0.014373779296875, -0.00885009765625, -0.003997802734375, -0.001556396484375, 0.0009765625, 0.00225830078125, 0.001312255859375, 0.000457763671875, 0.000946044921875, -0.001190185546875, -0.005950927734375, -0.010009765625, -0.012847900390625, -0.0135498046875, -0.013031005859375, -0.010467529296875, -0.0081787109375, -0.007354736328125, -0.006500244140625, -0.00640869140625, -0.0047607421875, -0.00299072265625, -0.001617431640625, -0.001800537109375, -0.002410888671875, -0.002593994140625, -0.003265380859375, -0.00323486328125, -0.0029296875, -0.00225830078125, -0.002105712890625, -0.0029296875, -0.0035400390625, -0.004364013671875, -0.00347900390625, -0.002349853515625, -0.002044677734375, -0.00238037109375, -0.0037841796875, -0.004608154296875, -0.004608154296875, -0.003143310546875, -0.001678466796875, -0.00140380859375, -0.0025634765625, -0.00335693359375, -0.003173828125, -0.0029296875, -0.001983642578125, -0.001373291015625, -0.001251220703125, -0.001739501953125, -0.001678466796875, -0.0009765625, -0.000518798828125, -0.001068115234375, -0.002410888671875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, 0.0, 0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, 9.1552734375e-05, 9.1552734375e-05, 0.0001220703125, 0.00018310546875, 9.1552734375e-05, -3.0517578125e-05, -0.000732421875, 0.001434326171875, 0.000457763671875, 0.000335693359375, 0.0015869140625, 0.03045654296875, 0.0458984375, 0.029510498046875, -0.013519287109375, -0.059478759765625, 0.000885009765625, 0.06378173828125, 0.08294677734375, 0.086517333984375, 0.07110595703125, 0.059783935546875, 0.06494140625, 0.081085205078125, 0.0501708984375, -0.01263427734375, -0.04290771484375, -0.034210205078125, -0.046539306640625, -0.06884765625, -0.062286376953125, -0.056549072265625, -0.0538330078125, -0.03326416015625, -0.0089111328125, -0.00244140625, 0.003814697265625, 0.02227783203125, 0.0313720703125, 0.02447509765625, 0.017120361328125, 0.014404296875, 0.005767822265625, 0.001953125, -0.004974365234375, -0.02069091796875, -0.031890869140625, -0.030364990234375, -0.023773193359375, -0.02154541015625, -0.021575927734375, -0.02069091796875, -0.016937255859375, -0.011474609375, -0.006011962890625, -0.0018310546875, 0.001800537109375, 0.004180908203125, 0.00469970703125, 0.00372314453125, 0.002716064453125, 0.000396728515625, -0.0029296875, -0.00830078125, -0.0120849609375, -0.013763427734375, -0.014190673828125, -0.0123291015625, -0.010101318359375, -0.0089111328125, -0.008758544921875, -0.007781982421875, -0.005950927734375, -0.003875732421875, -0.002777099609375, -0.001922607421875, -0.00164794921875, -0.00177001953125, -0.00189208984375, -0.00189208984375, -0.0028076171875, -0.003814697265625, -0.00299072265625, -0.001708984375, -0.002410888671875, -0.004180908203125, -0.0040283203125, -0.002716064453125, -0.002593994140625, -0.00299072265625, -0.00335693359375, -0.00433349609375, -0.004669189453125, -0.00335693359375, -0.00238037109375, -0.002166748046875, -0.00213623046875, -0.002655029296875, -0.00299072265625, -0.0025634765625, -0.001556396484375, -0.001434326171875, -0.0015869140625, -0.001678466796875, -0.001861572265625, -0.001861572265625, -0.001434326171875, -0.001251220703125, -0.001708984375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 0.0, 6.103515625e-05, -6.103515625e-05, 9.1552734375e-05, 9.1552734375e-05, 0.000396728515625, 0.0, -0.000274658203125, 9.1552734375e-05, 0.0003662109375, 0.00103759765625, -0.0001220703125, -0.000152587890625, 0.00341796875, 0.0311279296875, 0.049072265625, 0.038970947265625, -0.00811767578125, -0.056365966796875, -0.019744873046875, 0.048980712890625, 0.098907470703125, 0.097442626953125, 0.082244873046875, 0.094482421875, 0.099761962890625, 0.063262939453125, 0.014617919921875, -0.0201416015625, -0.058868408203125, -0.06658935546875, -0.068603515625, -0.079742431640625, -0.06915283203125, -0.0572509765625, -0.044281005859375, -0.02191162109375, -0.003326416015625, 0.009307861328125, 0.02203369140625, 0.03216552734375, 0.034088134765625, 0.025482177734375, 0.0140380859375, 0.008880615234375, 0.00384521484375, -0.001922607421875, -0.0137939453125, -0.02410888671875, -0.029693603515625, -0.031158447265625, -0.027801513671875, -0.024627685546875, -0.023406982421875, -0.01861572265625, -0.011383056640625, -0.0076904296875, -0.00323486328125, 0.001953125, 0.005096435546875, 0.006072998046875, 0.006866455078125, 0.00531005859375, 0.000701904296875, -0.003082275390625, -0.006072998046875, -0.010162353515625, -0.01336669921875, -0.01397705078125, -0.012664794921875, -0.012115478515625, -0.010894775390625, -0.00958251953125, -0.0086669921875, -0.006744384765625, -0.00433349609375, -0.003143310546875, -0.002899169921875, -0.001861572265625, -0.000885009765625, -0.00018310546875, -0.00067138671875, -0.003143310546875, -0.00506591796875, -0.00360107421875, -0.0013427734375, -0.001495361328125, -0.0025634765625, -0.003448486328125, -0.003692626953125, -0.003509521484375, -0.00347900390625, -0.003326416015625, -0.003265380859375, -0.0032958984375, -0.003387451171875, -0.003387451171875, -0.003387451171875, -0.002288818359375, -0.001312255859375, -0.001495361328125, -0.00177001953125, -0.001983642578125, -0.00201416015625, -0.001922607421875, -0.0013427734375, -0.001495361328125, -0.002105712890625, -0.002166748046875, -0.002044677734375, -0.00177001953125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0517578125e-05, -3.0517578125e-05, 0.0, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, -9.1552734375e-05, 6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 0.000152587890625, 0.000213623046875, 0.0003662109375, -0.00054931640625, 0.000213623046875, 0.00079345703125, 0.000457763671875, -0.00018310546875, 0.000152587890625, -0.000518798828125, 0.009857177734375, 0.040802001953125, 0.078948974609375, 0.046295166015625, -0.078826904296875, -0.094757080078125, 0.022369384765625, 0.10693359375, 0.112152099609375, 0.109222412109375, 0.120147705078125, 0.084442138671875, 0.059417724609375, 0.04620361328125, -0.0062255859375, -0.06671142578125, -0.083740234375, -0.070587158203125, -0.078704833984375, -0.07745361328125, -0.05511474609375, -0.04632568359375, -0.0362548828125, -0.00628662109375, 0.01458740234375, 0.018829345703125, 0.028350830078125, 0.0372314453125, 0.030059814453125, 0.016448974609375, 0.00994873046875, 0.005584716796875, -0.0018310546875, -0.008209228515625, -0.016876220703125, -0.0283203125, -0.0352783203125, -0.03314208984375, -0.027130126953125, -0.0230712890625, -0.017547607421875, -0.011688232421875, -0.008880615234375, -0.004364013671875, 0.001922607421875, 0.0045166015625, 0.00604248046875, 0.007904052734375, 0.00640869140625, 0.000640869140625, -0.003753662109375, -0.005279541015625, -0.008392333984375, -0.01202392578125, -0.012786865234375, -0.012969970703125, -0.01348876953125, -0.012542724609375, -0.010345458984375, -0.008331298828125, -0.007080078125, -0.005035400390625, -0.003387451171875, -0.003570556640625, -0.00286865234375, -9.1552734375e-05, 0.000701904296875, -0.001495361328125, -0.00408935546875, -0.004638671875, -0.003509521484375, -0.001983642578125, -0.00103759765625, -0.001373291015625, -0.002777099609375, -0.0042724609375, -0.004669189453125, -0.003936767578125, -0.003143310546875, -0.002288818359375, -0.002471923828125, -0.00390625, -0.004180908203125, -0.003692626953125, -0.002471923828125, -0.000762939453125, 9.1552734375e-05, -0.001373291015625, -0.002960205078125, -0.00274658203125, -0.0020751953125, -0.00140380859375, -0.001678466796875, -0.002105712890625, -0.0025634765625, -0.003143310546875, -0.002655029296875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, -3.0517578125e-05, 9.1552734375e-05, 6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.00018310546875, 0.0, 0.00030517578125, -0.000152587890625, -0.000213623046875, 0.00091552734375, 0.00079345703125, -0.000732421875, -0.000244140625, -0.000213623046875, 0.0074462890625, 0.048187255859375, 0.079864501953125, 0.042724609375, -0.079437255859375, -0.104461669921875, 0.01983642578125, 0.0997314453125, 0.133087158203125, 0.127899169921875, 0.088134765625, 0.076324462890625, 0.082733154296875, 0.03851318359375, -0.0277099609375, -0.052001953125, -0.070770263671875, -0.083831787109375, -0.073944091796875, -0.061248779296875, -0.05828857421875, -0.048553466796875, -0.029022216796875, -0.01123046875, 0.006866455078125, 0.01800537109375, 0.0264892578125, 0.029052734375, 0.02764892578125, 0.02191162109375, 0.01202392578125, 0.00323486328125, 6.103515625e-05, -0.00341796875, -0.01593017578125, -0.029693603515625, -0.03509521484375, -0.033233642578125, -0.02801513671875, -0.0208740234375, -0.014801025390625, -0.01116943359375, -0.009185791015625, -0.004119873046875, 0.001129150390625, 0.004058837890625, 0.00537109375, 0.00604248046875, 0.0040283203125, 0.0, -0.003173828125, -0.00537109375, -0.007537841796875, -0.010101318359375, -0.011688232421875, -0.013031005859375, -0.014190673828125, -0.0126953125, -0.010040283203125, -0.007843017578125, -0.00634765625, -0.005462646484375, -0.003997802734375, -0.0037841796875, -0.002349853515625, -0.00030517578125, -0.00067138671875, -0.003204345703125, -0.00421142578125, -0.00323486328125, -0.003082275390625, -0.002166748046875, -0.001129150390625, -0.00128173828125, -0.002716064453125, -0.00439453125, -0.004608154296875, -0.003814697265625, -0.00225830078125, -0.001922607421875, -0.0030517578125, -0.00433349609375, -0.004150390625, -0.002716064453125, -0.00189208984375, -0.000335693359375, -3.0517578125e-05, -0.001373291015625, -0.002960205078125, -0.00311279296875, -0.00225830078125, -0.00164794921875, -0.00164794921875, -0.00262451171875, -0.00341796875, -0.003387451171875, -0.00262451171875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 0.0, 0.0, 3.0517578125e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, 3.0517578125e-05, 0.00018310546875, 3.0517578125e-05, 0.0001220703125, 0.0, 0.00030517578125, 9.1552734375e-05, 0.001251220703125, -0.00048828125, -0.0003662109375, 0.00146484375, 0.027679443359375, 0.064178466796875, 0.04388427734375, -0.00323486328125, -0.06500244140625, -0.06671142578125, 0.03765869140625, 0.126007080078125, 0.1295166015625, 0.087127685546875, 0.073028564453125, 0.08465576171875, 0.071380615234375, 0.0147705078125, -0.0390625, -0.053985595703125, -0.055572509765625, -0.064239501953125, -0.0699462890625, -0.055908203125, -0.044097900390625, -0.038665771484375, -0.0264892578125, -0.008636474609375, 0.001739501953125, 0.009613037109375, 0.01947021484375, 0.02197265625, 0.0224609375, 0.01922607421875, 0.01348876953125, 0.005828857421875, 0.0008544921875, -0.005340576171875, -0.017791748046875, -0.0299072265625, -0.034332275390625, -0.02972412109375, -0.023468017578125, -0.018157958984375, -0.013092041015625, -0.008758544921875, -0.00634765625, -0.0042724609375, 0.000244140625, 0.004425048828125, 0.003662109375, 0.00152587890625, -3.0517578125e-05, -0.00152587890625, -0.003143310546875, -0.0050048828125, -0.006744384765625, -0.009246826171875, -0.011322021484375, -0.012542724609375, -0.01324462890625, -0.01141357421875, -0.0087890625, -0.006866455078125, -0.0059814453125, -0.00518798828125, -0.00439453125, -0.00323486328125, -0.002197265625, -0.0023193359375, -0.0028076171875, -0.00360107421875, -0.0035400390625, -0.00274658203125, -0.00225830078125, -0.001922607421875, -0.00152587890625, -0.001861572265625, -0.0035400390625, -0.00439453125, -0.00360107421875, -0.002410888671875, -0.001953125, -0.002685546875, -0.003814697265625, -0.004302978515625, -0.003265380859375, -0.001495361328125, -0.000640869140625, -0.00054931640625, -0.001129150390625, -0.001739501953125, -0.00250244140625, -0.003082275390625, -0.00244140625, -0.0018310546875, -0.00244140625, -0.00384521484375, -0.003814697265625, -0.002471923828125, -0.001800537109375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, 0.0, 0.0, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0001220703125, 9.1552734375e-05, 0.000152587890625, 6.103515625e-05, 3.0517578125e-05, 0.00042724609375, 0.00048828125, 9.1552734375e-05, 0.0008544921875, 0.000885009765625, 0.020721435546875, 0.055328369140625, 0.03814697265625, 0.002044677734375, -0.026275634765625, -0.059295654296875, -0.0107421875, 0.098297119140625, 0.136688232421875, 0.084442138671875, 0.05206298828125, 0.080718994140625, 0.075164794921875, 0.025909423828125, -0.010223388671875, -0.036529541015625, -0.05517578125, -0.05157470703125, -0.0426025390625, -0.04803466796875, -0.050079345703125, -0.03125, -0.017120361328125, -0.018951416015625, -0.01007080078125, 0.00238037109375, 0.00225830078125, 0.00494384765625, 0.015228271484375, 0.01678466796875, 0.011962890625, 0.010772705078125, 0.009613037109375, 0.000732421875, -0.01300048828125, -0.0216064453125, -0.026702880859375, -0.030181884765625, -0.025787353515625, -0.0179443359375, -0.013702392578125, -0.01080322265625, -0.005584716796875, -0.002410888671875, -0.002532958984375, 6.103515625e-05, 0.00311279296875, 0.00079345703125, -0.00323486328125, -0.00390625, -0.004302978515625, -0.004608154296875, -0.004547119140625, -0.00653076171875, -0.0093994140625, -0.0115966796875, -0.01141357421875, -0.00982666015625, -0.00897216796875, -0.00732421875, -0.005828857421875, -0.005645751953125, -0.004730224609375, -0.00323486328125, -0.003021240234375, -0.004302978515625, -0.00439453125, -0.003021240234375, -0.003143310546875, -0.003509521484375, -0.002655029296875, -0.001861572265625, -0.001800537109375, -0.002166748046875, -0.002899169921875, -0.004058837890625, -0.003448486328125, -0.002105712890625, -0.00152587890625, -0.00225830078125, -0.00341796875, -0.003692626953125, -0.003448486328125, -0.002197265625, -0.00079345703125, -9.1552734375e-05, -0.00067138671875, -0.001922607421875, -0.0023193359375, -0.002410888671875, -0.002410888671875, -0.0025634765625, -0.0030517578125, -0.003814697265625, -0.0040283203125, -0.003021240234375, -0.001739501953125, -0.00115966796875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, 0.0, 0.0, 0.0, 0.0, 0.0, -9.1552734375e-05, 0.0001220703125, 0.0, 0.0001220703125, -6.103515625e-05, 0.000274658203125, -3.0517578125e-05, 0.0003662109375, 0.0003662109375, 0.00018310546875, 0.001068115234375, 0.019500732421875, 0.05340576171875, 0.0350341796875, -0.004241943359375, -0.01397705078125, -0.036590576171875, -0.029754638671875, 0.066192626953125, 0.139678955078125, 0.09075927734375, 0.04656982421875, 0.0726318359375, 0.062744140625, 0.023284912109375, -0.000762939453125, -0.03143310546875, -0.049285888671875, -0.039276123046875, -0.038055419921875, -0.044158935546875, -0.031158447265625, -0.016845703125, -0.017059326171875, -0.012481689453125, 0.001312255859375, -0.002777099609375, -0.00836181640625, -0.00067138671875, 0.0006103515625, 0.00054931640625, 0.005523681640625, 0.008819580078125, 0.00750732421875, 0.00274658203125, -0.004364013671875, -0.016387939453125, -0.025360107421875, -0.02423095703125, -0.021209716796875, -0.020294189453125, -0.015960693359375, -0.009552001953125, -0.005584716796875, -0.001708984375, 0.00030517578125, 0.000762939453125, 0.000762939453125, -0.001220703125, -0.003387451171875, -0.00616455078125, -0.00775146484375, -0.00799560546875, -0.007080078125, -0.0059814453125, -0.008209228515625, -0.01104736328125, -0.00994873046875, -0.008026123046875, -0.00726318359375, -0.005828857421875, -0.005767822265625, -0.005828857421875, -0.004852294921875, -0.00341796875, -0.0032958984375, -0.005157470703125, -0.00531005859375, -0.0042724609375, -0.00372314453125, -0.003448486328125, -0.003387451171875, -0.0030517578125, -0.002593994140625, -0.00250244140625, -0.003387451171875, -0.003997802734375, -0.003265380859375, -0.001983642578125, -0.001556396484375, -0.0023193359375, -0.002838134765625, -0.003082275390625, -0.0032958984375, -0.002288818359375, -0.00146484375, -0.0010986328125, -0.00079345703125, -0.0009765625, -0.001983642578125, -0.003082275390625, -0.002532958984375, -0.00238037109375, -0.003631591796875, -0.004364013671875, -0.00421142578125, -0.003326416015625, -0.002197265625, -0.001800537109375, -0.00164794921875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 0.0, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 0.000152587890625, -9.1552734375e-05, 0.000213623046875, 0.0, 0.00030517578125, -3.0517578125e-05, 0.000457763671875, 0.000762939453125, 0.01739501953125, 0.055877685546875, 0.037841796875, -0.010406494140625, -0.015411376953125, -0.024078369140625, -0.02703857421875, 0.0531005859375, 0.128753662109375, 0.088714599609375, 0.048614501953125, 0.070770263671875, 0.06298828125, 0.019073486328125, -0.010467529296875, -0.030731201171875, -0.049468994140625, -0.0465087890625, -0.0306396484375, -0.032135009765625, -0.0343017578125, -0.0155029296875, 0.002685546875, 0.00457763671875, 0.003204345703125, 0.00604248046875, 0.0042724609375, -0.00555419921875, -0.006103515625, -0.0029296875, -0.008880615234375, -0.00634765625, 0.00360107421875, 0.000762939453125, -0.009368896484375, -0.0140380859375, -0.018463134765625, -0.02276611328125, -0.020263671875, -0.0145263671875, -0.01336669921875, -0.013153076171875, -0.007080078125, -0.0001220703125, 0.003143310546875, 0.00408935546875, 0.003143310546875, -0.000335693359375, -0.004425048828125, -0.00701904296875, -0.008941650390625, -0.01043701171875, -0.010986328125, -0.009735107421875, -0.010894775390625, -0.012237548828125, -0.009002685546875, -0.006378173828125, -0.00469970703125, -0.00457763671875, -0.004119873046875, -0.004119873046875, -0.0045166015625, -0.00347900390625, -0.003753662109375, -0.004913330078125, -0.004974365234375, -0.003814697265625, -0.004425048828125, -0.004852294921875, -0.003631591796875, -0.00299072265625, -0.003662109375, -0.00445556640625, -0.003997802734375, -0.004119873046875, -0.00341796875, -0.001617431640625, -0.001251220703125, -0.00177001953125, -0.002716064453125, -0.002960205078125, -0.002471923828125, -0.001983642578125, -0.00140380859375, -0.00128173828125, -0.00164794921875, -0.001556396484375, -0.0015869140625, -0.002105712890625, -0.00274658203125, -0.0032958984375, -0.00360107421875, -0.004058837890625, -0.004302978515625, -0.0035400390625, -0.002410888671875, -0.00201416015625, -0.002288818359375, -0.002685546875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, 6.103515625e-05, -6.103515625e-05, 0.0001220703125, -0.000152587890625, 6.103515625e-05, 0.00018310546875, 0.000274658203125, -0.000152587890625, 0.00042724609375, 0.000335693359375, 0.01593017578125, 0.058563232421875, 0.042327880859375, -0.013916015625, -0.019439697265625, -0.018798828125, -0.02447509765625, 0.048431396484375, 0.12945556640625, 0.091064453125, 0.040924072265625, 0.064239501953125, 0.0662841796875, 0.0167236328125, -0.011566162109375, -0.02960205078125, -0.061309814453125, -0.05523681640625, -0.029083251953125, -0.034942626953125, -0.035400390625, -0.007598876953125, 0.00439453125, 0.00408935546875, 0.02008056640625, 0.0255126953125, 0.00823974609375, 0.0010986328125, 0.006866455078125, -0.002685546875, -0.0147705078125, -0.01171875, -0.008453369140625, -0.01080322265625, -0.014862060546875, -0.01898193359375, -0.022552490234375, -0.02142333984375, -0.016845703125, -0.01312255859375, -0.0106201171875, -0.00921630859375, -0.0069580078125, -0.003265380859375, 0.002471923828125, 0.008148193359375, 0.007659912109375, 0.0023193359375, -0.002471923828125, -0.005523681640625, -0.00909423828125, -0.012054443359375, -0.01226806640625, -0.013031005859375, -0.016815185546875, -0.01580810546875, -0.01080322265625, -0.00689697265625, -0.0030517578125, -0.002716064453125, -0.003082275390625, -0.002532958984375, -0.002349853515625, -0.002899169921875, -0.004425048828125, -0.004150390625, -0.003021240234375, -0.003387451171875, -0.0045166015625, -0.005462646484375, -0.004791259765625, -0.00335693359375, -0.003936767578125, -0.0057373046875, -0.00616455078125, -0.005035400390625, -0.003570556640625, -0.00189208984375, -0.001129150390625, -0.001495361328125, -0.001922607421875, -0.002471923828125, -0.00213623046875, -0.001922607421875, -0.0013427734375, -0.0010986328125, -0.001617431640625, -0.00189208984375, -0.002288818359375, -0.00238037109375, -0.002716064453125, -0.003326416015625, -0.00396728515625, -0.004302978515625, -0.00390625, -0.0032958984375, -0.002655029296875, -0.002349853515625, -0.002410888671875, -0.00311279296875, -0.004547119140625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, -6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, 0.00042724609375, 0.0001220703125, 6.103515625e-05, 0.0003662109375, 0.01446533203125, 0.061065673828125, 0.0491943359375, -0.016571044921875, -0.025482177734375, -0.015960693359375, -0.020965576171875, 0.04705810546875, 0.131988525390625, 0.09423828125, 0.039459228515625, 0.063507080078125, 0.0638427734375, 0.008270263671875, -0.01580810546875, -0.0260009765625, -0.061920166015625, -0.064849853515625, -0.037200927734375, -0.03369140625, -0.03814697265625, -0.01654052734375, 0.007171630859375, 0.0123291015625, 0.01861572265625, 0.02703857421875, 0.0242919921875, 0.01531982421875, 0.0115966796875, 0.00836181640625, -0.00201416015625, -0.011962890625, -0.0120849609375, -0.01458740234375, -0.026336669921875, -0.03076171875, -0.028717041015625, -0.026519775390625, -0.0205078125, -0.012542724609375, -0.008636474609375, -0.0072021484375, -0.004302978515625, -0.001129150390625, 0.00146484375, 0.006500244140625, 0.00994873046875, 0.006561279296875, 0.00030517578125, -0.00286865234375, -0.0057373046875, -0.01055908203125, -0.01220703125, -0.01611328125, -0.02032470703125, -0.01849365234375, -0.014495849609375, -0.0086669921875, -0.00518798828125, -0.003173828125, -0.001800537109375, -0.00128173828125, -0.001129150390625, -0.002410888671875, -0.002655029296875, -0.002410888671875, -0.001434326171875, -0.00201416015625, -0.0037841796875, -0.005828857421875, -0.0054931640625, -0.0037841796875, -0.004669189453125, -0.006134033203125, -0.00726318359375, -0.006561279296875, -0.00445556640625, -0.00250244140625, -0.001373291015625, -0.00146484375, -0.00177001953125, -0.001617431640625, -0.001617431640625, -0.00146484375, -0.00103759765625, -0.0010986328125, -0.001373291015625, -0.001953125, -0.00238037109375, -0.00286865234375, -0.003387451171875, -0.00396728515625, -0.0040283203125, -0.003997802734375, -0.003936767578125, -0.00299072265625, -0.00225830078125, -0.002105712890625, -0.002593994140625, -0.003387451171875, -0.004730224609375, -0.005279541015625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, 0.0, -3.0517578125e-05, 0.0001220703125, -6.103515625e-05, 9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, 0.00018310546875, 0.000335693359375, 0.0001220703125, 0.000274658203125, 0.01312255859375, 0.06353759765625, 0.056549072265625, -0.017730712890625, -0.0316162109375, -0.01654052734375, -0.0194091796875, 0.048431396484375, 0.138275146484375, 0.09857177734375, 0.037353515625, 0.0635986328125, 0.065948486328125, 0.006195068359375, -0.025299072265625, -0.03302001953125, -0.06292724609375, -0.070556640625, -0.04254150390625, -0.033203125, -0.040252685546875, -0.021392822265625, 0.0050048828125, 0.0086669921875, 0.0185546875, 0.03363037109375, 0.02545166015625, 0.014068603515625, 0.020965576171875, 0.023681640625, 0.007354736328125, -0.003021240234375, -0.001556396484375, -0.011016845703125, -0.029296875, -0.03839111328125, -0.040069580078125, -0.03607177734375, -0.026947021484375, -0.016937255859375, -0.0113525390625, -0.00799560546875, -0.0032958984375, 0.001251220703125, 0.004974365234375, 0.00775146484375, 0.00946044921875, 0.00628662109375, 0.001678466796875, -0.0001220703125, -0.002593994140625, -0.006256103515625, -0.0107421875, -0.017547607421875, -0.020538330078125, -0.02001953125, -0.016204833984375, -0.0106201171875, -0.00836181640625, -0.00640869140625, -0.003204345703125, -0.001190185546875, -0.0020751953125, -0.002227783203125, 6.103515625e-05, 0.0015869140625, 0.00018310546875, -0.001068115234375, -0.003021240234375, -0.00555419921875, -0.004913330078125, -0.00445556640625, -0.00592041015625, -0.00726318359375, -0.00726318359375, -0.006805419921875, -0.0057373046875, -0.00347900390625, -0.0015869140625, -0.001739501953125, -0.00244140625, -0.001617431640625, -0.001220703125, -0.0013427734375, -0.000823974609375, -0.000152587890625, -0.000762939453125, -0.001861572265625, -0.002716064453125, -0.003387451171875, -0.0040283203125, -0.004058837890625, -0.00433349609375, -0.0048828125, -0.0040283203125, -0.002685546875, -0.00177001953125, -0.001495361328125, -0.002227783203125, -0.0037841796875, -0.005157470703125, -0.005157470703125, -0.003509521484375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, -6.103515625e-05, 0.0, 0.0, 6.103515625e-05, -3.0517578125e-05, 0.0001220703125, -6.103515625e-05, 0.0, -3.0517578125e-05, 0.0001220703125, 0.00030517578125, 0.00018310546875, 0.00042724609375, 0.01165771484375, 0.0662841796875, 0.064361572265625, -0.017852783203125, -0.038055419921875, -0.0174560546875, -0.0185546875, 0.047821044921875, 0.1458740234375, 0.1063232421875, 0.037078857421875, 0.0635986328125, 0.06842041015625, 0.003387451171875, -0.031829833984375, -0.033721923828125, -0.0675048828125, -0.08465576171875, -0.050628662109375, -0.03155517578125, -0.039276123046875, -0.022247314453125, 0.004791259765625, 0.0081787109375, 0.014801025390625, 0.029296875, 0.0291748046875, 0.017120361328125, 0.016326904296875, 0.022796630859375, 0.018524169921875, 0.011138916015625, 0.006500244140625, -0.000823974609375, -0.0184326171875, -0.036224365234375, -0.04541015625, -0.04425048828125, -0.03521728515625, -0.024444580078125, -0.0174560546875, -0.0126953125, -0.005889892578125, -0.000244140625, 0.00616455078125, 0.012542724609375, 0.013214111328125, 0.00628662109375, -0.0001220703125, -0.00079345703125, -0.00048828125, -0.002960205078125, -0.010833740234375, -0.015625, -0.017608642578125, -0.01898193359375, -0.015289306640625, -0.0125732421875, -0.01055908203125, -0.008270263671875, -0.005828857421875, -0.005279541015625, -0.005340576171875, -0.001800537109375, 0.00311279296875, 0.003814697265625, 0.00225830078125, 0.00152587890625, -0.002166748046875, -0.0050048828125, -0.00537109375, -0.004547119140625, -0.005615234375, -0.008331298828125, -0.00811767578125, -0.006866455078125, -0.006134033203125, -0.00408935546875, -0.001708984375, -0.001800537109375, -0.002532958984375, -0.002410888671875, -0.00238037109375, -0.00164794921875, -9.1552734375e-05, 0.000579833984375, -0.0003662109375, -0.00140380859375, -0.002349853515625, -0.00372314453125, -0.004486083984375, -0.004364013671875, -0.004608154296875, -0.005096435546875, -0.004852294921875, -0.003326416015625, -0.001617431640625, -0.00079345703125, -0.001495361328125, -0.003570556640625, -0.005126953125, -0.00506591796875, -0.003448486328125, -0.001708984375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, -9.1552734375e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -0.0001220703125, -9.1552734375e-05, -0.000152587890625, -3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, -0.0001220703125, -0.000152587890625, -6.103515625e-05, -0.00018310546875, 0.0003662109375, -3.0517578125e-05, 0.000640869140625, 0.01025390625, 0.068328857421875, 0.07379150390625, -0.017852783203125, -0.045440673828125, -0.01904296875, -0.01763916015625, 0.048309326171875, 0.15301513671875, 0.1138916015625, 0.0369873046875, 0.06646728515625, 0.072479248046875, 0.00048828125, -0.04034423828125, -0.038055419921875, -0.06585693359375, -0.09100341796875, -0.064422607421875, -0.041717529296875, -0.039031982421875, -0.020294189453125, 0.00537109375, 0.013885498046875, 0.015289306640625, 0.024658203125, 0.0283203125, 0.016510009765625, 0.01287841796875, 0.0203857421875, 0.01678466796875, 0.01214599609375, 0.015472412109375, 0.011016845703125, -0.0086669921875, -0.027618408203125, -0.03814697265625, -0.043182373046875, -0.0399169921875, -0.029998779296875, -0.023895263671875, -0.0208740234375, -0.0126953125, -0.00311279296875, 0.004608154296875, 0.011322021484375, 0.01519775390625, 0.011383056640625, 0.0018310546875, -0.002685546875, -0.001708984375, -0.005767822265625, -0.01068115234375, -0.012481689453125, -0.0159912109375, -0.015289306640625, -0.0128173828125, -0.01251220703125, -0.0108642578125, -0.008514404296875, -0.008056640625, -0.01019287109375, -0.009124755859375, -0.001708984375, 0.003753662109375, 0.00433349609375, 0.003570556640625, 0.00201416015625, 0.000213623046875, -0.00360107421875, -0.005859375, -0.005096435546875, -0.006378173828125, -0.00787353515625, -0.00811767578125, -0.007965087890625, -0.0068359375, -0.004119873046875, -0.00201416015625, -0.001800537109375, -0.00213623046875, -0.00311279296875, -0.0035400390625, -0.002960205078125, -0.000885009765625, 0.00103759765625, 0.000274658203125, -0.001617431640625, -0.002960205078125, -0.003570556640625, -0.0040283203125, -0.00421142578125, -0.004974365234375, -0.0057373046875, -0.005401611328125, -0.0040283203125, -0.00201416015625, -0.00091552734375, -0.001617431640625, -0.0032958984375, -0.004547119140625, -0.004425048828125, -0.003631591796875, -0.002288818359375, -0.001739501953125])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, -9.1552734375e-05, -6.103515625e-05, 0.0, 3.0517578125e-05, 0.0, 9.1552734375e-05, -3.0517578125e-05, -6.103515625e-05, 6.103515625e-05, -0.000213623046875, 0.000396728515625, -3.0517578125e-05, 0.00091552734375, 0.00921630859375, 0.071380615234375, 0.083099365234375, -0.017730712890625, -0.052764892578125, -0.020965576171875, -0.01727294921875, 0.0499267578125, 0.162750244140625, 0.12164306640625, 0.035186767578125, 0.06884765625, 0.0792236328125, -0.00140380859375, -0.048675537109375, -0.043701171875, -0.0675048828125, -0.09417724609375, -0.072113037109375, -0.048492431640625, -0.045501708984375, -0.0257568359375, 0.00738525390625, 0.0198974609375, 0.020599365234375, 0.026824951171875, 0.02728271484375, 0.0169677734375, 0.010528564453125, 0.01409912109375, 0.0128173828125, 0.010894775390625, 0.014617919921875, 0.012664794921875, -0.001190185546875, -0.01708984375, -0.029541015625, -0.0361328125, -0.032958984375, -0.027374267578125, -0.0260009765625, -0.026519775390625, -0.020782470703125, -0.008544921875, 0.0018310546875, 0.009368896484375, 0.01312255859375, 0.010650634765625, 0.005157470703125, 0.00201416015625, -0.003875732421875, -0.010589599609375, -0.0103759765625, -0.0115966796875, -0.013214111328125, -0.013397216796875, -0.011993408203125, -0.009368896484375, -0.008056640625, -0.0078125, -0.010589599609375, -0.011444091796875, -0.0074462890625, -0.002685546875, 0.001068115234375, 0.0040283203125, 0.00384521484375, 0.0023193359375, 0.000213623046875, -0.00286865234375, -0.003936767578125, -0.00445556640625, -0.00604248046875, -0.007537841796875, -0.008392333984375, -0.00830078125, -0.006805419921875, -0.00408935546875, -0.001373291015625, -0.000946044921875, -0.0025634765625, -0.00335693359375, -0.003509521484375, -0.002838134765625, -0.001190185546875, 0.00030517578125, 6.103515625e-05, -0.001678466796875, -0.0030517578125, -0.00390625, -0.003570556640625, -0.00341796875, -0.004241943359375, -0.00531005859375, -0.00531005859375, -0.00390625, -0.0020751953125, -0.000823974609375, -0.001922607421875, -0.00335693359375, -0.003692626953125, -0.003692626953125, -0.003387451171875, -0.00225830078125, -0.001068115234375, -0.001861572265625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, -6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, -9.1552734375e-05, -6.103515625e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, -0.0001220703125, 0.000152587890625, -0.000335693359375, 0.00048828125, -0.000274658203125, 0.001190185546875, 0.007965087890625, 0.0743408203125, 0.0941162109375, -0.018402099609375, -0.06158447265625, -0.02203369140625, -0.017120361328125, 0.05108642578125, 0.173614501953125, 0.130828857421875, 0.03265380859375, 0.070404052734375, 0.086639404296875, -0.0037841796875, -0.056427001953125, -0.049163818359375, -0.069854736328125, -0.097900390625, -0.078887939453125, -0.05523681640625, -0.049957275390625, -0.027923583984375, 0.0029296875, 0.019378662109375, 0.027374267578125, 0.03240966796875, 0.028167724609375, 0.01971435546875, 0.012298583984375, 0.009429931640625, 0.007354736328125, 0.00628662109375, 0.010772705078125, 0.01104736328125, -0.0025634765625, -0.016510009765625, -0.023193359375, -0.0272216796875, -0.0252685546875, -0.01995849609375, -0.0185546875, -0.024139404296875, -0.02471923828125, -0.01373291015625, -0.00250244140625, 0.0054931640625, 0.01031494140625, 0.00921630859375, 0.0040283203125, -0.001800537109375, -0.004913330078125, -0.005950927734375, -0.011077880859375, -0.01385498046875, -0.0120849609375, -0.012908935546875, -0.012481689453125, -0.00787353515625, -0.005126953125, -0.007904052734375, -0.010467529296875, -0.008056640625, -0.005462646484375, -0.003509521484375, 0.00128173828125, 0.0029296875, 0.001251220703125, 0.000732421875, -0.000885009765625, -0.00323486328125, -0.00421142578125, -0.003204345703125, -0.004150390625, -0.0068359375, -0.008544921875, -0.008453369140625, -0.00726318359375, -0.00433349609375, -0.000732421875, -0.000457763671875, -0.0023193359375, -0.0037841796875, -0.003753662109375, -0.002838134765625, -0.000762939453125, 0.00054931640625, -0.0008544921875, -0.002960205078125, -0.004180908203125, -0.004241943359375, -0.003662109375, -0.003082275390625, -0.00335693359375, -0.004791259765625, -0.00531005859375, -0.00372314453125, -0.001220703125, -0.000518798828125, -0.002166748046875, -0.003692626953125, -0.004058837890625, -0.003631591796875, -0.003021240234375, -0.00213623046875, -0.001251220703125, -0.001129150390625, -0.0020751953125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -9.1552734375e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, 9.1552734375e-05, -3.0517578125e-05, 3.0517578125e-05, -0.000213623046875, 0.000244140625, -0.0003662109375, 0.000518798828125, -0.00048828125, 0.00146484375, 0.00634765625, 0.076812744140625, 0.107025146484375, -0.017913818359375, -0.073028564453125, -0.023651123046875, -0.01593017578125, 0.051239013671875, 0.185455322265625, 0.14154052734375, 0.030242919921875, 0.071014404296875, 0.095733642578125, -0.00494384765625, -0.067413330078125, -0.054412841796875, -0.072418212890625, -0.10107421875, -0.083404541015625, -0.062347412109375, -0.05615234375, -0.02984619140625, 0.002960205078125, 0.01885986328125, 0.027435302734375, 0.036590576171875, 0.032623291015625, 0.02130126953125, 0.015594482421875, 0.011016845703125, 0.003814697265625, 0.001373291015625, 0.007415771484375, 0.0064697265625, -0.00787353515625, -0.020111083984375, -0.024017333984375, -0.025634765625, -0.020538330078125, -0.011444091796875, -0.010589599609375, -0.016448974609375, -0.01739501953125, -0.011749267578125, -0.005859375, 0.001129150390625, 0.00799560546875, 0.008148193359375, -0.001220703125, -0.0078125, -0.005889892578125, -0.007293701171875, -0.0087890625, -0.009552001953125, -0.01422119140625, -0.01690673828125, -0.011749267578125, -0.006195068359375, -0.006866455078125, -0.008331298828125, -0.0048828125, -0.0032958984375, -0.006134033203125, -0.002838134765625, 0.003143310546875, 0.003753662109375, 6.103515625e-05, -0.00244140625, -0.00311279296875, -0.0050048828125, -0.005279541015625, -0.00286865234375, -0.00347900390625, -0.0062255859375, -0.007110595703125, -0.008056640625, -0.00750732421875, -0.0040283203125, -0.000579833984375, -0.000457763671875, -0.002410888671875, -0.0035400390625, -0.003692626953125, -0.002716064453125, -0.000762939453125, 0.00048828125, -0.0009765625, -0.00335693359375, -0.005401611328125, -0.006011962890625, -0.004364013671875, -0.002593994140625, -0.00274658203125, -0.004486083984375, -0.005126953125, -0.003265380859375, -0.000732421875, 0.00030517578125, -0.001220703125, -0.003662109375, -0.00457763671875, -0.00390625, -0.002777099609375, -0.001739501953125, -0.0013427734375, -0.00146484375, -0.001739501953125, -0.001800537109375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, -0.0001220703125, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, -6.103515625e-05, 3.0517578125e-05, -0.000335693359375, 0.00030517578125, -0.00054931640625, 0.00067138671875, -0.00091552734375, 0.001739501953125, 0.00482177734375, 0.077972412109375, 0.121429443359375, -0.015350341796875, -0.086181640625, -0.02655029296875, -0.015045166015625, 0.050628662109375, 0.198638916015625, 0.154083251953125, 0.027374267578125, 0.07073974609375, 0.105010986328125, -0.00396728515625, -0.078521728515625, -0.062103271484375, -0.075836181640625, -0.10498046875, -0.08624267578125, -0.06634521484375, -0.064239501953125, -0.0340576171875, 0.003570556640625, 0.020172119140625, 0.027496337890625, 0.03936767578125, 0.037017822265625, 0.020843505859375, 0.018707275390625, 0.01434326171875, 0.00189208984375, -0.0003662109375, 0.006439208984375, 0.00274658203125, -0.013885498046875, -0.026702880859375, -0.0296630859375, -0.027130126953125, -0.020904541015625, -0.01116943359375, -0.00634765625, -0.00634765625, -0.007171630859375, -0.005645751953125, -0.001373291015625, 0.00372314453125, 0.0072021484375, 0.00140380859375, -0.00714111328125, -0.007415771484375, -0.007965087890625, -0.011871337890625, -0.01031494140625, -0.009124755859375, -0.01348876953125, -0.01654052734375, -0.014251708984375, -0.010498046875, -0.0074462890625, -0.002288818359375, -0.0010986328125, -0.004486083984375, -0.00433349609375, 0.000244140625, 0.004058837890625, 0.00311279296875, 3.0517578125e-05, -0.0020751953125, -0.004974365234375, -0.00823974609375, -0.006378173828125, -0.00347900390625, -0.004852294921875, -0.006378173828125, -0.006561279296875, -0.0068359375, -0.006500244140625, -0.00396728515625, -0.000732421875, -0.00030517578125, -0.00201416015625, -0.00360107421875, -0.00421142578125, -0.00299072265625, -0.0003662109375, 0.000518798828125, -0.00152587890625, -0.00390625, -0.00592041015625, -0.00714111328125, -0.00531005859375, -0.002532958984375, -0.00274658203125, -0.005096435546875, -0.00543212890625, -0.0028076171875, 6.103515625e-05, 0.001220703125, -0.0008544921875, -0.003753662109375, -0.004302978515625, -0.003143310546875, -0.002471923828125, -0.002227783203125, -0.00152587890625, -0.001708984375, -0.002197265625, -0.0018310546875, -0.0013427734375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 0.0, -3.0517578125e-05, 0.0, 3.0517578125e-05, -9.1552734375e-05, -0.0001220703125, 6.103515625e-05, 0.0, 0.0001220703125, -6.103515625e-05, 0.000152587890625, -0.000457763671875, 0.000457763671875, -0.000640869140625, 0.000823974609375, -0.001068115234375, 0.001861572265625, 0.003265380859375, 0.07733154296875, 0.137054443359375, -0.008514404296875, -0.10089111328125, -0.0311279296875, -0.013641357421875, 0.047149658203125, 0.21185302734375, 0.170501708984375, 0.024749755859375, 0.06890869140625, 0.1148681640625, -0.000640869140625, -0.089019775390625, -0.070465087890625, -0.079833984375, -0.11041259765625, -0.08966064453125, -0.067718505859375, -0.07012939453125, -0.040435791015625, 0.002105712890625, 0.02313232421875, 0.02935791015625, 0.03759765625, 0.0433349609375, 0.02532958984375, 0.0166015625, 0.017669677734375, 0.003021240234375, -0.0040283203125, 0.006317138671875, 0.00567626953125, -0.01800537109375, -0.03485107421875, -0.03485107421875, -0.0323486328125, -0.02557373046875, -0.0128173828125, -0.00640869140625, -0.00445556640625, 0.001068115234375, 0.00396728515625, 0.005279541015625, 0.01165771484375, 0.010040283203125, -0.001739501953125, -0.007232666015625, -0.00860595703125, -0.0107421875, -0.01361083984375, -0.012939453125, -0.01202392578125, -0.01544189453125, -0.017791748046875, -0.016693115234375, -0.012481689453125, -0.004180908203125, 0.0013427734375, -0.001617431640625, -0.00360107421875, -0.001800537109375, 0.001556396484375, 0.0045166015625, 0.00360107421875, 0.0006103515625, -0.0020751953125, -0.004669189453125, -0.00750732421875, -0.008819580078125, -0.006011962890625, -0.004669189453125, -0.006866455078125, -0.00726318359375, -0.0069580078125, -0.005950927734375, -0.002777099609375, 0.000518798828125, 0.000518798828125, -0.002349853515625, -0.003997802734375, -0.003692626953125, -0.0028076171875, -0.000885009765625, 0.000518798828125, -0.001495361328125, -0.00445556640625, -0.00628662109375, -0.006744384765625, -0.005340576171875, -0.003173828125, -0.00286865234375, -0.004791259765625, -0.005828857421875, -0.003753662109375, 6.103515625e-05, 0.0025634765625, 0.000946044921875, -0.002899169921875, -0.004425048828125, -0.003173828125, -0.001861572265625, -0.00128173828125, -0.00128173828125, -0.00238037109375, -0.00299072265625, -0.001953125, -0.000640869140625, -0.00152587890625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, -0.0001220703125, -9.1552734375e-05, 0.0, 0.0, 0.000152587890625, -9.1552734375e-05, 0.000213623046875, -0.00054931640625, 0.000396728515625, -0.000701904296875, 0.00091552734375, -0.001220703125, 0.001861572265625, 0.00201416015625, 0.0751953125, 0.1524658203125, 0.00250244140625, -0.116424560546875, -0.03863525390625, -0.011749267578125, 0.04150390625, 0.22430419921875, 0.190948486328125, 0.023223876953125, 0.065460205078125, 0.124481201171875, 0.0035400390625, -0.098480224609375, -0.07989501953125, -0.084716796875, -0.1158447265625, -0.09466552734375, -0.068939208984375, -0.074249267578125, -0.0465087890625, -0.000701904296875, 0.024200439453125, 0.0352783203125, 0.036895751953125, 0.041748046875, 0.0330810546875, 0.01953125, 0.0181884765625, 0.00439453125, -0.008087158203125, 0.004302978515625, 0.008392333984375, -0.01654052734375, -0.039459228515625, -0.043548583984375, -0.037567138671875, -0.029541015625, -0.0186767578125, -0.00848388671875, -0.00274658203125, 0.00201416015625, 0.00604248046875, 0.014068603515625, 0.01715087890625, 0.012054443359375, 0.00738525390625, -0.00152587890625, -0.010589599609375, -0.0123291015625, -0.0140380859375, -0.0162353515625, -0.014404296875, -0.017608642578125, -0.0238037109375, -0.02130126953125, -0.008209228515625, 0.00030517578125, -0.00140380859375, -0.00201416015625, -0.001068115234375, -0.00115966796875, 0.000640869140625, 0.00445556640625, 0.00518798828125, 0.001129150390625, -0.001861572265625, -0.003570556640625, -0.007537841796875, -0.009429931640625, -0.00640869140625, -0.005950927734375, -0.00811767578125, -0.0076904296875, -0.0074462890625, -0.006866455078125, -0.00299072265625, 0.00177001953125, 0.001800537109375, -0.0020751953125, -0.003997802734375, -0.004150390625, -0.003387451171875, -0.001007080078125, 0.000152587890625, -0.001617431640625, -0.00469970703125, -0.0064697265625, -0.006805419921875, -0.005126953125, -0.00299072265625, -0.003082275390625, -0.005096435546875, -0.0062255859375, -0.004119873046875, -0.0006103515625, 0.001800537109375, 0.001617431640625, -0.00091552734375, -0.003173828125, -0.00347900390625, -0.002349853515625, -0.00091552734375, -0.000457763671875, -0.002105712890625, -0.004180908203125, -0.003814697265625, -0.001556396484375, -0.000701904296875, -0.0020751953125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -0.000152587890625, 3.0517578125e-05, 0.0, 0.00018310546875, -0.000152587890625, 0.000213623046875, -0.00054931640625, 0.000457763671875, -0.000762939453125, 0.000885009765625, -0.00128173828125, 0.001861572265625, 0.0009765625, 0.072235107421875, 0.1656494140625, 0.01739501953125, -0.129547119140625, -0.048919677734375, -0.00958251953125, 0.034149169921875, 0.233795166015625, 0.213714599609375, 0.024383544921875, 0.060394287109375, 0.1337890625, 0.0089111328125, -0.108245849609375, -0.08758544921875, -0.09075927734375, -0.12249755859375, -0.09832763671875, -0.07025146484375, -0.077362060546875, -0.05181884765625, -0.0047607421875, 0.022552490234375, 0.0408935546875, 0.0426025390625, 0.03765869140625, 0.032989501953125, 0.027069091796875, 0.021026611328125, 0.006439208984375, -0.00958251953125, -0.001800537109375, 0.009796142578125, -0.012054443359375, -0.042144775390625, -0.049560546875, -0.044525146484375, -0.03533935546875, -0.020599365234375, -0.010955810546875, -0.00604248046875, 0.00189208984375, 0.00982666015625, 0.01104736328125, 0.015106201171875, 0.022216796875, 0.015960693359375, 0.00244140625, -0.004669189453125, -0.009185791015625, -0.015716552734375, -0.015960693359375, -0.01531982421875, -0.023468017578125, -0.0291748046875, -0.019195556640625, -0.006256103515625, -0.003936767578125, -0.001617431640625, 0.000518798828125, -0.00054931640625, -0.00274658203125, -0.001007080078125, 0.00482177734375, 0.005401611328125, 0.002288818359375, 0.000152587890625, -0.002960205078125, -0.0081787109375, -0.00933837890625, -0.005645751953125, -0.005218505859375, -0.008331298828125, -0.009796142578125, -0.00909423828125, -0.0069580078125, -0.00244140625, 0.002044677734375, 0.001251220703125, -0.002166748046875, -0.00341796875, -0.003631591796875, -0.00360107421875, -0.002197265625, -0.000732421875, -0.0015869140625, -0.00384521484375, -0.0062255859375, -0.00714111328125, -0.005645751953125, -0.00274658203125, -0.00225830078125, -0.00482177734375, -0.006439208984375, -0.004669189453125, -0.000732421875, 0.002197265625, 0.001708984375, -0.0013427734375, -0.003570556640625, -0.003082275390625, -0.001220703125, 3.0517578125e-05, -0.000244140625, -0.00225830078125, -0.0047607421875, -0.004974365234375, -0.0025634765625, -0.001068115234375, -0.001617431640625, -0.00372314453125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, -9.1552734375e-05, -0.000152587890625, 6.103515625e-05, -9.1552734375e-05, 0.00018310546875, -0.000213623046875, 0.000244140625, -0.0006103515625, 0.00042724609375, -0.00079345703125, 0.0008544921875, -0.001312255859375, 0.001678466796875, 0.000274658203125, 0.06817626953125, 0.1759033203125, 0.036712646484375, -0.13818359375, -0.06353759765625, -0.00787353515625, 0.024688720703125, 0.23883056640625, 0.23931884765625, 0.031036376953125, 0.055267333984375, 0.140167236328125, 0.017333984375, -0.1171875, -0.096649169921875, -0.0958251953125, -0.131378173828125, -0.103790283203125, -0.069976806640625, -0.079742431640625, -0.056060791015625, -0.008270263671875, 0.018218994140625, 0.043365478515625, 0.051483154296875, 0.042022705078125, 0.026519775390625, 0.028289794921875, 0.029998779296875, 0.008056640625, -0.009124755859375, -0.00506591796875, 0.006317138671875, -0.00897216796875, -0.0411376953125, -0.055511474609375, -0.05072021484375, -0.040771484375, -0.02490234375, -0.01202392578125, -0.005462646484375, 0.001678466796875, 0.004791259765625, 0.00885009765625, 0.019012451171875, 0.02398681640625, 0.018157958984375, 0.008209228515625, -0.000701904296875, -0.004913330078125, -0.008544921875, -0.013031005859375, -0.01904296875, -0.0269775390625, -0.02508544921875, -0.01739501953125, -0.01226806640625, -0.007843017578125, -0.002471923828125, 0.00164794921875, 3.0517578125e-05, -0.0042724609375, -0.002960205078125, 0.0035400390625, 0.006622314453125, 0.00396728515625, 0.000701904296875, -0.0028076171875, -0.006805419921875, -0.00830078125, -0.005615234375, -0.003814697265625, -0.0074462890625, -0.010406494140625, -0.010528564453125, -0.00811767578125, -0.00244140625, 0.001617431640625, 0.001495361328125, -0.002166748046875, -0.00433349609375, -0.0040283203125, -0.003814697265625, -0.00201416015625, -0.000457763671875, -0.001190185546875, -0.00384521484375, -0.00604248046875, -0.007171630859375, -0.006011962890625, -0.002716064453125, -0.00201416015625, -0.004119873046875, -0.006011962890625, -0.004058837890625, 0.000274658203125, 0.00274658203125, 0.001251220703125, -0.002197265625, -0.004150390625, -0.00347900390625, -0.001373291015625, 0.000732421875, 0.001007080078125, -0.001861572265625, -0.005035400390625, -0.005584716796875, -0.00335693359375, -0.00140380859375, -0.001312255859375, -0.003021240234375, -0.005706787109375])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([0.000152587890625, 0.000152587890625, -0.000213623046875, 0.000579833984375, -0.001190185546875, 0.001708984375, -0.002655029296875, 0.003875732421875, -0.004974365234375, 0.006317138671875, 0.0028076171875, 0.156402587890625, 0.173431396484375, -0.009918212890625, -0.108551025390625, -0.239044189453125, 0.050140380859375, 0.162567138671875, 0.1873779296875, 0.3736572265625, 0.163818359375, -0.07147216796875, 0.04705810546875, 0.056854248046875, -0.191986083984375, -0.239593505859375, -0.200286865234375, -0.145172119140625, -0.099639892578125, -0.074005126953125, -0.023895263671875, -0.0223388671875, 0.043243408203125, 0.08624267578125, 0.04840087890625, 0.063751220703125, 0.073272705078125, 0.047454833984375, 0.03277587890625, 0.0147705078125, -0.0184326171875, -0.00103759765625, -0.00946044921875, -0.0145263671875, -0.00836181640625, -0.030975341796875, -0.0482177734375, -0.051300048828125, -0.037933349609375, -0.0244140625, -0.0064697265625, -0.003143310546875, 0.000701904296875, 0.0208740234375, 0.0386962890625, 0.037628173828125, 0.032318115234375, 0.027679443359375, 0.001129150390625, -0.03350830078125, -0.049163818359375, -0.04766845703125, -0.036407470703125, -0.0382080078125, -0.044097900390625, -0.036773681640625, -0.017486572265625, 0.000946044921875, 0.005340576171875, 0.003662109375, 0.00341796875, 0.006011962890625, 0.003662109375, 0.005706787109375, 0.011138916015625, 0.01220703125, 0.005126953125, -0.004302978515625, -0.00970458984375, -0.01226806640625, -0.015228271484375, -0.014739990234375, -0.01043701171875, -0.0091552734375, -0.010498046875, -0.009490966796875, -0.004791259765625, 0.001434326171875, 0.0064697265625, 0.00537109375, -3.0517578125e-05, -0.0045166015625, -0.0042724609375, -0.00250244140625, 6.103515625e-05, 0.001800537109375, -0.000732421875, -0.007415771484375, -0.010406494140625, -0.007598876953125, -0.004608154296875, -0.00286865234375, -0.004241943359375, -0.0072021484375, -0.007843017578125, -0.00421142578125, 0.000885009765625, 0.00445556640625, 0.003448486328125, -0.0013427734375, -0.0050048828125, -0.005279541015625, -0.00372314453125, -0.00201416015625, -0.001953125, -0.00421142578125, -0.006195068359375, -0.005523681640625, -0.003021240234375, 0.0006103515625, 0.002777099609375, 0.00140380859375, -0.00152587890625, -0.003082275390625, -0.001861572265625, 9.1552734375e-05, 0.001007080078125, -0.000274658203125])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 0.000457763671875, -0.00018310546875, 0.00048828125, -0.000213623046875, 0.0001220703125, 0.000213623046875, -0.000457763671875, 0.00152587890625, -0.00177001953125, 0.002838134765625, 0.023681640625, 0.172149658203125, 0.1087646484375, -0.02215576171875, -0.136077880859375, -0.16717529296875, 0.093841552734375, 0.1171875, 0.236907958984375, 0.3165283203125, 0.081298828125, -0.03125, 0.0758056640625, 0.00091552734375, -0.1802978515625, -0.209136962890625, -0.19354248046875, -0.112457275390625, -0.0865478515625, -0.073394775390625, -0.02679443359375, -0.005828857421875, 0.049652099609375, 0.06317138671875, 0.052886962890625, 0.0645751953125, 0.0596923828125, 0.044586181640625, 0.03009033203125, -0.0035400390625, -0.010009765625, 0.0098876953125, -0.011199951171875, -0.006256103515625, -0.009857177734375, -0.034210205078125, -0.049285888671875, -0.047271728515625, -0.0328369140625, -0.015655517578125, -0.003814697265625, -0.002593994140625, 0.01611328125, 0.0343017578125, 0.02447509765625, 0.02105712890625, 0.026947021484375, 0.01214599609375, -0.013671875, -0.035247802734375, -0.041900634765625, -0.035919189453125, -0.0286865234375, -0.03253173828125, -0.034942626953125, -0.03106689453125, -0.014373779296875, 6.103515625e-05, -0.00152587890625, -0.00152587890625, 0.002899169921875, 0.00469970703125, 0.0013427734375, 0.004119873046875, 0.00970458984375, 0.010498046875, 0.003662109375, -0.0045166015625, -0.010467529296875, -0.01336669921875, -0.0133056640625, -0.01129150390625, -0.008514404296875, -0.007293701171875, -0.0074462890625, -0.00506591796875, -0.0018310546875, 0.002166748046875, 0.00469970703125, 0.002349853515625, -0.002105712890625, -0.0045166015625, -0.00311279296875, -0.001861572265625, -0.00030517578125, 0.001007080078125, -0.001251220703125, -0.006256103515625, -0.00811767578125, -0.006988525390625, -0.004119873046875, -0.002349853515625, -0.003814697265625, -0.00665283203125, -0.00640869140625, -0.0030517578125, 0.00091552734375, 0.00384521484375, 0.00225830078125, -0.0013427734375, -0.0040283203125, -0.004364013671875, -0.002838134765625, -0.00146484375, -0.002227783203125, -0.004913330078125, -0.006439208984375, -0.00543212890625, -0.001983642578125, 0.001922607421875, 0.002685546875, 0.0006103515625, -0.001617431640625, -0.002105712890625, -0.001068115234375, 0.000732421875, 0.00146484375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -0.0001220703125, 0.00042724609375, -0.00018310546875, 0.000457763671875, -0.0003662109375, 0.000152587890625, -0.0001220703125, -9.1552734375e-05, 0.0006103515625, -0.000732421875, 0.001190185546875, 0.025238037109375, 0.149658203125, 0.0958251953125, -0.015899658203125, -0.118377685546875, -0.136962890625, 0.0626220703125, 0.111297607421875, 0.222747802734375, 0.270751953125, 0.089630126953125, -0.0079345703125, 0.06744384765625, 0.00537109375, -0.149932861328125, -0.200531005859375, -0.17523193359375, -0.09674072265625, -0.0906982421875, -0.074951171875, -0.02301025390625, -0.006195068359375, 0.03594970703125, 0.058929443359375, 0.050933837890625, 0.055145263671875, 0.055938720703125, 0.0457763671875, 0.022796630859375, -0.006134033203125, 0.00323486328125, 0.01226806640625, -0.01202392578125, -0.00653076171875, -0.009796142578125, -0.032257080078125, -0.045745849609375, -0.041778564453125, -0.026824951171875, -0.007720947265625, -0.0048828125, -0.008026123046875, 0.0166015625, 0.033935546875, 0.015899658203125, 0.0054931640625, 0.0162353515625, 0.0093994140625, -0.0167236328125, -0.032501220703125, -0.0328369140625, -0.029937744140625, -0.02587890625, -0.024322509765625, -0.023895263671875, -0.02777099609375, -0.019927978515625, -0.00604248046875, -0.002532958984375, -0.00469970703125, -0.001678466796875, 0.001495361328125, -0.00115966796875, 0.001495361328125, 0.00634765625, 0.007537841796875, 0.001922607421875, -0.00439453125, -0.009368896484375, -0.01226806640625, -0.012054443359375, -0.008819580078125, -0.005462646484375, -0.005035400390625, -0.005157470703125, -0.003173828125, -0.001708984375, 0.00042724609375, 0.002716064453125, 0.000823974609375, -0.003326416015625, -0.00518798828125, -0.00439453125, -0.00311279296875, -0.001007080078125, 0.00018310546875, -0.00146484375, -0.005340576171875, -0.00732421875, -0.007110595703125, -0.00506591796875, -0.00274658203125, -0.003082275390625, -0.00531005859375, -0.0059814453125, -0.003509521484375, 0.00079345703125, 0.003173828125, 0.001434326171875, -0.001922607421875, -0.004486083984375, -0.005035400390625, -0.003448486328125, -0.00164794921875, -0.00250244140625, -0.0050048828125, -0.00604248046875, -0.004730224609375, -0.0023193359375, 0.00054931640625, 0.001617431640625, -0.000152587890625, -0.00225830078125, -0.002593994140625, -0.001007080078125, 0.00091552734375])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, 0.0, -0.0001220703125, 0.00030517578125, -0.0001220703125, 0.00030517578125, -0.00030517578125, 9.1552734375e-05, -9.1552734375e-05, -0.00018310546875, 0.000518798828125, -0.000457763671875, 0.00048828125, 0.022613525390625, 0.12713623046875, 0.089874267578125, -0.006622314453125, -0.099151611328125, -0.126068115234375, 0.044158935546875, 0.10662841796875, 0.194183349609375, 0.242706298828125, 0.09698486328125, 0.005340576171875, 0.066009521484375, 0.014801025390625, -0.13079833984375, -0.1793212890625, -0.150299072265625, -0.095306396484375, -0.091949462890625, -0.0693359375, -0.02423095703125, -0.013092041015625, 0.02734375, 0.05194091796875, 0.04443359375, 0.04974365234375, 0.05389404296875, 0.045257568359375, 0.019989013671875, 0.000762939453125, 0.009124755859375, 0.006439208984375, -0.01092529296875, -0.0015869140625, -0.0089111328125, -0.02850341796875, -0.0347900390625, -0.0321044921875, -0.021759033203125, -0.01165771484375, -0.014892578125, -0.009979248046875, 0.01568603515625, 0.020660400390625, 0.00457763671875, 0.00360107421875, 0.01104736328125, 0.006622314453125, -0.013214111328125, -0.0283203125, -0.02685546875, -0.0223388671875, -0.019378662109375, -0.02032470703125, -0.019378662109375, -0.022857666015625, -0.02117919921875, -0.012176513671875, -0.0057373046875, -0.004852294921875, -0.005706787109375, -0.0050048828125, -0.00347900390625, 0.00054931640625, 0.001739501953125, 0.00244140625, 0.0020751953125, -0.0020751953125, -0.007232666015625, -0.008697509765625, -0.0086669921875, -0.006378173828125, -0.00244140625, -0.001800537109375, -0.003814697265625, -0.003936767578125, -0.002593994140625, -0.00042724609375, 0.000823974609375, -0.000457763671875, -0.00341796875, -0.00592041015625, -0.006195068359375, -0.00396728515625, -0.000885009765625, 0.0, -0.00238037109375, -0.00543212890625, -0.006805419921875, -0.006256103515625, -0.004058837890625, -0.002288818359375, -0.0028076171875, -0.00439453125, -0.004241943359375, -0.002716064453125, 0.0001220703125, 0.0020751953125, 0.000579833984375, -0.00299072265625, -0.00537109375, -0.004913330078125, -0.003509521484375, -0.002197265625, -0.001983642578125, -0.003265380859375, -0.004669189453125, -0.004730224609375, -0.003387451171875, -0.0010986328125, 0.000152587890625, -0.000640869140625, -0.002044677734375, -0.00213623046875, -0.000640869140625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -0.0001220703125, -6.103515625e-05, -6.103515625e-05, 0.000244140625, -9.1552734375e-05, 0.000213623046875, -0.00018310546875, 0.0, 6.103515625e-05, -0.000244140625, 0.000732421875, -0.000701904296875, 0.0006103515625, 0.017486572265625, 0.106048583984375, 0.0872802734375, 0.00555419921875, -0.086029052734375, -0.119415283203125, 0.0347900390625, 0.0924072265625, 0.168792724609375, 0.22320556640625, 0.09918212890625, 0.0177001953125, 0.067779541015625, 0.020111083984375, -0.111114501953125, -0.1484375, -0.13336181640625, -0.09857177734375, -0.08612060546875, -0.063873291015625, -0.03045654296875, -0.019317626953125, 0.020416259765625, 0.04302978515625, 0.039886474609375, 0.046722412109375, 0.0538330078125, 0.04693603515625, 0.016204833984375, 0.0015869140625, 0.0103759765625, 0.006683349609375, -0.00531005859375, 0.000946044921875, -0.003143310546875, -0.0167236328125, -0.026580810546875, -0.032562255859375, -0.026702880859375, -0.01776123046875, -0.021392822265625, -0.013641357421875, 0.00799560546875, 0.008453369140625, 0.00115966796875, 0.006561279296875, 0.00860595703125, 0.005462646484375, -0.007171630859375, -0.023284912109375, -0.02203369140625, -0.01611328125, -0.01605224609375, -0.018310546875, -0.017913818359375, -0.0196533203125, -0.019439697265625, -0.015716552734375, -0.009918212890625, -0.0067138671875, -0.008209228515625, -0.010223388671875, -0.007659912109375, -0.001861572265625, -0.00067138671875, 0.0009765625, 0.002410888671875, 0.000274658203125, -0.00341796875, -0.004791259765625, -0.005340576171875, -0.00384521484375, -0.001251220703125, -0.00146484375, -0.0030517578125, -0.004486083984375, -0.004608154296875, -0.002044677734375, 0.0, -0.00103759765625, -0.004058837890625, -0.006622314453125, -0.0067138671875, -0.004150390625, -0.0018310546875, -0.00146484375, -0.0025634765625, -0.004913330078125, -0.005950927734375, -0.004791259765625, -0.00244140625, -0.001678466796875, -0.00250244140625, -0.00347900390625, -0.00372314453125, -0.00274658203125, -0.000885009765625, 0.000213623046875, -0.000701904296875, -0.0029296875, -0.00457763671875, -0.00482177734375, -0.003936767578125, -0.002166748046875, -0.001434326171875, -0.002716064453125, -0.004302978515625, -0.0047607421875, -0.00384521484375, -0.00201416015625, -0.000732421875, -0.00079345703125, -0.001495361328125, -0.001922607421875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 0.000152587890625, -6.103515625e-05, 9.1552734375e-05, -0.0001220703125, -6.103515625e-05, 0.0001220703125, -0.000457763671875, 0.000885009765625, -0.000946044921875, 0.000762939453125, 0.011566162109375, 0.0863037109375, 0.086273193359375, 0.01690673828125, -0.074493408203125, -0.1116943359375, 0.0230712890625, 0.07666015625, 0.147979736328125, 0.2037353515625, 0.101776123046875, 0.0299072265625, 0.066253662109375, 0.025146484375, -0.086334228515625, -0.11993408203125, -0.122100830078125, -0.098541259765625, -0.0784912109375, -0.06146240234375, -0.03759765625, -0.02294921875, 0.012481689453125, 0.035888671875, 0.0391845703125, 0.04534912109375, 0.05230712890625, 0.03851318359375, 0.012054443359375, 0.010406494140625, 0.012176513671875, 0.007781982421875, 0.004302978515625, 0.008880615234375, 0.0006103515625, -0.015625, -0.028167724609375, -0.036163330078125, -0.02978515625, -0.026458740234375, -0.03045654296875, -0.01531982421875, 0.005767822265625, 0.002471923828125, -0.001617431640625, 0.008087158203125, 0.01220703125, 0.007781982421875, -0.0054931640625, -0.018524169921875, -0.01776123046875, -0.013214111328125, -0.01446533203125, -0.01806640625, -0.0174560546875, -0.01690673828125, -0.01776123046875, -0.01751708984375, -0.014373779296875, -0.010986328125, -0.010711669921875, -0.011962890625, -0.009368896484375, -0.004180908203125, -0.0003662109375, 0.0020751953125, 0.003021240234375, 0.002410888671875, -0.00042724609375, -0.0029296875, -0.003265380859375, -0.00164794921875, -0.001190185546875, -0.002410888671875, -0.003692626953125, -0.0047607421875, -0.0054931640625, -0.00384521484375, -0.00164794921875, -0.0023193359375, -0.00384521484375, -0.005889892578125, -0.006744384765625, -0.005706787109375, -0.0032958984375, -0.00128173828125, -0.00177001953125, -0.003631591796875, -0.004852294921875, -0.00347900390625, -0.00189208984375, -0.001190185546875, -0.002044677734375, -0.003936767578125, -0.004669189453125, -0.003631591796875, -0.0013427734375, -0.000244140625, -0.0009765625, -0.002471923828125, -0.003997802734375, -0.00469970703125, -0.004302978515625, -0.002532958984375, -0.001708984375, -0.00262451171875, -0.003692626953125, -0.004119873046875, -0.0035400390625, -0.002288818359375, -0.00115966796875, -0.001312255859375, -0.001861572265625])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 0.0, 0.0, -9.1552734375e-05, -3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, 6.103515625e-05, -9.1552734375e-05, 0.00018310546875, -0.000457763671875, 0.000946044921875, -0.001068115234375, 0.000885009765625, 0.0067138671875, 0.068267822265625, 0.083740234375, 0.02716064453125, -0.061309814453125, -0.104827880859375, 0.01025390625, 0.0631103515625, 0.12786865234375, 0.185455322265625, 0.106048583984375, 0.038299560546875, 0.06231689453125, 0.034576416015625, -0.061981201171875, -0.09619140625, -0.1102294921875, -0.096160888671875, -0.0728759765625, -0.060272216796875, -0.041259765625, -0.026458740234375, 0.008331298828125, 0.033843994140625, 0.032135009765625, 0.03704833984375, 0.04876708984375, 0.036468505859375, 0.015594482421875, 0.016357421875, 0.0184326171875, 0.017913818359375, 0.00738525390625, 0.003631591796875, -0.002105712890625, -0.017730712890625, -0.03106689453125, -0.039031982421875, -0.0360107421875, -0.0345458984375, -0.0308837890625, -0.01025390625, 0.00323486328125, -0.00311279296875, 0.00054931640625, 0.011016845703125, 0.01495361328125, 0.008392333984375, -0.006011962890625, -0.014434814453125, -0.0146484375, -0.0126953125, -0.01434326171875, -0.017303466796875, -0.016082763671875, -0.015838623046875, -0.019134521484375, -0.01983642578125, -0.0169677734375, -0.013671875, -0.01080322265625, -0.0101318359375, -0.008331298828125, -0.004150390625, -0.000885009765625, 0.003204345703125, 0.003662109375, 0.0018310546875, 0.00140380859375, -0.00140380859375, -0.0029296875, -0.00115966796875, -0.000579833984375, -0.00286865234375, -0.0054931640625, -0.0054931640625, -0.00555419921875, -0.005340576171875, -0.003662109375, -0.002655029296875, -0.003143310546875, -0.005828857421875, -0.006805419921875, -0.005706787109375, -0.002960205078125, -0.000457763671875, -0.000457763671875, -0.00213623046875, -0.0042724609375, -0.003570556640625, -0.00201416015625, -0.0018310546875, -0.0025634765625, -0.00390625, -0.004608154296875, -0.003814697265625, -0.0020751953125, -0.000244140625, -0.0008544921875, -0.002777099609375, -0.00396728515625, -0.004547119140625, -0.004119873046875, -0.002685546875, -0.0015869140625, -0.002197265625, -0.003204345703125, -0.003570556640625, -0.003173828125, -0.002166748046875, -0.00189208984375, -0.001983642578125])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -9.1552734375e-05, 0.0, -3.0517578125e-05, -9.1552734375e-05, 0.0, -3.0517578125e-05, 0.0, -3.0517578125e-05, 6.103515625e-05, 0.000152587890625, -0.000244140625, 0.000244140625, -0.00054931640625, 0.0009765625, -0.001129150390625, 0.001068115234375, 0.003204345703125, 0.051239013671875, 0.079742431640625, 0.03607177734375, -0.046051025390625, -0.097442626953125, -0.005035400390625, 0.0509033203125, 0.10906982421875, 0.1697998046875, 0.109344482421875, 0.04376220703125, 0.0599365234375, 0.044097900390625, -0.039337158203125, -0.07574462890625, -0.0977783203125, -0.093292236328125, -0.068359375, -0.056060791015625, -0.041351318359375, -0.0242919921875, 0.00042724609375, 0.017578125, 0.02618408203125, 0.041534423828125, 0.047271728515625, 0.031982421875, 0.025726318359375, 0.03021240234375, 0.01861572265625, 0.0103759765625, 0.003204345703125, -0.001983642578125, -0.00811767578125, -0.02069091796875, -0.033905029296875, -0.04083251953125, -0.03704833984375, -0.03497314453125, -0.02587890625, -0.007476806640625, 0.000457763671875, -0.001953125, 0.002349853515625, 0.01055908203125, 0.014739990234375, 0.007598876953125, -0.00665283203125, -0.013214111328125, -0.011871337890625, -0.0125732421875, -0.01409912109375, -0.016571044921875, -0.017791748046875, -0.01812744140625, -0.0203857421875, -0.01934814453125, -0.016265869140625, -0.01141357421875, -0.009002685546875, -0.00848388671875, -0.00634765625, -0.0035400390625, -0.0018310546875, 0.00103759765625, 0.00341796875, 0.00225830078125, 0.00115966796875, -0.000946044921875, -0.002960205078125, -0.00189208984375, -0.00146484375, -0.00299072265625, -0.005401611328125, -0.0069580078125, -0.00677490234375, -0.005828857421875, -0.00439453125, -0.00323486328125, -0.00341796875, -0.004669189453125, -0.0052490234375, -0.004150390625, -0.00189208984375, -0.0003662109375, -0.000457763671875, -0.002471923828125, -0.00396728515625, -0.0037841796875, -0.00299072265625, -0.00225830078125, -0.00244140625, -0.00335693359375, -0.0045166015625, -0.004364013671875, -0.0029296875, -0.00103759765625, -0.000762939453125, -0.00238037109375, -0.003509521484375, -0.00421142578125, -0.003753662109375, -0.00244140625, -0.0015869140625, -0.002044677734375, -0.003082275390625, -0.00335693359375, -0.003173828125, -0.002532958984375, -0.002044677734375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -6.103515625e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, 9.1552734375e-05, 0.000244140625, -0.000244140625, 0.000335693359375, -0.000518798828125, 0.000885009765625, -0.000946044921875, 0.001129150390625, 0.0008544921875, 0.036865234375, 0.07318115234375, 0.04327392578125, -0.028778076171875, -0.090728759765625, -0.02166748046875, 0.040863037109375, 0.093902587890625, 0.15484619140625, 0.11090087890625, 0.049346923828125, 0.056915283203125, 0.05279541015625, -0.01898193359375, -0.058502197265625, -0.0848388671875, -0.088134765625, -0.059295654296875, -0.0467529296875, -0.044891357421875, -0.037322998046875, -0.00897216796875, 0.01800537109375, 0.0286865234375, 0.041412353515625, 0.04730224609375, 0.04010009765625, 0.029541015625, 0.021728515625, 0.011505126953125, 0.003631591796875, -0.00494384765625, -0.0101318359375, -0.01202392578125, -0.020751953125, -0.0311279296875, -0.035491943359375, -0.03515625, -0.033721923828125, -0.018463134765625, -0.00286865234375, -0.00225830078125, -0.003265380859375, 0.0029296875, 0.009246826171875, 0.011566162109375, 0.004364013671875, -0.00689697265625, -0.01092529296875, -0.010833740234375, -0.012176513671875, -0.01611328125, -0.01934814453125, -0.018646240234375, -0.018035888671875, -0.0179443359375, -0.01544189453125, -0.011962890625, -0.009490966796875, -0.007965087890625, -0.005584716796875, -0.005462646484375, -0.005096435546875, -0.003814697265625, 0.0001220703125, 0.00274658203125, 0.001953125, -6.103515625e-05, -0.002593994140625, -0.00299072265625, -0.0025634765625, -0.001434326171875, -0.0029296875, -0.006317138671875, -0.0079345703125, -0.007415771484375, -0.005615234375, -0.004608154296875, -0.00323486328125, -0.00238037109375, -0.002532958984375, -0.002777099609375, -0.00335693359375, -0.002166748046875, -0.001251220703125, -0.001190185546875, -0.00225830078125, -0.00390625, -0.00408935546875, -0.003692626953125, -0.00262451171875, -0.002471923828125, -0.003631591796875, -0.00457763671875, -0.00445556640625, -0.00341796875, -0.0013427734375, -0.00048828125, -0.001708984375, -0.003326416015625, -0.00390625, -0.0030517578125, -0.002105712890625, -0.001739501953125, -0.002532958984375, -0.0029296875, -0.003204345703125, -0.003173828125, -0.002166748046875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, 0.0, -6.103515625e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, -9.1552734375e-05, 0.0, 9.1552734375e-05, 0.000244140625, -0.000244140625, 0.00030517578125, -0.000396728515625, 0.00054931640625, -0.00054931640625, 0.00067138671875, 0.0, 0.02520751953125, 0.06427001953125, 0.049285888671875, -0.01263427734375, -0.083099365234375, -0.037750244140625, 0.03167724609375, 0.08197021484375, 0.141357421875, 0.11077880859375, 0.053680419921875, 0.055450439453125, 0.058807373046875, -0.00128173828125, -0.04296875, -0.06732177734375, -0.0743408203125, -0.05767822265625, -0.056427001953125, -0.049285888671875, -0.030487060546875, -0.00848388671875, 0.015167236328125, 0.035919189453125, 0.047943115234375, 0.03875732421875, 0.0279541015625, 0.023895263671875, 0.0135498046875, 0.00048828125, -0.005584716796875, -0.0118408203125, -0.01275634765625, -0.007781982421875, -0.015228271484375, -0.024383544921875, -0.03118896484375, -0.032806396484375, -0.02545166015625, -0.011199951171875, -0.0052490234375, -0.00738525390625, -0.003875732421875, 0.00225830078125, 0.005859375, 0.006561279296875, 0.001495361328125, -0.00634765625, -0.009918212890625, -0.0115966796875, -0.01531982421875, -0.017974853515625, -0.018890380859375, -0.01641845703125, -0.013153076171875, -0.01324462890625, -0.01171875, -0.009979248046875, -0.0078125, -0.0057373046875, -0.005584716796875, -0.007080078125, -0.006622314453125, -0.003448486328125, -0.001251220703125, 0.0, 3.0517578125e-05, -0.001800537109375, -0.002716064453125, -0.002593994140625, -0.002532958984375, -0.0029296875, -0.004241943359375, -0.00604248046875, -0.007537841796875, -0.007049560546875, -0.005706787109375, -0.003692626953125, -0.001953125, -0.000946044921875, -0.000946044921875, -0.0023193359375, -0.003448486328125, -0.0030517578125, -0.001953125, -0.00152587890625, -0.002471923828125, -0.003814697265625, -0.0047607421875, -0.00408935546875, -0.002960205078125, -0.0030517578125, -0.003662109375, -0.00433349609375, -0.00372314453125, -0.00335693359375, -0.002044677734375, -0.001007080078125, -0.001434326171875, -0.002410888671875, -0.00323486328125, -0.00286865234375, -0.00244140625, -0.00213623046875, -0.00244140625, -0.00262451171875, -0.002685546875, -0.00274658203125])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, 0.0001220703125, 0.00018310546875, 0.000213623046875, -0.000152587890625, 0.00030517578125, -0.00030517578125, 0.0003662109375, -0.00018310546875, 0.000274658203125, 6.103515625e-05, 0.016754150390625, 0.0546875, 0.0528564453125, 0.001739501953125, -0.0751953125, -0.05194091796875, 0.023162841796875, 0.0750732421875, 0.13031005859375, 0.107391357421875, 0.057342529296875, 0.055816650390625, 0.063201904296875, 0.017486572265625, -0.020721435546875, -0.057098388671875, -0.0843505859375, -0.056915283203125, -0.0413818359375, -0.043548583984375, -0.028533935546875, -0.00079345703125, 0.0224609375, 0.029815673828125, 0.029205322265625, 0.024078369140625, 0.019500732421875, 0.01025390625, 0.00091552734375, -0.004547119140625, -0.009033203125, -0.0098876953125, -0.0067138671875, -0.00128173828125, -0.008880615234375, -0.01837158203125, -0.024810791015625, -0.02734375, -0.019287109375, -0.010467529296875, -0.01220703125, -0.0107421875, -0.003326416015625, -0.00042724609375, 0.00140380859375, 0.002044677734375, -0.00164794921875, -0.007110595703125, -0.01068115234375, -0.014068603515625, -0.01611328125, -0.01544189453125, -0.013671875, -0.01055908203125, -0.0089111328125, -0.010528564453125, -0.00994873046875, -0.00750732421875, -0.006195068359375, -0.006805419921875, -0.00714111328125, -0.007537841796875, -0.006805419921875, -0.005035400390625, -0.0040283203125, -0.002288818359375, -0.00128173828125, -0.001953125, -0.002716064453125, -0.002838134765625, -0.003936767578125, -0.00408935546875, -0.003936767578125, -0.004974365234375, -0.006195068359375, -0.00634765625, -0.0048828125, -0.002227783203125, -0.00054931640625, -0.00048828125, -0.001220703125, -0.00250244140625, -0.003692626953125, -0.00360107421875, -0.002288818359375, -0.002166748046875, -0.00311279296875, -0.003875732421875, -0.004425048828125, -0.004302978515625, -0.00341796875, -0.002716064453125, -0.00311279296875, -0.003753662109375, -0.00390625, -0.003662109375, -0.002105712890625, -0.0008544921875, -0.00103759765625, -0.002044677734375, -0.0025634765625, -0.002838134765625, -0.00286865234375, -0.002105712890625, -0.00189208984375, -0.001922607421875, -0.002227783203125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, -9.1552734375e-05, -9.1552734375e-05, 0.0, 9.1552734375e-05, 3.0517578125e-05, 6.103515625e-05, -0.0001220703125, 0.00018310546875, -0.000335693359375, 0.00018310546875, 0.0, 0.0, 0.000274658203125, 0.0113525390625, 0.04547119140625, 0.05401611328125, 0.013519287109375, -0.0687255859375, -0.0631103515625, 0.016357421875, 0.072174072265625, 0.121612548828125, 0.10211181640625, 0.0609130859375, 0.0635986328125, 0.07574462890625, 0.02288818359375, -0.0301513671875, -0.04791259765625, -0.06207275390625, -0.046661376953125, -0.03546142578125, -0.029815673828125, -0.01763916015625, -0.007476806640625, 0.004852294921875, 0.013702392578125, 0.013031005859375, 0.00750732421875, 0.0032958984375, -0.00189208984375, 0.00238037109375, 0.002410888671875, -0.008209228515625, -0.005615234375, 0.003936767578125, 0.00555419921875, -0.00408935546875, -0.0115966796875, -0.0213623046875, -0.025360107421875, -0.018585205078125, -0.015380859375, -0.015625, -0.011077880859375, -0.005706787109375, -0.005218505859375, -0.003143310546875, -0.002166748046875, -0.0050048828125, -0.00897216796875, -0.01202392578125, -0.011871337890625, -0.0106201171875, -0.0103759765625, -0.008331298828125, -0.00628662109375, -0.00738525390625, -0.009246826171875, -0.00714111328125, -0.00714111328125, -0.008758544921875, -0.00762939453125, -0.007598876953125, -0.009033203125, -0.00872802734375, -0.006256103515625, -0.005279541015625, -0.00408935546875, -0.002197265625, -0.00225830078125, -0.00335693359375, -0.004058837890625, -0.0040283203125, -0.0035400390625, -0.003509521484375, -0.0037841796875, -0.004608154296875, -0.004730224609375, -0.0035400390625, -0.001708984375, -0.000946044921875, -0.00146484375, -0.001922607421875, -0.00286865234375, -0.003814697265625, -0.004119873046875, -0.0032958984375, -0.00286865234375, -0.002838134765625, -0.00360107421875, -0.004302978515625, -0.0037841796875, -0.00323486328125, -0.003021240234375, -0.003631591796875, -0.0040283203125, -0.003570556640625, -0.003143310546875, -0.00213623046875, -0.001312255859375, -0.001068115234375, -0.00140380859375, -0.00250244140625, -0.003082275390625, -0.002532958984375, -0.00164794921875, -0.001861572265625, -0.001983642578125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 6.103515625e-05, 0.0, 3.0517578125e-05, 0.0, -6.103515625e-05, 0.0, 3.0517578125e-05, 0.0, 9.1552734375e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 0.0001220703125, 3.0517578125e-05, 0.000152587890625, 3.0517578125e-05, 0.00018310546875, -0.000335693359375, 0.00030517578125, 0.00030517578125, -9.1552734375e-05, 0.00048828125, 0.009185791015625, 0.038360595703125, 0.0538330078125, 0.0223388671875, -0.067352294921875, -0.071868896484375, 0.014373779296875, 0.076141357421875, 0.118133544921875, 0.100555419921875, 0.07427978515625, 0.061309814453125, 0.05157470703125, 0.0264892578125, -0.0037841796875, -0.029937744140625, -0.049835205078125, -0.030670166015625, -0.022979736328125, -0.0341796875, -0.031463623046875, -0.02081298828125, -0.01300048828125, -0.004669189453125, -0.00616455078125, -0.0101318359375, 0.000823974609375, 0.00860595703125, 0.00982666015625, 0.00299072265625, -0.00067138671875, 0.00531005859375, 0.0098876953125, 0.0113525390625, 0.00018310546875, -0.013519287109375, -0.02374267578125, -0.0244140625, -0.019256591796875, -0.017486572265625, -0.016510009765625, -0.01409912109375, -0.01171875, -0.008819580078125, -0.00494384765625, -0.006805419921875, -0.00860595703125, -0.0078125, -0.00604248046875, -0.0057373046875, -0.00677490234375, -0.0054931640625, -0.004241943359375, -0.0052490234375, -0.00634765625, -0.00738525390625, -0.00848388671875, -0.0091552734375, -0.00909423828125, -0.008544921875, -0.00958251953125, -0.010040283203125, -0.008392333984375, -0.0074462890625, -0.00653076171875, -0.00421142578125, -0.002838134765625, -0.003326416015625, -0.003662109375, -0.00323486328125, -0.0032958984375, -0.002777099609375, -0.002349853515625, -0.00201416015625, -0.00244140625, -0.003509521484375, -0.003753662109375, -0.0028076171875, -0.001861572265625, -0.001983642578125, -0.002288818359375, -0.0030517578125, -0.004150390625, -0.00421142578125, -0.00347900390625, -0.002777099609375, -0.0023193359375, -0.0025634765625, -0.003570556640625, -0.004180908203125, -0.0037841796875, -0.00341796875, -0.003173828125, -0.003143310546875, -0.003021240234375, -0.0029296875, -0.002227783203125, -0.001190185546875, -0.001068115234375, -0.001190185546875, -0.00177001953125, -0.002288818359375, -0.00250244140625, -0.00213623046875, -0.001556396484375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 6.103515625e-05, 0.0, 9.1552734375e-05, 3.0517578125e-05, -6.103515625e-05, 0.0, 0.0, -3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 0.0, 0.000152587890625, -3.0517578125e-05, 0.0001220703125, -0.000457763671875, 0.00054931640625, 9.1552734375e-05, 0.00018310546875, 0.0, 0.009490966796875, 0.03521728515625, 0.05401611328125, 0.024658203125, -0.076171875, -0.0751953125, 0.025115966796875, 0.095458984375, 0.12701416015625, 0.079498291015625, 0.044891357421875, 0.06689453125, 0.07537841796875, 0.0355224609375, 0.0054931640625, -0.00860595703125, -0.035186767578125, -0.03851318359375, -0.03619384765625, -0.043548583984375, -0.04876708984375, -0.037322998046875, -0.028167724609375, -0.028076171875, -0.0123291015625, 0.004730224609375, 0.007568359375, 0.01123046875, 0.01995849609375, 0.012451171875, 0.001922607421875, 0.01153564453125, 0.019561767578125, 0.00726318359375, -0.008392333984375, -0.01580810546875, -0.02435302734375, -0.024169921875, -0.0181884765625, -0.019866943359375, -0.02215576171875, -0.019012451171875, -0.013336181640625, -0.009979248046875, -0.008697509765625, -0.00787353515625, -0.0048828125, -0.002197265625, -0.00140380859375, -0.00164794921875, -0.003021240234375, -0.0025634765625, -0.00323486328125, -0.00518798828125, -0.007568359375, -0.009490966796875, -0.00909423828125, -0.010467529296875, -0.0106201171875, -0.0098876953125, -0.009918212890625, -0.0101318359375, -0.009521484375, -0.00738525390625, -0.005950927734375, -0.005035400390625, -0.0045166015625, -0.0030517578125, -0.002288818359375, -0.002471923828125, -0.002105712890625, -0.002105712890625, -0.00091552734375, -0.000701904296875, -0.002410888671875, -0.004791259765625, -0.0050048828125, -0.0030517578125, -0.002471923828125, -0.002471923828125, -0.003082275390625, -0.003631591796875, -0.003936767578125, -0.004119873046875, -0.003082275390625, -0.002105712890625, -0.001922607421875, -0.002899169921875, -0.004180908203125, -0.0045166015625, -0.0040283203125, -0.002655029296875, -0.00250244140625, -0.003173828125, -0.003204345703125, -0.0029296875, -0.002105712890625, -0.00115966796875, -0.000579833984375, -0.000946044921875, -0.0018310546875, -0.002410888671875, -0.002593994140625, -0.001861572265625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 9.1552734375e-05, 0.0, 0.0, -9.1552734375e-05, 6.103515625e-05, 0.0001220703125, 3.0517578125e-05, 0.00018310546875, 0.0001220703125, 0.0, -0.000274658203125, 0.0009765625, -3.0517578125e-05, -0.00018310546875, -0.000335693359375, 0.015167236328125, 0.036468505859375, 0.054443359375, 0.01092529296875, -0.09405517578125, -0.05072021484375, 0.06842041015625, 0.095855712890625, 0.07684326171875, 0.07135009765625, 0.078887939453125, 0.079376220703125, 0.08013916015625, 0.048980712890625, 0.007080078125, -0.0228271484375, -0.0399169921875, -0.04925537109375, -0.05975341796875, -0.0557861328125, -0.056854248046875, -0.05926513671875, -0.03790283203125, -0.00823974609375, 0.00030517578125, 0.00347900390625, 0.01922607421875, 0.029388427734375, 0.019134521484375, 0.010498046875, 0.01397705078125, 0.01171875, 0.008392333984375, 0.0018310546875, -0.0098876953125, -0.021484375, -0.02386474609375, -0.020751953125, -0.02301025390625, -0.02630615234375, -0.023529052734375, -0.018829345703125, -0.015106201171875, -0.009002685546875, -0.00537109375, -0.0037841796875, -0.001373291015625, 0.001800537109375, 0.00323486328125, 0.0008544921875, -0.001434326171875, -0.002410888671875, -0.00518798828125, -0.0078125, -0.009246826171875, -0.009796142578125, -0.010833740234375, -0.011474609375, -0.01068115234375, -0.0101318359375, -0.01031494140625, -0.00982666015625, -0.0078125, -0.007354736328125, -0.00738525390625, -0.00555419921875, -0.0030517578125, -0.001434326171875, -0.00115966796875, -0.001373291015625, -0.001739501953125, -0.000946044921875, -0.00018310546875, -0.00213623046875, -0.0042724609375, -0.004669189453125, -0.0037841796875, -0.00360107421875, -0.003265380859375, -0.002960205078125, -0.003204345703125, -0.003265380859375, -0.003265380859375, -0.003082275390625, -0.003143310546875, -0.002349853515625, -0.002197265625, -0.0030517578125, -0.004150390625, -0.003936767578125, -0.0028076171875, -0.002410888671875, -0.002777099609375, -0.00311279296875, -0.002716064453125, -0.002288818359375, -0.001434326171875, -0.000762939453125, -0.00103759765625, -0.001129150390625, -0.001495361328125, -0.002227783203125, -0.00250244140625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, -6.103515625e-05, 0.0, 0.0, 3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, 0.0001220703125, 3.0517578125e-05, 9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, -0.0001220703125, 0.000701904296875, 0.000396728515625, -0.000518798828125, -0.00103759765625, 0.004364013671875, 0.025482177734375, 0.04345703125, 0.048919677734375, -0.026214599609375, -0.08453369140625, -0.016387939453125, 0.062744140625, 0.10552978515625, 0.09234619140625, 0.074249267578125, 0.090545654296875, 0.101715087890625, 0.07098388671875, 0.01708984375, -0.0150146484375, -0.038970947265625, -0.056396484375, -0.0655517578125, -0.06927490234375, -0.072540283203125, -0.06396484375, -0.03778076171875, -0.016448974609375, -0.002685546875, 0.01019287109375, 0.02386474609375, 0.026885986328125, 0.0257568359375, 0.022064208984375, 0.009765625, 0.00152587890625, 0.00628662109375, 0.008087158203125, -0.00439453125, -0.016693115234375, -0.02362060546875, -0.024932861328125, -0.0250244140625, -0.025482177734375, -0.026123046875, -0.02374267578125, -0.016357421875, -0.008697509765625, -0.00433349609375, -0.0023193359375, -0.000244140625, 0.00274658203125, 0.005523681640625, 0.004425048828125, -0.000244140625, -0.00408935546875, -0.0054931640625, -0.007476806640625, -0.009918212890625, -0.010528564453125, -0.01068115234375, -0.011871337890625, -0.011749267578125, -0.010162353515625, -0.009307861328125, -0.00897216796875, -0.008758544921875, -0.009124755859375, -0.008148193359375, -0.005859375, -0.003021240234375, -0.001129150390625, -0.00067138671875, -0.00128173828125, -0.001495361328125, -0.001373291015625, -0.001953125, -0.00238037109375, -0.00262451171875, -0.003204345703125, -0.00439453125, -0.004486083984375, -0.003936767578125, -0.00323486328125, -0.002655029296875, -0.002899169921875, -0.0029296875, -0.00323486328125, -0.003814697265625, -0.003173828125, -0.002227783203125, -0.002197265625, -0.002899169921875, -0.003662109375, -0.003631591796875, -0.002777099609375, -0.002044677734375, -0.0023193359375, -0.002593994140625, -0.002288818359375, -0.002044677734375, -0.001434326171875, -0.000823974609375, -0.00091552734375, -0.0013427734375, -0.001953125, -0.002227783203125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 0.0, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, -9.1552734375e-05, -3.0517578125e-05, 6.103515625e-05, 0.00018310546875, -3.0517578125e-05, 3.0517578125e-05, 0.000274658203125, 0.000457763671875, 0.000457763671875, -0.000823974609375, 9.1552734375e-05, 0.0003662109375, 0.020111083984375, 0.043060302734375, 0.06561279296875, 0.005767822265625, -0.116973876953125, -0.0606689453125, 0.082794189453125, 0.11700439453125, 0.087615966796875, 0.087738037109375, 0.094940185546875, 0.089385986328125, 0.0770263671875, 0.02886962890625, -0.023468017578125, -0.04864501953125, -0.04931640625, -0.063934326171875, -0.084808349609375, -0.076416015625, -0.049713134765625, -0.034881591796875, -0.024322509765625, 0.00238037109375, 0.01898193359375, 0.02056884765625, 0.024993896484375, 0.0328369140625, 0.02044677734375, 0.000518798828125, -0.001495361328125, 0.004241943359375, 0.00701904296875, -0.00091552734375, -0.012908935546875, -0.024017333984375, -0.028564453125, -0.024871826171875, -0.023681640625, -0.025787353515625, -0.02313232421875, -0.0157470703125, -0.00885009765625, -0.00408935546875, -0.00048828125, 0.00152587890625, 0.003692626953125, 0.005767822265625, 0.003936767578125, -0.000885009765625, -0.004974365234375, -0.00579833984375, -0.0079345703125, -0.01092529296875, -0.01092529296875, -0.01123046875, -0.011749267578125, -0.01123046875, -0.009063720703125, -0.00738525390625, -0.009124755859375, -0.009857177734375, -0.00897216796875, -0.007965087890625, -0.00567626953125, -0.002288818359375, -0.000885009765625, -0.001983642578125, -0.001800537109375, -0.0020751953125, -0.003204345703125, -0.003143310546875, -0.00115966796875, -0.000762939453125, -0.00341796875, -0.004486083984375, -0.003997802734375, -0.00335693359375, -0.003173828125, -0.0029296875, -0.00274658203125, -0.0035400390625, -0.00372314453125, -0.003753662109375, -0.00323486328125, -0.002166748046875, -0.001800537109375, -0.00262451171875, -0.003631591796875, -0.003509521484375, -0.002227783203125, -0.00140380859375, -0.001953125, -0.00274658203125, -0.0025634765625, -0.002197265625, -0.00152587890625, -0.000823974609375, -0.00103759765625, -0.001312255859375, -0.00177001953125, -0.002227783203125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 0.0, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, -9.1552734375e-05, 0.0001220703125, -6.103515625e-05, 0.000152587890625, -3.0517578125e-05, -6.103515625e-05, 0.00030517578125, 0.000457763671875, 0.000244140625, -0.00042724609375, -0.000244140625, 0.00177001953125, 0.02362060546875, 0.064910888671875, 0.073211669921875, -0.05755615234375, -0.141082763671875, 0.003631591796875, 0.114349365234375, 0.100341796875, 0.090423583984375, 0.093414306640625, 0.078521728515625, 0.078155517578125, 0.07122802734375, 0.00689697265625, -0.03778076171875, -0.0394287109375, -0.050262451171875, -0.07696533203125, -0.07720947265625, -0.054443359375, -0.046844482421875, -0.03314208984375, -0.007293701171875, 0.012054443359375, 0.013427734375, 0.0205078125, 0.03277587890625, 0.0260009765625, 0.007171630859375, -0.003204345703125, -0.00250244140625, 0.000274658203125, 0.00494384765625, -0.002471923828125, -0.016998291015625, -0.023468017578125, -0.024871826171875, -0.02545166015625, -0.0244140625, -0.02056884765625, -0.016876220703125, -0.014556884765625, -0.00970458984375, -0.0030517578125, 0.00201416015625, 0.004180908203125, 0.00506591796875, 0.003753662109375, -0.000274658203125, -0.003204345703125, -0.00457763671875, -0.006683349609375, -0.00970458984375, -0.011383056640625, -0.012298583984375, -0.012298583984375, -0.01031494140625, -0.0087890625, -0.007354736328125, -0.0076904296875, -0.009429931640625, -0.0086669921875, -0.007720947265625, -0.0069580078125, -0.004730224609375, -0.001678466796875, -0.0018310546875, -0.003509521484375, -0.00372314453125, -0.00482177734375, -0.004486083984375, -0.0010986328125, 0.00054931640625, -0.001953125, -0.004119873046875, -0.003570556640625, -0.00286865234375, -0.00244140625, -0.00250244140625, -0.003204345703125, -0.00396728515625, -0.00408935546875, -0.003875732421875, -0.0037841796875, -0.00250244140625, -0.0018310546875, -0.0025634765625, -0.003448486328125, -0.00347900390625, -0.001922607421875, -0.001129150390625, -0.00152587890625, -0.002410888671875, -0.002838134765625, -0.002349853515625, -0.00189208984375, -0.001312255859375, -0.00103759765625, -0.000885009765625, -0.00128173828125, -0.002655029296875, -0.00372314453125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.000152587890625, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 0.000244140625, 0.000152587890625, 0.000335693359375, 6.103515625e-05, 6.103515625e-05, -0.000457763671875, 0.010009765625, 0.056793212890625, 0.080902099609375, -0.009765625, -0.119354248046875, -0.06146240234375, 0.0693359375, 0.11260986328125, 0.109588623046875, 0.087066650390625, 0.0654296875, 0.077178955078125, 0.0762939453125, 0.018646240234375, -0.027923583984375, -0.029510498046875, -0.03973388671875, -0.064361572265625, -0.07196044921875, -0.056365966796875, -0.04510498046875, -0.032623291015625, -0.013092041015625, 0.004638671875, 0.015625, 0.018524169921875, 0.0242919921875, 0.027801513671875, 0.014251708984375, -0.002349853515625, -0.006744384765625, -0.004669189453125, -9.1552734375e-05, -0.003082275390625, -0.012664794921875, -0.0205078125, -0.021575927734375, -0.02093505859375, -0.023529052734375, -0.022613525390625, -0.01507568359375, -0.010406494140625, -0.011138916015625, -0.0086669921875, -0.00225830078125, 0.004913330078125, 0.0076904296875, 0.004058837890625, -0.00091552734375, -0.003997802734375, -0.00506591796875, -0.005706787109375, -0.008758544921875, -0.01190185546875, -0.013031005859375, -0.013336181640625, -0.011688232421875, -0.007781982421875, -0.006134033203125, -0.007568359375, -0.008880615234375, -0.0072021484375, -0.006317138671875, -0.00628662109375, -0.004608154296875, -0.003448486328125, -0.003021240234375, -0.003509521484375, -0.0054931640625, -0.00799560546875, -0.00628662109375, -0.001739501953125, 0.000396728515625, -0.00091552734375, -0.0032958984375, -0.0035400390625, -0.00238037109375, -0.00201416015625, -0.00177001953125, -0.00225830078125, -0.003387451171875, -0.004852294921875, -0.004913330078125, -0.003692626953125, -0.0029296875, -0.002227783203125, -0.00244140625, -0.00384521484375, -0.003814697265625, -0.002197265625, -0.0008544921875, -0.000885009765625, -0.001983642578125, -0.002716064453125, -0.00274658203125, -0.001953125, -0.001434326171875, -0.00091552734375, -0.000701904296875, -0.0010986328125, -0.002685546875, -0.00439453125, -0.004180908203125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, -6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 9.1552734375e-05, 9.1552734375e-05, 9.1552734375e-05, 0.0, 3.0517578125e-05, 0.000274658203125, 0.000244140625, 0.00030517578125, -0.00018310546875, 0.000518798828125, 0.005950927734375, 0.052001953125, 0.08038330078125, -9.1552734375e-05, -0.092864990234375, -0.067901611328125, 0.03472900390625, 0.100006103515625, 0.115447998046875, 0.092071533203125, 0.065032958984375, 0.075592041015625, 0.07305908203125, 0.020050048828125, -0.026580810546875, -0.03240966796875, -0.041473388671875, -0.05517578125, -0.05908203125, -0.054931640625, -0.045989990234375, -0.032867431640625, -0.008514404296875, 0.010009765625, 0.0142822265625, 0.017333984375, 0.02667236328125, 0.029815673828125, 0.01483154296875, -0.000701904296875, -0.0047607421875, -0.005615234375, -0.00604248046875, -0.00738525390625, -0.016143798828125, -0.02398681640625, -0.022125244140625, -0.019317626953125, -0.019073486328125, -0.019073486328125, -0.015625, -0.0103759765625, -0.007293701171875, -0.00592041015625, -0.00408935546875, 0.000732421875, 0.00750732421875, 0.007080078125, 0.000823974609375, -0.003570556640625, -0.00628662109375, -0.00701904296875, -0.008392333984375, -0.011474609375, -0.01513671875, -0.015167236328125, -0.0118408203125, -0.008636474609375, -0.007293701171875, -0.00653076171875, -0.00616455078125, -0.006683349609375, -0.005096435546875, -0.003631591796875, -0.00286865234375, -0.002655029296875, -0.00341796875, -0.0048828125, -0.007293701171875, -0.009124755859375, -0.007720947265625, -0.003326416015625, -0.000640869140625, -0.001251220703125, -0.002960205078125, -0.003021240234375, -0.001953125, -0.0015869140625, -0.00140380859375, -0.001800537109375, -0.002288818359375, -0.003265380859375, -0.004608154296875, -0.00469970703125, -0.00335693359375, -0.001922607421875, -0.002349853515625, -0.0037841796875, -0.004119873046875, -0.0029296875, -0.001190185546875, -0.00079345703125, -0.00140380859375, -0.002105712890625, -0.00262451171875, -0.002197265625, -0.0013427734375, -0.000396728515625, -0.000274658203125, -0.001312255859375, -0.00311279296875, -0.00421142578125, -0.003753662109375, -0.002655029296875])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, 0.0, 6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0001220703125, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 0.000213623046875, 0.0, 0.0003662109375, 0.0, 0.00048828125, 0.006072998046875, 0.053131103515625, 0.07830810546875, -0.002777099609375, -0.080596923828125, -0.0599365234375, 0.02008056640625, 0.0931396484375, 0.1220703125, 0.08868408203125, 0.055419921875, 0.077392578125, 0.0804443359375, 0.01837158203125, -0.031951904296875, -0.0361328125, -0.045318603515625, -0.060577392578125, -0.059051513671875, -0.049652099609375, -0.0433349609375, -0.03192138671875, -0.00726318359375, 0.012603759765625, 0.0186767578125, 0.025543212890625, 0.028778076171875, 0.02691650390625, 0.022491455078125, 0.007080078125, -0.007476806640625, -0.0076904296875, -0.001678466796875, -0.007354736328125, -0.023712158203125, -0.030853271484375, -0.027587890625, -0.0244140625, -0.020294189453125, -0.016510009765625, -0.011871337890625, -0.0084228515625, -0.007049560546875, -0.004150390625, -0.001068115234375, 0.002838134765625, 0.00604248046875, 0.005645751953125, 0.001983642578125, -0.001220703125, -0.004425048828125, -0.00830078125, -0.010040283203125, -0.012054443359375, -0.015594482421875, -0.017578125, -0.0142822265625, -0.00970458984375, -0.009246826171875, -0.00762939453125, -0.00531005859375, -0.003875732421875, -0.003509521484375, -0.0029296875, -0.000518798828125, -0.000335693359375, -0.002288818359375, -0.005523681640625, -0.009033203125, -0.010467529296875, -0.00787353515625, -0.003997802734375, -0.00262451171875, -0.0029296875, -0.00341796875, -0.00341796875, -0.00299072265625, -0.001373291015625, -0.00042724609375, -0.0015869140625, -0.00250244140625, -0.002532958984375, -0.003204345703125, -0.00390625, -0.00347900390625, -0.002716064453125, -0.002471923828125, -0.003204345703125, -0.004058837890625, -0.00372314453125, -0.00225830078125, -0.001373291015625, -0.0015869140625, -0.0023193359375, -0.0025634765625, -0.002166748046875, -0.001129150390625, -9.1552734375e-05, -0.0001220703125, -0.00164794921875, -0.003753662109375, -0.004241943359375, -0.003173828125, -0.00201416015625, -0.0020751953125])
        IR_LEFT[len(IR_LEFT)-1].append([6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, -9.1552734375e-05, 0.0, -3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, -0.0001220703125, -0.0001220703125, 0.000213623046875, 0.0, 0.000244140625, -0.000335693359375, 0.00048828125, 0.007720947265625, 0.05792236328125, 0.076873779296875, -0.010467529296875, -0.077056884765625, -0.05181884765625, 0.01861572265625, 0.0928955078125, 0.1263427734375, 0.086517333984375, 0.05242919921875, 0.07720947265625, 0.0748291015625, 0.01263427734375, -0.030548095703125, -0.035003662109375, -0.053375244140625, -0.067230224609375, -0.05548095703125, -0.05535888671875, -0.053314208984375, -0.027099609375, -0.0015869140625, 0.01239013671875, 0.0208740234375, 0.03021240234375, 0.032745361328125, 0.031005859375, 0.02667236328125, 0.01141357421875, -0.00311279296875, -0.0040283203125, -0.001251220703125, -0.00689697265625, -0.019500732421875, -0.0328369140625, -0.036376953125, -0.033111572265625, -0.02618408203125, -0.019287109375, -0.01416015625, -0.00677490234375, -0.002471923828125, -0.003326416015625, -0.001129150390625, 0.005767822265625, 0.009307861328125, 0.006591796875, 0.00152587890625, -0.00152587890625, -0.00335693359375, -0.006072998046875, -0.00994873046875, -0.01397705078125, -0.01715087890625, -0.0177001953125, -0.01556396484375, -0.014190673828125, -0.011444091796875, -0.008209228515625, -0.005859375, -0.003509521484375, -0.0029296875, -0.000274658203125, 0.001312255859375, 0.001129150390625, -0.001190185546875, -0.005462646484375, -0.00848388671875, -0.0096435546875, -0.00830078125, -0.00531005859375, -0.003875732421875, -0.004669189453125, -0.004364013671875, -0.004638671875, -0.004302978515625, -0.002349853515625, -0.000823974609375, -0.000946044921875, -0.001953125, -0.002685546875, -0.003082275390625, -0.00299072265625, -0.00274658203125, -0.002166748046875, -0.00274658203125, -0.003570556640625, -0.0040283203125, -0.003814697265625, -0.002838134765625, -0.002166748046875, -0.002197265625, -0.00323486328125, -0.00335693359375, -0.002288818359375, -0.000640869140625, 0.000213623046875, -0.000640869140625, -0.002655029296875, -0.004150390625, -0.003814697265625, -0.00286865234375, -0.002166748046875, -0.00201416015625, -0.00299072265625])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, 6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 0.000244140625, 0.000335693359375, -0.00018310546875, 0.0003662109375, 0.010162353515625, 0.065673828125, 0.0758056640625, -0.020538330078125, -0.077117919921875, -0.04534912109375, 0.021453857421875, 0.10052490234375, 0.1326904296875, 0.08197021484375, 0.04998779296875, 0.08074951171875, 0.073333740234375, 0.0032958984375, -0.039764404296875, -0.039703369140625, -0.0543212890625, -0.06793212890625, -0.054718017578125, -0.05633544921875, -0.06005859375, -0.033172607421875, -0.004791259765625, 0.017181396484375, 0.025482177734375, 0.0299072265625, 0.036407470703125, 0.03350830078125, 0.0284423828125, 0.0166015625, 0.0028076171875, -0.00146484375, 0.001800537109375, -0.00189208984375, -0.01702880859375, -0.030975341796875, -0.0338134765625, -0.035125732421875, -0.03558349609375, -0.02740478515625, -0.0172119140625, -0.0106201171875, -0.005462646484375, -0.000396728515625, 0.003082275390625, 0.006195068359375, 0.01007080078125, 0.010101318359375, 0.005035400390625, -3.0517578125e-05, -0.004119873046875, -0.007110595703125, -0.007781982421875, -0.011962890625, -0.018951416015625, -0.019317626953125, -0.016998291015625, -0.014801025390625, -0.012451171875, -0.010345458984375, -0.005828857421875, -0.004425048828125, -0.003326416015625, 0.000152587890625, 0.003204345703125, 0.002838134765625, -0.001129150390625, -0.004180908203125, -0.00579833984375, -0.007049560546875, -0.0074462890625, -0.0059814453125, -0.005523681640625, -0.005340576171875, -0.005615234375, -0.006500244140625, -0.005096435546875, -0.002777099609375, -0.000701904296875, -0.001068115234375, -0.002532958984375, -0.00262451171875, -0.002288818359375, -0.00244140625, -0.001953125, -0.00128173828125, -0.001983642578125, -0.003265380859375, -0.003997802734375, -0.003662109375, -0.003204345703125, -0.002227783203125, -0.00225830078125, -0.003662109375, -0.004180908203125, -0.0025634765625, -0.00030517578125, 0.000457763671875, -0.0008544921875, -0.00347900390625, -0.004364013671875, -0.003326416015625, -0.001983642578125, -0.0013427734375, -0.00213623046875, -0.0030517578125, -0.00341796875])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, -9.1552734375e-05, -6.103515625e-05, -6.103515625e-05, 6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, -0.0001220703125, -9.1552734375e-05, -3.0517578125e-05, 6.103515625e-05, 0.000244140625, 0.0, 0.00018310546875, 0.013824462890625, 0.075225830078125, 0.073516845703125, -0.033172607421875, -0.078582763671875, -0.039276123046875, 0.02642822265625, 0.11187744140625, 0.14044189453125, 0.0760498046875, 0.049102783203125, 0.0863037109375, 0.068878173828125, -0.00665283203125, -0.045745849609375, -0.046600341796875, -0.06427001953125, -0.0738525390625, -0.050994873046875, -0.049285888671875, -0.06329345703125, -0.039459228515625, -0.00567626953125, 0.014312744140625, 0.024444580078125, 0.0330810546875, 0.03924560546875, 0.032806396484375, 0.028564453125, 0.021209716796875, 0.003082275390625, -0.001251220703125, 0.0078125, 0.001739501953125, -0.01641845703125, -0.02685546875, -0.02862548828125, -0.032135009765625, -0.03497314453125, -0.029998779296875, -0.02374267578125, -0.017730712890625, -0.0098876953125, -0.00445556640625, 0.00103759765625, 0.00933837890625, 0.013336181640625, 0.009918212890625, 0.006134033203125, 0.003662109375, -0.001220703125, -0.007598876953125, -0.0103759765625, -0.0118408203125, -0.015869140625, -0.022003173828125, -0.02142333984375, -0.01318359375, -0.010650634765625, -0.0098876953125, -0.008544921875, -0.006134033203125, -0.003143310546875, -0.000213623046875, 0.0020751953125, 0.00048828125, -0.000701904296875, -0.000701904296875, -0.00238037109375, -0.0054931640625, -0.0057373046875, -0.005767822265625, -0.00616455078125, -0.006683349609375, -0.0078125, -0.007781982421875, -0.00677490234375, -0.00323486328125, -0.000640869140625, -0.001007080078125, -0.00250244140625, -0.00341796875, -0.003326416015625, -0.00244140625, -0.000732421875, -0.000701904296875, -0.001953125, -0.003173828125, -0.00360107421875, -0.003662109375, -0.003204345703125, -0.002593994140625, -0.00347900390625, -0.004241943359375, -0.00396728515625, -0.002685546875, -0.00067138671875, 6.103515625e-05, -0.0020751953125, -0.004241943359375, -0.004150390625, -0.003143310546875, -0.00213623046875, -0.00146484375, -0.001678466796875, -0.002655029296875, -0.00341796875, -0.00341796875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, -9.1552734375e-05, -3.0517578125e-05, 0.0, 0.0001220703125, -3.0517578125e-05, 0.000152587890625, -0.000152587890625, 6.103515625e-05, -0.0001220703125, 0.000152587890625, 0.000152587890625, 0.000274658203125, 0.000274658203125, 0.01861572265625, 0.0870361328125, 0.0704345703125, -0.0482177734375, -0.08038330078125, -0.032501220703125, 0.033416748046875, 0.12567138671875, 0.1484375, 0.070281982421875, 0.049224853515625, 0.09356689453125, 0.064056396484375, -0.01898193359375, -0.05133056640625, -0.053466796875, -0.073211669921875, -0.07916259765625, -0.054656982421875, -0.047149658203125, -0.060028076171875, -0.038055419921875, -0.00482177734375, 0.011810302734375, 0.0242919921875, 0.033111572265625, 0.037750244140625, 0.03411865234375, 0.028717041015625, 0.02032470703125, 0.00579833984375, -0.000518798828125, 0.00439453125, 0.002838134765625, -0.012298583984375, -0.024566650390625, -0.02667236328125, -0.02587890625, -0.02838134765625, -0.0277099609375, -0.021392822265625, -0.018951416015625, -0.0164794921875, -0.011505126953125, -0.0030517578125, 0.006805419921875, 0.013153076171875, 0.012939453125, 0.007965087890625, 0.003631591796875, 3.0517578125e-05, -0.00372314453125, -0.008331298828125, -0.01312255859375, -0.020843505859375, -0.024261474609375, -0.016693115234375, -0.012237548828125, -0.010223388671875, -0.00872802734375, -0.00830078125, -0.00592041015625, -0.00433349609375, -0.001251220703125, -0.000579833984375, -0.001190185546875, 0.000823974609375, 0.001617431640625, -0.000701904296875, -0.003204345703125, -0.004150390625, -0.003936767578125, -0.005645751953125, -0.00823974609375, -0.009124755859375, -0.0091552734375, -0.0072021484375, -0.0032958984375, -0.00091552734375, -0.001434326171875, -0.001983642578125, -0.00299072265625, -0.003265380859375, -0.002197265625, -0.00103759765625, -0.000457763671875, -0.00177001953125, -0.00274658203125, -0.003265380859375, -0.003204345703125, -0.00250244140625, -0.002960205078125, -0.0037841796875, -0.00445556640625, -0.00439453125, -0.002105712890625, -6.103515625e-05, -0.0006103515625, -0.003021240234375, -0.00439453125, -0.003936767578125, -0.002655029296875, -0.001434326171875, -0.00128173828125, -0.001708984375, -0.00225830078125, -0.002685546875, -0.0032958984375, -0.003387451171875])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, -6.103515625e-05, -0.0001220703125, -6.103515625e-05, -6.103515625e-05, 0.0001220703125, -9.1552734375e-05, 0.0001220703125, -0.000213623046875, 9.1552734375e-05, -0.000213623046875, 0.000152587890625, -3.0517578125e-05, 0.00042724609375, 0.000244140625, 0.024627685546875, 0.100250244140625, 0.0662841796875, -0.06585693359375, -0.08282470703125, -0.024627685546875, 0.0423583984375, 0.14141845703125, 0.155548095703125, 0.06365966796875, 0.05133056640625, 0.10076904296875, 0.057281494140625, -0.032684326171875, -0.0565185546875, -0.0592041015625, -0.084686279296875, -0.084320068359375, -0.056671142578125, -0.0474853515625, -0.05694580078125, -0.040191650390625, -0.002410888671875, 0.017364501953125, 0.024444580078125, 0.032257080078125, 0.037017822265625, 0.034393310546875, 0.025390625, 0.018890380859375, 0.0076904296875, -0.00164794921875, 0.00262451171875, 0.000579833984375, -0.01531982421875, -0.026947021484375, -0.02294921875, -0.02001953125, -0.024688720703125, -0.022857666015625, -0.015167236328125, -0.013519287109375, -0.015594482421875, -0.014801025390625, -0.009246826171875, 0.001953125, 0.01116943359375, 0.009918212890625, 0.00653076171875, 0.00457763671875, 0.00189208984375, -0.0029296875, -0.0064697265625, -0.0145263671875, -0.024932861328125, -0.023895263671875, -0.017242431640625, -0.009368896484375, -0.00701904296875, -0.0093994140625, -0.008056640625, -0.004669189453125, -0.003997802734375, -0.005096435546875, -0.003143310546875, 0.00103759765625, 0.001373291015625, 0.000823974609375, -0.0003662109375, -0.003204345703125, -0.002838134765625, -0.002532958984375, -0.00592041015625, -0.00885009765625, -0.009521484375, -0.00946044921875, -0.00775146484375, -0.00408935546875, -0.001312255859375, -0.001495361328125, -0.003021240234375, -0.003204345703125, -0.00238037109375, -0.00152587890625, -0.000579833984375, -0.00091552734375, -0.002349853515625, -0.0037841796875, -0.003875732421875, -0.00311279296875, -0.002532958984375, -0.003082275390625, -0.004241943359375, -0.00494384765625, -0.00439453125, -0.001953125, -6.103515625e-05, -0.001373291015625, -0.00390625, -0.00433349609375, -0.003509521484375, -0.00274658203125, -0.001708984375, -0.000823974609375, -0.001373291015625, -0.0023193359375, -0.002960205078125, -0.0037841796875, -0.003448486328125, -0.001861572265625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 0.0, 0.0, -0.0001220703125, 6.103515625e-05, -3.0517578125e-05, 0.00018310546875, -6.103515625e-05, 0.0001220703125, -0.000244140625, 0.000244140625, -0.000274658203125, 0.000274658203125, -0.00018310546875, 0.000640869140625, 0.000274658203125, 0.03192138671875, 0.115325927734375, 0.06060791015625, -0.085723876953125, -0.085235595703125, -0.0157470703125, 0.0535888671875, 0.1595458984375, 0.161102294921875, 0.05572509765625, 0.055908203125, 0.1094970703125, 0.047882080078125, -0.0494384765625, -0.06182861328125, -0.06341552734375, -0.095367431640625, -0.0906982421875, -0.0589599609375, -0.049530029296875, -0.051483154296875, -0.037567138671875, -0.005462646484375, 0.021209716796875, 0.02838134765625, 0.03472900390625, 0.038116455078125, 0.03289794921875, 0.0252685546875, 0.016845703125, 0.0050048828125, -0.001251220703125, 0.0003662109375, -0.003631591796875, -0.017852783203125, -0.0299072265625, -0.0279541015625, -0.02020263671875, -0.0155029296875, -0.016448974609375, -0.014007568359375, -0.008270263671875, -0.0078125, -0.011932373046875, -0.00830078125, 0.002716064453125, 0.006500244140625, 0.004364013671875, 0.002410888671875, 0.0023193359375, 0.001983642578125, -0.0010986328125, -0.009063720703125, -0.018402099609375, -0.022216796875, -0.021392822265625, -0.015045166015625, -0.0106201171875, -0.009033203125, -0.005523681640625, -0.00421142578125, -0.005615234375, -0.007080078125, -0.003814697265625, 0.001220703125, 0.00091552734375, -0.00054931640625, 0.00048828125, -0.0010986328125, -0.003143310546875, -0.00341796875, -0.003387451171875, -0.005462646484375, -0.00823974609375, -0.00933837890625, -0.009063720703125, -0.006866455078125, -0.00384521484375, -0.00177001953125, -0.002288818359375, -0.0029296875, -0.003173828125, -0.002777099609375, -0.000701904296875, 0.0009765625, 9.1552734375e-05, -0.00250244140625, -0.00457763671875, -0.0047607421875, -0.0040283203125, -0.00335693359375, -0.003265380859375, -0.004302978515625, -0.00518798828125, -0.00433349609375, -0.0015869140625, 0.0, -0.0013427734375, -0.003387451171875, -0.00421142578125, -0.003662109375, -0.002288818359375, -0.001129150390625, -0.00079345703125, -0.001312255859375, -0.002227783203125, -0.003204345703125, -0.00347900390625, -0.002349853515625, -0.0010986328125, -0.000946044921875])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, 0.0, -6.103515625e-05, -0.000152587890625, 0.0, -3.0517578125e-05, 0.00018310546875, -0.000152587890625, 0.0001220703125, -0.000335693359375, 0.000244140625, -0.000335693359375, 0.000335693359375, -0.00042724609375, 0.000885009765625, 0.000244140625, 0.04010009765625, 0.13128662109375, 0.053985595703125, -0.107177734375, -0.087646484375, -0.006072998046875, 0.065399169921875, 0.178924560546875, 0.1656494140625, 0.047119140625, 0.0625, 0.118438720703125, 0.037322998046875, -0.067718505859375, -0.068450927734375, -0.068023681640625, -0.104888916015625, -0.095977783203125, -0.061767578125, -0.052978515625, -0.047637939453125, -0.031280517578125, -0.00738525390625, 0.022552490234375, 0.03277587890625, 0.034698486328125, 0.039794921875, 0.034820556640625, 0.025665283203125, 0.015380859375, 0.004241943359375, -0.001068115234375, -0.004608154296875, -0.00994873046875, -0.021026611328125, -0.03173828125, -0.032806396484375, -0.02484130859375, -0.015106201171875, -0.010650634765625, -0.0086669921875, -0.006011962890625, -0.006256103515625, -0.0072021484375, 0.0013427734375, 0.008453369140625, 0.00628662109375, 0.00079345703125, -0.001556396484375, -0.0008544921875, -0.001312255859375, -0.007354736328125, -0.013275146484375, -0.017822265625, -0.021026611328125, -0.017364501953125, -0.013519287109375, -0.012054443359375, -0.008453369140625, -0.00457763671875, -0.004791259765625, -0.00732421875, -0.005218505859375, 0.001861572265625, 0.0035400390625, 0.000823974609375, -0.000579833984375, -0.001556396484375, -0.00286865234375, -0.0048828125, -0.00457763671875, -0.004150390625, -0.00653076171875, -0.008209228515625, -0.009002685546875, -0.00848388671875, -0.00604248046875, -0.002716064453125, -0.0018310546875, -0.002838134765625, -0.00335693359375, -0.003631591796875, -0.0028076171875, -0.0009765625, 0.001373291015625, 0.001312255859375, -0.001800537109375, -0.004974365234375, -0.005950927734375, -0.004638671875, -0.0037841796875, -0.00439453125, -0.005859375, -0.006500244140625, -0.004547119140625, -0.00128173828125, 3.0517578125e-05, -0.0013427734375, -0.002960205078125, -0.003509521484375, -0.00311279296875, -0.001922607421875, -0.001068115234375, -0.000823974609375, -0.0015869140625, -0.002716064453125, -0.00360107421875, -0.00335693359375, -0.0015869140625, 0.000213623046875, -0.000152587890625, -0.001983642578125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -9.1552734375e-05, -0.00018310546875, 0.0, 0.0, 0.00018310546875, -0.000152587890625, 0.00018310546875, -0.00042724609375, 0.000335693359375, -0.000518798828125, 0.00048828125, -0.00067138671875, 0.00103759765625, 0.000335693359375, 0.049163818359375, 0.147705078125, 0.0472412109375, -0.129058837890625, -0.090850830078125, 0.003204345703125, 0.078582763671875, 0.1995849609375, 0.169281005859375, 0.038238525390625, 0.070556640625, 0.12762451171875, 0.02545166015625, -0.086517333984375, -0.07568359375, -0.073333740234375, -0.114654541015625, -0.100921630859375, -0.064483642578125, -0.05572509765625, -0.044281005859375, -0.024505615234375, -0.006988525390625, 0.02117919921875, 0.038818359375, 0.036468505859375, 0.037994384765625, 0.037078857421875, 0.02569580078125, 0.016326904296875, 0.00537109375, 0.00018310546875, -0.006500244140625, -0.0184326171875, -0.029205322265625, -0.034088134765625, -0.033294677734375, -0.02935791015625, -0.017822265625, -0.009246826171875, -0.006439208984375, -0.00665283203125, -0.005157470703125, -0.000885009765625, 0.007965087890625, 0.014129638671875, 0.010772705078125, 0.00390625, -0.000335693359375, -0.002899169921875, -0.00927734375, -0.01318359375, -0.01507568359375, -0.019866943359375, -0.021148681640625, -0.01788330078125, -0.012786865234375, -0.009307861328125, -0.006866455078125, -0.00628662109375, -0.0076904296875, -0.00537109375, -0.000152587890625, 0.004119873046875, 0.004150390625, 0.002685546875, 0.000579833984375, -0.00213623046875, -0.005828857421875, -0.007476806640625, -0.00555419921875, -0.0048828125, -0.006683349609375, -0.00909423828125, -0.01007080078125, -0.008331298828125, -0.00482177734375, -0.00164794921875, -0.00091552734375, -0.00274658203125, -0.004241943359375, -0.00384521484375, -0.00250244140625, -0.000457763671875, 0.00128173828125, 0.001068115234375, -0.0015869140625, -0.005096435546875, -0.005767822265625, -0.0047607421875, -0.003692626953125, -0.004669189453125, -0.00762939453125, -0.00823974609375, -0.00537109375, -0.00140380859375, -3.0517578125e-05, -0.0013427734375, -0.002777099609375, -0.00274658203125, -0.001922607421875, -0.001251220703125, -0.000732421875, -0.000579833984375, -0.0013427734375, -0.002899169921875, -0.004486083984375, -0.00390625, -0.00128173828125, 0.000885009765625, 0.000579833984375, -0.001190185546875, -0.00244140625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -0.000152587890625, 6.103515625e-05, -3.0517578125e-05, 0.00018310546875, -0.0001220703125, 0.000213623046875, -0.000396728515625, 0.0003662109375, -0.000579833984375, 0.00067138671875, -0.0008544921875, 0.00128173828125, 0.00048828125, 0.058990478515625, 0.16400146484375, 0.040557861328125, -0.14996337890625, -0.094818115234375, 0.011627197265625, 0.092315673828125, 0.221160888671875, 0.172332763671875, 0.02996826171875, 0.080230712890625, 0.136260986328125, 0.0126953125, -0.104766845703125, -0.083770751953125, -0.079620361328125, -0.12347412109375, -0.10540771484375, -0.06793212890625, -0.0596923828125, -0.038848876953125, -0.01727294921875, -0.0045166015625, 0.019561767578125, 0.04058837890625, 0.04315185546875, 0.0357666015625, 0.03741455078125, 0.028289794921875, 0.013519287109375, 0.007293701171875, 0.005340576171875, -0.005859375, -0.0250244140625, -0.03839111328125, -0.040130615234375, -0.035308837890625, -0.031280517578125, -0.0186767578125, -0.0087890625, -0.0084228515625, -0.009124755859375, -0.004638671875, 0.003387451171875, 0.01287841796875, 0.017822265625, 0.01507568359375, 0.009613037109375, 0.00213623046875, -0.005462646484375, -0.009002685546875, -0.01202392578125, -0.01715087890625, -0.0234375, -0.02447509765625, -0.0194091796875, -0.01287841796875, -0.00897216796875, -0.008392333984375, -0.007415771484375, -0.003265380859375, 0.000396728515625, -0.000213623046875, 0.003448486328125, 0.006988525390625, 0.0042724609375, -3.0517578125e-05, -0.00311279296875, -0.0064697265625, -0.00775146484375, -0.00604248046875, -0.005157470703125, -0.007659912109375, -0.009857177734375, -0.009979248046875, -0.008819580078125, -0.005035400390625, -0.00042724609375, 0.00018310546875, -0.00238037109375, -0.004119873046875, -0.00396728515625, -0.002349853515625, -3.0517578125e-05, 0.002349853515625, 0.001251220703125, -0.003265380859375, -0.006011962890625, -0.004852294921875, -0.00323486328125, -0.00335693359375, -0.005828857421875, -0.008392333984375, -0.008331298828125, -0.00531005859375, -0.00177001953125, -0.000762939453125, -0.001983642578125, -0.002777099609375, -0.00189208984375, -0.001373291015625, -0.000701904296875, 0.000396728515625, 0.0009765625, -0.0006103515625, -0.003021240234375, -0.00433349609375, -0.00421142578125, -0.002166748046875, 0.00079345703125, 0.00140380859375, -0.00054931640625, -0.002227783203125, -0.00225830078125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.00018310546875, 6.103515625e-05, 3.0517578125e-05, 0.000213623046875, -0.000152587890625, 0.000213623046875, -0.000518798828125, 0.00042724609375, -0.000640869140625, 0.000732421875, -0.001007080078125, 0.00140380859375, 0.000732421875, 0.06866455078125, 0.179107666015625, 0.035247802734375, -0.168121337890625, -0.10040283203125, 0.01702880859375, 0.1058349609375, 0.242401123046875, 0.176116943359375, 0.023101806640625, 0.0899658203125, 0.144805908203125, -0.000579833984375, -0.1221923828125, -0.091766357421875, -0.087799072265625, -0.13232421875, -0.10882568359375, -0.071868896484375, -0.064697265625, -0.0338134765625, -0.00970458984375, -0.00091552734375, 0.0211181640625, 0.03814697265625, 0.04718017578125, 0.0390625, 0.033966064453125, 0.030670166015625, 0.0146484375, 0.0042724609375, 0.010223388671875, -0.0025634765625, -0.028900146484375, -0.0450439453125, -0.04840087890625, -0.03875732421875, -0.033599853515625, -0.022064208984375, -0.009490966796875, -0.0078125, -0.010711669921875, -0.00579833984375, 0.00457763671875, 0.014404296875, 0.020233154296875, 0.01934814453125, 0.010162353515625, -0.000946044921875, -0.00152587890625, -0.00189208984375, -0.00982666015625, -0.017333984375, -0.023651123046875, -0.02630615234375, -0.02227783203125, -0.015594482421875, -0.012664794921875, -0.01129150390625, -0.00506591796875, 0.00146484375, 0.00067138671875, 0.0001220703125, 0.00640869140625, 0.0087890625, 0.0030517578125, -0.00244140625, -0.003814697265625, -0.0062255859375, -0.0078125, -0.005523681640625, -0.0048828125, -0.008209228515625, -0.010162353515625, -0.010498046875, -0.0093994140625, -0.00506591796875, -0.000335693359375, -6.103515625e-05, -0.002777099609375, -0.00384521484375, -0.003753662109375, -0.00262451171875, -0.000274658203125, 0.002593994140625, 0.000732421875, -0.004150390625, -0.006591796875, -0.005401611328125, -0.003204345703125, -0.00286865234375, -0.005157470703125, -0.008697509765625, -0.008697509765625, -0.00531005859375, -0.001922607421875, -0.000732421875, -0.0020751953125, -0.003509521484375, -0.003570556640625, -0.0020751953125, 0.000274658203125, 0.001922607421875, 0.0015869140625, -0.00103759765625, -0.003021240234375, -0.0035400390625, -0.00341796875, -0.0023193359375, -0.000335693359375, -0.0003662109375, -0.001556396484375, -0.00152587890625, -0.00128173828125, -0.001251220703125])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, -0.00018310546875, -9.1552734375e-05, 0.000152587890625, 0.000274658203125, -0.000152587890625, 0.00042724609375, -0.001220703125, 0.001373291015625, -0.00262451171875, 0.0035400390625, -0.004791259765625, 0.006500244140625, -0.001373291015625, 0.121795654296875, 0.1553955078125, 0.009765625, -0.24517822265625, -0.41705322265625, 0.067108154296875, 0.3319091796875, 0.42498779296875, 0.416351318359375, 0.046905517578125, -0.123077392578125, 0.025848388671875, 0.072601318359375, -0.10528564453125, -0.158782958984375, -0.199432373046875, -0.14605712890625, -0.094085693359375, -0.106689453125, -0.05902099609375, -0.05621337890625, -0.01092529296875, 0.050933837890625, 0.057708740234375, 0.07586669921875, 0.074615478515625, 0.06988525390625, 0.060150146484375, 0.029022216796875, 0.01239013671875, 0.003875732421875, -0.04876708984375, -0.03326416015625, -0.017547607421875, -0.064453125, -0.05462646484375, -0.0289306640625, -0.019622802734375, -0.01080322265625, 0.001953125, 0.011932373046875, 0.013763427734375, 0.009307861328125, 0.012603759765625, 0.025543212890625, 0.03741455078125, 0.029449462890625, 0.013885498046875, 0.002960205078125, -0.01116943359375, -0.024383544921875, -0.034820556640625, -0.045166015625, -0.04595947265625, -0.042144775390625, -0.039825439453125, -0.0357666015625, -0.0240478515625, -0.00115966796875, 0.009857177734375, 0.00732421875, 0.007781982421875, 0.01275634765625, 0.007568359375, 0.00347900390625, 0.0037841796875, -0.000244140625, -0.004913330078125, -0.006622314453125, -0.009765625, -0.0130615234375, -0.009368896484375, -0.006500244140625, -0.00982666015625, -0.0125732421875, -0.010955810546875, -0.00946044921875, -0.005584716796875, 0.00030517578125, 0.0042724609375, 0.00262451171875, 0.0015869140625, 0.001739501953125, 0.001129150390625, 0.001678466796875, 0.00146484375, -0.00146484375, -0.006866455078125, -0.008392333984375, -0.00738525390625, -0.00616455078125, -0.005340576171875, -0.005279541015625, -0.004974365234375, -0.0050048828125, -0.004119873046875, -0.001708984375, -0.00128173828125, -0.00189208984375, -0.00177001953125, -0.002227783203125, -0.0029296875, -0.002105712890625, -0.0018310546875, -0.002197265625, -0.002349853515625, -0.00213623046875, -0.002044677734375, -0.0030517578125, -0.0040283203125, -0.0037841796875, -0.002166748046875, -0.0013427734375, -0.000885009765625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, -0.0001220703125, -6.103515625e-05, 6.103515625e-05, 0.000335693359375, -0.000213623046875, 0.000579833984375, -0.001129150390625, 0.001129150390625, -0.00225830078125, 0.002838134765625, -0.00347900390625, 0.004791259765625, -0.0020751953125, 0.0897216796875, 0.141845703125, 0.028961181640625, -0.180938720703125, -0.38848876953125, -0.041259765625, 0.25775146484375, 0.372589111328125, 0.435943603515625, 0.139923095703125, -0.090576171875, -0.00115966796875, 0.05804443359375, -0.064239501953125, -0.107757568359375, -0.16510009765625, -0.157928466796875, -0.10150146484375, -0.093017578125, -0.065765380859375, -0.06793212890625, -0.0260009765625, 0.03558349609375, 0.03912353515625, 0.060760498046875, 0.07391357421875, 0.063812255859375, 0.0628662109375, 0.05047607421875, 0.02587890625, 0.00848388671875, -0.045806884765625, -0.037567138671875, -0.018157958984375, -0.05865478515625, -0.0501708984375, -0.028564453125, -0.01849365234375, -0.008148193359375, 0.000274658203125, 0.004241943359375, 0.010162353515625, 0.00885009765625, 0.00885009765625, 0.02984619140625, 0.042938232421875, 0.021820068359375, 0.00189208984375, 0.003509521484375, -0.006561279296875, -0.025115966796875, -0.03375244140625, -0.04071044921875, -0.039886474609375, -0.033111572265625, -0.029022216796875, -0.02801513671875, -0.027923583984375, -0.012451171875, 0.006378173828125, 0.00732421875, 0.002838134765625, 0.006011962890625, 0.00506591796875, -6.103515625e-05, -6.103515625e-05, 0.000640869140625, -0.003753662109375, -0.00616455078125, -0.007537841796875, -0.01165771484375, -0.011505126953125, -0.007965087890625, -0.0057373046875, -0.009063720703125, -0.01165771484375, -0.00958251953125, -0.005462646484375, -0.001922607421875, 0.0018310546875, 0.00384521484375, 0.002960205078125, 0.001312255859375, 0.000885009765625, 0.00140380859375, 0.000579833984375, -0.001312255859375, -0.004547119140625, -0.00677490234375, -0.007171630859375, -0.005615234375, -0.005401611328125, -0.00592041015625, -0.005157470703125, -0.004608154296875, -0.004119873046875, -0.00311279296875, -0.0025634765625, -0.002288818359375, -0.001617431640625, -0.0009765625, -0.000946044921875, -0.00201416015625, -0.0030517578125, -0.002685546875, -0.002044677734375, -0.0020751953125, -0.001312255859375, -0.002166748046875, -0.003997802734375, -0.004608154296875, -0.003662109375, -0.002471923828125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 9.1552734375e-05, 6.103515625e-05, -9.1552734375e-05, -0.0001220703125, 0.000152587890625, 6.103515625e-05, 6.103515625e-05, 0.00018310546875, -0.0006103515625, 0.000518798828125, -0.001373291015625, 0.0020751953125, -0.0025634765625, 0.003387451171875, 0.003021240234375, 0.0946044921875, 0.115997314453125, 0.01556396484375, -0.1953125, -0.32574462890625, 0.00457763671875, 0.215545654296875, 0.35101318359375, 0.38641357421875, 0.1029052734375, -0.05462646484375, 0.02734375, 0.032470703125, -0.0609130859375, -0.0948486328125, -0.158905029296875, -0.1429443359375, -0.088714599609375, -0.08245849609375, -0.06964111328125, -0.062042236328125, -0.01385498046875, 0.025665283203125, 0.033050537109375, 0.058868408203125, 0.065521240234375, 0.060211181640625, 0.060821533203125, 0.048614501953125, 0.029510498046875, -0.001861572265625, -0.04736328125, -0.024322509765625, -0.0228271484375, -0.05316162109375, -0.040008544921875, -0.023712158203125, -0.011871337890625, -0.006683349609375, -0.003692626953125, 0.0, 0.007232666015625, 0.003692626953125, 0.009063720703125, 0.0322265625, 0.037078857421875, 0.01409912109375, -0.0035400390625, -0.002655029296875, -0.005645751953125, -0.02117919921875, -0.0341796875, -0.036285400390625, -0.03057861328125, -0.0279541015625, -0.025360107421875, -0.022796630859375, -0.023284912109375, -0.013153076171875, 0.00067138671875, 0.00604248046875, 0.00146484375, -0.000335693359375, -0.000732421875, -0.0013427734375, -0.00115966796875, -0.002410888671875, -0.003387451171875, -0.0050048828125, -0.008270263671875, -0.009521484375, -0.008026123046875, -0.007781982421875, -0.00714111328125, -0.007232666015625, -0.009765625, -0.01025390625, -0.00543212890625, -0.000274658203125, 0.002685546875, 0.003082275390625, 0.002105712890625, 0.0006103515625, 0.00048828125, 0.001220703125, 0.00048828125, -0.00189208984375, -0.004669189453125, -0.0059814453125, -0.0057373046875, -0.005279541015625, -0.005828857421875, -0.006103515625, -0.006103515625, -0.00506591796875, -0.00408935546875, -0.00286865234375, -0.003082275390625, -0.00201416015625, -0.000396728515625, -6.103515625e-05, -0.000701904296875, -0.00244140625, -0.003662109375, -0.003021240234375, -0.001434326171875, -0.00140380859375, -0.001556396484375, -0.002197265625, -0.00335693359375, -0.00408935546875, -0.00439453125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, -0.0001220703125, 0.000152587890625, 0.0, 3.0517578125e-05, 0.0001220703125, -0.00054931640625, 0.000396728515625, -0.00103759765625, 0.00152587890625, -0.001922607421875, 0.00250244140625, 0.002716064453125, 0.077301025390625, 0.102386474609375, 0.025604248046875, -0.156982421875, -0.279449462890625, -0.029388427734375, 0.157196044921875, 0.30926513671875, 0.351226806640625, 0.12152099609375, -0.013763427734375, 0.025115966796875, 0.028228759765625, -0.040191650390625, -0.078887939453125, -0.14227294921875, -0.12823486328125, -0.0787353515625, -0.081390380859375, -0.0701904296875, -0.054901123046875, -0.020538330078125, 0.01116943359375, 0.027252197265625, 0.050445556640625, 0.059356689453125, 0.058929443359375, 0.057952880859375, 0.048431396484375, 0.028106689453125, -0.003936767578125, -0.034942626953125, -0.01580810546875, -0.018951416015625, -0.040924072265625, -0.0321044921875, -0.021209716796875, -0.016357421875, -0.013214111328125, -0.007171630859375, -0.005767822265625, 3.0517578125e-05, 0.00048828125, 0.008544921875, 0.029266357421875, 0.029266357421875, 0.009857177734375, -0.0013427734375, -0.00238037109375, -0.002655029296875, -0.01690673828125, -0.031463623046875, -0.03045654296875, -0.025146484375, -0.024139404296875, -0.023590087890625, -0.020233154296875, -0.01898193359375, -0.01458740234375, -0.0064697265625, 0.001434326171875, 0.00152587890625, -0.002777099609375, -0.00665283203125, -0.005401611328125, -0.000762939453125, -0.0025634765625, -0.006011962890625, -0.0047607421875, -0.006103515625, -0.007415771484375, -0.005859375, -0.006500244140625, -0.0078125, -0.00799560546875, -0.007476806640625, -0.007568359375, -0.00469970703125, -0.000701904296875, 0.00152587890625, 0.00225830078125, 0.001861572265625, 0.000518798828125, -0.000396728515625, -0.00018310546875, -9.1552734375e-05, -0.0013427734375, -0.00335693359375, -0.00518798828125, -0.005615234375, -0.00604248046875, -0.0067138671875, -0.00628662109375, -0.005950927734375, -0.00537109375, -0.004241943359375, -0.00238037109375, -0.002105712890625, -0.0013427734375, 0.0, -0.000244140625, -0.001129150390625, -0.00250244140625, -0.00372314453125, -0.003570556640625, -0.0018310546875, -0.000701904296875, -0.000946044921875, -0.002410888671875, -0.003753662109375, -0.004150390625])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -9.1552734375e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, -6.103515625e-05, -6.103515625e-05, 0.000213623046875, -9.1552734375e-05, 0.000152587890625, -0.0001220703125, -0.000213623046875, 6.103515625e-05, -0.00048828125, 0.000946044921875, -0.001190185546875, 0.001434326171875, 0.005889892578125, 0.073211669921875, 0.08807373046875, 0.021209716796875, -0.152374267578125, -0.238494873046875, -0.027801513671875, 0.136932373046875, 0.29473876953125, 0.305511474609375, 0.113311767578125, 0.00616455078125, 0.028564453125, 0.024444580078125, -0.032989501953125, -0.073760986328125, -0.128448486328125, -0.107208251953125, -0.073760986328125, -0.080047607421875, -0.064605712890625, -0.049560546875, -0.023651123046875, 0.005218505859375, 0.026092529296875, 0.048004150390625, 0.056915283203125, 0.051544189453125, 0.0496826171875, 0.04754638671875, 0.029388427734375, -0.004730224609375, -0.023223876953125, -0.0057373046875, -0.016510009765625, -0.034637451171875, -0.031158447265625, -0.025726318359375, -0.02142333984375, -0.0137939453125, -0.012908935546875, -0.01141357421875, 0.00079345703125, -0.001373291015625, 0.008148193359375, 0.029327392578125, 0.022918701171875, 0.004913330078125, 0.004058837890625, 0.004150390625, -0.00531005859375, -0.01873779296875, -0.02764892578125, -0.027008056640625, -0.02294921875, -0.02227783203125, -0.021575927734375, -0.02081298828125, -0.017578125, -0.01153564453125, -0.007659912109375, -0.002685546875, -0.0009765625, -0.003509521484375, -0.00872802734375, -0.007049560546875, -0.001068115234375, -0.0032958984375, -0.007049560546875, -0.00482177734375, -0.003875732421875, -0.006256103515625, -0.005706787109375, -0.005889892578125, -0.0078125, -0.007476806640625, -0.00604248046875, -0.0042724609375, -0.003814697265625, -0.00238037109375, 0.00152587890625, 0.002471923828125, 0.001495361328125, -0.000518798828125, -0.00146484375, -0.000396728515625, 0.000274658203125, -0.0009765625, -0.00408935546875, -0.00567626953125, -0.0054931640625, -0.00592041015625, -0.006866455078125, -0.006500244140625, -0.005157470703125, -0.00457763671875, -0.003082275390625, -0.0015869140625, -0.001678466796875, -0.001068115234375, -0.0008544921875, -0.0006103515625, -0.0009765625, -0.00238037109375, -0.00372314453125, -0.00335693359375, -0.00189208984375, -0.00115966796875, -0.000885009765625, -0.002593994140625, -0.0042724609375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -6.103515625e-05, -9.1552734375e-05, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, -0.000152587890625, 0.00018310546875, -0.00048828125, 0.000732421875, -0.0010986328125, 0.001190185546875, 0.003509521484375, 0.056243896484375, 0.0802001953125, 0.0343017578125, -0.110626220703125, -0.216156005859375, -0.064453125, 0.099761962890625, 0.25018310546875, 0.28179931640625, 0.1346435546875, 0.02618408203125, 0.028656005859375, 0.02862548828125, -0.02001953125, -0.056854248046875, -0.10528564453125, -0.095550537109375, -0.07025146484375, -0.0772705078125, -0.060760498046875, -0.048187255859375, -0.032257080078125, -0.00030517578125, 0.02459716796875, 0.037322998046875, 0.041778564453125, 0.04583740234375, 0.05291748046875, 0.05401611328125, 0.0343017578125, 0.00384521484375, -0.00933837890625, -0.002899169921875, -0.017578125, -0.035064697265625, -0.034027099609375, -0.030029296875, -0.02801513671875, -0.019775390625, -0.014801025390625, -0.009857177734375, -0.00286865234375, -0.006011962890625, 0.009765625, 0.028289794921875, 0.018829345703125, 0.007080078125, 0.010955810546875, 0.007049560546875, -0.0076904296875, -0.018524169921875, -0.024322509765625, -0.025665283203125, -0.023162841796875, -0.0216064453125, -0.0223388671875, -0.02081298828125, -0.0140380859375, -0.009796142578125, -0.00958251953125, -0.00732421875, -0.00335693359375, -0.003387451171875, -0.007354736328125, -0.006072998046875, -0.00433349609375, -0.004638671875, -0.005279541015625, -0.004058837890625, -0.004425048828125, -0.006591796875, -0.006988525390625, -0.006011962890625, -0.004913330078125, -0.005615234375, -0.006011962890625, -0.0045166015625, -0.001983642578125, -0.000701904296875, 0.00018310546875, 0.00067138671875, -0.0001220703125, -0.000518798828125, -0.000946044921875, -0.00091552734375, -0.000762939453125, -0.0023193359375, -0.004241943359375, -0.00531005859375, -0.005096435546875, -0.0057373046875, -0.006591796875, -0.00616455078125, -0.0045166015625, -0.002960205078125, -0.002166748046875, -0.001708984375, -0.0020751953125, -0.001617431640625, -0.001068115234375, -0.000701904296875, -0.000946044921875, -0.00225830078125, -0.00347900390625, -0.00341796875, -0.002716064453125, -0.00225830078125, -0.00177001953125, -0.00250244140625])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 0.0, 6.103515625e-05, 6.103515625e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 0.0, 6.103515625e-05, 6.103515625e-05, -3.0517578125e-05, 9.1552734375e-05, -0.000213623046875, 0.0003662109375, -0.000518798828125, 0.000732421875, 0.004852294921875, 0.05169677734375, 0.07196044921875, 0.032501220703125, -0.103424072265625, -0.195892333984375, -0.0634765625, 0.09185791015625, 0.23291015625, 0.253387451171875, 0.12664794921875, 0.034027099609375, 0.032501220703125, 0.0267333984375, -0.014862060546875, -0.04888916015625, -0.090667724609375, -0.081939697265625, -0.067474365234375, -0.072784423828125, -0.05438232421875, -0.04595947265625, -0.030364990234375, -0.002899169921875, 0.0135498046875, 0.0301513671875, 0.04388427734375, 0.0499267578125, 0.05645751953125, 0.058013916015625, 0.033843994140625, 0.002532958984375, -0.00689697265625, -0.007904052734375, -0.02301025390625, -0.0333251953125, -0.037872314453125, -0.03961181640625, -0.026092529296875, -0.01422119140625, -0.0157470703125, -0.01025390625, -0.004058837890625, -0.004730224609375, 0.01397705078125, 0.03021240234375, 0.0167236328125, 0.007171630859375, 0.011260986328125, 0.00567626953125, -0.00970458984375, -0.020538330078125, -0.023834228515625, -0.026336669921875, -0.024017333984375, -0.021392822265625, -0.019683837890625, -0.01776123046875, -0.01275634765625, -0.009796142578125, -0.0103759765625, -0.007232666015625, -0.003448486328125, -0.00299072265625, -0.005889892578125, -0.0045166015625, -0.004547119140625, -0.006103515625, -0.004638671875, -0.0048828125, -0.007110595703125, -0.007415771484375, -0.0064697265625, -0.005126953125, -0.00445556640625, -0.004302978515625, -0.004364013671875, -0.003082275390625, -0.000640869140625, -0.000396728515625, -0.001007080078125, -0.000457763671875, 0.0, -0.000457763671875, -0.001495361328125, -0.00213623046875, -0.002197265625, -0.00250244140625, -0.004150390625, -0.00469970703125, -0.004638671875, -0.005615234375, -0.005828857421875, -0.00537109375, -0.003265380859375, -0.001983642578125, -0.0018310546875, -0.00189208984375, -0.002105712890625, -0.00164794921875, -0.001190185546875, -0.0009765625, -0.001312255859375, -0.002288818359375, -0.003631591796875, -0.0035400390625, -0.003082275390625, -0.002838134765625, -0.00244140625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 0.0, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, -0.000244140625, 0.000274658203125, -0.00030517578125, 0.00018310546875, 0.005828857421875, 0.047332763671875, 0.06475830078125, 0.032135009765625, -0.096466064453125, -0.1815185546875, -0.062530517578125, 0.085205078125, 0.217559814453125, 0.229705810546875, 0.118804931640625, 0.04022216796875, 0.034820556640625, 0.02545166015625, -0.01019287109375, -0.040740966796875, -0.077117919921875, -0.07110595703125, -0.06451416015625, -0.065948486328125, -0.04656982421875, -0.047943115234375, -0.039154052734375, -0.007171630859375, 0.0179443359375, 0.0343017578125, 0.046112060546875, 0.05413818359375, 0.059814453125, 0.052764892578125, 0.021484375, -0.001220703125, -0.0074462890625, -0.0113525390625, -0.024993896484375, -0.0426025390625, -0.04248046875, -0.031585693359375, -0.02099609375, -0.0157470703125, -0.0140380859375, -0.007080078125, -0.007659912109375, -0.0006103515625, 0.024749755859375, 0.026824951171875, 0.00897216796875, 0.007110595703125, 0.010589599609375, 0.001495361328125, -0.012420654296875, -0.0216064453125, -0.026947021484375, -0.02777099609375, -0.021148681640625, -0.0174560546875, -0.018768310546875, -0.017425537109375, -0.0120849609375, -0.00958251953125, -0.00811767578125, -0.006195068359375, -0.00372314453125, -0.00201416015625, -0.0037841796875, -0.003662109375, -0.005218505859375, -0.00811767578125, -0.007110595703125, -0.006866455078125, -0.008331298828125, -0.007659912109375, -0.006378173828125, -0.005035400390625, -0.00396728515625, -0.00213623046875, -0.0018310546875, -0.002532958984375, -0.001861572265625, -0.00067138671875, -0.000579833984375, -0.00103759765625, -0.00079345703125, -0.001800537109375, -0.0028076171875, -0.003265380859375, -0.00262451171875, -0.00262451171875, -0.003875732421875, -0.00445556640625, -0.004730224609375, -0.0048828125, -0.00494384765625, -0.003997802734375, -0.00274658203125, -0.00238037109375, -0.0018310546875, -0.001983642578125, -0.001983642578125, -0.0023193359375, -0.002105712890625, -0.00152587890625, -0.001708984375, -0.00244140625, -0.003631591796875, -0.00396728515625, -0.00408935546875, -0.003387451171875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, -6.103515625e-05, 0.0, -9.1552734375e-05, -3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, -9.1552734375e-05, 0.0, -6.103515625e-05, 3.0517578125e-05, 0.00018310546875, -0.0001220703125, -3.0517578125e-05, -0.000244140625, 0.000335693359375, -0.000457763671875, 0.000274658203125, 0.00372314453125, 0.036865234375, 0.0579833984375, 0.042022705078125, -0.067840576171875, -0.1708984375, -0.082763671875, 0.059234619140625, 0.18914794921875, 0.2154541015625, 0.125244140625, 0.051116943359375, 0.035614013671875, 0.027984619140625, -0.000457763671875, -0.025604248046875, -0.059295654296875, -0.061431884765625, -0.05572509765625, -0.06390380859375, -0.05718994140625, -0.049530029296875, -0.031402587890625, -0.002471923828125, 0.020294189453125, 0.0361328125, 0.04766845703125, 0.048309326171875, 0.047607421875, 0.03997802734375, 0.013946533203125, 0.0008544921875, -0.006591796875, -0.0220947265625, -0.031097412109375, -0.03302001953125, -0.036773681640625, -0.031341552734375, -0.01690673828125, -0.010284423828125, -0.013214111328125, -0.0108642578125, -0.00146484375, 0.008270263671875, 0.02032470703125, 0.01824951171875, 0.006622314453125, 0.00494384765625, 0.006317138671875, -0.001495361328125, -0.01434326171875, -0.02423095703125, -0.026885986328125, -0.023040771484375, -0.0177001953125, -0.0169677734375, -0.019378662109375, -0.015533447265625, -0.00921630859375, -0.007537841796875, -0.006866455078125, -0.0048828125, -0.0025634765625, -0.001007080078125, -0.002105712890625, -0.004852294921875, -0.007354736328125, -0.010284423828125, -0.010284423828125, -0.008209228515625, -0.0081787109375, -0.008148193359375, -0.00726318359375, -0.00408935546875, -0.001007080078125, -0.00042724609375, -0.00164794921875, -0.002685546875, -0.00164794921875, -0.000396728515625, -0.000732421875, -0.001983642578125, -0.002349853515625, -0.00311279296875, -0.003631591796875, -0.003387451171875, -0.003265380859375, -0.00323486328125, -0.0032958984375, -0.00341796875, -0.003662109375, -0.003875732421875, -0.0037841796875, -0.003631591796875, -0.00311279296875, -0.002197265625, -0.00177001953125, -0.00201416015625, -0.0028076171875, -0.003021240234375, -0.002288818359375, -0.001861572265625, -0.002044677734375, -0.002838134765625, -0.00390625, -0.004638671875, -0.00439453125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, 0.0, 0.0, 3.0517578125e-05, 0.0, -6.103515625e-05, -6.103515625e-05, 3.0517578125e-05, -9.1552734375e-05, 0.000213623046875, 0.00018310546875, -9.1552734375e-05, -6.103515625e-05, -0.000152587890625, 0.000213623046875, -0.000335693359375, 0.000213623046875, 0.005126953125, 0.03521728515625, 0.05364990234375, 0.0401611328125, -0.071990966796875, -0.162933349609375, -0.073516845703125, 0.063232421875, 0.184844970703125, 0.195465087890625, 0.11224365234375, 0.0521240234375, 0.03656005859375, 0.027099609375, 0.003997802734375, -0.01806640625, -0.04632568359375, -0.0567626953125, -0.063720703125, -0.063018798828125, -0.043731689453125, -0.0345458984375, -0.02227783203125, 0.002716064453125, 0.023345947265625, 0.03240966796875, 0.03570556640625, 0.036712646484375, 0.0372314453125, 0.02728271484375, 0.011138916015625, -0.005462646484375, -0.01849365234375, -0.016265869140625, -0.020751953125, -0.03369140625, -0.0355224609375, -0.01953125, -0.010894775390625, -0.013702392578125, -0.01043701171875, -0.004364013671875, 0.0003662109375, 0.00897216796875, 0.016448974609375, 0.009002685546875, 0.0030517578125, 0.003753662109375, 0.000579833984375, -0.00836181640625, -0.0166015625, -0.020843505859375, -0.023101806640625, -0.02044677734375, -0.0172119140625, -0.01678466796875, -0.01556396484375, -0.011016845703125, -0.007720947265625, -0.00653076171875, -0.00482177734375, -0.00323486328125, -0.001708984375, -0.001678466796875, -0.00396728515625, -0.006927490234375, -0.00994873046875, -0.011627197265625, -0.010162353515625, -0.008758544921875, -0.009613037109375, -0.00830078125, -0.004150390625, -0.00146484375, -0.0010986328125, -0.001129150390625, -0.000946044921875, -0.0009765625, -0.001251220703125, -0.001190185546875, -0.001739501953125, -0.00299072265625, -0.00311279296875, -0.003936767578125, -0.004608154296875, -0.00433349609375, -0.003387451171875, -0.002227783203125, -0.001983642578125, -0.00250244140625, -0.003387451171875, -0.003326416015625, -0.0032958984375, -0.003204345703125, -0.00286865234375, -0.002593994140625, -0.002197265625, -0.00213623046875, -0.0025634765625, -0.00323486328125, -0.003143310546875, -0.00262451171875, -0.0025634765625, -0.0030517578125, -0.0045166015625, -0.004852294921875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 0.0, -6.103515625e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, -9.1552734375e-05, 3.0517578125e-05, -9.1552734375e-05, 0.00030517578125, 6.103515625e-05, -6.103515625e-05, -9.1552734375e-05, -9.1552734375e-05, 0.000213623046875, -0.000274658203125, 0.000457763671875, 0.00445556640625, 0.030853271484375, 0.04901123046875, 0.04315185546875, -0.0623779296875, -0.156951904296875, -0.075927734375, 0.056610107421875, 0.1719970703125, 0.180145263671875, 0.1064453125, 0.056732177734375, 0.039581298828125, 0.031402587890625, 0.01324462890625, -0.01312255859375, -0.04791259765625, -0.0521240234375, -0.045623779296875, -0.044891357421875, -0.032135009765625, -0.02569580078125, -0.02008056640625, -0.00628662109375, 0.011627197265625, 0.019683837890625, 0.0230712890625, 0.026702880859375, 0.027069091796875, 0.015411376953125, -0.001068115234375, -0.00018310546875, -0.004486083984375, -0.011810302734375, -0.018310546875, -0.027618408203125, -0.025390625, -0.017120361328125, -0.009735107421875, -0.008575439453125, -0.011474609375, -0.007049560546875, 0.0023193359375, 0.0081787109375, 0.005615234375, 0.00244140625, 0.00213623046875, -0.00189208984375, -0.0069580078125, -0.008026123046875, -0.01019287109375, -0.018310546875, -0.022003173828125, -0.018768310546875, -0.014007568359375, -0.012359619140625, -0.0120849609375, -0.008880615234375, -0.00689697265625, -0.005157470703125, -0.002532958984375, -0.003570556640625, -0.004241943359375, -0.00347900390625, -0.005615234375, -0.0093994140625, -0.01019287109375, -0.0101318359375, -0.011749267578125, -0.011077880859375, -0.008087158203125, -0.004730224609375, -0.0032958984375, -0.002227783203125, -0.0006103515625, 0.000244140625, 0.0003662109375, -0.00042724609375, -0.0015869140625, -0.002227783203125, -0.0029296875, -0.00335693359375, -0.004180908203125, -0.005523681640625, -0.005157470703125, -0.003265380859375, -0.001800537109375, -0.00152587890625, -0.001556396484375, -0.002166748046875, -0.002716064453125, -0.00244140625, -0.002838134765625, -0.00341796875, -0.003173828125, -0.002197265625, -0.00140380859375, -0.002166748046875, -0.00335693359375, -0.003997802734375, -0.003509521484375, -0.00311279296875, -0.002960205078125, -0.003448486328125, -0.004241943359375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, 6.103515625e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, 0.0003662109375, -9.1552734375e-05, 9.1552734375e-05, -0.00018310546875, 0.0001220703125, -9.1552734375e-05, 0.000274658203125, -3.0517578125e-05, 0.007843017578125, 0.0333251953125, 0.04913330078125, 0.03289794921875, -0.0885009765625, -0.1497802734375, -0.046142578125, 0.08154296875, 0.173828125, 0.15576171875, 0.08978271484375, 0.05487060546875, 0.043487548828125, 0.026702880859375, 0.001312255859375, -0.01409912109375, -0.029327392578125, -0.033111572265625, -0.034912109375, -0.034942626953125, -0.02886962890625, -0.030670166015625, -0.02880859375, -0.01275634765625, 0.0062255859375, 0.011566162109375, 0.016448974609375, 0.017578125, 0.009674072265625, 0.0103759765625, 0.014892578125, 0.00457763671875, -0.005706787109375, -0.00439453125, -0.013275146484375, -0.028350830078125, -0.02056884765625, -0.0081787109375, -0.01318359375, -0.01531982421875, -0.010284423828125, -0.00439453125, 0.002410888671875, 0.00390625, -0.0018310546875, -0.00152587890625, -0.001556396484375, -0.005218505859375, -0.006072998046875, -0.00592041015625, -0.010345458984375, -0.0185546875, -0.0185546875, -0.013580322265625, -0.01104736328125, -0.010955810546875, -0.009613037109375, -0.0076904296875, -0.005828857421875, -0.00341796875, -0.00445556640625, -0.0059814453125, -0.00543212890625, -0.00543212890625, -0.007354736328125, -0.009490966796875, -0.00994873046875, -0.0118408203125, -0.01165771484375, -0.008544921875, -0.0064697265625, -0.0047607421875, -0.00299072265625, -0.000518798828125, 0.0003662109375, 0.000518798828125, 0.000152587890625, -0.001068115234375, -0.002288818359375, -0.003631591796875, -0.00396728515625, -0.004608154296875, -0.005035400390625, -0.00494384765625, -0.003997802734375, -0.002227783203125, -0.001861572265625, -0.001373291015625, -0.001495361328125, -0.001983642578125, -0.002044677734375, -0.002716064453125, -0.0032958984375, -0.002960205078125, -0.002288818359375, -0.0020751953125, -0.00225830078125, -0.002899169921875, -0.004119873046875, -0.0045166015625, -0.00421142578125, -0.00360107421875, -0.0029296875, -0.002899169921875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 0.0, 6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 6.103515625e-05, 6.103515625e-05, 0.0, 3.0517578125e-05, -9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, 0.000274658203125, -0.000152587890625, 0.000213623046875, -0.000274658203125, 0.00042724609375, 0.0, 0.000579833984375, -0.000762939453125, 0.01153564453125, 0.035797119140625, 0.0501708984375, 0.0167236328125, -0.111541748046875, -0.13397216796875, -0.012451171875, 0.101409912109375, 0.1619873046875, 0.133514404296875, 0.07879638671875, 0.04803466796875, 0.037506103515625, 0.02972412109375, 0.01885986328125, 0.002227783203125, -0.013580322265625, -0.024139404296875, -0.035003662109375, -0.037872314453125, -0.04193115234375, -0.0421142578125, -0.0343017578125, -0.0172119140625, -0.00177001953125, 0.00299072265625, 0.002655029296875, 0.006591796875, 0.023956298828125, 0.024322509765625, 0.01336669921875, 0.00775146484375, 0.008514404296875, -0.0028076171875, -0.019195556640625, -0.017547607421875, -0.017730712890625, -0.021270751953125, -0.018310546875, -0.011566162109375, -0.0103759765625, -0.005401611328125, 0.002227783203125, -0.003021240234375, -0.008575439453125, -0.002105712890625, 0.000335693359375, -0.005889892578125, -0.00665283203125, -0.005096435546875, -0.0084228515625, -0.01348876953125, -0.01422119140625, -0.012115478515625, -0.009765625, -0.008636474609375, -0.00787353515625, -0.00689697265625, -0.006134033203125, -0.005401611328125, -0.006927490234375, -0.00732421875, -0.00640869140625, -0.00616455078125, -0.0076904296875, -0.0101318359375, -0.0103759765625, -0.009490966796875, -0.009521484375, -0.009002685546875, -0.00634765625, -0.003265380859375, -0.000885009765625, 0.000396728515625, 0.000518798828125, -0.00018310546875, -0.001007080078125, -0.0018310546875, -0.00347900390625, -0.00482177734375, -0.004730224609375, -0.003997802734375, -0.004058837890625, -0.004180908203125, -0.003326416015625, -0.002197265625, -0.001556396484375, -0.001373291015625, -0.00115966796875, -0.00152587890625, -0.00213623046875, -0.002410888671875, -0.002716064453125, -0.00262451171875, -0.002532958984375, -0.002349853515625, -0.002655029296875, -0.003875732421875, -0.004791259765625, -0.0047607421875, -0.003814697265625, -0.002838134765625, -0.001739501953125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 0.0, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, -9.1552734375e-05, 0.0, -6.103515625e-05, 0.0, 0.0, 0.0, -3.0517578125e-05, -0.0001220703125, -6.103515625e-05, 0.0, 0.0001220703125, 9.1552734375e-05, -9.1552734375e-05, -3.0517578125e-05, -3.0517578125e-05, 0.000640869140625, 3.0517578125e-05, -0.00048828125, 0.001312255859375, 0.023193359375, 0.043487548828125, 0.046966552734375, -0.041229248046875, -0.145843505859375, -0.075103759765625, 0.052764892578125, 0.128265380859375, 0.1397705078125, 0.097991943359375, 0.056304931640625, 0.051483154296875, 0.05914306640625, 0.0384521484375, 0.01580810546875, -0.000885009765625, -0.014801025390625, -0.03558349609375, -0.04632568359375, -0.044830322265625, -0.050506591796875, -0.045745849609375, -0.03399658203125, -0.013885498046875, -0.007659912109375, -0.009613037109375, 0.01373291015625, 0.0303955078125, 0.02484130859375, 0.020782470703125, 0.0208740234375, 0.011993408203125, 0.00189208984375, -0.003143310546875, -0.0177001953125, -0.0301513671875, -0.027435302734375, -0.018310546875, -0.015289306640625, -0.013458251953125, -0.00848388671875, -0.003875732421875, -0.00262451171875, -0.006439208984375, -0.00311279296875, -0.00018310546875, -0.0047607421875, -0.00738525390625, -0.00390625, -0.002685546875, -0.007598876953125, -0.01318359375, -0.01409912109375, -0.010223388671875, -0.007659912109375, -0.007904052734375, -0.008392333984375, -0.007293701171875, -0.007171630859375, -0.00811767578125, -0.008148193359375, -0.006744384765625, -0.006256103515625, -0.0076904296875, -0.0091552734375, -0.0091552734375, -0.008392333984375, -0.009368896484375, -0.009613037109375, -0.0078125, -0.0045166015625, -0.001312255859375, -6.103515625e-05, -0.000335693359375, -0.001190185546875, -0.001495361328125, -0.00238037109375, -0.003387451171875, -0.004058837890625, -0.00439453125, -0.004180908203125, -0.003936767578125, -0.00372314453125, -0.0035400390625, -0.003173828125, -0.002288818359375, -0.0015869140625, -0.00146484375, -0.00146484375, -0.00164794921875, -0.00213623046875, -0.00299072265625, -0.003082275390625, -0.002716064453125, -0.0028076171875, -0.00323486328125, -0.0037841796875, -0.00439453125, -0.0047607421875, -0.0040283203125, -0.002899169921875, -0.001800537109375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, 0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, 0.0, 6.103515625e-05, 6.103515625e-05, 0.000244140625, -9.1552734375e-05, 9.1552734375e-05, -9.1552734375e-05, 0.00103759765625, -0.00018310546875, 0.0, -0.00146484375, 0.014007568359375, 0.03778076171875, 0.05242919921875, 0.00189208984375, -0.12677001953125, -0.112335205078125, 0.020416259765625, 0.103485107421875, 0.126129150390625, 0.1038818359375, 0.07806396484375, 0.06903076171875, 0.07147216796875, 0.05340576171875, 0.02337646484375, -0.0003662109375, -0.013427734375, -0.0299072265625, -0.05255126953125, -0.050506591796875, -0.04937744140625, -0.05584716796875, -0.046173095703125, -0.019439697265625, -0.01715087890625, -0.011566162109375, 0.021392822265625, 0.03143310546875, 0.027435302734375, 0.02923583984375, 0.027374267578125, 0.010284423828125, 0.010009765625, 0.006866455078125, -0.02294921875, -0.039306640625, -0.02911376953125, -0.018218994140625, -0.019378662109375, -0.015594482421875, -0.01104736328125, -0.00787353515625, -0.0028076171875, 0.00091552734375, -0.00030517578125, -0.003570556640625, -0.00518798828125, -0.0057373046875, -0.00244140625, -0.001220703125, -0.004058837890625, -0.01123046875, -0.014251708984375, -0.0107421875, -0.00762939453125, -0.00799560546875, -0.0086669921875, -0.007171630859375, -0.008697509765625, -0.009521484375, -0.0081787109375, -0.006378173828125, -0.00567626953125, -0.0074462890625, -0.008331298828125, -0.008026123046875, -0.007965087890625, -0.008087158203125, -0.00836181640625, -0.00799560546875, -0.0057373046875, -0.00238037109375, -0.00091552734375, -0.00140380859375, -0.001708984375, -0.00225830078125, -0.00299072265625, -0.002777099609375, -0.002166748046875, -0.003326416015625, -0.004547119140625, -0.003875732421875, -0.00274658203125, -0.00274658203125, -0.00323486328125, -0.002716064453125, -0.001678466796875, -0.001678466796875, -0.0015869140625, -0.00146484375, -0.00189208984375, -0.002655029296875, -0.003143310546875, -0.0028076171875, -0.002777099609375, -0.003204345703125, -0.003173828125, -0.003631591796875, -0.003997802734375, -0.003448486328125, -0.002349853515625, -0.00164794921875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, 0.0, 0.0, 0.0, 0.0, 3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, -9.1552734375e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, -9.1552734375e-05, -6.103515625e-05, 3.0517578125e-05, -9.1552734375e-05, 6.103515625e-05, -0.00018310546875, 0.000152587890625, -0.000213623046875, 0.00091552734375, -0.0001220703125, -0.000244140625, -0.00140380859375, 0.010040283203125, 0.035675048828125, 0.054473876953125, 0.018585205078125, -0.114501953125, -0.1351318359375, -6.103515625e-05, 0.099029541015625, 0.127685546875, 0.114776611328125, 0.092193603515625, 0.07513427734375, 0.073516845703125, 0.05419921875, 0.019805908203125, -0.000335693359375, -0.019012451171875, -0.034271240234375, -0.0504150390625, -0.054443359375, -0.05426025390625, -0.057891845703125, -0.044952392578125, -0.032196044921875, -0.01849365234375, 0.00811767578125, 0.0194091796875, 0.02557373046875, 0.039642333984375, 0.03790283203125, 0.02008056640625, 0.01434326171875, 0.016876220703125, -0.0023193359375, -0.0308837890625, -0.039215087890625, -0.027618408203125, -0.022369384765625, -0.02117919921875, -0.0184326171875, -0.015716552734375, -0.00860595703125, 0.001312255859375, 0.006683349609375, 0.00213623046875, -0.003509521484375, -0.004364013671875, -0.00372314453125, -0.003662109375, -0.0020751953125, -0.00347900390625, -0.010345458984375, -0.01416015625, -0.011505126953125, -0.0087890625, -0.00823974609375, -0.007965087890625, -0.008026123046875, -0.00982666015625, -0.010406494140625, -0.0079345703125, -0.00604248046875, -0.005523681640625, -0.006072998046875, -0.008087158203125, -0.009307861328125, -0.006927490234375, -0.0057373046875, -0.007049560546875, -0.00762939453125, -0.006378173828125, -0.00457763671875, -0.003662109375, -0.002685546875, -0.003204345703125, -0.0040283203125, -0.00262451171875, -0.001220703125, -0.001708984375, -0.003326416015625, -0.004058837890625, -0.0032958984375, -0.00250244140625, -0.002410888671875, -0.00250244140625, -0.00244140625, -0.0025634765625, -0.002471923828125, -0.00225830078125, -0.002166748046875, -0.00225830078125, -0.0028076171875, -0.003387451171875, -0.00335693359375, -0.0028076171875, -0.002685546875, -0.003021240234375, -0.003082275390625, -0.0029296875, -0.002410888671875, -0.002197265625, -0.00238037109375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 0.0, 0.0, 0.0, 6.103515625e-05, 0.0, -3.0517578125e-05, -6.103515625e-05, 9.1552734375e-05, 3.0517578125e-05, 3.0517578125e-05, -0.000274658203125, 0.000213623046875, 0.0001220703125, 0.00079345703125, -0.000244140625, -9.1552734375e-05, -0.001312255859375, 0.01324462890625, 0.0401611328125, 0.06060791015625, 0.00604248046875, -0.13861083984375, -0.133819580078125, 0.017333984375, 0.115692138671875, 0.14202880859375, 0.127960205078125, 0.0904541015625, 0.063568115234375, 0.06671142578125, 0.044708251953125, 0.009002685546875, -0.006866455078125, -0.0224609375, -0.042144775390625, -0.054901123046875, -0.05120849609375, -0.05645751953125, -0.053070068359375, -0.042877197265625, -0.035430908203125, -0.002288818359375, 0.017852783203125, 0.01837158203125, 0.03033447265625, 0.044036865234375, 0.03485107421875, 0.020050048828125, 0.02093505859375, 0.006744384765625, -0.019317626953125, -0.032989501953125, -0.031585693359375, -0.0284423828125, -0.0255126953125, -0.02117919921875, -0.02197265625, -0.01568603515625, -0.0048828125, 0.004547119140625, 0.007415771484375, 0.004119873046875, 0.000518798828125, -0.0008544921875, -0.002471923828125, -0.0057373046875, -0.00555419921875, -0.0047607421875, -0.0087890625, -0.01519775390625, -0.013916015625, -0.008514404296875, -0.007080078125, -0.00830078125, -0.00921630859375, -0.0101318359375, -0.009368896484375, -0.0067138671875, -0.005584716796875, -0.004974365234375, -0.00567626953125, -0.008575439453125, -0.00823974609375, -0.005523681640625, -0.004608154296875, -0.005950927734375, -0.00714111328125, -0.006805419921875, -0.006072998046875, -0.0048828125, -0.005096435546875, -0.00543212890625, -0.0032958984375, -0.00042724609375, -0.0009765625, -0.00286865234375, -0.003204345703125, -0.0025634765625, -0.002044677734375, -0.002288818359375, -0.00213623046875, -0.00189208984375, -0.001861572265625, -0.002685546875, -0.003204345703125, -0.0028076171875, -0.0028076171875, -0.00286865234375, -0.0032958984375, -0.0032958984375, -0.00299072265625, -0.002593994140625, -0.002288818359375, -0.00250244140625, -0.002288818359375, -0.001983642578125, -0.001800537109375, -0.002227783203125, -0.0023193359375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, 3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, 0.000152587890625, -0.000152587890625, -0.000152587890625, -3.0517578125e-05, 0.00042724609375, 0.000579833984375, -0.00030517578125, -0.0003662109375, 0.00140380859375, 0.02490234375, 0.05926513671875, 0.056365966796875, -0.0704345703125, -0.177520751953125, -0.0682373046875, 0.081756591796875, 0.141632080078125, 0.150970458984375, 0.1177978515625, 0.072662353515625, 0.061614990234375, 0.0516357421875, 0.0157470703125, -0.004058837890625, -0.018951416015625, -0.03790283203125, -0.050872802734375, -0.054473876953125, -0.05364990234375, -0.048919677734375, -0.042327880859375, -0.047576904296875, -0.013916015625, 0.0203857421875, 0.015655517578125, 0.0260009765625, 0.044677734375, 0.03729248046875, 0.024078369140625, 0.029541015625, 0.016265869140625, -0.017242431640625, -0.033721923828125, -0.02838134765625, -0.026031494140625, -0.03070068359375, -0.026702880859375, -0.024505615234375, -0.020721435546875, -0.009979248046875, 0.000396728515625, 0.00360107421875, 0.00531005859375, 0.008758544921875, 0.00689697265625, 0.0023193359375, -0.00164794921875, -0.005859375, -0.010040283203125, -0.008880615234375, -0.009857177734375, -0.015380859375, -0.01617431640625, -0.0098876953125, -0.0067138671875, -0.00927734375, -0.01025390625, -0.00933837890625, -0.00653076171875, -0.004913330078125, -0.0042724609375, -0.005645751953125, -0.007720947265625, -0.00628662109375, -0.0052490234375, -0.004425048828125, -0.004913330078125, -0.006072998046875, -0.007171630859375, -0.00775146484375, -0.0068359375, -0.0074462890625, -0.007843017578125, -0.00482177734375, -0.0008544921875, -0.0009765625, -0.00286865234375, -0.00311279296875, -0.00189208984375, -0.00115966796875, -0.001708984375, -0.001861572265625, -0.00164794921875, -0.001434326171875, -0.001983642578125, -0.002593994140625, -0.0035400390625, -0.00360107421875, -0.003692626953125, -0.00390625, -0.00384521484375, -0.00347900390625, -0.00225830078125, -0.002044677734375, -0.00213623046875, -0.001800537109375, -0.0015869140625, -0.001739501953125, -0.001983642578125, -0.00152587890625, -0.0015869140625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 0.0, 3.0517578125e-05, 0.0, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, 0.0, 0.0001220703125, -3.0517578125e-05, 9.1552734375e-05, -0.00018310546875, -9.1552734375e-05, -6.103515625e-05, 0.000518798828125, 9.1552734375e-05, 0.0001220703125, -0.00091552734375, 0.01153564453125, 0.049652099609375, 0.0743408203125, -0.0130615234375, -0.1636962890625, -0.13226318359375, 0.03582763671875, 0.1351318359375, 0.159820556640625, 0.13079833984375, 0.080535888671875, 0.06585693359375, 0.065155029296875, 0.0296630859375, -0.00628662109375, -0.020477294921875, -0.036956787109375, -0.05279541015625, -0.05926513671875, -0.05059814453125, -0.048553466796875, -0.042266845703125, -0.041290283203125, -0.028717041015625, 0.012298583984375, 0.021392822265625, 0.022857666015625, 0.0413818359375, 0.042083740234375, 0.02880859375, 0.028594970703125, 0.023284912109375, -0.004669189453125, -0.028961181640625, -0.0338134765625, -0.027130126953125, -0.027099609375, -0.02899169921875, -0.030059814453125, -0.025482177734375, -0.01202392578125, -0.0040283203125, -0.0001220703125, 0.002471923828125, 0.006988525390625, 0.0111083984375, 0.009765625, 0.003204345703125, -0.000274658203125, -0.004547119140625, -0.012054443359375, -0.013702392578125, -0.01348876953125, -0.0150146484375, -0.0152587890625, -0.01263427734375, -0.01007080078125, -0.010101318359375, -0.009185791015625, -0.006378173828125, -0.00439453125, -0.003509521484375, -0.004913330078125, -0.0064697265625, -0.005462646484375, -0.004150390625, -0.003936767578125, -0.004608154296875, -0.005096435546875, -0.006988525390625, -0.008026123046875, -0.0081787109375, -0.009368896484375, -0.008453369140625, -0.005157470703125, -0.00262451171875, -0.0028076171875, -0.0035400390625, -0.002960205078125, -0.001708984375, -0.000823974609375, -0.001220703125, -0.0018310546875, -0.001556396484375, -0.000823974609375, -0.001190185546875, -0.002471923828125, -0.0032958984375, -0.003448486328125, -0.003875732421875, -0.0040283203125, -0.004364013671875, -0.004425048828125, -0.00347900390625, -0.001953125, -0.00115966796875, -0.0015869140625, -0.001953125, -0.0020751953125, -0.001556396484375, -0.001251220703125, -0.001251220703125, -0.001617431640625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, 6.103515625e-05, 6.103515625e-05, 6.103515625e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, 6.103515625e-05, 0.0, 0.0, 3.0517578125e-05, 9.1552734375e-05, 6.103515625e-05, 6.103515625e-05, -0.0001220703125, -6.103515625e-05, -9.1552734375e-05, 0.000335693359375, 6.103515625e-05, 6.103515625e-05, -0.0003662109375, 0.007232666015625, 0.047698974609375, 0.08074951171875, -0.00201416015625, -0.15484619140625, -0.147064208984375, 0.016571044921875, 0.136810302734375, 0.1717529296875, 0.13604736328125, 0.0750732421875, 0.059783935546875, 0.06732177734375, 0.040069580078125, 0.001495361328125, -0.017822265625, -0.043304443359375, -0.064208984375, -0.066802978515625, -0.0565185546875, -0.05145263671875, -0.039276123046875, -0.033905029296875, -0.03277587890625, 0.009307861328125, 0.029083251953125, 0.023040771484375, 0.039520263671875, 0.044525146484375, 0.032958984375, 0.029998779296875, 0.025360107421875, 0.000152587890625, -0.026885986328125, -0.032318115234375, -0.026336669921875, -0.027313232421875, -0.029937744140625, -0.031097412109375, -0.029266357421875, -0.01580810546875, -0.004852294921875, -0.002471923828125, -0.0009765625, 0.004669189453125, 0.0106201171875, 0.010772705078125, 0.00634765625, 0.004791259765625, 0.002838134765625, -0.0047607421875, -0.0123291015625, -0.01739501953125, -0.017425537109375, -0.014892578125, -0.0146484375, -0.016143798828125, -0.015289306640625, -0.010711669921875, -0.00482177734375, -0.00238037109375, -0.003936767578125, -0.00518798828125, -0.003021240234375, -0.00201416015625, -0.003509521484375, -0.004058837890625, -0.003570556640625, -0.00506591796875, -0.006591796875, -0.007110595703125, -0.010009765625, -0.01092529296875, -0.007843017578125, -0.004364013671875, -0.003662109375, -0.004425048828125, -0.00494384765625, -0.00384521484375, -0.002105712890625, -0.00079345703125, -0.000457763671875, -0.001739501953125, -0.00164794921875, -0.000823974609375, -0.00042724609375, -0.00146484375, -0.003143310546875, -0.00390625, -0.003570556640625, -0.0030517578125, -0.00390625, -0.0048828125, -0.004364013671875, -0.0025634765625, -0.001251220703125, -0.0010986328125, -0.0015869140625, -0.0025634765625, -0.002044677734375, -0.000823974609375, -0.00054931640625, -0.00152587890625, -0.002838134765625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 0.0, 6.103515625e-05, 0.0, 3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, -6.103515625e-05, 6.103515625e-05, 9.1552734375e-05, 0.0, -6.103515625e-05, -9.1552734375e-05, -6.103515625e-05, 9.1552734375e-05, 0.000274658203125, -9.1552734375e-05, -0.000152587890625, 0.003631591796875, 0.04156494140625, 0.0858154296875, 0.016082763671875, -0.141510009765625, -0.162933349609375, -0.009521484375, 0.130615234375, 0.181610107421875, 0.147979736328125, 0.0771484375, 0.0556640625, 0.06707763671875, 0.043487548828125, 0.003021240234375, -0.0118408203125, -0.0338134765625, -0.06298828125, -0.074859619140625, -0.067626953125, -0.05841064453125, -0.0474853515625, -0.03118896484375, -0.02935791015625, -0.004119873046875, 0.031646728515625, 0.0333251953125, 0.038421630859375, 0.0426025390625, 0.033416748046875, 0.033721923828125, 0.02813720703125, 0.0064697265625, -0.020111083984375, -0.033050537109375, -0.0296630859375, -0.0230712890625, -0.02606201171875, -0.033905029296875, -0.032257080078125, -0.018096923828125, -0.0068359375, -0.006103515625, -0.0032958984375, 0.00262451171875, 0.008026123046875, 0.010467529296875, 0.00640869140625, 0.0048828125, 0.0062255859375, 0.001220703125, -0.004638671875, -0.012054443359375, -0.0185546875, -0.018524169921875, -0.0162353515625, -0.016845703125, -0.019134521484375, -0.016632080078125, -0.00872802734375, -0.002593994140625, -0.003570556640625, -0.003814697265625, -0.001129150390625, -9.1552734375e-05, -0.00103759765625, -0.002777099609375, -0.003326416015625, -0.0050048828125, -0.0062255859375, -0.008056640625, -0.010345458984375, -0.009521484375, -0.007293701171875, -0.005828857421875, -0.005462646484375, -0.005035400390625, -0.004638671875, -0.0042724609375, -0.003692626953125, -0.0020751953125, -0.00079345703125, -0.000762939453125, -0.00140380859375, -0.00115966796875, -0.000701904296875, -0.00128173828125, -0.002288818359375, -0.003631591796875, -0.003662109375, -0.00335693359375, -0.00335693359375, -0.004364013671875, -0.00433349609375, -0.002685546875, -0.001708984375, -0.00152587890625, -0.002410888671875, -0.00244140625, -0.001861572265625, -0.00128173828125, -0.0008544921875, -0.0013427734375, -0.002410888671875, -0.003326416015625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, -9.1552734375e-05, -6.103515625e-05, 0.0, 9.1552734375e-05, -6.103515625e-05, -6.103515625e-05, -0.00018310546875, -9.1552734375e-05, -0.0001220703125, 0.00030517578125, -0.000152587890625, 9.1552734375e-05, 0.001953125, 0.037689208984375, 0.09027099609375, 0.026885986328125, -0.136199951171875, -0.1732177734375, -0.025665283203125, 0.128875732421875, 0.193084716796875, 0.15850830078125, 0.078094482421875, 0.052978515625, 0.0672607421875, 0.047027587890625, 0.00054931640625, -0.016845703125, -0.03192138671875, -0.059295654296875, -0.07135009765625, -0.0697021484375, -0.06524658203125, -0.05859375, -0.036712646484375, -0.025665283203125, -0.01519775390625, 0.025390625, 0.04425048828125, 0.04425048828125, 0.04486083984375, 0.0328369140625, 0.032745361328125, 0.027618408203125, 0.01092529296875, -0.01129150390625, -0.033203125, -0.034698486328125, -0.022430419921875, -0.019927978515625, -0.031036376953125, -0.034881591796875, -0.020599365234375, -0.00616455078125, -0.006805419921875, -0.00616455078125, -0.000701904296875, 0.0057373046875, 0.00897216796875, 0.00555419921875, 0.004241943359375, 0.005828857421875, 0.00360107421875, -0.001251220703125, -0.006317138671875, -0.01251220703125, -0.01666259765625, -0.018096923828125, -0.019287109375, -0.020751953125, -0.019622802734375, -0.012725830078125, -0.008209228515625, -0.005401611328125, -0.001434326171875, 0.0001220703125, 0.0009765625, 0.0001220703125, -3.0517578125e-05, -0.00146484375, -0.0042724609375, -0.006927490234375, -0.0098876953125, -0.009857177734375, -0.007568359375, -0.00592041015625, -0.006805419921875, -0.0074462890625, -0.006072998046875, -0.0050048828125, -0.00469970703125, -0.004058837890625, -0.00286865234375, -0.001861572265625, -0.001373291015625, -0.0009765625, -0.0009765625, -0.00079345703125, -0.00128173828125, -0.002593994140625, -0.00347900390625, -0.00335693359375, -0.00311279296875, -0.0040283203125, -0.00457763671875, -0.003814697265625, -0.002471923828125, -0.001129150390625, -0.00140380859375, -0.00299072265625, -0.0037841796875, -0.002471923828125, -0.000946044921875, -0.00067138671875, -0.001556396484375, -0.00299072265625, -0.00335693359375, -0.002838134765625])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, -6.103515625e-05, -3.0517578125e-05, 0.0, 6.103515625e-05, -3.0517578125e-05, 0.0, -0.000213623046875, -3.0517578125e-05, -0.000213623046875, 0.00030517578125, -0.000244140625, 0.000274658203125, 0.003021240234375, 0.046783447265625, 0.098876953125, 0.009063720703125, -0.160186767578125, -0.17022705078125, -0.005950927734375, 0.152618408203125, 0.211761474609375, 0.15570068359375, 0.066009521484375, 0.052459716796875, 0.070556640625, 0.0416259765625, -0.008270263671875, -0.0245361328125, -0.040008544921875, -0.066162109375, -0.072906494140625, -0.06646728515625, -0.0631103515625, -0.0595703125, -0.03973388671875, -0.023284912109375, -0.020843505859375, 0.01434326171875, 0.049072265625, 0.05523681640625, 0.05096435546875, 0.032562255859375, 0.032135009765625, 0.025634765625, 0.008026123046875, -0.0103759765625, -0.031982421875, -0.038177490234375, -0.026641845703125, -0.016021728515625, -0.02447509765625, -0.03253173828125, -0.02166748046875, -0.0040283203125, -0.002716064453125, -0.0059814453125, -0.00189208984375, 0.003021240234375, 0.005615234375, 0.0032958984375, 0.003173828125, 0.0048828125, 0.00390625, -0.0003662109375, -0.006683349609375, -0.010833740234375, -0.011077880859375, -0.013275146484375, -0.019683837890625, -0.023040771484375, -0.021331787109375, -0.016571044921875, -0.009765625, -0.0052490234375, -0.0035400390625, -0.001251220703125, 0.00079345703125, 0.0028076171875, 0.002166748046875, -0.000152587890625, -0.002960205078125, -0.007904052734375, -0.009613037109375, -0.007598876953125, -0.00592041015625, -0.00677490234375, -0.007720947265625, -0.006744384765625, -0.005706787109375, -0.00665283203125, -0.006591796875, -0.004302978515625, -0.0025634765625, -0.001556396484375, -0.001312255859375, -0.001495361328125, -0.001251220703125, -0.00042724609375, -0.000640869140625, -0.001983642578125, -0.003631591796875, -0.00390625, -0.003692626953125, -0.004150390625, -0.0045166015625, -0.003936767578125, -0.002227783203125, -0.00079345703125, -0.000762939453125, -0.0020751953125, -0.003265380859375, -0.00311279296875, -0.00189208984375, -0.00091552734375, -0.00140380859375, -0.002716064453125, -0.003448486328125, -0.00311279296875, -0.003204345703125])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, 3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, 9.1552734375e-05, -3.0517578125e-05, -3.0517578125e-05, -0.000244140625, 0.0, -0.000335693359375, 0.00030517578125, -0.000213623046875, 0.000396728515625, 0.002044677734375, 0.0458984375, 0.106964111328125, 0.01593017578125, -0.16741943359375, -0.182647705078125, -0.01190185546875, 0.159759521484375, 0.22943115234375, 0.166412353515625, 0.06201171875, 0.050384521484375, 0.07550048828125, 0.0445556640625, -0.012786865234375, -0.031707763671875, -0.044525146484375, -0.07012939453125, -0.076812744140625, -0.0693359375, -0.063934326171875, -0.058135986328125, -0.040313720703125, -0.018646240234375, -0.01806640625, -0.002655029296875, 0.03839111328125, 0.061004638671875, 0.0582275390625, 0.035614013671875, 0.032806396484375, 0.02642822265625, 0.007537841796875, -0.00518798828125, -0.028961181640625, -0.04559326171875, -0.03399658203125, -0.01544189453125, -0.020416259765625, -0.02880859375, -0.020294189453125, -0.00537109375, -0.0010986328125, -0.000640869140625, 0.0009765625, -3.0517578125e-05, 0.002166748046875, 0.002532958984375, 0.0013427734375, 0.0030517578125, 0.003631591796875, -0.000152587890625, -0.006927490234375, -0.011810302734375, -0.010345458984375, -0.0106201171875, -0.016632080078125, -0.021026611328125, -0.0240478515625, -0.01824951171875, -0.00787353515625, -0.00518798828125, -0.0059814453125, -0.004913330078125, 0.00018310546875, 0.00323486328125, 0.00225830078125, 0.000579833984375, -0.0030517578125, -0.00634765625, -0.005859375, -0.005615234375, -0.007476806640625, -0.008026123046875, -0.00714111328125, -0.00640869140625, -0.006805419921875, -0.007568359375, -0.00714111328125, -0.005401611328125, -0.003326416015625, -0.001556396484375, -0.001190185546875, -0.001312255859375, -0.001068115234375, -0.000762939453125, -0.000640869140625, -0.00128173828125, -0.002716064453125, -0.003814697265625, -0.004791259765625, -0.005157470703125, -0.00518798828125, -0.004180908203125, -0.002471923828125, -0.001312255859375, -0.00146484375, -0.001861572265625, -0.001983642578125, -0.00189208984375, -0.001708984375, -0.002197265625, -0.002532958984375, -0.002593994140625, -0.00250244140625, -0.002777099609375, -0.00408935546875, -0.005126953125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, -3.0517578125e-05, -9.1552734375e-05, -6.103515625e-05, 9.1552734375e-05, 9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, 6.103515625e-05, 6.103515625e-05, 0.0, 3.0517578125e-05, -0.000213623046875, 9.1552734375e-05, -0.00030517578125, 0.000274658203125, -0.000274658203125, 0.000579833984375, 0.003692626953125, 0.059539794921875, 0.1177978515625, -0.010040283203125, -0.2017822265625, -0.178466796875, 0.019927978515625, 0.19366455078125, 0.2510986328125, 0.15911865234375, 0.044891357421875, 0.052398681640625, 0.08319091796875, 0.037567138671875, -0.025146484375, -0.040985107421875, -0.056488037109375, -0.079010009765625, -0.0802001953125, -0.071136474609375, -0.067718505859375, -0.0570068359375, -0.03515625, -0.0115966796875, -0.00872802734375, -0.00335693359375, 0.032806396484375, 0.058380126953125, 0.05975341796875, 0.038299560546875, 0.030364990234375, 0.023834228515625, 0.008026123046875, -0.00341796875, -0.027923583984375, -0.048126220703125, -0.043060302734375, -0.023193359375, -0.019439697265625, -0.023345947265625, -0.01702880859375, -0.00482177734375, 0.003204345703125, 0.005035400390625, 0.00543212890625, 0.003173828125, 0.000885009765625, -0.000335693359375, 0.0018310546875, 0.004180908203125, 0.0008544921875, -0.00482177734375, -0.009552001953125, -0.010955810546875, -0.010101318359375, -0.01177978515625, -0.018707275390625, -0.0250244140625, -0.020904541015625, -0.00933837890625, -0.004547119140625, -0.006683349609375, -0.007843017578125, -0.004058837890625, 0.0008544921875, 0.001708984375, -9.1552734375e-05, -0.002410888671875, -0.0020751953125, -0.001007080078125, -0.00299072265625, -0.006378173828125, -0.007598876953125, -0.00732421875, -0.006927490234375, -0.007537841796875, -0.008209228515625, -0.0084228515625, -0.007171630859375, -0.00518798828125, -0.003631591796875, -0.001953125, -0.00091552734375, -0.00079345703125, -0.00079345703125, 6.103515625e-05, 0.000213623046875, -0.001007080078125, -0.0028076171875, -0.004058837890625, -0.004241943359375, -0.005157470703125, -0.006134033203125, -0.005279541015625, -0.003143310546875, -0.00201416015625, -0.00213623046875, -0.002044677734375, -0.00189208984375, -0.00091552734375, -0.000274658203125, -0.00152587890625, -0.0028076171875, -0.003143310546875, -0.002899169921875, -0.00274658203125, -0.00347900390625, -0.004608154296875, -0.004150390625])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, 6.103515625e-05, 0.0, -9.1552734375e-05, 0.0, 3.0517578125e-05, 0.0001220703125, -9.1552734375e-05, 9.1552734375e-05, -0.000335693359375, 0.0001220703125, -0.0003662109375, 0.0003662109375, -0.000396728515625, 0.000762939453125, 0.0028076171875, 0.06011962890625, 0.129791259765625, -0.00433349609375, -0.21807861328125, -0.195343017578125, 0.021148681640625, 0.20855712890625, 0.272064208984375, 0.171051025390625, 0.0382080078125, 0.048248291015625, 0.090087890625, 0.040924072265625, -0.031829833984375, -0.047760009765625, -0.06304931640625, -0.08673095703125, -0.0838623046875, -0.07427978515625, -0.071136474609375, -0.05938720703125, -0.03515625, -0.008209228515625, -0.00054931640625, -0.002471923828125, 0.0262451171875, 0.056793212890625, 0.062530517578125, 0.039794921875, 0.027099609375, 0.0225830078125, 0.006622314453125, -0.00067138671875, -0.01885986328125, -0.047271728515625, -0.050018310546875, -0.030914306640625, -0.02435302734375, -0.024383544921875, -0.01531982421875, -0.004119873046875, 0.002288818359375, 0.008270263671875, 0.01239013671875, 0.00634765625, 0.001190185546875, 0.001983642578125, 0.00494384765625, 0.00311279296875, -0.001434326171875, -0.00537109375, -0.011505126953125, -0.012420654296875, -0.010711669921875, -0.0125732421875, -0.02374267578125, -0.028411865234375, -0.017913818359375, -0.006134033203125, -0.0028076171875, -0.00579833984375, -0.004638671875, -0.001373291015625, 0.000396728515625, -0.0006103515625, -0.00299072265625, -0.002655029296875, 0.001007080078125, 0.000518798828125, -0.004302978515625, -0.005950927734375, -0.00506591796875, -0.006256103515625, -0.0089111328125, -0.009490966796875, -0.0084228515625, -0.008209228515625, -0.00762939453125, -0.00543212890625, -0.00347900390625, -0.00238037109375, -0.001129150390625, -0.000213623046875, -3.0517578125e-05, 0.000274658203125, 0.0008544921875, -0.00030517578125, -0.002655029296875, -0.00360107421875, -0.004241943359375, -0.005096435546875, -0.00555419921875, -0.005340576171875, -0.0047607421875, -0.00390625, -0.00250244140625, -0.001953125, -0.00213623046875, -0.001495361328125, -0.000244140625, 0.0, -0.00128173828125, -0.002655029296875, -0.00335693359375, -0.003204345703125, -0.00341796875, -0.003662109375, -0.003204345703125, -0.003570556640625])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -9.1552734375e-05, 3.0517578125e-05, 6.103515625e-05, -0.0001220703125, -0.0001220703125, -3.0517578125e-05, 6.103515625e-05, 9.1552734375e-05, -0.0001220703125, -6.103515625e-05, -0.000396728515625, 9.1552734375e-05, -0.000457763671875, 0.000335693359375, -0.0006103515625, 0.00079345703125, 0.005035400390625, 0.078094482421875, 0.14166259765625, -0.039154052734375, -0.259033203125, -0.18780517578125, 0.063140869140625, 0.251495361328125, 0.292327880859375, 0.15533447265625, 0.0194091796875, 0.056396484375, 0.09844970703125, 0.028594970703125, -0.0487060546875, -0.05682373046875, -0.074737548828125, -0.098541259765625, -0.086334228515625, -0.076324462890625, -0.0760498046875, -0.059051513671875, -0.029876708984375, -0.00164794921875, 0.00689697265625, 0.003387451171875, 0.02667236328125, 0.05657958984375, 0.06304931640625, 0.04315185546875, 0.024810791015625, 0.01275634765625, 0.003753662109375, -0.00384521484375, -0.019073486328125, -0.0416259765625, -0.050048828125, -0.038818359375, -0.029632568359375, -0.02545166015625, -0.017059326171875, -0.0050048828125, 0.003662109375, 0.0098876953125, 0.01324462890625, 0.0111083984375, 0.00469970703125, 0.00701904296875, 0.00982666015625, 0.002410888671875, -0.00390625, -0.007598876953125, -0.010894775390625, -0.01226806640625, -0.014068603515625, -0.0220947265625, -0.029327392578125, -0.0242919921875, -0.013885498046875, -0.008819580078125, -0.0076904296875, -0.002197265625, 0.002960205078125, 0.003326416015625, 0.000335693359375, -0.003875732421875, -0.00335693359375, 0.001556396484375, 0.002410888671875, -0.003173828125, -0.006317138671875, -0.004547119140625, -0.003692626953125, -0.0069580078125, -0.01025390625, -0.011138916015625, -0.01031494140625, -0.00927734375, -0.00689697265625, -0.004608154296875, -0.003021240234375, -0.002655029296875, -0.0020751953125, -0.00054931640625, 0.00054931640625, 0.001434326171875, 0.00091552734375, -0.000823974609375, -0.002777099609375, -0.003692626953125, -0.0040283203125, -0.004791259765625, -0.0054931640625, -0.005584716796875, -0.0054931640625, -0.00531005859375, -0.004119873046875, -0.003143310546875, -0.00311279296875, -0.0020751953125, -0.00079345703125, -0.00042724609375, -0.00079345703125, -0.001800537109375, -0.002838134765625, -0.003143310546875, -0.00347900390625, -0.00396728515625, -0.0035400390625, -0.003326416015625, -0.00396728515625])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, 6.103515625e-05, 9.1552734375e-05, -6.103515625e-05, -0.0001220703125, 0.0, 3.0517578125e-05, 0.00018310546875, -6.103515625e-05, 3.0517578125e-05, -0.000396728515625, 0.000152587890625, -0.00048828125, 0.000457763671875, -0.000701904296875, 0.00091552734375, 0.003692626953125, 0.07659912109375, 0.1573486328125, -0.02642822265625, -0.277801513671875, -0.213592529296875, 0.060943603515625, 0.270416259765625, 0.3167724609375, 0.170501708984375, 0.011688232421875, 0.05157470703125, 0.10943603515625, 0.032501220703125, -0.0582275390625, -0.065399169921875, -0.0791015625, -0.1085205078125, -0.09246826171875, -0.0770263671875, -0.080352783203125, -0.06329345703125, -0.031463623046875, 0.001434326171875, 0.01434326171875, 0.00799560546875, 0.024688720703125, 0.052093505859375, 0.063720703125, 0.046417236328125, 0.029754638671875, 0.011932373046875, 0.00030517578125, -0.006378173828125, -0.02117919921875, -0.035858154296875, -0.0472412109375, -0.041473388671875, -0.03564453125, -0.0286865234375, -0.018463134765625, -0.00732421875, 0.001068115234375, 0.00750732421875, 0.01226806640625, 0.0107421875, 0.01202392578125, 0.0137939453125, 0.010467529296875, 0.002105712890625, -0.0015869140625, -0.00390625, -0.009735107421875, -0.01300048828125, -0.01898193359375, -0.02667236328125, -0.028076171875, -0.021331787109375, -0.017242431640625, -0.01348876953125, -0.007965087890625, -0.001495361328125, 0.00482177734375, 0.0048828125, 0.00091552734375, -0.001617431640625, 0.002655029296875, 0.00396728515625, -0.0006103515625, -0.004241943359375, -0.0048828125, -0.004669189453125, -0.005340576171875, -0.007171630859375, -0.009368896484375, -0.01129150390625, -0.01190185546875, -0.0103759765625, -0.007293701171875, -0.00396728515625, -0.002227783203125, -0.00189208984375, -0.001861572265625, -0.001495361328125, 0.000274658203125, 0.0018310546875, 0.001312255859375, -0.00054931640625, -0.002349853515625, -0.00341796875, -0.00408935546875, -0.003997802734375, -0.00457763671875, -0.005218505859375, -0.00579833984375, -0.0054931640625, -0.00482177734375, -0.0047607421875, -0.00396728515625, -0.0020751953125, -0.00103759765625, -0.0009765625, -0.0010986328125, -0.00140380859375, -0.001953125, -0.002105712890625, -0.00238037109375, -0.003662109375, -0.003936767578125, -0.00335693359375, -0.003173828125, -0.003082275390625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 9.1552734375e-05, -3.0517578125e-05, -0.000152587890625, 0.0, 3.0517578125e-05, 0.000213623046875, -0.0001220703125, 6.103515625e-05, -0.000518798828125, 0.0001220703125, -0.000518798828125, 0.000396728515625, -0.00067138671875, 0.00079345703125, 0.00238037109375, 0.072479248046875, 0.171844482421875, -0.005706787109375, -0.292022705078125, -0.246063232421875, 0.0498046875, 0.2880859375, 0.343780517578125, 0.19036865234375, 0.007415771484375, 0.043609619140625, 0.12005615234375, 0.03955078125, -0.068023681640625, -0.076263427734375, -0.08160400390625, -0.117431640625, -0.102752685546875, -0.078216552734375, -0.08258056640625, -0.06756591796875, -0.03424072265625, 0.000946044921875, 0.02239990234375, 0.01446533203125, 0.0250244140625, 0.047821044921875, 0.06158447265625, 0.04937744140625, 0.031158447265625, 0.01556396484375, -0.000152587890625, -0.00665283203125, -0.025115966796875, -0.0372314453125, -0.04296875, -0.043182373046875, -0.037750244140625, -0.031768798828125, -0.021209716796875, -0.00994873046875, 0.000640869140625, 0.00506591796875, 0.0062255859375, 0.008331298828125, 0.01849365234375, 0.019866943359375, 0.008453369140625, 0.00177001953125, 0.001007080078125, 0.000518798828125, -0.006500244140625, -0.014984130859375, -0.0224609375, -0.025970458984375, -0.025909423828125, -0.0230712890625, -0.019927978515625, -0.015380859375, -0.0084228515625, -0.00201416015625, 0.0035400390625, 0.003265380859375, 0.0010986328125, 0.003265380859375, 0.006134033203125, 0.004364013671875, 0.000579833984375, -0.002227783203125, -0.0054931640625, -0.007415771484375, -0.0064697265625, -0.006072998046875, -0.00921630859375, -0.0128173828125, -0.012725830078125, -0.0106201171875, -0.0074462890625, -0.00433349609375, -0.00225830078125, -0.00146484375, -0.001739501953125, -0.001617431640625, -0.000244140625, 0.001251220703125, 0.0006103515625, -0.000701904296875, -0.002166748046875, -0.00347900390625, -0.004058837890625, -0.004180908203125, -0.00433349609375, -0.0047607421875, -0.005340576171875, -0.00567626953125, -0.005767822265625, -0.005645751953125, -0.004638671875, -0.002685546875, -0.001617431640625, -0.0018310546875, -0.001708984375, -0.001708984375, -0.002227783203125, -0.002349853515625, -0.00189208984375, -0.0028076171875, -0.003509521484375, -0.003143310546875, -0.003326416015625, -0.003173828125, -0.002227783203125])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([0.00018310546875, 6.103515625e-05, -0.0008544921875, 0.0010986328125, -0.002197265625, 0.00323486328125, -0.004669189453125, 0.006317138671875, -0.001678466796875, 0.108673095703125, 0.144683837890625, 0.07232666015625, -0.251373291015625, -0.493560791015625, 0.07147216796875, 0.381744384765625, 0.468048095703125, 0.359619140625, -0.019866943359375, -0.07977294921875, 0.056427001953125, 0.055206298828125, -0.1002197265625, -0.133453369140625, -0.199127197265625, -0.142364501953125, -0.06939697265625, -0.105377197265625, -0.083587646484375, -0.0555419921875, -0.0040283203125, 0.02178955078125, 0.058990478515625, 0.083740234375, 0.0587158203125, 0.063995361328125, 0.065887451171875, 0.033172607421875, 0.003692626953125, -0.002471923828125, -0.01123046875, -0.00701904296875, -0.05084228515625, -0.075958251953125, -0.04779052734375, -0.04364013671875, -0.02410888671875, 0.005126953125, 0.00848388671875, 0.001983642578125, 0.020538330078125, 0.024749755859375, 0.01898193359375, 0.005157470703125, -0.00543212890625, 0.011566162109375, 0.019134521484375, 0.00482177734375, -0.00494384765625, 0.002685546875, -0.00408935546875, -0.017608642578125, -0.02105712890625, -0.027679443359375, -0.037933349609375, -0.045684814453125, -0.0404052734375, -0.026275634765625, -0.015716552734375, -0.009765625, -0.000732421875, 0.00494384765625, 0.002532958984375, 0.006195068359375, 0.007110595703125, 0.005584716796875, 0.0062255859375, 0.0032958984375, -0.005615234375, -0.009124755859375, -0.00634765625, -0.006683349609375, -0.00860595703125, -0.00982666015625, -0.010894775390625, -0.0137939453125, -0.011444091796875, -0.007568359375, -0.00543212890625, -0.005706787109375, -0.00482177734375, -0.002349853515625, 0.001007080078125, 0.005279541015625, 0.006744384765625, 0.00433349609375, -0.000396728515625, -0.001983642578125, -0.002777099609375, -0.00323486328125, -0.004302978515625, -0.00732421875, -0.008514404296875, -0.006988525390625, -0.005218505859375, -0.004058837890625, -0.004058837890625, -0.003753662109375, -0.00335693359375, -0.0037841796875, -0.003021240234375, -0.001983642578125, -0.002593994140625, -0.0025634765625, -0.001953125, -0.0018310546875, -0.000762939453125, -0.000732421875, -0.001739501953125, -0.001983642578125, -0.002227783203125, -0.0025634765625, -0.003143310546875, -0.0040283203125, -0.00335693359375, -0.001953125, -0.00091552734375, -0.001373291015625])
        IR_LEFT[len(IR_LEFT)-1].append([0.00048828125, -0.000244140625, 0.000823974609375, -0.001190185546875, 0.001220703125, -0.002044677734375, 0.002197265625, -0.002655029296875, 0.003509521484375, -0.003326416015625, 0.04803466796875, 0.132110595703125, 0.094573974609375, -0.0699462890625, -0.439056396484375, -0.23248291015625, 0.21099853515625, 0.40374755859375, 0.495147705078125, 0.181610107421875, -0.0589599609375, -0.029327392578125, 0.04443359375, -0.0162353515625, -0.0648193359375, -0.12786865234375, -0.161834716796875, -0.09326171875, -0.106719970703125, -0.089385986328125, -0.066070556640625, -0.051177978515625, -0.001556396484375, 0.03790283203125, 0.05926513671875, 0.053466796875, 0.057830810546875, 0.060821533203125, 0.07025146484375, 0.03997802734375, 0.010467529296875, -0.006591796875, -0.0203857421875, -0.039703369140625, -0.068572998046875, -0.051544189453125, -0.04144287109375, -0.024200439453125, -0.002105712890625, 0.004302978515625, -0.001861572265625, 0.007781982421875, 0.018798828125, 0.015228271484375, 0.01123046875, -0.004791259765625, 0.00244140625, 0.024505615234375, 0.02301025390625, 0.002166748046875, -0.005401611328125, -0.005035400390625, -0.01788330078125, -0.019744873046875, -0.020263671875, -0.033294677734375, -0.04217529296875, -0.038055419921875, -0.02337646484375, -0.015655517578125, -0.01422119140625, -0.005462646484375, 0.0068359375, 0.003021240234375, -0.004852294921875, -0.002532958984375, 0.002227783203125, 0.0037841796875, 0.004608154296875, 0.00048828125, -0.007537841796875, -0.007415771484375, -0.0054931640625, -0.007965087890625, -0.0108642578125, -0.010406494140625, -0.0108642578125, -0.011993408203125, -0.011383056640625, -0.007904052734375, -0.0047607421875, -0.003448486328125, -0.00079345703125, 0.001007080078125, 0.0032958984375, 0.005126953125, 0.0052490234375, 0.003204345703125, -0.000701904296875, -0.0023193359375, -0.003692626953125, -0.0057373046875, -0.0068359375, -0.006683349609375, -0.005950927734375, -0.0052490234375, -0.00384521484375, -0.005218505859375, -0.00628662109375, -0.004302978515625, -0.001953125, -0.000396728515625, -0.000457763671875, -0.002593994140625, -0.00469970703125, -0.00433349609375, -0.00201416015625, 0.0010986328125, 0.00140380859375, -0.001373291015625, -0.00372314453125, -0.003662109375, -0.00225830078125, -0.001373291015625, -0.002044677734375, -0.004150390625, -0.004669189453125, -0.002716064453125])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 0.000396728515625, -0.000213623046875, 0.000640869140625, -0.00091552734375, 0.000946044921875, -0.001708984375, 0.001800537109375, -0.00225830078125, 0.003082275390625, -0.002838134765625, 0.045623779296875, 0.11224365234375, 0.08489990234375, -0.064117431640625, -0.37298583984375, -0.20269775390625, 0.159942626953125, 0.34881591796875, 0.42755126953125, 0.17742919921875, -0.02044677734375, -0.006927490234375, 0.0472412109375, -0.0113525390625, -0.0562744140625, -0.108673095703125, -0.140716552734375, -0.0970458984375, -0.099212646484375, -0.078521728515625, -0.065277099609375, -0.0521240234375, -0.00323486328125, 0.030975341796875, 0.044830322265625, 0.047454833984375, 0.052581787109375, 0.05743408203125, 0.068328857421875, 0.039398193359375, 0.011566162109375, -0.00048828125, -0.012725830078125, -0.036651611328125, -0.05755615234375, -0.043487548828125, -0.037322998046875, -0.023895263671875, -0.008819580078125, -0.00323486328125, -0.0030517578125, 0.00567626953125, 0.0107421875, 0.00897216796875, 0.00701904296875, -0.00177001953125, 0.0072021484375, 0.025360107421875, 0.022552490234375, 0.00384521484375, -0.007354736328125, -0.010467529296875, -0.0133056640625, -0.01806640625, -0.025299072265625, -0.032684326171875, -0.035552978515625, -0.031219482421875, -0.0196533203125, -0.011016845703125, -0.011749267578125, -0.009796142578125, 0.000396728515625, 0.00286865234375, -0.00286865234375, -0.0067138671875, -0.003997802734375, 0.001678466796875, 0.0028076171875, -0.00018310546875, -0.0050048828125, -0.00714111328125, -0.007568359375, -0.007904052734375, -0.00958251953125, -0.012603759765625, -0.012451171875, -0.009490966796875, -0.008575439453125, -0.00726318359375, -0.004791259765625, -0.00189208984375, -9.1552734375e-05, 0.0010986328125, 0.0030517578125, 0.003692626953125, 0.00396728515625, 0.00262451171875, 0.000244140625, -0.00250244140625, -0.003692626953125, -0.004669189453125, -0.006927490234375, -0.007171630859375, -0.006591796875, -0.005706787109375, -0.004669189453125, -0.0045166015625, -0.004974365234375, -0.0040283203125, -0.002044677734375, -0.00115966796875, -0.000885009765625, -0.002471923828125, -0.00372314453125, -0.00360107421875, -0.00225830078125, 0.000457763671875, 0.000396728515625, -0.001556396484375, -0.0029296875, -0.00335693359375, -0.003143310546875, -0.002288818359375, -0.00189208984375, -0.00311279296875, -0.00433349609375])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, -6.103515625e-05, 0.000274658203125, -0.00018310546875, 0.000457763671875, -0.000762939453125, 0.000640869140625, -0.001373291015625, 0.00146484375, -0.001739501953125, 0.002349853515625, -0.002197265625, 0.039703369140625, 0.095123291015625, 0.078399658203125, -0.048980712890625, -0.314422607421875, -0.190277099609375, 0.11248779296875, 0.2923583984375, 0.37469482421875, 0.182342529296875, 0.011199951171875, 0.0115966796875, 0.046539306640625, -0.007476806640625, -0.044281005859375, -0.089569091796875, -0.125244140625, -0.093780517578125, -0.088714599609375, -0.07257080078125, -0.064849853515625, -0.0506591796875, -0.0072021484375, 0.021087646484375, 0.035064697265625, 0.042083740234375, 0.0484619140625, 0.05035400390625, 0.06085205078125, 0.04315185546875, 0.01983642578125, 0.0078125, -0.006195068359375, -0.0301513671875, -0.04986572265625, -0.041534423828125, -0.037445068359375, -0.0281982421875, -0.015350341796875, -0.00628662109375, -0.003814697265625, -0.0032958984375, 0.0028076171875, 0.0107421875, 0.00775146484375, 0.001007080078125, 0.0111083984375, 0.02496337890625, 0.020355224609375, 0.005615234375, -0.004974365234375, -0.013397216796875, -0.016357421875, -0.019256591796875, -0.0262451171875, -0.03033447265625, -0.0289306640625, -0.025665283203125, -0.0189208984375, -0.011322021484375, -0.00897216796875, -0.008941650390625, -0.00396728515625, 0.000946044921875, -0.00146484375, -0.005859375, -0.006622314453125, -0.003204345703125, 0.000762939453125, -0.001495361328125, -0.005462646484375, -0.00750732421875, -0.01025390625, -0.010223388671875, -0.00885009765625, -0.010162353515625, -0.011383056640625, -0.0089111328125, -0.0054931640625, -0.003875732421875, -0.003387451171875, -0.001800537109375, -0.000213623046875, 0.000762939453125, 0.001953125, 0.0028076171875, 0.003326416015625, 0.00225830078125, -0.0003662109375, -0.0030517578125, -0.003814697265625, -0.005218505859375, -0.007080078125, -0.007843017578125, -0.006805419921875, -0.00506591796875, -0.003936767578125, -0.003326416015625, -0.00396728515625, -0.0035400390625, -0.00244140625, -0.001556396484375, -0.001068115234375, -0.00238037109375, -0.003753662109375, -0.003173828125, -0.001678466796875, -0.000274658203125, -0.0003662109375, -0.00238037109375, -0.00347900390625, -0.00341796875, -0.0032958984375, -0.002532958984375, -0.002044677734375, -0.002197265625])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, -6.103515625e-05, 6.103515625e-05, 0.00018310546875, -0.0001220703125, 0.0003662109375, -0.000579833984375, 0.000518798828125, -0.001129150390625, 0.001129150390625, -0.0013427734375, 0.00164794921875, -0.001434326171875, 0.033599853515625, 0.080810546875, 0.073516845703125, -0.03277587890625, -0.26641845703125, -0.1832275390625, 0.073272705078125, 0.244720458984375, 0.3321533203125, 0.1829833984375, 0.03594970703125, 0.0260009765625, 0.043548583984375, -0.001983642578125, -0.032745361328125, -0.073089599609375, -0.1094970703125, -0.086273193359375, -0.07916259765625, -0.0687255859375, -0.061859130859375, -0.0484619140625, -0.01220703125, 0.013580322265625, 0.027130126953125, 0.03253173828125, 0.04034423828125, 0.0478515625, 0.06121826171875, 0.04901123046875, 0.02734375, 0.01495361328125, 0.00042724609375, -0.029205322265625, -0.05096435546875, -0.041259765625, -0.038543701171875, -0.03082275390625, -0.01806640625, -0.012298583984375, -0.01129150390625, -0.004791259765625, 0.00592041015625, 0.01025390625, 0.01019287109375, 0.005615234375, 0.010040283203125, 0.024200439453125, 0.0220947265625, 0.00341796875, -0.0087890625, -0.01318359375, -0.016387939453125, -0.02227783203125, -0.0274658203125, -0.0250244140625, -0.02276611328125, -0.02496337890625, -0.0198974609375, -0.010284423828125, -0.00653076171875, -0.00738525390625, -0.00518798828125, -0.00054931640625, -0.000335693359375, -0.003753662109375, -0.00701904296875, -0.008514404296875, -0.00372314453125, -0.002471923828125, -0.00775146484375, -0.01007080078125, -0.010833740234375, -0.010009765625, -0.00830078125, -0.007904052734375, -0.008148193359375, -0.006500244140625, -0.003875732421875, -0.002197265625, -0.001708984375, -0.00201416015625, -0.0009765625, 0.00042724609375, 0.00189208984375, 0.002777099609375, 0.00189208984375, 0.000335693359375, -0.002105712890625, -0.003631591796875, -0.00421142578125, -0.006072998046875, -0.00726318359375, -0.006866455078125, -0.005279541015625, -0.0037841796875, -0.002685546875, -0.002655029296875, -0.00335693359375, -0.002838134765625, -0.00274658203125, -0.0020751953125, -0.001373291015625, -0.002044677734375, -0.003265380859375, -0.0032958984375, -0.0018310546875, -0.0009765625, -0.001129150390625, -0.00311279296875, -0.0042724609375, -0.00335693359375, -0.002777099609375, -0.002288818359375, -0.001708984375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 0.0001220703125, -6.103515625e-05, 0.000274658203125, -0.000518798828125, 0.000457763671875, -0.00091552734375, 0.000885009765625, -0.001129150390625, 0.001312255859375, -0.001007080078125, 0.02813720703125, 0.069183349609375, 0.0692138671875, -0.0186767578125, -0.229217529296875, -0.177581787109375, 0.044036865234375, 0.207305908203125, 0.29534912109375, 0.178741455078125, 0.054779052734375, 0.035552978515625, 0.0416259765625, 0.004364013671875, -0.023406982421875, -0.059539794921875, -0.09381103515625, -0.07659912109375, -0.0723876953125, -0.063720703125, -0.056671142578125, -0.045684814453125, -0.01727294921875, 0.001373291015625, 0.017608642578125, 0.030303955078125, 0.041046142578125, 0.047943115234375, 0.0609130859375, 0.052947998046875, 0.031280517578125, 0.015655517578125, -0.000701904296875, -0.0323486328125, -0.05181884765625, -0.0400390625, -0.037261962890625, -0.035888671875, -0.026275634765625, -0.011383056640625, -0.008880615234375, -0.0052490234375, 0.008026123046875, 0.015625, 0.012451171875, 0.00299072265625, 0.01165771484375, 0.024383544921875, 0.0146484375, -0.002471923828125, -0.006866455078125, -0.01116943359375, -0.02020263671875, -0.024566650390625, -0.023345947265625, -0.021514892578125, -0.023040771484375, -0.023162841796875, -0.017608642578125, -0.0103759765625, -0.006195068359375, -0.0048828125, -0.003204345703125, -0.000274658203125, -0.000701904296875, -0.00494384765625, -0.00836181640625, -0.009521484375, -0.0086669921875, -0.00811767578125, -0.008880615234375, -0.009368896484375, -0.010223388671875, -0.010528564453125, -0.007904052734375, -0.0048828125, -0.004180908203125, -0.00421142578125, -0.004119873046875, -0.00250244140625, -0.000701904296875, -0.000640869140625, -0.000579833984375, -9.1552734375e-05, 0.000946044921875, 0.001220703125, -0.00048828125, -0.002288818359375, -0.00384521484375, -0.00482177734375, -0.005096435546875, -0.005157470703125, -0.005645751953125, -0.005828857421875, -0.004302978515625, -0.00238037109375, -0.001434326171875, -0.00250244140625, -0.003570556640625, -0.003265380859375, -0.002716064453125, -0.001708984375, -0.0013427734375, -0.002655029296875, -0.00445556640625, -0.004150390625, -0.002471923828125, -0.00146484375, -0.001922607421875, -0.003509521484375, -0.0045166015625, -0.003875732421875, -0.0023193359375, -0.001220703125])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, -6.103515625e-05, 3.0517578125e-05, 0.000152587890625, -3.0517578125e-05, 0.000244140625, -0.00030517578125, 0.000457763671875, -0.000732421875, 0.00079345703125, -0.001007080078125, 0.00128173828125, -0.000762939453125, 0.024658203125, 0.060577392578125, 0.065521240234375, -0.01055908203125, -0.20379638671875, -0.169647216796875, 0.02783203125, 0.182159423828125, 0.26336669921875, 0.169921875, 0.06640625, 0.041961669921875, 0.04058837890625, 0.00897216796875, -0.016754150390625, -0.0484619140625, -0.07708740234375, -0.066925048828125, -0.06585693359375, -0.055999755859375, -0.051727294921875, -0.049713134765625, -0.025604248046875, 0.000518798828125, 0.019927978515625, 0.030853271484375, 0.040313720703125, 0.046600341796875, 0.05743408203125, 0.048736572265625, 0.027496337890625, 0.01312255859375, -0.00299072265625, -0.0347900390625, -0.04925537109375, -0.039886474609375, -0.043487548828125, -0.035736083984375, -0.017791748046875, -0.01123046875, -0.011993408203125, 0.003204345703125, 0.015228271484375, 0.01385498046875, 0.01202392578125, 0.00311279296875, 0.005859375, 0.01788330078125, 0.012786865234375, -0.004150390625, -0.009735107421875, -0.01043701171875, -0.0191650390625, -0.023712158203125, -0.021270751953125, -0.02081298828125, -0.021331787109375, -0.020538330078125, -0.015838623046875, -0.00982666015625, -0.004852294921875, -0.001434326171875, -0.001068115234375, -0.001556396484375, -0.002777099609375, -0.005645751953125, -0.0098876953125, -0.0115966796875, -0.01141357421875, -0.01025390625, -0.009185791015625, -0.00982666015625, -0.009521484375, -0.00799560546875, -0.00531005859375, -0.00360107421875, -0.00335693359375, -0.00274658203125, -0.002777099609375, -0.00177001953125, -3.0517578125e-05, 0.00079345703125, 3.0517578125e-05, -0.001373291015625, -0.001220703125, -0.001190185546875, -0.002655029296875, -0.00439453125, -0.004974365234375, -0.00457763671875, -0.003631591796875, -0.00335693359375, -0.0045166015625, -0.00469970703125, -0.00262451171875, -0.001007080078125, -0.000885009765625, -0.0023193359375, -0.003509521484375, -0.002716064453125, -0.00201416015625, -0.00189208984375, -0.00238037109375, -0.003692626953125, -0.00494384765625, -0.004547119140625, -0.00299072265625, -0.00177001953125, -0.001800537109375, -0.00311279296875, -0.003662109375, -0.003326416015625, -0.002166748046875])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, 0.0, 6.103515625e-05, 0.0, 0.0, -3.0517578125e-05, 6.103515625e-05, -3.0517578125e-05, 0.0001220703125, -0.000213623046875, 0.000396728515625, -0.000701904296875, 0.00067138671875, -0.00091552734375, 0.001190185546875, -0.000457763671875, 0.02374267578125, 0.0548095703125, 0.062255859375, -0.012451171875, -0.191436767578125, -0.1558837890625, 0.02734375, 0.16986083984375, 0.234771728515625, 0.155029296875, 0.071075439453125, 0.045074462890625, 0.038848876953125, 0.01300048828125, -0.011627197265625, -0.040069580078125, -0.061431884765625, -0.056671142578125, -0.06121826171875, -0.05426025390625, -0.049530029296875, -0.045013427734375, -0.021575927734375, 0.00421142578125, 0.020904541015625, 0.02734375, 0.035247802734375, 0.0391845703125, 0.04669189453125, 0.04193115234375, 0.0245361328125, 0.009674072265625, -0.0062255859375, -0.0347900390625, -0.052093505859375, -0.0396728515625, -0.03277587890625, -0.02886962890625, -0.018768310546875, -0.012939453125, -0.00189208984375, 0.01043701171875, 0.0137939453125, 0.01300048828125, 0.00421142578125, -0.00445556640625, 0.005523681640625, 0.016876220703125, 0.006256103515625, -0.008056640625, -0.0076904296875, -0.008758544921875, -0.019134521484375, -0.02197265625, -0.019012451171875, -0.020965576171875, -0.020660400390625, -0.016937255859375, -0.012664794921875, -0.008514404296875, -0.003631591796875, -0.00018310546875, -0.000640869140625, -0.003509521484375, -0.00482177734375, -0.007568359375, -0.011932373046875, -0.011627197265625, -0.011138916015625, -0.0123291015625, -0.011474609375, -0.008087158203125, -0.005828857421875, -0.006256103515625, -0.005340576171875, -0.003509521484375, -0.002410888671875, -0.0013427734375, -0.000732421875, -0.00054931640625, -0.000244140625, 0.000152587890625, -0.001129150390625, -0.002899169921875, -0.0037841796875, -0.003997802734375, -0.00439453125, -0.0047607421875, -0.00396728515625, -0.0030517578125, -0.002593994140625, -0.00299072265625, -0.003448486328125, -0.003326416015625, -0.001739501953125, -0.00018310546875, -0.00030517578125, -0.00213623046875, -0.003448486328125, -0.0029296875, -0.002655029296875, -0.00286865234375, -0.00335693359375, -0.004425048828125, -0.00531005859375, -0.004913330078125, -0.003570556640625, -0.001983642578125, -0.001190185546875, -0.0018310546875, -0.002960205078125, -0.003570556640625])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -3.0517578125e-05, 0.0, -3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, -3.0517578125e-05, 3.0517578125e-05, 0.0, 6.103515625e-05, -0.0001220703125, 0.000274658203125, -0.0006103515625, 0.00048828125, -0.000701904296875, 0.001190185546875, 0.00018310546875, 0.02618408203125, 0.0521240234375, 0.059356689453125, -0.0303955078125, -0.1925048828125, -0.129608154296875, 0.045562744140625, 0.170745849609375, 0.2081298828125, 0.13446044921875, 0.06744384765625, 0.04473876953125, 0.038330078125, 0.016265869140625, -0.008087158203125, -0.03472900390625, -0.049652099609375, -0.05389404296875, -0.0570068359375, -0.04241943359375, -0.03961181640625, -0.03802490234375, -0.01971435546875, 0.0057373046875, 0.016754150390625, 0.0167236328125, 0.025115966796875, 0.031951904296875, 0.039642333984375, 0.034881591796875, 0.021484375, 0.00677490234375, -0.01666259765625, -0.0345458984375, -0.035919189453125, -0.031890869140625, -0.031890869140625, -0.025543212890625, -0.014892578125, -0.0089111328125, 0.00531005859375, 0.01361083984375, 0.00537109375, -0.000244140625, 0.001068115234375, 0.0, 0.003265380859375, 0.009552001953125, 0.002105712890625, -0.006072998046875, -0.005615234375, -0.009063720703125, -0.017791748046875, -0.02020263671875, -0.019683837890625, -0.02069091796875, -0.01702880859375, -0.012359619140625, -0.010406494140625, -0.00799560546875, -0.00323486328125, -0.000640869140625, -0.002166748046875, -0.00555419921875, -0.007415771484375, -0.009124755859375, -0.01141357421875, -0.012237548828125, -0.01220703125, -0.011627197265625, -0.009613037109375, -0.006622314453125, -0.0052490234375, -0.00531005859375, -0.0047607421875, -0.003021240234375, -0.001068115234375, 0.000335693359375, 0.00030517578125, -0.0009765625, -0.001800537109375, -0.001922607421875, -0.00299072265625, -0.004730224609375, -0.0057373046875, -0.005126953125, -0.00390625, -0.003509521484375, -0.0028076171875, -0.002288818359375, -0.002166748046875, -0.002593994140625, -0.00274658203125, -0.00201416015625, -0.0006103515625, 0.000335693359375, -0.000518798828125, -0.00262451171875, -0.00421142578125, -0.00396728515625, -0.0032958984375, -0.00323486328125, -0.003814697265625, -0.005218505859375, -0.00567626953125, -0.004852294921875, -0.00323486328125, -0.001556396484375, -0.000762939453125, -0.00152587890625, -0.002960205078125])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0, -6.103515625e-05, 6.103515625e-05, -9.1552734375e-05, 6.103515625e-05, -9.1552734375e-05, 0.0001220703125, -0.0001220703125, -0.0003662109375, 0.00018310546875, 0.0, 0.000335693359375, 0.002960205078125, 0.032073974609375, 0.0533447265625, 0.052093505859375, -0.072998046875, -0.196380615234375, -0.0819091796875, 0.083343505859375, 0.17816162109375, 0.177276611328125, 0.108673095703125, 0.05792236328125, 0.04541015625, 0.039031982421875, 0.01666259765625, -0.0096435546875, -0.036468505859375, -0.039154052734375, -0.04327392578125, -0.0455322265625, -0.033905029296875, -0.03509521484375, -0.0357666015625, -0.022125244140625, 0.002685546875, 0.007537841796875, 0.0068359375, 0.02001953125, 0.029327392578125, 0.032501220703125, 0.03216552734375, 0.013397216796875, -0.00506591796875, -0.005767822265625, -0.01763916015625, -0.03350830078125, -0.034912109375, -0.02520751953125, -0.01910400390625, -0.014373779296875, -0.0015869140625, 0.0042724609375, -0.00146484375, -0.00189208984375, 0.002288818359375, 0.001007080078125, -0.000518798828125, 0.0018310546875, 0.003753662109375, 0.000732421875, -0.001312255859375, -0.00311279296875, -0.0128173828125, -0.019439697265625, -0.018890380859375, -0.018280029296875, -0.017669677734375, -0.013092041015625, -0.009368896484375, -0.009552001953125, -0.00811767578125, -0.004608154296875, -0.001800537109375, -0.004180908203125, -0.007171630859375, -0.008636474609375, -0.010833740234375, -0.012298583984375, -0.010711669921875, -0.0086669921875, -0.01043701171875, -0.010009765625, -0.00616455078125, -0.004180908203125, -0.004119873046875, -0.00335693359375, -0.00164794921875, -0.00042724609375, 0.000213623046875, -0.00067138671875, -0.002716064453125, -0.004058837890625, -0.004364013671875, -0.004608154296875, -0.005218505859375, -0.005218505859375, -0.00439453125, -0.003082275390625, -0.00244140625, -0.001983642578125, -0.001953125, -0.002227783203125, -0.002349853515625, -0.001800537109375, -0.000823974609375, -0.0001220703125, -0.000274658203125, -0.001861572265625, -0.003753662109375, -0.004730224609375, -0.004119873046875, -0.003631591796875, -0.00384521484375, -0.004302978515625, -0.005126953125, -0.005340576171875, -0.0045166015625, -0.002960205078125, -0.001190185546875, -0.000640869140625, -0.0013427734375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0, -3.0517578125e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, 0.0001220703125, -6.103515625e-05, 0.00018310546875, -0.000152587890625, 0.000335693359375, -0.0006103515625, 0.0003662109375, -3.0517578125e-05, 0.000885009765625, -0.00128173828125, 0.01226806640625, 0.04119873046875, 0.059112548828125, 0.0194091796875, -0.1446533203125, -0.169830322265625, -0.00054931640625, 0.130401611328125, 0.175933837890625, 0.140045166015625, 0.082061767578125, 0.0484619140625, 0.049041748046875, 0.034393310546875, 0.008544921875, -0.010284423828125, -0.02764892578125, -0.030731201171875, -0.0418701171875, -0.038055419921875, -0.0325927734375, -0.038177490234375, -0.038726806640625, -0.023101806640625, 0.0009765625, 0.00140380859375, 0.003265380859375, 0.019256591796875, 0.03277587890625, 0.025177001953125, 0.01763916015625, 0.0203857421875, 0.009490966796875, -0.006072998046875, -0.01971435546875, -0.03143310546875, -0.032989501953125, -0.021331787109375, -0.01153564453125, -0.01519775390625, -0.01416015625, -0.0037841796875, 0.00213623046875, -0.0001220703125, 6.103515625e-05, 0.00164794921875, 0.001739501953125, 0.000579833984375, 0.000885009765625, 0.0050048828125, 0.0015869140625, -0.009796142578125, -0.01812744140625, -0.0177001953125, -0.01593017578125, -0.0157470703125, -0.014190673828125, -0.010009765625, -0.0089111328125, -0.010009765625, -0.00872802734375, -0.0054931640625, -0.00262451171875, -0.0052490234375, -0.00909423828125, -0.011749267578125, -0.01025390625, -0.007843017578125, -0.00738525390625, -0.009246826171875, -0.011322021484375, -0.008453369140625, -0.004608154296875, -0.00262451171875, -0.002227783203125, -0.0020751953125, -0.001617431640625, -0.001434326171875, -0.00103759765625, -0.003021240234375, -0.00531005859375, -0.005706787109375, -0.00457763671875, -0.00390625, -0.004425048828125, -0.00384521484375, -0.003082275390625, -0.001922607421875, -0.00177001953125, -0.001800537109375, -0.00152587890625, -0.001739501953125, -0.001678466796875, -0.001220703125, -0.000701904296875, -0.00067138671875, -0.001312255859375, -0.002655029296875, -0.00433349609375, -0.004852294921875, -0.004241943359375, -0.0035400390625, -0.003173828125, -0.003997802734375, -0.00506591796875, -0.004791259765625, -0.00372314453125, -0.00213623046875, -0.000732421875, -0.000274658203125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, -3.0517578125e-05, -9.1552734375e-05, 9.1552734375e-05, -9.1552734375e-05, 6.103515625e-05, -0.0001220703125, 6.103515625e-05, -9.1552734375e-05, -9.1552734375e-05, 0.000457763671875, 0.00030517578125, -0.00054931640625, 0.002960205078125, 0.031158447265625, 0.053741455078125, 0.049468994140625, -0.081329345703125, -0.191192626953125, -0.0634765625, 0.093292236328125, 0.159423828125, 0.15240478515625, 0.102447509765625, 0.05816650390625, 0.04559326171875, 0.046722412109375, 0.02386474609375, 0.00494384765625, -0.011383056640625, -0.028167724609375, -0.04010009765625, -0.04229736328125, -0.034820556640625, -0.03973388671875, -0.046356201171875, -0.03466796875, -0.01055908203125, -0.002227783203125, -0.002655029296875, 0.013427734375, 0.0240478515625, 0.016571044921875, 0.030670166015625, 0.037750244140625, 0.01702880859375, 0.00042724609375, -0.0087890625, -0.02459716796875, -0.035430908203125, -0.021575927734375, -0.016265869140625, -0.0289306640625, -0.02630615234375, -0.00531005859375, 0.002105712890625, -0.000701904296875, 0.001129150390625, 0.001678466796875, 0.002777099609375, 0.0050048828125, 0.0035400390625, 0.0009765625, 0.00103759765625, -0.003936767578125, -0.014373779296875, -0.01995849609375, -0.015716552734375, -0.011810302734375, -0.01312255859375, -0.012359619140625, -0.009368896484375, -0.009979248046875, -0.011627197265625, -0.0076904296875, -0.004302978515625, -0.005584716796875, -0.008636474609375, -0.009918212890625, -0.008575439453125, -0.006927490234375, -0.00616455078125, -0.0087890625, -0.010711669921875, -0.00860595703125, -0.004730224609375, -0.002685546875, -0.002105712890625, -0.00213623046875, -0.0029296875, -0.003204345703125, -0.00323486328125, -0.0042724609375, -0.005828857421875, -0.00567626953125, -0.004150390625, -0.003692626953125, -0.003814697265625, -0.002960205078125, -0.001983642578125, -0.001983642578125, -0.0023193359375, -0.001556396484375, -0.00091552734375, -0.0013427734375, -0.001922607421875, -0.00213623046875, -0.001251220703125, -0.001068115234375, -0.001495361328125, -0.002471923828125, -0.004180908203125, -0.0048828125, -0.004486083984375, -0.00311279296875, -0.002685546875, -0.003143310546875, -0.00396728515625, -0.0047607421875, -0.004241943359375, -0.003082275390625, -0.00103759765625, -0.00042724609375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 3.0517578125e-05, 3.0517578125e-05, 0.0, 3.0517578125e-05, -6.103515625e-05, 9.1552734375e-05, 0.0, 6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, 3.0517578125e-05, 0.000640869140625, -3.0517578125e-05, -9.1552734375e-05, 0.000823974609375, 0.027130126953125, 0.053009033203125, 0.055389404296875, -0.060272216796875, -0.189605712890625, -0.085845947265625, 0.077880859375, 0.1492919921875, 0.154998779296875, 0.115447998046875, 0.06671142578125, 0.04925537109375, 0.0487060546875, 0.02685546875, 0.008636474609375, -0.008087158203125, -0.023712158203125, -0.041656494140625, -0.0482177734375, -0.040435791015625, -0.043212890625, -0.0467529296875, -0.03851318359375, -0.0113525390625, -0.00384521484375, -0.003509521484375, 0.010498046875, 0.010284423828125, 0.02484130859375, 0.045806884765625, 0.035888671875, 0.020416259765625, 0.009918212890625, -0.009521484375, -0.0260009765625, -0.02294921875, -0.023468017578125, -0.033721923828125, -0.035858154296875, -0.022796630859375, -0.0087890625, -0.003662109375, 0.00054931640625, 0.002349853515625, 0.004791259765625, 0.00537109375, 0.007904052734375, 0.008270263671875, 0.00018310546875, -0.005523681640625, -0.002410888671875, -0.0089111328125, -0.0203857421875, -0.01715087890625, -0.01129150390625, -0.010345458984375, -0.011749267578125, -0.011444091796875, -0.011444091796875, -0.011077880859375, -0.008087158203125, -0.00665283203125, -0.007476806640625, -0.007843017578125, -0.006317138671875, -0.00665283203125, -0.007080078125, -0.006927490234375, -0.00823974609375, -0.00848388671875, -0.006561279296875, -0.00360107421875, -0.00299072265625, -0.00372314453125, -0.003509521484375, -0.003753662109375, -0.004608154296875, -0.005340576171875, -0.00579833984375, -0.00518798828125, -0.004180908203125, -0.00390625, -0.003692626953125, -0.00299072265625, -0.00177001953125, -0.00128173828125, -0.00152587890625, -0.002105712890625, -0.001495361328125, -0.000762939453125, -0.001373291015625, -0.0020751953125, -0.002288818359375, -0.001678466796875, -0.0015869140625, -0.00189208984375, -0.002471923828125, -0.00384521484375, -0.0045166015625, -0.003875732421875, -0.002716064453125, -0.002044677734375, -0.001983642578125, -0.0029296875, -0.004547119140625, -0.004638671875, -0.00311279296875, -0.0013427734375, -0.00067138671875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 0.0, -3.0517578125e-05, 9.1552734375e-05, -3.0517578125e-05, 0.000152587890625, -0.00018310546875, -6.103515625e-05, -0.000244140625, 0.000213623046875, 0.000579833984375, -3.0517578125e-05, -0.0006103515625, 0.00262451171875, 0.031158447265625, 0.058624267578125, 0.050994873046875, -0.087249755859375, -0.1943359375, -0.061767578125, 0.09466552734375, 0.15325927734375, 0.15155029296875, 0.114898681640625, 0.07232666015625, 0.0552978515625, 0.048675537109375, 0.015625, -0.00445556640625, -0.01171875, -0.028045654296875, -0.04547119140625, -0.0496826171875, -0.047821044921875, -0.05035400390625, -0.045562744140625, -0.027191162109375, -0.00762939453125, -0.001007080078125, 0.00244140625, -0.0037841796875, 0.01611328125, 0.047271728515625, 0.04144287109375, 0.0286865234375, 0.02386474609375, 0.00732421875, -0.016754150390625, -0.018096923828125, -0.019775390625, -0.035797119140625, -0.043304443359375, -0.030303955078125, -0.016143798828125, -0.013946533203125, -0.00677490234375, -0.0018310546875, 0.004638671875, 0.010467529296875, 0.009246826171875, 0.0068359375, 0.0069580078125, 0.003387451171875, -0.003875732421875, -0.00714111328125, -0.011962890625, -0.016387939453125, -0.017364501953125, -0.01287841796875, -0.009429931640625, -0.0108642578125, -0.013031005859375, -0.012664794921875, -0.009979248046875, -0.00872802734375, -0.007843017578125, -0.007293701171875, -0.00677490234375, -0.006134033203125, -0.004974365234375, -0.006866455078125, -0.008941650390625, -0.00677490234375, -0.005035400390625, -0.00384521484375, -0.003204345703125, -0.003997802734375, -0.0054931640625, -0.006103515625, -0.0057373046875, -0.006591796875, -0.00665283203125, -0.005035400390625, -0.003814697265625, -0.00433349609375, -0.00421142578125, -0.0032958984375, -0.001953125, -0.001129150390625, -0.001495361328125, -0.0015869140625, -0.0013427734375, -0.001251220703125, -0.001739501953125, -0.0018310546875, -0.002227783203125, -0.00262451171875, -0.002471923828125, -0.00213623046875, -0.001953125, -0.002655029296875, -0.003692626953125, -0.00439453125, -0.003692626953125, -0.0020751953125, -0.00091552734375, -0.001312255859375, -0.00299072265625, -0.004547119140625, -0.004638671875, -0.00286865234375, -0.00128173828125, -0.001251220703125])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, -9.1552734375e-05, -6.103515625e-05, 0.0, 3.0517578125e-05, -3.0517578125e-05, 0.0, 0.0, 9.1552734375e-05, -6.103515625e-05, 0.000152587890625, -0.000213623046875, 0.0001220703125, -0.00048828125, 0.00067138671875, -6.103515625e-05, 0.0006103515625, -0.00146484375, 0.010894775390625, 0.044952392578125, 0.07000732421875, 0.013031005859375, -0.160736083984375, -0.172088623046875, 0.01446533203125, 0.13665771484375, 0.16162109375, 0.140838623046875, 0.09832763671875, 0.06475830078125, 0.064208984375, 0.03997802734375, -0.000885009765625, -0.016510009765625, -0.029541015625, -0.040863037109375, -0.052764892578125, -0.0509033203125, -0.050201416015625, -0.054901123046875, -0.03997802734375, -0.0108642578125, 0.00469970703125, 0.004486083984375, -0.006072998046875, 0.00408935546875, 0.0428466796875, 0.046600341796875, 0.033843994140625, 0.02685546875, 0.01324462890625, -0.005859375, -0.011260986328125, -0.014862060546875, -0.03363037109375, -0.046051025390625, -0.037841796875, -0.017578125, -0.014495849609375, -0.0147705078125, -0.01007080078125, -0.0010986328125, 0.01141357421875, 0.0130615234375, 0.0081787109375, 0.00482177734375, 0.0052490234375, 0.005615234375, -9.1552734375e-05, -0.010284423828125, -0.01507568359375, -0.016876220703125, -0.015899658203125, -0.0111083984375, -0.01141357421875, -0.013427734375, -0.01312255859375, -0.011322021484375, -0.00982666015625, -0.00860595703125, -0.00653076171875, -0.005279541015625, -0.006591796875, -0.006805419921875, -0.006500244140625, -0.006622314453125, -0.005584716796875, -0.004425048828125, -0.002471923828125, -0.002777099609375, -0.003997802734375, -0.005401611328125, -0.006866455078125, -0.00823974609375, -0.008697509765625, -0.00732421875, -0.00482177734375, -0.003204345703125, -0.004119873046875, -0.004608154296875, -0.003662109375, -0.001861572265625, -0.001068115234375, -0.001373291015625, -0.00164794921875, -0.00152587890625, -0.001007080078125, -0.00115966796875, -0.0018310546875, -0.00225830078125, -0.002685546875, -0.00341796875, -0.002777099609375, -0.001739501953125, -0.0015869140625, -0.002349853515625, -0.0035400390625, -0.003753662109375, -0.002838134765625, -0.0009765625, -0.00048828125, -0.001739501953125, -0.00347900390625, -0.004364013671875, -0.003570556640625, -0.001800537109375, -0.000885009765625, -0.00244140625])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 0.0, -6.103515625e-05, 0.0, 3.0517578125e-05, 0.0, -9.1552734375e-05, 9.1552734375e-05, -3.0517578125e-05, 9.1552734375e-05, -0.0001220703125, 3.0517578125e-05, -0.000244140625, 0.0, 0.0003662109375, 9.1552734375e-05, -6.103515625e-05, 0.002044677734375, 0.0318603515625, 0.070159912109375, 0.05560302734375, -0.103302001953125, -0.21270751953125, -0.060516357421875, 0.1168212890625, 0.170074462890625, 0.159576416015625, 0.113525390625, 0.065948486328125, 0.064483642578125, 0.0587158203125, 0.0150146484375, -0.01080322265625, -0.028656005859375, -0.04901123046875, -0.06396484375, -0.0595703125, -0.05157470703125, -0.05572509765625, -0.045928955078125, -0.020355224609375, 0.002960205078125, 0.013275146484375, 0.0035400390625, -0.003997802734375, 0.03765869140625, 0.05401611328125, 0.03363037109375, 0.029388427734375, 0.0155029296875, -0.004547119140625, -0.00732421875, -0.0103759765625, -0.030364990234375, -0.045440673828125, -0.0418701171875, -0.022064208984375, -0.0130615234375, -0.012939453125, -0.013885498046875, -0.009246826171875, 0.008819580078125, 0.015289306640625, 0.008148193359375, 0.003814697265625, 0.003692626953125, 0.0050048828125, 0.0050048828125, -0.002197265625, -0.009674072265625, -0.015472412109375, -0.01763916015625, -0.012969970703125, -0.012939453125, -0.015167236328125, -0.0145263671875, -0.0135498046875, -0.011566162109375, -0.008087158203125, -0.00537109375, -0.005126953125, -0.00555419921875, -0.007049560546875, -0.008819580078125, -0.00665283203125, -0.00335693359375, -0.001739501953125, -0.002227783203125, -0.003387451171875, -0.003814697265625, -0.0054931640625, -0.0068359375, -0.00946044921875, -0.01055908203125, -0.00750732421875, -0.0047607421875, -0.0045166015625, -0.00506591796875, -0.00433349609375, -0.00299072265625, -0.001922607421875, -0.001434326171875, -0.0013427734375, -0.001556396484375, -0.00177001953125, -0.00177001953125, -0.001708984375, -0.001739501953125, -0.00177001953125, -0.0030517578125, -0.003997802734375, -0.0032958984375, -0.002227783203125, -0.0015869140625, -0.00177001953125, -0.00213623046875, -0.002838134765625, -0.002471923828125, -0.001434326171875, -0.001251220703125, -0.001739501953125, -0.003173828125, -0.004241943359375, -0.003448486328125, -0.00177001953125, -0.001129150390625, -0.002166748046875, -0.00408935546875])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -6.103515625e-05, -3.0517578125e-05, -3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, 3.0517578125e-05, 6.103515625e-05, 3.0517578125e-05, 0.0, -0.0001220703125, -6.103515625e-05, -0.0003662109375, 0.0003662109375, -0.00018310546875, 0.000457763671875, -0.00030517578125, 0.023345947265625, 0.0703125, 0.0736083984375, -0.072174072265625, -0.2230224609375, -0.10699462890625, 0.102203369140625, 0.1822509765625, 0.175872802734375, 0.123687744140625, 0.064971923828125, 0.0599365234375, 0.062591552734375, 0.0216064453125, -0.006805419921875, -0.020904541015625, -0.04644775390625, -0.0689697265625, -0.0721435546875, -0.06500244140625, -0.062469482421875, -0.049957275390625, -0.02313232421875, 0.002655029296875, 0.014678955078125, 0.01177978515625, -0.001251220703125, 0.0350341796875, 0.061187744140625, 0.03607177734375, 0.02984619140625, 0.015716552734375, -0.00592041015625, -0.00750732421875, -0.00872802734375, -0.0281982421875, -0.0462646484375, -0.044342041015625, -0.0242919921875, -0.010223388671875, -0.012603759765625, -0.013641357421875, -0.01043701171875, 0.005279541015625, 0.01617431640625, 0.008880615234375, 0.003082275390625, 0.001251220703125, 0.002471923828125, 0.00299072265625, -0.001190185546875, -0.00384521484375, -0.0093994140625, -0.01416015625, -0.01177978515625, -0.01385498046875, -0.01873779296875, -0.017242431640625, -0.014739990234375, -0.0142822265625, -0.01092529296875, -0.004608154296875, -0.001373291015625, -0.0047607421875, -0.01019287109375, -0.0079345703125, -0.004638671875, -0.003570556640625, -0.000946044921875, -0.0009765625, -0.0030517578125, -0.005340576171875, -0.0052490234375, -0.0074462890625, -0.011077880859375, -0.009765625, -0.006103515625, -0.0052490234375, -0.00640869140625, -0.0059814453125, -0.005279541015625, -0.00311279296875, -0.00140380859375, -0.0013427734375, -0.001312255859375, -0.001861572265625, -0.00146484375, -0.001922607421875, -0.00286865234375, -0.002685546875, -0.0025634765625, -0.0032958984375, -0.004119873046875, -0.0035400390625, -0.002349853515625, -0.001861572265625, -0.00201416015625, -0.002166748046875, -0.00201416015625, -0.001068115234375, -0.0006103515625, -0.0013427734375, -0.00250244140625, -0.00384521484375, -0.004730224609375, -0.003875732421875, -0.001983642578125, -0.001068115234375, -0.0018310546875, -0.0037841796875, -0.004791259765625])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -3.0517578125e-05, -3.0517578125e-05, 9.1552734375e-05, 3.0517578125e-05, 9.1552734375e-05, -0.0001220703125, -3.0517578125e-05, -0.000335693359375, 0.000274658203125, -0.000274658203125, 0.000579833984375, -0.0006103515625, 0.0201416015625, 0.073760986328125, 0.08380126953125, -0.066009521484375, -0.23345947265625, -0.12664794921875, 0.101654052734375, 0.19830322265625, 0.1920166015625, 0.128570556640625, 0.0606689453125, 0.0576171875, 0.064117431640625, 0.020294189453125, -0.011199951171875, -0.021392822265625, -0.0462646484375, -0.068267822265625, -0.072662353515625, -0.069915771484375, -0.07208251953125, -0.0625, -0.0294189453125, 0.004241943359375, 0.0146484375, 0.02008056640625, 0.007080078125, 0.027252197265625, 0.067626953125, 0.04791259765625, 0.028289794921875, 0.0135498046875, -0.0052490234375, -0.009033203125, -0.014556884765625, -0.026824951171875, -0.042449951171875, -0.0484619140625, -0.03167724609375, -0.00762939453125, -0.005218505859375, -0.01287841796875, -0.011993408203125, 0.005889892578125, 0.01812744140625, 0.009490966796875, 0.00372314453125, 0.001434326171875, -0.0006103515625, -0.000701904296875, -0.00225830078125, -0.00616455078125, -0.008026123046875, -0.00762939453125, -0.008087158203125, -0.0125732421875, -0.01788330078125, -0.01812744140625, -0.0186767578125, -0.0172119140625, -0.01190185546875, -0.00543212890625, -0.001953125, -0.00445556640625, -0.00732421875, -0.006378173828125, -0.004669189453125, -0.00189208984375, 0.000274658203125, -0.001617431640625, -0.004180908203125, -0.0047607421875, -0.0064697265625, -0.0096435546875, -0.009918212890625, -0.007171630859375, -0.006011962890625, -0.006988525390625, -0.00640869140625, -0.005523681640625, -0.00506591796875, -0.004241943359375, -0.00262451171875, -0.00146484375, -0.000823974609375, -0.000274658203125, -0.001434326171875, -0.00262451171875, -0.0028076171875, -0.00274658203125, -0.00335693359375, -0.004638671875, -0.004852294921875, -0.003814697265625, -0.0023193359375, -0.001556396484375, -0.001708984375, -0.002410888671875, -0.002166748046875, -0.0003662109375, 0.000457763671875, -0.000152587890625, -0.001861572265625, -0.00408935546875, -0.005096435546875, -0.00433349609375, -0.002960205078125, -0.0020751953125, -0.0018310546875, -0.002593994140625, -0.004119873046875, -0.004913330078125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.0001220703125, -6.103515625e-05, -9.1552734375e-05, 0.0, 9.1552734375e-05, 9.1552734375e-05, 6.103515625e-05, -0.000152587890625, 0.0, -0.000335693359375, 0.000244140625, -0.000244140625, 0.000579833984375, -0.000457763671875, 0.02203369140625, 0.0843505859375, 0.088409423828125, -0.0858154296875, -0.25274658203125, -0.119293212890625, 0.127777099609375, 0.22222900390625, 0.201690673828125, 0.1212158203125, 0.052276611328125, 0.05975341796875, 0.064605712890625, 0.013214111328125, -0.021209716796875, -0.02850341796875, -0.05157470703125, -0.07421875, -0.072601318359375, -0.068023681640625, -0.0745849609375, -0.06439208984375, -0.03314208984375, -0.000946044921875, 0.0111083984375, 0.025360107421875, 0.01812744140625, 0.024749755859375, 0.06805419921875, 0.05615234375, 0.0284423828125, 0.01458740234375, -0.003936767578125, -0.01177978515625, -0.019622802734375, -0.029541015625, -0.04193115234375, -0.047576904296875, -0.036285400390625, -0.011993408203125, -0.00140380859375, -0.008148193359375, -0.009124755859375, 0.00567626953125, 0.019287109375, 0.012603759765625, 0.005462646484375, 0.00115966796875, -0.0023193359375, -0.002227783203125, -0.002899169921875, -0.008331298828125, -0.010467529296875, -0.007598876953125, -0.007293701171875, -0.01025390625, -0.015533447265625, -0.01605224609375, -0.018157958984375, -0.020172119140625, -0.01434326171875, -0.00518798828125, -0.003082275390625, -0.006317138671875, -0.005401611328125, -0.003143310546875, -0.00164794921875, -0.000518798828125, -0.000213623046875, -0.001983642578125, -0.004425048828125, -0.005706787109375, -0.008575439453125, -0.00946044921875, -0.007049560546875, -0.005859375, -0.007293701171875, -0.008270263671875, -0.00628662109375, -0.0042724609375, -0.0045166015625, -0.004486083984375, -0.00323486328125, -0.002593994140625, -0.001190185546875, 0.00018310546875, -0.00054931640625, -0.0023193359375, -0.0028076171875, -0.002777099609375, -0.003265380859375, -0.004364013671875, -0.005462646484375, -0.005157470703125, -0.0032958984375, -0.001312255859375, -0.00152587890625, -0.00244140625, -0.00152587890625, 3.0517578125e-05, 0.00042724609375, 0.00018310546875, -0.0009765625, -0.003021240234375, -0.00445556640625, -0.00445556640625, -0.003692626953125, -0.002777099609375, -0.002410888671875, -0.003021240234375, -0.003631591796875, -0.0037841796875, -0.00311279296875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, -0.0001220703125, -9.1552734375e-05, -3.0517578125e-05, 6.103515625e-05, 0.0, 3.0517578125e-05, -0.000152587890625, -3.0517578125e-05, -0.000335693359375, 0.0001220703125, -0.0003662109375, 0.000518798828125, -0.000396728515625, 0.024932861328125, 0.0966796875, 0.091796875, -0.110931396484375, -0.275054931640625, -0.110260009765625, 0.157012939453125, 0.24969482421875, 0.21136474609375, 0.112152099609375, 0.04486083984375, 0.064849853515625, 0.06640625, 0.003326416015625, -0.03277587890625, -0.037628173828125, -0.05908203125, -0.079803466796875, -0.0745849609375, -0.0687255859375, -0.076324462890625, -0.062652587890625, -0.030548095703125, 0.0008544921875, 0.0076904296875, 0.0208740234375, 0.0281982421875, 0.024078369140625, 0.0557861328125, 0.064544677734375, 0.0364990234375, 0.012451171875, -0.002166748046875, -0.009033203125, -0.0260009765625, -0.036102294921875, -0.038726806640625, -0.04833984375, -0.043731689453125, -0.016357421875, 0.0015869140625, -0.005706787109375, -0.00677490234375, 0.00726318359375, 0.01971435546875, 0.01654052734375, 0.0103759765625, 0.00244140625, -0.00628662109375, -0.003631591796875, -0.0010986328125, -0.007232666015625, -0.01177978515625, -0.010986328125, -0.011993408203125, -0.013946533203125, -0.0135498046875, -0.0135498046875, -0.01861572265625, -0.020477294921875, -0.01348876953125, -0.006683349609375, -0.003814697265625, -0.003021240234375, -0.005096435546875, -0.00439453125, 0.000732421875, 0.003692626953125, 0.000762939453125, -0.004180908203125, -0.006439208984375, -0.0076904296875, -0.00830078125, -0.006988525390625, -0.007171630859375, -0.008819580078125, -0.0086669921875, -0.0069580078125, -0.005401611328125, -0.0057373046875, -0.00518798828125, -0.003662109375, -0.00286865234375, -0.002532958984375, -0.001190185546875, -0.000762939453125, -0.001983642578125, -0.002197265625, -0.001800537109375, -0.00213623046875, -0.003662109375, -0.005035400390625, -0.00567626953125, -0.005615234375, -0.004150390625, -0.002899169921875, -0.002655029296875, -0.0023193359375, -0.00164794921875, -0.00054931640625, 0.00042724609375, 0.0003662109375, -0.001190185546875, -0.002960205078125, -0.0037841796875, -0.00384521484375, -0.00360107421875, -0.003082275390625, -0.003204345703125, -0.003936767578125, -0.004364013671875, -0.003814697265625, -0.00238037109375, -0.001312255859375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -9.1552734375e-05, 3.0517578125e-05, 0.000152587890625, 9.1552734375e-05, 3.0517578125e-05, -0.000213623046875, -3.0517578125e-05, -0.000274658203125, 0.00018310546875, -0.0003662109375, 0.00054931640625, -0.0001220703125, 0.030731201171875, 0.113067626953125, 0.09063720703125, -0.148406982421875, -0.299163818359375, -0.0880126953125, 0.197540283203125, 0.279388427734375, 0.21673583984375, 0.09771728515625, 0.037017822265625, 0.07293701171875, 0.068511962890625, -0.009490966796875, -0.04595947265625, -0.04840087890625, -0.0701904296875, -0.086761474609375, -0.076416015625, -0.06878662109375, -0.07769775390625, -0.062408447265625, -0.02618408203125, 0.006805419921875, 0.0120849609375, 0.022064208984375, 0.034271240234375, 0.026580810546875, 0.040130615234375, 0.059356689453125, 0.043182373046875, 0.016357421875, 0.002410888671875, -0.010955810546875, -0.029876708984375, -0.03790283203125, -0.03857421875, -0.04791259765625, -0.0469970703125, -0.024749755859375, -0.0013427734375, 0.00054931640625, -0.003021240234375, 0.006744384765625, 0.0179443359375, 0.020172119140625, 0.016357421875, 0.00482177734375, -0.005615234375, -0.00469970703125, -0.000518798828125, -0.00457763671875, -0.0103759765625, -0.013031005859375, -0.016754150390625, -0.017364501953125, -0.015655517578125, -0.016571044921875, -0.02105712890625, -0.02008056640625, -0.013092041015625, -0.002716064453125, 0.00164794921875, -0.00439453125, -0.00634765625, -0.000518798828125, 0.004547119140625, 0.00396728515625, 0.0003662109375, -0.003509521484375, -0.007568359375, -0.007843017578125, -0.005767822265625, -0.007080078125, -0.0101318359375, -0.0101318359375, -0.008453369140625, -0.00726318359375, -0.00604248046875, -0.005615234375, -0.004669189453125, -0.003662109375, -0.00238037109375, -0.00091552734375, -0.00042724609375, -0.0009765625, -0.002197265625, -0.002655029296875, -0.001861572265625, -0.001678466796875, -0.00274658203125, -0.004730224609375, -0.006195068359375, -0.00555419921875, -0.0040283203125, -0.003082275390625, -0.003143310546875, -0.003143310546875, -0.00262451171875, -0.001129150390625, 0.000518798828125, 0.00048828125, -0.0010986328125, -0.0028076171875, -0.003631591796875, -0.00335693359375, -0.00244140625, -0.002105712890625, -0.00299072265625, -0.004119873046875, -0.004364013671875, -0.00396728515625, -0.002593994140625, -0.0010986328125, -0.001953125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, 3.0517578125e-05, 0.00018310546875, 0.0, 0.0, -0.000244140625, 0.0, -0.000274658203125, 0.000213623046875, -0.00042724609375, 0.000579833984375, 0.0001220703125, 0.0384521484375, 0.131805419921875, 0.08538818359375, -0.192718505859375, -0.32275390625, -0.057586669921875, 0.245025634765625, 0.309234619140625, 0.216827392578125, 0.079132080078125, 0.031280517578125, 0.08392333984375, 0.0693359375, -0.02581787109375, -0.060302734375, -0.05877685546875, -0.0821533203125, -0.09478759765625, -0.07904052734375, -0.071044921875, -0.077880859375, -0.058624267578125, -0.023162841796875, 0.009307861328125, 0.018798828125, 0.0284423828125, 0.04205322265625, 0.03643798828125, 0.025665283203125, 0.040435791015625, 0.046630859375, 0.0194091796875, 0.004669189453125, -0.006866455078125, -0.033538818359375, -0.041900634765625, -0.035888671875, -0.04571533203125, -0.05023193359375, -0.029815673828125, -0.00689697265625, 0.00018310546875, 0.00140380859375, 0.008880615234375, 0.015655517578125, 0.019866943359375, 0.01898193359375, 0.005828857421875, -0.002960205078125, 0.000823974609375, 0.00299072265625, -0.005889892578125, -0.011810302734375, -0.01312255859375, -0.015838623046875, -0.018829345703125, -0.021240234375, -0.022918701171875, -0.02587890625, -0.02252197265625, -0.009918212890625, 0.002227783203125, 0.001129150390625, -0.003753662109375, -0.00177001953125, 0.003448486328125, 0.0054931640625, 0.004425048828125, 0.001068115234375, -0.0045166015625, -0.006103515625, -0.003997802734375, -0.0064697265625, -0.01116943359375, -0.010833740234375, -0.009429931640625, -0.010223388671875, -0.009307861328125, -0.006744384765625, -0.005462646484375, -0.005126953125, -0.002655029296875, -0.000518798828125, -0.001312255859375, -0.00042724609375, 0.000244140625, -0.001190185546875, -0.002838134765625, -0.00274658203125, -0.00225830078125, -0.003265380859375, -0.004730224609375, -0.00555419921875, -0.005340576171875, -0.004241943359375, -0.002838134765625, -0.0028076171875, -0.003875732421875, -0.003814697265625, -0.00201416015625, -0.000152587890625, -0.000457763671875, -0.00189208984375, -0.002655029296875, -0.00347900390625, -0.00311279296875, -0.001922607421875, -0.001434326171875, -0.00225830078125, -0.00323486328125, -0.00408935546875, -0.004638671875, -0.003082275390625, -0.001556396484375, -0.00225830078125, -0.003021240234375])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.000213623046875, 3.0517578125e-05, 3.0517578125e-05, -0.000244140625, -3.0517578125e-05, -0.000274658203125, 0.000274658203125, -0.000457763671875, 0.00067138671875, 0.0003662109375, 0.047698974609375, 0.15185546875, 0.077789306640625, -0.239410400390625, -0.345123291015625, -0.02392578125, 0.29632568359375, 0.33868408203125, 0.212799072265625, 0.059844970703125, 0.02734375, 0.0970458984375, 0.06976318359375, -0.04486083984375, -0.076751708984375, -0.069427490234375, -0.093414306640625, -0.10235595703125, -0.082061767578125, -0.0751953125, -0.0782470703125, -0.0537109375, -0.017059326171875, 0.01123046875, 0.021514892578125, 0.037933349609375, 0.04974365234375, 0.0472412109375, 0.024169921875, 0.017364501953125, 0.03759765625, 0.027435302734375, 0.00506591796875, -0.008453369140625, -0.033294677734375, -0.04229736328125, -0.034149169921875, -0.042999267578125, -0.051666259765625, -0.03485107421875, -0.0107421875, 0.0, 0.0029296875, 0.00860595703125, 0.01434326171875, 0.01849365234375, 0.0189208984375, 0.005157470703125, -0.00140380859375, 0.0074462890625, 0.007568359375, -0.00494384765625, -0.01214599609375, -0.014068603515625, -0.013427734375, -0.01849365234375, -0.026763916015625, -0.030303955078125, -0.030792236328125, -0.0198974609375, -0.00567626953125, -0.002349853515625, -0.0028076171875, 0.00067138671875, 0.004638671875, 0.00640869140625, 0.005615234375, 0.00445556640625, 0.00140380859375, -0.000518798828125, -0.001251220703125, -0.004913330078125, -0.01007080078125, -0.010955810546875, -0.010223388671875, -0.01104736328125, -0.01171875, -0.010955810546875, -0.00830078125, -0.006378173828125, -0.004150390625, -0.00128173828125, -0.000701904296875, -0.00079345703125, 0.000457763671875, 0.000885009765625, -9.1552734375e-05, -0.002166748046875, -0.00341796875, -0.00323486328125, -0.003509521484375, -0.005279541015625, -0.00592041015625, -0.005096435546875, -0.003326416015625, -0.002288818359375, -0.0028076171875, -0.00396728515625, -0.0042724609375, -0.002197265625, -0.0010986328125, -0.00189208984375, -0.002471923828125, -0.003082275390625, -0.003936767578125, -0.003082275390625, -0.00152587890625, -0.001068115234375, -0.0013427734375, -0.002166748046875, -0.003936767578125, -0.00469970703125, -0.003021240234375, -0.001312255859375, -0.00238037109375, -0.003509521484375, -0.001953125])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([0.00048828125, -0.0008544921875, 0.000732421875, -0.000335693359375, -0.000518798828125, 0.000946044921875, 0.016754150390625, 0.11834716796875, 0.1336669921875, 0.10272216796875, -0.3125, -0.343170166015625, 0.240631103515625, 0.3408203125, 0.265533447265625, 0.10211181640625, 0.041473388671875, 0.088897705078125, 0.08453369140625, -0.03326416015625, -0.171142578125, -0.168060302734375, -0.16387939453125, -0.08935546875, -0.081787109375, -0.08349609375, -0.03955078125, -0.02001953125, 0.01153564453125, 0.032989501953125, 0.06158447265625, 0.051483154296875, 0.051025390625, 0.042816162109375, 0.037506103515625, 0.017486572265625, -0.005645751953125, 0.00640869140625, 0.004547119140625, 0.0003662109375, -0.031463623046875, -0.056365966796875, -0.06298828125, -0.045745849609375, -0.029815673828125, -0.012969970703125, 0.006744384765625, 0.017669677734375, 0.0167236328125, 0.00799560546875, 0.01617431640625, 0.02215576171875, 0.016754150390625, 0.008087158203125, -0.0059814453125, -0.016082763671875, -0.0115966796875, -0.006072998046875, -0.006378173828125, -0.004791259765625, -0.006195068359375, -0.012542724609375, -0.01678466796875, -0.02008056640625, -0.016571044921875, -0.0208740234375, -0.035369873046875, -0.040252685546875, -0.02252197265625, -0.0006103515625, 0.005889892578125, 0.0064697265625, 0.003326416015625, -0.001373291015625, -0.002410888671875, -0.000946044921875, 0.000762939453125, 0.0015869140625, 0.00244140625, -0.0008544921875, -0.007904052734375, -0.01312255859375, -0.012451171875, -0.005645751953125, -0.002532958984375, -0.004241943359375, -0.00860595703125, -0.012908935546875, -0.012298583984375, -0.009490966796875, -0.00421142578125, 0.002471923828125, 0.002685546875, -0.001068115234375, -0.004119873046875, -0.00347900390625, 0.001007080078125, 0.003814697265625, 0.000335693359375, -0.003448486328125, -0.004150390625, -0.0035400390625, -0.00164794921875, -0.001007080078125, -0.0020751953125, -0.004486083984375, -0.007171630859375, -0.007965087890625, -0.00640869140625, -0.0030517578125, -0.001617431640625, -0.003631591796875, -0.004730224609375, -0.00445556640625, -0.00299072265625, -0.00103759765625, -3.0517578125e-05, -0.00018310546875, -0.001220703125, -0.002777099609375, -0.001953125, 0.0003662109375, 0.000762939453125, -0.00042724609375, -0.002655029296875, -0.005401611328125, -0.005859375, -0.0025634765625])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000946044921875, 0.001068115234375, -0.001617431640625, 0.0015869140625, -0.001800537109375, 0.001617431640625, -0.001739501953125, 0.028045654296875, 0.11053466796875, 0.121612548828125, 0.057708740234375, -0.326934814453125, -0.246826171875, 0.2379150390625, 0.309112548828125, 0.24700927734375, 0.083831787109375, 0.040679931640625, 0.0809326171875, 0.080322265625, -0.040618896484375, -0.14129638671875, -0.145904541015625, -0.143310546875, -0.07763671875, -0.0821533203125, -0.0794677734375, -0.0462646484375, -0.020721435546875, 0.004913330078125, 0.028289794921875, 0.0576171875, 0.050048828125, 0.051300048828125, 0.041717529296875, 0.037078857421875, 0.014373779296875, -0.004058837890625, 0.00555419921875, 0.00726318359375, -0.000762939453125, -0.031494140625, -0.05059814453125, -0.05596923828125, -0.040618896484375, -0.026031494140625, -0.0133056640625, 0.001190185546875, 0.01458740234375, 0.012603759765625, 0.00439453125, 0.011688232421875, 0.0189208984375, 0.01751708984375, 0.007537841796875, -0.0054931640625, -0.012847900390625, -0.008697509765625, -0.00341796875, -0.006500244140625, -0.00433349609375, -0.005706787109375, -0.01885986328125, -0.019744873046875, -0.014251708984375, -0.015350341796875, -0.024932861328125, -0.032501220703125, -0.029144287109375, -0.01708984375, -0.003997802734375, 0.004364013671875, 0.007049560546875, 0.000457763671875, -0.006988525390625, -0.005950927734375, -0.001800537109375, -0.0006103515625, -0.000244140625, 0.0006103515625, -0.0015869140625, -0.006805419921875, -0.0108642578125, -0.011077880859375, -0.007476806640625, -0.003509521484375, -0.003509521484375, -0.0081787109375, -0.011505126953125, -0.010955810546875, -0.008087158203125, -0.003814697265625, 0.001983642578125, 0.00274658203125, -0.0010986328125, -0.003173828125, -0.003173828125, -0.00042724609375, 0.001922607421875, -0.000335693359375, -0.003387451171875, -0.0032958984375, -0.002716064453125, -0.00140380859375, -0.000244140625, -0.001861572265625, -0.004302978515625, -0.006500244140625, -0.007415771484375, -0.005828857421875, -0.003387451171875, -0.00244140625, -0.00384521484375, -0.00531005859375, -0.0048828125, -0.00225830078125, -0.000244140625, -0.0006103515625, -0.001129150390625, -0.00115966796875, -0.0015869140625, -0.001251220703125, -0.000152587890625, 6.103515625e-05, -0.00103759765625, -0.00225830078125, -0.003936767578125, -0.00506591796875])
        IR_LEFT[len(IR_LEFT)-1].append([0.00042724609375, -0.000946044921875, 0.00103759765625, -0.001495361328125, 0.00177001953125, -0.002227783203125, 0.00262451171875, -0.002532958984375, 0.035125732421875, 0.09918212890625, 0.110321044921875, 0.02105712890625, -0.3145751953125, -0.178375244140625, 0.221038818359375, 0.2852783203125, 0.224853515625, 0.072509765625, 0.042022705078125, 0.0789794921875, 0.0731201171875, -0.03765869140625, -0.115203857421875, -0.131927490234375, -0.123748779296875, -0.070404052734375, -0.08148193359375, -0.077392578125, -0.0479736328125, -0.02142333984375, -0.000732421875, 0.02703857421875, 0.05438232421875, 0.04779052734375, 0.049652099609375, 0.040924072265625, 0.03363037109375, 0.0125732421875, 0.000152587890625, 0.006500244140625, 0.008087158203125, -0.0028076171875, -0.029449462890625, -0.047454833984375, -0.05242919921875, -0.035888671875, -0.02520751953125, -0.016754150390625, -0.00128173828125, 0.012908935546875, 0.006134033203125, 0.00048828125, 0.017120361328125, 0.022491455078125, 0.014007568359375, 0.00469970703125, -0.00537109375, -0.010284423828125, -0.0072021484375, -0.00146484375, -0.0057373046875, -0.01141357421875, -0.011810302734375, -0.015533447265625, -0.014617919921875, -0.013519287109375, -0.018463134765625, -0.0242919921875, -0.025299072265625, -0.020416259765625, -0.0128173828125, -0.00732421875, -0.000701904296875, 0.00494384765625, 0.001129150390625, -0.00689697265625, -0.009368896484375, -0.00616455078125, -0.003143310546875, -0.001373291015625, -0.0001220703125, -0.0029296875, -0.007720947265625, -0.009918212890625, -0.009063720703125, -0.006744384765625, -0.004364013671875, -0.0037841796875, -0.00616455078125, -0.008575439453125, -0.008819580078125, -0.006744384765625, -0.003265380859375, 0.00115966796875, 0.001922607421875, -0.001678466796875, -0.003387451171875, -0.002777099609375, -0.0010986328125, -0.00030517578125, -0.0015869140625, -0.003204345703125, -0.0025634765625, -0.001220703125, -3.0517578125e-05, 3.0517578125e-05, -0.002410888671875, -0.004547119140625, -0.005859375, -0.0064697265625, -0.00567626953125, -0.003631591796875, -0.002838134765625, -0.003936767578125, -0.00518798828125, -0.00469970703125, -0.001983642578125, -0.000152587890625, -0.00054931640625, -0.001220703125, -0.00115966796875, -0.00152587890625, -0.001251220703125, -0.00048828125, -0.000640869140625, -0.001220703125, -0.002044677734375, -0.00347900390625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, 0.000274658203125, -0.000732421875, 0.0008544921875, -0.001251220703125, 0.001617431640625, -0.00213623046875, 0.002838134765625, -0.002105712890625, 0.04022216796875, 0.08905029296875, 0.1007080078125, -0.013336181640625, -0.299652099609375, -0.123321533203125, 0.21051025390625, 0.266815185546875, 0.198699951171875, 0.062164306640625, 0.0460205078125, 0.0772705078125, 0.065399169921875, -0.032318115234375, -0.0970458984375, -0.119171142578125, -0.102935791015625, -0.06536865234375, -0.08209228515625, -0.072662353515625, -0.046112060546875, -0.022308349609375, -0.004241943359375, 0.0279541015625, 0.050262451171875, 0.042449951171875, 0.046356201171875, 0.040252685546875, 0.03167724609375, 0.012481689453125, 0.003997802734375, 0.0069580078125, 0.00732421875, -0.00567626953125, -0.030364990234375, -0.0457763671875, -0.046661376953125, -0.03338623046875, -0.027618408203125, -0.01641845703125, -0.00421142578125, 0.004150390625, 0.008331298828125, 0.01116943359375, 0.018096923828125, 0.017547607421875, 0.010284423828125, 0.002288818359375, -0.003509521484375, -0.00640869140625, -0.0076904296875, -0.00787353515625, -0.01043701171875, -0.00933837890625, -0.009033203125, -0.01483154296875, -0.014892578125, -0.01324462890625, -0.017364501953125, -0.020233154296875, -0.019134521484375, -0.016265869140625, -0.01397705078125, -0.009857177734375, -0.001434326171875, 0.003997802734375, 0.0003662109375, -0.00732421875, -0.011627197265625, -0.01025390625, -0.004913330078125, -0.0030517578125, -0.00274658203125, -0.00421142578125, -0.0072021484375, -0.009063720703125, -0.00775146484375, -0.004547119140625, -0.00396728515625, -0.003662109375, -0.003875732421875, -0.005340576171875, -0.006805419921875, -0.006561279296875, -0.003265380859375, -9.1552734375e-05, -6.103515625e-05, -0.002685546875, -0.003997802734375, -0.003082275390625, -0.001861572265625, -0.001373291015625, -0.00225830078125, -0.002532958984375, -0.001434326171875, 0.0, 0.00042724609375, -0.000579833984375, -0.002471923828125, -0.0042724609375, -0.005584716796875, -0.005950927734375, -0.0052490234375, -0.0040283203125, -0.00347900390625, -0.003936767578125, -0.004791259765625, -0.004638671875, -0.001983642578125, 0.0, -0.000274658203125, -0.00140380859375, -0.00201416015625, -0.001739501953125, -0.001190185546875, -0.00067138671875, -0.001068115234375, -0.001678466796875, -0.0023193359375])
        IR_LEFT[len(IR_LEFT)-1].append([0.000244140625, 3.0517578125e-05, 9.1552734375e-05, -0.00042724609375, 0.000579833984375, -0.001007080078125, 0.00128173828125, -0.001678466796875, 0.002532958984375, -0.000579833984375, 0.04437255859375, 0.08148193359375, 0.09173583984375, -0.04852294921875, -0.284881591796875, -0.074951171875, 0.208404541015625, 0.25067138671875, 0.169158935546875, 0.055206298828125, 0.0517578125, 0.07489013671875, 0.057373046875, -0.028839111328125, -0.084442138671875, -0.1058349609375, -0.084686279296875, -0.063812255859375, -0.080047607421875, -0.065185546875, -0.043548583984375, -0.02264404296875, -0.0050048828125, 0.028167724609375, 0.0435791015625, 0.037872314453125, 0.0450439453125, 0.040435791015625, 0.028656005859375, 0.012298583984375, 0.006988525390625, 0.0050048828125, 0.003509521484375, -0.010101318359375, -0.02947998046875, -0.042144775390625, -0.0435791015625, -0.032501220703125, -0.02825927734375, -0.0234375, -0.003448486328125, 0.0162353515625, 0.01080322265625, 0.010040283203125, 0.015960693359375, 0.012603759765625, 0.008758544921875, 0.004547119140625, -0.002410888671875, -0.01422119140625, -0.016204833984375, -0.005035400390625, -0.0020751953125, -0.010589599609375, -0.014312744140625, -0.012298583984375, -0.010284423828125, -0.01214599609375, -0.0162353515625, -0.016204833984375, -0.017425537109375, -0.016845703125, -0.01239013671875, -0.00848388671875, -0.002777099609375, 0.001617431640625, -0.001922607421875, -0.0079345703125, -0.011138916015625, -0.012725830078125, -0.009674072265625, -0.005035400390625, -0.001983642578125, -0.00396728515625, -0.00738525390625, -0.00762939453125, -0.005401611328125, -0.002593994140625, -0.001922607421875, -0.00238037109375, -0.003387451171875, -0.003936767578125, -0.00518798828125, -0.00628662109375, -0.004486083984375, -0.001617431640625, -0.001617431640625, -0.00372314453125, -0.004852294921875, -0.003936767578125, -0.001739501953125, -0.000640869140625, -0.001373291015625, -0.001739501953125, -0.00091552734375, 0.0, 0.000396728515625, -0.00030517578125, -0.001953125, -0.003692626953125, -0.00531005859375, -0.0057373046875, -0.005096435546875, -0.004150390625, -0.003875732421875, -0.0040283203125, -0.004241943359375, -0.00347900390625, -0.001556396484375, -0.000579833984375, -0.000732421875, -0.001434326171875, -0.00189208984375, -0.00177001953125, -0.00128173828125, -0.0009765625, -0.001190185546875, -0.001617431640625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0001220703125, 9.1552734375e-05, 0.00018310546875, -0.0001220703125, -6.103515625e-05, 0.0001220703125, -0.00048828125, 0.000732421875, -0.0008544921875, 0.001617431640625, 0.003143310546875, 0.05010986328125, 0.077117919921875, 0.079620361328125, -0.09881591796875, -0.26519775390625, -0.011810302734375, 0.21551513671875, 0.229400634765625, 0.13433837890625, 0.05224609375, 0.0570068359375, 0.072174072265625, 0.04742431640625, -0.030303955078125, -0.0767822265625, -0.093505859375, -0.068389892578125, -0.063446044921875, -0.074920654296875, -0.0567626953125, -0.039703369140625, -0.02239990234375, -0.00384521484375, 0.030426025390625, 0.037322998046875, 0.034027099609375, 0.04425048828125, 0.0391845703125, 0.02313232421875, 0.010528564453125, 0.005218505859375, 0.000885009765625, 0.000335693359375, -0.011993408203125, -0.02899169921875, -0.039642333984375, -0.039093017578125, -0.04058837890625, -0.030609130859375, -0.00616455078125, 0.00701904296875, 0.01123046875, 0.009246826171875, 0.00927734375, 0.010986328125, 0.014190673828125, 0.010772705078125, -0.004150390625, -0.0159912109375, -0.0150146484375, -0.005462646484375, -0.00048828125, -0.00811767578125, -0.014923095703125, -0.0098876953125, -0.005523681640625, -0.00946044921875, -0.01446533203125, -0.014892578125, -0.014312744140625, -0.015655517578125, -0.01513671875, -0.012115478515625, -0.008544921875, -0.004638671875, -0.00115966796875, -0.0032958984375, -0.0087890625, -0.013397216796875, -0.014984130859375, -0.010467529296875, -0.004241943359375, -0.00152587890625, -0.003936767578125, -0.006103515625, -0.005462646484375, -0.002960205078125, -0.000823974609375, -0.000946044921875, -0.002166748046875, -0.003509521484375, -0.004119873046875, -0.005279541015625, -0.006500244140625, -0.005218505859375, -0.00299072265625, -0.00311279296875, -0.0050048828125, -0.00531005859375, -0.003570556640625, -0.000762939453125, 0.00048828125, -0.00067138671875, -0.001495361328125, -0.00091552734375, -3.0517578125e-05, 0.000396728515625, -0.000335693359375, -0.001739501953125, -0.00347900390625, -0.00537109375, -0.005828857421875, -0.0052490234375, -0.004241943359375, -0.00408935546875, -0.003814697265625, -0.00347900390625, -0.00286865234375, -0.00189208984375, -0.00140380859375, -0.0010986328125, -0.0013427734375, -0.00177001953125, -0.00213623046875, -0.00164794921875, -0.0010986328125, -0.0013427734375])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000152587890625, 0.000274658203125, -6.103515625e-05, 0.000213623046875, -0.00042724609375, 0.0003662109375, -0.000457763671875, 0.000396728515625, -0.000335693359375, 0.0006103515625, -0.000274658203125, 0.0118408203125, 0.05706787109375, 0.077301025390625, 0.051727294921875, -0.168701171875, -0.219268798828125, 0.0699462890625, 0.224151611328125, 0.197357177734375, 0.0985107421875, 0.053802490234375, 0.05975341796875, 0.07073974609375, 0.031829833984375, -0.039154052734375, -0.07305908203125, -0.079254150390625, -0.05535888671875, -0.064605712890625, -0.0667724609375, -0.049835205078125, -0.03509521484375, -0.0194091796875, 0.001556396484375, 0.031829833984375, 0.03070068359375, 0.031829833984375, 0.043060302734375, 0.033935546875, 0.012969970703125, 0.007171630859375, 0.0030517578125, -9.1552734375e-05, -0.001800537109375, -0.013946533203125, -0.027801513671875, -0.04437255859375, -0.04339599609375, -0.027618408203125, -0.012847900390625, -0.002899169921875, 0.004852294921875, 0.008087158203125, 0.0072021484375, 0.0087890625, 0.0133056640625, 0.0093994140625, -0.00555419921875, -0.010650634765625, -0.008056640625, -0.007598876953125, -0.0062255859375, -0.0059814453125, -0.009063720703125, -0.009552001953125, -0.00494384765625, -0.006134033203125, -0.01312255859375, -0.014007568359375, -0.0101318359375, -0.0120849609375, -0.016387939453125, -0.015289306640625, -0.012115478515625, -0.009613037109375, -0.005767822265625, -0.00274658203125, -0.006744384765625, -0.011993408203125, -0.013427734375, -0.01275634765625, -0.009063720703125, -0.0029296875, -0.000579833984375, -0.00311279296875, -0.0045166015625, -0.003265380859375, -0.001617431640625, -0.00067138671875, -0.00103759765625, -0.002838134765625, -0.0050048828125, -0.00518798828125, -0.005523681640625, -0.0068359375, -0.0059814453125, -0.004058837890625, -0.003875732421875, -0.005157470703125, -0.004730224609375, -0.0025634765625, 0.0, 0.000823974609375, -0.000396728515625, -0.000885009765625, -0.000518798828125, -0.0001220703125, 0.0, -0.000946044921875, -0.002044677734375, -0.0035400390625, -0.00531005859375, -0.005828857421875, -0.00506591796875, -0.004180908203125, -0.003875732421875, -0.00360107421875, -0.00335693359375, -0.00250244140625, -0.00177001953125, -0.001495361328125, -0.00140380859375, -0.001678466796875, -0.00189208984375, -0.00201416015625, -0.001678466796875, -0.001556396484375])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -3.0517578125e-05, 0.000244140625, 0.0, 0.0001220703125, -0.0003662109375, 0.00042724609375, -0.00067138671875, 0.000946044921875, -0.00103759765625, 0.00189208984375, -0.001007080078125, 0.029296875, 0.06402587890625, 0.07928466796875, -0.02239990234375, -0.237060546875, -0.110137939453125, 0.160247802734375, 0.21783447265625, 0.1470947265625, 0.07098388671875, 0.05859375, 0.06378173828125, 0.06634521484375, 0.00299072265625, -0.051544189453125, -0.0679931640625, -0.06207275390625, -0.052001953125, -0.06500244140625, -0.0565185546875, -0.042999267578125, -0.027435302734375, -0.015533447265625, 0.010223388671875, 0.03033447265625, 0.025909423828125, 0.030853271484375, 0.03839111328125, 0.0233154296875, 0.00518798828125, 0.00628662109375, 0.00250244140625, 0.0008544921875, -0.00341796875, -0.022918701171875, -0.03955078125, -0.0330810546875, -0.02447509765625, -0.02001953125, -0.01043701171875, -0.00341796875, 0.003814697265625, 0.007537841796875, 0.008636474609375, 0.005462646484375, 0.000335693359375, -0.00048828125, -0.001129150390625, -0.00341796875, -0.00738525390625, -0.010833740234375, -0.007476806640625, -0.0028076171875, -0.006378173828125, -0.00927734375, -0.00665283203125, -0.008453369140625, -0.010650634765625, -0.00836181640625, -0.008941650390625, -0.014892578125, -0.017181396484375, -0.014251708984375, -0.01324462890625, -0.01129150390625, -0.00653076171875, -0.0062255859375, -0.009979248046875, -0.010711669921875, -0.010894775390625, -0.010498046875, -0.005767822265625, -0.0001220703125, 0.000244140625, -0.00250244140625, -0.003387451171875, -0.002044677734375, -0.001251220703125, -0.001556396484375, -0.00286865234375, -0.004974365234375, -0.00592041015625, -0.0057373046875, -0.006744384765625, -0.007415771484375, -0.005279541015625, -0.003082275390625, -0.003692626953125, -0.0050048828125, -0.00372314453125, -0.0010986328125, 0.000885009765625, 0.000579833984375, -0.000396728515625, -0.000274658203125, 0.0, -0.00030517578125, -0.0010986328125, -0.0015869140625, -0.002197265625, -0.00372314453125, -0.0052490234375, -0.0052490234375, -0.004425048828125, -0.004119873046875, -0.00408935546875, -0.00341796875, -0.002593994140625, -0.0018310546875, -0.001434326171875, -0.00201416015625, -0.002288818359375, -0.001678466796875, -0.0015869140625, -0.00177001953125, -0.00189208984375])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, -9.1552734375e-05, 0.000213623046875, 0.0, 0.000274658203125, -0.000396728515625, 0.000396728515625, -0.00048828125, 0.00048828125, -0.000335693359375, 0.000885009765625, -0.000579833984375, 0.01068115234375, 0.051849365234375, 0.074432373046875, 0.04461669921875, -0.165313720703125, -0.2064208984375, 0.06903076171875, 0.212188720703125, 0.17242431640625, 0.0909423828125, 0.06500244140625, 0.0634765625, 0.07122802734375, 0.038909912109375, -0.03515625, -0.0599365234375, -0.056488037109375, -0.051300048828125, -0.06085205078125, -0.0550537109375, -0.047943115234375, -0.0369873046875, -0.020355224609375, -0.004364013671875, 0.01800537109375, 0.024444580078125, 0.025421142578125, 0.029327392578125, 0.03106689453125, 0.013092041015625, 0.003326416015625, 0.00543212890625, 0.006195068359375, -0.006011962890625, -0.02056884765625, -0.023529052734375, -0.02685546875, -0.021575927734375, -0.019012451171875, -0.018707275390625, -0.011505126953125, 0.000885009765625, 0.006439208984375, 0.00341796875, -0.0035400390625, -0.003875732421875, 0.005126953125, 0.004791259765625, -0.0006103515625, -0.0052490234375, -0.008758544921875, -0.0084228515625, -0.00439453125, -0.0042724609375, -0.011138916015625, -0.010101318359375, -0.0042724609375, -0.0050048828125, -0.007537841796875, -0.008453369140625, -0.012237548828125, -0.016021728515625, -0.015716552734375, -0.016387939453125, -0.01678466796875, -0.012542724609375, -0.006805419921875, -0.00628662109375, -0.008819580078125, -0.009918212890625, -0.00958251953125, -0.005645751953125, 0.0, 0.001434326171875, -0.0008544921875, -0.00238037109375, -0.00213623046875, -0.002044677734375, -0.003021240234375, -0.004180908203125, -0.005462646484375, -0.006439208984375, -0.00653076171875, -0.007049560546875, -0.007537841796875, -0.005340576171875, -0.002716064453125, -0.002716064453125, -0.004241943359375, -0.004302978515625, -0.001983642578125, 0.0003662109375, 0.00042724609375, -0.0003662109375, -0.000274658203125, -6.103515625e-05, -0.000335693359375, -0.0006103515625, -0.00140380859375, -0.002410888671875, -0.003326416015625, -0.004058837890625, -0.004364013671875, -0.004486083984375, -0.00457763671875, -0.00421142578125, -0.003448486328125, -0.00262451171875, -0.00189208984375, -0.001739501953125, -0.002288818359375, -0.00274658203125, -0.00213623046875, -0.00140380859375, -0.001495361328125, -0.002349853515625])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -0.000152587890625, 0.000152587890625, 0.0, 0.000213623046875, -0.000274658203125, 6.103515625e-05, -0.000152587890625, 9.1552734375e-05, 0.000274658203125, 9.1552734375e-05, 0.000396728515625, 0.003997802734375, 0.04351806640625, 0.071136474609375, 0.062255859375, -0.119293212890625, -0.228759765625, 0.01409912109375, 0.200042724609375, 0.178131103515625, 0.099700927734375, 0.07025146484375, 0.06939697265625, 0.074188232421875, 0.0528564453125, -0.020721435546875, -0.058746337890625, -0.05670166015625, -0.045684814453125, -0.061676025390625, -0.0584716796875, -0.043548583984375, -0.043548583984375, -0.0274658203125, -0.006622314453125, 0.0123291015625, 0.014495849609375, 0.0228271484375, 0.031646728515625, 0.029052734375, 0.016815185546875, 0.00897216796875, 0.00787353515625, -0.00177001953125, -0.0072021484375, -0.00872802734375, -0.019622802734375, -0.0245361328125, -0.0159912109375, -0.01837158203125, -0.021575927734375, -0.013458251953125, -0.003204345703125, -0.001068115234375, -0.005035400390625, -0.00579833984375, -0.000335693359375, 0.005523681640625, 0.005584716796875, 0.00146484375, -0.00115966796875, -0.0029296875, -0.007110595703125, -0.0091552734375, -0.009429931640625, -0.011566162109375, -0.008941650390625, -0.002227783203125, -0.0023193359375, -0.007080078125, -0.008392333984375, -0.009185791015625, -0.013275146484375, -0.0166015625, -0.019134521484375, -0.0218505859375, -0.0179443359375, -0.0068359375, -0.002593994140625, -0.007568359375, -0.011077880859375, -0.008148193359375, -0.002593994140625, 0.00103759765625, 0.001251220703125, 3.0517578125e-05, -0.001312255859375, -0.002349853515625, -0.0030517578125, -0.004669189453125, -0.006134033203125, -0.00701904296875, -0.007080078125, -0.007110595703125, -0.00726318359375, -0.00689697265625, -0.00494384765625, -0.002532958984375, -0.002044677734375, -0.003448486328125, -0.0040283203125, -0.002532958984375, -0.000579833984375, -0.000213623046875, -0.000701904296875, -0.00091552734375, -0.0006103515625, -6.103515625e-05, -0.000152587890625, -0.00128173828125, -0.003021240234375, -0.003173828125, -0.0030517578125, -0.003509521484375, -0.00433349609375, -0.00469970703125, -0.004150390625, -0.00335693359375, -0.002655029296875, -0.00238037109375, -0.002197265625, -0.00250244140625, -0.00299072265625, -0.002593994140625, -0.001800537109375, -0.001922607421875, -0.0029296875])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -0.0001220703125, 0.00018310546875, -6.103515625e-05, 0.000213623046875, -0.000213623046875, 6.103515625e-05, -0.00030517578125, 3.0517578125e-05, 0.000244140625, 0.000213623046875, 0.000244140625, 0.003936767578125, 0.043701171875, 0.073455810546875, 0.06048583984375, -0.125732421875, -0.2257080078125, 0.02276611328125, 0.201171875, 0.17022705078125, 0.09515380859375, 0.07391357421875, 0.074310302734375, 0.0789794921875, 0.055511474609375, -0.022216796875, -0.058807373046875, -0.05853271484375, -0.051025390625, -0.06170654296875, -0.06097412109375, -0.046142578125, -0.04010009765625, -0.029815673828125, -0.00860595703125, 0.014739990234375, 0.01239013671875, 0.017425537109375, 0.035430908203125, 0.0352783203125, 0.013671875, 0.012420654296875, 0.0072021484375, -0.01116943359375, -0.001007080078125, -0.003875732421875, -0.022613525390625, -0.022369384765625, -0.0155029296875, -0.017303466796875, -0.018096923828125, -0.01190185546875, -0.007965087890625, -0.011932373046875, -0.010833740234375, 0.000457763671875, 0.00396728515625, 0.002532958984375, 0.003875732421875, 0.004486083984375, 0.004180908203125, -0.000579833984375, -0.005706787109375, -0.01171875, -0.01617431640625, -0.01312255859375, -0.00543212890625, -0.000946044921875, -0.00299072265625, -0.00701904296875, -0.007476806640625, -0.0062255859375, -0.010894775390625, -0.017120361328125, -0.022430419921875, -0.02557373046875, -0.018798828125, -0.0057373046875, -0.001922607421875, -0.008270263671875, -0.011077880859375, -0.005859375, 0.000274658203125, 0.001922607421875, 0.001922607421875, 0.0008544921875, -0.001373291015625, -0.003021240234375, -0.004150390625, -0.006195068359375, -0.008331298828125, -0.008331298828125, -0.007659912109375, -0.007171630859375, -0.007049560546875, -0.006134033203125, -0.00408935546875, -0.0020751953125, -0.00164794921875, -0.0030517578125, -0.00347900390625, -0.0028076171875, -0.001220703125, -0.0006103515625, -0.0013427734375, -0.001800537109375, -0.001190185546875, -3.0517578125e-05, -0.000457763671875, -0.00177001953125, -0.002410888671875, -0.002105712890625, -0.002349853515625, -0.00341796875, -0.004150390625, -0.0042724609375, -0.0037841796875, -0.003143310546875, -0.0028076171875, -0.002716064453125, -0.002532958984375, -0.00262451171875, -0.00299072265625, -0.002777099609375, -0.0025634765625, -0.0029296875, -0.00311279296875])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -0.0001220703125, 0.000244140625, -6.103515625e-05, 0.000274658203125, -0.0003662109375, 0.00030517578125, -0.000640869140625, 0.00048828125, -0.000335693359375, 0.001007080078125, -0.001068115234375, 0.010589599609375, 0.05389404296875, 0.081512451171875, 0.032745361328125, -0.1832275390625, -0.189544677734375, 0.095611572265625, 0.2109375, 0.145751953125, 0.080902099609375, 0.07647705078125, 0.07867431640625, 0.082489013671875, 0.04229736328125, -0.0361328125, -0.063232421875, -0.057861328125, -0.05914306640625, -0.074005126953125, -0.058349609375, -0.045928955078125, -0.041961669921875, -0.021759033203125, -0.000640869140625, 0.0135498046875, 0.014678955078125, 0.02423095703125, 0.037384033203125, 0.033203125, 0.019683837890625, 0.008544921875, -0.0076904296875, 0.000762939453125, 0.003326416015625, -0.017242431640625, -0.021728515625, -0.021636962890625, -0.019134521484375, -0.014495849609375, -0.012847900390625, -0.0128173828125, -0.013397216796875, -0.01507568359375, -0.0078125, 0.003387451171875, 0.004913330078125, 0.001678466796875, 0.0035400390625, 0.009002685546875, 0.00445556640625, -0.002166748046875, -0.005126953125, -0.014190673828125, -0.019134521484375, -0.010955810546875, -0.00421142578125, -0.004913330078125, -0.003997802734375, -0.00390625, -0.0059814453125, -0.006591796875, -0.00958251953125, -0.018035888671875, -0.026580810546875, -0.023956298828125, -0.013763427734375, -0.0059814453125, -0.0057373046875, -0.00897216796875, -0.008514404296875, -0.002716064453125, 0.001861572265625, 0.0029296875, 0.002960205078125, 0.000732421875, -0.001953125, -0.004058837890625, -0.00579833984375, -0.0081787109375, -0.00933837890625, -0.0081787109375, -0.00750732421875, -0.00732421875, -0.00689697265625, -0.0052490234375, -0.002532958984375, -0.001190185546875, -0.001953125, -0.00323486328125, -0.003082275390625, -0.00213623046875, -0.000946044921875, -0.00115966796875, -0.002410888671875, -0.002349853515625, -0.0015869140625, -0.001129150390625, -0.00115966796875, -0.00103759765625, -0.0006103515625, -0.0010986328125, -0.002471923828125, -0.00347900390625, -0.003631591796875, -0.003143310546875, -0.002960205078125, -0.003021240234375, -0.003204345703125, -0.00299072265625, -0.00262451171875, -0.002593994140625, -0.00274658203125, -0.00341796875, -0.00341796875, -0.0030517578125, -0.0029296875])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, 9.1552734375e-05, 0.000152587890625, 6.103515625e-05, 0.0001220703125, -0.000213623046875, 0.00030517578125, -0.000640869140625, 0.000823974609375, -0.00067138671875, 0.001617431640625, -0.001190185546875, 0.02972412109375, 0.073455810546875, 0.08392333984375, -0.059478759765625, -0.247528076171875, -0.06494140625, 0.19549560546875, 0.195709228515625, 0.105224609375, 0.071624755859375, 0.07904052734375, 0.0838623046875, 0.0780029296875, 0.002685546875, -0.05767822265625, -0.06097412109375, -0.05963134765625, -0.074462890625, -0.0794677734375, -0.05706787109375, -0.04730224609375, -0.0350341796875, -0.01165771484375, 0.014801025390625, 0.016510009765625, 0.01751708984375, 0.037078857421875, 0.0401611328125, 0.0283203125, 0.016265869140625, -0.002105712890625, -0.00347900390625, 0.00885009765625, -0.007781982421875, -0.02239990234375, -0.0277099609375, -0.023223876953125, -0.015625, -0.01495361328125, -0.013092041015625, -0.013916015625, -0.01361083984375, -0.00848388671875, -3.0517578125e-05, 0.00250244140625, 0.0023193359375, 0.004119873046875, 0.00970458984375, 0.008209228515625, -0.001678466796875, -0.00396728515625, -0.007110595703125, -0.016082763671875, -0.015899658203125, -0.007537841796875, -0.0068359375, -0.0093994140625, -0.004608154296875, -0.000732421875, -0.00341796875, -0.00830078125, -0.01287841796875, -0.021392822265625, -0.023895263671875, -0.01617431640625, -0.009063720703125, -0.008758544921875, -0.0103759765625, -0.007659912109375, -0.003936767578125, -0.00048828125, 0.002716064453125, 0.004425048828125, 0.002471923828125, -0.00079345703125, -0.003082275390625, -0.0054931640625, -0.008392333984375, -0.009002685546875, -0.007415771484375, -0.007171630859375, -0.00799560546875, -0.007659912109375, -0.005767822265625, -0.003326416015625, -0.00152587890625, -0.001312255859375, -0.00286865234375, -0.003448486328125, -0.002227783203125, -0.00067138671875, -0.0008544921875, -0.002410888671875, -0.002960205078125, -0.00274658203125, -0.00262451171875, -0.0020751953125, -0.0006103515625, 0.000335693359375, 0.0001220703125, -0.00128173828125, -0.002685546875, -0.00274658203125, -0.002044677734375, -0.002105712890625, -0.002899169921875, -0.0032958984375, -0.003173828125, -0.0030517578125, -0.0025634765625, -0.00274658203125, -0.00347900390625, -0.00347900390625, -0.003265380859375, -0.0030517578125, -0.00262451171875])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000152587890625, 0.000274658203125, -6.103515625e-05, 0.000244140625, -0.00042724609375, 0.000396728515625, -0.000579833984375, 0.00054931640625, -0.000640869140625, 0.0010986328125, -0.001068115234375, 0.012115478515625, 0.06243896484375, 0.096221923828125, 0.020599365234375, -0.215423583984375, -0.181488037109375, 0.135955810546875, 0.231292724609375, 0.137908935546875, 0.074249267578125, 0.07568359375, 0.0814208984375, 0.08953857421875, 0.036834716796875, -0.0506591796875, -0.066558837890625, -0.057952880859375, -0.07135009765625, -0.090484619140625, -0.07025146484375, -0.0557861328125, -0.04931640625, -0.02093505859375, 0.009185791015625, 0.02227783203125, 0.021514892578125, 0.03466796875, 0.041473388671875, 0.03631591796875, 0.023834228515625, 0.0003662109375, -0.00531005859375, 0.013641357421875, -0.00054931640625, -0.02252197265625, -0.028228759765625, -0.029571533203125, -0.021392822265625, -0.017333984375, -0.016998291015625, -0.01568603515625, -0.012542724609375, -0.007354736328125, 0.002777099609375, 0.004119873046875, 0.0008544921875, 0.002960205078125, 0.01116943359375, 0.010986328125, -0.000885009765625, -0.005645751953125, -0.007293701171875, -0.01263427734375, -0.012664794921875, -0.010040283203125, -0.01171875, -0.010009765625, -0.007171630859375, -0.005889892578125, -0.0018310546875, -0.002777099609375, -0.011444091796875, -0.02069091796875, -0.020538330078125, -0.013031005859375, -0.00860595703125, -0.010406494140625, -0.012725830078125, -0.00927734375, -0.00482177734375, -0.001678466796875, 0.000823974609375, 0.00360107421875, 0.003692626953125, 0.000244140625, -0.00360107421875, -0.006561279296875, -0.008209228515625, -0.00775146484375, -0.00634765625, -0.007049560546875, -0.008392333984375, -0.00799560546875, -0.00616455078125, -0.004425048828125, -0.00238037109375, -0.001678466796875, -0.002960205078125, -0.003631591796875, -0.002532958984375, -0.0013427734375, -0.0008544921875, -0.001861572265625, -0.00335693359375, -0.003631591796875, -0.003448486328125, -0.00286865234375, -0.001678466796875, -0.000518798828125, -0.000152587890625, -0.0008544921875, -0.0020751953125, -0.001983642578125, -0.000732421875, -0.00103759765625, -0.002899169921875, -0.003753662109375, -0.003448486328125, -0.002899169921875, -0.002777099609375, -0.003448486328125, -0.004241943359375, -0.00384521484375, -0.0029296875, -0.00286865234375, -0.0030517578125, -0.002349853515625])
        IR_LEFT[len(IR_LEFT)-1].append([0.000152587890625, 0.0, 0.000213623046875, -0.000244140625, 9.1552734375e-05, -0.000244140625, 3.0517578125e-05, 0.0001220703125, -0.0001220703125, 0.000457763671875, 0.00372314453125, 0.052276611328125, 0.10186767578125, 0.062835693359375, -0.173583984375, -0.24432373046875, 0.075897216796875, 0.253448486328125, 0.16607666015625, 0.081146240234375, 0.07403564453125, 0.08038330078125, 0.09246826171875, 0.05535888671875, -0.0433349609375, -0.073699951171875, -0.061279296875, -0.0703125, -0.093475341796875, -0.080596923828125, -0.05926513671875, -0.057159423828125, -0.03466796875, 0.00079345703125, 0.0250244140625, 0.024261474609375, 0.036224365234375, 0.04876708984375, 0.039581298828125, 0.026458740234375, 0.0081787109375, -0.00823974609375, 0.010223388671875, 0.009490966796875, -0.017578125, -0.03143310546875, -0.034393310546875, -0.022857666015625, -0.0225830078125, -0.022705078125, -0.018310546875, -0.013946533203125, -0.008544921875, 0.00323486328125, 0.009979248046875, 0.004547119140625, 0.0037841796875, 0.011474609375, 0.01373291015625, 0.000823974609375, -0.0079345703125, -0.00830078125, -0.012725830078125, -0.01177978515625, -0.00836181640625, -0.012603759765625, -0.013702392578125, -0.00927734375, -0.00616455078125, -0.00494384765625, -0.005035400390625, -0.010162353515625, -0.018402099609375, -0.018707275390625, -0.00970458984375, -0.00518798828125, -0.00872802734375, -0.012054443359375, -0.009765625, -0.0057373046875, -0.002838134765625, -0.001190185546875, 0.00213623046875, 0.003387451171875, 0.000335693359375, -0.00384521484375, -0.008514404296875, -0.009002685546875, -0.00579833984375, -0.0042724609375, -0.00665283203125, -0.008758544921875, -0.007659912109375, -0.00604248046875, -0.00518798828125, -0.00347900390625, -0.002197265625, -0.002716064453125, -0.003875732421875, -0.003143310546875, -0.001861572265625, -0.001678466796875, -0.0020751953125, -0.00286865234375, -0.003448486328125, -0.00372314453125, -0.0030517578125, -0.002227783203125, -0.001800537109375, -0.00140380859375, -0.00152587890625, -0.002227783203125, -0.001556396484375, 0.0, -0.000152587890625, -0.00201416015625, -0.003509521484375, -0.0040283203125, -0.003204345703125, -0.002349853515625, -0.003509521484375, -0.00494384765625, -0.00457763671875, -0.00347900390625, -0.002777099609375, -0.002227783203125, -0.00213623046875, -0.001983642578125])
        IR_LEFT[len(IR_LEFT)-1].append([0.0001220703125, 9.1552734375e-05, -0.000152587890625, -0.0001220703125, 3.0517578125e-05, -0.000335693359375, 0.00048828125, -0.000823974609375, 0.001312255859375, 0.000152587890625, 0.045440673828125, 0.1075439453125, 0.087799072265625, -0.1461181640625, -0.27886962890625, 0.0341796875, 0.269195556640625, 0.188507080078125, 0.08660888671875, 0.07452392578125, 0.082794189453125, 0.0950927734375, 0.0648193359375, -0.0445556640625, -0.08404541015625, -0.0645751953125, -0.071533203125, -0.099090576171875, -0.089111328125, -0.058685302734375, -0.060089111328125, -0.041259765625, -0.003875732421875, 0.022552490234375, 0.023834228515625, 0.037109375, 0.052215576171875, 0.045318603515625, 0.033172607421875, 0.01373291015625, -0.011138916015625, 0.0037841796875, 0.017486572265625, -0.014251708984375, -0.033966064453125, -0.033782958984375, -0.025726318359375, -0.027008056640625, -0.025634765625, -0.020233154296875, -0.01873779296875, -0.011688232421875, 0.00164794921875, 0.01202392578125, 0.01007080078125, 0.008453369140625, 0.014129638671875, 0.015960693359375, 0.0048828125, -0.00830078125, -0.013092041015625, -0.01300048828125, -0.00897216796875, -0.009857177734375, -0.014068603515625, -0.013336181640625, -0.01141357421875, -0.009033203125, -0.005859375, -0.0057373046875, -0.014404296875, -0.021331787109375, -0.015625, -0.00445556640625, -0.002716064453125, -0.006134033203125, -0.008026123046875, -0.007293701171875, -0.005126953125, -0.003814697265625, -0.00213623046875, 0.0006103515625, 0.001983642578125, -0.0008544921875, -0.006561279296875, -0.00994873046875, -0.007537841796875, -0.00494384765625, -0.0050048828125, -0.00592041015625, -0.00628662109375, -0.006927490234375, -0.007171630859375, -0.0057373046875, -0.00347900390625, -0.001953125, -0.002532958984375, -0.0035400390625, -0.003387451171875, -0.00311279296875, -0.00225830078125, -0.00201416015625, -0.0028076171875, -0.003631591796875, -0.00299072265625, -0.002532958984375, -0.002838134765625, -0.00238037109375, -0.00189208984375, -0.0023193359375, -0.002960205078125, -0.001617431640625, -9.1552734375e-05, -9.1552734375e-05, -0.001373291015625, -0.002777099609375, -0.00372314453125, -0.003143310546875, -0.0023193359375, -0.00341796875, -0.004180908203125, -0.004119873046875, -0.004150390625, -0.003265380859375, -0.001861572265625, -0.000823974609375, -0.0010986328125, -0.001922607421875])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -0.0001220703125, -0.000335693359375, 0.000244140625, -0.000701904296875, 0.000701904296875, -0.0013427734375, 0.001678466796875, -0.00140380859375, 0.041412353515625, 0.11505126953125, 0.10693359375, -0.13238525390625, -0.30548095703125, 0.009552001953125, 0.28692626953125, 0.20556640625, 0.089569091796875, 0.075164794921875, 0.086578369140625, 0.099273681640625, 0.07012939453125, -0.050506591796875, -0.098480224609375, -0.0692138671875, -0.074737548828125, -0.10479736328125, -0.096405029296875, -0.061370849609375, -0.060760498046875, -0.042938232421875, -0.00439453125, 0.024566650390625, 0.0228271484375, 0.033172607421875, 0.053070068359375, 0.047698974609375, 0.03546142578125, 0.024078369140625, -0.00433349609375, -0.009124755859375, 0.017059326171875, -0.004730224609375, -0.03839111328125, -0.03802490234375, -0.024658203125, -0.02764892578125, -0.029937744140625, -0.02044677734375, -0.018890380859375, -0.018524169921875, -0.005645751953125, 0.012176513671875, 0.014923095703125, 0.011444091796875, 0.016937255859375, 0.0191650390625, 0.009796142578125, -0.00567626953125, -0.01556396484375, -0.01507568359375, -0.00823974609375, -0.0096435546875, -0.014556884765625, -0.015594482421875, -0.013946533203125, -0.009124755859375, -0.0074462890625, -0.01019287109375, -0.019256591796875, -0.023284912109375, -0.015106201171875, -0.00396728515625, 0.00018310546875, -0.001220703125, -0.004180908203125, -0.00421142578125, -0.002227783203125, -0.00244140625, -0.00360107421875, -0.001129150390625, 0.00128173828125, -0.003509521484375, -0.0103759765625, -0.01080322265625, -0.00701904296875, -0.005615234375, -0.005615234375, -0.005340576171875, -0.00592041015625, -0.006988525390625, -0.007049560546875, -0.00665283203125, -0.003814697265625, -0.001220703125, -0.001922607421875, -0.004058837890625, -0.00439453125, -0.00384521484375, -0.003021240234375, -0.002166748046875, -0.003173828125, -0.0040283203125, -0.003662109375, -0.003021240234375, -0.002685546875, -0.00244140625, -0.002532958984375, -0.00299072265625, -0.00323486328125, -0.002685546875, -0.001678466796875, -0.000946044921875, -0.001556396484375, -0.003173828125, -0.00408935546875, -0.003143310546875, -0.002685546875, -0.003570556640625, -0.003875732421875, -0.003997802734375, -0.004119873046875, -0.003631591796875, -0.002288818359375, -0.000946044921875, -0.001007080078125, -0.001708984375, -0.002899169921875])
        IR_LEFT[len(IR_LEFT)-1].append([9.1552734375e-05, -0.000457763671875, 0.000396728515625, -0.000762939453125, 0.00103759765625, -0.001495361328125, 0.00201416015625, -0.00225830078125, 0.038970947265625, 0.12396240234375, 0.12548828125, -0.12286376953125, -0.332427978515625, -0.00994873046875, 0.309234619140625, 0.222808837890625, 0.09033203125, 0.076446533203125, 0.09320068359375, 0.105194091796875, 0.073394775390625, -0.059844970703125, -0.115753173828125, -0.0751953125, -0.07818603515625, -0.112884521484375, -0.103729248046875, -0.060821533203125, -0.062774658203125, -0.045562744140625, 0.000823974609375, 0.02996826171875, 0.025665283203125, 0.031829833984375, 0.050445556640625, 0.048858642578125, 0.035308837890625, 0.027923583984375, 0.00836181640625, -0.011505126953125, 0.007476806640625, 0.000640869140625, -0.037322998046875, -0.04443359375, -0.026214599609375, -0.028533935546875, -0.029937744140625, -0.018157958984375, -0.0162353515625, -0.0211181640625, -0.013336181640625, 0.005279541015625, 0.018341064453125, 0.0179443359375, 0.017730712890625, 0.0191650390625, 0.013916015625, -0.001007080078125, -0.014404296875, -0.012908935546875, -0.009033203125, -0.01129150390625, -0.0135498046875, -0.015228271484375, -0.01605224609375, -0.01055908203125, -0.0074462890625, -0.013916015625, -0.0252685546875, -0.0252685546875, -0.013946533203125, -0.00341796875, 0.000579833984375, 0.00238037109375, 0.00189208984375, 0.00091552734375, 0.00115966796875, -0.00048828125, -0.002166748046875, -0.0001220703125, -0.00030517578125, -0.00726318359375, -0.011444091796875, -0.009979248046875, -0.00787353515625, -0.00726318359375, -0.004974365234375, -0.003814697265625, -0.005828857421875, -0.0076904296875, -0.007537841796875, -0.006103515625, -0.00201416015625, 0.00048828125, -0.0010986328125, -0.00390625, -0.00506591796875, -0.004241943359375, -0.002044677734375, -0.00152587890625, -0.003082275390625, -0.0040283203125, -0.00421142578125, -0.003570556640625, -0.002227783203125, -0.00140380859375, -0.00177001953125, -0.002593994140625, -0.003204345703125, -0.002593994140625, -0.001922607421875, -0.00146484375, -0.001922607421875, -0.0030517578125, -0.0037841796875, -0.003387451171875, -0.00262451171875, -0.002593994140625, -0.0029296875, -0.003173828125, -0.003082275390625, -0.002716064453125, -0.00152587890625, -0.000457763671875, -0.00048828125, -0.00152587890625, -0.0025634765625, -0.003204345703125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000518798828125, 0.00054931640625, -0.00103759765625, 0.0010986328125, -0.001678466796875, 0.002044677734375, -0.00286865234375, 0.035369873046875, 0.131622314453125, 0.145751953125, -0.10699462890625, -0.358734130859375, -0.038909912109375, 0.328887939453125, 0.2445068359375, 0.0919189453125, 0.076019287109375, 0.100341796875, 0.112457275390625, 0.0782470703125, -0.068572998046875, -0.13671875, -0.0841064453125, -0.080780029296875, -0.12017822265625, -0.113739013671875, -0.06207275390625, -0.06170654296875, -0.049591064453125, 0.003082275390625, 0.038543701171875, 0.029693603515625, 0.033447265625, 0.04833984375, 0.046722412109375, 0.03619384765625, 0.0264892578125, 0.017730712890625, -0.00494384765625, -0.002685546875, -0.001220703125, -0.031036376953125, -0.051727294921875, -0.031585693359375, -0.02935791015625, -0.032257080078125, -0.01605224609375, -0.0101318359375, -0.018646240234375, -0.01983642578125, -0.003173828125, 0.016082763671875, 0.022308349609375, 0.0208740234375, 0.01898193359375, 0.01153564453125, 0.000213623046875, -0.00909423828125, -0.0089111328125, -0.008514404296875, -0.01263427734375, -0.014739990234375, -0.014556884765625, -0.015472412109375, -0.0115966796875, -0.01025390625, -0.019012451171875, -0.028564453125, -0.0264892578125, -0.015472412109375, -0.003631591796875, 0.0010986328125, 0.00384521484375, 0.004791259765625, 0.00634765625, 0.00543212890625, 0.00054931640625, -0.0008544921875, 0.001190185546875, -0.00018310546875, -0.008544921875, -0.01287841796875, -0.01239013671875, -0.00958251953125, -0.007110595703125, -0.003875732421875, -0.0045166015625, -0.007720947265625, -0.00848388671875, -0.007781982421875, -0.00537109375, -0.001068115234375, 0.00146484375, 9.1552734375e-05, -0.003875732421875, -0.006195068359375, -0.003875732421875, -0.001373291015625, -0.001953125, -0.00341796875, -0.004364013671875, -0.005157470703125, -0.00433349609375, -0.002349853515625, -0.001068115234375, -0.00146484375, -0.00225830078125, -0.00341796875, -0.003570556640625, -0.002197265625, -0.001251220703125, -0.002288818359375, -0.004180908203125, -0.00482177734375, -0.003814697265625, -0.0025634765625, -0.00262451171875, -0.0028076171875, -0.002685546875, -0.002777099609375, -0.0023193359375, -0.001068115234375, -0.000274658203125, -0.000518798828125, -0.0015869140625, -0.002593994140625, -0.003173828125, -0.0025634765625])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000152587890625, -0.000152587890625, -0.000213623046875, 0.00054931640625, -0.00018310546875, 0.00048828125, -0.000579833984375, 0.000335693359375, -0.000213623046875, -0.00018310546875, 0.000823974609375, -0.0018310546875, 0.002471923828125, 0.0078125, 0.099700927734375, 0.128875732421875, 0.13519287109375, -0.22265625, -0.38616943359375, 0.1700439453125, 0.348785400390625, 0.21612548828125, 0.10595703125, 0.098907470703125, 0.10137939453125, 0.0655517578125, -0.02337646484375, -0.177490234375, -0.193572998046875, -0.162628173828125, -0.097137451171875, -0.0928955078125, -0.077606201171875, -0.016387939453125, 0.001708984375, 0.025787353515625, 0.04638671875, 0.073944091796875, 0.051361083984375, 0.037567138671875, 0.03814697265625, 0.034423828125, 0.006866455078125, -0.0216064453125, -0.007110595703125, -0.00311279296875, -0.006744384765625, -0.027069091796875, -0.04705810546875, -0.06280517578125, -0.0509033203125, -0.030181884765625, -0.01116943359375, 0.0089111328125, 0.024200439453125, 0.0281982421875, 0.020263671875, 0.02154541015625, 0.026641845703125, 0.016143798828125, 0.000823974609375, -0.01080322265625, -0.0181884765625, -0.01953125, -0.016265869140625, -0.017730712890625, -0.02117919921875, -0.012481689453125, -0.006500244140625, -0.000701904296875, -0.00128173828125, -0.006439208984375, -0.008880615234375, -0.014068603515625, -0.025115966796875, -0.032958984375, -0.024932861328125, -0.007049560546875, 0.00384521484375, 0.0013427734375, -0.0032958984375, -0.001220703125, 0.003387451171875, 0.001617431640625, -0.00299072265625, -0.003143310546875, -0.00225830078125, -0.006683349609375, -0.0108642578125, -0.010498046875, -0.0062255859375, -0.00201416015625, 9.1552734375e-05, -0.003143310546875, -0.008392333984375, -0.0101318359375, -0.008331298828125, -0.0054931640625, -0.002105712890625, -0.000732421875, -0.0045166015625, -0.00762939453125, -0.00537109375, 0.000152587890625, 0.0028076171875, 0.000946044921875, -0.00323486328125, -0.00408935546875, -0.0025634765625, -3.0517578125e-05, 0.00250244140625, 0.0015869140625, -0.002166748046875, -0.005523681640625, -0.007049560546875, -0.00592041015625, -0.003173828125, -0.002288818359375, -0.004730224609375, -0.00677490234375, -0.006927490234375, -0.00408935546875, 9.1552734375e-05, 0.0010986328125, -0.00054931640625, -0.001220703125, -0.000946044921875, -0.00146484375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -0.0001220703125, -9.1552734375e-05, -0.00018310546875, 0.00042724609375, -0.0001220703125, 0.00048828125, -0.0006103515625, 0.000396728515625, -0.00042724609375, 3.0517578125e-05, 0.00030517578125, -0.001007080078125, 0.001373291015625, 0.00982666015625, 0.0877685546875, 0.1131591796875, 0.10943603515625, -0.209259033203125, -0.33544921875, 0.1422119140625, 0.319580078125, 0.217681884765625, 0.1009521484375, 0.085601806640625, 0.09393310546875, 0.066619873046875, -0.01025390625, -0.142974853515625, -0.167449951171875, -0.143035888671875, -0.088714599609375, -0.083984375, -0.075103759765625, -0.029327392578125, -0.01080322265625, 0.011810302734375, 0.036773681640625, 0.063446044921875, 0.0487060546875, 0.04302978515625, 0.04205322265625, 0.03570556640625, 0.011962890625, -0.01629638671875, -0.008270263671875, -0.003204345703125, -0.00634765625, -0.02581787109375, -0.043487548828125, -0.055389404296875, -0.04656982421875, -0.029815673828125, -0.012054443359375, 0.00482177734375, 0.016448974609375, 0.0224609375, 0.017852783203125, 0.0189208984375, 0.024566650390625, 0.01678466796875, 0.004150390625, -0.008056640625, -0.017242431640625, -0.020416259765625, -0.015594482421875, -0.01177978515625, -0.020355224609375, -0.0164794921875, -0.00634765625, -0.003173828125, -0.004058837890625, -0.005340576171875, -0.0064697265625, -0.01171875, -0.02056884765625, -0.025726318359375, -0.020721435546875, -0.00823974609375, 0.001129150390625, -0.000579833984375, -0.00640869140625, -0.006805419921875, -0.00372314453125, -0.00177001953125, -0.003082275390625, -0.0029296875, -0.002960205078125, -0.0059814453125, -0.008697509765625, -0.00830078125, -0.00457763671875, -0.003631591796875, -0.00238037109375, -0.002593994140625, -0.005828857421875, -0.008087158203125, -0.008544921875, -0.006011962890625, -0.002197265625, -0.000823974609375, -0.00390625, -0.00738525390625, -0.005950927734375, -0.001312255859375, 0.001983642578125, 0.000640869140625, -0.003082275390625, -0.003448486328125, -0.001678466796875, 0.00079345703125, 0.002716064453125, 0.002410888671875, -0.00091552734375, -0.004730224609375, -0.00634765625, -0.0059814453125, -0.003997802734375, -0.003753662109375, -0.005340576171875, -0.00653076171875, -0.00665283203125, -0.004241943359375, -0.0006103515625, 0.00140380859375, 0.000518798828125, -0.00140380859375, -0.001678466796875])
        IR_LEFT[len(IR_LEFT)-1].append([-3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, -0.0001220703125, -0.000152587890625, 0.000396728515625, 0.0, 0.0003662109375, -0.00048828125, 0.0003662109375, -0.0003662109375, 0.000152587890625, 0.00018310546875, -0.000701904296875, 0.001068115234375, 0.00927734375, 0.074981689453125, 0.099334716796875, 0.092803955078125, -0.183380126953125, -0.30413818359375, 0.1058349609375, 0.295166015625, 0.215301513671875, 0.099700927734375, 0.078704833984375, 0.0858154296875, 0.0675048828125, 0.007568359375, -0.11187744140625, -0.143646240234375, -0.1260986328125, -0.08209228515625, -0.07708740234375, -0.072998046875, -0.039215087890625, -0.01904296875, 0.00408935546875, 0.0263671875, 0.054779052734375, 0.047027587890625, 0.0433349609375, 0.043609619140625, 0.03662109375, 0.015411376953125, -0.010650634765625, -0.007659912109375, -0.004486083984375, -0.00714111328125, -0.025360107421875, -0.039306640625, -0.04901123046875, -0.043701171875, -0.029327392578125, -0.013641357421875, 0.00018310546875, 0.0072021484375, 0.02044677734375, 0.023040771484375, 0.016937255859375, 0.01953125, 0.01824951171875, 0.00732421875, -0.009124755859375, -0.017822265625, -0.01837158203125, -0.015655517578125, -0.014068603515625, -0.019134521484375, -0.0147705078125, -0.0067138671875, -0.006195068359375, -0.00634765625, -0.001007080078125, -0.0020751953125, -0.01068115234375, -0.017425537109375, -0.0174560546875, -0.015380859375, -0.01220703125, -0.00604248046875, -0.003082275390625, -0.00592041015625, -0.0086669921875, -0.0087890625, -0.008056640625, -0.004974365234375, -0.001495361328125, -0.00244140625, -0.006591796875, -0.0078125, -0.00677490234375, -0.00408935546875, -0.002471923828125, -0.001708984375, -0.002593994140625, -0.0045166015625, -0.005615234375, -0.006439208984375, -0.005828857421875, -0.00360107421875, -0.0023193359375, -0.004180908203125, -0.006866455078125, -0.00665283203125, -0.003082275390625, 6.103515625e-05, -0.00018310546875, -0.002044677734375, -0.002044677734375, -0.00018310546875, 0.001678466796875, 0.00286865234375, 0.002105712890625, -0.00042724609375, -0.00347900390625, -0.006256103515625, -0.00634765625, -0.00469970703125, -0.0042724609375, -0.00567626953125, -0.0062255859375, -0.005889892578125, -0.00433349609375, -0.001129150390625, 0.0010986328125, 0.001068115234375, -0.0003662109375])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, 0.0, 0.0, -9.1552734375e-05, -6.103515625e-05, -0.00018310546875, 0.000274658203125, -6.103515625e-05, 0.0003662109375, -0.000518798828125, 0.0003662109375, -0.00054931640625, 0.000396728515625, -0.000335693359375, 0.0, 0.000274658203125, 0.0113525390625, 0.06817626953125, 0.090606689453125, 0.0736083984375, -0.1878662109375, -0.267364501953125, 0.106048583984375, 0.275177001953125, 0.199615478515625, 0.092742919921875, 0.07733154296875, 0.079010009765625, 0.067108154296875, 0.01373291015625, -0.092559814453125, -0.123809814453125, -0.10784912109375, -0.074005126953125, -0.0745849609375, -0.067108154296875, -0.041656494140625, -0.022491455078125, -0.000823974609375, 0.020721435546875, 0.04742431640625, 0.041839599609375, 0.041839599609375, 0.04327392578125, 0.03656005859375, 0.015472412109375, -0.006103515625, -0.009124755859375, -0.007659912109375, -0.009124755859375, -0.02496337890625, -0.036407470703125, -0.0452880859375, -0.03924560546875, -0.02777099609375, -0.01873779296875, -0.00286865234375, 0.015899658203125, 0.02154541015625, 0.015838623046875, 0.015228271484375, 0.018463134765625, 0.015716552734375, 0.0037841796875, -0.009796142578125, -0.01739501953125, -0.02008056640625, -0.016845703125, -0.011962890625, -0.015380859375, -0.015594482421875, -0.00885009765625, -0.003997802734375, -0.00372314453125, -0.001312255859375, -9.1552734375e-05, -0.0064697265625, -0.01422119140625, -0.01458740234375, -0.014404296875, -0.01556396484375, -0.010894775390625, -0.005157470703125, -0.0068359375, -0.01116943359375, -0.010955810546875, -0.0096435546875, -0.007415771484375, -0.002532958984375, -0.001220703125, -0.0057373046875, -0.007476806640625, -0.0052490234375, -0.002777099609375, -0.001373291015625, -0.000274658203125, -0.001953125, -0.004241943359375, -0.004638671875, -0.004852294921875, -0.00653076171875, -0.00604248046875, -0.003875732421875, -0.004608154296875, -0.006927490234375, -0.007171630859375, -0.00433349609375, -0.0010986328125, 3.0517578125e-05, -0.00042724609375, -0.000396728515625, 0.00042724609375, 0.00177001953125, 0.002532958984375, 0.00140380859375, -0.0008544921875, -0.003173828125, -0.0057373046875, -0.00640869140625, -0.005157470703125, -0.00469970703125, -0.005706787109375, -0.00604248046875, -0.00506591796875, -0.00323486328125, -0.0008544921875, 0.000244140625, -0.0001220703125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.00018310546875, 0.0, -3.0517578125e-05, 3.0517578125e-05, -9.1552734375e-05, -9.1552734375e-05, -0.0001220703125, 0.00030517578125, -9.1552734375e-05, 0.000335693359375, -0.0006103515625, 0.00054931640625, -0.0008544921875, 0.0009765625, -0.00115966796875, 0.0013427734375, -0.001220703125, 0.019927978515625, 0.068267822265625, 0.088531494140625, 0.03472900390625, -0.23150634765625, -0.200439453125, 0.15570068359375, 0.257049560546875, 0.16558837890625, 0.080810546875, 0.079925537109375, 0.07342529296875, 0.06561279296875, 0.00341796875, -0.088653564453125, -0.109710693359375, -0.088531494140625, -0.066070556640625, -0.074554443359375, -0.05682373046875, -0.037750244140625, -0.022308349609375, -0.00201416015625, 0.0230712890625, 0.041473388671875, 0.03369140625, 0.040771484375, 0.04327392578125, 0.03302001953125, 0.00982666015625, -0.00726318359375, -0.012359619140625, -0.007049560546875, -0.009521484375, -0.027435302734375, -0.035888671875, -0.03985595703125, -0.0418701171875, -0.026885986328125, 0.001373291015625, 0.004974365234375, 0.006744384765625, 0.018280029296875, 0.015228271484375, 0.011322021484375, 0.015869140625, 0.010650634765625, -0.0048828125, -0.01507568359375, -0.015380859375, -0.0113525390625, -0.012664794921875, -0.0181884765625, -0.017364501953125, -0.008941650390625, -0.00421142578125, -0.006195068359375, -0.00408935546875, 0.002685546875, 0.001678466796875, -0.006500244140625, -0.011871337890625, -0.0135498046875, -0.017120361328125, -0.019012451171875, -0.012969970703125, -0.007354736328125, -0.010040283203125, -0.01190185546875, -0.010345458984375, -0.0098876953125, -0.00738525390625, -0.0010986328125, -0.000518798828125, -0.005035400390625, -0.005645751953125, -0.00323486328125, -0.001129150390625, -0.000518798828125, 0.0, -0.0025634765625, -0.0054931640625, -0.005279541015625, -0.005218505859375, -0.007476806640625, -0.007232666015625, -0.004730224609375, -0.004730224609375, -0.00701904296875, -0.0068359375, -0.003448486328125, -0.00048828125, 0.000518798828125, 0.00030517578125, 0.000244140625, 0.00067138671875, 0.00164794921875, 0.001708984375, 0.000335693359375, -0.001220703125, -0.003265380859375, -0.00543212890625, -0.006103515625, -0.005279541015625, -0.005157470703125, -0.00537109375, -0.00457763671875, -0.003875732421875, -0.002685546875, -0.00115966796875, -0.000152587890625])
        IR_LEFT[len(IR_LEFT)-1].append([-9.1552734375e-05, -0.0001220703125, -3.0517578125e-05, 0.0, -3.0517578125e-05, -0.0001220703125, -0.0001220703125, 0.0001220703125, 9.1552734375e-05, 9.1552734375e-05, -3.0517578125e-05, -0.000274658203125, 0.000213623046875, -0.000579833984375, 0.000946044921875, -0.001220703125, 0.001922607421875, 0.0003662109375, 0.041015625, 0.074554443359375, 0.084320068359375, -0.073516845703125, -0.276031494140625, -0.041259765625, 0.23126220703125, 0.2144775390625, 0.11181640625, 0.076812744140625, 0.080322265625, 0.071441650390625, 0.055999755859375, -0.033660888671875, -0.095916748046875, -0.095733642578125, -0.06817626953125, -0.0667724609375, -0.071685791015625, -0.042938232421875, -0.029998779296875, -0.017242431640625, 0.00311279296875, 0.033233642578125, 0.0325927734375, 0.027099609375, 0.043975830078125, 0.041229248046875, 0.01776123046875, -0.0009765625, -0.005828857421875, -0.01025390625, -0.008209228515625, -0.012969970703125, -0.029296875, -0.04925537109375, -0.039794921875, -0.013519287109375, -0.0068359375, -0.003692626953125, 0.003448486328125, 0.010345458984375, 0.01239013671875, 0.010040283203125, 0.011627197265625, 0.00762939453125, -0.006378173828125, -0.009979248046875, -0.00384521484375, -0.005706787109375, -0.014556884765625, -0.01788330078125, -0.01409912109375, -0.012115478515625, -0.010009765625, -0.00494384765625, -0.002838134765625, -0.000274658203125, 0.0032958984375, 0.0006103515625, -0.006927490234375, -0.01068115234375, -0.015411376953125, -0.02197265625, -0.0218505859375, -0.01324462890625, -0.008758544921875, -0.01226806640625, -0.011444091796875, -0.00848388671875, -0.007049560546875, -0.003265380859375, 0.001373291015625, -0.00079345703125, -0.004241943359375, -0.0030517578125, -0.00079345703125, -0.00067138671875, -0.00146484375, -0.002685546875, -0.0054931640625, -0.006622314453125, -0.00555419921875, -0.006805419921875, -0.008697509765625, -0.006103515625, -0.003509521484375, -0.004730224609375, -0.006561279296875, -0.00494384765625, -0.00152587890625, 0.000244140625, 0.000213623046875, 0.000335693359375, 0.00054931640625, 0.000762939453125, 0.001007080078125, 0.000640869140625, -0.000457763671875, -0.00189208984375, -0.003936767578125, -0.005462646484375, -0.005340576171875, -0.004486083984375, -0.004180908203125, -0.0042724609375, -0.003997802734375, -0.003387451171875, -0.001708984375, -0.000396728515625])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, -6.103515625e-05, -3.0517578125e-05, 0.0, 0.0, -9.1552734375e-05, -9.1552734375e-05, 6.103515625e-05, 0.000213623046875, -3.0517578125e-05, 0.000274658203125, -0.000396728515625, 0.00048828125, -0.000885009765625, 0.00115966796875, -0.0010986328125, 0.00201416015625, -0.00177001953125, 0.02587890625, 0.06793212890625, 0.086883544921875, -0.01165771484375, -0.252410888671875, -0.129730224609375, 0.18853759765625, 0.2283935546875, 0.125640869140625, 0.078216552734375, 0.086944580078125, 0.07354736328125, 0.072235107421875, -0.000335693359375, -0.084442138671875, -0.092864990234375, -0.072723388671875, -0.06671142578125, -0.074981689453125, -0.0513916015625, -0.032562255859375, -0.01849365234375, -0.0059814453125, 0.021728515625, 0.036865234375, 0.025115966796875, 0.031646728515625, 0.041595458984375, 0.02813720703125, 0.000518798828125, -0.0029296875, -0.00555419921875, -0.007354736328125, -0.011810302734375, -0.03662109375, -0.043487548828125, -0.024993896484375, -0.0152587890625, -0.010406494140625, -0.00482177734375, 0.001922607421875, 0.008941650390625, 0.006103515625, 0.005096435546875, 0.00567626953125, 0.002593994140625, -0.00262451171875, -0.0028076171875, -0.001190185546875, -0.0057373046875, -0.010589599609375, -0.008880615234375, -0.01226806640625, -0.020416259765625, -0.0162353515625, -0.003753662109375, 0.0, -0.00079345703125, 0.002044677734375, 0.002288818359375, -0.00250244140625, -0.006591796875, -0.011474609375, -0.0220947265625, -0.028106689453125, -0.02020263671875, -0.01043701171875, -0.00994873046875, -0.01129150390625, -0.009490966796875, -0.00604248046875, -0.00042724609375, 0.003936767578125, 0.000732421875, -0.002716064453125, -0.001708984375, -0.000396728515625, -0.001190185546875, -0.003387451171875, -0.004791259765625, -0.00640869140625, -0.006805419921875, -0.006591796875, -0.007537841796875, -0.007843017578125, -0.00537109375, -0.0030517578125, -0.0035400390625, -0.0050048828125, -0.004425048828125, -0.002227783203125, -0.000152587890625, -0.000213623046875, -0.000396728515625, 0.000152587890625, 0.000396728515625, 0.00048828125, 0.000335693359375, -0.0003662109375, -0.001800537109375, -0.002899169921875, -0.0040283203125, -0.0042724609375, -0.003570556640625, -0.00311279296875, -0.003692626953125, -0.0040283203125, -0.00286865234375, -0.0015869140625, -0.00115966796875])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, -6.103515625e-05, 0.0, 3.0517578125e-05, 3.0517578125e-05, -6.103515625e-05, -6.103515625e-05, 3.0517578125e-05, 0.000213623046875, -3.0517578125e-05, 0.000213623046875, -0.000396728515625, 0.00048828125, -0.0008544921875, 0.001129150390625, -0.001129150390625, 0.002166748046875, -0.001800537109375, 0.02899169921875, 0.07196044921875, 0.088043212890625, -0.034210205078125, -0.26373291015625, -0.096710205078125, 0.21099853515625, 0.217041015625, 0.10906982421875, 0.077301025390625, 0.091644287109375, 0.078826904296875, 0.07147216796875, -0.00531005859375, -0.085052490234375, -0.0911865234375, -0.07086181640625, -0.074859619140625, -0.082550048828125, -0.050506591796875, -0.03375244140625, -0.0206298828125, 0.00042724609375, 0.0272216796875, 0.033203125, 0.0263671875, 0.03497314453125, 0.035614013671875, 0.0234375, 0.008087158203125, -0.002593994140625, -0.006866455078125, -0.004058837890625, -0.026580810546875, -0.03924560546875, -0.027252197265625, -0.0235595703125, -0.01953125, -0.01214599609375, -0.00146484375, 0.005950927734375, 0.00653076171875, 0.003662109375, -0.001129150390625, -0.002716064453125, 0.0035400390625, 0.00750732421875, -0.000152587890625, -0.008575439453125, -0.00750732421875, -0.000762939453125, -0.003570556640625, -0.01812744140625, -0.0238037109375, -0.0159912109375, -0.00628662109375, -0.001312255859375, 0.001068115234375, 0.0015869140625, 0.0018310546875, -0.000213623046875, -0.004547119140625, -0.01068115234375, -0.021697998046875, -0.029205322265625, -0.023468017578125, -0.01177978515625, -0.009429931640625, -0.01220703125, -0.010986328125, -0.003173828125, 0.00408935546875, 0.004058837890625, 0.001251220703125, -0.00042724609375, -0.0006103515625, -0.001495361328125, -0.0029296875, -0.00543212890625, -0.007293701171875, -0.00714111328125, -0.007293701171875, -0.008697509765625, -0.008697509765625, -0.005340576171875, -0.003082275390625, -0.00323486328125, -0.004119873046875, -0.00439453125, -0.003265380859375, -0.001922607421875, -0.0006103515625, -0.001220703125, -0.001495361328125, -0.0008544921875, -0.000213623046875, -0.000213623046875, -0.000762939453125, -0.0013427734375, -0.002105712890625, -0.0025634765625, -0.002899169921875, -0.003143310546875, -0.0030517578125, -0.00262451171875, -0.0029296875, -0.003173828125, -0.0029296875, -0.002105712890625, -0.00225830078125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -9.1552734375e-05, 3.0517578125e-05, 0.0, -3.0517578125e-05, -9.1552734375e-05, -0.00018310546875, 0.00018310546875, -3.0517578125e-05, 0.0001220703125, -0.000274658203125, 9.1552734375e-05, -0.000213623046875, -0.000152587890625, 0.000213623046875, -0.000213623046875, 0.00079345703125, 0.0037841796875, 0.051300048828125, 0.088165283203125, 0.06866455078125, -0.152862548828125, -0.257110595703125, 0.065673828125, 0.257720947265625, 0.165313720703125, 0.077178955078125, 0.08697509765625, 0.091033935546875, 0.0831298828125, 0.050537109375, -0.0521240234375, -0.095550537109375, -0.080718994140625, -0.07379150390625, -0.090728759765625, -0.079833984375, -0.04766845703125, -0.03326416015625, -0.01495361328125, 0.015228271484375, 0.04449462890625, 0.032318115234375, 0.027099609375, 0.041473388671875, 0.036407470703125, 0.01214599609375, 3.0517578125e-05, 0.0037841796875, -0.00604248046875, -0.025146484375, -0.0283203125, -0.02630615234375, -0.033843994140625, -0.025146484375, -0.017059326171875, -0.0107421875, 0.0013427734375, 0.00933837890625, 0.006683349609375, -0.0023193359375, -0.002899169921875, 0.004425048828125, 0.0086669921875, 0.004638671875, -0.002471923828125, -0.008575439453125, -0.00531005859375, -0.001129150390625, -0.01019287109375, -0.022003173828125, -0.0201416015625, -0.01153564453125, -0.008392333984375, -0.0048828125, 0.000885009765625, 0.00347900390625, 0.002838134765625, -0.000396728515625, -0.006072998046875, -0.015594482421875, -0.022857666015625, -0.02294921875, -0.016571044921875, -0.013458251953125, -0.014739990234375, -0.01324462890625, -0.00531005859375, 0.00189208984375, 0.002716064453125, 0.003936767578125, 0.002777099609375, 0.0001220703125, -0.00164794921875, -0.00323486328125, -0.006072998046875, -0.007598876953125, -0.00653076171875, -0.0074462890625, -0.00958251953125, -0.0093994140625, -0.006500244140625, -0.003173828125, -0.0020751953125, -0.00323486328125, -0.0050048828125, -0.004669189453125, -0.002655029296875, -0.000701904296875, -0.000701904296875, -0.0025634765625, -0.002471923828125, -0.001190185546875, -0.0009765625, -0.00128173828125, -0.0015869140625, -0.001983642578125, -0.002288818359375, -0.002716064453125, -0.002593994140625, -0.001983642578125, -0.001800537109375, -0.00189208984375, -0.001861572265625, -0.002410888671875, -0.00323486328125, -0.002838134765625, -0.00274658203125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000152587890625, 0.0, 0.0, -3.0517578125e-05, -0.000152587890625, -0.0001220703125, 0.0, 0.000152587890625, -9.1552734375e-05, 3.0517578125e-05, -0.000396728515625, 0.000335693359375, -0.000885009765625, 0.0009765625, -0.00140380859375, 0.002105712890625, -0.001739501953125, 0.0352783203125, 0.08740234375, 0.097686767578125, -0.072479248046875, -0.28900146484375, -0.044403076171875, 0.2584228515625, 0.20806884765625, 0.08795166015625, 0.0792236328125, 0.097991943359375, 0.085662841796875, 0.071258544921875, -0.026611328125, -0.103057861328125, -0.089569091796875, -0.073394775390625, -0.09228515625, -0.097747802734375, -0.05804443359375, -0.04278564453125, -0.03045654296875, 0.0052490234375, 0.045867919921875, 0.04437255859375, 0.03375244140625, 0.04449462890625, 0.039337158203125, 0.022003173828125, 0.003997802734375, 3.0517578125e-05, -0.006622314453125, -0.019317626953125, -0.024658203125, -0.027587890625, -0.035125732421875, -0.03057861328125, -0.024627685546875, -0.015472412109375, -0.003082275390625, 0.004852294921875, 0.0069580078125, 0.001495361328125, -0.001007080078125, 0.0067138671875, 0.0167236328125, 0.00872802734375, -0.004486083984375, -0.006622314453125, -0.001556396484375, -0.004486083984375, -0.0142822265625, -0.02117919921875, -0.0191650390625, -0.011474609375, -0.0101318359375, -0.010223388671875, -0.00433349609375, 0.0030517578125, 0.00335693359375, -0.00103759765625, -0.00396728515625, -0.011688232421875, -0.020477294921875, -0.018218994140625, -0.010223388671875, -0.01226806640625, -0.018096923828125, -0.014556884765625, -0.00634765625, -0.001434326171875, 0.001739501953125, 0.004638671875, 0.0023193359375, -0.000213623046875, -0.00140380859375, -0.003662109375, -0.0069580078125, -0.006988525390625, -0.005218505859375, -0.006988525390625, -0.009490966796875, -0.009063720703125, -0.006072998046875, -0.00341796875, -0.002410888671875, -0.002685546875, -0.00445556640625, -0.005462646484375, -0.004180908203125, -0.00152587890625, -0.00042724609375, -0.002227783203125, -0.00244140625, -0.002044677734375, -0.00213623046875, -0.001953125, -0.00146484375, -0.001678466796875, -0.0025634765625, -0.00311279296875, -0.003143310546875, -0.00201416015625, -0.00067138671875, -0.0003662109375, -0.00128173828125, -0.00250244140625, -0.0028076171875, -0.002685546875, -0.002838134765625, -0.00323486328125])
        IR_LEFT[len(IR_LEFT)-1].append([-6.103515625e-05, -3.0517578125e-05, 0.0, -0.0001220703125, -0.000152587890625, 0.0, 0.000244140625, -0.0001220703125, 0.00018310546875, -0.00054931640625, 0.000518798828125, -0.00103759765625, 0.0010986328125, -0.001617431640625, 0.002166748046875, -0.00250244140625, 0.03033447265625, 0.0933837890625, 0.113433837890625, -0.0496826171875, -0.30352783203125, -0.07977294921875, 0.2705078125, 0.227264404296875, 0.09014892578125, 0.08050537109375, 0.10302734375, 0.08843994140625, 0.074249267578125, -0.025970458984375, -0.115509033203125, -0.0980224609375, -0.076416015625, -0.099212646484375, -0.106597900390625, -0.06085205078125, -0.044525146484375, -0.0367431640625, 0.0, 0.045684814453125, 0.04833984375, 0.03857421875, 0.0518798828125, 0.04766845703125, 0.0257568359375, 0.001983642578125, 0.001739501953125, -0.004791259765625, -0.02215576171875, -0.02874755859375, -0.0252685546875, -0.034576416015625, -0.03765869140625, -0.026397705078125, -0.016265869140625, -0.008056640625, 0.000457763671875, 0.007598876953125, 0.000335693359375, -0.00250244140625, 0.011566162109375, 0.022735595703125, 0.0150146484375, 0.000946044921875, -0.00543212890625, -0.0042724609375, -0.004302978515625, -0.013397216796875, -0.026214599609375, -0.02227783203125, -0.012054443359375, -0.010711669921875, -0.009002685546875, -0.004608154296875, -0.0008544921875, 0.0003662109375, -0.001739501953125, -0.00775146484375, -0.01519775390625, -0.015899658203125, -0.010284423828125, -0.006683349609375, -0.011077880859375, -0.013427734375, -0.008941650390625, -0.00592041015625, -0.00372314453125, -0.000885009765625, 0.00250244140625, 0.0013427734375, -0.00201416015625, -0.004302978515625, -0.006378173828125, -0.00640869140625, -0.004486083984375, -0.004364013671875, -0.007080078125, -0.008941650390625, -0.0076904296875, -0.004913330078125, -0.00323486328125, -0.002197265625, -0.00274658203125, -0.005035400390625, -0.006256103515625, -0.00433349609375, -0.00164794921875, -0.001617431640625, -0.00274658203125, -0.002532958984375, -0.0018310546875, -0.0023193359375, -0.002593994140625, -0.001678466796875, -0.0015869140625, -0.00244140625, -0.00372314453125, -0.00372314453125, -0.00213623046875, -0.000335693359375, 9.1552734375e-05, -0.0013427734375, -0.0028076171875, -0.00323486328125, -0.002227783203125, -0.002044677734375, -0.00299072265625, -0.003387451171875])
        IR_LEFT[len(IR_LEFT)-1].append([3.0517578125e-05, 0.0, -0.000152587890625, -9.1552734375e-05, 3.0517578125e-05, 0.000244140625, -0.000152587890625, 0.000244140625, -0.000579833984375, 0.000640869140625, -0.001129150390625, 0.0013427734375, -0.001861572265625, 0.002410888671875, -0.00299072265625, 0.03338623046875, 0.106964111328125, 0.12762451171875, -0.06146240234375, -0.328704833984375, -0.06329345703125, 0.30133056640625, 0.22723388671875, 0.083953857421875, 0.08843994140625, 0.111328125, 0.089447021484375, 0.0694580078125, -0.046661376953125, -0.135009765625, -0.102813720703125, -0.08154296875, -0.11016845703125, -0.1153564453125, -0.05743408203125, -0.041351318359375, -0.036865234375, 0.005859375, 0.052520751953125, 0.047271728515625, 0.038665771484375, 0.0556640625, 0.049468994140625, 0.031219482421875, 0.004638671875, -0.00152587890625, -0.0048828125, -0.0164794921875, -0.034576416015625, -0.0382080078125, -0.034820556640625, -0.03741455078125, -0.0283203125, -0.01483154296875, -0.008636474609375, 0.0001220703125, 0.006317138671875, -0.00079345703125, -0.003021240234375, 0.010498046875, 0.0238037109375, 0.02069091796875, 0.0062255859375, -0.0029296875, -0.001068115234375, -0.004119873046875, -0.018280029296875, -0.026519775390625, -0.020660400390625, -0.017364501953125, -0.014373779296875, -0.006591796875, -0.00238037109375, -0.00225830078125, -0.002471923828125, -0.006988525390625, -0.01416015625, -0.01751708984375, -0.0133056640625, -0.005767822265625, -0.00469970703125, -0.006805419921875, -0.00634765625, -0.003387451171875, -0.0008544921875, -0.0013427734375, -0.00213623046875, -0.00079345703125, -0.002288818359375, -0.006622314453125, -0.009124755859375, -0.007720947265625, -0.004852294921875, -0.00341796875, -0.004058837890625, -0.006072998046875, -0.0074462890625, -0.00628662109375, -0.004730224609375, -0.0032958984375, -0.00140380859375, -0.001983642578125, -0.00555419921875, -0.007293701171875, -0.004486083984375, -0.0015869140625, -0.0015869140625, -0.003021240234375, -0.003448486328125, -0.00311279296875, -0.002593994140625, -0.00152587890625, -0.001068115234375, -0.002044677734375, -0.003265380859375, -0.00390625, -0.00341796875, -0.00140380859375, 0.000152587890625, -0.000518798828125, -0.002532958984375, -0.003662109375, -0.003265380859375, -0.002044677734375, -0.002166748046875, -0.00274658203125, -0.002960205078125, -0.003265380859375])
        IR_LEFT[len(IR_LEFT)-1].append([0.0, -0.00018310546875, -9.1552734375e-05, 6.103515625e-05, 0.00030517578125, -0.0001220703125, 0.000244140625, -0.0006103515625, 0.000701904296875, -0.001220703125, 0.00152587890625, -0.00213623046875, 0.00286865234375, -0.00360107421875, 0.040771484375, 0.12567138671875, 0.1414794921875, -0.0867919921875, -0.358123779296875, -0.026885986328125, 0.336944580078125, 0.217620849609375, 0.07733154296875, 0.0999755859375, 0.12139892578125, 0.0906982421875, 0.05877685546875, -0.077606201171875, -0.1583251953125, -0.10546875, -0.08831787109375, -0.12457275390625, -0.12042236328125, -0.052825927734375, -0.0394287109375, -0.030029296875, 0.0164794921875, 0.06207275390625, 0.050048828125, 0.038360595703125, 0.057220458984375, 0.04705810546875, 0.029754638671875, 0.006744384765625, 0.0001220703125, -0.00262451171875, -0.01318359375, -0.038482666015625, -0.051513671875, -0.04083251953125, -0.039794921875, -0.031494140625, -0.009185791015625, -0.00482177734375, 0.001190185546875, 0.00799560546875, 0.000823974609375, -0.002716064453125, 0.00860595703125, 0.02020263671875, 0.020416259765625, 0.00970458984375, 9.1552734375e-05, 0.000244140625, -0.003997802734375, -0.016937255859375, -0.025299072265625, -0.023529052734375, -0.02001953125, -0.0123291015625, -0.006317138671875, -0.003509521484375, -0.003692626953125, -0.00445556640625, -0.012359619140625, -0.02117919921875, -0.01788330078125, -0.00994873046875, -0.005767822265625, -0.003753662109375, -0.00177001953125, 0.00067138671875, 0.003997802734375, 0.00262451171875, 3.0517578125e-05, 0.000457763671875, -0.00054931640625, -0.007415771484375, -0.01300048828125, -0.012847900390625, -0.008392333984375, -0.004852294921875, -0.00323486328125, -0.00274658203125, -0.00433349609375, -0.0057373046875, -0.0062255859375, -0.005035400390625, -0.00177001953125, -0.000579833984375, -0.002532958984375, -0.00628662109375, -0.006927490234375, -0.003692626953125, -0.001373291015625, -0.001251220703125, -0.003509521484375, -0.004730224609375, -0.00433349609375, -0.002532958984375, -0.00128173828125, -0.0009765625, -0.00177001953125, -0.003448486328125, -0.004547119140625, -0.00335693359375, -0.00042724609375, 0.000640869140625, -0.00091552734375, -0.003143310546875, -0.004547119140625, -0.003997802734375, -0.0023193359375, -0.0023193359375, -0.00299072265625, -0.002960205078125, -0.0025634765625, -0.00238037109375])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([0.000518798828125, -0.00018310546875, 0.00048828125, -0.000701904296875, 0.00054931640625, -0.000518798828125, 0.00030517578125, 0.000396728515625, -0.000732421875, 0.00140380859375, 0.009552001953125, 0.0972900390625, 0.13970947265625, 0.148681640625, -0.21246337890625, -0.3502197265625, 0.17669677734375, 0.30828857421875, 0.1318359375, 0.09210205078125, 0.149566650390625, 0.105743408203125, 0.05670166015625, -0.014404296875, -0.17230224609375, -0.186065673828125, -0.13134765625, -0.102081298828125, -0.12799072265625, -0.07666015625, -0.010040283203125, 0.001556396484375, 0.03839111328125, 0.058868408203125, 0.070831298828125, 0.044281005859375, 0.036041259765625, 0.03253173828125, 0.026702880859375, -0.0045166015625, -0.019866943359375, -0.002532958984375, 3.0517578125e-05, -0.00494384765625, -0.025909423828125, -0.044708251953125, -0.06195068359375, -0.050201416015625, -0.03125, -0.016876220703125, -0.0010986328125, 0.01422119140625, 0.028900146484375, 0.027923583984375, 0.029083251953125, 0.032958984375, 0.01708984375, -0.005950927734375, -0.021484375, -0.020965576171875, -0.010650634765625, -0.00421142578125, -0.015655517578125, -0.0299072265625, -0.022125244140625, -0.009063720703125, -0.007293701171875, -0.00592041015625, 0.0008544921875, 0.00225830078125, 0.00048828125, -0.00390625, -0.013580322265625, -0.024078369140625, -0.024444580078125, -0.01214599609375, -0.0040283203125, -0.012176513671875, -0.017822265625, -0.0084228515625, 0.002593994140625, 0.003570556640625, 0.0020751953125, 0.001312255859375, -0.00250244140625, -0.003997802734375, -0.00244140625, -0.00262451171875, -0.00439453125, -0.00244140625, -0.002960205078125, -0.0068359375, -0.011138916015625, -0.01141357421875, -0.007293701171875, -0.003143310546875, -0.003509521484375, -0.00836181640625, -0.011322021484375, -0.007293701171875, -3.0517578125e-05, 0.002838134765625, 0.000579833984375, -0.00299072265625, -0.003509521484375, -0.001190185546875, 0.0020751953125, 0.00445556640625, 0.00311279296875, -0.002410888671875, -0.005950927734375, -0.006103515625, -0.00457763671875, -0.002166748046875, -0.002197265625, -0.005401611328125, -0.00775146484375, -0.00750732421875, -0.004425048828125, -9.1552734375e-05, 0.001220703125, -0.0003662109375, -0.004241943359375, -0.00701904296875, -0.0050048828125, 0.00048828125, 0.004425048828125, 0.003631591796875])
        IR_LEFT[len(IR_LEFT)-1].append([-0.00018310546875, 0.00054931640625, -0.00018310546875, 0.000518798828125, -0.0006103515625, 0.000701904296875, -0.000701904296875, 0.000762939453125, -0.00018310546875, 0.0001220703125, 0.0003662109375, 0.01287841796875, 0.089447021484375, 0.1219482421875, 0.10699462890625, -0.240875244140625, -0.312957763671875, 0.194580078125, 0.316497802734375, 0.14434814453125, 0.077362060546875, 0.126068115234375, 0.10009765625, 0.06756591796875, -0.000335693359375, -0.14813232421875, -0.167236328125, -0.1195068359375, -0.091766357421875, -0.11602783203125, -0.07666015625, -0.018157958984375, -0.005401611328125, 0.020599365234375, 0.04949951171875, 0.06622314453125, 0.04150390625, 0.039215087890625, 0.035186767578125, 0.02899169921875, 0.00262451171875, -0.015533447265625, -0.004638671875, -0.00048828125, -0.006317138671875, -0.027679443359375, -0.046600341796875, -0.0579833984375, -0.04541015625, -0.028289794921875, -0.0108642578125, 0.002838134765625, 0.013824462890625, 0.022125244140625, 0.02178955078125, 0.025390625, 0.031646728515625, 0.01690673828125, -0.005157470703125, -0.01837158203125, -0.02130126953125, -0.01422119140625, -0.010284423828125, -0.016571044921875, -0.024078369140625, -0.01898193359375, -0.0067138671875, -0.0045166015625, -0.003814697265625, 0.00311279296875, 0.0035400390625, -0.00054931640625, -0.00299072265625, -0.00726318359375, -0.018707275390625, -0.02630615234375, -0.01885986328125, -0.006683349609375, -0.010711669921875, -0.019622802734375, -0.015899658203125, -0.0040283203125, 0.004547119140625, 0.004852294921875, 0.000579833984375, -0.003692626953125, -0.003021240234375, 6.103515625e-05, 0.001190185546875, -0.001922607421875, -0.004119873046875, -0.005096435546875, -0.00726318359375, -0.008697509765625, -0.010223388671875, -0.009002685546875, -0.004150390625, -0.003021240234375, -0.006317138671875, -0.00994873046875, -0.00787353515625, -0.002197265625, 0.00164794921875, 0.000732421875, -0.00250244140625, -0.002532958984375, 0.000213623046875, 0.0029296875, 0.004150390625, 0.003204345703125, -0.000762939453125, -0.0042724609375, -0.005859375, -0.005279541015625, -0.003509521484375, -0.00372314453125, -0.005645751953125, -0.006561279296875, -0.005859375, -0.00323486328125, -0.000244140625, 0.00048828125, -0.000152587890625, -0.000640869140625, -0.001678466796875, -0.002349853515625, -0.00079345703125, 0.00054931640625])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000244140625, -9.1552734375e-05, 0.000396728515625, -0.00030517578125, 0.00048828125, -0.000823974609375, 0.0009765625, -0.00140380859375, 0.001708984375, -0.001922607421875, 0.00238037109375, -0.00262451171875, 0.028900146484375, 0.09173583984375, 0.1173095703125, 0.0281982421875, -0.32513427734375, -0.193817138671875, 0.272613525390625, 0.284515380859375, 0.1195068359375, 0.077117919921875, 0.1168212890625, 0.08355712890625, 0.07110595703125, -0.020111083984375, -0.142791748046875, -0.141571044921875, -0.09869384765625, -0.088226318359375, -0.109466552734375, -0.061248779296875, -0.022705078125, -0.007659912109375, 0.014984130859375, 0.04925537109375, 0.0579833984375, 0.035186767578125, 0.043121337890625, 0.037811279296875, 0.024505615234375, -0.001312255859375, -0.009979248046875, -0.00701904296875, -0.002166748046875, -0.01129150390625, -0.033843994140625, -0.048675537109375, -0.054656982421875, -0.040985107421875, -0.02276611328125, -0.000274658203125, 0.009857177734375, 0.016082763671875, 0.020050048828125, 0.015228271484375, 0.020538330078125, 0.0244140625, 0.0101318359375, -0.00872802734375, -0.01922607421875, -0.017059326171875, -0.010406494140625, -0.01190185546875, -0.023162841796875, -0.024627685546875, -0.01446533203125, -0.00390625, -0.00177001953125, -0.000457763671875, 0.005096435546875, 0.003173828125, 0.000518798828125, -0.00018310546875, -0.0059814453125, -0.019622802734375, -0.0284423828125, -0.02001953125, -0.009613037109375, -0.014739990234375, -0.022125244140625, -0.018035888671875, -0.005889892578125, 0.00469970703125, 0.00689697265625, 0.0003662109375, -0.003448486328125, -0.000885009765625, 0.00201416015625, 0.001373291015625, -0.002349853515625, -0.004852294921875, -0.00689697265625, -0.00738525390625, -0.0079345703125, -0.0107421875, -0.010589599609375, -0.0054931640625, -0.002593994140625, -0.005645751953125, -0.008514404296875, -0.006561279296875, -0.002593994140625, 0.000335693359375, -0.00030517578125, -0.0018310546875, -0.00140380859375, 0.000396728515625, 0.002197265625, 0.002899169921875, 0.001800537109375, -0.001312255859375, -0.003997802734375, -0.005889892578125, -0.0052490234375, -0.003631591796875, -0.003875732421875, -0.005279541015625, -0.005523681640625, -0.00494384765625, -0.00299072265625, -0.000823974609375, -0.000640869140625, -0.001007080078125, -0.000701904296875, -0.00079345703125, -0.0020751953125, -0.0018310546875])
        IR_LEFT[len(IR_LEFT)-1].append([-0.000152587890625, -0.000244140625, 0.000335693359375, -0.0001220703125, 0.00030517578125, -0.00042724609375, 0.0003662109375, -0.000457763671875, 0.0001220703125, 0.00018310546875, -0.0003662109375, 0.000885009765625, 0.007843017578125, 0.07318115234375, 0.10577392578125, 0.084259033203125, -0.21759033203125, -0.316070556640625, 0.146270751953125, 0.324493408203125, 0.16741943359375, 0.07196044921875, 0.1055908203125, 0.098052978515625, 0.0770263671875, 0.032806396484375, -0.101531982421875, -0.13909912109375, -0.1055908203125, -0.081146240234375, -0.1064453125, -0.08612060546875, -0.0345458984375, -0.020477294921875, 0.00042724609375, 0.034698486328125, 0.06182861328125, 0.037139892578125, 0.038909912109375, 0.0482177734375, 0.029754638671875, 0.003631591796875, -0.00787353515625, -0.006378173828125, -0.007171630859375, -0.005859375, -0.0252685546875, -0.046722412109375, -0.056732177734375, -0.042938232421875, -0.018402099609375, -0.005279541015625, 0.00201416015625, 0.016265869140625, 0.01934814453125, 0.0125732421875, 0.01678466796875, 0.019500732421875, 0.007965087890625, -0.004608154296875, -0.01177978515625, -0.0118408203125, -0.0108642578125, -0.013427734375, -0.018157958984375, -0.023590087890625, -0.020111083984375, -0.00897216796875, -0.001434326171875, -0.0001220703125, 0.00469970703125, 0.005859375, 0.00323486328125, 0.00042724609375, -0.002532958984375, -0.011627197265625, -0.025390625, -0.027313232421875, -0.016143798828125, -0.01275634765625, -0.020355224609375, -0.022125244140625, -0.01202392578125, 0.001617431640625, 0.007354736328125, 0.00372314453125, -0.0006103515625, 0.000701904296875, 0.002899169921875, 0.002685546875, -0.001556396484375, -0.005950927734375, -0.00775146484375, -0.008087158203125, -0.008697509765625, -0.010498046875, -0.010284423828125, -0.005523681640625, -0.00286865234375, -0.00494384765625, -0.00787353515625, -0.006927490234375, -0.00335693359375, -0.000640869140625, -0.00054931640625, -0.001678466796875, -0.000701904296875, 6.103515625e-05, 0.00067138671875, 0.0015869140625, 0.0015869140625, -0.000823974609375, -0.003692626953125, -0.00537109375, -0.005401611328125, -0.004150390625, -0.0030517578125, -0.003204345703125, -0.0035400390625, -0.003814697265625, -0.0029296875, -0.0010986328125, -0.00115966796875, -0.001861572265625, -0.00164794921875, -0.00140380859375, -0.002410888671875, -0.002960205078125])
        IR_LEFT[len(IR_LEFT)-1].append([-0.0001220703125, -0.0001220703125, 0.000457763671875, -0.000213623046875, 0.000457763671875, -0.000640869140625, 0.000762939453125, -0.001007080078125, 0.0009765625, -0.0009765625, 0.00115966796875, -0.001068115234375, 0.01641845703125, 0.083892822265625, 0.11480712890625, 0.05108642578125, -0.283172607421875, -0.2490234375, 0.229278564453125, 0.30328369140625, 0.1259765625, 0.069854736328125, 0.116607666015625, 0.0970458984375, 0.078643798828125, 0.0076904296875, -0.121490478515625, -0.132598876953125, -0.092315673828125, -0.088470458984375, -0.114715576171875, -0.076690673828125, -0.035797119140625, -0.024139404296875, 0.0025634765625, 0.045806884765625, 0.065643310546875, 0.0379638671875, 0.042327880859375, 0.04742431640625, 0.028594970703125, -0.00360107421875, -0.01043701171875, -0.0068359375, -0.006622314453125, -0.006805419921875, -0.0323486328125, -0.056304931640625, -0.053863525390625, -0.027374267578125, -0.014251708984375, -0.011474609375, 0.00701904296875, 0.01898193359375, 0.011383056640625, 0.011077880859375, 0.019866943359375, 0.017242431640625, 0.001312255859375, -0.004608154296875, -0.00390625, -0.01031494140625, -0.015869140625, -0.0113525390625, -0.01458740234375, -0.02642822265625, -0.021942138671875, -0.007080078125, -0.00213623046875, 0.000213623046875, 0.00347900390625, 0.003875732421875, 0.004791259765625, 0.0025634765625, -0.003997802734375, -0.01611328125, -0.024871826171875, -0.0223388671875, -0.01446533203125, -0.015655517578125, -0.02197265625, -0.019683837890625, -0.00616455078125, 0.004058837890625, 0.003326416015625, 0.0020751953125, 0.00311279296875, 0.0028076171875, 0.002410888671875, 0.0010986328125, -0.003265380859375, -0.0067138671875, -0.007415771484375, -0.008544921875, -0.011871337890625, -0.01190185546875, -0.007171630859375, -0.00323486328125, -0.00341796875, -0.005828857421875, -0.00677490234375, -0.004913330078125, -0.00244140625, -0.000885009765625, -0.0018310546875, -0.002166748046875, -0.001007080078125, -0.000152587890625, 0.00042724609375, 0.000885009765625, 9.1552734375e-05, -0.002471923828125, -0.00408935546875, -0.0048828125, -0.00433349609375, -0.002960205078125, -0.002288818359375, -0.002593994140625, -0.0030517578125, -0.002838134765625, -0.00177001953125, -0.00115966796875, -0.00146484375, -0.001739501953125, -0.00213623046875, -0.00299072265625, -0.00323486328125, -0.002166748046875])
        IR_LEFT[len(IR_LEFT)-1].append([-0.00030517578125, 0.0003662109375, 3.0517578125e-05, 0.000152587890625, -0.000152587890625, -9.1552734375e-05, 0.000335693359375, -0.000640869140625, 0.001190185546875, -0.001800537109375, 0.002838134765625, 0.000396728515625, 0.0662841796875, 0.117431640625, 0.114166259765625, -0.16033935546875, -0.348480224609375, 0.09515380859375, 0.337005615234375, 0.163604736328125, 0.06439208984375, 0.11376953125, 0.119781494140625, 0.080902099609375, 0.039459228515625, -0.100128173828125, -0.152099609375, -0.105499267578125, -0.085968017578125, -0.12078857421875, -0.101715087890625, -0.03790283203125, -0.03466796875, -0.013671875, 0.036651611328125, 0.072021484375, 0.051727294921875, 0.04583740234375, 0.052093505859375, 0.034149169921875, 0.006866455078125, -0.009735107421875, -0.01123046875, -0.010406494140625, -0.001800537109375, -0.024871826171875, -0.055450439453125, -0.058258056640625, -0.03271484375, -0.018402099609375, -0.017364501953125, 0.00262451171875, 0.015625, 0.0081787109375, 0.010345458984375, 0.020721435546875, 0.020538330078125, 0.0096435546875, 0.0008544921875, -0.004241943359375, -0.009521484375, -0.01324462890625, -0.008331298828125, -0.009124755859375, -0.025390625, -0.027435302734375, -0.01312255859375, -0.0062255859375, -0.005126953125, 0.000732421875, 0.005279541015625, 0.003021240234375, 0.000335693359375, -0.0006103515625, -0.0113525390625, -0.024078369140625, -0.019683837890625, -0.00994873046875, -0.015228271484375, -0.0220947265625, -0.01568603515625, -0.00341796875, 0.00042724609375, 0.001251220703125, 0.00396728515625, 0.001556396484375, 0.0003662109375, 0.001007080078125, -0.0006103515625, -0.003936767578125, -0.00341796875, -0.003509521484375, -0.009185791015625, -0.01336669921875, -0.011016845703125, -0.005859375, -0.00323486328125, -0.00311279296875, -0.005126953125, -0.00762939453125, -0.00653076171875, -0.00335693359375, -0.0006103515625, -0.000701904296875, -0.00244140625, -0.002685546875, -0.001953125, 0.000396728515625, 0.00189208984375, 0.000396728515625, -0.00238037109375, -0.00421142578125, -0.0048828125, -0.0045166015625, -0.002838134765625, -0.001708984375, -0.002349853515625, -0.00299072265625, -0.003173828125, -0.00201416015625, -0.000579833984375, -0.000457763671875, -0.00091552734375, -0.001983642578125, -0.003692626953125, -0.00439453125, -0.002349853515625, -0.000213623046875])
        IR_LEFT[len(IR_LEFT)-1].append([0.000244140625, 0.000152587890625, 9.1552734375e-05, 6.103515625e-05, -0.0003662109375, 0.000701904296875, -0.00115966796875, 0.00189208984375, -0.002593994140625, 0.0037841796875, -0.002655029296875, 0.063690185546875, 0.130889892578125, 0.14581298828125, -0.11248779296875, -0.3712158203125, 0.049346923828125, 0.33868408203125, 0.163726806640625, 0.06878662109375, 0.126922607421875, 0.131622314453125, 0.076812744140625, 0.0333251953125, -0.11041259765625, -0.171905517578125, -0.113800048828125, -0.09405517578125, -0.1318359375, -0.107757568359375, -0.034820556640625, -0.03082275390625, -0.012054443359375, 0.037872314453125, 0.07586669921875, 0.055419921875, 0.047943115234375, 0.057220458984375, 0.0404052734375, 0.0067138671875, -0.014434814453125, -0.0093994140625, -0.0107421875, -0.003326416015625, -0.024078369140625, -0.05706787109375, -0.063232421875, -0.038055419921875, -0.019989013671875, -0.019561767578125, -0.001708984375, 0.0142822265625, 0.01080322265625, 0.0150146484375, 0.023406982421875, 0.02032470703125, 0.009002685546875, 0.001007080078125, -0.00384521484375, -0.008544921875, -0.0101318359375, -0.0015869140625, -0.005340576171875, -0.027557373046875, -0.027099609375, -0.017120361328125, -0.015167236328125, -0.009521484375, 0.0003662109375, 0.005584716796875, 0.002685546875, -0.001953125, -0.00640869140625, -0.01470947265625, -0.01873779296875, -0.012359619140625, -0.009735107421875, -0.01702880859375, -0.015869140625, -0.005767822265625, -0.001434326171875, -0.001373291015625, 0.00250244140625, 0.00482177734375, -0.000274658203125, -0.003570556640625, -0.003265380859375, -0.004302978515625, -0.004241943359375, -0.0025634765625, -0.0042724609375, -0.00830078125, -0.009124755859375, -0.0067138671875, -0.006195068359375, -0.00494384765625, -0.004150390625, -0.005340576171875, -0.00836181640625, -0.008026123046875, -0.002777099609375, -0.000152587890625, -0.000244140625, -0.0023193359375, -0.00372314453125, -0.002960205078125, -0.0003662109375, 0.002105712890625, 0.000732421875, -0.00225830078125, -0.0047607421875, -0.00628662109375, -0.004638671875, -0.00164794921875, -0.000274658203125, -0.0023193359375, -0.004241943359375, -0.004302978515625, -0.002197265625, -0.00018310546875, -0.000518798828125, -0.001220703125, -0.003021240234375, -0.004974365234375, -0.0052490234375, -0.003936767578125, -0.002288818359375, -0.001129150390625])
        IR_LEFT.append([])
        IR_LEFT[len(IR_LEFT)-1].append([0.000152587890625, -0.000518798828125, 0.00079345703125, -0.001251220703125, 0.001922607421875, -0.00244140625, 0.003631591796875, -0.002227783203125, 0.061614990234375, 0.133575439453125, 0.17889404296875, -0.027557373046875, -0.3494873046875, -0.036224365234375, 0.277099609375, 0.146484375, 0.078643798828125, 0.147003173828125, 0.133392333984375, 0.065399169921875, 0.01751708984375, -0.11090087890625, -0.17071533203125, -0.120361328125, -0.09735107421875, -0.125152587890625, -0.099853515625, -0.03448486328125, -0.01470947265625, 0.01568603515625, 0.038726806640625, 0.0662841796875, 0.059722900390625, 0.035003662109375, 0.038330078125, 0.03021240234375, -0.00677490234375, -0.0238037109375, 0.00408935546875, 0.0140380859375, 0.0078125, -0.014678955078125, -0.048431396484375, -0.069366455078125, -0.058135986328125, -0.0335693359375, -0.01318359375, -6.103515625e-05, 0.010833740234375, 0.016693115234375, 0.012786865234375, 0.019866943359375, 0.028411865234375, 0.02069091796875, 0.004425048828125, -0.0086669921875, -0.01141357421875, -0.010589599609375, -0.00299072265625, -0.004302978515625, -0.02490234375, -0.034423828125, -0.02105712890625, -0.01092529296875, -0.00830078125, 0.00323486328125, 0.00225830078125, -0.003814697265625, -0.003662109375, -0.002960205078125, -0.008392333984375, -0.018096923828125, -0.0185546875, -0.011016845703125, -0.0111083984375, -0.019744873046875, -0.017181396484375, -0.002349853515625, 0.00579833984375, 0.002838134765625, 0.00128173828125, 0.0, -0.00372314453125, -0.006744384765625, -0.00518798828125, -0.001708984375, 0.001800537109375, 0.001617431640625, -0.005950927734375, -0.013824462890625, -0.01177978515625, -0.003662109375, 0.000701904296875, -0.003265380859375, -0.013458251953125, -0.018524169921875, -0.012939453125, -0.002227783203125, 0.004180908203125, 0.001556396484375, -0.002288818359375, -0.00030517578125, 0.0028076171875, 0.005218505859375, 0.00531005859375, 0.002410888671875, -0.003509521484375, -0.00799560546875, -0.00823974609375, -0.00677490234375, -0.004486083984375, -0.003082275390625, -0.00421142578125, -0.00604248046875, -0.006072998046875, -0.00360107421875, 0.00018310546875, 0.00213623046875, 0.00091552734375, -0.00177001953125, -0.003875732421875, -0.0037841796875, -0.0006103515625, 0.002105712890625, 0.00115966796875, -0.002105712890625, -0.0040283203125, -0.004302978515625])
        IR_RIGHT = []
        IR_RIGHT.append([])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.000274658203125, 0.000244140625, -0.000152587890625, 0.000396728515625, -0.000335693359375, 0.00054931640625, -0.0008544921875, 0.0006103515625, -0.0006103515625, 0.00030517578125, -0.000518798828125, 0.0006103515625, -0.001190185546875, 0.06524658203125, 0.202117919921875, -0.077972412109375, -0.246307373046875, 0.005523681640625, -0.039581298828125, 0.044189453125, 0.269439697265625, 0.240631103515625, 0.101531982421875, 0.147186279296875, 0.31597900390625, 0.090789794921875, -0.149078369140625, -0.108001708984375, -0.19500732421875, -0.22613525390625, -0.01312255859375, -0.06683349609375, -0.204620361328125, -0.117950439453125, -0.0386962890625, -0.0218505859375, -0.013336181640625, 0.03057861328125, 0.048065185546875, 0.026947021484375, 0.052215576171875, 0.093292236328125, 0.02874755859375, 0.001373291015625, 0.016326904296875, 0.009185791015625, -0.0091552734375, -0.034454345703125, -0.031097412109375, -0.03564453125, -0.040374755859375, -0.020660400390625, -0.0216064453125, -0.0303955078125, -0.00604248046875, 0.006988525390625, 0.002716064453125, 0.008880615234375, 0.01556396484375, 0.020172119140625, 0.013702392578125, -0.00201416015625, -0.001556396484375, -0.013885498046875, -0.015777587890625, 0.004150390625, 0.007232666015625, 0.005401611328125, 0.008544921875, 0.0054931640625, -0.000335693359375, -0.011260986328125, -0.01715087890625, -0.0238037109375, -0.037628173828125, -0.0306396484375, -0.014495849609375, -0.005340576171875, 0.005340576171875, 0.010650634765625, 0.014404296875, 0.015655517578125, 0.0089111328125, 0.008148193359375, 0.0009765625, -0.009765625, -0.0167236328125, -0.019378662109375, -0.014404296875, -0.0062255859375, -0.000946044921875, 0.0023193359375, 0.001495361328125, 0.000946044921875, 0.0015869140625, -0.0023193359375, -0.00360107421875, -0.00274658203125, -0.001800537109375, -0.004425048828125, -0.007720947265625, -0.00634765625, -0.00360107421875, -0.003173828125, -0.002960205078125, -0.005828857421875, -0.008575439453125, -0.00750732421875, -0.005584716796875, -0.00543212890625, -0.003631591796875, 6.103515625e-05, 0.001373291015625, 0.00177001953125, 0.00286865234375, 0.003143310546875, 0.001739501953125, -0.00091552734375, -0.002532958984375, -0.003326416015625, -0.004638671875, -0.005706787109375, -0.00689697265625, -0.006500244140625, -0.008148193359375, -0.007598876953125, -0.004547119140625, -0.0013427734375])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.0001220703125, -9.1552734375e-05, 0.0003662109375, -0.00018310546875, 0.000244140625, -0.00030517578125, -0.00030517578125, 0.000457763671875, -0.00103759765625, 0.00103759765625, -0.001708984375, 0.00115966796875, 0.03289794921875, 0.21258544921875, 0.021453857421875, -0.30010986328125, -0.050323486328125, -0.020294189453125, -0.01055908203125, 0.26312255859375, 0.294708251953125, 0.143798828125, 0.10699462890625, 0.336395263671875, 0.187652587890625, -0.165985107421875, -0.14105224609375, -0.1761474609375, -0.2589111328125, -0.033599853515625, -0.017486572265625, -0.218536376953125, -0.15618896484375, -0.047576904296875, -0.033111572265625, -0.037872314453125, 0.014801025390625, 0.05303955078125, 0.03955078125, 0.051300048828125, 0.1043701171875, 0.05609130859375, 0.00811767578125, 0.021209716796875, 0.007293701171875, -0.006744384765625, -0.03662109375, -0.04559326171875, -0.043365478515625, -0.0450439453125, -0.025848388671875, -0.01739501953125, -0.030853271484375, -0.00897216796875, 0.013092041015625, 0.00830078125, 0.0086669921875, 0.014739990234375, 0.018096923828125, 0.015472412109375, -0.004150390625, -0.006378173828125, -0.011199951171875, -0.02130126953125, -0.0009765625, 0.009307861328125, 0.00494384765625, 0.006927490234375, 0.00408935546875, 0.000396728515625, -0.0076904296875, -0.0174560546875, -0.02410888671875, -0.038970947265625, -0.033843994140625, -0.012939453125, -0.00189208984375, 0.005462646484375, 0.011444091796875, 0.014068603515625, 0.01898193359375, 0.013916015625, 0.00933837890625, 0.001373291015625, -0.01171875, -0.018096923828125, -0.0218505859375, -0.017669677734375, -0.009368896484375, -0.004119873046875, -0.00054931640625, 0.000732421875, 0.000518798828125, 0.003082275390625, 0.00054931640625, -0.0006103515625, 0.000885009765625, 0.001678466796875, -0.000701904296875, -0.005218505859375, -0.006378173828125, -0.00445556640625, -0.004486083984375, -0.00469970703125, -0.007476806640625, -0.01116943359375, -0.01043701171875, -0.0076904296875, -0.00592041015625, -0.004669189453125, -0.001251220703125, 0.000213623046875, 0.000946044921875, 0.002899169921875, 0.0037841796875, 0.00299072265625, 0.001739501953125, 6.103515625e-05, -0.000946044921875, -0.00390625, -0.005706787109375, -0.008392333984375, -0.010101318359375, -0.009857177734375, -0.009246826171875, -0.005767822265625, -0.00286865234375, 0.001708984375])
        IR_RIGHT[len(IR_RIGHT)-1].append([6.103515625e-05, 0.000152587890625, 0.000152587890625, -0.000244140625, 0.000396728515625, -0.001129150390625, 0.00140380859375, -0.00201416015625, 0.00225830078125, -0.003326416015625, 0.00347900390625, 0.0096435546875, 0.18963623046875, 0.134796142578125, -0.306396484375, -0.146331787109375, 0.009185791015625, -0.0552978515625, 0.228790283203125, 0.33740234375, 0.201934814453125, 0.087371826171875, 0.316375732421875, 0.292755126953125, -0.15380859375, -0.1806640625, -0.155364990234375, -0.283660888671875, -0.067657470703125, 0.0279541015625, -0.21697998046875, -0.200347900390625, -0.0565185546875, -0.0457763671875, -0.07696533203125, -0.002227783203125, 0.082916259765625, 0.057861328125, 0.035919189453125, 0.104217529296875, 0.090545654296875, 0.022979736328125, 0.0316162109375, 0.005523681640625, -0.017547607421875, -0.034576416015625, -0.046844482421875, -0.056427001953125, -0.060302734375, -0.033447265625, -0.015106201171875, -0.028656005859375, -0.010711669921875, 0.019134521484375, 0.0145263671875, 0.010498046875, 0.015045166015625, 0.019378662109375, 0.02020263671875, -9.1552734375e-05, -0.011749267578125, -0.010101318359375, -0.023345947265625, -0.00994873046875, 0.0093994140625, 0.0030517578125, 0.0028076171875, 0.001708984375, -0.0006103515625, -0.003326416015625, -0.014739990234375, -0.021820068359375, -0.0379638671875, -0.038604736328125, -0.01495361328125, 0.001434326171875, 0.008819580078125, 0.013824462890625, 0.015045166015625, 0.01776123046875, 0.0159912109375, 0.01251220703125, 0.00518798828125, -0.01080322265625, -0.01971435546875, -0.024932861328125, -0.02264404296875, -0.01116943359375, -0.00433349609375, -0.00347900390625, -0.000732421875, 0.000701904296875, 0.00494384765625, 0.004302978515625, 0.0009765625, 0.00244140625, 0.004425048828125, 0.003753662109375, -0.001190185546875, -0.005279541015625, -0.004638671875, -0.00396728515625, -0.004791259765625, -0.00836181640625, -0.013458251953125, -0.01318359375, -0.010711669921875, -0.00701904296875, -0.004669189453125, -0.001556396484375, 0.00048828125, 0.000640869140625, 0.002227783203125, 0.004150390625, 0.00433349609375, 0.003143310546875, 0.00146484375, 0.0010986328125, -0.001556396484375, -0.00494384765625, -0.007415771484375, -0.0113525390625, -0.012237548828125, -0.0107421875, -0.006988525390625, -0.0030517578125, 0.00018310546875, 0.00469970703125])
        IR_RIGHT[len(IR_RIGHT)-1].append([3.0517578125e-05, 0.000457763671875, -0.000579833984375, 0.000885009765625, -0.0015869140625, 0.00177001953125, -0.002197265625, 0.0023193359375, -0.003326416015625, 0.00372314453125, 0.00091552734375, 0.164398193359375, 0.20977783203125, -0.28204345703125, -0.2408447265625, 0.014404296875, -0.064849853515625, 0.200347900390625, 0.361480712890625, 0.25018310546875, 0.105926513671875, 0.290374755859375, 0.343170166015625, -0.10760498046875, -0.203460693359375, -0.186981201171875, -0.284149169921875, -0.068145751953125, 0.03131103515625, -0.217254638671875, -0.222198486328125, -0.07977294921875, -0.07757568359375, -0.104217529296875, -0.004150390625, 0.1214599609375, 0.081390380859375, 0.02593994140625, 0.098052978515625, 0.11785888671875, 0.043609619140625, 0.031036376953125, 0.0069580078125, -0.023468017578125, -0.047393798828125, -0.05078125, -0.05816650390625, -0.073333740234375, -0.046600341796875, -0.0177001953125, -0.02886962890625, -0.011474609375, 0.025115966796875, 0.019927978515625, 0.011688232421875, 0.0191650390625, 0.02545166015625, 0.025360107421875, 0.006927490234375, -0.011016845703125, -0.012420654296875, -0.027252197265625, -0.021759033203125, 0.0028076171875, 0.002716064453125, -0.000152587890625, 0.0010986328125, -0.002288818359375, -0.004241943359375, -0.01214599609375, -0.01885986328125, -0.03619384765625, -0.040435791015625, -0.017730712890625, 0.003692626953125, 0.01446533203125, 0.018157958984375, 0.015777587890625, 0.0145263671875, 0.014434814453125, 0.01324462890625, 0.00823974609375, -0.0089111328125, -0.019927978515625, -0.02569580078125, -0.0255126953125, -0.015411376953125, -0.0067138671875, -0.00531005859375, -0.0018310546875, 0.0020751953125, 0.007568359375, 0.0087890625, 0.003692626953125, 0.00299072265625, 0.004974365234375, 0.005523681640625, 0.002716064453125, -0.00213623046875, -0.004364013671875, -0.004608154296875, -0.00457763671875, -0.007965087890625, -0.01519775390625, -0.0152587890625, -0.013641357421875, -0.010009765625, -0.00506591796875, 0.000244140625, 0.002593994140625, 0.000885009765625, 0.001678466796875, 0.0032958984375, 0.0040283203125, 0.00384521484375, 0.002532958984375, 0.001708984375, -9.1552734375e-05, -0.00384521484375, -0.006256103515625, -0.011138916015625, -0.0142822265625, -0.01190185546875, -0.007598876953125, -0.003326416015625, 3.0517578125e-05, 0.0037841796875, 0.00634765625])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.000640869140625, -0.00067138671875, 0.000885009765625, -0.00115966796875, 0.001007080078125, -0.000946044921875, 0.0006103515625, -0.0009765625, 0.000701904296875, -0.002166748046875, 0.08941650390625, 0.282562255859375, -0.125335693359375, -0.37567138671875, -0.026458740234375, -0.05035400390625, 0.109283447265625, 0.361114501953125, 0.305633544921875, 0.152313232421875, 0.1998291015625, 0.41864013671875, 0.046539306640625, -0.2347412109375, -0.1998291015625, -0.30377197265625, -0.113494873046875, 0.058319091796875, -0.184417724609375, -0.26678466796875, -0.11834716796875, -0.09442138671875, -0.116943359375, -0.023193359375, 0.118927001953125, 0.107574462890625, 0.042999267578125, 0.08843994140625, 0.12603759765625, 0.062713623046875, 0.0357666015625, 0.008514404296875, -0.01763916015625, -0.04388427734375, -0.065093994140625, -0.0635986328125, -0.0718994140625, -0.054779052734375, -0.025665283203125, -0.032562255859375, -0.021209716796875, 0.021148681640625, 0.0233154296875, 0.01593017578125, 0.02423095703125, 0.02984619140625, 0.028594970703125, 0.01800537109375, -0.0047607421875, -0.014251708984375, -0.025848388671875, -0.0345458984375, -0.011871337890625, 0.0009765625, -0.000946044921875, 0.003326416015625, 9.1552734375e-05, -0.003265380859375, -0.010467529296875, -0.0147705078125, -0.029510498046875, -0.041900634765625, -0.02459716796875, -0.00213623046875, 0.013458251953125, 0.02008056640625, 0.01800537109375, 0.013702392578125, 0.011749267578125, 0.01068115234375, 0.010894775390625, -0.001708984375, -0.015777587890625, -0.0245361328125, -0.027557373046875, -0.019439697265625, -0.00823974609375, -0.005584716796875, -0.004913330078125, -6.103515625e-05, 0.006103515625, 0.011260986328125, 0.007904052734375, 0.0042724609375, 0.004180908203125, 0.005126953125, 0.0050048828125, 0.00213623046875, -0.00189208984375, -0.00390625, -0.00469970703125, -0.007232666015625, -0.014892578125, -0.017181396484375, -0.01507568359375, -0.01263427734375, -0.007080078125, -0.000701904296875, 0.004058837890625, 0.00323486328125, 0.001922607421875, 0.001800537109375, 0.001800537109375, 0.00335693359375, 0.00311279296875, 0.00115966796875, 0.000823974609375, -0.00225830078125, -0.004486083984375, -0.008270263671875, -0.01361083984375, -0.0142822265625, -0.009979248046875, -0.00494384765625, -0.000762939453125, 0.003143310546875, 0.00567626953125, 0.004852294921875])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.000274658203125, 0.000274658203125, -0.000518798828125, -0.00018310546875, 0.00048828125, -0.001251220703125, 0.00128173828125, -0.00244140625, 0.00103759765625, 0.043060302734375, 0.285552978515625, 0.026702880859375, -0.43133544921875, -0.123687744140625, -0.01580810546875, 0.057373046875, 0.348907470703125, 0.3341064453125, 0.163848876953125, 0.169464111328125, 0.477325439453125, 0.160980224609375, -0.23565673828125, -0.2255859375, -0.334503173828125, -0.136077880859375, 0.0704345703125, -0.15130615234375, -0.3021240234375, -0.1783447265625, -0.10382080078125, -0.09075927734375, -0.029327392578125, 0.087310791015625, 0.114410400390625, 0.07122802734375, 0.105255126953125, 0.13140869140625, 0.06597900390625, 0.033355712890625, 0.006103515625, -0.0142822265625, -0.036102294921875, -0.07611083984375, -0.081878662109375, -0.071990966796875, -0.05242919921875, -0.03070068359375, -0.0322265625, -0.028411865234375, 0.01629638671875, 0.0247802734375, 0.02215576171875, 0.02630615234375, 0.02960205078125, 0.032470703125, 0.025238037109375, 0.0018310546875, -0.015472412109375, -0.025909423828125, -0.042449951171875, -0.02667236328125, -0.00164794921875, -0.00048828125, 0.00238037109375, 0.004302978515625, 0.00018310546875, -0.008148193359375, -0.0137939453125, -0.024322509765625, -0.039703369140625, -0.027557373046875, -0.007110595703125, 0.009124755859375, 0.015777587890625, 0.016754150390625, 0.014404296875, 0.01080322265625, 0.00958251953125, 0.01171875, 0.004638671875, -0.009857177734375, -0.022796630859375, -0.029876708984375, -0.02301025390625, -0.01104736328125, -0.004974365234375, -0.0042724609375, -0.000640869140625, 0.003692626953125, 0.009613037109375, 0.00921630859375, 0.004730224609375, 0.00421142578125, 0.005462646484375, 0.005157470703125, 0.00531005859375, 0.002410888671875, -0.001556396484375, -0.003509521484375, -0.006683349609375, -0.014739990234375, -0.01922607421875, -0.01776123046875, -0.0147705078125, -0.00726318359375, -0.0013427734375, 0.004150390625, 0.004791259765625, 0.00262451171875, 0.001556396484375, 0.00042724609375, 0.001373291015625, 0.001373291015625, -0.000213623046875, 0.0006103515625, -0.000396728515625, -0.002899169921875, -0.006256103515625, -0.01129150390625, -0.014373779296875, -0.01239013671875, -0.006378173828125, -0.002166748046875, 0.001617431640625, 0.00433349609375, 0.00469970703125, 0.00439453125])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.00048828125, 0.0008544921875, -0.001708984375, 0.00213623046875, -0.0028076171875, 0.002899169921875, -0.004302978515625, 0.004547119140625, 0.000396728515625, 0.197296142578125, 0.244537353515625, -0.337799072265625, -0.32891845703125, -0.00225830078125, -0.00079345703125, 0.273956298828125, 0.370025634765625, 0.1912841796875, 0.129180908203125, 0.46942138671875, 0.36962890625, -0.167388916015625, -0.244171142578125, -0.3526611328125, -0.22686767578125, 0.07415771484375, -0.067047119140625, -0.312744140625, -0.253570556640625, -0.127777099609375, -0.06402587890625, -0.034912109375, 0.0252685546875, 0.0999755859375, 0.088836669921875, 0.114959716796875, 0.1522216796875, 0.08154296875, 0.03155517578125, 0.014495849609375, -0.009307861328125, -0.02880859375, -0.069244384765625, -0.092864990234375, -0.089263916015625, -0.056365966796875, -0.0316162109375, -0.029571533203125, -0.032440185546875, 0.008209228515625, 0.0244140625, 0.0234375, 0.027618408203125, 0.026214599609375, 0.02947998046875, 0.030548095703125, 0.015228271484375, -0.010284423828125, -0.02484130859375, -0.041473388671875, -0.0399169921875, -0.0120849609375, 3.0517578125e-05, -0.0008544921875, 0.00738525390625, 0.0064697265625, -0.00323486328125, -0.012542724609375, -0.018951416015625, -0.032806396484375, -0.0313720703125, -0.015899658203125, 0.001495361328125, 0.010894775390625, 0.012603759765625, 0.013671875, 0.011993408203125, 0.008636474609375, 0.0128173828125, 0.012176513671875, -0.00140380859375, -0.01416015625, -0.028472900390625, -0.028564453125, -0.017730712890625, -0.006988525390625, -0.004241943359375, -0.001861572265625, 0.001373291015625, 0.005645751953125, 0.00994873046875, 0.00653076171875, 0.00347900390625, 0.005950927734375, 0.006103515625, 0.006500244140625, 0.0059814453125, 0.001556396484375, -0.001312255859375, -0.00341796875, -0.0107421875, -0.019256591796875, -0.019744873046875, -0.0174560546875, -0.010498046875, -0.003204345703125, 0.002655029296875, 0.006195068359375, 0.00421142578125, 0.001617431640625, -0.000213623046875, -0.0006103515625, 0.000823974609375, 0.000152587890625, -0.00054931640625, 0.000732421875, -0.001068115234375, -0.004150390625, -0.00836181640625, -0.012176513671875, -0.014251708984375, -0.0098876953125, -0.00323486328125, 0.000274658203125, 0.003662109375, 0.004608154296875, 0.003509521484375, 0.00494384765625])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.000762939453125, -0.0013427734375, 0.0013427734375, -0.001251220703125, 0.000701904296875, -0.001220703125, 0.000885009765625, -0.003265380859375, 0.09423828125, 0.32818603515625, -0.115814208984375, -0.47845458984375, -0.086578369140625, 0.012054443359375, 0.196533203125, 0.3563232421875, 0.206939697265625, 0.135467529296875, 0.418853759765625, 0.53570556640625, -0.0472412109375, -0.272857666015625, -0.360137939453125, -0.2850341796875, 0.06683349609375, -0.0264892578125, -0.303619384765625, -0.3045654296875, -0.145111083984375, -0.057373046875, -0.021148681640625, -0.011627197265625, 0.053497314453125, 0.09716796875, 0.11358642578125, 0.1580810546875, 0.11083984375, 0.046142578125, 0.0140380859375, -0.006317138671875, -0.018157958984375, -0.06494140625, -0.09552001953125, -0.10650634765625, -0.071197509765625, -0.031524658203125, -0.021270751953125, -0.0362548828125, -0.000244140625, 0.031982421875, 0.022979736328125, 0.02520751953125, 0.022979736328125, 0.0286865234375, 0.02862548828125, 0.02276611328125, -0.000823974609375, -0.02203369140625, -0.037109375, -0.045928955078125, -0.02874755859375, -0.00323486328125, 0.00018310546875, 0.003387451171875, 0.0087890625, 0.004638671875, -0.005157470703125, -0.016632080078125, -0.02783203125, -0.02978515625, -0.02117919921875, -0.00701904296875, 0.004486083984375, 0.007781982421875, 0.009552001953125, 0.01177978515625, 0.011566162109375, 0.011810302734375, 0.014892578125, 0.0068359375, -0.005401611328125, -0.021728515625, -0.028411865234375, -0.020965576171875, -0.0115966796875, -0.0074462890625, -0.005401611328125, -0.00079345703125, 0.00238037109375, 0.006011962890625, 0.006622314453125, 0.004364013671875, 0.00628662109375, 0.00946044921875, 0.008026123046875, 0.007598876953125, 0.00518798828125, 0.00128173828125, -0.001708984375, -0.007415771484375, -0.01593017578125, -0.020294189453125, -0.018951416015625, -0.013275146484375, -0.006011962890625, -0.0001220703125, 0.005218505859375, 0.005584716796875, 0.002899169921875, 0.000579833984375, -0.002044677734375, -0.0015869140625, 0.00042724609375, -0.00018310546875, 0.0006103515625, 0.001373291015625, -0.002349853515625, -0.007781982421875, -0.010284423828125, -0.013031005859375, -0.0125732421875, -0.005950927734375, -0.000823974609375, 0.003173828125, 0.005645751953125, 0.00439453125, 0.00299072265625, 0.00299072265625])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.00054931640625, -0.00146484375, 0.002044677734375, -0.003021240234375, 0.003143310546875, -0.0047607421875, 0.004852294921875, 0.00494384765625, 0.24090576171875, 0.2275390625, -0.420989990234375, -0.340240478515625, 0.011260986328125, 0.0948486328125, 0.310882568359375, 0.2530517578125, 0.157440185546875, 0.264892578125, 0.6187744140625, 0.259429931640625, -0.2529296875, -0.332489013671875, -0.37750244140625, -0.017791748046875, 0.0589599609375, -0.230987548828125, -0.35003662109375, -0.200286865234375, -0.08245849609375, -0.033660888671875, -0.0062255859375, 0.01422119140625, 0.0645751953125, 0.08843994140625, 0.152557373046875, 0.137939453125, 0.07147216796875, 0.042694091796875, -0.001922607421875, -0.01226806640625, -0.041351318359375, -0.08306884765625, -0.114349365234375, -0.094573974609375, -0.050079345703125, -0.024444580078125, -0.0294189453125, -0.01983642578125, 0.027923583984375, 0.027435302734375, 0.027191162109375, 0.022796630859375, 0.025299072265625, 0.0281982421875, 0.02752685546875, 0.0115966796875, -0.0145263671875, -0.032440185546875, -0.043060302734375, -0.040191650390625, -0.0205078125, -0.001556396484375, -0.00201416015625, 0.00555419921875, 0.010406494140625, 0.004669189453125, -0.007293701171875, -0.02252197265625, -0.029296875, -0.02545166015625, -0.013580322265625, -0.0018310546875, 0.00177001953125, 0.0040283203125, 0.0081787109375, 0.015289306640625, 0.014129638671875, 0.013092041015625, 0.0108642578125, 0.003997802734375, -0.011688232421875, -0.026275634765625, -0.023529052734375, -0.014007568359375, -0.00927734375, -0.010833740234375, -0.0054931640625, -0.000335693359375, 0.00225830078125, 0.00469970703125, 0.00433349609375, 0.003875732421875, 0.00872802734375, 0.010833740234375, 0.010528564453125, 0.00909423828125, 0.0052490234375, 0.0009765625, -0.005645751953125, -0.0120849609375, -0.017669677734375, -0.02044677734375, -0.016754150390625, -0.00927734375, -0.0040283203125, 0.001739501953125, 0.005706787109375, 0.0045166015625, 0.0015869140625, -0.000823974609375, -0.002960205078125, -0.001129150390625, 0.000274658203125, 0.000244140625, 0.00140380859375, 0.0006103515625, -0.005401611328125, -0.010162353515625, -0.011016845703125, -0.013031005859375, -0.00946044921875, -0.004119873046875, 0.0, 0.00506591796875, 0.006591796875, 0.00408935546875, 0.001953125, 0.0])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.0008544921875, 0.000732421875, -0.0006103515625, -0.00054931640625, 0.0003662109375, -0.00140380859375, -0.000823974609375, 0.065338134765625, 0.34765625, -0.037200927734375, -0.545379638671875, -0.145263671875, 0.06365966796875, 0.2012939453125, 0.291748046875, 0.195343017578125, 0.169219970703125, 0.475067138671875, 0.5892333984375, -0.066619873046875, -0.32794189453125, -0.395111083984375, -0.173583984375, 0.110015869140625, -0.110748291015625, -0.337127685546875, -0.290985107421875, -0.12286376953125, -0.06005859375, -0.005767822265625, 0.00274658203125, 0.0361328125, 0.0517578125, 0.100830078125, 0.165679931640625, 0.1005859375, 0.055633544921875, 0.020172119140625, 0.007904052734375, -0.0146484375, -0.06719970703125, -0.100433349609375, -0.111602783203125, -0.07025146484375, -0.044921875, -0.031005859375, -0.033721923828125, 0.011566162109375, 0.032318115234375, 0.0262451171875, 0.030364990234375, 0.02569580078125, 0.027435302734375, 0.02630615234375, 0.024169921875, -0.00152587890625, -0.02557373046875, -0.042449951171875, -0.042083740234375, -0.0328369140625, -0.013885498046875, -0.005859375, -0.005157470703125, 0.010101318359375, 0.013763427734375, 0.00360107421875, -0.012664794921875, -0.025360107421875, -0.025146484375, -0.021087646484375, -0.007598876953125, -0.001129150390625, -0.000457763671875, 0.002044677734375, 0.010986328125, 0.018310546875, 0.013916015625, 0.0120849609375, 0.00830078125, -0.000732421875, -0.01885986328125, -0.024627685546875, -0.01678466796875, -0.010162353515625, -0.0111083984375, -0.010406494140625, -0.00433349609375, -0.00103759765625, 0.001220703125, 0.003448486328125, 0.0035400390625, 0.00506591796875, 0.00927734375, 0.01129150390625, 0.013031005859375, 0.010772705078125, 0.006591796875, -0.001220703125, -0.01019287109375, -0.01495361328125, -0.018524169921875, -0.01953125, -0.013336181640625, -0.007080078125, -0.0025634765625, 0.002655029296875, 0.00567626953125, 0.00372314453125, 0.00103759765625, -0.001617431640625, -0.002410888671875, -0.0001220703125, -0.00103759765625, 0.0008544921875, 0.00152587890625, -0.00152587890625, -0.007659912109375, -0.01019287109375, -0.010650634765625, -0.011566162109375, -0.006988525390625, -0.00347900390625, 0.0008544921875, 0.005767822265625, 0.006378173828125, 0.004058837890625, 0.000885009765625, -0.00140380859375])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.001739501953125, 0.002349853515625, -0.0032958984375, 0.002899169921875, -0.0042724609375, 0.004547119140625, -0.005615234375, 0.18011474609375, 0.334259033203125, -0.353118896484375, -0.4786376953125, 0.024566650390625, 0.102203369140625, 0.26385498046875, 0.2403564453125, 0.15313720703125, 0.277923583984375, 0.6611328125, 0.324554443359375, -0.293670654296875, -0.383544921875, -0.295501708984375, 0.071563720703125, 0.033111572265625, -0.26507568359375, -0.36602783203125, -0.197662353515625, -0.07122802734375, -0.040191650390625, 0.0047607421875, 0.001708984375, 0.040252685546875, 0.053955078125, 0.128570556640625, 0.126434326171875, 0.07147216796875, 0.04351806640625, 0.013031005859375, 0.0255126953125, -0.024505615234375, -0.0828857421875, -0.11962890625, -0.08514404296875, -0.05328369140625, -0.049041748046875, -0.04949951171875, -0.020660400390625, 0.0323486328125, 0.028045654296875, 0.0321044921875, 0.031158447265625, 0.031890869140625, 0.026214599609375, 0.026031494140625, 0.01361083984375, -0.013153076171875, -0.03564453125, -0.0467529296875, -0.039459228515625, -0.028411865234375, -0.00909423828125, -0.011505126953125, -0.0062255859375, 0.013702392578125, 0.015594482421875, 0.0029296875, -0.018524169921875, -0.0230712890625, -0.020172119140625, -0.015899658203125, -0.004669189453125, -0.00323486328125, -0.002593994140625, 0.003814697265625, 0.01654052734375, 0.01824951171875, 0.011962890625, 0.00799560546875, 0.004150390625, -0.008880615234375, -0.0218505859375, -0.0186767578125, -0.01019287109375, -0.00811767578125, -0.011993408203125, -0.010040283203125, -0.004791259765625, -0.001922607421875, -0.000213623046875, 0.001922607421875, 0.003173828125, 0.00762939453125, 0.010650634765625, 0.012298583984375, 0.012939453125, 0.010498046875, 0.00640869140625, -0.004425048828125, -0.01275634765625, -0.016357421875, -0.019012451171875, -0.017913818359375, -0.010833740234375, -0.005157470703125, -0.001800537109375, 0.002716064453125, 0.004852294921875, 0.003875732421875, 0.001251220703125, -0.00213623046875, -0.001190185546875, -0.001007080078125, -0.001617431640625, 0.001251220703125, -0.00067138671875, -0.004302978515625, -0.00714111328125, -0.008209228515625, -0.010589599609375, -0.010040283203125, -0.00634765625, -0.00286865234375, 0.00274658203125, 0.005584716796875, 0.00457763671875, 0.002655029296875, -0.000457763671875, -0.001434326171875])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.00177001953125, 0.002685546875, -0.004150390625, 0.004364013671875, -0.006256103515625, 0.006805419921875, 0.001129150390625, 0.267242431640625, 0.246368408203125, -0.532318115234375, -0.35076904296875, 0.094146728515625, 0.122161865234375, 0.27947998046875, 0.189727783203125, 0.161102294921875, 0.411468505859375, 0.680450439453125, 0.09393310546875, -0.398101806640625, -0.367706298828125, -0.123443603515625, 0.14312744140625, -0.072296142578125, -0.328765869140625, -0.3486328125, -0.129730224609375, -0.059051513671875, -0.0325927734375, -0.0052490234375, 0.0, 0.044158935546875, 0.0631103515625, 0.127716064453125, 0.098175048828125, 0.060760498046875, 0.02471923828125, 0.031951904296875, 0.030609130859375, -0.034149169921875, -0.088104248046875, -0.117156982421875, -0.0703125, -0.0489501953125, -0.051055908203125, -0.05950927734375, -0.0081787109375, 0.034088134765625, 0.027435302734375, 0.032196044921875, 0.034210205078125, 0.036346435546875, 0.023956298828125, 0.022918701171875, 0.00616455078125, -0.018341064453125, -0.04083251953125, -0.04583740234375, -0.038360595703125, -0.02508544921875, -0.008697509765625, -0.014984130859375, -0.00274658203125, 0.014129638671875, 0.015289306640625, 0.001373291015625, -0.020233154296875, -0.0198974609375, -0.017852783203125, -0.011444091796875, -0.00421142578125, -0.005218505859375, -0.001861572265625, 0.008758544921875, 0.020660400390625, 0.016754150390625, 0.00823974609375, 0.00372314453125, -0.002227783203125, -0.014739990234375, -0.020172119140625, -0.011810302734375, -0.005706787109375, -0.00762939453125, -0.012298583984375, -0.010467529296875, -0.006256103515625, -0.002349853515625, 0.0001220703125, 0.001129150390625, 0.0042724609375, 0.010101318359375, 0.013214111328125, 0.012603759765625, 0.010498046875, 0.00897216796875, 0.00390625, -0.005859375, -0.012603759765625, -0.01641845703125, -0.018402099609375, -0.016876220703125, -0.009735107421875, -0.00439453125, -0.00054931640625, 0.003387451171875, 0.0048828125, 0.003875732421875, 0.000885009765625, -0.00201416015625, -3.0517578125e-05, -0.001678466796875, -0.00164794921875, 0.001129150390625, -0.002777099609375, -0.00531005859375, -0.005828857421875, -0.007049560546875, -0.010040283203125, -0.0089111328125, -0.00640869140625, -0.00213623046875, 0.003997802734375, 0.005615234375, 0.003662109375, 0.0006103515625, -0.00250244140625, -0.001007080078125])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.001190185546875, 0.002349853515625, -0.00421142578125, 0.005096435546875, -0.007171630859375, 0.007781982421875, 0.01776123046875, 0.34442138671875, 0.101593017578125, -0.640167236328125, -0.187225341796875, 0.128814697265625, 0.141754150390625, 0.2529296875, 0.151641845703125, 0.214263916015625, 0.537139892578125, 0.59979248046875, -0.133270263671875, -0.455474853515625, -0.268951416015625, 0.060760498046875, 0.1214599609375, -0.172637939453125, -0.36651611328125, -0.29608154296875, -0.072174072265625, -0.07244873046875, -0.029754638671875, -0.0185546875, -0.00616455078125, 0.04168701171875, 0.084228515625, 0.12005615234375, 0.074462890625, 0.0440673828125, 0.01153564453125, 0.052276611328125, 0.0291748046875, -0.0352783203125, -0.097076416015625, -0.09918212890625, -0.04937744140625, -0.05072021484375, -0.059051513671875, -0.057342529296875, 0.00079345703125, 0.024261474609375, 0.023651123046875, 0.02947998046875, 0.036041259765625, 0.03521728515625, 0.02398681640625, 0.018310546875, -0.0008544921875, -0.016815185546875, -0.04010009765625, -0.04339599609375, -0.036407470703125, -0.02392578125, -0.01397705078125, -0.0179443359375, 0.00225830078125, 0.01568603515625, 0.013671875, -0.00286865234375, -0.0167236328125, -0.012969970703125, -0.01422119140625, -0.0106201171875, -0.007293701171875, -0.006988525390625, -0.00103759765625, 0.0128173828125, 0.020660400390625, 0.01123046875, 0.003570556640625, 0.00201416015625, -0.005126953125, -0.015838623046875, -0.016082763671875, -0.005889892578125, -0.003143310546875, -0.0081787109375, -0.011962890625, -0.01202392578125, -0.0087890625, -0.002044677734375, 0.000579833984375, 0.000579833984375, 0.004608154296875, 0.011505126953125, 0.014801025390625, 0.012176513671875, 0.009765625, 0.00860595703125, 0.00103759765625, -0.007415771484375, -0.01300048828125, -0.01470947265625, -0.016082763671875, -0.01702880859375, -0.009979248046875, -0.0040283203125, 0.0008544921875, 0.0042724609375, 0.004547119140625, 0.003326416015625, 0.000640869140625, -0.00128173828125, -0.000335693359375, -0.001708984375, -0.0013427734375, -0.000457763671875, -0.004058837890625, -0.00518798828125, -0.003631591796875, -0.006927490234375, -0.01031494140625, -0.00823974609375, -0.0054931640625, -0.00018310546875, 0.0047607421875, 0.005096435546875, 0.001739501953125, -0.002044677734375, -0.00347900390625, -0.000701904296875])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.0009765625, 0.002044677734375, -0.004058837890625, 0.0052490234375, -0.007537841796875, 0.00836181640625, 0.0240478515625, 0.37103271484375, 0.03558349609375, -0.668853759765625, -0.115020751953125, 0.146575927734375, 0.1341552734375, 0.22113037109375, 0.149749755859375, 0.254241943359375, 0.587066650390625, 0.530120849609375, -0.24859619140625, -0.46856689453125, -0.167327880859375, 0.15264892578125, 0.08465576171875, -0.221099853515625, -0.3720703125, -0.25, -0.05889892578125, -0.0882568359375, -0.03363037109375, -0.038360595703125, -0.0079345703125, 0.046173095703125, 0.08831787109375, 0.111846923828125, 0.067840576171875, 0.03167724609375, 0.012237548828125, 0.061248779296875, 0.02386474609375, -0.03485107421875, -0.090118408203125, -0.0811767578125, -0.043670654296875, -0.047698974609375, -0.0638427734375, -0.057342529296875, 0.0035400390625, 0.017578125, 0.0140380859375, 0.0224609375, 0.036041259765625, 0.03265380859375, 0.025543212890625, 0.0169677734375, -0.002532958984375, -0.0142822265625, -0.035064697265625, -0.03875732421875, -0.03643798828125, -0.0255126953125, -0.019012451171875, -0.018524169921875, 0.005126953125, 0.016387939453125, 0.01397705078125, -0.0054931640625, -0.015899658203125, -0.008575439453125, -0.009735107421875, -0.0101318359375, -0.00982666015625, -0.009368896484375, -0.00115966796875, 0.014678955078125, 0.0184326171875, 0.006927490234375, 0.00146484375, 0.001922607421875, -0.004669189453125, -0.01348876953125, -0.012298583984375, -0.00469970703125, -0.00469970703125, -0.009033203125, -0.01031494140625, -0.012054443359375, -0.01129150390625, -0.0025634765625, 0.001220703125, 0.00067138671875, 0.00347900390625, 0.010833740234375, 0.01556396484375, 0.01239013671875, 0.010833740234375, 0.007904052734375, -0.000732421875, -0.0081787109375, -0.013885498046875, -0.0133056640625, -0.014495849609375, -0.01654052734375, -0.0108642578125, -0.004486083984375, 0.001007080078125, 0.00494384765625, 0.005218505859375, 0.0025634765625, 9.1552734375e-05, -0.000732421875, 9.1552734375e-05, -0.001373291015625, -0.00238037109375, -0.002349853515625, -0.00445556640625, -0.004486083984375, -0.001953125, -0.00701904296875, -0.011962890625, -0.00799560546875, -0.003387451171875, 0.00164794921875, 0.004791259765625, 0.003509521484375, -6.103515625e-05, -0.00311279296875, -0.00347900390625, -0.001861572265625])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.001220703125, 0.00244140625, -0.00439453125, 0.005889892578125, -0.00848388671875, 0.009918212890625, 0.018280029296875, 0.370758056640625, 0.034271240234375, -0.675567626953125, -0.092254638671875, 0.1693115234375, 0.10321044921875, 0.186126708984375, 0.15838623046875, 0.281982421875, 0.59881591796875, 0.478851318359375, -0.3128662109375, -0.45697021484375, -0.062744140625, 0.203338623046875, 0.04632568359375, -0.254150390625, -0.354248046875, -0.211761474609375, -0.062713623046875, -0.10125732421875, -0.047027587890625, -0.05718994140625, -0.01617431640625, 0.051422119140625, 0.087890625, 0.09814453125, 0.06878662109375, 0.03179931640625, 0.015838623046875, 0.06195068359375, 0.023345947265625, -0.037750244140625, -0.081146240234375, -0.054229736328125, -0.037872314453125, -0.05303955078125, -0.063262939453125, -0.053131103515625, -0.00433349609375, 0.00897216796875, 0.00445556640625, 0.01287841796875, 0.030914306640625, 0.031036376953125, 0.027435302734375, 0.01690673828125, 0.001373291015625, -0.00885009765625, -0.029541015625, -0.033233642578125, -0.03387451171875, -0.028778076171875, -0.024261474609375, -0.018890380859375, 0.006195068359375, 0.0166015625, 0.0135498046875, -0.004364013671875, -0.014556884765625, -0.007080078125, -0.0054931640625, -0.0096435546875, -0.0120849609375, -0.013214111328125, -0.00244140625, 0.015899658203125, 0.01605224609375, 0.00335693359375, 0.000732421875, 0.00341796875, -0.0029296875, -0.009796142578125, -0.0087890625, -0.004608154296875, -0.006988525390625, -0.00994873046875, -0.00946044921875, -0.011505126953125, -0.011444091796875, -0.00347900390625, -0.00067138671875, -0.000732421875, 0.003997802734375, 0.011749267578125, 0.015716552734375, 0.012481689453125, 0.012298583984375, 0.008331298828125, -0.0009765625, -0.00860595703125, -0.014251708984375, -0.01300048828125, -0.0133056640625, -0.014678955078125, -0.01116943359375, -0.0054931640625, 0.000823974609375, 0.0048828125, 0.005340576171875, 0.00225830078125, 0.000732421875, -3.0517578125e-05, 0.0008544921875, -0.000579833984375, -0.003814697265625, -0.003265380859375, -0.004791259765625, -0.00482177734375, -0.0013427734375, -0.005828857421875, -0.01214599609375, -0.007232666015625, -0.001495361328125, 0.002197265625, 0.005035400390625, 0.00311279296875, -0.0015869140625, -0.004302978515625, -0.003875732421875, -0.001617431640625])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.00189208984375, 0.00360107421875, -0.005828857421875, 0.00738525390625, -0.009979248046875, 0.012542724609375, -0.000457763671875, 0.330047607421875, 0.133270263671875, -0.660888671875, -0.16241455078125, 0.1944580078125, 0.069427490234375, 0.164276123046875, 0.160125732421875, 0.278778076171875, 0.5748291015625, 0.4967041015625, -0.28509521484375, -0.459808349609375, -0.027496337890625, 0.214691162109375, 0.050750732421875, -0.25567626953125, -0.335845947265625, -0.205230712890625, -0.07135009765625, -0.107391357421875, -0.060333251953125, -0.066162109375, -0.031768798828125, 0.046356201171875, 0.07904052734375, 0.09765625, 0.071441650390625, 0.037384033203125, 0.021820068359375, 0.06219482421875, 0.02691650390625, -0.036834716796875, -0.074859619140625, -0.04766845703125, -0.0277099609375, -0.05035400390625, -0.068145751953125, -0.053497314453125, -0.008514404296875, 0.0001220703125, -0.004486083984375, 0.008880615234375, 0.0244140625, 0.027618408203125, 0.0284423828125, 0.0206298828125, 0.005859375, -0.0042724609375, -0.022674560546875, -0.03155517578125, -0.03240966796875, -0.02838134765625, -0.02752685546875, -0.02325439453125, 0.0054931640625, 0.019134521484375, 0.014434814453125, -0.003326416015625, -0.013763427734375, -0.00714111328125, -0.006011962890625, -0.011077880859375, -0.013427734375, -0.013397216796875, -0.002471923828125, 0.015106201171875, 0.0157470703125, 0.003631591796875, -3.0517578125e-05, 0.002685546875, -0.0018310546875, -0.00701904296875, -0.00634765625, -0.004852294921875, -0.009307861328125, -0.0108642578125, -0.008880615234375, -0.01153564453125, -0.012451171875, -0.0048828125, -0.0015869140625, -0.0018310546875, 0.00482177734375, 0.013275146484375, 0.015289306640625, 0.011932373046875, 0.01239013671875, 0.009307861328125, 0.000579833984375, -0.008392333984375, -0.01495361328125, -0.0145263671875, -0.013397216796875, -0.01263427734375, -0.010009765625, -0.006134033203125, -0.0006103515625, 0.003387451171875, 0.0048828125, 0.0029296875, 0.002227783203125, 0.000701904296875, 0.000335693359375, -0.00115966796875, -0.00421142578125, -0.003387451171875, -0.0054931640625, -0.005859375, -0.0015869140625, -0.0040283203125, -0.010589599609375, -0.007080078125, -0.00189208984375, 0.001495361328125, 0.004913330078125, 0.0028076171875, -0.001800537109375, -0.003997802734375, -0.003387451171875, -0.001129150390625])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.002685546875, 0.00439453125, -0.00634765625, 0.007171630859375, -0.009246826171875, 0.011627197265625, -0.012664794921875, 0.244537353515625, 0.27325439453125, -0.577301025390625, -0.30950927734375, 0.214263916015625, 0.049713134765625, 0.131622314453125, 0.1556396484375, 0.257781982421875, 0.526824951171875, 0.540557861328125, -0.1812744140625, -0.47686767578125, -0.035247802734375, 0.21435546875, 0.0791015625, -0.237091064453125, -0.3262939453125, -0.210479736328125, -0.079315185546875, -0.110015869140625, -0.077362060546875, -0.0626220703125, -0.0574951171875, 0.03363037109375, 0.068511962890625, 0.095703125, 0.080841064453125, 0.0443115234375, 0.02435302734375, 0.066558837890625, 0.040496826171875, -0.03619384765625, -0.071533203125, -0.04718017578125, -0.024505615234375, -0.04522705078125, -0.06512451171875, -0.05975341796875, -0.018157958984375, -0.000732421875, -0.01165771484375, 0.00030517578125, 0.019622802734375, 0.02520751953125, 0.02716064453125, 0.02496337890625, 0.0133056640625, -0.000701904296875, -0.01678466796875, -0.028472900390625, -0.03106689453125, -0.02850341796875, -0.027374267578125, -0.02728271484375, 0.000213623046875, 0.02142333984375, 0.01812744140625, -0.001190185546875, -0.01544189453125, -0.0089111328125, -0.006805419921875, -0.01220703125, -0.015533447265625, -0.013336181640625, -0.00146484375, 0.01416015625, 0.01580810546875, 0.004730224609375, 0.0001220703125, 0.00238037109375, -0.001129150390625, -0.0042724609375, -0.004608154296875, -0.005096435546875, -0.011260986328125, -0.012481689453125, -0.008575439453125, -0.011688232421875, -0.013885498046875, -0.006591796875, -0.0008544921875, -0.001739501953125, 0.004150390625, 0.013763427734375, 0.0150146484375, 0.011627197265625, 0.0115966796875, 0.01055908203125, 0.003387451171875, -0.007049560546875, -0.01495361328125, -0.0166015625, -0.013092041015625, -0.011077880859375, -0.009002685546875, -0.006866455078125, -0.002105712890625, 0.002105712890625, 0.003662109375, 0.00335693359375, 0.002716064453125, 0.002166748046875, 0.000244140625, -0.00177001953125, -0.00457763671875, -0.004241943359375, -0.00579833984375, -0.006195068359375, -0.001556396484375, -0.002532958984375, -0.008087158203125, -0.007598876953125, -0.003387451171875, 0.000640869140625, 0.003753662109375, 0.002899169921875, -0.0003662109375, -0.00189208984375, -0.002593994140625, -0.001556396484375])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.001953125, 0.002410888671875, -0.002960205078125, 0.00189208984375, -0.00177001953125, 0.001312255859375, -0.00433349609375, 0.10675048828125, 0.385711669921875, -0.3201904296875, -0.5333251953125, 0.170013427734375, 0.07843017578125, 0.0640869140625, 0.15728759765625, 0.2147216796875, 0.451324462890625, 0.574066162109375, 0.027130126953125, -0.472442626953125, -0.109466552734375, 0.207611083984375, 0.11767578125, -0.19146728515625, -0.320770263671875, -0.22735595703125, -0.097137451171875, -0.098480224609375, -0.107635498046875, -0.049835205078125, -0.068817138671875, 0.00042724609375, 0.05560302734375, 0.093658447265625, 0.091522216796875, 0.056671142578125, 0.02880859375, 0.058746337890625, 0.06463623046875, -0.020599365234375, -0.073211669921875, -0.059326171875, -0.02630615234375, -0.041748046875, -0.063018798828125, -0.0587158203125, -0.0306396484375, -0.00634765625, -0.011505126953125, -0.005645751953125, 0.01202392578125, 0.023101806640625, 0.0279541015625, 0.026611328125, 0.02056884765625, 0.006103515625, -0.01123046875, -0.02618408203125, -0.029541015625, -0.02801513671875, -0.0286865234375, -0.029541015625, -0.006683349609375, 0.0172119140625, 0.019012451171875, 0.00537109375, -0.012908935546875, -0.0101318359375, -0.007080078125, -0.013336181640625, -0.017822265625, -0.015716552734375, -0.001861572265625, 0.013580322265625, 0.015533447265625, 0.00567626953125, 0.0008544921875, 0.00421142578125, 0.00067138671875, -0.003875732421875, -0.00543212890625, -0.006500244140625, -0.011688232421875, -0.014129638671875, -0.009979248046875, -0.01092529296875, -0.01336669921875, -0.00860595703125, -0.000762939453125, -0.000732421875, 0.001983642578125, 0.011474609375, 0.015045166015625, 0.01214599609375, 0.0107421875, 0.010772705078125, 0.00567626953125, -0.004669189453125, -0.01348876953125, -0.017608642578125, -0.0140380859375, -0.011383056640625, -0.0091552734375, -0.007476806640625, -0.003997802734375, 0.001068115234375, 0.001922607421875, 0.003387451171875, 0.00262451171875, 0.0035400390625, 0.00128173828125, -0.00238037109375, -0.00537109375, -0.006500244140625, -0.00616455078125, -0.0059814453125, -0.001739501953125, -0.00115966796875, -0.005279541015625, -0.008209228515625, -0.006439208984375, -0.0013427734375, 0.002685546875, 0.00360107421875, 0.00115966796875, -0.000579833984375, -0.001556396484375, -0.002227783203125])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.00054931640625, -0.00152587890625, 0.002532958984375, -0.0047607421875, 0.00628662109375, -0.008575439453125, 0.01031494140625, 0.011383056640625, 0.337799072265625, 0.03515625, -0.628326416015625, -0.032135009765625, 0.16845703125, -0.01116943359375, 0.143096923828125, 0.18878173828125, 0.363677978515625, 0.557891845703125, 0.24591064453125, -0.377685546875, -0.2264404296875, 0.182464599609375, 0.15484619140625, -0.12969970703125, -0.31329345703125, -0.243865966796875, -0.1256103515625, -0.086029052734375, -0.130950927734375, -0.059478759765625, -0.050445556640625, -0.025665283203125, 0.03802490234375, 0.077392578125, 0.104461669921875, 0.072845458984375, 0.038360595703125, 0.04510498046875, 0.076934814453125, 0.008392333984375, -0.06573486328125, -0.0728759765625, -0.04132080078125, -0.037322998046875, -0.061981201171875, -0.060791015625, -0.03778076171875, -0.009735107421875, -0.0106201171875, -0.009765625, 0.01043701171875, 0.021240234375, 0.0269775390625, 0.02691650390625, 0.024261474609375, 0.012451171875, -0.004852294921875, -0.020263671875, -0.030914306640625, -0.0272216796875, -0.026214599609375, -0.031951904296875, -0.015594482421875, 0.0115966796875, 0.019012451171875, 0.010162353515625, -0.0079345703125, -0.0103759765625, -0.006561279296875, -0.01336669921875, -0.018524169921875, -0.018035888671875, -0.004669189453125, 0.013214111328125, 0.0167236328125, 0.008941650390625, 0.00213623046875, 0.004364013671875, 0.002838134765625, -0.0040283203125, -0.0062255859375, -0.008880615234375, -0.012298583984375, -0.01336669921875, -0.010986328125, -0.010406494140625, -0.011566162109375, -0.0087890625, -0.00164794921875, 0.00048828125, 0.000823974609375, 0.00830078125, 0.01458740234375, 0.013458251953125, 0.011138916015625, 0.010040283203125, 0.00677490234375, -0.001556396484375, -0.010589599609375, -0.01678466796875, -0.01568603515625, -0.01226806640625, -0.0103759765625, -0.00732421875, -0.004486083984375, 0.000701904296875, 0.0008544921875, 0.002593994140625, 0.00384521484375, 0.004241943359375, 0.003204345703125, -0.0025634765625, -0.006072998046875, -0.007415771484375, -0.00634765625, -0.005157470703125, -0.00225830078125, -0.000335693359375, -0.002532958984375, -0.00726318359375, -0.008392333984375, -0.00335693359375, 0.001861572265625, 0.00335693359375, 0.001983642578125, 0.000732421875, 0.00042724609375, -0.001678466796875])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.001617431640625, -0.0025634765625, 0.003021240234375, -0.00372314453125, 0.0032958984375, -0.003631591796875, 0.004425048828125, -0.007415771484375, 0.133453369140625, 0.3355712890625, -0.361328125, -0.425384521484375, 0.18756103515625, 0.016815185546875, 0.03253173828125, 0.1865234375, 0.269378662109375, 0.46673583984375, 0.438079833984375, -0.105010986328125, -0.3416748046875, 0.068817138671875, 0.212738037109375, -0.03570556640625, -0.29351806640625, -0.27838134765625, -0.15753173828125, -0.089263916015625, -0.12823486328125, -0.109649658203125, -0.030181884765625, -0.0321044921875, 0.022735595703125, 0.06048583984375, 0.094879150390625, 0.092498779296875, 0.0626220703125, 0.04229736328125, 0.065216064453125, 0.045196533203125, -0.043487548828125, -0.07684326171875, -0.062713623046875, -0.0435791015625, -0.059112548828125, -0.0682373046875, -0.0494384765625, -0.016632080078125, -0.00177001953125, -0.010589599609375, 0.003143310546875, 0.02264404296875, 0.02667236328125, 0.025421142578125, 0.02593994140625, 0.02093505859375, 0.0008544921875, -0.010833740234375, -0.024322509765625, -0.0316162109375, -0.0267333984375, -0.032501220703125, -0.024322509765625, 0.00164794921875, 0.01739501953125, 0.01495361328125, -0.002593994140625, -0.011810302734375, -0.006072998046875, -0.010498046875, -0.0174560546875, -0.019866943359375, -0.009490966796875, 0.0115966796875, 0.01751708984375, 0.01275634765625, 0.00604248046875, 0.00262451171875, 0.00323486328125, -0.0037841796875, -0.00823974609375, -0.009765625, -0.013702392578125, -0.014068603515625, -0.01177978515625, -0.0096435546875, -0.008331298828125, -0.00799560546875, -0.003936767578125, 0.000762939453125, 0.0008544921875, 0.005828857421875, 0.01336669921875, 0.013824462890625, 0.010772705078125, 0.009033203125, 0.00677490234375, 0.001617431640625, -0.007171630859375, -0.015960693359375, -0.01806640625, -0.013885498046875, -0.01129150390625, -0.007904052734375, -0.004791259765625, -0.000396728515625, 0.001983642578125, 0.001556396484375, 0.004150390625, 0.00445556640625, 0.00408935546875, -0.000457763671875, -0.006561279296875, -0.0084228515625, -0.007171630859375, -0.00482177734375, -0.003143310546875, -0.001068115234375, -0.000701904296875, -0.0050048828125, -0.008331298828125, -0.00579833984375, -0.00115966796875, 0.00213623046875, 0.002288818359375, 0.001312255859375, 0.002349853515625, 0.000457763671875])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.000213623046875, 0.00079345703125, -0.00177001953125, 0.00244140625, -0.00433349609375, 0.005523681640625, -0.00750732421875, 0.009063720703125, 0.005767822265625, 0.28582763671875, 0.090789794921875, -0.544036865234375, -0.087890625, 0.154937744140625, -0.050994873046875, 0.121734619140625, 0.22650146484375, 0.355255126953125, 0.484039306640625, 0.18499755859375, -0.275665283203125, -0.108428955078125, 0.200225830078125, 0.082977294921875, -0.214599609375, -0.33056640625, -0.207489013671875, -0.103485107421875, -0.1038818359375, -0.14434814453125, -0.058929443359375, -0.01544189453125, 0.00213623046875, 0.055633544921875, 0.08941650390625, 0.10125732421875, 0.0712890625, 0.05413818359375, 0.05609130859375, 0.063751220703125, -0.0103759765625, -0.075103759765625, -0.07244873046875, -0.054443359375, -0.05560302734375, -0.073394775390625, -0.06396484375, -0.031524658203125, -0.00042724609375, -0.001007080078125, -0.00347900390625, 0.017608642578125, 0.028289794921875, 0.027435302734375, 0.025970458984375, 0.026763916015625, 0.010498046875, -0.008575439453125, -0.016693115234375, -0.031402587890625, -0.027618408203125, -0.0301513671875, -0.030731201171875, -0.008026123046875, 0.011199951171875, 0.016082763671875, 0.00360107421875, -0.0113525390625, -0.010040283203125, -0.00921630859375, -0.01385498046875, -0.015777587890625, -0.0123291015625, 0.006317138671875, 0.016632080078125, 0.01446533203125, 0.010162353515625, 0.003387451171875, 0.0018310546875, -0.00274658203125, -0.010009765625, -0.011810302734375, -0.014801025390625, -0.014801025390625, -0.01092529296875, -0.010101318359375, -0.007598876953125, -0.00604248046875, -0.0050048828125, 0.00018310546875, 0.00238037109375, 0.004974365234375, 0.01080322265625, 0.013763427734375, 0.0108642578125, 0.00665283203125, 0.0048828125, 0.002685546875, -0.00384521484375, -0.01422119140625, -0.019012451171875, -0.01568603515625, -0.011688232421875, -0.008819580078125, -0.0048828125, -0.0018310546875, 0.002349853515625, 0.002471923828125, 0.003082275390625, 0.005340576171875, 0.00390625, 0.00115966796875, -0.00518798828125, -0.00933837890625, -0.00848388671875, -0.00506591796875, -0.003387451171875, -0.003204345703125, -0.001312255859375, -0.00286865234375, -0.006561279296875, -0.00653076171875, -0.00408935546875, -0.000335693359375, 0.002105712890625, 0.00140380859375, 0.002044677734375, 0.001922607421875])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.000579833984375, 0.00103759765625, -0.00115966796875, 0.000762939453125, -0.000732421875, -0.000335693359375, 0.0008544921875, -0.001739501953125, 0.000457763671875, 0.0567626953125, 0.313232421875, -0.11676025390625, -0.4693603515625, 0.0460205078125, 0.060943603515625, -0.01910400390625, 0.17230224609375, 0.2486572265625, 0.382781982421875, 0.414154052734375, 0.0279541015625, -0.21331787109375, 0.0533447265625, 0.158721923828125, -0.061126708984375, -0.287200927734375, -0.288604736328125, -0.17230224609375, -0.1116943359375, -0.11993408203125, -0.110198974609375, -0.029815673828125, -0.00372314453125, 0.03436279296875, 0.07598876953125, 0.10980224609375, 0.10174560546875, 0.062652587890625, 0.0457763671875, 0.05828857421875, 0.046112060546875, -0.0423583984375, -0.083404541015625, -0.0679931640625, -0.05609130859375, -0.066497802734375, -0.076568603515625, -0.05670166015625, -0.020263671875, 0.003173828125, 9.1552734375e-05, 0.00836181640625, 0.026519775390625, 0.03143310546875, 0.03131103515625, 0.027862548828125, 0.022186279296875, -0.001251220703125, -0.011383056640625, -0.021759033203125, -0.029510498046875, -0.024749755859375, -0.03338623046875, -0.02154541015625, -0.00067138671875, 0.01190185546875, 0.00885009765625, -0.005615234375, -0.011566162109375, -0.009033203125, -0.010498046875, -0.012176513671875, -0.012115478515625, -0.00189208984375, 0.01483154296875, 0.014373779296875, 0.012237548828125, 0.00872802734375, 0.001953125, -0.001068115234375, -0.010467529296875, -0.01495361328125, -0.0155029296875, -0.01641845703125, -0.0107421875, -0.008209228515625, -0.007965087890625, -0.004730224609375, -0.0042724609375, -0.00164794921875, 0.003448486328125, 0.00634765625, 0.008697509765625, 0.010528564453125, 0.010711669921875, 0.006317138671875, 0.001068115234375, -0.000213623046875, -0.0006103515625, -0.007598876953125, -0.016693115234375, -0.01776123046875, -0.013641357421875, -0.010040283203125, -0.00531005859375, -0.00213623046875, 0.0003662109375, 0.003814697265625, 0.003570556640625, 0.005615234375, 0.00543212890625, 0.001800537109375, -0.0028076171875, -0.008636474609375, -0.009613037109375, -0.006011962890625, -0.003265380859375, -0.004486083984375, -0.003997802734375, -0.002777099609375, -0.00421142578125, -0.00506591796875, -0.0057373046875, -0.00372314453125, 0.00115966796875, 0.0020751953125, 0.001220703125, 0.00274658203125])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.00067138671875, -0.001007080078125, 0.0015869140625, -0.002166748046875, 0.00250244140625, -0.003448486328125, 0.003692626953125, -0.004486083984375, 0.005584716796875, -0.007354736328125, 0.13751220703125, 0.2608642578125, -0.2926025390625, -0.32000732421875, 0.083648681640625, -0.0057373046875, 0.054412841796875, 0.2025146484375, 0.272796630859375, 0.3919677734375, 0.3043212890625, -0.060638427734375, -0.088134765625, 0.116943359375, 0.047607421875, -0.170867919921875, -0.3067626953125, -0.237579345703125, -0.1439208984375, -0.12646484375, -0.13214111328125, -0.064208984375, 0.00103759765625, 0.010986328125, 0.051544189453125, 0.09429931640625, 0.119354248046875, 0.08917236328125, 0.0615234375, 0.04736328125, 0.049102783203125, 0.010040283203125, -0.05853271484375, -0.07122802734375, -0.064697265625, -0.066619873046875, -0.075653076171875, -0.07073974609375, -0.04443359375, -0.01275634765625, 0.000244140625, 0.003143310546875, 0.0216064453125, 0.03131103515625, 0.03387451171875, 0.032257080078125, 0.02783203125, 0.01153564453125, -0.007568359375, -0.011810302734375, -0.02655029296875, -0.025390625, -0.028961181640625, -0.029296875, -0.011199951171875, 0.002838134765625, 0.00830078125, 0.00140380859375, -0.006744384765625, -0.010284423828125, -0.010498046875, -0.012054443359375, -0.011138916015625, -0.007415771484375, 0.008392333984375, 0.016021728515625, 0.01171875, 0.0125732421875, 0.00579833984375, -0.000335693359375, -0.0076904296875, -0.0162353515625, -0.016815185546875, -0.017425537109375, -0.012542724609375, -0.006927490234375, -0.007537841796875, -0.0045166015625, -0.0025634765625, -0.004058837890625, 0.00018310546875, 0.006011962890625, 0.00909423828125, 0.009002685546875, 0.008331298828125, 0.00567626953125, 0.00048828125, -0.00164794921875, -0.00054931640625, -0.0035400390625, -0.01226806640625, -0.01739501953125, -0.015350341796875, -0.01080322265625, -0.00689697265625, -0.00323486328125, -0.001220703125, 0.002777099609375, 0.00494384765625, 0.00445556640625, 0.005767822265625, 0.003326416015625, -0.0009765625, -0.006072998046875, -0.009765625, -0.007537841796875, -0.004058837890625, -0.00439453125, -0.00567626953125, -0.004302978515625, -0.004364013671875, -0.00439453125, -0.004852294921875, -0.005950927734375, -0.0015869140625, 0.00250244140625, 0.002349853515625, 0.002349853515625])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.0001220703125, 0.000244140625, -0.000396728515625, 0.000885009765625, -0.001678466796875, 0.00213623046875, -0.003448486328125, 0.00433349609375, -0.00592041015625, 0.00738525390625, -0.000274658203125, 0.2044677734375, 0.150604248046875, -0.360107421875, -0.185394287109375, 0.04998779296875, -0.01318359375, 0.118896484375, 0.212127685546875, 0.2877197265625, 0.3792724609375, 0.202423095703125, -0.068389892578125, 0.02020263671875, 0.091064453125, -0.06256103515625, -0.234100341796875, -0.285491943359375, -0.19598388671875, -0.1329345703125, -0.127471923828125, -0.120025634765625, -0.040130615234375, 0.013336181640625, 0.0335693359375, 0.063873291015625, 0.10223388671875, 0.11627197265625, 0.0809326171875, 0.05792236328125, 0.0509033203125, 0.042022705078125, -0.0181884765625, -0.065185546875, -0.06121826171875, -0.0616455078125, -0.073028564453125, -0.079254150390625, -0.064666748046875, -0.03448486328125, -0.00787353515625, -0.001495361328125, 0.0076904296875, 0.02716064453125, 0.034942626953125, 0.0374755859375, 0.031494140625, 0.020782470703125, 0.000701904296875, -0.007537841796875, -0.015380859375, -0.024139404296875, -0.0234375, -0.03082275390625, -0.020263671875, -0.0040283203125, 0.005615234375, 0.00341796875, -0.002777099609375, -0.0076904296875, -0.011077880859375, -0.01202392578125, -0.012451171875, -0.01116943359375, -0.002105712890625, 0.013824462890625, 0.01336669921875, 0.011993408203125, 0.01104736328125, 0.003143310546875, -0.002655029296875, -0.011993408203125, -0.01654052734375, -0.0172119140625, -0.0152587890625, -0.009124755859375, -0.00750732421875, -0.006591796875, -0.00244140625, -0.003082275390625, -0.00341796875, 0.001220703125, 0.00634765625, 0.009979248046875, 0.008056640625, 0.00445556640625, 0.001922607421875, -6.103515625e-05, -0.001129150390625, -0.00250244140625, -0.007659912109375, -0.0142822265625, -0.0159912109375, -0.01214599609375, -0.0078125, -0.004425048828125, -0.002593994140625, -0.000823974609375, 0.003204345703125, 0.00433349609375, 0.004730224609375, 0.004974365234375, 0.0013427734375, -0.002899169921875, -0.006591796875, -0.007904052734375, -0.00592041015625, -0.0050048828125, -0.00628662109375, -0.005828857421875, -0.0050048828125, -0.004913330078125, -0.00439453125, -0.005889892578125, -0.004241943359375, 0.00067138671875, 0.00323486328125, 0.002838134765625])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.0, 0.000274658203125, 3.0517578125e-05, -6.103515625e-05, 0.000396728515625, -0.001007080078125, 0.00146484375, -0.0025634765625, 0.00335693359375, -0.004791259765625, 0.005889892578125, 0.007171630859375, 0.20831298828125, 0.110992431640625, -0.333465576171875, -0.16278076171875, 0.019134521484375, -0.00091552734375, 0.1368408203125, 0.218536376953125, 0.275390625, 0.3436279296875, 0.18731689453125, -0.014312744140625, 0.03948974609375, 0.028656005859375, -0.110809326171875, -0.249603271484375, -0.263885498046875, -0.159393310546875, -0.126312255859375, -0.135650634765625, -0.103668212890625, -0.028045654296875, 0.0103759765625, 0.0367431640625, 0.0714111328125, 0.105194091796875, 0.106536865234375, 0.079681396484375, 0.0662841796875, 0.049835205078125, 0.032989501953125, -0.0174560546875, -0.058349609375, -0.06341552734375, -0.066192626953125, -0.070465087890625, -0.074249267578125, -0.06097412109375, -0.0333251953125, -0.007476806640625, 0.00225830078125, 0.01519775390625, 0.027984619140625, 0.03143310546875, 0.03350830078125, 0.026397705078125, 0.011932373046875, -0.00372314453125, -0.005523681640625, -0.01220703125, -0.016448974609375, -0.022125244140625, -0.026031494140625, -0.01202392578125, -0.001373291015625, 0.004241943359375, 0.000732421875, -0.00445556640625, -0.01104736328125, -0.01416015625, -0.013153076171875, -0.012725830078125, -0.010498046875, 0.000457763671875, 0.01177978515625, 0.011138916015625, 0.013916015625, 0.010833740234375, 0.003875732421875, -0.00189208984375, -0.010223388671875, -0.014251708984375, -0.01776123046875, -0.016632080078125, -0.01220703125, -0.010040283203125, -0.0054931640625, -0.00213623046875, -0.003631591796875, -0.00244140625, 0.001312255859375, 0.00714111328125, 0.009063720703125, 0.005279541015625, 0.00396728515625, 0.00341796875, 0.000732421875, -0.001739501953125, -0.0050048828125, -0.010162353515625, -0.014007568359375, -0.01312255859375, -0.008575439453125, -0.00579833984375, -0.004608154296875, -0.003936767578125, -0.001953125, 0.002288818359375, 0.00408935546875, 0.00384521484375, 0.00390625, 0.001373291015625, -0.001495361328125, -0.004608154296875, -0.006256103515625, -0.005889892578125, -0.006378173828125, -0.006591796875, -0.006500244140625, -0.005645751953125, -0.004974365234375, -0.00482177734375, -0.0050048828125, -0.003021240234375, 0.001708984375, 0.003753662109375])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.0001220703125, -0.0001220703125, 0.00048828125, -0.000274658203125, 0.000396728515625, -0.0003662109375, -3.0517578125e-05, 0.000244140625, -0.00103759765625, 0.001434326171875, -0.00250244140625, 0.002593994140625, 0.02606201171875, 0.223052978515625, 0.03790283203125, -0.325836181640625, -0.126739501953125, 0.006622314453125, 0.02642822265625, 0.15948486328125, 0.222747802734375, 0.270843505859375, 0.30731201171875, 0.161834716796875, 0.02911376953125, 0.027130126953125, -0.043212890625, -0.151275634765625, -0.248626708984375, -0.21856689453125, -0.1302490234375, -0.130828857421875, -0.1365966796875, -0.087158203125, -0.0140380859375, 0.01776123046875, 0.03680419921875, 0.068572998046875, 0.105133056640625, 0.1026611328125, 0.0804443359375, 0.0655517578125, 0.0452880859375, 0.024078369140625, -0.024017333984375, -0.051239013671875, -0.05963134765625, -0.07269287109375, -0.076080322265625, -0.0694580078125, -0.04693603515625, -0.018707275390625, -0.002960205078125, 0.00103759765625, 0.016815185546875, 0.02789306640625, 0.026702880859375, 0.022796630859375, 0.017059326171875, 0.006103515625, -0.0009765625, -0.003173828125, -0.009246826171875, -0.013763427734375, -0.022857666015625, -0.01861572265625, -0.0062255859375, 0.001434326171875, 0.003326416015625, -0.00225830078125, -0.009033203125, -0.015106201171875, -0.01611328125, -0.014984130859375, -0.012664794921875, -0.0091552734375, 0.002349853515625, 0.00927734375, 0.01202392578125, 0.0159912109375, 0.0106201171875, 0.00433349609375, -0.003448486328125, -0.009521484375, -0.016204833984375, -0.021392822265625, -0.019378662109375, -0.01568603515625, -0.01025390625, -0.00433349609375, -0.002777099609375, -0.003875732421875, -0.001007080078125, 0.003265380859375, 0.007720947265625, 0.00701904296875, 0.0045166015625, 0.005279541015625, 0.003509521484375, -0.00042724609375, -0.004730224609375, -0.0091552734375, -0.011993408203125, -0.012542724609375, -0.009765625, -0.006805419921875, -0.006195068359375, -0.00567626953125, -0.00494384765625, -0.002899169921875, 0.000885009765625, 0.002105712890625, 0.002716064453125, 0.003753662109375, 0.001708984375, -0.001129150390625, -0.003692626953125, -0.0054931640625, -0.00640869140625, -0.0069580078125, -0.007904052734375, -0.00750732421875, -0.006622314453125, -0.00592041015625, -0.004913330078125, -0.00457763671875, -0.002410888671875, 0.001220703125])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.000244140625, 0.000213623046875, -0.0001220703125, 0.00042724609375, -0.000213623046875, 0.000244140625, -0.000244140625, -6.103515625e-05, 0.00018310546875, -0.0009765625, 0.001190185546875, -0.002105712890625, 0.0023193359375, 0.025115966796875, 0.20831298828125, 0.0523681640625, -0.30889892578125, -0.149261474609375, 0.005584716796875, 0.047027587890625, 0.170745849609375, 0.204071044921875, 0.23883056640625, 0.2822265625, 0.186676025390625, 0.05743408203125, -0.00616455078125, -0.077667236328125, -0.157379150390625, -0.220855712890625, -0.1844482421875, -0.122222900390625, -0.13665771484375, -0.131927490234375, -0.082244873046875, -0.014923095703125, 0.019317626953125, 0.034942626953125, 0.0667724609375, 0.098236083984375, 0.09637451171875, 0.078643798828125, 0.064605712890625, 0.042449951171875, 0.0247802734375, -0.0166015625, -0.04718017578125, -0.0596923828125, -0.06781005859375, -0.066070556640625, -0.061279296875, -0.04296875, -0.0189208984375, -0.0023193359375, 0.005950927734375, 0.015380859375, 0.02069091796875, 0.021484375, 0.0224609375, 0.016204833984375, 0.003143310546875, -0.002410888671875, -0.004547119140625, -0.006011962890625, -0.012481689453125, -0.01947021484375, -0.011627197265625, -0.001678466796875, 0.002716064453125, 0.001556396484375, -0.003021240234375, -0.01116943359375, -0.01739501953125, -0.017608642578125, -0.0147705078125, -0.012115478515625, -0.00921630859375, -6.103515625e-05, 0.00726318359375, 0.014678955078125, 0.018218994140625, 0.0118408203125, 0.00341796875, -0.00439453125, -0.01025390625, -0.01824951171875, -0.02215576171875, -0.021270751953125, -0.017303466796875, -0.01019287109375, -0.00408935546875, -0.003265380859375, -0.002593994140625, 0.001983642578125, 0.00555419921875, 0.008392333984375, 0.0084228515625, 0.006744384765625, 0.00469970703125, 0.001251220703125, -0.0029296875, -0.00799560546875, -0.011077880859375, -0.01007080078125, -0.008026123046875, -0.006378173828125, -0.005706787109375, -0.006134033203125, -0.0062255859375, -0.0064697265625, -0.004638671875, -0.0008544921875, 0.000396728515625, 0.002655029296875, 0.00555419921875, 0.003997802734375, 0.001251220703125, -0.001708984375, -0.005340576171875, -0.006256103515625, -0.006988525390625, -0.00830078125, -0.00787353515625, -0.007049560546875, -0.00543212890625, -0.00390625, -0.0040283203125, -0.00244140625])
        IR_RIGHT[len(IR_RIGHT)-1].append([-9.1552734375e-05, -0.000213623046875, 0.000244140625, -0.00018310546875, 0.000518798828125, -0.00030517578125, 0.000396728515625, -0.000457763671875, 0.000244140625, -0.000274658203125, -0.000335693359375, 0.000396728515625, -0.00079345703125, 0.00091552734375, 0.038238525390625, 0.212066650390625, 0.009796142578125, -0.314117431640625, -0.127227783203125, 0.014984130859375, 0.078582763671875, 0.186553955078125, 0.186737060546875, 0.210296630859375, 0.26007080078125, 0.1959228515625, 0.053192138671875, -0.041748046875, -0.1060791015625, -0.15826416015625, -0.19073486328125, -0.149444580078125, -0.121551513671875, -0.15008544921875, -0.12310791015625, -0.066864013671875, -0.008270263671875, 0.022308349609375, 0.0421142578125, 0.0665283203125, 0.0908203125, 0.0894775390625, 0.07421875, 0.05804443359375, 0.03515625, 0.01922607421875, -0.01708984375, -0.03985595703125, -0.053680419921875, -0.06298828125, -0.060791015625, -0.054351806640625, -0.03729248046875, -0.01824951171875, -0.003814697265625, 0.006378173828125, 0.0179443359375, 0.02490234375, 0.02569580078125, 0.021575927734375, 0.0079345703125, -0.00128173828125, -0.004852294921875, -0.00775146484375, -0.005889892578125, -0.012664794921875, -0.015533447265625, -0.006927490234375, 0.001190185546875, 0.0028076171875, 0.000335693359375, -0.005035400390625, -0.0123291015625, -0.01593017578125, -0.017486572265625, -0.01666259765625, -0.016357421875, -0.010894775390625, 0.0008544921875, 0.010223388671875, 0.017669677734375, 0.0172119140625, 0.010101318359375, 0.000823974609375, -0.005889892578125, -0.012725830078125, -0.02154541015625, -0.023773193359375, -0.021270751953125, -0.0145263671875, -0.0079345703125, -0.004425048828125, -0.003936767578125, -3.0517578125e-05, 0.005126953125, 0.007415771484375, 0.00921630859375, 0.008148193359375, 0.005523681640625, 0.0023193359375, -0.002044677734375, -0.006500244140625, -0.009613037109375, -0.009063720703125, -0.006500244140625, -0.0054931640625, -0.0052490234375, -0.006256103515625, -0.007415771484375, -0.007720947265625, -0.007080078125, -0.004669189453125, -0.00177001953125, 0.000213623046875, 0.00384521484375, 0.0064697265625, 0.004547119140625, 0.002288818359375, -0.00244140625, -0.006439208984375, -0.006561279296875, -0.007781982421875, -0.007843017578125, -0.0072021484375, -0.00689697265625, -0.0052490234375, -0.003753662109375, -0.003265380859375])
        IR_RIGHT[len(IR_RIGHT)-1].append([-6.103515625e-05, -3.0517578125e-05, -0.000244140625, 0.000213623046875, -6.103515625e-05, 0.000396728515625, -0.000213623046875, 0.00030517578125, -0.000244140625, 3.0517578125e-05, 0.00018310546875, -0.000823974609375, 0.001007080078125, -0.00128173828125, 0.001983642578125, 0.030242919921875, 0.200775146484375, 0.031158447265625, -0.312164306640625, -0.13690185546875, 0.029052734375, 0.091461181640625, 0.180633544921875, 0.159576416015625, 0.172119140625, 0.2376708984375, 0.22930908203125, 0.068145751953125, -0.08026123046875, -0.1239013671875, -0.131317138671875, -0.15179443359375, -0.12835693359375, -0.11944580078125, -0.155670166015625, -0.127044677734375, -0.06292724609375, 0.003021240234375, 0.022003173828125, 0.030181884765625, 0.060150146484375, 0.08660888671875, 0.08612060546875, 0.0736083984375, 0.051666259765625, 0.024932861328125, 0.018035888671875, -0.00640869140625, -0.032073974609375, -0.05224609375, -0.054443359375, -0.047882080078125, -0.048370361328125, -0.0372314453125, -0.019134521484375, -0.00299072265625, 0.006988525390625, 0.0179443359375, 0.0250244140625, 0.026702880859375, 0.021881103515625, 0.003936767578125, -0.0059814453125, -0.00628662109375, -0.00189208984375, -0.001861572265625, -0.01580810546875, -0.0177001953125, -0.0054931640625, 0.00439453125, 0.00341796875, -0.00152587890625, -0.008026123046875, -0.0130615234375, -0.01654052734375, -0.019744873046875, -0.020050048828125, -0.01953125, -0.010406494140625, 0.003448486328125, 0.014129638671875, 0.0203857421875, 0.0172119140625, 0.007171630859375, -0.002960205078125, -0.008087158203125, -0.0146484375, -0.022491455078125, -0.024169921875, -0.019256591796875, -0.011474609375, -0.00634765625, -0.003662109375, -0.0025634765625, 0.000823974609375, 0.00439453125, 0.00714111328125, 0.008270263671875, 0.00738525390625, 0.005126953125, 0.0010986328125, -0.00323486328125, -0.0067138671875, -0.008087158203125, -0.00738525390625, -0.00634765625, -0.00531005859375, -0.005340576171875, -0.006988525390625, -0.0076904296875, -0.00714111328125, -0.006927490234375, -0.005401611328125, -0.002593994140625, 0.00054931640625, 0.004730224609375, 0.006591796875, 0.00457763671875, 0.00128173828125, -0.00323486328125, -0.0057373046875, -0.0064697265625, -0.007904052734375, -0.007476806640625, -0.006317138671875, -0.005584716796875, -0.004608154296875, -0.00457763671875])
        IR_RIGHT.append([])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.000244140625, 0.00018310546875, -0.000152587890625, 0.000152587890625, 0.0, -0.0001220703125, 9.1552734375e-05, -0.0008544921875, 0.001068115234375, -0.001800537109375, 0.001800537109375, -0.002532958984375, 0.00250244140625, 0.019989013671875, 0.192657470703125, 0.0638427734375, -0.3096923828125, -0.07501220703125, -0.0418701171875, -0.07745361328125, 0.26165771484375, 0.285064697265625, 0.139739990234375, 0.162506103515625, 0.42041015625, 0.166412353515625, -0.2283935546875, -0.082794189453125, -0.15338134765625, -0.319488525390625, -0.051300048828125, 0.0322265625, -0.18218994140625, -0.114593505859375, 0.026153564453125, 0.030181884765625, -0.01220703125, 0.010406494140625, 0.042083740234375, -0.0072021484375, 0.004058837890625, 0.0555419921875, -0.011474609375, -0.05389404296875, -0.00286865234375, 0.004974365234375, -0.03363037109375, -0.04180908203125, -0.020904541015625, -0.019805908203125, -0.0198974609375, 0.0048828125, 0.007659912109375, -0.008270263671875, 0.0062255859375, 0.0224609375, 0.0213623046875, 0.01104736328125, 0.0037841796875, 0.0018310546875, -0.001373291015625, -0.014495849609375, -0.014495849609375, -0.015045166015625, -0.02105712890625, -0.0145263671875, -0.006011962890625, -0.00811767578125, -0.00836181640625, 0.000335693359375, 0.000946044921875, -0.000396728515625, 0.003692626953125, 0.003936767578125, -0.000213623046875, -0.001434326171875, -0.003326416015625, -0.00482177734375, -0.00543212890625, -0.00396728515625, -0.00262451171875, -0.0015869140625, -0.00494384765625, -0.004638671875, -0.002288818359375, -0.00189208984375, -0.001220703125, -0.00054931640625, -0.00177001953125, -0.004730224609375, -0.00360107421875, -0.00433349609375, -0.005401611328125, -0.000762939453125, -0.00213623046875, -0.01544189453125, -0.018951416015625, -0.015869140625, -0.00830078125, 0.008148193359375, 0.0152587890625, 0.0113525390625, 0.008209228515625, -0.000244140625, -0.009918212890625, -0.014434814453125, -0.01983642578125, -0.025909423828125, -0.020660400390625, -0.001129150390625, 0.009033203125, 0.007843017578125, 0.0078125, 0.00518798828125, 0.001953125, 0.000244140625, -0.00115966796875, 0.00018310546875, 0.00360107421875, 0.00433349609375, 0.0009765625, -0.00250244140625, -0.00634765625, -0.007781982421875, -0.0084228515625, -0.01007080078125, -0.011688232421875, -0.014404296875])
        IR_RIGHT[len(IR_RIGHT)-1].append([9.1552734375e-05, 0.0, 6.103515625e-05, 0.000213623046875, -0.000335693359375, 0.00048828125, -0.00128173828125, 0.001556396484375, -0.0023193359375, 0.0023193359375, -0.003173828125, 0.00335693359375, 0.011932373046875, 0.194061279296875, 0.12255859375, -0.338226318359375, -0.131744384765625, -0.025787353515625, -0.109344482421875, 0.27618408203125, 0.33111572265625, 0.154998779296875, 0.152069091796875, 0.44842529296875, 0.236328125, -0.261810302734375, -0.116119384765625, -0.15399169921875, -0.3577880859375, -0.0701904296875, 0.042877197265625, -0.183380126953125, -0.1201171875, 0.02691650390625, 0.04351806640625, -0.004852294921875, 0.006011962890625, 0.0511474609375, -0.014678955078125, -0.0211181640625, 0.05340576171875, -0.007293701171875, -0.053436279296875, 0.00750732421875, 0.006622314453125, -0.04071044921875, -0.042877197265625, -0.01239013671875, -0.0213623046875, -0.0306396484375, 0.004913330078125, 0.01422119140625, -0.00750732421875, 0.007568359375, 0.0201416015625, 0.016082763671875, 0.01348876953125, 0.01007080078125, 0.004913330078125, -0.001983642578125, -0.01409912109375, -0.013153076171875, -0.01605224609375, -0.02593994140625, -0.019317626953125, -0.010284423828125, -0.010833740234375, -0.00787353515625, 0.00360107421875, 0.0042724609375, 0.000885009765625, 0.005340576171875, 0.006744384765625, 9.1552734375e-05, 0.000823974609375, -0.00286865234375, -0.008575439453125, -0.008636474609375, -0.0064697265625, -0.005096435546875, -0.00335693359375, -0.005279541015625, -0.004852294921875, -0.002349853515625, -0.002410888671875, -0.00018310546875, 0.001312255859375, 0.0006103515625, -0.00103759765625, -0.000274658203125, -0.003082275390625, -0.006256103515625, -0.0025634765625, 0.000762939453125, -0.012054443359375, -0.0206298828125, -0.0189208984375, -0.014862060546875, 0.001617431640625, 0.014892578125, 0.012359619140625, 0.009490966796875, 0.004486083984375, -0.00543212890625, -0.01129150390625, -0.01788330078125, -0.026214599609375, -0.02587890625, -0.007049560546875, 0.009521484375, 0.009735107421875, 0.0076904296875, 0.005279541015625, 0.001708984375, 0.00128173828125, 0.00146484375, 0.00164794921875, 0.00335693359375, 0.004974365234375, 0.00262451171875, -0.001953125, -0.00665283203125, -0.009185791015625, -0.0101318359375, -0.010711669921875, -0.009918212890625, -0.01165771484375, -0.0140380859375])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.00018310546875, -9.1552734375e-05, 0.00048828125, -0.000640869140625, 0.00079345703125, -0.00164794921875, 0.001800537109375, -0.002410888671875, 0.002288818359375, -0.003082275390625, 0.003448486328125, 0.00360107421875, 0.17474365234375, 0.19903564453125, -0.32501220703125, -0.227874755859375, -0.008270263671875, -0.13507080078125, 0.253631591796875, 0.389404296875, 0.181243896484375, 0.138916015625, 0.458099365234375, 0.326629638671875, -0.2662353515625, -0.16876220703125, -0.146484375, -0.39483642578125, -0.11334228515625, 0.082122802734375, -0.170135498046875, -0.149688720703125, 0.026123046875, 0.050079345703125, 9.1552734375e-05, 0.000732421875, 0.05963134765625, -0.022735595703125, -0.066162109375, 0.048248291015625, 0.031585693359375, -0.04193115234375, -0.002655029296875, 0.011627197265625, -0.03082275390625, -0.04376220703125, -0.009765625, -0.0185546875, -0.04248046875, -0.003936767578125, 0.016448974609375, -0.009124755859375, 0.00311279296875, 0.01776123046875, 0.012451171875, 0.0108642578125, 0.00958251953125, 0.010650634765625, 0.00592041015625, -0.011199951171875, -0.01165771484375, -0.010284423828125, -0.02215576171875, -0.022186279296875, -0.014678955078125, -0.015045166015625, -0.015228271484375, -0.000518798828125, 0.00653076171875, 0.002777099609375, 0.006439208984375, 0.009521484375, 0.000823974609375, 0.000823974609375, 6.103515625e-05, -0.008056640625, -0.01116943359375, -0.009521484375, -0.008209228515625, -0.0068359375, -0.005889892578125, -0.003814697265625, -0.00152587890625, -0.002716064453125, 0.00091552734375, 0.004425048828125, 0.002227783203125, -0.00054931640625, 0.0008544921875, -0.00128173828125, -0.006256103515625, -0.00469970703125, 0.001708984375, -0.008514404296875, -0.021759033203125, -0.01995849609375, -0.016387939453125, -0.0059814453125, 0.01043701171875, 0.013519287109375, 0.010589599609375, 0.008331298828125, -0.00042724609375, -0.0069580078125, -0.01397705078125, -0.02471923828125, -0.03021240234375, -0.015960693359375, 0.006072998046875, 0.0111083984375, 0.008697509765625, 0.00543212890625, 0.000732421875, 0.001129150390625, 0.00250244140625, 0.0035400390625, 0.005279541015625, 0.007232666015625, 0.005096435546875, -0.00054931640625, -0.005340576171875, -0.009063720703125, -0.012176513671875, -0.01361083984375, -0.011138916015625, -0.00970458984375, -0.01300048828125, -0.011688232421875])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.0001220703125, 0.000640869140625, -0.0008544921875, 0.00091552734375, -0.001739501953125, 0.0015869140625, -0.001983642578125, 0.001495361328125, -0.002166748046875, 0.00238037109375, -0.001129150390625, 0.13665771484375, 0.269989013671875, -0.251861572265625, -0.34222412109375, -0.022216796875, -0.1356201171875, 0.200042724609375, 0.430999755859375, 0.22955322265625, 0.13616943359375, 0.442047119140625, 0.429107666015625, -0.228485107421875, -0.234954833984375, -0.16424560546875, -0.427947998046875, -0.136444091796875, 0.124267578125, -0.14892578125, -0.18487548828125, 0.003082275390625, 0.052215576171875, 0.014068603515625, -0.00146484375, 0.0550537109375, -0.0386962890625, -0.11248779296875, 0.054718017578125, 0.09039306640625, -0.033905029296875, -0.027435302734375, 0.01708984375, 0.0, -0.036376953125, -0.022857666015625, -0.02569580078125, -0.04534912109375, -0.009490966796875, 0.015716552734375, -0.01739501953125, -0.00885009765625, 0.017059326171875, 0.01092529296875, 0.00836181640625, 0.008087158203125, 0.01312255859375, 0.01177978515625, -0.006866455078125, -0.00750732421875, -0.000640869140625, -0.017608642578125, -0.02227783203125, -0.014801025390625, -0.01507568359375, -0.019500732421875, -0.0074462890625, 0.00018310546875, -0.000396728515625, 0.008026123046875, 0.012237548828125, 6.103515625e-05, -0.001678466796875, 0.00286865234375, -0.005401611328125, -0.011749267578125, -0.01025390625, -0.0089111328125, -0.00714111328125, -0.00640869140625, -0.005401611328125, -0.000823974609375, -0.002044677734375, 0.000732421875, 0.004150390625, 0.00341796875, 0.000213623046875, 0.002532958984375, 0.00079345703125, -0.00677490234375, -0.007904052734375, -9.1552734375e-05, -0.002838134765625, -0.01983642578125, -0.02276611328125, -0.017974853515625, -0.01129150390625, 0.0054931640625, 0.01397705078125, 0.0120849609375, 0.01129150390625, 0.00439453125, -0.002777099609375, -0.009552001953125, -0.020111083984375, -0.031524658203125, -0.026611328125, -0.00115966796875, 0.011444091796875, 0.008026123046875, 0.005279541015625, 0.0008544921875, 0.00079345703125, 0.002044677734375, 0.003692626953125, 0.0074462890625, 0.0093994140625, 0.00885009765625, 0.00360107421875, -0.002716064453125, -0.007476806640625, -0.012451171875, -0.015869140625, -0.013946533203125, -0.01092529296875, -0.01153564453125, -0.013214111328125, -0.0067138671875])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.000701904296875, -0.000732421875, 0.00079345703125, -0.00128173828125, 0.000823974609375, -0.00079345703125, -6.103515625e-05, -0.000152587890625, -0.0001220703125, -0.00079345703125, 0.087249755859375, 0.3106689453125, -0.119537353515625, -0.4356689453125, -0.0830078125, -0.12677001953125, 0.132080078125, 0.45074462890625, 0.275970458984375, 0.15545654296875, 0.4210205078125, 0.516021728515625, -0.140472412109375, -0.2891845703125, -0.236572265625, -0.443328857421875, -0.116729736328125, 0.13330078125, -0.1204833984375, -0.197052001953125, -0.042999267578125, 0.029876708984375, 0.042938232421875, 0.00360107421875, 0.019927978515625, -0.047210693359375, -0.126983642578125, 0.055511474609375, 0.130157470703125, -0.021453857421875, -0.0400390625, 0.02447509765625, 0.025054931640625, -0.024078369140625, -0.035125732421875, -0.037689208984375, -0.04742431640625, -0.01239013671875, 0.00958251953125, -0.02294921875, -0.017303466796875, 0.0096435546875, 0.00665283203125, 0.009979248046875, 0.009490966796875, 0.010406494140625, 0.013671875, 0.000213623046875, -0.00140380859375, 0.005462646484375, -0.012786865234375, -0.020721435546875, -0.01092529296875, -0.011566162109375, -0.019683837890625, -0.013458251953125, -0.005401611328125, -0.00457763671875, 0.00286865234375, 0.009674072265625, 0.000640869140625, -0.00140380859375, 0.002838134765625, -0.00439453125, -0.01025390625, -0.009033203125, -0.0067138671875, -0.005157470703125, -0.00482177734375, -0.005615234375, -0.00164794921875, -0.001739501953125, -9.1552734375e-05, 0.002960205078125, 0.002593994140625, -0.000152587890625, 0.001312255859375, 0.00244140625, -0.0030517578125, -0.00823974609375, -0.004150390625, 0.000244140625, -0.01409912109375, -0.025054931640625, -0.02001953125, -0.01416015625, 0.0, 0.013580322265625, 0.0130615234375, 0.013763427734375, 0.011016845703125, 0.001983642578125, -0.00634765625, -0.0167236328125, -0.029083251953125, -0.03363037109375, -0.01239013671875, 0.010528564453125, 0.0089111328125, 0.003692626953125, -0.000213623046875, 0.000457763671875, 0.003387451171875, 0.0028076171875, 0.008331298828125, 0.01275634765625, 0.012115478515625, 0.0079345703125, 0.00091552734375, -0.00408935546875, -0.00982666015625, -0.0164794921875, -0.01690673828125, -0.014190673828125, -0.011383056640625, -0.012298583984375, -0.0093994140625, -0.0035400390625])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.0001220703125, 9.1552734375e-05, -0.000457763671875, -0.00054931640625, 0.000823974609375, -0.0020751953125, 0.00225830078125, -0.003448486328125, 0.00286865234375, 0.037078857421875, 0.300018310546875, 0.062103271484375, -0.46893310546875, -0.196197509765625, -0.10760498046875, 0.041412353515625, 0.44024658203125, 0.328369140625, 0.171417236328125, 0.3956298828125, 0.606353759765625, -0.012786865234375, -0.35028076171875, -0.28424072265625, -0.449554443359375, -0.13525390625, 0.14898681640625, -0.081634521484375, -0.2132568359375, -0.08575439453125, -0.0054931640625, 0.057373046875, 0.0091552734375, -0.029388427734375, -0.034820556640625, -0.094879150390625, 0.030364990234375, 0.127655029296875, 0.012481689453125, -0.031524658203125, 0.021820068359375, 0.0360107421875, -0.010284423828125, -0.03302001953125, -0.04876708984375, -0.060821533203125, -0.016876220703125, 0.008331298828125, -0.0299072265625, -0.02532958984375, 0.006866455078125, 0.001922607421875, 0.005889892578125, 0.0084228515625, 0.009185791015625, 0.01605224609375, 0.010406494140625, -0.001220703125, 0.005828857421875, -0.002166748046875, -0.01434326171875, -0.01226806640625, -0.010162353515625, -0.01739501953125, -0.01776123046875, -0.00811767578125, -0.008575439453125, -0.003448486328125, 0.005218505859375, -0.001220703125, -0.00262451171875, 0.003631591796875, -0.002044677734375, -0.008453369140625, -0.008941650390625, -0.005584716796875, -0.00238037109375, -0.002471923828125, -0.006622314453125, -0.0020751953125, -3.0517578125e-05, -0.0009765625, 0.000823974609375, 0.000946044921875, -0.00042724609375, -0.0001220703125, 0.001495361328125, -0.002044677734375, -0.007049560546875, -0.006866455078125, 0.00067138671875, -0.0050048828125, -0.02276611328125, -0.024444580078125, -0.0167236328125, -0.005706787109375, 0.011138916015625, 0.0137939453125, 0.01202392578125, 0.01422119140625, 0.00885009765625, -0.001007080078125, -0.01214599609375, -0.02520751953125, -0.036651611328125, -0.026031494140625, 0.004302978515625, 0.011688232421875, 0.003082275390625, -0.002227783203125, -0.0028076171875, 0.00286865234375, 0.003326416015625, 0.0079345703125, 0.01483154296875, 0.01544189453125, 0.01220703125, 0.004791259765625, -0.001312255859375, -0.00567626953125, -0.01446533203125, -0.0184326171875, -0.0172119140625, -0.0147705078125, -0.012725830078125, -0.010711669921875, -0.004730224609375, -0.00244140625])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.000518798828125, 0.000640869140625, -0.001861572265625, 0.002166748046875, -0.003265380859375, 0.00323486328125, -0.00469970703125, 0.005126953125, 0.003662109375, 0.228118896484375, 0.243743896484375, -0.387542724609375, -0.355194091796875, -0.098480224609375, -0.039947509765625, 0.370330810546875, 0.380279541015625, 0.1951904296875, 0.355804443359375, 0.679840087890625, 0.15765380859375, -0.390838623046875, -0.282562255859375, -0.453125, -0.209320068359375, 0.15814208984375, -0.03509521484375, -0.221099853515625, -0.12652587890625, -0.030548095703125, 0.031829833984375, 0.016326904296875, -0.0576171875, -0.029876708984375, -0.0421142578125, 0.011932373046875, 0.100799560546875, 0.036712646484375, -0.0074462890625, 0.0206298828125, 0.0391845703125, -0.005828857421875, -0.030914306640625, -0.041717529296875, -0.071685791015625, -0.03936767578125, 0.008056640625, -0.022247314453125, -0.037872314453125, 0.00244140625, 0.00238037109375, 0.00390625, 0.00469970703125, 0.00482177734375, 0.01800537109375, 0.018829345703125, 0.003662109375, 0.003326416015625, 0.004669189453125, -0.007659912109375, -0.010040283203125, -0.00982666015625, -0.0172119140625, -0.021484375, -0.0130615234375, -0.01123046875, -0.0074462890625, 0.00445556640625, -0.001556396484375, -0.006866455078125, 0.00299072265625, 0.0018310546875, -0.00384521484375, -0.006988525390625, -0.00750732421875, -0.00299072265625, -0.00042724609375, -0.006134033203125, -0.004638671875, 0.000244140625, -0.000335693359375, 0.0003662109375, 0.000213623046875, -0.000396728515625, 0.000213623046875, 0.00048828125, -0.0030517578125, -0.0057373046875, -0.007293701171875, -0.003143310546875, 0.0008544921875, -0.013336181640625, -0.025115966796875, -0.01898193359375, -0.011199951171875, 0.00433349609375, 0.014556884765625, 0.01153564453125, 0.012908935546875, 0.012481689453125, 0.00421142578125, -0.00653076171875, -0.01837158203125, -0.032135009765625, -0.035614013671875, -0.01007080078125, 0.0126953125, 0.005828857421875, -0.003021240234375, -0.00604248046875, -0.001617431640625, 0.00250244140625, 0.007110595703125, 0.016998291015625, 0.018768310546875, 0.01531982421875, 0.009674072265625, 0.00164794921875, -0.0015869140625, -0.009857177734375, -0.0186767578125, -0.018096923828125, -0.018096923828125, -0.015167236328125, -0.011138916015625, -0.005950927734375, -0.002960205078125, -0.001678466796875])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.000701904296875, -0.00189208984375, 0.00177001953125, -0.002227783203125, 0.00152587890625, -0.0020751953125, 0.002227783203125, -0.00408935546875, 0.12188720703125, 0.347503662109375, -0.173980712890625, -0.49853515625, -0.15264892578125, -0.07244873046875, 0.24822998046875, 0.40887451171875, 0.2230224609375, 0.3140869140625, 0.694793701171875, 0.360687255859375, -0.34716796875, -0.301666259765625, -0.42095947265625, -0.29217529296875, 0.129486083984375, 0.00616455078125, -0.218231201171875, -0.151275634765625, -0.049835205078125, -0.023193359375, 0.003082275390625, -0.038177490234375, -0.027130126953125, -0.02874755859375, 0.012054443359375, 0.0950927734375, 0.047271728515625, 0.00653076171875, 0.02410888671875, 0.043365478515625, -0.003692626953125, -0.04132080078125, -0.032257080078125, -0.0665283203125, -0.0592041015625, -0.009521484375, -0.012542724609375, -0.03900146484375, -0.00408935546875, 0.00152587890625, 0.001861572265625, 0.008544921875, 0.0035400390625, 0.012176513671875, 0.019744873046875, 0.01470947265625, 0.004974365234375, 0.00408935546875, -0.00579833984375, -0.00738525390625, -0.006256103515625, -0.01611328125, -0.027252197265625, -0.017913818359375, -0.0125732421875, -0.0125732421875, 0.001373291015625, 0.002227783203125, -0.00604248046875, 0.001861572265625, 0.003143310546875, -0.00238037109375, -0.003021240234375, -0.00531005859375, -0.00616455078125, -0.00323486328125, -0.00439453125, -0.00537109375, -0.003570556640625, -0.00323486328125, 0.0006103515625, 0.00225830078125, 0.000762939453125, -0.000701904296875, 0.00115966796875, -0.00250244140625, -0.005279541015625, -0.0059814453125, -0.00567626953125, 0.000579833984375, -0.00384521484375, -0.021148681640625, -0.02227783203125, -0.014739990234375, -0.004180908203125, 0.012481689453125, 0.012908935546875, 0.010406494140625, 0.012847900390625, 0.00732421875, -0.001983642578125, -0.012298583984375, -0.02557373046875, -0.03533935546875, -0.0233154296875, 0.0054931640625, 0.009490966796875, -0.00238037109375, -0.007965087890625, -0.0067138671875, -0.00067138671875, 0.003692626953125, 0.015350341796875, 0.02276611328125, 0.0189208984375, 0.0137939453125, 0.0059814453125, 0.000274658203125, -0.004486083984375, -0.015625, -0.0196533203125, -0.019195556640625, -0.01812744140625, -0.01275634765625, -0.007110595703125, -0.003662109375, -0.00250244140625, -0.00048828125])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.00018310546875, -0.000732421875, 0.00115966796875, -0.002532958984375, 0.002899169921875, -0.0042724609375, 0.004058837890625, 0.024505615234375, 0.314117431640625, 0.13958740234375, -0.51220703125, -0.320526123046875, -0.072662353515625, 0.109161376953125, 0.384979248046875, 0.265411376953125, 0.26019287109375, 0.614837646484375, 0.599945068359375, -0.16351318359375, -0.365570068359375, -0.356903076171875, -0.36358642578125, 0.050506591796875, 0.059600830078125, -0.195831298828125, -0.191070556640625, -0.0853271484375, -0.063385009765625, -0.012481689453125, -0.015411376953125, -0.029876708984375, -0.022064208984375, -0.0025634765625, 0.087188720703125, 0.083465576171875, 0.025726318359375, 0.013824462890625, 0.033599853515625, 0.019439697265625, -0.042755126953125, -0.043243408203125, -0.063690185546875, -0.065948486328125, -0.02581787109375, -0.016845703125, -0.0382080078125, -0.00872802734375, 0.007476806640625, -0.00201416015625, 0.009857177734375, 0.008056640625, 0.01251220703125, 0.017181396484375, 0.01910400390625, 0.0081787109375, 0.0047607421875, -0.001129150390625, -0.011199951171875, -0.0108642578125, -0.010101318359375, -0.022979736328125, -0.02569580078125, -0.017578125, -0.015533447265625, -0.001922607421875, 0.005157470703125, -0.0040283203125, 0.00054931640625, 0.006256103515625, 0.000885009765625, -0.001678466796875, -0.003570556640625, -0.00653076171875, -0.0048828125, -0.004150390625, -0.00811767578125, -0.005462646484375, -0.004058837890625, -0.002532958984375, -0.0009765625, 0.001922607421875, 0.002288818359375, 0.00262451171875, 0.000274658203125, -0.004547119140625, -0.003997802734375, -0.00396728515625, -0.001739501953125, 0.001708984375, -0.01275634765625, -0.025390625, -0.018310546875, -0.011016845703125, 0.00604248046875, 0.015045166015625, 0.00933837890625, 0.010467529296875, 0.01031494140625, 0.002899169921875, -0.007080078125, -0.019927978515625, -0.031585693359375, -0.029388427734375, -0.00518798828125, 0.0111083984375, -0.000335693359375, -0.010040283203125, -0.009552001953125, -0.003387451171875, 0.0013427734375, 0.00860595703125, 0.02239990234375, 0.023895263671875, 0.0181884765625, 0.0118408203125, 0.002655029296875, -0.00225830078125, -0.009918212890625, -0.017791748046875, -0.019439697265625, -0.019744873046875, -0.015533447265625, -0.00848388671875, -0.003692626953125, -0.003082275390625, -0.001190185546875, -3.0517578125e-05])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.001617431640625, 0.002105712890625, -0.00299072265625, 0.002349853515625, -0.003143310546875, 0.00347900390625, -0.005706787109375, 0.147705078125, 0.370269775390625, -0.247222900390625, -0.54656982421875, -0.134246826171875, 0.01312255859375, 0.288543701171875, 0.314239501953125, 0.2196044921875, 0.45782470703125, 0.740570068359375, 0.189300537109375, -0.387420654296875, -0.329193115234375, -0.384124755859375, -0.073944091796875, 0.109710693359375, -0.128143310546875, -0.24176025390625, -0.149261474609375, -0.087005615234375, -0.040374755859375, 0.01434326171875, -0.033111572265625, -0.035186767578125, -0.017425537109375, 0.066925048828125, 0.118011474609375, 0.05218505859375, 0.014312744140625, 0.027740478515625, 0.0384521484375, -0.028717041015625, -0.05584716796875, -0.063812255859375, -0.08050537109375, -0.046661376953125, -0.015167236328125, -0.035675048828125, -0.02752685546875, 0.014892578125, 0.002960205078125, 0.006195068359375, 0.0150146484375, 0.018096923828125, 0.016265869140625, 0.01751708984375, 0.015380859375, 0.005889892578125, 0.000335693359375, -0.01080322265625, -0.016326904296875, -0.01544189453125, -0.01739501953125, -0.025970458984375, -0.02081298828125, -0.017913818359375, -0.009490966796875, 0.005615234375, 0.00042724609375, -0.00146484375, 0.00665283203125, 0.004638671875, 9.1552734375e-05, -0.000823974609375, -0.004730224609375, -0.006439208984375, -0.004364013671875, -0.008636474609375, -0.00921630859375, -0.00653076171875, -0.003692626953125, -0.00311279296875, -0.002777099609375, 0.00115966796875, 0.0042724609375, 0.00579833984375, 0.00042724609375, -0.003448486328125, -0.003021240234375, -0.001922607421875, 0.002655029296875, -0.001953125, -0.022705078125, -0.024200439453125, -0.015960693359375, -0.005035400390625, 0.012939453125, 0.0118408203125, 0.0074462890625, 0.009124755859375, 0.00689697265625, 0.00030517578125, -0.01239013671875, -0.026947021484375, -0.031097412109375, -0.016387939453125, 0.006805419921875, 0.005584716796875, -0.01123046875, -0.014312744140625, -0.00775146484375, 0.000152587890625, 0.003936767578125, 0.016265869140625, 0.025909423828125, 0.022125244140625, 0.01678466796875, 0.008209228515625, 0.00048828125, -0.0064697265625, -0.01507568359375, -0.01861572265625, -0.019012451171875, -0.017333984375, -0.01171875, -0.004608154296875, -0.0028076171875, -0.002105712890625, 9.1552734375e-05, 0.000213623046875])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.0013427734375, 0.002227783203125, -0.003814697265625, 0.004486083984375, -0.00628662109375, 0.006988525390625, 0.010406494140625, 0.3133544921875, 0.207275390625, -0.561981201171875, -0.378631591796875, -0.015411376953125, 0.13238525390625, 0.339019775390625, 0.2216796875, 0.29095458984375, 0.692108154296875, 0.583892822265625, -0.22509765625, -0.382843017578125, -0.340576171875, -0.204498291015625, 0.11346435546875, -0.02642822265625, -0.245391845703125, -0.240478515625, -0.11029052734375, -0.079071044921875, 0.004180908203125, 0.000885009765625, -0.05072021484375, -0.0294189453125, 0.028289794921875, 0.111419677734375, 0.0921630859375, 0.041961669921875, 0.01141357421875, 0.04913330078125, 0.017578125, -0.060394287109375, -0.076019287109375, -0.087432861328125, -0.0687255859375, -0.029815673828125, -0.02056884765625, -0.0411376953125, -0.004241943359375, 0.01324462890625, 0.0087890625, 0.017791748046875, 0.02081298828125, 0.023193359375, 0.018341064453125, 0.01788330078125, 0.00726318359375, 0.005950927734375, -0.00592041015625, -0.020233154296875, -0.020294189453125, -0.0177001953125, -0.024322509765625, -0.027069091796875, -0.0172119140625, -0.013885498046875, 0.000274658203125, 0.00384521484375, -0.003509521484375, 0.003173828125, 0.008087158203125, 0.0045166015625, 0.00054931640625, -0.000335693359375, -0.003997802734375, -0.003814697265625, -0.006591796875, -0.01220703125, -0.00994873046875, -0.007568359375, -0.00506591796875, -0.00518798828125, -0.00213623046875, 0.002532958984375, 0.006439208984375, 0.006500244140625, 0.001556396484375, -0.00067138671875, -0.001220703125, 0.000335693359375, 0.00531005859375, -0.008544921875, -0.026611328125, -0.021514892578125, -0.01519775390625, 0.00201416015625, 0.013671875, 0.007476806640625, 0.0072021484375, 0.006561279296875, 0.0047607421875, -0.002227783203125, -0.01812744140625, -0.028961181640625, -0.02325439453125, -0.00390625, 0.009552001953125, -0.00390625, -0.019195556640625, -0.015838623046875, -0.0040283203125, 0.0020751953125, 0.008758544921875, 0.023101806640625, 0.025299072265625, 0.020782470703125, 0.0145263671875, 0.0062255859375, -0.002288818359375, -0.012237548828125, -0.01763916015625, -0.01806640625, -0.017425537109375, -0.013397216796875, -0.007598876953125, -0.002960205078125, -0.00244140625, -0.000396728515625, 0.001373291015625, 0.0010986328125])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.000244140625, -0.000244140625, -0.001007080078125, 0.001495361328125, -0.002685546875, 0.0009765625, 0.072540283203125, 0.416046142578125, -0.07940673828125, -0.674774169921875, -0.167144775390625, 0.05169677734375, 0.218353271484375, 0.30108642578125, 0.174713134765625, 0.47247314453125, 0.792877197265625, 0.225555419921875, -0.409393310546875, -0.341583251953125, -0.26458740234375, 0.0147705078125, 0.091217041015625, -0.157958984375, -0.306243896484375, -0.201690673828125, -0.07904052734375, -0.06207275390625, 0.009521484375, -0.024139404296875, -0.03717041015625, -0.010223388671875, 0.070556640625, 0.107208251953125, 0.072479248046875, 0.029296875, 0.030670166015625, 0.062255859375, -0.0233154296875, -0.073699951171875, -0.091339111328125, -0.095611572265625, -0.05694580078125, -0.017486572265625, -0.03704833984375, -0.036376953125, 0.0103759765625, 0.013519287109375, 0.013153076171875, 0.0216064453125, 0.03271484375, 0.02777099609375, 0.022705078125, 0.012176513671875, 0.000732421875, 0.003662109375, -0.010589599609375, -0.024627685546875, -0.024871826171875, -0.024444580078125, -0.03033447265625, -0.02337646484375, -0.016143798828125, -0.00823974609375, 0.005462646484375, -0.000640869140625, -0.003143310546875, 0.005889892578125, 0.009307861328125, 0.00439453125, 0.001800537109375, 0.000701904296875, -0.001007080078125, -0.003662109375, -0.011749267578125, -0.01422119140625, -0.011505126953125, -0.008636474609375, -0.00762939453125, -0.00579833984375, -0.000732421875, 0.00494384765625, 0.008575439453125, 0.006072998046875, 0.002227783203125, 0.00115966796875, 0.0001220703125, 0.002960205078125, 0.0057373046875, -0.01483154296875, -0.02667236328125, -0.01995849609375, -0.0133056640625, 0.00604248046875, 0.008941650390625, 0.004852294921875, 0.00653076171875, 0.004730224609375, 0.004913330078125, -0.00628662109375, -0.023529052734375, -0.02581787109375, -0.01226806640625, 0.004791259765625, 0.005706787109375, -0.014892578125, -0.023529052734375, -0.013153076171875, -0.001953125, 0.0020751953125, 0.014373779296875, 0.025421142578125, 0.023895263671875, 0.019927978515625, 0.011962890625, 0.00494384765625, -0.00567626953125, -0.016357421875, -0.01806640625, -0.01702880859375, -0.014892578125, -0.009613037109375, -0.004547119140625, -0.002593994140625, -0.0018310546875, 0.00115966796875, 0.00177001953125, 0.001373291015625])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.0018310546875, -0.003021240234375, 0.002777099609375, -0.00311279296875, 0.0032958984375, -0.0062255859375, 0.1571044921875, 0.4271240234375, -0.348236083984375, -0.63946533203125, -0.0035400390625, 0.087860107421875, 0.24908447265625, 0.234771728515625, 0.224609375, 0.6512451171875, 0.69451904296875, -0.0712890625, -0.45281982421875, -0.28607177734375, -0.11065673828125, 0.112823486328125, 0.003875732421875, -0.24224853515625, -0.319000244140625, -0.148284912109375, -0.079925537109375, -0.0645751953125, 0.016693115234375, -0.031463623046875, -0.03265380859375, 0.0247802734375, 0.08709716796875, 0.088104248046875, 0.06610107421875, 0.014495849609375, 0.049468994140625, 0.057769775390625, -0.0430908203125, -0.08447265625, -0.094970703125, -0.084320068359375, -0.05487060546875, -0.026031494140625, -0.04150390625, -0.0234375, 0.011627197265625, 0.012481689453125, 0.01190185546875, 0.029754638671875, 0.042388916015625, 0.0313720703125, 0.02581787109375, 0.007080078125, -0.0023193359375, 0.001800537109375, -0.014801025390625, -0.027618408203125, -0.02691650390625, -0.03057861328125, -0.0347900390625, -0.02166748046875, -0.013641357421875, -0.0035400390625, 0.003814697265625, -0.003631591796875, -0.00030517578125, 0.009674072265625, 0.01080322265625, 0.004302978515625, 0.004058837890625, 0.0020751953125, -0.000244140625, -0.005157470703125, -0.014312744140625, -0.01617431640625, -0.01202392578125, -0.00927734375, -0.00982666015625, -0.005615234375, 0.001068115234375, 0.00701904296875, 0.009613037109375, 0.00604248046875, 0.00311279296875, 0.00299072265625, 0.001129150390625, 0.005584716796875, 0.004608154296875, -0.018402099609375, -0.025146484375, -0.019500732421875, -0.01104736328125, 0.006072998046875, 0.003936767578125, 0.004150390625, 0.00537109375, 0.004852294921875, 0.005523681640625, -0.0108642578125, -0.025634765625, -0.02020263671875, -0.00341796875, 0.01043701171875, 0.000732421875, -0.02337646484375, -0.02520751953125, -0.010650634765625, -0.001678466796875, 0.003173828125, 0.018218994140625, 0.025054931640625, 0.02276611328125, 0.018463134765625, 0.011016845703125, 0.0045166015625, -0.008575439453125, -0.01776123046875, -0.016693115234375, -0.015960693359375, -0.012054443359375, -0.005950927734375, -0.00274658203125, -0.002655029296875, -0.00048828125, 0.001007080078125, 0.00079345703125, 0.00164794921875])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.002777099609375, -0.00494384765625, 0.00543212890625, -0.006744384765625, 0.0079345703125, -0.009979248046875, 0.223876953125, 0.3917236328125, -0.51953125, -0.5631103515625, 0.09503173828125, 0.103851318359375, 0.22412109375, 0.203765869140625, 0.322601318359375, 0.724273681640625, 0.55133056640625, -0.240142822265625, -0.45220947265625, -0.200775146484375, 0.019683837890625, 0.124267578125, -0.07342529296875, -0.2850341796875, -0.29736328125, -0.1180419921875, -0.102020263671875, -0.0643310546875, 0.017425537109375, -0.031005859375, -0.02569580078125, 0.044891357421875, 0.0943603515625, 0.078857421875, 0.05108642578125, 0.006439208984375, 0.06402587890625, 0.043731689453125, -0.0511474609375, -0.081512451171875, -0.09002685546875, -0.076904296875, -0.052093505859375, -0.039031982421875, -0.044281005859375, -0.01336669921875, 0.009979248046875, 0.007293701171875, 0.012908935546875, 0.037109375, 0.044036865234375, 0.03350830078125, 0.02947998046875, 0.00830078125, -0.003692626953125, -0.00189208984375, -0.0181884765625, -0.029205322265625, -0.027587890625, -0.03472900390625, -0.038177490234375, -0.023162841796875, -0.011688232421875, -0.000823974609375, 0.00079345703125, -0.00439453125, 0.002166748046875, 0.013824462890625, 0.01275634765625, 0.00592041015625, 0.00531005859375, 0.001617431640625, -0.00189208984375, -0.00732421875, -0.013702392578125, -0.016815185546875, -0.012847900390625, -0.010345458984375, -0.010955810546875, -0.00518798828125, 0.002685546875, 0.00762939453125, 0.008148193359375, 0.006256103515625, 0.00592041015625, 0.004638671875, 0.002044677734375, 0.007537841796875, 0.002532958984375, -0.020965576171875, -0.023712158203125, -0.019805908203125, -0.009063720703125, 0.00433349609375, -0.000213623046875, 0.004638671875, 0.0048828125, 0.006622314453125, 0.00433349609375, -0.0159912109375, -0.025390625, -0.013885498046875, 0.00311279296875, 0.01141357421875, -0.0050048828125, -0.02740478515625, -0.023590087890625, -0.009857177734375, -0.00335693359375, 0.00543212890625, 0.020477294921875, 0.024383544921875, 0.02099609375, 0.016265869140625, 0.01104736328125, 0.003936767578125, -0.010162353515625, -0.017425537109375, -0.015899658203125, -0.01458740234375, -0.009368896484375, -0.002960205078125, -0.00225830078125, -0.003326416015625, 0.000244140625, 0.00042724609375, 3.0517578125e-05, 0.001129150390625])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.003387451171875, -0.00604248046875, 0.007232666015625, -0.009063720703125, 0.011077880859375, -0.012298583984375, 0.2591552734375, 0.362762451171875, -0.604888916015625, -0.50958251953125, 0.15472412109375, 0.1103515625, 0.180206298828125, 0.204010009765625, 0.401519775390625, 0.72564697265625, 0.440521240234375, -0.33447265625, -0.4298095703125, -0.1060791015625, 0.104095458984375, 0.11395263671875, -0.13470458984375, -0.306182861328125, -0.267303466796875, -0.110595703125, -0.120574951171875, -0.05810546875, 0.010345458984375, -0.040679931640625, -0.017303466796875, 0.06005859375, 0.09375, 0.078704833984375, 0.04193115234375, -0.00067138671875, 0.071685791015625, 0.0394287109375, -0.06036376953125, -0.0836181640625, -0.071502685546875, -0.065155029296875, -0.05377197265625, -0.04412841796875, -0.048095703125, -0.015533447265625, 0.00823974609375, 0.004791259765625, 0.01104736328125, 0.037750244140625, 0.04327392578125, 0.033935546875, 0.03167724609375, 0.011871337890625, 0.000335693359375, -0.004364013671875, -0.020843505859375, -0.028411865234375, -0.02789306640625, -0.037139892578125, -0.040313720703125, -0.024383544921875, -0.011566162109375, 0.00018310546875, -0.0003662109375, -0.00592041015625, 0.00311279296875, 0.01605224609375, 0.014495849609375, 0.0078125, 0.005340576171875, -9.1552734375e-05, -0.0040283203125, -0.00775146484375, -0.012908935546875, -0.0157470703125, -0.01275634765625, -0.010345458984375, -0.01043701171875, -0.00543212890625, 0.002105712890625, 0.007080078125, 0.008331298828125, 0.006591796875, 0.00653076171875, 0.00543212890625, 0.00311279296875, 0.008941650390625, 0.0018310546875, -0.02252197265625, -0.024383544921875, -0.020660400390625, -0.00836181640625, 0.00225830078125, -0.0028076171875, 0.003753662109375, 0.0047607421875, 0.008636474609375, 0.00421142578125, -0.017425537109375, -0.023406982421875, -0.009307861328125, 0.005859375, 0.01019287109375, -0.009368896484375, -0.0291748046875, -0.021697998046875, -0.010345458984375, -0.005157470703125, 0.00518798828125, 0.01959228515625, 0.023651123046875, 0.019683837890625, 0.015625, 0.011199951171875, 0.003692626953125, -0.0089111328125, -0.015655517578125, -0.01593017578125, -0.012969970703125, -0.00701904296875, -0.002349853515625, -0.00311279296875, -0.00457763671875, -0.0008544921875, -0.001190185546875, -0.00091552734375, 0.00079345703125])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.003631591796875, -0.006561279296875, 0.00775146484375, -0.009552001953125, 0.011749267578125, -0.01458740234375, 0.249114990234375, 0.375335693359375, -0.60406494140625, -0.518524169921875, 0.181396484375, 0.11273193359375, 0.13616943359375, 0.207489013671875, 0.437042236328125, 0.702423095703125, 0.38592529296875, -0.364593505859375, -0.3994140625, -0.03662109375, 0.146331787109375, 0.11370849609375, -0.172698974609375, -0.3148193359375, -0.245361328125, -0.117431640625, -0.131072998046875, -0.057647705078125, 0.003143310546875, -0.052276611328125, -0.02337646484375, 0.06689453125, 0.102935791015625, 0.073974609375, 0.043731689453125, 0.00335693359375, 0.067474365234375, 0.041778564453125, -0.06304931640625, -0.087860107421875, -0.06512451171875, -0.050323486328125, -0.044219970703125, -0.04937744140625, -0.052520751953125, -0.016754150390625, -0.00030517578125, -0.001556396484375, 0.01324462890625, 0.035552978515625, 0.0391845703125, 0.032257080078125, 0.03216552734375, 0.015625, 0.00408935546875, -0.000946044921875, -0.020233154296875, -0.02923583984375, -0.026824951171875, -0.035980224609375, -0.0426025390625, -0.026031494140625, -0.010894775390625, -0.0001220703125, -0.00164794921875, -0.008026123046875, 0.003021240234375, 0.0167236328125, 0.015411376953125, 0.009368896484375, 0.005157470703125, -0.001007080078125, -0.004974365234375, -0.008331298828125, -0.012298583984375, -0.014068603515625, -0.011016845703125, -0.00982666015625, -0.01080322265625, -0.005584716796875, 0.002349853515625, 0.0069580078125, 0.0074462890625, 0.00628662109375, 0.006256103515625, 0.0057373046875, 0.00390625, 0.008544921875, 0.0015869140625, -0.02227783203125, -0.0234375, -0.020599365234375, -0.009368896484375, -3.0517578125e-05, -0.005096435546875, 0.0032958984375, 0.005584716796875, 0.01080322265625, 0.004302978515625, -0.017242431640625, -0.020538330078125, -0.006439208984375, 0.006317138671875, 0.007568359375, -0.011993408203125, -0.02923583984375, -0.01995849609375, -0.010467529296875, -0.005859375, 0.003814697265625, 0.01727294921875, 0.022979736328125, 0.019378662109375, 0.01654052734375, 0.011474609375, 0.00341796875, -0.0059814453125, -0.013397216796875, -0.015960693359375, -0.0120849609375, -0.00555419921875, -0.0020751953125, -0.00390625, -0.005889892578125, -0.00299072265625, -0.0030517578125, -0.0013427734375, 0.0013427734375])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.003204345703125, -0.005615234375, 0.006103515625, -0.00701904296875, 0.008270263671875, -0.012908935546875, 0.188201904296875, 0.426483154296875, -0.501007080078125, -0.5999755859375, 0.1673583984375, 0.122222900390625, 0.09942626953125, 0.194091796875, 0.4227294921875, 0.67962646484375, 0.39447021484375, -0.3336181640625, -0.38665771484375, 0.002777099609375, 0.162261962890625, 0.1260986328125, -0.172119140625, -0.322113037109375, -0.24603271484375, -0.126861572265625, -0.132904052734375, -0.07373046875, 0.001434326171875, -0.06072998046875, -0.039764404296875, 0.061492919921875, 0.1103515625, 0.07977294921875, 0.05218505859375, 0.00726318359375, 0.064178466796875, 0.053192138671875, -0.06207275390625, -0.09173583984375, -0.063018798828125, -0.048309326171875, -0.037200927734375, -0.03900146484375, -0.055633544921875, -0.02703857421875, -0.005828857421875, -0.00762939453125, 0.0076904296875, 0.0345458984375, 0.037872314453125, 0.026702880859375, 0.0296630859375, 0.02056884765625, 0.007415771484375, 0.002593994140625, -0.01513671875, -0.0269775390625, -0.025634765625, -0.03314208984375, -0.041900634765625, -0.028350830078125, -0.01373291015625, -0.002288818359375, -0.001953125, -0.00958251953125, 0.0013427734375, 0.01593017578125, 0.015533447265625, 0.00909423828125, 0.00579833984375, -0.000732421875, -0.00518798828125, -0.00836181640625, -0.011444091796875, -0.012237548828125, -0.0107421875, -0.009124755859375, -0.00946044921875, -0.00445556640625, 0.0030517578125, 0.006072998046875, 0.005462646484375, 0.00408935546875, 0.005401611328125, 0.005126953125, 0.002197265625, 0.007476806640625, 0.00390625, -0.019012451171875, -0.022247314453125, -0.020050048828125, -0.011962890625, -0.00262451171875, -0.006256103515625, 0.0029296875, 0.006622314453125, 0.011810302734375, 0.005096435546875, -0.0166015625, -0.01885986328125, -0.0057373046875, 0.004974365234375, 0.005645751953125, -0.012237548828125, -0.028656005859375, -0.019805908203125, -0.010589599609375, -0.005950927734375, 0.002716064453125, 0.014678955078125, 0.02130126953125, 0.0191650390625, 0.018035888671875, 0.012542724609375, 0.003173828125, -0.0032958984375, -0.01116943359375, -0.01580810546875, -0.01177978515625, -0.00567626953125, -0.0025634765625, -0.0048828125, -0.0074462890625, -0.0050048828125, -0.004241943359375, -0.002227783203125, 0.001556396484375])
        IR_RIGHT[len(IR_RIGHT)-1].append([0.001495361328125, -0.0023193359375, 0.001251220703125, -0.0006103515625, -0.0003662109375, -0.00201416015625, 0.095672607421875, 0.45623779296875, -0.278045654296875, -0.710235595703125, 0.082977294921875, 0.15460205078125, 0.061676025390625, 0.17022705078125, 0.3624267578125, 0.652618408203125, 0.454681396484375, -0.253173828125, -0.389923095703125, 0.0147705078125, 0.171112060546875, 0.138824462890625, -0.13372802734375, -0.32330322265625, -0.2667236328125, -0.140899658203125, -0.1251220703125, -0.10870361328125, -0.004791259765625, -0.0487060546875, -0.06378173828125, 0.0391845703125, 0.11810302734375, 0.088470458984375, 0.062744140625, 0.01953125, 0.055084228515625, 0.07171630859375, -0.046173095703125, -0.094635009765625, -0.06805419921875, -0.048675537109375, -0.039825439453125, -0.034759521484375, -0.048553466796875, -0.032958984375, -0.016082763671875, -0.01251220703125, 0.00286865234375, 0.026519775390625, 0.0372314453125, 0.02618408203125, 0.024871826171875, 0.0225830078125, 0.010162353515625, 0.00689697265625, -0.007598876953125, -0.022674560546875, -0.02166748046875, -0.028289794921875, -0.04034423828125, -0.031890869140625, -0.017669677734375, -0.006683349609375, -0.00225830078125, -0.00921630859375, -0.001007080078125, 0.01409912109375, 0.01483154296875, 0.008148193359375, 0.005462646484375, 0.00091552734375, -0.00341796875, -0.007598876953125, -0.0113525390625, -0.01165771484375, -0.00860595703125, -0.00640869140625, -0.008026123046875, -0.00433349609375, 0.0029296875, 0.00579833984375, 0.00341796875, 0.001190185546875, 0.001312255859375, 0.00299072265625, 0.00189208984375, 0.00750732421875, 0.008087158203125, -0.01507568359375, -0.021759033203125, -0.019073486328125, -0.01287841796875, -0.003509521484375, -0.00787353515625, 0.001495361328125, 0.0079345703125, 0.012481689453125, 0.005462646484375, -0.016571044921875, -0.018524169921875, -0.005859375, 0.003631591796875, 0.00439453125, -0.010528564453125, -0.027313232421875, -0.020111083984375, -0.009735107421875, -0.005767822265625, 0.001373291015625, 0.012725830078125, 0.01983642578125, 0.01849365234375, 0.018829345703125, 0.013946533203125, 0.003509521484375, -0.001739501953125, -0.0087890625, -0.014862060546875, -0.01177978515625, -0.007080078125, -0.004119873046875, -0.00592041015625, -0.0079345703125, -0.006256103515625, -0.00457763671875, -0.002960205078125, 0.00103759765625])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.001556396484375, 0.00250244140625, -0.005279541015625, 0.00689697265625, -0.00994873046875, 0.011962890625, 0.010589599609375, 0.388427734375, 0.058074951171875, -0.742889404296875, -0.134124755859375, 0.211822509765625, 0.026336669921875, 0.138427734375, 0.278167724609375, 0.577392578125, 0.55816650390625, -0.101959228515625, -0.399444580078125, -0.01861572265625, 0.1851806640625, 0.1497802734375, -0.07086181640625, -0.299652099609375, -0.295623779296875, -0.178192138671875, -0.112884521484375, -0.13848876953125, -0.0418701171875, -0.021514892578125, -0.07440185546875, 3.0517578125e-05, 0.1129150390625, 0.104644775390625, 0.07110595703125, 0.039031982421875, 0.046051025390625, 0.09027099609375, -0.0155029296875, -0.08984375, -0.07122802734375, -0.056121826171875, -0.048126220703125, -0.03790283203125, -0.048095703125, -0.037017822265625, -0.01739501953125, -0.020172119140625, -0.006988525390625, 0.020050048828125, 0.03533935546875, 0.02581787109375, 0.022735595703125, 0.02545166015625, 0.0115966796875, 0.00909423828125, 0.00433349609375, -0.016754150390625, -0.02044677734375, -0.0220947265625, -0.03594970703125, -0.036773681640625, -0.023193359375, -0.01190185546875, -0.004150390625, -0.007568359375, -0.003753662109375, 0.010467529296875, 0.01348876953125, 0.0074462890625, 0.005340576171875, 0.001983642578125, -0.00286865234375, -0.005767822265625, -0.008148193359375, -0.00946044921875, -0.008514404296875, -0.00396728515625, -0.00579833984375, -0.0054931640625, 0.000274658203125, 0.00396728515625, 0.001312255859375, -0.001922607421875, -0.00177001953125, 0.000732421875, 0.00189208984375, 0.006103515625, 0.01141357421875, -0.008026123046875, -0.020477294921875, -0.018341064453125, -0.01434326171875, -0.00390625, -0.0072021484375, -0.0008544921875, 0.0078125, 0.01141357421875, 0.005401611328125, -0.016082763671875, -0.01873779296875, -0.0068359375, 0.0009765625, 0.003082275390625, -0.00732421875, -0.02362060546875, -0.0205078125, -0.009307861328125, -0.005340576171875, -0.000457763671875, 0.010833740234375, 0.018585205078125, 0.0169677734375, 0.018402099609375, 0.015350341796875, 0.004241943359375, -0.00067138671875, -0.006195068359375, -0.013824462890625, -0.012420654296875, -0.0091552734375, -0.006134033203125, -0.006561279296875, -0.008270263671875, -0.006744384765625, -0.0048828125, -0.0032958984375, 0.000274658203125])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.002777099609375, 0.003997802734375, -0.006195068359375, 0.0064697265625, -0.008148193359375, 0.00994873046875, -0.014312744140625, 0.205474853515625, 0.34765625, -0.51837158203125, -0.46356201171875, 0.20452880859375, 0.044921875, 0.069427490234375, 0.224639892578125, 0.428924560546875, 0.622833251953125, 0.142181396484375, -0.3660888671875, -0.10626220703125, 0.193603515625, 0.169403076171875, -0.00848388671875, -0.239959716796875, -0.3062744140625, -0.23541259765625, -0.127593994140625, -0.13458251953125, -0.103485107421875, -0.016326904296875, -0.05889892578125, -0.04046630859375, 0.085662841796875, 0.120574951171875, 0.079071044921875, 0.062164306640625, 0.042144775390625, 0.0980224609375, 0.03839111328125, -0.0809326171875, -0.074188232421875, -0.053497314453125, -0.059906005859375, -0.052215576171875, -0.050201416015625, -0.047393798828125, -0.02374267578125, -0.019287109375, -0.0157470703125, 0.00506591796875, 0.033477783203125, 0.031829833984375, 0.019073486328125, 0.0264892578125, 0.0211181640625, 0.0098876953125, 0.011077880859375, -0.005615234375, -0.0185546875, -0.019256591796875, -0.030731201171875, -0.037872314453125, -0.02923583984375, -0.018585205078125, -0.008148193359375, -0.00640869140625, -0.0069580078125, 0.005706787109375, 0.01275634765625, 0.008056640625, 0.003265380859375, 0.002838134765625, -0.000396728515625, -0.002593994140625, -0.00408935546875, -0.005767822265625, -0.00811767578125, -0.005126953125, -0.003875732421875, -0.007080078125, -0.0048828125, 0.000152587890625, 0.000946044921875, -0.00250244140625, -0.0037841796875, -0.001678466796875, 0.00115966796875, 0.004364013671875, 0.012908935546875, -0.00048828125, -0.017913818359375, -0.0172119140625, -0.014923095703125, -0.005126953125, -0.00579833984375, -0.003204345703125, 0.006134033203125, 0.010162353515625, 0.005584716796875, -0.0147705078125, -0.020263671875, -0.00823974609375, -0.001678466796875, 0.0006103515625, -0.003814697265625, -0.01873779296875, -0.02001953125, -0.00897216796875, -0.0047607421875, -0.00225830078125, 0.00799560546875, 0.01690673828125, 0.01513671875, 0.01654052734375, 0.016265869140625, 0.0059814453125, -0.0001220703125, -0.004058837890625, -0.0126953125, -0.013427734375, -0.01104736328125, -0.008209228515625, -0.006927490234375, -0.009307861328125, -0.007568359375, -0.004730224609375, -0.0025634765625, -0.000518798828125])
        IR_RIGHT[len(IR_RIGHT)-1].append([-0.00030517578125, -0.0003662109375, 0.00067138671875, -0.00262451171875, 0.003814697265625, -0.005950927734375, 0.00616455078125, 0.032867431640625, 0.374908447265625, -0.04522705078125, -0.657257080078125, -0.0277099609375, 0.15380859375, -0.0296630859375, 0.1812744140625, 0.30743408203125, 0.529815673828125, 0.41070556640625, -0.2015380859375, -0.219818115234375, 0.158050537109375, 0.209686279296875, 0.045135498046875, -0.16876220703125, -0.277191162109375, -0.27142333984375, -0.190521240234375, -0.127960205078125, -0.13702392578125, -0.05511474609375, -0.031463623046875, -0.068115234375, 0.03192138671875, 0.13134765625, 0.09454345703125, 0.07537841796875, 0.056396484375, 0.080474853515625, 0.097198486328125, -0.03118896484375, -0.087738037109375, -0.056488037109375, -0.05535888671875, -0.0654296875, -0.0616455078125, -0.061279296875, -0.038330078125, -0.023681640625, -0.018341064453125, -0.005767822265625, 0.019317626953125, 0.039276123046875, 0.0267333984375, 0.0232238769