# coding: utf-8

"""
    CLOUD API

    IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class NatGatewayProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'lans': 'list[NatGatewayLanProperties]',

        'name': 'str',

        'public_ips': 'list[str]',
    }

    attribute_map = {

        'lans': 'lans',

        'name': 'name',

        'public_ips': 'publicIps',
    }

    def __init__(self, lans=None, name=None, public_ips=None, local_vars_configuration=None):  # noqa: E501
        """NatGatewayProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._lans = None
        self._name = None
        self._public_ips = None
        self.discriminator = None

        if lans is not None:
            self.lans = lans
        self.name = name
        self.public_ips = public_ips


    @property
    def lans(self):
        """Gets the lans of this NatGatewayProperties.  # noqa: E501

        Collection of LANs connected to the NAT Gateway. IPs must contain a valid subnet mask. If no IP is provided, the system will generate an IP with /24 subnet.  # noqa: E501

        :return: The lans of this NatGatewayProperties.  # noqa: E501
        :rtype: list[NatGatewayLanProperties]
        """
        return self._lans

    @lans.setter
    def lans(self, lans):
        """Sets the lans of this NatGatewayProperties.

        Collection of LANs connected to the NAT Gateway. IPs must contain a valid subnet mask. If no IP is provided, the system will generate an IP with /24 subnet.  # noqa: E501

        :param lans: The lans of this NatGatewayProperties.  # noqa: E501
        :type lans: list[NatGatewayLanProperties]
        """

        self._lans = lans

    @property
    def name(self):
        """Gets the name of this NatGatewayProperties.  # noqa: E501

        Name of the NAT Gateway.  # noqa: E501

        :return: The name of this NatGatewayProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NatGatewayProperties.

        Name of the NAT Gateway.  # noqa: E501

        :param name: The name of this NatGatewayProperties.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def public_ips(self):
        """Gets the public_ips of this NatGatewayProperties.  # noqa: E501

        Collection of public IP addresses of the NAT Gateway. Should be customer reserved IP addresses in that location.  # noqa: E501

        :return: The public_ips of this NatGatewayProperties.  # noqa: E501
        :rtype: list[str]
        """
        return self._public_ips

    @public_ips.setter
    def public_ips(self, public_ips):
        """Sets the public_ips of this NatGatewayProperties.

        Collection of public IP addresses of the NAT Gateway. Should be customer reserved IP addresses in that location.  # noqa: E501

        :param public_ips: The public_ips of this NatGatewayProperties.  # noqa: E501
        :type public_ips: list[str]
        """
        if self.local_vars_configuration.client_side_validation and public_ips is None:  # noqa: E501
            raise ValueError("Invalid value for `public_ips`, must not be `None`")  # noqa: E501

        self._public_ips = public_ips
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NatGatewayProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NatGatewayProperties):
            return True

        return self.to_dict() != other.to_dict()
