# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementAuthorizationServerOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_authorization_server_list_by_service(self, resource_group):
        response = self.client.authorization_server.list_by_service(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_authorization_server_get_entity_tag(self, resource_group):
        response = self.client.authorization_server.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            authsid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_authorization_server_get(self, resource_group):
        response = self.client.authorization_server.get(
            resource_group_name=resource_group.name,
            service_name="str",
            authsid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_authorization_server_create_or_update(self, resource_group):
        response = self.client.authorization_server.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            authsid="str",
            parameters={
                "authorizationEndpoint": "str",
                "authorizationMethods": ["str"],
                "bearerTokenSendingMethods": ["str"],
                "clientAuthenticationMethod": ["str"],
                "clientId": "str",
                "clientRegistrationEndpoint": "str",
                "clientSecret": "str",
                "defaultScope": "str",
                "description": "str",
                "displayName": "str",
                "grantTypes": ["str"],
                "id": "str",
                "name": "str",
                "resourceOwnerPassword": "str",
                "resourceOwnerUsername": "str",
                "supportState": bool,
                "tokenBodyParameters": [{"name": "str", "value": "str"}],
                "tokenEndpoint": "str",
                "type": "str",
                "useInApiDocumentation": bool,
                "useInTestConsole": bool,
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_authorization_server_update(self, resource_group):
        response = self.client.authorization_server.update(
            resource_group_name=resource_group.name,
            service_name="str",
            authsid="str",
            if_match="str",
            parameters={
                "authorizationEndpoint": "str",
                "authorizationMethods": ["str"],
                "bearerTokenSendingMethods": ["str"],
                "clientAuthenticationMethod": ["str"],
                "clientId": "str",
                "clientRegistrationEndpoint": "str",
                "clientSecret": "str",
                "defaultScope": "str",
                "description": "str",
                "displayName": "str",
                "grantTypes": ["str"],
                "id": "str",
                "name": "str",
                "resourceOwnerPassword": "str",
                "resourceOwnerUsername": "str",
                "supportState": bool,
                "tokenBodyParameters": [{"name": "str", "value": "str"}],
                "tokenEndpoint": "str",
                "type": "str",
                "useInApiDocumentation": bool,
                "useInTestConsole": bool,
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_authorization_server_delete(self, resource_group):
        response = self.client.authorization_server.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            authsid="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_authorization_server_list_secrets(self, resource_group):
        response = self.client.authorization_server.list_secrets(
            resource_group_name=resource_group.name,
            service_name="str",
            authsid="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
