# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.iotfirmwaredefense.aio import IoTFirmwareDefenseMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestIoTFirmwareDefenseMgmtWorkspacesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(IoTFirmwareDefenseMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspaces_get(self, resource_group):
        response = await self.client.workspaces.get(
            resource_group_name=resource_group.name,
            workspace_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspaces_create(self, resource_group):
        response = await self.client.workspaces.create(
            resource_group_name=resource_group.name,
            workspace_name="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {"provisioningState": "str"},
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspaces_update(self, resource_group):
        response = await self.client.workspaces.update(
            resource_group_name=resource_group.name,
            workspace_name="str",
            properties={
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspaces_delete(self, resource_group):
        response = await self.client.workspaces.delete(
            resource_group_name=resource_group.name,
            workspace_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspaces_list_by_resource_group(self, resource_group):
        response = self.client.workspaces.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspaces_list_by_subscription(self, resource_group):
        response = self.client.workspaces.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspaces_generate_upload_url(self, resource_group):
        response = await self.client.workspaces.generate_upload_url(
            resource_group_name=resource_group.name,
            workspace_name="str",
            body={"firmwareId": "str"},
        )

        # please add some check logic here by yourself
        # ...
