# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.mobilenetwork import MobileNetworkManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-mobilenetwork
# USAGE
    python packet_core_control_plane_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = MobileNetworkManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.packet_core_control_planes.begin_create_or_update(
        resource_group_name="rg1",
        packet_core_control_plane_name="TestPacketCoreCP",
        parameters={
            "location": "eastus",
            "properties": {
                "controlPlaneAccessInterface": {"name": "N2"},
                "coreNetworkTechnology": "5GC",
                "localDiagnosticsAccess": {
                    "authenticationType": "AAD",
                    "httpsServerCertificate": {
                        "certificateUrl": "https://contosovault.vault.azure.net/certificates/ingress"
                    },
                },
                "platform": {
                    "azureStackEdgeDevice": {
                        "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"
                    },
                    "connectedCluster": {
                        "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster"
                    },
                    "customLocation": {
                        "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation"
                    },
                    "type": "AKS-HCI",
                },
                "sites": [
                    {
                        "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite"
                    }
                ],
                "sku": "G0",
                "ueMtu": 1600,
                "version": "0.2.0",
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2022-11-01/examples/PacketCoreControlPlaneCreate.json
if __name__ == "__main__":
    main()
