/*
 * htmltidy.h - Tidy html with libtidy
 *
 * Off-the-Record Messaging plugin for Psi+
 * Copyright (C) 2007-2011  Timo Engel (timo-e@freenet.de)
 *                    2011  Florian Fieber
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef HTMLTIDY_H_
#define HTMLTIDY_H_

#include <QString>
#include <QByteArray>

#include <string>
#ifndef Q_WS_WIN
#include <tidy.h>
#include <buffio.h>
#else
#include <tidy/tidy.h>
#include <tidy/buffio.h>
#endif

class QDomDocument;
class QDomElement;

class HtmlTidy
{
public:
    HtmlTidy(const QString& html);
    ~HtmlTidy();
    QString output();
    QDomElement output(QDomDocument& document);
    static void putByte(void* sinkData, byte bt);


protected:
    void putByte(byte bt);
    QString writeOutput();


private:
    TidyDoc     m_tidyDoc;
    TidyBuffer  m_errorOutput;
    QByteArray  m_output;
    QString     m_input;
};

#endif
